          SUBROUTINE TRANSF
C---------------------------------------------------------
#include "viewer.h"
#include "viewer.h2"

C---------------------------------------------------------
          DIMENSION AT1(4,4),ATR(4,4),VE(3)
          DIMENSION ALF(3),BXYZ(3),CXYZ(4),DXYZ(3),SXYZ(3)

C SCALE FACTORS FOR PHOTOMONTAGE FOR EACH OUTPUT DEVICE
C TO CONVERT FROM MM (FOCAL LENGTH)
C TEK(IOUTD=1) 1022 TEKPOINTS / 175.5 MM HARD COPY
C CALCOMP 1051(IOUTD=2)  1 CM./20 MM
C LOCAL TEK PLOTTER(IOUTD=3) SAME AS TEK
C PLOT FILE (IOUTD=4) SAME AS TEK

C---------------------------------------------------------
  9   DO 10 I=1,3

C DISTANCE EYE TO FOCUS
           DXYZ(I)=DDDD(I)-CCCC(I)

C IF DIST ZERO, SHIFT SLIGHTLY TO AVOID PROJECTION REVERSAL
           IF (ABS(DXYZ(I)) .LT. 0.01) DXYZ(I)=0.01

C DIST TO SHIFT FOCUS TO NEW ORIGIN
  10       CXYZ(I)=-CCCC(I)

      PI = 3.1415926

C---------------------------------------------------------
C DO TRANSFORMS FOR CURRENT EYE POSITION,ETC.

C TRANSLATE AXES(MOVR ORIGIN TO FOCUS POINT)
      CALL TRASL(CXYZ,3,AT1)

C ROTATE AXES IN XY AND XXZ
C SET ROTATION ORIGIN AND ANGLES ZERO
        DO 11 I=1,3
            CXYZ(I)=0.
  11        ALF(I)=0.

C HORIZONTAL AND DIAGONAL DISTANCES
        DISTA=SQRT(DXYZ(1)**2+DXYZ(2)**2)
        DISTD=SQRT(DXYZ(2)**2+DXYZ(3)**2+DXYZ(1)**2)
C REDO
C If view point is almost above, do not rotate in XY plane
        IF (DISTA.GT..01*DISTD) THEN
C Avoid possibility of division by zero
C TEST FOR SMALL ANGLES
 111         IF (ABS(DXYZ(2)).GT. 0.005)
     &            ALF(3)=1.570796-ATAN2(DXYZ(1),DXYZ(2))
             IF (ABS(ALF(3)).LT. 0.01) GO TO 12
        ELSE
             ALF(3)=-1.570796
        ENDIF
 
C ROTATE AXES IN XY PLANE
 112    CALL ROT(CXYZ,ALF,3,ATR)
        CALL PROMAT(4,AT1,ATR,AT1)
        ALF(3)=0.
 
C DONT ROTATE IN XZ PLANE IF PARALLEL PROJ (IPROJ =3 OR 4)
  12  IF (IPROJ.GE.3)GO TO 13
 
C ROTATE AXES IN NEW XZ PLANE
      IF (ABS(DXYZ(3)) .GT. 0.005)ALF(2)=ATAN2(DISTA,DXYZ(3))-1.570796
      IF (ABS(ALF(2)) .LT. 0.01) GO TO 13
 
      CALL ROT(CXYZ,ALF,3,ATR)
      CALL PROMAT(4,AT1,ATR,AT1)
 
C---------------------------------------------------------
C CALCULATE SCALE FACTORS

C NEW SCALING
C WE NOW SCALE THE PICTURE SO THAT THE PCTURE X-BOUNDS
C ARE AT -1000,+1000: THE Y BOUNDS SIMILARLY PROPORTIONED.
C THIS 'ABSOLUTELY' SCALED PICTURE OF THE PROJECTED BODIES
C IS USED FOR THE HIDDEN LINE CALCS(IN PERS1,AND HLR)
C THUS AVOIDING SOME OF THE PROBLEMS IN THAT AREA
C TO DO WITH ACCURACY,COINCIDENCE OF POINTS OR LINES
C ,SHIFTING OF POINTS,AND DIFFERENCES FO SCREEN OR PLOTTER OUTPUT
C (PREVIOUS VERSIONS SCALED TO THE PHYSICAL PLOT SIZE:
C I.E. 512 FOR TEK, AND 30CM FOR E.G. A3 PLOT)
C AT PLOT TIME(IN PLOTTR) WE RESCALE THE OUTPUT POINTS TO
C THE PHYSICAL PLOT SIZE
 
C SCALE PICTURE TO +-1000 IN X
C(THE PHYSICAL PLOTSIZE IS BILDX,BILDY)
  13  BX=1000.
      BY=1000.*BILDY/BILDX
C SCALE IMAGE SPACE
C DEPENDING ON ANGLE OF VISION SET,ETC.
      IF (SYNVKL)41,43,42
 
  41  CONTINUE
C NO VIEWCONE SET:NEED NO SCALE,DONE LATER
      SCAL=1.0
      GO TO 45
 
C VIEW ANGLE SET
  42    ANGV=.0087266*ABS(SYNVKL)
      SCAL=BX/(DISTD*SIN(ANGV)/COS(ANGV))
      GO TO 45
 
C VIEW ANGLE =0 IS PHOTOMONTAGE MODE
C SCALE FACTOR FOR PHOTOMONTAGE DEPENDS ON PLOTSIZE
C AND OUTPUT DEVICE
  43  GO TO (51,52,53,54),IOUTD
 
C SCALE FACTOR IS 1000/1/2 PICTURSIZE INMM
C TEK 175.5 MM
  51  SFAC=2000./175.5
      GO TO 55
 
C CALCOMP BILDX(CM)
  52  SFAC=100./BILDX
      GO TO 55
 
C LOCAL TEK PLOTTER AS TEK
C SCALE TO USERSET PICTURE SIZE (BILDX MM)
  53  SFAC=2000./BILDX
C AND CONVERT VIEWPORT BACK TO TEKPOINTS FOR SCREEN DISPLAY
      BILDX=511.
      GO TO 55
 
C OUTPUT FILE LEAVE AS 1000.
  54  SFAC =1.
 
C---------------------------------------------------------
  55  SCAL=FL*EF*SFAC/DISTD
 
C SET SCALES, LEAVE X UNSCALED
  45  SXYZ(1)=1.0
      SXYZ(2)=SCAL
      SXYZ(3)=SCAL
C CALL FATT WITH VECTOR SCALE
      CALL FATT(CXYZ,SXYZ,3,ATR)
      CALL PROMAT(4,AT1,ATR,AT1)
C---------------------------------------------------------
C NOW DO PROJECTION
      GO TO (21,22,25,26),IPROJ
 
C DONR SCALE X PROJECTION POINT SINCE QV X-DEPTH NOT SCALED
  21  CXYZ(1)=DISTD
      CALL PROPA(CXYZ,3,ATR,1)
      GO TO 23
 
C DONT SCALE X-DEPTH
  22  CXYZ(1)=DISTD
      CALL PROSP(CXYZ,3,ATR)
      GO TO 23
 
  25  CXYZ(1)=DISTA
      CXYZ(3)=DXYZ(3)*SCAL
      CALL PROPA(CXYZ,3,ATR,2)
      GO TO 23
 
  26  CXYZ(1)=DISTA
      CXYZ(3)=DXYZ(3)*SCAL
      CALL PROPA(CXYZ,3,ATR,1)
 
  23  CALL PROMAT(4,AT1,ATR,AT1)
 
C---------------------------------------------------------
C TRANSFORM SCENE MIDPOINT (IF MP=FP THIS GOES TO ORIGIN)
      CALL PROVM(BBBB,AT1,BXYZ,3)
 
C---------------------------------------------------------
C ADJUST Z-VALUES FOR CURVATURE & REFRACTION
C ONLY SIGNIFICANT FOR DISTANCES OF KM'S FROM EYE
C (UNITS ARE ASSUMED TO BE METRES)
      CALL CURV
 
C---------------------------------------------------------
C NOW FIND PROJECTED POINTS
 
C GET DISTANCE EYE TO FOCUS
      DISTE=DISTD
  30  DO 320 J=1,NP
           DO 31 I=1,3
  31           VE(I)=PUNT(J,I)
C PROJECT X-DEPTH AND SCREEN YZ
           CALL PROVM(VE,AT1,VE,3)
           DO 32 I=1,3
C MOVE SCREEN CENTRE TO PICTURE MIDPOINT
               PUPRVI(J,I)=VE(I)-BXYZ(I)
  32       CONTINUE
 320  CONTINUE
 
C IF PERSP SET,CHECK FOR BEHIND EYE POINTS,AND SHIFT THEM
        IF (IPROJ.NE.2)GO TO 33
 
C GET DISTANCE EYE TO FOCUS POINT
        DISTE=CXYZ(1)
        CALL BEYE(DISTE)
 
C---------------------------------------------------------
C WE HAVE FINISHED UNLESS NO VIEW CONE ANGLE SET
  33    IF (SYNVKL.GE.0.)GOTO 9901
 
C SCALE FOR NO VIEWANGLE SET
C TO JUST FILL SCREEN
      SCLY=0.
      SCLZ=0.
      DO 35 J=1,NP
          SCLY=AMAX1(SCLY,ABS(PUPRVI(J,2)))
          SCLZ=AMAX1(SCLZ,ABS(PUPRVI(J,3)))
  35  CONTINUE

C SCALE TO +-1000 IN X
C SCALE TO 95% OF SCREEN
      SCAL=.95*AMIN1(BILDX/SCLY,BILDY/SCLZ)
      SCAL=BX*SCAL/BILDX
        DO 91 I=1,NP
        DO 91 J=1,3
  91         PUPRVI(I,J)=PUPRVI(I,J)*SCAL
 9901   CONTINUE
 
C---------------------------------------------------------
C FIND BODY BOUNDBOXES
      BIG=1.0E6
      DO 95 I=1,NB
C FIRST AND LAST POINTS OF BODY I
           IP1=IBP1(I)
           IP2=IBP2(I)
           BBXMN(I)=BIG
           BBXMX(I)=-BIG
           BBYMN(I)=BIG
           BBYMX(I)=-BIG
           BBZMN(I)=BIG
           BBZMX(I)=-BIG
 
C DO EACH EDGE OF BODY I
           DO 90 J=IP1,IP2
C FIND MAX AAND MIN SCREEN (Y,Z) AND DEPTH (X)
                IF (PUPRVI(J,1).LT.BBXMN(I))BBXMN(I)=PUPRVI(J,1)
                IF (PUPRVI(J,1).GT.BBXMX(I))BBXMX(I)=PUPRVI(J,1)
                IF (PUPRVI(J,2).LT.BBYMN(I))BBYMN(I)=PUPRVI(J,2)
                IF (PUPRVI(J,2).GT.BBYMX(I))BBYMX(I)=PUPRVI(J,2)
                IF (PUPRVI(J,3).LT.BBZMN(I))BBZMN(I)=PUPRVI(J,3)
                IF (PUPRVI(J,3).GT.BBZMX(I))BBZMX(I)=PUPRVI(J,3)
  90       CONTINUE
  95   CONTINUE
 
C---------------------------------------------------------
C PICTUR NOW SCALED TO +-1000 IN X AT BOUNDARIES
C REAL SCALE FOR SCREEN COORDS IS SAVED AS
      SCFXY=BILDX/BX
C THIS IS APPLIED AT PLOT-TIME(IN PLOTTR)
C BEFORE CLIPPING TO PRODUCE THE SCREEN/PLOT PICTURE
 
C---------------------------------------------------------
C***DIAG
C***D        WRITE(20,9904)BILDX,BILDY,BX,BY,SCFXY
C***D9904   FORMAT(' BILDX,Y:',2F10.2,' BX,Y:',2F10.2,' SCFXY:',F10.4)
C***D        DO 9902 I=1,NP
C***D9902   WRITE(20,9903)I,(PUPRVI(I,J),J=1,3)
C***D9903   FORMAT(' VERTEX',I4,' TRANSFORMED TO ',3G16.8)
C***
 
C---------------------------------------------------------
          RETURN
          END

C ******** CURV
      SUBROUTINE CURV

#include "viewer.h"
#include "viewer.h2"

C CORRECT ELEVATION CONSTANT DATA FOR CURVATURE OF EARTH AND REFRACTION OF L
C CALCULATE CONSTANT FOR CURVATURE OF AND REFRACTION
      REFRA=0.075

C CORRECT DIAM OF EARTH (IN METRES).
      DIA=12739567.1
      CONST=(1.0-2.0*REFRA)/DIA
      DO 410 J=1,NP
      X=PUNT(J,1)-DDDD(1)
      Y=PUNT(J,2)-DDDD(2)
      PUNT(J,3)=POZ(J)-(X*X+Y*Y)*CONST
  410 CONTINUE
  999 RETURN
      END

