C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file contains the following routines:
C  MOSTAT High level control of statistical analysis.
C  MOSMSD Generic menu & get routines to retrieve basic statistical data. 
C  MOSMSDCEN As MOSMSD with comparison to CEN standard.
C  MOSQHR Find number of hours above or below a given value. 
C  MOEDMDS Energy demands integrated over the assessment period. 
C  CASDIST Reports casual gains distributions.

C ******************** MOSTAT ********************
C High level control of statistical analysis of the simulation
C results.

      SUBROUTINE MOSTAT
#include "building.h"
#include "geometry.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS
      COMMON/OUTPCH/ICOUT
      COMMON/DEFLT/IDEFLT

      COMMON/GETPIK/NGET,IGETNO(MZS,9)

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      common/getmenu/menutype,igetind(65),igetflux(65)

      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      common/recver/izver,ipver,iever
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV
      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME
      COMMON/GET2/XDUM(MTS),XDUM1(MTS),GVAL(MTS)
      common/exporttg/xfile,tg,delim
      COMMON/EXPORTI/ixopen,ixunit,ixpunit
      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)
      COMMON/SIMPKA/NSIM
      COMMON/ZONPIK/NZ,NZNO(MCOM)
      common/zcondhr/izctime(MCON)

C Markdown flag.
      logical markdown
      common/markdownflag/markdown
      COMMON/GRTOOL/IHFLAG,IDHFLG,ilflag

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext
      common/recov03/recovery_active
      logical recovery_active

C High level control scope key words.
      character hcffpattern*12    ! heat, cool, or heat+cool plus detail
      common/hlcontrol/hcffpattern(2)     

C User preferences for Monthly table.
      integer imshtr,imtcas,imtaiv,imtctl,imtsol,imunit      ! monthly topic inclusion
      common/monthlyoptions/imshtr,imtcas,imtaiv,imtctl,imtsol,imunit

C SNAPSH is a logical flag to request variation in header.
      COMMON/SNAP/SNAPSH
      logical SNAPSH,close
      DIMENSION ATI(8),RTI(8),TATI(8),TRTI(8),NDYMTH(12)
      dimension ITEM(26),ITEMONTH(7)
      character ITEM*23,ITEMONTH*32
      character tg*1,delim*1,xfile*144
      character PDESCR*64,SDESCR*44
      character prompt*124,outs*124
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      character RSNAME*40
      CHARACTER*3 NMTHNM(12)
      integer IWM,ihd  ! for radio buttons
      integer NITMS,INO ! max items and current menu item

      helpinsub='stats'  ! set for subroutine

      DATA NDYMTH/31,59,90,120,151,181,212,243,273,304,334,365/
      DATA NMTHNM/'Jan','Feb','Mar','Apr','May','Jun','Jul',
     &'Aug','Sep','Oct','Nov','Dec'/

C Clear initial values.
      JIOD1=1; JIOM1=1; JIOH1=1; JIOD2=1; JIOM2=1; JIOH2=1
      JIODS=1; JIODF=1

C Setup for menu.
 1    ITEM(1) ='2 select result set   '
      ITEM(2) ='3 define output period'
      ITEM(3) ='4 select zones        '
      ITEM(4) ='  ------------------- '
      ITEM(5) ='a summary statistics  '
      ITEM(6) ='b frequency table     '
      ITEM(7) ='  ------------------- '
      ITEM(8) ='c hours above a value '
      ITEM(9) ='d hours below a value '
      ITEM(10)='  ------------------- '

C If implementing checking against CEN statistics then remove item 10 from 
C list of illegal choices.
C      ITEM(10)='e CEN statistics     '
      ITEM(11)='f energy delivered    '
      ITEM(12)='g casual gains distrib'
      ITEM(13)='h zone energy balance '
      ITEM(14)='i surface energy balnc'
      ITEM(15)='j surface condensation'
      ITEM(16)='k intrstl condensation'
      ITEM(17)='  ------------------- '
      ITEM(18)='l monthy gains/losses '
      ITEM(19)='m monthy temp. stats '
      ITEM(20)='  ------------------- '
      if(ixopen.eq.1)then
        ITEM(21)='> output >> file    '
      elseif(ixopen.eq.0)then
        ITEM(21)='> output >> screen  '
      endif
      if(markdown)then
       ITEM(22)=': output >> Markdown '
      else
       ITEM(22)=': output >> ASCII    '
      endif
      if(delim.eq.'-')then
        ITEM(23)='^ delim >> normal      '
      elseif(delim.eq.'T')then
        ITEM(23)='^ delim >> tab         '
      elseif(delim.eq.'C')then
        ITEM(23)='^ delim >> comma       '
      elseif(delim.eq.'S')then
        ITEM(23)='^ delim >> space       '
      elseif(delim.eq.'X')then
        ITEM(23)='^ delim >> tagged      '
      endif
      if(ILFLAG.eq.0)then
        ITEM(24)='& labels >> multiline  '
      elseif(ILFLAG.eq.1)then
        ITEM(24)='& labels >> on one line'
      elseif(ILFLAG.eq.2)then
        ITEM(24)='& labels >> one ln no #'
      endif
       ITEM(25)='? help               '
      ITEM(26)='- exit               '

 2    NITMS=26
      if(MMOD.eq.8)then
        INO=-1
      else
        INO=-2
      endif

C Instantiate help strings for the menu.
      helptopic='res_statistics_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU('Enquire about',ITEM,NITMS,INO)

      IF(INO.EQ.1)then
        CALL MORESS
        IDEFLT=0
      elseif(INO.EQ.2)then
        CALL MOOPER
      elseif(INO.EQ.3)then
        CALL MOZDFN
      elseif(INO.EQ.5)then

C Summary statistics.
        CALL MOSMSD('-',VMX,VMN,VAVE,VTOT,DIVMX,DIVMN,DISTMX,DISTMN)

      elseif(INO.EQ.6) then

C Frequency histogram table.
        ivvv=0
        CALL MODGRF('t',ivvv)

      elseif(INO.EQ.8) then

C Hours above given value.
        CALL MOSQHR('-',1,0.0)

      elseif(INO.EQ.9) then

C Hours below given value.
        CALL MOSQHR('-',-1,0.0)

      elseif(INO.EQ.10)then

C Comparison to CEN statistics (if implemented)
        CALL EASKI(IANS,' ',' Password: ',
     &           0,'-',0,'-',0,'Password',IER,0)
        IF(IANS.NE.101)GOTO 2

C Call the menu of choices (this also sets some default options).
C The logical variable totals controls the displaying of cumulative 
C data for all the zones chosen.
        NGET=9
        do 11 I=1,9
          IGETNO(I,1)=6
          IGETNO(I,2)=I
          IGETNO(I,3)=0
          IGETNO(I,4)=0
          IGETNO(I,5)=ISIM
          SLABEL(I)='Resultant temperature (C)'
          LNSLABEL(I)=25
 11     continue
        CALL MOSMSDCEN('s')

      elseif(INO.EQ.11)then

        call MOEDMDS('-',the,tzhtime,tce,tzctime,tlhe,tzlhtime,
     &    tlce,tzlctime)

      elseif(INO.EQ.12)then

        call CASDIST('-')

      elseif(INO.EQ.13)then

C Setup for zone balance. Confirm if snapshot or integrated report.
C If output to file alter the edisp unit number.
        call EASKMBOX('Energy balance options: ',' ',
     &    'snapshot','integrated over time','cancel',
     &    ' ',' ',' ',' ',' ',isnapsh,nbhelp)
        if(isnapsh.eq.1)then
          SNAPSH=.TRUE.
          IMO=IOM1; IDO=IOD1
          TIME=IOH1
          CALL ASKRTIM(IFDAY,IMO,IDO,IDAY,TIME,IT,IER)
          JIOD1=IOD1; JIOM1=IOM1; JIOH1=IOH1
          JIOD2=IOD2; JIOM2=IOM2; JIOH2=IOH2
          JIODS=IODS; JIODF=IODF
          IODS=IDAY; IODF=IDAY
          IOH1=IT; IOH2=IT
        elseif(isnapsh.eq.2)then
          SNAPSH=.FALSE.
        elseif(isnapsh.eq.3)then
          goto 1
        endif

C Check what to focus on and if a snapshot display.
C Snapshot done via using the time requested
C to temporarily overwrite the IOH1 IOH2 and the
C standard energy balance.  After finished then reset
C the period to previous settings.
        helptopic='res_air_point_forms'
        call gethelptext(helpinsub,helptopic,nbhelp)
        call EASKMBOX('Zone energy balance: ','(grouped by)',
     &    'plant status','gain/loss','cancel',
     &    ' ',' ',' ',' ',' ',IWHICH,nbhelp)
        if(IWHICH.eq.3)goto 1

        itru = icout
        prompt = ' '
        if(ixopen.eq.1)then
          itru = ixunit
        endif

C Call the menu of choices (this also sets some default options).
        MENUTYPE=9
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif

          if(recovery_active)then
            continue
          else
            call usrmsg(prompt,'Scanning for range of values...','-')
          endif
        else
          write(prompt,'(3a)') 'Scanning for ',
     &      SLABEL(1)(1:LNSLABEL(1)),'...'
          itru = icout
          call usrmsg(prompt,'  ','-')
        endif

        ISET=ISIM
        CALL HDDATE(PDESCR)
        CALL HDSTEP(SDESCR)
        lsn1=MIN0(lnblnk(RFILE),42)
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
          write(outs,'(3A,I4,3A)')'Results library: ',
     &      RFILE(1:lsn1),'; results set:',ISIM,
     &      ' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          else
            write(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &      '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          endif
          call edisp(itru,outs)
          write(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &     SDESCR(12:lnblnk(SDESCR))
          call edisp(itru,outs)
        endif

C For each selected zone generate energy balance report.
        DO 65 JZ=1,NZ
          izone=NZNO(JZ)
          if(ISAVE.EQ.4)then
            CALL MOZCAS(IZONE,IWHICH,NIT)
          elseif(ISAVE.eq.2.or.ISAVE.eq.3)then
            if(izver.ge.2)then
              CALL MOZCAS(izone,IWHICH,NIT)
            else
              call usrmsg(
     &          'The results library is an older format and a full',
     &          'zone energy balance cannot be recovered.','W')
              CALL MOZCAS(izone,IWHICH,NIT)
            endif
          endif
 65     continue
        if(SNAPSH)then
          call usrmsg(' switching from snapshot to integration...',
     &        ' ','P')
          call usrmsg(' ',' ','-')
          SNAPSH=.FALSE.
          IOD1=JIOD1; IOM1=JIOM1; IOH1=JIOH1
          IOD2=JIOD2; IOM2=JIOM2; IOH2=JIOH2
          IODS=JIODS; IODF=JIODF
        endif
        if(ixopen.eq.1)then
          continue
        else
          call usrmsg('  ','  ','-')
        endif

      elseif(INO.EQ.14)then

C Surface energy balance. Confirm if snapshot or integrated report.
C If output to file alter the edisp unit number.
        if(ISAVE.ne.4)then
          call usrmsg(' The simulation save option does not',
     &                ' allow surface energy balances.','W')
          goto 1
        endif
        helptopic='res_surf_point_forms'
        call gethelptext(helpinsub,helptopic,nbhelp)
        call EASKMBOX('Energy balance options: ',' ',
     &    'snapshot','integrated over time','cancel',
     &    ' ',' ',' ',' ',' ',isnapsh,nbhelp)
        if(isnapsh.eq.1)then
          SNAPSH=.TRUE.
          IMO=IOM1
          IDO=IOD1
          TIME=IOH1
          CALL ASKRTIM(IFDAY,IMO,IDO,IDAY,TIME,IT,IER)
          JIOD1=IOD1; JIOM1=IOM1; JIOH1=IOH1
          JIOD2=IOD2; JIOM2=IOM2; JIOH2=IOH2
          JIODS=IODS; JIODF=IODF
          IODS=IDAY; IODF=IDAY
          IOH1=IT; IOH2=IT
        elseif(isnapsh.eq.2)then
          SNAPSH=.FALSE.
        elseif(isnapsh.eq.3)then
          goto 1
        endif

        helptopic='res_surf_point_forms'
        call gethelptext(helpinsub,helptopic,nbhelp)
        call EASKMBOX('Surface energy balance: ','(grouped by)',
     &    'plant status','gain/ loss','cancel',
     &    ' ',' ',' ',' ',' ',IWHICH,nbhelp)
        if(IWHICH.eq.3)goto 1
        IWHICH=IWHICH+3
        itru = icout
        prompt = ' '
        if(ixopen.eq.1)then
          itru = ixunit
        endif

C Call the menu of choices (this also sets some default options).
        MENUTYPE=12
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif

          if(recovery_active)then
            continue
          else
            call usrmsg(prompt,'Scanning for range of values...','-')
          endif
        else
          write(prompt,'(3a)') 'Scanning for ',
     &      SLABEL(1)(1:LNSLABEL(1)),'...'
          itru = icout
          call usrmsg(prompt,'  ','-')
        endif

C If the heading has not already been written do so.
        ISET=ISIM
        CALL HDDATE(PDESCR)
        CALL HDSTEP(SDESCR)
        lsn1=MIN0(lnblnk(RFILE),42)
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
          write(outs,'(3A,I4,3A)')'Results library: ',
     &      RFILE(1:lsn1),'; results set:',ISIM,
     &      ' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          else
            write(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &      '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          endif
          call edisp(itru,outs)
          write(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &     SDESCR(12:lnblnk(SDESCR))
          call edisp(itru,outs)
        endif

C For each selected zone and surface generate energy balance report.
        DO 165 KGET=1,NGET
          izone=IGETNO(KGET,2)
          isfn =IGETNO(KGET,3)
          CALL MOSCAS(izone,isfn,IWHICH)
 165    continue
        if(SNAPSH)then
          call usrmsg(' switching from snapshot to integration...',
     &        ' ','P')
          call usrmsg(' ',' ','-')
          SNAPSH=.FALSE.
          IOD1=JIOD1; IOM1=JIOM1; IOH1=JIOH1
          IOD2=JIOD2; IOM2=JIOM2; IOH2=JIOH2
          IODS=JIODS; IODF=JIODF
        endif
        if(ixopen.eq.1)then
          continue
        else
          call usrmsg('  ','  ','-')
        endif

      elseif(INO.EQ.15)then

C Surface condensation. Setup GOGET variables and advise user while
C scanning data. Call MOSURC for each selected zone in turn.
        itru = icout
        prompt = ' '
        if(ixopen.eq.1)then
          itru = ixunit
        endif
        MENUTYPE=14
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif
        else
          write(prompt,'(3a)') 'Scanning for ',
     &      SLABEL(1)(1:LNSLABEL(1)),'...'
          itru = icout
          call usrmsg(prompt,'  ','-')
        endif
        ISET=ISIM
        CALL HDDATE(PDESCR)
        CALL HDSTEP(SDESCR)
        lsn1=MIN0(lnblnk(RFILE),42)
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
          write(outs,'(3A,I4,3A)')'Results library: ',
     &      RFILE(1:lsn1),'; results set:',ISIM,
     &      ' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          else
            write(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &      '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          endif
          call edisp(itru,outs)
          write(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &     SDESCR(12:lnblnk(SDESCR))
          call edisp(itru,outs)
        endif

C For each selected zone and surface condensation report.
        write(outs,'(2a)')
     &  ' Total occurances = timesteps with condensation',
     &  ' on at least one surface.'
        call edisp(itru,outs)
        DO 166 KGET=1,NGET
          izone=IGETNO(KGET,2)
          izrh =IGETNO(KGET,3)
          iverb =IGETNO(KGET,4)
          izctime(izone)=0
          CALL MOSURC(izone,izrh,iverb)
 166    continue
        if(ixopen.eq.1)then
          continue
        else
          call usrmsg('  ','  ','-')
        endif

      elseif(INO.EQ.16)then

C Interstitial condensation.
        if(ISAVE.eq.3)then
          CALL ASKZON(ICOMP,23)
          CALL FINDCND(ICOMP)
        else
          call usrmsg(' The simulation save option does not allow',
     &                ' intersitital condensation checks.','W')
          goto 1
        endif

      elseif(INO.EQ.18)then

C Monthly zone gains and losses report. Default columns take into
C account hcffpattern:
        imshtr=1; imtcas=1; imtaiv=1; imtctl=1; imtsol=1; imunit=1
        if(hcffpattern(1)(1:8).eq.'HEATONLY')then
          imtctl=2
        elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
          imtctl=3
        elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &         hcffpattern(1)(1:7).eq.'UNKNOWN')then
          imtctl=1
        endif
 111    if(imshtr.eq.1)then
          ITEMONTH(1)='a heat transfer > all surfaces'
        elseif(imshtr.eq.2)then
          ITEMONTH(1)='a heat transfer > facade only '
        endif
        if(imtcas.eq.1)then
          ITEMONTH(2)='b casual gains > separate types'
        elseif(imtcas.eq.2)then
          ITEMONTH(2)='b casual gains > aggregate'
        endif
        if(imtaiv.eq.1)then
          ITEMONTH(3)='c air movement > infil & vent'
        elseif(imtaiv.eq.2)then
          ITEMONTH(3)='c air movement > infiltration'
        elseif(imtaiv.eq.3)then
          ITEMONTH(3)='c air movement > ventilation'
        endif
        if(imtctl.eq.1)then
          ITEMONTH(4)='d controls > heating & cooling'
        elseif(imtctl.eq.2)then
          ITEMONTH(4)='d controls > heating '
        elseif(imtctl.eq.3)then
          ITEMONTH(4)='d controls > cooling '
        endif
        if(imtsol.eq.1)then
          ITEMONTH(5)='e solar > absorbed & entering'
        elseif(imtsol.eq.2)then
          ITEMONTH(5)='e solar > absorbed'
        elseif(imtsol.eq.3)then
          ITEMONTH(5)='e solar > entering'
        endif
        ITEMONTH(6)='? help'
        ITEMONTH(7)='- proceed'
        NMITMS=7
C        if(MMOD.eq.8)then
C          INO=-1
C        else
C          INO=-2
C        endif
        INOM=-4

C Instantiate help strings for the menu.
        helptopic='res_monthly_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)

        CALL EMENU('Monthly column options',ITEMONTH,NMITMS,INOM)
        if(inom.eq.1)then
          imshtr=imshtr+1
          if(imshtr.gt.2) imshtr=1
          goto 111
        elseif(inom.eq.2)then
          imtcas=imtcas+1
          if(imtcas.gt.2)imtcas=1
          goto 111
        elseif(inom.eq.3)then
          imtaiv=imtaiv+1
          if(imtaiv.gt.3) imtaiv=1
          goto 111
        elseif(inom.eq.4)then
          imtctl=imtctl+1
          if(imtctl.gt.3) imtctl=1
          goto 111
        elseif(inom.eq.5)then
          imtsol=imtsol+1
          if(imtsol.gt.3) imtsol=1
          goto 111
        elseif(inom.eq.6)then
          CALL PHELPD('Monthly options',nbhelp,'-',0,0,IER)
          goto 111
        elseif(inom.eq.7)then
          continue
        else
          goto 111
        endif
        CALL MGLTBL

      elseif(INO.EQ.19)then

C Monthly db temperature and resultant temperature stats.
        itru = icout
        prompt = ' '
        if(ixopen.eq.1)then
          itru = ixunit
        endif
        if(markdown)then
          call edisp(itru,'  ')
          call edisp(itru,
     &    '## Monthly zone temperature stats')
          call edisp(itru,
     &    ': Monthly zone temperature stats.')
          call edisp(itru,'  ')
          write(outs,'(2a)')
     &    '------------- -----  ------- ------- ------- ------- ',
     &    '------- ------- --------- ------- --------- ---------' 
          call edisp(itru,outs)
          write(outs,'(2a)')
     &    ' Zone         Month  db T    dbT Max db T    dbT Min ',
     &    'db T    Result  Res T Max Result  Res T Min Resultant'
          call edisp(itru,outs)
          write(outs,'(2a)')
     &    '                     Max.    day:hr  Min.    day:hr  ',
     &    'Mean    T Max.  day:hr    T Min.  day:hr     Mean'
          call edisp(itru,outs)
        else
          call edisp(itru,
     &    ' Monthly zone temperature stats.')
          if(ILFLAG.eq.0)then
            write(outs,'(a,8x,a,8x,a)')' Zone',
     &      'Internal air temperature','Internal resultant temp.'
            call edisp(itru,outs)
            write(outs,'(4x,2a)') 
     &      'Period  Max.   at   Min.   at   Mean ',
     &      ' Max.   at   Min.   at   Mean'
            call edisp(itru,outs)
            call edisp(itru,' ')
          else
            write(outs,'(2a)')
     &        'Zone Period dbT-max DOM:hour dbT-min DOM:hour ',
     &        'dbT-mean ResT-max DOM:hour ResT-min DOM:hour ResT-mean'
            call eddisp(itru,outs)
          endif
        endif

C Per zone for each day in period.
        DO 860 I=1,NZ
          IZN=NZNO(I); IMNTH=IOM1; ATI(8)=0.0; INITL=0; ISET=ISIM

C Get statistics for the day.
          DO 850 J=IODS,IODF
            JD=J
            CALL CHKTIME(JD,ISTART,IEND)

C Get zone db temp into GVAL.
            CALL GZAIRT(JD,IZN,ISET)

C Get zone resultant temp into XDUM1.
            CALL CZRESL(JD,IZN,ISET)

            DO 830 K=ISTART,IEND
              KT=K
              call eclose(ATI(8),0.0,0.001,close)
              IF(close)goto 828
              IF(GVAL(KT).LE.ATI(1))GOTO 821
              ATI(1)=GVAL(KT); ATI(2)=JD; ATI(3)=KT
              goto 822
  821         IF(GVAL(KT).GE.ATI(4))GOTO 822
              ATI(4)=GVAL(KT)
              ATI(5)=JD
              ATI(6)=KT
  822         ATI(7)=ATI(7)+GVAL(KT)
              ATI(8)=ATI(8)+1.0
              IF(XDUM1(KT).LE.RTI(1))GOTO 826
              RTI(1)=XDUM1(KT); RTI(2)=JD; RTI(3)=KT
              goto 827
  826         IF(XDUM1(KT).GE.RTI(4))GOTO 827
              RTI(4)=XDUM1(KT); RTI(5)=JD; RTI(6)=KT
  827         RTI(7)=RTI(7)+XDUM1(KT)
              RTI(8)=RTI(8)+1.0
             goto  830
  828         RTI(1)=XDUM1(KT) 
              RTI(2)=JD; RTI(3)=KT
              RTI(4)=XDUM1(KT); RTI(5)=JD; RTI(6)=KT
              RTI(7)=XDUM1(KT); RTI(8)=1.0 
              ATI(1)=GVAL(KT); ATI(2)=JD; ATI(3)=KT
              ATI(4)=GVAL(KT); ATI(5)=JD; ATI(6)=KT
              ATI(7)=GVAL(KT); ATI(8)=1.0
  830       CONTINUE

C Check if month finished.
            IF(JD.LT.NDYMTH(IMNTH).AND.JD.NE.IODF)goto 850

C Dump this month's statistics.
            ND1=INT(ATI(2))
            IF (IMNTH.NE.1) ND1=ND1-NDYMTH(IMNTH-1)
            NT1=INT(ATI(3))/NTS
            ND2=INT(ATI(5))
            IF (IMNTH.NE.1) ND2=ND2-NDYMTH(IMNTH-1)
            NT2=INT(ATI(6))/NTS
            ATI7=ATI(7)/ATI(8)
            ND3=INT(RTI(2))
            IF (IMNTH.NE.1) ND3=ND3-NDYMTH(IMNTH-1)
            NT3=INT(RTI(3))/NTS
            ND4=INT(RTI(5))
            IF (IMNTH.NE.1) ND4=ND4-NDYMTH(IMNTH-1)
            NT4=INT(RTI(6))/NTS
            RTI7=RTI(7)/RTI(8)
            IF(IMNTH.EQ.IOM1)THEN
              if(markdown)then
                write(outs,'(4a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &            I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &            F11.2)') ' ',zname(IZN)(1:12),' ',NMTHNM(IMNTH),
     &            ATI(1),'  ',ND1,':',NT1,ATI(4),'  ',ND2,':',NT2,
     &            ATI7,RTI(1),'   ',ND3,':',NT3,RTI(4),'  ',
     &            ND4,':',NT4,RTI7
                call edisp(itru,outs)
              else
                if(ILFLAG.eq.0)then
                  WRITE(outs,904) zname(IZN)(1:12),' ',NMTHNM(IMNTH),
     &              ATI(1),ND1,NT1,ATI(4),ND2,NT2,ATI7,
     &              RTI(1),ND3,NT3,RTI(4),ND4,NT4,RTI7
  904             FORMAT(3a,2(2(F6.2,I3,':',I2),F6.2))
                  call eddisp(itru,outs)
                else
                  WRITE(outs,'(3a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &              I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &              F11.2)') zname(IZN)(1:12),' ',NMTHNM(IMNTH),
     &              ATI(1),' ',ND1,':',NT1,ATI(4),' ',ND2,':',NT2,
     &              ATI7,RTI(1),' ',ND3,':',NT3,RTI(4),' ',
     &              ND4,':',NT4,RTI7
                  call eddisp(itru,outs)
                endif
              endif
            ELSE
              if(markdown)then
                write(outs,'(14x,a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &            I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &            F11.2)') NMTHNM(IMNTH),
     &            ATI(1),'  ',ND1,':',NT1,ATI(4),'  ',ND2,':',NT2,
     &            ATI7,RTI(1),'   ',ND3,':',NT3,RTI(4),'  ',
     &            ND4,':',NT4,RTI7
                call edisp(itru,outs)
              else
                if(ILFLAG.eq.0)then
                  WRITE(outs,'(14x,a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &              I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &              F11.2)') NMTHNM(IMNTH),
     &              ATI(1),'  ',ND1,':',NT1,ATI(4),'  ',ND2,':',NT2,
     &              ATI7,RTI(1),'   ',ND3,':',NT3,RTI(4),'  ',
     &              ND4,':',NT4,RTI7
                  call eddisp(itru,outs)
                else
                  WRITE(outs,'(2a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &              I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &              F11.2)') '-- ',NMTHNM(IMNTH),
     &            ATI(1),' ',ND1,':',NT1,ATI(4),' ',ND2,':',NT2,
     &            ATI7,RTI(1),' ',ND3,':',NT3,RTI(4),' ',
     &            ND4,':',NT4,RTI7
                  call eddisp(itru,outs)
                endif
              endif
            ENDIF

            IF(INITL.GE.1)goto 841
            DO 840 IJK=1,8
              TATI(IJK)=ATI(IJK)
              TRTI(IJK)=RTI(IJK)
  840       CONTINUE
            goto 849
  841       IF(ATI(1).LE.TATI(1))goto 842
            TATI(1)=ATI(1); TATI(2)=ATI(2); TATI(3)=ATI(3)
            goto 843
  842       IF(ATI(4).GE.TATI(4))goto 843
            TATI(4)=ATI(4); TATI(5)=ATI(5)
            TATI(6)=ATI(6)
  843       TATI(7)=TATI(7)+ATI(7)
            TATI(8)=TATI(8)+ATI(8)
            IF(RTI(1).LE.TRTI(1))goto 844
            TRTI(1)=RTI(1); TRTI(2)=RTI(2); TRTI(3)=RTI(3)
            goto 845
  844       IF(RTI(4).GE.TRTI(4))goto 845
            TRTI(4)=RTI(4); TRTI(5)=RTI(5); TRTI(6)=RTI(6)
  845       TRTI(7)=TRTI(7)+RTI(7)
            TRTI(8)=TRTI(8)+RTI(8)
  849       ATI(8)=0.0
            RTI(8)=0.0
            IMNTH=IMNTH+1
            INITL=INITL+1
  850     CONTINUE

C Dump annual statistics.
          TATI7=TATI(7)/TATI(8)
          IYD=INT(TATI(2))
          CALL EDAYR(IYD,ND1,NM1)
          IYD=INT(TATI(5))
          CALL EDAYR(IYD,ND2,NM2)
          IYD=INT(TRTI(2))
          CALL EDAYR(IYD,ND3,NM3)
          IYD=INT(TRTI(5))
          CALL EDAYR(IYD,ND4,NM4)
          TRTI7=TRTI(7)/TRTI(8)
          if(markdown)then
            write(outs,'(14x,a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &        I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &        F11.2)') 'All',TATI(1),'  ',ND1,':',NM1,TATI(4),'  ',
     &        ND2,':',NM2,TATI7,TRTI(1),'   ',
     &        ND3,':',NM3,TRTI(4),'  ',ND4,':',NM4,TRTI7
            call edisp(itru,outs)
          else
            if(ILFLAG.eq.0)then
              write(outs,9015)TATI(1),ND1,NM1,TATI(4),ND2,NM2,TATI7,
     &          TRTI(1),ND3,NM3,TRTI(4),ND4,NM4,TRTI7
 9015         format(6X,'All',' ',2(2(F6.2,I3,':',I2),F6.2))
              call eddisp(itru,outs)
              call edisp(itru,' ')
            else
              write(outs,'(a,F10.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,
     &          I2.2,F9.2,F9.2,a,I2.2,a,I2.2,F9.2,a,I2.2,a,I2.2,
     &          F11.2)') '-- ,All ',
     &          TATI(1),' ',ND1,':',NM1,TATI(4),' ',
     &          ND2,':',NM2,TATI7,TRTI(1),' ',
     &          ND3,':',NM3,TRTI(4),' ',ND4,':',NM4,TRTI7
              call eddisp(itru,outs)
              call edisp(itru,' ')
            endif
          endif
  860   CONTINUE
        if(markdown)then
          write(outs,'(2a)')
     &    '------------- -----  ------- ------- ------- ------- ',
     &    '------- ------- --------- ------- --------- ---------' 
          call edisp(itru,outs)
          call edisp(itru,' ')
        endif
      elseif(INO.EQ.(NITMS-5)) then

        call ctlexp(xfile,ixopen,ixunit,ixpunit,'X','Tabular',IER)

      elseif(INO.EQ.(NITMS-4)) then

C Toggle markdown mode.
        if(markdown)then
          markdown=.false.
        else

C Set markdown and if output is to a file reset heading logicals 
          markdown=.true.
          libheading=.false.; headingcontext=.false. ! reset heading logicals
        endif

      elseif(INO.EQ.(NITMS-3)) then

C Toggle delimeter.
        helptopic='res_stats_delimiter'
        call gethelptext(helpinsub,helptopic,nbhelp)
        IWM=1
        CALL EASKMBOX('Delimeter to use between columns of data:',' ',
     &    'normal spaces','single space','tab','comma','tagged',
     &    'continue',' ',' ',IWM,nbhelp)
        if(iwm.eq.1)then
          delim = '-'
        elseif(iwm.eq.2)then
          delim = 'S'
        elseif(iwm.eq.3)then
          delim = 'T'
        elseif(iwm.eq.4)then
          delim = 'C'
        elseif(iwm.eq.5)then
          delim = 'X'
        endif
      elseif(INO.EQ.(NITMS-2)) then

C Toggle single or multiple line headings.
        ILFLAG=ILFLAG+1
        if(ILFLAG.GT.2)ILFLAG=0
        if(ILFLAG.eq.0)then
          call edisp(iuout,' ')
          call edisp(iuout,'column labels on multi-lines ')
        elseif(ILFLAG.eq.1)then
          call edisp(iuout,' ')
          call edisp(iuout,'column labels on one line (spreadsheets)')
        elseif(ILFLAG.eq.2)then
          call edisp(iuout,' ')
          call edisp(iuout,
     &      'column labels on one line & no # header lines in files')
        endif
      elseif(INO.EQ.(NITMS-1)) then

C Display help messages. Menu help text.
        helptopic='res_help_choices'
        call gethelptext(helpinsub,helptopic,nbhelp)
        ihd=1
        call easkmbox(' ','Help options:','overview','summary stats',
     &   'frequency table','energy balances','detailed stats',
     &   'monthly gain loss','cancel',' ',ihd,nbhelp)
        if(ihd.eq.1)then
          helptopic='res_statistics_menu'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Enquire about',nbhelp,'-',0,0,IER)
        elseif(ihd.eq.2)then
          helptopic='res_help_sum_stats'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Enquire summary stats',nbhelp,'-',0,0,IER)

        elseif(ihd.eq.3)then
          helptopic='res_help_freq_table'
          call gethelptext(helpinsub,helptopic,nbhelp)
         CALL PHELPD('Enquire frequency',nbhelp,'-',0,0,IER)

        elseif(ihd.eq.4)then
          helptopic='res_help_zone_bal'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Enquire energy bal',nbhelp,'-',0,0,IER)

        elseif(ihd.eq.5)then

          helptopic='res_help_specific_topic'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Enquire detailed',nbhelp,'-',0,0,IER)

        elseif(ihd.eq.6)then

          helptopic='res_help_monthly_gl'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Enquire montly',nbhelp,'-',0,0,IER)
        elseif(ihd.eq.7)then
          continue
        endif

      elseif(INO.EQ.NITMS) then
        RETURN
      else
        goto 2
      endif
      goto 1
      END

C ******************** MOSMSD ********************
C Uses the generic menu and get routines to retrieve max, min and
C other basic statistical data. 
C Returns the following on the command line (used for IPV reporting).
C VMX,VMN,VAVE The max, min and average value for the selected metric for 
C   all active zones (as defined in IGETNO).
C DIVMX,DIVMN The diversified maximum and minimum values.
C DISTMX,DISTMN The distributed maximum and minimum values.
C act='i' called from ipv: sets bin width uses current IGETS
C act='p' iget parameters already set.

      SUBROUTINE MOSMSD(act,VMX,VMN,VAVE,VTOT,DIVMX,DIVMN,DISTMX,DISTMN)
#include "building.h"
      
      integer lnblnk  ! function definition

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/OUTPCH/ICOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS
      COMMON/GRTOOL/IHFLAG,IDHFLG,ilflag

      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME

      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV

      COMMON/IGETFLG/IOCUPF,ialstused,IROC
      COMMON/GETPIK/NGET,IGETNO(MZS,9)
      common/getmenu/menutype,igetind(65),igetflux(65)

C Markdown flag.
      logical markdown
      common/markdownflag/markdown
      common/recov03/recovery_active
      logical recovery_active

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      COMMON/GET1/VAL1(MZS,MTS),VAL2(MZS,MTS),VAL3(MZRL,MTS)
      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)
      COMMON/SIMPKA/NSIM

      common/exporttg/xfile,tg,delim
      COMMON/EXPORTI/ixopen,ixunit,ixpunit

      integer ireportunit ! zero is default one is W two is kW three Joules
      common/repunit/ireportunit
      integer nbdecimal  ! number of decimal places by topic

C Remember if we are dealing with surface information (longer names in reporting).
      logical SLISTR
      common/focussurf/SLISTR

      dimension YMAX(MZS), YMIN(MZS), YTOTSD(MZS)
      dimension YAVE(MZS), YSTD(MZS), NY(MZS), YTOT(MZS)
      dimension TMAX(MZS), TMIN(MZS)
      character xfile*144,tg*1,delim*1
      character outs*124,act*1
      character fill*9  ! spaces for surface reporting
      character prompt*124,prompte*124
      character DESCR*7,DESCR1*10,DESCR2*8,DESCRH*5,DESCRD*5,DESCRJ*5
      character NT*14,XT*14
      character RSNAME*40
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      character PDESCR*64,SDESCR*44

      logical LARGE,HAVEIT

C If output to file alter the edisp unit number. Skip if in IPV mode.
      prompt = '  '
      if (act(1:1).ne.'i') then
        itru = icout
        if(ixopen.eq.1)then
          itru = ixunit
        endif
      endif

C Set all returned data to zero.
 42   continue
      VMX=0.0; VMN=0.0; VAVE=0.0; VTOT=0.0
      DIVMX=0.0; DIVMN=0.0; DISTMX=0.0; DISTMN=0.0
      nbdecimal=3  ! default assumption

C Call the menu of choices (this also sets some default options).
C The logical variable totals controls the displaying of cumulative 
C data for all the zones chosen.  
      if(act(1:1).eq.'-')then
        MENUTYPE=5
C        write(6,*) 'in stats ireportunit is ',ireportunit
        ireportunit=0  ! assume normal for stats
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          if(NGET.ge.1)then
            write(prompt,'(3a)') 'Scanning ',
     &        SLABEL(1)(1:LNSLABEL(1)),' >> file...'
          else
            write(prompt,'(a)') ' Scanning data >> file...' 
          endif
          itru = ixunit
        else
          if(NGET.ge.1)then
            write(prompt,'(3a)') 'Scanning ',
     &        SLABEL(1)(1:LNSLABEL(1)),'...'
          else
            write(prompt,'(a)') 'Scanning...' 
          endif
          itru = icout
        endif
        if (MENUTYPE.eq.-1) return
      else
        if(NGET.ge.1)then
          write(prompt,'(3a)') 'Scanning ',
     &      SLABEL(1)(1:LNSLABEL(1)),'...'
        else
          write(prompt,'(a)') 'Scanning...' 
        endif
      endif
      write(prompte,'(2a)') prompt(1:lnblnk(prompt)),'done.'

C Setup parameters and call GOGET for each output day to get required data.
C GOGET recovers the data in VAL2 (and averages output if required.)
C Variables begining X are for all zones selected whereas variables 
C starting Y are zone based.
      do 5 I=1,MZS
        YTOTSD(I)=0.0; YSTD(I)=0.0; NY(I)=0; YTOT(I)=0.0
 5    continue
      XMAX=-1.E+10; XMIN=1.E+10; XTOT=0.0; XAVE=0.0; NX=0

      if(recovery_active)then
        continue
      else
        call usrmsg(prompt,' ','-')
      endif

C First recover bounds of selected data and calculate distributed max, min.
C If we can recover it efficiently use GETSTATS otherwise use MMACAL.
      do 40 IX=1,NGET
        call GETSTATS(IX,HAVEIT,DMAX,DMIN,DAVE,DTOT,TXMAX,TXMIN)
        if(HAVEIT)then

C Debug.
C          write(6,*) 'get stats ',DMAX,DMIN,DAVE,DTOT,TXMAX,TXMIN
        else
          call MMACAL(IX,DMAX,DMIN,DAVE,DTOT,TXMAX,TXMIN)

C Debug.
C          write(6,*) 'get MMACAL ',DMAX,DMIN,DAVE,DTOT,TXMAX,TXMIN
        endif
        YMAX(IX)=DMAX
        YMIN(IX)=DMIN
        YAVE(IX)=DAVE
        TMAX(IX)=TXMAX
        TMIN(IX)=TXMIN
        DISTMX=DISTMX+DMAX
        DISTMN=DISTMN+DMIN
 40   continue

C TSTART and TFINISH - start and finish times in hours from 0000 on the 
C first day of output.
      TSTART=FLOAT(IOH1)
      TFINSH=FLOAT(((IODF)*24+IOH2)-(IODS)*24)

C Debug.
      fill='         '
      if(SLISTR)then  ! space for surface labels
        isp=26; lf=7
      else
        isp=20; lf=1
      endif
      
C NDTS - the number of timesteps in a day.
      NDTS=24*NTS
      do 10 IDAY=IODS,IODF
        call GOGET(IDAY)

C Add values in VAL2 to there correct bins. Loop through selected zones.
        do 400 IX=1,NGET

          IZONE=IGETNO(IX,2)
          DO 421 J = 1,NDTS,NOUT

C Compute current time.
C IHRD - number of days since start of plotting period in hours.
C TIME - time in hours since start of first day plotted.
            IHRD=(IDAY-IODS)*24
            call DATIME(J,ATIME)
            TIME=float(IHRD)+ATIME

C Within requested output period.
            IF(TIME.LT.(TSTART-1.0).or.TIME.GT.TFINSH)goto 421

C If there is occupancy filter and occupancy then include in check.
C Assume fully occupied.
            ih=int(ATIME+1.)
            ioc=1
            if(iocupf.eq.1) call getocup(IZONE,IDAY,J,ioc,ier)
            if(ioc.ne.0) then
              YTOTSD(IX)=YTOTSD(IX)+((YAVE(IX)-VAL2(IX,J))**2)
              NY(IX)=NY(IX)+1
              YTOT(IX)=YTOT(IX)+VAL2(IX,J)

C Diversified values. Do this only once.
C Sum all NGET values for current timestep.
              if (IX.eq.1) then
                XMAXC=0.0
                XMINC=0.0
                do 451 ISUM=1,NGET
                  IF(VAL2(ISUM,J).GT.0.)XMAXC=XMAXC+VAL2(ISUM,J)
                  IF(VAL2(ISUM,J).LT.0.)XMINC=XMINC+VAL2(ISUM,J)
 451            continue
                if (XMAXC.gt.DIVMX) then
                  DIVMX=XMAXC
                  DIVMXT=TIME
                  if (DIVMX.gt.1000.) LARGE=.TRUE.
                endif
                if (XMINC.lt.DIVMN) then
                  DIVMN=XMINC
                  DIVMNT=TIME
                  if (DIVMN.lt.-1000.) LARGE=.TRUE.
                endif
              endif

C Find largest value for current timestep and zone.
              XMAX=MAX(XMAX,VAL2(IX,J))
              XMIN=MIN(XMIN,VAL2(IX,J))
              XTOT=XTOT+VAL2(IX,J)  ! Increment total.
              NX=NX+1
            endif
 421      CONTINUE
 400    CONTINUE
 10   continue

C Calculate standard deviation and averages.
      do 25 I=1,NGET
        if (NY(I).lt.2) then
          YSTD(I)=0.
        else
          YSTD(I)=sqrt(YTOTSD(I)/float(NY(I)-1))
        endif
 25   continue
      if (NX.ne.0) XAVE=XTOT/float(NX)

      if(recovery_active)then
        continue
      else
        call usrmsg(prompte,'  ','P')
      endif
      if(MMOD.eq.8)call usrmsg('  ','  ','-')

C Set IPV data and return (note calling code will need to divide
C by NTS to shift to kWhr.
      if(act(1:1).eq.'i') then
        VMX=XMAX; VMN=XMIN; VAVE=XAVE; VTOT=XTOT
        return
      endif

C -- Now display the recovered data. --
C At each step here need to check if default space delimiter has been 
C changed.

      CALL HDDATE(PDESCR)
      CALL HDSTEP(SDESCR)
      lsn1=MIN0(lnblnk(RFILE),42)

C Switch to fixed font for text feedback (applicable for graphic mode).
      lastmenufont=IMFS
      lastbuttonfont=IFS
      lasttextfont=ITFS
      if(ITFS.eq.4) ITFS=0
      if(ITFS.eq.5) ITFS=1
      if(ITFS.eq.6) ITFS=2
      if(ITFS.eq.7) ITFS=3
      call userfonts(IFS,ITFS,IMFS)
      call defaultfonts(IFS,ITFS,IMFS)  ! and remember these as defaults
      
C Write tag line if tagged output requested otherwise write a line
C separator between reports.
      if (delim.eq.'X') then
        write(outs,'(a)')'*stats'
        call edisp(itru,outs)
      else
        call edisp(itru,' ')
      endif
      
C If writing to file prefix text with a '#' mark. If we have
C not yet printed the heading do so and mark as printed.
      if(ixopen.eq.1)then
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
            if(markdown)then
              write(outs,'(2a)') '# Performance Report for ',
     &          RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM)))
              call edisp(itru,outs)
    
              write(outs,'(3A,I4)')'### Library ',RFILE(1:lsn1),
     &          ' Set:',ISIM
              call edisp(itru,outs)
            else
              WRITE(outs,'(3A,I4,3A)')'# Results library: ',
     &          RFILE(1:lsn1),'; results set:',
     &          ISIM,' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
              call edisp(itru,outs)
            endif
          else
            if(markdown)then
              write(outs,'(2a)') '# Performance Report for ',
     &          RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM)))
              call edisp(itru,outs)
              write(outs,'(2A)')'### Library ',RFILE(1:lsn1)
              call edisp(itru,outs)
            else
              WRITE(outs,'(5A)')'# Results library: ',RFILE(1:lsn1),
     &         '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
              call edisp(itru,outs)
            endif
          endif
          if(markdown)then
            write(outs,'(4A)')'### ',PDESCR(1:lnblnk(PDESCR)),' ',
     &        SDESCR(12:lnblnk(SDESCR))
          else
            WRITE(outs,'(4A)')'# ',PDESCR(1:lnblnk(PDESCR)),' ',
     &        SDESCR(12:lnblnk(SDESCR))
          endif
          call edisp(itru,outs)
        endif
        if(markdown)then
          call edisp(itru,'  ')
          write (outs,'(2a)') '## ',SLABEL(NGET)
          call edisp(itru,outs)
          write (outs,'(2a)') ': ',SLABEL(NGET)
          call edisp(itru,outs)
          call edisp(itru,' ')
        else
          write (outs,'(2a)') '# ',SLABEL(NGET)
          call edisp(itru,outs)
        endif
      else
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
            WRITE(outs,'(3A,I4,3A)')'Results library: ',
     &        RFILE(1:lsn1),'; results set:',ISIM,
     &       ' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          else
            WRITE(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &       '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
          endif
          call edisp(itru,outs)
          WRITE(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &                      SDESCR(12:lnblnk(SDESCR))
          call edisp(itru,outs)
        endif
        write (outs,'(a)') SLABEL(NGET)
        call edisp(itru,outs)
        call edisp(itru,'  ')
      endif
C       write(6,'(a,i3)') 'The igetno is',IGETNO(NGET,1)

C For temperatures or humidity we only need 1 decimal place.
      if (IGETNO(NGET,1).eq.1.or.IGETNO(NGET,1).eq.2.or.
     &    IGETNO(NGET,1).eq.3.or.IGETNO(NGET,1).eq.4.or.
     &    IGETNO(NGET,1).eq.5.or.IGETNO(NGET,1).eq.6.or.
     &    IGETNO(NGET,1).eq.7.or.IGETNO(NGET,1).eq.11.or.
     &    IGETNO(NGET,1).eq.12.or.IGETNO(NGET,1).eq.13.or.
     &    IGETNO(NGET,1).eq.14.or.IGETNO(NGET,1).eq.15.or.
     &    IGETNO(NGET,1).eq.16.or.IGETNO(NGET,1).eq.21.or.
     &    IGETNO(NGET,1).eq.22.or.IGETNO(NGET,1).eq.24.or.
     &    IGETNO(NGET,1).eq.29.or.IGETNO(NGET,1).eq.34.or.
     &    IGETNO(NGET,1).eq.35.or.IGETNO(NGET,1).eq.41.or.
     &    IGETNO(NGET,1).eq.42.or.IGETNO(NGET,1).eq.43.or.
     &    IGETNO(NGET,1).eq.44.or.IGETNO(NGET,1).eq.45) then
        nbdecimal=1  ! we can't measure any tighter than this.
      endif
      
C Write specific cases first, generally in numerical order of IGET.
C Weather data therefore do not print zone names.
      if (IGETNO(NGET,1).eq.2.or.IGETNO(NGET,1).eq.19.or.
     &    IGETNO(NGET,1).eq.20.or.IGETNO(NGET,1).eq.21.or.
     &    IGETNO(NGET,1).eq.22.or.IGETNO(NGET,1).eq.26) then
        if(ixopen.eq.1)then
          if (IROC.eq.-1) then  ! integrate data
            if(markdown)then
C              call edisp(itru,'  ')
              write(outs,'(2A)')
     &'---------  -------------  ----------  ',
     &'------------   ----------  ----------  -----'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'Max        Max            Min         ',
     &'Min            Average     Std        -Total'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'value      occurrance     value       ',
     &'occurance      value       deviation'             
              call edisp(itru,outs)
             else
               write(outs,'(2a)')'Max_value Max_occur Min_value ',
     &                      'Min_occur Ave_value Std_dev Total'
               call eddisp(itru,outs)
             endif
          else
            if(markdown)then
C              call edisp(itru,'  ')
              write(outs,'(2A)')
     &'---------  -------------  ----------  ',
     &'------------   ----------  ----------'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'Max        Max            Min         ',
     &'Min            Average     Std      '
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'value      occurrance     value       ',
     &'occurance      value       deviation '             
              call edisp(itru,outs)
            else
              write(outs,'(2a)')'Max_value Max_occur Min_value ',
     &                      'Min_occur Ave_value Std_dev'
              call eddisp(itru,outs)
            endif
          endif
        else

C Writing weather data to the screen.
          write (outs,'(2a)') '    Maximum                  Minimum',
     &                      '                Mean   Standard  Total'
          call eddisp(itru,outs)
          write (outs,'(2a)') '  value    occurrence      value',
     &            '    occurrence      value  deviation'
          call eddisp(itru,outs)
        endif

C Write tag line if tagged output requested.
        if (delim.eq.'X') then
          write(outs,'(a,5i4)')'*data ',(IGETNO(NGET,IX),IX=1,5)
          call eddisp(itru,outs)
        endif
      
C Now generate climate data output text.
        if (NX.eq.0) then
          if(ixopen.eq.1)then
            write(outs,'(a)')'# -- No data: probably due to filtering.'
          else
            write(outs,'(a)')' -- No data: probably due to filtering.'
          endif
        else

C Create string description for time of maximum occurrance.
          MAXDOY=INT(TMAX(1)/24.)+IODS
          TMAXHR=AMOD(TMAX(1),24.)
          call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
          MINDOY=INT(TMIN(1)/24.)+IODS
          TMINHR=AMOD(TMIN(1),24.)
          call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (NT,'(3a)')DESCR(1:6),'@',DESCRH
          if (IROC.eq.-1) then  ! integrate data
            if(markdown)then
              if(nbdecimal.eq.1)then
                write (outs,'(2(f9.1,2x,a12,4x),2(f9.2,3x),g12.6)')
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1),YTOT(1)
              else
                write (outs,'(2(f9.1,2x,a12,4x),2(f9.1,3x),g12.6)')
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1),YTOT(1)
              endif    
            else
              if(nbdecimal.eq.1)then
                write (outs,'(2(f7.1,2x,a12,4x),2(f7.2,3x),g12.6)')
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1),YTOT(1)
              else
                write (outs,'(2(f7.1,2x,a12,4x),2(f7.1,3x),g12.6)')
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1),YTOT(1)
              endif
            endif
          else
            if(markdown)then
              if(nbdecimal.eq.1)then
                write (outs,'(2(f9.1,2x,a12,4x),2(f9.2,3x))') 
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1)
              else
                write (outs,'(2(f9.1,2x,a12,4x),2(f9.1,3x))') 
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1)
              endif
            else
              if(nbdecimal.eq.1)then
                write (outs,'(2(f7.1,2x,a12,4x),2(f7.2,3x))') 
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1)
              else
                write (outs,'(2(f7.1,2x,a12,4x),2(f7.1,3x))') 
     &            YMAX(1),XT,YMIN(1),NT,YAVE(1),YSTD(1)
              endif
            endif
          endif
        endif
        call eddisp(itru,outs)  ! Write climate data text as required.
      else

C All other IGET's. Display zone based information.
C Generate and display or write to file the column headings.
        if(ixopen.eq.1)then   ! writing to a file
          if (delim.eq.'X') then
            write(outs,'(a)')'*title'
            call edisp(itru,outs)
          endif
          if (IROC.eq.-1) then  ! integrate data
            if(markdown)then
              call edisp(itru,'  ')
              if(SLISTR)then  ! space for surface labels
                write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
              else
                write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
              endif
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'Description    ',fill(1:lf),
     &'    Max          Max            Min         ',
     &'Min            Average     Std        Total'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'               ',fill(1:lf),
     &'    value        occurrance     value       ',
     &'occurance      value       deviation       '             
              call edisp(itru,outs)
            else
              write(outs,'(2a)')'Description Max_value Max_occur ',
     &                 'Min_value Min_occur Ave_value Std_dev Total'
              call eddisp(itru,outs)
            endif
          else
            if(markdown)then
              call edisp(itru,'  ')
              if(SLISTR)then  ! space for surface labels
                write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
              else
                write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
              endif
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'Description   ',fill(1:lf),
     &'    Max          Max            Min         ',
     &'Min            Average     Std      '
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'              ',fill(1:lf),
     &'    value        occurrance     value       ',
     &'occurance      value       deviation'             
              call edisp(itru,outs)
            else
              write(outs,'(2a)')'Description Max_value Max_occur ',
     &                 'Min_value Min_occur Ave_value Std_dev'
              call eddisp(itru,outs)
            endif
          endif
        else                    ! Writing to screen.
          if (IROC.eq.-1) then  ! Integrate data.
            if(markdown)then
              call edisp(itru,'  ')
              if(SLISTR)then  ! space for surface labels
                write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
              else
                write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
              endif
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'Description   ',fill(1:lf),
     &'Max          Max            Min         ',
     &'Min            Average     Std        Total'
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'              ',fill(1:lf),
     &'value        occurrance     value       ',
     &'occurance      value       deviation'             
              call edisp(itru,outs)
            else
              write(outs,'(2a)')
     &'Description        Maximum         ',
     &'          Minimum                  Mean        Standard   Total'
              call eddisp(itru,outs)
            endif
          else
            if(markdown)then
              call edisp(itru,'  ')
              if(SLISTR)then  ! space for surface labels
                write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
              else
                write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
              endif
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'Description       ',fill(1:lf),
     &'Max          Max            Min         ',
     &'Min            Average     Std      '
              call edisp(itru,outs)
              write(outs,'(4A)')
     &'                  ',fill(1:lf),
     &'value        occurrance     value       ',
     &'occurance      value       deviation'             
              call edisp(itru,outs)
            else
              write(outs,'(4a)')
     &'Description           ',fill(1:lf),'Maximum           ',
     &'        Minimum                  Mean      Standard'
              call eddisp(itru,outs)
              write(outs,'(4a)')  
     &'                      ',fill(1:lf),'value   occurrence',
     &'        value   occurrence       value     deviation'
              call eddisp(itru,outs)
            endif
          endif
        endif
        do 30 I=1,NGET

C Write tag line if tagged output requested.
          if (delim.eq.'X') then
            write(outs,'(a,5i4)')'*data ',(IGETNO(I,IX),IX=1,5)
            call eddisp(itru,outs)
          endif
          if (NY(I).eq.0) then
            write (outs,'(a,a)') TABLABEL(I)(1:LNTABLABEL(I)),
     &           ' No data: probably due to filtering.'
          else

C Create string description for time of maximum occurrance.
            MAXDOY=INT(TMAX(I)/24.)+IODS
            TMAXHR=AMOD(TMAX(I),24.)
            call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
            MINDOY=INT(TMIN(I)/24.)+IODS
            TMINHR=AMOD(TMIN(I),24.)
            call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (NT,'(3a)')DESCR(1:6),'@',DESCRH

            if(markdown)then        ! Build up string for displaying.
              if (IROC.eq.-1) then  ! Integrate data
                if(nbdecimal.eq.1)then
                  write(outs,'(a,f10.1,3a,f10.1,3a,f10.1,a,f10.2,
     &            a,f10.3)') TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I),
     &            ' ',YTOT(I)
                else
                  write(outs,'(a,f10.3,3a,f10.3,3a,f10.3,a,f10.3,
     &            a,f10.3)') TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I),
     &            ' ',YTOT(I)
                endif
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(a,f10.1,3a,f10.1,3a,f10.2,a,f10.3)') 
     &            TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I)
                else
                  write (outs,'(a,f10.3,3a,f10.3,3a,f10.3,a,f10.3)') 
     &            TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I)
                endif
              endif
            else                    ! Non-markdown reporting.
              if (IROC.eq.-1) then  ! Integrate data.
                if(nbdecimal.eq.1)then
                  write(outs,'(a,f9.1,3a,f9.1,3a,f9.1,a,f9.2,
     &            a,f10.3)') TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I),
     &            ' ',YTOT(I)
                else
                  write(outs,'(a,f9.3,3a,f9.3,3a,f9.3,a,f9.3,
     &            a,f10.3)') TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I),
     &            ' ',YTOT(I)
                endif
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(a,f9.1,3a,f9.1,3a,f9.2,a,f9.3)') 
     &            TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I)
                else
                  write (outs,'(a,f9.3,3a,f9.3,3a,f9.3,a,f9.3)') 
     &            TABLABEL(I)(1:isp),YMAX(I),
     &            '  ',XT,' ',YMIN(I),'  ',NT,' ',YAVE(I),' ',YSTD(I)
                endif
              endif
            endif
          endif
          call eddisp(itru,outs)
 30     continue

C Generate 'all zones' text.  Include times for maximum and minimum 
C heating and cooling.
        if (delim.eq.'X') then
          write(outs,'(a,i4,a)')'*data ',IGETNO(NGET,1),' 0 0 0 0'
          call eddisp(itru,outs)
        else
          if(.NOT.markdown) call edisp(itru,'  ')
        endif
        if (NX.eq.0) then
          if(ixopen.eq.1)then
            write(outs,'(a)')'# -- No data: probably due to filtering.'
          else
            write(outs,'(a)')' -- No data: probably due to filtering.'
          endif
        else

C If zone sensible heating, sensible cooling, sensible load or
C zone latent loads do the following report.
          if (IGETNO(NGET,1).eq.8.or.IGETNO(NGET,1).eq.9.or.
     &        IGETNO(NGET,1).eq.10.or.IGETNO(NGET,1).eq.30.or.
     &        IGETNO(NGET,1).eq.31.or.IGETNO(NGET,1).eq.32.or.
     &        IGETNO(NGET,1).eq.33) then

C Create string description for time of maximum occurrance.
            MAXDOY=INT(DIVMXT/24.)+IODS
            TMAXHR=AMOD(DIVMXT,24.)
            call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
            MINDOY=INT(DIVMNT/24.)+IODS
            TMINHR=AMOD(DIVMNT,24.)
            call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (NT,'(3a)')DESCR(1:6),'@',DESCRH
            
            if(markdown)then       ! Build up string for displaying markdown loads.
              if (IROC.eq.-1) then ! Integrate data.
                if(nbdecimal.eq.1)then
                  write(outs,'(2a,f10.1,3a,f10.1,3a,f10.1)')
     &            'All           ',fill(1:lf),DIVMX,'  ',
     &            XT,' ',DIVMN,'  ',NT,'     --           --     ',
     &             XTOT
                else
                  write(outs,'(2a,f10.3,3a,f10.3,3a,f10.3)')
     &            'All           ',fill(1:lf),DIVMX,'  ',
     &            XT,' ',DIVMN,'  ',NT,'     --           --     ',
     &             XTOT
                endif
                call edisp(itru,outs)
                if(SLISTR)then  ! space for surface labels
                  write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
                else
                  write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
                endif
                call edisp(itru,outs)
                call edisp(itru,' ')
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(2a,f10.1,3a,f10.1,3a)') 
     &            'All                 ',fill(1:lf),DIVMX,
     &            '  ',XT,' ',DIVMN,'  ',NT,'     --           --     '
                else
                  write (outs,'(2a,f10.3,3a,f10.3,3a)') 
     &            'All                ',fill(1:lf),DIVMX,
     &            '  ',XT,' ',DIVMN,'  ',NT,'     --           --     '
                endif
                call edisp(itru,outs)
                if(SLISTR)then  ! space for surface labels
                  write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
                else
                  write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
                endif
                call edisp(itru,outs)
                call edisp(itru,' ')
              endif
            else                    ! Feedback to screen for non-markdown loads.
              if (IROC.eq.-1) then  ! Integrate data.
                if(nbdecimal.eq.1)then
                  write(outs,'(2a,f9.1,3a,f9.1,3a,f9.1)')
     &              'All                ',fill(1:lf),DIVMX,'  ',
     &              XT,' ',DIVMN,'  ',NT,'     --           --     ',
     &              XTOT
                else
                  write(outs,'(2a,f9.3,3a,f9.3,3a,f9.3)')
     &              'All                ',fill(1:lf),DIVMX,'  ',
     &              XT,' ',DIVMN,'  ',NT,'     --           --     ',
     &              XTOT
                endif
                if(ilflag.eq.0.or.ilflag.eq.2)then
                  if(ixopen.eq.1)then
                    call eddisp(itru,outs)
                  else
                    call edisp(itru,outs)
                  endif
                elseif(ilflag.eq.1)then
                  call eddisp(itru,outs)
                endif
                call edisp(itru,' ')
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(2a,f9.1,3a,f9.1,3a)') 
     &              'All                ',fill(1:lf),DIVMX,
     &              '  ',XT,' ',DIVMN,'  ',NT,'     --           --    '
                else
                  write (outs,'(2a,f9.3,3a,f9.3,3a)') 
     &              'All                ',fill(1:lf),DIVMX,
     &              '  ',XT,' ',DIVMN,'  ',NT,'     --           --    '
                endif
                if(ilflag.eq.0.or.ilflag.eq.2)then
                  if(ixopen.eq.1)then
                    call eddisp(itru,outs)
                  else
                    call edisp(itru,outs)
                  endif
                elseif(ilflag.eq.1)then
                  call eddisp(itru,outs)
                endif
                call edisp(itru,' ')
              endif
            endif
          else     ! Build up ALL strings for other topics.
            write (outs,'(3x,a,15x)') 'All'
            if(markdown)then
              if (IROC.eq.-1) then
                if(nbdecimal.eq.1)then
                  write(outs,'(2a,f10.1,a,f10.1,a,f10.2,a,f10.3)') 
     &            'All               ',fill(1:lf),XMAX,
     &            '     --          ',XMIN,'     --          ',XAVE,
     &            '     --          ',XTOT
                else
                  write(outs,'(2a,f10.3,a,f10.3,a,f10.3,a,f10.3)') 
     &            'All               ',fill(1:lf),XMAX,
     &            '     --          ',XMIN,'     --          ',XAVE,
     &            '     --          ',XTOT
                endif
                call edisp(itru,outs)
                if(SLISTR)then  ! space for surface labels
                  write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
                else
                  write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
                endif
                call edisp(itru,outs)
                call edisp(itru,' ')
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(2a,f10.1,a,f10.1,a,f10.2,a)') 
     &            'All                ',fill(1:lf),XMAX,
     &            '     --          ',XMIN,'     --          ',XAVE,
     &            '     --          '
                else
                  write (outs,'(2a,f10.3,a,f10.3,a,f10.3,a)') 
     &            'All                ',fill(1:lf),XMAX,
     &            '     --          ',XMIN,'     --          ',XAVE,
     &            '     --          '
                endif
                call edisp(itru,outs)
                if(SLISTR)then  ! space for surface labels
                  write(outs,'(2A)')
     &'----------------------   -----------  -------------  ',
     &'----------  ------------   ----------  ---------'
                else
                  write(outs,'(2A)')
     &'----------------   -----------  -------------  -----',
     &'-----  ------------   ----------  ---------'
                endif
                call edisp(itru,outs)
                call edisp(itru,' ')
              endif
            else    ! Feedback to screen (non-markdown).
              if (IROC.eq.-1) then
                if(nbdecimal.eq.1)then
                  write(outs,'(2a,f9.1,a,f9.1,a,f9.2,a,f9.3)') 
     &              'All            ',fill(1:lf),XMAX,
     &              '     --          ',XMIN,'     --          ',XAVE,
     &              '     --          ',XTOT
                else
                  write(outs,'(2a,f9.3,a,f9.3,a,f9.3,a,f9.3)') 
     &              'All            ',fill(1:lf),XMAX,
     &              '     --          ',XMIN,'     --          ',XAVE,
     &              '     --          ',XTOT
                endif
                if(ilflag.eq.0.or.ilflag.eq.2)then
                  if(ixopen.eq.1)then
                    call eddisp(itru,outs)
                  else
                    call edisp(itru,outs)
                  endif
                elseif(ilflag.eq.1)then
                  call eddisp(itru,outs)
                endif
                call edisp(itru,' ')
              else
                if(nbdecimal.eq.1)then
                  write (outs,'(2a,f9.1,a,f9.1,a,f9.2,a)') 
     &              'All                ',fill(1:lf),XMAX,
     &              '     --          ',XMIN,'     --          ',XAVE,
     &              '     --          '
                else
                  write (outs,'(2a,f9.3,a,f9.3,a,f9.3,a)') 
     &              'All                ',fill(1:lf),XMAX,
     &              '     --          ',XMIN,'     --          ',XAVE,
     &              '     --          '
                endif
                if(ilflag.eq.0.or.ilflag.eq.2)then
                  if(ixopen.eq.1)then
                    call eddisp(itru,outs)
                  else
                    call edisp(itru,outs)
                  endif
                elseif(ilflag.eq.1)then
                  call eddisp(itru,outs)
                endif
                call edisp(itru,' ')
              endif
            
C Display 'all zones' text.
C              call eddisp(itru,outs)
            endif
          endif
        endif

C Display 'all zones' text.
C        call eddisp(itru,outs)
      endif

C Reset text feedback font.
      if(MMOD.EQ.8)then
        IMFS=lastmenufont
        ITFS=lasttextfont    ! reset to proportional font in text feedback
        IFS=lastbuttonfont
        call userfonts(IFS,ITFS,IMFS)
      endif

C End tag for tagged data
      if (delim.eq.'X') then
        write(outs,'(a)')'*end_stats'
        call edisp(itru,outs)
      endif

C Allow other/ re- display?
      if(act(1:1).eq.'p')then
        return
      else
        goto 42
      endif

      END

C ******************** MOSMSDCEN ********************
C MOSMSDCEN uses the generic menu and get routines to retrieve max, min and
C other basic statistical data and then compares it to the values in the CEN 
C standard.

      SUBROUTINE MOSMSDCEN(act)
#include "building.h"

C Get common precz from geometry.h
#include "geometry.h"

      integer lnblnk
      
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/OUTPCH/ICOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY

      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)

      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV

      COMMON/SETPIK/NS,NSNO(MNRS),ISETON(MNRS),IMET,IFAFLG(MNRS,MNFA)
      COMMON/ZONPIK/NZ,NZNO(MCOM)
      COMMON/IGETFLG/IOCUPF,ialstused,IROC
      COMMON/GETPIK/NGET,IGETNO(MZS,9)

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      COMMON/GET1/VAL1(MZS,MTS),VAL2(MZS,MTS),VAL3(MZRL,MTS)

      COMMON/EXPORTI/ixopen,ixunit,ixpunit

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext
      common/recov03/recovery_active
      logical recovery_active

      dimension YMAX(MZS), YMIN(MZS), YTOT(MZS), YTOTSD(MZS)
      dimension YAVE(MZS), NY(MZS)
      dimension CENMAX(9), CENMIN(9), CENAVE(9)
      integer lsn1

      character outs*124,act*1
      character prompt*124
      CHARACTER PDESCR*64,SDESCR*44,RSNAME*40
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      logical display

C If output to file alter the edisp unit number.
      itru = icout
      if(ixopen.eq.1)then
        itru = ixunit
        if(NGET.ge.1)then
          write(prompt,'(a,a)') TABLABEL(1)(1:LNTABLABEL(1)),' >> file.'
        else
          write(prompt,'(a)')' Output being directed to file. ' 
        endif
      elseif(ixopen.eq.0)then
        prompt = ' '
      endif

      if(act(1:1).eq.'s')then
C Ask for the CEN standard.
        ISTAND=1
        display=.FALSE.

C Get the CEN data into the results array.
        if (ISTAND.eq.1) then

C CEN summer temperatures, geometry A.
          DATA CENMAX/38.9,34.7,33.7,37.8,32.5,32.4,40.3,35.0,33.6/
          DATA CENAVE/35.9,29.8,29.1,35.9,29.5,29.1,38.6,31.6,30.2/
          DATA CENMIN/33.2,25.3,25.3,34.4,26.5,26.3,37.0,28.2,27.5/
        endif
      endif

C Setup parameters and call GOGET for each output day to get required data.
C GOGET recovers the data in VAL2 (and averages output if required.)
C Variables begining X are for all zones selected whereas variables 
C starting Y are zone based.
      do 5 I=1,MZS
        YMAX(I)=-1.E+10; YMIN(I)=1.E+10; YTOT(I)=0.0
        YTOTSD(I)=0.0; YAVE(I)=0.0; NY(I)=0
 5    continue
      XMAX=-1.E+10; XMIN=1.E+10; XTOT=0.0
      XTOTSD=0.0; XAVE=0.0; NX=0

      if(recovery_active)then
        continue
      else
        call usrmsg(prompt,'Scanning for range of values...','-')
      endif

C TSTART and TFINISH - start and finish times in hours from 0000 on the 
C first day of output.
      TSTART=FLOAT(IOH1)
      TFINSH=FLOAT(((IODF)*24+IOH2)-(IODS)*24)

C NDTS - the number of timesteps in a day.
      NDTS=24*NTS
 99   do 10 IDAY=IODS,IODF
        call GOGET(IDAY)

C Add values in VAL2 to there correct bins. Loop through selected zones.
        do 400 IX=1,NGET
          IZONE=IGETNO(IX,2)
          if (IZONE.ne.0) then 
            NZNO(IX)=IZONE
          endif
          DO 421 J = 1,NDTS,NOUT

C Compute current time.
C IHRD - number of days since start of plotting period in hours.
C TIME - time in hours since start of first day plotted.
C Add half a timestep to TIME if data averaged.
            IHRD=(IDAY-IODS)*24
            call DATIME(J,ATIME)
            TIME=float(IHRD)+ATIME

C Within requested output period.
            IF(TIME.LT.(TSTART-1.0).or.TIME.GT.TFINSH)goto 421

C If there is occupancy filter and occupancy then include in check.
C Assume fully occupied.
            ih=int(ATIME+1.)
            ioc=1
            if(iocupf.eq.1) call getocup(IZONE,IDAY,J,ioc,ier)
            if(ioc.ne.0) then
              if (display) then
                XTOTSD=XTOTSD+((XAVE-VAL2(IX,J))**2)
                YTOTSD(IX)=YTOTSD(IX)+((YAVE(IX)-VAL2(IX,J))**2)
              else
                IF (VAL2(IX,J).GT.XMAX) XMAX=VAL2(IX,J)
                IF (VAL2(IX,J).LT.XMIN) XMIN=VAL2(IX,J)
                XTOT=XTOT+VAL2(IX,J)
                NX=NX+1
                IF (VAL2(IX,J).GT.YMAX(IX)) YMAX(IX)=VAL2(IX,J)
                IF (VAL2(IX,J).LT.YMIN(IX)) YMIN(IX)=VAL2(IX,J)
                YTOT(IX)=YTOT(IX)+VAL2(IX,J)
                NY(IX)=NY(IX)+1
              endif
            endif
 421      CONTINUE
 400    CONTINUE
 10   continue

C Calculate averages and rescan the data to calculate std deviations.
      if (.not.display) then
        do 20 I=1,NGET
          if (NY(I).eq.0) then
            YAVE(I)=0.
          else
            YAVE(I)=YTOT(I)/float(NY(I))
          endif
 20     continue
        if (NX.eq.0) then
          XAVE=0.
        else
          XAVE=XTOT/float(NX)
        endif
        display=.TRUE.
        goto 99
      endif

      if(recovery_active)then
        continue
      else
        call usrmsg('  ','  ','-')
      endif

C Now display the calculated data.
      call edisp(itru,'  ')
      CALL HDDATE(PDESCR)
      CALL HDSTEP(SDESCR)
      lsn1=MIN0(lnblnk(RFILE),42)
      if (NS.lt.2) then
        write (outs,'(1X,5A)')
     &    SDESCR,' results library:',RFILE(1:lsn1),'; results set:',
     &    RSNAME(ISIM)(1:22)
      else
        write (outs,'(1X,3A)') SDESCR,' results library:',RFILE(1:lsn1)
      endif

C If heading has not yet been written do so now.
      if((.NOT.libheading).and.(.NOT.headingcontext))then
        call edisp(itru,outs)
      endif
      write (outs,'(a)') TABLABEL(NGET)(1:LNTABLABEL(NGET))
      call edisp(itru,outs)
      call edisp(itru,'  ')

      write (outs,'(a,a)')'   Zone            Maximum       ',
     &                                        'Minimum       Mean'
      call edisp(itru,outs)
      write (outs,'(a,a)')'id name                 Delta',
     &                                  '         Delta         Delta'
      call edisp(itru,outs)
      do 30 I=1,NGET
        if (NY(I).eq.0) then
          write (outs,'(i3,1x,a12,a)') NZNO(I), zname(IGETNO(I,2)), 
     &                           'No data: probably due to filtering.'
        else
          write (outs,'(i3,1x,a12,3(f8.1,f6.1))') NZNO(I),
     &         zname(IGETNO(I,2)),YMAX(I),(YMAX(I)-CENMAX(I)),
     &         YMIN(I),(YMIN(I)-CENMIN(I)),YAVE(I),(YAVE(I)-CENAVE(I))
        endif
        call edisp(itru,outs)
 30   continue

      return
      END

C ******************** MOSQHR ********************
C Find number of hours above or below a given value using generic 
C         routines.
C  iabove >1 find hours above value
C  iabove <1 find hours below value
C act='p' iget parameters already set.

      SUBROUTINE MOSQHR(act,iabove,tval)
#include "building.h"
#include "help.h"

      integer lnblnk
      
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/OUTPCH/ICOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS

      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME

      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV

      COMMON/IGETFLG/IOCUPF,ialstused,IROC
      COMMON/GETPIK/NGET,IGETNO(MZS,9)
      common/getmenu/menutype,igetind(65),igetflux(65)
      COMMON/GRTOOL/IHFLAG,IDHFLG,ILFLAG

C Markdown flag.
      logical markdown
      common/markdownflag/markdown
      common/recov03/recovery_active
      logical recovery_active

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      COMMON/GET1/VAL1(MZS,MTS),VAL2(MZS,MTS),VAL3(MZRL,MTS)
      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)

      COMMON/EXPORTI/ixopen,ixunit,ixpunit

      COMMON/AVRAGE/IDAVER

C Remember if we are dealing with surface information (longer names in reporting).
      logical SLISTR
      common/focussurf/SLISTR

      character prompt*124,outs*124
      character DESCR*7,DESCR1*10,DESCR2*8,DESCRH*5,DESCRD*5,DESCRJ*5
      character NT*14,XT*14
      character RSNAME*40
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      character PDESCR*64,SDESCR*44,act*1
      character fill*9  ! added spaces for surface reporting

      dimension YMAX(MZS), YMIN(MZS), YTOT(MZS)
      dimension YAVE(MZS), NY(MZS)
      dimension TMAX(MZS), TMIN(MZS)
      integer lsn1

      integer isAct(MZS),isOcc(MZS),isActPrev(MZS),isOccPrev(MZS)
      real TActive(MZS),TOccup(MZS),TPerStart(MZS),TPerFinish(MZS)
      real TOccStart(MZS),TOccFinish(MZS),TSTIME,TActiveTot,TOccupTot
      integer nbdecimal  ! number of decimal places by topic
      

      real toAdd

      helpinsub='stats'  ! set for subroutine

C If output to file alter the edisp unit number.
      itru = icout
      prompt = ' '
      if(ixopen.eq.1)then
        itru = ixunit
      endif

C Call the menu of choices (this also sets some default options).
 1    if(act(1:1).eq.'-') then
        if (IABOVE.gt.0) then
          MENUTYPE=7
        else
          MENUTYPE=8
        endif
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif
        else
          itru = icout
        endif
        if (MENUTYPE.eq.-1)then
          return
        endif
      endif

C Ask for set point value.
      if (act(1:1).eq.'p') then
        XQUERY=tval
      else
        helptopic='res_above_below_pt'
        call gethelptext(helpinsub,helptopic,nbhelp)
        XQUERY=0.0
        CALL EASKR(XQUERY,' ','  Test point value ? ',
     &    0.0,'-',0.0,'-',20.0,'query value',IER,nbhelp)
      endif

C Setup parameters and call GOGET for each output day to get required data.
C GOGET recovers the data in VAL2 (and averages output if required.)
C Variables begining X are for all zones selected whereas variables 
C starting Y are zone based.
      do 5 I=1,MZS
        YMAX(I)=-1.E+10; YMIN(I)=1.E+10
        YTOT(I)=0.0; YAVE(I)=0.0; NY(I)=0
        TMAX(I)=0.0; TMIN(I)=0.0
 5    continue
      XMAX=-1.E+10; XMIN=1.E+10
      XTOT=0.0; NX=0
      nbdecimal=3  ! default assumption

      fill='         '
      if(SLISTR)then  ! space for surface labels
        isp=26; lf=15
      else
        isp=20; lf=1
      endif

      if(recovery_active)then
        continue
      else
        call usrmsg(prompt,'Scanning for range of values...','-')
      endif

C Switch to fixed font for text feedback.
      lastmenufont=IMFS
      lastbuttonfont=IFS
      lasttextfont=ITFS
      if(ITFS.eq.4) ITFS=0
      if(ITFS.eq.5) ITFS=1
      if(ITFS.eq.6) ITFS=2
      if(ITFS.eq.7) ITFS=3
      call userfonts(IFS,ITFS,IMFS)


C TSTART and TFINISH - start and finish times in hours from 0000 on the 
C first day of output.
      TSTART=FLOAT(IOH1)
      TFINSH=FLOAT(((IODF)*24+IOH2)-(IODS)*24)

C Initialise arrays.
      do IX=1,NGET
        isAct(IX)=-1
        isOcc(IX)=-1
        TActive(IX)=0.0
        TOccup(IX)=0.0
        isActPrev(IX)=0
        isOccPrev(IX)=0
        TOccStart(IX)=0.0
        TOccFinish(IX)=0.0 
        TPerStart(IX)=0.0
        TPerFinish(IX)=0.0
      enddo

C Calculate time values for first and last time steps, and duration
C of 1 time step (in hours).
      TSTIME=1.0/NTS
      TFirst=TSTART-1.0+TSTIME/2
      TLast=TFINSH-TSTIME/2

C NDTS - the number of timesteps in a day.
      NDTS=24*NTS
      do 10 IDAY=IODS,IODF
        call GOGET(IDAY)

C Check values in VAL2 against XQUERY.
        do 400 IX=1,NGET
          IZONE=IGETNO(IX,2)
          DO 421 J = 1,NDTS,NOUT

C Keep track of previous active and occupancy flags.
            isActPrev(IX)=isAct(IX)
            isOccPrev(IX)=isOcc(IX)

C Compute current time.
C IHRD - number of days since start of plotting period in hours.
C TIME - time in hours since start of first day plotted.
            IHRD=(IDAY-IODS)*24
            call DATIME(J,ATIME)
            TIME=float(IHRD)+ATIME

C Within requested output period.
            IF(TIME.LT.(TSTART-1.0).or.TIME.GT.TFINSH)goto 421

C If there is occupancy filter and occupancy then include in check.
C Assume fully occupied.
            ih=int(ATIME+1.)
            ioc=1
            if(iocupf.eq.1) call getocup(IZONE,IDAY,J,ioc,ier)
            if(ioc.ne.0) then

C Is occupied (or there is no occupancy filtering).
              isOcc(IX)=1

C Begin occupancy period, remember start time.
              if (isOccPrev(IX).eq.0) then
                TOccStart(IX)=TIME
              endif

C Find largest value for current timestep and zone.
              IF (VAL2(IX,J).GT.XMAX) XMAX=VAL2(IX,J)
              IF (VAL2(IX,J).LT.XMIN) XMIN=VAL2(IX,J)
              XTOT=XTOT+VAL2(IX,J)
              NX=NX+1

C Find largest value for current timestep, note time.
              IF (VAL2(IX,J).GT.YMAX(IX)) then
                YMAX(IX)=VAL2(IX,J)
                TMAX(IX)=TIME
              endif
              IF (VAL2(IX,J).LT.YMIN(IX)) then
                YMIN(IX)=VAL2(IX,J)
                TMIN(IX)=TIME
              endif
              YTOT(IX)=YTOT(IX)+VAL2(IX,J)
              NY(IX)=NY(IX)+1

C Hours above query value are "active".
              if (iabove.gt.0) then
                if (VAL2(IX,J).gt.XQUERY) then ! Active
                  isAct(IX)=1

C Active period has started. Remember start time.
                  if (isActPrev(IX).eq.0) then

C If currently on the first time step, take actual start time instead of
C first time steps time stamp. This preserves the correct duration if 
C there is no occupancy filtering.
                    if (TIME.eq.TFIRST) then
                      TPerStart(IX)=TSTART-1.0
                    else
                      TPerStart(IX)=TIME
                    endif
                  endif
                else ! Not active
                  isAct(IX)=0

C Active period has ended. Work out period duration and add to aggregate.
                  if (isActPrev(IX).eq.1) then
C If time step averaging is off (IDAVER=1) then each value represents a
C time step instead of an instantaneous value.  Add a time step onto each
C active period to approximate this.
                    if (IDAVER.eq.1) then
                      TPerFinish(IX)=TIME
                    else
                      TPerFinish(IX)=TIME-TSTIME
                    endif
                    TActive(IX)=TActive(IX)+TPerFinish(IX)-TPerStart(IX)
                  endif
                endif

C Hours below query value are "active". See above for annotations.
              else
                if (VAL2(IX,J).lt.XQUERY) then ! Active
                  isAct(IX)=1
                  if (isActPrev(IX).eq.0) then
                    if (TIME.eq.TFIRST) then
                      TPerStart(IX)=TSTART-1.0
                    else
                      TPerStart(IX)=TIME
                    endif
                  endif
                else ! Not active
                  isAct(IX)=0
                  if (isActPrev(IX).eq.1) then
                    if (IDAVER.eq.1) then
                      TPerFinish(IX)=TIME
                    else
                      TPerFinish(IX)=TIME-TSTIME
                    endif
                    TActive(IX)=TActive(IX)+TPerFinish(IX)-TPerStart(IX)
                  endif
                endif
              endif

            else ! Not occupied
              isOcc(IX)=0

C End occupancy period. Calculate period duration and add to aggregate.
              if (isOccPrev(IX).eq.1) then
                if (IDAVER.eq.1) then
                  TOccFinish(IX)=TIME
                else
                  TOccFinish(IX)=TIME-TSTIME
                endif
                TOccup(IX)=TOccup(IX)+TOccFinish(IX)-TOccStart(IX)
              endif

C If there is no occupancy, assume not active, and end any active periods.
              isAct(IX)=0
              if (isActPrev(IX).eq.1) then
                if (IDAVER.eq.1) then
                  TPerFinish(IX)=TIME
                else
                  TPerFinish(IX)=TIME-TSTIME
                endif
                TActive(IX)=TActive(IX)+TPerFinish(IX)-TPerStart(IX)
              endif
            endif

C On last time step, end any current active or occupancy periods. Take
C actual finish time instead of last time steps time stamp to preserve
C actual duration.
            if (TIME.eq.TLAST) then
              if (isAct(IX).eq.1) then
                TPerFinish(IX)=TFINSH
                TActive(IX)=TActive(IX)+TPerFinish(IX)-TPerStart(IX)
              endif 
              if (isOcc(IX).eq.1) then
                TOccFinish(IX)=TFINSH
                TOccup(IX)=TOccup(IX)+TOccFinish(IX)-TOccStart(IX)
              endif
            endif 

C Debug.
C            write(375,*)'TIME,IX,isAct(IX),isOcc(IX),isActPrev(IX),',
C     & 'isOccPrev(IX),TActive(IX),TOccup(IX),TPerFinish(IX),',
C     & 'TPerStart(IX)=',TIME,IX,isAct(IX),isOcc(IX),isActPrev(IX),
C     & isOccPrev(IX),TActive(IX),TOccup(IX),TPerFinish(IX),TPerStart(IX)

 421      CONTINUE
 400    CONTINUE
 10   continue

C Calculate averages.
      do 20 I=1,NGET
        if (NY(I).eq.0) then
          YAVE(I)=0.
        else
          YAVE(I)=YTOT(I)/float(NY(I))
        endif
 20   continue

      if(recovery_active)then
        continue
      else
        call usrmsg('  ','  ','-')
      endif

C -- Now display the recovered data. --
C At each step here need to check if default space delimiter has been 
C changed.
      call edisp(itru,'  ')
      CALL HDDATE(PDESCR)
      CALL HDSTEP(SDESCR)
      lsn1=MIN0(lnblnk(RFILE),42)
      if((.NOT.libheading).and.(.NOT.headingcontext))then
        libheading=.true.; headingcontext=.true.
        if(markdown)then
          write(outs,'(2a)') '# Performance Report for ',
     &      RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM)))
          call edisp(itru,outs)
          write(outs,'(2A)')'### Library ',RFILE(1:lsn1)
          call edisp(itru,outs)
        else
          WRITE(outs,'(3A,I4,3A)')
     &     'Results library: ',RFILE(1:lsn1),'; results set:',ISIM,' (',
     &      RSNAME(ISIM),')'
          call edisp(itru,outs)
        endif
        if(markdown)then
          write(outs,'(4A)')'### ',PDESCR(1:lnblnk(PDESCR)),' ',
     &      SDESCR(12:lnblnk(SDESCR))
        else
          WRITE(outs,'(4A)')'# ',PDESCR(1:lnblnk(PDESCR)),' ',
     &      SDESCR(12:lnblnk(SDESCR))
        endif
        call edisp(itru,outs)
      endif
      if(markdown)then
        call edisp(itru,'  ')
        write (outs,'(2a)') '## ',SLABEL(NGET)
        call edisp(itru,outs)
        if (iabove.gt.0) then
          write (outs,'(3a,f7.2)') ': ',
     &      SLABEL(NGET)(1:lnblnk(SLABEL(NGET))),
     &      ' number of hours above',XQUERY
        else
          write (outs,'(3a,f7.2)') ': ',SLABEL(NGET),
     &    ' number of hours below',XQUERY
        endif
        call edisp(itru,outs)
C        call edisp(itru,' ')
      else
        write (outs,'(2a)') '# ',SLABEL(NGET)
        call edisp(itru,outs)
        if (iabove.gt.0) then
        write (outs,'(a,f7.2)')'Reporting number of hours above ',XQUERY
        else
        write (outs,'(a,f7.2)')'Reporting number of hours below ',XQUERY
        endif
        call edisp(itru,outs)
      endif
      call edisp(itru,'  ')

C For temperatures or humidity we only need 1 decimal place.
      if (IGETNO(NGET,1).eq.1.or.IGETNO(NGET,1).eq.2.or.
     &    IGETNO(NGET,1).eq.3.or.IGETNO(NGET,1).eq.4.or.
     &    IGETNO(NGET,1).eq.5.or.IGETNO(NGET,1).eq.6.or.
     &    IGETNO(NGET,1).eq.7.or.IGETNO(NGET,1).eq.11.or.
     &    IGETNO(NGET,1).eq.12.or.IGETNO(NGET,1).eq.13.or.
     &    IGETNO(NGET,1).eq.14.or.IGETNO(NGET,1).eq.15.or.
     &    IGETNO(NGET,1).eq.16.or.IGETNO(NGET,1).eq.21.or.
     &    IGETNO(NGET,1).eq.22.or.IGETNO(NGET,1).eq.24.or.
     &    IGETNO(NGET,1).eq.29.or.IGETNO(NGET,1).eq.34.or.
     &    IGETNO(NGET,1).eq.35.or.IGETNO(NGET,1).eq.41.or.
     &    IGETNO(NGET,1).eq.42.or.IGETNO(NGET,1).eq.43.or.
     &    IGETNO(NGET,1).eq.44.or.IGETNO(NGET,1).eq.45) then
        nbdecimal=1  ! we can't measure any tighter than this.
      endif

C Write specific cases first, generally in numerical order of IGET.
C Climate data therefore do not print zone names.
      if (IGETNO(NGET,1).eq.2.or.IGETNO(NGET,1).eq.19.or.
     &    IGETNO(NGET,1).eq.20.or.IGETNO(NGET,1).eq.21.or.
     &    IGETNO(NGET,1).eq.22.or.IGETNO(NGET,1).eq.26) then
        if(markdown)then
          write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  --------'
          call edisp(itru,outs)
          write (outs,'(2a)')
     &'Description        Max          Max            Min         ',
     &'Min           Mean         Hours     Hours     % above'
          call edisp(itru,outs)
          write (outs,'(2a)')
     &'                   value        occurrance     value       ',
     &'occurance     value        above     below            '
          call edisp(itru,outs)
        else
          if(ilflag.eq.0.or.ilflag.eq.2)then
            write (outs,'(a,a)') '    Maximum               Minimum',
     &                           '              Mean    No of hours'
            call eddisp(itru,outs)
            write (outs,'(a,a)') '  value    occurrence   value',
     &        '    occurrence    value   above    below'
            call eddisp(itru,outs)
          elseif(ilflag.eq.1)then
            write (outs,'(2a)') 
     &       'Description Maximum_val Maximum_occur Minimum_val ',
     &       'Minimum_occur Mean_val Hours_above Hours_below %_above'
            call eddisp(itru,outs)
          endif
        endif

C Now generate climate data output text.
        if (NX.eq.0) then
          write (outs,'(a)') ' -- No data: probably due to filtering.'
        else

C Create string description for time of maximum occurrance.
          MAXDOY=INT(TMAX(1)/24.)+IODS
          TMAXHR=AMOD(TMAX(1),24.)
          call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
          MINDOY=INT(TMIN(1)/24.)+IODS
          TMINHR=AMOD(TMIN(1),24.)
          call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (NT,'(3a)')DESCR(1:6),'@',DESCRH

C Calculate total time above and below query value. If there is
C filtering, take total period as the time occupied.
          if (iocupf.eq.1) then
            if (iabove.gt.0) then
              AYAB=TActive(1)
              AYBE=TOccup(1)-TActive(1)
            else
              AYBE=TActive(1)
              AYAB=TOccup(1)-TActive(1)
            endif
          else
            if (iabove.gt.0) then
              AYAB=TActive(1)
              AYBE=TFINSH-(TSTART-1.0)-TActive(1)
            else
              AYBE=TActive(1) 
              AYAB=TFINSH-(TSTART-1.0)-TActive(1)
            endif
          endif
          if(nbdecimal.eq.1)then
            write (outs,'(2(f7.1,2x,a12,1x),3f8.1)')YMAX(1),XT,
     &                                  YMIN(1),NT,YAVE(1),AYAB,AYBE
          else
            write (outs,'(2(f7.1,2x,a12,1x),3f8.2)')YMAX(1),XT,
     &                                  YMIN(1),NT,YAVE(1),AYAB,AYBE
          endif
        endif

C Write climate data text as required.
        call eddisp(itru,outs)
        if(markdown)then
          write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  -------'
          call edisp(itru,outs)
        endif
      else

C All other IGET's. Display zone based information.
C Generate and display column headings.
        if(IGETNO(NGET,9).ge.15)then
          if(markdown)then
            write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  --------'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'Description        Max          Max            Min         ',
     &'Min           Mean         Hours     Hours     % above'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'                   value        occurrance     value       ',
     &'occurance     value        above     below            '
            call edisp(itru,outs)
          else
            if(ilflag.eq.0.or.ilflag.eq.2)then
              write(outs,'(4a)')
     & 'Description          ',fill(1:lf),'Maximum',
     & '                Minimum             Mean    No of hours     %'
              call eddisp(itru,outs)
              write(outs,'(4a)')
     & '                     ',fill(1:lf),'value  occurrence',
     & '     value  occurrence     value   above  below   above'
              call eddisp(itru,outs)
            elseif(ilflag.eq.1)then

C User requested single line header, use the curren separator.
              write (outs,'(2a)') 
     &        'Description Maximum_val Maximum_occur Minimum_val ',
     &        'Minimum_occur Mean_val Hours_above Hours_below %_above'
              call eddisp(itru,outs)
            endif
          endif
        elseif(IGETNO(NGET,9).le.12)then
          if(markdown)then
            write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  --------'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'Description        Max          Max            Min         ',
     &'Min           Mean         Hours     Hours     % above'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'                   value        occurrance     value       ',
     &'occurance     value        above     below            '
            call edisp(itru,outs)
          else
            if(ilflag.eq.0.or.ilflag.eq.2)then
              write(outs,'(4a)')
     & 'Description       ',fill(1:lf),'Maximum',
     & '                Minimum            Mean    No of hours     %'
              call eddisp(itru,outs)
              write(outs,'(4a)')
     & '               ',fill(1:lf),'value  occurrence',
     & '     value  occurrence     value   above  below   above'
              call eddisp(itru,outs)
            elseif(ilflag.eq.1)then
              write (outs,'(2a)') 
     &        'Description Maximum_val Maximum_occur Minimum_val ',
     &        'Minimum_occur Mean_val Hours_above Hours_below %_above'
              call eddisp(itru,outs)
            endif
          endif
        else
          if(markdown)then
            write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  --------'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'Description        Max          Max            Min         ',
     &'Min           Mean         Hours     Hours     % above'
            call edisp(itru,outs)
            write (outs,'(2a)')
     &'                   value        occurrance     value       ',
     &'occurance     value        above     below            '
            call edisp(itru,outs)
          else
            if(ilflag.eq.0.or.ilflag.eq.2)then
              write(outs,'(a,a)')'Description               Maximum',
     & '                Minimum            Mean    No of hours     %'
              call eddisp(itru,outs)
              write(outs,'(2a)')
     & '                    value  occurrence',
     & '         value  occurrence    value   above  below   above'
              call eddisp(itru,outs)
            elseif(ilflag.eq.1)then
              write (outs,'(2a)') 
     &        'Description Maximum_val Maximum_occur Minimum_val ',
     &        'Minimum_occur Mean_val Hours_above Hours_below %_above'
              call eddisp(itru,outs)
            endif
          endif
        endif
        do 30 I=1,NGET
          if (NY(I).eq.0) then
            write (outs,'(2a)') TABLABEL(I)(1:LNTABLABEL(I)),
     &       ' No data: probably due to filtering.'
          else

C Create string description for time of maximum occurrance.
            MAXDOY=INT(TMAX(I)/24.)+IODS
            TMAXHR=AMOD(TMAX(I),24.)
            call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
            MINDOY=INT(TMIN(I)/24.)+IODS
            TMINHR=AMOD(TMIN(I),24.)
            call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
            call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
            write (NT,'(3a)')DESCR(1:6),'@',DESCRH

C Calculate total time above and below query value. If there is
C filtering, take total period as the time occupied.
            if (iocupf.eq.1) then
              if (iabove.gt.0) then
                AYAB=TActive(I)
                AYBE=TOccup(I)-TActive(I)
              else
                AYBE=TActive(I)
                AYAB=TOccup(I)-TActive(I)
              endif
            else
              if (iabove.gt.0) then
                AYAB=TActive(I) 
                AYBE=TFINSH-(TSTART-1.0)-TActive(I)
              else
                AYBE=TActive(I) 
                AYAB=TFINSH-(TSTART-1.0)-TActive(I)
              endif
            endif
            APYAB=(AYAB/(AYAB+AYBE))*100.

            if(IGETNO(NGET,9).ge.15)then
              if(markdown)then
                if(nbdecimal.eq.1)then
                  write (outs,1205)TABLABEL(I)(1:isp),YMAX(I),XT,
     &              YMIN(I),NT,YAVE(I),AYAB,AYBE,APYAB
                else
                  write (outs,1105)TABLABEL(I)(1:isp),YMAX(I),XT,
     &              YMIN(I),NT,YAVE(I),AYAB,AYBE,APYAB
                endif
              else
                write (outs,1102)TABLABEL(I)(1:isp),YMAX(I),XT,
     &            YMIN(I),NT,YAVE(I),AYAB,AYBE,APYAB
              endif
            elseif(IGETNO(NGET,9).le.12)then  ! topics needed zone name only
              if(markdown)then
                if(nbdecimal.eq.1)then
                  write (outs,1203)TABLABEL(I)(1:12),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                else
                  write (outs,1103)TABLABEL(I)(1:12),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                endif
              else
                if(nbdecimal.eq.1)then
                  write (outs,1202)TABLABEL(I)(1:12),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                else
                  write (outs,1102)TABLABEL(I)(1:12),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                endif
              endif
            else
              if(markdown)then
                if(nbdecimal.eq.1)then
                  write (outs,1214)TABLABEL(I)(1:15),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                else
                  write (outs,1114)TABLABEL(I)(1:15),YMAX(I),XT,YMIN(I),
     &              NT,YAVE(I),AYAB,AYBE,APYAB
                endif
              else
                write (outs,1102)TABLABEL(I)(1:isp),YMAX(I),XT,YMIN(I),
     &            NT,YAVE(I),AYAB,AYBE,APYAB
              endif
            endif
 1102       format (a,1x,2(f8.2,1x,a12,1x),3f8.2,f7.1)
 1202       format (a,1x,2(f8.1,1x,a12,1x),f8.2,2f8.1,f7.1)
 1103       format (a,8x,2(f10.2,2x,a,1x),3f10.2,f10.1)
 1203       format (a,8x,2(f10.1,2x,a,1x),f10.2,3f10.1)
 1114       format (a,4x,2(f10.2,2x,a,1x),3f10.2,f10.1)
 1214       format (a,4x,2(f10.1,2x,a,1x),f10.2,3f10.1)
 1105       format (a,2x,2(f10.2,2x,a,1x),3f10.2,f10.1)
 1205       format (a,2x,2(f10.1,2x,a,1x),f10.2,3f10.1)
          endif
          call eddisp(itru,outs)
 30     continue

C Close off markdown table.
        if(markdown)then
          write (outs,'(2a)') 
     &'--------------     -----------  -------------  ----------  ',
     &'------------  -----------  --------  --------  --------'
          call edisp(itru,outs)
        endif

C Generate 'all zones' text.  
C Remember that depending on query the number of hours will be 
C 'greater than' or 'greater than or equal' to the query point.
        if (NX.eq.0) then
          write(outs,'(a)') ' -- No data: probably due to filtering.'
          call edisp(itru,'  ')
          call edisp(itru,outs)
        else
          call edisp(itru,'  ')
          
C Sum all active and occupied periods.
          TActiveTot=0.0
          TOccupTot=0.0
          do I=1,NGET
            TActiveTot=TActiveTot+TActive(I)
            TOccupTot=TOccupTot+TOccup(I)
          enddo

C Calculate total time above and below query value, aggregated over all
C metrics. If there is filtering, take total period as the time occupied.
          if (iocupf.eq.1) then
            if (iabove.gt.0) then
              AXAB=TActiveTot
              AXBE=TOccupTot-TActiveTot
            else
              AXBE=TActiveTot
              AXAB=TOccupTot-TActiveTot
            endif
          else
            if (iabove.gt.0) then
              AXAB=TActiveTot
              AXBE=(TFINSH-(TSTART-1.0))*NGET-TActiveTot
            else
              AXBE=TActiveTot
              AXAB=(TFINSH-(TSTART-1.0))*NGET-TActiveTot
            endif
          endif 
          APXAB=(AXAB/(AXAB+AXBE))*100.
          APXBE=(AXBE/(AXAB+AXBE))*100.
          if (iabove.gt.0) then
            write (outs,1104) 'Total number of hours',
     &        ' greater than query point:',AXAB,'  (',APXAB,'%)'
            call edisp(itru,outs)
            write (outs,1104) 'Total number of hours',
     &        ' less than or equal to query point:',AXBE,
     &        '  (',APXBE,'%)'
            call edisp(itru,outs)
          else
            write (outs,1104) 'Total number of hours',
     &        ' less than query point:',AXBE,'  (',APXBE,'%)'
            call edisp(itru,outs)
            write (outs,1104) 'Total number of hours',
     &        ' greater than or equal to query point:',AXAB,
     &        '  (',APXAB,'%)'
            call edisp(itru,outs)
          endif
 1104     format (a,a,f10.2,a,f5.1,a)
        endif
      endif

C Switch the text display back to proportional font.
      IMFS=lastmenufont
      ITFS=lasttextfont    ! reset to proportional font in text feedback
      IFS=lastbuttonfont
      call userfonts(IFS,ITFS,IMFS)

C Allow other/ re- display?
      if(act(1:1).eq.'p')then
        return
      else
        goto 1
      endif

      END

C ******************** MOEDMDS ********************
C MOEDMDS: energy demands (radiant + convective) integrated over the
C assessment period and number of hours required. 
C Called by IPV report if act = 'i'
C Called by normal stats if act = '-'
C Also called by recovert if act = 'p' << needs checking >>

      SUBROUTINE MOEDMDS(act,the,tzhtime,tce,tzctime,tlhe,tzlhtime,
     &  tlce,tzlctime)
#include "building.h"
#include "geometry.h"
      
      integer lnblnk  ! function definition

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/OUTPCH/ICOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS

      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV

      COMMON/GETPIK/NGET,IGETNO(MZS,9)
      common/getmenu/menutype,igetind(65),igetflux(65)
      COMMON/GRTOOL/IHFLAG,IDHFLG,ILFLAG
      common/exporttg/xfile,tg,delim
      character xfile*144,tg*1,delim*1

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      COMMON/GET2/XDUM(MTS),XDUM1(MTS),GVAL(MTS)
      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)
      COMMON/SIMPKA/NSIM
      COMMON/ZONPIK/NZ,NZNO(MCOM)

      COMMON/EXPORTI/ixopen,ixunit,ixpunit

C Markdown flag.
      logical markdown
      common/markdownflag/markdown

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext

C High level control scope key words.
      character hcffpattern*12    ! heat, cool, or heat+cool plus detail
      common/hlcontrol/hcffpattern(2)     
      common/recov03/recovery_active
      logical recovery_active

      character prompt*124,outs*148,outsd*148,prompte*124
      CHARACTER RSNAME*40
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      CHARACTER PDESCR*64,SDESCR*44,act*1
      DIMENSION YDUM(MTS),YAGRHT(MTS),YAGRCL(MTS)
      logical close

C Bookkeepping variables.
      real THE,TCE,tzhtime,tzctime
      real TLHE,TLCE,tzlhtime,tzlctime
      real ZHE,ZCE,zhtime,zctime,ZLHE,ZLCE,zlhtime,zlctime
      integer AGRHTSTEPS,AGRCLSTEPS

C If output to file alter the edisp unit number.
      prompt = ' '
      if (act(1:1).ne.'i') then
        itru = icout
        if(ixopen.eq.1)then
          itru = ixunit
        endif
      else
        itru = icout
        if(ixopen.eq.1)then
          itru = ixunit
        endif
      endif

C Set all returned data to zero.
      THE=0.0  ! total sensible heating
      TCE=0.   ! total sensible cooling
      tzhtime=0.
      tzctime=0.

      TLHE=0.  ! total latent humidification
      TLCE=0.  ! total latent dehumidification
      tzlhtime=0.
      tzlctime=0.

C Call the menu of choices (this also sets some default options).
      if(act(1:1).ne.'i') then
        MENUTYPE=10
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif
        else
          itru = icout
        endif
        if (MENUTYPE.eq.-1) return
      else
        if(NGET.ge.1)then
          write(prompt,'(3a)') 'Scanning ',
     &      SLABEL(1)(1:LNSLABEL(1)),'...'
        else
          write(prompt,'(a)') 'Scanning...' 
        endif
      endif
      write(prompte,'(2a)') prompt(1:lnblnk(prompt)),'done.'

C Switch to fixed font for text feedback.
      lastmenufont=IMFS
      lastbuttonfont=IFS
      lasttextfont=ITFS
      if(ITFS.eq.4) ITFS=0
      if(ITFS.eq.5) ITFS=1
      if(ITFS.eq.6) ITFS=2
      if(ITFS.eq.7) ITFS=3
      call userfonts(IFS,ITFS,IMFS)

C Energy requirements.
      ISET=ISIM
      if(act(1:1).ne.'i') then
        CALL HDDATE(PDESCR)
        CALL HDSTEP(SDESCR)
        lsn1=MIN0(lnblnk(RFILE),42)
        if((.NOT.libheading).and.(.NOT.headingcontext))then
          libheading=.true.; headingcontext=.true.
          if(NSIM.gt.1)then
            if(markdown)then
              write(outs,'(2a)') '# Performance Report for ',
     &          RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM)))
              call edisp(itru,outs)
    
              write(outs,'(3A,I4)')'### Library ',RFILE(1:lsn1),
     &          ' Set:',ISIM
              call edisp(itru,outs)
            else
              write(outs,'(3A,I4,3A)')'Results library: ',
     &          RFILE(1:lsn1),'; results set:',
     &          ISIM,' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
              call edisp(itru,outs)
            endif
          else
            if(markdown)then
              write(outs,'(2a)') '# Performance Report for ',
     &          RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM)))
              call edisp(itru,outs)
              write(outs,'(2A)')'### Library ',RFILE(1:lsn1)
              call edisp(itru,outs)
            else
              write(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &        '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
              call edisp(itru,outs)
            endif
          endif
          if(markdown)then
            write(outs,'(4A)')'### ',PDESCR(1:lnblnk(PDESCR)),' ',
     &        SDESCR(12:lnblnk(SDESCR))
          else
            write(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &        SDESCR(12:lnblnk(SDESCR))
          endif
          call edisp(itru,outs)
        endif

        call edisp(itru,' ')
        if(markdown)then
          call edisp(itru,'## Zone energy requirements summary')
          call edisp(itru,': Zone energy requirements summary')
          call edisp(itru,' ')
        else
          call edisp(itru,' Zone energy requirements summary')
        endif

        if(markdown)then
          call edisp(itru,' ')
          if(hcffpattern(1)(1:8).eq.'HEATONLY')then
            write(outs,'(2A)')
     &'--- -------------  -------- --------- --------   ',
     &'--------------  --------------  '
            call edisp(itru,outs)
            write(outs,'(2A)')
     &'    Zone           Sensible Sensible  Sensible   ',
     &'Humidification  Humidification  '
            call edisp(itru,outs)
            write(outs,'(2A)')
     &' id name           heating  heating   heating    ',
     &'energy          hours           '
            call edisp(itru,outs)
            write(outs,'(2A)')
     &'                   kWhrs    kWhrs/m2  hours      ',
     &'kWhrs           required        '
            call edisp(itru,outs)
          elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
            write(outs,'(3A)')
     &'--- -------------  --------  -------- --------  ',
     &'----------------  ----------------'
            call edisp(itru,outs)
            write(outs,'(2A)')
     &'    Zone           Sensible  Sensible Sensible  ',
     &'Dehumidification  Dehumidification'
            call edisp(itru,outs)
            write(outs,'(2A)')
     &' id name           cooling   cooling  cooling   ',
     &'energy            hours'
            call edisp(itru,outs)
            write(outs,'(2A)')
     &'                   kWhrs     kWhrs/m2 hours     ',
     &'kWhrs             required'
            call edisp(itru,outs)
          elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &           hcffpattern(1)(1:7).eq.'UNKNOWN')then
            write(outs,'(3A)')
     &'--- -------------  -------- --------- --------   --------  ',
     &'-------- --------  --------------  --------------  ',
     &'----------------  ----------------'
            call edisp(itru,outs)
            write(outs,'(3A)')
     &'    Zone           Sensible Sensible  Sensible   Sensible  ',
     &'Sensible Sensible  Humidification  Humidification  ',
     &'Dehumidification  Dehumidification'
            call edisp(itru,outs)
            write(outs,'(3A)')
     &' id name           heating  heating   heating    cooling   ',
     &'cooling  cooling   energy          hours           ',
     &'energy            hours'
            call edisp(itru,outs)
            write(outs,'(3A)')
     &'                   kWhrs    kWhrs/m2  hours      kWhrs     ',
     &'kWhrs/m2 hours     kWhrs           required        ',
     &'kWhrs             required'
            call edisp(itru,outs)
          endif
        else
          if(ilflag.eq.0.or.ilflag.eq.2)then
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(2A)')
     &'    Zone                 Sensible heating        ',
     &'Humidification '
              call edisp(itru,outs)
              write(outs,'(2A)')
     &' id name                 Energy       Hours      ',
     &'Energy   Hours '
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'                     kWhrs  kWhrs/m2 required    ',
     &'kWhrs  required'
              call edisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(2A)')
     &'    Zone                 Sensible ',
     &'cooling         Dehumidification'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &' id name                 Energy   ',
     &'    Hours       Energy  Hours'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'                     kWhrs  kWhrs/',
     &'m2 required     kWhrs  required'
              call edisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
              write(outs,'(2A)')
     &'    Zone                 Sensible heating            Sensible ',
     &'cooling         Humidification    Dehumidification'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &' id name                 Energy       Hours          Energy   ',
     &'    Hours       Energy   Hours    Energy  Hours'
              call edisp(itru,outs)
              write(outs,'(2A)')
     &'                     kWhrs  kWhrs/m2 required    kWhrs  kWhrs/',
     &'m2 required     kWhrs  required   kWhrs  required'
              call edisp(itru,outs)
            endif
          elseif(ilflag.eq.1)then

C User requested single line header, use the current separator.
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(3A)')
     &          'Id Zone_name Sens_heat_kWh Sens_heat_kWhm2 ',
     &          'Heat_hrs  ','Humid_kWh Humid_hrs'
              call SDELIM(outs,outsd,delim,IW)
              call edisp(itru,outsd)
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(3A)')
     &          'Id Zone_name ','Sens_cool_kWh Sens_cool_kWhm2 ',
     &          'Cool_hrs Dehumid_kWh Dehumid_hrs'
              call SDELIM(outs,outsd,delim,IW)
              call edisp(itru,outsd)
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
              write(outs,'(3A)')
     &          'Id Zone_name Sens_heat_kWh Sens_heat_kWhm2 ',
     &          'Heat_hrs Sens_cool_kWh Sens_cool_kWhm2 ',
     &          'Cool_hrs Humid_kWh Humid_hrs Dehumid_kWh Dehumid_hrs'
              call SDELIM(outs,outsd,delim,IW)
              call edisp(itru,outsd)
            endif
          endif
        endif
      endif

C Find the number of hours represented by an output timestep.
      TFACT=FLOAT(NOUT)/FLOAT(NTS)

C For each requested zone and for every computational time-step, get
C results for complete day.
      ZBA=0.0  ! reset aggregate base area for 'all' summary.
      DO 65 J=1,NZ
        IZ=NZNO(J)
        ZHE=0.0; ZCE=0.0; ZLHE=0.0; ZLCE=0.0
        zhtime=0.0; zctime=0.0; zlhtime=0.0; zlctime=0.0
        ZBA=ZBA+ZBASEA(IZ)  ! increment total base area
        DO 55 I=IODS,IODF
          ID=I
          NEL=0

C Get the zone plant flux and average if required.
          CALL GZQM(ID,IZ,ISET)
          CALL FLTIAV(ID,GVAL,YDUM,NEL)

C Calcalate the sums and statistics to display during relevant period.
          CALL CHKTIME(ID,ISTART,IEND)
          CALL SUM1V(YDUM,ISTART,IEND,SGT,SLT,IGT,IEQ,ILT)
          ZHE=ZHE+(SGT/1000.)
          ZCE=ZCE+(SLT/1000.)
          ZHTIME=ZHTIME+FLOAT(IGT)*TFACT
          Zctime=Zctime+FLOAT(ILT)*TFACT

C Get zone humidification flux and average if required.
          CALL GZLLH(ID,IZ,ISET)
          CALL FLTIAV(ID,GVAL,YDUM,NEL)

C Calcalate the sums and statistics to display during relevant period.
          CALL CHKTIME(ID,ISTART,IEND)
          CALL SUM1V(YDUM,ISTART,IEND,SGT,SLT,IGT,IEQ,ILT)
          ZLHE=ZLHE+(SGT/1000.)
          ZLHTIME=ZLHTIME+FLOAT(IGT)*TFACT

C Get zone de-humidification flux and average if required.
          CALL GZLLC(ID,IZ,ISET)
          CALL FLTIAV(ID,GVAL,YDUM,NEL)

C Calcalate the sums and statistics to display during relevant period.
          CALL CHKTIME(ID,ISTART,IEND)
          CALL SUM1V(YDUM,ISTART,IEND,SGT,SLT,IGT,IEQ,ILT)
          ZLCE=ZLCE+(SLT/1000.)
          zlctime=zlctime+FLOAT(ILT)*TFACT
   55   CONTINUE
        THE=THE+ZHE
        TCE=TCE+ZCE
        TLHE=TLHE+ZLHE
        TLCE=TLCE+ZLCE
        tzhtime=tzhtime+zhtime
        tzctime=tzctime+zctime
        tzlhtime=tzlhtime+zlhtime
        tzlctime=tzlctime+zlctime
        if(act(1:1).ne.'i') then
          if(markdown)then
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(I3,1x,a12,f11.2,f9.2,f10.1,f13.2,f16.1)')
     &        IZ,zname(IZ),ZHE,ZHE/ZBASEA(IZ),ZHTIME,ZLHE,ZLHTIME
              call eddisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(I3,1x,a12,f11.2,f9.2,f10.1,f13.2,f16.1)')
     &        IZ,zname(IZ),ZCE,ZCE/ZBASEA(IZ),Zctime,ZLCE,zlctime
              call eddisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
        write(outs,'(I3,1x,a12,2(f11.2,f9.2,f10.1),2(f16.2,f16.1))')
     &        IZ,zname(IZ),ZHE,ZHE/ZBASEA(IZ),ZHTIME,ZCE,ZCE/ZBASEA(IZ),
     &        Zctime,ZLHE,ZLHTIME,ZLCE,zlctime
              call eddisp(itru,outs)
            endif
          else
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(I3,1x,a12,f11.2,f9.2,f8.1,f12.2,f8.1)')
     &          IZ,zname(IZ),ZHE,ZHE/ZBASEA(IZ),ZHTIME,ZLHE,ZLHTIME
              call eddisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(I3,1x,a12,f11.2,f9.2,f8.1,f12.2,f8.1)')
     &          IZ,zname(IZ),ZCE,ZCE/ZBASEA(IZ),Zctime,ZLCE,zlctime
              call eddisp(itru,outs)
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
             write(outs,'(I3,1x,a12,2(f11.2,f9.2,f8.1),2(f11.2,f8.1))')
     &       IZ,zname(IZ),ZHE,ZHE/ZBASEA(IZ),ZHTIME,ZCE,ZCE/ZBASEA(IZ),
     &       Zctime,ZLHE,ZLHTIME,ZLCE,zlctime
             call eddisp(itru,outs)
            endif
          endif
        endif
   65 CONTINUE
      if(act(1:1).ne.'i') then
        if(THE.gt.99999.0.or.TCE.lt.-99999.0)then
          if(markdown)then
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(a,f11.1,f9.1,f10.0,f12.1,f16.0)') 
     &        '    All        ',THE,THE/ZBA,tzhtime,TLHE,tzlhtime
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(a,f11.1,f9.1,f10.0,f12.1,f16.0)') 
     &        '    All        ',TCE,TCE/ZBA,tzctime,TLCE,tzlctime
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
             write(outs,'(a,2(f11.1,f9.1,f10.0),2(f16.1,f16.0))') 
     &       '    All        ',THE,THE/ZBA,tzhtime,TCE,
     &       TCE/ZBA,tzctime,TLHE,tzlhtime,TLCE,tzlctime
            endif
          else
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(a,f11.1,f9.1,f8.0,f11.1,f8.0)') 
     &        '    All        ',THE,THE/ZBA,tzhtime,TLHE,tzlhtime
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(a,f11.1,f9.1,f8.0,f11.1,f8.0)') 
     &        '    All        ',TCE,TCE/ZBA,tzctime,TLCE,tzlctime
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
             write(outs,'(a,2(f11.1,f9.1,f8.0),2(f11.1,f8.0))') 
     &       '    All        ',THE,THE/ZBA,tzhtime,TCE,
     &       TCE/ZBA,tzctime,TLHE,tzlhtime,TLCE,tzlctime
            endif
          endif
        else
          if(markdown)then
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(a,f11.1,f9.1,f10.0,f13.1,f17.1)')
     &        '    All        ',THE,THE/ZBA,tzhtime,TLHE,tzlhtime
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(a,f11.1,f9.1,f10.0,f13.1,f17.1)')
     &        '    All        ',TCE,TCE/ZBA,tzctime,TLCE,tzlctime
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
             write(outs,'(a,2(f11.1,f9.1,f10.0),2(f16.1,f16.1))')
     &       '    All        ',THE,THE/ZBA,tzhtime,TCE,
     &       TCE/ZBASEA(IZ),tzctime,TLHE,tzlhtime,TLCE,tzlctime
            endif
          else
            if(hcffpattern(1)(1:8).eq.'HEATONLY')then
              write(outs,'(a,f11.1,f9.1,f8.0,f12.1,f9.1)')
     &        '    All        ',THE,THE/ZBA,tzhtime,TLHE,tzlhtime
            elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
              write(outs,'(a,f11.1,f9.1,f8.0,f12.1,f9.1)')
     &        '    All        ',TCE,TCE/ZBA,tzctime,TLCE,tzlctime
            elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &             hcffpattern(1)(1:7).eq.'UNKNOWN')then
             write(outs,'(a,2(f11.1,f9.1,f8.0),2(f11.1,f8.1))')
     &       '    All        ',THE,THE/ZBA,tzhtime,TCE,
     &       TCE/ZBA,tzctime,TLHE,tzlhtime,TLCE,tzlctime
            endif
          endif
        endif
        if(.NOT.markdown) call edisp(itru,' ')
        call eddisp(itru,outs)
        if(markdown)then
          if(hcffpattern(1)(1:8).eq.'HEATONLY')then
            write(outs,'(2A)')
     &'--- -------------  -------- --------- --------   ',
     &'--------------  --------------  '
          elseif(hcffpattern(1)(1:8).eq.'COOLONLY')then
            write(outs,'(3A)')
     &'--- -------------  --------  -------- --------  ',
     &'----------------  ----------------'
          elseif(hcffpattern(1)(1:8).eq.'HEATCOOL'.or.
     &           hcffpattern(1)(1:7).eq.'UNKNOWN')then
            write(outs,'(3A)')
     &'--- -------------  -------- --------- --------   --------  ',
     &'-------- --------  --------------  --------------  ',
     &'----------------  ----------------'
          endif
          call edisp(itru,outs)
        endif
        call edisp(itru,' ')
      endif

C Find the aggregate number of hours heating used (considered true for a
C timestep if any zone needs heating. So for the current day loop through
C each timestep, at each timestep check if any zone heating is non-zero.
      AGRHTSTEPS=0; AGRCLSTEPS=0  ! reset counters
      DO I=1,MTS
        YAGRHT(I)=0.0  ! clear heat array for the day
        YAGRCL(I)=0.0  ! clear cool array for the day
      ENDDO
      DO I=IODS,IODF   ! loop each day
        ID=I
        NEL=0
        DO J=1,NZ      ! and for each zone
          IZ=NZNO(J)

C Get the zone plant flux and average if required. Array YDUM has
C the values for the day. Copy into the YAGRHT or HAGRCL as appropriate
          CALL GZQM(ID,IZ,ISET)
          CALL FLTIAV(ID,GVAL,YDUM,NEL)
          CALL CHKTIME(ID,ISTART,IEND)
          DO K=ISTART,IEND  ! and for each timestep
            call eclose(YDUM(K),0.0,0.001,close)
            if(.NOT.close)then
              if(YDUM(K).lt.0.0) YAGRCL(K)=YAGRCL(K)+YDUM(K)
              if(YDUM(K).gt.0.0) YAGRHT(K)=YAGRHT(K)+YDUM(K)
            endif
          ENDDO ! of K for each timestep
        ENDDO   ! of J for each zone

C Having looped through all the zones now loop through YAGRCL
C and YAGRHT and if non-zero increment.
        DO L=ISTART,IEND  ! and for each timestep
          call eclose(YAGRCL(L),0.0,0.001,close)
          if(.NOT.close) AGRCLSTEPS=AGRCLSTEPS+1
          call eclose(YAGRHT(L),0.0,0.001,close)
          if(.NOT.close) AGRHTSTEPS=AGRHTSTEPS+1
        ENDDO   ! of timesteps in day

C Clear the day array.
        DO M=1,MTS
          YAGRHT(M)=0.0  ! clear heat array for the day
          YAGRCL(M)=0.0  ! clear cool array for the day
        ENDDO

      ENDDO    ! of I loop of days.
      if(act(1:1).ne.'i') then
        write(outs,'(f8.1,a)') AGRHTSTEPS*TFACT,
     &  ' hours when heating required in at least one zone.'
        call edisp(itru,outs)
        write(outs,'(f8.1,a)') AGRCLSTEPS*TFACT,
     &  ' hours when cooling required in at least one zone.'
        call edisp(itru,outs)
        if(markdown) call edisp(itru,'  ')
      endif

      if(recovery_active)then
        continue
      else
        call usrmsg(prompte,'  ','P')
      endif
      if(MMOD.eq.8)call usrmsg('  ','  ','-')

      IMFS=lastmenufont
      ITFS=lasttextfont    ! reset to proportional font in text feedback
      IFS=lastbuttonfont
      call userfonts(IFS,ITFS,IMFS)

      return
      end

C ******************** CASDIST ********************

C Reporting of casual gains distribution (radiant and convective)
C within current zone set.

C << Future update would be to read the explicit radiant gains for
C << each surface if save level 4 so that the zone construction
C << file does not need to be scanned to get the surface emissivity.

      SUBROUTINE CASDIST(act)

#include "building.h"
#include "model.h"
#include "geometry.h"
#include "schedule.h"
      
      integer lnblnk  ! function definition

      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      COMMON/OUTPCH/ICOUT
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS
      COMMON/FILEP/IFIL
      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV
      COMMON/GETPIK/NGET,IGETNO(MZS,9)
      common/getmenu/menutype,igetind(65),igetflux(65)
      common/recver/izver,ipver,iever

      character SLABEL*32,GLABEL*24,TABLABEL*36
      COMMON/GETLABEL/SLABEL(MZS),GLABEL(MZS),TABLABEL(MZS)
      integer LNSLABEL,LNGLABEL,LNTABLABEL  ! lengths for label strings
      COMMON/LNGETLABEL/LNSLABEL(MZS),LNGLABEL(MZS),LNTABLABEL(MZS)
      COMMON/GET1/VAL1(MZS,MTS),VAL2(MZS,MTS),VAL3(MZRL,MTS)

      COMMON/T4/EMISI(MS),EMISE(MS),ABSI(MS),ABSE(MS)

      COMMON/EXPORTI/ixopen,ixunit,ixpunit
      COMMON/RESLIB/RFILE,PFILE,MSTRFILE,LAFRES
      COMMON/SETNAM/RSNAME(MNRS)
      COMMON/SIMPKA/NSIM
      COMMON/ZONPIK/NZ,NZNO(MCOM)

      logical libheading ! have we printed report heading (library name etc).
      logical headingcontext ! has set or period changed so heading needs reprint
      common/libhead/libheading,headingcontext
      common/recov03/recovery_active
      logical recovery_active

      CHARACTER PDESCR*64,SDESCR*44,CSTR*25
      CHARACTER*18 LABELS(13)
      CHARACTER*5 LABSurf(2)
      character outs*124,act*1,prompt*124
      CHARACTER RSNAME*40
      character rfile*72,PFILE*72,MSTRFILE*72,LAFRES*72
      DIMENSION XVAL1(MZS)
      DIMENSION ST(6,10)

C Check for sufficient information.
      IF(ISAVE.le.1)THEN
        CALL EPAGEW
        RETURN
      ENDIF

      LABSurf(1)= ' @opq'
      LABSurf(2)= ' @trn'

C If output to file alter the edisp unit number.
      itru = icout
      prompt = ' '
      if(ixopen.eq.1)then
        itru = ixunit
      endif

C Call the menu of choices (this also sets some default options).
      if(act(1:1).eq.'-') then
        MENUTYPE=11
        call GOMSETUP
        call GOMENU
        if(ixopen.eq.1)then
          itru = ixunit
          if(NGET.ge.1)then
            write(prompt,'(a,a)') SLABEL(1)(1:LNSLABEL(1)),' >> file.'
          else
            write(prompt,'(a)')' Output being directed to file. ' 
          endif
        else
          itru = icout
        endif
        if (MENUTYPE.eq.-1) return
      endif

C Switch to fixed font for text feedback.
      lastmenufont=IMFS
      lastbuttonfont=IFS
      lasttextfont=ITFS
      if(ITFS.eq.4) ITFS=0
      if(ITFS.eq.5) ITFS=1
      if(ITFS.eq.6) ITFS=2
      if(ITFS.eq.7) ITFS=3
      call userfonts(IFS,ITFS,IMFS)
 
C Energy requirements.
      if(recovery_active)then
        continue
      else
        call usrmsg(prompt,'Scanning for range of values...','-')
      endif
      ISET=ISIM
      CALL HDDATE(PDESCR)
      CALL HDSTEP(SDESCR)
      lsn1=MIN0(lnblnk(RFILE),42)
      if((.NOT.libheading).and.(.NOT.headingcontext))then
        libheading=.true.; headingcontext=.true.
        if(NSIM.gt.1)then
          write(outs,'(3A,I4,3A)')'Results library: ',
     &      RFILE(1:lsn1),'; results set:',ISIM,
     &      ' (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
        else
          write(outs,'(5A)')'Results library: ',RFILE(1:lsn1),
     &      '; (',RSNAME(ISIM)(1:lnblnk(RSNAME(ISIM))),')'
        endif
        call edisp(itru,outs)
        write(outs,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &   SDESCR(12:lnblnk(SDESCR))
        call edisp(itru,outs)
      endif

C Initialiase variables for totals over all selected zones.
      TPTTOTCG=0.0; TPCV=0.0; TPTTR=0.0; TPTOTE=0.0
      TPTTI=0.0; TPTTG=0.
 
      do 66 ii=1,10
        do 67 ij=1,6
          ST(ij,ii)=0.0
 67     continue
 66   continue

C Read construction files and set up labels.
      DO 65 JZ=1,NZ
        izone=NZNO(JZ)
        iunit=ifil+1
        CALL ECONST(LTHRM(IZONE),IUNIT,izone,0,IUOUT,IER)

C Update labels to match the current zone.
        write(LABELS(1),'(1x,a)')lodlabel(izone,1)
        write(LABELS(2),'(1x,a)')lodlabel(izone,1)
        write(LABELS(3),'(1x,a)')lodlabel(izone,2)
        write(LABELS(4),'(1x,a)')lodlabel(izone,2)
        write(LABELS(5),'(1x,a)')lodlabel(izone,3)
        write(LABELS(6),'(1x,a)')lodlabel(izone,3)
        if(lodslot(izone,4).ne.0)then
          write(LABELS(7),'(1x,a)')lodlabel(izone,4)
          write(LABELS(8),'(1x,a)')lodlabel(izone,4)
        else
          write(LABELS(7),'(1x,a)')'--'
          write(LABELS(8),'(1x,a)')'--'
        endif
        write(LABELS(9),'(a)') ' Ctl cas'
        write(LABELS(10),'(a)')' Ctl cas'
        write(LABELS(11),'(a)')' Totals'

C Output general header information.
        write(outs,'(3a,i3,a)')
     &    ' Casual gains distribution (kWhrs) for ',
     &    zname(IZONE)(1:lnzname(IZONE)),' (',IZONE,')'
        call edisp(itru,' ')
        call edisp(itru,outs)

C If izver >= 4 reads data directly so zone operation file not necessary.
        if(izver.eq.4)then
          continue
        else

C Prepare to recover information from results library.
          IUNIT=IFIL+1
          CALL EROPER(0,iuout,iunit,izone,IER)  ! for older results library
          if(ip3ver(izone).eq.0)then
            write(outs,'(a,i3,a)') 
     &      'Operation file for zone ',izone,' periods being sorted!'
            call edisp(iuout,outs)
            call PROCESSOLDCAS(izone,0,iuout)
          endif
          IF(IER.EQ.1)RETURN
          IF(ICGC(IZONE).EQ.1)CALL ercgcf(0,iuout,LCGCIN(izone),
     &      IZONE,ier)
        endif

        N=24*NTS
        TCMULT=FLOAT(NOUT)/(FLOAT(NTS)*1000.)
        NN=NZSUR(IZONE)

C IGT is number of occupied timesteps, IGTL is number of lighting timesteps, IGTS
C is number of small power timesteps, IGTOTH other timesteps, IGTC
C is controlled timesteps.
        IGT=0; IGTL=0; IGTS=0; IGTOTH=0; IGTC=0
        ZOTIME=0.0; ZLTIME=0.0; ZSTIME=0.0; ZOTHTIME=0.0; ZCTIME=0.0

C Find the number of hours represented by an output timestep.
        TFACT=FLOAT(NOUT)/FLOAT(NTS)

C Radiant casual gains are area AND emissivity weighted.
        emarea=0.0
        do 80 kk=1,NN
          emarea=emarea+sna(izone,kk)*EMISI(kk)
  80    continue

C Initialise summation locations: VAL1(I,J).
        DO 202 I=1,MZS
          XVAL1(I)=0.
          DO 201 J=1,N
            VAL2(I,J)=0.
  201     CONTINUE
  202   CONTINUE

C Find the total surface area * emissivity in each surface
C connection class. << This could be simplified with new izver. >>
        SURFAE=0.0; SURFAI=0.0; SURFAG=0.0; SURFTE=0.0; SURFTG=0.0
        SURFTI=0.0
        DO 210 ISN= 1,NN
          CALL SURADJ(IZONE,ISN,IE,T,IZC,ISC,ICN,CSTR)
          IF(IE.EQ.0)THEN
            if(SOTF(IZONE,ISN)(1:4).EQ.'OPAQ'.OR.
     &         SOTF(IZONE,ISN)(1:4).EQ.'UNKN')THEN
              SURFAE=SURFAE+SNA(IZONE,ISN)*EMISI(ISN)
            else
              SURFTE=SURFTE+SNA(IZONE,ISN)*EMISI(ISN)
            endif
          ELSEIF(IE.EQ.4)THEN
            if(SOTF(IZONE,ISN)(1:4).EQ.'OPAQ'.OR.
     &         SOTF(IZONE,ISN)(1:4).EQ.'UNKN')THEN
              SURFAG=SURFAG+SNA(IZONE,ISN)*EMISI(ISN)
            else
              SURFTG=SURFTG+SNA(IZONE,ISN)*EMISI(ISN)
            endif
          ELSE
            if(SOTF(IZONE,ISN)(1:4).EQ.'OPAQ'.OR.
     &         SOTF(IZONE,ISN)(1:4).EQ.'UNKN')THEN
              SURFAI=SURFAI+SNA(IZONE,ISN)*EMISI(ISN)
            else
              SURFTI=SURFTI+SNA(IZONE,ISN)*EMISI(ISN)
            endif
          ENDIF
  210   CONTINUE

C Day-by-day recovery.
        DO 30 IDAY=IODS,IODF
          CALL CHKTIME(IDAY,ISTART,IEND)

C Clear VAL1.
          DO 18 I=1,MZS
            DO 19 II=ISTART,IEND
              VAL1(I,II)=0.
   19       CONTINUE
   18     CONTINUE

C For requested zone and day get convective casual gains results.
C If type one casual > 0. then occupied during timestep (and increment
C IGTL, IGTS, IGTOTH, IGTC. Stuff data into VAL1(1,I) to VAL1(5,I)
          CALL ZCASC(IZONE,IDAY)
          DO 50, I=1,IEND
            VAL1(1,I)=VAL3(15,I)
            if(I.ge.ISTART.and.VAL1(1,I).gt.0.0)IGT=IGT+1
            VAL1(2,I)=VAL3(16,I)
            if(I.ge.ISTART.and.VAL1(2,I).gt.0.0)IGTL=IGTL+1
            VAL1(3,I)=VAL3(17,I)
            if(I.ge.ISTART.and.VAL1(3,I).gt.0.0)IGTS=IGTS+1
            VAL1(4,I)=VAL3(18,I)
            if(I.ge.ISTART.and.VAL1(4,I).gt.0.0)IGTOTH=IGTOTH+1
            VAL1(5,I)=VAL3(19,I)+VAL3(20,I)+VAL3(21,I)+VAL3(22,I)
            if(I.ge.ISTART.and.VAL3(19,I).gt.0.0)IGTC=IGTC+1
            if(I.ge.ISTART.and.VAL3(20,I).gt.0.0)IGTC=IGTC+1
            if(I.ge.ISTART.and.VAL3(21,I).gt.0.0)IGTC=IGTC+1
            if(I.ge.ISTART.and.VAL3(22,I).gt.0.0)IGTC=IGTC+1
   50     CONTINUE

C Get casual radiant amount for all surfaces and store uncontrolled
C and controlled types 1,2,3 4 in VAL1(6,I) to VAL1(10,I).
          do 52 ISS=1,NN
            CALL ZCASR(IZONE,ISS,IDAY)
            DO 28 I=1,N
              VAL1(6,I)=VAL1(6,I)+VAL3(15,I)
              VAL1(7,I)=VAL1(7,I)+VAL3(16,I)
              VAL1(8,I)=VAL1(8,I)+VAL3(17,I)
              VAL1(9,I)=VAL1(9,I)+VAL3(18,I)
              VAL1(10,I)=
     &          VAL1(10,I)+VAL3(19,I)+VAL3(20,I)+VAL3(21,I)+VAL3(22,I)
   28       CONTINUE
   52     continue

          DO 400 J=ISTART,IEND,NOUT
            JT=J

C Compute average of VAL1() based on IAV.
            CALL VALIAV(10,JT,XVAL1)

C Sum to VAL2 for printing.
            DO 410 K=1,10
              VAL2(K,1)=VAL2(K,1)+XVAL1(K)*TCMULT
  410       CONTINUE
  400     CONTINUE
   30   CONTINUE

C Find number of hours for occupants, lights, small power, controlled.
        ZOTIME=FLOAT(IGT)*TFACT
        ZLTIME=FLOAT(IGTL)*TFACT
        ZSTIME=FLOAT(IGTS)*TFACT
        ZOTHTIME=FLOAT(IGTOTH)*TFACT
        ZCTIME=FLOAT(IGTC)*TFACT

C Print the data and labels for uncontrolled casual gains.
        write(outs,128)
  128   format(' Gains     |   Total   | Convective|    Radiative  |',
     &         '        Radiant by connection type')
        call edisp(itru,outs)
        write(outs,1281)
 1281   format(' type      | (Con+Rad) | part (air)|     on surf   |',
     &         '    external    internal     ground ')
        call edisp(itru,outs)

C Split radiant by surface connection type, begin by multiplying
C each casual by total surface area for that connnection type
C and dividing by the zone opaque area.  Write it out and then
C sum it to TOT0 etc.
        IRLC=10

        TR=0.0; TOR=0.0; TTR=0.0; TOTE=0.0
        TTI=0.0; TTG=0.0; TTOTCG=0.0
        DO 420 IR=6,IRLC

C Apply radiant by surface groupings.
          CE =VAL2(IR,1)*SURFAE/emarea
          CTE=VAL2(IR,1)*SURFTE/emarea
          CI =VAL2(IR,1)*SURFAI/emarea
          CTI=VAL2(IR,1)*SURFTI/emarea
          CG =VAL2(IR,1)*SURFAG/emarea
          CTG=VAL2(IR,1)*SURFTG/emarea
          TOR=CE+CI+CG
          TR =CTE+CTI+CTG

          TOTCG=VAL2(IR-5,1) + TOR + TR

C Update IR.
          IF(IR.EQ.6)IRL=1
          IF(IR.EQ.7)IRL=3
          IF(IR.EQ.8)IRL=5
          IF(IR.EQ.9)IRL=7
          IF(IR.EQ.10)IRL=9

          write(outs,126)LABELS(IRL)(1:12),TOTCG,VAL2(IR-5,1),
     &                   TOR,LABSurf(1),CE,CI,CG
          call edisp(itru,outs)
          write(outs,127) TR, LABSurf(2),CTE,CTI,CTG
          call edisp(itru,outs)
          TTR=TTR+CE+CI+CG+CTE+CTI+CTG
          TOTE=TOTE+CE+CTE
          TTI=TTI+CI+CTI
          TTG=TTG+CG+CTG
          TTOTCG=TTOTCG+TOTCG

C Add each value to have the sub-total over all the selected zones
          ST(IR-5,1)=ST(IR-5,1)+TOTCG
          ST(IR-5,2)=ST(IR-5,2)+VAL2(IR-5,1)
          ST(IR-5,3)=ST(IR-5,3)+TOR
          ST(IR-5,4)=ST(IR-5,4)+CE
          ST(IR-5,5)=ST(IR-5,5)+CI
          ST(IR-5,6)=ST(IR-5,6)+CG
          ST(IR-5,7)=ST(IR-5,7)+TR
          ST(IR-5,8)=ST(IR-5,8)+CTE
          ST(IR-5,9)=ST(IR-5,9)+CTI
          ST(IR-5,10)=ST(IR-5,10)+CTG
  420   CONTINUE

C Totals:
        CV=VAL2(1,1)+VAL2(2,1)+VAL2(3,1)+VAL2(4,1)+VAL2(5,1)

        write(outs,118)' Totals    ',TTOTCG,CV,TTR,TOTE,TTI,TTG
        call edisp(itru,outs)

  126   format(A,3F12.2,A,3F12.2)
  127   format(36X,F12.2,A,3F12.2)
  118   format(A,3F12.2,4x,3F12.2)

        write(outs,'(a,f9.2)') ' Number of hours occupied: ',ZOTIME
        call edisp(itru,outs)
        write(outs,'(a,f9.2)') ' Number of hours with lights: ',ZLTIME
        call edisp(itru,outs)
        write(outs,'(a,f9.2)') ' Number of hours with small power: ',
     &    ZSTIME
        call edisp(itru,outs)
        write(outs,'(a,f9.2)') ' Number of hours with other gains: ',
     &    ZOTHTIME
        call edisp(itru,outs)
        write(outs,'(a,f9.2)') ' Number of hours with ctld gains: ',
     &    ZCTIME
        call edisp(itru,outs)

C Total of 'Totals' over selected zones    
        TPTTOTCG=TPTTOTCG+TTOTCG
        TPCV=TPCV+CV
        TPTTR=TPTTR+TTR
        TPTOTE=TPTOTE+TOTE
        TPTTI=TPTTI+TTI
        TPTTG=TPTTG+TTG
  65  continue

C Display the total over all selected zones
      IF((JZ.EQ.NZ+1).AND.(NZ.GT.1)) THEN
C Output general header information.
        call edisp(itru,'  ')
        call edisp(itru,
     &    ' Casual gains distribution (kWhrs) for ALL SELECTED ZONES')

C Print the data and labels for uncontrolled casual gains.
        write(outs,'(2a)')
     &    ' Gains      |   Total   | Convective|    Radiative  | ',
     &    '       Radiant by connection type'
        call edisp(itru,outs)
        write(outs,'(2a)')
     &    ' type       | (Con+Rad) | part (air)|     on surf   | ',
     &    '    external    internal     ground '
        call edisp(itru,outs)
        DO 520 IIR=6,IRLC
          IF(IIR.EQ.6)IRL=1
          IF(IIR.EQ.7)IRL=3
          IF(IIR.EQ.8)IRL=5
          IF(IIR.EQ.9)IRL=7
          IF(IIR.EQ.10)IRL=9
          write(outs,226)LABELS(IRL)(1:12),ST(IIR-5,1),ST(IIR-5,2),
     &      ST(IIR-5,3),LABSurf(1),ST(IIR-5,4),ST(IIR-5,5),ST(IIR-5,6)
          call edisp(itru,outs)

          write(outs,227)ST(IIR-5,7),LABSurf(2),ST(IIR-5,8),ST(IIR-5,9),
     &                   ST(IIR-5,10)
          call edisp(itru,outs)
  520   CONTINUE
        write(outs,218)' Totals    ',TPTTOTCG,TPCV,TPTTR,TPTOTE,TPTTI,
     &    TPTTG
        call edisp(itru,outs)
  226   format(A,3F12.2,A,3F12.2)
  227   format(36X,F12.2,A,3F12.2)
  218   format(A,3F12.2,5x,3F12.2)
      ENDIF

      call edisp(itru,' ')
      call edisp(itru,
     &' (@opq & @trn = associated with opaque or transparent surfaces)')

      IMFS=lastmenufont
      ITFS=lasttextfont    ! reset to proportional font in text feedback
      IFS=lastbuttonfont
      call userfonts(IFS,ITFS,IMFS)

      RETURN
      END
