C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file contains the following routine:
C  plttab: handles plant results view/setup requests
C  selpc: displays a selection list of plant components
C  opnplt: open and scan the plant database for names etc.
C  dbdat: read additional output for a component.
C  fnddat: finds IPC data for given time
C  mosyssu: clears commons/ sets default values for systems plotting.
C  SYSOUTP: display performance (tabular/graphic/stats) of components.

C ******************** PLTTAB ********************
C Handles results view/setup requests for plant.

      subroutine plttab
#include "plant.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      PARAMETER (MSYSRS=20)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/GRTOOL/IHFLAG,IDHFLG,ILFLAG
      common/exporttg/xfile,tg,delim
      COMMON/EXPORTI/ixopen,ixunit,ixpunit
      COMMON/DEFLT/IDEFLT
      COMMON/C9/NPCOMP,NCI(MPCOM),CDATA(MPCOM,MMISCD)

      common/getmenu/menutype,igetind(65),igetflux(65)
C MENUTYPE 1: not used
C MENUTYPE 2: Frequency histogram (not yet working for systems)
C MENUTYPE 3: Time series plot (not yet working for systems)
C MENUTYPE 4: Performance metrics
C MENUTYPE 5: Summary statistics (not yet working for systems)
C MENUTYPE 6: Sensitivity ( ?? )
C MENUTYPE 7: Hours above query point (not yet working for systems)
C MENUTYPE 8: Hours below query point (not yet working for systems)
C MENUTYPE 9: Psychrometric chart

C IPGET = 1 Temperature deg C
C IPGET = 2 1st flow kg/s
C IPGET = 3 2nd flow kg/s
C IPGET = 4 RH %
C IPGET = 5 SH kgv/kga
C IPGET = 6 Enthalpy KJ/Kg
C IPGET = 7 Dew ptT deg C
C IPGET = 9 Ambient temperature
C IPGET = 10 Additional output
C IPGET = 12 Ambient RH

C Up to MSYSRS data can be plotted/listed.
C IPGETNO contains all the information needed for specifying which data to recover
C IPGETNO(*,1): The IPGET number - metric identifier
C << need to think of what indices are what >>
C IPGETNO(*,2): The chosen component (meaning assumed from IPGET) in the
C               case of weather data it gets used to set graphing colour.
C IPGETNO(*,3): The chosen node
C IPGETNO(*,4): ?
C IPGETNO(*,5): Result set number 
C IPGETNO(*,6): Line type
C IPGETNO(*,7): Symbol index
C IPGETNO(*,8): Associated axis (1=temperature, 2=kg/s, 3=%, 4=KJ/Kg
C               5=misc ??)

C Note: there is a common block name clash between pcres as used in
C moplnt.F and the common block pcres used elsewhere. The common
C block in this source file has been renamed pcresres to avoid
C this clash.
      COMMON/MSYSPICK/NPGET,IPGETNO(MSYSRS,8)
      common/pcnam/pcname(mpcom)
      common/adopdesc/adopdsc(mpcom,MPCRES)
      common/pcresres/ napout(mpcom),apcout(MPCRES)
      common/pcdat/ CSV1M(mnodec),CSV2M(mnodec),CSV3M(mnodec),
     &              NNODE(mpcom),nrecpc(mpcom)
      common/ntype/isv(mpcom,mnodec)
      COMMON/SYSLABEL/SPLABEL(MSYSRS),GPLABEL(MSYSRS)

      dimension mcomp(mpcom), ipcndx(mpcom), ivals(15)
      CHARACTER ITEM(26)*23
      character outs*124,xfile*144,tg*1,delim*1,MTITLE*22
      character pcname*15,pcnam1(mpcom)*15,adopdsc*30
      character aoutstr(15)*30
      character SPLABEL*32,GPLABEL*20,SUFFIX*6,SUFFIX10*10
      character PREFIX*14
      integer IWM  ! for radio button
      integer NITMS,INO ! max items and current menu item

      helpinsub='moplnt'  ! set for subroutine

C Default value for GRTOOL file hourly flag = 0 (off).
      IHFLAG=0

C Initialise.
      ipc=1
      istat=0
      MNGET=1

C MNGET is the maximum number of metrics allowed to be chosen from the menu.
   7  if (MENUTYPE.eq.1) then
        return
      elseif (MENUTYPE.eq.2) then
        MTITLE='Frequency histogram'
        MNGET=1
      elseif (MENUTYPE.eq.3) then
        MTITLE='Parameter plot'
        MNGET=MSYSRS-1
      elseif (MENUTYPE.eq.4) then
        MTITLE='Timestep listing'
        MNGET=13
      elseif (MENUTYPE.eq.5) then
        MTITLE='Summary statistics'
        MNGET=MSYSRS-1
      elseif (MENUTYPE.eq.6) then
        MTITLE='Sensitivity'
        MNGET=1
      elseif (MENUTYPE.eq.7) then
        MTITLE='Hrs above query point'
        MNGET=MSYSRS-1
      elseif (MENUTYPE.eq.8) then
        MTITLE='Hrs below query point'
        MNGET=MSYSRS-1
      elseif (MENUTYPE.eq.9) then
        MTITLE='Psychrometric'
        MNGET=1
      else
        MNGET=1
        MTITLE='  '
      endif

C Setup menu text.
      ITEM(1)  ='2 result set    '
      ITEM(2)  ='3 display period '
      ITEM(3)  ='  __________________   '
      if(MENUTYPE.eq.1)then
       ITEM(4) ='5 output style        '
      elseif(MENUTYPE.eq.2)then
       ITEM(4) ='5 output >> histogram '
      elseif(MENUTYPE.eq.3)then
       ITEM(4) ='5 output >> graph     '
      elseif(MENUTYPE.eq.4)then
       ITEM(4) ='5 output >> tabular   '
      elseif(MENUTYPE.eq.5)then
       ITEM(4) ='5 output >> statistics'
      elseif(MENUTYPE.eq.6)then
       ITEM(4) ='5 output: sensitivity '
      elseif(MENUTYPE.eq.7)then
       ITEM(4) ='5 output >> hours over'
      elseif(MENUTYPE.eq.8)then
       ITEM(4) ='5 output >> hrs below '
      elseif(MENUTYPE.eq.9)then
       ITEM(4) ='5 output >> psychromtrc'
      endif
      ITEM(5)  ='  __________________   '
      item(6)  =' node related...       '
      if(MENUTYPE.eq.9)then
        item(7)  ='a -                    '
        item(8)  ='b -                    '
        item(9)  ='c -                    '
        item(10) ='d -                    '
        item(11) ='e -                    '
        item(12) ='f -                    '
        item(13) ='g -                    '
        item(14) ='  ____________________ '
        item(15) =' special...            '
        item(16) ='h -                    '
        item(17) ='i -                    '
        item(18) ='j -                    '
      else
        item(7)  ='a temperature          '
        item(8)  ='b 1st phase flow       '
        item(9)  ='c 2nd phase flow       '
        item(10) ='d relative humidity%   '
        item(11) ='e specific humidity    '
        item(12) ='f enthalpy             '
        item(13) ='g dew point temperature'
        item(14) ='  ____________________ '
        item(15) =' special...            '
        item(16) ='h additional output    '
        item(17) ='i outside dry bulb T   '
        item(18) ='j ambient RH%          '
      endif
      ITEM(19) ='  __________________   '
      if(ixopen.eq.1)then
        ITEM(20)='> output >> file       '
      elseif(ixopen.eq.0)then
        ITEM(20)='> output >> screen     '
      endif
      if(IHFLAG.eq.0)then
        ITEM(21)='* format >> 10h30      '
      elseif(IHFLAG.eq.1)then
        ITEM(21)='* format >> 0.4375     '
      endif

C << Place toggle for ILFLAG here and revise menu >>
      if(delim.eq.'-')then
        ITEM(22)='^ delim >> normal      '
      elseif(delim.eq.'T')then
        ITEM(22)='^ delim >> TAB         '
      elseif(delim.eq.'C')then
        ITEM(22)='^ delim >> comma       '
      elseif(delim.eq.'S')then
        ITEM(22)='^ delim >> space       '
      elseif(delim.eq.'X')then
        ITEM(22)='^ delim >> tagged      '
      endif
      if(MENUTYPE.eq.3) then
        ITEM(23)='! draw graph           '
      elseif(MENUTYPE.eq.4)then
        ITEM(23)='! list data            '
      elseif(MENUTYPE.eq.9)then
        ITEM(23)='! generate chart       '
      else
        ITEM(23)='! generate reports     '
      endif
      ITEM(24)  ='/ clear selections     '
      ITEM(25)  ='? help                 '
      ITEM(26)  ='- exit menu            '

C Display menu.
      NITMS=26
    2 INO=-2
    5 continue

C Instantiate the help strings for this menu.
      helptopic='res_plant_perf_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU(MTITLE,ITEM,NITMS,INO)

C If separator or blank choice loop back again.
      if(ino.EQ.1.or.ino.EQ.3.or.ino.EQ.5.or.ino.EQ.6.or.ino.EQ.14.or.
     &   ino.EQ.15.or.ino.EQ.19.or.ino.eq.0) goto 2

C If one of the fixed items do what is required.
      if(INO.EQ.2)then
        ideflt=0
        call mooper
        goto 7
      elseif(INO.EQ.4)then
        CALL MOSTYLE
        if(menutype.eq.9)then
          call edisp(iuout,' ')
          call edisp(iuout,'In psychrometric mode, you must')
          call edisp(iuout,'choose `! generate chart`.')
        endif
        goto 7
      elseif(INO.EQ.20)then

C Output redirect.
        if(MENUTYPE.eq.3)then
          call ctlexp(xfile,ixopen,ixunit,ixpunit,'G','Graphics',IER)
        elseif(MENUTYPE.eq.4)then
          call ctlexp(xfile,ixopen,ixunit,ixpunit,'X','Tabular',IER)
        else
          call ctlexp(xfile,ixopen,ixunit,ixpunit,'T','Text',IER)
        endif

C If user request cancel then reset ixopen to zero.
        if(ier.eq.-3) ixopen=0
        goto 7
      elseif(INO.EQ.21)then

C Display hours.
        IHFLAG=IHFLAG+1
        if(IHFLAG.GT.1)IHFLAG=0
        if(IHFLAG.eq.0)then
          call edisp(iuout,' ')
          call edisp(iuout,'standard display time = 10h30 set ')
        elseif(IHFLAG.eq.1)then
          call edisp(iuout,' ')
          call edisp(iuout,'3rd party graphing time = day fraction set')
        endif
        goto 7
      elseif(INO.EQ.22)then

C Toggle delimeter.
        helptopic='res_plant_delimeter'
        call gethelptext(helpinsub,helptopic,nbhelp)
        IWM=1
        CALL EASKMBOX('Delimeter to use between columns of data:',' ',
     &    'normal spaces','single space','tab','comma','tagged',
     &    'continue',' ',' ',IWM,nbhelp)
        if(iwm.eq.1)then
          delim = '-'
        elseif(iwm.eq.2)then
          delim = 'S'
        elseif(iwm.eq.3)then
          delim = 'T'
        elseif(iwm.eq.4)then
          delim = 'C'
        elseif(iwm.eq.5)then
          delim = 'X'
        endif
        goto 7
      ELSEIF(INO.EQ.23)THEN

C List or draw what has been selected.
        return
      ELSEIF(INO.EQ.24)THEN

C Clear selections.
        call mosyssu
        call edisp(iuout,' ')
        call edisp(iuout,'Previous selections cleared.')
        goto 7
      ELSEIF(INO.EQ.25)THEN

C Help.
        helptopic='res_plant_perf_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('systems tabular data',nbhelp,'-',0,0,IER)
      ELSEIF(INO.EQ.26)THEN

C To exit without drawing anything set menutype to -1 and return.
        call usrmsg('  ','  ','-')
        MENUTYPE=-1
        return
      endif

C If this point reached then must have selected one of the metrics.
      if(ino.gt.6.and.ino.lt.14) then

C Consider only the components which support the selected variable 
C (i.e. moist air)
        if(ino.eq.9.or.ino.eq.10.or.ino.eq.11.or.ino.eq.13) then
          k=0
          do 30 i=1,npcomp
            do 25 j=1, nnode(i)
              if(isv(i,j).eq.21) then
                k=k+1
                pcnam1(k)=pcname(i)
                ipcndx(k)=i
              endif
  25        continue
  30      continue
        endif

        if(ino.eq.8.or.ino.eq.12) then
          do 40 i=1,npcomp
            pcnam1(i)=pcname(i)
            ipcndx(i)=i
            k=i
  40      continue
        endif

C Consider only the components which support temperature 
C (i.e. all components)
        if(ino.eq.7) then
          do 50 i=1,npcomp
            pcnam1(i)=pcname(i)
            ipcndx(i)=i
            k=i
  50      continue
        endif

C Now display components menu
        ipc=1
        call selpc(ipc,mcomp,pcnam1,k)
        if(ipc.eq.0) goto 5
        indx=ipcndx(mcomp(1))
        mcomp(1)=indx
        ipcn =nnode(mcomp(1))

C If selected component has more than one node, then get desired node.
        if(ipcn.gt.1) then
          write(outs,*)'Node number for component ',
     &      pcname(mcomp(1)),'?'
          CALL EASKI(nsnd,' ',outs,1,'F',ipcn,'F',1,
     &                              'node number',IER,1)
        elseif(ipcn.eq.1) then
          nsnd=1
        endif

C Save selected component and node numbers.
        if((NPGET+1).GT.MNGET)then
          call usrmsg(' ','Number of items exceeded!','P')
          goto 7
        endif
        NPGET=NPGET+1
        lname=MIN0(lnblnk(pcname(indx)),11)
        write(PREFIX,'(a)') pcname(indx)(1:lname)

C Now save information for the specific selection.
        if(INO.EQ.7)then

C Temperature (IPGET = 1 ).
          IPGETNO(NPGET,1)=1
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-302
          IPGETNO(NPGET,7)=1
          IPGETNO(NPGET,8)=1

C Build string for display - the prefix being up to 11 characters
C of the component name and then the node index and then a suffix.
          SUFFIX=' degC'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='Node temperature (C)'
        ELSEIF(INO.EQ.8)THEN

C First phase flow (IPGET = 2).
          IPGETNO(NPGET,1)=2
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-203
          IPGETNO(NPGET,7)=6
          IPGETNO(NPGET,8)=2
          SUFFIX=' kg/s1'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='1st phase flow (kg/s)'
        ELSEIF(INO.EQ.9)THEN

C Second phase flow(IPGET = 3).
          IPGETNO(NPGET,1)=3
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-203
          IPGETNO(NPGET,7)=4
          IPGETNO(NPGET,8)=2
          SUFFIX=' kg/s2'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='2nd phase flow (kg/s)'
        ELSEIF(INO.EQ.10)THEN

C Relative humidity(IPGET=4).
          IPGETNO(NPGET,1)=4
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-202
          IPGETNO(NPGET,7)=7
          IPGETNO(NPGET,8)=3
          SUFFIX=' %'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='Relative humidity (%)'
        ELSEIF(INO.EQ.11)THEN

C Specific humidity(IPGET = 5).
          IPGETNO(NPGET,1)=5
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-102
          IPGETNO(NPGET,7)=1
          IPGETNO(NPGET,8)=4
          SUFFIX=' kg/kg'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='Specific humidity (kgv/kga)'
        ELSEIF(INO.EQ.12)THEN

C Enthalpy(IPGET = 6).
          IPGETNO(NPGET,1)=6
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-102
          IPGETNO(NPGET,7)=2
          IPGETNO(NPGET,8)=4
          SUFFIX=' KJ/Kg'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='Enthalpy (KJ/Kg)'
        ELSEIF(INO.EQ.13)THEN

C Dew point temperature(IPGET = 7).
          IPGETNO(NPGET,1)=7
          IPGETNO(NPGET,2)=indx
          IPGETNO(NPGET,3)=nsnd
          IPGETNO(NPGET,6)=-102
          IPGETNO(NPGET,7)=3
          IPGETNO(NPGET,8)=1
          SUFFIX=' degC'
          if(nsnd.le.9)then
            write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &        nsnd,SUFFIX
          else
            write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &        nsnd,SUFFIX
          endif
          write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
          call edisp(iuout,outs)
          SPLABEL(NPGET)='Dew point T (C)'
        endif
        goto 5

C Additional output.
      elseif(ino.eq.16) then
        k=0
        do 60 i=1,npcomp
          if(napout(i).gt.0) then
            k=k+1
            pcnam1(k)=pcname(i)
            ipcndx(k)=i
          endif
  60    continue

C Now display components menu
  61    ipc=1
        call selpc(ipc,mcomp,pcnam1,k)
        if(ipc.eq.0) goto 5
        indx=ipcndx(mcomp(1))
        mcomp(1)=indx
        naout=napout(mcomp(1))

C Display a menu showing additional output choices for the 
C component.
        do 66 iaout=1,naout
          aoutstr(iaout)=adopdsc(mcomp(1),iaout)
  66    continue
        ix=1 
        nitems=naout
        call epicks(ix,ivals,' ','Choose an additional output',30,
     &    nitems,aoutstr,'additional output',IER,0)
        if(ix.eq.0) goto 61
        nsnd=ivals(1)
        SUFFIX=' other'
        SUFFIX10=' Other (-)'
        if(aoutstr(nsnd)(1:11).eq.'Heat output')then
          SUFFIX=' HoutW'
          SUFFIX10=' Ht outp W'
        elseif(aoutstr(nsnd)(1:4).eq.'Coef')then
          SUFFIX=' COP'
          SUFFIX10=' COP (-)'
         elseif(aoutstr(nsnd)(1:14).eq.'Cooling output')then
          SUFFIX=' CoolW'
          SUFFIX10=' CoolingW'
         elseif(aoutstr(nsnd)(1:14).eq.'Cooling energy')then
          SUFFIX=' CoolW'
          SUFFIX10=' CoolingW'
         elseif(aoutstr(nsnd)(1:15).eq.'Total cooling e')then
          SUFFIX=' CoolW'
          SUFFIX10=' CoolingW'
         elseif(aoutstr(nsnd)(1:15).eq.'Sensible coolin')then
          SUFFIX=' CoolW'
          SUFFIX10=' CoolingLd'
         elseif(aoutstr(nsnd)(1:15).eq.'Condensate flow')then
          SUFFIX=' CndsF'
          SUFFIX10=' Cnds flrt'
         elseif(aoutstr(nsnd)(1:14).eq.'Condensation (')then
          SUFFIX=' StoCn'
          SUFFIX10=' Sto conds'
       elseif(aoutstr(nsnd)(1:4).eq.'Ambi')then
          SUFFIX=' Amb T'
          SUFFIX10=' Ambnt T'
        elseif(aoutstr(nsnd)(1:4).eq.'Devi')then
          SUFFIX=' ON:OF'
          SUFFIX10=' ON:OFF'
        elseif(aoutstr(nsnd)(1:5).eq.'Retur')then
          SUFFIX=' Rtn T'
          SUFFIX10=' Return T'
        elseif(aoutstr(nsnd)(1:10).eq.'Real power')then
          SUFFIX=' RlPwr'
          SUFFIX10=' Real Pwr'
        elseif(aoutstr(nsnd)(1:10).eq.'Reactive po')then
          SUFFIX=' ReaPw'
          SUFFIX10=' React Pwr'
        elseif(aoutstr(nsnd)(1:12).eq.'Reac power c')then
          SUFFIX=' ReaPw'
          SUFFIX10=' React Pwr'
        elseif(aoutstr(nsnd)(1:4).eq.'Appa')then
          SUFFIX=' AppPw'
          SUFFIX10=' Aprnt Pwr'
        elseif(aoutstr(nsnd)(1:5).eq.'Defro')then
          SUFFIX=' Dfrst'
          SUFFIX10=' Defrost'
        elseif(aoutstr(nsnd)(1:8).eq.'Valve po')then
          SUFFIX=' VlvPs'
          SUFFIX10=' Valv Pos'
        elseif(aoutstr(nsnd)(1:11).eq.'Average tan')then
          SUFFIX=' Avg T'
          SUFFIX10=' Averg T'
        elseif(aoutstr(nsnd)(1:9).eq.'Heat loss')then
          SUFFIX=' HtLsW'
          SUFFIX10=' Ht Loss W'
        elseif(aoutstr(nsnd)(1:9).eq.'Heat gain')then
          SUFFIX=' HtGnW'
          SUFFIX10=' Heat Gn W'
        elseif(aoutstr(nsnd)(1:15).eq.'Heat emission b')then
          SUFFIX=' Ht1:2'
          SUFFIX10=' Heat 1:2'
        elseif(aoutstr(nsnd)(1:12).eq.'Number of in')then
          SUFFIX=' IntTS'
          SUFFIX10=' Int TmStp'
        elseif(aoutstr(nsnd)(1:9).eq.'Times mix')then
          SUFFIX=' Mixng'
          SUFFIX10=' Nb.Mixing'
        elseif(aoutstr(nsnd)(1:8).eq.'Avg numb')then
          SUFFIX=' Mixsx'
          SUFFIX10=' Mix sx'
        elseif(aoutstr(nsnd)(1:8).eq.'Heat tra')then
          SUFFIX=' Ht HX'
          SUFFIX10=' Ht frm HX'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 1')then
          SUFFIX=' FlwT1'
          SUFFIX10=' Flow Ty 1'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 2')then
          SUFFIX=' FlwT2'
          SUFFIX10=' Flow Ty 2'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 3')then
          SUFFIX=' FlwT3'
          SUFFIX10=' Flow Ty 3'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 4')then
          SUFFIX=' FlwT4'
          SUFFIX10=' Flow Ty 4'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 5')then
          SUFFIX=' FlwT5'
          SUFFIX10=' Flow Ty 5'
        elseif(aoutstr(nsnd)(1:16).eq.'Flow rate type 6')then
          SUFFIX=' FlwT6'
          SUFFIX10=' Flow Ty 6'
        elseif(aoutstr(nsnd)(1:16).eq.'Heat emission fr')then
          SUFFIX=' Rad W'
          SUFFIX10=' Radiatr W'
        elseif(aoutstr(nsnd)(1:16).eq.'Heat emission be')then
          SUFFIX=' Rad W'
          SUFFIX10=' Rad htbtw'
        elseif(aoutstr(nsnd)(1:16).eq.'Mean radiator te')then
          SUFFIX=' Rad T'
          SUFFIX10=' Radiatr T'
        elseif(aoutstr(nsnd)(1:16).eq.'Environment temp')then
          SUFFIX=' RadEn'
          SUFFIX10=' Rad Env T'
        elseif(aoutstr(nsnd)(1:13).eq.'Log mean temp')then
          SUFFIX=' DeltT'
          SUFFIX10=' log m dT'
        elseif(aoutstr(nsnd)(1:12).eq.'Solar rad.on')then
          SUFFIX=' SolCo'
          SUFFIX10=' Sol rd.on'
        elseif(aoutstr(nsnd)(1:12).eq.'Cos of incid')then
          SUFFIX=' InAng'
          SUFFIX10=' Incid Ang'
        elseif(aoutstr(nsnd)(1:13).eq.'Environment t')then
          SUFFIX=' EnviT'
          SUFFIX10=' Envir T'
        elseif(aoutstr(nsnd)(1:13).eq.'ON/OFF signal')then
          SUFFIX=' ONOFF'
          SUFFIX10=' ON/OFF sg'
        elseif(aoutstr(nsnd)(1:15).eq.'Gas consumption')then
          SUFFIX=' gas'
          SUFFIX10=' gas cons'
        elseif(aoutstr(nsnd)(1:15).eq.'Water sided eff')then
          SUFFIX=' H2eff'
          SUFFIX10=' H2O eff'
        elseif(aoutstr(nsnd)(1:15).eq.'Water heat inpu')then
          SUFFIX=' H2inp'
          SUFFIX10=' H2O input'
        elseif(aoutstr(nsnd)(1:15).eq.'Water exit temp')then
          SUFFIX=' H2OeT'
          SUFFIX10=' H2O exitT'
        elseif(aoutstr(nsnd)(1:15).eq.'Water mass flow')then
          SUFFIX=' H2Omf'
          SUFFIX10=' H2O msflr'
        elseif(aoutstr(nsnd)(1:15).eq.'Mean useful pow')then
          SUFFIX=' MnPwr'
          SUFFIX10=' Mn UsePwr'
        elseif(aoutstr(nsnd)(1:15).eq.'Mean consumed p')then
          SUFFIX=' MnPwr'
          SUFFIX10=' Mn conPwr'
        elseif(aoutstr(nsnd)(1:14).eq.'Mean fuel mass')then
          SUFFIX=' Mnful'
          SUFFIX10=' Mn fuelms'
        elseif(aoutstr(nsnd)(1:14).eq.'Rate of burner')then
          SUFFIX=' BurRt'
          SUFFIX10=' Burner Rt'
        elseif(aoutstr(nsnd)(1:14).eq.'Ditto in stand')then
          SUFFIX=' BurSb'
          SUFFIX10=' Burner Sb'
        elseif(aoutstr(nsnd)(1:15).eq.'Global boiler e')then
          SUFFIX=' BurGE'
          SUFFIX10=' Burner GE'
        elseif(aoutstr(nsnd)(1:15).eq.'Operation effic')then
          SUFFIX=' BurOE'
          SUFFIX10=' Burner OE'
        elseif(aoutstr(nsnd)(1:15).eq.'Stand-by heat l')then
          SUFFIX=' HLstb'
          SUFFIX10=' HL stndby'
        elseif(aoutstr(nsnd)(1:13).eq.'Heat exch eff')then
          SUFFIX=' HXeff'
          SUFFIX10=' HX eff'
        elseif(aoutstr(nsnd)(1:13).eq.'Heat exch hea')then
          SUFFIX=' HXhtc'
          SUFFIX10=' HX htc'
        elseif(aoutstr(nsnd)(1:13).eq.'Net water hea')then
          SUFFIX=' H2OHi'
          SUFFIX10=' H2O htin'
        elseif(aoutstr(nsnd)(1:13).eq.'Radiator temp')then
          SUFFIX=' RadT'
          SUFFIX10=' Rad T'
        elseif(aoutstr(nsnd)(1:12).eq.'Inlet air db')then
          SUFFIX=' inAT'
          SUFFIX10=' in air T'
        elseif(aoutstr(nsnd)(1:12).eq.'Inlet air 2b')then
          SUFFIX=' inWB'
          SUFFIX10=' in air WB'
        elseif(aoutstr(nsnd)(1:12).eq.'CHP unit loa')then
          SUFFIX=' CHP%'
          SUFFIX10=' CHP unit%'
        elseif(aoutstr(nsnd)(1:12).eq.'CHP unit gen')then
          SUFFIX=' CHPW'
          SUFFIX10=' CHP untkW'
        elseif(aoutstr(nsnd)(1:12).eq.'CHP fuel con')then
          SUFFIX=' CHPfc'
          SUFFIX10=' CHP fuel'
        elseif(aoutstr(nsnd)(1:13).eq.'Heat input to')then
          SUFFIX=' CalHi'
          SUFFIX10=' Caloif Hi'
        elseif(aoutstr(nsnd)(1:13).eq.'Fuel consumpt')then
          SUFFIX=' CHPfl'
          SUFFIX10=' CHP fuel'
        elseif(aoutstr(nsnd)(1:13).eq.'Total heat tr')then
          SUFFIX=' Acum'
          SUFFIX10=' Acum HT'
        elseif(aoutstr(nsnd)(1:14).eq.'Heat release o')then
          SUFFIX=' CHPfW'
          SUFFIX10=' CHP flW'
        elseif(aoutstr(nsnd)(1:14).eq.'Generator outp')then
          SUFFIX=' CHP G'
          SUFFIX10=' CHP GkW'
        elseif(aoutstr(nsnd)(1:14).eq.'Overall effici')then
          SUFFIX=' CHPEf'
          SUFFIX10=' CHP eff'
        elseif(aoutstr(nsnd)(1:15).eq.'Heat transfer b')then
          SUFFIX=' HxW-W'
          SUFFIX10=' HxW-Wht'
        elseif(aoutstr(nsnd)(1:15).eq.'Number of trans')then
          SUFFIX=' HxNTU'
          SUFFIX10=' Hx NTU'
        elseif(aoutstr(nsnd)(1:16).eq.'Heat exchanger e')then
          SUFFIX=' Hxeff'
          SUFFIX10=' Hx eff'
        elseif(aoutstr(nsnd)(1:12).eq.'Effectiness (')then
          SUFFIX=' Cteff'
          SUFFIX10=' CTwr eff'
        elseif(aoutstr(nsnd)(1:16).eq.'Cooling Power (W')then
          SUFFIX=' CT W'
          SUFFIX10=' CoolTwr W'
        elseif(aoutstr(nsnd)(1:6).eq.'NTUr (')then
          SUFFIX=' CTNTU'
          SUFFIX10=' ClTwr NTU'
        elseif(aoutstr(nsnd)(1:15).eq.'Minimum floor t')then
          SUFFIX=' RadnT'
          SUFFIX10=' Radn mnT'
        elseif(aoutstr(nsnd)(1:15).eq.'Maximum floor t')then
          SUFFIX=' RadnT'
          SUFFIX10=' Radn mxT'
        elseif(aoutstr(nsnd)(1:15).eq.'Supply power (W')then
          SUFFIX=' RadnW'
          SUFFIX10=' Radn supW'
        elseif(aoutstr(nsnd)(1:15).eq.'Average fluid t')then
          SUFFIX=' RadnT'
          SUFFIX10=' Radn fldT'
        elseif(aoutstr(nsnd)(1:15).eq.'Average circuit')then
          SUFFIX=' RadnL'
          SUFFIX10=' Radn crtL'

C Extend as required.
        endif

C Save selected component and additional output number.
        if((NPGET+1).GT.MNGET)then
          call usrmsg('Number of items exceeded.',' ','P')
          goto 7
        endif
        NPGET=NPGET+1
        lname=MIN0(lnblnk(pcname(indx)),11)
        write(PREFIX,'(a)') pcname(indx)(1:lname)

C Additional output.
        IPGETNO(NPGET,1)=10
        IPGETNO(NPGET,2)=indx
        IPGETNO(NPGET,3)=nsnd
        IPGETNO(NPGET,6)=-102
        IPGETNO(NPGET,7)=5
        IPGETNO(NPGET,8)=5

C        SUFFIX=' other'
        if(nsnd.le.9)then
          write(GPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &      nsnd,SUFFIX
        else
          write(GPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &      nsnd,SUFFIX
        endif
        write(outs,'(2a)') 'Selected ',GPLABEL(NPGET)
        call edisp(iuout,outs)
        SPLABEL(NPGET)='Other (-)'
        if(nsnd.le.9)then
          write(SPLABEL(NPGET),'(2a,i1,a)') PREFIX(1:lname),' n',
     &      nsnd,SUFFIX10(1:lnblnk(SUFFIX10))
        else
          write(SPLABEL(NPGET),'(2a,i2,a)') PREFIX(1:lname),'n',
     &      nsnd,SUFFIX10(1:lnblnk(SUFFIX10))
        endif
        goto 5
      endif

      IF(INO.EQ.17)THEN

C Ambient db T(IPGET = 9).
        if((NPGET+1).GT.MNGET)then
          call usrmsg('Number of items exceeded.',' ','P')
          goto 7
        endif
        NPGET=NPGET+1
        IPGETNO(NPGET,1)=9
        IPGETNO(NPGET,2)=0
        IPGETNO(NPGET,3)=0
        IPGETNO(NPGET,6)=-302
        IPGETNO(NPGET,7)=4
        IPGETNO(NPGET,8)=1
        GPLABEL(NPGET)='Ambient T (C)'
        SPLABEL(NPGET)='Ambient Temp (C)'
      ELSEIF(INO.EQ.18)THEN

C Ambient RH(IPGET = 12).
        if((NPGET+1).GT.MNGET)then
          call usrmsg('Number of items exceeded.',' ','P')
          goto 7
        endif
        NPGET=NPGET+1
        IPGETNO(NPGET,1)=12
        IPGETNO(NPGET,2)=0
        IPGETNO(NPGET,3)=0
        IPGETNO(NPGET,6)=-202
        IPGETNO(NPGET,7)=7
        IPGETNO(NPGET,8)=3
        GPLABEL(NPGET)='Ambient RH (%)'
        SPLABEL(NPGET)='Ambient RH (%)'
      else
        INO=-1
        goto 5
      ENDIF
      INO=-2
      goto 7

      END

C ******************** SELPC ********************
C SELPC displays a selection list of plant components
C for the user to select from.
      subroutine selpc(mnpc,mcomp,pcnam1,npc)
#include "plant.h"
#include "help.h"
      dimension mcomp(mpcom)

      character pcnam1(mpcom)*15

      helpinsub='moplnt'  ! set for subroutine

c Get number of components.
      if(npc.eq.1) then
         mnpc=1
         mcomp(1)=1
      else

c Get number of each component.
   10   helptopic='res_plant_comp_list'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EPICKS(mnpc,mcomp,' ',
     &    ' Which component to include: ',15,npc,pcnam1,
     &    ' Select comp',IER,nbhelp)
         if(ier.ne.0) goto 10
         if(mnpc.eq.0)return

      endif
      return
      end


C ******************** opnplt ********************
C opnplt opens plant result file and fills header with
C simulation related information. It is passed npc the
C number of plant components used in the network.
C If user cancels file browse set ier to -3.
      subroutine opnplt(npc,imode,ier)
#include "building.h"
#include "model.h"
#include "plant.h"
#include "esprdbfile.h"
#include "help.h"

      integer lnblnk  ! function definition
      integer igraphiclib  ! external definition

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/pres/iunitp
      COMMON/FILEP/IFIL
      COMMON/PPERS/IpSD1,IpSM1,IpSD2,IpSM2,IpSDS,IpSDF,NpTS,IpSav
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV
      COMMON/DEFLT/IDEFLT
      common/prav/IDAVER
      COMMON/LIBRCP/IRCPLP,nblock
      common/cctlnm/ctldoc,lctlf
      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME
      common/pcdbdt/ipcrec(mpcom)

C This common block based on initial results file dialog and is
C the best-guess of file names (but with full path).
      character RFILEABS*144,PFILEABS*144,MSTRFILEABS*144,LAFRESABS*144
      COMMON/ABSRESLIB/RFILEABS,PFILEABS,MSTRFILEABS,LAFRESABS
      common/pcdat/ CSV1M(mnodec),CSV2M(mnodec),CSV3M(mnodec),
     &              NNODE(mpcom),nrecpc(mpcom)
      common/pcresres/ napout(mpcom),apcout(MPCRES)
      COMMON/LIBOK/IBLIB,IFLIB,ICLIB,IELIB,IPLIB
      common/rpath/path
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      COMMON/FOPENED/CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK

C Defaults.
      character*96 DFCFG,DFCTL,DEFRLB,DAPROB,DAFRES,DPNF
      COMMON/DEFLT2/DFCFG,DFCTL,DEFRLB,DAFRES,DAPROB,DPNF

      character xfile*144,tg*1,delim*1
      common/exporttg/xfile,tg,delim

      character DFILE*72,LTMP*144
      character outs*124,louts*248
      character lctlf*72,ctldoc*248,scname*12,MODE*4
      character firstbit*72,secondbit*72,path*72
      character longtmp*144
      logical XST,ok
      logical CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK
      integer nsim  ! number of simulations
      integer ISTRW

      helpinsub='moplnt'  ! set for subroutine

      IUNITp=ifil+10
      DFILE='plant.plr'
      firstbit=' '   ! to ensure string buffers are not null
      secondbit=' '

      ier=0
    6 call edisp(iuout,' ')
      if(imode.eq.1) then
        if(PFILEABS(1:2).ne.'  '.or.PFILEABS(1:4).ne.'UNKN')then
          ltmp=PFILEABS
        else
          ltmp=' '
        endif

        llt=lnblnk(ltmp)
        helptopic='res_plant_res_file'
        call gethelptext(helpinsub,helptopic,nbhelp)

C The X11 version will be returning only the name of the
C file, while the GTK version will be returning the
C name with the full path.
        iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
        if(iglib.eq.1.or.iglib.eq.3)then
          if(llt.lt.72)then
            ISTRW=72
          elseif(llt.ge.72.and.llt.lt.96)then
            ISTRW=96
          elseif(llt.ge.96.and.llt.lt.124)then
            ISTRW=124
          elseif(llt.ge.124.and.llt.le.144)then
            ISTRW=144
          endif
        elseif(iglib.eq.2)then
          ISTRW=144
        else
          ISTRW=96
        endif
        CALL EASKF(ltmp,'Plant library name? ',' ',ISTRW,DFILE,
     &    'plant library file',IER,nbhelp)
        if(ier.eq.-3) return  ! cancel detected pass back -3 in ier.

        if(LTMP(1:2).eq.'  '.or.LTMP(1:4).eq.'UNKN')goto 6
      else
        ltmp=PFILEABS
      endif
      IER=0

      INQUIRE (FILE=ltmp,EXIST=XST)
      IF(XST)THEN

C Set record length of library file.
        CALL ERPFREE(iunitp,ISTAT)
        nprl = nprecl
        call EFOPRAN(iunitp,ltmp,nprl,1,IER)
        if(ier.eq.0) then
          write(outs,'(A,I3)')
     &     ' Opened plant results with record length',nprl
          call edisp(iuout,outs)
        else
          call edisp(iuout,'Unable to open plant results')
        endif
      ELSE

C Try again? Note: because of space limits only echo the start of
C the plant file name.
        helptopic='plant_res_file_not'
        call gethelptext(helpinsub,helptopic,nbhelp)
        write(outs,'(3a)') 'Could not find ',LTMP(1:72),'!'
        CALL EASKOK(outs,'Retry?',OK,nbhelp)
        IF(.NOT.OK) return
        goto  6
      endif

      IREC=1
C Read number of result-set.
      READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)NSIM
      IF (NSIM.EQ.0) then
          call edisp(iuout,' ')
          call edisp(iuout,' Results not saved.')
          call erpfree(iunitp,istat)
          return
      endif
      ipset=0
      if(nsim.gt.1) then
         write(outs,'(a,I4,a)')'Plant library contains',nsim,
     &     ' results sets'
         call edisp(iuout,outs)
  13     ipset=1
         helptopic='res_plant_res_set'
         call gethelptext(helpinsub,helptopic,nbhelp)
         CALL easki(ipset,' ',' Specify required set ? ',
     &      1,'F',nsim,'F',1,'required set',IER,nbhelp)
         IF(IER.NE.0) GOTO 13
      else
         ipset=1
      endif
      
C In case plant results file name was not passed directly to res
C the value of IPLIB will not have been set. Do the check of
C record 32 and set this value.
      irec=32
      read(iunitp,rec=irec,iostat=istat,err=1000)iftype
      if(iftype.eq.-1) then

C Debug.
C        write(6,*) 'opnplt: older plant ',iftype

        IPLIB=1
      elseif(iftype.eq.-2) then
      
C If newer plant results file we could recover the cfg file name and
C scan it in at this point. Read the 2nd item on record 32 to get location.

C Debug.
C        write(6,*) 'opnplt: newer plant ',iftype

        IPLIB=2
        IREC=32
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)iftype,ireccfg

C Debug.
C        write(6,*) 'opnplt: the jump for cfg ',ireccfg

        IREC=ireccfg
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) firstbit
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) secondbit
        lnfb=lnblnk(firstbit)
        lnsb=lnblnk(secondbit)
        write(longtmp,'(2a)') firstbit(1:lnfb),secondbit(1:lnsb)

C Debug.
C        write(6,*) longtmp
      
C Extract path from cfg file name and check that we can find it.
 289    call fdroot(longtmp,path,LCFGF)
        IFCFG=IFIL+1
        IAPROB=IFIL+2
        CALL ERPFREE(IFCFG,ISTAT)
        call FINDFIL(LCFGF,XST)
        IF(XST)THEN
          MODE='ALL'
          CALL ERSYS(LCFGF,IFCFG,IAPROB,MODE,ITRC,IER)
          IF(IER.NE.0)THEN
            WRITE(OUTS,'(A,2X,A)')' Problem reading ',LCFGF
            call edisp(iuout,outs)
          ELSE
            CFGOK=.TRUE.
          ENDIF

C If izver is >=4 then the only information needed from the zone
C operation file is the user name for each casual gain type. Scan
C this information.
          if(NCOMP.gt.0)then
            DO 43 IZONE=1,NCOMP
              CALL EROPER(0,iuout,IAPROB,izone,IER)
  43        CONTINUE
          endif

C Set the default export file name based on model root name.
          write(xfile,'(2a)') cfgroot(1:lnblnk(cfgroot)),'.csv'

        ELSE

C Not found, might be in a remote folder.  Warn user first.
          WRITE(OUTS,'(A,A)')' Could not find ',LCFGF
          call edisp(iuout,outs)
          WRITE(OUTS,'(A,A)')' in the folder ',path
          call edisp(iuout,outs)
          helptopic='res_plant_cfg_file'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('no system file',nbhelp,'-',0,0,IER)

          write(longtmp,'(a)') LCFGF(1:lnblnk(LCFGF))

C If using X11 assume that the full path is less than 96 chars
C but if using GTK then we need the full length to avoid truncation.
          iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
          if(iglib.eq.1.or.iglib.eq.3)then
            ISTRW=96
          elseif(iglib.eq.2)then
            ISTRW=144
          else
            ISTRW=96
          endif
          CALL EASKF(longtmp,'Model configuration file?',' ',ISTRW,
     &      DFCFG,'config file name',IER,nbhelp)
          if(ier.eq.-3) return  ! cancel detected pass back -3 in ier.

          if (longtmp(1:2).ne.'  ') GOTO 289
        ENDIF
      endif
      
      NSIM=ipset-1
      IREC=NSIM+2

C Get pointer to control record and start of result data set.
      READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)NST,IRCPLP

C Get Number of plant components value.
      IREC=33
      READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)
     &   IDUM,NPCOMP
      if(npcomp.ne.npc) then
         write(outs,'(a)')
     &       'Unequal no. comp in result file and configuration file'
         call edisp(iuout,outs)
         ier=1
         return
      endif
      IREC=IREC+1

C Read pointers to components entries in database.
C First find required number of records.
      nrecs=npcomp/nprecl+1

C Initialise first item number and number of items left
C respectively.
      items=1
      iteml=npcomp
      do 11 ir=1, nrecs
         if(iteml.le.nprecl) then
            iteme=npcomp
         else
            iteme=items+nprecl-1
         endif
         read(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)
     &                          (ipcrec(I),i=items,iteme)
         IREC=IREC+1
         items=nprecl*ir+1
         iteml=npcomp-items+1
   11 continue

C Read climate file name.
      if(IPLIB.eq.1)then
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) LCLIM
      elseif(IPLIB.eq.2)then
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) firstbit
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) secondbit
        lnfb=lnblnk(firstbit)
        lnsb=lnblnk(secondbit)
        write(LCLIM,'(2a)') firstbit(1:lnfb),secondbit(1:lnsb)

C Debug.
C        write(6,*) 'plant lclim is ',LCLIM

      endif

C Check that this CLIMATE file can still be assigned. << convert >>
   44 IUNITC=IFIL+5
      CALL FPRAND(IUNITC,ISTAT,144,1,LCLIM)
      IF(ISTAT.LT.0)then

C Climate file not found - ask user for name.
        write(louts,'(3A)') ' Referenced climate file ',
     &     LCLIM(1:lnblnk(LCLIM)), ' not found...'
        call edisp248(iuout,louts,100)
        call erpfree(IUNITC,istat)
        helptopic='res_climate_file_ask'
        call gethelptext(helpinsub,helptopic,nbhelp)
        ltmp=LCLIM

C If using X11 assume that the full path is less than 96 chars
C but if using GTK then we need the full length to avoid truncation.
        iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
        if(iglib.eq.1.or.iglib.eq.3)then
          ISTRW=96
        elseif(iglib.eq.2)then
          ISTRW=144
        else
          ISTRW=96
        endif
        CALL EASKF(ltmp,' ','Climate file name? ',
     &    ISTRW,DCLIM,'climate file name',IER,nbhelp)
        if(ier.eq.-3) return  ! cancel detected pass back -3 in ier.

        if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
          LCLIM=ltmp
        endif
        goto 44
      endif

C Read Climate year from the file if not already done
C so when reading the building configuration file. If 
C we have a plant only configuration then the year number
C has to be read. imode=0 - plant only config
      IF(imode.EQ.0) THEN
        IRECC=366
        READ(IUNITC,REC=IRECC,IOSTAT=ISTAT,ERR=999)IYEAR
      END IF

C Read plant component file name (long or short) 
      if(IPLIB.eq.1)then
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) firstbit
        lnfb=lnblnk(firstbit)
        write(Lpcdb,'(a)') firstbit(1:lnfb)

C Debug.
C        write(6,*) Lpcdb

      elseif(IPLIB.eq.2)then
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) firstbit
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) secondbit
        lnfb=lnblnk(firstbit)
        lnsb=lnblnk(secondbit)
        write(Lpcdb,'(2a)') firstbit(1:lnfb),secondbit(1:lnsb)

C Debug.
C        write(6,*) Lpcdb

      endif
      
C If IPLIB is 2 then the model configuration file name will have alread
C been scanned. Eventually this code can be commented out.
      if(IPLIB.eq.2)then
        IREC=IREC+1

C Debug.
C        write(6,*) ' irec at  cfg file name ',irec

        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) firstbit
        IREC=IREC+1
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) secondbit
        lnfb=lnblnk(firstbit)
        lnsb=lnblnk(secondbit)
        write(longtmp,'(2a)') firstbit(1:lnfb),secondbit(1:lnsb)

C Debug.
C        write(6,*) longtmp

        call fdroot(longtmp,path,LCFGF)
      endif

C Read control data for simulation.
      IREC=NST
      write(scname,'(a)')CTLDOC(1:12)
      READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)
     &   IpSD1,IpSM1,IpSD2,IpSM2,IpSDS,IpSDF,NpTS,ipsav,scname,IDAVER
      IREC=IREC+1

C In case of no configuration control file active, skip one record
C to allow match with building library for results recovery.
      IF(CTLDOC(1:4).NE.'NONE'.AND.CTLDOC(1:4).NE.'None'.AND.
     &   CTLDOC(1:4).NE.'none') THEN
         IREC=IREC+1
         READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000) LCTLF
         IREC=IREC+1
      ENDIF

C Check that IREC=IRCPLP, stop if not equal.
      if(irec.ne.ircplp) then
        write(outs,'(a,i4,a,i4,a)') ' End of header ',irec,
     &   ' & pointer to results set ',ircplp,' dont match.!'
        call edisp(iuout,outs)
      endif

C Determine number of records for all components.
C Add additional output for components if any.
      mxnode=nprecl/3
      nblock=0
      do 717 jj=1, npcomp
         irec=ipcrec(jj)
         call dbdat(jj,irec,nnode(jj),napout(jj))
         nrecs=nnode(jj)/(mxnode+1)+1
         nrecpc(jj)=nrecs
         nblock=nblock+nrecs
         if(napout(jj).ne.0) nblock=nblock+1
  717 continue

C Default set-up.
      
      IF(IDEFLT.EQ.1)then
         IOH1=1
         IOD1=IpsD1
         IOM1=IpsM1
         IOH2=24
         IOD2=IpsD2
         IOM2=IpsM2
         IODS=IpSDS
         IODF=IpSDF
         NOUT=1
         IAV=0
      endif
      return

 999  WRITE(outs,'(a)') ' Simulation year not found'
      call edisp(iuout,outs)
      return
     

 1000 WRITE(outs,'(a,I5)') ' Library error at record',IREC
      call edisp(iuout,outs)
      return
      end

C ************************ dbdat **************************
C Read (??) additional output data for a plant component.
C ipc is the index of the component index.
C irec is the initial record to scan.
C nnode (??) is returned 
C naout (number of additional output data) is returned.
      subroutine dbdat(ipc,irec,nnode,naout)
#include "plant.h"
#include "esprdbfile.h"
#include "gencompDB.h"
#include "gencompDB_common.h"
#include "help.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/FILEP/IFIL
      common/ntype/isv(mpcom,mnodec)
      common/adopdesc/adopdsc(mpcom,MPCRES)
      COMMON/C9plus/UCdbNam(MPCOM),CdbCat(MPCOM),CDBDesc(MPCOM)
      COMMON/PCRES/QDATA(MPCOM),PCAOUT(MPCOM,MPCRES),napdat(mpcom)


C Common for new format component database
      COMMON/NCDBFORM/ICDBF

      LOGICAL OK,unixok
      CHARACTER PZDESC*25,cdate*16,buffer*80,adopdsc*30,
     &UCDBNam*16, CdbCat*32, CDBDesc*72, argstr*12
      character fs*1
      integer lndbp   ! for length of standard database path
      character lltmp*144  ! to re-create plant database file name with path
      character domain_s*16,category_s*16
      
      helpinsub='moplnt'  ! set for subroutine

C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C !icdbf should have already been set - so no need to open file again.

      if (icdbf.eq.0)then

C If unit for plant component db not yet set, do it.
      if(ipcdb.eq.0)ipcdb=ifil+11

C 'irecln' is defined in 'plantdb.h'.
      irecln=20
      lndbp=lnblnk(standarddbpath)
      if(ipathpcdb.eq.0.or.ipathpcdb.eq.1)then
        lltmp=LPCDB
      elseif(ipathpcdb.eq.2)then
        write(lltmp,'(3a)') standarddbpath(1:lndbp),fs,
     &    lpcdb(1:lnblnk(lpcdb))  ! prepend db folder path
      endif
  100 call EFOPRAN(ipcdb,lltmp,IRECLN,1,IER)

C Check for error on opening.
      if(ier.gt.0) then
         ok=.false.
         helptopic='res_plant_db_not'
         call gethelptext(helpinsub,helptopic,nbhelp)
         CALL EASKOK('Error opening plant component database!',
     &              'Retry?',OK,nbhelp)
         if(ok) goto 100
      elseif(ier.lt.0) then

C File doesn't exist.
         ok=.false.
         helptopic='res_plant_db_not'
         call gethelptext(helpinsub,helptopic,nbhelp)
         CALL EASKOK('Plant component database does not exist.',
     &              'Retry?',OK,nbhelp)
         CALL USRMSG(' ',' ','-')
         if(ok) goto 100
      endif

C Old file, so check header.
      iorec = 1
      READ (ipcdb,REC=IOREC,IOSTAT=ISTAT,ERR=99999) PZDESC
      IF (PZDESC .NE. ' PLANT COMPONENT DATABASE') then

C Attempt to open the file as a new format cdb (ASCII) file. 
          ok=.false.
          CALL EASKOK('Error opening plant component database!',
     &              'Retry?',OK,nbhelp)
          if(ok) goto 100
      endif

      read(ipcdb,rec=irec,iostat=istat,err=99999)
     &     idum,idum,cdate,nnode,nmatx,nmisc
      irec=irec+1
      read(ipcdb,rec=irec,iostat=istat,err=99999)
     &     idum,idum,idum,idum,idum,ncdata,naout
      irec=irec+3
      read(ipcdb,rec=irec,iostat=istat,err=99999)
     &     (ISV(ipc,INOD),INOD=1,NNODE)


C Read additional output description and type
      if(naout.gt.0) then
        irec=irec + 1 + (NMATX-1)/IRECLN + NMISC + ncdata
        do 160 i=1, naout
          irec=irec+1
          read(ipcdb,REC=IREC,IOSTAT=ISTAT,ERR=99999)adopdsc(ipc,i)
  160   continue
      endif

      endif
c Read the additional plant output data data from the new format database.
      if(icdbf.eq.1)then
        argstr='parameters'
        domain_s=' '; category_s=' '
        call CDBGetItemData(domain_s,category_s,UCdbNam(IPC),argstr)
        argstr='detailed'
        CALL CDB2Plant(IPC,argstr)
        nnode=s_NNODE
        naout=NAPDAT(IPC)
      endif

      return

C Error trap routine.
99999 write(buffer,99099)
99099 format('Error reading plant data base.')
      call edisp(iuout,buffer)
      return
      end

C ************************ fnddat *************************
C Given the day, hour and current step, fnddat reads
C the component 'ipc' results data from plant library
C file.
C State space variables data and additional output.
C data are stored in CSV?M and APCOUT arrays respectively.
      subroutine fnddat(ii,ipc,ier)
#include "plant.h"

      COMMON/pres/iunitp
      COMMON/LIBRCP/IRCPLP,nblock
      common/pcdat/ CSV1M(mnodec),CSV2M(mnodec),CSV3M(mnodec),
     &              NNODE(mpcom),nrecpc(mpcom)
      common/pcresres/ napout(mpcom),apcout(MPCRES)
      logical unixok

C Find data location in result file.
      ier=0
      IREC=IRCPLP+NBLOCK*ii

C Find relative position of record for this component
      if(ipc.gt.1) then
        do 373 ir=2,ipc
          irec=irec+nrecpc(ir-1)
          if(napout(ir-1).gt.0) irec=irec+1
 373    continue
      endif

C Find number of records required.
      nrecs=(nnode(ipc)*3)/(nprecl+1)+1

C Initialise first item number and number of items left
C respectively.
      items=1
      mxnode=nprecl/3
      iteml=nnode(ipc)
      items=1

C Start reading nodal data, perhaps using more than one record.
      do 7000 ir=1, nrecs
        if(iteml.le.mxnode) then
          iteme=nnode(ipc)
        else
          iteme=items+mxnode-1
        endif

C Read each node's temperature, 1th and 2nd phase mass flow rate.
        READ(IUNITp,REC=IREC,IOSTAT=ISTAT,ERR=1000)
     &      (CSV1M(JJ),CSV2M(JJ),CSV3M(JJ),JJ=items,iteme)
        IREC=IREC+1
        items=mxnode*ir+1
        iteml=nnode(ipc)-items+1
 7000 continue

C Read additional output if any.
      if(napout(ipc).gt.0)
     &   READ(IUNITp,REC=IREC,IOSTAT=ISTAT,
     &        ERR=1000)(apcout(jj),JJ=1,napout(ipc))
      return

 1000 call isunix(unixok)
      if(unixok)WRITE(6,'(A,I5)') 
     &  ' error when reading results for comp ',ipc
      ier=1
      END

C ******************** MOSYSSU ********************
C MOSYSSU clears commons/ sets default values for systems plotting.

      SUBROUTINE MOSYSSU
      PARAMETER (MSYSRS=20)

      COMMON/MSYSPICK/NPGET,IPGETNO(MSYSRS,8)

      COMMON/GRAF1/YMAX(6),YMIN(6),YAXSET(6),ADDLIN,horaxisdiv
      COMMON/IGETFLG/IOCUPF,ialstused,IROC
      COMMON/SYSLABEL/SPLABEL(MSYSRS),GPLABEL(MSYSRS)

      integer YAXSET,ADDLIN,horaxisdiv
      character SPLABEL*32,GPLABEL*20

C Reset axis max and min values to 1.0 and 0.0 resp.
C YAXSET: Axis max min set =1 automatically scalled, 2= user set.
      do 8 I=1,5
        YMAX(I)=1.0
        YMIN(I)=0.0
        YAXSET(I)=0
 8    continue

C Set add profile label ADDLIN=0 i.e. no add
      ADDLIN=0

C Reset to no choices and current result set.
      NPGET=0
      do 10 I=1,MSYSRS
        IPGETNO(I,1)=0
        IPGETNO(I,2)=0
        IPGETNO(I,3)=0
        IPGETNO(I,4)=0
        IPGETNO(I,5)=0
        IPGETNO(I,6)=0
        IPGETNO(I,7)=0
        IPGETNO(I,8)=0
        SPLABEL(I)='  '
        GPLABEL(I)='  '
 10   continue
      ialstused=0

      return
      end

C ******************** SYSOUTP ********************
C SYSOUTP is the main controlling routine for system line graph
C output, stats, data above or below a setpoint, timestep listings and
C histograms. Occupancy filtering (based on user selected zone) is
C implemented for all but line graphs.
C This output mode allows the various causal relationships 
C to be displayed and so visually investigated.   
C act='p' iget parameters already set.
C If imode is 1 then user is asked to confirm the plant
C results file. If imode is 0 then sysoutp has been called
C imediately after starting res because the file passed on
C the command line was a plant results file.

      SUBROUTINE SYSOUTP(act,imode)
#include "building.h"
#include "site.h"
#include "plant.h"
#include "help.h"
C act='p' iget parameters already set.
      
      integer lnblnk  ! function definition

      PARAMETER (MSYSRS=20)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/OUTPCH/ICOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY

      common/appcols/mdispl,nifgrey,ncset,ngset,nzonec
      integer menuchw,igl,igr,igt,igb,igw,igwh
      COMMON/VIEWPX/menuchw,igl,igr,igt,igb,igw,igwh
      COMMON/GRAF1/YMAX(6),YMIN(6),YAXSET(6),ADDLIN,horaxisdiv
      COMMON/GRAF2/YSC(6),Yadd(6),TSC,Xadd,IGX(6),ILR(6),DT
      common/grextras/graftitle,grlbl(10),ngrlbl,lblpx(10),lblpy(10)

      COMMON/PPERS/IPSD1,IPSM1,IPSD2,IPSM2,IPSDS,IPSDF,NPTS,ipsav
      COMMON/SIMPIK/ISIM,ISTADD,ID1,IM1,ID2,IM2,ISDS,ISDF,NTS,ISAVE
      COMMON/PERO/IOD1,IOM1,IOH1,IOD2,IOM2,IOH2,IODS,IODF,NOUT,IAV
      COMMON/C6/INDCFG
      COMMON/C9/NPCOMP,NCI(MPCOM),CDATA(MPCOM,MMISCD)

      common/getmenu/menutype,igetind(65),igetflux(65)
      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME
      common/prav/IDAVER

      COMMON/GRTOOL/IHFLAG,IDHFLG,ILFLAG
      COMMON/EXPORTI/ixopen,ixunit,ixpunit

C Occupancy filter info.
      COMMON/IGETFLG/IOCUPF,ialstused,IROC
      common/mfocup/iocpzone

      COMMON/MSYSPICK/NPGET,IPGETNO(MSYSRS,8)
      COMMON/SYSLABEL/SPLABEL(MSYSRS),GPLABEL(MSYSRS)

C Simulator parameters.
      COMMON/SPFL/spfileok,perok,cfdperok,tstepok,saveok,autook,exitok,
     &  startupok
      LOGICAL spfileok,perok,cfdperok,tstepok,saveok,autook,exitok,
     &  startupok
      COMMON/FREQS/NBINS,XBIN1,XBINN,DXBIN,IFREQ,IHITS,IMISS,INBIN(MF)
      integer ICBIN,IRCBIN
      COMMON/FREQS1/ICBIN(MF),IRCBIN(MF),ITOTAL
      common/ntype/isv(mpcom,mnodec)
      common/pcdat/ CSV1M(mnodec),CSV2M(mnodec),CSV3M(mnodec),
     &              NNODE(mpcom),nrecpc(mpcom)
      common/pcresres/ napout(mpcom),apcout(MPCRES)

C Flags identifying if results libries are available. =0 no lib, =1 lib exists.
      COMMON/LIBOK/IBLIB,IFLIB,ICLIB,IELIB,IPLIB

      dimension Yold(65),TIMEold(65),val(MSYSRS)
      character outs*124,TLABEL*60,trange*20,tranged*20
      character ALABEL(6)*12,t20*20,act*1
      CHARACTER PDESCR*64,SDESCR*44,DESCR*7,DESCR1*10,DESCR2*8
      character SPLABEL*32,GPLABEL*20
      CHARACTER DESCRH*5,DESCRD*5,DESCRJ*5,NT*14,XT*14
      character graftitle*64,grlbl*24,t24*24
      character ETEXT*124,t64*64
      dimension FMAX(MSYSRS), FMIN(MSYSRS), FTOTSD(MSYSRS)
      dimension FAVE(MSYSRS), FSTD(MSYSRS), NF(MSYSRS)
      dimension TMAX(MSYSRS), TMIN(MSYSRS), IQHRS(MSYSRS)

      integer YAXSET,ADDLIN,horaxisdiv

      integer iglib   ! if 1 then X11, if 2 then GTK, if 3 then text only.
#ifdef OSI
      integer IGX  ! see common graf2
      integer iside,isize,ifont     ! passed to viewtext
      integer iupdown,isym,iid1,iid2    ! passed to etplot
      integer iicol,ibsize
      integer iigl,iigr,iigt,iigb,iigw,iigwh
      integer iiw1,iiw2,iiw3,iiw4,iimenu
      integer ilf,igfw,igfh,ild,igdw,igdh
#else
      integer*8 IGX  ! see common graf2
      integer*8 iside,isize,ifont     ! passed to viewtext
      integer*8 iupdown,isym,iid1,iid2    ! passed to etplot
      integer*8 iicol,ibsize
      integer*8 iigl,iigr,iigt,iigb,iigw,iigwh
      integer*8 iiw1,iiw2,iiw3,iiw4,iimenu
      integer*8 ilf,igfw,igfh,ild,igdw,igdh
#endif

      logical colok,ok,unixok

      helpinsub='moplnt'  ! set for subroutine

C Begin with the menu type=4 (performance metrics).
      menutype=4
      ideflt=1
      call opnplt(npcomp,imode,ier)
      if(ier.ne.0) return  ! a -3 signals user cancel during file browse.

C Define prompt and set initial value of xquery.
      outs='  '
      XQUERY=0.0

C Check if can draw in colour.
      colok=.false.
      if(nzonec.ge.MSYSRS)colok=.true.
      
C If output to file alter the edisp unit number.
      itru = icout
      if(ixopen.eq.1)then
        itru = ixunit
        if(NPGET.ge.1)then
          write(outs,'(2a)')GPLABEL(1)(1:lnblnk(GPLABEL(1))),
     &      '>> file.'
        else
          write(outs,'(a)')' Output being directed to file.' 
        endif
        call edisp(iuout,outs)
      elseif(ixopen.eq.0)then
        if(MMOD.eq.8)call startbuffer()
      endif

C Call the menu of choices (this also sets some default options).
C First clear current selections.
      call MOSYSSU

C Save original date values before calling routines
      ibs3=ID1
      ibs4=IM1
      ibs5=ID2
      ibs6=IM2
      ibs7=ISDS
      ibs8=ISDF
      ibs9=NTS

C Assign new values
      ID1=IPSD1
      IM1=IPSM1
      ID2=IPSD2
      IM2=IPSM2
      ISDS=IPSDS
      ISDF=IPSDF
      NTS=NPTS

C Call the setup menu.
 1    call PLTTAB
      call edisp(iuout,' ')
      if(ixopen.eq.1)then
        itru = ixunit
      else
        itru = icout
      endif
      if (MENUTYPE.eq.-1)then

C User exited plttab via -end rather than to request something displayed.
C Restore original date values
        ID1=ibs3
        IM1=ibs4
        ID2=ibs5
        IM2=ibs6
        ISDS=ibs7
        ISDF=ibs8
        NTS=ibs9
        return
      endif
      if (MENUTYPE.eq.9)then
        CALL PSYCHART('p')
        goto 1
      endif

C Ask for set point value.
      if (MENUTYPE.eq.7.or.MENUTYPE.eq.8)then
        if (act(1:1).eq.'p') then
          continue
        else
          helptopic='plant_test_point_val'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL EASKR(XQUERY,' ','  Test point value ? ',
     &      0.0,'-',0.0,'-',20.0,'query value',IER,nbhelp)
        endif
      endif

C TSTART and TFINISH - start and finish timesteps from 00h00 on the 
C first day of output.
      ENTERVAL=1.0/FLOAT(NPTS)/24.0
      istart=((ioh1-1)+(iods-IPSDS)*24)*npts
      if(istart.eq.0)istart=1
      iend  =((ioh2)+(iodf-IPSDS)*24)*npts-1
      TSTART=float(istart)
      TFINSH=float(iend)

C Debug.
C      write(6,*) 'start and finish for graph ',TSTART,TFINSH

C Set add profile label ADDLIN=0 i.e. no add
      ADDLIN=0

C Generate a descriptive string for the time period to be displayed
C and the simulation and output timesteps.
      CALL HDDATE(PDESCR)
      CALL HDSTEP(SDESCR)

C For line graphs, check if axis is currently drawn, if not then scale.
      if (MENUTYPE.eq.3) then
        if(npget.eq.0)then
          call usrmsg('No items selected....',' ','W')
          goto 1
        endif
        do 5 I=1,NPGET
          IAX=IPGETNO(I,8)
          if (YAXSET(IAX).eq.0.or.ADDLIN.eq.0) then

C Setup parameters and call fnddat for each output to get required data.
C Set TIMEold to -ive number so as to identify first point to be plotted.
C The YMAX,MIN variables are for axis 1 through 5 max and min values.
            call AXISINT(3,ALABEL)
            do 6 J=1,65
              TIMEold(J)=-1.
 6          continue
          endif
 5      continue
      elseif (MENUTYPE.eq.4) then

C For timestep listings generate initial lines.
        if(npget.eq.0)then
          call usrmsg('No items selected....',' ','W')
          goto 1
        endif
        if (IHFLAG.eq.1) then
          call edisp(itru,'# Timestep performance metrics.')
        else
          call edisp(itru,'Timestep performance metrics.')
        endif
      endif
C      call usrmsg('Scanning data for range of values...','  ','-')

C Reset stats values.Set query hours to zero.
      do 55 I=1,MSYSRS 
        IQHRS(I)=0
        FTOTSD(I)=0.0
        FSTD(I)=0.0
        FAVE(I)=0.0
        NF(I)=0
        FMAX(I)= -1.E+10
        FMIN(I)=  1.E+10
 55   continue

C Set histogram bounds.
      XMAX=-1.E+10
      XMIN=1.E+10

C First recover bounds of selected data when no averaging is required
C << no occupancy sensing at this time >>
      if(iav.eq.0) then
        if(idaver.eq.0) then
          ctime=float(ioh1-1)/24.0+ENTERVAL/2.+float(iods)
        else
          ctime=float(ioh1-1)/24.0+enterval+float(iods)
        endif

C For each timestep.
C         do 100 ii=istart, iend, nout
        ii=istart
        do iid=IODS,IODF
        if (iid.eq.IODS) then
          iihs=IOH1
        else
          iihs=1
        endif
        if (iid.eq.IODF) then
          iihf=IOH2
        else
          iihf=24
        endif
        do iih=iihs,iihf
        do iits=1,NPTS,NOUT

C For each requested item.
          do 40 jstat=1,npget
            ipc =IPGETNO(jstat,2)
            nsnd=IPGETNO(jstat,3)
            if(IPGETNO(jstat,1).eq.9)then

C Asking for ambient db. Recover via call to mfclim
C Current timestep ii to a iday and hour (MINH).
C IPAR is one to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=1
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            elseif(IPGETNO(jstat,1).eq.12)then

C Asking for ambient rh.
C IPAR is four to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=7
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            else
              call fnddat(ii,ipc,ier)
              call isunix(unixok)
              if(ier.ne.0)then
                if(unixok)write(6,*) 'An error in fnddat ',ii,ipc,ier
                goto 40
              endif
            endif

C Node temperature (C)
            if(IPGETNO(jstat,1).eq.1)then
              val(jstat)=csv1m(nsnd)

C Node first phase mass flow rate (kg/s)
            elseif(IPGETNO(jstat,1).eq.2)then
              val(jstat)=csv2m(nsnd)

C Node second phase mass flow rate (kg/s)
            elseif(IPGETNO(jstat,1).eq.3)then
              val(jstat)=csv3m(nsnd)
            endif

C Node relative humidity %
            if(nsnd.gt.0)then
              if(IPGETNO(jstat,1).eq.4.and.csv2m(nsnd).gt.0.0) 
     &          val(jstat)=pcrh2(csv1m(nsnd),
     &          csv3m(nsnd)/csv2m(nsnd),patmos)
            endif

C Node specific humidity (kg(v)/kg(a))
            if(nsnd.gt.0)then
              if(IPGETNO(jstat,1).eq.5.and.csv2m(nsnd).gt.0.0) 
     &          val(jstat)=csv3m(nsnd)/csv2m(nsnd)
            endif

C Node enthalpy (J/kg K)
            if(nsnd.gt.0)then
              if(IPGETNO(jstat,1).eq.6.and.csv2m(nsnd).gt.0.0) then

C  ..water..
                if(isv(ipc,nsnd).eq.10.or.isv(ipc,nsnd).eq.20) 
     &             val(jstat)=csv1m(nsnd)*shth2o(csv1m(nsnd))

C  ..dry air..
                if(isv(ipc,nsnd).eq.1.or.isv(ipc,nsnd).eq.11) 
     &             val(jstat)=enthp2(csv1m(nsnd),0.0)

C  ..moist air..
                if(isv(ipc,nsnd).eq.21) 
     &             val(jstat)=enthp2(csv1m(nsnd),
     &                      csv3m(nsnd)/csv2m(nsnd))
              endif
            endif

C Node Dew Point temperature (C)
            if(nsnd.gt.0)then
              if(IPGETNO(jstat,1).eq.7.and.csv2m(nsnd).gt.0.0.and.
     &           isv(ipc,nsnd).eq.21) 
     &            val(jstat)=dewpt(csv3m(nsnd)/csv2m(nsnd),patmos)
            endif

C Additional output. Note that 'nsnd' is NOT a node, 
C it is the additional output number for the component considered.
            if(IPGETNO(jstat,1).eq.10) val(jstat)=apcout(nsnd)

C Calculate summary stats (part 1)
            if(VAL(jstat).gt.FMAX(jstat))then
              FMAX(jstat)=VAL(jstat)
              TMAX(jstat)=CTIME
            elseif(VAL(jstat).lt.FMIN(jstat))then
              FMIN(jstat)=VAL(jstat)
              TMIN(jstat)=CTIME
            endif
            FAVE(jstat)=FAVE(jstat)+VAL(jstat)
            NF(jstat)=NF(jstat)+1

C Set max and min for graph axis.
            IAX=IPGETNO(jstat,8)
            if (YAXSET(IAX).lt.2) then
              YMAX(IAX)=MAX(VAL(jstat),YMAX(IAX))
              YMIN(IAX)=MIN(VAL(jstat),YMIN(IAX))
              YAXSET(IAX)=1
            endif

C Set max and min for any histogram, (this follows the pattern
C used in frqdis.F where initial range of data is not filtered
C by occupancy.
            XMAX=MAX(VAL(jstat),XMAX)
            XMIN=MIN(VAL(jstat),XMIN)
   40     continue

C We have all the data for this timestep into val array.

C Debug.
C          write(6,'(F10.5,12(2x,G10.3))')
C     &      ctime,(val(jjj),jjj=1,npget)

C update ctime for the next loop.
C           ctime=ctime+enterval*float(nout)
          ii=ii+nout
          if(idaver.eq.0) then
            ctime=float(iih-1)/24.0+ENTERVAL/2.+float(iid)
          else
            ctime=float(iih-1)/24.0+enterval+float(iid)
          endif

C   100   continue
        enddo
        enddo
        enddo
      else

C Case when averaging is required
        if(idaver.eq.0) then
          ctime=float(ioh1-1)/24.0+ENTERVAL/2.+float(iods)
     &              +ENTERVAL*float(nout)/2.
        else
          ctime=float(ioh1-1)/24.0+enterval+float(iods)
     &              +ENTERVAL*float(nout)/2.
        endif
        do 111 jj=1,npget
  111     val(jj)=0.0
        jcount=0
C         do 120 ii=istart, iend
        ii=istart
        do iid=IODS,IODF
        if (iid.eq.IODS) then
          iihs=IOH1
        else
          iihs=1
        endif
        if (iid.eq.IODF) then
          iihf=IOH2
        else
          iihf=24
        endif
        do iih=iihs,iihf
        do iits=1,NPTS,NOUT

          do 60 jstat=1,npget
            ipc =IPGETNO(jstat,2)
            nsnd=IPGETNO(jstat,3)
            if(IPGETNO(jstat,1).eq.9)then

C Asking for ambient db. Recover via call to mfclim
C Current timestep ii to a iday and hour (MINH).
C IPAR is one to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=1
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            elseif(IPGETNO(jstat,1).eq.12)then

C Asking for ambient rh.
C IPAR is four to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=7
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            else
              call fnddat(ii,ipc,ier)
              call isunix(unixok)
              if(ier.ne.0)then
                if(unixok)write(6,*) 'An error in fnddat ',ii,ipc,ier
                goto 60
              endif
            endif

C Node temperature (C)
            if(IPGETNO(jstat,1).eq.1)then
              val(jstat)=val(jstat)+csv1m(nsnd)

C Node first phase mass flow rate (kg/s)
            elseif(IPGETNO(jstat,1).eq.2)then
              val(jstat)=val(jstat)+csv2m(nsnd)

C Node second phase mass flow rate (kg/s)
            elseif(IPGETNO(jstat,1).eq.3)then
              val(jstat)=val(jstat)+csv3m(nsnd)
            endif

C Node relative humidity %
            if(IPGETNO(jstat,1).eq.4.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=val(jstat)+pcrh2(csv1m(nsnd),
     &                   csv3m(nsnd)/csv2m(nsnd),patmos)

C Node specific humidity (kg(v)/kg(a))
            if(IPGETNO(jstat,1).eq.5.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=val(jstat)+csv3m(nsnd)/csv2m(nsnd)

C Node enthalpy (J/kg K)
            if(IPGETNO(jstat,1).eq.6.and.csv2m(nsnd).gt.0.0) then

C ..water..
              if(isv(ipc,nsnd).eq.10.or.isv(ipc,nsnd).eq.20) 
     &           val(jstat)=val(jstat)+csv1m(nsnd)*shth2o(csv1m(nsnd))

C ..dry air..
              if(isv(ipc,nsnd).eq.1.or.isv(ipc,nsnd).eq.11) 
     &           val(jstat)=val(jstat)+enthp2(csv1m(nsnd),0.0)

C ..moist air..
              if(isv(ipc,nsnd).eq.21) 
     &          val(jstat)=val(jstat)+enthp2(csv1m(nsnd),
     &                     csv3m(nsnd)/csv2m(nsnd))
            endif

C Node Dew Point temperature (C)
            if(IPGETNO(jstat,1).eq.7.and.csv2m(nsnd).gt.0.0.and.
     &         isv(ipc,nsnd).eq.21)  val(jstat)=val(jstat)
     &                          +dewpt(csv3m(nsnd)/csv2m(nsnd),patmos)

C Additional output.
C Note, in this case 'nsnd' is NOT a node, 
C it is the additional output number for the component considered.
            if(IPGETNO(jstat,1).eq.10)val(jstat)=val(jstat)+apcout(nsnd)
   60     continue
          jcount=jcount+1

C If we are at last timestep of the hour then average it
C and process the information.
          if(jcount.eq.nout) then
            do 112 jj=1,npget
              val(jj)=val(jj)/float(nout)
  112       continue

C Have averaged val array for the current hour.

C Debug.
C            write(6,'(f10.5,12(2x,G10.3))')
C     &            ctime,(val(jjj),jjj=1,npget)

C Calculate summary stats (part 1). Loop through each of
C the selected items to set FMAX, TMAX etc.
            do 61 jstat=1,npget
              if(VAL(jstat).gt.FMAX(jstat))then
                FMAX(jstat)=VAL(jstat)
                TMAX(jstat)=CTIME
              elseif(VAL(jstat).lt.FMIN(jstat))then
                FMIN(jstat)=VAL(jstat)
                TMIN(jstat)=CTIME
              endif
              FAVE(jstat)=FAVE(jstat)+VAL(jstat)
              NF(jstat)=NF(jstat)+1

C Set max and min for graph axis.
              IAX=IPGETNO(jstat,8)
              if (YAXSET(IAX).lt.2) then
                YMAX(IAX)=MAX(VAL(jstat),YMAX(IAX))
                YMIN(IAX)=MIN(VAL(jstat),YMIN(IAX))
                YAXSET(IAX)=1
              endif

C Set max and min for any histogram, (this follows the pattern
C used in frqdis.F where initial range of data is not filtered
C by occupancy.
              XMAX=MAX(VAL(jstat),XMAX)
              XMIN=MIN(VAL(jstat),XMIN)
  61        continue

C Tidy up in preparation for the next loop.
C             ctime=ctime+enterval*float(nout)
            ii=ii+nout
            if(idaver.eq.0) then
              ctime=float(iih-1)/24.0+ENTERVAL/2.+float(iid)
     &              +ENTERVAL*float(nout)/2.
            else
              ctime=float(iih-1)/24.0+enterval+float(iid)
     &              +ENTERVAL*float(nout)/2.
            endif

            do 113 jj=1,npget
              val(jj)=0.0
  113       continue
            jcount=0
          endif
C   120   continue
        enddo
        enddo
        enddo
      endif

C Calculate average.
      do 56 I=1,NPGET
        if(NF(I).ne.0) FAVE(I)=FAVE(I)/real(NF(I))
  56  continue

C      call usrmsg('Scanning data for range of values...done.','  ','P')
      if (MENUTYPE.eq.2) then

C Inform user of the histo range and reset nb of bins and typcial bin size.
        if(npget.eq.0)then
          call usrmsg('No items selected....',' ','W')
          goto 1
        endif
        write(outs,'(a,a,a,f9.2,a,f10.2)')'The ',
     &    GPLABEL(1)(1:lnblnk(GPLABEL(1))),' data range is',
     &    XMIN,' to',XMAX
        call edisp(itru,outs)
        DXBIN=0.0
        NBINS=1

C If in pif mode use default bin setup.
        if (act(1:1).eq.'p'.and.autook)then
          ok=.TRUE.
        else
          helptopic='plant_freq_reporting'
          call gethelptext(helpinsub,helptopic,nbhelp)
          call easkok(' ','Use default bins?',OK,nbhelp)
        endif
        if(ok)then

C Check data range and pick a suitable value for DXBIN. No more than 
C MF bins for any given range. 
          DELTA=XMAX-XMIN
          if (DELTA.lt.1.) then
            DXBIN=0.05
          elseif (DELTA.lt.2.) then
            DXBIN=0.1
          elseif (DELTA.lt.5.) then
            DXBIN=0.25
          elseif (DELTA.lt.15.) then
            DXBIN=0.5
          elseif (DELTA.lt.30.) then
            DXBIN=1.0
          elseif (DELTA.lt.60.) then
            DXBIN=2.0
          elseif (DELTA.lt.150.) then
            DXBIN=5.0
          elseif (DELTA.lt.300.) then
            DXBIN=10.0
          elseif (DELTA.lt.500.) then
            DXBIN=20.0
          elseif (DELTA.lt.1000.) then
            DXBIN=25.0
          elseif (DELTA.lt.2000.) then
            DXBIN=50.0
          elseif (DELTA.lt.5000.) then
            DXBIN=100.0
          elseif (DELTA.lt.10000.) then
            DXBIN=200.0
          elseif (DELTA.lt.20000.) then
            DXBIN=500.0
          elseif (DELTA.lt.50000.) then
            DXBIN=1000.0
          else
            DXBIN=100.0
          endif

C Bin sized from data max & min. 
          XBIN1=ANINT(XMIN/DXBIN)*DXBIN
          XBINN=ANINT(XMAX/DXBIN)*DXBIN
          NB=INT((XBINN-XBIN1)/DXBIN)
          if(NB.ge.MF)then
            write(outs,'(a,3(i4,a))')'The required ',NB,'bins > ',MF,
     &                      '(max number of bins). Using ',MF-1,'bins.'
            call edisp(iuout,outs)
            NB=MF-1
          endif
          NBINS=NB+1
          XDIFF=((NBINS*DXBIN)-(XBINN-XBIN1))/2.0
          XBIN1=XBIN1-XDIFF
          XBINN=XBINN+XDIFF
        else
          XBIN1=XMIN
          XBINN=XMAX
          helptopic='plant_freq_bin_data'
          call gethelptext(helpinsub,helptopic,nbhelp)
          call easkr(XBIN1,' ',' Minimum parameter value for bin ?',
     &      0.,'-',0.,'-',0.,'min bin parameter',IER,nbhelp)
          call easkr(XBINN,' ',' Maximum parameter value for bin ?',
     &      XBIN1,'F',0.,'-',0.,'max bin parameter',IER,nbhelp)
          call easki(NBINS,' ',' Number of bins required ? ',
     &      1,'F',MF,'F',0,'no of bins',IER,nbhelp)
          DXBIN=(XBINN-XBIN1)/NBINS
        endif
        call usrmsg(' ',' ','-')

C Error check on bin width.
        IF(DXBIN.le.0.0)then
          call edisp(iuout,'All data zero: no frequency distribution.')
          call edisp(iuout,'Data range error: plot abandoned.')

C Restore original values before returning
          ID1=ibs3
          IM1=ibs4
          ID2=ibs5
          IM2=ibs6
          ISDS=ibs7
          ISDF=ibs8
          NTS=ibs9
          RETURN
        endif

C Empty bins of hits.
        DO 510 I=1,NBINS
          INBIN(I) = 0
          ICBIN(I) = 0
  510   CONTINUE
        IHITS = 0
        IMISS = 0
        iover = 0
        iunder = 0
      elseif (MENUTYPE.eq.3) then

C Write graph head and set up axis positions and draw.
        IF(MMOD.EQ.8)THEN

C Setup and pass in parameters to win3d.
          iiw1=9; iiw2=30; iiw3=4; iiw4=3; iimenu=menuchw
          iigl=igl; iigr=igr; iigt=igt; iigb=igb; iigw=igw; iigwh=igwh
          ilf=2; ild=LIMTTY
          iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
          if(iglib.eq.1)then
            call feedbox(iimenu,ilf,igfw,igfh)
            call opengdisp(iimenu,ild,ilf,igdw,igdh)
          endif
          CALL win3d(iimenu,iiw1,iiw2,iiw3,iiw4,
     &      iigl,iigr,iigt,iigb,iigw,iigwh)
          igl=int(iigl); igr=int(iigr); igt=int(iigt); igb=int(iigb)
          igw=int(iigw); igwh=int(iigwh)
          call startbuffer()
        ENDIF

        WRITE(ETEXT,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &    SDESCR(12:lnblnk(SDESCR))
        iside=1; isize=0; ifont=1
        if(mmod.eq.8)then
          call viewtext(etext,iside,isize,ifont)
        else
          call viewtextwwc(etext,iside,isize,ifont)
        endif

        iancline=0
        if(graftitle(1:2).ne.'  ')then
          t64=graftitle
          if(iancline.gt.0)then
            iside=3; isize=1; ifont=2
            if(mmod.eq.8)then
              call viewtext(t64,iside,isize,ifont)
            else
              call viewtextwwc(t64,iside,isize,ifont)
            endif
          endif
          if(iancline.eq.0)then
            iside=2; isize=1; ifont=2
            if(mmod.eq.8)then
              call viewtext(t64,iside,isize,ifont)
            else
              call viewtextwwc(t64,iside,isize,ifont)
            endif
          endif
        endif

        call AXISPOS
        call AXISDRW(TSTART-1.0,TFINSH,ALABEL,'-')
      endif

C Recover and plot data. If listing to file or text feedback then
C write out labels for each column at the start.
      if (MENUTYPE.eq.4) then
        if(idaver.eq.0) then
           ctime=float(ioh1-1)/24.0+ENTERVAL/2.+float(iods)
        else
           ctime=float(ioh1-1)/24.0+enterval+float(iods)
        endif
        iday=INT(ctime)
        CALL STDATE(IYEAR,IDAY,DESCR,DESCR1,DESCR2)
        if (IDHFLG.eq.1) then
          outs='# '
          call edisp(itru,outs)
          write(outs,'(3A)')'# ',DESCR1,' timestep listing'
          call edisp(itru,outs)
          outs='# '
          call edisp(itru,outs)
        else
          outs='  '
        endif
        if (IHFLAG.eq.1) then
          outs='#Time'
        else
          outs='Time '
        endif
        K=6
        do 20 IL=1,NPGET
          KE=K+14
          if(KE.le.124)then
           write (outs(K:KE),'(a,a)') '|',GPLABEL(IL)(1:13)
           K=K+14
          endif
 20     continue

C Print titles on first day.
        call edisp(itru,outs)
        if (IDHFLG.eq.1) then
          outs='#    '
        else
          outs='     '
        endif
        if (IHFLAG.eq.1) then
          outs='#    '
        else
          outs='     '
        endif
        K=6
        do 225 IL=1,NPGET
          KE=K+14
          if(KE.le.124)then
           write (outs(K:KE),'(a,a)') '|',GPLABEL(IL)(14:20)
           K=K+14
          endif
 225    continue
        call edisp(itru,outs)
        if (IDHFLG.eq.1) then
          outs='#    '
        else
          outs='     '
        endif
        if (IHFLAG.eq.1) then
          outs='#    '
        else
          outs='     '
        endif
      endif

C Now, for each system timestep get the non-averaged data and
C deal with it.
      if(iav.eq.0) then
        if(idaver.eq.0) then
           ctime=float(ioh1-1)/24.0+ENTERVAL/2.+float(iods)
           gtime=TSTART
        else
           ctime=float(ioh1-1)/24.0+enterval+float(iods)
           gtime=TSTART
        endif

C Debug.
C        write(6,*) 'initial ctime gtime ',ctime,gtime,enterval

C For each timestep.
C         do 200 ii=istart, iend, nout
        ii=istart
        do iid=IODS,IODF
        if (iid.eq.IODS) then
          iihs=IOH1
        else
          iihs=1
        endif
        if (iid.eq.IODF) then
          iihf=IOH2
        else
          iihf=24
        endif
        do iih=iihs,iihf
        do iits=1,NPTS,NOUT

C For each requested item.
          do 240 jstat=1,npget
            ipc =IPGETNO(jstat,2)
            nsnd=IPGETNO(jstat,3)
            if(IPGETNO(jstat,1).eq.9)then

C Asking for ambient db. Recover via call to mfclim
C Current timestep ii to a iday and hour (MINH).
C IPAR is one to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=1
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            elseif(IPGETNO(jstat,1).eq.12)then

C Asking for ambient rh.
C IPAR is four to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=7
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            else
              call fnddat(ii,ipc,ier)
              call isunix(unixok)
              if(ier.ne.0)then
                if(unixok)write(6,*) 'An error in fnddat ',ii,ipc,ier
                goto 240
              endif
            endif

C Node temperature (C), first phase, 2nd phase.
            if(IPGETNO(jstat,1).eq.1)then
              val(jstat)=csv1m(nsnd)
            elseif(IPGETNO(jstat,1).eq.2)then
              val(jstat)=csv2m(nsnd)
            elseif(IPGETNO(jstat,1).eq.3)then
              val(jstat)=csv3m(nsnd)
            endif

C Node relative humidity %
            if(IPGETNO(jstat,1).eq.4.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=pcrh2(csv1m(nsnd),
     &                         csv3m(nsnd)/csv2m(nsnd),patmos)

C Node specific humidity (kg(v)/kg(a))
            if(IPGETNO(jstat,1).eq.5.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=csv3m(nsnd)/csv2m(nsnd)

C Node enthalpy (J/kg K)
            if(IPGETNO(jstat,1).eq.6.and.csv2m(nsnd).gt.0.0) then

C  ..water..
              if(isv(ipc,nsnd).eq.10.or.isv(ipc,nsnd).eq.20) 
     &           val(jstat)=csv1m(nsnd)*shth2o(csv1m(nsnd))

C  ..dry air..
              if(isv(ipc,nsnd).eq.1.or.isv(ipc,nsnd).eq.11) 
     &           val(jstat)=enthp2(csv1m(nsnd),0.0)

C  ..moist air..
              if(isv(ipc,nsnd).eq.21) 
     &           val(jstat)=enthp2(csv1m(nsnd),
     &                      csv3m(nsnd)/csv2m(nsnd))
            endif

C Node Dew Point temperature (C)
            if(IPGETNO(jstat,1).eq.7.and.csv2m(nsnd).gt.0.0.and.
     &         isv(ipc,nsnd).eq.21) 
     &        val(jstat)=dewpt(csv3m(nsnd)/csv2m(nsnd),patmos)

C Additional output. Note that 'nsnd' is NOT a node, 
C it is the additional output number for the component considered.
            if(IPGETNO(jstat,1).eq.10) val(jstat)=apcout(nsnd)
  240     continue

C We have the data for this timestep into val array.

C Debug.
C          write(6,'(F10.5,12(2x,G10.3))')
C     &            ctime,(val(jjj),jjj=1,npget)

          if (MENUTYPE.eq.4) then

C C Timestep listing. First split time into hours and minutes.
C             MINH=iih-1
C             MINU=INT((time-AINT(time))*60.+0.5)
C             if(MINH.lt.10)then
C               IF(MINU.LT.10)THEN
C                 WRITE(DESCRH,'(a1,i1,a2,i1)')'0',INT(TIME),'h0',MINU
C               ELSE
C                 WRITE(DESCRH,'(a1,i1,a1,i2)')'0',INT(TIME),'h',MINU
C               ENDIF
C             else
C               IF(MINU.LT.10)THEN
C                 WRITE(DESCRH,'(i2,a2,i1)')INT(TIME),'h0',MINU
C               ELSE
C                 WRITE(DESCRH,'(i2,a1,i2)')INT(TIME),'h',MINU
C               ENDIF
C             endif
C             outs='  '
            if (IHFLAG.eq.0) then 

C Split flow time into hours and minutes, repeating every 24 hours.
              ii_day=ii-(iid-IODS)*24*NPTS
              call STIME(ii_day,DESCRH)
              write (outs,'(a5)') DESCRH
              K=6
            else
              write (outs,'(f10.4)') ctime
              K=11
            endif
            do 410 IXY=1,NPGET
              KE=K+14
              if(KE.le.124)then
                write (outs(K:KE),'(f14.4)') VAL(IXY)
                K=K+14
              endif
 410        continue
            call eddisp(itru,outs)
          else

C Do the other menu types. If graph reset scaling factor for appropriate axis.
            do 400 IX=1,NPGET
              if (MENUTYPE.eq.3) then
                Iax=IPGETNO(IX,8)
                call linescale(iigl,Xadd,TSC,iigb,Yadd(Iax),YSC(Iax))
                if (TIMEold(IX).lt.0.0.or.ADDLIN.eq.1) then
                  TIMEold(IX)=0
                  Yold(IX)=VAL(IX)
                endif
                ioldpos=1
              endif

C If within requested output period.
              IF(GTIME.LT.(TSTART-1.0).or.GTIME.GT.TFINSH)goto 402
              if (MENUTYPE.eq.2) then

C First, recalculate time as it is done in table.F 
C If there is occupancy filter and occupancy then use pattern
C from zone iocpzone. Start with assumption of full occupancy.
                IB = INT(((VAL(IX) - XBIN1) / DXBIN) + 1.)
                if(IB.LE.0)then
                  iunder = iunder +1
                  IMISS = IMISS + 1
                elseif(IB.GT.NBINS)then
                  iover = iover +1
                  IMISS = IMISS + 1
                else
                  INBIN(IB) = INBIN(IB) + 1
                  IHITS = IHITS + 1
                endif
              elseif (MENUTYPE.eq.3) then

C Draw next section of line.
                iupdown=0
                isym=0
                if(ioldpos.eq.1)then
                  call etplot(TIMEold(IX),Yold(IX),iupdown,isym)
                endif
                ioldpos=0
                IPEN=1
                MARK=0
                RMK=AMOD(GTIME,DT)
                if (RMK.lt.0.001) MARK=6
                TIMEold(IX)=GTIME
                Yold(IX)=VAL(IX)

C If plotting colours for different components then recall which
C item we are dealing with. If the index of the item is greater
C than that of the number of colours re-use an earlier colour.
                if(colok)then
                  if(IPGETNO(IX,2).gt.0)then
                    ICM=IPGETNO(IX,2)
                    if(ICM.gt.nzonec) ICM=IPGETNO(IX,2)-nzonec
                    if(ICM.gt.nzonec) ICM=IPGETNO(IX,2)-nzonec
                    iicol=ICM
                    call winscl('z',iicol)
                  endif
                endif

C Plot the current value - this has already been copied to Yold and
C then reset to forground colour.
                iupdown=IPEN
                isym=MARK
                call etplot(GTIME,Yold(IX),iupdown,isym)
                if(colok)then
                  iicol=0
                  call winscl('-',iicol)
                endif
                call forceflush()
              elseif (MENUTYPE.eq.5) then

C Stats, calculate standard deviation.
                FTOTSD(IX)=FTOTSD(IX)+((FAVE(IX)-VAL(IX))**2)
                NF(IX)=NF(IX)+1
              elseif (MENUTYPE.eq.7) then

C Hours above, calculate standard deviation.
                if (VAL(IX).gt.XQUERY)then
                  IQHRS(ix)=IQHRS(IX)+1
                endif
              elseif (MENUTYPE.eq.8) then

C Hours below.
                if (VAL(IX).lt.XQUERY)then
                  IQHRS(ix)=IQHRS(ix)+1
                endif
              endif
 402          continue
 400        CONTINUE
          endif

C Tidy up in preparation for the next loop.
C           ctime=ctime+enterval*float(nout)
          ii=ii+nout
          if(idaver.eq.0) then
C            ctime=float(iih-1)/24.0+ENTERVAL/2.+float(iid)
             ctime = ctime+enterval*float(nout)
C            gtime=TSTART
          else
C            ctime=float(iih-1)/24.0+ENTERVAL/2.+float(iid)
            ctime = ctime+enterval*float(nout)
C            gtime=TSTART
          endif
          gtime=gtime+float(nout)

C Debug.
C          write(6,*) 'incr ii ctime gtime ',ii,ctime,gtime

C   200   continue
        enddo
        enddo
        enddo
      else

C Case when averaging IS required
        if(idaver.eq.0) then
          ctime=float(ioh1-1)/24.0+ENTERVAL/2.+float(iods)
     &              +ENTERVAL*float(nout)/2.
          gtime=TSTART
        else
          ctime=float(ioh1-1)/24.0+enterval+float(iods)
     &              +ENTERVAL*float(nout)/2.
          gtime=TSTART
        endif
        do 211 jj=1,npget
  211     val(jj)=0.0
        jcount=0
C         do 220 ii=istart, iend
        ii=istart
        do iid=IODS,IODF
        if (iid.eq.IODS) then
          iihs=IOH1
        else
          iihs=1
        endif
        if (iid.eq.IODF) then
          iihf=IOH2
        else
          iihf=24
        endif
        do iih=iihs,iihf
        do iits=1,NPTS,NOUT
          do 260 jstat=1,npget
            ipc =IPGETNO(jstat,2)
            nsnd=IPGETNO(jstat,3)
            if(IPGETNO(jstat,1).eq.9)then

C Asking for ambient db. Recover via call to mfclim
C Current timestep ii to a iday and hour (MINH).
C IPAR is one to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=1
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            elseif(IPGETNO(jstat,1).eq.12)then

C Asking for ambient rh.
C IPAR is four to get ambient db. Set ITS to 1 to get
C start of the hour.
              iday=INT(ctime)
              call DASYSTIME(II,TIME)
              MINH=INT(time)+1
              IPAR=7
              ITS=1
              call MFCLIM(IDAY,MINH,ITS,IPAR,VALC)
              val(jstat)=VALC
            else
              call fnddat(ii,ipc,ier)
              call isunix(unixok)
              if(ier.ne.0)then
                if(unixok)write(6,*) 'An error in fnddat ',ii,ipc,ier
                goto 260
              endif
            endif

C Node temperature (C), first phase, 2nd phase.
            if(IPGETNO(jstat,1).eq.1)then
              val(jstat)=val(jstat)+csv1m(nsnd)
            elseif(IPGETNO(jstat,1).eq.2)then
              val(jstat)=val(jstat)+csv2m(nsnd)
            elseif(IPGETNO(jstat,1).eq.3)then
              val(jstat)=val(jstat)+csv3m(nsnd)
            endif

C Node relative humidity %
            if(IPGETNO(jstat,1).eq.4.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=val(jstat)+pcrh2(csv1m(nsnd),
     &                   csv3m(nsnd)/csv2m(nsnd),patmos)

C Node specific humidity (kg(v)/kg(a))
            if(IPGETNO(jstat,1).eq.5.and.csv2m(nsnd).gt.0.0) 
     &        val(jstat)=val(jstat)+csv3m(nsnd)/csv2m(nsnd)

C Node enthalpy (J/kg K)
            if(IPGETNO(jstat,1).eq.6.and.csv2m(nsnd).gt.0.0) then

C ..water..
              if(isv(ipc,nsnd).eq.10.or.isv(ipc,nsnd).eq.20) 
     &           val(jstat)=val(jstat)+csv1m(nsnd)*shth2o(csv1m(nsnd))

C ..dry air..
              if(isv(ipc,nsnd).eq.1.or.isv(ipc,nsnd).eq.11) 
     &           val(jstat)=val(jstat)+enthp2(csv1m(nsnd),0.0)

C ..moist air..
              if(isv(ipc,nsnd).eq.21) 
     &          val(jstat)=val(jstat)+enthp2(csv1m(nsnd),
     &                     csv3m(nsnd)/csv2m(nsnd))
            endif

C Node Dew Point temperature (C)
            if(IPGETNO(jstat,1).eq.7.and.csv2m(nsnd).gt.0.0.and.
     &         isv(ipc,nsnd).eq.21)  val(jstat)=val(jstat)
     &                          +dewpt(csv3m(nsnd)/csv2m(nsnd),patmos)

C Additional output.
C Note, in this case 'nsnd' is NOT a node, 
C it is the additional output number for the component considered.
            if(IPGETNO(jstat,1).eq.10)val(jstat)=val(jstat)+apcout(nsnd)
  260     continue
          jcount=jcount+1

C If we are at last timestep of the hour then average it
C and process the information.
          if(jcount.eq.nout) then
            do 212 jj=1,npget
              val(jj)=val(jj)/float(nout)
  212       continue

C Have averaged val array for the current hour.

C Debug.
C            write(6,'(f10.5,12(2x,G10.3))')
C     &            ctime,(val(jjj),jjj=1,npget)

            if (MENUTYPE.eq.4) then

C C Split time into hours and minutes.
C               call DASYSTIME(II,TIME)
C               MINH=INT(time)
C               MINU=INT((time-AINT(time))*60.+0.5)
C               if(MINH.lt.10)then
C                 IF(MINU.LT.10)THEN
C                   WRITE(DESCRH,'(a1,i1,a2,i1)')'0',INT(TIME),'h0',MINU
C                 ELSE
C                   WRITE(DESCRH,'(a1,i1,a1,i2)')'0',INT(TIME),'h',MINU
C                 ENDIF
C               else
C                 IF(MINU.LT.10)THEN
C                   WRITE(DESCRH,'(i2,a2,i1)')INT(TIME),'h0',MINU
C                 ELSE
C                   WRITE(DESCRH,'(i2,a1,i2)')INT(TIME),'h',MINU
C                 ENDIF
C               endif
              outs='  '
              if (IHFLAG.eq.0) then 

C Split flow time into hours and minutes, repeating every 24 hours.
                ii_day=ii-(iid-IODS)*24*NPTS
                call STIME(ii_day,DESCRH)
                write (outs,'(a5)') DESCRH
                K=6
              else
                write (outs,'(f10.4)') ctime
                K=11
              endif
              do 412 IXY=1,NPGET
                KE=K+11
                if(KE.le.124)then
                  write (outs(K:KE),'(f11.4)') VAL(IXY)
                  K=K+11
                endif
 412          continue
              call eddisp(itru,outs)
            else

C Do the other menu types. If graph reset scaling factor for appropriate axis.
              do 401 IX=1,NPGET
                if (MENUTYPE.eq.3) then
                  Iax=IPGETNO(IX,8)
                  call linescale(iigl,Xadd,TSC,iigb,Yadd(Iax),
     &              YSC(Iax))
                  if (TIMEold(IX).lt.0.0.or.ADDLIN.eq.1) then
                    TIMEold(IX)=0
                    Yold(IX)=VAL(IX)
                  endif
                  ioldpos=1
                endif

C For current time:
C Within requested output period.
                IF(GTIME.LT.(TSTART-1.0).or.GTIME.GT.TFINSH)goto 403
                if (MENUTYPE.eq.2) then

C First, recalculate time as it is done in table.F 
C If there is occupancy filter and occupancy then use pattern
C from zone iocpzone. Start with assumption of full occupancy.
                  IB = INT(((VAL(IX) - XBIN1) / DXBIN) + 1.)
                  if(IB.LE.0)then
                    iunder = iunder +1
                    IMISS = IMISS + 1
                  elseif(IB.GT.NBINS)then
                    iover = iover +1
                    IMISS = IMISS + 1
                  else
                    INBIN(IB) = INBIN(IB) + 1
                    IHITS = IHITS + 1
                  endif
                elseif (MENUTYPE.eq.3) then

C Draw next section of line.
                  iupdown=0
                  isym=0
                  if (ioldpos.eq.1)then
                    call etplot(TIMEold(IX),Yold(IX),iupdown,isym)
                  endif
                  ioldpos=0
                  IPEN=1
                  MARK=0
                  RMK=AMOD((GTIME-(0.5*float(NOUT)/float(NPTS))),DT)
                  if (RMK.lt.0.001) MARK=6
                  TIMEold(IX)=GTIME
                  Yold(IX)=VAL(IX)

C If plotting colours for different components then recall which
C item we are dealing with. If the index of the item is greater
C than that of the number of colours re-use an earlier colour.
                  if(colok)then
                    if(IPGETNO(IX,2).gt.0)then
                      ICM=IPGETNO(IX,2)
                      if(ICM.gt.nzonec) ICM=IPGETNO(IX,2)-nzonec
                      if(ICM.gt.nzonec) ICM=IPGETNO(IX,2)-nzonec
                      iicol=ICM
                      call winscl('z',iicol)
                    endif
                  endif

C Plot the current value - this has already been copied to Yold and
C then reset to forground colour.
                  iupdown=IPEN
                  isym=MARK
                  call etplot(GTIME,Yold(IX),iupdown,isym)
                  if(colok)then
                    iicol=0
                    call winscl('-',iicol)
                  endif
                  call forceflush()
                elseif (MENUTYPE.eq.5) then

C Stats, calculate standard deviation.
                  FTOTSD(IX)=FTOTSD(IX)+((FAVE(IX)-VAL(IX))**2)
                  NF(IX)=NF(IX)+1
                elseif (MENUTYPE.eq.7) then

C Hours above, calculate standard deviation.
                  if (VAL(IX).gt.XQUERY)then
                    IQHRS(ix)=IQHRS(IX)+1
                  endif
                elseif (MENUTYPE.eq.8) then

C Hours below.
                  if (VAL(IX).lt.XQUERY)then
                    IQHRS(ix)=IQHRS(ix)+1
                  endif
                endif
  403           continue
 401          CONTINUE
            endif

C Tidy up in preparation for the next loop.
C             ctime=ctime+enterval*float(nout)
            ii=ii+nout
            if(idaver.eq.0) then
              ctime=float(iih-1)/24.0+ENTERVAL/2.+float(iid)
     &              +ENTERVAL*float(nout)/2.
            else
              ctime=float(iih-1)/24.0+enterval+float(iid)
     &              +ENTERVAL*float(nout)/2.
            endif
            gtime=gtime+float(nout)
            do 213 jj=1,npget
              val(jj)=0.0
  213       continue
            jcount=0
          endif
C   220   continue
        enddo
        enddo
        enddo
      endif

C Reset add profile.
      ADDLIN=0

C Calculate standard deviation and averages.
      if (MENUTYPE.eq.5) then
        if(npget.eq.0)then
          call usrmsg('No items selected....',' ','W')
          goto 1
        endif
        do 25 I=1,NPGET
          if (NF(I).lt.2) then
            FSTD(I)=0.
          else
            FSTD(I)=sqrt(FTOTSD(I)/real(NF(I)-1))
          endif
 25     continue
      endif

      if (MENUTYPE.eq.2) then

C For histogram, save largest number of hits in a bin (IFREQ).
        IFREQ=0
        DO 700 I=1,NBINS
          IFREQ=MAX(IFREQ,INBIN(I))
  700   CONTINUE

C Calculate cumulative frequency.
        ITOTAL=0
        DO 710 I=1,NBINS
          IF(I.EQ.1)ICBIN(I)=INBIN(I)
          IF(I.GT.1)ICBIN(I)=ICBIN(I-1)+INBIN(I)
          ITOTAL=ITOTAL+INBIN(I)
  710   CONTINUE

C Ask user how data should be presented.
        helptopic='res_freq_menu_options'
        call gethelptext(helpinsub,helptopic,nbhelp)
        IDG=1
        IG=1
        CALL MENUATOL('Frequency choices','Frequency reports:',
     &    'a frequency distribution','b cumulative freq. dist.',
     &    'c summary table ','d frequency dist. + table',
     &    'e cumulative dist. + table','f none of the above',
     &    ' ',' ',' ',' ',' ',' ',IG,IDG,nbhelp)
        if(IG.eq.6) goto 1
        IF(IG.EQ.1.OR.IG.EQ.2.OR.IG.EQ.4.OR.IG.EQ.5)then

C Invoke drawing routines.  If echoing graphics to file, close it
C after image and advise user. If there is only one item then
C write heading with its identifier, otherwise include (...) to
C indicate that several flow items (e.g. nodes) are included.
          if(MMOD.eq.8)then

C Write graph head and set up axis positions and draw.
C Setup and pass in parameters to win3d.
            iiw1=9; iiw2=30; iiw3=4; iiw4=3; iimenu=menuchw
            iigl=igl; iigr=igr;iigt=igt;iigb=igb;iigw=igw;iigwh=igwh
            iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
            if(iglib.eq.1)then
              ilf=2; ild=LIMTTY
              call feedbox(iimenu,ilf,igfw,igfh)
              call opengdisp(iimenu,ild,ilf,igdw,igdh)
            endif
            CALL win3d(iimenu,iiw1,iiw2,iiw3,iiw4,
     &        iigl,iigr,iigt,iigb,iigw,iigwh)
            igl=int(iigl); igr=int(iigr);igt=int(iigt);igb=int(iigb)
            igw=int(iigw); igwh=int(iigwh)
            call startbuffer()

            WRITE(ETEXT,'(3A)')PDESCR(1:lnblnk(PDESCR)),' ',
     &        SDESCR(12:lnblnk(SDESCR))
            iside=1; isize=0; ifont=1
            call viewtext(etext,iside,isize,ifont)
            TLABEL='  '
            if(NPGET.eq.1)then
              write (TLABEL,'(2a,f6.2)')
     &          GPLABEL(1)(1:lnblnk(GPLABEL(1))),', Bin width =',
     &          DXBIN
            else
              write (TLABEL,'(2a,f6.2)')
     &          GPLABEL(1)(1:lnblnk(GPLABEL(1))),
     &          ' (...), Bin width =',DXBIN
            endif
            if(IG.eq.1.or.IG.eq.4)CALL MODDRW(1,TLABEL,0,0)
            if(IG.eq.2.or.IG.eq.5)CALL MODDRW(2,TLABEL,0,0)
          else
            call edisp(iuout,' Sorry, not in graphic mode...')
          endif
        endif
        if(IG.EQ.3.OR.IG.EQ.4.OR.IG.EQ.5)then

C If output to file alter the edisp unit number and then write out
C a tabular report.
          itru = icout
          if(ixopen.eq.1)then
            itru = ixunit
            call edisp(icout,' Output being directed to file... ')
          endif

          call edisp(itru,' ')
          call edisp(itru,GPLABEL(1))
          call edisp(itru,
     &' Bin   data range       Distri-  freq.   cumulative  cumulative')
          call edisp(itru,
     &'                        bution    (%)   distribution  freq (%)')

C Provide initial range and then loop through each.
          XBINS=XBIN1
          XBIN=XBIN1+DXBIN
          DO 101 I=1,NBINS
            write(trange,'(F9.2,a,F9.2)') XBINS,'-',XBIN
            call SDELIM(trange,tranged,'N',IW)
            XBINS=XBIN
            XBIN=XBIN+DXBIN
            CFREQ=(FLOAT(ICBIN(I))/FLOAT(ITOTAL))*100.0
            FREQ=(FLOAT(INBIN(I))/FLOAT(ITOTAL))*100.0
            if(I.eq.1)then
              WRITE(outs,'(i3,2x,a,i5,2x,f6.2,i9,f12.2,a,i6,a)') I,
     &        tranged,INBIN(I),FREQ,ICBIN(I),CFREQ,'  ',iunder,' below'
            elseif(I.eq.NBINS)then
              WRITE(outs,'(i3,2x,a,i5,2x,f6.2,i9,f12.2,a,i6,a)') I,
     &        tranged,INBIN(I),FREQ,ICBIN(I),CFREQ,'  ',iover,' above'
            else
              WRITE(outs,'(i3,2x,a,i5,2x,f6.2,i9,f12.2)')I,tranged,
     &        INBIN(I),FREQ,ICBIN(I),CFREQ
            endif
            call eddisp(itru,outs)
  101     CONTINUE
        endif

C Reset the number of requested items (NPGET) so that if another
C histogram metric is selected it will be the first one.
        call usrmsg('Current selections have been cleared,',
     &    'you will need to re-select.','P')
        NPGET=0
      elseif (MENUTYPE.eq.3) then

C Finally label lines, matching zone line colour if used.
        ibsize=0
        do 202 I=1,NPGET
          Iax=IPGETNO(I,8)
          call linescale(iigl,Xadd,TSC,iigb,Yadd(Iax),YSC(Iax))
          t20=GPLABEL(I)
          if(colok)then
            if(IPGETNO(I,2).gt.0)then
              ICM=IPGETNO(I,2)
              if(ICM.gt.nzonec) ICM=IPGETNO(I,2)-nzonec
              if(ICM.gt.nzonec) ICM=IPGETNO(I,2)-nzonec
              iicol=ICM
            endif
          endif
          call u2pixel(TIMEold(I),Yold(I),iid1,iid2)
          call textsizeatxy(iid1,iid2,t20,ibsize,'z',iicol)
          if(colok)then
            iicol=0
            call winscl('-',iicol)
          endif
          call forceflush()
 202    continue

C If there are optional user defined labels draw them.
        if(ngrlbl.gt.0)then
          ibsize=0; iicol=0
          do 201 ijj=1,ngrlbl
            t24=grlbl(ijj)
            iid1=lblpx(ijj); iid2=lblpy(ijj);
            call textsizeatxy(iid1,iid2,t24,ibsize,'-',iicol)
 201      continue
        endif
      elseif (MENUTYPE.eq.5) then

C Display stats.
        write (outs,'(a,a)') 
     &    '                            Maximum                 Minimum',
     &    '               Mean         Standard'
        call eddisp(itru,outs)
        write (outs,'(a,a)') 
     &    '                        value    occurrence     value    ',
     &    '  occurrence     value        deviation'
        call eddisp(itru,outs)
        do 210 I=1,NPGET

C Create string description for time of maximum occurrance.
C TMAX & TMIN will have been recorded as a Julian day.
          MAXDOY=INT(TMAX(I))
          TMAXHR= (TMAX(I)-INT(TMAX(I)))*24.0
          call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
          MINDOY=INT(TMIN(I))
          TMINHR= (TMIN(I)-INT(TMIN(I)))*24.0
          call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (NT,'(a,a,a)')DESCR(1:6),'@',DESCRH
          t20=GPLABEL(I)
C          write (outs,'(a,1x,2(f8.2,2x,a12,2x),2(f7.2,3x))') t20,
C     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),FSTD(I)
C          call eddisp(itru,outs)
          write (outs,'(a,1x,2(g10.4,2x,a12,2x),2(g10.4,3x))') t20,
     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),FSTD(I)
          call eddisp(itru,outs)
 210    continue
        if(iocupf.eq.1.and.iocpzone.ne.0)then
          call eddisp(itru,'(above data filtered by occupancy)')
        endif
      elseif (MENUTYPE.eq.7) then

C Display stats + hrs above.
        write (outs,'(a,f7.2)')'Reporting number of hours above ',XQUERY
        call edisp(itru,outs)
        call edisp(itru,'  ')
        write (outs,'(a,a)') 
     &    '                           Maximum                Minimum',
     &    '                 Mean     Hours'
        call eddisp(itru,outs)
        write (outs,'(a,a)')
     &    '                       value     occurrence     value    ',
     &    '  occurrence     value    above'
        call eddisp(itru,outs)
        do 221 I=1,NPGET

C Create string description for time of maximum occurrance.
          MAXDOY=INT(TMAX(I)/24.)+IODS
          TMAXHR=AMOD(TMAX(I),24.)
          call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (XT,'(a,a,a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
          MINDOY=INT(TMIN(I)/24.)+IODS
          TMINHR=AMOD(TMIN(I),24.)
          call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (NT,'(3a)')DESCR(1:6),'@',DESCRH
          AYAB=float(IQHRS(I))*float(NOUT)/float(NTS)
          t20=GPLABEL(I)
C          write (outs,'(a,1x,2(f8.2,2x,a12,1x),2f9.2)') t20,
C     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),AYAB
C          call eddisp(itru,outs)
          write (outs,'(a,1x,2(g10.4,2x,a12,1x),2g10.4)') t20,
     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),AYAB
          call eddisp(itru,outs)

C Debug.
C          write(6,*) FMAX(I),FMIN(I),FAVE(I),FSTD(I),IQHRS(I)

 221    continue
        if(iocupf.eq.1.and.iocpzone.ne.0)then
          call eddisp(itru,'(above data filtered by occupancy)')
        endif
      elseif (MENUTYPE.eq.8) then

C Display stats + hrs below.
        write (outs,'(a,f7.2)')'Reporting number of hours below ',XQUERY
        call edisp(itru,outs)
        call edisp(itru,'  ')
        write (outs,'(a,a)') 
     &    '                           Maximum                Minimum',
     &    '                 Mean     Hours'
        call eddisp(itru,outs)
        write (outs,'(a,a)') 
     &    '                       value     occurrence     value    ',
     &    '  occurrence     value    below'
        call eddisp(itru,outs)
        do 230 I=1,NPGET

C Create string description for time of maximum occurrance.
          MAXDOY=INT(TMAX(I)/24.)+IODS
          TMAXHR=AMOD(TMAX(I),24.)
          call STDATE(IYEAR,MAXDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMAXHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (XT,'(3a)')DESCR(1:6),'@',DESCRH

C Create string description for time of minimum occurrance.
          MINDOY=INT(TMIN(I)/24.)+IODS
          TMINHR=AMOD(TMIN(I),24.)
          call STDATE(IYEAR,MINDOY,DESCR,DESCR1,DESCR2)
          call EDTIME(TMINHR,DESCRH,DESCRD,DESCRJ,TIMER)
          write (NT,'(3a)')DESCR(1:6),'@',DESCRH
          AYAB=float(IQHRS(I))*float(NOUT)/float(NTS)
          t20=GPLABEL(I)
C          write (outs,'(a,1x,2(f8.2,2x,a12,1x),2f9.2)') t20,
C     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),AYAB
C          call eddisp(itru,outs)
          write (outs,'(a,1x,2(g10.4,2x,a12,1x),2g10.4)') t20,
     &      FMAX(I),XT,FMIN(I),NT,FAVE(I),AYAB
          call eddisp(itru,outs)

C Debug.
C          write(6,*) FMAX(I),FMIN(I),FAVE(I),FSTD(I),IQHRS(I)

 230    continue
        if(iocupf.eq.1.and.iocpzone.ne.0)then
          call eddisp(itru,'(above data filtered by occupancy)')
        endif
      endif

      goto 1

      END
