C ESP-r is free software. You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 or later).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file comprises the following routines.
C prj        - main program.
C simula     - commissions technical assessments and analysis.
C checkmodel - checks model prior to commissioning a simulation.
C imgdisp    - displays images associated with start-up or at
C              specific points thereafter.
C CFGVER     - supports the creation of model variants.
C VERMAN     - copies model files and names them uniquely in
C              order to build multiple variants of a base case model.
C FNCNGR     - changes the name of file ORIGNAM by appending APP


C ******************** prj ********************
C Main program for the ESP-r Project Manager.

      program prj
      USE START_UP
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "uncertainty.h"
#include "esprdbfile.h"
#include "material.h"
#include "espriou.h"
#include "control.h"
#include "net_flow.h"
#include "prj3dv.h"
#include "ipvdata.h"
#include "sbem.h"
#include "schedule.h"
#include "help.h"

      PARAMETER (MSTMC=20)
      
      integer lnblnk  ! function definition

      common/initv/initvt,EYEMI(3),VIEWMI(3),ANGI
      common/SPAD/MMOD,LIMIT,LIMTTY
      integer childterminal  ! picks up mmod from starting of prj
      common/childt/childterminal
      integer iuout,iuin,ieout
      common/OUTIN/IUOUT,IUIN,IEOUT

C Attributes of the session log file.
      logical ieopened     ! Has session file been started/requested.
      integer iecount      ! Does it hold error messages.
      character iefile*72  ! The name of the session file.
      common/logs/ieopened,iecount,iefile

C Attributes of session keystroke file.
      logical ikopened     ! Has keystoke file been started/requested.
      integer ikcount      ! Number of entries.
      integer ikout        ! File unit for keystrokes.
      character ikfile*72  ! The name of the keystroke file.
      common/logk/ikopened,ikcount,ikout,ikfile

C Markdown flag.
      logical markdown
      common/markdownflag/markdown
      integer ifs,itfs,imfs
      common/GFONT/IFS,ITFS,IMFS
      common/FILEP/IFIL
      common/appw/iappw,iappx,iappy
      integer iappw,iappx,iappy
      common/appcols/mdispl,nifgrey,ncset,ngset,nzonec
      common/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      INTEGER :: iairn,icaas
      
      integer ncomp,ncon
      common/C1/NCOMP,NCON
      common/C6/INDCFG
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      common/cctlnm/ctldoc,lctlf

C Significant figure reporting limit (NSIGFIG).
      common/SFIG/NSIGFIG

C Ground topology.
      common/GTFIL/GTGEOM

C Path to model and command line file (if any). Browse
C is a logical flag, .true. restricts update/save options.
      common/rpath/path
      common/rcmd/LCMDFL

      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh

C Extended simulation parameters for each set.
      common/spfldats/isstupex(MSPS),isbnstepex(MSPS),ispnstepex(MSPS),
     &  issaveex(MSPS),isavghex(MSPS),iscfdactivate(MSPS),
     &  isicfdys(MSPS),isicfdyf(MSPS),
     &  scftims(MSPS),scftimf(MSPS)
      INTEGER :: isstupex,isbnstepex,ispnstepex,issaveex,isavghex
      INTEGER :: iscfdactivate      ! zero ignore domains
      INTEGER :: isicfdys,isicfdyf  ! CFD simulation start & finish days
      REAL :: scftims,scftimf       ! CFD simulation start & finish time

C Indicator of possible focus zone.
      common/rzone/inzone
      common/user/browse

C Redirected text/graphics parameters.
      common/exporttgi/ixopen,ixloc,ixunit

C Where ESP-r was installed (as recorded when it was compiled).
      common/deflt4/dinstpath

      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton

C IPV description via ipvdata.h.
      common/IPVF/lipvdatf

      integer menuchw,igl,igr,igt,igb,igw,igwh
      common/VIEWPX/menuchw,igl,igr,igt,igb,igw,igwh
      common/wkdtyp/idwe1,idwe2,wkd1,wkd2
      common/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME
      common/gzonpik/izgfoc,nzg,nznog(mcom)
      common/FOPENED/CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK

C IDST tool commands.
      common/idsta/CMDCFG,CMDCLM,CMDCLMN,CMDNOTE,CMDRES,CMDLBL(10),
     &             CMDLNAM(10)
      common/idstb/nidst

      COMMON/BIDIRFL/bidirfile,bidirname(MSTMC)
      COMMON/OVRWT/AUTOVR
      logical AUTOVR

C 3D visualisation mode.
      COMMON/MODVIS/IVISMOD

C Name of current application
      common/APPNAME/cAppName
      character cAppName*12

C Tolerance for surface matching.
      real ANGCC  ! angle between surfaces tolerance
      real CACC   ! tolerance between vertices
      real DACC   ! angle tolerance along line
      real COGCC  ! tolerance between surface COG
      real SNACC  ! tolerance between surface areas
      integer IACC ! number of matching corners outside dist tolerance
      common/matching/ANGCC,CACC,DACC,COGCC,SNACC,IACC
      
C Topic variables: value of zero = none, one = compact, two = verbose,
C three = very verbose, -1 = applicable. Initial assumption is verbose
C for most topics. 
      integer siteinfo,databaseinfo,contextinfo,controlinfo,netinfo
      integer plantinfo,geominfo,schedinfo,zoneextrainfo,fileinfo
      integer spminfo,enetinfo
      integer zonecolumns,surfcolumns  ! patterns of zone and surface columns
      common/qatopics/siteinfo,databaseinfo,contextinfo,controlinfo,
     &  netinfo,plantinfo,geominfo,schedinfo,zoneextrainfo,fileinfo,
     &  spminfo,enetinfo,zonecolumns,surfcolumns

      integer mlcnamegt24         ! number of instances of long MLC names.
      integer mlcindex32          ! indices of long MLCs
      integer mlcindex24          ! indies of paired shorter MLCs
      integer mlcindexo32         ! indices of MLCs paired to long MLCs
      integer mlcindexo24         ! indies of short naed paired MLCs
      integer mlcx32refs          ! references to long MLCs
      common/mlclong/mlcnamegt24,mlcindex32(6),mlcindex24(6),
     &               mlcindexo32(6),mlcindexo24(6),mlcx32refs

      integer iverb     ! verbosity passed on command line
      logical OK,CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,MODSIT,CFCDBOK
      logical browse,confirm,XST,ckpath
      logical unixok,changedit
      logical itisanexemplar  ! passed to newprb to ensure browse mode.

      character dstmp*24,uname*24
      character LTMP*72
      character inf*144,inz*16,inzone*16,act*16,inact*16,LCMDFL*144
      character outs*124,outstr*124
C      character outs248*248
      character path*72,exemplar*144
      character LAPROB*72
      character ITEMS(28)*34
      character ltcmdfl*144
      character ctldoc*248,lctlf*72,ETEXT*82
      character tfile*72
      character GTGEOM*72,lipvdatf*72,longtfile*144
      character*10 wkd1, wkd2
      character CMDCFG*72,CMDCLM*72,CMDCLMN*72,CMDNOTE*64,CMDRES*72
      character CMDLBL*12,CMDLNAM*80
      CHARACTER topt*72
      character t32*32,DFILE*72,DCNN*72
      character bidirfile*72,bidirname*12
      CHARACTER dinstpath*60,dirpath*72
      character useraction*8  ! returned from exemplar access call.
      character menu*72       ! model title for pregist call
      character fs*1

C Passed parameters for pregist.
      character root*32,mpath*72

C Returned parameters from silentread or silentxmlread.
      character theprimedirective*8
      integer iappwpc ! application height as % of nominal size
      integer itrc    ! feedback level during scans
      integer iglib   ! if 1 then X11, if 2 then GTK, if 3 then text only.
      real d1,d2,d3   ! data used with transfor or rotate command line
      integer ivals   ! holds list of zones to be rotated or transformed.
      integer MITEM,INO ! max items and current menu item
      dimension ivals(MCOM)
      logical silent  ! for dependency checking on transform or rotate
      logical QUIET   ! to force silent rebuild of zone constructions

      character cVnum*38      ! returned from ESPrVersionNum
      character pagestitle*68 ! for banner title via epages call
      character subpath*84,troot*32
      character sfile*144
      character odir*84
      character cfgpath*144   ! full path to cfg folder for refocus
      character thecfgis*72   ! cfg file only
      character hold32*32     ! test whether curl is installed
      character doit*248      ! to invoke curl command
      character theupdatefile*72,msg*96
      character modt*12,actt*34,actv*4
      character update_ver*38,updatecomment*124
      character tmode*8
      integer nbupdatecomments
      dimension updatecomment(20)

      integer ianother   ! jump to previous or next zone flag

#ifdef OSI
      integer iside,isize,ifont     ! passed to viewtext
      integer numberofzones ! to pass to updwire rather than ncomp
      integer iigl,iigr,iigt,iigb,iigw,iigwh
      integer iiw1,iiw2,iiw3,iiw4,iimenu
      integer iicapture,iiazi    ! to pass to updcapt updazi
#else
      integer*8 iside,isize,ifont     ! passed to viewtext
      integer*8 numberofzones
      integer*8 iigl,iigr,iigt,iigb,iigw,iigwh
      integer*8 iiw1,iiw2,iiw3,iiw4,iimenu
      integer*8 iicapture,iiazi    ! to pass to updcapt updazi
#endif

C Initialize variables and recover command line arguments.
      call ezero
      call curmodule('prj ')
      cAppName = 'prj'
      helpinapp='prj'  ! set once for the application
      helpinsub='prj'  ! set for MAIN
      IUOUT=6
      IUIN=5
      LIMTTY=30
      LIMIT =30
      IFIL=11
      iuj=IFIL+10   ! use for journal

C Other file units used in esruprj:
C  ifil+1 (lots of uses), ifil+2 (lots of uses), ifil+3 (in mksbem and mlc db)
C  ifile+4 (in mksbem and mat db), ifil+5 (in anlyt tdf editing scanning cfg files)
C  ifil+6 (databases and mass flow), ifil+7 (temporal )
C  ifil+8 (?), ifil+9 file export, ifil+10 (AIM, DHW and journal),
C  ifil+11 (external help text), ifil+19 ifil+20 ifil+21 analytics.

C Recover command line parameters (terminal, size (iappx) position (iappx iappy),
C config file, zone focus and actions arguments).
      call parsprj(MODL,iappw,iappx,iappy,inf,inz,act,d1,d2,d3,iverb,
     &  ikey)
C      write(6,*) 'inf ',inf(1:lnblnk(inf))
C      write(6,*) 'act ',act(1:lnblnk(act))
C      write(6,*) 'inz ',act(1:lnblnk(inz))
C      write(6,*) 'd1 d2 d3 ',d1,d2,d3
C      write(6,*) 'MODL iverb key ',MODL,iverb,ikey
      itrc=iverb    ! set trace level after call to parsprj
      IFDAY=2
      IFTIME=0
      nsset=0
      isset=0
      isstup=0; isstupex(1)=0
      isbnstep=4; isbnstepex(1)=4
      ispnstep=2; ispnstepex(1)=2
      issave=2; issaveex(1)=2
      isavgh=0; isavghex(1)=0
      iscfdactivate(1)=0; isicfdys(1)=0; isicfdyf(1)=0
      scftims(1)=0.0; scftimf(1)=23.9
      NSIGFIG=3
      childterminal=MODL          ! remember so that child processes can run the same
      markdown=.false.            ! reporting in plain text rather than markdown
      mlcnamegt24=0; mlcx32refs=0 ! Reset count of long MLC names & references
      mlcindex32(1)=0; mlcindex32(2)=0; mlcindex32(3)=0     ! clear long name slots
      mlcindex32(4)=0; mlcindex32(5)=0; mlcindex32(6)=0 
      mlcindex24(1)=0; mlcindex24(2)=0; mlcindex24(3)=0     ! clear linked shortened slots
      mlcindex24(4)=0; mlcindex24(5)=0; mlcindex24(6)=0 
      mlcindexo32(1)=0; mlcindexo32(2)=0; mlcindexo32(3)=0  ! clear paired long name slots
      mlcindexo32(4)=0; mlcindexo32(5)=0; mlcindexo32(6)=0 
      mlcindexo24(1)=0; mlcindexo24(2)=0; mlcindexo24(3)=0  ! clear paired linked shortened slots
      mlcindexo24(4)=0; mlcindexo24(5)=0; mlcindexo24(6)=0 

C Initial assumptions about common data files (prior to configuration file scan
C that the default common data files will be defined explicitly).
      matver=0.0   ! initial assumption of binary materials database
      ipathapres=0; ipathoptdb=0; ipathpcdb=0; ipathprodb=0
      ipathmat=0; ipathmul=0; ipathclim=0; ipathsbem=0; ipathmsc=0
      ipathmould=0
      usecurcfg=0     ! Mark user has not offered opion on cfg version.

C Initial assumptions about QA reporting.
      siteinfo=1      ! constrained site information
      databaseinfo=1  ! constrained database reporting
      contextinfo=1   ! constrained context information
      controlinfo=-1  ! no control reporting
      spminfo=-1      ! no special material reporting
      netinfo=-1      ! no network reporting
      enetinfo=-1     ! no electrical reporting
      geominfo=2      ! full geometry
      schedinfo=2     ! full schedules
      zoneextrainfo=1 ! few anciliary files
      zonecolumns=3   ! all columns of zone reporting
      surfcolumns=3   ! all columns of surface reporting

C Set initial values for surface-to-surface matching.
      ANGCC=10.0; CACC=0.025; DACC=5.0; COGCC=1.0; SNACC=0.5; IACC=0 
      
C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif
      write(path,'(a1,a1)')'.',fs
      write(upath,'(a1,a1)')'.',fs
      write(zonepth,'(a1,a1)')'.',fs
      write(netpth,'(a1,a1)')'.',fs
      write(ctlpth,'(a1,a1)')'.',fs
      write(mscpth,'(a1,a1)')'.',fs
      write(imgpth,'(a1,a1)')'.',fs
      write(radpth,'(a1,a1)')'.',fs
      write(docpth,'(a1,a1)')'.',fs
      write(dbspth,'(a1,a1)')'.',fs
      write(tmppth,'(a1,a1)')'.',fs
      IYEAR=2022
      IBDOY=1
      IEDOY=365
      cfgroot=' '
      troot=' '
      LCTLF=' '
      LCNN=' '
      LAPROB='  '
      lradcf='UNKNOWN'
      GTGEOM='UNKNOWN'
      LUALF='UNKNOWN'
      lipvdatf='UNKNOWN'
      LASBEM='UNKNOWN'  ! assume no UK NCM description
      nipvassmt=0  ! to signal initially no IPV defined
      dmdsdesc='no dispersed demands notes (yet)'
      bdmds='UNKNOWN'
      bidirfile='UNKNOWN'

C Assume weekends are Saturday & Sunday unless re-defined.
      idwe1=6
      idwe2=7
      wkd1='Saturday'
      wkd2='Sunday'

C Set upgrade files flag to zero (no opinion yet).
      igupgrade=0

C Clear number of images and allow image browsing.
      noimg=0
      iton=0
      NALOC= 0
      nidst= 0

C Initialise coordinates for eye point, view point and angle of view.
      EYEM(1)=-100.0; EYEM(2)=-100.0; EYEM(3)=100.0
      VIEWM(1)=10.0; VIEWM(2)=10.0; VIEWM(3)=10.0
      ANG=40.
      IVISMOD=1

C General image option flags.
      ITDSP=0; ITBND=1; ITEPT=0; ITZNM=0; ITSNM=1; ITVNO=1
      ITORG=0; ITSNR=1; ITOBS=0; ITGRD=0
      GRDIS=0.0
      ITPPSW=0

C Set initial font sizes (IMFS is for menus, IFS is for dialog & ITFS text feedback).
C Fonts 4-7 are proportional and 0-3 are fixed width. Use proportional for menus
C and dialog.
      IMFS=5
      IFS=4
      ITFS=4

C Assume that the system configuration, multi-layered db, material db
C and control files have not been read in and that any files saved will
C be atrributed.
      CFGOK=.FALSE.
      MLDBOK=.FALSE.
      MATDBOK=.FALSE.
      CTLOK=.FALSE.
      OPTKOK=.FALSE.
      browse=.false.
      AUTOVR=.false.
      changedit=.false.
      MODSIT=.false.  ! assume model context has not changed.

C Initialise output device, assume minimal trace and a standard
C display.  If passed zero size and offsets use default (670 pixels
C high). If size is <200 then assume it is intended as a % of the
C nominal size and take % of default, otherwise use passed width.
C If left & top offsets are 0 then use defaults. If > 200 then it
C is treated as a specific pixel height.
      MMOD=MODL
      if(iappw.eq.0.and.iappx.eq.0.and.iappy.eq.0)then
        iappw=690  ! default height
        iappx=40
        iappy=40
        iappwpc=100   ! remember %
      else
        if(iappx.lt.0)iappx=40
        if(iappy.lt.0)iappy=40
        if(iappw.le.200)then
          iappwpc=iappw    ! remember %
          iappwi=int(690*iappw*0.01)
          iappw=iappwi
        elseif(iappw.gt.200)then
          iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          continue
        endif
      endif

C Set pixels high to iappw and pixels wide to factor in monitor size.
      iapphi=iappw
      iappwi=int(real(iappw)*(1024.0/700.0))

      if(iappwpc.gt.0.and.iappwpc.lt.100)then
        menuchw = MAX0(int(36*iappwpc*0.01),20)
        LIMTTY= MAX0(int(10*iappwpc*0.01),6)
        LIMIT = MAX0(int(10*iappwpc*0.01),6)
      else
        menuchw = 36
        LIMTTY=10
        LIMIT =10
      endif
      IF(MMOD.EQ.8)THEN

C Set initial font sizes (IMFS is for menus, IFS is for dialog & ITFS text feedback).
C Fonts 4-7 are proportional and 0-3 are fixed width. Use proportional for menus
C and dialog.
        IMFS=5
        IFS=4
        ITFS=4
#ifdef OSX
        IMFS=4
        IFS=4   ! use a smaller fonts
        ITFS=4
#endif
        call userfonts(IFS,ITFS,IMFS)
        call defaultfonts(IFS,ITFS,IMFS)  ! and remember these as defaults
      ELSE
        IMFS=5  ! Text mode set LIMTTY larger for paging menus.
        IFS=4
        ITFS=4
        LIMTTY=30
        LIMIT =30
      ENDIF

C Find the current ESP-r version number and add it to application title.
      call ESPrVersionNum(cVnum)
      write(pagestitle,'(2a)') 'Project Manager, ESP-r ',
     &  cVnum(1:lnblnk(cVnum))

      lntitle=lnblnk(pagestitle)
      CALL EPAGES(MMOD,IUIN,IUOUT,iappwi,iapphi,iappx,iappy,menuchw,
     &  pagestitle,lntitle)

C Open the text display box equal to LIMTTY if MMOD = 8.  Model
C not yet know so pass 0 to the wireframe control routine (updwire).
C If starting as a reduced percentage of default then widen the
C graphic display to compensate.
      IF(MMOD.EQ.8)THEN

C Setup and pass in parameters to win3d.
        iiw1=4; iiw2=1; iiw3=0; iiw4=1; iimenu=menuchw
        iigl=igl; iigr=igr; iigt=igt; iigb=igb; iigw=igw; iigwh=igwh
        CALL win3d(iimenu,iiw1,iiw2,iiw3,iiw4,
     &    iigl,iigr,iigt,iigb,iigw,iigwh)
        igl=int(iigl); igr=int(iigr); igt=int(iigt); igb=int(iigb)
        igw=int(iigw); igwh=int(iigwh)
        iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
        if(iglib.eq.1)then
          call opencpw
          call opensetup
          numberofzones=0
          call updwire(numberofzones)  ! pass local integer
          iicapture=1; iiazi=1
          call updcapt(iicapture)
          call updazi(iiazi)
        endif
        call setzscale()
        nifgrey=0
        ncset=0
        ngset=0
        nzonec=0
        call foundcolour(mdispl,nifgrey,ncset,ngset,nzonec)
        call startbuffer()
      ELSE
        
C Set reasonable defaults for text mode.
C        igw=631; igwh=433; igl=37; igb=441  ! at -s 100 0 0
        igw=813; igwh=571; igl=37; igb=579  ! at -s 120 0 0
        iiw1=4; iiw2=1; iiw3=0; iiw4=3; iimenu=menuchw
        iigl=igl; iigr=igr; iigt=igt; iigb=igb; iigw=igw; iigwh=igwh
        CALL win3dwwc(iimenu,iiw1,iiw2,iiw3,iiw4,
     &    iigl,iigr,iigt,iigb,iigw,iigwh)
        igl=int(iigl); igr=int(iigr); igt=int(iigt); igb=int(iigb)
        igw=int(iigw); igwh=int(iigwh)
      ENDIF

C Generate the version report.
      CALL ESPrVersion("summary",cAppName,IUOUT)

C Remember where prj was started (pwdinitial). If we are starting
C within a model pwdinitial will end in cfg or cfg/ or cfg\
      pwdinitial='  '  ! clear common
      pwdtocfg='  '    ! and from pwd into cfg folder
      call usrdir(pwdinitial)
      lnpwdi=lnblnk(pwdinitial)
      if(pwdinitial(lnpwdi-2:lnpwdi).eq.'cfg')then
        pwdtocfg='!'             ! signal no need to append this
        lnpwdc=lnblnk(pwdtocfg)  ! remember its length
      endif

C Find the user's home folder then get user's custom settings
C if defined. If there is no .esprc file in the users home folder
C then the esp-r install folders will be checked by scesprc and
C esprc may be updated if the alternate version is found. Echo
C in the feedback area if the trace level is non-zero.
      call usrhome(upath)
      if(unixok)then
        write(esprc,'(3a)') upath(1:lnblnk(upath)),fs,'.esprc'
      else
        write(esprc,'(3a)') upath(1:lnblnk(upath)),fs,'esprc'
      endif
      if(ITRC.eq.0)then
        call scesprc(esprc,IFIL+5,0,IIER)
      else
        call scesprc(esprc,IFIL+5,1,IIER)
      endif

C  902 continue

C Create and open a session log file based on user name, PID etc.
      uname=' '; tfile=' '
      call usrname(uname)
      call esppid(ipid)
      call isunix(unixok)

C Take command line file name as initial configuration file.
      ltcmdfl=inf                        ! Take command line file
      call cmdtoroot(inf,troot)          ! Return model root name.
      if(unixok)then
        write(tfile,'(3a)') '/tmp/',troot(1:lnblnk(troot)),'.log'
        call st2file(tfile,iefile)
      else
        write(tfile,'(6a)') 'C:',fs,'TEMP',fs,
     &    troot(1:lnblnk(troot)),'.log'
        call st2file(tfile,iefile)  ! Keep track of iefile name.
      endif

C Open keystroke file if ikey returned as 1 in call to parsprj.
      if(ikey.eq.1)then
        if(unixok)then
          if(inf(1:7).eq.'UNKNOWN')then
            write(tfile,'(a)') 'new_project_prj.key'
          else
            write(tfile,'(2a)') troot(1:lnblnk(troot)),'_prj.key'
          endif
          call st2file(tfile,ikfile)
        else
          write(tfile,'(6a)') 'C:',fs,'TEMP',fs,
     &      troot(1:lnblnk(troot)),'_prj.key'
          call st2file(tfile,ikfile)  ! Keep track of ikfile name.
        endif
        ikout=ifil+932                ! Set to unused index 932.
        ikcount=0                     ! Clear count of entries.
        INQUIRE (FILE=ikfile,EXIST=XST)
        if(XST)then
          close(ikout)
          open(ikout,file=ikfile,position='APPEND',
     &      status='UNKNOWN',err=905)
        else
          open(ikout,file=ikfile,status='UNKNOWN',err=905)
        endif
        call dstamp(dstmp) ! get curret time
        write(ikout,'(a)') '#!/bin/sh'
        write(ikout,'(2a)') '# running prj @ ',dstmp

C Reflect parameters passed to prj.
        if(MODL.eq.-1)then
          modt = '-mode text  '
        elseif(MODL.eq.-6)then
          modt = '-mode script'
        else
          modt = '-mode text  '
        endif
        if(act(1:2).ne.'  '.and.act(1:4).ne.'NONE')then
          if(act(1:8).eq.'transform')then
            write(actt,'(a,3f6.2)') ' -act transform',d1,d2,d3
          elseif(act(1:8).eq.'rotate')then
            write(actt,'(a,3f6.2)') ' -act rotate',d1,d2,d3
          elseif(act(1:10).eq.'silentread'.or.
     &           act(1:13).eq.'silentxmlread'.or.
     &           act(1:2).eq.'QA'.or.
     &           act(1:15).eq.'update_zone_con')then
            write(actt,'(2a)') ' -act ',act(1:lnblnk(act))
          endif
        else
          write(actt,'(a)') '  '
        endif
        if(iverb.eq.0)then
          actv='  '
        elseif(iverb.eq.2)then
          actv=' -vv'
        elseif(iverb.eq.1)then
          actv=' -v '
        endif
        if(inf(1:2).ne.'  '.and.inf(1:4).ne.'UNKN')then
          write(ikout,'(7a)') 'prj ',modt(1:lnblnk(modt)),
     &      ' -file ',inf(1:lnblnk(inf)),actt(1:lnblnk(actt)),
     &      actv(1:lnblnk(actv)),' <<XXX'
        else
          write(ikout,'(5a)') 'prj ',modt(1:lnblnk(modt)),
     &      actt(1:lnblnk(actt)),actv(1:lnblnk(actv)),' <<XXX'
        endif
        ikcount=3
        ikopened = .true.
        tmode='text'
        write(doit,'(2a)')'chmod a+x ./',ikfile(1:lnblnk(ikfile))
        call runit(doit,tmode)
      else
        ikout=ifil+932             ! Set to unused index 932.
        ikcount=0                  ! Clear count of entries.
      endif
  906 continue

C Open the session file if .esprc preference ON.  If it alreay exists then APPEND.
      ieout=ifil+931              ! Set to unused index 931.
      iecount=0                   ! Clear count of errors.
      if(.NOT.ieopened) goto 904  ! Set in scan of .esprc file (scesprc)
      INQUIRE (FILE=iefile,EXIST=XST)
      if(XST)then
        close(ieout)
        open(ieout,file=iefile,position='APPEND',
     &    status='UNKNOWN',err=903)
        write(ieout,'(a)')'   '   ! Blank line to separate new entries.
      else
        open(ieout,file=iefile,status='UNKNOWN',err=903)
      endif
      ieopened = .true.
      write(ieout,'(a)')'Session log for prj'
      call dstamp(dstmp) ! get curret time
      write(ieout,'(2a)')'Date ',dstmp
      write(ieout,'(2a)')'User ',uname(1:lnblnk(uname))
      write(ieout,'(2a)')'Model ',ltcmdfl(1:lnblnk(ltcmdfl))
      call to_session('   ')
  904 continue

C Check if the utility 'curl' is available on this computer
C and if so go to the ESRU web site and download the current
C update document. 
      call isunix(unixok)
      if(unixok)then
        found_curl=.false.; hold32='curl'
        call isinstalled(hold32,found_curl)
        if(found_curl)then
          write(doit,'(4a)') 'curl --connect-timeout 3 -f -s ',
     &      'https://www.esru.strath.ac.uk/',
     &      'Downloads/esp-r/update_notes.txt -o ',
     &      '/tmp/update_notes.txt'
          call runit(doit,'-')
          call pausems(200)
          write(theupdatefile,'(a)') '/tmp/update_notes.txt'
          write(currentfile,'(a)')theupdatefile(1:lnblnk(theupdatefile))
          call FINDFIL(theupdatefile,XST)
          if(XST)then
            nbupdatecomments=0
            CALL EFOPSEQ(iuj,theupdatefile,1,IER)
  942       CALL STRIPC(iuj,OUTSTR,99,ND,1,'upgrade notes',IER)
            IF(IER.NE.0) goto 943
            if (OUTSTR(1:3).eq.'V13')then
              if(lnblnk(outstr).le.38)then
                write(update_ver,'(a)') OUTSTR(1:lnblnk(OUTSTR))
              else
                write(update_ver,'(a)') OUTSTR(1:38)
              endif
              nbupdatecomments=0
              goto 942
            else
              nbupdatecomments=nbupdatecomments+1
              if(nbupdatecomments.le.20)then
                write(updatecomment(nbupdatecomments),'(a)') 
     &            OUTSTR(1:lnblnk(OUTSTR))
              endif
              goto 942
            endif
  943       if(nbupdatecomments.gt.1)then
              if(nbupdatecomments.gt.20) nbupdatecomments=20
              if(cVnum(9:lnblnk(cVnum)).eq.
     &           update_ver(1:lnblnk(update_ver)))then
                call edisp(iuout,
     &            'This is the latest ESP-r version.')
                continue
              else
                write(msg,'(2a)')
     &           'Most recent published ESP-r version is ',update_ver
                call edisp(iuout,msg)
                call edisp(iuout,
     &           'For upgrade history and download visit:')
                write(msg,'(2a)')
     &           'https://www.strath.ac.uk/research/',
     &           'energysystemsresearchunit/applications/esp-r'
                call edisp(iuout,msg)
              endif
              close(iuj)
              CALL EFOPSEQ(iuj,theupdatefile,1,IER)
              CALL EFDELET(iuj,ISTAT)
              outs='Upgrade prj message sent.'
              call to_session(outs)
            endif
          endif
        else

C << Curl not installed, suggest this to the user? >>
        endif
      else
        found_curl=.false.  ! not (yet) in Windows
      endif
      call isunix(unixok)
      if(unixok)then
        found_xterm=.false.; hold32='xterm'
        call isinstalled(hold32,found_xterm)
      else
        found_xterm=.false.  ! not (yet) in Windows
      endif

C Scan the defaults file for default system configuration file.
C Make temporary use of file unit IFIL+5. Note: escdef must come
C after scan of .esprc file.
      call escdef(IFIL+5,'-',IER)

C Take command line file name as initial configuration file.
      if(inf(1:2).eq.'  '.or.inf(1:4).eq.'UNKN')then
        LCMDFL='UNKNOWN'
      else
        LCMDFL=inf
      endif

C Take command line zone name, convert to 'inzone'
C and determine if focus is a single zone.
      if(inz(1:2).ne.'  ')then
        inzone=inz
      else
        inzone='ALL'
      endif

C If command line also included a key word, file name or data after -act
C then set inact.
      if(act(1:2).ne.'  ')then
        inact=act
      else
        inact='NONE'
      endif

C Weather file is on read channel IFIL (N.B. when not in use, other
C files may make use of this channel temporarily).
      ICLIM=IFIL; ipathclim=0
      LCLIM=DCLIM

      write(LAPRES,'(a)') DAPRES(1:lnblnk(DAPRES))

C Common constructions on channel IFIL+3. Default file assumed with
C full path.
      IFMUL=IFIL+3; ipathmul=0
      write(LFMUL,'(a)') DFMUL(1:lnblnk(DFMUL))

C Common materials on channel IFIL+4. Default file assumed with
C full path.
      IFMAT=IFIL+4; ipathmat=0
      write(LFMAT,'(a)') DFCON(1:lnblnk(DFCON))

C System configuration file on channel IFIL+5. 
      IFCFG=IFIL+5
      LCFGF='UNKNOWN'
      modeltitle='UNKNOWN'

C Optical and rarely used common files on channel IFIL+6. 
      IOPTDB=IFIL+6
      IPRODB=IFIL+6

C Set optical, mould event profiles etc. to default file names.
      write(LOPTDB,'(a)') DOPTDB(1:lnblnk(DOPTDB))
      ipathoptdb=0
      write(lfmould,'(a)') dmdbnam(1:lnblnk(dmdbnam))
      ipathmould=0
      write(LPRFDB,'(a)') DPRFDB(1:lnblnk(DPRFDB))
      ipathprodb=0
      write(LPCDB,'(a)') DPCDB(1:lnblnk(DPCDB))
      ipathpcdb=0
      write(MCMPDBFL,'(a)') DMCMPDBFL(1:lnblnk(DMCMPDBFL))
      ipathmsc=0
      write(LSBEM,'(a)')  DSBEM(1:lnblnk(DSBEM))  ! assign default SBEM db
      ipathsbem=0
      write(LPREDEF,'(a)')  DPREDEF(1:lnblnk(DPREDEF))
      ipathpredef=0

C Temporal information on channel IFIL+7.
      IUTDF=IFIL+7
      IUTDFA=IFIL+8
      write(LTDF,'(a)') 'UNKNOWN'
      write(LTDFA,'(a)') 'UNKNOWN'
      ITDFLG=0

C Text/graphic feedback redirection on channel IFIL+9.
      ixunit = ifil + 9

C CFClayers on channel IFIL+10.
      icfcdb = ifil + 10
      write(LCFCDB,'(a)') DCFCDB(1:lnblnk(DCFCDB))

C Project log and contents.
      lmodellog='project.notes'
      lmodelqa='UNKNOWN'

C If -actf was included in the command line then see if it
C is a known command that can be acted on.
      XST=.false.
      if(inact(1:10).eq.'silentread')then

C Check to see if the -file parameter is an ESP-r META file
C and if so do what it says.
        if(LCMDFL(1:2).ne.'  '.and.LCMDFL(1:4).ne.'UNKN')then
          INQUIRE (FILE=LCMDFL,EXIST=XST)
          if(XST)then
            call clrprb  ! clear the model common blocks prior to scan
            write(longtfile,'(a)') LCMDFL(1:lnblnk(LCMDFL))
            IUNIT=IFIL+1

C If iverb passed as non-zero then change directive.
            call silentread(iunit,longtfile,'-',theprimedirective,ier)
            call edisp(iuout,theprimedirective)
            call edisp(iuout,modeltitle)
            call edisp248(iuout,modeldocblock,80)
            if(theprimedirective(1:3).eq.'new')then
              call usrmsg('Processing of silent file complete.',
     &          'Exiting project manager.','P')

C If open, close the session log.
              close(ieout)
              if(iecount.eq.0)then     ! if there were no warnings delete
                open(ieout,file=iefile,status='UNKNOWN')
                call efdelet(ieout,istat)
              endif
              if(ikcount.gt.0)then  ! If entries in key file write closing line.
                write(ikout,'(a)') 'XXX'
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              else
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              endif

C Clear allocatable arrays.
              CALL DeallocateAllArrays
              CALL EPAGEND
              STOP
            else
              goto 3
            endif
          endif
        endif
      elseif(inact(1:13).eq.'silentxmlread')then

C Check to see if the -file parameter is a high level silent input file
C and if so do what it says.
        if(LCMDFL(1:2).ne.'  '.and.LCMDFL(1:4).ne.'UNKN')then
          INQUIRE (FILE=LCMDFL,EXIST=XST)
          if(XST)then
            call clrprb  ! clear the model common blocks prior to scan
            write(longtfile,'(a)') LCMDFL(1:lnblnk(LCMDFL))
            IUNIT=IFIL+1
            write(mpath,'(a)')'/tmp/test'  ! fix for testing

C If iverb passed as non-zero then change directive.
            if(iverb.eq.0)then
              call silentxmlread(iunit,longtfile,'- ',mpath,ier)
            elseif(iverb.eq.1)then
              call silentxmlread(iunit,longtfile,'v ',mpath,ier)
            elseif(iverb.eq.2)then
              call silentxmlread(iunit,longtfile,'vv',mpath,ier)
            endif
            call edisp(iuout,theprimedirective)
            call edisp(iuout,modeltitle)
            call edisp248(iuout,modeldocblock,80)
            if(theprimedirective(1:3).eq.'new')then
              call usrmsg('Processing of silent file complete.',
     &          'Exiting Project Manager.','P')

C If open, close the session log.
              close(ieout)
              if(iecount.eq.0)then     ! if there were no warnings delete
                open(ieout,file=iefile,status='UNKNOWN')
                call efdelet(ieout,istat)
              endif
              if(ikcount.gt.0)then  ! If entries in key file write closing line.
                write(ikout,'(a)') 'XXX'
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              else
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              endif

C Clear allocatable arrays.
              CALL DeallocateAllArrays
              CALL EPAGEND
              STOP
            else
              goto 3
            endif
          endif
        endif

      elseif(inact(1:9).eq.'transform'.or.inact(1:6).eq.'rotate'.or.
     &       inact(1:2).eq.'QA'.or.
     &       inact(1:15).eq.'update_zone_con')then

C Act on a command line request to transform the model or generate
C a model contents report or rebuilt the zone construction files
C (assumes that zone file names are known).
        XST=.false.
        if(LCMDFL(1:2).ne.'  '.and.LCMDFL(1:4).ne.'UNKN')then
          INQUIRE (FILE=LCMDFL,EXIST=XST)
          if(XST)then

C Call newprb without the need to confirm model but to check its path.
C We assume that the user owns the model to be transformed.
            itisanexemplar=.false.
            confirm=.false.
            ckpath=.true.
            call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
            if(ier.eq.-3)then
              call usrmsg('Configuration file could not be loaded.',
     &          'Exiting from project manager','W')

C Close the session log.
              iecount=iecount+1  ! retain the log file
              close(ieout)
              CALL ERPFREE(ieout,ISTAT)
              if(ikcount.gt.0)then  ! If entries in key file write closing line.
                write(ikout,'(a)') 'XXX'
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              else
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              endif

C Clear allocatable arrays.
              CALL DeallocateAllArrays
              CALL EPAGEND
              STOP
            endif

C Open core databases.
            call opendb(ier)
            if(ier.ne.0)then
              call usrmsg('Possible problem with the Constructions',
     &          'or Optical Properties db. Exiting.','W')

C Close the session log.
              close(ieout)
              CALL ERPFREE(ieout,ISTAT)
              if(ikcount.gt.0)then  ! If entries in key file write closing line.
                write(ikout,'(a)') 'XXX'
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              else
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              endif

C Clear allocatable arrays.
              CALL DeallocateAllArrays
              CALL EPAGEND
              STOP
            endif

C Scan control file if one exists.
            ICTLF=IFIL+1
            CALL ERPFREE(ICTLF,ISTAT)
            call FINDFIL(LCTLF,XST)
            if(XST)then
              CALL EZCTLR(ICTLF,0,IUOUT,IER)
            endif
    
C Now implement the transform based on data passed in command line
C for all the zones in the model. NOTE: in the next line set the
C value of silent = .false if you want to interact with the transform
C or rotation.
            silent= .true.
            inpic=NCOMP
            nzg=NCOMP
            do 29 iz=1,inpic
              ivals(iz)=iz
              nznog(iz)=iz
  29        continue
  
C Perform either the transform or rotation or generate QA report.
            if(inact(1:9).eq.'transform')then
              call globaltransform(d1,d2,d3,inpic,ivals,
     &          silent,itru,ier)
            elseif(inact(1:6).eq.'rotate')then
              call globalrotate(d1,d2,d3,inpic,ivals,silent,itru,ier)
            elseif(inact(1:2).eq.'QA')then

C Assume markdown is false (for now).
              markdown=.false.
              call prjqa(inpic,ivals,silent,ier)
            elseif(inact(1:15).eq.'update_zone_con')then
              QUIET=.TRUE.
              DO 2491, IZ=1,NCOMP
               CALL EDCON(ITRC,itru,IZ,QUIET,IER)
 2491         CONTINUE
              QUIET=.FALSE.

            endif
            if(silent)then 
              call usrmsg(
     &          'Processing of transform:rotate:QA complete.',
     &          'Exiting from project manager','W')

C Close the session log.
              close(ieout)
              if(iecount.eq.0)then     ! if there were no warnings delete
                open(ieout,file=iefile,status='UNKNOWN')
                call efdelet(ieout,istat)
              endif

C Close the keystroke file.
              if(ikcount.gt.0)then  ! If entries in key file write closing line.
                write(ikout,'(a)') 'XXX'
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              else
                close(ikout)
                CALL ERPFREE(ikout,ISTAT)
              endif

C Clear allocatable arrays.
              CALL DeallocateAllArrays
              CALL EPAGEND
              STOP
            else
              goto 3
            endif
          endif
        endif      
      endif

C If an input file has been specified then load it.
      XST=.false.
      if(LCMDFL(1:2).ne.'  '.and.LCMDFL(1:4).ne.'UNKN')then
        INQUIRE (FILE=LCMDFL,EXIST=XST)
        if(XST)then
          CALL ERPFREE(IFCFG,ISTAT)

C Call newprb without the need to confirm model but to check its path.
C Assume that the file passed is not an exemplar.
          itisanexemplar=.false.
          confirm=.false.
          ckpath=.true.
          call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
          if(ier.eq.-3)then
            ier=0
            goto 3  ! cancel detected, redisplay menu
          endif
        else

C The model file might not exist. Request the path is checked.
C Assume that the file name passed is not an exemplar.
          itisanexemplar=.false.
          confirm=.false.
          ckpath=.true.
          call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
          if(ier.eq.-3)then
            ier=0
            goto 3  ! cancel detected, redisplay menu
          endif
        endif
      else

C Nothing on the command line and if we are in a cfg folder then
C use the file browsing to see if there are any cfg files.
        if(pwdinitial(lnpwdi-2:lnpwdi).eq.'cfg')then
          write(subpath,'(a)') pwdinitial(1:lnpwdi)
          call discovercfg(subpath,sfile,ier)

C Return from discovercfg and derive the path and LCFGF portions
C of the string sfile.
          if(ier.eq.0)then
            call fdroot(sfile,path,LCFGF)
            lcfgr=lnblnk(LCFGF)
            lcfgl=lcfgr-3
            if(lcfgr.gt.4)then
              if(LCFGF(lcfgl:lcfgr).eq.'.cfg')then
                if(lcfgl-1.le.32)then
                  write(cfgroot,'(a)') LCFGF(1:lcfgl-1)
                else
                  write(cfgroot,'(a)') LCFGF(1:32)
                endif
                write(thecfgis,'(a,a)')LCFGF(1:lcfgr)
              else
                if(lcfgr.le.32)then
                  write(cfgroot,'(a)') LCFGF(1:lcfgr)
                else
                  write(cfgroot,'(a)') LCFGF(1:32)
                endif
                write(LCFGF,'(a,a)')LCFGF(1:lcfgr),'.cfg'
                write(thecfgis,'(a,a)')LCFGF(1:lcfgr),'.cfg'
              endif
            else
              if(lcfgr.le.32)then
                write(cfgroot,'(a)') LCFGF(1:lcfgr)
              else
                write(cfgroot,'(a)') LCFGF(1:32)
              endif
              write(LCFGF,'(a,a)')LCFGF(1:lcfgr),'.cfg'
              write(thecfgis,'(a,a)')LCFGF(1:lcfgr),'.cfg'
            endif
            odir=' '
            call usrdir(odir)
            lnod=lnblnk(odir)
            lncr=lnblnk(cfgroot)
            if(lnod+lncr+6.lt.72)then
              call edisp(iuout,' ')
              if(pwdtocfg(1:1).eq.'!')then

C Prj started within a model cfg folder. Set cfgpath accordingly.
                lnpth=lnblnk(path)
                write(cfgpath,'(a)') path(1:lnpth-1)  ! omit trailing /
              else
                write(path,'(6a)')odir(1:lnod),fs,cfgroot(1:lncr),
     &            fs,'cfg',fs
                write(cfgpath,'(5a)')odir(1:lnod),fs,cfgroot(1:lncr),
     &            fs,'cfg'
              endif
              call edisp(iuout,
     &          'Model configuration file is in folder')
              call edisp(iuout,path)
            else
              write(outs,'(6a)')odir(1:lnod),fs,cfgroot(1:lncr),
     &          fs,'cfg',fs
              call usrmsg(
     &    'The derived path (below) is >72 char give shorter root',
     &          outs,'W')
            endif

C Refocus prj on the model cfg folder and re-load the model cfg file
C as is done in cadio.F
            call pausems(1000)

C Use call to refocus to start a new prj within the model cfg folder.
            call refocus(cfgpath,thecfgis,iret)
            if(iret.eq.0)then
              continue
            elseif(iret.eq.-2)then
              call edisp(iuout,
     &        'Features using Radiance calls may not work as expected.')
            endif
          endif
        endif
      endif

C Provide site information, update wireframe control with
C current number of zones if a model has been loaded.
      if(LCMDFL(1:2).ne.'  '.and.LCMDFL(1:4).ne.'UNKN')then
        if(ier.eq.0)then
          CFGOK=.TRUE.

C Uncomment next line to echo site info when model is scanned.
C          call siteinfo(iuout)

C Open core of databases if not already done.
          if(MLDBOK.and.MATDBOK.and.OPTKOK)then
            continue
          else
            call opendb(ier)
            if(ier.ne.0)then
              call usrmsg('Possible problem with the Constructions',
     &               'or Optical Properties db. Please check.','W')
              ier = 0
            endif
          endif

C Scan for matching MLC for surfaces.
          do 30 ICOMP=1,NCOMP
            DO 9994 I=1,NZSUR(icomp)
              icn1=izstocn(icomp,i)
              if(icn1.gt.0)then
                smlcindex(icomp,i)=0  ! assume no matching MLC          
                lnssmlc=lnblnk(SMLCN(icomp,i))
                do 5 ii=1,nmlc
                  if(SMLCN(icomp,i)(1:lnssmlc).eq.
     &               mlcname(ii)(1:lnmlcname(ii)))then
                    smlcindex(icomp,i)=ii   ! remember MLC index  
                  endif
  5             continue
              endif
 9994       continue
 30       continue

C Scan control file if one exists.
          ICTLF=IFIL+1
          CALL ERPFREE(ICTLF,ISTAT)
          call FINDFIL(LCTLF,XST)
          if(XST)then
            CALL EZCTLR(ICTLF,0,IUOUT,IER)
          endif

C If there are associated images and the image browser
C has not been invoked do this now.
          call imgdisp(0,'****',ier)

C If 'inzone' = 'All' display an image of the model. If 'inzone'
C is either a string which matches a zone name or is an index then
C focus on that zone.  If 'inzone' = 'UNKNOWN' or 0 present a list.
          call zindex(inzone,index)
          if(index.le.0)then
            if(indcfg.ne.2.and.indcfg.ne.0)then
              MODIFYVIEW=.TRUE.
              MODBND=.TRUE.
              MODLEN=.TRUE.
              nzg=NCOMP
              DO 44 I=1,nzg
                nznog(I)=I
  44          CONTINUE

C (Re)Set all surfaces to standard line width and if an initial view
C has been specified update view info to this.
              CALL INLNST(1)
              izgfoc=0
              if(initvt.eq.1)then
                EYEM(1)=EYEMI(1)
                EYEM(2)=EYEMI(2)
                EYEM(3)=EYEMI(3)
                VIEWM(1)=VIEWMI(1)
                VIEWM(2)=VIEWMI(2)
                VIEWM(3)=VIEWMI(3)
                ANG=ANGI
              endif

              call redraw(IER)
            endif
          else
            itru=iuout
            call georead(IFIL+1,LGEOM(index),index,1,iuout,IER)
            IF(IER.NE.0)goto 3

C Change focus to zone but do not act on any ianother jump command.
            CALL EDZONE(ITRC,index,ianother,IER)
            MODIFYVIEW=.TRUE.
          endif
        endif
      endif

C      ITRC=1  ! why reset this ?
    3 INO=-4
      ITEMS(1) =  'a introduction'
      ITEMS(2) =  'b databases'
      ITEMS(3) =  'c self testing'
      ITEMS(4) =  ' ..... Model selection ....'
      ITEMS(5) =  'd open existing'
      ITEMS(6) =  'e create new'

      if(CFGOK)then
        if(browse)then
          ITEMS(7) =  ' ..... Current model (browse) ....'
          ITEMS(13)=  'm browse/simulate'
        else
          ITEMS(7) =  ' ...... Current model .....'
          ITEMS(13)=  'm browse/edit/simulate'
        endif
        WRITE(ITEMS(8),'(2A)') '  cfg: ',LCFGF(1:26)
        WRITE(ITEMS(9),'(2A)') '  path: ',path(1:25)
        WRITE(ITEMS(10),'(2A)')'g root: ',cfgroot(1:25)
        WRITE(ITEMS(11),'(2A)')'h title: ',modeltitle(1:24)
        WRITE(ITEMS(12),'(A)') 'j variants'
        ITEMS(14)=  '             '
      else
        ITEMS(7) =    ' ..... Current model (none) ....'
        WRITE(ITEMS(8),'(A)')  ' '
        WRITE(ITEMS(9),'(A)')  ' '
        WRITE(ITEMS(10),'(A)') ' '
        WRITE(ITEMS(11),'(A)') ' '
        WRITE(ITEMS(12),'(A)') ' '
        ITEMS(13)=  ' '
        ITEMS(14)=  ' '
      endif
      ITEMS(15)   = ' ..... Import & export .....'
      ITEMS(16)   = 'n invoke CAD tool'
      ITEMS(17)   = 'o import CAD file'
      if(CFGOK)then
        ITEMS(18) = 'p export model'
        ITEMS(19) = 'q archive model'
      else
        ITEMS(18) = '  export'
        ITEMS(19) = '  archive'
      endif
      ITEMS(20)   = ' ..... Model location .....'
      if(CFGOK)then
        ITEMS(21) = 't folders & files'
      else
        ITEMS(21) = '  folders & files'
      endif
      ITEMS(22)  =  ' ..... Miscellaneous .....'
      if(CFGOK)then
        ITEMS(23) = 'r save model'
        ITEMS(24) = 's save model as'
      else
        ITEMS(23) = '  save model'
        ITEMS(24) = '  save model as'
      endif
      IF(ITRC.EQ.0)THEN
        ITEMS(25) = 'v feedback >> silent'
      ELSEIF(ITRC.EQ.1)THEN
        ITEMS(25) = 'v feedback >> summary'
      ELSEIF(ITRC.EQ.2)THEN
        ITEMS(25) = 'v feedback >> detailed'
      ENDIF
      ITEMS(26) =   '* preferences'
      ITEMS(27) =   '? help'
      ITEMS(28) =   '- quit module'
      MITEM=28

C If user has defined model and perhaps resized the display then
C redraw the model image. If in registration mode do not attempt
C to draw the model.
      if(indcfg.eq.2)then
        CALL USRMSG(' ',' ','-')
      elseif(indcfg.eq.0)then
        CALL USRMSG(' ',' ','-')
      else
        if(CFGOK.AND.MODIFYVIEW)then
          MODBND=.TRUE.
          MODLEN=.TRUE.
          ITSNM=1
          ITVNO=1
          nzg=NCOMP
          if(nzg.gt.0)then
            DO 444 I=1,nzg
              nznog(I)=I
  444       CONTINUE

C (Re)Set all surfaces to standard line width.
            CALL INLNST(1)
            izgfoc=0
            CALL redraw(IER)
          endif

C Re-draw the configuration buttons.
          if(MMOD.EQ.8)then
            call redrawbuttons()
            WRITE(etext,'(2A)')'Model: ',
     &        modeltitle(1:lnblnk(modeltitle))
            iside=1; isize=1; ifont=1
            call viewtext(etext,iside,isize,ifont)
          endif
        endif
      endif

C Use askabout to instantiate the initial help messages (2nd parameter is one).
      call askabout('prj ',1)

C Present opening menu.
      CALL EMENU('Model management',ITEMS,MITEM,INO)
      IF(INO.EQ.MITEM)THEN
        if(changedit)then
          helptopic='exit_without_save'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL EASKMBOX('The active model has unsaved change.',
     &      'Options:','exit (no save)','save & exit','cancel',
     &      ' ',' ',' ',' ',' ',IW,nbhelp)
          if(iw.eq.3)then
            goto 3
          elseif(iw.eq.2)then
            CALL EMKCFG('s',IER)
            OK=.true.
          elseif(iw.eq.1)then
            OK=.true.
            continue
          endif
        else
          ok=.true.
        endif
        IF(.NOT.OK)GOTO 3

C If there is a temporary optical file remove it.
        XST=.false.
        topt='tmpopt'
        call FINDFIL(topt,XST)
        if(XST)then
          IUF=IFIL+1
          CALL ERPFREE(IUF,ISTAT)
          CALL EFOPSEQ(IUF,topt,1,IER)
          CALL EFDELET(IUF,ISTAT)
        endif

C Close the session log.
        close(ieout)
        if(iecount.eq.0)then     ! if there were no warnings delete
          open(ieout,file=iefile,status='UNKNOWN')
          call efdelet(ieout,istat)
        endif
        if(ikcount.gt.0)then  ! If entries in key file write closing line.
          write(ikout,'(a)') 'XXX'
          close(ikout)
          CALL ERPFREE(ikout,ISTAT)
        else
          close(ikout)
          CALL ERPFREE(ikout,ISTAT)
        endif

C Clear allocatable arrays
        CALL DeallocateAllArrays
        CALL EPAGEND
        STOP
 
C Introduction. Get text from external and then add in lines
C based on the current compiled-in limits.
      ELSEIF(INO.EQ.1)THEN
        helptopic='prj_intro'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Introduction',nbhelp,'-',0,0,IER)

C Manage databases.
      ELSEIF(INO.EQ.2)THEN
        CALL EDDB(IER)

C Manage self testing - does not need to have an existing model
C loaded.
      ELSEIF(INO.EQ.3)THEN
        call MValid

C Open an exemplar or other existing model.
      ELSEIF(INO.EQ.5)THEN
        helptopic='exemplar_or_other'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(' ','Options:',
     &    'exemplar','other','cancel',' ',' ',' ',' ',' ',IW,nbhelp)
        if(iw.eq.3)then
          continue
        elseif(iw.eq.1)then

C Scan exemplars file specified in the user's .esprc file (or from
C the standard file dinstpath'/training/exemplars'. If call to
C rexmpl returns an ier=2 then the user asked to continue.
          IUF=IFIL+1
          XST=.false.
          if(exemfl(1:2).ne.'  '.and.exemfl(1:4).ne.'UNKN')then
            INQUIRE (FILE=exemfl,EXIST=XST)
            if(XST)then

C << An idea - rexmpl could return in addition the path and the cfg file  >>
C << name parts of exemplar (because it already knows this so it need not >>
C << be resolved again. >>

C Call rexmpl to get the exemplar. If ier is set to 2 then the
C user didn't pick anything. If useraction is set to 'browse' then
C ensure the toggle is set accordingly.
              useraction = ' '
              call rexmpl(ITRC,IUF,exemplar,useraction,ier)
              if(ier.eq.2)then
                ier=0
                goto 3
              endif
              if(ier.ne.0)goto 3
              if(exemplar(1:7).ne.'UNKNOWN'.and.
     &           exemplar(1:2).ne.'  ')then

C Set initial browse toggle to match useraction.
                if(useraction(1:8).eq.'browse  ')then
                  browse=.true.
                elseif(useraction(1:8).eq.'ownit   ')then
                  browse=.false.
                endif

C Copy the exemplar configuration file (with full path) to LCMDFL.
                write(LCMDFL,'(a)') exemplar(1:lnblnk(exemplar))
                ltcmdfl=exemplar
                call fdroot(ltcmdfl,path,LCFGF)

C If the path of the model indicates it is one of the standard
C exemplars then flag browse and itisanexemplar to true.
                write(dirpath,'(3a)') dinstpath(1:lnblnk(dinstpath)),
     &            fs,'training'

                ldirpath=lnblnk(dirpath)
                if(path(1:ldirpath).eq.dirpath(1:ldirpath))then

C For OSX/Linux/Unix comparison of paths is usually successful so
C if the model path is to the distribution training folder believe it.
                  browse=.true.
                  itisanexemplar=.true.
                else

C A non match may happen in windows so fall back to user
C action if there is no match in the paths.
                  if(useraction(1:8).eq.'browse  ')then
                    browse=.true.
                    itisanexemplar=.true.
                  elseif(useraction(1:8).eq.'ownit   ')then
                    browse=.false.
                    itisanexemplar=.false.
                  endif
                endif

C If running on a Windows machine the the file browser would have been
C used and there is no need to check the path.
                call isunix(unixok)
                confirm=.false.
                if(unixok)then
                  ckpath=.true.
                else
                  ckpath=.false.
                endif
                call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
                if(ier.eq.-3)then
                  ier=0
                  goto 3  ! cancel detected, redisplay menu
                endif
              endif
            endif
          else
            call edisp(iuout,'No exemplars list available!')
            call edisp(iuout,' ')
            goto 3
          endif
        elseif(iw.eq.2)then

C Select an existing model. If Project Manager was started with
C 'UNKNOWN' then ask for actual name to create or read.
          if(LCMDFL(1:7).eq.'UNKNOWN')then
            itisanexemplar=.false.
            confirm=.true.
            ckpath=.true.
            call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
            if(ier.eq.-3)then
              ier=0
              goto 3  ! cancel detected, redisplay menu
            endif
          else

C Something was passed in via the command line so offer choice.
            helptopic='command_line_cfg_file'
            call gethelptext(helpinsub,helptopic,nbhelp)
            write(outs,'(a,a)') ' The command line included: ',
     &      LCMDFL(1:lnblnk(LCMDFL))
            CALL EASKMBOX(outs,' ','use it as the model',
     &        'specify another','cancel',' ',' ',' ',' ',' ',
     &        IW,nbhelp)

C User confirmed model so find the path and local file name. The
C variable dirpath is where esp-r training models are located.
            if(IW.eq.1)then
              ltcmdfl=LCMDFL
              call fdroot(ltcmdfl,path,LCFGF)
              write(dirpath,'(3a)') dinstpath(1:lnblnk(dinstpath)),
     &          fs,'training'
              ldirpath=lnblnk(dirpath)
              if(path(1:ldirpath).eq.dirpath(1:ldirpath))then
                browse=.true.
                itisanexemplar=.true.
              else
                itisanexemplar=.false.
              endif
              confirm=.false.
              ckpath=.true.
              call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
              if(ier.eq.-3)then
                ier=0
                goto 3  ! cancel detected, redisplay menu
              endif
            elseif(IW.eq.2)then
              itisanexemplar=.false.
              confirm=.true.
              ckpath=.true.
              call NEWPRB(ITRC,confirm,ckpath,itisanexemplar,IER)
              if(ier.eq.-3)then
                ier=0
                goto 3  ! cancel detected, redisplay menu
              endif
            elseif(IW.eq.3)then
              INO=-2
              GOTO 3
            endif
          endif

C For any loaded model, if user is not browsing check to see if
C the model should be updated.
          if(browse)then
            continue
          else
            call mupdate(ier)
          endif
        endif
      ELSEIF(INO.EQ.6)THEN

C Start new project, begin with registration.
        root=' '
        mpath=' '
        menu='This model...'
        call pregist('i ',root,mpath,menu,ier)
      ELSEIF(INO.EQ.10)THEN

C Root name of the model.
        if(CFGOK)then
          helptopic='model_root_name'
          call gethelptext(helpinsub,helptopic,nbhelp)
          t32=cfgroot
          CALL EASKS(t32,' ','Project root name (<32 chars)?',
     &      32,'project','root name',IER,nbhelp)
          if(t32(1:2).ne.'  '.and.t32(1:4).ne.'UNKN')cfgroot=t32
          changedit=.true.
        endif
      ELSEIF(INO.EQ.11)THEN

C Synopsis of the model.
        if(CFGOK)then
 246      helptopic='prj_model_title'
          call gethelptext(helpinsub,helptopic,nbhelp)
          ltmp=modeltitle
          CALL EASKS(ltmp,' ','Model synopsis?',
     &      72,'base case simulation','model description',IER,nbhelp)
          if(ltmp(1:2).eq.'  '.or.ltmp(1:4).eq.'UNKN')then
            call usrmsg('Blank entry not allowed!',' ','W')
            goto 246
          else
            modeltitle=ltmp
          endif
          changedit=.true.
        endif

C Version.
      ELSEIF(INO.EQ.12)THEN
        CALL CFGVER

C Browse the current model.
      ELSEIF(INO.EQ.13)THEN
        if(CFGOK)then
          itru=iuout
          CALL EDCFG(ITRC,itru,IER)
        endif

C Invoke CAD tool.
      ELSEIF(INO.EQ.16)THEN
        call gtoolin(itrc,ier)

C Import CAD file.
      ELSEIF(INO.EQ.17)THEN
        call cadin(itrc,ier)

C Export, if something other than registration or plant only.
      ELSEIF(INO.EQ.18)THEN
        if(INDCFG.NE.0.and.INDCFG.NE.2)then
          call exportcad(itrc,IER)
        else
          CALL USRMSG('Insufficient data to export.',' ','W')
        endif

C Archive model facility.
      ELSEIF(INO.EQ.19)THEN

C Project folders and files.
      ELSEIF(INO.EQ.21)THEN
        call pfolders(iier)

C Save model (23 without asking for file name & 24 asking for file name).
      ELSEIF(INO.EQ.23.or.INO.EQ.24)THEN
        if(browse)then
          call usrmsg('Cannot update the model while in browse',
     &                'mode; you must `own` the model.','W')
          goto 3
        endif

C Ask for file name. If save as and V4.2 then offer to save as V4.0
        if(INO.EQ.24)then
          helptopic='updated_cfg_file_name'
          call gethelptext(helpinsub,helptopic,nbhelp)
          DFILE=' '
          ltmp=LCFGF
   89     CALL EASKS(ltmp,' ','Updated configuration file?',
     &      72,DFILE,'updated configuration file',IER,nbhelp)
          if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
            LCFGF=ltmp
          else
            call usrmsg('Re-enter file name.',' ','W')
            goto 89
          endif

C Give option to alter the base name of the project files.
          helptopic='model_root_name'
          call gethelptext(helpinsub,helptopic,nbhelp)
          t32=cfgroot
          CALL EASKS(t32,' ','Base name for project files?',
     &      32,'project','root name',
     &      IER,nbhelp)
          if(t32(1:2).ne.'  '.and.t32(1:4).ne.'UNKN')cfgroot=t32
        endif

        if(icfgv.ge.3)then

C Also check about connections file.
          if(ncon.gt.1)then
            if(INO.EQ.24)then
  289         helptopic='model_cnn_file_name'
              call gethelptext(helpinsub,helptopic,nbhelp)
              write(DCNN,'(a,a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
              if(LCNN(1:1).eq.' ')LCNN=DCNN
              ltmp=LCNN
              CALL EASKS(ltmp,' ','Surface connections file name?',
     &          72,DCNN,'system connx file name',IER,nbhelp)
              if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
                LCNN=ltmp
              else
                call usrmsg('Re-enter file name.',' ','W')
                goto 289
              endif
            endif
          endif
        endif

        if(INO.EQ.24)then
          CALL EMKCFG('v',IER)  ! Ask user about version as well.
        else
          CALL EMKCFG('-',IER)
        endif
        IF(IER.EQ.1)THEN
          call usrmsg('Problem creating new file. Check disk',
     &                'space or write permission.','W')
        ENDIF
        goto 3

C Toggle trace level.
      ELSEIF(INO.EQ.MITEM-3)THEN
        ITRC=ITRC+1
        IF(ITRC.GT.2)ITRC=0
        INO=-4
        GOTO 3
      ELSEIF(INO.EQ.MITEM-2)THEN

C Allow user to change preferences for dates, time, wireframe view
C and reporting/ trace level and version of the model files.
        MODSIT=.false.
        call setup(MODSIT,ITRC,IER)
        if(MODSIT)then
          CALL EMKCFG('s',IER)
          MODSIT=.false.
        endif

C Menu level help.
      ELSEIF(INO.EQ.MITEM-1)THEN
        helptopic='prj_main_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Prj main menu',nbhelp,'-',0,0,IER)
      ELSE
        INO=-4
        GOTO 3
      ENDIF
      INO=-2
      GOTO 3

 903  call edisp(iuout,' ')
      call edisp(iuout,'Error opening session log ... continuing.')
      goto 904

 905  call edisp(iuout,' ')
      call edisp(iuout,'Error opening keystroke file ... continuing.')
      goto 906

      END
     
C ******************** simula ********************
C Commissions technical assessments and analysis.

      subroutine simula(ier)
#include "building.h"
#include "model.h"
#include "uncertainty.h"
#include "plant.h"
#include "power.h"
#include "sbem.h"
#include "ipvdata.h"
#include "net_flow.h"
#include "tdf2.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT
      common/FILEP/IFIL
      common/appw/iappw,iappx,iappy
      integer iappw,iappx,iappy
      integer childterminal  ! picks up mmod from starting of prj
      common/childt/childterminal
      COMMON/PREC7/ITCNST
      COMMON/C6/INDCFG
      integer ncomp,ncon
      common/C1/NCOMP,NCON
      COMMON/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      INTEGER :: iairn,icaas
      COMMON/MOIST01/MSTROK,MSTRZN(MCOM)
      LOGICAL MSTROK,MSTRZN
      common/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME

      common/IPVF/lipvdatf
      common/ACTDOM/CFDOK
      logical CFDOK

C Typical seasons and default simulation periods. Isset is the
C current seasons set, nsset number of similar parameter sets,
C Isauto (0=use info as defaults 1=autoexec mode),
C istcnst (startup days), isbnstep (building timesteps/hr),
C ispnstep (plant timesteps/hr), issave (results save level).
      common/spmfxst/ispmxist,spflnam
      common/spfldes/spfdescr(MSPS)
      common/spflper/isstday(MSPS),isstmon(MSPS),isfnday(MSPS),
     &               isfnmon(MSPS)
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      common/spflres/sblres(MSPS),sflres(MSPS),splres(MSPS),
     &  smstres(MSPS),selres(MSPS),scfdres(MSPS),sipvres
      character sblres*72,sflres*72,splres*72,smstres*72,
     &  selres*72,scfdres*72,sipvres*72

C Extended simulation parameters for each set.
      common/spfldats/isstupex(MSPS),isbnstepex(MSPS),ispnstepex(MSPS),
     &  issaveex(MSPS),isavghex(MSPS),iscfdactivate(MSPS),
     &  isicfdys(MSPS),isicfdyf(MSPS),
     &  scftims(MSPS),scftimf(MSPS)
      INTEGER :: isstupex,isbnstepex,ispnstepex,issaveex,isavghex
      INTEGER :: iscfdactivate      ! zero ignore domains
      INTEGER :: isicfdys,isicfdyf  ! CFD simulation start & finish days
      REAL :: scftims,scftimf       ! CFD simulation start & finish time
      COMMON/cfdfil/LCFD(MCOM),IFCFD(MCOM)
      CHARACTER*72 LCFD
      integer IFCFD      
      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton
      common/user/browse

      dimension ITEMS(26)

      character doit*248,tmode*8,ITEMS*42,key*1
      character spflnam*72,longtfile*144,longtfiledos*144
      CHARACTER*72 LAPROB,lipvdatf
      character cr*48,spfdescr*30,ipvaction*3

C dd is character array for selecting simulation parameter sets.
      character dd(MSPS+3)*55,de*30,aut*12
      character t72*72

      character brw*11,outs*124,fs*1
      character descra*7,descrb*7,descrst*10,descrfn*10
      character descr2st*8,descr2fn*8

      logical OK,XST,modparms
      logical browse,concat,hri,defok,unixok,LIBXST
      logical mlcok,bndryok,bndrysxc,confok,geofok,oprfok,prob
      logical tmcok,shdok
      integer iappwpc ! application height as % of nominal size

      integer isstupt,isbnstept,ispnstept,issavet  ! for local editing
      integer MITEM,INO,ic,IRT ! max items and current menu item

      helpinsub='simula'  ! set for subroutine

C Set initial values of local variables.
      modparms=.false.
      lr=lnblnk(cfgroot)
      write(cr,'(a)') cfgroot(1:lnblnk(cfgroot))
      if(nsset.gt.0)isset=1
      t72='  '
      itrc=0   ! set initial value.
      aut=' interactive'
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Do an initial check to see if the model is attributed and
C constructions are known.
      if(INDCFG.eq.2)then
        continue
      else
        call checkmodel(mlcok,bndryok,bndrysxc,confok,geofok,oprfok,
     &    prob,tmcok,shdok)
        if(.NOT.mlcok)then
          call edisp(iuout,' ')
          call edisp(iuout,'Surface construction attributes not ok.')
        endif
        if(.NOT.bndryok)then
          call edisp(iuout,' ')
          call edisp(iuout,'Surface connection attributes not ok.')
        endif
        if(.NOT.bndrysxc)then
          call edisp(iuout,' ')
          call edisp(iuout,'Surface topology (1st check) not ok.')
       endif
        if(prob)then
          call edisp(iuout,' ')
          call edisp(iuout,'Surface topology (2nd check) not ok.')
        endif
        if(.NOT.(geofok.AND.confok.AND.oprfok))then
          call edisp(iuout,' ')
          call edisp(iuout,'Mandatory zone files do not exist!')
        endif
      endif

      if(noimg.gt.0)call imgdisp(1,'FPER',ier)

C Loop through zones to see if there is a cfd domain description.
      do loop=1,NCOMP
        IF(ABS(IFCFD(loop)).GT.0) CFDOK=.true.
      enddo
      
    3 INO=-4
      if(nsset.eq.0)then
        ITEMS(1) ='a simulation presets: none'
        ITEMS(2)= '  ______________________________ '
        M=2
      else
        write(ITEMS(1),'(a,i2,a,i2,a)')'a simulation presets (',isset,
     &    ' of',nsset,')'
        write(ITEMS(2),'(a,a)')      'b set name: ',spfdescr(isset)
     &                                   (1:lnblnk(spfdescr(isset)))
        write(ITEMS(3),'(a,i4)')     'c start-up days:',isstupex(isset)
        if(isbnstepex(isset).le.1)then
          write(ITEMS(4),'(a,i2)')   'd zone timestep/h:',
     &      isbnstepex(isset)
        else
          if(isavghex(isset).eq.0)then
           write(ITEMS(4),'(a,i2,a)')'d zone timestep/h:',
     &       isbnstepex(isset),' each ts saved'
          else
           write(ITEMS(4),'(a,i2,a)')'d zone timestep/h:',
     &       isbnstepex(isset),' saved 1 ts/hr'
          endif
        endif
        if(INDCFG.eq.2.or.INDCFG.eq.3)then
          write(ITEMS(5),'(a,i2)')   'e plant timestep/(bldg ts):',
     &      ispnstepex(isset)
        else
          write(ITEMS(5),'(a)')      'e plant timestep/(bldg ts): N/A'
        endif
        write(ITEMS(6),'(a,i2)')     'f result save level:',
     &    issaveex(isset)

C Display the simulation period.
        CALL EDAY(isstday(isset),isstmon(isset),ijdstart)
        call stdate(iyear,ijdstart,descra,descrst,descr2st)
        CALL EDAY(isfnday(isset),isfnmon(isset),ijdfinish)
        call stdate(iyear,ijdfinish,descrb,descrfn,descr2fn)
        write(ITEMS(7),'(4a)')        'g from: ',descrst,' - ',descrfn
        if(INDCFG.ne.2)then
          write(ITEMS(8),'(2a)')      'h zone results: ',
     &      sblres(isset)(1:24)
        else
          write(ITEMS(8),'(a)')       '  zone results: N/A'
        endif
        if(IAIRN.ge.1)then
          write(ITEMS(9),'(2a)')      'i flow results: ',
     &      sflres(isset)(1:24)
        else
          write(ITEMS(9),'(a)')       '  flow results: N/A'
        endif
        if(INDCFG.eq.2.or.INDCFG.eq.3)then
          write(ITEMS(10),'(2a)')     'j plant results: ',
     &      splres(isset)(1:23)
        else
          write(ITEMS(10),'(a)')      '  plant results: N/A'
        endif
        if(ispmxist.gt.0)then
          write(ITEMS(11),'(a)')      'k : '
        else
          write(ITEMS(11),'(a)')      '  : N/A'
        endif
        if(MSTROK)then
          write(ITEMS(12),'(2a)')     'l moist. results: ',
     &      smstres(isset)(1:22)
        else
          write(ITEMS(12),'(a)')      '  moisture results: N/A'
        endif
        if(ientxist.gt.0)then
          write(ITEMS(13),'(2a)')     'm elect. results: ',
     &      selres(isset)(1:22)
        else
          write(ITEMS(13),'(a)')      '  electrical results: N/A'
        endif
        if(CFDOK)then  ! Also keep track of CFD results.
          write(ITEMS(14),'(2a)')     'n CFD results: ',
     &      scfdres(isset)(1:24)
        else
          write(ITEMS(14),'(a)')      '  CFD results: N/A'
        endif
        if(lnblnk(lipvdatf).eq.0)then
          write(ITEMS(15),'(a)')      '  IPV report: N/A'
        elseif(lipvdatf(1:7).eq.'UNKNOWN')then
          write(ITEMS(15),'(a)')      '  IPV report: N/A'
        elseif(lipvdatf(1:8).eq.'internal')then
          write(ITEMS(15),'(2a)')  'o IPV report: ',sipvres(1:24)
        else
          write(ITEMS(15),'(2a)')  'o IPV report: ',sipvres(1:24)
        endif    
        ITEMS(16)  ='p save/ dereference parameters'
        ITEMS(17)  ='  ______________________________ '
        M=17
      endif
      if(INDCFG.eq.2)then
        ITEMS(M+1) ='q plant simulation'
      else
        ITEMS(M+1) ='q integrated simulation'
      endif
      ITEMS(M+2)   ='r fluid flow simulation'
      ITEMS(M+3)   ='s visual simulation'
      ITEMS(M+4)   ='t integrated performance view'
      ITEMS(M+5)   ='u NCM compliance check'
      ITEMS(M+6)   ='  ______________________________ '
      IF(ITRC.EQ.0)THEN
        ITEMS(m+7) = 'v feedback: none'
      ELSEIF(ITRC.EQ.1)THEN
        ITEMS(m+7) = 'v feedback: summary'
      ELSEIF(ITRC.EQ.2)THEN
        ITEMS(m+7) = 'v feedback: detailed'
      ENDIF
      ITEMS(M+8)   ='? help'
      ITEMS(M+9)   ='- exit menu'
      MITEM=M+9

C At each pass update for recent parameter changes.
      if(modparms)then
        CALL EMKCFG('s',IER)
        modparms=.false.
      endif

C Help text for this menu and most of the dialogs.
      helptopic='prj_sim_set_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU('Simulation controller',ITEMS,MITEM,INO)
      if(INO.EQ.MITEM)then
        if(modparms)then
          CALL EMKCFG('s',IER)
          modparms=.false.
        endif
        RETURN

C Help text.
      elseif(INO.EQ.MITEM-1)then
        helptopic='prj_sim_set_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Simulation',nbhelp,'-',0,0,IER)
        helptopic='prj_simulation_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Simulation',nbhelp,'-',0,0,IER)
 
C Toggle feedback level.
      elseif(INO.EQ.MITEM-2)then
        ITRC=ITRC+1
        IF(ITRC.GT.2)ITRC=0

C Invoke simulator for the case of a simulation parameter set.
C If uncertanties included in model, tell user to use silent mode.
      elseif(INO.EQ.MITEM-8)then
        INQUIRE (FILE=LUALF,EXIST=LIBXST)
        if(LIBXST) call edisp(iuout,
     &     'Use run automated for uncertainty assessments.')
        helptopic='prj_simulation_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        if(nsset.gt.0)then
          CALL EASKMBOX(' ','Options:',
     &      'interactive','automated','cancel',
     &      ' ',' ',' ',' ',' ',isauto,nbhelp)
          if(isauto.eq.1)then
            aut=' interactive'
          elseif(isauto.eq.2)then
            aut=' silent'
          else
            goto 3
          endif

C Setup child process for the terminal type.
          doit = ' '
          call terminalmode(childterminal,tmode)
          call isunix(unixok)
          if(unixok)then
            call addpath(LCFGF,longtfile,concat)
          else

C For a non-unix machine see if there are spaces in the name
C and change any / to \.
            call addpath(LCFGF,longtfile,concat)
            call cmdfiledos(longtfile,longtfiledos,ier)

C Debug the patched file name.
            write(outs,'(2a)') 'Corrected file ',
     &        longtfiledos(1:lnblnk(longtfiledos))
            call edisp(iuout,' ')
            call edisp248(iuout,outs,100)
            longtfile=' '
            longtfile=longtfiledos
          endif

C If browsing pass this information to bps and if the user
C has set the trace level above 1 add a -v option to the
C command line.
          if(browse)then
            if(itrc.gt.1)then
              brw = ' -v -b yes'
            else
              brw = ' -b yes'
            endif
          else
            if(itrc.gt.1)then
              brw = ' -v -b no '
            else
              brw = ' -b no '
            endif
          endif

C If prj initial size is a % of default, pass this to child with
C an offset from the prj start position.
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif

          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,7a)') 'bps -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' -file ',
     &        longtfile(1:lnblnk(longtfile)),brw,' -p ',
     &        spfdescr(isset)(1:lnblnk(spfdescr(isset))),aut,' & '
          else
            write(doit,'(9a)') 'bps -mode ',tmode,
     &        ' -s 0 0 0 -file ',longtfile(1:lnblnk(longtfile)),
     &        brw,' -p ',spfdescr(isset)(1:lnblnk(spfdescr(isset))),aut,
     &        ' & '
          endif
          if(tmode(1:7).eq.'graphic')then ! tmode for runit is different from
                                          ! tmode ESP-r command line argument
             call runit(doit,'-')         ! use '-' to request execute_command_line
          else
            call runit(doit,tmode)
          endif
          return
        else

C Invoke simulator for the case without a simulation parameter set.
          if(NIACT.gt.0) call edisp(iuout,
     &      'Use run silent for uncertainty assessments.')
          doit = ' '
          call terminalmode(childterminal,tmode)
          call isunix(unixok)
          if(unixok)then
            call addpath(LCFGF,longtfile,concat)
          else

C For a non-unix machine see if there are spaces in the name
C and change any / to \.
            call addpath(LCFGF,longtfile,concat)
            call cmdfiledos(longtfile,longtfiledos,ier)

C Debug the patched file name.
            write(outs,'(2a)') '* Corrected file ',
     &        longtfiledos(1:lnblnk(longtfiledos))
            call edisp(iuout,outs)
            longtfile=' '
            longtfile=longtfiledos
          endif

C If browsing pass this information to bps.
          if(browse)then
            if(itrc.gt.1)then
              brw = ' -v -b yes'
            else
              brw = ' -b yes'
            endif
          else
            if(itrc.gt.1)then
              brw = ' -v -b no '
            else
              brw = ' -b no '
            endif
          endif

C If prj initial size is a % of default, pass this to child with
C an offset from the prj start position.
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif
          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,4a)') 'bps -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' -file ',
     &        longtfile(1:lnblnk(longtfile)),brw,' & '
          else
            write(doit,'(6a)') 'bps -mode ',tmode,
     &        ' -s 0 0 0 -file ',longtfile(1:lnblnk(longtfile)),
     &        brw,' & '
          endif
          if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
             call runit(doit,'-')
          else
            call runit(doit,tmode)
          endif
          return
        endif

C Flow analysis.
      elseif(INO.EQ.MITEM-7)then
        helptopic='prj_simulation_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(' ','Flow analysis via:','nodal network',
     &    'CFD','cancel',' ',' ',' ',' ',' ',IW,nbhelp)

C Execute mfs.
        IF(IW.EQ.1)THEN
          doit = ' '
          call terminalmode(childterminal,tmode)

C If prj initial size is a % of default, pass this to child with
C an offset from the prj start position.
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif
          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,a)') 'mfs -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' & '
          else
            write(doit,'(3a)') 'mfs -mode ',tmode,' -s 0 0 0 & '
          endif
          if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
             call runit(doit,'-')
          else
            call runit(doit,tmode)
          endif

C Execute dfs.
        ELSEIF(IW.EQ.2)THEN
          call CFDLIST(iuout,ier) ! List available domain files.
          doit = ' '
          call terminalmode(childterminal,tmode)

C If prj initial size is a % of default, pass this to child with
C an offset from the prj start position.
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif
          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,a)') 'dfs -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' & '
          else
            write(doit,'(3a)') 'dfs -mode ',tmode,' -s 0 0 0 & '
          endif
          if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line 
             call runit(doit,'-')
          else
            call runit(doit,tmode)
          endif
        ENDIF

C Visual simulation. Starts e2r with configuration file. Set up appropriate
C path for Unix or Windows.
      elseif(INO.EQ.MITEM-6)then
        if(itrc.gt.1)then
          brw = ' -v -b no '
        else
          brw = ' -b no '
        endif

        doit = ' '
        call terminalmode(childterminal,tmode)
        call isunix(unixok)
        if(unixok)then
          call addpath(LCFGF,longtfile,concat)
        else

C For a non-unix machine, see if there are spaces in the name
C and change any / to \.
          call addpath(LCFGF,longtfile,concat)
          call cmdfiledos(longtfile,longtfiledos,ier)
          longtfile=' '
          longtfile=longtfiledos
        endif
        if(iappw.eq.690)then
          iappwpc=100
        else
          iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
        endif
        if(iappwpc.gt.0.and.iappwpc.le.200)then
          write(doit,'(3a,3i4,4a)') 'e2r -mode ',tmode,
     &      ' -s ',iappwpc,iappx+35,iappy+40,' -file ',
     &      longtfile(1:lnblnk(longtfile)),brw,' & '
        else
          write(doit,'(6a)') 'e2r -mode ',tmode,
     &      ' -s 0 0 0 -file ',longtfile(1:lnblnk(longtfile)),brw,' & '
        endif
        if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
           call runit(doit,'-')
        else
          call runit(doit,tmode)
        endif

C IPV for the actual number of simulations required.
      elseif(INO.EQ.MITEM-5)then
        call ipvactions(ier)

C Generate UK NCM specific models, run simulations and generate results.
      elseif(INO.EQ.MITEM-4)then
        call MMGFUN
        if(nsset.gt.0)isset=1

C Case of no initial simulation parameter sets, offer default or user 
C defined sets. If the data is internal to the file then it will already
C have been scanned.
      elseif(MITEM.eq.11.and.INO.EQ.1)then
        helptopic='prj_sim_set_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        if(icfgv.lt.4)then

C IPV description held in a separate file.
          if(lnblnk(lipvdatf).eq.0.or.lipvdatf(1:7).eq.'UNKNOWN')then
            CALL EASKOK(' ',
     &        'Proceed with simulation parameter definitions?',
     &        OK,nbhelp)
            if(.NOT.OK)then
              INO=-4
              GOTO 3
            endif
            ID=1   ! remember new state
          else

C Scan the IPV description before asking user choice.
            call FINDFIL(lipvdatf,XST)
            IF(XST)then
              ipvaction='ipv'
              call ripvdat(ifil+1,lipvdatf,ipvaction,ier)
            else
              call usrmsg('IPV definition not found.',lipvdatf,'W')
              INO=-4
              GOTO 3
            endif
            CALL EASKOK('IPV description found!',
     &        'Create matching parameter sets?',OK,nbhelp)
            if(.NOT.OK)then
              INO=-4
              GOTO 3
            endif
            ID=3   ! remember existing state
          endif
        else

C There may be IPV data held in the configuration file.
          if(nipvassmt.eq.0)then
            CALL EASKOK(' ','Proceed with parameter definitions?',
     &        OK,nbhelp)
            if(.NOT.OK)then
              INO=-4
              GOTO 3
            endif
            ID=1   ! remember new state
          else
            CALL EASKOK('IPV description found!',
     &        'Create matching parameter sets?',OK,nbhelp)
            if(.NOT.OK)then
              INO=-4
              GOTO 3
            endif
            ID=3   ! remember existing state   
          endif
        endif

C Set up one or more parameter sets to match IPV description.
        if(ID.eq.1.or.ID.eq.3)then
          if(INDCFG.eq.2)then  ! If plant only.
            nsset=1; isset=1; isstup=0; isstupex(1)=0
            isbnstep=4; isbnstepex(1)=4
            ispnstep=10; ispnstepex(1)=10
            issave=4; issaveex(1)=4
            isavgh=0; isavghex(1)=0
            iscfdactivate(1)=0; isicfdys(1)=0; isicfdyf(1)=0
            scftims(1)=0.0; scftimf(1)=23.9
          else
            call scntcnst(TDM,istd,TCM,ISTC,ITCN)
            nsset=1; isset=1
            if(isstup.eq.0)then
              isstup=ITCNST; isstupex(1)=ITCNST
            elseif(isstup.ne.ITCN)then
              write(outs,'(a,i2,a,i2,a)') 'Current warm-up days ',
     &          isstup,' differs from the suggested value',ITCN,
     &          ' based on thermal diffusivity.'
              call edisp(iuout,outs)
              CALL EASKMBOX('Set warm-up days to suggested value?',
     &          'Options:','yes','no','cancel',
     &          ' ',' ',' ',' ',' ',IW,nbhelp)
              if(IW.eq.1)then
                isstup=ITCN; isstupex(1)=ITCN
              endif
            endif
            isbnstep=4; isbnstepex(1)=4
            ispnstep=10; ispnstepex(1)=10
            issave=4; issaveex(1)=4
            isavgh=0; isavghex(1)=0
            iscfdactivate(1)=0; isicfdys(1)=0; isicfdyf(1)=0
            scftims(1)=0.0; scftimf(1)=23.9
          endif
          if(ID.eq.1)then
            de='default'
            CALL EASKS(de,' ','Name for set?',30,'win','set name',
     &        IER,nbhelp)
            write(spfdescr(isset),'(a30)')de(1:30)
            lde=lnblnk(spfdescr(isset))
            spfdescr(2)='-'; spfdescr(3)='-'
            spfdescr(4)='-'; spfdescr(5)='-'
            isstday(isset)=9; isstmon(isset)=1
            isfnday(isset)=15; isfnmon(isset)=1
            iscfdactivate(isset)=0; 
            isicfdys(isset)=9; isicfdyf(isset)=15
            scftims(isset)=0.0; scftimf(isset)=23.9

C Initially use global values.
            isstupex(isset)=isstup; isbnstepex(isset)=isbnstep
            ispnstepex(isset)=ispnstep
            issaveex(isset)=issave; isavghex(isset)=isavgh

C Prepend ../tmp if Unix.
            call isunix(unixok)
            if(unixok)then
              write(cr,'(2a)') '../tmp/',cfgroot(1:lnblnk(cfgroot))
            else
              write(cr,'(a)') cfgroot(1:lnblnk(cfgroot))
            endif
            lr=lnblnk(cr)
            if(INDCFG.ne.2)then
              WRITE(sblres(isset),'(A,A4)') cr(1:lr),'.res'
            else
              sblres(isset)=' '
            endif
            if(IAIRN.ge.1)then
              WRITE(sflres(isset),'(A,A4)') cr(1:lr),'.mfr'
            else
              sflres(isset)=' '
            endif
            if(INDCFG.eq.2.or.INDCFG.eq.3)then
              WRITE(splres(isset),'(A,A4)') cr(1:lr),'.plr'
            else
              splres(isset)=' '
            endif
            if(MSTROK)then
              WRITE(smstres(isset),'(A,A4)') cr(1:lr),'.msr'
            else
              smstres(isset)=' '
            endif
            if(ientxist.gt.0)then
              WRITE(selres(isset),'(A,A4)') cr(1:lr),'.elr'
            else
              selres(isset)=' '
            endif
            if(CFDOK)then
              WRITE(scfdres(isset),'(A,A4)') cr(1:lr),'.dfr'
            else
              scfdres(isset)=' '
            endif

            if(lnblnk(lipvdatf).eq.0)then
              sipvres=' '
            elseif(lipvdatf(1:7).eq.'UNKNOWN')then
              sipvres=' '
            elseif(lipvdatf(1:8).eq.'internal')then
              WRITE(sipvres,'(A,A7)') cr(1:lr),'ipv.rep'
            else
              WRITE(sipvres,'(A,A7)') cr(1:lr),'ipv.rep'
            endif
          elseif(ID.eq.3)then

C Set parameter sets for current number of IPV assessments.
            call ipv2simpar(ipvsimu)
          endif
          modparms=.true.
        endif

C Help text for this menu and all of the dialogs.
      elseif(MITEM.eq.26.and.INO.EQ.1)then
        helptopic='prj_sim_set_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)

C Select an existing set, create a new one or cancel.
 170    do 60 ii=1, nsset
          CALL EDAY(isstday(ii),isstmon(ii),ijdstart)
          call stdate(iyear,ijdstart,descra,descrst,descr2st)
          CALL EDAY(isfnday(ii),isfnmon(ii),ijdfinish)
          call stdate(iyear,ijdfinish,descrb,descrfn,descr2fn)
          CALL EMKEY(ii,KEY,IER)
          write(dd(ii),'(8a,i2)') key,' ',spfdescr(ii)
     &      (1:lnblnk(spfdescr(ii))),' ',descrst,'-',
     &      descrfn,' ',isbnstepex(ii)
 60     continue
        if (nsset.lt.MSPS) then
          dd(nsset+1)='+ make a new set'
        else
          dd(nsset+1)='                '
        endif
        dd(nsset+2)='? help            '
        dd(nsset+3)='- end this menu   '
        ic=nsset+3
        if(ic.lt.MSPS+3)then
          do 61 ii=ic+1,MSPS+3
            dd(ii)=' '
 61       continue
        endif

        CALL EMENU('Parameter sets periods TSPH',dd,ic,IRT)
        if(IRT.ge.ic) then
          INO=-4
          GOTO 3
        elseif(IRT.eq.ic-1) then
          helptopic='prj_sim_set_menu'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('Simulation sets',nbhelp,'-',0,0,IER)
          goto 170
        elseif(IRT.eq.ic-2.and.nsset.lt.MSPS)then

C If it is possible to add another set ask user & set file names.
          de='win'
          CALL EASKS(de,' ','Name for simulation parameter set?',
     &      30,'win','set name',IER,nbhelp)
          nsset=nsset+1
          isset=nsset
          write(spfdescr(isset),'(a30)')de(1:30)

C Use global values that the user can update later.
C Prepend ../tmp if Unix.
          call isunix(unixok)
          if(unixok)then
            write(cr,'(2a)') '../tmp/',cfgroot(1:lnblnk(cfgroot))
          else
            write(cr,'(a)') cfgroot(1:lnblnk(cfgroot))
          endif
          lr=lnblnk(cr)
          isstupex(isset)=isstup
          isbnstepex(isset)=isbnstep
          ispnstepex(isset)=ispnstep
          issaveex(isset)=issave
          isavghex(isset)=isavgh
          lde=lnblnk(spfdescr(isset))
          isstday(isset)=9; isstmon(isset)=1
          isfnday(isset)=15; isfnmon(isset)=1
          isicfdys(isset)=9; isicfdyf(isset)=15
          scftims(isset)=0.0; scftimf(isset)=23.9
          if(INDCFG.ne.2)then
            WRITE(sblres(isset),'(3a)')cr(1:lr),de(1:lde),'.res'
          else
            sblres(isset)=' '
          endif
          if(IAIRN.ge.1)then
            WRITE(sflres(isset),'(3a)')cr(1:lr),de(1:lde),'.mfr'
          else
            sflres(isset)=' '
          endif
          if(INDCFG.eq.2.or.INDCFG.eq.3)then
            WRITE(splres(isset),'(3a)')cr(1:lr),de(1:lde),'.plr'
          else
            splres(isset)=' '
          endif
          if(MSTROK)then
            WRITE(smstres(isset),'(3a)')cr(1:lr),de(1:lde),'.msr'
          else
            smstres(isset)=' '
          endif
          if(CFDOK)then
            WRITE(scfdres(isset),'(3a)')cr(1:lr),de(1:lde),'.dfr'
            iscfdactivate(isset)=0; 
          else
            scfdres(isset)=' '
            iscfdactivate(isset)=-1; 
          endif

          modparms=.true.
          goto 170
        elseif(IRT.eq.ic-2.and.nsset.ge.MSPS)then
          call usrmsg('At the limit of simulation parameter sets.',
     &      'Unable to add another.','W')
          goto 170
        elseif(IRT.ge.1.and.IRT.le.nsset)then
          isset=IRT  ! choose an existing set
        endif
        call scntcnst(TDM,istd,TCM,ISTC,ITCN)

C If there is an IPV descripton and this set is one,
C do not allow this set name to be changed.
      elseif(MITEM.eq.26.and.INO.EQ.2)then
        if(nipvassmt.eq.nsset)then
          call usrmsg('IPV set name is pre-defined.',' ','W')
        else
          de=spfdescr(isset)
          CALL EASKS(de,' ','Name for set?',30,spfdescr(isset),
     &               'set name',IER,nbhelp)
          write(spfdescr(isset),'(a30)')de(1:30)
          modparms=.true.
        endif

      elseif(MITEM.eq.26.and.INO.EQ.3)then
        call scntcnst(TDM,istd,TCM,ISTC,ITCN)
        isstupt=isstupex(isset)
        CALL EASKI(isstupt,' ',
     &     'Pre-simulation start-up period (days)?',
     &     0,'F',100,'W',ITCNST,'presimulation days',IERI,nbhelp)
        if(ieri.eq.-3)then
          continue
        else
          isstupex(isset)=isstupt
          modparms=.true.
        endif 

C The simulation timestep. Edit local variable and if not cancelling
C instantiate it and also ask about results integration if more than
C one timestep in the hour.
      elseif(MITEM.eq.26.and.INO.EQ.4)then
        if(itdflg.ne.0)then
          write(outs,'(2a,i3,a)') 'The model includes a temporal',
     &     'file with ',ntsph,' per hour frequency.'
          call edisp(iuout,outs)
        endif
        isbnstept=isbnstepex(isset)
        CALL EASKI(isbnstept,' ','Zone-side time steps per hour?',
     &       1,'F',60,'W',2,'zone steps per hour',IERI,nbhelp)
        if(ieri.eq.-3)then
          continue
        else
          isbnstepex(isset)=isbnstept
          if(isbnstepex(isset).gt.1)then
            if(itdflg.ne.0)then

C There is temporal data so must save at each timestep.
              isavghex(isset)=0
            else
              defok=.false.
              hri=.false.
              call easkok(' ','Hourly results integration:',hri,
     &          nbhelp)
              if(hri)then
                isavghex(isset)=1
              else
                isavghex(isset)=0
              endif
            endif
          else
            isavghex(isset)=0
          endif
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.5)then
        if(INDCFG.eq.2.or.INDCFG.eq.3)then
          ispnstept=ispnstepex(isset)
          CALL EASKI(ispnstept,' ',
     &      'Plant-side time steps per zone step?',
     &      1,'F',100,'W',10,'plt steps per hour',IERI,nbhelp)
          if(ieri.eq.-3)then
            continue
          else
            ispnstepex(isset)=ispnstept
            modparms=.true.
          endif
        endif
      elseif(MITEM.eq.26.and.INO.EQ.6)then
        issavet=issaveex(isset)
        CALL EASKI(issavet,' ','Results save level (0-4 & 6)?',
     &      0,'F',6,'F',6,'save level',IERI,nbhelp)
        if(ieri.eq.-3)then
          continue
        else
          issaveex(isset)=issavet
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.7)then 
        CALL EDAY(isstday(isset),isstmon(isset),ISDS)
        CALL EDAY(isfnday(isset),isfnmon(isset),ISDF)
        call EASKPER('Assessment period:',ISDS,ISDF,IFDAY,IER)
        call EDAYR(ISDS,isstday(isset),isstmon(isset))
        call EDAYR(ISDF,isfnday(isset),isfnmon(isset))
        modparms=.true.
      elseif(MITEM.eq.26.and.INO.EQ.8)then
        t72=sblres(isset)
        CALL EASKS(t72,' ','Building results library?',72,
     &    'zones.res','bld library',IER,nbhelp)
        sblres(isset)=t72
        modparms=.true.
      elseif(MITEM.eq.26.and.INO.EQ.9)then
        if(IAIRN.ge.1)then
          t72=sflres(isset)
          CALL EASKS(t72,' ','Network flow results library?',72,
     &    'network.mfr','flow results library',IER,nbhelp)
          sflres(isset)=t72
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.10)then
        if(INDCFG.eq.2.or.INDCFG.eq.3)then
          t72=splres(isset)
          CALL EASKS(t72,' ','Plant results library?',72,
     &    'plant.res','plant results library',IER,nbhelp)
          splres(isset)=t72
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.11)then
        if(ispmxist.gt.0)then
          continue
        endif
      elseif(MITEM.eq.26.and.INO.EQ.12)then
        if(MSTROK)then
          t72=smstres(isset)
          CALL EASKS(t72,' ','Moisture results library?',72,
     &    'moist.res','moisture results library',IER,nbhelp)
          smstres(isset)=t72
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.13)then
        if(ientxist.gt.0)then
          t72=selres(isset)
          CALL EASKS(t72,' ','Electrical results library?',72,
     &    'elect.res','electrical results library',IER,nbhelp)
          selres(isset)=t72
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.14)then
        if(CFDOK)then

C Ask if CFD assessments are required.
          CALL EASKOK(' ','Include domains in assessment?',
     &      OK,nbhelp)
          if(ok)then
            iscfdactivate(isset)=1

C Ask for further attributes.
            t72=scfdres(isset)
            CALL EASKS(t72,' ','CFD results library?',72,
     &        'cfd.res','CFD results library',IER,nbhelp)
            scfdres(isset)=t72
            modparms=.true.
            CALL EDAY(isstday(isset),isstmon(isset),icsday)
            CALL EDAY(isfnday(isset),isfnmon(isset),icfday)
            call EASKPER('CFD Assessment period:',icsday,icfday,
     &        IFDAY,IER)
            isicfdys(isset)=icsday
            isicfdyf(isset)=icfday
  50        scftims(isset)=1.0
            scftimf(isset)=24.99
            write(outs,'(a)')'For the first day CFD is active specify'
            CALL EASKR(scftims(isset),outs,'starting time ',
     &        1.0,'F',24.99,'F',1.0,'Decimal fraction',IER,nbhelp)
            write(outs,'(a)')'For the last day CFD is active specify'
            CALL EASKR(scftimf(isset),outs,'finishing time ',
     &        1.0,'F',24.99,'F',24.99,'Decimal fraction',IER,nbhelp)
            if (scftimf(isset).lt.scftims(isset)) then
              call edisp(iuout,' Start/ finish hours out of order.')
              goto 50
            endif

          else
            iscfdactivate(isset)=0

C Set defaults, as the information will be ignored anyway.
            if(scfdres(isset)(1:2).eq.'  '.or.
     &        scfdres(isset)(1:7).eq.'UNKNOWN')then
              call isunix(unixok)
              if(unixok)then
                write(cr,'(2a)') '../tmp/',cfgroot(1:lnblnk(cfgroot))
              else
                write(cr,'(a)') cfgroot(1:lnblnk(cfgroot))
              endif
              lr=lnblnk(cr)
              WRITE(scfdres(isset),'(A,A4)') cr(1:lr),'.dfr'
            endif
            CALL EDAY(isstday(isset),isstmon(isset),isicfdys(isset))
            CALL EDAY(isfnday(isset),isfnmon(isset),isicfdyf(isset))
            scftims(isset)=1.0
            scftimf(isset)=24.99
          endif
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.15)then
        if(lnblnk(lipvdatf).eq.0)then
        elseif(lipvdatf(1:7).eq.'UNKNOWN')then
        else
          helptopic='prj_ipv_res_file'
          call gethelptext(helpinsub,helptopic,nbhelp)
          t72=sipvres
          CALL EASKS(t72,' ','IPV transfer file name?',72,
     &    'IPV.rep','IPV report file',IER,nbhelp)
          sipvres=t72
          modparms=.true.
        endif
      elseif(MITEM.eq.26.and.INO.EQ.16)then
        CALL EASKMBOX(' ','Options:',
     &    'save current sets','clear sets','cancel',
     &    ' ',' ',' ',' ',' ',IDO,nbhelp)
        if(IDO.eq.3)then
          goto 3
        elseif(IDO.eq.1.or.IDO.eq.2)then
          if(IDO.eq.2)then
            nsset=0
            modparms=.true.
          endif
          if(modparms)then
            CALL EMKCFG('s',IER)
            modparms=.false.
          else
          endif
          goto 3
        endif
      else
        INO=-4
        GOTO 3
      ENDIF
      INO=-2
      GOTO 3

      END

C ******************** ipvactions ********************
C Commissions ipv assessments and recovery and comparisons.

C << Note that the results file passed to res is 72 char rather than
C << the longer string used when commissioning a simulation.

      subroutine ipvactions(ier)
#include "building.h"
#include "model.h"
#include "ipvdata.h"
#include "help.h"

      integer lnblnk  ! function definition
      integer igraphiclib  ! external definition

C Get logical name of terminal type, expand model name
C to include the path and create a string to drive the modules.
      common/OUTIN/IUOUT,IUIN,IEOUT

C Attributes of the session log file.
      logical ieopened     ! Has session file been started.
      integer iecount      ! Does it hold error messages.
      character iefile*72  ! The name of the session file.
      common/logs/ieopened,iecount,iefile
      common/FILEP/IFIL

      common/appw/iappw,iappx,iappy
      integer iappw,iappx,iappy
      integer childterminal  ! picks up mmod from starting of prj
      common/childt/childterminal
      common/IPVF/lipvdatf
      common/exporttg/xfile,tg,delim
      
C Significant figure reporting limit (NSIGFIG).
      common/SFIG/NSIGFIG

C Typical seasons and default simulation periods. Isset is the
C current seasons set, nsset number of sets, Isauto (0=use info as
C defaults 1=autoexec mode), istcnst (startup days), isbnstep (building
C timesteps/hr), ispnstep (plant timesteps/hr), issave (results save
C level), isavgh = 0 save every timestep = 1 save hourly zone data.
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      common/spflres/sblres(MSPS),sflres(MSPS),splres(MSPS),
     &  smstres(MSPS),selres(MSPS),scfdres(MSPS),sipvres
      character sblres*72,sflres*72,splres*72,smstres*72,
     &  selres*72,scfdres*72,sipvres*72
      common/user/browse

C Extended simulation parameters for each set.
      common/spfldats/isstupex(MSPS),isbnstepex(MSPS),ispnstepex(MSPS),
     &  issaveex(MSPS),isavghex(MSPS),iscfdactivate(MSPS),
     &  isicfdys(MSPS),isicfdyf(MSPS),
     &  scftims(MSPS),scftimf(MSPS)
      INTEGER :: isstupex,isbnstepex,ispnstepex,issaveex,isavghex
      INTEGER :: iscfdactivate      ! zero ignore domains
      INTEGER :: isicfdys,isicfdyf  ! CFD simulation start & finish days
      REAL :: scftims,scftimf       ! CFD simulation start & finish time

      character doit*248,tmode*8,tfile*72
      character longtfile*144,longtfiledos*144
      CHARACTER lipvdatf*72
      character aut*12

      dimension assmttag(MSPS),runtag(MSPS)
      character assmttag*8,runtag*16,brw*8
      character ltpath*72,filen*72,ltmp*72
      character basefile*144,variantfile*144,outs*124,louts*144
      character word1*20,word2*40,word3*20,outstr*124
      character xfile*144,tg*1,delim*1,tab*1,fs*1
      character ipvaction*3

      logical XST,browse,remote,concat,unixok
      logical atreports,im2
      integer IWM   ! for radio button
      integer lmsg  ! for length of message.
      integer iappwpc ! application %
      integer ISTRW

C   anu_ht_m2 - annual heat kWh/m2/a
C   anu_ht_bld - annual heat for building kWh/a
C   anu_ht_thrm_m2 - annual heating therms/m2/a
C   anu_ht_thrm_bld - annual heating therms/a
C   anu_cl_m2 - annual cooling kWh/m2/a
C   anu_cl_bld - annual heat for buidling kWh/a
C   anu_tot_m2 - annual total heating/cooling/lights etc.
C   anu_ht_cap_m2 - annual heating capacity kW/m2/a
C   anu_ht_cap_bld - annual buidling heating capacity kW/a
C   anu_cl_cap_m2 - annual cooling capacity kW/m2/a
C   anu_cl_cap_bld - annual buidling cooling capacity kW/a
C the first array index is base and 2nd is variant, 3rd diff
      dimension anu_ht_m2(3),anu_ht_bld(3)
      dimension anu_ht_thrm_m2(3),anu_ht_thrm_bld(3)
      dimension anu_cl_m2(3),anu_cl_bld(3)
      dimension anu_tot_m2(3),anu_tot_bld(3)
      dimension anu_ht_cap_m2(3),anu_ht_cap_bld(3)
      dimension anu_cl_cap_m2(3),anu_cl_cap_bld(3)

      helpinsub='prj'  ! set for subroutine
      ibasefile=11
      ivarfile=12
      NSIGFIG=3
      tab=CHAR(9)

      if(nsset.gt.0)isset=1
      write(basefile,'(a)') sipvres(1:lnblnk(sipvres))
      write(variantfile,'(a)') sipvres(1:lnblnk(sipvres))
      aut=' default'

C Set file separator.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Clear values.
      anu_ht_m2(1)=0.; anu_ht_m2(2)=0.; anu_ht_m2(3)=0.
      anu_ht_bld(1)=0.; anu_ht_bld(2)=0.; anu_ht_bld(3)=0.
      anu_ht_thrm_m2(1)=0.; anu_ht_thrm_m2(2)=0.; anu_ht_thrm_m2(3)=0.
      anu_ht_thrm_bld(1)=0.;anu_ht_thrm_bld(2)=0.;anu_ht_thrm_bld(3)=0.
      anu_cl_m2(1)=0.; anu_cl_m2(2)=0.; anu_cl_m2(3)=0.;  
      anu_cl_bld(1)=0.; anu_cl_bld(2)=0.; anu_cl_bld(3)=0.;
      anu_tot_m2(1)=0.; anu_tot_m2(2)=0.; anu_tot_m2(3)=0.;   
      anu_tot_bld(1)=0.; anu_tot_bld(2)=0.; anu_tot_bld(3)=0.;   
      anu_ht_cap_m2(1)=0.; anu_ht_cap_m2(2)=0.; anu_ht_cap_m2(3)=0.
      anu_ht_cap_bld(1)=0.; anu_ht_cap_bld(2)=0.; anu_ht_cap_bld(3)=0.
      anu_cl_cap_m2(1)=0.; anu_cl_cap_m2(2)=0.; anu_cl_cap_m2(3)=0. 
      anu_cl_cap_bld(1)=0.; anu_cl_cap_bld(2)=0.; anu_cl_cap_bld(3)=0. 

C Setup help messages for this menu and its dialogs.
      helptopic='prj_ipv_options'
      call gethelptext(helpinsub,helptopic,nbhelp)
 
C IPV for the actual number of simulations required.  A separate file
C for legacy model cfg files.
      if(icfgv.lt.4)then
        if(lnblnk(lipvdatf).eq.0)then
          CALL PHELPD('IPV message',nbhelp,'-',0,0,IER)
          return
        elseif(lipvdatf(1:7).eq.'UNKNOWN')then
          CALL PHELPD('IPV message',nbhelp,'-',0,0,IER)
          return
        elseif(lipvdatf(1:8).eq.'internal')then
          continue  ! carry on because IPV is within cfg file
        else
          call FINDFIL(lipvdatf,XST)
          IF(XST)then
            ipvaction='ipv'
            call ripvdat(ifil+1,lipvdatf,ipvaction,ier)
            if(ier.ne.0)then
              CALL PHELPD('IPV message',nbhelp,'-',0,0,IER)
              return
            endif
          else
            CALL PHELPD('IPV message',nbhelp,'-',0,0,IER)
            return
          endif
        endif
      else
      
C IPV data could be internal to cfg file.
        if(nipvassmt.eq.0)then
          CALL PHELPD('IPV message',nbhelp,'-',0,0,IER)
          return
        else
          continue
        endif
      endif

  39  CALL EASKMBOX(' ','IPV options:',
     &  'simulate','extract reports',
     &  'compare reports','cancel',' ',' ',' ',' ',irs,nbhelp)

      if(irs.eq.1)then

C Run the simulations.
        CALL EASKMBOX(' ','Simulation options:',
     &    'interactive','silent',
     &    'cancel',' ',' ',' ',' ',' ',isauto,nbhelp)
        doit = ' '
        call terminalmode(childterminal,tmode)
        if(isauto.eq.1)then
          aut=' default'
        elseif(isauto.eq.2)then
          aut=' silent '
          tmode='text'
        elseif(isauto.eq.3)then
          return
        endif

C Temporarily assume no browsing if in ipv mode.
        if(browse)then
          brw = ' -b yes'
        else
          brw = ' -b no '
        endif

        call isunix(unixok)
        if(unixok)then
          call addpath(LCFGF,longtfile,concat)
        else

C If running on a non-unix machine see if there are spaces in the name
C and change any / to \.
          call addpath(LCFGF,longtfile,concat)
          call cmdfiledos(longtfile,longtfiledos,ier)
          longtfile=' '
          longtfile=longtfiledos
        endif

C Run only the number of assessments required. Currently there is
C an assumption that the IPV will use fixed names for the 3 and 5
C season assessments.
        if(ipvsimu(1:6).eq.'icwint'.or.ipvsimu(1:6).eq.'icwinf'.or.
     &     ipvsimu(1:6).eq.'icwins')then
          assmttag(1)=' -p win'
        elseif(ipvsimu(1:6).eq.'icsprt'.or.ipvsimu(1:6).eq.'icsprf'.or.
     &         ipvsimu(1:6).eq.'icsprs')then    
          assmttag(1)=' -p trn'
        elseif(ipvsimu(1:6).eq.'icsumt'.or.ipvsimu(1:6).eq.'icsumf'.or.
     &       ipvsimu(1:6).eq.'icsums')then
          assmttag(1)=' -p sum'
        elseif(ipvsimu(1:6).eq.'icautt'.or. ipvsimu(1:6).eq.'icautf'.or.
     &         ipvsimu(1:6).eq.'icauts')then
          assmttag(1)=' -p aut'
        elseif(ipvsimu(1:3).eq.'ias')then   ! Annual simulation
          assmttag(1)=' -p ann'
        elseif(ipvsimu(1:3).eq.'i5s'.or.ipvsimu(1:3).eq.'i5t')then  ! Five season variant
          assmttag(1)=' -p win1'
          assmttag(2)=' -p spr'
          assmttag(3)=' -p sum'
          assmttag(4)=' -p aut'
          assmttag(5)=' -p win2'
        elseif(ipvsimu(1:3).eq.'i3s'.or.ipvsimu(1:3).eq.'i3t')then  ! Three season variant
          assmttag(1)=' -p win'
          assmttag(2)=' -p trn'
          assmttag(3)=' -p sum'
        endif

        if(nipvassmt.eq.3)then
          assmttag(1)=' -p win'
          assmttag(2)=' -p trn'
          assmttag(3)=' -p sum'
        elseif(nipvassmt.eq.5)then
          assmttag(1)=' -p win1'
          assmttag(2)=' -p spr'
          assmttag(3)=' -p sum'
          assmttag(4)=' -p aut'
          assmttag(5)=' -p win2'
        endif
        do 667 ij=1,nipvassmt
              
C If prj initial size is a % of default pass this on to child with
C an offset from prj start position.
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif
          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,5a)') 'bps -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' -file ',
     &        longtfile(1:lnblnk(longtfile)),brw,assmttag(ij),aut
          else
            write(doit,'(7a)') 'bps -mode ',tmode,
     &        ' -s 0 0 0 -file ',longtfile(1:lnblnk(longtfile)),
     &        brw,assmttag(ij),aut
          endif

          if(isauto.eq.2)then
            call runit(doit,'-')
          else
            if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
              call runit(doit,'-')
            else
              call runit(doit,tmode)
            endif
          endif
  667   continue

      elseif(irs.eq.2)then

C Extract performance report from the standard results files.
        CALL EASKMBOX(' ','IPV extraction options:',
     &    'interactive','silent','cancel',
     &    ' ',' ',' ',' ',' ',isauto,nbhelp)
        doit = ' '
        call terminalmode(childterminal,tmode)
        if(isauto.eq.1)then
          aut=' default'
        elseif(isauto.eq.2)then
          aut=' silent '
          tmode='text'
        elseif(isauto.eq.3)then
          return
        endif
        call easkmbox(' ','IPV recovery options:',
     &    'recover & append summary','cancel',
     &    ' ',' ',' ',' ',' ',' ',IRT,nbhelp)
        if(IRT.eq.2) goto 39  ! redisplay menu.

C Extract only for the number of assessments required. Note: the strings
C ipv_win ipv_win1 ipv_aut etc are set in the IPV descriptive process and
C should not be altered in the simulation parameter sets.
        if(ipvsimu(1:6).eq.'icwint'.or.ipvsimu(1:6).eq.'icwinf'.or.
     &     ipvsimu(1:6).eq.'icwins')then
          runtag(1)=' -act ipv_win '
        elseif(ipvsimu(1:6).eq.'icsprt'.or.ipvsimu(1:6).eq.'icsprf'.or.
     &         ipvsimu(1:6).eq.'icsprs')then    
          runtag(1)=' -act ipv_spr '
        elseif(ipvsimu(1:6).eq.'icsumt'.or.ipvsimu(1:6).eq.'icsumf'.or.
     &       ipvsimu(1:6).eq.'icsums')then
          runtag(1)=' -act ipv_sum'
        elseif(ipvsimu(1:6).eq.'icautt'.or. ipvsimu(1:6).eq.'icautf'.or.
     &         ipvsimu(1:6).eq.'icauts')then
          runtag(1)=' -act ipv_aut'
        elseif(ipvsimu(1:3).eq.'ias')then   ! Annual simulation
          runtag(1)=' -act ipv_ann'
        elseif(ipvsimu(1:3).eq.'i5s'.or.ipvsimu(1:3).eq.'i5t')then  ! Five season variant
          runtag(1)=' -act ipv_win1 '
          runtag(2)=' -act ipv_spr '
          runtag(3)=' -act ipv_sum '
          runtag(4)=' -act ipv_aut '
          runtag(5)=' -act ipv_win2 '
        elseif(ipvsimu(1:3).eq.'i3s'.or.ipvsimu(1:3).eq.'i3t')then  ! Three season variant
          runtag(1)=' -act ipv_win '
          runtag(2)=' -act ipv_trn '
          runtag(3)=' -act ipv_sum '
        endif
        if(nipvassmt.eq.3)then
          runtag(1)=' -act ipv_win '
          runtag(2)=' -act ipv_trn '
          runtag(3)=' -act ipv_sum '
        elseif(nipvassmt.eq.5)then
          runtag(1)=' -act ipv_win1 '
          runtag(2)=' -act ipv_spr '
          runtag(3)=' -act ipv_sum '
          runtag(4)=' -act ipv_aut '
          runtag(5)=' -act ipv_win2 '
        endif

C Logic to react when browsing a model.
        remote=.false.
        if(browse)then
          remote=.true.
        else
          ltmp = LCFGF
          call addpath(ltmp,longtfile,concat)
          if(concat)then
            remote=.true.
          endif
        endif

        if(IRT.eq.1)then
          call edisp(iuout,'  ')
          do 668 ij=1,nipvassmt
            tfile=sblres(ij)
            if(remote)then
              call fdroot(tfile,ltpath,filen)
              call isunix(unixok)
              if(unixok)then
                if (ICHAR(ltpath(1:1)).ne.47) then
                  write(tfile,'(3a)') upath(1:lnblnk(upath)),fs,
     &              filen(1:lnblnk(filen))
                endif
              else
                if (ltpath(2:2).ne.':') then
                  write(tfile,'(3a)') upath(1:lnblnk(upath)),fs,
     &              filen(1:lnblnk(filen))
                endif
              endif

            endif

            if(iappw.eq.690)then
              iappwpc=100
            else
              iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
            endif
            if(iappwpc.gt.0.and.iappwpc.le.200)then
              write(doit,'(3a,3i4,4a)') 'res -mode ',tmode,
     &          ' -s ',iappwpc,iappx+15,iappy+50,' -file ',
     &          tfile(1:lnblnk(tfile)),runtag(ij),aut
            else
              write(doit,'(6a)') 'res -mode ',tmode,
     &           ' -file ',tfile(1:lnblnk(tfile)),runtag(ij),aut
            endif

            if(isauto.eq.2)then
              call runit(doit,'-')
            else
              if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
                call runit(doit,'-')
              else
                call runit(doit,tmode)
              endif
            endif
            write(outs,'(3a)') '* IPV extract ',
     &        runtag(ij)(7:lnblnk(runtag(ij))),' is complete.'
            call edisp(iuout,outs)
 668      continue

C Having done the assessments re-open and append summary.
          if(ipvsimu(1:6).eq.'icwint'.or.ipvsimu(1:6).eq.'icwinf'.or.
     &       ipvsimu(1:6).eq.'icwins')then
            tfile=sblres(1)
          elseif(ipvsimu(1:6).eq.'icsprt'.or.
     &           ipvsimu(1:6).eq.'icsprf'.or.
     &           ipvsimu(1:6).eq.'icsprs')then    
            tfile=sblres(1)
          elseif(ipvsimu(1:6).eq.'icsumt'.or.
     &           ipvsimu(1:6).eq.'icsumf'.or.
     &           ipvsimu(1:6).eq.'icsums')then
            tfile=sblres(1)
          elseif(ipvsimu(1:6).eq.'icautt'.or.
     &           ipvsimu(1:6).eq.'icautf'.or.
     &           ipvsimu(1:6).eq.'icauts')then
            tfile=sblres(1)
          elseif(ipvsimu(1:3).eq.'ias')then   ! Annual simulation
            tfile=sblres(1)
          else
            tfile=sblres(nipvassmt)
          endif
          if(remote)then
            call fdroot(tfile,ltpath,filen)
            call isunix(unixok)
            if(unixok)then
              if (ICHAR(ltpath(1:1)).ne.47) then
                write(tfile,'(3a)') upath(1:lnblnk(upath)),fs,
     &            filen(1:lnblnk(filen))
              endif
            else
              if (ltpath(2:2).ne.':') then
                write(tfile,'(3a)') upath(1:lnblnk(upath)),fs,
     &            filen(1:lnblnk(filen))
              endif
            endif

          endif
          if(iappw.eq.690)then
            iappwpc=100
          else
            iappwpc=nint(100.0*(real(iappw)/690.0))  ! reconstitute %
          endif
          if(iappwpc.gt.0.and.iappwpc.le.200)then
            write(doit,'(3a,3i4,4a)') 'res -mode ',tmode,
     &        ' -s ',iappwpc,iappx+15,iappy+50,' -file ',
     &        tfile(1:lnblnk(tfile)),' -act ipv_annual ',aut
          else
            write(doit,'(6a)') 'res -mode ',tmode,' -file ',
     &        tfile(1:lnblnk(tfile)),' -act ipv_annual ',aut
          endif

          if(isauto.eq.2)then
            call runit(doit,'-')
          else
            if(tmode(1:7).eq.'graphic')then ! use '-' to request execute_command_line
             call runit(doit,'-')
            else
              call runit(doit,tmode)
            endif
          endif
        endif

      elseif(irs.eq.3)then

C Compare two IPV reports.  First ask for separator.

C Toggle delimeter.
        IWM=1
        CALL EASKMBOX(' ','Column delimeter:',
     &    'spaces','single space','tab','comma','tagged',
     &    'cancel',' ',' ',IWM,nbhelp)
        if(iwm.eq.1)then
          delim = '-'
        elseif(iwm.eq.2)then
          delim = 'S'
        elseif(iwm.eq.3)then
          delim = 'T'
        elseif(iwm.eq.4)then
          delim = 'C'
        elseif(iwm.eq.5)then
          delim = 'X'
        elseif(iwm.eq.6)then
          goto 39  ! redisplay menu.
        endif

 41     llt=lnblnk(basefile)
        iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
        if(iglib.eq.1.or.iglib.eq.3)then
          if(llt.lt.96)then
            ISTRW=96
          elseif(llt.ge.96.and.llt.lt.124)then
            ISTRW=124
          elseif(llt.ge.124.and.llt.le.144)then
            ISTRW=144
          endif
        elseif(iglib.eq.2)then
          ISTRW=144
        else
          ISTRW=96
        endif
        CALL EASKF(basefile,' ','IPV base case report file?',
     &    ISTRW,'xxx.rep','IPV base report',IER,nbhelp)

C At user's request re-display the menu.
        if(ier.eq.-3)then
          goto 39  ! redisplay menu.
        endif

        lnf=lnblnk(basefile)
        inquire (file=basefile(1:lnf),exist=xst)
        if(xst)then
          call erpfree(ibasefile,istat)
          OPEN (ibasefile,FILE=basefile(1:lnf),ACCESS='SEQUENTIAL',
     &      STATUS='OLD',IOSTAT=ISTAT)
          if(istat.eq.0)then
            call edisp(iuout,' ')
            call edisp(iuout,'Base model is')
            call edisp(iuout,basefile)
          else
            call edisp(iuout,'Problem with base case file!')
            goto 41
          endif
        endif

C Ask the name of the design variant file.
 40     llt=lnblnk(variantfile)
        iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
        if(iglib.eq.1.or.iglib.eq.3)then
          if(llt.lt.96)then
            ISTRW=96
          elseif(llt.ge.96.and.llt.lt.124)then
            ISTRW=124
          elseif(llt.ge.124.and.llt.le.144)then
            ISTRW=144
          endif
        elseif(iglib.eq.2)then
          ISTRW=144
        else
          ISTRW=96
        endif
        CALL EASKF(variantfile,' ','IPV variant report file?',
     &    ISTRW,'xxx.rep','IPV variant report',IER,nbhelp)

C At user's request re-display the menu.
        if(ier.eq.-3)then
          goto 39  ! redisplay menu.
        endif

        lnf=lnblnk(variantfile)
        inquire (file=variantfile(1:lnf),exist=xst)
        if(xst)then
          call erpfree(ivarfile,istat)
          OPEN (ivarfile,FILE=variantfile(1:lnf),ACCESS='SEQUENTIAL',
     &      STATUS='OLD',IOSTAT=ISTAT)
          if(istat.eq.0)then
            call edisp(iuout,' ')
            call edisp(iuout,'Variant model is')
            call edisp(iuout,variantfile)
          else
            call edisp(iuout,'Problem with variant file!')
            goto 40
          endif
        endif

C Recover data from the base case file.
C Set test logic to false.
        ipass=1
  42    if(ipass.eq.1)ifu=ibasefile
        if(ipass.eq.2)ifu=ivarfile
        if(ipass.eq.3)then

C We have done both passes, report differences and exit.
          call edisp(iuout,' ')
          call edisp(iuout,'Summary of performance and differences.')
          call edisp(iuout,' ')
          call edisp(iuout,'Demand is reported in kWh/m^2/a and kWh/a')
          call edisp(iuout,'Capacity is reported in kW/m^2/a and kW/a')
          call edisp(iuout,
     &      'Differences reported between the base case model and the')
          call edisp(iuout,
     &      'variant: positive = savings.')
          call edisp(iuout,' ')
          call edisp(iuout,'For the base case model:')
          if(delim.eq.'-')then
            call edisp(iuout,
     &            '        Demand              Capacity')
            call edisp(iuout,
     &            '        m^2    building     m^2    building')
          elseif(delim.eq.'T')then
            write(outs,'(7a)') 'Demand m^2',tab,'Demand building',tab,
     &        'Capacity m^2',tab,'Capacity building'
          elseif(delim.eq.'C')then
            write(outs,'(2a)') 'Demand m^2,Demand building,',
     &        'Capacity m^2,Capacity building'
          elseif(delim.eq.'S')then
            write(outs,'(2a)') 'Demand m&^2 Demand building ',
     &        'Capacity m^2 Capacity building'
          endif
          call edisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Heat  ',
     &      anu_ht_m2(1),
     &      anu_ht_bld(1),anu_ht_cap_m2(1),anu_ht_cap_bld(1)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2)') 'Therm ',anu_ht_thrm_m2(1),
     &      anu_ht_thrm_bld(1)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Cool  ',
     &      anu_cl_m2(1),
     &      anu_cl_bld(1),anu_cl_cap_m2(1),anu_cl_cap_bld(1)
          call eddisp(iuout,outs)
          call edisp(iuout,'* For the variant model:')
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Heat  ',
     &      anu_ht_m2(2),
     &      anu_ht_bld(2),anu_ht_cap_m2(2),anu_ht_cap_bld(2)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2)') 'Therm ',anu_ht_thrm_m2(2),
     &      anu_ht_thrm_bld(2)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Cool  ',
     &      anu_cl_m2(2),
     &      anu_cl_bld(2),anu_cl_cap_m2(2),anu_cl_cap_bld(2)
          call eddisp(iuout,outs)

C Ensure long file names fit in buffer.
          lmsg=lnblnk(basefile)+lnblnk(variantfile)+16
          if(lmsg.lt.144)then
            write(louts,'(4a)')'Diff between ',
     &        basefile(1:lnblnk(basefile)),
     &        ' & ',variantfile(1:lnblnk(variantfile))
            call edisp(iuout,louts)
          else
            write(louts,'(2a)')'Diff between ',
     &        basefile(1:lnblnk(basefile))
            call edisp(iuout,louts)
            write(louts,'(2a)')'Diff between ',
     &        ' & ',variantfile(1:lnblnk(variantfile))
            call edisp(iuout,louts)
          endif
          if(delim.eq.'-')then
            call edisp(iuout,
     &            '        Demand              Capacity')
            call edisp(iuout,
     &            '        m^2    building     m^2    building')
          elseif(delim.eq.'T')then
            write(outs,'(7a)') 'Demand m^2',tab,'Demand building',tab,
     &        'Capacity m^2',tab,'Capacity building'
          elseif(delim.eq.'C')then
            write(outs,'(2a)') 'Demand m^2,Demand building,',
     &        'Capacity m^2,Capacity building'
          elseif(delim.eq.'S')then
            write(outs,'(2a)') 'Demand m^2 Demand building ',
     &        'Capacity m^2 Capacity building'
          endif
          call edisp(iuout,outs)
          anu_ht_m2(3)=anu_ht_m2(1)-anu_ht_m2(2)
          anu_ht_bld(3)=anu_ht_bld(1)-anu_ht_bld(2)
          anu_ht_thrm_m2(3)=anu_ht_thrm_m2(1)-anu_ht_thrm_m2(2)
          anu_ht_thrm_bld(3)=anu_ht_thrm_bld(1)-anu_ht_thrm_bld(2)
          anu_cl_m2(3)=anu_cl_m2(1)-anu_cl_m2(2)
          anu_cl_bld(3)=anu_cl_bld(1)-anu_cl_bld(2)
          anu_tot_bld(3)=anu_tot_bld(1)-anu_tot_bld(2)
          anu_ht_cap_m2(3)=anu_ht_cap_m2(1)-anu_ht_cap_m2(2)
          anu_ht_cap_bld(3)=anu_ht_cap_bld(1)-anu_ht_cap_bld(2)
          anu_cl_cap_m2(3)=anu_cl_cap_m2(1)-anu_cl_cap_m2(2)
          anu_cl_cap_bld(3)=anu_cl_cap_bld(1)-anu_cl_cap_bld(2)
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Heat  ',
     &      anu_ht_m2(3),
     &      anu_ht_bld(3),anu_ht_cap_m2(3),anu_ht_cap_bld(3)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.2,F10.2)') 'Therm ',anu_ht_thrm_m2(3),
     &      anu_ht_thrm_bld(3)
          call eddisp(iuout,outs)
          write(outs,'(a,F8.3,F10.2,F9.3,F10.2)') 'Cool  ',
     &      anu_cl_m2(3),
     &      anu_cl_bld(3),anu_cl_cap_m2(3),anu_cl_cap_bld(3)
          call eddisp(iuout,outs)

C Patch for IEA_Annex 46: if comma separated delimeter then also
C write out a single line summary.
          if(delim.eq.'C')then
            call edisp(iuout,
     & 'Location,building heating kWh/a,heating therms,cooling kWh/a')
            write(outs,'(2a,F11.2,a,F11.2,a,F11.2)')
     &        variantfile(1:lnblnk(variantfile)),' ',anu_ht_bld(3),
     &        ' ',anu_ht_thrm_bld(3),' ',anu_cl_bld(3)
            call eddisp(iuout,outs)
          endif

          CALL EASKMBOX(' ','Comparison options:','return to menu',
     &      'another report',' ',' ',' ',' ',' ',' ',IW,nbhelp)
          if(iw.eq.1)then
            return
          else
            call erpfree(ibasefile,istat)
            call erpfree(ivarfile,istat)
            goto 41
          endif
        endif
        atreports=.false.
 142    CALL STRIPC(ifu,OUTSTR,0,ND,1,'*Summary',IER)
        IF(IER.NE.0)goto 2
        if(OUTSTR(1:8).eq.'*Summary')then
          write(outs,'(a,i1,a)') 'pass ',ipass,' found summary'
          call edisp(iuout,outs)
 143      CALL STRIPC(ifu,OUTSTR,0,ND,1,'*report',IER)
          IF(IER.NE.0)goto 1
          if(OUTSTR(1:7).eq.'*report')then
            K=7
            CALL EGETWI(OUTSTR,K,id1,1,98,'W','iget',IIER)
            if(id1.eq.98)then

C We have the performance aggregate
              CALL EGETW(OUTSTR,K,WORD1,'W','third',IFLAG)
              CALL EGETW(OUTSTR,K,WORD2,'W','metric clarification',
     &          IFLAG)
              if(word2(1:11).eq.'performance')then
                atreports=.true.
                im2=.true.
              elseif(word2(1:20).eq.'building_performance')then
                atreports=.true.
                im2=.false.
              else
                atreports=.false.
                goto 143
              endif
              if(atreports)then

C Found the correct report, skip title, format and fields lines.
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*title',IER)
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*format',IER)
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*fields',IER)
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*data',IER)
                k=5
                if(im2)then
                  CALL EGETWR(OUTSTR,K,anu_ht_m2(ipass),0.,0.,'-',
     &              'heat dmd',IER)
                  anu_ht_thrm_m2(ipass)=anu_ht_m2(ipass)*0.0341296
                  CALL EGETWR(OUTSTR,K,anu_cl_m2(ipass),0.,0.,'-',
     &              'cool dmd',IER)
                else
                  CALL EGETWR(OUTSTR,K,anu_ht_bld(ipass),0.,0.,'-',
     &              'heat dmd',IER)
                  anu_ht_thrm_bld(ipass)=anu_ht_bld(ipass)*0.0341296
                  CALL EGETWR(OUTSTR,K,anu_cl_bld(ipass),0.,0.,'-',
     &              'cool dmd',IER)
                endif

                goto 143
              endif
            elseif(id1.eq.74)then

C We have capacity aggregate.
              CALL EGETW(OUTSTR,K,WORD1,'W','third',IFLAG)
              CALL EGETW(OUTSTR,K,WORD2,'W','metric clarification',
     &          IFLAG)
              if(word2(1:8).eq.'capacity')then
                atreports=.true.
                im2=.true.
              elseif(word2(1:17).eq.'building_capacity')then
                atreports=.true.
                im2=.false.
              else
                atreports=.false.
                goto 143
              endif
              if(atreports)then

C Found the correct report, skip title, format and fields lines.
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*title',IER)
                k=0
                CALL EGETW(OUTSTR,K,WORD1,'W','first',IFLAG)
                CALL EGETP(OUTSTR,K,WORD2,'W','title',IFLAG)
                CALL EGETW(OUTSTR,K,WORD3,'W','unit',IFLAG)
                if(word3(1:5).eq.'W/m^2')then
                  im2=.true.
                elseif(word3(1:2).eq.'kW')then
                  im2=.false.
                endif
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*format',IER)
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*fields',IER)
                CALL STRIPC(ifu,OUTSTR,0,ND,1,'*data',IER)
                k=5
                if(im2)then
                  CALL EGETWR(OUTSTR,K,anu_ht_cap_m2(ipass),0.,0.,'-',
     &              'heat cap',IER)
                  CALL EGETWR(OUTSTR,K,anu_cl_cap_m2(ipass),0.,0.,'-',
     &              'cool cap',IER)

C Still need to find building capacity report so look further.
                  goto 143
                else
                  CALL EGETWR(OUTSTR,K,anu_ht_cap_bld(ipass),0.,0.,
     &              '-','heat cap',IER)
                  CALL EGETWR(OUTSTR,K,anu_cl_cap_bld(ipass),0.,0.,
     &              '-','cool cap',IER)

C We now have both demand and capacity, increment ipass.
                  ipass=ipass+1
                  goto 42
                endif
              endif
            else

C Not one we are intrested in at the moment.
              goto 143
            endif
          else
            goto 143
          endif
        else
          goto 142
        endif

      elseif(irs.eq.4)then
        return
      endif 

C error state.
  1   call edisp(iuout,' ')
      call edisp(ieout,'End of file when looking for report!')
      goto 39
  2   call edisp(iuout,' ')
      call edisp(ieout,'End of file when looking for summary!')
      goto 39
   
      end
        
C ******************** checkmodel ********************
C Check model files prior to commissioning a simulation. Returns
C logical variables for possible use by calling routines.
C
C mlcok    - detect unattributed surface constructions
C bndryok  - detect unattributed surface connections
C bndrysxc - detect surface connection attribute different from cnn list
C confok   - detect missing construction files
C geofok   - detect missing geometry files
C oprfok   - detect missing/old/unsorted operations files 
C prob     - detect contiguity cross-references
C tmcok    - detect matching transparent partitions
C shdok    - detect if existing shading files are readable if
C            S/I calculation method is file based

      subroutine checkmodel(mlcok,bndryok,bndrysxc,confok,geofok,
     &                      oprfok,prob,tmcok,shdok)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "CFC_common.h"
#include "help.h"

      common/OUTIN/IUOUT,IUIN,IEOUT
      integer childterminal  ! picks up mmod from starting of prj
      common/childt/childterminal
      common/FILEP/IFIL
      common/C1/NCOMP,NCON
      common/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      common/C24/IZSTOCN(MCOM,MS)
      common/shad0/ISIcalc,icalcD,icalcM
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      common/spflres/sblres(MSPS),sflres(MSPS),splres(MSPS),
     &  smstres(MSPS),selres(MSPS),scfdres(MSPS),sipvres
      character sblres*72,sflres*72,splres*72,smstres*72,
     &  selres*72,scfdres*72,sipvres*72
      common/PRECTC/ITMCFL(MCOM,MS),TMCT(MCOM,MTMC,5),
     &       TMCA(MCOM,MTMC,ME,5),TMCREF(MCOM,MTMC),TVTR(MCOM,MTMC)

      character CXSTR*78
      character shdafile*96
      character*72 LS
      character ZSDES*28,ZSDESC*20,ZSDESS*16
      character ZN*12,longtfile*144,longtfiledos*144
      character sbound_ty*12,sbound_c2*6,sbound_e2*6
      character DOIT*248,outs*248
      character TempString*96   ! For creating tmp folder.
      character fs*1            ! separator

      logical XST,XSTA,asked,problem
      logical mlcok,bndryok,bndrysxc,confok,geofok,oprfok,prob,dup
      logical tmcok,shdok
      logical concat,unixok,lexist,ok
      logical changed

      integer lnblnk        ! function definition
      integer icple,iscple  ! coupled zone and surface for tmc check.
      integer itmc1,itmc2   ! non-zero if surface a tmc
      integer icz,ics       ! associated surface
      dimension isadd(12),ishd(12),idum(ms)

      helpinsub='prj'  ! set for subroutine

      asked=.false.; changed=.false.

      IUO=IFIL+1
      if(nsset.gt.0)isset=1

C Check if Unix-based or DOS based.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Ensure model has tmp & msc folders.
      WRITE(TempString,'(4a)')'..',fs,'tmp',fs
      INQUIRE(FILE=TempString,EXIST=lexist)
      if (.not.lexist) then
        write(doit,'(4a)') 'mkdir -p ','..',fs,'tmp'
        call usrmsg('Creating folder:',doit,'-')
        call runit(doit,'-')
        call pausems(200)
        write(tmppth,'(3a)')'..',fs,'tmp'
      endif
      WRITE(TempString,'(4a)')'..',fs,'msc',fs
      INQUIRE(FILE=TempString,EXIST=lexist)
      if (.not.lexist) then
        write(doit,'(4a)') 'mkdir -p ','..',fs,'msc'
        call usrmsg('Creating folder:',doit,'-')
        call runit(doit,'-')
        call pausems(400)
        write(mscpth,'(3a)')'..',fs,'msc'
      endif

C If the model is using simulation parameter sets check whether
C the results files are using the tmp folder.
      if(nsset.gt.0)then
        do ij=1,nsset
          if(unixok)then
            if(sblres(ij)(1:4).ne.'UNKN'.and.
     &         sblres(ij)(1:2).ne.'  ')then
              if(sblres(ij)(1:7).eq.'../tmp/')then
                continue
              elseif(sblres(ij)(1:2).eq.'./')then
                continue
              else
                write(outs,'(3a)') sblres(ij)(1:lnblnk(sblres(ij))),
     &            ' is not in ../tmp/'
                helptopic='has_unknown_file'
                call gethelptext(helpinsub,helptopic,nbhelp)
                CALL EASKOK(outs,'Correct',OK,nbhelp)
                if(OK)then
                 write(TempString,'(a)')sblres(ij)(1:lnblnk(sblres(ij)))
                 write(sblres(ij),'(2a)') '../tmp/',
     &             TempString(1:lnblnk(TempString))
                 changed=.true.
                endif
              endif
            endif
            if(sflres(ij)(1:4).ne.'UNKN'.and.
     &         sflres(ij)(1:2).ne.'  ')then
              if(sflres(ij)(1:7).eq.'../tmp/')then
                continue
              elseif(sflres(ij)(1:2).eq.'./')then
                continue
              else
                write(outs,'(3a)') sflres(ij)(1:lnblnk(sflres(ij))),
     &            ' is not in ../tmp/'
                helptopic='has_unknown_file'
                call gethelptext(helpinsub,helptopic,nbhelp)
                CALL EASKOK(outs,'Correct',OK,nbhelp)
                if(OK)then
                 write(TempString,'(a)')sflres(ij)(1:lnblnk(sflres(ij)))
                 write(sflres(ij),'(2a)') '../tmp/',
     &             TempString(1:lnblnk(TempString))
                 changed=.true.
                endif
              endif
            endif
            if(splres(ij)(1:4).ne.'UNKN'.and.
     &         splres(ij)(1:2).ne.'  ')then
              if(splres(ij)(1:7).eq.'../tmp/')then
                continue
              elseif(splres(ij)(1:2).eq.'./')then
                continue
              else
                write(outs,'(3a)') splres(ij)(1:lnblnk(splres(ij))),
     &            ' is not in ../tmp/'
                helptopic='has_unknown_file'
                call gethelptext(helpinsub,helptopic,nbhelp)
                CALL EASKOK(outs,'Correct',OK,nbhelp)
                if(OK)then
                 write(TempString,'(a)')splres(ij)(1:lnblnk(splres(ij)))
                 write(splres(ij),'(2a)') '../tmp/',
     &             TempString(1:lnblnk(TempString))
                 changed=.true.
                endif
              endif
            endif
            if(smstres(ij)(1:4).ne.'UNKN'.and.
     &         smstres(ij)(1:2).ne.'  ')then
              if(smstres(ij)(1:7).eq.'../tmp/')then
                continue
              elseif(smstres(ij)(1:2).eq.'./')then
                continue
              else
                write(outs,'(3a)') smstres(ij)(1:lnblnk(smstres(ij))),
     &            ' is not in ../tmp/'
                helptopic='has_unknown_file'
                call gethelptext(helpinsub,helptopic,nbhelp)
                CALL EASKOK(outs,'Correct',OK,nbhelp)
                if(OK)then
                 write(TempString,'(a)')
     &             smstres(ij)(1:lnblnk(smstres(ij)))
                 write(smstres(ij),'(2a)') '../tmp/',
     &             TempString(1:lnblnk(TempString))
                 changed=.true.
                endif
              endif
            endif
            if(changed)then
              CALL EMKCFG('s',IER)
            endif    
          endif
        enddo
      endif

C Initial check to see if the model is attributed and
C constructions known.
      helptopic='has_unknown_attributes'
      call gethelptext(helpinsub,helptopic,nbhelp)
      mlcok=.true.
      do 40 i=1,ncon
        icz=IC1(I); ics=IE1(I)
        if(SMLCN(icz,ics)(1:7).eq.'UNKNOWN')then
          CALL ZSID(icz,ics,ZSDES,ZSDESC,ZSDESS)
          mlcok=.false.
          if(nbhelp.lt.60)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'MLC unknown in ',ZSDES
          endif
        endif
 40   continue
      if(.NOT.mlcok)then
        call easkok(
     &    'Some surfaces not construction attributed!',
     &    'View surfaces?',asked,nbhelp)
        if(asked)then
          CALL PHELPD('lacking construction attrib',nbhelp,'-',0,0,IER)
        endif
      endif

      helptopic='has_unknown_attributes'
      call gethelptext(helpinsub,helptopic,nbhelp)
      bndryok=.true.
      do 41 i=1,ncon
        icz=IC1(I); ics=IE1(I)
        if(zboundarytype(icz,ics,1).eq.-1)then
          CALL ZSID(icz,ics,ZSDES,ZSDESC,ZSDESS)
          bndryok=.false.
          if(nbhelp.lt.60)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 
     &        'Other side boundary unknown in ',ZSDES
          endif
        endif
 41   continue
      if(.NOT.bndryok)then
        call easkok(
     &    'Some surfaces not boundary condition attributed!',
     &    'View surfaces?',asked,nbhelp)
        if(asked)then
          CALL PHELPD('questioned boundary attrib',nbhelp,'-',0,0,IER)
        endif
      endif

      helptopic='has_unknown_attributes'
      call gethelptext(helpinsub,helptopic,nbhelp)
      bndrysxc=.true.
      tmcok=.true.
      do 42 i=1,ncon
        icz=IC1(I); ics=IE1(I)
        CALL ZSID(icz,ics,ZSDES,ZSDESC,ZSDESS)
        CALL CONXINFO(1,i,CXSTR)
        call decode_zsbound(icz,ics,sbound_ty,sbound_c2,sbound_e2)
        if(ICT(i).eq.0.and.zboundarytype(icz,ics,1).ne.0)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 
     &        'Boundary looking for EXTER in ',ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection is ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.1.and.zboundarytype(icz,ics,1).ne.1)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary looking for SIML in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection is ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.2.and.zboundarytype(icz,ics,1).ne.2)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary looking for CONST in ',
     &       ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection is ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.3.and.zboundarytype(icz,ics,1).eq.2)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary unexpected CONST in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection is ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.3.and.zboundarytype(icz,ics,1).eq.1)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary unexpected SIMIL in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.3.and.zboundarytype(icz,ics,1).eq.0)then
          bndrysxc=.false.
          if(nbhelp.lt.59)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary unexpected EXTER in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
          endif
        endif
        if(ICT(i).eq.3.and.zboundarytype(icz,ics,1).eq.4)then
          bndrysxc=.false.
          if(nbhelp.lt.59)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary unexpected GROUN in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
          endif
        endif

C Do same check as in solar.F.
        if(ICT(i).eq.3)then
          ICPLE=IC2(i)
          ISCPLE=IE2(i)
          ITMC1=ITMCFL(icz,ics)
          ITMC2=ITMCFL(ICPLE,ISCPLE)
          if(ITMC1.NE.0)then
            if(ITMC2.EQ.0)then
              tmcok=.false.
              if(nbhelp.lt.58)then
                nbhelp=nbhelp+1
                write(h(nbhelp),'(2a)') 'Opaque/Transp mismatch in ',
     &            ZSDES
                nbhelp=nbhelp+1
                write(h(nbhelp),'(2a)') 'connection is ',CXSTR(1:50)
                nbhelp=nbhelp+1
                write(h(nbhelp),'(2a)') 'for surface attribute.',
     &           SMLCN(icz,ics)
              endif
            endif
          endif
        endif

        if(ICT(i).eq.4.and.zboundarytype(icz,ics,1).ne.4)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary looking for GROUN in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute. ',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.5.and.zboundarytype(icz,ics,1).ne.5)then
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary looking for ADIAB in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute.',
     &        sbound_ty
          endif
        endif
        if(ICT(i).eq.6.and.zboundarytype(icz,ics,1).ne.6)then

C HOT3000: BASESIMP.
          bndrysxc=.false.
          if(nbhelp.lt.58)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Boundary looking for BASES in ',
     &        ZSDES
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'connection ',CXSTR(1:50)
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'found surface attribute',
     &        sbound_ty
          endif
        endif
 42   continue

      if(.NOT.bndrysxc)then
        call easkok(
     &    'Some surface boundary conections may be incorrect!',
     &    'View connections?',asked,nbhelp)
        if(asked)then
          CALL PHELPD('questioned boundary attrib',nbhelp,'-',0,0,IER)
        endif
      endif

C Check contiguity.
      helptopic='has_unknown_connects'
      call gethelptext(helpinsub,helptopic,nbhelp)
      ICC=0
      prob=.false.
      do 287 IZ=1,NCOMP
        do 289 IS=1,NSUR
          ICC=ICC+1
          CALL ZSID(IZ,IS,ZSDES,ZSDESC,ZSDESS)
          if(IC1(ICC).ne.IZ)prob=.true.
          if(IE1(ICC).ne.IS)prob=.true.
          if(nbhelp.lt.60.and.prob)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(2a)') 'Zone surface <> master list ',
     &       ZSDES
          endif
  289   continue
  287 continue

C Check to see if partitions match. See if other zone/surface
C exists and what it points to.
      do 290 i=1,NCON
        prob=.false.
        CALL CONXINFO(1,i,CXSTR)
        if(ICT(i).eq.3)then
          if(IC2(i).gt.0.and.IC2(i).le.NCOMP.and.
     &      IE2(i).gt.0.and.IE2(i).le.NZSUR(IC2(i)))then
            ioc=IZSTOCN(IC2(i),IE2(i))
            if(ioc.ne.0)then
              if(ICT(ioc).ne.3)then
                prob=.true.
              elseif(IC2(ioc).ne.IC1(i))then
                prob=.true.
              elseif(IE2(ioc).ne.IE1(i))then
                prob=.true.
              endif
              if(nbhelp.lt.60.and.prob)then
                nbhelp=nbhelp+1
                write(h(nbhelp),'(2a)') 'Zone surface <> master list ',
     &            CXSTR(1:40)
              endif

C Check to see if this connection only pointed to once in the whole list.
              dup=.false.
              do 291 i2=1,NCON
                if(IC2(i2).eq.IC1(i).and.IE2(i2).eq.IE1(i))then
                  if(.NOT.dup)then
                    if(ICT(i2).eq.3)dup=.true.
                  else
                    prob=.true.  ! we have a 2nd mention
                  endif
                endif
  291         continue
              if(nbhelp.lt.60.and.prob)then
                nbhelp=nbhelp+1
                write(h(nbhelp),'(2a)') 
     &            'Duplicates surface <> master list ',CXSTR(1:36)
              endif
            endif
          else
            prob=.true.
            if(nbhelp.lt.60)then
              nbhelp=nbhelp+1
              write(h(nbhelp),'(2a)') 'Zone surface <> master list ',
     &          CXSTR(1:40)
            endif
          endif
        endif
  290 continue
      if(prob)then
        call usrmsg('Topology found to be inconsistent!',
     &  'Resolved before starting a simulation.','W')
        CALL PHELPD('boundary checks',nbhelp,'-',0,0,IER)
      endif

C Now look for unknown files.
      helptopic='has_unknown_files'
      call gethelptext(helpinsub,helptopic,nbhelp)
      geofok=.true.
      do 46 i=1,ncomp
        if(LGEOM(i)(1:7).eq.'UNKNOWN'.or.LGEOM(i)(1:2).eq.'  ')then
          geofok=.false.
          if(nbhelp.lt.60)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' geometry undefined.'
          endif
        else
          XST=.false.
          call FINDFIL(LGEOM(i),XST)
          if(.NOT.XST)then
            if(nbhelp.lt.60)then
              nbhelp=nbhelp+1
              write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' geometry not found.'
            endif
          endif
        endif
 46   continue
      if(.NOT.geofok)then
        call usrmsg('Some zones do not reference a geometry file.',
     &    'Model will not support thermal simulation.','W')
        CALL PHELPD('geometry checks',nbhelp,'-',0,0,IER)
      endif

      helptopic='has_unknown_files'
      call gethelptext(helpinsub,helptopic,nbhelp)
      oprfok=.true.
      do 43 i=1,ncomp
        if(LPROJ(i)(1:7).eq.'UNKNOWN'.or.LPROJ(i)(1:2).eq.'  ')then
          oprfok=.false.
          if(nbhelp.lt.60)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' operations undefined.'
          endif
        else
          XST=.false.
          call FINDFIL(LPROJ(i),XST)
          if(.NOT.XST)then
            if(nbhelp.lt.60)then
              nbhelp=nbhelp+1
              write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' operations not found.'
              oprfok=.false.
            endif
          else
            CALL ERPFREE(IUO,ISTAT)
            CALL EROPER(ITRC,ITRU,IUO,I,IER)

C Do cursory check to see if the file is sorted.
            problem=.false.
            call checksort(i,1,problem)
            problem=.false.
            call checksort(i,2,problem)
            problem=.false.
            call checksort(i,3,problem)
            if(problem)then
              oprfok=.false.
            endif
          endif
        endif
  43  continue
      if(.NOT.oprfok)then
        call usrmsg(
     &  'Some zones lack operation details or have outdated files.',
     &  'Model will not support thermal simulation.','W')
        CALL PHELPD('operations checks',nbhelp,'-',0,0,IER)
      endif

      helptopic='has_unknown_files'
      call gethelptext(helpinsub,helptopic,nbhelp)
      confok=.true.
      do 45 i=1,ncomp
        if(LTHRM(i)(1:7).eq.'UNKNOWN'.or.LTHRM(i)(1:2).eq.'  ')then
          confok=.false.
          if(nbhelp.lt.60)then
            nbhelp=nbhelp+1
            write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' constructions undefined.'
          endif
        else
          XST=.false.
          call FINDFIL(LTHRM(i),XST)
          if(.NOT.XST)then
            confok=.false.
            if(nbhelp.lt.60)then
              nbhelp=nbhelp+1
              write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' constructions not found.'
            endif
          else

C Zone construction file exists so attempt to scan it.
            CALL ECONST(LTHRM(I),IFIL+1,I,0,IUOUT,IER)
            if(ier.ne.0)then
              confok=.false.
              if(nbhelp.lt.60)then
                nbhelp=nbhelp+1
                write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &          ' constructions file did not read cleanly.'
              endif
            endif
            if(ITW(I).eq.1)then
              CALL ERTWIN(0,IUOUT,IFIL+1,LTWIN(I),I,IER)
              if(ier.ne.0)then
                confok=.false.
                if(nbhelp.lt.60)then
                  nbhelp=nbhelp+1
                  write(h(nbhelp),'(3a)') 'Zone ',
     &              zname(i)(1:lnzname(i)),
     &              ' tmc file did not read cleanly.'
                endif
              endif
            endif
            if(icfc(I).eq.1)then
              CALL read_in_cfc_file(0,IUOUT,IFIL+1,lcfcin(I),I,IER)
              if(ier.ne.0)then
                confok=.false.
                if(nbhelp.lt.60)then
                  nbhelp=nbhelp+1
                  write(h(nbhelp),'(3a)') 'Zone ',
     &              zname(i)(1:lnzname(i)),
     &              ' cfc file did not read cleanly.'
                endif
              endif
            endif
          endif
        endif
 45   continue
      if(.NOT.confok)then
        call usrmsg(
     &   'Some zones do not reference a construction file.',
     &   'Model will not support thermal simulation.','W')
        CALL PHELPD('constructions checks',nbhelp,'-',0,0,IER)
      endif

C For existing S/I file case, check for existence of zone files and,
C if missing but there is an ASCII S/I file convert it; otherwise,
C invoke ish to calculate.
      if(ISIcalc.eq.1)return  ! embedded S/I calculation mode
      helptopic='has_unknown_shading'
      call gethelptext(helpinsub,helptopic,nbhelp)
      shdok=.true.
      IUO=IFIL+1
      do 52 i=1,ncomp
        if(isi(i).eq.1)then
          LS=LSHAD(I)
          if(LS(1:7).eq.'UNKNOWN'.or.LS(1:2).eq.'  ')then
            shdok=.false.
            if(nbhelp.lt.60)then
              nbhelp=nbhelp+1
              write(h(nbhelp),'(3a)') 'Zone ',zname(i)(1:lnzname(i)),
     &        ' shading expected but undefined.'
            endif
          else
            XST=.false.
            call FINDFIL(LS,XST)
            write(shdafile,'(2a)') ls(1:lnblnk(ls)),'a'
            call FINDFIL(shdafile,XSTA)

C Setup file name depending on the machine type.
            if(unixok)then
              call addpath(LCFGF,longtfile,concat)
            else

C If running on a non-unix machine see if there are spaces in the name
C and change any / to \.
              call addpath(LCFGF,longtfile,concat)
              call cmdfiledos(longtfile,longtfiledos,ier)
              longtfile=' '
              longtfile=longtfiledos
            endif
            write(ZN,'(A)') zname(i)
            doit = ' '

C If there is no binary file but there is an ASCII version then
C use method in ish to create a blank binary file and fill it
C from ASCII.
            if(.NOT.XST)then
              if(XSTA)then
C                call edisp(iuout,'Importing missing shading ...')
C                write(doit,'(6a)') 'ish -mode text -file ',
C     &            longtfile(1:lnblnk(longtfile)),' -zone ',
C     &            ZN(1:lnblnk(ZN)),' -act asci2bin ',
C     &            shdafile(1:lnblnk(shdafile))
C                call usrmsg('starting shading conversion via',doit,'-')
C                call runit(doit,'-')

C Close any binary file already open then assign a new file via logic as
C in sifle.F ~143 (applicable bit of sifile).
                ifilsi=ifil+3
                call erpfree(ifilsi,istat)
                LS=LSHAD(I)
                write(shdafile,'(2a)') ls(1:lnblnk(ls)),'a'
                maxrec=24
                if(nzsur(i).gt.24)maxrec=nzsur(i)
                call efopran(ifilsi,LS,maxrec,3,ier)
                do ij=1,maxrec
                  if(ij.gt.12)then
                    idum(ij)=0
                  else
                    idum(ij)=0
                    ishd(ij)=0
                    isadd(ij)=0
                  endif
                enddo
                irec=1
                write(ifilsi,rec=irec,iostat=istat,err=1001)
     &            (ishd(ij),ij=1,12),(isadd(ij),ij=1,12)
                irec=4
                write(ifilsi,rec=irec,iostat=istat,err=1001)
     &            (idum(ij),ij=1,nzsur(i))
                ifstat=1  ! signal new file

                write(outs,'(3a)') 
     &            'Importing missing shading data from ',
     &            shdafile(1:lnblnk(shdafile)),'.'
                call edisp(iuout,outs)
                call sifimport(i,shdafile,ier)

                write(outs,'(3a)') 'Shading for ',ZN(1:lnblnk(ZN)),
     &            ' has been imported from ASCII.'
                call edisp(iuout,outs)

                if(nbhelp.lt.60)then
                  nbhelp=nbhelp+1
                  write(h(nbhelp),'(3a)') 'Shading for ',
     &              ZN(1:lnblnk(ZN)),' has been imported from ASCII.'
                endif
              else
                call edisp(iuout,'Regenerating missing shading ...')
                write(doit,'(5a)') 'ish -mode text -file ',
     &            longtfile(1:lnblnk(longtfile)),' -zone ',
     &            ZN(1:lnblnk(ZN)),' -act update_silent '
C                 call usrmsg('starting shading calcs via',doit,'-')
                call runit(doit,'-')
                write(outs,'(3a)') 'Shading for ',ZN(1:lnblnk(ZN)),
     &            ' has been calculated.'
                call edisp(iuout,outs)
                if(nbhelp.lt.60)then
                  nbhelp=nbhelp+1
                  write(ZN,'(A)') zname(i)
                  write(h(nbhelp),'(3a)') 'Shading for ',
     &              ZN(1:lnblnk(ZN)),' has been recalculated.'
                endif
              endif
            else

C Attempt to read the shading file as done in esrubld/util.F subroutine
C mzshin.
              maxrec=24
              if(nzsur(i).gt.24) maxrec=nzsur(i)
              CALL ERPFREE(IFIL+1,ISTAT)
              call EFOPRAN(IFIL+1,LS,maxrec,1,IER)
              IF(ier.ne.0)goto 1000

C Check file has been written to. If a problem then try again
C at maxrec=24 for older files. Remember maxrec for use in solar.F.
              IREC=2
              READ(IFIL+1,REC=IREC,IOSTAT=ISTAT,ERR=1001)INEXT,NS
              if(INEXT.LE.3.OR.NS.NE.nzsur(i))then
                CALL ERPFREE(IFIL+1,ISTAT)
                maxrec=24
                call EFOPRAN(IFIL+1,LS,maxrec,1,IER)
                IF(ier.ne.0)goto 1000
                IREC=2
                READ(IFIL+1,REC=IREC,IOSTAT=ISTAT,ERR=1001)INEXT,NS
                if(INEXT.LE.3.OR.NS.NE.nzsur(i))then
                  CALL ERPFREE(IFIL+1,ISTAT)
                  maxrec=MS
                  call EFOPRAN(IFIL+1,LS,maxrec,1,IER)
                  IF(ier.ne.0)goto 1000
                  IREC=2
                  READ(IFIL+1,REC=IREC,IOSTAT=ISTAT,ERR=1001)INEXT,NS
                  if(INEXT.LE.3.OR.NS.NE.nzsur(i))goto 1003
                endif
              endif
            endif
          endif
        endif
        goto 52

 1000   continue
 1001   IER=1
        if(nbhelp.lt.59)then
          nbhelp=nbhelp+1
          write(h(nbhelp),'(2A)') zname(I),' shading file error in ...'
          nbhelp=nbhelp+1
          write(h(nbhelp),'(A)') LS(1:lnblnk(LS))
        endif
        shdok=.false.
        goto 52

 1003   if(nbhelp.lt.59)then
          nbhelp=nbhelp+1
          write(h(nbhelp),'(a,i3,a,i3,a,i2)') 'Model nsur=',NSUR,
     &      ' db ns=',ns,' inext=',INEXT
          nbhelp=nbhelp+1
          write(h(nbhelp),'(A)') 
     &      'Mismatch between model and shading file.'
        endif
        shdok=.false.
 52   continue
      if(.NOT.shdok)then
        call usrmsg(
     &    'Some zones have missing or corrupt shading files.',
     &    'Model will not support thermal simulation.','W')
        CALL PHELPD('shading checks',nbhelp,'-',0,0,IER)
      endif
      return
      end

C ********** imgdisp
C imgdisp displays images associated with start-up or at specific points
C and the image browser has not been invoked do this now. In the case
C of the GTK version use an in-built GTK function rather than an
C external tool.
      subroutine imgdisp(iforce,focus,ier)
#include "building.h"
#include "model.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT
      common/SPAD/MMOD,LIMIT,LIMTTY
 
C A set of possible image formats which can be accepted within
C a model configuration file. These definitions are held in the
C .esprc file. To add additional image types and/or 3rd
C party display applications edit the ESP-r Install script which
C creates the .esprc file.
C   imgtyp is the number of different image formats supported
C   fmttag (4 char) is a tag for each image formt (e.g. GIF, XBMP)
C   fmtexe (20 char) is the application name used to display
C          images of type fmttag.
      common/showimg/imgtyp,fmttag(5),fmtexe(5)

C Images in the model.
C  imgfmt (4 char) gives the format of each image associated with
C         the model, it must match one of the known fmttag.
C  imgfoc (4 char) associates an image with a specific topic:
C         'FZON' is related to zone composition
C         'FNET' is related to network composition
C         'FCTL' is related to control composition
C         'FDFS' is related to CFD domains
C         'FPLN' is related to plant network
C         'FPER' is related to predicted performance
C         '****' is a general image displayed at startup
C  limgfil (72 char) name of the image file << ?? longer string >>
      character imgfmt*4  ! GIF XBMP TIF JPG PNG
      character imgfoc*4  ! FZON FNET FCTL FDFS FPLN
      character limgfil*72  ! file name (extend to 144 char)
      character imgdoc*248  ! text associated with image
      common/imagf/imgfmt(MIMG),imgfoc(MIMG),limgfil(MIMG),imgdoc(MIMG)

      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton

      character ilist*200,dolist*254
      character fmttag*4,fmtexe*20,focus*4
      character longtfile*144,longtfiledos*144
      character topic*248,head*136,act*1
      integer iglib  ! if one then X11 if 2 then GTK if 3 text only.
      integer idl  ! length of image documentation
      character hold32*32
      logical found_image ! to test application existance

      logical concat,show,unixok

      helpinsub='prj'  ! set for subroutine

C Check if Unix-based or DOS based.
      call isunix(unixok)

C Loop through the images and display those which match the 'focus'
C and can be displayed with a known utility. Iforce, if set to 1,
C forces display.
      if(noimg.eq.0)return
      if(imgtyp.eq.0)then
        call edisp(iuout,'* No image display application available.')
        call edisp(iuout,'You can define one via your .esprc file.')
        return
      endif

      iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
      if(iglib.eq.1)then

C If X11 version then request an external agent to display the image.
        if((iton.eq.0.or.iforce.eq.1))then
          do 498 imgv=1,imgtyp
            ilist=' '
            ix=1
            do 49 img=1,noimg
              if(imgfmt(img)(1:3).eq.fmttag(imgv)(1:3))then

C If focus is `****` then show images marked with `****` , otherwise
C attempt to match the focus with the image. 
                show=.false.
                if(imgfoc(img)(1:4).eq.focus(1:4))show=.true.
                if(show)then
                  longtfile=' '
                  if(unixok)then
                    call addpath(limgfil(img),longtfile,concat)
                  else

C If running on a non-unix machine see if there are spaces in the name
C and change any / to \.  If X11 then an external application is used
C an double quoting is useful. If GTK then internal function used.
                    call addpath(limgfil(img),longtfile,concat)
                    if(iglib.eq.1)then
                      call cmdfiledos(longtfile,longtfiledos,ier)
                    elseif(iglib.eq.2)then
                      call imgfiledos(longtfile,longtfiledos,ier)
                    endif
                    longtfile=' '
                    longtfile=longtfiledos
                  endif
                  ixl=lnblnk(longtfile)
                  ixe=ix+ixl
                  if(ixe.le.200)then
                    WRITE(ilist(ix:ixe),'(a,2x)')longtfile(1:ixl)
                  endif
                  ix=ixe+1
                endif
              endif
 49         continue
            if(ix.gt.1)then
              dolist=' '
              if(fmtexe(imgv)(1:2).eq.'  ')then
                call usrmsg(
     &    'The image display tool has not been defined. You can',
     &    'do this via your .esprc file.','W')
              else

C Check if the image tool is available.
                if(unixok)then
                 found_image=.false. 
                 write(hold32,'(a)')
     &             fmtexe(imgv)(1:lnblnk(fmtexe(imgv)))
                 call isinstalled(hold32,found_image)
                 if(.NOT.found_image)then
                   call usrmsg(
     &             'You have not yet installed an',
     &             'image viewer.','W')
                 endif
                else
                  found_image=.false.  ! not in Windows
                endif

C If recent version then display image documentation as well.
                if(icfgv.gt.3)then
                  call edisp(iuout,'  ')
                  call edisp248(iuout,imgdoc(imgv),100)
                endif
                if(found_image)then
                  write(dolist,'(a,2x,a,a)')
     &            fmtexe(imgv)(1:lnblnk(fmtexe(imgv))),
     &            ilist(1:lnblnk(ilist)),' & '
                  call runit(dolist,'text')
                  iton=1
                endif
              endif
            endif
 498      continue
        endif
      elseif(iglib.eq.2)then

C If GTK version then use GTK calls to display images in popup.
        if((iton.eq.0.or.iforce.eq.1))then

C Setup help text for the popup.
          helptopic='image_purpose'
          call gethelptext(helpinsub,helptopic,nbhelp)

          do 99 img=1,noimg
            if(imgfmt(img)(1:3).eq.'GIF'.or.
     &         imgfmt(img)(1:4).eq.'XBMP'.or.
     &         imgfmt(img)(1:3).eq.'TIF'.or.
     &         imgfmt(img)(1:3).eq.'PNG'.or.
     &         imgfmt(img)(1:3).eq.'JPG')then

C If focus is `****` then show images marked with `****` , otherwise
C attempt to match the focus with the image. Create a string topic
C to pass to the display routine along with the image file name.
C << tag for editing ?? >>
              show=.false.
              if(imgfoc(img)(1:4).eq.focus(1:4))show=.true.
              if(show)then
                longtfile=' '
                if(unixok)then
                  call addpath(limgfil(img),longtfile,concat)
                  ixl=lnblnk(longtfile)
                else

C If running on a non-unix machine see if there are spaces in the name
C and change any / to \.
                  call addpath(limgfil(img),longtfile,concat)
                  call cmdfiledos(longtfile,longtfiledos,ier)
                  longtfile=' '
                  longtfile=longtfiledos
                  ixl=lnblnk(longtfile)
                endif

C If version 4 or newer then display the text otherwise make
C up a general block of text for the image.
                if(icfgv.gt.3)then
                  idl=lnblnk(imgdoc(img))
                  write(topic,'(a)') imgdoc(img)(1:idl)
                else
                  if(focus(1:4).eq.'****')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' is a general topic.'
                  elseif(focus(1:4).eq.'FZON')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of zone composition.'
                  elseif(focus(1:4).eq.'FSIT')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of site.'
                  elseif(focus(1:4).eq.'FNET')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of network composition.'
                  elseif(focus(1:4).eq.'FELN')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of power networks.'
                  elseif(focus(1:4).eq.'FPLN')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of HVAC composition.'
                  elseif(focus(1:4).eq.'FCTL')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of control composition.'
                  elseif(focus(1:4).eq.'FDFS')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of the CFD domain.'
                  elseif(focus(1:4).eq.'FSPM')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of special materials.'
                  elseif(focus(1:4).eq.'F3DC')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of 3D conduction.'
                  elseif(focus(1:4).eq.'FMOI')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of moisture flow.'
                  elseif(focus(1:4).eq.'FHRO')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of high resolution occupants.'
                  elseif(focus(1:4).eq.'FSIM')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' provides details of assessment automation.'
                  elseif(focus(1:4).eq.'FIPV')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' detailing Integrated Performance Views.'
                  elseif(focus(1:4).eq.'FPER')then
                    write(topic,'(3a)') ' Image ',longtfile(1:ixl),
     &                ' relates to model performance.'
                  endif
                endif

C Provide some feedback, set the title of the popup and then call C
C function in lib/esp_draw.c
                call edisp(iuout,topic)
                write(head,'(2a)') 'Image: ',longtfile(1:ixl)
                act='-'
                if(MMOD.eq.8)then
                  call popupimage(head,topic,act,longtfile)
                  iton=1
                else
                  call edisp(iuout,'Not in graphics mode.')
                endif
              endif
            endif
  99      continue
        endif
      endif

      return
      end

C ******************** CFGVER ********************
C Supports the creation of model variants.
C It copies model files and gives them new names   
C thereby facilitating creatiion of multiple versions
C of the same project that can later be modified.

C << logic would be simpler if models had to be upgraded to
C << the latest version prior to running this facility.

      SUBROUTINE CFGVER
#include "building.h"
#include "model.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT
      common/user/browse

      dimension items2(33)
      CHARACTER ITEMS2*36,APP*6
      CHARACTER NBSTR*6,OUTS*124
      LOGICAL BROWSE,clkok
      integer MITEMS2,KNO ! max items and current menu item
      integer ISTRW

      IF(BROWSE)THEN
        CALL EDISP(IUOUT,
     &      '* Variant Manager does not operate in browse mode.')
        RETURN
      ENDIF

      helpinsub='prj'  ! set for subroutine
      helptopic='design_variants'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Ask for changes to be made
      APP='_xyz  '
      ISTRW=6
      CALL EASKSCMD(APP,' ',
     &  'Specify up to 6 characters to append to project name?',
     &  'cancel',clkok,ISTRW,'_xyz','root name modifier',IER,nbhelp)
C      call usrmsg(' ',' ','-')
      if(clkok) return         ! User selected cancel.

      K=0
      CALL EGETRM(APP,K,NBSTR,'W','cfg modifier ',IER)
      APP=NBSTR
      WRITE(OUTS,'(4A)')'* New project name will be `',
     &  CFGROOT(1:LNBLNK(CFGROOT)),APP,'`.'
      CALL EDISP(IUOUT,OUTS)

C Change string holding cfg description
      CALL EASKS(modeltitle,' ','Description for this variant?',
     &   72,'project','description modifier',IER,nbhelp)

C Set up menu for different variants
      LRCR=0
 201  KNO=-3
      ITEMS2(1) = ' ___ Site and location ___'
      ITEMS2(2) = 'a site exposure & ground reflectance'
      ITEMS2(3) = 'b weather, latitude and longitude'
      ITEMS2(4) = 'c pressure distribution'
      ITEMS2(5) = 'd ground temperature profiles'
      ITEMS2(6) = ' ___ Form and fabric ___'
      ITEMS2(7) = 'e zone form and composition'
      ITEMS2(8) = 'f shading and insolation'
      ITEMS2(9) = 'g view factors and radiant sensors'
      ITEMS2(10)= 'h - future option -'
      ITEMS2(11)= 'i materials or MLC properties db'
      ITEMS2(12)= 'j computational fluid dynamics'
      ITEMS2(13)= 'k convection regimes'
      ITEMS2(14)= 'l - future option -'
      ITEMS2(15)= 'm integrated performance view'
      ITEMS2(16)= '___ Networks ___'
      ITEMS2(17)= 'o fluid flow'
      ITEMS2(18)= 'p electrical'
      ITEMS2(19)= 'q plant'
      ITEMS2(20)= 'r contaminants'
      ITEMS2(21)= '___ Usage ___'
      ITEMS2(22)= 's zone operations'
      ITEMS2(23)= 't controls'
      ITEMS2(24)= 'u casual gains control'
      ITEMS2(25)= 'v - future option -'
      ITEMS2(26)= 'w mould and mycotoxins'
      ITEMS2(27)=' --------------------------------'
      ITEMS2(28)='? help'
      ITEMS2(29)='- exit menu'
      MITEMS2=29

C Help.
      helptopic='variant_options'
      call gethelptext(helpinsub,helptopic,nbhelp)
      CALL EMENU('Model variants',ITEMS2,MITEMS2,KNO)

      IF(KNO.EQ.2)THEN
        CALL VERMAN(APP,3,LRCR)  ! Site exposure and ground reflectance.
      ELSEIF(KNO.EQ.3)THEN
        CALL VERMAN(APP,6,LRCR)  ! Weather, latitiude and longitude difference.
      ELSEIF(KNO.EQ.4)THEN
        CALL VERMAN(APP,7,LRCR)  ! Pressure distributions.
      ELSEIF(KNO.EQ.5)THEN
        CALL VERMAN(APP,12,LRCR) ! Ground temperature profiles.
      ELSEIF(KNO.EQ.7)THEN
        CALL VERMAN(APP,2,LRCR)  ! Zone form and composition.
      ELSEIF(KNO.EQ.8)THEN
        CALL VERMAN(APP,4,LRCR)  ! Shading and insolation.
      ELSEIF(KNO.EQ.9)THEN
        CALL VERMAN(APP,5,LRCR)  ! View factors and radiant sensors.
      ELSEIF(KNO.EQ.10)THEN
        GOTO 201                 ! Future option (CALL VERMAN(APP,8,LRCR)).
      ELSEIF(KNO.EQ.11)THEN
        CALL VERMAN(APP,10,LRCR) ! Variant materials database.
      ELSEIF(KNO.EQ.12)THEN
        CALL VERMAN(APP,11,LRCR) ! CFD domain.
      ELSEIF(KNO.EQ.13)THEN
        CALL VERMAN(APP,13,LRCR) ! Convection calculations.
      ELSEIF(KNO.EQ.14)THEN
        GOTO 201                 ! Future option (CALL VERMAN(APP,14,LRCR)).
      ELSEIF(KNO.EQ.15)THEN
        CALL VERMAN(APP,17,LRCR) ! Integrated performance view.
      ELSEIF(KNO.EQ.17)THEN
        CALL VERMAN(APP,18,LRCR) ! Fluid flow network.
      ELSEIF(KNO.EQ.18)THEN
        CALL VERMAN(APP,19,LRCR) ! Electrical network.
      ELSEIF(KNO.EQ.19)THEN
        CALL VERMAN(APP,20,LRCR) ! Plant network.
      ELSEIF(KNO.EQ.20)THEN
        CALL VERMAN(APP,21,LRCR) ! Contaminants network.
      ELSEIF(KNO.EQ.22)THEN
        CALL VERMAN(APP,22,LRCR) ! Zone operations.
      ELSEIF(KNO.EQ.23)THEN
        CALL VERMAN(APP,23,LRCR) ! Zone and other controls.
      ELSEIF(KNO.EQ.24)THEN
        CALL VERMAN(APP,24,LRCR) ! Casual gains control.
      ELSEIF(KNO.EQ.25)THEN
        GOTO 201                 ! Future option (CALL VERMAN(APP,25,LRCR)).
      ELSEIF(KNO.EQ.26)THEN
        CALL VERMAN(APP,26,LRCR) ! Mould and mycotoxins.
      ELSEIF(KNO.EQ.28)THEN
        CALL PHELPD('version tasks',nbhelp,'-',0,0,IER)
        GOTO 201
      ENDIF
      IF(LRCR.EQ.2)RETURN  ! user said no more changes
      GOTO 201             ! jump back and see if more changes
      
      END

C ******************** VERMAN ********************
C Copies various model files and names them uniquely
C in order to build multiple variants of a base case model
C The root name is modified with the three character string APE appended
C to it and the configuration file is always written out.
C For the various other files in the project model, data is first read
C into common blocks and the file name is changed using APE and the same
C data is written out to the new file.
C<< It is intended that the data be modified interactively before
C<< writing out to new files in the future and this has been implemented
C<< for some of the options included in this subroutine.
C For the following values of ILM the respective file will be copied and
C renamed with APE character string appendage
C ILM = 1 means global tasks and site exposure ( not yet )
C ILM = 2 means zone form and compositiong *
C ILM = 3 means site exposure & ground reflectance
C ILM = 4 means shading and insolation and obstructions (why?)
C ILM = 5 means view factors and radiant sensors (shift to the viewfactor menu).
C ILM = 6 means weather, latitude and longitude
C ILM = 7 means pressure distribution
C ILM = 8 future option
C ILM = 9 means variant zone constructions (* remove after testing)
C ILM = 10 means variant material database
C ILM = 11 means computational fluid dynamics
C ILM = 12 means ground temperature profiles
C ILM = 13 means convection calculations
C ILM = 14 means active materials (not implemented)
C ILM = 15 means adaptive gridding and moisture (not implemented)
C ILM = 16 means integrated renewables (not implemented)
C ILM = 17 means integrated performance view
C ILM = 18 means fluid flow network
C ILM = 19 means electrical network
C ILM = 20 means plant network
C ILM = 21 means contaminants network
C ILM = 22 means zone operations
C ILM = 23 means controls
C ILM = 24 means casual gains control
C ILM = 25 means event profiles
C ILM = 26 means mould and mycotoxins (currently not implemented)

C << Check existence of all files. If non-existant create filenames 
C << and message user that such a file does not exist.

      SUBROUTINE VERMAN(APE,ILM,LRCR)
#include "building.h"
#include "model.h"
#include "site.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "ipvdata.h"
#include "cfd.h"
#include "espriou.h"
#include "help.h"
      
      integer lnblnk  ! function definition

C Path to model and command line file (if any). 
      common/OUTIN/IUOUT,IUIN,IEOUT
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/FILEP/IFIL
      character*72 lipvdatf
      common/IPVF/lipvdatf
      integer childterminal  ! picks up mmod from starting of prj
      common/childt/childterminal

      common/spflres/sblres(MSPS),sflres(MSPS),splres(MSPS),
     &  smstres(MSPS),selres(MSPS),scfdres(MSPS),sipvres
      character sblres*72,sflres*72,splres*72,smstres*72,
     &  selres*72,scfdres*72,sipvres*72

      common/cctlnm/ctldoc,lctlf
      common/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      INTEGER :: iairn,icaas

C To signal to MFWRIT that globals are available from graphic network.
C Currently set true if graphic network file exists, false otherwise.
      logical haveglobal
      COMMON/MFLOW11/haveglobal

      COMMON/cfdfil/LCFD(MCOM),IFCFD(MCOM)
      COMMON/ICFNOD/ICFD,ICP
      COMMON/CONTM/CNTMFIL,CNTMDESC,NTSTEPC
      common/ndcfd/ncfdnd,icfdnd(MNZ),NCONF
      integer ncfdnd,icfdnd,NCONF
      common/shad0/ISIcalc,icalcD,icalcM
      integer ISIcalc,icalcD,icalcM
      COMMON/CLMSET/ICYEAR,ICDNGH,CLAT,CLONG

      DIMENSION IVALS(MCOM),IVALSS(8),SALT(8)

C ivalsv keeps track of new viewfactor files which need analysis.
C ivalsg keeps track of whether a geometry file has alread been copied.
      dimension ivalsv(MCOM),ivalsg(MCOM)
      integer nbitem,items
      dimension items(MCOM)

      character CNTMFIL*72
      CHARACTER*72 NNAME,msg1,MSG2,LCFD
      character ctldoc*248,lctlf*72
      CHARACTER*72 LAPROB,lshda,lshdb
      CHARACTER OUTSTR*124
      CHARACTER APE*6,EXT*4,OUTS*124,doit*248,tmode*8
      CHARACTER SALT*31,CNTMDESC*124
      character ipvaction*3     ! to signal external ipv file
      integer irootlen,iapelin  ! string buffer lengths
      LOGICAL XST,OK,modsit,moddb,docnn,silent
      logical unixok
      logical newgeo            ! to use for testing if new/old geometry file.
      logical updatetitle ! if true the edit IPV titles.
      logical quiet             ! for zone construction file I/O
      integer IW                ! for radio button
      integer ISTRW

      helpinsub='prj'  ! set for subroutine

      M=ILM
      call isunix(unixok)

C Assume that a new connections file does not need to be created.
      docnn=.false.
      newgeo=.false.            ! assume older format geometry.

C Change name of configuration file.
      IF(LRCR.eq.0)THEN
        EXT='.cfg'
        CALL FNCNGR(LCFGF,APE,EXT,NNAME)
        write(LCFGF,'(a)') NNAME(1:lnblnk(NNAME))
      ENDIF

      IF(M.EQ.1)THEN

C This slot is not currently called.
        helptopic='global_tasks'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('global tasks not supported',nbhelp,'-',0,0,IER)
        msg1='no changes for global tasks ...'
      ELSEIF(M.EQ.2)THEN

C Zone form and composition - reads and writes each geometry file to
C ensure it is up-to-date. Replicates shading, viewfactor, heat transfer,
C casual gain controls, construction and tmc files as well as obstruction files.
        inpic=0
        call askmultizone(inpic,ivals,
     &    ' Select zones for geometric variant?',
     &    'Zone geometric variant','-',ier)
        if(inpic.gt.0)then
          DO 17 IC=1,inpic
            IUF=IFIL+2
            ICOMP=ivals(IC)

C The pattern is to scan the zone file, derive alternative name and
C then write its attributes to the alternative file name.
            EXT='.geo'
            call eclose(gversion(icomp),1.1,0.01,newgeo)
            call georead(IUF,LGEOM(ICOMP),ICOMP,1,iuout,IER)
            CALL FNCNGR(LGEOM(ICOMP),APE,EXT,NNAME)
            write(LGEOM(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            if(igupgrade.eq.2.and.(.NOT.newgeo))then
              gversion(icomp) =1.1
              newgeo = .true.
            endif
            if(newgeo)then
              call geowrite2(IUF,LGEOM(ICOMP),IComp,IUOUT,3,IER)
            else
              call emkgeo(IUF,LGEOM(ICOMP),ICOMP,3,IER)
            endif

C Remember this geometry file has been done so that a later selection
C of constructions does not re-do it.
            ivalsg(ic)=ivals(IC)

C Also process zone construction files and write to alt nameed file.
            call FINDFIL(LTHRM(ICOMP),XST)
            if(XST)then
              QUIET=.FALSE.
              CALL ECONST(LTHRM(ICOMP),IUF,ICOMP,ITRC,ITRU,IER)
              EXT='.con'
              CALL FNCNGR(LTHRM(ICOMP),APE,EXT,NNAME)
              write(LTHRM(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
              CALL EMKCON(LTHRM(ICOMP),IUF,ICOMP,QUIET,IER)
            endif
            call FINDFIL(LTWIN(ICOMP),XST)
            if(XST)then
              CALL ERTWIN(ITRC,ITRU,IFU,LTWIN(ICOMP),ICOMP,IER)
              EXT='.tmc'
              CALL FNCNGR(LTWIN(ICOMP),APE,EXT,NNAME)
              write(LTWIN(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
              CALL MKTWIN(IFU,ICOMP,QUIET,IER)
            endif

C If there is an existing shading file copy it to new name
C so that subsequent changes are applied to the new file.
C If ISIcalc has not yet been set and there is a zone shading file
C set ISIcalc =2. Also copy any existing .shda file.
            if(ISI(icomp).eq.1)then
              if(ISIcalc.eq.0) ISIcalc = 2
              EXT='.shd'
              CALL FNCNGR(LSHAD(ICOMP),APE,EXT,NNAME)
              XST=.FALSE.
              write(lshda,'(2a)') 
     &          LSHAD(ICOMP)(1:LNBLNK(LSHAD(ICOMP))),'a'
              if(unixok)then
                WRITE(doit,'(4A)')'cp ',
     &            LSHAD(ICOMP)(1:LNBLNK(LSHAD(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              else
                WRITE(doit,'(4A)')'copy /y ',
     &            LSHAD(ICOMP)(1:LNBLNK(LSHAD(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              endif
              CALL USRMSG('Copying shading file via:',doit,'-')
              CALL RUNIT(doit,'-')

C Update lshad and then use that to create the shda file to copy to.
              write(LSHAD(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))

              call FINDFIL(lshda,XST)
              if(XST)then
                write(lshdb,'(2a)') 
     &            LSHAD(ICOMP)(1:LNBLNK(LSHAD(ICOMP))),'a'
                if(unixok)then
                  WRITE(doit,'(4A)')'cp ',
     &              lshda(1:LNBLNK(lshda)),' ',
     &              lshdb(1:LNBLNK(lshdb))
                else
                  WRITE(doit,'(4A)')'copy /y ',
     &              lshda(1:LNBLNK(lshda)),' ',
     &              lshdb(1:LNBLNK(lshdb))
                endif
                CALL USRMSG('Copying ascii shading file via:',doit,'-')
                CALL RUNIT(doit,'-')
              endif
            endif

C If there is an existing viewfactor file copy it to new name
C so that subsequent changes are applied to the new file.
            if(IVF(icomp).eq.1)then
              EXT='.vwf'
              CALL FNCNGR(LVIEW(ICOMP),APE,EXT,NNAME)
              if(unixok)then
                WRITE(doit,'(4A)')'cp ',
     &            LVIEW(ICOMP)(1:LNBLNK(LVIEW(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              else
                WRITE(doit,'(4A)')'copy /y ',
     &            LVIEW(ICOMP)(1:LNBLNK(LVIEW(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              endif
C              CALL USRMSG('Copying view factor file via:',doit,'-')
              CALL RUNIT(doit,'-')
              write(LVIEW(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))

C ? after copy it is probably not necessary to re-run the viewfactor analysis.
C              ivalsv(ic)=ivals(IC)
            endif

C If there is a heat transfer regime copy the exiting file
C so that subsequent changes are applied to the new file.
            if(IHC(icomp).eq.1)then
              EXT='.htc'
              CALL FNCNGR(LHCCO(ICOMP),APE,EXT,NNAME)
              if(unixok)then
                WRITE(doit,'(4A)')'cp ',
     &            LHCCO(ICOMP)(1:LNBLNK(LHCCO(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              else
                WRITE(doit,'(4A)')'copy /y ',
     &            LHCCO(ICOMP)(1:LNBLNK(LHCCO(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              endif
C              CALL USRMSG('Copying hc regime file via:',doit,'-')
              CALL RUNIT(doit,'-')
              write(LHCCO(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            endif

C If there is a casual gain control file copy the exiting file
C so that subsequent changes are applied to the new file.
            if(ICGC(icomp).eq.1)then
              EXT='.cgc'
              CALL FNCNGR(LHCCO(ICOMP),APE,EXT,NNAME)
              if(unixok)then
                WRITE(doit,'(4A)')'cp ',
     &            LCGCIN(ICOMP)(1:LNBLNK(LCGCIN(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              else
                WRITE(doit,'(4A)')'copy /y ',
     &            LCGCIN(ICOMP)(1:LNBLNK(LCGCIN(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              endif
C              CALL USRMSG('Copying casual gain ctl file via:',
C     &                    doit,'-')
              CALL RUNIT(doit,'-')
              write(LCGCIN(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            endif

C If there is an obstruction file copy the exiting file
C so that subsequent changes are applied to the new file.
            if(IOBS(icomp).eq.1)then
              EXT='.obs'
              CALL FNCNGR(ZOBS(ICOMP),APE,EXT,NNAME)
              if(unixok)then
                WRITE(doit,'(4A)')'cp ',
     &            ZOBS(ICOMP)(1:LNBLNK(ZOBS(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              else
                WRITE(doit,'(4A)')'copy /y ',
     &            ZOBS(ICOMP)(1:LNBLNK(ZOBS(ICOMP))),' ',
     &            NNAME(1:LNBLNK(NNAME))
              endif
C              CALL USRMSG('Copying obstruction file via:',doit,'-')
              CALL RUNIT(doit,'-')
              write(ZOBS(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            elseif(IOBS(icomp).eq.2)then
              continue
            endif
 17       CONTINUE
          docnn=.true.
          msg1='updating model for geometry changes ...'
          call edisp(iuout,
     &      '* New geometry files available for subsequent changes.')
        endif

C Find existing shading and viewfactor files. 
        ishdq=-1
        ivfwq=-1
        do 43 iz=1,ncomp
          if(ISIcalc.eq.1)then
            continue    ! ignore if embeded calculations used
          else 
            if(ISI(iz).eq.1)ishdq=1
          endif
          if(IVF(iz).eq.1)ivfwq=1
  43    continue
        if(ishdq.eq.1)then
          call usrmsg(
     &      'Shading files found that will be dependent on',
     &      'future geometry changes: files copied.','W')
          ishd=1
        endif
        if(ivfwq.eq.1)then
          call usrmsg(
     &      'View factor files found that will be dependent on',
     &      'future geometry changes: files copied.','W')
        endif
      ELSEIF(M.EQ.3)THEN

C Site exposure and ground reflectance creates variant cfg file with
C these attributes altered - other model features remain the same.
C Selection strings for site exposure.
        SALT(1)='typical city centre            '
        SALT(2)='typical urban site             '
        SALT(3)='typical rural site             '
        SALT(4)='city: = sky, grnd, bldgs       '
        SALT(5)='city: below surroundings       '
        SALT(6)='isolated rural site            '
        SALT(7)='totally enclosed (no sky)      '
        WRITE(SALT(8),53)skyview,groundview,buildingview
  53    FORMAT('sky=',F4.2,' grnd=',F4.2,' bld=',F4.2)
        helptopic='site_exposure'
        call gethelptext(helpinsub,helptopic,nbhelp)
 563    IX=1
        CALL EPICKS(IX,IVALSS,' ',' Site exposure:',
     &         31,8,SALT,'site exposure',IER,nbhelp)
        IF(IX.EQ.0)GOTO 563
        siteexposureindex=IVALSS(1)
        IF(siteexposureindex.EQ.8)THEN
  290     CALL EASKR(skyview,' ','Sky view factor?',
     &         0.0,'W',0.99,'W',0.33,'sky view factor',IER,1)
          CALL EASKR(groundview,' ','Ground view factor?',
     &         0.0,'W',0.99,'W',0.33,'ground view factor',IER,1)
          CALL EASKR(buildingview,' ','Surroundings view factor?',
     &         0.0,'W',0.99,'W',0.33,'surroundings view factor',IER,1)
          IF(ABS(skyview+groundview+buildingview-1.).GT..001)THEN
            CALL USRMSG('Error: view factor summation > 1.0',
     &                  ' ','W')
            GOTO 290
          ENDIF
        ENDIF
        CALL EASKR(groundrefl,' ','Ground reflectivity?',
     &       0.0,'W',0.99,'W',0.2,'ground reflectivity',IER,1)
        MODSIT=.true.
        msg1='updating model for site exposure changes ...'
        docnn=.true.

      ELSEIF(M.EQ.4)THEN

C If the zone form & composition option above already invoked then
C advise the user to simply go to the model context menu and adjust
c the site data and allow the variant zone files to be updated.
        helptopic='shading_tasks'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('shading updates elsewhere',nbhelp,'-',0,0,IER)
        msg1='no shading changes ...'

      ELSEIF(M.EQ.5)THEN

C Add calculated view factors to a model. Would be
C better placed in the menu for view factors.
        inpic=0
        call askmultizone(inpic,ivals,
     &    ' Select zones for viewfactor variant?',
     &    'Zone viewfactor variant','v',ier)
        if(inpic.gt.0)then
          nbvalsv=0
          helptopic='viewfactor_options'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL EASKMBOX(' ','View factor options:',
     &      'area weighted','ray traced','cancel',
     &      ' ',' ',' ',' ',' ',IW,nbhelp)

C Updating viewfactors can require configuration file to be updated
C before calling mrt. NOTE: viewfactor block attributes will not be
C known in the associated zone geometry file so update if required. 
          if(iw.eq.1.or.iw.eq.2)then
            DO 127 IC=1,inpic
              IUF=IFIL+2
              ITRC=1
              ITRU=6
              ICOMP=ivals(IC)
              if(IVF(icomp).eq.1)then
                EXT='.vwf'
                CALL ERMRT(ITRC,ITRU,IUF,LVIEW(ICOMP),ICOMP,IER)
                CALL FNCNGR(LVIEW(ICOMP),APE,EXT,NNAME)
                write(LVIEW(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
                CALL EMKMRT(LVIEW(ICOMP),LGEOM(ICOMP),
     &            NZSUR(ICOMP),IUF,ICOMP,'v',IER)
                call eclose(gversion(icomp),1.1,0.01,newgeo)
                if(newgeo)then
                  call geowrite2(IUF,LGEOM(ICOMP),IComp,IUOUT,3,IER)
                endif
              elseif(IVF(icomp).eq.0)then
                if(zonepth(1:2).eq.'  '.or.zonepth(1:2).eq.'./')then
                  WRITE(LVIEW(icomp),'(A,A4)')
     &              zname(icomp)(1:lnzname(icomp)),'.vwf'
                else
                  WRITE(LVIEW(icomp),'(3A,A4)') 
     &              zonepth(1:lnblnk(zonepth)),'/',
     &              zname(icomp)(1:lnzname(icomp)),'.vwf'
                endif
                EXT='.vwf'
                CALL FNCNGR(LVIEW(ICOMP),APE,EXT,NNAME)
                write(LVIEW(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))

C In both cases create an initial viewfactor file. If ray tracing
C required, save the list of zones to be done after the
C configuration file has been updated.
                silent=.true.
                call EDMRT(ITRC,ITRU,IUF,ICOMP,silent,'a',IER)
                if(iw.eq.2)then
                  ivalsv(ic)=ivals(IC)
                endif
              endif
 127        CONTINUE
            if(iw.eq.2)then
              nbvalsv=inpic
            endif
            msg1='updating model for viewfactor changes ...'
            call edisp(iuout,
     &          '* View factor files being copied to allow updates')
            call edisp(iuout,'should geometry subsequent change.')
            docnn=.true.
          endif
        endif

      ELSEIF(M.EQ.6)THEN

C Climate, latitiude and longitude. First check if the model
C includes shading files. Also updates model title and IPV.
C << why does it not copy zone shading files? 
        ishd=-1
        if(ISIcalc.eq.1)then
          continue
        else
          do 42 iz=1,ncomp
            if(ISI(iz).eq.1)ishd=1
  42      continue
        endif

C Open clm module. Remind user to record the weather file location.
        call usrmsg('Please check the feedback in the clm module',
     &    'for the latitude and longitude difference values.','W')
        CALL EDDBCLM(moddb,ape,ishad)

        helptopic='context_lat_long'
        call gethelptext(helpinsub,helptopic,nbhelp)
        write(outs,'(a,2F8.1)') 'The current model location is ',
     &    sitelat,sitelongdif
        call edisp(iuout,' ')
        call edisp(iuout,outs)
        write(outs,'(a,2F8.1)') 'The weather site is ',
     &    clat,clong
        call edisp(iuout,outs)

        slat=sitelat  ! sitelat is in common C4 in site.h
        
        CALL EASKR(SLAT,' ','Site latitude?',
     &       -89.9,'W',89.9,'W',55.9,'site latitude',IER,nbhelp)
        IF(IER.EQ.0)sitelat=SLAT

        slon=sitelongdif  ! sitelongdif is in common C4 in site.h
        CALL EASKR(SLON,
     &    'Site longitude difference from local time meridian',
     &    '(East +ve, West -ve)?',-15.0,'W',15.0,'W',-4.1,
     &    'longitude difference',IER,nbhelp)
        IF(IER.EQ.0)sitelongdif=SLON


        IF(NGRDP.NE.0)THEN
          call edisp(IUOUT,
     &     '* User defined ground temperatures need to be updated.')
          CALL EDDGTP(modsit) 
        ENDIF

C If there is an IPV file also update it.
        call FINDFIL(lipvdatf,XST)
        call isunix(unixok)
        IF(XST)THEN
          call edisp(IUOUT,
     &      '* IPV file has been updated to match climate.')
          call edisp(IUOUT,'Please update the IPV titles.')
          ipvaction='ipv'
          CALL RIPVDAT(IFIL+1,LIPVDATF,ipvaction,IER)
          EXT='.ipv'
          CALL FNCNGR(LIPVDATF,APE,EXT,NNAME)
          if(unixok)then
            WRITE(doit,'(4A)')'cp ',LIPVDATF(1:LNBLNK(LIPVDATF)),' ',
     &        NNAME(1:LNBLNK(NNAME))
          else
            WRITE(doit,'(4A)')'copy /y ',
     &        LIPVDATF(1:LNBLNK(LIPVDATF)),' ',
     &        NNAME(1:LNBLNK(NNAME))
          endif
          CALL USRMSG('Copying IPV file via:',doit,'-')
          CALL RUNIT(doit,'-')
          write(LIPVDATF,'(a)') NNAME(1:lnblnk(NNAME))
          updatetitle=.true.
        else
          if(nipvassmt.eq.0)then
            updatetitle=.false.   ! nothing to do
          else
            updatetitle=.true.
          endif
        endif

C Update the titles.
        if(updatetitle)then
          CALL EASKS(ipvtitl,' ','Project title for this variant?',
     &    40,'project','description modifier',IER,0)
          ISTRW=72
          CALL EASKS248(ipvsynop,'Synopsis',' ',ISTRW,
     &    'Project synopsis for this variant','synopsis',IER,5)
          CALL IPVDAT('-')
        endif
        docnn=.true.
        msg1='updating model for climate changes ...'

      ELSEIF(M.EQ.7)THEN

C Pressure distribution. Offers to update the database and
C create a model cfg file which points to alternative db.
        helptopic='pressure_db_changes'
        call gethelptext(helpinsub,helptopic,nbhelp)
        msg1='updating model for pressure db changes ...'
        CALL EASKMBOX(' ','Change to be made to:',
     &  'building parameters','database','cancel',
     &  ' ',' ',' ',' ',' ',IW,nbhelp)
        IF(IW.EQ.3)THEN
          RETURN
        ELSEIF(IW.EQ.2)THEN
          EXT='.db1'
          CALL FNCNGR(LAPRES,APE,EXT,NNAME)
          CALL fdroot(NNAME,msg1,MSG2)
          WRITE(LAPRES,'(3a)')DBSPTH(1:LNBLNK(DBSPTH)),'/',MSG2
          CALL EASKOK('  ','Edit database?',OK,5)
          IF(OK)THEN
            CALL EDPCDB(IER)          
          ELSE
            CALL EMKAPCDB(LAPRES,IER)
          ENDIF
        ELSEIF(IW.EQ.1)THEN
          CALL CPCDAT
        ENDIF
        docnn=.true.
        msg1='updating model for pressure db changes ...'
      ELSEIF(M.EQ.8)THEN

C Slot for future option.
        msg1='no action taken...'
      ELSEIF(M.EQ.9)THEN

C Variant zone constructions (this includes geometry, construction
C and tmc file variants for each zone selected. Uses logic in sensa.F
C for safety better to just copy the zone construction files in
C the geometry logic above.
        helptopic='construction_tasks'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('construction updates elsewhere',nbhelp,'-',0,0,IER)
        msg1='choose zone form & composition instead ...'

      ELSEIF(M.EQ.10)THEN

C Construction and materials databases file variant.
        call VER_MLC_MAT(APE)

      ELSEIF(M.EQ.11)THEN

C CFD domain
        inpic=0
        call askmultizone(inpic,ivals,
     &    'Select zones for CFD variant?',
     &    'Zone CFD variant','d',ier)
        if(inpic.gt.0)then
          EXT='.dfd'
          DO 178 IC=1,inpic
            ICOMP=ivals(IC)
            do 234 iconf=1,nconf
              if ( icfdnd(iconf).eq.ICOMP )then
                ICFD = iconf
              endif
  234       continue
            ITRC=2
            ITU=6
            CALL DFDREAD(ICOMP,itrc,itu,IER)
            CALL FNCNGR(LCFD(ICOMP),APE,EXT,NNAME)
            write(LCFD(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            IUF=12
            CALL DFDSV(IUF,ICOMP,IER)
 178      CONTINUE
          CALL EASKOK(' ','Edit CFD data?',OK,5)
          IF(OK)CALL CFDCOMP(ICOMP,iuf,IER)
          msg1='updating model for CFD domain changes ...'
          call edisp(iuout,' ')
        endif
      ELSEIF(M.EQ.12)THEN

C Ground temperature profiles. Does changing this imply other
C files need to change?
        CALL EDDGTP(modsit) 
        msg1='updating model for ground temperature changes ...'
        docnn=.true.
        call edisp(iuout,
     &    '* Configuration file holds revised greound temperatures.')
      ELSEIF(M.EQ.13)THEN

C Variant convection calculations. Start by getting a list of
C zones (which already have htc files).
        inpic=0
        call askmultizone(inpic,ivals,
     &    'Select zones for hc regime variant?',
     &    'Zone hc regime variant','h',ier)
        if(inpic.gt.0)then
          EXT='.htc'
          DO 188 IC=1,inpic
            ICOMP=ivals(IC)
            ITRU=6
            IUF=12
            CALL ehtcff(LHCCO(ICOMP),IUF,IER)
            CALL FNCNGR(LHCCO(ICOMP),APE,EXT,NNAME)
            write(LHCCO(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
            CALL EMKHTC(LHCCO(ICOMP),ICOMP,IUF,ITRU,IER)
 188      CONTINUE
          msg1='updating model for convective regime changes ...'
          docnn=.true.
          call edisp(iuout,
     &      '* Subsequent changes will be applied to the new files.')
        endif
      ELSEIF(M.EQ.14)THEN

C active materials and advanced optics
        helptopic='active_mat_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('active mateial not supported',nbhelp,'-',0,0,IER)
        msg1='updating model for active materials changes ...'
      ELSEIF(M.EQ.15)THEN

C adaptive gridding and moisture
        helptopic='adapt_grid_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('adaptive gridding not supported',nbhelp,'-',0,0,
     &    IER)
        msg1='updating model for gridding changes ...'
      ELSEIF(M.EQ.16)THEN

C building integrated renewables
        helptopic='renewables_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('renewables not supported',nbhelp,'-',0,0,IER)
        msg1='updating model for integrated renewables changes ...'
      ELSEIF(M.EQ.17)THEN

C variant integrated performance view
        if(icfgv.lt.4)then
          EXT='.ipv'
          call FINDFIL(lipvdatf,XST)
          call isunix(unixok)
          IF(XST)THEN
            ipvaction='ipv'
            CALL RIPVDAT(IFIL+1,LIPVDATF,ipvaction,IER)
            CALL FNCNGR(LIPVDATF,APE,EXT,NNAME)
            if(unixok)then
              WRITE(doit,'(4A)')'cp ',LIPVDATF(1:LNBLNK(LIPVDATF)),' ',
     &          NNAME(1:LNBLNK(NNAME))
            else
              WRITE(doit,'(4A)')'copy /y ',
     &          LIPVDATF(1:LNBLNK(LIPVDATF)),' ',
     &          NNAME(1:LNBLNK(NNAME))
            endif
C          CALL USRMSG('Copying file via:',doit,'-')
            CALL RUNIT(doit,'-')
            write(LIPVDATF,'(a)') NNAME(1:lnblnk(NNAME))
            updatetitle=.true.
          else
            updatetitle=.false.   ! nothing to do
          endif
        else
          if(nipvassmt.eq.0)then
            updatetitle=.false.   ! nothing to do
          else
            updatetitle=.true.
          endif
        endif

C Update the titles.
        if(updatetitle)then
          CALL EASKS(ipvtitl,' ','Project title for this variant?',
     &     40,'project','description modifier',IER,0)
          ISTRW=72
          CALL EASKS248(ipvsynop,'Synopsis',' ',ISTRW,
     &    'Project synopsis for this variant','synopsis',IER,5)
          CALL IPVDAT('-')
          docnn=.true.
        ELSE
          if(icfgv.lt.4)then
            CALL EDISP(IUOUT,
     &        '* IPV file does not exist, creating one!')        
            WRITE(LIPVDATF,'(2A)')cfgroot(1:lnblnk(cfgroot)),'.ipv'
            CALL FNCNGR(LIPVDATF,APE,EXT,NNAME)
            write(LIPVDATF,'(a)') NNAME(1:lnblnk(NNAME))
          endif
          CALL IPVDAT('I')
          CALL EASKS(ipvtitl,' ','Project title for this variant?',
     &     40,'project','description modifier',IER,0)
          ISTRW=72
          CALL EASKS248(ipvsynop,'Synopsis',' ',ISTRW,
     &    'Project synopsis for this variant','synopsis',IER,5)
          CALL IPVDAT('-') 
          docnn=.true.
        ENDIF
        if(icfgv.lt.4)then

C Older format writing to separate IPV file (depreciate).
          ipvaction='ipv'
          CALL MKIPVDAT(IFIL+1,LIPVDATF,ipvaction)
          msg1='updating model for IPV changes ...'
          call edisp(iuout,
     &      '* IPV file being copied and edited text included.')
          docnn=.true.
        endif
        
      ELSEIF(M.EQ.18)THEN
         
C Variant fluid flow network. Use OS to copy the file. Update
C LAPROB name and then read the file.
        IF(IAIRN.GE.1)THEN
          EXT='.afn'
          CALL FNCNGR(LAPROB,APE,EXT,NNAME)
          call isunix(unixok)

C Because subroutine to write the file is called with file number and
C not by name invoke system calls to make a copy but this file is read
C into commons and then written out again
          if(unixok)then
            write(doit,'(4A)')'cp -f ',LAPROB(1:lnblnk(LAPROB)),
     &        ' ',NNAME
          else
            write(doit,'(4A)')'copy /y ',LAPROB(1:lnblnk(LAPROB)),
     &        ' ',NNAME
          endif
          write(LAPROB,'(a)') NNAME(1:lnblnk(NNAME))
          call terminalmode(childterminal,tmode)
C          CALL USRMSG('Copying flow network via:',doit,'-')
          call runit(doit,tmode)
          CALL EFOPSEQ(IUM,LAPROB,1,IER)

C Read the file header and check for first-line tag. If 4 items
C then an older file so rewind the file and call emfread.
          CALL STRIPC(IUM,OUTSTR,99,ND,0,'1st line of file',IER)
          if(ier.eq.0)then
            write(currentfile,'(a)') LAPROB(1:lnblnk(LAPROB))
            if(OUTSTR(1:18).EQ.'*Graphical_network')then

C Found a graphic network file, scan it (silently) and then convert it
C into network flow common blocks.
              IAIRN = 2
              CALL ERPFREE(IUM,ISTAT)
              call NETREAD(IUM,'S',IER)
              CALL NETTOFLW(ier)
              call usrmsg(
     &        'This file is a graphic network file rather than a',
     &        'flow network file!','W') 
              haveglobal=.TRUE.  ! a graphic network file
              CALL MFWRIT(IUM)
            elseif(OUTSTR(1:13).EQ.'*Flow_network')then

C Found 3D flow network file.
              IAIRN = 3
              CALL ERPFREE(IUM,ISTAT)
              CALL MFCDAT
              CALL EMF3DREAD(IUM,'S',IER)
              CALL ERPFREE(IUM,ISTAT)
              CALL EFOPSEQ(IUM,LAPROB,4,IER)
              call MF3DWRIT(IUM)
            else

C Found legacy text mass flow file.
              REWIND(IUM,ERR=999)
              CALL EMFREAD(IUM,IER)
              CALL ERPFREE(IUM,ISTAT)
              IAIRN = 1
              CALL MFWRIT(IUM)
            endif
          endif
        ENDIF
        msg1='updating model for air flow network changes ...'
        docnn=.true.
        call edisp(iuout,'* Mass flow file being copied.')
      ELSEIF(M.EQ.19)THEN

C Electrical network.
        helptopic='electrical_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('electrical net not supported',nbhelp,'-',0,0,IER)
        msg1='updating model for electrical network changes...'
      ELSEIF(M.EQ.20)THEN

C Plant components / plant network.
        helptopic='plant_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('plant not supported',nbhelp,'-',0,0,IER)
        msg1='updating model for plant network changes ...'
      ELSEIF(M.EQ.21)THEN

C contaminants network
C << There is some problem with this section because the ctm file is
C << written out as fort.83 in ../cfg and not as ../nets/.ctm
        EXT='.ctm'
        CALL CTREAD(iier)
        if(iier.ne.0)then
          outs='* Problem scanning contaminants file.'
          call edisp(iuout,outs)
        endif
        CALL FNCNGR(CNTMFIL,APE,EXT,NNAME)
        write(CNTMFIL,'(a)') NNAME(1:lnblnk(NNAME))
        IUNIT=72
        CALL CTWRIT(iunit)
        msg1='updating model for contaminants network changes ...'
        docnn=.true.
        call edisp(iuout,'* Contaminants network being copied.')
      ELSEIF(M.EQ.22)THEN

C Versioning of zone operations. First ask which zones that
C will have different zone operations. Use VER_OPR to
C loop through each of these, read the current operations file,
C derive a new file name from fncngr call and then call prjfmk 
C to write out the common block data to the alternative file name.
        nbitem=0
        call askmultizone(nbitem,items,
     &    'Select zones for schedules variant?',
     &    'Zone construction variant','c',ier)
        if(nbitem.gt.0)then
          call VER_OPR(nbitem,items,APE,docnn)
        endif

      ELSEIF(M.EQ.23)THEN

C A version with different control file. If there is a current
C control file << assume that common block data is current >>
C derive an alternative file name and call ctlwrt to write out the
C common block data.
        EXT='.ctl'
        IUNIT=12
        call FINDFIL(LCTLF,XST)
        IF(.NOT.XST)THEN
          CALL EDISP(IUOUT,'* Control file does not exist!')
          RETURN
        ENDIF
        CALL FNCNGR(LCTLF,APE,EXT,NNAME)
        write(LCTLF,'(a)') NNAME(1:lnblnk(NNAME))
        CALL CTLWRT(IUNIT,IER)
        msg1='Updating model for zone controls changes ...'
        docnn=.true.
        call edisp(iuout,'* Control file being copied.')
      ELSEIF(M.EQ.24)THEN

C casual gains control
        helptopic='casual_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Not supported',nbhelp,'func not supported',0,0,IER)
        msg1='Updating model for zone casual gain control changes ...'
      ELSEIF(M.EQ.25)THEN

C event profiles
        helptopic='events_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Not supported',nbhelp,'func not supported',0,0,IER)
        msg1='Updating model for event profile changes ...'
      ELSEIF(M.EQ.26)THEN

C mould and mycotoxins
        helptopic='mycotoxins_not_supported'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Not supported',1,'func not supported',0,0,IER)
        msg1='Updating model for mould and mycotoxins changes ...'
      ENDIF

C If notional model generation then return now.
      IF(LRCR.EQ.3)RETURN

C Reached this point after user has selected a topic whether or
C not any zones were selected.
      helptopic='multiple_changes'
      call gethelptext(helpinsub,helptopic,nbhelp)
      CALL EASKOK(' ','More changes?',OK,nbhelp)
      IF(OK)THEN
        LRCR=1
        RETURN
      ELSE

C Write out configuration file
C But first change names of results libraries zones, flow, plant,
C moisture, electrical cfd and IPV
        DO 123 ISPS=1,NSSET
          EXT='.res'
          CALL FNCNGR(SBLRES(ISPS),APE,EXT,NNAME)
          write(SBLRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
          EXT='.mfr'
          CALL FNCNGR(SFLRES(ISPS),APE,EXT,NNAME)
          write(SFLRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
          EXT='.plr'
          CALL FNCNGR(SPLRES(ISPS),APE,EXT,NNAME)
          write(SPLRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
          EXT='.msr'
          CALL FNCNGR(SMSTRES(ISPS),APE,EXT,NNAME)
          write(SMSTRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
          EXT='.elr'
          CALL FNCNGR(SELRES(ISPS),APE,EXT,NNAME)
          write(SELRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
          EXT='.dfr'
          CALL FNCNGR(SCFDRES(ISPS),APE,EXT,NNAME)
          write(SCFDRES(ISPS),'(a)') NNAME(1:lnblnk(NNAME))
 123    CONTINUE
        EXT='.rep'
        CALL FNCNGR(SIPVRES,APE,EXT,NNAME)
        write(SIPVRES,'(a)') NNAME(1:lnblnk(NNAME))
        LRCR=2

C Check length of cfgroot string. Figure out how to include the
C whole of ape in the root name, even if this requires removing
C some characters from the middle of the string buffer.
        irootlen=LNBLNK(CFGROOT)
        iapelin=lnblnk(ape)
        IF(irootlen.GT.(32-iapelin))THEN
          irootlen=32-iapelin
        ENDIF
        write(cfgroot,'(2a)')cfgroot(1:irootlen),ape(1:iapelin)

C If a variant connections file also required set this up.
        if(docnn)then
          EXT='.cnn'
          if(icfgv.gt.4)then
            if(usecurcfg.eq.1)then
              CALL FNCNGR(LCNN,APE,EXT,NNAME)
              write(LCNN,'(a)') NNAME(1:lnblnk(NNAME))
            endif
          endif
        endif
        call usrmsg(msg1,' ','-')
        CALL EMKCFG('-',IER)
        call usrmsg(msg1,'done.','P')
      ENDIF

C If shading needs updating do this now.
      IF(ISHAD.EQ.1)CALL EDDSHD('site')

C If calculated viewfactors need run do this now.
      if(nbvalsv.gt.0)then
        DO 128 IC=1,nbvalsv
          ICOMP=ivalsv(IC)
          silent=.true.
          call EDMRT(ITRC,ITRU,IUF,ICOMP,silent,'v',IER)
 128   continue
      endif

      RETURN

C File rewind errors.
  999 CALL USRMSG('Error rewinding flow network file: ',
     &  LAPROB,'W')
      IER=1
      return

      END

***************** redrawbuttons ************************
C Refresh the feature buttons at upper right of graphic feedback.

      subroutine redrawbuttons()

      common/SPAD/MMOD,LIMIT,LIMTTY
          
C Passed parameters to cfgtogg.
#ifdef OSI
      integer icfg_type  ! model cfg type
      integer icfgz      ! if non-zero then there are zones
      integer icfgs      ! if non-zero then there is Context
      integer icfgnet    ! if non-zero then there is Fluid flow
      integer icfgc      ! if non-zero then there is Control
      integer icfgpln    ! if non-zero then HVAC exists
      integer icfgeln    ! if non-zero then Electrical exists
      integer icfgren    ! if non-zero then Renebables
      integer icfgfab    ! if non-zero then 3D conduction
      integer icfgbeh    ! if non-zero then Behaviour
      integer icfgsim    ! if non-zero then Automation
      integer iicfg      ! there are zone related images
      integer iicfgs     ! if non-zero then Context images
      integer iicfgnet   ! there are Fluid flow images
      integer iicfgc     ! there are Control images
      integer iicfgpln   ! if non-zero then HVAC images
      integer iicfgeln   ! if non-zero then Electrical images
      integer iicfgfab   ! if non-zero then Enhanced fabric images
      integer iicfgbeh   ! if non-zero then Behaviour images
      integer iicfgsim   ! if non-zero then Automation images
#else
      integer*8 icfg_type,icfgz,icfgs,icfgnet,icfgc
      integer*8 icfgpln,icfgeln
      integer*8 icfgren,icfgfab,icfgbeh,icfgsim
      integer*8 iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln
      integer*8 iicfgeln,iicfgfab,iicfgbeh,iicfgsim
#endif

C Re-draw the configuration buttons.
      if(MMOD.EQ.8)then
        call cfgtogg(icfg_type,icfgz,icfgs,icfgnet,icfgc,
     &   icfgpln,icfgeln,icfgfab,icfgbeh,icfgsim,
     &   iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln,
     &   iicfgeln,iicfgfab,iicfgbeh,iicfgsim)
     
C Set renewables value (as it does not come out of cfgtogg)
C         icfgren=1
 
        call opencfg(icfg_type,icfgz,icfgs,icfgnet,icfgc,
     &   icfgpln,icfgeln,icfgren,icfgfab,icfgbeh,icfgsim)
      endif
      return
      end


***************** FNCNGR ************************
C FNCNGR changes the name of file ORIGNAM by appending APP
C before an extension EXT, returning NEWNAM as the new file name
      SUBROUTINE FNCNGR(ORIGNAM,APP,EXT,NEWNAM)

      CHARACTER*(*) ORIGNAM,NEWNAM,EXT
      CHARACTER APP*6,LEXT*6

      LCFIL=LNBLNK(ORIGNAM)
      LA=LNBLNK(APP)
      LX=LNBLNK(EXT)
      if(lcfil.gt.1)then
        IF(ORIGNAM(LCFIL-3:LCFIL).EQ.EXT(1:4))THEN
          IF(LCFIL.GT.(72-3))LCFIL=69
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-4),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-4:LCFIL).EQ.EXT(1:5))THEN
          IF(LCFIL.GT.(72-4))LCFIL=68
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-5),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-5:LCFIL).EQ.EXT(1:6))THEN
          IF(LCFIL.GT.(72-5))LCFIL=67
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-6),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-6:LCFIL).EQ.EXT(1:7))THEN
          IF(LCFIL.GT.(72-6))LCFIL=66
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-7),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-7:LCFIL).EQ.EXT(1:8))THEN
          IF(LCFIL.GT.(72-7))LCFIL=65
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-8),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-8:LCFIL).EQ.EXT(1:9))THEN
          IF(LCFIL.GT.(72-8))LCFIL=64
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-9),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-9:LCFIL).EQ.EXT(1:10))THEN
          IF(LCFIL.GT.(72-9))LCFIL=63
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-10),APP(1:la),EXT(1:lx)
        ELSEIF(ORIGNAM(LCFIL-10:LCFIL).EQ.EXT(1:11))THEN
          IF(LCFIL.GT.(72-10))LCFIL=62
          WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-11),APP(1:la),EXT(1:lx)
        ELSE

C For ascii files with extension .asc write name assuming a full
C extension of 6 characters (e.g. materials.db3.a has extension of
C ".db3.a"
          IF(EXT.EQ.'.asc')THEN
            IF(LCFIL.GT.(72-5))LCFIL=65
            IF(LCFIL.GT.5)THEN
              LEXT=ORIGNAM(LCFIL-5:LCFIL)
            ELSE
              LEXT='small'
            endif
            WRITE(NEWNAM,'(3A)')ORIGNAM(1:LCFIL-6),APP(1:LA),LEXT
          ELSE
            IF(LCFIL.GT.(72-3))LCFIL=69
            WRITE(NEWNAM,'(2A)')ORIGNAM(1:LCFIL-4),APP(1:la)
          ENDIF
        ENDIF
      else
        WRITE(NEWNAM,'(3A)') 'not_yet_defined',APP(1:la),EXT(1:lx)
      endif

      RETURN
      END

C ********************* VER_MLC_MAT 
C VER_MLC_MAT supports the creation of model variants MLC and
C materials databases. Passed APE (4-6 char variant string).
C It copies model files and gives them new names.   
      SUBROUTINE VER_MLC_MAT(APE)
#include "building.h"
#include "model.h"
#include "esprdbfile.h"
      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT
      character lworking*144,fs*1,EXT*11,APE*6,doit*248
      character NNAME*144
      character*72 msg1,MSG2
      logical unixok
      integer lndbp,ist,istm,LFMULEN,LFMATEN

C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Construction data file variant. Depending on location expand path to file.
      if(ipathmul.eq.0.or.ipathmul.eq.1)then
        lworking=LFMUL
      elseif(ipathmul.eq.2)then
        lndbp=lnblnk(standarddbpath)
        write(lworking,'(3a)') standarddbpath(1:lndbp),fs,
     &    LFMUL(1:lnblnk(LFMUL))
      endif

C See if the MLC database follows a known naming pattern.
      LFMULEN=LNBLNK(lworking)
      istm=LFMULEN-7
      IF(lworking(LFMULEN:LFMULEN).EQ.'1')THEN
        EXT='.db1'
      ELSEIF(lworking(LFMULEN:LFMULEN).EQ.'2')THEN
        EXT='.db2'
      ELSEIF(lworking(LFMULEN:LFMULEN).EQ.'3')THEN
        EXT='.db3'
      ELSEIF(lworking(LFMULEN:LFMULEN).EQ.'4')THEN
        EXT='.db4'
      ELSEIF(lworking(LFMULEN:LFMULEN).EQ.'5')THEN
        EXT='.db5'
      ELSEIF(lworking(LFMULEN:LFMULEN).EQ.'a')THEN
        EXT='.asc'
      ELSEIF(lworking(istm:LFMULEN).EQ.'constrdb')THEN
        EXT='.constrdb'
      else
        EXT='.dbs'
      endif

C Find last token in lworking and return in msg2.
      call isunix(unixok)
      call fdroot(lworking,msg1,MSG2)
      WRITE(NNAME,'(3a)')DBSPTH(1:LNBLNK(DBSPTH)),fs,MSG2
      CALL FNCNGR(NNAME,APE,EXT,NNAME)
      if(unixok)then
        WRITE(DOIT,'(4A)')'cp ',lworking(1:LNBLNK(lworking)),' ',
     &     NNAME(1:LNBLNK(NNAME))
      else
        WRITE(DOIT,'(4A)')'copy /y ',lworking(1:LNBLNK(lworking)),' ',
     &     NNAME(1:LNBLNK(NNAME))
      endif
      write(LFMUL,'(a)') NNAME(1:lnblnk(NNAME))  ! truncation risk
      CALL EDISP(IUOUT,' ')
      CALL EDISP(IUOUT,'Copying database via ...')
      CALL EDISP(IUOUT,DOIT)
      CALL RUNIT(DOIT,'-')
      call edisp(iuout,' Updating model for construction changes...')

C Also make automatically materials database variant
      if(ipathmat.eq.0.or.ipathmat.eq.1)then
        lworking=LFMAT
      elseif(ipathmat.eq.2)then
        lndbp=lnblnk(standarddbpath)
        write(lworking,'(3a)') standarddbpath(1:lndbp),fs,
     &    LFMAT(1:lnblnk(LFMAT))
      endif

C See if the material database follows a known naming pattern.
      LFMATEN=LNBLNK(lworking)
      ist=LFMATEN-2
      istm=LFMATEN-9
      IF(lworking(ist:LFMATEN).EQ.'1.a')THEN
        EXT='.db1.a'
      ELSEIF(lworking(ist:LFMATEN).EQ.'2.a')THEN
        EXT='.db2.a'
      ELSEIF(lworking(ist:LFMATEN).EQ.'3.a')THEN
        EXT='.db3.a'
      ELSEIF(lworking(ist:LFMATEN).EQ.'4.a')THEN
        EXT='.db4.a'
      ELSEIF(lworking(istm:LFMATEN).EQ.'materialdb')THEN
        EXT='.materialdb'
      ELSEIF(lworking(LFMATEN:LFMATEN).EQ.'a')THEN
        EXT='.asc'
      else
        EXT='.dbs'
      endif

C Find last token in lworking and return in msg2.
      call isunix(unixok)
      call fdroot(lworking,msg1,MSG2)
      WRITE(NNAME,'(3a)')DBSPTH(1:LNBLNK(DBSPTH)),fs,MSG2
      CALL FNCNGR(NNAME,APE,EXT,NNAME)  ! ?? why call this
      if(unixok)then
        WRITE(DOIT,'(4A)')'cp ',lworking(1:LNBLNK(lworking)),' ',
     &    NNAME(1:LNBLNK(NNAME))
      else
        WRITE(DOIT,'(4A)')'copy /y ',lworking(1:LNBLNK(lworking)),' ',
     &    NNAME(1:LNBLNK(NNAME))
      endif
      write(LFMAT,'(a)') NNAME(1:lnblnk(NNAME))
      CALL EDISP(IUOUT,' ')
      CALL EDISP(IUOUT,'Copying database via ...')
      CALL EDISP(IUOUT,DOIT)
      CALL RUNIT(DOIT,'-')
      call edisp(iuout,' Updating model for constructions changes ...')
      return
      end

C ********************* VER_GEO_CON_TMC 
C VER_GEO_CON_TMC supports the creation of model variants zone
C files (geo con tmc). Passed number of zones and list of zones
C to copy, array of zone geometry file that might have previously
C been sorted and APE (4-6 char variant string).
C It copies model files and gives them new names.   
      SUBROUTINE VER_GEO_CON_TMC(nbitem,items,ivalsg,APE,docnn)
#include "building.h"
#include "model.h"
#include "geometry.h"
      integer lnblnk  ! function definition
      integer nbitem,items
      dimension items(MCOM)
      dimension ivalsg(MCOM)
      character APE*6
      logical docnn

      common/OUTIN/IUOUT,IUIN,IEOUT
      character EXT*11
      character NNAME*144
      character*72 msg1
      logical unixok,xst,newgeo,QUIET,donegeo
      integer iunit,icomp,ic,itrc,itru

C Set folder separator (fs) to \ or / as required.
      itru=iuout
      ITRC=0
      call isunix(unixok)
      if(nbitem.le.0)then
        return
      endif
      DO 147 IC=1,nbitem
        IUNIT=12
        QUIET=.FALSE.
        ICOMP=items(IC)
        IF(ICOMP.EQ.0)GOTO 147
        call FINDFIL(LTHRM(ICOMP),XST)
        IF(.NOT.XST)THEN
          CALL EDISP(IUOUT,
     &      '* Construction file does not exist ...skipping.')
          goto 147
        ENDIF


C Check if geometry file has already been updated.
        donegeo=.false.
        DO 149 icg=1,nbitem
          if(icomp.eq.ivalsg(icg))donegeo=.true.
 149    continue
        if(.NOT.donegeo)then
          EXT='.geo'
          call eclose(gversion(icomp),1.1,0.01,newgeo)
          call georead(IUNIT,LGEOM(ICOMP),ICOMP,IR,ITRU,IER)
          CALL FNCNGR(LGEOM(ICOMP),APE,EXT,NNAME)
          write(LGEOM(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
          if(igupgrade.eq.2.and.(.NOT.newgeo))then
            gversion(icomp) =1.1
            newgeo = .true.
          endif
          if(newgeo)then
            call geowrite2(IUNIT,LGEOM(ICOMP),ICOMP,ITRU,3,IER)
          else
            call emkgeo(IUNIT,LGEOM(ICOMP),ICOMP,3,IER)
          endif
          WRITE(MSG1,'(2A)')
     &      '* New geometry file written out for zone ',ZNAME(ICOMP)
          CALL EDISP(IUOUT,MSG1)
        endif
        CALL ECONST(LTHRM(ICOMP),IUNIT,ICOMP,ITRC,ITRU,IER)
        EXT='.con'
        CALL FNCNGR(LTHRM(ICOMP),APE,EXT,NNAME)
        write(LTHRM(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
        CALL EMKCON(LTHRM(ICOMP),IUNIT,ICOMP,QUIET,IER)
        WRITE(MSG1,'(2A)')
     &    '* New constructions file written out for zone ',
     &    ZNAME(ICOMP)
        CALL EDISP(IUOUT,MSG1)
        call FINDFIL(LTWIN(ICOMP),XST)
        IF(.NOT.XST)GOTO 147
        IFU=13
        CALL ERTWIN(ITRC,ITRU,IFU,LTWIN(ICOMP),ICOMP,IER)
        EXT='.tmc'
        CALL FNCNGR(LTWIN(ICOMP),APE,EXT,NNAME)
        write(LTWIN(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
        CALL MKTWIN(IFU,ICOMP,QUIET,IER)
        WRITE(MSG1,'(2A)')
     &    'New  transparent constructions file written out for zone '
     &    ,ZNAME(ICOMP)
        CALL EDISP(IUOUT,MSG1)
 147  CONTINUE
      docnn=.true.
      call edisp(iuout,
     &  '* Subsequent changes will be written to the new files.')

      return
      end

C ********************* VER_OPR 
C VER_OPR supports the creation of model variants zone operation
C file. Passed number of zones and list of zones
C to copy and APE (4-6 char variant string).
C It copies model files and gives them new names.   
      SUBROUTINE VER_OPR(nbitem,items,APE,docnn)
#include "building.h"
#include "model.h"
#include "geometry.h"
      integer lnblnk  ! function definition
      integer nbitem,items
      dimension items(MCOM)
      character APE*6

      common/OUTIN/IUOUT,IUIN,IEOUT
      character EXT*11
      character NNAME*144
      character*72 msg1
      logical unixok,xst,docnn
      integer iuo,icomp,ic,itrc,itru

C Set folder separator (fs) to \ or / as required.
      itru=iuout
      ITRC=0
      call isunix(unixok)
      if(nbitem.le.0)then
        return
      endif
      EXT='.opr'
      IUO=12
      DO 148 IC=1,nbitem
        ICOMP=items(IC)
        IF(ICOMP.EQ.0)GOTO 148
        call FINDFIL(LPROJ(ICOMP),XST)
        IF(.NOT.XST)THEN
          CALL EDISP(IUOUT,'* Operations file does not exist.')
          RETURN
        ENDIF
        CALL EROPER(ITRC,ITRU,IUO,ICOMP,IER)
        CALL FNCNGR(LPROJ(ICOMP),APE,EXT,NNAME)
        write(LPROJ(ICOMP),'(a)') NNAME(1:lnblnk(NNAME))
        CALL PRJFMK(ITRC,ITRU,IUO,ICOMP,IER,ICOMP)
        WRITE(MSG1,'(2A)')'* New operations file written out for ',
     &    ZNAME(ICOMP)
        CALL EDISP(IUOUT,MSG1)
 148  CONTINUE
      docnn=.true.
      call edisp(iuout,
     &  '* Subsequent changes will be applied to the new files.')
      return
      end

C Dummy subroutine.
      SUBROUTINE GRAAPH(IDRW1,IDRW2)
      return
      end
