C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001-.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C TThis file is a collection of support facilities for 
C creating and editing the model topology ie. connection lists:
C  EDCONN    - edit/check/clear connection attributes.
C  CONFIG    - processes the vertex data and presents close matches
C              to confirm before updating .cfg and .cnn files.
C  ESACON    - import surface connection attributes.
C  anchor    - anchor point items.
C  anchlist  - manage list of anchor points.
C  group     - defines a group of zones associated with a specific
C              concept.
C  grouplist - manage list of group-of-zones.
C  easkconn  - select one or more connection from a list.
C  Serchrpl  - search and replace of composition attributes.

C ******************** EDCONN ********************
C Edit/clear/check connection attributes.
C IER=0 OK, IER=1 problem encountered.

      SUBROUTINE EDCONN(IER)
#include "epara.h"
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "espriou.h"
#include "prj3dv.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)

      integer itznb  ! test count of zones
      integer itncon ! test count of connections.
      integer itIC1,itIE1,itICT,itIC2,itIE2 ! tests of
      common/itcnn/itznb,itncon,itIC1(MCON),itIE1(MCON),itICT(MCON),
     &  itIC2(MCON),itIE2(MCON)

      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)

C ITDSP labels: all surf+obs+vis = 0, all surf = 1, ext = 2,
C    partn = 3, similar = 4, surfs+obs+ground = 5, ground only = 6
C    surf+obs = 7
C ITBND bounds toggle: static = 0, optimum = 1, zone focus = 2
C ITEPT is
C ITZNM zone name toggle: display = 0, hidden = 1
C ITSNM surface name toggle: display = 0, hidden = 1
C ITORG origin toggle: display = 0, hidden = 1
C ITSNR surf normal toggle: display = 0, hidden = 1.
C ITOBS obstruction toggle: not yet enabled.
C ITHLS highlight toggle: normal 0, constr 1, trans/opaq/cfc 2, part atrib 3
C ITGRD grid toggle: display = 0, hidden = 1
C ITVNO vertex toggle: display = 0, hidden = 1
C ITPPSW current view - perspective/plan/south/west

C Pause length during sequentail scan longpause (true=1 sec).
      common/scanpause/longpause
      
C Tolerances for surface matching.
      real ANGCC  ! angle between surfaces tol
      real CACC   ! tolerance between vertices
      real DACC   ! tolerance along line
      real COGCC  ! tolerance between surface COG
      real SNACC  ! tolerance between surface areas
      integer IACC ! number of matching corners outside dist tolerance
      common/matching/ANGCC,CACC,DACC,COGCC,SNACC,IACC

      LOGICAL OTHEROK
      logical M0SKP,M1SKP,M2SKP,M3SKP,M4SKP,M5SKP,M6SKP,M7SKP,M8SKP
      logical M1OK,M2OK,M4OK,M5OK,M6OK,M7OK
      LOGICAL prob,OK,unixok,XST
      logical longpause

      DIMENSION ITEMS1(23)
      CHARACTER CXSTR*78,outs*124,ITEMS1*34,CFGFN*72
      character CXITM*48
      character DCNN*72
      character bl*2
      DIMENSION VERT(35)
      character VERT*50,KEY*1
      integer MITEM,INO ! max items and current menu item
      integer MVERT,IVERT ! max items and current menu item

      helpinsub='edtopol'  ! set for subroutine

C Check if Unix-based or DOS based.
      call isunix(unixok)
      longpause=.true.     ! initially use longer pause

C General image option flags for use with cadjview.
      ITDSP=1; ITBND=1; ITEPT=0
      ITZNM=0; ITSNM=0; ITVNO=1
      ITORG=1; ITSNR=1; ITGRD=1
      GRDIS=0.0
      ITRC=0

C On first entry, see if the list is consistent with geometry. If
C prob is .true. then there is at least some inconsistency. The value
C of iprob is the number of inconsistencies. If more than 10
C inconsistencies then action required. There are several
C possible causes for disagreements between what is held in the
C zone geometry files and the connection information held in
C the model connections file:
C a) prj crashed while managing the files resulting in incomplete
C    files (either *.geo or *.cnn)
C b) a 3rd party agent altered the contents of the model files
C    and introduced an error
C c) a source code modification introduced an inconsistency.

C Typically, it is assumed that the geometry file is correct and
C the connections file has been corrupted. Thus the `clear` function
C relies on re-scanning the geometry files, updating the values in
C the nzsur() array and then re-setting the common C3 data.

C Because legacy zone geometry files only held portions of the connection
C information (equivalent to IC1, IE1 and ICT), user intervention is needed
C to re-establish the C3 common block. The version 1.1 geometry
C file holds sufficient information to re-establish the C3 common
C block with the help of topology checking.

C Assume that all surfaces marked as identical, constant, ground,
C adiabatic and back-to-back require no confirmation (if no
C geometric match is found). Assume all existing partitions are
C re-checked and failed searches brought to the user's attention.
      M0SKP=.FALSE.
      M1SKP=.TRUE.
      M2SKP=.TRUE.
      M3SKP=.FALSE.
      M4SKP=.TRUE.
      M5SKP=.TRUE.
      M6SKP=.TRUE.
      M7SKP=.TRUE.
      M8SKP=.TRUE.  !  back-to-back in zone assumed to be partitions
      OTHEROK=.TRUE.
      MODIFYVIEW=.FALSE.
      DCNN=' '
      bl='  '

C The inital task is to see if there are easily spotted issues with
C the connections list.
      call usrmsg(
     &  'Checking zone surfaces against master list ...',' ','-')
      call ckcurmatch(prob,iprob)
      if(prob)then
        if(IPROB.gt.10)then
          write(outs,*) IPROB,' inconsistencies found!'
          call edisp(iuout,outs)
          call usrmsg(
     &    'Topology list inconsistent!',
     &    'Clear the current topology.','W')
        else
          call usrmsg(
     &    'Topology list inconsistent! ',
     &    'Clear current and/or use the check topology option.','W')
        endif
      else
        call usrmsg(
     &    'Checking zone surfaces against master list ... done.',
     &    ' ','-')
      endif

C Refresh the global data arrays used during the checking.
      NZONES=NCOMP
      CALL ZDATA (0,IER,NZONES)

C Set for redraw if image on first entry (if refresh set to after
C each edit). Set flag for updating geometry file (for changed
C surface attribute.
    3 INO=-4
      write(ITEMS1(1),'(a,i4,a)')'Connections (',ncon,')'
      ITEMS1(2)=   '  ______________________'
      ITEMS1(3)=   'b set close vertex tolerance'
      ITEMS1(4)=   '  confirm if (already marked):'
      if(M1SKP)then
        ITEMS1(5)= 'c   marked as identical: No'
      else
        ITEMS1(5)= 'c   marked as identical: Yes'
      endif
      if(M2SKP)then
        ITEMS1(6)= 'd   marked as constant: No'
      else
        ITEMS1(6)= 'd   marked as constant: Yes'
      endif
      if(M3SKP)then
        ITEMS1(7)= 'e   marked as partition: No'
      else
        ITEMS1(7)= 'e   marked as partition: Yes'
      endif
      if(M4SKP)then
        ITEMS1(8)= 'f   marked as ground: No'
      else
        ITEMS1(8)= 'f   marked as ground: Yes'
      endif
      if(M5SKP)then
        ITEMS1(9)= 'g   marked as adiabatic: No'
      else
        ITEMS1(9)= 'g   marked as adiabatic: Yes'
      endif
      if(M6SKP)then
        ITEMS1(10)='h   marked as BASESIMP: No'
      else
        ITEMS1(10)='h   marked as BASESIMP: Yes'
      endif
      if(M7SKP)then
        ITEMS1(11)='h   marked as IDENT_CEN: No '
      else
        ITEMS1(11)='h   marked as IDENT_CEN: Yes'
      endif
      if(M0SKP)then
        ITEMS1(12)='i   if no match found: No'
      else
        ITEMS1(12)='i   if no match found: Yes'
      endif
      if(M8SKP)then
        ITEMS1(13)='j   if back-to-back found: No'
      else
        ITEMS1(13)='j   if back-to-back found: Yes'
      endif
      ITEMS1(14)=  '  _______________________'

      ITEMS1(15)=  'p edit individual connections'

C If contiguity has problems then hilight the selection.
      if(prob)then
        if(IPROB.gt.10)then
          ITEMS1(16)='q clear/restore all contiguity'
        else
          ITEMS1(16)='q clear some/all contiguity'
        endif
      else
          ITEMS1(16)='q clear some/all contiguity'
      endif
      ITEMS1(17)=    'r check via vertex contiguity'
      ITEMS1(18)=  '  _______________________'

      IF(ITRC.EQ.0)THEN
        ITEMS1(19)='s report >> silent'
      ELSEIF(ITRC.EQ.1)THEN  
        ITEMS1(19)='s report >> summary' 
      ELSEIF(ITRC.EQ.2)THEN
        ITEMS1(19)='s report >> verbose'
      ENDIF
      ITEMS1(20)=  '! list connections'
      if(longpause)then
        ITEMS1(21)='* pause during check 1 sec'
      else
        ITEMS1(21)='* pause during check 0.5 sec'
      endif
      ITEMS1(22)=  '? help'
      ITEMS1(23)=  '- exit menu'
      MITEM=23

C Help text for this menu.
      helptopic='topology_choice_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

C If user has defined problem and perhaps resized the display then
C redraw the problem image.
      if(MODIFYVIEW)then
        MODBND=.TRUE.; MODLEN=.TRUE.
        NZONES=NCOMP
        nzg=NZONES
        DO 44 I=1,nzg
          nznog(I)=I
  44    CONTINUE

C (Re)Set all surfaces to standard line width.
        izgfoc=0
        if(MMOD.eq.8)then
          CALL INLNST(1)
          CALL redraw(IER)
        endif
      endif

C Now display the menu (short heading if in text mode).
      if(mmod.eq.8)then
        CALL EMENU('  Surface Connections & Boundary',ITEMS1,MITEM,INO)
      else
        CALL EMENU('Topology',ITEMS1,MITEM,INO)
      endif
      IF(INO.EQ.MITEM)THEN
        RETURN
      ELSEIF(INO.EQ.MITEM-1)THEN

C List help.
        helptopic='topology_choice_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('connection section',nbhelp,'-',0,0,IER)
      ELSEIF(INO.EQ.MITEM-2)THEN

C Swop the pause length.
        if(longpause)then
          longpause=.false.
        else
          longpause=.true.
        endif
      ELSEIF(INO.EQ.MITEM-3)THEN

C List connections.
        WRITE(outs,'(A,I3)')' Number of connections = ',NCON
        CALL EDISP(iuout,' ')
        CALL EDISP(iuout,outs)
        CALL CONXINF(1,0,CXSTR)
        CALL EDISP(iuout,CXSTR)
        DO 21 ICON=1,NCON
          CALL CONXINF(1,ICON,CXSTR)
          CALL EDISP(iuout,CXSTR)
   21   CONTINUE
      ELSEIF(INO.EQ.3)THEN

C Set tolerances for vertex comparison. Initial values set in prj.F
C CACC is the tolerance between two vertices. Can be user adjusted.
C ANGCC angle tolerance between surface normals
C IACC is the number of corners beyond tolerance which are allowed,
C DACC is the line degree tolerance for setting of corners.
        helptopic='surface_corner_detect'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKR(CACC,' ',' Tolerance (metres) between vertices? ',
     &             0.001,'W',0.2,'W',0.001,'dist tolerance',IER,nbhelp)
        CALL EASKR(DACC,' ',' Corner tolerance (degrees)?',
     &             0.1,'W',5.0,'W',1.0,'degree tolerance',IER,nbhelp)
        CALL EASKI(IACC,' Number of corners which are allowed outside',
     &    ' of the distance tolerance ? ',
     &     0,'F',2,'W',1,'corner tolerance',IER,nbhelp)

        helptopic='surface_corner_detect'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKR(ANGCC,' Surface normal tolerance (degrees)',
     &    ' of the distance tolerance ? ',
     &     0.1,'F',20.0,'W',10.0,'normal tolerance',IER,nbhelp)

      ELSEIF(INO.EQ.5)THEN

C Flip logic for identical.
        if(M1SKP)then
          M1SKP=.false.
        else
          M1SKP=.true.
        endif
      ELSEIF(INO.EQ.6)THEN

C Flip logic for constant.
        if(M2SKP)then
          M2SKP=.false.
        else
          M2SKP=.true.
        endif
      ELSEIF(INO.EQ.7)THEN

C Flip logic for partitions.
        if(M3SKP)then
          M3SKP=.false.
        else
          call easkok(' ',
     &      'Skip confirmation of existing marked partitions?',
     &      OK,nbhelp)
          if(OK)M3SKP=.true.
        endif
      ELSEIF(INO.EQ.8)THEN

C Flip logic for ground.
        if(M4SKP)then
          M4SKP=.false.
        else
          
          M4SKP=.true.
        endif
      ELSEIF(INO.EQ.9)THEN

C Flip logic for adiabatic.
        if(M5SKP)then
          M5SKP=.false.
        else
          M5SKP=.true.
        endif
      ELSEIF(INO.EQ.10)THEN

C Flip logic for case of BASESIMP or no match found.
        if(M6SKP)then
          M6SKP=.false.
        else
          M6SKP=.true.
        endif
      ELSEIF(INO.EQ.11)THEN

C Flip logic for case of CEN 13791 partition or no match found.
        if(M7SKP)then
          M7SKP=.false.
        else
          M7SKP=.true.
        endif
      ELSEIF(INO.EQ.12)THEN

C Flip logic for case of UNKNOWN or no match found.
        if(M0SKP)then
          M0SKP=.false.
        else
          M0SKP=.true.
        endif
      ELSEIF(INO.EQ.13)THEN
      
C Flip logic for back-to-back within zone.
        if(M8SKP)then
          M8SKP=.false.
        else
          helptopic='boundary_back_to_back'
          call gethelptext(helpinsub,helptopic,nbhelp)
          call easkok(' ',
     &     'Skip confirmation of back-to-back surfaces?',
     &      OK,nbhelp)
          if(OK)M8SKP=.true.
        endif

      ELSEIF(INO.EQ.15)THEN

C Edit single connection. Setup a long list made up of short
C connection descriptions and allow the user to select. This
C then calls ?? to do the work.

C Initialise connection menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
        MHEAD=2
        MCTL=3
        ILEN=NCON
        IPACT=CREATE
        CALL EKPAGE(IPACT)

C Switch menu to fixed width font.
C Switch to fixed width font for menu. Base size on current
C IMFS or ITFS sizes and remember so can restore.
        lastmenufont=IMFS
        if(IMFS.eq.4) IMFS=0
        if(IMFS.eq.5) IMFS=1
        if(IMFS.eq.6) IMFS=2
        if(IMFS.eq.7) IMFS=3
        lastbuttonfont=IFS
        lasttextfont=ITFS
        call userfonts(IFS,ITFS,IMFS)

C Initial menu entry setup.
   92   IER=0
        IVERT=-3

C Loop through the items until the page to be displayed. M is the 
C current menu line index. Build up text strings for the menu. 
   33   M=MHEAD
        DO 10 L=1,ILEN
          IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
            M=M+1
            CALL EMKEY(L,KEY,IER)
            call CONXMENU(L,CXITM)
            VERT(M)=' '
            WRITE(VERT(M),'(A1,1x,A)')KEY,CXITM(1:47)
          ENDIF
   10   CONTINUE

C Set menu header text.
        VERT(1)=    ' conn|reference   |conn|      connection       |'
        VERT(2)=    ' no. |zone|surface|type| zone/data|surf/data   |'

C Number of actual items displayed.
        MVERT=M+MCTL

C If a long list include page facility text.      
        IF(IPFLG.EQ.0)THEN
          VERT(M+1)='  ___________________________________ '
        ELSE
          WRITE(VERT(M+1),15)IPM,MPM 
   15     FORMAT   ('0 page ------- Part: ',I2,' of ',I2,' -----')
        ENDIF
        VERT(M+2)  ='? help                                '
        VERT(M+3)  ='- exit menu                           '

C Help text for this menu.
        helptopic='boundary_choice_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)

C Now display the menu.
        CALL EMENU('Zone Boundary Conditions',VERT,MVERT,IVERT)
        IF(IVERT.LE.MHEAD)THEN

C Within the header so skip request.
          IVERT=-1
          goto 33
        ELSEIF(IVERT.EQ.MVERT)THEN
          IMFS=lastmenufont    ! reset to proportional font
          ITFS=lasttextfont
          IFS=lastbuttonfont
          call userfonts(IFS,ITFS,IMFS)
          goto 3  ! go to main menu

        ELSEIF(IVERT.EQ.(MVERT-1))THEN

C List help text for the menu.
          helptopic='boundary_choice_menu'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('connection section',nbhelp,'-',0,0,IER)
        ELSEIF(IVERT.EQ.(MVERT-2))THEN

C If there are enough items allow paging control via EKPAGE.
          IF(IPFLG.EQ.1)THEN
            IPACT=EDIT
            CALL EKPAGE(IPACT)
          ENDIF
        ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Edit item identified by KEYIND after reporting on current values.
          CALL KEYIND(MVERT,IVERT,IFOC,IO)
          CALL EDISP(iuout,' ')
          CALL EDISP(iuout,' Current connection description...')
          CALL CONXINF(1,0,CXSTR)
          write(outs,'(1X,A)') CXSTR
          CALL EDISP(iuout,outs)
          CALL CONXINF(1,IFOC,CXSTR)
          write(outs,'(1X,A)') CXSTR

C Call edaconn to get the editing done.
          call edaconn(IFOC,ier)
          MODIFYVIEW=.TRUE.

        ELSE

C Not one of the legal menu choices.
          goto 92
        ENDIF
        IVERT=-2
        goto 33

C Clear contiguity.
      ELSEIF(INO.EQ.16)THEN

C If zone and cnn are matched prior to clearing then offer a
C refresh option. 
        helptopic='boundary_clear_all'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(' ','Topology options:','clear all',
     &   'clear subset.','refresh from surface attributes',
     &   'cancel',' ',' ',' ',' ',IRT,nbhelp)
        if(IRT.eq.1)then
          call easkok(' ','Clear all contiguity data?',
     &           OK,nbhelp)
          if(.NOT.OK)goto 3

C Clear the connections list by scanning each zone geometry
C file in turn, re-establish nzsur. Once there is a new list
C of connections re-establish the IZSTOCN array.
          call edisp(iuout,'Clearing contiguity... ')
          ICC=0
          do 87 IZ=1,NCOMP
            call georead(IFIL+1,LGEOM(IZ),IZ,0,itru,IER)
            nzsur(iz)=nsur
            do 88 IS=1,NSUR
              ICC=ICC+1
              IC1(ICC)=IZ; IE1(ICC)=IS
              ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
   88       continue
   87     continue
          NCON=ICC
          do 145 icc = 1, NCON
            IZSTOCN(IC1(icc),IE1(icc))=icc
 145      continue
          write(outs,'(a,i4)')'No. of connections now = ',NCON
          call edisp(iuout,outs)

C Re-establish arrays of zone data now that there are possibly
C different numbers of connections.
          NZONES=NCOMP
          CALL ZDATA (0,IER,NZONES)

C Check if user wants to re-establish connection data from surface
C attributes.
          call easkok(' ','Recover surface attribute data?',
     &      OK,9)
          if(OK)then
            call ESACON(M1SKP,M2SKP,M4SKP,M5SKP,M6SKP,M7SKP,IER)
            MODIFYVIEW=.TRUE.
          endif
        elseif(IRT.eq.2)then
          call easkok(' ','Clear items marked SIMILAR?',M1OK,
     &      nbhelp)
          call easkok(' ','Clear items marked CONSTANT?',M2OK,
     &      nbhelp)
          call easkok(' ','Clear items marked GROUND?',M4OK,
     &      nbhelp)
          call easkok(' ','Clear items marked ADIABETIC?',M5OK,
     &      nbhelp)
          call easkok(' ','Clear items marked BASESIMP?',M6OK,
     &      nbhelp)
          call easkok(' ','Clear items marked IDENT_CEN?',M7OK,
     &      nbhelp)
          call usrmsg('Clearing partial contiguity...',bl,'-')
          ICC=0
          do 187 IZ=1,NCOMP
            call georead(IFIL+1,LGEOM(IZ),IZ,0,itru,IER)
            nzsur(iz)=nsur
            do 188 IS=1,NSUR
              if(ICT(ICC).eq.1.and.M1OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              elseif(ICT(ICC).eq.2.and.M2OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              elseif(ICT(ICC).eq.4.and.M4OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              elseif(ICT(ICC).eq.5.and.M5OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              elseif(ICT(ICC).eq.6.and.M6OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              elseif(ICT(ICC).eq.7.and.M7OK)then
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              else
                ICC=ICC+1
                IC1(ICC)=IZ; IE1(ICC)=IS
                ICT(ICC)=0; IC2(ICC)=0; IE2(ICC)=0
              endif
  188       continue
  187     continue
          NCON=ICC
          write(outs,'(a,i4)')'No. of connections now = ',NCON
          call edisp(iuout,outs)

C Re-build zone:surface to connection hash array.
          do icc = 1, NCON
            IZSTOCN(IC1(icc),IE1(icc))=icc
          enddo

C Check if user wants to re-establish connection data from surface
C attributes.
          call easkok(' ','Recover surface attribute data?',
     &             OK,nbhelp)
          if(OK)then
            call ESACON(M1SKP,M2SKP,M4SKP,M5SKP,M6SKP,M7SKP,IER)
            MODIFYVIEW=.TRUE.
          endif
        elseif(IRT.eq.3)then   ! Refresh from surface attributes.

          itznb=0; itncon=0  ! clear geoscan counters.
          do ijj=1,ncomp
            call FINDFIL(LGEOM(ijj),XST)
            IF(XST)THEN
              write(currentfile,'(a)') LGEOM(ijj)(1:lnblnk(LGEOM(ijj)))
              CALL ERPFREE(IFIL+1,ios)
              call GEOSCAN(IFIL+1,LGEOM(ijj),ijj,IR,ITRU,IER)
            endif
          enddo
          write(6,*) 'geoscan found ',itncon,' connections.'
          do ICON=1,ITNCON
            ic1(icon)=itic1(icon)
            ie1(icon)=itIE1(icon)
            ICT(ICON)=itICT(icon)
            IC2(ICON)=itIC2(icon)
            IE2(ICON)=itIE2(icon)

C Debug of geo scan vs cnn file variables.
            write(6,'(i4,a,2i4,a,2i4,a,2i4,a,2i4,a,2i4)') 
     &       icon,' tcz cz ',itic1(icon),ic1(icon),
     &       ' tcs cs',itIE1(icon),ie1(icon),
     &       ' tct ct',itICT(icon),ICT(ICON),
     &       ' tc2 c2',itIC2(icon),IC2(ICON),
     &       ' te2 e2',itIE2(icon),IE2(ICON)
          enddo
          goto 3
        elseif(IRT.eq.4)then
          goto 3
        endif

C Save current common block information to file, jump back and
C update the display. 
  286   write(DCNN,'(a,a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
        if(icfgv.gt.4.and.usecurcfg.eq.1)then
          write(LCNN,'(a)') 'internal'
        else
          write(LCNN,'(2a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
          if(LCNN(1:1).eq.' ')LCNN=DCNN
          CALL EASKS(LCNN,'Updated surface connections file?',' ',
     &      72,DCNN,'system connx file name',IER,nbhelp)
          IF(LCNN.EQ.' ')GOTO 286
        endif
        CALL EMKCFG('-',IER)
      ELSEIF(INO.EQ.17)THEN

C Check vertex matches and rebuild configuration file. 
        ITSNM=0
  285   write(DCNN,'(a,a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
        if(icfgv.gt.4.and.usecurcfg.eq.1)then
          write(LCNN,'(a)') 'internal'
        else
          write(LCNN,'(2a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
          if(LCNN(1:1).eq.' ') LCNN=DCNN
          CALL EASKS(LCNN,'Updated surface connections file?',' ',
     &      72,DCNN,'system connx file name',IER,nbhelp)
          IF(LCNN.EQ.' ')GOTO 285
        endif

C Look for connections.
        CALL CONFIG(NZONES,CACC,IACC,DACC,M0SKP,M1SKP,M2SKP,M3SKP,
     &    M4SKP,M5SKP,M6SKP,M7SKP,M8SKP,OTHEROK,ANGCC)

C Re-build zone:surface to connection hash array.
        do 43 icc = 1, NCON
          IZSTOCN(IC1(icc),IE1(icc))=icc
 43     continue

C Save data to configuration and connections file.
        CALL EMKCFG('s',IER)
        MODIFYVIEW=.TRUE.
      ELSEIF(INO.EQ.19)THEN

C Toggle trace level.
        ITRC=ITRC+1
        IF(ITRC.GT.2)ITRC=0
        INO=-4
      ELSE
        INO=-1
        GOTO 3
      ENDIF
      GOTO 3

      END 

C ******************** CONFIG ********************
C Processes the vertex data and presents close matches for
C user confirmation before writing to temporary configuration file.

      SUBROUTINE CONFIG(NZONES,CACC,IACC,DACC,M0SKP,M1SKP,M2SKP,M3SKP,
     &  M4SKP,M5SKP,M6SKP,M7SKP,M8SKP,OTHEROK,ANGCC)
#include "building.h"
#include "model.h"
#include "site.h"
#include "geometry.h"
#include "prj3dv.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      COMMON/FILEP/IFIL
      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)

      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)

C Pause length during sequentail scan longpause (true=1 sec).
      common/scanpause/longpause

      dimension ICVALS(MCOM),ipmz(3),ipms(3)
      DIMENSION cog(3),cogo(3)

      LOGICAL OK,DOIT,OTHEROK,UPDGEO
      logical M0SKP,M1SKP,M2SKP,M3SKP,M4SKP,M5SKP,M6SKP,M7SKP,M8SKP
      logical closee,closee2,close,longpause
      logical closecog,closearea,closeaz
      logical closecog2,closearea2,closeaz2
      logical origisfloor,origisceiling ! close to horizontal
      logical testisfloor,testisceiling
      logical newgeo  ! to use for testing if new/old geometry file.
      logical focussname
      character outs*124,CXSTR*78,SN*12
      character DESCRC*25
      character DCNN*72,bl*2
      integer izselfcheck  ! the surface being tested
      logical selfcheck  ! set true if currently looking within zone
      real ANGCC  ! angular tolerance between surfaces
      real vdist                                ! distance between cog of two surfaces
      integer zso_ck
      integer zso
      dimension zso(MS,3)                       ! To pass boundary indices.

      helpinsub='edtopol'  ! set for subroutine

C CACC is the tolerance allowed between two vertices (can be user adjusted).
C zso is array of temporary new topology attributes for current zone.

      bl='  '
      ITSNM=0
      IC=0
      newgeo=.false.  ! assume older format geometry.

C Set for redraw if image on first entry (if refresh set to after
C each edit).
      MODIFYVIEW=.TRUE.
      MODLEN=.TRUE.
      MODBND=.TRUE.
      zso(1,1)=-1; zso(1,2)=0; zso(1,3)=0   ! Clear.

C Request which zones to include.
      helptopic='setting_up_topol'
      call gethelptext(helpinsub,helptopic,nbhelp)
      ICPIC=NZONES
      CALL EPICKS(ICPIC,ICVALS,' ',' Which zones to include: ',
     &  12,NZONES,zname,' zone list',IER,nbhelp)

C Loop for each zone, only doing comparison for selected zones.
      DO 100 I=1,NZONES
        IZ=I
        DOIT=.FALSE.
        UPDGEO=.FALSE.
        do 215 ix=1,icpic
          if(IZ.eq.ICVALS(ix))DOIT=.TRUE.
  215   continue
        if(DOIT)then

C Get confirmation for continuing, if user wishes to skip a
C selected zone then updae the IC count to reflect the surfaces
C skiped.
          if(IZ.ne.1)then
            write(outs,'(3a)')'Continue with ',zname(IZ),'?'
            CALL EASKOK(' ',outs,OK,nbhelp)
            if(.NOT.OK)then
              IC=IC+nzsur(IZ)
              goto 100
            endif
          endif
          WRITE(outs,'(A,I2,A,A)') 'Processing (',IZ,') ',zname(IZ)
          call edisp(iuout,outs)
          call edisp(iuout,' corners|connx| description ')
          call edisp(iuout,' in surf|index| of existing topology')
        endif

C Display the reference zone (if type 3 then display both).
C Remember topology attributes for reference zone in zso.
        IUO=IFIL+1
        call georead(IUO,LGEOM(IZ),IZ,0,iuout,IER)
        do 322 IJ=1,NSUR
          zso(IJ,1)=zboundarytype(iz,ij,1)
          zso(IJ,2)=zboundarytype(iz,ij,2)
          zso(IJ,3)=zboundarytype(iz,ij,3)
  322   continue
        MODIFYVIEW=.TRUE.
        MODBND=.TRUE.

C Loop over each surface and increment the counter IC. JS is the
C base surface to search for boundary options.
        DO 110 J=1,nzsur(IZ)
          JS=J
          IC=IC+1
          izselfcheck=JS  ! remember the surface being tested

C If zone is not to be included in the analysis, jump.
          if(.NOT.DOIT)goto 110

C Reset all surface lines to standard width and then the specific 
C surface(s) under consideration to wide lines. If other side
C is not a type 3 then don`t highlight.
          if(MMOD.eq.8)then
            CALL INLNST(1)
            LINSTY(IC)=2
          endif
          nzg=1
          nznog(1)=IZ
          izgfoc = IZ
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          MODIFYVIEW=.TRUE.

          cog(1)=surcog(iz,js,1)
          cog(2)=surcog(iz,js,2)
          cog(3)=surcog(iz,js,3)
          CALL CONXINF(1,IC,CXSTR)
          write(outs,'(3X,A)') CXSTR
          call edisp(iuout,outs)

C If user said skip confirmation of marked partitions, check and update the
C surface attribute if a dash and jump around.
          if(M3SKP.and.(ICT(IC).eq.3))then
            call edisp(iuout,'known connection skipped.')
            if(MMOD.eq.8)then
              if(longpause)then
                call pauses(1)
              else
                call pausems(400)
              endif
            endif
            goto 110
          endif

C Reset number of geometric matches. If more than one then ask.
          ipmatch=0

C Loop over zones including this zone so that back-to-back surfaces
C are also detected.
          DO 200 II=1, NZONES
            if (II.EQ.IZ)then
              selfcheck=.true.  ! currently looking within zone
            else
              selfcheck=.false.
            endif

C Find if there is a surface connection. Skip past self if in same zone.
C JJ is the current surface being tested.
            DO 210 JJ=1,nzsur(II)
              if(selfcheck.and.JJ.eq.izselfcheck)then
                goto 210
              endif

C Find if two surface are within ANGCC degrees orientation and COG etc.
              closecog=.false.; closecog2=.false.
              closearea=.false.; closearea2=.false.
              closee=.false.; closee2=.false.
              closeaz=.false.; closeaz2=.false.
              cogo(1)=surcog(ii,jj,1)
              cogo(2)=surcog(ii,jj,2)
              cogo(3)=surcog(ii,jj,3)

C Tighter tollerances for COG comparison with small surfaces.
              if(sna(iz,js).lt.1.0)then
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.2,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.3,closecog2)
              elseif(sna(iz,js).gt.10.0)then
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.6,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.8,closecog2)
              else
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.4,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.5,closecog2)
              endif
              vdist= crowxyz(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &          cogo(3))

C Compare the base surface iz & js with ii & jj
              if(sna(iz,js).lt.1.0)then
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.1,closearea)
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.2,closearea2)
              elseif(sna(iz,js).gt.10.0)then
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.5,closearea)
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.6,closearea2)
              else
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.3,closearea)
                CALL ECLOSE(SNA(ii,jj),sna(iz,js),0.4,closearea2)
              endif

              SELV=SPELV(ii,jj)+SPELV(iz,js)
              DAZI=SPAZI(ii,jj)-SPAZI(iz,js)
              DAZI=ABS(DAZI)
              call eclose(DAZI,180.0,ANGCC,closeaz)
              call eclose(DAZI,180.0,3.0,closeaz2)
              call eclose(SELV,0.0,ANGCC,closee)
              call eclose(SELV,0.0,3.0,closee2)
              call eclose(SPELV(iz,js),-90.0,1.0,origisfloor)
              call eclose(SPELV(iz,js),90.0,1.0,origisceiling)
              call eclose(SPELV(ii,jj),-90.0,1.0,testisfloor)
              call eclose(SPELV(ii,jj),90.0,1.0,testisceiling)

              if(closecog.and.closearea.and.closeaz.and.closee)then
                continue
              elseif(closecog.and.closearea.and.closee)then

C If horizontal relax the azimuth test.
                if(origisfloor.and.testisceiling)then
                  continue  ! original was a floor vs other ceiling
                elseif(origisceiling.and.testisfloor)then
                  continue  ! original was ceiling vs other floor
                endif
              else

C Test relaxed tollerances.
                if(closecog2.and.closearea2.and.closeaz2.and.
     &             closee2)then
                  continue
                else
                  goto 210  ! not worth testing
                endif
              endif

C If we reached here increment the number of matches and remember the current test surface.
              ipmatch=ipmatch+1
              if(ipmatch.le.3)then
                ipmz(ipmatch)=II
                ipms(ipmatch)=JJ
              endif

  210       CONTINUE
  200     CONTINUE

C Depending on how many matches were found, proceed.  If there were
C no matches then check for existing IDENTICAL or CONSTANT or GROUND
C or ADIABATIC or BASESIMP or IDENT_CEN and set these if the user
C asked to skip onfirmation.
          if(ipmatch.eq.0)then

C If user said skip confirmation of marked IDENTICAL, check and update the
C surface attribute if it does not match and jump around. zso_ck is the
C base surface boundary condition.
            zso_ck=zso(JS,1)
            if(M1SKP.and.(ICT(IC).eq.1))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.1)then
                zso(JS,1)=1; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C If user said skip confirmation of marked CONSTANT, check and update the
C surface attribute if it does not match and jump around.
            if(M2SKP.and.(ICT(IC).eq.2))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.2)then
                zso(JS,1)=2; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C If user said skip confirmation of marked GROUND, check and update the
C surface attribute if it does not match and jump around.
            if(M4SKP.and.(ICT(IC).eq.4))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.4)then
                zso(JS,1)=4; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C If user said skip confirmation of marked ADIABATIC, check and update the
C surface attribute if it does not match and jump around.
            if(M5SKP.and.(ICT(IC).eq.5))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.5)then
                zso(JS,1)=5; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C If user said skip confirmation of marked BASESIMP, check and update the
C surface attribute if it does not match and jump around. 
            if(M6SKP.and.(ICT(IC).eq.6))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.6)then
                zso(JS,1)=6; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C If user said skip confirmation of marked IDENT_CEN, check and update the
C surface attribute if it does not match and jump around. 
            if(M7SKP.and.(ICT(IC).eq.7))then
              call edisp(iuout,'known connection skipped.')
              if(MMOD.eq.8)then
                if(longpause)then
                  call pauses(1)
                else
                  call pausems(400)
                endif
              endif
              if(zso_ck.ne.7)then
                zso(JS,1)=7; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
              endif
              goto 110
            endif

C Ask user if some other type of connection. If M0SKP is true then
C set connection to exterior and proceed.
            if(OTHEROK)then
              if(M0SKP)then
                IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=0
                IE2(IC)=0; IC2(IC)=0
                if(zso_ck.ne.0)then
                  zso(JS,1)=0; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                  UPDGEO=.TRUE.
                endif
                call edisp(iuout,'no match found setting to EXTERIOR.')
                if(MMOD.eq.8)then
                  if(longpause)then
                    call pauses(1)
                  else
                    call pausems(400)
                  endif
                endif
              else

C Setup contextural help for boundary conditions.
                helptopic='boundary_choices'
                call gethelptext(helpinsub,helptopic,nbhelp)
                if(ICT(IC).eq.3)then
                  write(outs,'(a,a)') 
     &              'Partition, but no geometric match found. Is ',
     &              CXSTR(1:lnblnk(CXSTR))
                elseif(ICT(IC).ne.3)then
                  write(outs,'(a,a)')'No geometric match found. Is ',
     &              CXSTR(1:lnblnk(CXSTR))
                  idno=ICT(IC)
                endif
                iart=0
                call MENUATOL(outs,'Connection options:',
     &  'a exterior                  ','b similar',
     &  'c constant','d ground (standard profile)',
     &  'e ground (user profile) ','f ground (3D conduction)',
     &  'g adiabatic','h BASESIMP foundation',
     &  'i CEN 13791 partition',
     &  'j unknown (at this time)','k accept current',
     &   ' ',iart,idno,nbhelp)

                if(IART.eq.0)then
                  continue
                elseif(IART.eq.1)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=0
                  IE2(IC)=0; IC2(IC)=0
                  if(zso_ck.ne.0)then
                    zso(JS,1)=0; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                elseif(IART.eq.2)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=1
                  VALT=0.0; VALW=0.0
                  CALL EASKR(VALT,' ','Temperature offset?',
     &              -99.,'F',700.,'F',0.0,'offset temp',IER,nbhelp)
                  CALL EASKR(VALW,' ','Radiation offset?',
     &              0.0,'W',99999.,'W',0.0,'offset rad',IER,nbhelp)
                  IC2(IC)= int(VALT); IE2(IC)= int(VALW)
                  if(zso_ck.ne.1)then
                    zso(JS,1)=1; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                elseif(IART.eq.3)then
                  CALL EASKR(VAL,' ','Constant temperature (C)?',
     &              -99.,'F',99.,'F',20.,'adjacent temperature',
     &              IER,nbhelp)
                  CALL EASKR(VAL2,' ','Constant radiation (W/m^2)?',
     &              -999.,'F',999.,'F',0.,'adjacent rad',IER,nbhelp)
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=2
                  IE2(IC)=INT(VAL2)
                  IC2(IC)=INT(VAL)
                  if(zso_ck.ne.2)then
                    zso(JS,1)=2; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                elseif(IART.eq.4)then

C List out standard profiles, assuming that if June is 0.0, then the
C profile has not been defined.
                  CALL EDISP(iuout,'Standard ground profiles Jan-Dec:')
                  CALL EDISP(iuout,
     &              'id  Jan, Feb, Mar, Apr, May, Jun, Jul...')
                  do 21 igrdp=1,mgrdp
                    CALL ECLOSE(GRDTMP(6,igrdp),0.0,0.001,close)
                    if(.NOT.close)then
                      WRITE(OUTS,'(I2,2a)')igrdp,' ',grdtmpname(IGRDP)
                      call edisp(iuout,outs)
                      WRITE(OUTS,'(I2,12F5.1)')igrdp,
     &                  (GRDTMP(JG,IGRDP),JG=1,12)
                      call edisp(iuout,outs)
                    endif
21                continue
                  helptopic='boundary_ground'
                  call gethelptext(helpinsub,helptopic,nbhelp)
                  iic2=ic2(IC)
  777             CALL EASKI(IIC2,'Standard profile index?',
     &              ' ',1,'F',mgrdp,'F',1,'ground profile',IER,nbhelp)
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=4
                  IF(IIC2.GT.0)THEN
                    IC2(IC)=iic2
                    IE2(IC)=0
                    if(zso_ck.ne.4)then
                      zso(JS,1)=4; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                      UPDGEO=.TRUE.
                    endif
                  ELSE
                    CALL USRMSG(' ','Unacceptable ground profile.','W')
                    GOTO 777
                  ENDIF
                elseif(IART.eq.5)then

C List out user defined profiles, assuming that if June is 0.0, then the
C profile has not been defined.
                  if(NGRDP.gt.0)then
                    CALL EDISP(iuout,' ')
                    do 22 igrdp=1,NGRDP    
                      CALL EDISP(iuout,
     &                  'User defined ground profile Jan-Dec:')
                      WRITE(OUTS,'(12F6.1)')(UGRDTP(JG,IGRDP),JG=1,12)
                      call edisp(iuout,outs)
 22                 continue
                    CALL EASKI(IIE2,
     &                'User ground profile index?',
     &                ' ',0,'F',9,'F',1,'user defined profile',
     &                IER,nbhelp)
                    IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=4 
                    IC2(IC)=0
                    IE2(IC)=iie2
                    if(zso_ck.ne.4)then
                      zso(JS,1)=4; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                      UPDGEO=.TRUE.
                    endif
                  else
                    call usrmsg(
     &               'No user defined ground profiles found!',
     &               ' ','W')
                  endif
                elseif(iart.eq.6)then 

C Link to a 3D conduction model..
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=4
                  IC2(IC)=-3; IE2(IC)=0
                  if(zso_ck.ne.4)then
                    zso(JS,1)=4; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                elseif(IART.eq.7)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=5
                  IE2(IC)=0; IC2(IC)=0
                  if(zso_ck.ne.5)then
                    zso(JS,1)=5; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif

C Get BASESIMP configuration via call to bsimtype. Save state of current
C menu and recover after the call.
                elseif(iart.eq.8)then 
                  IC1(IC)=IZ;  IE1(IC)=JS; ICT(IC)=6
                  IBS=IC2(IC)
                  call bsimtype(ibs)
                  IC2(IC)=IBS

C Get `surface weighting factor', the percentage of the BASESIMP heat loss to
C attribute to the surface under consideration.
                  Ifrac=IE2(IC)
                  helptopic='boundary_basesimp'
                  call gethelptext(helpinsub,helptopic,nbhelp)
                  CALL EASKI(Ifrac,
     &              'BASESIMP loss to this surface (%)?'
     &             ,' ',0,'F',100,'F',100,'BASESIMP heat loss percent',
     &              IER,nbhelp)
                  IE2(IC)=Ifrac
                  if(zso_ck.ne.6)then
                    zso(JS,1)=6; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif

                elseif(IART.eq.9)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=7
                  IE2(IC)=0; IC2(IC)=0
                  if(zso_ck.ne.7)then
                    zso(JS,1)=7; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif

C CEN 13791 partition end.
                elseif(IART.eq.10)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=-1
                  IE2(IC)=0; IC2(IC)=0
                  if(zso_ck.ne.-1)then
                    zso(JS,1)=0; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                endif
              endif
            endif
          elseif(ipmatch.eq.1)then

C Only one possible matching surface, inform user and then proceed. If
C selfcheck is false then the match is as a partition to a surface in
C another zone. If selfcheck is true then we have a back-to-back
C match and we need to test the value of M8SKP.
            II=ipmz(1)
            JJ=ipms(1)

C Re-evaluate the state of selfcheck based on the surface that was
C found to match.
            if (II.EQ.IZ)then
              selfcheck=.true.  ! currently looking within zone
            else
              selfcheck=.false.
            endif

            MODBND=.TRUE.
            if(MMOD.eq.8)then
              CALL INLNST(1)
              LINSTY(IC)=2
            endif
            nzg=2
            nznog(1)=IZ
            nznog(2)=II
            CALL SURADJ(II,JJ,IE,TMP,IZC,ISC,ICO,DESCRC)  ! Why call? 
            if(MMOD.eq.8)LINSTY(ICO)=2
            izgfoc = IZ
            focussname=.true.
            if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
            MODIFYVIEW=.TRUE.
            MODBND=.TRUE.
            IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=3
            IC2(IC)=II; IE2(IC)=JJ
            call usrmsg(' ',bl,'-')
            if(MMOD.eq.8)then
              if(longpause)then
                call pauses(1)
              else
                call pausems(400)
              endif
            endif

C If an actual partition then no need for confirmation, just
C update the attributes.
            if(.NOT.selfcheck)then
              zso(JS,1)=3; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
              UPDGEO=.TRUE.
              SN=SNAME(II,JJ)
              lnzn=lnblnk(zname(II))
              WRITE(outs,'(4a)')' accepting match to surface ',
     &          SN(1:lnblnk(SN)),' in ',zname(II)(1:lnzn)
              call edisp(iuout,outs)
              goto 110  ! no need to check further
            else
    
C If we are in the same room then we have a back-to-back surface.
C If M8SKP was set to false then go ahead and
C make it a partition without bothering to ask the user.
              if(M8SKP)then
                zso(JS,1)=3; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
                SN=SNAME(II,JJ)
                WRITE(outs,'(3a)')' accepting match to surface ',
     &            SN(1:lnblnk(SN)),' in current zone.'
                call edisp(iuout,outs)
                goto 110  ! no need to check further
              else
                CALL EASKMBOX('Matched surface within room:',' ',
     &            'set to back-to-back','set to ADIABETIC',
     &            'set to UNKNOWN','set to EXTERIOR',
     &            ' ',' ',' ',' ',IRTA,nbhelp)
                if(IRTA.eq.1)then
                  zso(JS,1)=3; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                  UPDGEO=.TRUE.
                  SN=SNAME(II,JJ)
                  WRITE(outs,'(3a)')' accepting match to surface ',
     &              SN(1:lnblnk(SN)),' in current zone.'
                  call edisp(iuout,outs)
                elseif(IRTA.eq.2)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=5
                  IE2(IC)=0; IC2(IC)=0
                  zso(JS,1)=5; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                  UPDGEO=.TRUE.
                elseif(IRTA.eq.3)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=-1
                  IE2(IC)=0; IC2(IC)=0
                  zso(JS,1)=-1; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                  UPDGEO=.TRUE.
                elseif(IRTA.eq.4)then
                  IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=0
                  IE2(IC)=0; IC2(IC)=0
                  if(zso_ck.ne.0)then
                    zso(JS,1)=0; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                    UPDGEO=.TRUE.
                  endif
                endif
                goto 110  ! no need to check further
              endif
            endif
          elseif(ipmatch.gt.1)then

C If there is more than ONE possible matching geometric connection
C then confirm with the user. First check if one of the matches
C is of a reasonable orientation.  Again, test the base surface
C iz & js with ii & jjx.
            iipmatch=MIN0(ipmatch,3)
            write(outs,'(a,i2,a,a)') 'There are ',iipmatch,
     &        ' possible matches with ',CXSTR(1:lnblnk(CXSTR))
            call edisp(iuout,outs)
            do 841 ipml=1,iipmatch
              IIx=ipmz(ipml)
              JJx=ipms(ipml)
              CALL SURADJ(IIx,JJx,IE,TMP,IZC,ISC,ICO,DESCRC)
              SELV=SPELV(IIx,JJx)+SPELV(iz,js)
              DAZI=SPAZI(IIx,JJx)-SPAZI(iz,js)
              DAZI=ABS(DAZI)
              closecog=.false.; closecog2=.false.  ! Clear before testing again.
              closearea=.false.; closee=.false.
              closeaz=.false.
              call eclose(DAZI,180.0,3.0,closeaz)
              call eclose(SELV,0.0,3.0,closee)
              SN=SNAME(IIx,JJx)
              cogo(1)=surcog(iix,jjx,1)
              cogo(2)=surcog(iix,jjx,2)
              cogo(3)=surcog(iix,jjx,3)

C Tighter tollerances for COG comparison with small surfaces.
              if(sna(iz,js).lt.1.0)then
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.2,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.3,closecog2)
              elseif(sna(iz,js).gt.10.0)then
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.6,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.8,closecog2)
              else
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.4,closecog)
                call eclose3(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &            cogo(3),0.5,closecog2)
              endif
              vdist= crowxyz(cog(1),cog(2),cog(3),cogo(1),cogo(2),
     &          cogo(3))

              if(sna(IIx,JJx).lt.1.0)then
                CALL ECLOSE(SNA(IIx,JJx),sna(iz,js),0.2,closearea)
              elseif(sna(IIx,JJx).gt.10.0)then
                CALL ECLOSE(SNA(IIx,JJx),sna(iz,js),0.6,closearea)
              else
                CALL ECLOSE(SNA(IIx,JJx),sna(iz,js),0.4,closearea)
              endif
              lnzn=lnblnk(zname(IIx))
              if(closecog.and.closearea.and.closeaz.and.closee)then
                WRITE(outs,'(5a,f6.1,a,2f5.2,a,f5.2)')
     &          ' Probable (area CoG azim elev) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas ',SNA(IIx,JJx),sna(iz,js),
     &            ' dif COG ',vdist
                call edisp(iuout,outs)
              elseif(closearea.and.closeaz.and.closee)then
                WRITE(outs,'(5a,f6.1,a,2f5.2,a,f5.2)')
     &            ' Probable (area close) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas ',SNA(IIx,JJx),sna(iz,js),
     &            ' dif COG ',vdist
                call edisp(iuout,outs)
              elseif(closeaz.and.closee)then
                WRITE(outs,'(5a,f6.1,a,2F5.2,a,f5.2)')
     &            ' Probable (orientation close) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas',SNA(IIx,JJx),sna(i,js),
     &            ' dif COG ',vdist
                call edisp(iuout,outs)
              else

C In the case of near horizontal surfaces do additional checks before
C giving up on orientation.
                lnzn=lnblnk(zname(IIx))
                call eclose(SPELV(iz,js),-90.0,1.0,origisfloor)
                call eclose(SPELV(iz,js),90.0,1.0,origisceiling)
                call eclose(SPELV(IIx,JJx),-90.0,1.0,testisfloor)
                call eclose(SPELV(IIx,JJx),90.0,1.0,testisceiling)
                if(origisfloor.and.testisceiling)then
                  WRITE(outs,'(5a,F6.1,a,2F5.2)')
     &            ' Possible (orientation close) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas',SNA(IIx,JJx),sna(iz,js)
                elseif(origisceiling.and.testisfloor)then
                  WRITE(outs,'(5a,F6.1,a,2F5.2)')
     &            ' Possible (orientation close) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas',SNA(IIx,JJx),sna(iz,js)
                else
                  WRITE(outs,'(5a,F6.1,a,2F5.2)')
     &            ' Possible (orientation not close) match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(IIx)(1:lnzn),
     &            ' @ dif azi ',DAZI,' areas',SNA(IIx,JJx),sna(iz,js)
                endif
                call edisp(iuout,outs)
              endif
 841        continue
 840        continue

C With two surfaces close together it is difficult to see the connection.
C Zoom in on the surface in question - find its bounding box and centre
C the view on it and calculate the angle of view to that box.
            if(MMOD.eq.8)then
              call surbox(iz,js,1.,cx,cy,cz,sxmx,sxmn,symx,symn,szmx,
     &          szmn)
              call saveview
              call ang3vtx(sxmn,symn,sznb,EYEM(1),EYEM(2),EYEM(3),sxmx,
     &          symx,szmx,angn)
              ANG=angn
              HANG=ANG/2.0
            endif
            do 843 ipml=1,iipmatch
              ITBND=0
              VIEWM(1)=cx; VIEWM(2)=cy; VIEWM(3)=cz
              XMN=sxmn; YMN=symn; ZMN=szmn
              XMX=sxmx; YMX=symx; ZMX=szmx
              MODIFYVIEW=.TRUE.
              MODLEN=.TRUE.
              if(MMOD.eq.8)CALL INLNST(1)
              if(MMOD.eq.8)LINSTY(IC)=2
              nzg=2
              II=ipmz(ipml)  ! Reset II & JJ with the user choice.
              JJ=ipms(ipml)
              nznog(1)=IZ
              nznog(2)=II
              if(MMOD.eq.8)LINSTY(ICO)=2
              izgfoc = IZ
              focussname=.true.
              if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
              SN=SNAME(II,JJ)
              lnzn=lnblnk(zname(II))
              WRITE(outs,'(4a)')' Probable match to surface ',
     &            SN(1:lnblnk(SN)),' in ',zname(II)(1:lnzn)
              helptopic='multi_match_partn'
              call gethelptext(helpinsub,helptopic,nbhelp)
              CALL EASKOK(outs,'Accept?',OK,nbhelp)
              IF(OK)then
                IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=3
                IC2(IC)=II; IE2(IC)=JJ

C Update surface attributes and then restore the view points.
                zso(JS,1)=3; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
                UPDGEO=.TRUE.
                if(MMOD.eq.8)call recoview
                ITBND=1
                MODLEN=.TRUE.
                MODIFYVIEW=.TRUE.
                MODBND=.TRUE.

C Move to the next surface.
                goto 110
              endif
 843        continue

C If reached this point then no surface selected. 
            if(MMOD.eq.8)call recoview
            ITBND=1
            MODBND=.TRUE.
            MODIFYVIEW=.TRUE.
            MODLEN=.TRUE.
            CALL EASKMBOX('No suggestion taken.','Options:',
     &        'loop again','set to UNKNOWN','set to EXTERIOR',
     &        'set to SIMILAR','set to ADIABATIC','cancel',' ',' ',
     &        IRTA,nbhelp)
            if(irta.eq.1)then
              goto 840
            elseif(irta.eq.2)then
              IC1(IC)=IZ; IE1(IC)=JS
              ICT(IC)=-1            ! unknown connection is a -1
              IE2(IC)=0; IC2(IC)=0
              zso(JS,1)=-1; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
              UPDGEO=.TRUE.
            elseif(irta.eq.3)then
              IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=0
              IE2(IC)=0;  IC2(IC)=0
              zso(JS,1)=0; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
              UPDGEO=.TRUE.
            elseif(irta.eq.4)then
              IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=1
              VALT=0.0; VALW=0.0
              CALL EASKR(VALT,' ','Temperature offset?',
     &          -99.,'F',700.,'F',0.0,'offset temp',IER,nbhelp)
              CALL EASKR(VALW,' ','Radiation offset?',
     &          0.0,'W',99999.,'W',0.0,'offset rad',IER,nbhelp)
              IC2(IC)= int(VALT); IE2(IC)= int(VALW)
              zso(JS,1)=1; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
              UPDGEO=.TRUE.
            elseif(irta.eq.5)then
              IC1(IC)=IZ; IE1(IC)=JS; ICT(IC)=5
              IE2(IC)=0; IC2(IC)=0
              zso(JS,1)=5; zso(JS,2)=IC2(ic); zso(JS,3)=IE2(ic)
              UPDGEO=.TRUE.
            elseif(irta.eq.6)then
              goto 110
            endif

C Reset line style.
            if(MMOD.eq.8)CALL INLNST(1)
          ENDIF
  110   CONTINUE

C Update geometry file if required.
        if(UPDGEO)then
          call edisp(iuout,' Updating surface attributes...')
          do 323 IJ=1,NSUR
            zboundarytype(iz,ij,1)=zso(ij,1)
            zboundarytype(iz,ij,2)=zso(ij,2)
            zboundarytype(iz,ij,3)=zso(ij,3)
  323     continue
  
C Debug.
          write(6,*) (zso(ij,1),ij=1,10)

          call eclose(gversion(IZ),1.1,0.01,newgeo)
          if(.NOT.newgeo)then
            gversion(iz) =1.1
            newgeo = .true.
          endif
          call geowrite2(IFIL+2,LGEOM(IZ),IZ,iuout,3,IER)
          IF(IER.NE.0)THEN
            CALL USRMSG(bl,' Problem updating geometry file.','W')
          ENDIF
        endif
  100 CONTINUE

C Ask user if updated information should be saved to different file.
 289  helptopic='save_to_cnn_file'
      call gethelptext(helpinsub,helptopic,nbhelp)
      write(DCNN,'(a,a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
      if(icfgv.gt.4.and.usecurcfg.eq.1)then
        write(LCNN,'(a)') 'internal'
      else
        write(LCNN,'(2a)')cfgroot(1:lnblnk(cfgroot)),'.cnn'
        if(LCNN(1:1).eq.' ') LCNN=DCNN
        CALL EASKS(LCNN,'Surface connections file?',' ',
     &    72,DCNN,'system connx file name',IER,nbhelp)
        IF(LCNN.EQ.' ')GOTO 289
      endif
      call EMKCFG('-',IER)

      RETURN
      END

C ************* ESACON 
C ESACON import surface connection attributes into the problem topology
C common block C3 while taking into account confirmation preferences.
C IER=0 OK, IER=1 problem.
C Use common block from geometry prescan for the surface attribute
C indices to copy into c3 common block.

      SUBROUTINE ESACON(M1SKP,M2SKP,M4SKP,M5SKP,M6SKP,M7SKP,IER)
#include "building.h"
#include "model.h"
#include "site.h"
#include "geometry.h"
#include "prj3dv.h"
#include "espriou.h"
#include "help.h"
      
      integer lnblnk  ! function definition

C Parameters: logical variables set the context of what to check
      logical M1SKP,M2SKP,M4SKP,M5SKP,M6SKP,M7SKP
      integer  IER   ! zero is ok 

      COMMON/FILEP/IFIL
      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)
      common/scanpause/longpause

      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      LOGICAL OK,longpause,XST,focussname

      integer itznb  ! test count of zones
      integer itncon ! test count of connections.
      integer itIC1,itIE1,itICT,itIC2,itIE2 ! tests of
      common/itcnn/itznb,itncon,itIC1(MCON),itIE1(MCON),itICT(MCON),
     &  itIC2(MCON),itIE2(MCON)

      CHARACTER CXSTR*78
      CHARACTER OUTSTR*124,SO*12,ZN*12,TMP*54
      CHARACTER bl*2
      character sbound_ty*12,sbound_c2*6,sbound_e2*6

      helpinsub='edtopol'  ! set for subroutine

C General image option flags.
      bl='  '
      ITDSP=1; ITBND=1; ITEPT=0; ITZNM=0; 
      ITSNM=0; ITVNO=1; ITORG=1; ITSNR=1
      ITGRD=1; GRDIS=0.0

C Display connection header.
      TMP=' '
      CALL EDISP(iuout,' ')
      CALL CONXINF(1,0,CXSTR)
      CALL EDISP(iuout,CXSTR)

C Help text for the dialogs.
      helptopic='importing_surf_conn'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Prescan the zone geometry files.
      itznb=0; itncon=0  ! clear geoscan counters.
      do ijj=1,ncomp
        call FINDFIL(LGEOM(ijj),XST)
        IF(XST)THEN
          write(currentfile,'(a)') LGEOM(ijj)(1:lnblnk(LGEOM(ijj)))
          CALL ERPFREE(IFIL+1,ios)
          call GEOSCAN(IFIL+1,LGEOM(ijj),ijj,IR,ITRU,IER)
        endif
      enddo
      write(6,*) 'geoscan found ',itncon,' connections.'

C Loop through each connection in turn. Read in the geometry
C attributes for each set of connections in turn.
C Map between the connection and surface. Only read in geometry
C and display zone when connection jumps to another zone.
      ICL=0; ISS=0
      NCON=ITNCON
      DO 123 ICC=1,ITNCON
        CALL ZPCONXINF(1,ICC,CXSTR)
        CALL EDISP(iuout,CXSTR)
        IF(ICL.NE.itIC1(ICC))THEN
          call georead(IFIL+1,LGEOM(itIC1(ICC)),itIC1(ICC),1,ITRU,IER)
          MODIFYVIEW=.TRUE.
          MODBND=.TRUE.

C Set all surfaces to standard line width.
          if(MMOD.eq.8)CALL INLNST(1)
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          IF(IER.NE.0)THEN
            RETURN
          ELSE
            ICL=itIC1(ICC)
            ISS=0
          ENDIF
        ENDIF
        ISS=ISS+1

C If surface attribute is something other than UNKNOWN then see about 
C upgrading the current connection. Display the connection and the
C surface attribute and ask user if attribute should be used. First
C check for easy matches.
        call decode_zsbound(itIC1(ICC),iss,sbound_ty,sbound_c2,
     &    sbound_e2)
        write(6,*) 'ESACON ',itIC1(ICC),iss,sbound_ty
        WRITE(SO,'(A)')sbound_ty(1:12)

C << what about instanciating zboundarytype here?? >>

C Set connected zone name if one exists.
        if(itIC2(ICC).ne.0)then
          write(ZN,'(a)') zname(IC2(ICC))
        else
          ZN='------------'
        endif
        WRITE(TMP,'(A,I3,A,A)')'Surface ',ISS,' attribute: ',SO
        WRITE(OUTSTR,'(A,A)')'Topology: ',CXSTR(1:lnblnk(CXSTR))
        IF(SO(1:8).EQ.'EXTERIOR'.AND.itICT(ICC).EQ.0)THEN
          CALL EDISP(iuout,'   topology & attribute EXTERIOR matches.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          goto  123
        ELSEIF(SO(1:7).EQ.'SIMILAR'.AND.itICT(ICC).EQ.1)THEN
          CALL EDISP(iuout,'   topology & attribute SIMILAR matches.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:8).EQ.'CONSTANT'.AND.itICT(ICC).EQ.2)THEN
          CALL EDISP(iuout,'   topology & attribute CONSTANT matches.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:6).EQ.'GROUND'.AND.itICT(ICC).EQ.4)THEN
          CALL EDISP(iuout,'   topology & attribute GROUND match.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:9).EQ.'ADIABATIC'.AND.itICT(ICC).EQ.5)THEN
          CALL EDISP(iuout,'   topology & attribute ADIABATIC match.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:8).EQ.'BASESIMP'.AND.itICT(ICC).EQ.6)THEN
          CALL EDISP(iuout,'   topology & attribute BASESIMP match.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:9).EQ.'IDENT_CEN'.AND.itICT(ICC).EQ.7)THEN
          CALL EDISP(iuout,'   topology & attribute IDENT_CEN match.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:7).EQ.'UNKNOWN'.OR.SO(1:2).EQ.'  ')THEN
          CALL EDISP(iuout,' surface attribute was UNKNOWN: skipping.')
          GOTO 123
        ELSEIF(SO(1:7).EQ.'ANOTHER'.and.itICT(ICC).EQ.3)THEN
          IF(SO(1:lnblnk(SO)).EQ.ZN(1:lnblnk(ZN)))then
            CALL EDISP(iuout,'   connected zone names match.')
            MODIFYVIEW=.TRUE.
            if(MMOD.eq.8)CALL INLNST(1)
            LINSTY(ICC)=2
            nzg=2
            nznog(1)=itIC1(ICC)
            nznog(2)=itIC2(ICC)
            izgfoc=0
            focussname=.true.
            if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
            if(.NOT.M1SKP)then
              call edisp(iuout,OUTSTR)
              call edisp(iuout,TMP)
              CALL EASKOK(' ','Use this surface attribute?',OK,nbhelp)
              IF(.NOT.OK)GOTO 123
            endif
            ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
            ICT(icc)=itICT(icc)
            IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          endif
          GOTO 123
        ELSEIF(SO(1:7).EQ.'SIMILAR')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M1SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << SIMILAR.')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:8).EQ.'CONSTANT')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M2SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << CONSTANT.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:6).EQ.'GROUND')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M4SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << GROUND.')
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:9).EQ.'ADIABATIC')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M5SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',
     &        OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << ADIABATIC.')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:8).EQ.'BASESIMP')THEN

C BASESIMP start.
C Get BASESIMP configuration via call to bsimtype. Save state of current
C menu and recover after the call.
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M6SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',
     &        OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << BASESIMP.')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:9).EQ.'IDENT_CEN')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          if(.NOT.M7SKP)then
            call edisp(iuout,OUTSTR)
            call edisp(iuout,TMP)
            CALL EASKOK(' ','Use this surface attribute?',
     &        OK,nbhelp)
            IF(.NOT.OK)GOTO 123
          endif
          CALL EDISP(iuout,'   topology << IDENT_CEN.')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
          GOTO 123
        ELSEIF(SO(1:8).EQ.'EXTERIOR')THEN
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=itIC1(ICC)
          izgfoc=itIC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          call edisp(iuout,OUTSTR)
          call edisp(iuout,TMP)
          CALL EASKOK(' ','Use this surface attribute?',OK,nbhelp)
          IF(.NOT.OK)GOTO 123
          CALL EDISP(iuout,'   topology << EXTERIOR.')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          ic1(icc)=itic1(icc); ie1(icc)=itIE1(icc)
          ICT(icc)=itICT(icc)
          IC2(icc)=itIC2(icc); IE2(Icc)=itIE2(icc)
        ELSE

C Not an easy match or mandated match so tell user.
          MODIFYVIEW=.TRUE.
          if(MMOD.eq.8)CALL INLNST(1)
          LINSTY(ICC)=2
          nzg=1
          nznog(1)=IC1(ICC)
          izgfoc=IC1(ICC)
          focussname=.true.
          if(MMOD.eq.8)CALL CADJVIEW(focussname,IER)
          WRITE(OUTSTR,'(A,A)')'Topology: ',CXSTR(1:lnblnk(CXSTR))
          call edisp(iuout,' ')
          call edisp(iuout,OUTSTR)
          call edisp(iuout,TMP)
          CALL usrmsg(bl,'Attribute cannot be imported.','-')
          if(MMOD.eq.8)then
            if(longpause)then
              call pauses(1)
            else
              call pausems(400)
            endif
          endif
          GOTO 123
        ENDIF
  123 CONTINUE

C Ask user if updated info should be saved to file.
      CALL EASKOK(' ','Save updated topology?',OK,nbhelp)
      if(OK)then
        call EMKCFG('s',IER)
      endif

      RETURN
      END

C **************** anchor 
C Defines and anchor points (a list of connections associated
C with a concept).

      subroutine anchor(ifoc,ier)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "material.h"
#include "epara.h"
#include "prj3dv.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)

C Anchor commons defined in model.h.
      DIMENSION VERT(35),flag(mcon),iconnpk(99)
      CHARACTER VERT*61,KEY*1,outs*124
      character CXITM*48,flag*12
      character ZN*12,SN*12
      character AL*12
      character LTMP*72
      character sbound_ty*12,sbound_c2*6,sbound_e2*6
      logical found,ok,foundone,okd,modmlc
      integer MVERT,IVERT ! max items and current menu item
      dimension IVALS(MCOM)

      helpinsub='edtopol'  ! set for subroutine

C Initialise connection menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
      iuf=IFIL+1
      INPIC=0
  31  MHEAD=7
      MCTL=4
      ILEN=NCON
      IPACT=CREATE
      CALL EKPAGE(IPACT)

      do 2 i = 1,ncon
        flag(i)= '      '
  2   continue

C Force redraw of zones, highlighting anchor list.
      MODIFYVIEW=.TRUE.
      nzg=NCOMP
      if(nzg.gt.0)then
        DO 44 I=1,nzg
          nznog(I)=I
  44    CONTINUE
        CALL INLNST(1)
        do 45 jj = 1,IALOC(ifoc)
          kk=lstanchr(ifoc,jj)
          if(kk.ne.0)LINSTY(kk)=2
  45    continue
        CALL redraw(IER)
      endif

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Help text.
   3  helptopic='anchor_options'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Set menu header text. Update flag string with * depending on which
C anchor set(s) is/are associated with a connection.
      write(VERT(1),'(a)') '  anchor data: '
      write(VERT(2),'(a)') '  ____________________________________'
      write(VERT(3),'(a)') '  index  label    type       nb. links'
      write(VERT(4),'(a,i2,5a,i2,a)') '1 ',ifoc,' ',ALOCLBL(ifoc),' ',
     &  ALOCTYP(ifoc),' (',IALOC(ifoc),' links)'
      VERT(5)='  ______________________________________________   '
      VERT(6)=
     &     ' conn|  connection        |    connection       |123456789'
      VERT(7)=' no. | inside face        | other side data     |anchor'
      do 5 i=1,NALOC
        if(IALOC(i).gt.0)then
          do 4 j = 1,IALOC(i)
            k=lstanchr(i,j)
            if(k.ne.0.and.i.eq.1)write(flag(k)(1:1),'(a)') '*'
            if(k.ne.0.and.i.eq.2)write(flag(k)(2:2),'(a)') '*'
            if(k.ne.0.and.i.eq.3)write(flag(k)(3:3),'(a)') '*'
            if(k.ne.0.and.i.eq.4)write(flag(k)(4:4),'(a)') '*'
            if(k.ne.0.and.i.eq.5)write(flag(k)(5:5),'(a)') '*'
            if(k.ne.0.and.i.eq.6)write(flag(k)(6:6),'(a)') '*'
            if(k.ne.0.and.i.eq.7)write(flag(k)(7:7),'(a)') '*'
            if(k.ne.0.and.i.eq.8)write(flag(k)(8:8),'(a)') '*'
            if(k.ne.0.and.i.eq.9)write(flag(k)(9:9),'(a)') '*'
            if(k.ne.0.and.i.eq.10)write(flag(k)(10:10),'(a)') '*'
            if(k.ne.0.and.i.eq.11)write(flag(k)(11:11),'(a)') '*'
            if(k.ne.0.and.i.ge.12)write(flag(k)(12:12),'(a)') '*'
   4      continue
        endif
   5  continue

C Loop through the items until the page to be displayed. M is the 
C current menu line index. Build up text strings for the menu. 
      M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          call CONXMENU(L,CXITM)
          VERT(M)=' '
          WRITE(VERT(M),'(A,1x,3A)')KEY,CXITM(1:46),'|',flag(L)
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.      
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)='  ________________________________________ '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM 
   15   FORMAT   ('0 page ------- Part: ',I3,' of ',I3,' -----')
      ENDIF
      VERT(M+2)  ='* modify list                         '
      VERT(M+3)  ='? help                                '
      VERT(M+4)  ='- exit menu                           '

C Now display the menu.
      CALL EMENU('  Anchor points',VERT,MVERT,IVERT)

      if(ivert.eq.mvert)then

C Save and return. 
        if(NALOC.gt.0)CALL EMKCFG('s',IER)
        return
      elseif(ivert.eq.mvert-1)then
        helptopic='anchor_options'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('anchor points',nbhelp,'-',0,0,IER)
      elseif(ivert.eq.mvert-2)then

C Modify the list. Ask whether to locate via a construction or
C via selection one at a time.
        CALL EASKMBOX('Surfaces to include in anchor list',
     &    'Select:','which match a construction','select manually',
     &    'cancel',' ',' ',' ',' ',' ',ins9,nbhelp)
        if(ins9.eq.1)then

C Search for matching constructions (similar to logic in serchrpl).
          if(mlcver.eq.0)then
            CALL EPKMLC(ISEL,'Select a construction to SEARCH for',
     &      'or -Exit',IER)
          else
            call edisp(iuout,'Select a construction to SEARCH for')
            CALL EDMLDB2(modmlc,'-',ISEL,IER)
          endif
          if(ISEL.eq.0) goto 92

          INPIC=NCOMP
          CALL EPICKS(INPIC,IVALS,' ',' Search zones:',
     &      12,NCOMP,zname,' zone list',IER,nbhelp)
          IF(INPIC.EQ.0) goto 92
          DO 96 IZ=1,INPIC
            IF(IVALS(IZ).GT.0)THEN
              write(zn,'(A)') zname(IVALS(IZ))
              write(outs,'(3a)') ' Scanning: ',zn(1:lnblnk(zn)),
     &           ' attributes...'
              CALL USRMSG(' ',outs,'-')
              LTMP=LGEOM(IVALS(IZ))
              call georead(IUF,LTMP,IVALS(IZ),1,iuout,IER)

C Remind user of surface attributes.
              WRITE(outs,93)
   93         FORMAT('          Surface|  Area  |Azim|Elev|geometry',
     &               '| multilayer  |environment')
              call edisp(iuout,outs)
              WRITE(outs,94)
   94         FORMAT('                 |  m^2   |deg |deg |type|loc',
     &               '| constr name |other side ')
              call edisp(iuout,outs)

C Loop through surfaces in the zone and report on which ones match.
              do 91 i=1,nsur
                icc=izstocn(ivals(iz),i)
                call decode_zsbound(ivals(iz),i,sbound_ty,sbound_c2,
     &            sbound_e2)
                lnssmlc=lnblnk(SMLCN(ivals(iz),i))
                if(SMLCN(ivals(iz),i)(1:lnssmlc).eq.
     &             mlcname(ISEL)(1:lnmlcname(ISEL)))then
                  write(sn,'(a)') SNAME(ivals(iz),i)
                  WRITE(outs,'(2a,F7.2,F5.0,F5.0,1X,A,
     &              1X,A,1X,A,1X,A)') 'Match: ',sn,SNA(ivals(iz),icc),
     &              SPAZI(ivals(iz),icc),SPELV(ivals(iz),icc),
     &              SOTF(ivals(iz),icc)(1:4),
     &              SVFC(ivals(iz),icc),SMLCN(ivals(iz),i)(1:12),
     &              sbound_ty
                  call edisp(iuout,outs)
                  if(inpic+1.lt.99)then
                    write(outs,'(5a)') ' Include in anchor list ',
     &                zn(1:lnblnk(zn)),':',sn(1:lnblnk(sn)),'?'
                    CALL EASKOK(' ',outs,OK,nbhelp)
                    if(ok)then
                      inpic=inpic+1       ! increment
                      iconnpk(inpic)=icc  ! remember connection
                    endif
                  endif
                endif
  91          continue
            endif
  96      continue

        elseif(ins9.eq.2)then
          if(IALOC(ifoc).eq.0)then
            inpic = 99
          else
            inpic = 99 - IALOC(ifoc)
          endif
          CALL EPMENSV
          call easkconn(inpic,iconnpk,99,
     &      'Select from the list of connections the',
     &      'surfaces associated with this anchor.',ALOCLBL(ifoc),
     &      ifoc,ier,nbhelp)
          CALL EPMENRC
        elseif(ins9.eq.3)then
          goto 92  ! jump and re-display the menu
        endif
        if(inpic.gt.0)then
          do 242 ij=1,inpic

C For each item from iconnpk that does not match an existing
C anchor update the list.
            found=.false.
            if(IALOC(ifoc).eq.0)then
              IALOC(ifoc)=IALOC(ifoc)+1
              lstanchr(ifoc,IALOC(ifoc))=iconnpk(ij)
            else
              do 243 ik=1,IALOC(ifoc)
                if(lstanchr(ifoc,ik).eq.iconnpk(ij))found=.true.
  243         continue
              if(.NOT.found)then
                IALOC(ifoc)=IALOC(ifoc)+1
                lstanchr(ifoc,IALOC(ifoc))=iconnpk(ij)
              endif
            endif
  242     continue
          goto 31
        else
          call edisp(iuout,'No surfaces associated with anchor.')
        endif
        goto 31
      elseif(ivert.eq.mvert-3)then

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      elseif(ivert.eq.4)then

C Force redraw of zones, highlighting anchor list.
        MODIFYVIEW=.TRUE.
        nzg=NCOMP
        if(nzg.gt.0)then
          DO 144 I=1,nzg
            nznog(I)=I
 144      CONTINUE
          CALL INLNST(1)
          do 145 jj = 1,IALOC(ifoc)
            kk=lstanchr(ifoc,jj)
            if(kk.ne.0)LINSTY(kk)=2
 145      continue
          CALL redraw(IER)
        endif
        call easkok(' ','Edit anchor name or type?',ok,nbhelp)
        if(ok)then
          ino=0
          if(ALOCTYP(ifoc)(1:4).eq.'SURF')ino=1
          if(ALOCTYP(ifoc)(1:4).eq.'CLDR')ino=2
          if(ALOCTYP(ifoc)(1:4).eq.'OPDR')ino=3
          if(ALOCTYP(ifoc)(1:4).eq.'CLWN')ino=4
          if(ALOCTYP(ifoc)(1:4).eq.'OPWN')ino=5
          if(ALOCTYP(ifoc)(1:4).eq.'CLGR')ino=6
          if(ALOCTYP(ifoc)(1:4).eq.'OPGR')ino=7
          if(ALOCTYP(ifoc)(1:4).eq.'DUCT')ino=8
          if(ALOCTYP(ifoc)(1:4).eq.'FANP')ino=9
          if(ALOCTYP(ifoc)(1:4).eq.'DFLT')ino=10
          if(ALOCTYP(ifoc)(1:4).eq.'IESL')ino=11
          if(ALOCTYP(ifoc)(1:4).eq.'????')ino=12
          idno=1
          call MENUATOL('Select a type for the anchor:',
     &    'Anchor type (options)','a surface (general)','b closed door',
     &    'c open(able) door','d closed window','e open(able) window',
     &    'f closed grill','g openable grill','h duct or pipe',
     &    'i fan or pump','j diffuse light','k IESNA light',
     &    'l ???',ino,idno,nbhelp)
          if(ino.eq.0)then
            goto 31
          elseif(ino.eq.1)then
            AL=ALOCLBL(ifoc)
            if(AL(1:4).eq.'unde')AL='  '
            CALL EASKS(AL,' Label for anchor: ',
     &        ' ',12,'none','anchor label',IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='SURF'
          elseif(ino.eq.2)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='closed_door'
            CALL EASKS(AL,'Label:',' ',12,'none','closed dr',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='CLDR'
          elseif(ino.eq.3)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='open_door'
            CALL EASKS(AL,'Label:',' ',12,'none','open dr ',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='OPDR'
          elseif(ino.eq.4)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='closed_windw'
            CALL EASKS(AL,'Label:',' ',12,'none','closd win',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='CLWN'
          elseif(ino.eq.5)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='open_window'
            CALL EASKS(AL,'Label:',' ',12,'none','open win',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='OPWN'
          elseif(ino.eq.6)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='closed_grill'
            CALL EASKS(AL,'Label:',' ',12,'none','closd grill',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='CLGR'
          elseif(ino.eq.7)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='open_grill'
            CALL EASKS(AL,'Label:',' ',12,'none','open grill',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='OPGR'
          elseif(ino.eq.8)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='duct'
            CALL EASKS(AL,'Label:',' ',12,'none','ductorpipe',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='DUCT'
          elseif(ino.eq.9)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='fanorpump'
            CALL EASKS(AL,'Label:',' ',12,'none','fanorpump',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='FANP'
          elseif(ino.eq.10)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='difltsrc'
            CALL EASKS(AL,'Label:',' ',12,'none','difltsrc',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='DFLT'
          elseif(ino.eq.11)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='iesltsrc'
            CALL EASKS(AL,'Label:',' ',12,'none','iesltsrc',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='IESL'
          elseif(ino.eq.11)then
            if(ALOCLBL(ifoc)(1:4).eq.'unde')AL='difltsrc_3'
            CALL EASKS(AL,'Label:',' ',12,'none','difltsrc_3',
     &        IER,nbhelp)
            ALOCLBL(ifoc)=AL
            ALOCTYP(ifoc)='DFL3'
          endif
          CALL EMKCFG('s',IER)
        endif
      elseif(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))then

C Enquire about connection identified by KEYIND.
        CALL KEYIND(MVERT,IVERT,IFOCC,IO)

C Display information about the anchors associated with connection.
        call CONXMENU(ifocc,CXITM)
        write(outs,'(a,a)') CXITM(1:lnblnk(CXITM)),
     &    ' is associated with the following anchors...'
        call edisp(iuout,outs)
        outs=' '
        foundone=.false.
        do 6 i=1,NALOC
          if(IALOC(i).gt.0)then
            do 7 j = 1,IALOC(i)
              k=lstanchr(i,j)
              if(k.eq.ifocc.and.i.gt.0)then
                foundone=.true.
                write(outs(1:12),'(a,a)') ALOCLBL(i)
                call edisp(iuout,outs)
              endif
   7        continue
          endif
   6    continue
        if(foundone)then
          call easkok(' ','De-reference link(s) to this surface?',
     &      ok,nbhelp)
          if(ok)then

C Loop through all of the anchor lists and check if any reference this
C connection. If use requests deletion, shift list (lstanchr) and
C decrement IALOC.
            do 16 i=1,NALOC
              ikk=IALOC(i)
              if(ikk.gt.0)then
                do 17 j = 1,ikk
                  k=lstanchr(i,j)
                  if(k.eq.ifocc)then
                   write(outs,'(3a)')'Dereference ',ALOCLBL(i),'?'
                    call easkok(' ',outs,okd,nbhelp)
                    if(okd)then
                      do 18 ik=j,ikk-1
                        lstanchr(i,j)=lstanchr(i,j+1)
  18                  continue
                      IALOC(i)=IALOC(i)-1
                    endif
                  endif
  17            continue
              endif
  16        continue
            goto 31
          endif
        endif
C << what additional functionality?? >>
      else
        ivert=-1
        goto 92
      endif
      ivert=-4
      goto 3

      end

C **************** anchlist 
C anchlist allows selection and list management of anchor points (a list
C of connections associated with a concept).
      subroutine anchlist(iasel,ier)
#include "building.h"
#include "model.h"
#include "help.h"

      COMMON/SPAD/MMOD,LIMIT,LIMTTY

      DIMENSION AVERT(27)
      CHARACTER AVERT*36,KEY*1
      character AL*12
      integer MVERT,IVERT ! max items and current menu item

      helpinsub='edtopol'  ! set for subroutine

      iasel=0
      ifoc=0

C Initialise connection menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
      if(NALOC.eq.0)then
        call usrmsg('Currently there are no anchors defined. ',
     &    'Begin by selecting the + option. ','W')
      endif
  31  MHEAD=3
      MCTL=4

C Debug
C      write(6,*) 'naloc mhead mctl ',naloc,mhead,mctl

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Help text.
   3  helptopic='anchor_choices'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Set menu header text.
      write(AVERT(1),'(a,i2)') '1 anchors: ',NALOC
      write(AVERT(2),'(a)')    '  ________________________________ '
      write(AVERT(3),'(a)')    '  index  label     type  links     '
      M=MHEAD
      do 5 L=1,NALOC
        M=M+1
        CALL EMKEY(L,KEY,IER)
        AVERT(M)=' '
        write(AVERT(M),'(2a,i2,5a,i3,a)') KEY,' ',L,'  ',ALOCLBL(L),
     &  ' ',ALOCTYP(L),' (',IALOC(L),' links)'
   5  continue

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.      
      AVERT(M+1)  ='  ________________________________ '
      AVERT(M+2)  ='+ add/delete an anchor             '
      AVERT(M+3)  ='? help                             '
      AVERT(M+4)  ='- exit menu                        '

C Now display the menu.
      if(mmod.eq.8)then
        CALL EMENU('  Current anchor points',AVERT,MVERT,IVERT)
      else
        CALL EMENU('  Anchor points',AVERT,MVERT,IVERT)
      endif

      if(ivert.eq.mvert)then

C Save and return. 
        if(NALOC.gt.0)CALL EMKCFG('s',IER)
        return
      elseif(ivert.eq.mvert-1)then
        helptopic='anchor_choices'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('anchor points',nbhelp,'-',0,0,IER)
      elseif(ivert.eq.mvert-2)then
        CALL EASKMBOX(' ','Anchor point options:',
     &    'add','delete','cancel',' ',' ',' ',' ',' ',II,nbhelp)
        if(II.eq.1)then
          NALOC=NALOC+1
          ino=0
          idno=3
          call MENUATOL('Select a type for the anchor:',
     &    'Anchor type (options)','a surface (general)','b closed door',
     &    'c open(able) door','d closed window','e open(able) window',
     &    'f closed grill','g openable grill','h duct or pipe',
     &    'i fan or pump','j diffuse light','k IESNA light',
     &    'l ????',ino,idno,nbhelp)
          if(ino.eq.0)then
            goto 31
          elseif(ino.eq.1)then
            AL=ALOCLBL(NALOC)
            CALL EASKS(AL,' Label for anchor: ',
     &        ' ',12,'none','anchor label',IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='SURF'
          elseif(ino.eq.2)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='closed_door'
            CALL EASKS(AL,'Label:',' ',12,'none','closed dr',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='CLDR'
          elseif(ino.eq.3)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='open_door'
            CALL EASKS(AL,'Label:',' ',12,'none','open dr ',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='OPDR'
          elseif(ino.eq.4)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='closed_windw'
            CALL EASKS(AL,'Label:',' ',12,'none','closd win',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='CLWN'
          elseif(ino.eq.5)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='open_window'
            CALL EASKS(AL,'Label:',' ',12,'none','open win',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='OPWN'
          elseif(ino.eq.6)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='closed_grill'
            CALL EASKS(AL,'Label:',' ',12,'none','closd grill',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='CLGR'
          elseif(ino.eq.7)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='open_grill'
            CALL EASKS(AL,'Label:',' ',12,'none','open grill',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='OPGR'
          elseif(ino.eq.8)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='duct'
            CALL EASKS(AL,'Label:',' ',12,'none','ductorpipe',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='DUCT'
          elseif(ino.eq.9)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='fanorpump'
            CALL EASKS(AL,'Label:',' ',12,'none','fanorpump',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='FANP'
          elseif(ino.eq.10)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='difltsrc'
            CALL EASKS(AL,'Label:',' ',12,'none','difltsrc',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='DFLT'
          elseif(ino.eq.11)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='iesltsrc'
            CALL EASKS(AL,'Label:',' ',12,'none','iesltsrc',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='IESL'
          elseif(ino.eq.11)then
            if(ALOCLBL(NALOC)(1:4).eq.'unde')AL='difltsrc_3'
            CALL EASKS(AL,'Label:',' ',12,'none','difltsrc_3',
     &        IER,nbhelp)
            ALOCLBL(NALOC)=AL
            ALOCTYP(NALOC)='DFL3'
          endif
          call usrmsg('You may now associate surfaces with this',
     &      'anchor... Begin by selecting from the list. ','W')
          iasel=NALOC
          if(NALOC.gt.0)CALL EMKCFG('s',IER)
          call anchor(iasel,ier)
          goto 31
        elseif(II.eq.2)then

C Deletion function. << to be done >>

        elseif(II.eq.3)then
          continue
        endif
        goto 31
      elseif(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))then

C Pass one back for selection and manipulation.
        iasel=ivert-MHEAD
        call anchor(iasel,ier)
        goto 31
      else
        ivert=-1
        goto 92
      endif
      ivert=-4
      goto 3

      end

C ******************** group ********************
C Defines a group of zones associated with a specific concept.

      subroutine group(ifoc,ier)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "material.h"
#include "epara.h"
#include "prj3dv.h"
#include "help.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)

C Group commons defined in model.h.
      DIMENSION VERT(35),flag(mcom)
      CHARACTER VERT*33,KEY*1,outs*124
      character flag*12
      character AZG*16
      logical found,ok,foundone,okd
      integer MVERT,IVERT ! max items and current menu item
      dimension IVALS(MCOM)

      helpinsub='group'  ! set for subroutine

C Initialise zone menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
      INPIC=0
  31  MHEAD=7
      MCTL=4
      ILEN=NCOMP
      IPACT=CREATE
      CALL EKPAGE(IPACT)

      do i = 1,ncomp
        flag(i)= '       '
      enddo

C Force redraw of zones, highlighting list.
      MODIFYVIEW=.TRUE.
      nzg=NCOMP
      if(nzg.gt.0)then
        DO I=1,nzg
          nznog(I)=I
        ENDDO
        CALL INLNST(1)
        do jj = 1,izgnumber(ifoc)
          kk=izglist(ifoc,jj)
          if(kk.ne.0)LINSTY(kk)=2
        enddo
        CALL redraw(IER)
      endif

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Help text.
   3  helptopic='group_options'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Set menu header text. Update flag string with * depending on which
C anchor set(s) is/are associated with a connection.
      write(VERT(1),'(a)') ' group data: '
      write(VERT(2),'(a)') ' ______________________________'
      write(VERT(3),'(a)') ' index  label   number of links'
      write(VERT(4),'(a,i2,3a,i2,a)') '1 ',ifoc,' ',zglbl(ifoc),
     &  ' (',izgnumber(ifoc),' links)'
      VERT(5)=             ' ______________________________'
      VERT(6)=             ' zone name         |123456789'
      VERT(7)=             '                   |group    '
      do 5 i=1,nzgroup
        if(izgnumber(i).gt.0)then
          do 4 j = 1,izgnumber(i)
            k=izglist(i,j)
            if(k.ne.0.and.i.eq.1)write(flag(k)(1:1),'(a)') '*'
            if(k.ne.0.and.i.eq.2)write(flag(k)(2:2),'(a)') '*'
            if(k.ne.0.and.i.eq.3)write(flag(k)(3:3),'(a)') '*'
            if(k.ne.0.and.i.eq.4)write(flag(k)(4:4),'(a)') '*'
            if(k.ne.0.and.i.eq.5)write(flag(k)(5:5),'(a)') '*'
            if(k.ne.0.and.i.eq.6)write(flag(k)(6:6),'(a)') '*'
            if(k.ne.0.and.i.eq.7)write(flag(k)(7:7),'(a)') '*'
            if(k.ne.0.and.i.eq.8)write(flag(k)(8:8),'(a)') '*'
            if(k.ne.0.and.i.eq.9)write(flag(k)(9:9),'(a)') '*'
            if(k.ne.0.and.i.eq.10)write(flag(k)(10:10),'(a)') '*'
            if(k.ne.0.and.i.eq.11)write(flag(k)(11:11),'(a)') '*'
            if(k.ne.0.and.i.ge.12)write(flag(k)(12:12),'(a)') '*'
   4      continue
        endif
   5  continue

C Loop through the items until the page to be displayed. M is the 
C current menu line index. Build up text strings for the menu. 
      M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          VERT(M)=' '
          WRITE(VERT(M),'(A,1x,3A)')KEY,zname(L),'   |',flag(L)
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.      
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)='  _____________________________'
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM 
   15   FORMAT   ('0 page --- Part: ',I3,' of ',I3,' ---')
      ENDIF
      VERT(M+2)  ='* add zones to current group   '
      VERT(M+3)  ='? help                         '
      VERT(M+4)  ='- exit menu                    '

C Now display the menu.
      CALL EMENU(' Groups of zones',VERT,MVERT,IVERT)

      if(ivert.eq.mvert)then

C Save and return. 
        if(nzgroup.gt.0)CALL EMKCFG('s',IER)
        return
      elseif(ivert.eq.mvert-1)then
        helptopic='group_options'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('groups-of-zones',nbhelp,'-',0,0,IER)
      elseif(ivert.eq.mvert-2)then

C Modify the list.
        if(izgnumber(ifoc).eq.0)then
          inpic = 40
        else
          inpic = 40 - izgnumber(ifoc)
        endif
        INPIC=NCOMP
        CALL EPICKS(INPIC,IVALS,' ','Associate zones:',
     &    12,NCOMP,zname,' zone list',IER,nbhelp)
        if(inpic.gt.0)then
          do ij=1,inpic

C For each item from IVALS that does not match an existing
C group item update the list.
            found=.false.
            if(izgnumber(ifoc).eq.0)then
              izgnumber(ifoc)=izgnumber(ifoc)+1
              izglist(ifoc,izgnumber(ifoc))=IVALS(ij)
            else
              do ik=1,izgnumber(ifoc)
                if(izglist(ifoc,ik).eq.IVALS(ij))found=.true.
              enddo
              if(.NOT.found)then
                izgnumber(ifoc)=izgnumber(ifoc)+1
                izglist(ifoc,izgnumber(ifoc))=IVALS(ij)
              endif
            endif
          enddo
          goto 31
        else
          call edisp(iuout,'No zones associated with group.')
        endif
        goto 31
      elseif(ivert.eq.mvert-3)then

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      elseif(ivert.eq.4)then

C Force redraw of zones, highlighting anchor list.
        MODIFYVIEW=.TRUE.
        nzg=NCOMP
        if(nzg.gt.0)then
          DO I=1,nzg
            nznog(I)=I
          ENDDO
          CALL INLNST(1)
          do jj = 1,izgnumber(ifoc)
            kk=izglist(ifoc,jj)
            if(kk.ne.0)LINSTY(kk)=2
          enddo
          CALL redraw(IER)
        endif
        call easkok(' ','Edit group name?',ok,nbhelp)
        if(ok)then
          AZG=zglbl(ifoc)
          if(AZG(1:4).eq.'unde')AZG='  '
          CALL EASKS(AZG,' Label for group-of-zones: ',
     &      ' ',16,'none','group label',IER,nbhelp)
          zglbl(ifoc)=AZG
          CALL EMKCFG('s',IER)
        endif
      elseif(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))then

C Enquire about connection identified by KEYIND.
        CALL KEYIND(MVERT,IVERT,IFOCC,IO)

C Display information about the zones.
        write(outs,'(a,a)') zname(ifocc),
     &    ' is associated with the following groups...'
        call edisp(iuout,outs)
        outs=' '
        foundone=.false.
        do 6 i=1,nzgroup
          if(izgnumber(i).gt.0)then
            do 7 j = 1,izgnumber(i)
              k=izglist(i,j)
              if(k.eq.ifocc.and.i.gt.0)then
                foundone=.true.
                write(outs(1:12),'(a)') zglbl(i)
                call edisp(iuout,outs)
              endif
   7        continue
          endif
   6    continue
        if(foundone)then
          call easkok(' ','De-reference link(s) to this zone?',
     &      ok,nbhelp)
          if(ok)then

C Loop through all of the anchor lists and check if any reference this
C connection. If use requests deletion, shift list (izglist) and
C decrement izgnumber.
            do 16 i=1,nzgroup
              ikk=izgnumber(i)
              if(ikk.gt.0)then
                do 17 j = 1,ikk
                  k=izglist(i,j)
                  if(k.eq.ifocc)then
                   write(outs,'(3a)')'Dereference ',zglbl(i),'?'
                    call easkok(' ',outs,okd,nbhelp)
                    if(okd)then
                      do 18 ik=j,ikk-1
                        izglist(i,j)=izglist(i,j+1)
  18                  continue
                      izgnumber(i)=izgnumber(i)-1
                    endif
                  endif
  17            continue
              endif
  16        continue
            goto 31
          endif
        endif
C << what additional functionality?? >>
      else
        ivert=-1
        goto 92
      endif
      ivert=-4
      goto 3

      end !of group

C **************** grouplist 
C grouplist allows selection and list management of groups-of-zones
C e.g. offices on level 3.
      subroutine grouplist(iasel,ier)
#include "building.h"
#include "model.h"
#include "epara.h"
#include "help.h"

      COMMON/SPAD/MMOD,LIMIT,LIMTTY

      DIMENSION AVERT(32)
      CHARACTER AVERT*36,KEY*1
      character AL*16
      integer MVERT,IVERT ! max items and current menu item

      helpinsub='grouplist'  ! set for subroutine

      iasel=0

C Initialise connection menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
      if(nzgroup.eq.0)then
        call usrmsg('Currently there are no groups defined. ',
     &    'Begin by selecting the + option. ','W')
      endif
  31  MHEAD=3
      MCTL=4
      ILEN=nzgroup
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Help text.
   3  helptopic='group_choices'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Set menu header text.
      write(AVERT(1),'(a,i2)') '1 groups: ',nzgroup
      write(AVERT(2),'(a)')    '  __________________________ '
      write(AVERT(3),'(a)')    '  index label     associated '
      M=MHEAD
      do 5 L=1,nzgroup
        if(L.GE.IST.AND.(L.LE.(IST+MIFULL)))then
          M=M+1
          CALL EMKEY(L,KEY,IER)
          AVERT(M)=' '
          write(AVERT(M),'(2a,i2,3a,i3,a)') KEY,' ',L,'  ',zglbl(L),
     &    ' (',izgnumber(L),' )'
        endif
   5  continue

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.      
      IF(IPFLG.EQ.0)THEN
        AVERT(M+1)='  _____________________________'
      ELSE
        WRITE(AVERT(M+1),15)IPM,MPM 
   15   FORMAT   ('0 page --- Part: ',I3,' of ',I3,' ---')
      ENDIF
      AVERT(M+2)  ='+ add/delete an group            '
      AVERT(M+3)  ='? help                           '
      AVERT(M+4)  ='- exit menu                      '

C Now display the menu.
      if(mmod.eq.8)then
        CALL EMENU('  Current groups of zones',AVERT,MVERT,IVERT)
      else
        CALL EMENU('  Groups of zones',AVERT,MVERT,IVERT)
      endif

      if(ivert.eq.mvert)then

C Save and return. 
        if(NALOC.gt.0)CALL EMKCFG('s',IER)
        return
      elseif(ivert.eq.mvert-1)then
        helptopic='group_choices'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('groups-of-zones',nbhelp,'-',0,0,IER)
      elseif(ivert.eq.mvert-2)then
        CALL EASKMBOX(' ','Group options:',
     &    'add','delete','cancel',' ',' ',' ',' ',' ',II,nbhelp)
        if(II.eq.1)then
          nzgroup=nzgroup+1
          izgnumber(nzgroup)=0
          izglist(nzgroup,1)=0
          AL=zglbl(nzgroup)
          CALL EASKS(AL,'Label for group-of-zones: ',
     &      ' ',16,'none','group label',IER,nbhelp)
          zglbl(nzgroup)=AL
          call usrmsg('You may now associate zones with this',
     &      'group... Begin by selecting from the list. ','W')
          iasel=nzgroup
          if(nzgroup.gt.0)CALL EMKCFG('s',IER)
          call group(iasel,ier)
          goto 31
        elseif(II.eq.2)then

C Deletion function. << to be done >>

        elseif(II.eq.3)then
          continue
        endif
        goto 31
      elseif(ivert.eq.mvert-3)then

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      elseif(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))then

C Pass one back for selection and manipulation.
        CALL KEYIND(MVERT,IVERT,iasel,IO)
        call group(iasel,ier)
        goto 31
      else
        ivert=-1
        goto 92
      endif
      ivert=-4
      goto 3

      end !of grouplist

C **************** easkconn 
C Select one or more connections from a list.
      subroutine easkconn(inpic,iconnpk,lconnpk,promp1,promp2,ermsg,
     &  ltype,ier,nhelp)
#include "building.h"
#include "model.h"
#include "epara.h"
      
      integer lnblnk  ! function definition

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

      DIMENSION iconnpk(lconnpk),VERT(35),flag(mcon)
      CHARACTER*(*) PROMP1,PROMP2,ERMSG
      CHARACTER VERT*54,KEY*1,CXITM*48,flag*1,SEL*50
      logical found
      integer MVERT,IVERT ! max items and current menu item
    
C At this point bring up a menu with the string alternatives, assuming
C there is more than one alternative to pick from.
      IF(lconnpk.LT.1)THEN
        CALL USRMSG(PROMP1,' Nunber of items to small.','W')
        IER=1
        RETURN
      ENDIF
      CALL USRMSG(PROMP1,PROMP2,'-')

C Initialise connection menu size variables based on window size. 
C IVERT is the menu position, MVERT the current number of menu lines.
      MHEAD=2
      MCTL=3
      ILEN=NCON
      IPACT=CREATE
      CALL EKPAGE(IPACT)
      IALLOW=INPIC

C Clear iconnpk and INPIC and, if editing an existing anchor, point
C to those items already associated.
      IER=0
      INPIC=0
      DO 40 I=1,lconnpk
        iconnpk(I)=0
   40 CONTINUE
      if(IALOC(ltype).gt.0)then
        do 42 ia=1,IALOC(ltype)
          if(lstanchr(ltype,ia).ne.0)then
            iconnpk(ia)=lstanchr(ltype,ia)
          endif
  42    continue
      endif

C If previous list being edited, marke these.
      do 2 i = 1,ncon
        flag(i)= ' '
        if(IALOC(ltype).gt.0)then
          do 41 ia=1,IALOC(ltype)
            if(lstanchr(ltype,ia).eq.i)then
              flag(i)= '*'
            endif
  41      continue
        endif
  2   continue

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Set menu header text. Update flag string with * depending on which
C items have been selected. Generate text for title.
    3 lne=LNBLNK(ERMSG)
      IF(lne.GT.50)WRITE(SEL,'(1X,A)')ERMSG(1:50)
      IF(lne.LE.50)WRITE(SEL,'(1X,A)')ERMSG(1:lne)
      VERT(1)=  ' no. | inside face     | other side data      |anchor'
      VERT(2)=  ' conn|  connection     |    connection        |select'

C Loop through the items until the page to be displayed. M is the 
C current menu line index. Build up text strings for the menu. 
      M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          call CONXMENU(L,CXITM)
          VERT(M)=' '
          WRITE(VERT(M),'(A1,1x,A,1x,a1)')KEY,CXITM(1:48),flag(L)
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.      
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)='  ________________________________________ '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM 
   15   FORMAT   ('0 page ------- Part: ',I2,' of ',I2,' -----')
      ENDIF
      VERT(M+2)  ='? help                                '
      VERT(M+3)  ='- exit menu                           '

C Now display the menu.
      CALL EMENU(sel,VERT,MVERT,IVERT)

      if(IVERT.LE.MHEAD)then

C Within the header so skip request.
        IVERT=-1
        goto 3
      elseif(ivert.eq.mvert)then
        return
      elseif(ivert.eq.mvert-1)then

C Produce help text for the menu.
        CALL PHELPD('connection pick string',NHELP,'-',0,0,IER)
      elseif(ivert.eq.mvert-2)then

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      elseif(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))then

C Mark identified by KEYIND. Increment ialoc counter and then
C instantiate iconnpk with current connection number. If item
C already selected, treat second selection as a toggle OFF.
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        FOUND=.FALSE.
        IF(INPIC.GT.0)THEN
          DO 44 J=1,INPIC
            if(iconnpk(J).EQ.IFOC)then
              FOUND=.TRUE.
              ljfoc=iconnpk(j)
              lj=j
            endif
  44      CONTINUE
          if(.NOT.FOUND)then
            INPIC=INPIC+1
            iconnpk(INPIC)=IFOC
            flag(ifoc)='*'
          else
            INPIC=INPIC-1
            iconnpk(lj)=0
            flag(ljfoc)=' '
          endif
        ELSEIF(INPIC.EQ.0)THEN
          INPIC=1
          iconnpk(INPIC)=IFOC
          flag(ifoc)='*'
        ENDIF
        IF(INPIC.EQ.IALLOW)THEN

C Have picked as many as are allowed.
          RETURN
        ELSE
          IVERT=-2
          goto 3
        ENDIF
      else
        ivert=-1
        goto 92
      endif
      ivert=-4
      goto 3

      end

C ******** serchrpl
C Serchrpl handles search and replace of composition attributes.
C In the case of construction search/replace (act='c') it also manages
C updating construction attributes in adjacent zones in the case
C of non-symetric constructions. If act='a' then filters can be
C applied e.g. orientation, transpareny. If act='p' then use
C predefined indices for MLC search and replace and which also
C will have additional information if searched-for MLC is linked
C to a reversed version.
      subroutine serchrpl(act,itrc,ier)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "material.h"
#include "prj3dv.h"
#include "help.h"
      
      integer lnblnk  ! function definition

      COMMON/FILEP/IFIL
      common/OUTIN/IUOUT,IUIN,IEOUT
      
      integer ncomp,ncon
      common/C1/NCOMP,NCON
      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)

C Variables in common from eddb.F specifying the index of search
C and replace MLC indices.
      common/srmlc/imlcsearch,imlcreplace,imlcosearh,imlcoreplace

      logical OK,QUIET,apply
      logical newgeo  ! to use for testing if new/old geometry file.
      logical showother ! true if partition true if other zone
      logical updoth ! true if other zone needs construction updated
      integer iissmlci ! for use in testing adjacent MLC
      logical modmlc   ! and for selecting MLC

      dimension IVALS(MCOM)
C     dimension PELV(MS)

      character LTMP*72
      character ZN*12,outs*124,outsl*148,SN*12
      character TOSMLCN*32  ! to remember other side mlc name
      character TOOPT*24    ! to remember other side optics
      character DESCRC*25,act*1
      character AL1*12,AL2*12,AL3*12,AL4*12,AL5*12,AL6*12,AL7*12
      character AL8*12,AL9*12,CXITM*48
      character sbound_ty*12,sbound_c2*6,sbound_e2*6
      integer ltype,ins2,ins3   ! for radio buttons

      helpinsub='edtopol'  ! set for subroutine

      iuf=IFIL+1
      newgeo=.false.  ! assume older format geometry.
      iissmlci=0
      if(act.eq.'c'.or.act.eq.'p')then
        if(act.eq.'p')then
          ins9=1
        else
          helptopic='search_constructions'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('global attributions',nbhelp,'-',0,0,IER)
          if(NALOC.gt.0)then
            CALL EASKMBOX(' Surfaces to update:',' ',
     &        'which match a construction','linked with an anchor',
     &        'cancel',' ',' ',' ',' ',' ',ins9,nbhelp)
          else
            ins9=1
          endif
        endif
        if(ins9.eq.1)then

C Search and replace by finding matching constructions. In the case of
C a MLC which is paired also scan for linked MLC.
          if(act.eq.'p')then
            if(imlcsearch.gt.0.and.imlcreplace.gt.0)then
              ISEL=imlcsearch
              ISELR=imlcreplace
              ISELO=imlcosearh
              ISELOR=imlcoreplace
            else
              call edisp(iuout,
     &          'Search are replace MLC indices have not been set.')
              return
            endif
          else

C << TODO add logic to deal with MLC which has a linked reversed version. >>
            ISELO=0
            ISELOR=0
            if(mlcver.eq.0)then
              CALL EPKMLC(ISEL,'Select a construction to SEARCH for',
     &        'or -Exit',IER)
            else
              call edisp(iuout,'Select a construction to SEARCH for')
              CALL EDMLDB2(modmlc,'-',ISEL,IER)
            endif
            if(ISEL.eq.0)return
            if(mlcver.eq.0)then
              CALL EPKMLC(ISELR,'Select a construction to REPLACE it',
     &        'with or -Exit',IER)
            else
              call edisp(iuout,'Select a construction to REPLACE it')
              CALL EDMLDB2(modmlc,'-',ISELR,IER)
            endif
            if(ISELR.eq.0)return

C If searched MLC is linked to another MLC that also should be searched for.
C ISELO is the other MLC to search for and ISELOR is its replacement.
            if(matsymindex(isel).gt.0)then
              ISELO=matsymindex(isel)
            endif
            if(matsymindex(iselr).gt.0)then
              ISELOR=matsymindex(iselr)
            endif
          endif
          if(act.eq.'p')then
            INPIC=NCOMP
            do ij=1,NCOMP
              ivals(ij)=ij
            enddo
          else
            INPIC=NCOMP
            CALL EPICKS(INPIC,IVALS,' ',' Search zones:',
     &        12,NCOMP,zname,' zone list',IER,nbhelp)
            IF(INPIC.EQ.0)return
          endif

C For each of the selected zones (which might not include the other side
C zone of all partitions in the zone we are dealing with), read the zone
C geometry file, update the attribute and save changes to the zone file.
          DO 96 IZ=1,INPIC
            izz=IVALS(IZ)
            if(izz.eq.0) cycle
            write(zn,'(A)') zname(IZZ)
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &         ' attributes...'
            CALL USRMSG(' ',outs,'-')
            LTMP=LGEOM(IZZ)
            call georead(IUF,LTMP,IZZ,1,iuout,IER)

C Also check for obstructions and visual entities.
            if(iobs(izz).eq.2)then   ! Also check obstructions.
              if(nbobs(izz).gt.0)then
                do nbo=1,nbobs(izz)
                  lnsmlcn=lnblnk(BLOCKMAT(izz,nbo))
                  if(mlcname(isel)(1:lnmlcname(ISEL)).eq.
     &               BLOCKMAT(izz,nbo)(1:lnsmlcn))then
                    write(BLOCKMAT(izz,nbo),'(a)') mlcname(ISELR)
                  endif
                enddo
              endif
            endif
            if(nbvis(izz).gt.0)then  ! And visual entities.
              do nbv = 1,nbvis(izz)
                lnsmlcn=lnblnk(VISMAT(izz,nbv))
                if(mlcname(isel)(1:lnmlcname(ISEL)).eq.
     &             VISMAT(izz,nbv)(1:lnsmlcn))then
                  write(VISMAT(izz,nbv),'(a)') mlcname(ISELR)
                endif
              enddo
            endif

C And if non-zero scan for linked MLC to replace.
            if(ISELO.gt.0.and.ISELOR.gt.0)then
              if(iobs(izz).eq.2)then   ! Also check obstructions.
                if(nbobs(iz).gt.0)then
                  do nbo=1,nbobs(izz)
                    lnsmlcn=lnblnk(BLOCKMAT(izz,nbo))
                    if(mlcname(iselo)(1:lnmlcname(iselo)).eq.
     &                 BLOCKMAT(izz,nbo)(1:lnsmlcn))then
                      write(BLOCKMAT(izz,nbo),'(a)') mlcname(ISELOR)
                    endif
                  enddo
                endif
              endif
              if(nbvis(izz).gt.0)then  ! And visual entities.
                do nbv = 1,nbvis(izz)
                  lnsmlcn=lnblnk(VISMAT(izz,nbv))
                  if(mlcname(iselo)(1:lnmlcname(ISELO)).eq.
     &               VISMAT(izz,nbv)(1:lnsmlcn))then
                    write(VISMAT(izz,nbv),'(a)') mlcname(ISELOR)
                  endif
                enddo
              endif
            endif

C Loop through surfaces in the zone and report on which ones match.
C Depending on values of ISEL, ISELR ISELO ISELOR set ifoc and ifocr
C indices for find and replace.
            do 91 i=1,nsur
              ifoc=0
              lnssmlc=lnblnk(SMLCN(IZZ,i))
              if(ISELO.gt.0.and.ISELOR.gt.0)then
                if(SMLCN(IZZ,i)(1:lnssmlc).eq.
     &             mlcname(ISELO)(1:lnmlcname(ISELO)))then
                  ifoc=iselo; ifocr=iselor
                elseif(SMLCN(IZZ,i)(1:lnssmlc).eq.
     &             mlcname(ISEL)(1:lnmlcname(ISEL)))then
                  ifoc=isel; ifocr=iselr
                endif
              else 
                if(SMLCN(IZZ,i)(1:lnssmlc).eq.
     &             mlcname(ISEL)(1:lnmlcname(ISEL)))then
                  ifoc=isel; ifocr=iselr
                endif
              endif
              if(ifoc.eq.0) cycle

C A substitution is warranted.
              call decode_zsbound(izz,i,sbound_ty,sbound_c2,sbound_e2)
              write(sn,'(a)') SNAME(IZZ,i)
              lnsn=lnblnk(SN)
              lnso=lnblnk(sbound_ty)
              lnotf=lnblnk(SOTF(izz,i))
              WRITE(outsl,'(3a,F7.2,a,F5.0,a,F5.0,1X,2A,1X,2A,
     &          1X,2A,1X,2A)')'Match: ',sn(1:lnsn),' area=',SNA(IZZ,i),
     &          ' azi=',SPAZI(IZZ,i),' elv=',SPELV(IZZ,i),
     &          ' optics ',SOTF(IZZ,i)(1:lnotf),
     &          ' loc= ',SVFC(IZZ,i),' MLC= ',SMLCN(IZZ,i)(1:lnssmlc),
     &          ' other= ',sbound_ty(1:lnso)
              call edisp(iuout,outsl)
              write(outs,'(5a)') 'Apply construction to ',
     &          zn(1:lnblnk(zn)),':',sn(1:lnblnk(sn)),'?'
              CALL EASKOK(' ',outs,OK,nbhelp)
              IF(OK)then

C If the user agrees update the construction attributes.
                ioc=IZSTOCN(IZZ,i)
                write(SN,'(a12)') SNAME(IZZ,i)
                if(ICT(ioc).eq.3)then  ! detect partition
                  showother=.true.
                  icoth=IZSTOCN(IC2(ioc),IE2(ioc))
                else
                  showother=.false.
                  icoth=0
                endif
                WRITE(SMLCN(IZZ,i),'(A)') mlcname(ifocr)
                smlcindex(IZZ,i)=ifocr       ! update array

C Update the optical name.
                IF(mlctype(ifocr)(1:4).EQ.'OPAQ')then
                  SOTF(IZZ,i)='OPAQUE'
                ELSEIF(mlctype(ifocr)(1:4).EQ.'CFC ')then
                  SOTF(IZZ,i)='CFC '
                ELSEIF(mlctype(ifocr)(1:4).EQ.'CFC2')then
                  SOTF(IZZ,i)='CFC2'
                ELSE
                  WRITE(SOTF(IZZ,i),'(A)') mlcoptical(ifocr)
                ENDIF

C Save this surface attribute change to current geometry file.
                call eclose(gversion(IZZ),1.1,0.01,newgeo)
                if(igupgrade.eq.2.and.(.NOT.newgeo))then
                  gversion(IZZ) =1.1
                  newgeo = .true.
                endif
                if(newgeo)then
                  call geowrite2(IUF,LTMP,IZZ,iuout,3,IER)
                else
                  call emkgeo(IUF,LTMP,IZZ,3,IER)
                endif

C Source code pattern in edgeo.F near line 1080 included so that
C the other side construction is also dealt with if required.
C << SOMETHING rotten here. >>
                if(showother.and.icoth.ne.0.and.
     &             smlcindex(IZZ,i).ne.0)then
                  ii=smlcindex(IZZ,i)          ! the newly updated MLC index
                  lnopt=lnblnk(mlcoptical(ii))
                  updoth=.false.
                  if(mlcsymetric(ii)(1:9).EQ.'SYMMETRIC')then
                    lnssmlc=lnblnk(SMLCN(IC2(ioc),IE2(ioc)))
                    if(SMLCN(IC2(ioc),IE2(ioc))(1:lnssmlc).eq.
     &                 mlcname(ii)(1:lnmlcname(ii)))then
                      TOSMLCN= mlcname(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                    elseif(SMLCN(IC2(ioc),IE2(ioc))(1:4).eq.
     &                     'UNKN')then
                      TOSMLCN= mlcname(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                      updoth=.true.
                    else
                      TOSMLCN= mlcname(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                      updoth=.true.
                    endif
                    iissmlci=ii
                  elseif(mlcsymetric(ii)(1:12).EQ.
     &                   'NONSYMMETRIC')then

C If the current construction is marked as nonsymmetric then it has not
C been linked to a revered MLC - inform the user.
                    lnsmlcn=lnblnk(SMLCN(IZZ,i))
                    write(outs,'(5a)') 'Surface ',SN(1:lnblnk(SN)),
     &                ' has a nonsymmetric construction ',
     &                SMLCN(IZZ,i)(1:lnsmlcn),'.'
                    call edisp(iuout,outs)
                    lnsmlcn=lnblnk(SMLCN(IC2(ioc),IE2(ioc)))
                    write(outs,'(5a)') 'It faces ',
     &                SNAME(IC2(ioc),IE2(ioc)),' composed of ',
     &                SMLCN(IC2(ioc),IE2(ioc))(1:lnsmlcn),
     &                ' (which may not match).'
                    call edisp(iuout,outs)
                    write(outs,'(2a)')
     &              'Please check that one construction has inverted ',
     &              'layers or revise the common constructions.'
                    call edisp(iuout,outs)
                    if(SMLCN(IC2(ioc),IE2(ioc))(1:4).eq.'UNKN')then
                      TOSMLCN= mlcname(ii)  ! replace UNKNOWN
                      iissmlci=smlcindex(IZZ,i)
                      updoth=.true.
                    else
                      TOSMLCN= SMLCN(IC2(ioc),IE2(ioc))
                      iissmlci=smlcindex(IC2(ioc),IE2(ioc))  ! leave it alone
                      updoth=.false.
                    endif
                  else

C We have a non-symmetric MLC which does point to a reversed version
C so check to see if the name of the other MLC matches mlcsymetric.
                    lnsmlcn=lnblnk(SMLCN(IC2(ioc),IE2(ioc)))
                    if(SMLCN(IC2(ioc),IE2(ioc))(1:4).eq.'UNKN')then
                      TOSMLCN= mlcsymetric(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                      updoth=.true.
                    elseif(SMLCN(IC2(ioc),IE2(ioc))(1:lnsmlcn).eq.
     &                     mlcsymetric(ii)(1:lnsmlcn))then
                      TOSMLCN= mlcsymetric(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                    else
                      TOSMLCN= mlcsymetric(ii)
                      write(TOOPT,'(a)') mlcoptical(ii)(1:lnopt)
                      updoth=.true.
                    endif
                    iissmlci=matsymindex(ii)  ! use returned value
                  endif
                  if(updoth)then

C First backup the current zones data before reading in the other
C zone.
                    CALL ESCZONE(IZZ)
                    lnicoth=lnblnk(SMLCN(IC2(ioc),IE2(ioc)))
                    write(outs,'(6a)') 
     &                'Updating `other side` composition of ',
     &                SN(1:lnblnk(SN)),' from ',
     &                SMLCN(IC2(ioc),IE2(ioc))(1:lnicoth),
     &                ' > ',TOSMLCN
                    if(SMLCN(IC2(ioc),IE2(ioc))(1:lnicoth).ne.
     &                 TOSMLCN(1:lnblnk(TOSMLCN)))then
                      call edisp(iuout,outs)
                    endif
                    call eclose(gversion(IC2(ioc)),1.1,0.01,newgeo)
                    if(newgeo)then
                      call georead(IFIL+2,LGEOM(IC2(ioc)),IC2(ioc),
     &                  0,iuout,IER)
                    else
                      call egomin(IFIL+2,LGEOM(IC2(ioc)),IC2(ioc),
     &                  0,0,iuout,IER)
                    endif

C Assign new MLC name to the icoth surface as well as SOTF with the
C optical properties and MLC index from material.h commons.
                    SMLCN(IC2(ioc),IE2(ioc))=TOSMLCN
                    if(iissmlci.ne.0)then
                       smlcindex(IC2(ioc),IE2(ioc))=iissmlci  ! update
                    endif
                    write(SOTF(IC2(ioc),IE2(ioc)),'(a)')
     &                TOOPT(1:lnblnk(TOOPT))

C Logic to decide whether to update other zone geometry format.
                    call eclose(gversion(IC2(ioc)),1.1,0.01,newgeo)
                    if(igupgrade.eq.2.and.(.NOT.newgeo))then
                      gversion(IC2(ioc)) =1.1
                      newgeo = .true.
                    endif
                    if(newgeo)then
                      call geowrite2(IFIL+2,LGEOM(IC2(ioc)),IC2(ioc),
     &                  iuout,3,IER)
                    else
                      call emkgeo(IFIL+2,LGEOM(IC2(ioc)),IC2(ioc),
     &                  3,IER)
                    endif
                    IF(IER.NE.0)CALL USRMSG(
     &                'Problem updating other surface attribute... ',
     &                '(could not write other geometry file).','W')

C Read current zone data back in to commons. But the backed up data
C might not include the name of the newly selected mlc name so just
C to be sure reset smlcn with smlcn so it will show up in the menu
C when it is re-freshed.
                    CALL ERCZONE(IZZ)
                    SOTF(IZZ,i)=SOTF(IC2(ioc),IE2(ioc))
                    call usrmsg(' Updating other side...done.',
     &                  ' ','-')
                    updoth=.false.
                  endif
                endif
              endif
 91         continue


C Having pass through all of the relevant surfaces in this zone update
C the zone construction file. Re-open focus geometry file and write out
C focus zone construction files.
            LTMP=LGEOM(IZZ)
            call georead(IUF,LTMP,IZZ,1,iuout,IER)
            QUIET=.TRUE.
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &         ' constructions...'
            CALL USRMSG(' ',outs,'P')
            CALL EDCON(0,ITRU,IZZ,QUIET,IER)
            QUIET=.FALSE.
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &        '... done.'
            CALL USRMSG(' ',outs,'-')
  96      continue
          MODIFYVIEW=.TRUE.
          MODBND=.TRUE.

C ?? what about smlcindex as in edcfg.F 2036 ??

        elseif(ins9.eq.2)then

C Anchor point substitution.
          AL1=ALOCLBL(1)
          AL2=ALOCLBL(2)
          AL3=ALOCLBL(3)
          AL4=ALOCLBL(4)
          AL5=ALOCLBL(5)
          ltype=1
          CALL easkmbox(' ','Which anchor point:',AL1,AL2,AL3,AL4,AL5,
     &      'another','cancel',' ',ltype,nbhelp)
          if(ltype.eq.7)then
            call usrmsg('No anchor selected.',' ','W')
            return
          elseif(ltype.eq.6)then
            AL6=ALOCLBL(6)
            AL7=ALOCLBL(7)
            AL8=ALOCLBL(8)
            AL9=ALOCLBL(9)
            ltype=1
            CALL easkmbox(' ','Which anchor point:',AL6,AL7,AL8,AL9,
     &        'cancel',' ',' ',' ',ltype,nbhelp)
            if(ltype.gt.4)then
              call usrmsg('No anchor selected.',' ','W')
              return
            else
              ltype=ltype+5
            endif
          endif
          if(mlcver.eq.0)then
            CALL EPKMLC(ISELR,'Select a construction to use with this',
     &      'surface list or -Exit',IER)
          else
            call edisp(iuout,'Select a construction to use with list')
            CALL EDMLDB2(modmlc,'-',ISELR,IER)
          endif
          if(ISELR.eq.0)return
          CALL EASKOK(' ','Apply this construction?',OK,nbhelp)
          IF(.NOT.OK)return
          do 2243 j=1,IALOC(ltype)
            ifoc=lstanchr(ltype,j)
            call CONXMENU(ifoc,CXITM)
            call usrmsg(' Processing...',CXITM,'-')
            iz=ic1(ifoc)
            is=ie1(ifoc)
            LTMP=LGEOM(IZ)
            call georead(IUF,LTMP,IZ,1,iuout,IER)
            WRITE(SMLCN(iz,is),'(A)') mlcname(ISELR)

C << this is a place to update smlcindex? >>

            IF(mlctype(ISELR)(1:4).NE.'OPAQ')SOTF(iz,is)='TRAN'
            IF(mlctype(ISELR)(1:4).EQ.'OPAQ')SOTF(iz,is)='OPAQUE'
            IF(mlctype(ISELR)(1:4).EQ.'CFC ')SOTF(iz,is)='CFC '
            IF(mlctype(ISELR)(1:4).EQ.'CFC2')SOTF(iz,is)='CFC2'
            call eclose(gversion(IZ),1.1,0.01,newgeo)
            if(igupgrade.eq.2.and.(.NOT.newgeo))then
              gversion(iz) =1.1
              newgeo = .true.
            endif
            if(newgeo)then
              call geowrite2(IUF,LTMP,IZ,iuout,3,IER)
            else
              call emkgeo(IUF,LTMP,IZ,3,IER)
            endif
 2243     continue
          QUIET=.FALSE.
          CALL EASKOK(' ',
     &         'Update construction & related files?',QUIET,nbhelp)
          if(.NOT.QUIET)return
          DO 2492,IZ=1,NCOMP
            CALL EDCON(0,ITRU,IZ,QUIET,IER)
 2492     CONTINUE
          QUIET=.FALSE.
        endif
      elseif(act.eq.'a')then
        helptopic='search_constructions'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('global attributions',nbhelp,'-',0,0,IER)

        if(mlcver.eq.0)then
          CALL EPKMLC(ISEL,'Select construction for matching surfaces',
     &    'or -Exit',IER)
        else
          call edisp(iuout,
     &    'Select a construction for matching surfaces.')
          CALL EDMLDB2(modmlc,'-',ISEL,IER)
        endif
        if(ISEL.eq.0)return

        CALL EASKMBOX(' First filter--surface opacity:',' ',
     &    'opaque','transparent','both','cancel',
     &    ' ',' ',' ',' ',ins1,nbhelp)
        if(ins1.eq.4)return

        ins2=1
        call EASKMBOX(' Second filter--surface contiguity:',' ',
     &      'external','similar','constant','partitions','ground',
     &      'adiabatic','cancel',' ',ins2,nbhelp)
        if(ins2.eq.7)then
          return
        endif

        ins3=1
        call EASKMBOX(' Third filter--surface orientation:',' ',
     &      'vertical','sloped','horizontal up','horizontal down',
     &      'any horizontal','any orien.','cancel',' ',ins3,nbhelp)
        if(ins3.eq.7)then
          return
        endif

        CALL EASKMBOX(' Surfaces to update:',' ',
     &    'those already attributed','those marked UNKNOWN','both',
     &    'cancel',' ',' ',' ',' ',ins4,nbhelp)
        if(ins4.eq.4)then
          return
        endif

        INPIC=NCOMP
        CALL EPICKS(INPIC,IVALS,' ',' Which zones to update: ',
     &      12,NCOMP,zname,' zone list',IER,nbhelp)
        IF(INPIC.EQ.0)return
        DO 95 IZ=1,INPIC
          IF(IVALS(IZ).GT.0)THEN
            write(zn,'(A)') zname(IVALS(IZ))
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &         '...'
            CALL USRMSG(' ',outs,'-')
            LTMP=LGEOM(IVALS(IZ))
            call georead(IUF,LTMP,IVALS(IZ),1,iuout,IER)

            WRITE(outs,93)
   93       FORMAT('          Surface|  Area  |Azim|Elev|geometry',
     &             '| multilayer  |environment')
            call edisp(iuout,outs)
            WRITE(outs,94)
   94       FORMAT('                 |  m^2   |deg |deg |type|loc',
     &             '| constr name |other side ')
            call edisp(iuout,outs)
            do 11 i=1,nsur
              apply=.true.
              if(ins1.eq.1.and.SOTF(ivals(iz),i)(1:4).ne.'OPAQ'.and.
     &            SOTF(ivals(iz),i)(1:4).ne.'CFC '.and.
     &            SOTF(ivals(iz),i)(1:4).ne.'CFC2')apply=.false.
              if(ins1.eq.2.and.SOTF(ivals(iz),i)(1:4).eq.'OPAQ')
     &          apply=.false.

C Determine the match in the system topology. 
              CALL SURADJ(IVALS(IZ),I,IE,TMP,IZC,ISC,IC,DESCRC)
              if(ins2.eq.1.and.IE.ne.0)then
                apply=.false.
              elseif(ins2.eq.2.and.IE.ne.1)then
                apply=.false.
              elseif(ins2.eq.3.and.IE.ne.2)then
                apply=.false.
              elseif(ins2.eq.4.and.IE.ne.3)then
                apply=.false.
              elseif(ins2.eq.5.and.IE.ne.4)then
                apply=.false.
              elseif(ins2.eq.6.and.IE.ne.5)then
                apply=.false.
              endif

C Orientation check.
C 'vertical','sloped','horizontal up','horizontal down',
C 'any horizontal','any orien.','cancel'.
              if(ins3.eq.1.and.SVFC(ivals(iz),i)(1:4).ne.'VERT')then
                apply=.false.
              elseif(ins3.eq.2.and.SVFC(ivals(iz),i)(1:4).ne.'SLOP')then
                apply=.false.
              elseif(ins3.eq.3.and.SVFC(ivals(iz),i)(1:4).ne.'CEIL')then
                apply=.false.
              elseif(ins3.eq.4.and.SVFC(ivals(iz),i)(1:4).ne.'FLOR')then
                apply=.false.
              elseif(
     &          (ins3.eq.5.and.SVFC(ivals(iz),i)(1:4).eq.'FLOR').or.
     &          (ins3.eq.5.and.SVFC(ivals(iz),i)(1:4).eq.'CEIL'))then
                continue
              elseif(ins3.eq.6)then
                continue
              endif

              if(ins4.eq.2.and.SMLCN(ivals(iz),i)(1:4).ne.
     &          'UNKN')apply=.false.

              call decode_zsbound(ivals(iz),i,sbound_ty,sbound_c2,
     &          sbound_e2)
              if(apply)then
                write(sn,'(a)') SNAME(ivals(iz),i)
                lnsmlcn=lnblnk(SMLCN(ivals(iz),i))
                WRITE(outs,'(a7,I3,1X,F7.2,F5.0,F5.0,1X,A,1X,A,
     &            1X,A,1X,A,1X,A)')'Match: ',I,SNA(ivals(iz),i),
     &            SPAZI(ivals(iz),i),SPELV(ivals(iz),i),SN,
     &            SOTF(ivals(iz),i)(1:4),
     &            SVFC(ivals(iz),i),SMLCN(ivals(iz),i)(1:lnsmlcn),
     &            sbound_ty(1:12)
                call edisp(iuout,outs)
                write(outs,'(5a)') 'Apply construction to ',
     &            zn(1:lnblnk(zn)),':',sn(1:lnblnk(sn)),'?'
                CALL EASKOK(' ',outs,OK,nbhelp)
                IF(OK)then
                  ioc=IZSTOCN(IVALS(IZ),i)
                  WRITE(SMLCN(IVALS(IZ),i),'(A)') mlcname(ISEL)

C << this is a place to update smlcindex? >>

                  IF(mlctype(ISEL)(1:4).NE.'OPAQ')SOTF(IVALS(IZ),i)=
     &              'TRAN'
                  IF(mlctype(ISEL)(1:4).EQ.'OPAQ')SOTF(IVALS(IZ),i)=
     &              'OPAQ'
                  IF(mlctype(ISEL)(1:4).EQ.'CFC ')SOTF(IVALS(IZ),i)=
     &              'CFC '
                  IF(mlctype(ISEL)(1:4).EQ.'CFC2')SOTF(IVALS(IZ),i)=
     &              'CFC2'
                endif
              endif
 11         continue
            call eclose(gversion(IVALS(IZ)),1.1,0.01,newgeo)
            if(igupgrade.eq.2.and.(.NOT.newgeo))then
              gversion(IVALS(IZ)) =1.1
              newgeo = .true.
            endif
            if(newgeo)then
              call geowrite2(IUF,LTMP,IVALS(IZ),ITRU,3,IER)
            else
              call emkgeo(IUF,LTMP,IVALS(IZ),3,IER)
            endif
            QUIET=.TRUE.
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &         'constructions...'
            CALL USRMSG(' ',outs,'P')
            CALL EDCON(0,ITRU,IVALS(IZ),QUIET,IER)
            QUIET=.FALSE.
            write(outs,'(3a)') ' Updating: ',zn(1:lnblnk(zn)),
     &        '... done.'
            CALL USRMSG(' ',outs,'-')
          endif
  95    continue
        MODIFYVIEW=.TRUE.
        MODBND=.TRUE.
      else
        call usrmsg('Unknown action...returning. ',' ','P')
      endif
      return

      end

C ******************** ZPCONXINF ********************
C Returns a description in CXSTR of the inter-connection 
C information based on geometric prescan common blocks.
C If ICF=1 then display with zone and surface names. If
C ICON=0 then generate a text heading.

      SUBROUTINE ZPCONXINF(ICF,ICON,CXSTR)
#include "building.h"
#include "geometry.h"

      integer itznb  ! test count of zones
      integer itncon ! test count of connections.
      integer itIC1,itIE1,itICT,itIC2,itIE2 ! tests of
      common/itcnn/itznb,itncon,itIC1(MCON),itIE1(MCON),itICT(MCON),
     &  itIC2(MCON),itIE2(MCON)
      
      CHARACTER CXSTR*78,SST1*12,ZST1*12,SST2*12,ZST2*12
      integer lnblnk  ! function definition

      IF(ICON.EQ.0.AND.ICF.GT.0)THEN
        WRITE(CXSTR,8986)  
 8986   FORMAT('Con   Origin surface               Other side')    
        RETURN
      ENDIF

C Trap out of range itIC1 and itIE1 variables.
      if(itIC1(ICON).EQ.0)then
        CXSTR='  '
        RETURN
      endif
      if(itIE1(ICON).EQ.0)then
        CXSTR='  '
        RETURN
      endif

      SST1=SNAME(itIC1(icon),itIE1(icon))
      lsn1=lnblnk(SST1)
      ZST1=ZNAME(itIC1(ICON))
      lzn1=lnblnk(ZST1)
      IF(itICT(ICON).EQ.-1.AND.ICF.GT.0)THEN
        WRITE(CXSTR,7985)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 7985   FORMAT(I4,1X,a,' in ',a,' not yet defined')
      ELSEIF(itICT(ICON).EQ.0.AND.ICF.GT.0)THEN
        WRITE(CXSTR,8985)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 8985   FORMAT(I4,1X,a,' in ',a,' is External')
      ELSEIF(itICT(ICON).EQ.1.AND.ICF.GT.0)THEN
        if(itIC2(ICON).eq.0.and.itIE2(ICON).eq.0)then
          WRITE(CXSTR,8984)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 8984     FORMAT(I4,1X,a,' in ',a,' to Identical environment ')
        else
          WRITE(CXSTR,8987)ICON,SST1(1:lsn1),
     &      ZST1(1:lzn1),itIC2(ICON),itIE2(ICON)
 8987     FORMAT(I4,1X,a,' in ',a,' to Similar +-',i3,'C & ',
     &      I4,' W rad')
        endif
      ELSEIF(itICT(ICON).EQ.2.AND.ICF.GT.0)THEN
        WRITE(CXSTR,8983)ICON,SST1(1:lsn1),ZST1(1:lzn1),
     &                   itIC2(ICON),itIE2(ICON)
 8983   FORMAT(I4,1X,a,' in ',a,' is Constant @',I3,' C & ',
     &         I4,' W rad')
      ELSEIF(itICT(ICON).EQ.3.AND.ICF.GT.0)THEN
        if(itIC2(ICON).gt.0.and.itIE2(ICON).gt.0)then
          SST2=SNAME(itIC2(ICON),itIE2(ICON))
          lsn2=lnblnk(SST2)
          ZST2=zname(itIC2(ICON))
          lzn2=lnblnk(ZST2)
        else
          SST2='not_known'
          lsn2=lnblnk(SST2)
          ZST2='not_known'
          lzn2=lnblnk(ZST2)
        endif
        WRITE(CXSTR,8982)ICON,SST1(1:lsn1),ZST1(1:lzn1),
     &                        SST2(1:lsn2),ZST2(1:lzn2)
 8982   FORMAT(I4,1X,a,' in ',a,' to ',a,' in ',a)
      ELSEIF(itICT(ICON).EQ.4.AND.ICF.GT.0)THEN
        IF(itIC2(ICON).GT.0)THEN
          WRITE(CXSTR,8981)ICON,SST1(1:lsn1),
     &                     ZST1(1:lzn1),itIC2(ICON)
 8981     FORMAT(I4,1X,a,' in ',a,' to ground profile',I2)
        ELSEIF(itIC2(ICON).EQ.-3)THEN
          WRITE(CXSTR,8998)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 8998     FORMAT(I4,1X,a,' in ',a,' to 3D ground model')
        ELSE
          WRITE(CXSTR,8980)ICON,SST1(1:lsn1),
     &                     ZST1(1:lzn1),itIE2(ICON)
 8980     FORMAT(I4,1X,a,' in ',a,
     &         ' to user def ground profile',I2)
        ENDIF
      ELSEIF(itICT(ICON).EQ.5.AND.ICF.GT.0)THEN
        WRITE(CXSTR,7984)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 7984   FORMAT(I4,1X,a,' in ',a,' is adiabatic')

      ELSEIF(itICT(ICON).EQ.6.AND.ICF.GT.0)THEN
        WRITE(CXSTR,7986)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 7986   FORMAT(I4,1X,a,' in ',a,' is BASESIMP fndtn')

      ELSEIF(itICT(ICON).EQ.7.AND.ICF.GT.0)THEN

        if(itIC2(ICON).eq.0.and.itIE2(ICON).eq.0)then
          WRITE(CXSTR,9984)ICON,SST1(1:lsn1),ZST1(1:lzn1)
 9984     FORMAT(I4,1X,a,' in ',a,' is Identical CEN 13791   ')
        else
          WRITE(CXSTR,9987)ICON,SST1(1:lsn1),
     &      ZST1(1:lzn1),itIC2(ICON),itIE2(ICON)
 9987     FORMAT(I4,1X,a,' in ',a,' is CEN13791+-',i3,'dC & ',
     &      I4,' W rad')
        endif
      ENDIF

      RETURN
      END

