C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file contains the following subroutines.
C  EDSITE - edits site/general information for system configuration file
C  Roaming - manages data associated with rotating a model as a
C            function of time.
C  manageimages - allows the user to manage images associated with
C            a model.
C  Setuptemporal - coordinates access to and initial creation of
C                 temporal data to be associated with a model.
C  PECONV - conversion factors for primary energy units.
C  Calenmanage - sets up and manages a calendar for ESP-r.
C  Calenprint - displays a calendar for year iyear (or a few months)
C  EDDGTP - sets up ground temperature profiles
C  EDDSHD - sets up shading and insolation files

C ******************** EDSITE ********************
C Edits site/general information for a system configuration file.
C ITRU unit number for user output, IER=0 indicates no error.

      SUBROUTINE EDSITE(ITRC,IER)

#include "building.h"
#include "model.h"
#include "site.h"
#include "geometry.h"
#include "net_flow.h"
#include "sbem.h"
#include "ipvdata.h"
#include "help.h"

      integer lnblnk  ! function definition
      integer igraphiclib  ! external definition
      integer iCountWords

      COMMON/FILEP/IFIL
      common/OUTIN/IUOUT,IUIN,IEOUT

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      COMMON/SET1/IYEAR,IBDOY,IEDOY,IFDAY,IFTIME
      common/PREC8/SLAT,SLON
      common/deflt4/dinstpath
      character dinstpath*60  ! location of Modish.pm
      common/user/browse

C IPV description via ipvdata.h. If within cfg file then the file
C name is replaced with 'internal'.
      character lipvdatf*72
      common/IPVF/lipvdatf

C CPCALC description
      common/CPCALC/icpcon,ble,bwi,bhi,blox,bloy,bloz,orient,irt,ra,
     &              sbh,pad,wvpe

C Variables for weekdays, and weekends.
C Assume: Mon=1, Tue=2, Wed=3, Thu=4, Fri=5, Sat=6, Sun=7
      common/wkdtyp/idwe1,idwe2,wkd1,wkd2


      COMMON/LongRad/iExtLgRadFlag,eGrdTp(12)
      INTEGER iExtLgRadFlag
      REAL eGrdTp

      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton
      COMMON/GTFIL/GTGEOM
      COMMON/GT/GTNAME

C Calendar.
      common/caleni/nbdaytype,nbcaldays(MDTY),icalender(365)

C iSlr_half_hr_flg =0 = hour-centred; 1 = half-hour centred.
      common/CWEC_SOL/iSlr_half_hr_flg
      integer iSlr_half_hr_flg

      common/shad0/ISIcalc,icalcD,icalcM
      integer ISIcalc,icalcD,icalcM

      common/hcthry/ihct,icorexhct

      logical MODSIT,browse,XST,modish,OK,unixok
      logical FOUND
      dimension SALT(8),IVALS(8),SICALT(7)
      dimension SALTM(31),IVALSM(31)
      character*10 wkd1, wkd2
      character*10 wkday(7)
      character SEXP*31,SALT*31,hold*72
      character SEXPM*31,SALTM*31,holdM*72
      character SICALT*51

C ITEMS is menu for site/context items.
      character*35 ITEMS(32)
      character*72 GTGEOM
      character outs*124,ltmp*72
      character act*1,GTNAME*15,fs*1,msg*42
      character ipvact*3  ! to denote whether in cfd file or external
      CHARACTER doit*256
      character ipvaction*3
      dimension HCALT(15),IHCVAL(15)
      character HCALT*42

      integer idwe1T,idwe2T,iyearT   ! local values for editing.
      integer icreport  ! to signal that calendar has been updated.
      integer IDOL,IDAYNUM,IMTHNUM,IDWKNUM,IDTYY  ! for correcting calendar
      integer nitms,INO ! max items and current menu item
      logical MY        ! signal not-multi-year weather

      helpinsub='context'  ! set for subroutine

      data wkday/'Monday', 'Tuesday','Wednesday', 'Thursday',
     &           'Friday','Saturday', 'Sunday'/

C Set initial states to false.
      MODSIT=.false.
      modish=.false.

C Check if Unix-based or DOS based.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Initial string for site exposure.
      SALT(1)='urban (normal)         '
      SALT(2)='urban (low density)    '
      SALT(3)='rural                  '
      SALT(4)='urban (equal weighting)'
      SALT(5)='urban (high rise)      '
      SALT(6)='isolated rural         '
      SALT(7)='totally enclosed       '
      SALT(8)='user defined           '
C      WRITE(SALT(8),53)skyview,groundview,buildingview
      SEXP=SALT(siteexposureindex)

C MODISH: initial assignments for reflections from obstructions.
      SALTM(1)= '1) compute reflections from obs'
      SALTM(2)= '1) do not compute refl.from obs'
      SALTM(3)= '2) shd.f.corr. + diffuse piping'
      SALTM(4)= '2) shd.f.cor+dif.pip.+grnd refl'
      SALTM(5)= '2) completely recalculate s.f. '
      SALTM(6)= '2) compl.recalc. + diff. piping'
      SALTM(7)= '2) put dir. refl. in diff. s.f.'
      SALTM(8)= '3) use Perez sky, from weather '
      SALTM(9)= '3) use CIE sky, generic        '
      SALTM(10)='3) use Perez sky, generic      '
      SALTM(11)='4) suppose 1 diffuse bounce    '
      SALTM(12)='4) suppose 2 diffuse bounces   '
      SALTM(13)='4) suppose 3 diffuse bounces   '
      SALTM(14)='5) use 5 direction vectors     '
      SALTM(15)='5) use 17 direction vectors    '
      SALTM(16)='6) resolution:2x2 diffuse & dir'
      SALTM(17)='6) resolution:2x2 dif,20x20 dir'
      SALTM(18)='6) resolution:1x1 dif,10x10 dir'
      SALTM(19)='7) specify zons&surfs(optional)'
      SALTM(20)='7) include all zones &all surfs'
      SALTM(21)='8) if monthly: process now.    '
      if(modishindex.ne.0)then
        SEXPM=SALTM(modishindex)
      else
        SEXPM='  '
      endif

C Begin with high level menu.
    3 INO=-4
      IER=0
      WRITE(ITEMS(1),'(A,F6.2)')'a latitude: ',sitelat
      WRITE(ITEMS(2),'(A,F6.2)')'b longitude difference: ',sitelongdif
      WRITE(ITEMS(3),'(A,F6.1)')'c altitude: ',sitealt
      if(iSlr_half_hr_flg.eq.0)then
        WRITE(ITEMS(4),'(A)')   'd solar timing: hour centred'
      elseif(iSlr_half_hr_flg.eq.1)then
        WRITE(ITEMS(4),'(A)')   'd solar timing: half-hour centred'
      else
        WRITE(ITEMS(4),'(A)')   'd solar timing: not defined'
      endif

      WRITE(ITEMS(5),'(A,A)')   'e exposure: ',SEXP(1:21)
      IF(groundreflmodel.EQ.1) THEN
        WRITE(ITEMS(6),'(a,f5.3,a)')
     &                  'f grd. reflectivity: const. (',groundrefl,')'
      ELSEIF(groundreflmodel.EQ.2) THEN
        ITEMS(6) =      'f grd. reflectivity: simple'
      ELSEIF(groundreflmodel.EQ.3) THEN
        ITEMS(6) =      'f grd. reflectivity: advanced'
      ENDIF
      WRITE(ITEMS(7),'(4a)')    'g weekends: ',wkd1,'/',wkd2
      WRITE(ITEMS(8),'(a,I4)')  'h year: ',IYEAR
      ITEMS(9) =                'i project calendar               '
      ITEMS(10)=                'j contacts                       '
      ITEMS(11)=                'k simulationist address          '
      ITEMS(12)=                '  ___________________________    '
      if(GTGEOM(1:2).eq.'  '.or.GTGEOM(1:4).eq.'UNKN')then
        ITEMS(13)=              'l ground topology                '
      else
        WRITE(ITEMS(13),'(2A)') 'l ground topology:',GTNAME(1:13)
      endif
      WRITE(ITEMS(14),'(A,i2)') 'm ground temperature profiles:',NGRDP
      ITEMS(15)=                'n 3-D ground representation      '
      ITEMS(16)=                '  ___________________________    '
      ITEMS(17)=                'o primary energy conversions     '
      ITEMS(18)=                'p fan/lift/DHW dispersed demands '
      ITEMS(19)=                'q integrated performance view    '
      ITEMS(20)=                '  ___________________________    '
      ITEMS(21)=                'r pressure coefficients calc.    '
      ITEMS(22)=                's temporal data                  '
      ITEMS(23)=                '  ___________________________    '
      WRITE(ITEMS(24),'(a,i3)') 't define images: ',noimg
      ITEMS(25)=                'u UK NCM specifications          '
c      ITEMS(26)=                'v transient orientation         '
      ITEMS(26)=                'v update shading for reflections '
      ITEMS(27)=                ' _____________________________   '
      ITEMS(28)=                'w random perturbations           '
      if(ihct.eq.0.and.icorexhct.eq.0)then
        ITEMS(29)=              'x surface htc methods (unset)    '
      elseif(ihct.eq.1.and.icorexhct.eq.1)then
        ITEMS(29)=              'x surface htc methods (defaults) '
      elseif(ihct.gt.1.or.icorexhct.gt.1)then
        ITEMS(29)=              'x surface htc methods (user set) '
      endif
      ITEMS(30)=                ' _____________________________   '
      ITEMS(31)=                '? help                           '
      ITEMS(32)=                '- exit menu                      '
      nitms=32

C Help text for this menu.
      helptopic='context_overview_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU('Context',ITEMS,nitms,INO)
      IF(INO.EQ.nitms)THEN

C Update configuration if context changed. If lat/long changes,
C check to see if existing shading files need to be updated.
        if(MODSIT.and.(.NOT.browse))then
          CALL EMKCFG('s',IER)
        endif
        if(modish.and.(.NOT.browse))then

C If there was a change in location, but no zones defined just return.
          if(ncomp.eq.0)then
            return
          endif

C If there are existing shading files recalculate. If ISIcalc is
C still zero then set it to 2 so that ish can run the monthly 
C calculations. If ISIcalc = 1 then embedded calculations are
C used so skip recalculation.
          if(ISIcalc.eq.1) goto 44 ! embedded so jump
          do 42 iz=1,ncomp
            if(ISI(iz).eq.1)then
              if(ISIcalc.eq.0) ISIcalc=2  ! if not set assign = 2
              call FINDFIL(LSHAD(iz),XST)
              if(XST)then
                write(outs,'(3a)') 'Shading for ',
     &            zname(iz)(1:lnzname(iz)),' is out of date.'
                call edisp(iuout,' ')
                call edisp(iuout,outs)
              endif
            endif
  42      continue
          CALL EASKMBOX(
     &      'Site changes may require shading adjustments!',
     &      'Options:','recalculate (silent)',
     &      'recalculate (interactive)',
     &      'cancel',' ',' ',' ',' ',' ',IRT,nbhelp)
          if(IRT.eq.1.or.IRT.eq.2)then
            call edisp(iuout,'Processing zones.')
            if(IRT.eq.1)then
              call edisp(iuout,
     &           'Control will be returned to the Project Manager.')
            endif
            do 43 iz=1,ncomp
              if(ISI(iz).eq.0) goto 43
              call FINDFIL(LSHAD(iz),XST)
              if(XST)then

C Get logical name of terminal type, expand model name
C to include the path and create a string to drive ish.
C If user asked for silent recalculation then do each
C one in forground in an xterm with `-act update_silent`
C as the command line. For silent do the runit via
C the current applications command window rather than
C starting up a new xterm (i.e. use '-' rather than 'text')
                if(IRT.eq.1)then
                  call comissionish(iz,'sr ',ier)
                  if(ier.ne.0)then
                    call edisp(iuout,'Possible error in calculations.')
                  endif
                else
                  write(outs,'(3a)') 'Proceed with shading for ',
     &              zname(iz)(1:lnzname(iz)),'?'
                  CALL EASKOK(' ',outs,OK,nbhelp)
                  if(OK)then
                    call comissionish(iz,'ir ',ier)
                    if(ier.ne.0)then
                      call edisp(iuout,
     &                  'Possible error in calculations.')
                    endif
                  endif
                endif
              endif
  43        continue
            call edisp(iuout,'Zones shading db update complete.')
          endif
  44      continue
        endif
        RETURN

C Help text.
      ELSEIF(INO.EQ.nitms-1)THEN
        helptopic='context_overview_menu'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Model context',nbhelp,'-',0,0,IER)

C Site latitude.
      ELSEIF(INO.EQ.1)THEN
        helptopic='context_lat_long'
        call gethelptext(helpinsub,helptopic,nbhelp)
        slat=sitelat  ! sitelat is in common C4 in site.h
        CALL EASKR(SLAT,' ','Site latitude?',
     &       -89.9,'W',89.9,'W',55.9,'site latitude',IER,nbhelp)
        IF(IER.EQ.0)sitelat=SLAT
        MODSIT=.true.
        modish=.true.

C Site longitude difference.
      ELSEIF(INO.EQ.2)THEN
        helptopic='context_lat_long'
        call gethelptext(helpinsub,helptopic,nbhelp)
        slon=sitelongdif  ! sitelongdif is in common C4 in site.h
        CALL EASKR(SLON,
     &    'Site longitude difference from local time meridian',
     &    '(East +ve, West -ve)?',-15.0,'W',15.0,'W',-4.1,
     &    'longitude difference',IER,nbhelp)
        IF(IER.EQ.0)sitelongdif=SLON
        MODSIT=.true.
        modish=.true.

C Site altitude.
      ELSEIF(INO.EQ.3)THEN
        helptopic='context_lat_long'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKR(sitealt,' ',
     &    'Site altitude',-100.0,'W',3000.0,'W',0.0,
     &    'site altitude',IER,nbhelp)
        MODSIT=.true.

C Solar radiation timing.
      ELSEIF(INO.EQ.4)THEN
        helptopic='context_solar_timing'
        call gethelptext(helpinsub,helptopic,nbhelp)
        if(iSlr_half_hr_flg.eq.1)then
          iSlr_half_hr_flg=0
        elseif(iSlr_half_hr_flg.eq.0)then
          iSlr_half_hr_flg=1
        endif
        MODSIT=.true.

C Site exposure.
      ELSEIF(INO.EQ.5)THEN
        SALT(8)='user defined'
        helptopic='site_exposure_options'
        call gethelptext(helpinsub,helptopic,nbhelp)
        IX=1
        CALL EPICKS(IX,IVALS,' ','Site Exposure',
     &                31,8,SALT,'Site Exposure',IER,nbehlp)
        IF(IX.EQ.0)THEN
          INO=-4
          GOTO 3
        ENDIF

        siteexposureindex=IVALS(1)
        SEXP=SALT(siteexposureindex)
        IF(siteexposureindex.EQ.8)THEN
  290     CALL EASKR(skyview,' ','Sky view factor?',
     &      0.0,'W',0.99,'W',0.33,'sky view factor',IER,nbhelp)
          CALL EASKR(groundview,' ','Ground view factor?',
     &      0.0,'W',0.99,'W',0.33,'ground view factor',IER,nbhelp)
          CALL EASKR(buildingview,' ','Surroundings view factor?',
     &      0.0,'W',0.99,'W',0.33,'surroundings view factor',IER,nbhelp)
          IF(skyview.LT.0.0.or.groundview.LT.0.0.or.
     &       buildingview.LT.0.0)then
            CALL USRMSG(' ','View factor cannot be negative!','W')
            GOTO 290
          ENDIF
          IF(skyview.GT.1.0.or.groundview.GT.1.0.or.
     &       buildingview.GT.1.0)then
            CALL USRMSG(' ','View factor cannot be > 1.0!','W')
            GOTO 290
          ENDIF
          IF((skyview+groundview+buildingview).GT.1.0)THEN
            CALL USRMSG(' ','Total view factor cannot be > 1.0!','W')
            GOTO 290
          ENDIF
          IF(ABS(skyview+groundview+buildingview-1.0).GT.0.001)THEN
            CALL USRMSG(' ','Total view factor must = 1!','W')
            GOTO 290
          ENDIF
        ENDIF
        MODSIT=.true.

C Ground reflectance.
      ELSEIF(INO.EQ.6)THEN
        helptopic='context_ground_refl'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(' ','Ground reflectance:',
     &    'constant','monthly (simple)','monthly (detailed)','cancel',
     &    ' ',' ',' ',' ',IW,nbhelp)

C Constant ground reflectance.
        if (IW.EQ.1) then
          groundreflmodel=1
          CALL EASKR(groundrefl,' ','Ground reflectance?',
     &        0.0,'W',0.99,'W',0.2,'ground reflectance',IER,nbhelp)
          MODSIT=.true.

C Simple or detailed monthly.
        elseif (IW.EQ.2 .OR. IW.EQ.3) then
          groundreflmodel=IW
   83     HOLD=' '
          WRITE(HOLD,'(1X,6F7.2)')(groundreflmonth(J),J=1,6)
          CALL EASKS(HOLD,' ',
     &      'January thro` June ground reflectance (no snow)?',
     &      72,'0.2 0.2 0.2 0.2 0.2 0.2','gr albedo jan-jun',
     &      IER,nbhelp)
          NV = iCountWords(HOLD)
          IF (NV.NE.6) GOTO 83
          K=0
          DO 84 J=1,6
            CALL EGETWR(HOLD,K,GV,0.0,0.99,'W','profile',IER)
            IF (IER.NE.0) GOTO 83
            groundreflmonth(J)=GV
   84     CONTINUE
   85     CONTINUE
          HOLD = ' '
          WRITE(HOLD,'(1X,6F7.2)')(groundreflmonth(J),J=7,12)
          CALL EASKS(HOLD,' ',
     &      'July thro` December ground reflectance (no snow)?',
     &       72,'0.2 0.2 0.2 0.2 0.2 0.2','gr albedo jul-dec',
     &      IER,nbhelp)
          NV = iCountWords(HOLD)
          IF (NV.NE.6) GOTO 85
          K=0
          DO 86 J=7,12
            CALL EGETWR(HOLD,K,GV,0.0,0.99,'W','profile',IER)
            IF (IER.NE.0) GOTO 85
            groundreflmonth(J)=GV
   86     CONTINUE
          MODSIT=.true.

C Simple model - ask for average albedo of snow, and number of days
C with snow on the ground.
          if (IW.EQ.2) then
            CALL EASKR(snowgroundrefl,' ',
     &        'Average ground reflectance with snow?',
     &        0.0,'W',0.99,'W',0.4,'snow reflectance',IER,nbhelp)
            MODSIT=.true.
   87       CONTINUE
            HOLD=' '
            WRITE(HOLD,'(6(1X,I2))')(dayswithsnow(J),J=1,6)
            CALL EASKS(HOLD,' ',
     &        'Number of days in January thro` June with snow?',
     &        72,'0 0 0 0 0 0','days with snow jan-jun',IER,nbhelp)
            NV = iCountWords(HOLD)
            IF (NV.NE.6) GOTO 87
            K=0
            DO 88 J=1,6
              CALL EGETWI(HOLD,K,IV,0,31,'W','profile',IER)
              IF (IER.NE.0) GOTO 87
              dayswithsnow(J)=IV
   88       CONTINUE
   89       CONTINUE
            HOLD = ' '
            WRITE(HOLD,'(6(1X,I2))')(dayswithsnow(J),J=7,12)
            CALL EASKS(HOLD,' ',
     &        'Number of days in July thro` December with snow?',
     &        72,'0 0 0 0 0 0 ','days with snow jul-dec',IER,nbhelp)
            NV = iCountWords(HOLD)
            IF (NV.NE.6) GOTO 89
            K=0
            DO 90 J=7,12
              CALL EGETWI(HOLD,K,IV,0,31,'W','profile',IER)
              IF (IER.NE.0) GOTO 89
              dayswithsnow(J)=IV
   90       CONTINUE
          endif

C Detailed model - ask for albedo of fresh snow and file containing
C hourly snow depth.
          if (IW.EQ.3) then
            CALL EASKR(snowgroundrefl,' ',
     &        'Ground reflectance with fresh snow?',
     &        0.0,'W',0.99,'W',0.5,'snow reflectance',IER,nbhelp)

   92       CONTINUE
            CALL EASKS(SNFNAM,' ',
     &        'Snow depth file?',72,' ','Snow depth file',IER,nbhelp)
            CALL FINDFIL(SNFNAM,FOUND)
            IF(.NOT.FOUND) THEN
              CALL EASKOK('File not found!','Retry?',OK,nbhelp)
              IF (.NOT.OK) GOTO 92
            ENDIF
          endif
        endif

C Weekends definition.
      ELSEIF(INO.EQ.7)THEN
        helptopic='context_weekends'
        call gethelptext(helpinsub,helptopic,nbhelp)
        idwe1T=idwe1
        CALL EASKI(idwe1T,'Day index (Mon=1,Tue=2, ...) for',
     &    'the first day of the weekend?',
     &        1,'F',7,'F',6,'1st weekend index',IERI,nbhelp)
        if(ieri.eq.-3) goto 3
        idwe1=idwe1T
        wkd1=wkday(idwe1)
        idwe2T=idwe2
        CALL EASKI(idwe2T,'Day index (Mon=1,Tue=2, ...) for',
     &    'the second day of the weekend?',
     &        1,'F',7,'F',7,'2nd weekend index',IERI,nbhelp)
        if(ieri.eq.-3) goto 3
        idwe2=idwe2T
        wkd2=wkday(idwe2)
        MODSIT=.true.

C Change the year and if calendar has not been set up initialise
C and then list the months of the year. If there is an existing
C calendar with the default day types and the year has changed
C then re-initialise.
      ELSEIF(INO.EQ.8)THEN
        helptopic='context_model_year'
        call gethelptext(helpinsub,helptopic,nbhelp)
        iyeart=iyear
        CALL EASKI(iyeart,' ','Simulation year?',
     &       1900,'W',2051,'W',2020,'year',IERI,nbhelp)
        if(ieri.eq.-3) goto 3
        iyear=iyeart
        MODSIT=.true.

C If no day types found use calenmanage to instantiate the initial set of
C day types. If nbdaytype is 3 then we have a legacy assumption and leave
C it alone. If more then 3 then use the calendar function.
        if(nbdaytype.eq.0)then
          call calenmanage('i',ier) ! no known daytypes instantiated
        elseif(nbdaytype.lt.3)then
          call calenmanage('i',ier) ! might not be necessary
        elseif(nbdaytype.eq.3)then
          continue
        elseif(nbdaytype.gt.3)then

C Perform check that calendar day types correspond with simulation year.
C The logic below assumes that the first three day types are weekday,
C saturday and sunday. It loops through each day-of-the-year and if the model
C calendar day type is one of the standards it checks that the model weekday
C is the same as a Julian weekday. Any calendar day types beyond 3 are
C retained. If no calendar was defined in the model then it should do the
C work silently. (Same logic as in esystem.F). If there are more than 4
C day types in the calendar, the user probably has defined their own scheme.
          ICREPORT=0
          if(nbdaytype.gt.4)then
            continue
          else
            DO 123 IDOL=1,365
              IF(ICALENDER(IDOL).LE.3)THEN
                CALL EDAYR(IDOL,IDAYNUM,IMTHNUM)
                CALL EWEEKD(IDAYNUM,IMTHNUM,IYEAR,IDWKNUM)
                IF(IDWKNUM.LT.6)THEN
                  IDTYY=1 ! WEEKDAY
                ELSEIF(IDWKNUM.EQ.6)THEN
                  IDTYY=2 ! SATURDAY
                ELSEIF(IDWKNUM.EQ.7)THEN
                  IDTYY=3 ! SUNDAY
                ENDIF
                IF(ICALENDER(IDOL).EQ.0)THEN
                  ICALENDER(IDOL)=IDTYY  ! update the model calendar
                  ICREPORT=2             ! do it silently
                ELSEIF(ICALENDER(IDOL).NE.IDTYY)THEN
                  ICALENDER(IDOL)=IDTYY  ! update the model calendar
                  ICREPORT=1
                ENDIF
              ENDIF
 123        CONTINUE
          endif
          if(ICREPORT.EQ.1)then
            CALL EDISP(IUOUT,'  ')
            CALL EDISP(IUOUT,
     &        'Simulation year and calendar mismatch rectified.')
          endif
        endif
        call easkok(' ','View calendar?',ok,nbhelp)
        if(ok)then
          loop=12
          loopst=1
          call calenprint(iuout,'t',iyear,loopst,loop)
        endif

C Calendar functions. If number of day types is zero or less than
C the legacy assumption of 3  then initialise prior to entering
C the interactive facility to allow user to manage the calendar.
      ELSEIF(INO.EQ.9)THEN
        if(nbdaytype.lt.3)then
          act = 'i'
          call calenmanage(act,ier)
        endif
        act = '-'
        call calenmanage(act,ier)

C Address of the site and client.
      ELSEIF(INO.EQ.10)THEN
        call edsbmbld()

C Address of the model maker.
      ELSEIF(INO.EQ.11)THEN
        call edsbmbld()

C Not used.
      ELSEIF(INO.EQ.12)THEN
        continue

C Ground topology.
      ELSEIF(INO.EQ.13)THEN
        helptopic='context_ground_topology'
        call gethelptext(helpinsub,helptopic,nbhelp)
        call easkmbox(' ','Ground topology options:',
     &    'select current','create manually','create via bitmap',
     &    'cancel',' ',' ',' ',' ',iwgt,nbhelp)
        if(iwgt.eq.1)then
          call GTOPOL(itrc,ier)
          MODSIT=.true.
        elseif(iwgt.eq.2)then
          call GTOPOL(itrc,ier)
          MODSIT=.true.
        elseif(iwgt.eq.3)then
          iglib = igraphiclib()  ! find out if X11 or GTK or text support only.
          if(iglib.eq.1)then
            iz=0
            call edisp(iuout,' ')
            call edisp(iuout,'In the bitmap facility you must toggle')
            call edisp(iuout,'to the ground topology input mode.')
            call clickonbitmap(iz,ier)
            call GTOPOL(itrc,ier)
            MODSIT=.true.
          elseif(iglib.eq.2)then
            call usrmsg('Sorry: the click-on-bitmap facility is not',
     &        'operational with the current graphics library.','W')
          elseif(iglib.eq.3)then
            call usrmsg('You must be in graphic mode to use the',
     &      'click-on-bitmap facility to define ground toplogy.','W')
          endif
        endif

C User defined or local ground temperature profiles. Sort available weather
C first, offer choices and then report on the temperatures.
      ELSEIF(INO.EQ.14)THEN
        MY=.false.
        call CLMOPB(MY,0,IER)
        call CLMRDBMD(IER)
        helptopic='context_ground_temps'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(
     &   'User defined ground temperature profiles:','  ',
     &   'list','edit temps','add manually','add one via weather',
     &   'add set via weather',' ',' ',' ',IRT,nbhelp)
        if(IRT.eq.1)then
          if(NGRDP.gt.0)then
            do 22 igrdp=1,NGRDP
              call edisp(iuout,' ')
              CALL EDISP(iuout,'Profile for January-December:')
              WRITE(OUTS,'(12F6.1)')(UGRDTP(J,IGRDP),J=1,12)
              call edisp(iuout,outs)
 22         continue
          endif
          goto 3
        elseif(IRT.eq.2)then  ! Edit an existing set.
          if(NGRDP.gt.0)then
            CALL EASKI(IFOC,' ','Profile to edit?',
     &        1,'F',NGRDP,'F',1,'edit profile',IERI,nbhelp)
            if(ieri.eq.-3) goto 3
            WRITE(HOLD,'(a)') '  '
            CALL EASKS(HOLD,'Profile description:',
     &        'ground temp',32,'profile','profile',IIER,nbhelp)
            UGRNAME(ifoc)=HOLD(1:32)
            depth=UGRDEPTH(ifoc)
            CALL EASKR(depth,' ','Associated depth (m):',
     &       0.0,'W',5.0,'W',1.0,'depth to calculate',IER,nbhelp)
            UGRDEPTH(ifoc)=depth
            goto 93    ! jump to edit
          else
            call usrmsg('No profiles defined!','Choose add.','W')
            goto 3
          endif
        elseif(IRT.eq.3)then  ! Create a new set (initial values = 10C.)
          if(NGRDP.lt.MGRDP)then
            NGRDP=NGRDP+1
            ifoc=NGRDP
            do j=1,12
              UGRDTP(J,ifoc)=10.0
            enddo
            WRITE(HOLD,'(a)') 'User supplied '
            CALL EASKS(HOLD,'Profile description:',
     &        'ground temp',32,'profile','profile',IIER,nbhelp)
            UGRNAME(ifoc)=HOLD(1:32)
            depth=1.0
            CALL EASKR(depth,' ','Associated depth (m):',
     &       0.0,'W',5.0,'W',1.0,'depth to calculate',IER,nbhelp)
            UGRDEPTH(ifoc)=depth
            goto 93    ! jump to edit
          else
            call usrmsg('Additional ground temperature profiles',
     &                  'not permitted in current model!','W')
            goto 3
          endif
        elseif(IRT.eq.4)then
          if(NGRDP.lt.MGRDP)then
            NGRDP=NGRDP+1
            ifoc=NGRDP
            CALL EASKR(depth,' ','At depth (m):',
     &       0.0,'W',5.0,'W',1.0,'depth to calculate',IER,nbhelp)
            UGRDEPTH(ifoc)=depth
            CALL GTCALC(depth,'-',IER)  ! Use Kusada method to calculate ground.
            do J=1,12
              UGRDTP(J,ifoc)=eGrdTp(J)
            enddo
            WRITE(HOLD,'(a,f5.1)') 'weather derived @',depth
            CALL EASKS(HOLD,'Profile description:',
     &        'ground temp',32,'profile','profile',IIER,nbhelp)
            UGRNAME(ifoc)=HOLD(1:32)
            call edisp(iuout,' ')
            write(outs,'(2a,f4.1,a)') UGRNAME(ifoc),'@ depth ',depth,
     &          ' profile for January-December:'
            CALL EDISP(iuout,outs)
            WRITE(OUTS,'(12F6.1)')(UGRDTP(J,ifoc),J=1,12)
            call edisp(iuout,outs)
            goto 3
          else
            call usrmsg('Additional ground temperature profiles',
     &                  'not permitted in current model!','W')
            goto 3
          endif
        elseif(IRT.eq.5)then
          do jj=1,4
            if(NGRDP.lt.MGRDP)then
              NGRDP=NGRDP+1
              ifoc=NGRDP
              if(jj.eq.1)then 
                depth=0.5; UGRNAME(ifoc)='weather derived @0.5m'
              elseif(jj.eq.2)then
                depth=1.0; UGRNAME(ifoc)='weather derived @1.0m'
              elseif(jj.eq.3)then
                depth=1.5; UGRNAME(ifoc)='weather derived @1.5m'
              elseif(jj.eq.4)then
                depth=2.0; UGRNAME(ifoc)='weather derived @2.0m'
              endif
              UGRDEPTH(ifoc)=depth
              CALL GTCALC(depth,'-',IER)  ! Use Kusada method to calculate ground.
              do J=1,12
                UGRDTP(J,ifoc)=eGrdTp(J)
              enddo
              call edisp(iuout,' ')
              write(outs,'(2a,f4.1,a)') UGRNAME(ifoc),'@ depth ',depth,
     &          ' profile for January-December:'
              CALL EDISP(iuout,outs)
              WRITE(OUTS,'(12F6.1)')(UGRDTP(J,ifoc),J=1,12)
              call edisp(iuout,outs)
            else
              call usrmsg('Additional ground temperature profiles',
     &                    'not permitted in current model!','W')
              goto 3
            endif
          enddo
          goto 3
        endif

C Manual edit of temperatures.
   93   WRITE(HOLD,'(1X,6F7.2)')(UGRDTP(J,IFOC),J=1,6)
        CALL EASKS(HOLD,' ','Temperatures, January-June?',
     &      72,' ','gr prof jan-jun',IER,nbhelp)
        NV = iCountWords(HOLD)
        if(NV.ne.6)goto 93
        K=0
        DO 94 J=1,6
          CALL EGETWR(HOLD,K,GV,0.,0.,'-','profile',IER)
          IF(IER.NE.0)GOTO 93
          UGRDTP(J,IFOC)=GV
   94   CONTINUE
   95   hold = ' '
        WRITE(HOLD,'(1X,6F7.2)')(UGRDTP(J,IFOC),J=7,12)
        CALL EASKS(HOLD,' ','Temperatures, July-December?',
     &      72,' ','gr prof jan-jun',IER,1)
        NV = iCountWords(HOLD)
        if(NV.ne.6)goto 95
        K=0
        DO 96 J=7,12
          CALL EGETWR(HOLD,K,GV,0.,0.,'-','profile',IER)
          IF(IER.NE.0)GOTO 95
          UGRDTP(J,IFOC)=GV
   96   CONTINUE
        call edisp(iuout,' ')
        CALL EDISP(iuout,'Edited profile for January-December:')
        WRITE(OUTS,'(12F6.1)')(UGRDTP(J,ifoc),J=1,12)
        call edisp(iuout,outs)
        MODSIT=.true.

C 3-D Ground representation.
      ELSEIF(INO.EQ.15)THEN
        call usrmsg('Please use program `grd` to define',
     &              '3D ground representations.','-')

C Primary energy conversions.
      ELSEIF(INO.EQ.17)THEN
        helptopic='context_PEC'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL EASKMBOX(' ','Energy demand conversion options:',
     &   'initialise and edit','edit','cancel',
     &   ' ',' ',' ',' ',' ',IR,nbhelp)
        if(IR.eq.1)then
          call peconv('i')
          call peconv('-')
        elseif(IR.eq.2)then
          call peconv('-')
        endif

C Dispersed fan/pump/lift/DHW demands.
      ELSEIF(INO.EQ.18)THEN
        call prjdmds(itrc,itru,iuo,ier)

C IPV data. If it exists read it, if nothing yet initialise, save to
C msc folder file and then edit.
      ELSEIF(INO.EQ.19)THEN
        lr=lnblnk(cfgroot)
        write(ltmp,'(4a)') mscpth(1:lnblnk(mscpth)),fs,
     &    cfgroot(1:lr),'.ipv'
        if(lipvdatf(1:7).eq.'UNKNOWN'.or.
     &     lipvdatf(1:2).eq.'  ')then

C Offer choice of a classic IPV or user define scheme.
          CALL EASKMBOX(
     &      'Performance assessment and data mining directives.',
     &      'Options:','setup a classic IPV','bespoke user directives',
     &      'cancel',' ',' ',' ',' ',' ',IW,nbhelp)
          if(iw.eq.3)then
            goto 3
          elseif(iw.eq.2)then 
            call ipvinitialq('d',iresponse)
            if(iresponse.gt.2)then
              CALL EASKOK('Several performance issues will require',
     &          'preparation do you want to continue? ',OK,nbhelp)
              if(ok)then
                call ipvdat('i')             ! fill with defaults
              else
                goto 3
              endif
            else
              call ipvdat('i')               ! fill with defaults
            endif
          elseif(iw.eq.1)then
            call ipvinitialq('-',iresponse)  ! check and ask initial questions.
            if(iresponse.eq.-1)then
              goto 3                         ! user declined to create
            elseif(iresponse.eq.0)then
              call usrmsg('Please confirm the initial setup details.',
     &          'and invoke seasonal scaling option.','P')
              call ipvdat('-')               ! enter the menu
            endif
          endif
          ipvaction='ipv'
 142      CALL EASKS(ltmp,' ','IPV description file?',
     &      72,'xxx.ipv','IPV file',IER,nbhelp)
          if(ltmp(1:2).ne.'  ')then
            lipvdatf=ltmp
            call FINDFIL(lipvdatf,XST)
            IF(XST)then
              ipvact='ipv'
              call ripvdat(ifil+1,lipvdatf,ipvact,ier)
              call ipvdat('-')
              CALL EMKCFG('s',IER) ! remember this
              goto 3
            else
              ipvact='ipv'
C              call ipvdat('i')   ! ??
              call ipvdat('i')   ! ??
              call mkipvdat(ifil+1,lipvdatf,ipvact)
              call ipvdat('-')
              CALL EMKCFG('s',IER) ! remember this
              goto 3
            endif
          else
            call usrmsg('Please re-enter file name.',' ','W')
            goto 142
          endif
          goto 3
        elseif(lipvdatf(1:8).eq.'internal')then

C Internal IPV description. If nipvassmt is zero then
C nothing has been created yet so initialise and save in msc folder.
          if(nipvassmt.eq.0)then
            call ipvdat('i')     ! fill with defaults
            ipvaction='ipv'
            lipvdatf=ltmp
            call mkipvdat(ifil+1,lipvdatf,ipvaction)
            CALL EMKCFG('s',IER) ! remember this
            call ipvdat('-')     ! edit data
            CALL EMKCFG('s',IER) ! remember this
            goto 3
          else
            ipvaction='ipv'
            lipvdatf=ltmp
            call mkipvdat(ifil+1,lipvdatf,ipvaction)
            call ipvdat('-')
            CALL EMKCFG('s',IER)
            goto 3
          endif
        else     ! a known file
          call FINDFIL(lipvdatf,XST)
          IF(XST)then
            ipvact='ipv'
            call ripvdat(ifil+1,lipvdatf,ipvact,ier)
            call ipvdat('-')
            CALL EMKCFG('s',IER) ! remember this
            goto 3
          else
            ipvact='ipv'
            call ipvdat('i')
            call mkipvdat(ifil+1,lipvdatf,ipvact)
            call ipvdat('-')
            CALL EMKCFG('s',IER) ! remember this
            goto 3
          endif
        endif

C External surface pressure coefficients.
      ELSEIF(INO.EQ.21)THEN
        call cpcdat

C Temporal definitions.
      ELSEIF(INO.EQ.22)THEN
        call setuptemporal(MODSIT,IER)

C Manage images associated with project.
      ELSEIF(INO.EQ.24)THEN
        call manageimages(modsit)

C UK NCM related data.
      ELSEIF(INO.eq.25)then
        call sbmedit(iuact,ier) ! generate stripped model and ncm file

C Change model orientation as a function of time.
C      ELSEIF(INO.eq.26)then
C        CALL ROAMING
C        CONTINUE

C MODISH: embedded mode. The Modish.pm perl script is assumed to be
C in the folder with other ESP-r modules.
      ELSEIF(INO.EQ.26)THEN
        helptopic='modish_confl'
        call gethelptext(helpinsub,helptopic,nbhelp)
        IX=1
        CALL EPICKS(IX,IVALSM,' ',' ',
     &    31,22,SALTM,'External reflections',IER,nbhelp)
        modishindex=IVALSM(1)
        SEXPM=SALTM(modishindex)
        if(unixok)then
          write(doit,'(8a,I3,a)')
     &    'perl ',dinstpath(1:lnblnk(dinstpath)),fs,'bin',fs,
     &    'modish',fs,'Modish.pm -setdefaults ',
     &    modishindex,LCFGF,' >/dev/null'
          call runit(doit,'-')
          MODSIT=.true.
        else
          continue
        endif
        GOTO 3

C Random perturbations (aka gremlins).
      elseif (ino.eq.28) then
        itmp=0
        call GRM_MNG(itmp,IER)

C Nominate inside and outside default heat transfer method.
      elseif (ino.eq.29) then

C External hc correlations:
        if(icorexhct.eq.0) msg='no current exterior hc method'
        if(icorexhct.eq.1) msg='default McAdams exterior hc method'
        if(icorexhct.eq.2) msg='MoWiTT  exterior hc method'
        if(icorexhct.eq.3) msg='Aya Hagishima correlation exterior hc'
        if(icorexhct.eq.4) msg='Ya Liu (roof wind speed) exterior hc'
        if(icorexhct.eq.5) msg='Ya Lui (raw wind speed) exterior hc'
        if(icorexhct.eq.6) msg='Loveday (roof wind speed) exterior hc'
        if(icorexhct.eq.7) msg='Loveday (raw wind speed) exterior hc'
        if(icorexhct.eq.8) msg='CIBSE guide exterior hc'
        if(icorexhct.eq.9) msg='ASHRAE Task Group  exterior hc'
        if(icorexhct.eq.10)msg='Sturrock exterior hc'
        if(icorexhct.eq.11)msg='Keith Nicol exterior hc'
        if(icorexhct.eq.12)msg='S.E .G.Jayamaha exterior hc'
        call edisp(iuout,' ')
        call edisp(iuout,'Current method for external surf HTC ')
        call edisp(iuout,msg)
        helptopic='toggle_ext_hc_methods'
        call gethelptext(helpinsub,helptopic,nbhelp)

        HCALT(1)='the default ESP-r method'
        HCALT(2)='MoWiTT low rise hc '
        HCALT(3)='Aya Hagishima hc '
        HCALT(4)='Ya Liu (roof wind speed) hc'
        HCALT(5)='Ya Lui (raw wind speed) hc'
        HCALT(6)='Ya Lui (weather station wind speed) hc'
        HCALT(7)='Loveday (roof wind speed) hc'
        HCALT(8)='Loveday (raw wind speed) hc'
        HCALT(9)='CIBSE guide hc'
        HCALT(10)='Loveday (mixed) hc'
        HCALT(11)='British Standard'
        HCALT(12)='ASHRAE Task Group hc'
        HCALT(13)='Sturrock hc'
        HCALT(14)='Keith Nicol hc'
        HCALT(15)='S.E.G. Jayamaha hc'
        IX=1
        CALL EPICKS(IX,IHCVAL,' ','External surface convection model:',
     &         42,15,HCALT,'ext hc model',IER,nbhelp)
        icorexhct=IHCVAL(1)

C If undefined set the default inside treatment.
        helptopic='toggle_int_hc_methods'
        call gethelptext(helpinsub,helptopic,nbhelp)

        SICALT(1)='Alamdari and Hammond (default) '
        SICALT(2)='Khalifa & Marshall, radiator located under window '
        SICALT(3)='Khalifa & Marshall, no radiator under window  '
        SICALT(4)='Halcrow, time invariant low    '
        SICALT(5)='Halcrow, time invariant high   '
        SICALT(6)='CIBSE guide, time invariant    '
        SICALT(7)='CEN simplified calc method     '
        IX=1
        CALL EPICKS(IX,IVALS,' ','Internal surface convection model:',
     &    51,7,SICALT,'hc model',IER,nbhelp)
        ihct=IVALS(1)
        if(ihct.eq.0) ihct=1
      endif
      GOTO 3

      END

c ******************** ROAMING ********************
C Rotation of model coordinates as a function of time.

      SUBROUTINE ROAMING
#include "building.h"
#include "model.h"
#include "roam.h"
#include "help.h"

      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT

      character*72 DFLTNAME,OUTS
      character TEMPSTR*30
      integer IOK
      logical OK

      helpinsub='context'  ! set for subroutine

C Initialise variables
      IOK=0
      OK=.FALSE.

C Help message.
      helptopic='roaming_choices'
      call gethelptext(helpinsub,helptopic,nbhelp)
      WRITE(DFLTNAME,'(2A)')CFGROOT(1:LNBLNK(CFGROOT)),'.roam'
      IF(IROAM.NE.1)THEN
        LROAM=DFLTNAME
        IROAM=1
        CALL PHELPD('Roaming Introduction',nbhelp,'-',0,0,IER)
        CALL EASKMBOX(' ','Roaming file actions:',
     &    'create template','cancel',' ',' ',' ',' ',' ',' ',
     &    IOK,nbhelp)
        IF(IOK.EQ.1)THEN
          CALL WROAM
          CALL RROAM
        ENDIF
      ELSE
        CALL EASKS2CMD(LROAM,' ','Roaming file?',
     &    'dereference','browse',IACT,72,' ','Roaming file',
     &    IER,nbhelp)
        IF(IACT.EQ.1)THEN
          IROAM=0
          CALL EMKCFG('s',IER)
        ELSE
          CALL RROAM
        ENDIF
      ENDIF

C Display file contents.
      CALL EASKOK(' ','View location information?',OK,nbhelp)
      IF(OK)THEN
        CALL EDISP(IUOUT,' ')
        WRITE(OUTS,'(A,F3.1)')'Roaming file version number ',VERS
        CALL EDISP(IUOUT,OUTS)
        CALL EDISP(IUOUT,
     &  'Location                      Latitude Longitude')
        DO 1000 ILOC=1,NLOC
          WRITE(OUTS,'(A30,1X,F5.1,5X,F5.1)')
     &    LOCRM(ILOC),XLOCLT(ILOC),XLOCLG(ILOC)
          CALL EDISP(IUOUT,OUTS)
 1000   CONTINUE
        CALL EASKOK(' ','View cruise schedule?',OK,nbhelp)
        IF(OK)THEN
          CALL EDISP(IUOUT,
     &    'start hr, dy, mth, orientation, day type, location')
          DO 1100 IPDR=1,NPDR
            IF(LLOCT(IPDR).EQ.0)THEN
              TEMPSTR='cruising'
            ELSE
              TEMPSTR=LOCRM(LLOCT(IPDR))
            ENDIF
            WRITE(OUTS,'(5X,F3.0,1X,I3,2X,I3,7X,I4,5X,I2,7X,A30)')
     &      XLHRS(IPDR),LDYS(IPDR),LMTS(IPDR),LORNT(IPDR),
     &      LDTP(IPDR),TEMPSTR
          CALL EDISP(IUOUT,OUTS)
 1100     CONTINUE
        ENDIF
        CALL EDISP(IUOUT,' ')
      ENDIF

C Update configuration file
      CALL EDISP(IUOUT,'Updating configuration file ...')
      CALL EMKCFG('-',IER)
      RETURN
      END

C ******************** manageimages ********************
C Management of images associated with a model (delete not yet enabled).

      subroutine manageimages(modsit)
#include "building.h"
#include "model.h"
#include "help.h"

      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT
      common/user/browse

C Images.
      character imgfmt*4  ! GIF XBMP TIF JPG
      character imgfoc*4  ! FZON FNET FCTL FDFS FPLN
      character limgfil*72  ! file name (extend to 144 char)
      character imgdoc*248  ! text associated with image
      common/imagf/imgfmt(MIMG),imgfoc(MIMG),limgfil(MIMG),imgdoc(MIMG)

      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton

      logical MODSIT,browse,unixok

C ITEMS is menu for site/context items, ITEMIMG is menu for editing
C and control of project images.
      character*33 ITEMIMG(20)
      character outs*124
      character limg*72,key*1,fs*1
      character iformat*4,ifocus*4
      character sfile*72,snpfile*72
      character tcname*248   ! for editing image notes
      integer nimgitms,INOI  ! max items and current menu item
      integer ISTRW

      helpinsub='context'  ! set for subroutine

C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

  36  WRITE(ITEMIMG(1),'(a,i3,a)')'  current images ... (',noimg,')'
      M=1
      IF(noimg.GT.0)THEN
        M=M+1
        ITEMIMG(M)  ='  type focus file             '
        DO 35 IW=1,noimg
          M=M+1
          CALL EMKEY(M-2,KEY,IER)
          WRITE(ITEMIMG(M),'(a,1x,a,1x,a,1x,a)')KEY,imgfmt(IW),
     &      imgfoc(IW),limgfil(IW)(1:20)
  35    CONTINUE
        ITEMIMG(M+1)=' _____________________________ '
      else
        ITEMIMG(M+1)=' _____________________________ '
      ENDIF
      ITEMIMG(M+2)='+ add/delete image               '
      ITEMIMG(M+3)='! display current images         '
      ITEMIMG(m+4)='? help                           '
      ITEMIMG(m+5)='- exit menu                      '
      nimgitms=m+5

C Help text for menu.
      helptopic='model_image_management'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU('Project Images',ITEMIMG,nimgitms,INOI)
      if(INOI.EQ.nimgitms)then

C Update configuration if images have changed.
        if(MODSIT.and.(.NOT.browse))then
          CALL EMKCFG('s',IER)
        endif
        return
      elseif(INOI.EQ.nimgitms-1)then
        helptopic='model_image_management'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('Model images',nbhelp,'-',0,0,IER)
      elseif(INOI.EQ.nimgitms-2)then

C Display each of the current images by topic.
        call edisp(iuout,' ')
        call edisp(iuout,' General images...')
        if(noimg.gt.0)call imgdisp(1,'****',ier)
        call edisp(iuout,' Zone related images...')
        if(noimg.gt.0)call imgdisp(1,'FZON',ier)
        call edisp(iuout,' Network related images...')
        if(noimg.gt.0)call imgdisp(1,'FNET',ier)
        call edisp(iuout,' Control related images...')
        if(noimg.gt.0)call imgdisp(1,'FCTL',ier)
        call edisp(iuout,' Domain flow related images...')
        if(noimg.gt.0)call imgdisp(1,'FDFS',ier)
        call edisp(iuout,' Performance related images...')
        if(noimg.gt.0)call imgdisp(1,'FPER',ier)
        goto 36

      elseif(INOI.EQ.nimgitms-3)then

C Add images from images folder or other location.
        CALL EASKmbox(' ','Project image options:',
     &    'add from ../images folder','add from another folder',
     &    'delete','cancel',' ',' ',' ',' ',IOK,nbhelp)
        if(iok.eq.1)then
          if(noimg.ge.MIMG)then
            call edisp(iuout,'No more images can be associated with')
            call edisp(iuout,'the current model.')
            continue
          else

C Ask for names of files in the ../images folder.
            sfile=' '
            snpfile=' '
            call edisp(iuout,' ')
            call browsefilelist('?','img','fil',sfile,snpfile,nlist,
     &        iier)

C Try to use information gathered from file scan.
            if(nlist.gt.0)then
              sfile=' '
              snpfile=' '
              call browsefilelist('b','img','fil',sfile,snpfile,nlist,
     &          iier)
              if(snpfile(1:2).ne.'  ')then
                write(limg,'(3a)')imgpth(1:lnblnk(imgpth)),fs,
     &            snpfile(1:lnblnk(snpfile))
              else
                write(limg,'(a)')imgpth(1:lnblnk(imgpth))
              endif
            else
              write(limg,'(a)')imgpth(1:lnblnk(imgpth))
            endif
            iformat='GIF '
            ifocus='****'
            call edimage(limg,iformat,ifocus,iier)
            if(iier.eq.2)then
              continue
            elseif(iier.eq.0)then
              noimg=noimg+1
              limgfil(noimg)=limg
              imgfmt(noimg)=iformat
              imgfoc(noimg)=ifocus

C Edit image documentation if version supports it.
              if(icfgv.gt.3)then
                tcname=imgdoc(noimg)
                ISTRW=72
                CALL EASKS248(tcname,' ','Image notes?',
     &            ISTRW,'associated image','image notes',IER,nbhelp)
                if(tcname(1:2).ne.'  ')imgdoc(noimg)=tcname
              endif
              modsit=.true.
            endif
          endif
        elseif(iok.eq.2)then
          if(noimg.ge.MIMG)then
            call edisp(iuout,'No more images can be associated with')
            call edisp(iuout,'the current model.')
            continue
          else
            limg=' '
            call easks(limg,' ','Image file name?',72,'xxx.gif',
     &        'image file name',ier,12)
            iformat='GIF '
            ifocus='****'
            call edimage(limg,iformat,ifocus,iier)
            if(iier.eq.0)then
              noimg=noimg+1
              limgfil(noimg)=limg
              imgfmt(noimg)=iformat
              imgfoc(noimg)=ifocus

C Edit image description if version supports it.
              if(icfgv.gt.3)then
                tcname=imgdoc(noimg)
                ISTRW=72
                CALL EASKS248(tcname,' ','Image notes?',
     &            ISTRW,'associated image','image notes',IER,nbhelp)
                if(tcname(1:2).ne.'  ')imgdoc(noimg)=tcname
              endif
              modsit=.true.
              goto 36
            endif
          endif
        elseif(iok.eq.3)then
          DO 33 IW=1,noimg
            WRITE(outs,'(i2,1x,a,1x,a,1x,a)') iw,imgfmt(IW),
     &        imgfoc(IW),limgfil(IW)
            call edisp(iuout,outs)
  33      CONTINUE
          call usrmsg('Option to delete an image not available.',
     &                ' ','W')
          goto 36
        elseif(iok.eq.4)then
          goto 36
        endif
      elseif(INOI.EQ.1.and.noimg.gt.0)THEN
        goto 36
      elseif(inoi.gt.1.and.inoi.lt.nimgitms-4.and.noimg.gt.0)THEN

C Update the tags associated with the image. Remind the user about
C what they selected first.
        WRITE(outs,'(6a)') ' format ',imgfmt(inoi-2),
     &    ' focus ',imgfoc(inoi-2),' file ',limgfil(inoi-2)
        call edisp(iuout,outs)

        limg=limgfil(inoi-2)
        iformat=imgfmt(inoi-2)
        ifocus=imgfoc(inoi-2)
        call edimage(limg,iformat,ifocus,iier)
        if(iier.eq.2)then
          continue
        elseif(iier.eq.0)then
          limgfil(inoi-2)=limg
          imgfmt(inoi-2)=iformat
          imgfoc(inoi-2)=ifocus

C Edit current image description if version allows.
          if(icfgv.gt.3)then
            tcname=imgdoc(inoi-2)
            ISTRW=72
            CALL EASKS248(tcname,' ','Image notes?',
     &        ISTRW,'associated image','image notes',IER,nbhelp)
            if(tcname(1:2).ne.'  ')imgdoc(inoi-2)=tcname
          endif
          MODSIT=.true.
        endif
      endif
      goto 36
      end

C ******************** setuptemporal ********************
C Coordinates access to and initial creation of
C temporal data to be associated with a model.

      SUBROUTINE setuptemporal(MODSIT,IER)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "net_flow.h"
#include "net_flow_data.h"
#include "tdf2.h"
#include "control.h"
#include "CFC_common.h"
#include "help.h"

      integer lnblnk  ! function definition

      common/SPAD/MMOD,LIMIT,LIMTTY
      common/FILEP/IFIL
      common/OUTIN/IUOUT,IUIN,IEOUT
      common/user/browse

C TDF related.
      common/TDFFLG0/DBTAG(MIT),DBTASK(MIT),DBZN(MIT),DBSN(MIT)

      common/sctl/tcps,ictyp,iclaw,cm(misc)
      integer icascf
      common/cctl/icascf(mcom)
      integer iairn,icaas
      character LAPROB*72
      common/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      character PROMPT1*72, PROMPT2*72

      logical MODSIT,browse,OK,unixok
      logical FOUND,XST,shd_xst

      character outs*124,ltmp*72,hold*40
      character fs*1,msgl2*48
      character*72 DLTDF
      character DBTAG*12,DBTASK*12,DBZN*15,DBSN*15
      character OUTSTR*124,HDR*12
      character*34 ITEMS(7)
      integer ier,ian3,ilayer
      integer nitms,irt ! max items and current menu item
      dimension INPK(MNOD)

C Action to pass to tdfedit. Prior 'update' option moved into
C esrub2e rather than invoking tdf.
       character action*16

      helpinsub='context'  ! set for subroutine

C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Default name for temporal file. For all cases generate default name.
cx << check if name already defined, here??
      if(netpth(1:2).eq.'  '.or.netpth(1:2).eq.'./')then
        WRITE(DLTDF,'(2a)')cfgroot(1:lnblnk(cfgroot)),'_temporal.tdfa'
      else
        WRITE(DLTDF,'(4a)') netpth(1:lnblnk(netpth)),fs,
     &    cfgroot(1:lnblnk(cfgroot)),'_temporal.tdfa'
      endif

C Temporal definitions. Initial scan of configuration file would
C determine the state of the file:
      if(iabs(itdflg).eq.0)then
C        call edisp(iuout,' ')
C        call edisp(iuout,'No temporal data has been defined.')

      elseif(iabs(itdflg).eq.1.or.iabs(itdflg).eq.2)then

C If binary, must convert before listing what is available in temporal
C file, what is currently used and other management tasks.
        call edisp(iuout,' ')
        call edisp(iuout,'Temporal data is available for this model')
        call edisp(iuout,'but is held in an old format. Please')
        call edisp(iuout,'update via the edit/ list option.')

      elseif(iabs(itdflg).eq.3)then
        continue
      endif

C Take into account if the user is browsing or can modify the files
C and present a different interface depending on file type.
 42   helptopic='temporal_setup_menu'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Begin with high level menu.
    3 IER=0
      if(MMOD.eq.8)then
        IRT=-1
      else
        IRT=-2
      endif

      if(itdflg.eq.0)then
        if(browse)then
          call usrmsg(
     &   'No temporal data associated with this model! Because you',
     &   'are in browse mode no changes may be made.','W')
          return
        endif
        WRITE(ITEMS(1),'(A)')'a create temporal file'
        WRITE(ITEMS(2),'(A)')'b select temporal file'
        WRITE(ITEMS(3),'(A)')'c -'
        WRITE(ITEMS(4),'(A)')'? help'
        WRITE(ITEMS(5),'(A)')'- exit menu'
        nitms=5
        CALL EMENU('Temporal file options',ITEMS,nitms,irt)
        if(irt.EQ.nitms)then
          return
        elseif(irt.EQ.nitms-1)then
          helptopic='temporal_setup_menu'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
          goto 3
        elseif(irt.EQ.3)then
          goto 3
        elseif(irt.EQ.0)then
          goto 3
        endif
      elseif(iabs(itdflg).eq.1)then
        if(browse)then
          call usrmsg(
     &    'Temporal data is held in an outdated format!.',
     &    'Please update.','W')
          return
        endif
        WRITE(ITEMS(1),'(A)')'a view/edit temporal entities'
        WRITE(ITEMS(2),'(A)')'b select temporal file'
        WRITE(ITEMS(3),'(A)')'c dereference temporal file'
        WRITE(ITEMS(4),'(A)')'d list associations'
        WRITE(ITEMS(5),'(A)')'e manage associations'
        WRITE(ITEMS(6),'(A)')'? help'
        WRITE(ITEMS(7),'(A)')'- exit menu'
        nitms=7
        CALL EMENU('Temporal file options',ITEMS,nitms,irt)
        if(irt.EQ.nitms)then
          return
        elseif(irt.EQ.nitms-1)then
          CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
          goto 3
        elseif(irt.EQ.0)then
          goto 3
        endif
      elseif(iabs(itdflg).eq.2)then
        if(browse)then
          WRITE(ITEMS(1),'(A)')'a view temporal entities'
          WRITE(ITEMS(2),'(A)')'b -'
          WRITE(ITEMS(3),'(A)')'c list associations'
          WRITE(ITEMS(4),'(A)')'? help'
          WRITE(ITEMS(5),'(A)')'- exit menu'
          nitms=5
          CALL EMENU('Temporal file options:',ITEMS,nitms,irt)
          if(irt.EQ.nitms)then
            return
          elseif(irt.EQ.nitms-1)then
            CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
            goto 3
          elseif(irt.EQ.2)then
            goto 3
          elseif(irt.EQ.0)then
            goto 3
          endif
        else
          WRITE(ITEMS(1),'(A)')'a view/edit temporal entities'
          WRITE(ITEMS(2),'(A)')'b select temporal file'
          WRITE(ITEMS(3),'(A)')'c dereference temporal file'
          WRITE(ITEMS(4),'(A)')'d list associations'
          WRITE(ITEMS(5),'(A)')'e manage associations'
          WRITE(ITEMS(6),'(A)')'? help'
          WRITE(ITEMS(7),'(A)')'- exit menu'
          nitms=7
          CALL EMENU('Temporal file options:',ITEMS,nitms,irt)
          if(irt.EQ.nitms)then
            return
          elseif(irt.EQ.nitms-1)then
            CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
            goto 3
          elseif(irt.EQ.0)then
            goto 3
          endif
        endif
      elseif(iabs(itdflg).eq.3)then
        if(browse)then
          WRITE(ITEMS(1),'(A)')'a view temporal entities'
          WRITE(ITEMS(2),'(A)')'b -'
          WRITE(ITEMS(3),'(A)')'c list associations'
          WRITE(ITEMS(4),'(A)')'? help'
          WRITE(ITEMS(5),'(A)')'- exit menu'
          nitms=5
          CALL EMENU('Temporal file options:',ITEMS,nitms,irt)
          if(irt.EQ.nitms)then
            return
          elseif(irt.EQ.nitms-1)then
            CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
            goto 3
          elseif(irt.EQ.2)then
            goto 3
          elseif(irt.EQ.0)then
            goto 3
          endif
        else
          WRITE(ITEMS(1),'(A)')'a view/edit temporal entities'
          WRITE(ITEMS(2),'(A)')'b select temporal file'
          WRITE(ITEMS(3),'(A)')'c dereference temporal file'
          WRITE(ITEMS(4),'(A)')'d list associations'
          WRITE(ITEMS(5),'(A)')'e manage associations'
          WRITE(ITEMS(6),'(A)')'? help'
          WRITE(ITEMS(7),'(A)')'- exit menu'
          nitms=7
          CALL EMENU('Temporal file options:',ITEMS,nitms,irt)
          if(irt.EQ.nitms)then
            return
          elseif(irt.EQ.nitms-1)then
            CALL PHELPD('temporal help',nbhelp,'-',0,0,IER)
            goto 3
          elseif(irt.EQ.0)then
            goto 3
          endif
        endif
      endif
      IF(IRT.LT.1.OR.IRT.GT.7)GOTO 3
  27  continue

      if(IRT.eq.1)then

C Create a new file (itdflg = 0).
cx ... or view/edit entities (itdflg = 3) ... this seems to create trouble!
C If browsing do not bother to confim the file name.
        if(browse)then
          write(outs,'(2a)')'Temporal definitions ',LTDFA
          call edisp(iuout,outs)
        else

C If LTDFA is still UNKNOWN set to default name.
          if(LTDFA(1:4).eq.'UNKN') LTDFA=DLTDF
          ltmp=LTDFA
          CALL EASKS(ltmp,' ','Temporal definitions file?',
     &      72,DLTDF,'temporal definitions file',
     &      IER,nbhelp)
          if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
            LTDFA=ltmp
            MODSIT=.true.
          endif
        endif

C If creating a new file assist by checking whether there
C are simulation parameter sets and startup days to guide
C the user.

C Go into the tdf editing menu.
        action='-'
        call tdfedit(action,ier)
        goto 42
      elseif(IRT.eq.2)then

C Select (existing!) temporal file
C User supplies name of file. Find out its contents (using similar code
C to ersys) and jump back to the start of this subroutine.

C << later add add a file browse function it is probably in the nets
C << folder in most new models.
        if(LTDFA(1:4).eq.'UNKN') LTDFA=DLTDF
        ltmp=LTDFA
        CALL EASKS(ltmp,' ','Temporal definitions file?',
     &    72,DLTDF,'existing temporal definitions file',IER,nbhelp)
        if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
          continue
        else
          goto 42
        endif
        LTDFA=ltmp
        MODSIT=.true.
        CALL ERPFREE(IUTDF,ISTAT) ! (undefined) file unit handle iutdf now free ...
        call FINDFIL(LTDFA,XST)
        if(.NOT.XST)then
          goto 42
        endif

C Try to open as ascii file first. If that fails try as a binary file.
        CALL EFOPSEQ(IUTDF,LTDFA,1,IER)
        if(ier.eq.0)then
          CALL STRIPC(IUTDF,outstr,99,ND,1,'header',IER)
          if(OUTSTR(1:9).eq.'ASCIITDF3')THEN
            ITDFLG=3
            CALL ERPFREE(IUTDF,ISTAT)
          elseif(OUTSTR(1:9).eq.'ASCIITDF2')THEN
            ITDFLG=2
            CALL ERPFREE(IUTDF,ISTAT)
          elseif(OUTSTR(1:12).eq.'TDFdatabase2')THEN
            ITDFLG=1
            CALL ERPFREE(IUTDF,ISTAT)
          else

C Might have reached this point because it was a binary file.
C Scan the first record of this file.
            CALL ERPFREE(IUTDF,ISTAT)
            NWPR=MTABC
            ITWPR=NWPR+1
            ier=0
            call EFOPRAN(iutdf,LTDFA,ITWPR,1,IER)
            IREC=1
            READ(IUTDF,REC=IREC,IOSTAT=ISTAT,ERR=103)HDR,NWPR
            if(HDR(1:12).eq.'TDFdatabase2')THEN
              ITDFLG= -2
            elseif(HDR(1:12).eq.'TDFdatabase3')THEN
              ITDFLG= -3
            else
              ITDFLG=0
            endif
            CALL ERPFREE(IUTDF,ISTAT)
            if(iabs(itdflg).gt.1)then
              call usrmsg('Including temporal file in model ...',
     &          ' ','-')
              CALL EMKCFG('s',IER)
              call usrmsg('Including temporal file in model ...done.',
     &          ' ','-')
            endif
            goto 42
 103        msgl2='in the temporal file'
            CALL USRMSG(' could not read header record 1',msgl2,'W')
            CALL ERPFREE(IUTDF,ISTAT)
            ITDFLG=0
          endif
        else ! ier .ne. 0 from EFOPSEQ()
          CALL ERPFREE(IUTDF,ISTAT)
          NWPR=MTABC
          ITWPR=NWPR+1
          ier=0
          call EFOPRAN(iutdf,LTDFA,ITWPR,1,IER)
          IREC=1
          READ(IUTDF,REC=IREC,IOSTAT=ISTAT,ERR=102)HDR,NWPR
          if(HDR(1:12).eq.'TDFdatabase2')THEN
            ITDFLG= -2
          elseif(HDR(1:12).eq.'TDFdatabase3')THEN
            ITDFLG= -3
          else
            ITDFLG=0
          endif
          CALL ERPFREE(IUTDF,ISTAT)
          if(iabs(itdflg).gt.1)then
            call usrmsg('Including temporal file in model ...',
     &        ' ','-')
            CALL EMKCFG('s',IER)
            call usrmsg('Including temporal file in model ... done.',
     &        ' ','-')
          endif
          goto 42
 102      msgl2='in the temporal file'
          CALL USRMSG(' could not read header record 1',msgl2,'W')
          CALL ERPFREE(IUTDF,ISTAT)
          ITDFLG=0
        endif
        goto 42
      elseif(IRT.eq.3)then

C Dereference or ignore, depending on the file type.
        if(itdflg.eq.0)then
          continue
        else
          LTDF='UNKNOWN'
          LTDFA='UNKNOWN'
          call clrtabc
          itdflg=0
          NITDF=0
          call usrmsg('Removing temporal references ...',' ','-')
          CALL EMKCFG('s',IER)
          call usrmsg('Removing temporal references ... done.',' ','-')
          MODSIT=.false.
          return
        endif
      elseif(IRT.eq.4)then

C List associations.
        if(itdflg.eq.0)then
          continue
        else
          if(ITEMSTD.gt.0)then
            call edisp(iuout,' ')
            call edisp(iuout,' Temporal entities currently used')
            call edisp(iuout,'  ________________________________')
            call edisp(iuout,'  |temporal    |generic |associated')
            call edisp(iuout,
     &           '  |entity name |type    |with   zone &     surface ')
            do 28, l=1,ITEMSTD
              WRITE(outs,29)l,DBTAG(L),DBTASK(L),DBZN(L),DBSN(L)
   29         FORMAT(i2,1X,A,1X,A,5X,A,A)
              call edisp(iuout,outs)
  28        continue
            call edisp(iuout,' ')
          else
            call edisp(iuout,'Currently no temporal entities used.')
          endif
        endif
        goto 42
      elseif(IRT.eq.5)then

C Use/manage entity associations.
        if(itdflg.eq.0)then
          call usrmsg(
     &    'No temporal file! You can only create associations',
     &    'with existing entities. ','W')
          goto 42
        endif

        ltmp=LTDFA
        CALL EASKS(ltmp,' ','Temporal definitions file name?',
     &    72,DLTDF,'temporal definitions db name',IER,nbhelp)
        if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then

C Depending on its type read the header of the temporal file.
          LTDFA=ltmp
          MODSIT=.true.
          call supplyandcheck(ltdfa,'P',ier)
          IF(IER.NE.0)then
            call usrmsg('Problem opening ',LTDFA,'W')
            CALL ERPFREE(iutdfa,ISTAT)
            return
          endif
        else
          CALL ERPFREE(iutdfa,ISTAT)
          return
        endif

C Based on header advise user their current options.
        CALL ERPFREE(iutdfa,ISTAT)

C Befor management option list current db items and then associations.
 128    call edisp(iuout,' ______Temporal file contents__________')
        call edisp(iuout,' |temporal     |generic |description   ')
        call edisp(iuout,' |entity name  |type    |              ')
        M=0
        if(NITDF.eq.0)then
          call edisp(iuout,' No temporal items to select!')
          return
        endif
        DO 10 L=1,NITDF
          M=M+1
          WRITE(outs,14)M,TAG(L),TTYPE(L),TMENU(L)
   14     FORMAT(i2,1X,A,1X,A,1X,A)
          call edisp(iuout,outs)
   10   CONTINUE
        if(ITEMSTD.gt.0)then
          call edisp(iuout,' ')
          call edisp(iuout,'  _____Temporal entities used_____')
          call edisp(iuout,'  |temporal    |generic |associated')
          call edisp(iuout,
     &           '  |entity name |type    |with   zone &     surface ')
          do 228, l=1,ITEMSTD
            WRITE(outs,29)l,DBTAG(L),DBTASK(L),DBZN(L),DBSN(L)
            call edisp(iuout,outs)
  228     continue
          call edisp(iuout,' ')
        else
          call edisp(iuout,'Currently no temporal items used.')
        endif

C Manage the list of DBTAG/DBTASK/DBZN/DBSN.
        itro=0
        if(ITEMSTD.eq.0)then
          call easkMBOX(' ','Association options:',
     &      'n/a','add','cancel',' ',' ',' ',' ',' ',ITRO,nbhelp)
          if(itro.eq.3) goto 42
        else
          call easkmbox(' ','Association options:',
     &      'delete','add','edit',
     &      'cancel',' ',' ',' ',' ',ITRO,nbhelp)
          if(itro.eq.4) goto 42
        endif
        if(itro.eq.1)then

C Delete an association and move others up.
          CALL EASKI(it,' ','Temporal item to be removed?',
     &      1,'F',itemstd,'F',1,'selec index',
     &      IERI,nbhelp)
          if(ieri.eq.-3) goto 42

          if(it.eq.0)then
            goto 42
          elseif(it.eq.itemstd)then
            continue
          else
            do 791 idv=it,itemstd-1
              DBTAG(idv)=DBTAG(idv+1)
              DBTASK(idv)=DBTASK(idv+1)
              DBZN(idv)=DBZN(idv+1)
              DBSN(idv)=DBSN(idv+1)
  791       continue
          endif
          ITEMSTD=ITEMSTD-1
          MODSIT=.true.
          call usrmsg('Compacting temporal references ...',' ','-')
          CALL EMKCFG('s',IER)
          call usrmsg('Compacting temporal references ... done.',
     &                ' ','-')
          MODSIT=.false.
        elseif(itro.eq.2.or.itro.eq.3)then

C Add association or edit current association.
          if(itro.eq.3)then
            CALL EASKI(ite,' ','Temporal association to modify?',
     &        1,'F',itemstd,'F',1,'selec tdf assoc',
     &        IERI,nbhelp)
            if(ieri.eq.-3) goto 42
            if(ite.ne.0)then

C Reset itemstd to the item to be edited.
              call edisp(iuout,'The association details are:')
              WRITE(outs,29)ite,DBTAG(ite),DBTASK(ite),DBZN(ite),
     &             DBSN(ite)
              call edisp(iuout,outs)
              CALL EASKI(it,' ','Index of associated temporal item?',
     &              1,'F',NITDF,'F',1,'selec tdf index',IERI,nbhelp)
              if(ieri.eq.-3) goto 42
            endif
          elseif(itro.eq.2)then
            CALL EASKI(it,' ','Temporal item index to associate',
     &        1,'F',NITDF,'F',1,'selec tdf index',
     &        IERI,nbhelp)
            if(ieri.eq.-3) goto 42
            ITEMSTD=ITEMSTD+1
            ite=ITEMSTD
          endif
          DBTAG(ITE)=TAG(it)
          DBTASK(ITE)=TTYPE(it)

C Depending on the type of the data, ask for associated zone.
cx << wild mix of "it" and "ite", here???
          if(TTYPE(it)(1:6).eq.'CASUAL'.or.
     &       TTYPE(it)(1:7).eq.'ELECPWR')then
            IC=-1
 250        izdef=0
            if(TTYPE(it)(1:6).eq.'CASUAL')then
              call askzone(ic,izdef,'Related zone','-',
     &          'Casual gains requires a zone.',34,ier)
            elseif(TTYPE(it)(1:7).eq.'ELECPWR')then
              call askzone(ic,izdef,'Related zone',
     &        '-','Electrical real & reactive requires a zone.',34,ier)
            endif
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 250
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'

          elseif(TTYPE(it)(1:6).eq.'ZIVENT')then

C Use DBZN to indicate that tdf ventilation associated with a zone.
C << need to support the no ventilation case? >>
            IC=-1
 251        izdef=0
            call askzone(ic,izdef,'Related zone',
     &        '-','Ventilation requires a zone.',34,ier)
            IF(IC.EQ.-1)GOTO 251
            if(ic.eq.0)then
              write(DBZN(ITE),'(a)') 'none        '
            else
              write(DBZN(ITE),'(a)') zname(IC)(1:12)
            endif
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:6).eq.'RAIRVL')then

C << Think about this, it might need to know about which surfaces
C << the velocity should be associated with an outside surface?
            IC=-1
 252        izdef=0
            call askzone(ic,izdef,'Related zone',
     &        '-','Air velocity requires a zone.',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 252
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:6).eq.'CTLSTA')then

C << Think about what this could be used for...if could be a number
C << between 0.0 and 1.0 giving ON fraction.
            IC=-1
 254        izdef=0
            call askzone(ic,izdef,'Related zone',
     &        '-','Set point requires a zone.',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 254
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:6).eq.'ACTIVI'.or.
     &           TTYPE(it)(1:6).eq.'HTCLSE')then

C Depending on the type of the data, ask for associated zone.
            IC=-1
 1252       izdef=0
            call askzone(ic,izdef,'Related zone',
     &      '-','Activity db can be assigned to a zone.',
     &      34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 1252
            write(DBZN(ITE),'(a)') zname(IC)(1:12)

C If there is no control file warn the user that one will be added.
            if(ncf.eq.0)then
              call usrmsg(
     &        'There is no zone control file (or it has been.',
     &        'dereferenced). One will be defined automatically.','W')
            endif

C Ask the user whether there has already been a control law defined
C to use the setpoint. If so report on that control loop and offer
C selected information to alter. Contol law 23 is the one used for this
C temporal definition entity
            write(outs,'(a,i2,a)')'There are currently ',ncf,
     &        ' control loops.'
            call edisp(iuout,outs)
            call edisp(iuout,'  ')
            found=.false.
            call edisp(iuout,
     &  'Controls might be suitable for use with temporal data.')
            do 777 ijj=1,ncf
              if(ibclaw(ijj,1,1).eq.23)found=.true.
              call LSTCNTL(iuout,0,ijj)
 777        continue
            if(found)then

C If there are possible control laws and if the user selects one of them
C copy data into cm variables for later editing.
              helptopic='temporal_ctl_linkage'
              call gethelptext(helpinsub,helptopic,nbhelp)
              irtc=0
              CALL EASKMBOX(' ','Control linkage options:',
     &          'use existing','new','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1)then
                CALL EASKI(ispl,'Control loop to use set point data?',
     &            ' ',1,'F',ncf,'F',1,'cntrl loop for set point',
     &            IERI,nbhelp)
                if(ieri.eq.-3) goto 42
                izdef=iban(ispl,1)
                ibsn(ispl,1)=izdef
                ibsn(ispl,2)=0; ibsn(ispl,3)=0; ibsn(ispl,4)=0
                cm(2)=bmiscd(ispl,1,1,2)
                cm(3)=bmiscd(ispl,1,1,3)
              elseif(irtc.eq.3)then
                goto 42
              endif
            else

C If no control loop has been defined to associate with this temporal
C setpoint so create another one, fill in as much information as
C possible and link back to the temporal item. Increment ncf.
              call edisp(iuout,'No applicable controls found.')
              irtc=0
              CALL EASKMBOX(' ','Control linkage options:',
     &          'n/a','create new control','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1.or.irtc.eq.3)then
                goto 42
              endif
            endif

C Add another controls
            if(irtc.eq.2)then
              ispl=ncf+1
              ncf=ncf+1
              ibsn(ispl,1)=0
              ibsn(ispl,2)=0; ibsn(ispl,3)=0; ibsn(ispl,4)=0
              if(TTYPE(it)(1:6).eq.'ACTIVI')then
                cm(2)=5.0
                cm(3)=6.0
              elseif(TTYPE(it)(1:6).eq.'HTCLSE')then
                cm(2)=2.0
                cm(3)=3.0
              endif
            endif

            ibsn(ispl,1)=IC
            iban(ispl,1)=IC; iban(ispl,2)=0; iban(ispl,3)=0
            nbcdt(ispl)=1
            ibcdv(ispl,1,1)=1; ibcdv(ispl,1,2)=365
            nbcdp(ispl,1)=1
            tbcps(ispl,1,1)=0.0
            ibctyp(ispl,1,1)=0
            ibclaw(ispl,1,1)=23
            cm(1)=2.0

C Confirm capacities.
  553       WRITE(HOLD,'(2f8.0)')cm(2),cm(3)
            if(TTYPE(it)(1:6).eq.'ACTIVI')then
              CALL EASKS(HOLD,' ',
     &        'Heating and cooling setpoint column number?',
     &        40,' 5.0 6.0 ',
     &        'track another column number(s)',IER,nbhelp)
            elseif(TTYPE(it)(1:6).eq.'HTCLSE')then
              CALL EASKS(HOLD,' ',
     &        'Heating and cooling setpoint column number?',
     &        40,' 2.0 3.0 ',
     &        ' track another column number(s)',IER,nbhelp)
            endif
            K=0
            CALL EGETWR(HOLD,K,cm(2),0.,80.,'F','Max columns heat',IER)
            CALL EGETWR(HOLD,K,cm(3),0.,80.,'F','Max columns cool',IER)
            if(ier.ne.0)goto 553

C Update the control period data.
            bmiscd(ispl,1,1,1)=cm(1)
            bmiscd(ispl,1,1,2)=cm(2)
            bmiscd(ispl,1,1,3)=cm(3)

C Update the control file and link the control loop to the correct zone.
            icascf(IC)=ispl
            ICTLF=IFIL+1
            call usrmsg('Updating model control for temporal link ...',
     &        ' ','-')
            CALL CTLWRT(ICTLF,IER)
            CALL EMKCFG('s',IER)
            call usrmsg(
     &        'Updating model control for temporal link ... done.',
     &        ' ','-')
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:6).eq.'SETPTT')then

C If there is no control file warn the user to create one first.
            if(ncf.eq.0)then
              call usrmsg(
     &        'There is no zone control file. Please define one',
     &        'before you create or use a link to temporal data.','W')
              goto 42
            endif

C Present a summary of the steps needed to create a temporal-control link.
            helptopic='temporal_ctl_setpoints'
            call gethelptext(helpinsub,helptopic,nbhelp)
            CALL PHELPD('temporal-control popup',nbhelp,'-',0,0,IER)

C Ask the user whether there has already been a control law defined
C to use the setpoint. If so report on that control loop and offer
C selected information to alter. Either controls with a sensor
C first item equal to -5 or a control with a type 11 (match sensor)
C control law in the first period.
            write(outs,'(a,i2,a)')' There are currently ',ncf,
     &        ' control loops.'
            call edisp(iuout,outs)
            call edisp(iuout,'  ')
            found=.false.
            call edisp(iuout,
     &  'Controls might be suitable for use with temporal data.')
            do 77 ijj=1,ncf
              if(ibsn(ijj,1).eq.-5)then
                found=.true.
                call LSTCNTL(iuout,0,ijj)
              elseif(ibclaw(ijj,1,1).eq.11)then
                found=.true.
                call LSTCNTL(iuout,0,ijj)
              endif
  77        continue
            if(found)then

C If there are possible control laws and if the user selects one of them
C copy data into cm variables for later editing.
              irtc=0
              CALL EASKMBOX(' ','Control linkage options:',
     &          'use existing','new','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1)then
                CALL EASKI(ispl,'Control loop to use set point data?',
     &            ' ',1,'F',ncf,'F',1,'cntrl loop for set point',
     &            IERI,nbhelp)
                if(ieri.eq.-3) goto 42
                izdef=iban(ispl,1)
                ibsn(ispl,1)=izdef
                ibsn(ispl,2)=0; ibsn(ispl,3)=0; ibsn(ispl,4)=0
                cm(2)=bmiscd(ispl,1,1,2)
                cm(3)=bmiscd(ispl,1,1,3)
                cm(4)=bmiscd(ispl,1,1,4)
                cm(5)=bmiscd(ispl,1,1,5)
                cm(6)=bmiscd(ispl,1,1,6)
                cm(7)=bmiscd(ispl,1,1,7)
                cm(8)=bmiscd(ispl,1,1,8)
                cm(9)=bmiscd(ispl,1,1,9)
                cm(10)=bmiscd(ispl,1,1,10)
                cm(11)=bmiscd(ispl,1,1,11)
                cm(12)=bmiscd(ispl,1,1,12)
                cm(13)=bmiscd(ispl,1,1,13)
              elseif(irtc.eq.3)then
                goto 42
              endif
            else

C If no control loop has been defined to associate with this temporal
C setpoint so create another one, fill in as much information as
C possible and link back to the temporal item. Increment ncf.
              call edisp(iuout,'No applicable controls found.')
              irtc=0
              CALL EASKMBOX(' ','Control linkage options:',
     &          'n/a','create new control','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1.or.irtc.eq.3)then
                goto 42
              endif
            endif

C Add another controls
            if(irtc.eq.2)then
              ispl=ncf+1
              ncf=ncf+1
              ibsn(ispl,1)=0
              ibsn(ispl,2)=0; ibsn(ispl,3)=0; ibsn(ispl,4)=0
              cm(2)=5000.0; cm(3)=0.0
              cm(4)=5000.0; cm(5)=0.0
              izdef=0
            endif
            if(ispl.le.9)then
              write(DBZN(ITE),'(a5,i1)') 'loop_',ispl
            else
              write(DBZN(ITE),'(a5,i2)') 'loop_',ispl
            endif

C Confirm which zone to use with this control. Then instantiate
C all of the usual values for control-temporal links. Note that
C even though cm(8) - cm(13) does not seem to be used set them.
            IC=-1
 255        call askzone(ic,izdef,'Related zone',
     &        '-','Set point requires a zone.',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 255
            ibsn(ispl,1)=IC
            iban(ispl,1)=IC; iban(ispl,2)=0; iban(ispl,3)=0
            nbcdt(ispl)=1
            ibcdv(ispl,1,1)=1; ibcdv(ispl,1,2)=365
            nbcdp(ispl,1)=1
            tbcps(ispl,1,1)=0.0
            ibctyp(ispl,1,1)=0
            ibclaw(ispl,1,1)=11
            cm(1)=12.0
            cm(6)=1.0;  cm(7)=3.0
            cm(8)=-5.0; cm(9)=ITE
            cm(10)=0.0; cm(11)=0.0
            cm(12)=1.0; cm(13)=0.0

C Confirm capacities.
  53        WRITE(HOLD,'(4f8.0)')cm(2),cm(3),cm(4),cm(5)
            CALL EASKS(HOLD,
     &      ' Max & Min heat capacity, Max & Min cool capacity for',
     &      ' matching another temp: ',40,' 10000. 0.0 10000. 0.0 ',
     &      ' track another max min heat cool',IER,nbhelp)
            K=0
            CALL EGETWR(HOLD,K,cm(2),0.,999999.,'F','Max Heat',IER)
            CALL EGETWR(HOLD,K,cm(3),0.,999999.,'F','Min Heat',IER)
            CALL EGETWR(HOLD,K,cm(4),0.,999999.,'F','Max Cool',IER)
            CALL EGETWR(HOLD,K,cm(5),0.,999999.,'F','Min Cool',IER)
            if(ier.ne.0)goto 53

C Update the control period data.
            bmiscd(ispl,1,1,1)=cm(1)
            bmiscd(ispl,1,1,2)=cm(2)
            bmiscd(ispl,1,1,3)=cm(3)
            bmiscd(ispl,1,1,4)=cm(4)
            bmiscd(ispl,1,1,5)=cm(5)
            bmiscd(ispl,1,1,6)=cm(6)
            bmiscd(ispl,1,1,7)=cm(7)
            bmiscd(ispl,1,1,8)=cm(8)
            bmiscd(ispl,1,1,9)=cm(9)
            bmiscd(ispl,1,1,10)=cm(10)
            bmiscd(ispl,1,1,11)=cm(11)
            bmiscd(ispl,1,1,12)=cm(12)
            bmiscd(ispl,1,1,13)=cm(13)

C Update the control file and link the control loop to the correct zone.
            icascf(IC)=ispl
            ICTLF=IFIL+1
            call usrmsg('Updating model control for temporal link ...',
     &        ' ','-')
            CALL CTLWRT(ICTLF,IER)
            CALL EMKCFG('s',IER)
            call usrmsg(
     &        'Updating model control for temporal link ... done.',
     &        ' ','-')
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:8).eq.'BIDIRSET')then

C Depending on the type of data, ask for associated surface.
            IC=-1
 352        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Optical sets require a zone.',
     &        34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 352
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            call easksur(IC,ISUR,'-',
     &           'Select surface for bidirectional dataset',' ',IER)
            IF(ISUR.EQ.0.OR.ISUR.EQ.-1)GOTO 352
            write(DBSN(ITE),'(a)') sname(IC,ISUR)(1:12)
          elseif(TTYPE(it)(1:7).eq.'VERTSOL')then

C Depending on the type of data, ask for associated zone & surface.
            IC=-1
 353        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','zone to assign solar data.',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 353
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            call easksur(IC,ISUR,'-',
     &           'Select surface to apply vertical solar data',' ',IER)
            IF(ISUR.EQ.0.OR.ISUR.EQ.-1)GOTO 353
            write(DBSN(ITE),'(a)') sname(IC,ISUR)(1:12)
          elseif(TTYPE(it)(1:8).eq.'DBTZNOBS')then

C Observed db T (associated with a zone to allow reporting). Note: bps
C will not use these values only for reporting in res.
            IC=-1
 354        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Observed db T for which zone?',
     &        34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 354
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:7).eq.'ZNRHOBS')then

C Observed RH (associated with a zone to allow reporting). Note: bps
C will not use these values only for reporting in res.
            IC=-1
 359        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Observed RH for which zone?',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 359
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:7).eq.'ZNHTOBS')then

C Observed heating (associated with a zone to allow reporting). Note: bps
C will not use these values only for reporting in res.
            IC=-1
 357        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Observed heating for which zone?',
     &        34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 357
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:7).eq.'ZNCLOBS')then

C Observed cooling (associated with a zone to allow reporting). Note: bps
C will not use these values only for reporting in res.
            IC=-1
 358        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Observed cooling for which zone?',
     &        34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 358
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:7).eq.'SURTOBS')then

C Measured surface T (associated with a zone and up to 6 surfaces to allow
C the values to be reported). Note: the simulator will not use these values
C only for reporting in res.
            IC=-1
 355        izdef=0
            call askzone(ic,izdef,'Related zone','-',
     &        'Measured surface T within which zone?',34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 355
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            call easksur(IC,ISUR,'-',
     &        'Select surface associated with measured temperature',
     &        ' ',IER)
            IF(ISUR.EQ.0.OR.ISUR.EQ.-1)GOTO 355
            write(DBSN(ITE),'(a)') sname(IC,ISUR)(1:12)
          elseif(TTYPE(it)(1:8).eq.'NODPRESS')then

C Exit if no flow network present or no nodes defined
            if(iairn.eq.0)then
              call usrmsg
     &        ('Define flow network before linking node pressures'
     &        ,' ','W')
            elseif(nnod.le.0)then
              call usrmsg
     &        ('Define flow nodes before linking node pressures'
     &        ,' ','W')
            else

C Ask for node name if flow network is present
              INOPT=0
              NNPK=1
              PROMPT1='Which node to link to this pressure'
              PROMPT2='  '
              call ASKMFNOD(INOPT,NNPK,INPK,PROMPT1,PROMPT2,nbhelp)
              write(DBZN(ITE),'(a)')ndnam(inpk(1))(1:12)
              write(DBSN(ITE),'(a)')'No surf reqd'
            endif
          elseif(TTYPE(it)(1:8).eq.'CTRLCAP')then

C Ask which zone is linked to charging schedule
            IC=-1
 356        izdef=0
            call askzone(ic,izdef,
     &        'Related zone','-','Charging schedule for which zone?',
     &        34,ier)
            IF(IC.EQ.0.OR.IC.EQ.-1)GOTO 356
            write(DBZN(ITE),'(a)') zname(IC)(1:12)
            DBSN(ITE)='ALL'

C **** CFCCTL => Copy from SETPTT.

          elseif(TTYPE(it)(1:6).eq.'CFCCTL') then

C If there is no control file warn the user to create one first.
            if(nCFCctlloops.eq.0)then
              call usrmsg(
     &        'There are no CFC control loops defined. Please define ',
     &        'before you create or use a link to temporal data.','W')
              goto 42
            endif

C Present a summary of the steps needed to create a temporal-control link.
cx << new entry for CFCCTL ??!!
            helptopic='temporal_ctl_setpoints'
            call gethelptext(helpinsub,helptopic,nbhelp)
            CALL PHELPD('temporal-control popup',nbhelp,'-',0,0,IER)

C Ask the user whether there has already been a control law defined
C to use the setpoint. If so report on that control loop and offer
C selected information to alter. Controls with a sensor
C first item equal to -5 and a control with a type 9
C control law in the first period.
            write(outs,'(a,i2,a)')' There are currently ',nCFCctlloops,
     &        ' CFC control loops.'
            call edisp(iuout,outs)
            call edisp(iuout,'  ')
            found=.false.
            call edisp(iuout,
     &  'Controls might be suitable for use with temporal data.')
            do 78 ijj=1,nCFCctlloops
              if(iCFCsensor(ijj,1).eq.-5)then
                found=.true.
                call LSTCNTL(iuout,0,ijj)
              endif
  78        continue
            if(found) then

C There are possible control loops. If the user selects one of them
C copy data into cm variables for later editing.
              irtc=0
              CALL EASKMBOX(' ','CFC control linkage options:',
     &          'use existing',' new','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1)then
                CALL EASKI(ispl,'Control loop to use tdf data?',
     &            ' ',1,'F',nCFCctlloops,'F',ijj,
     &            'cntrl loop for tdf data',IERI,nbhelp)
                if(ieri.eq.-3) goto 42
                iCFCsensor(ispl,1)=-5
                iCFCsensor(ispl,2)=ICFCCTL(ispl) ! <= this should be the tdf entry number
                iCFCsensor(ispl,3)=0
                iCFCsensor(ispl,4)=0
                cm(2)=bmiscd(ispl,1,1,2)
                cm(3)=bmiscd(ispl,1,1,3)
cx                cm(4)=bmiscd(ispl,1,1,4)
cx                cm(5)=bmiscd(ispl,1,1,5)
              elseif(irtc.eq.2) then

C Create new.
              elseif(irtc.eq.3)then
                goto 42
              endif
            else ! not found

C No control loop has been defined to associate with this temporal
C setpoint so create another one, fill in as much information as
C possible and link back to the temporal item. Increment nCFCctlloops.
              call edisp(iuout,'No applicable controls found.')
              irtc=0
              CALL EASKMBOX(' CFC control linkage options:',' ',
     &          'n/a','create new control','cancel',
     &          ' ',' ',' ',' ',' ',IRTC,nbhelp)
              if(irtc.eq.1.or.irtc.eq.3)then
                goto 42
              endif
            endif ! check for existing ctl loop linked to tdf

C Add another CFC control loop
            if(irtc.eq.2)then
              nCFCctlloops=nCFCctlloops+1
              ispl=nCFCctlloops
              iCFCsensor(ispl,1)=-5
              iCFCsensor(ispl,2)=it ! <= tdf entry number, no??!!
              iCFCsensor(ispl,3)=0
              iCFCsensor(ispl,4)=0
              cm(2)=0.0
              cm(3)=0.0
            endif

            if(ispl.le.9)then
              write(DBZN(ITE),'(a5,i1)') 'loop_',ispl
            else
              write(DBZN(ITE),'(a5,i2)') 'loop_',ispl
            endif

C Confirm which zone and which CFC type to use with this control.
C Then instantiate all of the usual values for CFC control-temporal links.
            IC=-1
            CALL EPMENSV
 256        call askzone(ic,izdef,'Related zone',
     &        '-','CFC control requires a zone.',34,ier)
            CALL EPMENRC ! ... seems to be good practice ... ??
            IF(IC.EQ.0.OR.IC.EQ.-1) GOTO 256

C Ask for CFC type in selected zone.
  92        call askCFCtype(IC,ian3,IER)

C Check that selected CFC type contains a shading layer.
            shd_xst=.false.
            do 1001 ilayer=1,ncfc_el(IC, ian3)
              if(icfcltp(IC,ian3,ilayer).gt.iGlazing) shd_xst=.true.
 1001       continue
            if(.not.shd_xst)then
cx              SELECT=.false.
              CALL USRMSG(' Shading layer not found, ',
     &                         'please select another CFC type','W')
              CALL EPMENRC
              goto 92
            endif
            CALL EPMENRC

cx << this block of code seems slightly "random", here ...
cx << move to "if irtc.eq.2", above?
            iCFCsensor(ispl,1)=-5
            iCFCsensor(ispl,2)=it      ! tdf entry number ... (?)

            iCFCactuator(ispl,1)=9
            iCFCactuator(ispl,2)=IC    ! Zone picked
            iCFCactuator(ispl,3)=ian3  ! CFC type in zone

            nCFCctldaytypes(ispl)=1
            iCFCctldatevalid(ispl,1,1)=1;
            iCFCctldatevalid(ispl,1,2)=365
            nCFCdayctlperiods(ispl,1)=1
            CFCctlperiodstart(ispl,1,1)=0.0
            iCFCctltype(ispl,1,1)=9
cx            iCFCclaw(ispl,1,1)=9
            cm(1)=2.0
            cm(2)=0.0 ! default value on/off (=off)
            cm(3)=0.0 ! default slat angle (0 deg, aka horizontal)

C Confirm default values.
  54        WRITE(HOLD,'(2f6.0)') cm(2),cm(3) !,cm(4),cm(5)
            CALL EASKS(HOLD,
     &      ' Default ON/OFF state, default slat angle',
     &      ': ',40,' 0.0 0.0 ',
     &      ' track another data set',IER,nbhelp)
            K=0
            CALL EGETWR(HOLD,K,cm(2),0.,1.,'F','ON/OFF',IER)
            CALL EGETWR(HOLD,K,cm(3),-90.,90.,'F','Slat angle',IER)

            if(ier.ne.0) goto 54

C Update the control period data.
            bmiscd(ispl,1,1,1)=cm(1)
            bmiscd(ispl,1,1,2)=cm(2)
            bmiscd(ispl,1,1,3)=cm(3)

C Update the control file.
            ICTLF=IFIL+1
          call usrmsg('Updating control file for CFC temporal link...',
     &        ' ','-')
            CALL CTLWRT(ICTLF,IER)
            CALL EMKCFG('s',IER)
            call usrmsg(
     &        'Updating control file for CFC temporal link...done.',
     &        ' ','-')
            DBSN(ITE)='ALL'

cx **** END CFCCTL
cx ******************************************************************
          elseif(TTYPE(it)(1:7).eq.'SUPPLWT')then
            itdfpcmp=0
            CALL EASKI(itdfpcmp,
     &        'Plant component number to associate with',
     &        'measured temperatures',1,'F',MPCOM,'F',1,'input number',
     &        IERI,nbhelp)
            if(itdfpcmp.le.9)then
              write(DBZN(ITE),'(A9,I1)') 'plantCom_', itdfpcmp !plant component number
            elseif(itdfpcmp.ge.10.and.itdfpcmp.le.99)then
              write(DBZN(ITE),'(A9,I2)') 'plantCom_', itdfpcmp !plant component number
            else
              write(DBZN(ITE),'(A9,I3)') 'plantCom_', itdfpcmp !plant component number
            endif
            DBSN(ITE)='ALL'
          elseif(TTYPE(it)(1:7).eq.'PUMPVFR')then
            itdfpvfrcmp=0
            CALL EASKI(itdfpvfrcmp,
     &        'Plant component number to associate with',
     &        'measured flow rate',1,'F',MPCOM,'F',1,'input number',
     &        IERI,nbhelp)
            if(itdfpvfrcmp.le.9)then
              write(DBZN(ITE),'(A12,I1)') 'plantVFRCom_', itdfpvfrcmp !plant component number
            elseif(itdfpvfrcmp.ge.10.and.itdfpvfrcmp.le.99)then
              write(DBZN(ITE),'(A12,I2)') 'plantVFRCom_', itdfpvfrcmp !plant component number
            else
              write(DBZN(ITE),'(A12,I3)') 'plantVFRCom_', itdfpvfrcmp !plant component number
            endif
            DBSN(ITE)='ALL'
          else
            DBZN(ITE)='ALL'
            DBSN(ITE)='ALL'
          endif
          if(itro.eq.2)then
            CALL EASKOK(' ','Use another temporal item?',OK,nbhelp)
            if(OK)then
              IRT=4
              goto 27
            endif
          endif
          call usrmsg('Updating temporal references...',' ','P')
          CALL EMKCFG('s',IER)
          call usrmsg('Updating temporal references...done.',' ','-')
        endif
        goto 128
      endif

C Close the tdf file..
      CALL ERPFREE(iutdfa,ISTAT)
      return
      end

C ************* PECONV
C Conversion factors for conversion to primary energy units.
C Conversion from demand units TO primary energy units are:
C  pcnvht = multiplier for plant heating
C  pcnvcl = multiplier for plant cooling
C  pcnvlt = multiplier for lighting casual gain
C  pcnvfn = multiplier for fan/pump casual gain
C  pcnvsp = multiplier for small power casual gain
C  pcnvhw = multiplier for hot water
C  phtco2,phtnox,phtsox = heat related emissions co2/nox/sox
C  pclco2,pclnox,pclsox = cooling related emissions co2/nox/sox
C  pltco2,pltnox,pltsox = lighting related emissions co2/nox/sox
C  pfnco2,pfnnox,pfnsox = fan/pump related emissions co2/nox/sox
C  pspco2,pspnox,pspsox = small power related emissions co2/nox/sox
C  phwco2,phwnox,phwsox = how water related emissions co2/nox/sox
      subroutine peconv(act)
#include "help.h"

      common/PCONV/ipconv,pcnvht,pcnvcl,pcnvlt,pcnvfn,pcnvsp,pcnvhw
      common/CONVEM/phtco2,phtnox,phtsox,pclco2,pclnox,pclsox,
     &              pltco2,pltnox,pltsox,pfnco2,pfnnox,pfnsox,
     &              pspco2,pspnox,pspsox,phwco2,phwnox,phwsox

      dimension ITEMS(18)
      character items*36,hold*40,act*1
      logical MODSIT
      integer nitms,INO ! max items and current menu item

      helpinsub='context'  ! set for subroutine

      MODSIT=.false.

C If act = 'i' then initialise variables.
      if(act(1:1).eq.'i'.or.act(1:1).eq.'I')then
        helptopic='primary_energy_conv'
        call gethelptext(helpinsub,helptopic,nbhelp)
        ipconv=1
        call easkmbox('Typical patterns',' ','UK','Europe','zeros',
     &    ' ',' ',' ',' ',' ',IW,nbhelp)
        if(IW.eq.1)then
          pcnvht=1.53; pcnvcl=1.44; pcnvlt=3.6; pcnvfn=3.6
          pcnvsp=3.6; pcnvhw=1.53
          phtco2=190.0; phtnox=0.3; phtsox=0.2; pclco2=612.0
          pclnox=2.06; pclsox=7.57
          pltco2=612.0; pltnox=2.06; pltsox=7.57; pfnco2=612.0
          pfnnox=2.06; pfnsox=7.57
          pspco2=612.0; pspnox=2.06; pspsox=7.57; phwco2=190.0
          phwnox=0.3; phwsox=0.2
        elseif(IW.eq.2)then
          pcnvht=1.53; pcnvcl=1.44; pcnvlt=3.6; pcnvfn=3.6
          pcnvsp=3.6; pcnvhw=1.53
          phtco2=190.0; phtnox=0.3; phtsox=0.2; pclco2=360.0
          pclnox=1.2; pclsox=4.5
          pltco2=360.0; pltnox=1.2; pltsox=4.5; pfnco2=360.0
          pfnnox=1.2; pfnsox=4.5
          pspco2=360.0; pspnox=1.2; pspsox=4.5; phwco2=190.0
          phwnox=0.3; phwsox=0.2
        elseif(IW.eq.3)then
          pcnvht=1.0; pcnvcl=1.0; pcnvlt=1.0; pcnvfn=1.0
          pcnvsp=1.0; pcnvhw=1.0
          phtco2=0.0; phtnox=0.0; phtsox=0.0; pclco2=0.0
          pclnox=0.0; pclsox=0.0
          pltco2=0.0; pltnox=0.0; pltsox=0.0; pfnco2=0.0
          pfnnox=0.0; pfnsox=0.0
          pspco2=0.0; pspnox=0.0; pspsox=0.0; phwco2=0.0
          phwnox=0.0; phwsox=0.0
        endif
        CALL EMKCFG('s',IER)
        return
      endif

    3 INO=-4
      IIER=0

      items(1)                 = '  multipliers demand > primary - '
      WRITE(ITEMS(2),'(A,F6.3)') 'a  heating   :',pcnvht
      WRITE(ITEMS(3),'(A,F6.3)') 'b  cooling   :',pcnvcl
      WRITE(ITEMS(4),'(A,F6.3)') 'c  lighting  :',pcnvlt
      WRITE(ITEMS(5),'(A,F6.3)') 'd  fans&pumps:',pcnvfn
      WRITE(ITEMS(6),'(A,F6.3)') 'e  small powr:',pcnvsp
      WRITE(ITEMS(7),'(A,F6.3)') 'f  hot water :',pcnvhw
      ITEMS(8)=                   '  ______________________________   '
      ITEMS(9)=                   '  emissions (g/kWh) co2  nox  sox  '
      WRITE(ITEMS(10),'(A,3F7.2)')'h heating : ',phtco2,phtnox,phtsox
      WRITE(ITEMS(11),'(A,3F7.2)')'i cooling : ',pclco2,pclnox,pclsox
      WRITE(ITEMS(12),'(A,3F7.2)')'j lighting: ',pltco2,pltnox,pltsox
      WRITE(ITEMS(13),'(A,3F7.2)')'k fan_pump: ',pfnco2,pfnnox,pfnsox
      WRITE(ITEMS(14),'(A,3F7.2)')'l small pr: ',pspco2,pspnox,pspsox
      WRITE(ITEMS(15),'(A,3F7.2)')'m hot water:',phwco2,phwnox,phwsox
      ITEMS(16)=                  '  ______________________________   '
      ITEMS(17)=                  '? help                             '
      ITEMS(18)=                  '- exit menu                        '
      nitms=18

C Help text for this menu.
  4   helptopic='primary_energy_conv'
      call gethelptext(helpinsub,helptopic,nbhelp)

      CALL EMENU('Conversions to primary',ITEMS,nitms,INO)

      if(INO.EQ.nitms)then
        if(MODSIT)CALL EMKCFG('s',IER)
        RETURN
      elseif(INO.EQ.nitms-1)then
        CALL PHELPD('prim convers',nbhelp,'-',0,0,IER)
      elseif(ino.eq.2)then
        CALL EASKR(pcnvht,' ','Heating primary energy multiplier:',
     &       1.0,'W',5.0,'W',1.25,'heat prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.3)then
        CALL EASKR(pcnvcl,' ','Cooling primary energy multiplier:',
     &       1.0,'W',5.0,'W',3.6,'cool prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.4)then
        CALL EASKR(pcnvlt,' ','Lighting primary energy multiplier:',
     &       1.0,'W',5.0,'W',3.6,'light prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.5)then
        CALL EASKR(pcnvfn,' ','Fans & pumps primary energy multiplier:',
     &       1.0,'W',5.0,'W',3.6,'fans prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.6)then
        CALL EASKR(pcnvsp,' ','Small power primary energy multiplier:',
     &       1.0,'W',5.0,'W',3.6,'sml pwr prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.7)then
        CALL EASKR(pcnvhw,' ','Hot water primary energy multiplier:',
     &       1.0,'W',5.0,'W',3.6,'hot water prim multip',IER,nbhelp)
        MODSIT=.true.
      elseif(ino.eq.10)then
   95   hold = ' '
        WRITE(HOLD,'(3F10.3)')phtco2,phtnox,phtsox
        CALL EASKS(HOLD,'Heating related emissions [gr/kWh primary]:',
     &    'CO2 NOx & SOx ',40,' 190.  0.2  0.1 ','heat emiss',
     &    IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,phtco2,0.,999.,'W','ht co2',IIER)
        CALL EGETWR(HOLD,K,phtnox,0.,999.,'W','ht nox',IIER)
        CALL EGETWR(HOLD,K,phtsox,0.,999.,'W','ht sox',IIER)
        if(iier.ne.0)goto 95
        MODSIT=.true.
      elseif(ino.eq.11)then
   96   hold = ' '
        WRITE(HOLD,'(3F10.3)')pclco2,pclnox,pclsox
        CALL EASKS(HOLD,'Cooling related emissions [gr/kWh primary]:',
     &    'CO2 NOx & SOx ',40,' 612.  2.06   7.5 ','cool emiss',
     &    IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,pclco2,0.,999.,'W','cl co2',IIER)
        CALL EGETWR(HOLD,K,pclnox,0.,999.,'W','cl nox',IIER)
        CALL EGETWR(HOLD,K,pclsox,0.,999.,'W','cl sox',IIER)
        if(iier.ne.0)goto 96
        MODSIT=.true.
      elseif(ino.eq.12)then
   97   hold = ' '
        WRITE(HOLD,'(3F10.3)')pltco2,pltnox,pltsox
        CALL EASKS(HOLD,'Lighting related emissions [gr/kWh primary]:',
     &   'CO2 NOx & SOx ',40,' 612.  2.06   7.5 ','light emiss',
     &   IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,pltco2,0.,999.,'W','lt co2',IIER)
        CALL EGETWR(HOLD,K,pltnox,0.,999.,'W','lt nox',IIER)
        CALL EGETWR(HOLD,K,pltsox,0.,999.,'W','lt sox',IIER)
        if(iier.ne.0)goto 97
        MODSIT=.true.
      elseif(ino.eq.13)then
   98   hold = ' '
        WRITE(HOLD,'(3F10.3)')pfnco2,pfnnox,pfnsox
        CALL EASKS(HOLD,'Fan & pump emissions [gr/kWh primary]:',
     &    'CO2 NOx & SOx ',40,' 612.  2.06   7.5 ','fan emiss',
     &    IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,pfnco2,0.,999.,'W','fan co2',IIER)
        CALL EGETWR(HOLD,K,pfnnox,0.,999.,'W','fan nox',IIER)
        CALL EGETWR(HOLD,K,pfnsox,0.,999.,'W','fan sox',IIER)
        if(iier.ne.0)goto 98
        MODSIT=.true.
      elseif(ino.eq.14)then
   99   hold = ' '
        WRITE(HOLD,'(3F10.3)')pspco2,pspnox,pspsox
        CALL EASKS(HOLD,'Small power emissions [gr/kWh primary]:',
     &    'CO2 NOx & SOx ',40,'612.   2.06  7.5 ','smlp emiss',
     &    IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,pspco2,0.,999.,'W','sml co2',IIER)
        CALL EGETWR(HOLD,K,pspnox,0.,999.,'W','sml nox',IIER)
        CALL EGETWR(HOLD,K,pspsox,0.,999.,'W','sml sox',IIER)
        if(iier.ne.0)goto 99
        MODSIT=.true.
      elseif(ino.eq.15)then
   94   hold = ' '
        WRITE(HOLD,'(3F10.3)')phwco2,phwnox,phwsox
        CALL EASKS(HOLD,'Hot water emissions [gr/kWh primary]:',
     &    'CO2 NOx & SOx ',40,' 190.  0.2  0.1 ','dhw emiss',
     &    IIER,nbhelp)
        K=0
        CALL EGETWR(HOLD,K,phwco2,0.,999.,'W','hw co2',IIER)
        CALL EGETWR(HOLD,K,phwnox,0.,999.,'W','hw nox',IIER)
        CALL EGETWR(HOLD,K,phwsox,0.,999.,'W','hw sox',IIER)
        if(iier.ne.0)goto 94
        MODSIT=.true.
      else
        INO=-4
        GOTO 4
      endif
      INO=-4
      GOTO 3

      end

C ********** calenmanage **************
C Sets up and manages a calendar for ESP-r. Currently
C up to 15 day types (MDTY) can be defined and one may be assigned to
C each of the 365 days of the year.
C calename (char*32) is the overall name of this calendar (e.g. `UK standard`)
C calentag (char*12) is a tag for each day type (e.g. `autumn_wkd`)
C calendayname (char*32) menu phrase for each day type (e.g.
C   `autumn weekdays`
C nbdaytype (int) is the number of day types
C nbcaldays (int) is the number of days associated with each type
C icalendar (int*365) for each day, the associated day type
C act (char*1) action to take 'i' initialise, '-' interactive

C Note that there is no specific logic to remind a user to update the
C model cfg file if a change is made.
      subroutine calenmanage(act,ier)
      implicit none

#include "epara.h"
#include "building.h"
#include "model.h"
#include "esprdbfile.h"
#include "espriou.h"
#include "schedule.h"
#include "seasons.h"
#include "help.h"

      integer lnblnk  ! function definition

C Parameters passed
      character act*1 ! action to take
      integer ier     ! error state

      integer iuout,iuin,ieout
      common/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/FILEP/IFIL
      integer ifil
      integer iyear,ibdoy,iedoy,ifday,iftime
      common/set1/iyear,ibdoy,iedoy,ifday,iftime
      common/user/browse
      common/calena/calename,calentag(MDTY),calendayname(MDTY)
      character calename*32,calentag*12,calendayname*32
      common/caleni/nbdaytype,nbcaldays(MDTY),icalender(365)
      integer nbdaytype,nbcaldays,icalender
      common/cctlnm/ctldoc,lctlf
      character ctldoc*248,lctlf*72
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

C Local variables.
      integer MVERT,IVERT,mcvert,icvert ! max items and current menu item
      integer ib,ld,l,idayloop,loop ! index for looping
      integer ijd,idayn,idwk,idt,idtt,imthn,ixd   ! for counting days
      integer idno,istjandwk,ISDS,ISDF   ! for counting days
      integer ifoc,ifrq,ihdt,m,mj,ij,mm,loopst,ix,io,isw,ipact,irt ! for position
      integer ictlf  ! for control domain and file unit
      integer ieri,istat   ! for error states
      integer iuf,iuo      ! additional file units
      integer itrc,itru    ! feedback verbosity
      integer icomp
      integer ipatday1,ipatday2,ipatday3,ipatday4,ipatday5,ipatday6  ! remember what the new day types are
      integer idol,idaynum,idtyy,idwknum,imthnum  ! for determining day of week
      integer iudt         ! user preferences for new day types
      logical ok,xst

C Variables for handling climate file.
      character llclmdb*144
      integer lndbp
      logical unixok
      character fs*1

C m1slots and m2slots are for the two possible months to be
C displayed. 42 is 7 days over maximum of 6 periods e.g.
C                   2000
C         Jan                     Feb
C Mo Tu We Th Fr Sa Su    Mo Tu We Th Fr Sa Su
C                 1  2        1  2  3  4  5  6
C  3  4  5  6  7  8  9     7  8  9 10 11 12 13
C 10 11 12 13 14 15 16    14 15 16 17 18 19 20
C 17 18 19 20 21 22 23    21 22 23 24 25 26 27
C 24 25 26 27 28 29 30    28 29
C 31
      DIMENSION VERT(35),citem(21),IDVALS(10),clist(365)
      dimension ixdvals(365)
      integer IDVALS,ixdvals

      character vert*33,DS*7,DS1*10,DS2*8,key*1
      character outs*124,head*18,tcalename*32,citem*52,clist*52
      character tcalentag*12,tcalendayn*32
      logical modify,browse
      logical havectl ! to remember if control file exists
      logical usecalendar  ! signal so easier to detect if other domains
                           ! have a different number of day types

      helpinsub='context'  ! set for subroutine

C Set folder separator (fs) to \ or / as required.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif
      havectl=.false.          ! assume no control
      usecalendar=.false.
      ICTLF=IFIL+1

C If user requested initial calendar. Setup initial 4 day types (wk sat sun holiday).
      if(act.eq.'i'.and.(.NOT.browse))then
        if(nbdaytype.le.3)then
          calename='standard weekday Sat Sun hol'
          nbdaytype=4
          nbcaldays(1)=0; calentag(1)='weekdays'
          calendayname(1)='weekdays (all year)'
          nbcaldays(2)=0; calentag(2)='saturday'
          calendayname(2)='Saturdays (all year)'
          nbcaldays(3)=0; calentag(3)='sunday'
          calendayname(3)='Sundays (all year)'
          calentag(4)='holiday'
          nbcaldays(4)=0; calendayname(4)='holiday'
          nbcaldays(5)=0; calentag(5)='-'; calendayname(5)='-'
          nbcaldays(6)=0; calentag(6)='-'; calendayname(6)='-'
          nbcaldays(7)=0; calentag(7)='-'; calendayname(7)='-'
          nbcaldays(8)=0; calentag(8)='-'; calendayname(8)='-'
          nbcaldays(9)=0; calentag(9)='-'; calendayname(9)='-'
          nbcaldays(10)=0; calentag(10)='-'; calendayname(10)='-'
          nbcaldays(11)=0; calentag(11)='-'; calendayname(11)='-'
          nbcaldays(12)=0; calentag(12)='-'; calendayname(12)='-'
          nbcaldays(13)=0; calentag(13)='-'; calendayname(13)='-'
          nbcaldays(14)=0; calentag(14)='-'; calendayname(14)='-'
          nbcaldays(15)=0; calentag(15)='-'; calendayname(15)='-'
          do 42 ijd=1,365

C Assume 1 Jan is a holiday (users can change this later).
            if(ijd.eq.1)then
              icalender(ijd)=4
              nbcaldays(4)=nbcaldays(4)+1
            else

C For day-of-year ijd find month and day of month and day of week.
              call edayr(ijd,idayn,imthn)
              call eweekd(idayn,imthn,iyear,idwk)
              if(idwk.ge.1.and.idwk.le.5)then
                icalender(ijd)=1
                nbcaldays(1)=nbcaldays(1)+1
              elseif(idwk.eq.6)then
                icalender(ijd)=2
                nbcaldays(2)=nbcaldays(2)+1
              elseif(idwk.eq.7)then
                icalender(ijd)=3
                nbcaldays(3)=nbcaldays(3)+1
              endif
            endif
  42      continue
          return
        else
          call usrmsg('day types exist, not initialised.',' ','W')
        endif
      endif

      MHEAD=4
      MCTL=5
      ILEN=365
      IPACT=CREATE
      CALL EKPAGE(IPACT)
      modify=.false.

C Initial menu entry setup.
   92 IER=0
      ILEN=365
      IVERT=-3

C Set usecalendar.
      if(nbdaytype.ge.3) usecalendar=.true.

C Loop through the items until the page to be displayed. M is the
C current menu line index. Build up text strings for the menu.
    3 M=MHEAD
      write(VERT(1),'(2a)')     '1 calendar: ',calename(1:20)
      write(VERT(2),'(a,i2,a)') '2 manage day types (',nbdaytype,')'
      VERT(3)                  =' __________________________'
      VERT(4)                  ='  date         day type    '
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          call stdate(iyear,l,DS,DS1,DS2)
          WRITE(VERT(M),'(a1,1x,3a)') KEY,DS1,'  ',
     &      calentag(icalender(L))
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)='  ______________________________ '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM
   15   FORMAT   ('0 page: ',I2,' of ',I2,' --------')
      ENDIF
      VERT(M+2)  ='+ apply day type to many days    '
      VERT(M+3)  ='! list calendar                  '
      VERT(M+4)  ='? help                           '
      VERT(M+5)  ='- exit menu                      '

C Help text for this menu.
      helptopic='calendar_day_types'
      call gethelptext(helpinsub,helptopic,nbhelp)

      write(head,'(a,i4)') ' Calendar for ',iyear
      CALL EMENU(head,VERT,MVERT,IVERT)
      IF(IVERT.eq.1)THEN

C Edit calendar name
        tcalename=calename
        CALL EASKS(tcalename,' Description of calendar: ',
     &    '  ',32,'weekday sat sun all year','calen descr',
     &    IER,nbhelp)
        if(tcalename(1:2).ne.'  ')then
          if(tcalename(1:lnblnk(tcalename)).ne.
     &       calename(1:lnblnk(calename)))then
            calename=tcalename
            modify=.true.
          endif
        endif
      ELSEIF(IVERT.EQ.2)THEN

C Manage day types.
        CALL EPMENSV
  73    write(citem(1),'(2a)') '  calendar: ',calename(1:32)
        write(citem(2),'(a)')  ' __tag________description______________'
        mj=2
        do 77 ij=1,nbdaytype
          CALL EMKEY(ij,KEY,IER)
          write(citem(ij+mj),'(5a)') KEY,' ',calentag(ij),' ',      ! text for menu
     &      calendayname(ij)
  77    continue
        mm=mj+nbdaytype
        write(citem(mm+1),'(a)') ' ____________________________________'
        write(citem(mm+2),'(a)') '+ add a daytype or set of daytypes   '
        write(citem(mm+3),'(a)') '? help                               '
        write(citem(mm+4),'(a)') '- exit                               '
        mcvert=mj+nbdaytype+4
        icvert=-1
        CALL EMENU('  Day types',citem,mcvert,icvert)
        if(icvert.eq.mcvert)then
          CALL EPMENRC
          goto 3
        elseif(icvert.eq.mcvert-1)then

C Help.
          CALL PHELPD('calendar day section',nbhelp,'-',0,0,IER)
          goto 73
        elseif(icvert.eq.mcvert-2)then

C Add a single day type or a set of day types (e.g. seasonal patterns) if
C there are seasonal periods defined for the current weather.
C Note: the delete a day type is currently not implemented.

C Rescan the `climatelist` file. Check if this climate is
C in the list. If not instantiate season and typical start and end dates.
          if(ihaveseason.gt.0)then
            continue
          else

C Setup string buffer with distribution weather folder name.
            lndbp=lnblnk(standardclmpath)
            if(ipathclim.eq.0.or.ipathclim.eq.1)then
              llclmdb=LCLIM
            elseif(ipathclim.eq.2)then
              write(llclmdb,'(3a)') standardclmpath(1:lndbp),fs,
     &          LCLIM(1:lnblnk(LCLIM))
            endif
            INQUIRE (FILE=cdblfil,EXIST=XST)
            if(XST)then
              IUF=IFIL+2
              call scancdblist(IUF,llclmdb,'p',ok,ier)
              if(ok)then
                continue
              else

C Set default early winter, spring, summer, autumn, late winter periods.
                CALL EDAY(9,1,ia1wins); CALL EDAY(15,1,ia1winf)
                CALL EDAY(6,3,ia1sprs); CALL EDAY(12,3,ia1sprf)
                CALL EDAY(11,7,iasums); CALL EDAY(17,7,iasumf)
                CALL EDAY(2,10,ia2sprs); CALL EDAY(8,10,ia2sprf)
                CALL EDAY(20,11,ia2wins); CALL EDAY(26,11,ia2winf)

C Default season definitions.
                CALL EDAY(1,1,is1wins); CALL EDAY(28,2,is1winf)
                CALL EDAY(1,11,is2wins); CALL EDAY(31,12,is2winf)
                CALL EDAY(1,3,is1sprs); CALL EDAY(30,4,is1sprf)
                CALL EDAY(1,9,is2sprs); CALL EDAY(31,10,is2sprf)
                CALL EDAY(1,5,is1sums); CALL EDAY(31,8,is1sumf)
              endif
            endif
          endif

C Dialog based on whether or not seasons have been found.

          if(nbdaytype.ge.3.and.nbdaytype.le.MDTY)then
            CALL EASKMBOX(' ',' Options:','add day type',
     &        'add set of day types','n/a',
     &        'cancel',' ',' ',' ',' ',IRT,nbhelp)
            if(irt.eq.1)then

C If there is a control file, scan it and then loop through each of the
C existing control loops to add in what-will-become the new day type.
C havectl is returned as true if there is a control file.
C Offer options for repeat of existing day type or a free-float day type.
              CALL EPMENSV
              do ij=1,nbdaytype
                write(citem(ij),'(3a)') calentag(ij),' ',
     &            calendayname(ij)
              enddo
              write(citem(nbdaytype+1),'(a)')
     &          'create one period free floating'
              write(citem(nbdaytype+2),'(a)')
     &          'copy last existing day type'
              IX=1
              CALL EPICKS(IX,IDVALS,
     &          'New day type can use an existing day type pattern.',
     &          ' Available day types & options:',
     &          52,nbdaytype+2,citem,'Available day types & options',
     &          IER,nbhelp)
              CALL EPMENRC
              if(ix.ne.0)then
                idt=idvals(1)
                if(idt.eq.nbdaytype+1) idt=0
                if(idt.eq.nbdaytype+2) idt=nbdaytype
              endif
              call updatectlfornewdaytype(havectl,usecalendar,idt,ier)

C Now increment nbdaytype and get its name and description.
              nbdaytype=nbdaytype+1
              nbcaldays(nbdaytype)=0
              calentag(nbdaytype)='new'
              calendayname(nbdaytype)='new day type'

C Edit calendar day tag and name.
              tcalentag=calentag(nbdaytype)
              CALL EASKS(tcalentag,' Calendar day type tag: ',
     &          '  ',12,'holiday','day tag',IER,nbhelp)
              if(tcalentag(1:2).ne.'  ')then
                if(tcalentag(1:lnblnk(tcalentag)).ne.
     &         calentag(nbdaytype)(1:lnblnk(calentag(nbdaytype))))then
                  calentag(nbdaytype)=tcalentag
                endif
              endif
              tcalendayn=calendayname(nbdaytype)
              CALL EASKS(tcalendayn,' Calendar day type descripton: ',
     &          '  ',32,'holiday','day descr',IER,nbhelp)
              if(tcalendayn(1:2).ne.'  ')then
                if(tcalendayn(1:lnblnk(tcalendayn)).ne.
     & calendayname(nbdaytype)(1:lnblnk(calendayname(nbdaytype))))then
                  calendayname(nbdaytype)=tcalendayn
                endif
              endif

C Update control data for all zones to include this new day type (now
C that its name is known).
              if(havectl)then
                CALL CTLWRT(ICTLF,IER)
              endif

C Deal with operation files. User will be asked if they want to
C overwrite or save to new file names.
              CALL UPDOPR(idt)
              modify=.true.
              goto 73

            elseif(irt.eq.2)then

C Display a list of day type patterns.
              idno=1
              isw=0
              call MENUATOL('  ','Daytype patterns',
     &          'a retail open Monday-Saturday closed Sunday',
     &          'b winter trans summer weekdays & weekends',
     &          'c xxx','d xxx','e xxx','f xxx',
     &          ' ',' ',' ',' ',' ',' ',
     &          isw,idno,nbhelp)
              if(isw.eq.1)then

C A retail profile is open Monday thru Saturday with reduced operating
C hours on the 2nd weekend day. Call the 1st day type retail_open and
C the 2nd day  retail_close. Later offer the user an option to reset
C the calendar to match this.
                if(nbdaytype+2.lt.MDTY)then

C For the 1st retail day revise the controls and then the operations.
                  call edisp(iuout,' ')
                  call edisp(iuout,' Processing retail_open day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)

C Now increment nbdaytype and get its name and description. Update
C the control file if it exists and then process zone operation files.
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday1 = nbdaytype  ! remember this
                  calentag(nbdaytype)='retail_open'
                  calendayname(nbdaytype)='retail open Mon-Sat'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the 2nd retail day revise the controls and then the operations.
                  call edisp(iuout,' Processing retail_close day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)

C Now increment nbdaytype and get its name and description. Update
C the control file if it exists and then process zone operation files.
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday2 = nbdaytype  ! remember this
                  calentag(nbdaytype)='retail_close'
                  calendayname(nbdaytype)='retail closed Sunday'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C If user agrees apply these two new day types to the current calendar.
C Loop through all days, if one of the original 3 day types revise them
C to use the new Mon-Sat & Sunday types.
                  CALL EASKOK(' ',
     &              'Apply these day types to the model calendar?',
     &              OK,nbhelp)
                  if(OK)then
                    DO 123 IDOL=1,365
                      IF(ICALENDER(IDOL).LE.3)THEN
                        CALL EDAYR(IDOL,IDAYNUM,IMTHNUM)
                        CALL EWEEKD(IDAYNUM,IMTHNUM,IYEAR,IDWKNUM)
                        IF(IDWKNUM.LE.6)THEN
                          IDTYY=ipatday1 ! WEEKDAY
                        ELSEIF(IDWKNUM.EQ.7)THEN
                          IDTYY=ipatday2 ! SUNDAY
                        ENDIF
                        ICALENDER(IDOL)=IDTYY  ! update the model calendar
                      ENDIF
 123                CONTINUE
                  endif

                  modify=.true.
                  goto 73

                else
                  call usrmsg('Not able to add two more day types to',
     &              'the current model calendar.','W')
                  goto 73
                endif
              elseif(isw.eq.2)then

C Create a separate weekday and weekend day type for winter transition
C and summer for the model seasons. The day type names are win_wkday,
C win_wkend, trn_wkday, trn_wkend, sum_wkday, sum_wkend.
                if(nbdaytype+6.lt.MDTY)then

C For the win_wkday revise the controls and then the operations.
                  call edisp(iuout,' ')
                  call edisp(iuout,' Processing win_wkday day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)

C Now increment nbdaytype and get its name and description. Update
C the control file if it exists and then process zone operation files.
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday1 = nbdaytype  ! remember this
                  calentag(nbdaytype)='win_wkday'
                  calendayname(nbdaytype)='winter seasons weekdays'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the win_wkend revise the controls and then the operations.
                  call edisp(iuout,' Processing win_wkend day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday2 = nbdaytype  ! remember this
                  calentag(nbdaytype)='win_wkend'
                  calendayname(nbdaytype)='winter seasons weekends'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the trn_wkday revise the controls and then the operations.
                  call edisp(iuout,' Processing trn_wkday day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday3 = nbdaytype  ! remember this
                  calentag(nbdaytype)='trn_wkday'
                  calendayname(nbdaytype)='transition seasons weekdays'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the trn_wkend revise the controls and then the operations.
                  call edisp(iuout,' Processing trn_wkend day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday4 = nbdaytype  ! remember this
                  calentag(nbdaytype)='trn_wkend'
                  calendayname(nbdaytype)='transition seasons weekends'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the sum_wkday revise the controls and then the operations.
                  call edisp(iuout,' Processing sum_wkday day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday5 = nbdaytype  ! remember this
                  calentag(nbdaytype)='sum_wkday'
                  calendayname(nbdaytype)='summer season weekdays'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C For the sum_wkend revise the controls and then the operations.
                  call edisp(iuout,' Processing sum_wkend day...')
                  iudt=-1
                  call updatectlfornewdaytype(havectl,usecalendar,
     &              iudt,ier)
                  nbdaytype=nbdaytype+1
                  nbcaldays(nbdaytype)=0
                  ipatday6 = nbdaytype  ! remember this
                  calentag(nbdaytype)='sum_wkend'
                  calendayname(nbdaytype)='summer season weekends'
                  if(havectl)then
                    CALL CTLWRT(ICTLF,IER)
                  endif
                  CALL UPDOPR(iudt)

C If user agrees apply these six new day types to the current calendar.
C Loop through all days, if one of the original 3 day types revise them
C to use the new seasonal day types. The 5 sesaons in the weather data
C are applied so that win1 and win2 both get the winter day types and
C spring and autumn both get the transition day type.
                  CALL EASKOK(' ',
     &              'Apply these day types to model calendar?',
     &              OK,nbhelp)
                  if(OK)then
C Debug.
C                    write(6,*) nbdaytype,ipatday1,ipatday2,ipatday3,
C     &ipatday4,ipatday5,ipatday6
C                    write(6,*) is1wins,is1winf,is2wins,is2winf,
C     &is1sprs,is1sprf,is2sprs,is2sprf,is1sums,is1sumf
                    DO 124 IDOL=1,365
                      IF(ICALENDER(IDOL).LE.3)THEN
                        CALL EDAYR(IDOL,IDAYNUM,IMTHNUM)
                        CALL EWEEKD(IDAYNUM,IMTHNUM,IYEAR,IDWKNUM)
                        if(IDOL.ge.is1wins.and.IDOL.le.is1winf)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=ipatday1 ! Win weekday
                          ELSEIF(IDWKNUM.EQ.6.or.IDWKNUM.EQ.7)THEN
                            IDTYY=ipatday2 ! Win weekend
                          ENDIF
                        elseif(IDOL.ge.is1sprs.and.IDOL.le.is1sprf)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=ipatday3 ! transition weekday
                          ELSEIF(IDWKNUM.EQ.6.or.IDWKNUM.EQ.7)THEN
                            IDTYY=ipatday4 ! transition weekend
                          ENDIF
                        elseif(IDOL.ge.is1sums.and.IDOL.le.is1sumf)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=ipatday5 ! summer WEEKDAY
                          ELSEIF(IDWKNUM.EQ.6.or.IDWKNUM.EQ.7)THEN
                            IDTYY=ipatday6 ! summer weekend
                          ENDIF
                        elseif(IDOL.ge.is2sprs.and.IDOL.le.is2sprf)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=ipatday3 ! autumn weekday
                          ELSEIF(IDWKNUM.EQ.6.or.IDWKNUM.EQ.7)THEN
                            IDTYY=ipatday4 ! autumn weekend
                          ENDIF
                        elseif(IDOL.ge.is2wins.and.IDOL.le.is2winf)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=ipatday1 ! winter WEEKDAY
                          ELSEIF(IDWKNUM.EQ.6.or.IDWKNUM.EQ.7)THEN
                            IDTYY=ipatday2 ! winter weekend
                          ENDIF
                        endif

C If the day type did not match then fall back on day of the week.
                        if(IDTYY.eq.0)then
                          IF(IDWKNUM.LT.6)THEN
                            IDTYY=1 ! WEEKDAY
                          ELSEIF(IDWKNUM.EQ.6)THEN
                            IDTYY=2 ! SATURDAY
                          ELSEIF(IDWKNUM.EQ.7)THEN
                            IDTYY=3 ! SUNDAY
                          ENDIF
                        endif
                        ICALENDER(IDOL)=IDTYY  ! update the model calendar
                      ENDIF
 124                CONTINUE
                  endif

                  modify=.true.
                  goto 73

                endif
              else
                goto 73
              endif
            elseif(irt.eq.3)then
              goto 73
            elseif(irt.eq.4)then
              goto 73
            endif
          endif
        elseif(icvert.gt.2.and.icvert.lt.mcvert-3)then

C Edit calendar day tag and name.
          ifoc=icvert-2
          tcalentag=calentag(ifoc)
          CALL EASKS(tcalentag,' Calendar day type tag: ',
     &      '  ',12,'holiday','day tag',IER,nbhelp)
          if(tcalentag(1:2).ne.'  ')then
            if(tcalentag(1:lnblnk(tcalentag)).ne.
     &         calentag(ifoc)(1:lnblnk(calentag(ifoc))))then
              calentag(ifoc)=tcalentag
              modify=.true.
            endif
          endif
          tcalendayn=calendayname(ifoc)
          CALL EASKS(tcalendayn,' Calendar day type descripton: ',
     &      '  ',32,'holiday','day descr',IER,nbhelp)
          if(tcalendayn(1:2).ne.'  ')then
            if(tcalendayn(1:lnblnk(tcalendayn)).ne.
     &         calendayname(ifoc)(1:lnblnk(calendayname(ifoc))))then
              calendayname(ifoc)=tcalendayn
              modify=.true.
            endif
          endif

C Write out the control file with the current calendar names and
C also re-write the zone operation files to reflect the new
C calendar names.
          if(modify)then
            ICTLF=IFIL+1; itrc=0     ! set to silent read
            CALL ERPFREE(ICTLF,ISTAT)
            call FINDFIL(LCTLF,XST)
            if(XST)then
              call edisp(iuout,
     &          ' Updating control to reflect new daytype name...')
              CALL EZCTLR(ICTLF,ITRC,IUOUT,IER)
              CALL CTLWRT(ICTLF,IER)
            endif
            call edisp(iuout,
     &      ' Updating zone schedules to reflect new daytype name...')

C For every zone in the model do the following...
            DO 100 ICOMP=1,NCOMP

C Check if operations file exists and read it.
              INQUIRE (FILE=LPROJ(ICOMP),EXIST=XST)
              IF(XST)THEN
                IUO=IFIL+1
                CALL ERPFREE(IUO,ISTAT)
                itru=iuout
                CALL EROPER(ITRC,ITRU,IUO,ICOMP,IER)

C Write zone operations file and update to current format.
                ip3ver(icomp)=21
                CALL EMKOPER(IUO,LPROJ(ICOMP),ICOMP,IER)
              ENDIF
 100        CONTINUE
            call usrmsg('  ','  ','-')
          endif
          goto 73
        else
          goto 73
        endif
      ELSEIF(IVERT.EQ.MVERT)THEN
        if(modify.and.(.NOT.browse))then

C Update calendar day types
          DO 21 IB=1,NBDAYTYPE
            NBCALDAYS(IB)=0
 21       CONTINUE
          DO 22 IB=1,365
            NBCALDAYS(ICALENDER(IB))=NBCALDAYS(ICALENDER(IB))+1
 22       CONTINUE

C Update the model.
          CALL EMKCFG('s',IER)
        endif
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-1))THEN

C Produce help text for the vertex menu.
        CALL PHELPD('calendar section',nbhelp,'-',0,0,IER)
      ELSEIF(IVERT.EQ.(MVERT-2))THEN

C List current calendar.
C Begin by finding out the day of the week of 1 Jan.
        ijd=1
        call edayr(ijd,idayn,imthn)
        call eweekd(idayn,imthn,iyear,istjandwk)
        idno=1
        isw=0
        call MENUATOL(outs,'Display options:',
     &    'a january - march','b april - june',
     &    'c july - september','d october - december ',
     &    'e all year',' ',' ',' ',' ',' ',' ',' ',isw,idno,nbhelp)

C loop is the number of months to display
C loopst is the month number to start with
        if(isw.eq.1)then
          loop=3
          loopst=1
        elseif(isw.eq.2)then
          loop=3
          loopst=4
        elseif(isw.eq.3)then
          loop=3
          loopst=7
        elseif(isw.eq.4)then
          loop=3
          loopst=10
        elseif(isw.eq.5)then
          loop=12
          loopst=1
        endif

C Print the calendar.
        call calenprint(iuout,'t',iyear,loopst,loop)
        call edisp(iuout,' ')
        call calenprint(iuout,'g',iyear,loopst,loop)
        call edisp(iuout,' ')
      ELSEIF(IVERT.EQ.(MVERT-3))THEN

C Apply day type to several days of the year. First ask for the
C day type and then present a list of all of the days so that the
C user can select one or more.
        CALL EPMENSV
        do 67 ij=1,nbdaytype
          write(citem(ij),'(3a)') calentag(ij),' ',calendayname(ij)
  67    continue
        IX=1
        CALL EPICKS(IX,IDVALS,' ',' Available day types:',
     &    52,nbdaytype,citem,'available day types',IER,nbhelp)
       if(ix.ne.0)then

C << potential place to support seasonal day type allocations >>

          IHDT=0
          CALL EASKMBOX(' ','Add day types:',
     &      'one-by-one','by pattern','cancel',
     &      ' ',' ',' ',' ',' ',IHDT,nbhelp)
          IF(IHDT.EQ.1)THEN
            idt=idvals(1)
            do 78 ld=1,365
              call stdate(iyear,ld,DS,DS1,DS2)
              WRITE(clist(ld),'(3a)') DS1,'  ',
     &          calentag(icalender(ld))
  78        continue
            CALL EPMENSV
            ixd=365
            CALL EPICKS(ixd,ixdvals,' ',' Days in the year:',
     &        52,365,clist,'available days',IER,nbhelp)
            CALL EPMENRC
            if(ixd.ne.0)then
              do 79 idayloop=1,ixd
                ifoc=ixdvals(idayloop)
                call stdate(iyear,ifoc,DS,DS1,DS2)
                icalender(ifoc)=idt
                nbcaldays(idt)=nbcaldays(idt) + 1
                write(outs,*) 'Revised day: ',ifoc,' ',DS1,' ',
     &            icalender(ifoc),' ',calendayname(icalender(ifoc))
                call edisp(iuout,outs)
  79          continue
              modify=.true.
            endif
          ELSEIF(IHDT.EQ.2)THEN

C Pattern addition of day types.
            ISDS=1
            ISDF=365
            IFRQ=1
            call eAskPer('Dates during which to add new day type',
     &      isds,isdf,ifday,ier)

C Regenerate help string that is clobbered by call to easkper
            CALL EASKI(IFRQ,
     &      ' Enter number of days to repeat pattern after ',
     &      ' E.g. 7=weekly, 30=monthly, 1=daily ',
     &      1,'F',30,'F',1,'frequency ',IERI,nbhelp)
            DO 532 IDTT=ISDS,ISDF,IFRQ
              ICALENDER(IDTT)=idvals(1)
 532        CONTINUE
          ENDIF
        endif
        CALL EPMENRC
      ELSEIF(IVERT.EQ.(MVERT-4))THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Edit day identified by KEYIND.
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        call stdate(iyear,ifoc,DS,DS1,DS2)
        write(outs,*) 'For day: ',ifoc,' ',DS1,' ',
     &    icalender(ifoc),' ',calendayname(icalender(ifoc))
        call edisp(iuout,outs)

C Select from current range of day types. Assign icalendar value
C for the focus day to the selected day type and increment nbcaldays.
        CALL EPMENSV
        do 76 ij=1,nbdaytype
          write(citem(ij),'(3a)') calentag(ij),' ',calendayname(ij)
  76    continue
        IX=1
        CALL EPICKS(IX,IDVALS,' ',' Available day types:',
     &    52,nbdaytype,citem,'avail day types',IER,nbhelp)
        if(ix.ne.0)then
          idt=idvals(1)
          icalender(ifoc)=idt
          nbcaldays(idt)=nbcaldays(idt) + 1
          write(outs,*) 'Revised day: ',ifoc,' ',DS1,' ',
     &      icalender(ifoc),' ',calendayname(icalender(ifoc))
          call edisp(iuout,outs)
          modify=.true.
        endif
        CALL EPMENRC
      ELSE
C Not one of the legal menu choices.
        IVERT=-1
        goto 92
      ENDIF
      IVERT=-2
      goto 3

C Errors.
C   14 if(IOS.eq.2)then
C        CALL USRMSG(' No prmission to write array in ',' ','W')
C      else
C        CALL USRMSG(' Long arrary write error in ',' ','W')
C      endif
C      IER=1
C      return
      end

C ********** updatectlfornewdaytype
C updatectlfornewdaytype adds an additional day type to each of the
C model control domains.
      subroutine updatectlfornewdaytype(havectl,usecalendar,iudt,ier)

#include "building.h"
#include "control.h"

C Parameters passed
      logical havectl ! to remember if control file exists
      logical usecalendar  ! signal so easier to detect if other domains
                           ! have a different number of day types
      integer iudt         ! user preference to replicat existing day type or free float
                           ! or interactive (iudt = -1)
      integer ier          ! error state

      integer iuout,iuin,ieout
      common/OUTIN/IUOUT,IUIN,IEOUT
      common/calena/calename,calentag(MDTY),calendayname(MDTY)
      character calename*32,calentag*12,calendayname*32
      common/caleni/nbdaytype,nbcaldays(MDTY),icalender(365)
      integer nbdaytype,nbcaldays,icalender
      COMMON/FILEP/IFIL
      integer ifil
      common/cctlnm/ctldoc,lctlf
      character ctldoc*248,LCTLF*72
      integer iloop ! index for looping
      integer idt   ! for counting days
      integer icfoc,ictlf  ! for control domain and file unit
      integer istat   ! for error states
      integer ITRC         ! for verbosity

      character dayact*2   ! action to take in managing day types
      logical XST
      integer IHDTP   ! for users preference to add or copy

      havectl=.false.          ! reset to assume no control

      ICTLF=IFIL+1; itrc=0     ! set to silent read
      CALL ERPFREE(ICTLF,ISTAT)
      call FINDFIL(LCTLF,XST)
      if(XST)then
        CALL EZCTLR(ICTLF,ITRC,IUOUT,IER)
        havectl=.true.          ! yes we have control

C Ask user whether to create a minimal control regime or to
C duplicate the last control day type in each loop.
C The treatment of day types within addctld is based on an assumption
C that nbdaytpe is not incremented until after the addctld call.
        IDT=nbdaytype     ! set to the not-yet-incremented value

        if(IUDT.eq.0)then
          dayact='SA'       ! assume silent addition
        elseif(IUDT.eq.nbdaytype)then
          dayact='SC'       ! assume silent copy of last
        elseif(IUDT.gt.0.and.IUDT.lt.nbdaytype)then
          dayact='EC'        ! assume silent existing copy of an existing day type
          IDT=IUDT
        elseif(IUDT.eq.-1)then
          IHDTP=1             ! interactive session
          CALL EASKMBOX('Control pattern for new day type (see help)?',
     &      ' ','One period free floating',
     &      'Use pattern of last day type','cancel',
     &      ' ',' ',' ',' ',' ',IHDTP,nbhelp)
          if(IHDTP.eq.1)then
            dayact='SA'       ! assume silent addition
          elseif(IHDTP.eq.2)then
            dayact='SC'       ! assume silent copy
          elseif(IHDTP.eq.3)then
            havectl=.false.   ! ignore control
            return            ! do not bother processing control data
          endif
        endif
        if(NCF.gt.0)then  ! zone loops
          icfoc=0
          do 80 iloop=1,NCF
            if(nbcdt(iloop).ne.0.AND.usecalendar)then
              continue   ! calendar and ideal day types do not match
            else
              call ADDCTLD(icfoc,iloop,IDT,dayact)
            endif
  80      continue
        endif
        if(NCC.gt.0)then  ! flow loops
          icfoc=2
          do 81 iloop=1,NCC
            if(nfcdt(iloop).ne.0.AND.usecalendar)then
              continue   ! calendar and flow day types do not match
            else
              call ADDCTLD(icfoc,iloop,IDT,dayact)
            endif
  81      continue
        endif
        if(NCL.gt.0)then  ! plant loops
          icfoc=1
          do 82 iloop=1,NCL
            if(npcdt(iloop).ne.0.AND.usecalendar)then
              continue   ! calendar and plant day types do not match
            else
              call ADDCTLD(icfoc,iloop,IDT,dayact)
            endif
  82      continue
        endif
        if(NGF.gt.0)then  ! global loops
          icfoc=3
          do 83 iloop=1,NGF
            call ADDCTLD(icfoc,iloop,IDT,dayact)
  83      continue
        endif
        if(NOF.gt.0)then  ! optical loops
          icfoc=5
          do 84 iloop=1,NOF
            call ADDCTLD(icfoc,iloop,IDT,dayact)
  84      continue
        endif
        if(nCFCctlloops.gt.0)then ! CFC loops
          icfoc=6
          do 86 iloop=1,nCFCctlloops
            call ADDCTLD(icfoc,iloop,IDT,dayact)
  86      continue
        endif
      endif

      return
      end

C ********** calenprint **************
C Calenprint displays a calendar for year iyear beginning
C at loopst for loop months.
C Currently it prints to text feedback or file only. Future
C option is to display in graphic feedback with day types
C as defined by calenmanage.
      subroutine calenprint(itru,act,iyear,loopst,loop)
#include "building.h"

C Parameters
      integer itru    ! reporting unit
      character act*1 ! action to take 't' text feedback, 'g' graphic feedback
      integer iyear   ! year to use for day of week calculations
      integer loopst  ! month to start list/display
      integer loop    ! number of months to list/display

      COMMON/SPAD/MMOD,LIMIT,LIMTTY
      common/calena/calename,calentag(MDTY),calendayname(MDTY)
      common/caleni/nbdaytype,nbcaldays(MDTY),icalender(365)

C m1slots and m2slots are for the two possible months to be
C displayed. 42 is 7 days over maximum of 6 periods e.g.
C                   2000
C         Jan                     Feb
C Mo Tu We Th Fr Sa Su    Mo Tu We Th Fr Sa Su
C                 1  2        1  2  3  4  5  6
C  3  4  5  6  7  8  9     7  8  9 10 11 12 13
C 10 11 12 13 14 15 16    14 15 16 17 18 19 20
C 17 18 19 20 21 22 23    21 22 23 24 25 26 27
C 24 25 26 27 28 29 30    28 29
C 31
C         Jan                     Feb
C Mo Tu We Th Fr Sa Su    Mo Tu We Th Fr Sa Su
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
C  x  x  x  x  x  x  x     x  x  x  x  x  x  x
      DIMENSION m1slots(42,2),m2slots(42,2)
#ifdef OSI
      integer iside,isize,ifont     ! passed to viewtext
      integer iix,iiy,iicol,idcol
#else
      integer*8 iside,isize,ifont     ! passed to viewtext
      integer*8 iix,iiy,iicol,idcol
#endif

C Text for each slot.
      character*3 am1slots(42),am2slots(42)
      character calename*32,calentag*12,calendayname*32,word3*3
      character mohead*44,outs*124,etext*72
      CHARACTER*9 RAMONTH(12)
      DIMENSION ID(12),MDAYS(12)

C ID is the number of days in each month, MDAYS is the Julian (day-of-the-year)
C start day of each month.
      DATA ID/31,28,31,30,31,30,31,31,30,31,30,31/
      DATA MDAYS/1,32,60,91,121,152,182,213,244,274,305,335/
      DATA RAMONTH/'January  ','February ','March    ','April    ',
     &             'May      ','June     ','July     ','August   ',
     &             'September','October  ','November ','December '/

C Set common text strings and then if in test mode print months
C side by side.
      mohead = ' Mo Tu We Th Fr Sa Su  Mo Tu We Th Fr Sa Su '
      if(act.eq.'t')then
        write(outs,'(20x,i4)') iyear
        call edisp(itru,outs)

C If number of months to display is a multiple of 2 display side by side.
C imon1 and imon2 are possible months to dispalay (if zero then do not).
C iloopfn is the end month in the do 44
        imon1=0
        imon2=0
        iloopfn=(loopst+loop)-1
        do 44 im=loopst,iloopfn,2
          if(mod(loop,2).eq.0)then

C Set two consecutive months, write their names and the full
C heading and then find the start day of the week for each.
            imon1=im
            imon2=im+1
            write(outs,'(8x,a,17x,a)') ramonth(imon1),ramonth(imon2)
            call edisp(itru,outs)
            write(outs,'(a)') mohead
            call edisp(itru,outs)
            call edayr(mdays(imon1),idayn,imthn)
            call eweekd(idayn,imthn,iyear,im1dwk)
            call edayr(mdays(imon2),idayn,imthn)
            call eweekd(idayn,imthn,iyear,im2dwk)
          else
            if(im.eq.iloopfn)then
              imon1=im
              imon2=0
              write(outs,'(8x,a)') ramonth(imon1)
              call edisp(itru,outs)
              write(outs,'(a)') mohead(1:22)
              call edisp(itru,outs)
              call edayr(mdays(imon1),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im1dwk)
              im2dwk=0
            else
              imon1=im
              imon2=im+1
              write(outs,'(8x,a,17x,a)') ramonth(imon1),ramonth(imon2)
              call edisp(itru,outs)
              write(outs,'(a)') mohead
              call edisp(itru,outs)
              call edayr(mdays(imon1),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im1dwk)
              call edayr(mdays(imon2),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im2dwk)
            endif
          endif

C For one or two current months fill the m1slots and m2slots.
C icntm1 & icntm2 increment as days fill the slots.
C If the slot is before the start of the month fill with 0,
C if the slot is the first day of the month set slot date and day type,
C if a subsequent day of the month the set slot date and day type.
C am1slots(42),am2slots(42)
          icntm1=0
          icntm2=0
          do 46 ims = 1,42
            if(ims.lt.im1dwk)then
              m1slots(ims,1)=0
              m1slots(ims,2)=0
              am1slots(ims)='   '
            elseif(ims.ge.im1dwk)then
              icntm1=icntm1+1
              if(icntm1.le.id(imon1))then
                m1slots(ims,1)=icntm1
                CALL EDAY(icntm1,imon1,icurday)
                m1slots(ims,2)=icalender(icurday)
                write(am1slots(ims),'(i3)') icntm1
              else
                m1slots(ims,1)=0
                m1slots(ims,2)=0
                am1slots(ims)='   '
              endif
            endif

C Fill second month with real data or blanks.
            if(im2dwk.eq.0)then
              m2slots(ims,1)=0
              m2slots(ims,2)=0
              am2slots(ims)='   '
            else
              if(ims.lt.im2dwk)then
                m2slots(ims,1)=0
                m2slots(ims,2)=0
                am2slots(ims)='   '
              elseif(ims.ge.im2dwk)then
                icntm2=icntm2+1
                if(icntm2.le.id(imon2))then
                  m2slots(ims,1)=icntm2
                  CALL EDAY(icntm2,imon2,icurday)
                  m2slots(ims,2)=icalender(icurday)
                  write(am2slots(ims),'(i3)') icntm2
                else
                  m2slots(ims,1)=0
                  m2slots(ims,2)=0
                  am2slots(ims)='   '
                endif
              endif
            endif
  46      continue
          write(outs,'(15a)') (am1slots(J),j=1,7),' ',
     &      (am2slots(J),j=1,7)
          call edisp(itru,outs)
          write(outs,'(15a)') (am1slots(J),j=8,14),' ',
     &      (am2slots(J),j=8,14)
          call edisp(itru,outs)
          write(outs,'(15a)') (am1slots(J),j=15,21),' ',
     &      (am2slots(J),j=15,21)
          call edisp(itru,outs)
          write(outs,'(15a)') (am1slots(J),j=22,28),' ',
     &      (am2slots(J),j=22,28)
          call edisp(itru,outs)
          write(outs,'(15a)') (am1slots(J),j=29,35),' ',
     &      (am2slots(J),j=29,35)
          call edisp(itru,outs)
          write(outs,'(15a)') (am1slots(J),j=36,42),' ',
     &      (am2slots(J),j=36,42)
          call edisp(itru,outs)
  44    continue
      elseif(act.eq.'g')then
        if(MMOD.eq.8)call startbuffer()
        line=3
        write(etext,'(20x,i4)') iyear
        iside=line; isize=0; ifont=2
        if(mmod.eq.8)then
          call viewtext(etext,iside,isize,ifont)
        else
          call viewtextwwc(etext,iside,isize,ifont)
        endif

C If number of months to display is a multiple of 2 display side by side.
C imon1 and imon2 are possible months to dispalay (if zero then do not).
C iloopfn is the end month in the do 44
        imon1=0
        imon2=0
        iloopfn=(loopst+loop)-1
        do 144 im=loopst,iloopfn,2
          if(mod(loop,2).eq.0)then

C Set two consecutive months, write their names and the full
C heading and then find the start day of the week for each.
            imon1=im
            imon2=im+1
            line=line+1
            write(etext,'(8x,a,17x,a)') ramonth(imon1),ramonth(imon2)
            iside=line; isize=0; ifont=2
            if(mmod.eq.8)then
              call viewtext(etext,iside,isize,ifont)
            else
              call viewtextwwc(etext,iside,isize,ifont)
            endif
            line=line+1
            write(etext,'(a)') mohead
            iside=line
            if(mmod.eq.8)then
              call viewtext(etext,iside,isize,ifont)
            else
              call viewtextwwc(etext,iside,isize,ifont)
            endif
            call edayr(mdays(imon1),idayn,imthn)
            call eweekd(idayn,imthn,iyear,im1dwk)
            call edayr(mdays(imon2),idayn,imthn)
            call eweekd(idayn,imthn,iyear,im2dwk)
          else
            if(im.eq.iloopfn)then
              imon1=im
              imon2=0
              line=line+1
              write(etext,'(8x,a)') ramonth(imon1)
              iside=line
              isize=0
              ifont=2
              if(mmod.eq.8)then
                call viewtext(etext,iside,isize,ifont)
              else
                call viewtextwwc(etext,iside,isize,ifont)
              endif
              line=line+1
              write(etext,'(a)') mohead(1:22)
              iside=line
              if(mmod.eq.8)then
                call viewtext(etext,iside,isize,ifont)
              else
                call viewtextwwc(etext,iside,isize,ifont)
              endif
              call edayr(mdays(imon1),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im1dwk)
              im2dwk=0
            else
              imon1=im
              imon2=im+1
              line=line+1
              write(etext,'(8x,a,17x,a)') ramonth(imon1),ramonth(imon2)
              iside=line
              isize=0
              ifont=2
              if(mmod.eq.8)then
                call viewtext(etext,iside,isize,ifont)
              else
                call viewtextwwc(etext,iside,isize,ifont)
              endif
              line=line+1
              write(etext,'(a)') mohead
              iside=line
              if(mmod.eq.8)then
                call viewtext(etext,iside,isize,ifont)
              else
                call viewtextwwc(etext,iside,isize,ifont)
              endif
              call edayr(mdays(imon1),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im1dwk)
              call edayr(mdays(imon2),idayn,imthn)
              call eweekd(idayn,imthn,iyear,im2dwk)
            endif
            if(mmod.eq.8) call forceflush()
          endif

C For one or two current months fill the m1slots and m2slots.
C icntm1 & icntm2 increment as days fill the slots.
C If the slot is before the start of the month fill with 0,
C if the slot is the first day of the month set slot date and day type,
C if a subsequent day of the month the set slot date and day type.
C am1slots(42),am2slots(42)
          icntm1=0
          icntm2=0
          do 146 ims = 1,42
            if(ims.lt.im1dwk)then
              m1slots(ims,1)=0
              m1slots(ims,2)=0
              am1slots(ims)='   '
            elseif(ims.ge.im1dwk)then
              icntm1=icntm1+1
              if(icntm1.le.id(imon1))then
                m1slots(ims,1)=icntm1
                CALL EDAY(icntm1,imon1,icurday)
                m1slots(ims,2)=icalender(icurday)
                write(am1slots(ims),'(i3)') icntm1
              else
                m1slots(ims,1)=0
                m1slots(ims,2)=0
                am1slots(ims)='   '
              endif
            endif

C Fill second month with real data or blanks.
            if(im2dwk.eq.0)then
              m2slots(ims,1)=0
              m2slots(ims,2)=0
              am2slots(ims)='   '
            else
              if(ims.lt.im2dwk)then
                m2slots(ims,1)=0
                m2slots(ims,2)=0
                am2slots(ims)='   '
              elseif(ims.ge.im2dwk)then
                icntm2=icntm2+1
                if(icntm2.le.id(imon2))then
                  m2slots(ims,1)=icntm2
                  CALL EDAY(icntm2,imon2,icurday)
                  m2slots(ims,2)=icalender(icurday)
                  write(am2slots(ims),'(i3)') icntm2
                else
                  m2slots(ims,1)=0
                  m2slots(ims,2)=0
                  am2slots(ims)='   '
                endif
              endif
            endif
 146      continue

C Repeat this 6 times (there can be this many lines of 7 days)
          do 149 lj=1,6
            if(lj.eq.1)then
              lstart=1
              lfinish=7
            elseif(lj.eq.2)then
              lstart=8
              lfinish=14
            elseif(lj.eq.3)then
              lstart=15
              lfinish=21
            elseif(lj.eq.4)then
              lstart=22
              lfinish=28
            elseif(lj.eq.5)then
              lstart=29
              lfinish=35
            elseif(lj.eq.6)then
              lstart=36
              lfinish=42
            endif

C Plot out the first 7 days.
            isize=2
            line=line+1
            icx=1
            do 147 j = lstart,lfinish
              write(word3(1:3),'(a)') am1slots(J)(1:3)
              idcol=m1slots(j,2)
              iicol=0
              if(idcol.eq.0.and.mmod.eq.8)call winscl('-',iicol)
              call findviewtext(icx,line,isize,iix,iiy)
C              iix=ix; iiy=iy
              if(idcol.eq.0)then
                call textatxy(iix,iiy,word3,'-',idcol)
              else
                call textatxy(iix,iiy,word3,'z',idcol)
              endif
              icx=icx+3
  147       continue

C Shift over another character and print out the 2nd months line.
            icx=icx+1
            do 148 j = lstart,lfinish
              write(word3(1:3),'(a)') am2slots(J)(1:3)
              idcol=m2slots(j,2)
              iicol=0
              if(idcol.eq.0.and.mmod.eq.8)call winscl('-',iicol)
              call findviewtext(icx,line,isize,iix,iiy)
C              iix=ix; iiy=iy
              if(idcol.eq.0)then
                call textatxy(iix,iiy,word3,'-',idcol)
              else
                call textatxy(iix,iiy,word3,'z',idcol)
              endif
              icx=icx+3
  148       continue
 149      continue
 144    continue

C Also include list of day types.
        line=line+2
        iicol=0
        if(mmod.eq.8) call winscl('-',iicol)
        write(etext,*) 'Calendar: ',calename
        iside=line; isize=0; ifont=2
        if(mmod.eq.8)then
          call viewtext(etext,iside,isize,ifont)
        else
          call viewtextwwc(etext,iside,isize,ifont)
        endif
        do 151 icd = 1,nbdaytype
          line=line+1
          write(etext,*) calentag(icd),' ',calendayname(icd)
          idcol=icd
          iicol=0
          if(idcol.eq.0.and.mmod.eq.8)call winscl('-',iicol)
          call findviewtext(3,line,isize,iix,iiy)
C          iix=ix; iiy=iy
          if(idcol.eq.0)then
            call textatxy(iix,iiy,etext,'-',idcol)
          else
            call textatxy(iix,iiy,etext,'z',idcol)
          endif
 151    continue
        iicol=0
        if(mmod.eq.8)then
          call winscl('-',iicol)
          call forceflush()
        endif
      endif
      return

C Errors for debug printing.
C   14 if(IOS.eq.2)then
C        CALL USRMSG(' No prmission to write array in ',' ','W')
C      else
C        CALL USRMSG(' Long array write error in ',' ','W')
C      endif
C      IER=1
C      return
      end

C ********** EDDGTP **************
C EDDGTP Sets up ground temperature profiles
      SUBROUTINE EDDGTP(modsit)
#include "building.h"
#include "site.h"
#include "help.h"
      integer iCountWords

      common/OUTIN/IUOUT,IUIN,IEOUT

      CHARACTER HOLD*72,OUTS*124
      LOGICAL MODSIT
      integer ifoc  ! the profile to edit

      helpinsub='context'  ! set for subroutine
      ifoc=1              ! initial assumption

C Ground temperature profiles....
      call edisp(iuout,' ')
      write(outs,'(a,i3,a)')' There are currently ',NGRDP,' profiles.'
      call edisp(iuout,outs)
      helptopic='ground_temp_profile'
      call gethelptext(helpinsub,helptopic,nbhelp)
      if(NGRDP.gt.0)then
        CALL EDISP(IUOUT,' ')
        do 22 igrdp=1,NGRDP
          WRITE(OUTS,'(A,I5)')'Profile number: ',IGRDP
          CALL EDISP(IUOUT,OUTS)
          CALL EDISP(iuout,'Ground temperature profile January-June:')
          WRITE(OUTS,'(12F6.1)')(UGRDTP(J,IGRDP),J=1,6)
          call edisp(iuout,outs)
          CALL EDISP(iuout,'Ground temperature profile July-December:')
          WRITE(OUTS,'(12F6.1)')(UGRDTP(J,IGRDP),J=7,12)
          call edisp(iuout,outs)
          CALL EDISP(IUOUT,' ')
 22     continue
        CALL EASKMBOX(' ','Options:',
     &    'edit profiles','add profile',' ',
     &    ' ',' ',' ',' ',' ',IRT,nbhelp)
        if(IRT.eq.1)then

C Setup which ground temperature profile to edit (ifoc).
          if(NGRDP.gt.0)then
            ifoc=1
            CALL EASKI(IFOC,' ',' Index of profile to edit?',
     &        1,'F',NGRDP,'F',1,'edit profile',IERI,nbhelp)
            if(ieri.eq.-3) then
              modsit=.false.
              return
            endif
            goto 93
          else
            call usrmsg('No profiles known.','Choose add!','W')
            RETURN
          endif
        elseif(IRT.eq.2)then
          if(NGRDP.lt.MGRDP)then
            NGRDP=NGRDP+1
            ifoc=NGRDP  ! set forus for later logic
            goto 93
          else
            call usrmsg('Additional ground temperature profiles',
     &                'not allowed in current model!','W')
            RETURN
          endif
        endif
      ELSE
        CALL EDISP(IUOUT,'No ground temperature profiles defined!')
        if(NGRDP.lt.MGRDP)then
          NGRDP=NGRDP+1
          ifoc=NGRDP   ! set focus for later logic
          goto 93
        else
          call usrmsg('Additional ground temperature profiles',
     &                'not allowed in current model!','W')
          RETURN
        endif
      ENDIF

   93 WRITE(HOLD,'(1X,6F7.2)')(UGRDTP(J,IFOC),J=1,6)
      CALL EASKS(HOLD,' Temperatures January-June:',' ',72,' ',
     &    'gr prof jan-jun',IER,nbhelp)
      NV = iCountWords(HOLD)
      CALL EDISP(IUOUT,' Ground temperature profiles of ')
      CALL EDISP(IUOUT,HOLD)
      CALL EDISP(IUOUT,'will be used for January thro June.')
      if(NV.ne.6)goto 93
      K=0
      DO 94 J=1,6
        CALL EGETWR(HOLD,K,GV,0.,0.,'-','profile',IER)
        IF(IER.NE.0)GOTO 93
        UGRDTP(J,IFOC)=GV
   94 CONTINUE
   95 hold = ' '
      WRITE(HOLD,'(1X,6F7.2)')(UGRDTP(J,IFOC),J=7,12)
      CALL EASKS(HOLD,' Temperatures July-December:',' ',72,' ',
     &    'gr prof jul-dec',IER,nbhelp)
      NV = iCountWords(HOLD)
      CALL EDISP(IUOUT,' Ground temperature profiles of ')
      CALL EDISP(IUOUT,HOLD)
      CALL EDISP(IUOUT,'will be used for July thro December.')
      if(NV.ne.6)goto 95
      K=0
      DO 96 J=7,12
        CALL EGETWR(HOLD,K,GV,0.,0.,'-','profile',IER)
        IF(IER.NE.0)GOTO 95
        UGRDTP(J,IFOC)=GV
   96 CONTINUE
      MODSIT=.true.
      RETURN
      END

C ********** EDDSHD **************
C Sets up shading and insolation files. If called
C with 'site' then force recalcultion of existing
C shading files. If called with 'asci' invoke ish with
C the useupdate_silent parameter to convert existing ASCII
C files if possible.

      SUBROUTINE EDDSHD(act)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "help.h"

      character act*4  ! site or asci

      common/OUTIN/IUOUT,IUIN,IEOUT

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/shad0/ISIcalc,icalcD,icalcM
      integer ISIcalc,icalcD,icalcM

      character outs*248,shdafile*72
      logical XST,XSTA,OK,unixok

      helpinsub='context'  ! set for subroutine

      if(ncomp.eq.0)then
        return
      endif

C Check if Unix-based or DOS based.
      call isunix(unixok)
      if(act.eq.'SITE'.or.act.eq.'site'.or.act.eq.'Site')then
        if(ISIcalc.eq.1)then
          continue
        else
          do iz=1,ncomp
            if(ISI(iz).eq.1)then
              call FINDFIL(LSHAD(iz),XST)
              if(XST)then
                write(outs,'(3a)') 'Shading for ',
     &            zname(iz)(1:lnzname(iz)),' is out of date.'
                call edisp(iuout,' ')
                call edisp(iuout,outs)
              endif
            endif
          enddo
        endif
      elseif(act.eq.'ASCI'.or.act.eq.'asci')then
        if(ISIcalc.eq.1)then
          continue
        else
          do iz=1,ncomp
            if(ISI(iz).eq.1)then
              write(shdafile,'(2a)') lshad(iz)(1:lnblnk(lshad(iz))),'a'
              call FINDFIL(shdafile,XST)
              if(XST)then
                write(outs,'(3a)') 'Shading for ',
     &          zname(iz)(1:lnzname(iz)),' can be imported from ASCII.'
                call edisp(iuout,outs)
              endif
            endif
          enddo
        endif
      endif

C Proceed to recalculate all shading/insolation to refelect
C the site change.
      if(act.eq.'SITE'.or.act.eq.'site'.or.act.eq.'Site')then
        if(ISIcalc.eq.1)then
          IRT=3  ! skip if embedded calculations
        else
          helptopic='reflect_site_change'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL EASKMBOX(' ','Reflect site change in shading options:',
     &      'recalculate (silent)','recalculate (interactive)','cancel',
     &      ' ',' ',' ',' ',' ',IRT,nbhelp)
        endif
        if(IRT.eq.1.or.IRT.eq.2)then
          do 43 iz=1,ncomp
            if(ISI(iz).eq.0) goto 43
            call FINDFIL(LSHAD(iz),XST)

C Get logical name of terminal type, expand model name
C to include the path and create a string to drive ish.
C If user asked for silent recalculation then do each
C one in forground in an xterm with `-act update_silent`
C as the command line.
            if(IRT.eq.1)then
              call comissionish(iz,'sra',ier)
              if(ier.ne.0)then
                call edisp(iuout,'Possible error in calculations.')
              endif
            else
              write(outs,'(3a)') 'Proceed with shading for ',
     &          zname(iz)(1:lnzname(iz)),'?'
              CALL EASKOK(' ',outs,OK,nbhelp)
              if(OK)then
                call comissionish(iz,'ira',ier)
                if(ier.ne.0)then
                  call edisp(iuout,'Possible error in calculations.')
                endif
              endif
            endif
  43      continue
          call edisp(iuout,
     &      'Update of zones with shading files complete.')
        endif
      elseif(act.eq.'ASCI'.or.act.eq.'asci')then
        if(ISIcalc.eq.1)then
          continue
        else
          helptopic='reflect_site_change'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL EASKMBOX(' ','Shading data options:',
     &     'import from ASCII if available',
     &     'recalculate missing (silent)',
     &     'recalculate (interactive)','cancel',
     &     ' ',' ',' ',' ',IRT,nbhelp)
          if(IRT.eq.1.or.IRT.eq.2.or.IRT.eq.3)then
            do iz=1,ncomp
              if(ISI(iz).gt.0)then
                call FINDFIL(LSHAD(iz),XST)
                write(shdafile,'(2a)') 
     &            lshad(iz)(1:lnblnk(lshad(iz))),'a'
                call FINDFIL(shdafile,XSTA)

C If ASCII available ask for import otherwise do with
C an `-act update_silent` as the command line.
                if(IRT.eq.1)then
                  if(XSTA)then
                    call comissionish(iz,'sab',ier)
                    if(ier.ne.0)then
                    call edisp(iuout,'Possible error in calculations.')
                    endif
                  else
                    if(XST)then

C << TODO read ISH file and ensure syntax is correct >>
                      continue  ! bin exists so can skip recalculation
                    else
                      call comissionish(iz,'sua',ier)
                      if(ier.ne.0)then
                        call edisp(iuout,'Possible error in calcs.')
                      endif
                    endif
                  endif
                elseif(IRT.eq.2)then
                  call comissionish(iz,'sra',ier)
                  if(ier.ne.0)then
                  call edisp(iuout,'Possible error in calculations.')
                  endif
                elseif(IRT.eq.3)then

                  write(outs,'(3a)') 'Proceed with shading for ',
     &              zname(iz)(1:lnzname(iz)),'?'
                  CALL EASKOK(' ',outs,OK,nbhelp)
                  if(OK)then
                    call comissionish(iz,'ira',ier)
                    if(ier.ne.0)then
                    call edisp(iuout,'Possible error in calculations.')
                    endif
                  endif
                endif
              endif
            enddo
            call edisp(iuout,
     &        'Update of zones with shading files complete.')
          endif
        endif
      endif
      return
      end

