C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.

C************SYSTEM.F
C Systems describes the performance of various the various CCHP plant
C layouts available to the user. System.F will eventually be replaced 
C by a more modular plant desription system i.e. with choices of 
C individual packaged type units, ideal systems (algorithm based).  
C This model will be replaced once initial model testing is completed.
C
C*******CHPSYS
      SUBROUTINE CHPSYS

C CHP COMMON BLOCK DATA
      COMMON/CHPDAT/QCHP,QELECT,QIN,FUELFLW,ICHPSYS,CHPBSLD
C Call the appropriate subroutine determined by the ICHPSYS 
C variable.
      IF (ICHPSYS.EQ.1) THEN
C Ideal combined heat and power model chp001
         CALL CHP001
      ELSE 
         WRITE(*,*)' This component does not exist! '
      ENDIF

C Return to the calling module
      RETURN

      END 
C*******CHP001
C
C This model of a CHP unit is an initial simplified unit. Electrical and 
C heating fluxes are taken from a general system model in "Energy Saver 
C - chapter 10 Combined Heat and Power." The Energy utilisation factor 
C for the unit assumes there is no condensing of the exhaust gasses, 
C s-a
C also the efficiency used is only correct for machines > 50 kW.
C 
C CHP001 is an idealised and simplified model of a reciprocating diesel 
C engine with jacket cooling and exhaust gas heat recovery. The model 
C feeds an LPHW system heat-exchanger, or supplies flux directly to a 
C building zone.  
C *********************************************************************
C
C Variables used in this routine and common blocks.
C
C QCHP - Heat generated or recovered from the CHP unit
C QELECT - Electrical power generated by the CHP unit
C FUELFLW - CHP unit fuel consumption
C ICHPSYS - CHP unit id number 
C CHPBSLD - The building side load for the CHP unit
C QIN - The energy input to the CHP unit.
C Internal varaiables
C
C EUF - Energy utilisation factor
C HTPR - The heat to power ratio
C CVFUEL -The fuel calorific value
C
C *********************************************************************
      SUBROUTINE CHP001
C     
C CHP COMMON BLOCK DATA
      COMMON/CHPDAT/QCHP,QELECT,QIN,FUELFLW,ICHPSYS,CHPBSLD
C
C
C Establish the EUF of the system
C for the moment assume this is a constant.
      EUF=0.84
C this corresponds to 84% useful energy recovery.

C Establish the heat to power-to-heat ratio of the engine.
C elect- 31%
C heat - 53%
C HTPR-heat/elect
      HTPR=1.545

C Establish the fuel calorific value
      CVFUEL=49605172
C Value in J/kgmol

C Establish the energy requirement of the CHP cycle
C from the base load.
      QIN=(CHPBSLD + (CHPBSLD/HTPR))/EUF

C Establish the electrical power output from base load.  
      QELECT=CHPBSLD/HTPR

C Establish the heat output from the unit, in this ideal case the
C output of the unit will equal the requires base load
      QCHP=CHPBSLD

C Calculate the fuel mass flow
      FUELFLW=QIN/CVFUEL
 
C Return to calling module
      RETURN

      END
