C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file contains the following subroutines.
C SHSYNP   - display table of direct and diffuse shading factors for analysed surfaces
C            based on scan of transitional file.
C SHADSYNP - display table of direct and diffuse shading factors for analysed surfaces
C            based on common block data.
C INSYNP   - display internal surface insolation proportions for analysed sources.

C ******************** SHSYNP ********************
C Displays a table showing the percentage direct and diffuse
C surface shading for each hour based on information held within
C a zone transitional shading file.

      subroutine shsynp(icomp,allsurf)
#include "building.h"
#include "geometry.h"
      
      integer lnblnk  ! function definition
      integer icomp   ! focus zone
      logical allsurf ! if true then do not ask for user confirmation

      common/outin/iuout,iuin,ieout
      common/filep/ifil
      common/filech/ixopen,ixunit,ixpunit
      common/prec8/slat,slon
      integer mon,isc,iyd
      common/contr/mon,isc(ms),iyd
      common/headl/irecs(ms)
      integer izstocn
      common/c24/izstocn(mcom,ms)
      common/data2/pso(ms,mt),psof(ms,mt)

      dimension month(12),iavdec(12)
      character outs*124,month*3,sn*12
      logical ok
 
      integer iexcludediff_flag
      common/excludediff/iexcludediff_flag

      data iavdec/17,15,16,15,15,11,17,16,16,16,15,11/
      data month/'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
     &            'Sep','Oct','Nov','Dec'/

C If output to file, alter the edisp unit number. Also auto yes
C for user questions about surfaces and months.
      itru=iuout
      if(ixopen.eq.1)then
        itru = ixunit
        call edisp(iuout,' ')
        call edisp(iuout,'Output directed to file.')
      endif

      iunit=ifil

      call edisp(itru,' ')
      write(outs,'(a,i3,1x,2a)')'External surface shading for ',
     &                           iavdec(mon),month(mon),'.'
      call edisp(itru,outs)

C Retrieve shading information from zone transitional shading file
C and display on a surface-by-surface basis.
      do 10 i=1,nzsur(icomp)
        if(isc(i).eq.0)goto 10
        icn=izstocn(icomp,i)

C shddt & shdft are shading summations, ishdh is number of sun-up
C hours. 
        shddt=0
        shdft=0
        ishdh=0

C Write output header information.
        sn=sname(icomp,i)
        write(outs,'(a,i3,3a)') 'Surface ',i,' (',sn(1:lnblnk(sn)),')'
        call edisp(itru,outs)
        write(outs,'(3a)') ' Hour   Direct   Diffuse   Solar   Solar'
        call edisp(itru,outs)
        write(outs,'(3a)')
     &                 '        Shading  Shading   Azimuth Altitude'
        call edisp(itru,outs)

C Recover calculated shading for the current surface hour-by-hour.
        irec=irecs(i)+2
        iprint=0
        do 20 j=1,24
           stime=float(j)
   
C << the value of isunupx should be the same as what is
C << read from the transitional file.
           call eazalts(stime,iyd,slat,slon,isunupx,sazi,salt)
           isunup=isunupx
           read(iunit,rec=irec,iostat=istat,err=1000)isunup
           irec=irec+1
           if(isunup.eq.0)then  ! Sun not up.
              if(iprint.eq.2)then
                 write(outs,'(i3,a)')j,':00   After sun-set'
                 call edisp(itru,outs)
                 iprint=-1  ! do not write again
              else
                 iprint=1
              endif
              pso(i,j)=0.0
              psof(i,j)=0.0
           else            ! Sun up.
              if(iprint.eq.1)then
                 write(outs,'(i3,a)')j-1,':00   Before sun-rise'
                 call edisp(itru,outs)
              endif

C inds indicates whether direct shading is total, partial or zero.
C << if inds were written to the ascii file then we would not need
C << to use the transitional file for the summary it would need to
C << be a 2D array of 24 columns * nzsur rows
              read(iunit,rec=irec,iostat=istat,err=1000)inds
              irec=irec+1
              iprint=2

C No direct shading.
              if(inds.eq.-2)then
                 read(iunit,rec=irec,iostat=istat,err=1000)pso(i,j),
     &                                                     psof(i,j)
                 irec=irec+1
                 if(iexcludediff_flag.eq.0)then
                    write(outs,'(i3,a,f8.1,a,2x,2f8.1)')j,
     &                      ':00     0.0%',psof(i,j)*100.0,'%',sazi,salt
                 elseif(iexcludediff_flag.eq.1)then                   
                    write(outs,'(i3,a,a,2x,2f8.1)')j,
     &                      ':00     0.0%',' excluded',sazi,salt
                 endif
                 call edisp(itru,outs)
                 shdft=shdft+psof(i,j)*100.0
                 ishdh=ishdh+1

C Total direct shading.
              elseif(inds.eq.-1)then
                 read(iunit,rec=irec,iostat=istat,err=1000)pso(i,j),
     &                                                     psof(i,j)
                 irec=irec+1
                 if(iexcludediff_flag.eq.0)then                 
                    write(outs,'(i3,a,f8.1,a,2x,2f8.1)')j,
     &                    ':00   100.0%',psof(i,j)*100.0,'%',sazi,salt
                 elseif(iexcludediff_flag.eq.1)then
                    write(outs,'(i3,a,a,2x,2f8.1)')j,
     &                    ':00   100.0%',' excluded',sazi,salt
                 endif   
                 call edisp(itru,outs)
                 shddt=shddt+100.0
                 shdft=shdft+psof(i,j)*100.0
                 ishdh=ishdh+1

C Partial direct shading: increment irec by nox to skip over
C ioshd array.
              elseif(inds.eq.0)then
                 irec=irec+nox(icomp)
                 read(iunit,rec=irec,iostat=istat,err=1000)pso(i,j),
     &                                                     psof(i,j)
                 irec=irec+1
                 if(iexcludediff_flag.eq.0)then                   
                   write(outs,'(i3,a,f8.1,a,f8.1,a,2x,2f8.1)')j,':00',
     &                pso(i,j)*100.0,'%',psof(i,j)*100.0,'%',sazi,salt
                 elseif(iexcludediff_flag.eq.1)then  
                   write(outs,'(i3,a,f8.1,a,a,2x,2f8.1)')j,':00',
     &                pso(i,j)*100.0,'%',' excluded',sazi,salt                 
                 endif   
                 call edisp(itru,outs)
                 shddt=shddt+pso(i,j)*100.0
                 shdft=shdft+psof(i,j)*100.0
                 ishdh=ishdh+1
              endif
           endif
   20   continue
        write(outs,'(a,f5.1,a)')
     &      'Averages for sun-up hours: Direct  = ',shddt/ishdh,'%'
        call edisp(itru,outs)
        write(outs,'(a,f5.1,a)')
     &      '                           Diffuse = ',shdft/ishdh,'%'
        call edisp(itru,outs)

C Determine if results are available for another surface?
        if(i.eq.nzsur(icomp))return
        mores=0
        do 30 j=i+1,nzsur(icomp)
           if(isc(j).ne.0)mores=1
   30   continue
        if(mores.eq.0)return
        if(allsurf)then
          continue
        else
          call easkok(' ','Consider next surface?',ok,0)
          if(.not.ok)return
        endif
   10 continue

 1000 write(outs,1001)irec
 1001 format('SHSYNP: Zone transitional shading file error, record',i6)
      call edisp(iuout,' ')
      call edisp(iuout,outs)
      return
      end

C ******************** SHADSYNP ********************
C Displays a table showing the percentage direct and diffuse
C surface shading for each hour based on common block data.

      subroutine shadsynp(icomp)
#include "building.h"
#include "geometry.h"
      
      integer lnblnk  ! function definition

      common/outin/iuout,iuin,ieout
      common/filech/ixopen,ixunit,ixpunit
      common/prec8/slat,slon
      integer mon,isc,iyd
      common/contr/mon,isc(ms),iyd
      integer izstocn
      common/c24/izstocn(mcom,ms)
      common/data2/pso(ms,mt),psof(ms,mt)

      dimension month(12),iavdec(12)
      character outs*124,month*3,sn*12
      logical ok
 
      integer iexcludediff_flag
      common/excludediff/iexcludediff_flag
      
      data iavdec/17,15,16,15,15,11,17,16,16,16,15,11/
      data month/'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
     &            'Sep','Oct','Nov','Dec'/

C If output to file, alter the edisp unit number.
      itru=iuout
      if(ixopen.eq.1)then
        itru = ixunit
        call edisp(iuout,' ')
        call edisp(iuout,'Output directed to file.')
      endif

      call edisp(itru,' ')
      write(outs,'(a,i2,1x,2a)')'External surface shading for ',
     &                           iavdec(mon),month(mon),'.'
      call edisp(itru,outs)

C Retrieve shading information from common blocks
C and display on a surface-by-surface basis.

C Re-establish isc(i).
      icont=0
      call findisc(icomp,ier,'s',icont)
      do 10 i=1,nzsur(icomp)
        if(isc(i).eq.0)goto 10
        icn=izstocn(icomp,i)
        sn=sname(icomp,i)

C shddt & shdft are shading summations, ishdh is number of sun-up
C hours. 
        shddt=0
        shdft=0
        ishdh=0

C Write output header information.
        write(outs,'(a,i3,3a)') 'Surface ',i,' (',sn(1:lnblnk(sn)),')'
        call edisp(itru,outs)
        write(outs,'(3a)') ' Hour   Direct   Diffuse   Solar   Solar'
        call edisp(itru,outs)
        write(outs,'(3a)')
     &                 '        Shading  Shading   Azimuth Altitude'
        call edisp(itru,outs)

        iprint=0
        do 20 j=1,24
           stime=float(j)
   
C The value of isunupx indicates if sun is up.
           call eazalts(stime,iyd,slat,slon,isunupx,sazi,salt)
           isunup=isunupx
           if(isunup.eq.0)then  ! Sun not up.
              if(iprint.eq.2)then
                 write(outs,'(i3,a)')j,':00   After sun-set'
                 call edisp(itru,outs)
                 iprint=-1      ! do not write again
              else
                 iprint=1
              endif
              pso(i,j)=0.0
              psof(i,j)=0.0
           else   ! Sun up.
              if(iprint.eq.1)then
                 write(outs,'(i3,a)')j-1,':00   Before sun-rise'
                 call edisp(itru,outs)
              endif

C inds indicates whether direct shading is total, partial or zero.
C the value is not recorded in the binary or ascii file (yet) so
C assume format for mixed.
              iprint=2

C Partial direct shading: increment irec by nox to skip over
C ioshd array.
              if(iexcludediff_flag.eq.0)then    
                 write(outs,'(i3,a,f8.1,a,f8.1,a,2x,2f8.1)')j,':00',
     &                 pso(i,j)*100.0,'%',psof(i,j)*100.0,'%',sazi,salt
              elseif(iexcludediff_flag.eq.1)then
                 write(outs,'(i3,a,f8.1,a,a,2x,2f8.1)')j,':00',
     &                 pso(i,j)*100.0,'%',' excluded',sazi,salt              
              endif
              call edisp(itru,outs)
              shddt=shddt+pso(i,j)*100.0
              shdft=shdft+psof(i,j)*100.0
              ishdh=ishdh+1
           endif
   20   continue
        write(outs,'(a,f5.1,a)')
     &      'Averages for sun-up hours: Direct  = ',shddt/ishdh,'%'
        call edisp(itru,outs)
        write(outs,'(a,f5.1,a)')
     &      '                           Diffuse = ',shdft/ishdh,'%'
        call edisp(itru,outs)

C Determine if results are required for another surface.
        if(i.eq.nzsur(icomp))return
        mores=0
        do 30 j=i+1,nzsur(icomp)
           if(isc(j).ne.0)mores=1
   30   continue
        if(mores.eq.0)return
        call easkok(' ','Consider next surface?',ok,0)
        if(.not.ok)return
   10 continue

      return
      end

C ******************** INSYNP ********************
C Outputs information on internal surface insolation.
C parameter act (1 char) is 's' for silent mode and 'i' for interacitve.

      subroutine insynp(icomp,act,allsurf)
#include "building.h"
#include "geometry.h"
      
      integer lnblnk  ! function definition
      integer icomp   ! focus zone
      character act*1
      logical allsurf ! if true then do not ask user confirmation

      common/outin/iuout,iuin,ieout
      common/filech/ixopen,ixunit,ixpunit
      common/prec8/slat,slon
      integer mon,isc,iyd
      common/contr/mon,isc(ms),iyd
      integer izstocn
      common/c24/izstocn(mcom,ms)
      common/data2/pso(ms,24),psof(ms,24)
      common/data3/ishd(12),isadd(12),ntmc(ms),ioffs(ms)
      common/data4/insst(mgt,24,misur),pinsst(mgt,24,misur)

      character month*3,outs*124,sn*12
      dimension month(12),iavdec(12)
      logical close,ok

      data iavdec/17,15,16,15,15,11,17,16,16,16,15,11/
      data month/'Jan','Feb','Mar','Apr','May','Jun','Jul',
     &'Aug','Sep','Oct','Nov','Dec'/

      if(isadd(mon).eq.0.or.ishd(mon).eq.1)then
        call edisp(iuout,' ')
        write(outs,'(3a)')'No insolation data for ',month(mon),'!'
        call edisp(iuout,outs)
        return
      endif

C If output to file, alter the edisp unit number.
      itru = iuout
      if(ixopen.eq.1)then
        itru = ixunit
      endif

      kount=0
      call edisp(itru,' ')
      write(outs,'(a,i2,1x,2a)')'Internal surface insolation for ',
     &                           iavdec(mon),month(mon),
     &                  '.'
      call edisp(itru,outs)

C Display on a surface-by-surface basis.
      do 10 i=1,nzsur(icomp)
        if(ntmc(i).eq.0)goto 10
        icn=izstocn(icomp,i)
        sn=sname(icomp,i)

C ntmc is 0 or 1.
        kount=kount+ntmc(i)
        write(outs,'(a,i3,3a)') 'Source surface is ',i,' (',
     &                           sn(1:lnblnk(sn)),').'
        call edisp(itru,outs)
        call edisp(itru,
     & ' Hour  Source   Receiving     Proportion   Solar   Solar')
        call edisp(itru,
     & '       Shading  Surface       Received     Azimuth Altitude')

        iprint=0
        do 20 j=1,24
          stime=float(j)
          call eazalts(stime,iyd,slat,slon,isunupx,sazi,salt)
          
C Sun not up.
          if(insst(kount,j,1).eq.-1)then
            if(iprint.eq.2)then
              write(outs,'(i3,a)')j,':00  After sun-set'
              call edisp(itru,outs)
             iprint=-1   ! do not write again
            else
             iprint=1
            endif
            
C Surface shaded.
          elseif(insst(kount,j,1).eq.0)then
            if(iprint.eq.1)then
              write(outs,'(i3,a)')j-1,':00  Before sun-rise'
              call edisp(itru,outs)
            endif
            write(outs,'(i3,a,28x,2f8.1)')  j,':00  100.0%',sazi,salt
            call edisp(itru,outs)
            iprint=2
            
C Surface insolated.
          else
            if(iprint.eq.1)then
              write(outs,'(i3,a)')j-1,':00  Before sun-rise'
              call edisp(itru,outs)
            endif
            if(pso(i,j).gt.0.999)then
              write(outs,1000)j,sazi,salt
 1000         format(i3,':00 100.0%',2f8.1)
              call edisp(itru,outs)
            else
              do k=1,misur

C Of misur possibilities only print internal surfaces with
C non zero pinsst.
                call eclose(pinsst(kount,j,k),0.0,0.001,close)
                if(.not.close)then
                  if(k.eq.1)then
                    l=insst(kount,j,k)
                    icm=izstocn(icomp,l)
                    sn=sname(icomp,l)
                    write(outs,1001)j,pso(i,j)*100.0,l,
     &                sn(1:12),pinsst(kount,j,k)*100.0,sazi,salt
 1001               format(i3,':00',f6.1,'% ',i3,' (',a,')',
     &                     f6.1,'%',4x,2f8.1)
                    call edisp(itru,outs)
                  else
                    l=insst(kount,j,k)
                    icm=izstocn(icomp,l)
                    sn=sname(icomp,l)
                    write(outs,1002)l,sn(1:12),
     &                    pinsst(kount,j,k)*100.0
 1002               format(13x,i3,' (',a,')',f6.1,'%')
                    call edisp(itru,outs)
                  endif
                endif
              enddo
            endif
            iprint=2
          endif
   20   continue

C Determine if results are available for another surface? If silent
C mode then list all surfaces.
        if(i.eq.nzsur(icomp))return
        mores=0
        do 40 j=i+1,nzsur(icomp)
          if(ntmc(j).ne.0)mores=1
   40   continue
        if(mores.eq.0)return
        if(act.eq.'s')then
          ok=.true.
        else
          if(allsurf)then
            ok=.true.
          else
            call easkok(' ','Consider next source surface?',ok,0)
          endif
        endif
        if(.not.ok)return
   10 continue
      return
      end
