C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001-.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 or later).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.

C  Zoneslist : Display Zones list and wait for INIPIC item selected
C  ZNLIST :    Takes the current selected zones and builds a descriptive
C              string to be used in headers.
C  ZoneDisp :  Displays zone based information
C  CompoList : Display Composites list and wait for INIPIC item selected
C  DispTRev :  Display the reverberation time
C  PLOTTrev : Plot the reverberation time curve

C********************* Zoneslist (copy of MOZDFN from resdef.F) ****
C Display Zones list and wait for INIPIC item selected
C the zone no are recorded in NZNOG

      SUBROUTINE Zoneslist
#include "building.h"
#include "geometry.h"
#include "help.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/surfsel/isursel(MCON),NbSurSel(MCOM)
      COMMON/FOPENED/CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK
      COMMON/ERRHAND/IDerr

      LOGICAL CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK

      DIMENSION IVALZ(MCOM)

      helpinsub='acoesp'  ! set for subroutine

      do 5 i=1,MCOM
        NbSurSel(i) = 0
  5   continue

      if (.not.cfgok) goto 666

C Clear nznog array and isursel array (remembers which surfaces have
C been selected).
      do 6 II=1,MCOM
        nznog(II)=0
  6   continue
      NZG=0
      do 8 II=1,MCON
        isursel(II)=0
  8   continue
      if(NCOMP.EQ.1)then
        call edisp(iuout,' Single zone model, this zone selected. ')
        call edisp(iuout,'  ')
        NZG=1
        nznog(1)=1
      else

C Otherwise select the zones from a list of zone names.
        call edisp(iuout,' Zone selection... ')
        call edisp(iuout,'  ')

 7      helptopic='aco_zones_to_inclue'
        call gethelptext(helpinsub,helptopic,nbhelp)
        INPIC=NCOMP
        CALL EPICKS(INPIC,IVALZ,' ','Which zones to include:',
     &    12,NCOMP,ZNAME,'Zone(s) list',IDerr,nbhelp)

C Check for errors (if => exit sub).
        if (IDerr.ne.0) goto 666
C If no zones have been selected then return to main menu.
        if (INPIC.eq.0) then
          izgfoc = 0           
          call edisp(iuout,' Returning to main menu.... ')
          GOTO 666
        endif
        NZG=INPIC
        izgfoc = Ncomp
        do 40 I=1,INPIC
          NZNOG(I)=IVALZ(I)
 40     continue

C Two zones cannot have the same number.
        DO 32 I=1,NZG
          DO 30 J=1,NZG
            IF(I.EQ.J)goto 30
            J1=NZNOG(I)
            J2=NZNOG(J)
            IF(J1.EQ.J2)then
              call edisp(iuout,'Two zones cannot have the same number!')
              goto 7
            endif
 30       continue
 32     continue
      endif

 666  RETURN
      END


C ******************** ZNLIST (edited from esrures/utils.F) *******
C Takes the current selected zones and builds a descriptive
C string to be used in headers. 
C zdescr : string containing the names of the slected zone(s)
C length : Length of zdescr

      SUBROUTINE ZNLIST(zdescr,length,ierr)
#include "building.h"
#include "geometry.h"

      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)
      CHARACTER zdescr*80,outs*244,outsd*80
      logical unixok

      length=0
      do 42 i=1,nzg
        lna=lnzname(nznog(i))
        length=length+lna+1
  42  continue
      if(length.lt.72)then
        WRITE(outs,5,iostat=ios,err=1)(zname(nznog(I)),I=1,nzg)
    5   FORMAT(20(a12,' '))
        call sdelim(outs,outsd,'S',IW)
        zdescr=outsd
        return
      else
        if(nzg.eq.1)then
         WRITE(ZDESCR,'(A,I2,A,A)')' (',nznog(1),') ',zname(nznog(1))
        elseif(nzg.gt.1.and.nzg.LE.20)THEN
         WRITE(ZDESCR,6)(nznog(I),I=1,nzg)
    6    FORMAT(20(I2,','))
        ELSEIF(nzg.GT.20.AND.nzg.LE.24)THEN
         WRITE(ZDESCR,7)(nznog(I),I=1,9),(nznog(J),J=10,nzg)
    7    FORMAT(9(I1,','),15(I2,','))
        ELSEIF(nzg.GT.24)THEN
         WRITE(ZDESCR,8)(nznog(I),I=1,9),(nznog(J),J=10,24)
    8    FORMAT(9(I1,','),15(I2,','))
        ENDIF
        return
      endif

C Trap for I/O error.
 1    call isunix(unixok)
      if(.NOT.unixok) return  ! if DOS return because of lack of I/O channel
        call lusrmsg('ZNLIST: error writing zone names: ',
     &    outs,'-')
      ierr=1
      
      return
      END


C ************* ZoneDisp
C ZoneDisp - displays zone based information and allows....
      SUBROUTINE ZoneDisp(icomp)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "prj3dv.h"

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      common/gzonpik/izgfoc,nzg,nznog(mcom)

      COMMON/SDATA/GSA(MS),GWA(MS)

      CHARACTER outs*124

      LOGICAL zbzero
      logical context

C Initialisation
      zbzero=.FALSE.

C Read geometry file for chosen zone.
      ITMP=IFIL+1
      call georead(ITMP,LGEOM(ICOMP),ICOMP,0,iuout,IER)
      MODIFYVIEW=.TRUE.  ! signal view and view bounds to be updated
      MODBND=.TRUE.
      nzg=1
      nznog(1)=ICOMP
      izgfoc=ICOMP
      CALL redraw(IER)

C Recover zone data (read only, no display).
      CALL ZINFO(icomp,ZOA,ZVOL,'q')
      vol(icomp)=zvol
      CALL ECLOSE(ZBASEA(ICOMP),0.0,0.001,zbzero)
      OPQ=0.
      TRN=0.
      DO 41 I=1,NSUR
        if(SOTF(icomp,i)(1:4).NE.'OPAQ')then
          TRN=TRN+SNA(icomp,I)
        else
          OPQ=OPQ+SNA(icomp,I)
        endif
   41 CONTINUE

C Display high level data.
      write(outs,'(A,A)')' Composition of ',ZNAME(ICOMP)
      call edisp(iuout,outs)
      WRITE(outs,'(a,f8.2,a)')'  Volume :          ',VOL(ICOMP),'m^3'
      call edisp(iuout,outs)
      WRITE(outs,'(a,f8.2,a)')'  Base/floor area : ',ZBASEA(ICOMP),'m^2'
      call edisp(iuout,outs)
      WRITE(outs,'(a,f8.2,a)')'  Opaque constr. (OPQ):  ',OPQ,'m^2'
      call edisp(iuout,outs)
      WRITE(outs,'(a,f8.2,a)')'  Trans. constr. (TRN): ',TRN,'m^2'
      call edisp(iuout,outs)

C IF * BROWSE
      context=.false.
      CALL SURINFO(ICOMP,iuout,context)

      END


C********************* CompoList **************************
C Display Composites list and wait for INIPIC item selected

C IComfoc      (Integer) Composite selected
C NComPik          (Integer) Number of selected composites (INPIC)
C LstComp(NMLC) (Integer) List of the selected composites number
C WidthCo (Real) : Width [m] of the composite, for LCA calculation.
C HeightCo (Real) : Height [m] of the composite, for LCA calculation.


      SUBROUTINE CompoList
#include "building.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "material.h"
#include "help.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/FOPENED/CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK
      COMMON/ERRHAND/IDerr
      COMMON/CompPik/IComfoc,NComPik,LstComp(MMLC)

      LOGICAL CFGOK,MLDBOK,MATDBOK,CTLOK,OPTKOK,CFCDBOK

      DIMENSION IVALZ(MCOM)

      helpinsub='acoesp'  ! set for subroutine

C Read database if not already done.
      if (.not.MLDBOK) then 
        call ERMLDB(0,iuout,IER)
        IF(IER.NE.0)THEN
          CALL USRMSG(
     &    ' Error in reading construction.',
     &    ' Unable to create zone construction file!','W')
          RETURN
        ELSE
          MLDBOK=.TRUE.
        ENDIF
      ENDIF

      DO 6 II=1,NComPik
        LstComp(II)=0
 6    continue
      NComPik=0

C Otherwise select the constructions from a list of names.
C << Copy mlcname array into a local array for use with epicks >>
      call edisp(iuout,' Composite(s) selection... ')
      call edisp(iuout,'  ')
 7    helptopic='aco_constr_to_include'
      call gethelptext(helpinsub,helptopic,nbhelp)
      INPIC=NMLC
      CALL EPICKS(INPIC,IVALZ,' ','Which constructions to include:',
     &  24,NMLC,mlcname,' Composite(s) list',IDerr,nbhelp)

C Check for errors (if => exit sub).
      if (IDerr.ne.0) RETURN

C If no composite have been selected then return to main menu.
      NComPik=INPIC
      if (NComPik .eq. 0) then
        IComfoc = 0           
        call edisp(iuout,' Returning to main menu.... ')
        RETURN
      ELSEIF (NComPik .eq. NMLC) THEN
        IComfoc = 0                       
        CALL EPAGE
        call edisp(iuout,' "*All items in list" selected.')
        RETURN
      ENDIF

      IComfoc = NComPik
      do 40 I=1,NComPik
        LstComp(I)=IVALZ(I)
 40   continue

C Two composites cannot have the same number.
      DO 32 I=1,NComPik
        DO 30 J=1,NComPik
          IF(I.EQ.J)goto 30
          J1=LstComp(I)
          J2=LstComp(J)
          IF(J1.EQ.J2)then
            call edisp(iuout,
     &        ' Two composites cannot have the same number!')
            goto 7
          endif
 30     continue
 32   continue


      RETURN
      END


C******************** DispTRev **************************
C Display the reverberation time according to the selected mode (Mode),
C frequency band (IOctave). In numerical mode, ISE displays or not the 
C equivalent surfaces
C
C Mode : 1 = Numeric (3 lines) ;2 = Numeric (1 lines) 
C IOctave : 1 = 1 octave; 2 = 1/3 octave
C ISE :    Flag for detailed display
C          1 = Display only rev. time
C          2 = Display equivalente surfaces
C          3 = Display Absorption coefficients + equivalente surfaces
C
C Method : Set of reverberation time to display
C          1 = Sabine ; 2 = Eyring; 3 = Millington, 4 = all
C IChanel : Sending result to that chanel: 
C          1 = textual feedback or 2 = File

      SUBROUTINE DispTRev(Mode,IOctave,ISE,Method,IAirAb, IChanel)

#include "building.h"
#include "model.h"
#include "geometry.h"
#include "acoustic.h"

      COMMON/gzonpik/izgfoc,nzg,nznog(mcom)
      COMMON/SDATA/GSA(MS),GWA(MS)

      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/MetNam/ACOName,CalName(4),LabFreq(MNbAbs)
      COMMON/AbsoCoef/SysAbsCo(MMLC,MNbAbs),PubAbsCo(MaxPub,MNbAbs),
     &                FurAbsCo(MaxPub,MNbAbs),AirAbs(MNbAbs)
      COMMON/AbsCHAR/PubType(MaxPub),FurType(MaxFur),FurCat(MaxFur)
      COMMON/PubFurZone/NbPub(MaxPub),XNbFur(MaxFur),SNAeff(MS),
     &                  IndexPub(MaxPub),IndexFur(MaxFur)
      COMMON/CPubFurZone/CovSurf(MaxFur)
      COMMON/AirPro/RTair,RHR
      COMMON/Trev/Divis(MNbAbs),SurfEquM(MS,MNbAbs), SEquM(MS,MNbAbs), 
     &            SurfEquP(MaxPub,MNbAbs), SurfEquF(MaxFur,MNbAbs),
     &            SurfEquT(MNbAbs), SurfTot, TReverb(MNbAbs), Tmean

      CHARACTER*36 RevLabA,RevLabB
      CHARACTER*63 FreqLabA,FreqLabB
      CHARACTER extraouts*189, outs*156
      CHARACTER CalName*12,ACOName*72
      CHARACTER*4 LabFreq
      CHARACTER PubType*12, FurType*12, FurCat*4, CovSurf*12

      ITMP=IFIL+1
      RevLabA = ' '
      RevLabB = ' '
      FreqLabA = ' '
      FreqLabB = ' '
      LabFreq(1) = ' 100'
      LabFreq(2) = ' 125'
      LabFreq(3) = ' 160'
      LabFreq(4) = ' 200'
      LabFreq(5) = ' 250'
      LabFreq(6) = ' 315'
      LabFreq(7) = ' 400'
      LabFreq(8) = ' 500'
      LabFreq(9) = ' 630'
      LabFreq(10) = ' 800'
      LabFreq(11) = '1000'
      LabFreq(12) = '1250'
      LabFreq(13) = '1600'
      LabFreq(14) = '2000'
      LabFreq(15) = '2500'
      LabFreq(16) = '3150'
      LabFreq(17) = '4000'
      
      if (Mode.le.2) then
        ICompact = Mode
      else
        continue
      endif
      IF (Method .LT. 4) THEN
        IStart = Method
        IStop = Method 
      ELSEIF (Method .EQ. 4) THEN
        IStart = 1
        IStop = 3
      ELSE
        write(outs,'(a,I1,a)')'The calculation method : ', Method,
     &      ' does not exist. Please check.'
        call edisp(Ichanel,outs)
      ENDIF
      DO 600 M = IStart, IStop

C First reset the divis (sum of absorption) when starting a new calculation method
C and should not reset when calculating the absorption of each zone ...
        DO 10 I=1,MNbAbs
          Divis(I)= 0.0
 10     Continue
        call edisp(Ichanel,
     &  '-------------------------------------------------------------')
        WRITE(outs,'(2a)') ' Calculation method: ', CalName(M)
        call edisp(Ichanel,outs)
        IF (IAirAb .EQ. 1) THEN
          WRITE(outs,'(a)') ' Air absroption: included '
          WRITE(outs,'(a,F6.2)') ' Air Temperature [C]: ', RTair
          call edisp(Ichanel,outs)
          WRITE(outs,'(a,F6.2)') ' Air Humidity [%]: ', RHR
          call edisp(Ichanel,outs)
        ELSE
          WRITE(outs,'(a)') ' Air absoption: NOT included '
        call edisp(Ichanel,outs)
        ENDIF

C Display left part of first label line (Revlab)
        IF (ICompact.EQ.1) THEN
          if (ISE.eq.1) then
            IF (IOctave.EQ.2) THEN
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(50x,a)')FreqLabA
              call edisp(Ichanel,outs)
              write(FreqLabB,'(5(a1,1x,a,2x))')('|',LabFreq(I),I=3,15,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=1,16,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
            ENDIF
          elseif (ISE.eq.2) then
            IF (IOctave.EQ.2) THEN
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(50x,a)')FreqLabA
              call edisp(Ichanel,outs)
              write(FreqLabB,'(5(a1,1x,a,2x))')('|',LabFreq(I),I=3,15,3)
              write(extraouts,'(36x,2x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              RevLabA = '   Surface    |  Area | Construction'
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(extraouts,'(a36,2x,a)')RevLabA,FreqLabB
              call edisp(Ichanel,extraouts)
              RevLabB = '     name     |  [m2] |     name    '
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=1,16,3)
              write(extraouts,'(a36,2x,a)')RevLabB,FreqLabB
              call edisp(Ichanel,extraouts)
            ENDIF
          elseif (ISE.eq.3) then
            IF (IOctave.EQ.2) THEN
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(50x,a)')FreqLabA
              call edisp(Ichanel,outs)
              write(FreqLabB,'(5(a1,1x,a,2x))')('|',LabFreq(I),I=3,15,3)
              write(extraouts,'(36x,2x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              RevLabA = '   Surface    |  Area | Construction'
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(extraouts,'(a36,2x,a)')RevLabA,FreqLabB
              call edisp(Ichanel,extraouts)
              RevLabB = '     name     |  [m2] |     name    '
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=1,16,3)
              write(extraouts,'(a36,2x,a)')RevLabB,FreqLabB
              call edisp(Ichanel,extraouts)
            ENDIF
          endif
        ELSEIF (ICompact.EQ.2) THEN
          if (ISE.eq.1) then
            IF (IOctave.EQ.1) THEN
              FreqLabA= 'Frequency [Hz]'
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(outs,'(50x,a)')FreqLabA
              write(extraouts,'(38x,a)')FreqLabB
            ELSEIF (IOctave.EQ.2) THEN
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(41x,a)') FreqLabA
             write(extraouts,'(22x,17(a1,a,1x))')
     &                        ('|',LabFreq(I),I=1,17)
            ENDIF
          elseif (ISE.eq.2) then
            IF (IOctave.EQ.1) THEN
              RevLabA = '   Surface    |  Area | Construction'
              FreqLabA= '|            Frequency [Hz] '
              RevLabB = '     name     |  [m2] |     name'
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(outs,'(a36,2x,a27)')RevLabA,FreqLabA
              write(extraouts,'(a33,5x,a)')RevLabB,FreqLabB
            ELSEIF (IOctave.EQ.2) THEN
              RevLabA = '   Surface    |Area/Nb|'
              FreqLabA= 'Frequency [Hz]'
              RevLabB = '    name      | [m2/-] '
              write(outs,'(a22,30x,a37)')RevLabA,FreqLabA
              write(extraouts,'(a22,17(a1,a,1x))') RevLabB,
     &                                        ('|',LabFreq(I),I=1,17)
            ENDIF
          elseif (ISE.eq.3) then
            IF (IOctave.EQ.1) THEN
              RevLabA = '   Surface            | Construction'
              FreqLabA= '|            Frequency [Hz] '
              RevLabB = '     name             |     name'
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(outs,'(a36,2x,a27)')RevLabA,FreqLabA
              write(extraouts,'(a33,5x,a)')RevLabB,FreqLabB              
            ELSEIF (IOctave.EQ.2) THEN
              RevLabA = '   Surface             |'
              FreqLabA= 'Frequency [Hz]'
              RevLabB = '    name     '
              write(outs,'(a25,30x,a37)')RevLabA,FreqLabA
              write(extraouts,'(a16,7x,17(a1,a,1x))') RevLabB,
     &                                        ('|',LabFreq(I),I=1,17)
            ENDIF
          endif        
        ELSEIF (ICompact.EQ.3) THEN
          call edisp(Ichanel,'Not yet implemented')
          Continue
        ENDIF
        if (ICompact.EQ.2) then 
          call edisp(Ichanel,outs)
          call edisp(Ichanel,extraouts)
        endif



C Display absorption coefficients information of MATERIAL 
C for each surface in the zone according to the frequency band
          IF (ISE .EQ. 3) THEN
            call edisp(Ichanel,' Absorption coeff.')
            DO 399 J =1,NZG 
              if (NZG.GT.1) then
                 WRITE(outs,'(a,a)') 'zone: ', ZNAME(nZnog(J))
                 call edisp(Ichanel,outs)
              endif
              call georead(ITMP,LGEOM(nZnog(J)),nZnog(J),0,iuout,IER)
              CALL ZINFO(nZnog(J),ZOA,ZVOL,'q')
            DO 400 I = 1,NSUR
              icon=IZSTOCN(nZnog(J),I)
              In = MLCIndex(SMLCN(nZnog(J),I))
              IF (SNA(nZnog(J),I) .GT. 0.) THEN
                if (IOctave .EQ. 1) then
                  WRITE(outs,311) SNAME(nZnog(J),I), SMLCN(nZnog(J),I),
     &                           (SysAbsCo(In,IY),IY=2,17,3)
 311              FORMAT(1X,A,3x, 5x, 3x, A, 6(4x, F4.2))
                  call edisp(Ichanel,outs)
                elseif (IOctave .EQ. 2) then
                  IF (ICompact.EQ.1) THEN
                    WRITE(outs,321) SNAME(nZnog(J),I),SNA(nZnog(J),I), 
     &                 SMLCN(nZnog(J),I),(SysAbsCo(In,IY),IY=3,15,3)
 321                FORMAT(1X,A,3x,F5.1,3x,a, 6(4x, F4.2))
                    call edisp(Ichanel,outs)
                    WRITE(outs,322) (SysAbsCo(In,IY),IY=2,17,3)
 322                FORMAT(36X,6(4x, F4.2))
                    call edisp(Ichanel,outs)
                    WRITE(outs,323) (SysAbsCo(In,IY),IY=1,16,3)
 323                FORMAT(36x,6(4x, F4.2))
                    call edisp(Ichanel,outs)
                    call edisp(Ichanel,' ')
                  ELSE
C Display material name rather surface name
                    WRITE(outs,324) SMLCN(nZnog(J),I),
     &               (SysAbsCo(In,IY),IY=1,17)
 324                FORMAT(1X,A,2x,7x, 17(2x, F4.2))
                    call edisp(Ichanel,outs)
                  ENDIF
                endif
              ENDIF
 400        CONTINUE
 399        CONTINUE 
            call edisp(Ichanel,' ')

C Display absorption coefficients information of PUBLIC
C for each surface in the zone according to the frequency band
            DO 499 k =1,NZG 
              call scnzoneaco(ZNAME(nZnog(k)),0,IER)
              DO 500 It = 1,MaxPub
                IF (NbPub(It) .GT. 0) THEN
                  IF ((It .EQ.1).AND.(k.LE.1)) THEN
                    call edisp(Ichanel,'Public')
                  ENDIF
                  if (NZG.GT.1) then
                    WRITE(outs,'(a,a)') 'zone: ', ZNAME(nZnog(k))
                    call edisp(Ichanel,outs)
                  endif
                  I = IndexPub(It)
                  if (IOctave .EQ. 1) then
                    WRITE(outs,411) PubType(I),'  ',
     &                           (PubAbsCo(I,J),J=2,17,3)
 411                FORMAT(1X,A12,3x, 5x, 3x, A12, 6(4x, F4.2))
                    call edisp(Ichanel,outs)
                  elseif (IOctave .EQ. 2) then
                    IF (ICompact.EQ.1) THEN
                      WRITE(outs,421)  PubType(I),NbPub(I), 
     &                              (PubAbsCo(I,J),J=3,15,3)
 421                  FORMAT(1X,A12,3x,I5,3x,12x, 6(4x, F4.2))
                      call edisp(Ichanel,outs)
                      WRITE(outs,422) (PubAbsCo(I,J),J=2,17,3)
 422                  FORMAT(36X,6(4x, F4.2))
                      call edisp(Ichanel,outs)
                      WRITE(outs,423) (PubAbsCo(I,J),J=1,16,3)
 423                  FORMAT(36x,6(4x, F4.2))
                      call edisp(Ichanel,outs)
                      call edisp(Ichanel,' ')
                    ELSE
C Display public name rather surface name
                      WRITE(outs,424) PubType(I),
     &                                (PubAbsCo(I,J),J=1,17)
 424                  FORMAT(1X,A12,2x,7x, 17(2x, F4.2))
                      call edisp(Ichanel,outs)
                    ENDIF
                  endif
                ELSE
                  GOTO 499
                ENDIF
 500          CONTINUE
 499        CONTINUE


            call edisp(Ichanel,' ')

C Display absorption coefficients information of FURNITURE
C for each surface in the zone according to the frequency band
            DO 699 k =1,NZG 
              call scnzoneaco(ZNAME(nZnog(k)),0,IER)
              DO 700 It = 1,MaxFur
                IF (XNbFur(It) .GT. 0) THEN
                  IF ((It .EQ.1).AND.(k.Eq.1)) THEN
                    call edisp(Ichanel,'Furniture')
                  ENDIF
                  if ((NZG.GT.1).AND.(It.EQ.1)) then
                    WRITE(outs,'(a,a)') 'zone: ', ZNAME(nZnog(k))
                    call edisp(Ichanel,outs)
                  endif
                  I = IndexFur(It)
                  if (IOctave .EQ. 1) then
                    IF (CovSurf(I).EQ.'none') THEN
                      WRITE(outs,511) FurType(IndexFur(I)),' ',
     &                           (FurAbsCo(IndexFur(I),J),J=2,17,3)
 511                  FORMAT(1X,A12,3x, 5x, 3x, A12, 6(4x, F4.2))
                    ELSE
                      WRITE(outs,512) CovSurf(I),' has ',
     &                              FurType(IndexFur(I)), 
     &                             (FurAbsCo(IndexFur(I),J),J=2,17,3)
 512                  FORMAT(1X,A12,3x, A5, 1x, A12,2x, 6(2x, F6.2))
                    ENDIF
                    call edisp(Ichanel,outs)
                  elseif (IOctave .EQ. 2) then
                    IF (ICompact.EQ.1) THEN
                      IF (FurCat(IndexFur(I)).EQ.'Surf') THEN
                        WRITE(outs,521)  FurType(IndexFur(I)),XNbFur(I), 
     &                              (FurAbsCo(IndexFur(I),J),J=3,15,3)
 521                    FORMAT(1X,A12,3x,F5.1,3x,12x, 6(4x, F4.2))
                      ELSE
                        WRITE(outs,526)  FurType(IndexFur(I)), 
     &                 INT(XNbFur(I)),(FurAbsCo(IndexFur(I),J),J=3,15,3)
 526                    FORMAT(1X,A12,3x,I5,3x,12x, 6(4x, F4.2))
                      ENDIF
                      call edisp(Ichanel,outs)
                      WRITE(outs,522) (FurAbsCo(IndexFur(I),J),J=2,17,3)
 522                  FORMAT(36X,6(4x, F4.2))
                      call edisp(Ichanel,outs)
                      WRITE(outs,523) (FurAbsCo(IndexFur(I),J),J=1,16,3)
 523                  FORMAT(36x,6(4x, F4.2))
                      call edisp(Ichanel,outs)
                      call edisp(Ichanel,' ')
                    ELSE
C Display public name rather surface name
                      WRITE(outs,524) FurType(IndexFur(I)),
     &                 (FurAbsCo(IndexFur(I),J),J=1,17)
 524                  FORMAT(1X,A12,2x,7x, 17(2x, F4.2))
                      call edisp(Ichanel,outs)
                    ENDIF
                  endif
                ELSE
                  GOTO 699
                ENDIF
 700          CONTINUE
 699        CONTINUE


            call edisp(Ichanel,' ')
          ENDIF

C Display EQUIVALENT area information 
C for each surface in the zone according to the frequency band 
          IF (ISE .GE. 2) THEN
            call edisp(Ichanel,' ')
            IF (ISE.EQ.3) THEN
              write(outs,'(a25,30x,a37)')RevLabA,FreqLabA
              write(extraouts,'(23x,17(a1,a,1x))') 
     &                                        ('|',LabFreq(I),I=1,17)
             call edisp(Ichanel,outs)
              call edisp(Ichanel,extraouts)
            ENDIF
            call edisp(Ichanel,' Equivalent area [m2]')
            if ((IOctave .EQ. 2).AND.(ICompact.EQ.1)) then
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(50x,a)')FreqLabA
              call edisp(Ichanel,outs)
              write(FreqLabB,'(5(a1,1x,a,2x))')('|',LabFreq(J),J=3,15,3)
              write(extraouts,'(36x,2x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(J),J=2,17,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(J),J=1,16,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
            endif

C Display equivalent surface for MATERIAL
            DO 199 k =1,NZG 
              if (NZG.GT.1) then
                WRITE(outs,'(a,a)') 'zone: ', ZNAME(nZnog(k))
                call edisp(Ichanel,outs)
                call edisp(Ichanel,'-----')
              endif
              call georead(ITMP,LGEOM(nZnog(k)),nZnog(k),0,iuout,IER)
              CALL ZINFO(nZnog(k),ZOA,ZVOL,'q')
              call SurfEquiCalc(nznog(k), M, IAirAb)
            DO 200 I = 1,NSUR
              icon=IZSTOCN(nZnog(k),I)
              ISys = MLCIndex(SMLCN(nZnog(k),I))
              IF (SNA(nZnog(k),I) .GT. 0.) THEN
                if (IOctave .EQ. 1) then
                  WRITE(outs,111)SNAME(nZnog(k),I),SNA(nZnog(k),I),
     &              SMLCN(nZnog(k),I),(SurfEquM(I,IY),IY=2,17,3)
 111              FORMAT(1X,A,1x, F7.1, 1x, A, 2x, 6(2x, F6.1))
                  call edisp(Ichanel,outs)
                  IF (ABS(SNA(nZnog(k),I)-SNAeff(I)).GT.0.001) THEN
                    DO 997 J = 1,MaxFur
                      if (CovSurf(J).EQ.SNAME(nZnog(k),I)) then
                        WRITE(outs,116) '*',-XNbFur(J),FurType(J),
     &                    (-XNbFur(J)* SysAbsCo(ISys,IY),IY=2,17,3)
 116                    FORMAT(13x,A,1x,F7.1,1x,A,2x, 6(2x,F6.1))
                        call edisp(Ichanel,outs)
                      endif
 997                CONTINUE
                  ENDIF
                elseif (IOctave .EQ. 2) then
                  IF (ICompact.EQ.1) THEN
                    WRITE(outs,206)SNAME(nZnog(k),I),SNA(nZnog(k),I),
     &                SMLCN(nZnog(k),I),(SurfEquM(I,IY),IY=3,15,3)
 206                FORMAT(1X,A,3x, F7.1, 3x, A, 6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    WRITE(outs,208) (SurfEquM(I,IY),IY=2,17,3)
 208                FORMAT(37X,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    WRITE(outs,209) (SurfEquM(I,IY),IY=1,16,3)
 209                FORMAT(37x,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    call edisp(Ichanel,' ')
                    if (ABS(SNA(nZnog(k),I)-SNAeff(I)).GT.0.001) then
C If furniture infront of surface
                      DO 999 J = 1,MaxFur
                        if (CovSurf(J).EQ.SNAME(nZnog(k),I)) then
                          WRITE(outs,216)'*',-XNbFur(J),FurType(J),
     &                      (-XNbFur(J)* SysAbsCo(ISys,IY),IY=3,15,3)
 216                      FORMAT(1X,A12,3x, F6.1, 3x, A12, 
     &                           6(2x, F6.1))
                          call edisp(Ichanel,outs)
                          WRITE(outs,218)(-XNbFur(J)* 
     &                              SysAbsCo(ISys,IY),IY=2,17,3)
 218                      FORMAT(37X,6(2x, F6.1))
                          call edisp(Ichanel,outs)
                          WRITE(outs,219)(-XNbFur(J)* 
     &                              SysAbsCo(ISys,IY),IY=1,16,3)
 219                      FORMAT(37x,6(2x, F6.1))
                          call edisp(Ichanel,outs)
                          call edisp(Ichanel,' ')
                        endif
 999                  CONTINUE
                    endif
                  ELSE
                    WRITE(extraouts,214) SNAME(nZnog(k),I),
     &                SNA(nZnog(k),I),(SurfEquM(I,IY),IY=1,17)
 214                FORMAT(1X,A12,1x,F7.1,1x,17(F6.1))
                    call edisp(Ichanel,extraouts)

                    if (ABS(SNA(nZnog(k),I)-SNAeff(I)).GT.0.001) then
C If furniture infront of surface
                      DO 998 J = 1,MaxFur
                       if (CovSurf(J).NE.SNAME(nZnog(k),I)) then
                          WRITE(extraouts,117) '*',FurType(IndexFur(J)),
     &                    -XNbFur(J),
     &                    (-XNbFur(J)* SysAbsCo(Isys,IY),IY=1,17)
 117                      FORMAT(1x,A1,A12,1x,F6.1,1x, 17(F6.1))
                          call edisp(Ichanel,extraouts)
                        endif
 998                  CONTINUE
                    endif
                  ENDIF
                endif
              ENDIF
 200        CONTINUE

C Display equivalent surface for PUBLIC
            DO 300 I = 1,MaxPub
              IF (NbPub(I) .GT. 0) THEN
                if (I .EQ. 1) then
                  call edisp(iuout,' Occupants in Zone:')
                endif
                if (IOctave .EQ. 1) then
                  WRITE(outs,221) PubType(I), NbPub(I), 
     &                           (SurfEquP(I,J),J=2,17,3)
 221              FORMAT(1X,A12,3x, I5, 3x, 12x,1x, 6(2x, F6.1))
                  call edisp(Ichanel,outs)
                elseif (IOctave .EQ. 2) then
                  IF (ICompact.EQ.1) THEN
                    WRITE(outs,301) PubType(I), NbPub(I),
     &                              (SurfEquP(I,J),J=3,15,3)
 301                FORMAT(1X,A12,3x, I5, 3x, 12x, 1x, 6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    WRITE(outs,312) (SurfEquP(I,J),J=2,17,3)
 312                FORMAT(37X,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    WRITE(outs,313) (SurfEquP(I,J),J=1,16,3)
 313                FORMAT(37x,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    call edisp(Ichanel,' ')
                  ELSE
                    WRITE(extraouts,314)  PubType(I), NbPub(I),
     &                           (SurfEquP(I,J),J=1,17)
 314                FORMAT(1X,A12,1x,I4, 4x,17(F6.1))
                    call edisp(Ichanel,extraouts)
                  ENDIF
                endif
              ENDIF
 300        CONTINUE

C Display equivalent surface for FURNITURE 
C ONLY if not in front of surface (This lastest already 
C display in the material list)
            DO 430 I = 1,MaxFur
              IF (XNbFur(I) .GT. 0.) THEN
                if (I .EQ. 1) then
                  call edisp(iuout,' Furniture in Zone:')
                endif
                if (IOctave .EQ. 1) then
                  IF (FurCat(IndexFur(I)).EQ.'Surf') THEN
                    WRITE(outs,331) FurType(IndexFur(I)), XNbFur(I),
     &                    '(',CovSurf(I) ,')', (SurfEquF(I,J),J=2,17,3)
 331                FORMAT(1X,A12,3x, F5.1,2x,A1,A12,A1,6(2x, F6.1))
                  ELSE
                    WRITE(outs,332) FurType(IndexFur(I)),INT(XNbFur(I)),
     &                             (SurfEquF(I,J),J=2,17,3)
 332                FORMAT(1X,A12,3x, I5, 3x, 12x, 1x, 6(2x, F6.1))
                  ENDIF
                  call edisp(Ichanel,outs)
                elseif (IOctave .EQ. 2) then
                  IF (ICompact.EQ.1) THEN
                    IF (FurCat(IndexFur(I)).EQ.'Surf') THEN
                      WRITE(outs,401) FurType(IndexFur(I)), XNbFur(I),
     &                             (SurfEquF(I,J),J=2,17,3)
 401                  FORMAT(1X,A12,3x, F5.1, 3x, 12x, 1x, 6(2x, F6.1))
                    ELSE
                      WRITE(outs,402) FurType(IndexFur(I)),
     &                         INT(XNbFur(I)),(SurfEquF(I,J),J=2,17,3)
 402                  FORMAT(1X,A12,3x, I5, 3x, 12x, 1x, 6(2x, F6.1))
                    ENDIF
                    call edisp(Ichanel,outs)
                    WRITE(outs,412) (SurfEquF(I,J),J=2,17,3)
 412                FORMAT(37X,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    WRITE(outs,413) (SurfEquF(I,J),J=1,16,3)
 413                FORMAT(37x,6(2x, F6.1))
                    call edisp(Ichanel,outs)
                    call edisp(Ichanel,' ')
                  ELSE
                    IF (FurCat(IndexFur(I)).EQ.'Surf') THEN
                     WRITE(extraouts,414)FurType(IndexFur(I)),XNbFur(I),
     &                             (SurfEquF(I,J),J=1,17)
 414                  FORMAT(1X,A12,2x, F6.1, 1x, 17F6.1)
                    ELSE
                      WRITE(extraouts,415) FurType(IndexFur(I)),
     &                         INT(XNbFur(I)),(SurfEquF(I,J),J=1,17)
 415                  FORMAT(1X,A12,1x,I4, 4x,17(F6.1))
                    ENDIF
                    call edisp(Ichanel,extraouts)
                  ENDIF
                endif
              ENDIF
 430        CONTINUE

C Display Total Equivalent surface according to frenquency band
            CALL edisp(Ichanel,' ')
            IF (IOctave .EQ. 1) THEN
              WRITE(outs,122) 'Total equivalent area [m2]',
     &                         (SurfEquT(IY),IY=2,17,3)
 122          FORMAT(10x,A, 1x, 6(2x, F6.1))
              call edisp(Ichanel,outs)
            ELSEIF ((IOctave .EQ. 2).AND.(ICompact.EQ.1)) THEN
              FreqLabA= 'Frequency [Hz]'
              write(outs,'(50x,a)')FreqLabA
              call edisp(Ichanel,outs)
              write(FreqLabB,'(5(a1,1x,a,2x))')('|',LabFreq(I),I=3,15,3)
              write(extraouts,'(36x,2x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=2,17,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              write(FreqLabB,'(6(a1,1x,a,2x))')('|',LabFreq(I),I=1,16,3)
              write(extraouts,'(38x,a)')FreqLabB
              call edisp(Ichanel,extraouts)
              IF (ICompact.EQ.1) THEN
                WRITE(outs,132) 'Total equivalent area [m2]',
     &                           (SurfEquT(IY),IY=3,15,3)
 132            FORMAT(10x,A, 1x, 6(2x, F6.1))
                call edisp(Ichanel,outs)
                WRITE(outs,142) (SurfEquT(IY),IY=2,17,3)
 142            FORMAT(37x, 6(2x, F6.1))
                call edisp(Ichanel,outs)
                WRITE(outs,152) (SurfEquT(IY),IY=1,16,3)
 152            FORMAT(37x, 6(2x, F6.1))
                call edisp(Ichanel,outs)
              ELSE
                WRITE(extraouts,153) 'Total',
     &                               (SurfEquT(IY),IY=1,17)
 153            FORMAT(1x,A14, 17(1x, F5.1))
                call edisp(Ichanel,extraouts)
              ENDIF
            ELSEIF ((IOctave .EQ. 2).AND.(ICompact.EQ.2)) THEN
              WRITE(extraouts,162) 'Total eq. area in zone',
     &                         (SurfEquT(IY),IY=1,17)
 162          FORMAT(A,17F6.1)
              call edisp(Ichanel,extraouts)
            ENDIF

C Display equivalent surface for Air absorption
            IF (ISE .GE. 2) THEN
              IF (IAirAb .eq. 1) THEN
                call edisp(Ichanel,' ')
                if (ICompact.EQ.1) then
                  WRITE(outs,192) 'Air absorption in zone',
     &                           (AirAbs(IY),IY=3,15,3)
 192              FORMAT(14x,A, 1x, 6(2x, F6.1))
                  call edisp(Ichanel,outs)
                  WRITE(outs,172) (AirAbs(IY),IY=2,17,3)
 172              FORMAT(37x, 6(2x, F6.1))
                  call edisp(Ichanel,outs)
                  WRITE(outs,182) (AirAbs(IY),IY=1,16,3)
 182              FORMAT(37x, 6(2x, F6.1))
                  call edisp(Ichanel,outs)
                else
                  IF (IOctave .EQ. 1) THEN
                    WRITE(extraouts,118) 'Air absorption in zone',
     &                           (AirAbs(IY),IY=2,17,3)
 118                FORMAT(10x,A,7x, 17(F6.1,2x))
                  ELSE
                    WRITE(extraouts,119) 'Air absorption in zone',
     &                           (AirAbs(IY),IY=1,17)
 119                FORMAT(A,17(F6.1))
                  ENDIF
                  call edisp(Ichanel,extraouts)
                endif
              ELSE
                WRITE(extraouts,'(a)') 'Air absorption not included'
                call edisp(Ichanel,extraouts)
              ENDIF
              call edisp(Ichanel,' ')
            ENDIF

 199        CONTINUE
          ELSE

C Should any way compute the equivalent area
            DO 691 k =1,NZG 
              call georead(ITMP,LGEOM(nZnog(k)),nZnog(k),0,iuout,IER)
              CALL ZINFO(nZnog(k),ZOA,ZVOL,'q')
              call SurfEquiCalc(nznog(k), M, IAirAb)
 691        CONTINUE
          ENDIF

C Display Reverberation time according to frenquency band
C Display loops trough the calculation method
C Then for the selected method(s) display the corresponding results
          call TrevCalc
          IF (IOctave .EQ. 1) THEN
            WRITE(outs,173) 'REVERBERATION TIME [s]',
     &             (TReverb(IY),IY=2,17,3), TMean,' (Mean value)'
 173        FORMAT(14x,a, 1x,7(4x, F4.2),a)
            call edisp(Ichanel,outs)
          ELSEIF (IOctave .EQ. 2) THEN
            if (ICompact.EQ.1) then
              WRITE(outs,123) 'REVERBERATION TIME [s]',
     &                    (TReverb(IY),IY=3,15,3)
 123          FORMAT(15x,a, 7(4x, F4.2))
              call edisp(Ichanel,outs)
              WRITE(outs,133) (TReverb(IY),IY=2,17,3)
 133          FORMAT(37x,7(4x, F4.2))
              call edisp(Ichanel,outs)
              WRITE(outs,143)(TReverb(IY),IY=1,16,3),TMean,
     &                       ' (Mean value)'
 143          FORMAT(37x,7(4x, F4.2),a)
              call edisp(Ichanel,outs)
              call edisp(Ichanel,' ')
            else
              WRITE(extraouts,140)'REVERBERATION TIME [s]',
     &                             (TReverb(IY),IY=1,17)
 140          FORMAT(1x,A,17(1x, F4.2,1x))
              call edisp(Ichanel,extraouts)
              call edisp(Ichanel,' ')
              WRITE(outs,154)'Mean reverberation time ',TMean,' [s]'
 154          FORMAT(1x,a,F4.2,a)
              call edisp(Ichanel,outs)
            endif
            CALL edisp(Ichanel,' ')
          ENDIF
          CALL PLOTTrev(method,M)
C Next Reverberation time calculation
 600    CONTINUE

      RETURN
      END


C ********************* PLOTTrev *********************
C PLOTTrev - This routine traces the results of the reverberation
C calculation. If all the reverberation time calculation have
C been selected, then add each curve on the same graph.
C MALL       - Index for the calculation metod used (4=all)
C MethodCalc - Index for the current calculation metod (1: Sabine..)
C Isymbol    - Symbol used to draw a curve (see etplot_ in wwcut.c for listing)
C RESMX      - Maximum reverberation time
C RESMN      - Minimum reverberation time

      SUBROUTINE PLOTTrev(MAll, MethodCalc)

#include "building.h"
#include "acoustic.h"

      integer menuchw,igl,igr,igt,igb,igw,igwh
      COMMON/VIEWPX/menuchw,igl,igr,igt,igb,igw,igwh
      COMMON/Zones/TxtZone
      CHARACTER TxtZone*12

      COMMON/MetNam/ACOName,CalName(4),LabFreq(MNbAbs)

      COMMON/Trev/Divis(MNbAbs),SurfEquM(MS,MNbAbs), SEquM(MS,MNbAbs), 
     &            SurfEquP(MaxPub,MNbAbs), SurfEquF(MaxFur,MNbAbs),
     &            SurfEquT(MNbAbs), SurfTot, TReverb(MNbAbs), Tmean

      CHARACTER title*200
      CHARACTER CalName*12,ACOName*72, LabFreq*4
#ifdef OSI
      integer igwid,igheight  ! for use with axiscale
      integer iside,isize,ifont     ! passed to viewtext
      integer iupdown,isym    ! passed to etplot
      integer iigl,iigr,iigt,iigb,iigw,iigwh
      integer iiw1,iiw2,iiw3,iiw4,iimenu
#else
      integer*8 igwid,igheight  ! for use with axiscale
      integer*8 iside,isize,ifont     ! passed to viewtext
      integer*8 iupdown,isym    ! passed to etplot
      integer*8 iigl,iigr,iigt,iigb,iigw,iigwh
      integer*8 iiw1,iiw2,iiw3,iiw4,iimenu
#endif

C Initialisation
      YMAX=1.0
      YMIN=0.0
      RESMX = 0.
      RESMN = 10.

C Setup the graph dimension according to the max and min RT
      IF ((MAll.EQ.4).AND.(MethodCalc.GT.1)) THEN
      ELSE

C Setup and pass in parameters to win3d.
        iiw1=15; iiw2=15; iiw3=5; iiw4=5; iimenu=menuchw
        iigl=igl; iigr=igr; iigt=igt; iigb=igb; iigw=igw; iigwh=igwh
        CALL win3d(iimenu,iiw1,iiw2,iiw3,iiw4,
     &    iigl,iigr,iigt,iigb,iigw,iigwh)
        igl=int(iigl); igr=int(iigr); igt=int(iigt); igb=int(iigb)
        igw=int(iigw); igwh=int(iigwh)
        do 20 I=1,MNbAbs
          if (TReverb(I).gt.RESMX) then
            RESMX=TReverb(I)
          endif
          if (TReverb(I).lt.RESMN) then
            RESMN=TReverb(I)
          endif
 20     continue


C Calculate plotting box locations.
        plxmin=0.
        plxmax=4000.
        YMAX=RESMX+0.5
        YMIN=0.
        igwid=igw
        igheight=igwh
        call axiscale(igwid,igheight,plxmin,plxmax,Ymin,Ymax,                 
     &                            xsc,ysc,sca,xadd,yadd)
        CALL linescale(iigl,xadd,xsc,iigb,yadd,ysc)

C Scale and draw monitoring plot.
        call dintervalf(plxmin,plxmax,ddy1,ny,0)
        Call horaxisdd(plxmin,plxmax,iigl,iigr,iigb,xadd,XSC,0,
     &    ddy1,ny,'Frequ.[Hz]')
        call dintervalf(YMIN,YMAX,DY,NDEC,0)
        call vrtaxisdd(YMIN,YMAX,iigl,iigb,iigt,Yadd,ysc,0,
     &    DY,NDEC,0,'RT  s')

C Print title. IPS is used to keep track of number of title lines.
        IPS=1
        write(title,'(20x,2a)')'Reverberation time for space: ',TxtZone
        iside=IPS; isize=0; ifont=0
        CALL viewtext(title,iside,isize,ifont)
      ENDIF

C Write the label concerning the calculation mode used
      IF (MAll.LT.4) THEN
        IPS=IPS+1
        write(title,'(1x,2a)') 'Method: ',CalName(MethodCalc)(1:11)
        iside=IPS; isize=0; ifont=0
        CALL viewtext(title,iside,isize,ifont)
      ENDIF
      IF ((MAll.EQ.4).AND.(MethodCalc.EQ.1)) THEN
        IPS=IPS+1
        write(title,'(1x,a)') 'Method: All'
        iside=IPS; isize=0; ifont=0
        CALL viewtext(title,iside,isize,ifont)
      ENDIF

C Define for each calculation method which symbol to use on the curve
      if (MethodCalc.EQ.1) THEN
        Isymbol = 1
      elseif (MethodCalc.EQ.2) THEN
        Isymbol = 11
      elseif (MethodCalc.EQ.3) THEN
        Isymbol = 6
      endif


C Plot reverberation time curve
      iupdown=0
      isym=0
      CALL etplot(125.,TReverb(1),iupdown,isym)
      do 30 I=1,MNbABS
          FREQ=INT(100* EXP((I-1)/3.*LOG(2.)))
          iupdown=1
          isym=Isymbol
          CALL etplot(FREQ,TReverb(I),iupdown,isym)
 30   continue

C Label curves
      IF ((MAll.EQ.4).AND.(MethodCalc.EQ.1)) THEN
        IPS=IPS+1
        write(title,'(40x,3(a,8x))')'Sabine (x)','Eyring (+)',
     &                              'Millington (.)'
        iside=IPS; isize=0; ifont=0
        CALL viewtext(title,iside,isize,ifont)
      ENDIF

      RETURN
      END


