C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation
C (version 2 or later).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C esru_misc.F contains the following subroutines.
C  CLRPRB : clears the zone based memory in preparation for reading
C           a new model file.
C  cfgpk:  Reacts to one of several configuration buttons and presents
C          related images.
C  EGOMST: Reads site obstruction data as ASCII strings, with or without
C          range checking and printed summary.
C  MKGOMST:Creates an annotated site obstruction file based
C          on passed parameters and the contents of common GS5.
C  ERMRT:  Read the viewfactor/ MRT sensor definition file.
C  EMKMRT: Write viewfactor/MRT sensor definition file based on
C          information in common blocks MRTC, MRTF.
C  SIFIMPORT: Imports ASCII shading and insolation into binary file.
C  SIFWRT - writes shading/insolation data to a zone shading &
C          insolation db for a given month.
C PICKSHSUR: selects surfaces for shading & insolation analysis.

C  PLEQN:  Finds the equation EQN to a plane containing a polygon
C          defined as a set of X() Y() Z() verticies tracing the edges.
C  ETRANSW: used when creating an insert rectangular shape into a surface.
C ETRANFRAME: used when creating an fixed width frame into a surface.
C  TRANSUR: Transforms a surface along its normal.

C  UV2AZ:  Recover azimuth & elevation from unit vector.
C  LN2AZ:  Recover azimuth & elevation vector from two coordinates in space.
C  AZ2UV:  Recover unit vector from azimuth & elevation.
C  CHECKWARP: transforms surface into 2D and checks if points are
C          are not in the plane of the surface.
C  ESCZONE Saves the current contents of common blocks G1 G2 G4 G5
C          into SG1 SG2 SG4 SG5.
C  ERCZONE Recovers the saved contents of common blocks G1 G2 G4 G5
C          from SG1 SG2 SG4 SG5.
C  EASKGEOF: Asks for zone number & geometry file name. If a configuration
C            file has been read present a list of zone names.
C  ASKZONE: presents  a list of zones to select one from depending on topic.
C  ASKMULTIZONE: presents a list of zones to select one or more from.
C  EASKSUR: Presents a list of surfaces in a zone IZONE.
C  EASKMSUR: Allows selection of multiple surfaces.
C  asksnode: Presents a list of layers/nodes within a surface.
C  FLNAME: Provides a name for a defined file type.
C  ZSID:   Returns a compact description in ZSDESC of the zone:surface.
C ZNARLIST: Takes an array (list) of zone indices and returns descr string.
C discovercfg: Provides a list of model cfg files within a passed folder
C              and allows user to select passing back full path & name.
C FDPWDTOCFG: Figures out the path between where an application was started
C             and the model cfg folder (pwdtocfg).
C dintervalf: A fortran implementation of the c surboutine dinterval.
C zones_with_occupants: Scan and report on zones with occupants.


C ************* CLRPRB
C Clears memory in preparation for reading in a new model file.

      SUBROUTINE CLRPRB

      USE AIM2_InputData, ONLY: iAIM2,LAIM2
      USE AIM2, ONLY: AIM2_ClearAll

      IMPLICIT NONE

#include "building.h"
#include "model.h"
#include "site.h"
#include "geometry.h"
#include "cfd.h"
#include "sbem.h"
#include "ipvdata.h"
#include "seasons.h"
#include "schedule.h"
#include "derived.h"
#include "plant.h"
#include "power.h"

      COMMON/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      INTEGER :: iairn,icaas

C << G7 and G8 need to be cleared >>

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

C iaplic(1) toggle for shading; iaplic(2) toggle for insolation.
C   toggle for assessment where:
C   1 is 'all_applicable', 0 is manual selection of surfaces.
C nsurfcalc nb of shaded surfaces, lstsfcalc() list of applicable surfaces.
C nsurfinso nb of insolation sources, isurfinso() list of insolation sources.
      common/ishdirec/iaplic(MCOM,2),nsurfcalc(MCOM),lstsfcalc(MCOM,MS),
     &     nsurfinso(MCOM),isurfinso(MCOM,MS)
      INTEGER :: iaplic,nsurfcalc,nsurfinso,lstsfcalc,isurfinso

C HOT3000:HVAC
C Flag indicating presence of HVAC models:
C ihvacflag=1 indicates HVAC models are active; 0 indicates no HVAC models.
      common/hvacinfo/ihvacflag,hvacfile
      INTEGER :: ihvacflag

C Simulation parameter presets.
      common/spfldes/spfdescr(MSPS)
      common/spflper/isstday(MSPS),isstmon(MSPS),isfnday(MSPS),
     &               isfnmon(MSPS)
      INTEGER :: isstday,isstmon,isfnday,isfnmon
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      common/spflres/sblres(MSPS),sflres(MSPS),splres(MSPS),
     &  smstres(MSPS),selres(MSPS),scfdres(MSPS),sipvres
      character sblres*72,sflres*72,splres*72,smstres*72,
     &  selres*72,scfdres*72,sipvres*72

C Extended simulation parameters for each set.
      common/spfldats/isstupex(MSPS),isbnstepex(MSPS),ispnstepex(MSPS),
     &  issaveex(MSPS),isavghex(MSPS),iscfdactivate(MSPS),
     &  isicfdys(MSPS),isicfdyf(MSPS),
     &  scftims(MSPS),scftimf(MSPS)
      INTEGER :: isstupex,isbnstepex,ispnstepex,issaveex,isavghex
      INTEGER :: iscfdactivate      ! zero ignore domains
      INTEGER :: isicfdys,isicfdyf  ! CFD simulation start & finish days
      REAL :: scftims,scftimf       ! CFD simulation start & finish time


C HOT3000: BASESIMP.
      common/bsmtdef/iBSIMP(MCOM),LBSIMP(MCOM)
      INTEGER :: ibsimp


      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      INTEGER :: ic1,ie1,ict,ic2,ie2
      COMMON/C23/IFPNF,LPNF
      INTEGER :: ifpnf
      common/cctl/icascf(mcom)
      INTEGER :: icascf
      COMMON/PREC8/SLAT,SLON
      REAL :: slat,slon

C CFD
      COMMON/cfdfil/LCFD(MCOM),IFCFD(MCOM)
      INTEGER :: ifcfd
      common/ndcfd/ncfdnd,icfdnd(MNZ),NCONF
      INTEGER :: ncfdnd,icfdnd,nconf
C Variables for weekdays, and weekends.
C Assume: Mon=1, Tue=2, Wed=3, Thu=4, Fri=5, Sat=6, Sun=7
      common/wkdtyp/idwe1,idwe2,wkd1,wkd2
      INTEGER :: idwe1,idwe2

C IPV description.
      character*72 lipvdatf
      common/IPVF/lipvdatf

C Non-linear thermophysical properties.
      COMMON/VTHP18/LNLTHP
      CHARACTER LNLTHP*72
      COMMON/VTHP31/INTHPS,INTHPZ(MCOM)
      LOGICAL INTHPS,INTHPZ
C 1D node distribution.
      COMMON/GR1D05/LGRD1D
      CHARACTER LGRD1D*72
      COMMON/GR1D06/IGR1D
      LOGICAL IGR1D
      COMMON/GRND108/LGDCVS,LGDCNC,LGDNDC,LGDTAQ,LGDNDD
      CHARACTER*72 LGDCVS,LGDCNC,LGDNDC,LGDTAQ,LGDNDD

C 3D ground.
      COMMON/GRND100/GRND3D
      LOGICAL GRND3D

C 3D zones.
      common/GR3D100/BLDG3D,ZONE3D(MCOM)
      LOGICAL BLDG3D,ZONE3D
      common/GR3D108/L3DCVS(MCOM),L3DCNC(MCOM),L3DNDC(MCOM),L3DTAQ(MCOM)

C Moisture.
      common/MOIST01/MSTROK,MSTRZN(MCOM)
      LOGICAL MSTROK,MSTRZN
      common/MOIST02/LMOIST(MCOM)

C Water filled zones.
      COMMON/zfluid/znotair(mcom),zfldK,zfldD,zfldC,zfldA,
     &              zSWAp(mcom),zSWAf(mcom)
      real zfldK,zfldD,zfldC,zfldA,zSWAp,zSWAf
      LOGICAL znotair

C Ground topology.
      COMMON/GTFIL/GTGEOM
      COMMON/GT/GTNAME

C Primary energy conversions and emissions.
      common/PCONV/ipconv,pcnvht,pcnvcl,pcnvlt,pcnvfn,pcnvsp,pcnvhw
      INTEGER :: ipconv
      REAL :: pcnvht,pcnvcl,pcnvlt,pcnvfn,pcnvsp,pcnvhw
      common/CONVEM/phtco2,phtnox,phtsox,pclco2,pclnox,pclsox,
     &              pltco2,pltnox,pltsox,pfnco2,pfnnox,pfnsox,
     &              pspco2,pspnox,pspsox,phwco2,phwnox,phwsox

      REAL :: phtco2,phtnox,phtsox,pclco2,pclnox,pclsox
      REAL :: pltco2,pltnox,pltsox,pfnco2,pfnnox,pfnsox
      REAL :: pspco2,pspnox,pspsox,phwco2,phwnox,phwsox


C CPCALC description
      common/CPCALC/icpcon,ble,bwi,bhi,blox,bloy,bloz,orient,irt,ra,
     &              sbh,pad,wvpe
      REAL :: ble,bwi,bhi,blox,bloy,bloz,orient,ra,sbh,pad,wvpe
      INTEGER :: icpcon,irt

C Images.
      common/imagf/imgfmt(MIMG),imgfoc(MIMG),limgfil(MIMG),imgdoc(MIMG)
      character imgfmt*4  ! GIF XBMP TIF JPG
      character imgfoc*4  ! FZON FNET FCTL FDFS FPLN etc.
      character limgfil*72  ! file name (extend to 144 char)
      character imgdoc*248  ! text associated with image

      common/imagfi/noimg,iton
      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes

C Configuration control.
      common/cctlnm/ctldoc,lctlf

C Special materials & electrical network files.
      common/spmfxst/ispmxist,spflnam
      INTEGER :: ispmxist
C Path to SHOCC input files
C bSHOCCed     - logical flag whether project has SHOCC input
C bZoneSHOCCed - logical array whether zones have SHOCC input
C SHOCCshlFile - path to SHOCC .shl file for SHOCC'd project library
C SHOCCshzFile - path to SHOCC .shz file for each SHOCC'd zone
      common/SHOCCcfg/bSHOCCed,SHOCCshlFile,bZoneSHOCCed(mcom),
     &                SHOCCshzFile(mcom)
      logical bSHOCCed,bZoneSHOCCed
      character SHOCCshlFile*72,SHOCCshzFile*72

C Thermal bridge common block:
C nbrdg is the number of thermal bridge types in the zone
C psi is the linear thermal transmittance value,
C lngth is the length of the thermal bridge and
C ibrdg is an index defining the type of thermal bridge as follows:
C   1 is "roof-wall", 2 is "wall-ground floor"
C   3 is "wall-wall (convex corner)", 4 is "wall-wall (concave corner)"
C   5 is "wall-floor (exposed)", 6 is "lintel above window or door"
C   7 is "Sill below window", 8 is "jamb at window or door"
C   9 is "roof-wall-gable", 10 is "wall-parapet"
C  11 is "wall-interm-floor", 12 is "wall-partition"
C  13 is "glass-frame", 14 is "balcony"
C  15 is "user-defined-a"
C  16 is "user-defined-b"
C The phrases for thermal bridges are defined in setbridgenames.

C losspercent is W/K for an alternative method  where the calculated heat flow
C   is augmented by a fixed percentage of the UA (fabric loss)
C totheatloss is W/K for all length*psi plus losspercent for the zone
C thbrpercent is the user defined fraction for thermal bridges used by
C   losspercent and is assumed to apply to all zones in the model.
      integer nbrdg, ibrdg
      real psi,lngth,losspercent,totheatloss,thbrpercent
      real uavtotal
      common/THRBRDG/nbrdg(MCOM),psi(MCOM,16),lngth(MCOM,16),
     &               ibrdg(MCOM,16),losspercent(MCOM),totheatloss(MCOM),
     &               thbrpercent,uavtotal(MCOM)
      real bridgelen       ! Length (m) of potential thermal bridges in each zone.
      integer nbridgevt    ! Number of verticies associted with this bridge.
      integer bridgevlst   ! List of vertices associated with bridge.
      common/gbridge/bridgelen(MCOM,16),nbridgevt(MCOM,16),
     &  bridgevlst(MCOM,16,MV*2)
      common/THBRSCH/tbregime
      character tbregime*36

C IPV data comes via ipvdata.h

C Assumption about inserted window surface percentage and assumed
C door width and height.
      real defwininsert,defdoorwidth,defdoorheight
      common/ginsert/defwininsert,defdoorwidth,defdoorheight

C Radiance processor cores.
      integer radcores
      common/radcor/radcores

C Version of construction file. If not specified set at 21 (2.1)
      integer izconstv,iztmcv
      common/znconstrv/izconstv(MCOM),iztmcv(MCOM)

C IES lighting distribution files from model.h

      CHARACTER LCFD*72
      CHARACTER*72 LAPROB,LPNF

      CHARACTER*72 L3DCVS,L3DCNC,L3DNDC,L3DTAQ,LMOIST
      character hvacfile*72,LBSIMP*72
      character ctldoc*248,lctlf*72
      character GTGEOM*72,GTNAME*15,spflnam*72
      character*10 wkd1, wkd2
      character spfdescr*30

      INTEGER :: i,icc,ibe,ibu,j,ixs,ix,iivu,isystcurrent,imu
      INTEGER :: ies,ik

C Clear any allocated arrays
      CALL DeallocateAllArrays

C Project level common blocks.

C Initial assumption is no SHOCC files.
      bSHOCCed=.false.
      SHOCCshlFile=' '

      lmodellog='job.notes'
      LPNF='UNKNOWN'
      LGDCVS='UNKNOWN'
      LGDCNC='UNKNOWN'
      LGDNDC='UNKNOWN'
      LGDTAQ='UNKNOWN'
      LGRD1D='UNKNOWN'
      LNLTHP='UNKNOWN'
      zonepth='../zones'; netpth='../nets'; ctlpth='../ctl'
      mscpth='../msc'; imgpth='../img'; radpth='../rad'
      dbspth='../dbs'; tmppth='../tmp'
      lradcf='UNKNOWN'
      cfgroot=' '
      LCTLF='UNKNOWN'
      if(icfgv.gt.4)then  ! If earlier preference set reset LCNN.
        if(usecurcfg.eq.2)then
          LCNN='UNKNOWN'
        elseif(usecurcfg.eq.1)then
          LCNN='internal'
        elseif(usecurcfg.eq.-1)then
          LCNN='UNKNOWN'
        endif
      else
        LCNN='UNKNOWN'
      endif
      CTLDOC='no overall project control notes (yet)'
      GTGEOM='UNKNOWN'
      GTNAME='flat'
      lipvdatf='UNKNOWN'
      bdmds='UNKNOWN'
      dmdsdesc='no dispersed demands notes (yet)'

C << Consider clearing the calendar plus dependencies in
C << control and operations which rely on daytypes.
      idwe1=6
      idwe2=7
      wkd1='Saturday'
      wkd2='Sunday'
      spflnam='UNKNOWN'
      ispmxist=0
      entflnam='UNKNOWN'
      ientxist=0
      igupgrade=0   ! no opinion about upgrading model files

C Initialize HVAC flag to indicate no HVAC models active. This
C will be reset if `*hvac' included in .cfg.
      ihvacflag=0
      hvacfile='UNKNOWN'

C HOT3000: AIM-2.
      iAIM2=0
      LAIM2='UNKNOWN'
      CALL AIM2_ClearAll

C Clear pre-simulation sets.
      nsset= 0; isstup= 0; isbnstep= 0; ispnstep= 0
      isavgh=0
      issave= -1
      sipvres=' '
      do i=1,MSPS
        isstupex(i)=isstup  ! same as global to start with
        isbnstepex(i)=isbnstep
        ispnstepex(i)=ispnstep
        issaveex(i)=issave
        isavghex(i)=isavgh
        spfdescr(i)=' '
        sblres(i)=' '
        sflres(i)=' '
        splres(i)=' '
        smstres(i)=' '
        selres(i)=' '
        scfdres(i)=' '
        isstday(i)=0
        isstmon(i)=0
        isfnday(i)=0
        isfnmon(i)=0
        seahddwk(i)=0.0
        seacddwk(i)=0.0
        seahddtot(i)=0.0
        seacddtot(i)=0.0
        wkdiff(i)=0.0
        iwkbest(i)=0
        iwkbstrt(i)=0
        wkheatdd(i)=0.0
        wkcooldd(i)=0.0
      enddo  ! of I

C Clear IPV strings and number of assessmments.
      ipvtitl=' '; ipvsynop=' '; ipvsimu=' '
      nipvassmt=0; nipvdispjd=0
      ipvastjd(1)=0; ipvafnjd(1)=0; ipvdispjd(1)=0
      ipvastjd(2)=0; ipvafnjd(2)=0; ipvdispjd(2)=0
      ipvastjd(3)=0; ipvafnjd(3)=0; ipvdispjd(3)=0
      ipvastjd(4)=0; ipvafnjd(4)=0; ipvdispjd(4)=0
      ipvastjd(5)=0; ipvafnjd(5)=0; ipvdispjd(5)=0
      imetget(1)=0;  msdoc(1)=' ';  metrglbl(1)='- '; metgroup(1)='- '
      imetget(2)=0;  msdoc(2)=' ';  metrglbl(2)='- '; metgroup(2)='- '
      nzedg(1)=0; edgflr(1)=0.0; edgsca(1)=1.0
      nzedg(2)=0; edgflr(2)=0.0; edgsca(2)=1.0
      iaggr=1; ifbhits=1   ! Include timestep reporting and hits for frq.  
      neds=0; nms=0
      ipvform=2            ! Assume tab separated IPV report.

C Clear anchors.
      NALOC=0
      do i=1,20
        ALOCLBL(i)='undefined'
        ALOCTYP(i)='unkn'
        IALOC(i)=0
        do j=1,99
          lstanchr(i,j)=0
        enddo   ! of j
      enddo     ! of i

C Clear zone groups.
      nzgroup=0
      do i=1,32
        zglbl(i)='undefined'
        izgnumber(i)=0
        do j=1,40
          izglist(i,j)=0
        enddo   ! of j
      enddo     ! of i

C Set initial primary conversions and emissions.
      ipconv=0
      pcnvht=1.0; pcnvcl=1.0; pcnvlt=1.0; pcnvfn=1.0; pcnvhw=1.0
      phtco2=0.0; phtnox=0.0; phtsox=0.0; pclco2=0.0; pclnox=0.0
      pclsox=0.0; pltco2=0.0; pltnox=0.0; pltsox=0.0; pfnco2=0.0
      pfnnox=0.0; pfnsox=0.0; pspco2=0.0; pspnox=0.0; pspsox=0.0
      phwco2=0.0; phwnox=0.0; phwsox=0.0

C Initial data for CPCALC.
      icpcon=0
      ble=0.00; bwi=0.00; bhi=0.00
      blox=0.00; bloy=0.00; bloz=0.00
      orient=0.00
      irt=0
      ra=0.00; sbh=0.00; pad=0.00; wvpe=0.00

C Clear derived model areas and U-values.
      xfloor = 0.0; xexposed = 0.0; xvexposed = 0.0
      xvthk = 0.0; xtoground = 0.0; xuavgtran = 0.0
      xuavwall = 0.0; xuavground = 0.0
      xfndthkg = 0.0; xperimlength = 0.0
      xuavslproof = 0.0; xuavfltroof = 0.0; xuavgsky = 0.0
      xareatran = 0.0; xareawall = 0.0
      xareaslproof = 0.0; xareafltroof = 0.0; xareaskylt = 0.0

C Initialize the indices.
      INTHPS=.FALSE.; IGR1D=.FALSE.; GRND3D=.FALSE.
      BLDG3D=.FALSE.; MSTROK=.FALSE.

C Assume there is not BSim-CFD conflation in any of the zones.
      NCONF=0
      do i=1,MNZ
        icfdnd(i)=0
      enddo  ! of i

C Clear image related data.
      noimg=0
      iton=0
      do IX=1,MIMG
        imgfmt(IX)=' '
        imgfoc(IX)=' '
        limgfil(IX)=' '
        imgdoc(IX)='-'
      enddo  ! of IX

      IAIRN=0
      LAPROB='UNKNOWN'

      sitelat=50.0
      SLAT=50.
      sitelongdif=0.0
      SLON=0.
      radcores = 1  ! assume only 1 core for use by Radiance

C Assumptions about doors and windows.
      defwininsert=15.0
      defdoorwidth=0.8
      defdoorheight=2.1

C Water properties for water filled zones (std values).
      zfldK=0.6; zfldD=998.2; zfldC=4190.0; zfldA=0.0

C Season data.
      ihaveseason=0
      ia1wins=0; ia1winf=0; ia1sprs=0; ia1sprf=0
      iasums=0;  iasumf=0;  ia2sprs=0; ia2sprf=0; ia2wins=0; ia2winf=0
      is1wins=0; is1winf=0; is2wins=0; is2winf=0; is1sprs=0; is1sprf=0
      is2sprs=0; is2sprf=0; is1sums=0; is1sumf=0
      hddw=1.0; cddw=1.0; radw=1.0; hddbaset=0.0; cddbaset=0.0

C Zone level common blocks.
      do 42 IX = 1,MCOM

C Per-zone areas and U-values.
        uavgtran(IX) = 0.0; uavwall(IX) = 0.0; uavslproof(IX) = 0.0
        uavfltroof(IX) = 0.0; uavgsky(IX) = 0.0; uavground(IX) = 0.0
        areatran(IX) = 0.0; areawall(IX) = 0.0; areaslproof(IX) = 0.0
        areafltroof(IX)= 0.0; areaskylt(IX)= 0.0; areaground(IX)= 0.0
        exposed(IX) = 0.0; vexposed(IX) = 0.0
        izsfloor(IX) = 0; izsceil(IX) = 0
        znotair(ix)=.FALSE.  ! assumption of air filled
        zSWAp(ix)=0.0; zSWAf(ix)=0.0
        ncub(ix)=0  ! clear number of mrt sensors in each zone
        izconstv(ix)=0  ! assume legacy zone constructions
        iztmcv(ix)=0    ! assume legacy zone TMC files
        do IXS = 1,MS
          SNAME(IX,IXS)=' '   ! clear surface name
          zboundarytype(IX,IXS,1)=0  ! clear surface boundary
          zboundarytype(IX,IXS,2)=0
          zboundarytype(IX,IXS,3)=0
          isznver(ix,ixs)=0
          do iivu=1,MV
            iszjvn(ix,ixs,iivu)=0
            szcoords(ix,ixs,1)=0.0
            szcoords(ix,ixs,2)=0.0
            szcoords(ix,ixs,3)=0.0
          enddo  ! of iivu
        enddo    ! if IXS

C Clear obstructions in all zones.
C << clear all mrt sensors in all zones. >>
        do ibu=1,MB
          XOB(ix,ibu) = 0.0
          YOB(ix,ibu) = 0.0
          ZOB(ix,ibu) = 0.0
          DXOB(ix,ibu) = 0.0
          DYOB(ix,ibu) = 0.0
          DZOB(ix,ibu) = 0.0
          BANGOB(ix,ibu,1) = 0.0
          BANGOB(ix,ibu,2) = 0.0
          BANGOB(ix,ibu,3) = 0.0
          OPOB(ix,ibu)=0.0
          BLOCKNAME(ix,ibu) = ' '
          BLOCKMAT(ix,ibu) = ' '
          BLOCKTYP(ix,ibu) = 'obs '
          do ibe=1,8
            XBP(ix,ibu,ibe)=0.0
            YBP(ix,ibu,ibe)=0.0
            ZBP(ix,ibu,ibe)=0.0
          enddo  ! of ibe
        enddo    ! of ibu

C Clear visual entities in all zones.
        nbvis(ix) = 0
        do ibu=1,MB
          XOV(ix,ibu) = 0.0
          YOV(ix,ibu) = 0.0
          ZOV(ix,ibu) = 0.0
          DXOV(ix,ibu) = 0.0
          DYOV(ix,ibu) = 0.0
          DZOV(ix,ibu) = 0.0
          BANGOV(ix,ibu,1) = 0.0
          BANGOV(ix,ibu,2) = 0.0
          BANGOV(ix,ibu,3) = 0.0
          OPOV(ix,ibu)=0.0
          VISNAME(ix,ibu) = ' '
          VISMAT(ix,ibu) = ' '
          VISTYP(ix,ibu) = 'vis '
          do ibe=1,8
            XVP(ix,ibu,ibe)=0.0
            YVP(ix,ibu,ibe)=0.0
            ZVP(ix,ibu,ibe)=0.0
          enddo  ! of ibe
        enddo    ! of ibu

C Clear visual objects in all zones.
        NBVOBJ(ix)=0
        do ibu=1,12
          VOBJNAME(ix,ibu) = ' '
          VOBJDESC(ix,ibu) = ' '
          NBVOBJLIST(ix,ibu) = 0
          do ibe=1,12
            VOBJLIST(ix,ibu,ibe) = ' '
          enddo  ! of ibe
        enddo    ! of ibu

C Clear SHOCC zone information as well.
        bZoneSHOCCed(IX)=.false.
        SHOCCshzFile(IX)=' '

        NZSUR(IX)=0
        NZTV(IX)=0
        NBWALLS(IX)=0
        NCCODE(IX)=0
        NDP(IX)=3
        IDPN(IX,1)=0; IDPN(IX,2)=0; IDPN(IX,3)=0
        CTYPE(IX)=' '
        shape(IX)=' '
        gversion(ix)=1.0
        zorigin(ix,1)=0.0; zorigin(ix,2)=0.0; zorigin(ix,3)=0.0
        zsize(ix,1)=0.0; zsize(ix,2)=0.0; zsize(ix,3)=0.0
        znbmass(ix) = 0
        do imu=1,4
          zdatamass(ix,imu,1)=0.0
          zdatamass(ix,imu,2)=0.0
          zdatamass(ix,imu,3)=0.0
          zdatamass(ix,imu,4)=0.0
          zdatamass(ix,imu,5)=0.0
          zdatamass(ix,imu,6)=0.0
          zdatamass(ix,imu,7)=0.0
          ztextmass(ix,imu,1)=' '
          ztextmass(ix,imu,2)=' '
          ztextmass(ix,imu,3)=' '
        enddo  ! if imu
        zdesc(IX)=' '
        zname(IX)=' '
        lnzname(IX)=0

C << consider clearing the P3N commons >>
        LPROJ(IX)='UNKNOWN'
        LGEOM(IX)='UNKNOWN'
        LTHRM(IX)='UNKNOWN'
        IVF(IX)=0
        LVIEW(IX)='UNKNOWN'
        ISI(IX)=0
        LSHAD(IX)='UNKNOWN'
        IHC(IX)=0
        LHCCO(IX)='UNKNOWN'

C HOT3000: BASESIMP.
        iBSIMP(I) = 0
        LBSIMP(I)='UNKNOWN'
        ITW(IX)=0
        LTWIN(IX)='UNKNOWN'
        ICGC(IX)=0
        LCGCIN(IX)='UNKNOWN'
        IOBS(IX)=0
        ZOBS(IX)  ='UNKNOWN'
        L3DCVS(IX)='UNKNOWN'
        L3DCNC(IX)='UNKNOWN'
        L3DNDC(IX)='UNKNOWN'
        L3DTAQ(IX)='UNKNOWN'
        IFCFD(IX)=0
        LCFD(IX)  ='UNKNOWN'
        icascf(IX)=0
        ICAAS(IX)=0
        INTHPZ(IX)=.FALSE.
        ZONE3D(IX)=.FALSE.
        MSTRZN(IX)=.FALSE.
        LMOIST(IX)='UNKNOWN'

        iaplic(IX,1)=0   ! reset shanding and insolation directives
        iaplic(IX,2)=0
        nsurfcalc(IX)=0
        nsurfinso(IX)=0
   42 continue

C Clear the connection list.
      DO ICC=1,MCON
        IC1(ICC)=0
        IE1(ICC)=0
        ICT(ICC)=-1   ! Set to -1 to signal connection type is not yet defined.
        IC2(ICC)=0
        IE2(ICC)=0
      ENDDO  ! of ICC
      icfgv=5  ! set cfg file version to latest type
      NCON=0
      ncomp=0
      siteexposureindex=1
      groundrefl=0.2
      groundreflmodel=1
      snowgroundrefl=0.4
      DO I=1,12
        groundreflmonth(I)=groundrefl
        dayswithsnow(I)=0
      ENDDO  ! of I
      SNFNAM=' '

C Clear the linear thermal bridges variables.
      tbregime='  '
      DO I=1,16
        DO IX=1,MCOM
          psi(IX,I) = 0.0
          lngth(IX,I) = 0.0
          bridgelen(IX,I)= 0.0
          nbridgevt(IX,I)= 0
          do ik=1,MV*2
            bridgevlst(IX,i,ik)=0
          enddo
          losspercent(IX) = 0.0
          thbrpercent = 0.0
          totheatloss(ix) = 0.0
          uavtotal(ix) = 0.0
        ENDDO  ! of IX
      ENDDO    ! of I

C Clear sbem string arrays (from sbem.h).
      UPRN='000000000000'
      Accr_Scheme=' not yet defined'
      assessRegNumber='ABCD123456'
      empl_Trading_name=' not yet defined'
      addr_empl_Trading=' not yet defined'
      party_disclosure=' not yet defined'
      qualifications_assessor=' NOS3'
      insurer_Company=' not yet defined'
      policyNumberInsurance=' not yet defined'
      pjLevComplexity='Undefined'
      do isystCurrent=1,MNS
        ductwork(isystCurrent)='No, use default leakage'
        AHUleakage(isystCurrent)='No, use default leakage'
        duct_tDLd(isystCurrent)=0.15
        AHU_tDLd(isystCurrent)=0.06
      enddo  ! of isystCurrent

C Also integers from sbem.h
      Y_inspect=2010; M_inspect=1; D_inspect=1
      S_Yinsur=2010; S_Minsur=1; S_Dinsur=1
      E_Yinsur=2011; E_Minsur=1; E_Dinsur=1
      pi_limit=0
      INOTI=0  ! assume we have an original model

C Clear IES data files (see model.h for details).
      nbofies=0
      do ies=1,10
        iesname(ies)='  '
        iesmenu(ies)='  '
        iesfile(ies)='  '
        iesalong='X'
        ieslen(ies)=0.0
        ieswid(ies)=0.0
        iesht(ies)=0.0
        iespercents(ies)=1
        iessteps(ies,1)=100; iessteps(ies,2)=1;
        iessteps(ies,3)=1; iessteps(ies,4)=1; iessteps(ies,5)=1
      enddo  ! of ies
      return
      end

C Find toggles for active description buttons and check to
C see if there are  associated images.
      subroutine cfgtogg(icfg_type,icfgz,icfgs,icfgnet,icfgc,
     &  icfgpln,icfgeln,icfgfab,icfgbeh,icfgsim,
     &  iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln,
     &  iicfgeln,iicfgfab,iicfgbeh,iicfgsim)
#include "building.h"
#include "geometry.h"
#include "plant.h"
#include "power.h"
#include "net_flow.h"
#include "net_flow_data.h"

C Passed parameters because these are also used by c function opencfg
#ifdef OSI
      integer icfg_type  ! model cfg type
      integer icfgz      ! if non-zero then there are zones
      integer icfgs      ! if non-zero then there are site ground obstr
      integer icfgnet    ! if non-zero then there Fluid flow
      integer icfgc      ! if non-zero then ctl file known
      integer icfgpln    ! if non-zero then plant network exists
      integer icfgeln    ! if non-zero then electrical network exists
      integer icfgfab    ! if non-zero then Enhanced Fabric
      integer icfgbeh    ! if non-zero then Behaviour
      integer icfgsim    ! if non-zero then automation
      integer iicfgz     ! there are zone related images
      integer iicfgs     ! if non-zero then there are site images
      integer iicfgnet   ! there are fluid flow related images
      integer iicfgc     ! there are control related images
      integer iicfgpln   ! if non-zero then plant network images
      integer iicfgeln   ! if non-zero then electrical network images
      integer iicfgfab   ! if non-zero then Enhanced fabric images
      integer iicfgbeh   ! if non-zero then Behaviour images
      integer iicfgsim   ! if non-zero then automation images
#else
      integer*8 icfg_type,icfgz,icfgs,icfgnet,icfgc,icfgpln
      integer*8 icfgeln,icfgfab,icfgbeh,icfgsim
      integer*8 iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln
      integer*8 iicfgeln,iicfgfab,iicfgbeh,iicfgsim
#endif

C icfgnet = 0 none, = 1 flow network only, = 2 CFD only, = 3 network and CFD.
C icfgfab =0 none, = 1 3D conduction, =2 moisture, =3 special materials, = 4 all.
      integer ncomp,ncon
      common/C1/NCOMP,NCON
      common/C6/INDCFG
      COMMON/cfdfil/LCFD(MCOM),IFCFD(MCOM)
      common/AFN/IAIRN,LAPROB,ICAAS(MCOM)
      common/cctlnm/ctldoc,lctlf
      common/GR3D100/BLDG3D,ZONE3D(MCOM)
      LOGICAL BLDG3D,ZONE3D
      COMMON/GTFIL/GTGEOM
      character GTGEOM*72
      common/spfldat/nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      INTEGER :: nsset,isset,isstup,isbnstep,ispnstep,issave,isavgh
      common/IPVF/lipvdatf
      CHARACTER lipvdatf*72
      common/dynamico/isdynamicocup(MCOM)
      common/spmfxst/ispmxist,spflnam
      INTEGER :: ispmxist
      character spflnam*72
      character imgfmt*4  ! GIF XBMP TIF JPG
      character imgfoc*4  ! FZON FNET FCTL FDFS FPLN etc.
      character limgfil*72  ! file name (extend to 144 char)
      character imgdoc*248  ! text associated with image
      common/imagf/imgfmt(MIMG),imgfoc(MIMG),limgfil(MIMG),imgdoc(MIMG)
      common/C23/IFPNF,LPNF
      character*72 LPNF
      common/MOIST01/MSTROK,MSTRZN(MCOM)
      LOGICAL MSTROK,MSTRZN
      integer noimg  ! number of images
      integer iton   ! zero if images not yet shown, one if yes
      common/imagfi/noimg,iton

      CHARACTER ctldoc*248,lctlf*72,LCFD*72
      character LAPROB*72

      icfg_type = INDCFG
      icfgz = 0
      if(INDCFG.eq.1.or.INDCFG.eq.3)icfgz = 1
      icfgnet = 0
      if(IAIRN.ge.1)icfgnet = 1
      if(LCTLF(1:7).eq.'UNKNOWN')then
        icfgc = 0
      else
        icfgc = 1
      endif
      if(LPNF(1:7).eq.'UNKNOWN')then
        icfgpln = 0
C [ if the flow network included water then set HVAC true.
      else
        icfgpln = 1
      endif
      if(ientxist.eq.0)then
        icfgeln = 0
      else
        icfgeln = 1
      endif
      icfgfab = 0
      if(BLDG3D)then
        if(icfgfab.eq.0)then
          icfgfab = 1
        elseif(icfgfab.eq.2)then
          icfgfab = 4
        endif
      endif
      if(ispmxist.ne.0)then
        if(icfgfab.eq.0)icfgfab = 3
        if(icfgfab.eq.1)icfgfab = 4
        if(icfgfab.eq.2)icfgfab = 4
      endif
      icfgsim = 0
      if(nsset.gt.1) icfgsim = 1
      if(lipvdatf(1:7).eq.'UNKNOWN')then
        continue
      else
        icfgsim = 1
      endif
      if(GTGEOM(1:7).eq.'UNKNOWN')then
        icfgs = 0
      else
        icfgs = 1
      endif

C If there is a flow network and there is water in any connection then
C assume that plant is true.
      if(IAIRN.ge.1.and.ncnn.gt.0)then
        do ICNN=1,NCNN   ! Connections loop.
          ICMP=ITPCON(ICNN)
          if(icmp.gt.0)then
            if(INT(SUPCMP(ICMP,1)).eq.2)then
              icfgpln = 1
            endif
          endif
        enddo
      endif
   
C Loop through all zones for other features.
      icfgbeh = 0
      if(NCOMP.gt.0)then
        do 42 i=1,NCOMP
          if(LCFD(i)(1:2).eq.'  '.or.LCFD(i)(1:4).eq.'UNKN')then
            continue
          else
            if(icfgnet.eq.0)then
              icfgnet = 2   ! If no flow network signal CFD only.
            elseif(icfgnet.eq.1)then
              icfgnet = 3   ! Signal both network and CFD.
            elseif(icfgnet.eq.2)then
              icfgnet = 2   ! Keep CFD only.
            elseif(icfgnet.eq.3)then
              icfgnet = 3   ! Keep both network and CFD.
            endif
          endif
          if(MSTRZN(i))then
             if(icfgfab.eq.0) icfgfab = 2
             if(icfgfab.eq.1) icfgfab = 4
             if(icfgfab.eq.3) icfgfab = 4
          endif
          if(isdynamicocup(i).gt.0) icfgbeh = 1
          if(nbobs(i).gt.0) icfgs = 1
  42    continue
      endif
      if(noimg.eq.0)then
        iicfgz=0; iicfgs=0; iicfgnet=0; iicfgc=0;
        iicfgeln=0; iicfgfab=0; iicfgbeh=0
        iicfgsim=0
      else
        if(icfgz.ne.0)then
          iicfgz=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FZON')iicfgz=iicfgz+1
          enddo
        endif
        if(icfgs.ne.0)then
          iicfgs=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FSIT')iicfgs=iicfgs+1
          enddo
        endif
        if(icfgnet.ne.0)then
          iicfgnet=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FNET')iicfgnet=iicfgnet+1
          enddo
        endif
        if(icfgeln.ne.0)then
          iicfgeln=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FELN')iicfgeln=iicfgeln+1
          enddo
        endif
        if(icfgpln.ne.0)then
          iicfgpln=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FPLN')iicfgpln=iicfgpln+1
          enddo
        endif
        if(icfgc.ne.0)then
          iicfgc=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FCTL')iicfgc=iicfgc+1
          enddo
        endif
        if(icfgnet.ne.0)then
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FDFS')iicfgnet=iicfgnet+1
          enddo
        endif
        iicfgfab=0
        if(icfgfab.ne.0)then
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'F3DC')iicfgfab=iicfgfab+1
            if(imgfoc(img)(1:4).eq.'FSPM')iicfgfab=iicfgfab+1
            if(imgfoc(img)(1:4).eq.'FMOI')iicfgfab=iicfgfab+1
          enddo
        endif
        if(icfgsim.ne.0)then
          iicfgsim=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FSIM')iicfgsim=iicfgsim+1
          enddo
        endif
        if(icfgbeh.ne.0)then
          iicfgbeh=0
          do img=1,noimg
            if(imgfoc(img)(1:4).eq.'FHRO')iicfgbeh=iicfgbeh+1
          enddo
        endif
      endif

      return
      end

C ***** Notice that an active model feature button has been pressed.
      subroutine cfgpk(act)
#include "building.h"
#include "net_flow.h"
#include "control.h"
#include "help.h"

C The 'act' character for each of the topics:
C s=site, n=fluid flow, c=control, p=plant e=elec net
C m=moisture, o=occupants, a=automation
C z= zones t= enhanced fabric

      character act*1

C Passed parameters because these are also used by c function opencfg
#ifdef OSI
      integer icfg_type  ! model cfg type
      integer icfgz      ! if non-zero then there are zones
      integer icfgs      ! if non-zero then there is Context
      integer icfgnet    ! if non-zero then there is Fluid flow
      integer icfgc      ! if non-zero then ctl file known
      integer icfgpln    ! if non-zero then HVAC exists
      integer icfgeln    ! if non-zero then Electrical exists
      integer icfgfab    ! if non-zero then Enhanced fabric
      integer icfgbeh    ! if non-zero then Behaviour
      integer icfgsim    ! if non-zero then automation
      integer iicfgz     ! there are zone related images
      integer iicfgs     ! if non-zero then there are site images
      integer iicfgnet   ! there are network related images
      integer iicfgc     ! there are control related images
      integer iicfgpln   ! if non-zero then plant network images
      integer iicfgeln   ! if non-zero then electrical network images
      integer iicfgfab   ! if non-zero then Enhanced fabric images
      integer iicfgbeh   ! if non-zero then Behaviour images
      integer iicfgsim   ! if non-zero then automation images
#else
      integer*8 icfg_type,icfgz,icfgs,icfgnet,icfgc,icfgpln
      integer*8 icfgeln,icfgfab,icfgbeh,icfgsim
      integer*8 iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln
      integer*8 iicfgeln,iicfgfab,iicfgbeh,iicfgsim
#endif

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='cfg_button_press'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Get the current model facilities.
       call cfgtogg(icfg_type,icfgz,icfgs,icfgnet,icfgc,
     &   icfgpln,icfgeln,icfgfab,icfgbeh,icfgsim,
     &   iicfgz,iicfgs,iicfgnet,iicfgc,iicfgpln,
     &   iicfgeln,iicfgfab,iicfgbeh,iicfgsim)

C Registration, show all available images.
      if(act.eq.'r')then
        call imgdisp(0,'****',ier)
        helptopic='cfg_register'
        call gethelptext(helpinsub,helptopic,nbhelp)
        CALL PHELPD('registration button popup',nbhelp,'-',0,0,IER)

C Context button.
      elseif(act.eq.'s')then
        if(icfgs.gt.0)then
          call imgdisp(1,'FSIT',ier)
          helptopic='cfg_context'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('site button popup',nbhelp,'-',0,0,IER)
        endif

C Zone button related images.
      elseif(act.eq.'z')then
        if(icfgz.gt.0) call imgdisp(1,'FZON',ier)

C Show fluid flow related images.
      elseif(act.eq.'n')then
        if(icfgnet.eq.0)then
          continue
        elseif(icfgnet.eq.1)then
          call imgdisp(1,'FNET',ier)
          helptopic='cfg_context_flow'
          call gethelptext(helpinsub,helptopic,nbhelp)
        elseif(icfgnet.eq.2)then
          call imgdisp(1,'FDFS',ier)
          call imgdisp(1,'FNET',ier)
          helptopic='cfg_context_cfd'
          call gethelptext(helpinsub,helptopic,nbhelp)
        elseif(icfgnet.eq.3)then
          call imgdisp(1,'FDFS',ier)
          call imgdisp(1,'FNET',ier)
          helptopic='cfg_context_flow_cfd'
          call gethelptext(helpinsub,helptopic,nbhelp)
        endif
        if(icfgnet.ne.0)then
          CALL PHELPD('Fluid flow button popup',nbhelp,'-',0,0,IER)
        endif

C Electrical button.
      elseif(act.eq.'e')then
        if(icfgeln.gt.0)then
          call imgdisp(1,'FELN',ier)
          helptopic='cfg_context_power'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('electrical button popup',nbhelp,'-',0,0,IER)
        endif

C Show control-related images.
      elseif(act.eq.'c')then
        if(icfgc.gt.0)then 
          call imgdisp(1,'FCTL',ier)
          helptopic='cfg_context_control'
          call gethelptext(helpinsub,helptopic,nbhelp)
          CALL PHELPD('electrical button popup',nbhelp,'-',0,0,IER)
          if(ncf.gt.0)then
            call edisp(iuout,' Zones - control included.')
          else
            call edisp(iuout,' Zones - no control included.')
          endif
          if(ncl.gt.0)then
            call edisp(iuout,' Plant - control included.')
          else
            call edisp(iuout,' Plant - no control included.')
          endif
          if(ncc.gt.0)then
            call edisp(iuout,' Flow - control included.')
          else
            call edisp(iuout,' Flow - no control included.')
          endif
          if(ngf.gt.0)then
            call edisp(iuout,' Global - control included.')
          else
            call edisp(iuout,' Global - no control included.')
          endif
          CALL PHELPD('control button popup',nbhelp,'-',0,0,IER)
        endif

C Enhanced fabric button, show image.
      elseif(act.eq.'t')then
        if(icfgfab.eq.0)then
          continue
        elseif(icfgfab.eq.1)then
          call imgdisp(1,'F3DC',ier)
          h(1)='The model includes zones with 2D or 3D conduction'
          h(2)='gridding. These facilities are managed by the grd'
          h(3)='ESP-r module.'
          h(4)='The model does not include materials with moisture'
          h(5)='properties.'
          h(6)='The model does not include adaptive materials such as'
          h(7)='PV modules and electrochromic glazing.'
          nbhelp=7
        elseif(icfgfab.eq.2)then
          call imgdisp(1,'FMOI',ier)
          h(1)='The model does not include 2D or 3D conduction.'
          h(2)='The model includes materials and surfaces with moisture'
          h(3)='attributes and has the potential to assess moisture'
          h(4)='transport.'
          h(5)='The model does not include adaptive materials such as'
          h(6)='PV modules and electrochromic glazing.'
          nbhelp=6
        elseif(icfgfab.eq.3)then
          call imgdisp(1,'FSPM',ier)
          h(1)='The model does not include 2D or 3D conduction.'
          h(2)='The model does includes adaptive materials such as'
          h(3)='PV modules and electrochromic glazing.'
          h(4)='The model does not include materials with moisture'
          h(5)='properties.'
          nbhelp=5
        elseif(icfgfab.eq.4)then
          call imgdisp(1,'F3DC',ier)
          call imgdisp(1,'FSPM',ier)
          call imgdisp(1,'FMOI',ier)
          h(1)='The model includes zones with 2D or 3D conduction'
          h(2)='gridding. '
          h(3)='The model also includes materials and surfaces with'
          h(4)='mosture attributes and has the potential to assess'
          h(5)='moisture transport.'
          h(6)='The model also includes adaptive materials such as'
          h(7)='PV modules and electrochromic glazing.'
          nbhelp=7
        endif
        if(icfgfab.ne.0)then
          CALL PHELPD('3D conduction button popup',nbhelp,'-',0,0,IER)
        endif

C HVAC button.
      elseif(act.eq.'p')then
        if(icfgpln.gt.0)then
          call imgdisp(1,'FPLN',ier)
          h(1)='The model includes HVAC via a component network.'
          nbhelp=1
          CALL PHELPD('HVAC button popup',nbhelp,'-',0,0,IER)
        endif

C Automation button.
      elseif(act.eq.'a')then
        if(icfgsim.gt.0)then
          call imgdisp(1,'FSIM',ier)
          h(1)='The model includes scripts or simulation parameter '
          h(2)='set definitions to automate assessments.'
          nbhelp=2
          CALL PHELPD('Automation button popup',nbhelp,'-',0,0,IER)
        endif
      endif
      return
      end

C ******************** EGOMST ********************
C Reads site obstruction data as ASCII strings, with or without
C range checking and printed summary. An obstruction block name (up to
C 12 characters) may be included as an option and is returned via BLOCKNAME.

C Note: obstruction attributes are held in global commons which are scanned
C as the model is loaded and held in memory. Re-scanning of obstructions is
C thus rarely required.
      SUBROUTINE EGOMST(IUNIT,ICOMP,LOBS,IR,ITRC,ITRU,IER)
#include "building.h"
#include "geometry.h"
#include "espriou.h"

      integer lnblnk  ! function definition
      CHARACTER LOBS*72,OUTSTR*124,WORD*32
      character outs*124
      integer NGXD,NGZD  ! dummy values for depreciated NGX & NGZ
      real VX,VY,VZ   ! local values for XOB YOB ZOB
      integer llbm    ! length of block material

      IER=0

      CALL EFOPSEQ(IUNIT,LOBS,1,IER)
      IF(IER.LT.0)THEN
        write(outs,'(3a)') 'Obstructions file ',LOBS(1:lnblnk(LOBS)),
     &    ' could not be opened.'
        call edisp(itru,outs)
        IER=1
        RETURN
      endif
      write(currentfile,'(a)') LOBS(1:lnblnk(LOBS))

C Read past site information from the file and check for range errors.
C Read lines from file, discarding comments, check the number of items
C in the data.
      CALL STRIPC(IUNIT,OUTSTR,2,ND,1,'line 1',IER)
      IF(IER.NE.0)goto 99

C Read number of obstruction blocks and check for range errors.
      CALL STRIPC(IUNIT,OUTSTR,1,ND,1,'number of blocks',IER)
      K=0
      CALL EGETWI(OUTSTR,K,nbo,1,MB,'F','number of obstr',IER)
      IF(IER.NE.0)GOTO 99
      nbobs(icomp)=nbo  ! remember how many for this zone

C Read each obstruction block, if 7 items found then unattributed, if
C 8 items assume the last is a name for the obstruction block, if 9 items
C then the last is the construction attribute. If no  name & or construction
C then assign the block index as the name via internal read.

C Note: legacy zone obstruction files only contain the single type
C of obstruction with one angle of rotation. Remember the number
C of tokens in variable ND.
      DO 10 I=1,nbobs(icomp)
        CALL STRIPC(IUNIT,OUTSTR,99,ND,1,'obstruction block',IER)
        IF(IER.NE.0)GOTO 99
        IF(ND.eq.7.OR.ND.eq.8.OR.ND.eq.9.OR.ND.eq.10)THEN
          K=0
          CALL EGETWR(OUTSTR,K,VX,-999.,998.,'W','obs X org',IER)
          CALL EGETWR(OUTSTR,K,VY,-999.,998.,'W','obs Y org',IER)
          CALL EGETWR(OUTSTR,K,VZ, -99., 99.,'W','obs Z org',IER)
          XOB(icomp,I)=VX
          YOB(icomp,I)=VY
          ZOB(icomp,I)=VZ
          CALL EGETWR(OUTSTR,K,VX,0.,150.,'W','obs X dis',IER)
          CALL EGETWR(OUTSTR,K,VY,0.,150.,'W','obs Y dis',IER)
          CALL EGETWR(OUTSTR,K,VZ,0.,150.,'W','obs Z dis',IER)
          DXOB(icomp,I)=VX
          DYOB(icomp,I)=VY
          DZOB(icomp,I)=VZ
          CALL EGETWR(OUTSTR,K,VX,-359.,359.,'W','obs rot ang',IER)
          BANGOB(icomp,I,1)=VX
          IF(ND.EQ.7)THEN
            OPOB(icomp,I)=1.0
            IF(I.LE.9)THEN
              WRITE(BLOCKNAME(ICOMP,I),77)I
   77         FORMAT('B',I1)
            ELSEIF(I.GT.9)THEN
              WRITE(BLOCKNAME(ICOMP,I),78)I
   78         FORMAT('B',I2)
            ENDIF
            BLOCKMAT(ICOMP,I)='NONE'
            BLOCKTYP(ICOMP,I)='obs '
          ELSEIF(ND.EQ.8)THEN
            OPOB(icomp,I)=1.0
            CALL EGETW(OUTSTR,K,WORD,'W','obs blk name',IFLAG)
            BLOCKNAME(ICOMP,I)=WORD(1:12)
            BLOCKMAT(ICOMP,I)='NONE'
            BLOCKTYP(ICOMP,I)='obs '
          ELSEIF(ND.EQ.9)THEN

C Get name of obstruction block and its construction (which might
C contain spaces).
            OPOB(icomp,I)=1.0
            CALL EGETW(OUTSTR,K,WORD,'W','obs blk name',IFLAG)
            BLOCKNAME(ICOMP,I)=WORD(1:12)
            CALL EGETP(OUTSTR,K,WORD,'W','obs mat name',IFLAG)
            write(BLOCKMAT(ICOMP,I),'(a)') WORD(1:lnblnk(WORD))
            BLOCKTYP(ICOMP,I)='obs '
          ELSEIF(ND.GE.10)THEN

C Get opacity and name of obstruction block and its construction (which might
C contain spaces).
            CALL EGETWR(OUTSTR,K,VX,0.,1.,'W','obs opacity',IER)
            OPOB(icomp,I)=VX
            CALL EGETW(OUTSTR,K,WORD,'W','obs blk name',IFLAG)
            BLOCKNAME(ICOMP,I)=WORD(1:12)
            CALL EGETP(OUTSTR,K,WORD,'W','obs mat name',IFLAG)
            write(BLOCKMAT(ICOMP,I),'(a)') WORD(1:lnblnk(WORD))
            BLOCKTYP(ICOMP,I)='obs '
          ENDIF
        ELSE
          CALL USRMSG(' mismatch block descr in',OUTSTR,'W')
        ENDIF

   10 CONTINUE

C Read surface test grid information and check ranges.
      CALL STRIPC(IUNIT,OUTSTR,99,ND,1,'obs grid infor',IER)
      IF(IER.NE.0)GOTO 99
      K=0
      CALL EGETWI(OUTSTR,K,NOX(icomp),4,MOX,'F','surf shd grid X',IER)
      CALL EGETWI(OUTSTR,K,NOZ(icomp),4,MOZ,'F','surf shd grid Z',IER)
      if(ND.eq.4)then
       CALL EGETWI(OUTSTR,K,NGXD,4,10,'F','win grid X depreciated',IER)
       CALL EGETWI(OUTSTR,K,NGZD,4,10,'F','win grid Z depreciated',IER)
      endif

C Close site file.
   99 CALL ERPFREE(IUNIT,ISTAT)

C Trace.
      IF(ITRC.GT.0)THEN
        CALL EDISP(ITRU,' ')
        CALL EDISP(ITRU,'Details of obstruction blocks:')
        WRITE(OUTSTR,997)NOX(icomp),NOZ(icomp)
  997   FORMAT('Shading based on a grid of ',
     &           I3,' by ',I3,' for surfaces.')
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,9996)nbobs(icomp)
 9996   FORMAT('There are ',I2,
     &         ' obstructions associated with the zone.')
        CALL EDISP(ITRU,OUTSTR)
        CALL EDISP(ITRU,
     &  'Block X- Y- Z- coords DX- DY- DZ- values Orient Opacity')
        DO 9995 I=1,nbobs(icomp)
          llbm=lnblnk(BLOCKMAT(ICOMP,I))
          llbn=lnblnk(BLOCKNAME(ICOMP,I))
          WRITE(OUTSTR,9994)I,XOB(ICOMP,I),YOB(ICOMP,I),ZOB(ICOMP,I),
     &      DXOB(ICOMP,I),DYOB(ICOMP,I),DZOB(ICOMP,I),
     &      BANGOB(ICOMP,I,1),OPOB(ICOMP,I),BLOCKNAME(ICOMP,I)(1:llbn),
     &      BLOCKMAT(ICOMP,I)(1:llbm)
 9994     FORMAT(I3,7F8.1,F5.2,' ',a,' ',a)
          CALL EDISP(ITRU,OUTSTR)
 9995   CONTINUE
        CALL EDISP(ITRU,' ')
      ENDIF
      RETURN

      END


C ******************** MKGOMST ********************
C Creates an annotated site obstruction file based
C on passed parameters and the contents of common GS5.

      SUBROUTINE MKGOMST(IAF,ZF,ICOMP,IER)
#include "building.h"
#include "model.h"
#include "geometry.h"

      integer lnblnk  ! function definition

      common/OUTIN/IUOUT,IUIN,IEOUT

      CHARACTER ZF*72  ! zone file name
      character outl*124,outld*124
      integer llbm  ! length of block material

C Create/Open the file.
      CALL EFOPSEQ(IAF,ZF,3,IER)
      IF(IER.LT.0)THEN
        IER=1
        RETURN
      ENDIF

C Write out a file header.
      WRITE(IAF,31)ZF(1:lnblnk(ZF)),
     &  LGEOM(ICOMP)(1:lnblnk(LGEOM(ICOMP)))
  31  FORMAT('# site obstruction file defined in ',a,/,
     &       '# associated with zone geometry file ',a)

C Write all site information.
      WRITE(IAF,'(A)',IOSTAT=IOS,ERR=3)
     &  ' 0. 0.   # dummy values for site position'

C Write number of blocks.
      WRITE(IAF,'(I5,A)',IOSTAT=IOS,ERR=3) nbobs(icomp),
     &  '    # no obstruction blocks'

C For each block write info, use space as item separation.
      WRITE(IAF,'(a)')
     &'# origin X Y Z, width, depth, height, rot ang, opac descr, cons'
      DO 10 I=1,nbobs(icomp)
        llbm=lnblnk(BLOCKMAT(ICOMP,I))
        llbn=lnblnk(BLOCKNAME(ICOMP,I))
        WRITE(outl,34,IOSTAT=IOS,ERR=3)XOB(icomp,I),YOB(icomp,I),
     &    ZOB(icomp,I),DXOB(icomp,I),DYOB(icomp,I),DZOB(icomp,I),
     &    BANGOB(icomp,I,1),OPOB(icomp,I),
     &    BLOCKNAME(ICOMP,I)(1:llbn),BLOCKMAT(ICOMP,I)(1:llbm),I
  34    FORMAT(7F9.3,F6.2,2X,A,1X,A,1X,'# block ',I3)
        call SDELIM(outl,outld,'S',IW)
        WRITE(IAF,'(a)',IOSTAT=IOS,ERR=3) outld(1:lnblnk(outld))
   10 CONTINUE

C Write surface test grid information.
      WRITE(IAF,'(A)',IOSTAT=IOS,ERR=3) '# grid surf X surf Z'
      WRITE(IAF,'(2I6)',IOSTAT=IOS,ERR=3) NOX(icomp),NOZ(icomp)

C Close site file.
      CALL ERPFREE(IAF,ISTAT)
      RETURN

   3  if(IOS.eq.2)then
        call edisp(iuout,
     &    'MKGOMST: no permission to write obstruction data.')
      else
        call edisp(iuout,'MKGOMST: error writing obstruction data.')
      endif
      CALL ERPFREE(IAF,ISTAT)
      ier=1
      return

      END

C ******************** ERMRT ********************
C Read the MRT sensor definition file. IC is the zone index
C (for use in mrt). IER=0 OK, IER=1 problem, IER=3 surface mismatch.

      SUBROUTINE ERMRT(ITRC,ITRU,IUF,LMRT,IC,IER)
#include "building.h"
#include "geometry.h"
#include "espriou.h"

      integer lnblnk  ! function definition

      common/TOTAL/nsurmf, NGRID, NTRPOL

      common/MRTF/FFL(MCUB,6,MSM),VEWF(MS,MS)
      common /cube5/fstgrp,fstsur,lstsur,strtgr

      DIMENSION VA(MSM)

      CHARACTER LMRT*72,LGEO*72,OUTSTR*124,WORD*20,outs*124
      integer fstgrp,fstsur,lstsur,strtgr

      CALL EFOPSEQ(IUF,LMRT,1,IER)
      IF(IER.LT.0)THEN
        write(outs,'(3a)') 'Viewfactor file ',LMRT(1:lnblnk(LMRT)),
     &    ' could not be opened.'
        call edisp(itru,outs)
        IER=1
        RETURN
      endif
      write(currentfile,'(a)') LMRT(1:lnblnk(LMRT))

C Read first line which must be *VIEWFACTORS or *viewfactors
      CALL STRIPC(IUF,OUTSTR,0,ND,1,'line 1',IER)
      if(IER.NE.0)return
      if(OUTSTR(1:12).eq.'*VIEWFACTORS'.or.
     &   OUTSTR(1:12).eq.'*viewfactors')then
        continue
      else
        write(outs,'(3a)') LMRT(1:lnblnk(LMRT)),
     &    ' is not a view factor file.'
        call edisp(itru,outs)
        IER=1
        RETURN
      endif

C Read name of geometry file this file matches.  Information
C currently not used - mrt accesses configuration file.
      CALL STRIPC(IUF,OUTSTR,0,ND,1,'geom file',IER)
      K=0
      CALL EGETW(OUTSTR,K,WORD,'W','*GEOM tag',IFLAG)
      if(WORD(1:5).eq.'*GEOM'.or.WORD(1:5).eq.'*geom')then
        call EGETRM(OUTSTR,K,LGEO,'W','assoc geom file',IER)
      else
        LGEO='UNKNOWN'
      endif

C Read number of mrt sensors.
C << NCUB is implied in newer geometry files so check if this number disagrees.
C << NZS needs to be checked against what is in the geometry file. If it does
C << not agree then should rebuild either with zeros or with area weighted and
C << re-establish mrt blocks if they exist in geo file.
      CALL STRIPC(IUF,OUTSTR,0,ND,1,'no sensors & surfs',IER)
      K=0
      CALL EGETWI(OUTSTR,K,NCUBF,0,MCUB,'F',
     &  'number mrt sensors in vwf file',IER)
      CALL EGETWI(OUTSTR,K,NZS,1,MS,'F','number mrt zone surfs',IER)
      CALL EGETWI(OUTSTR,K,IZINDX,1,MCOM,'F','mrt zone index',IER)
      if(ier.ne.0)return
      if(IZINDX.ne.IC)then
        write(outs,'(3a)') LMRT(1:lnblnk(LMRT)),
     &    ' linked to wrong zone index.'
        call edisp(itru,outs)
        IER=1
        CALL ERPFREE(iuf,ISTAT)
        return
      endif

      if(NZS.ne.NZSUR(ic))then

        write(outs,'(3a)') LMRT(1:lnblnk(LMRT)),
     &    ' has different surface count to zone geometry.'
        call edisp(itru,outs)
        IER=3  ! signal mismatch
        CALL ERPFREE(iuf,ISTAT)
        return
      endif

C Test for number of MRT sensors. If zero in this file but NCUB(IC) is
C non-zero then do not update NCUB. If > zero and NCUB(IC) is zero then do
C update NCUB(IC).
      if(NCUBF.eq.0.and.NCUB(IC).gt.0)then
        continue
      elseif(NCUBF.gt.0.and.NCUB(IC).eq.0)then
        NCUB(IC)=NCUBF
      endif

      DO 330 I = 1,NZS

C Read surface data line(s).
        IRV=NZS
        CALL EGETWRA(IUF,VA,IRV,0.,0.99999,'F','view factors',IER)
        DO 14 J=1,NZS
          VEWF(I,J)=VA(J)
   14   CONTINUE
  330 CONTINUE

C Skip past the row sums.
      DO 331 I = 1,NZS
        CALL STRIPC(IUF,OUTSTR,0,ND,1,'row sums',IER)
  331 CONTINUE

C Write trace if requested.
C MS sensitive, change if MS>99.
      if(itrc.gt.0)then
        call edisp(itru,' Black body view factors')
        if(NZS.le.22)then
          write(outs,'(4X,22I5)')(I,I=1,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.23.and.NZS.le.44)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.45.and.NZS.le.66)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.67.and.NZS.le.88)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.89.and.NZS.le.110)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.111.and.NZS.le.132)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.133.and.NZS.le.154)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,132)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=133,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.155.and.NZS.le.176)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,132)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=133,154)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=155,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.177.and.NZS.le.198)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,132)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=133,154)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=155,176)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=177,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.199.and.NZS.le.220)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,132)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=133,154)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=155,176)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=177,198)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=199,NZS)
          call edisp(itru,outs)
        elseif(NZS.ge.221.and.NZS.le.242)then
          write(outs,'(4X,22I5)')(I,I=1,22)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=23,44)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=45,66)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=67,88)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=89,110)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=111,132)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=133,154)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=155,176)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=177,198)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=199,220)
          call edisp(itru,outs)
          write(outs,'(4X,22I5)')(I,I=221,NZS)
          call edisp(itru,outs)
        endif
        call edisp(itru,' ')

C MS senstive, change if MS>99.
        DO 9994 I=1,NZS
          if(NZS.le.22)then
            write(outs,9993)I,(VEWF(I,J),J=1,NZS)
 9993       format(I3,1X,22F5.2)
            call edisp(itru,outs)
          elseif(NZS.ge.23.and.NZS.le.44)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.45.and.NZS.le.66)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.67.and.NZS.le.88)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.89.and.NZS.le.110)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.111.and.NZS.le.132)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.133.and.NZS.le.154)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,132)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=133,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.155.and.NZS.le.176)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,132)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=133,154)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=155,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.177.and.NZS.le.198)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,132)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=133,154)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=155,176)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=177,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.199.and.NZS.le.220)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,132)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=133,154)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=155,176)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=177,198)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=199,NZS)
            call edisp(itru,outs)
          elseif(NZS.ge.221.and.NZS.le.242)then
            write(outs,9993)I,(VEWF(I,J),J=1,22)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=23,44)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=45,66)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=67,88)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=89,110)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=111,132)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=133,154)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=155,176)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=177,198)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=199,220)
            call edisp(itru,outs)
            write(outs,'(1x,22F5.2)')(VEWF(I,J),J=221,NZS)
            call edisp(itru,outs)
          endif
 9994   CONTINUE
      endif

C If there are sensors continue.
      if(NCUB(IC).eq.0)goto 100

C If next line is *MRT_SENSOR or *mrt_sensor:
      CALL STRIPC(IUF,OUTSTR,0,ND,1,'line 1',IER)
      if(IER.NE.0)return
      if(OUTSTR(1:11).eq.'*MRT_SENSOR'.or.
     &   OUTSTR(1:11).eq.'*mrt_sensor')then
        continue
      else
        write(outs,'(3a)') LMRT(1:lnblnk(LMRT)),
     &    ' is missing a MRT sensor definition.'
        call edisp(itru,outs)
        IER=1
        CALL ERPFREE(iuf,ISTAT)
        return
      endif


C lstsur is the number of surfaces in the zone NZS.
C The 6 surfaces of MRT sensors are considered as
C NZS+1 - NZS+6, like this:
C 1: -Y (back)
C 2: +X (right)
C 3: +Y (front)
C 4: -X (left)
C 5: +Z (top)
C 6: -Z (bottom)

      fstsur=NZS+1
      lstsur=NZS
      nsurmf=NZS+6

C Clear array of view factors from each cube to geometry.
      do 40 i=1,NCUB(IC)
        do 41 iv=1,6
          do 42 j=1,nsurmf
            ffl(i,iv,j)=0.
  42      continue
  41    continue
  40  continue

C Read each sensor block. Read additional line if *MRT_SENSOR.
C If no name then assign the sensor index as the name
C via internal read. If FOCUS is the same as the current
C sensor name then read the viewfactors and exit.
      DO 10 I=1,NCUB(IC)
        CALL STRIPC(IUF,OUTSTR,99,ND,1,'sensor block',IER)
        if(OUTSTR(1:11).eq.'*MRT_SENSOR'.or.
     &     OUTSTR(1:11).eq.'*mrt_sensor')then
          CALL STRIPC(IUF,OUTSTR,99,ND,1,'sensor block',IER)
        endif
        IF(IER.NE.0)return
        IF(ND.EQ.8.OR.ND.EQ.9)THEN
          K=0
          CALL EGETWI(OUTSTR,K,IVFOK(I),0,1,'W','mrt flag',IER)
          CALL EGETWR(OUTSTR,K,XOC(I),-999.,998.,'W','mrt X org',IER)
          CALL EGETWR(OUTSTR,K,YOC(I),-999.,998.,'W','mrt Y org',IER)
          CALL EGETWR(OUTSTR,K,ZOC(I),  -9., 99.,'W','mrt Z org',IER)
          CALL EGETWR(OUTSTR,K,DXC(I),   0., 99.,'W','mrt X dis',IER)
          CALL EGETWR(OUTSTR,K,DYC(I),   0., 99.,'W','mrt Y dis',IER)
          CALL EGETWR(OUTSTR,K,DZC(I),   0., 99.,'W','mrt Z dis',IER)
          CALL EGETWR(OUTSTR,K,CANG(I),-359.,359.,'W','mrt rot',IER)
          IF(ND.EQ.8)THEN
            WRITE(CUBN(I),'(A,I2.2)')'sen_',I
          ELSEIF(ND.EQ.9)THEN
            CALL EGETW(OUTSTR,K,WORD,'W','cube name',IFLAG)
            CUBN(I)=WORD(1:6)
          ENDIF
        ELSE
          CALL USRMSG(' mismatch sensor descr. in',OUTSTR,'W')
        ENDIF

C If view factors have been previously defined the keyword *MRTVIEW
C or *mrt_viewfactors will appear next and relevant data should 
C be read in if the current sensor name mathches FOCUS (then return).
C Otherwise the file will have the keyword *NOMRTVIEW and zeros.
        CALL STRIPC(IUF,OUTSTR,0,ND,1,'viewfactor key',IER)
        K=0
        CALL EGETW(OUTSTR,K,WORD,'W','viewfactor key',IFLAG)
        if(WORD(1:8).eq.'*MRTVIEW'.or.
     &     WORD(1:16).eq.'*mrt_viewfactors')then
          IVFOK(i)=1
        elseif(WORD(1:10).eq.'*NOMRTVIEW')then
          IVFOK(i)=0
        endif
        do 425 iv = 1,6
          IRV=NZS
          CALL EGETWRA(IUF,VA,IRV,0.,0.9999,'W','sensor vf',IER)
          DO 114 j=1,nsurmf
            ffl(i,iv,j)=VA(j)
  114     CONTINUE
425     continue
   10 CONTINUE

C Close the file and free the unit number.
  100 CALL ERPFREE(iuf,ISTAT)
      RETURN
      END


C ******************** EMKMRT ********************
C Write viewfactor/MRT sensor definition file based on
C information currently held in common blocks MRTC, MRTF.
C LMRT is the name of the file to be written to (any existing file
C by this name is overwritten).  zname is the zone name (12 char),
C ICOMP is the zone number.
C ITRU unit number for user output, IER=0 OK, IER=1 problem.
C act character*1 if 'a' then area weighted, if 'r' ray traced.

      SUBROUTINE EMKMRT(LMRT,LGEOM,NZS,IUF,ICOMP,act,IER)
#include "building.h"
#include "geometry.h"

      integer lnblnk  ! function definition

      COMMON/MRTF/FFL(MCUB,6,MSM),VEWF(MS,MS)

      dimension rval(MS)
      character LMRT*72,LGEOM*72,act*1
      character louts*496
      character tokens*124,comment*76,aligned_str*124

      IER=0

C Place ouput into IUF. Open any existing file by this name,
C (ask user for confirmation to over-write) or create a new file.
      CALL EFOPSEQ(IUF,LMRT,4,IER)
      IF(IER.LT.0)THEN
        IER=1
        RETURN
      ENDIF

C Write data.
      WRITE(comment,'(2a)',IOSTAT=IOS,ERR=14)
     &  'zone viewfactors and MRT sensors for ',
     &  zname(ICOMP)(1:lnzname(ICOMP))
C      WRITE(tokens,'(A)',IOSTAT=IOS,ERR=14)'*VIEWFACTORS'
      WRITE(tokens,'(A)',IOSTAT=IOS,ERR=14)'*viewfactors'
      call align_comment(24,tokens,comment,aligned_str)
      write(IUF,'(a)') aligned_str(1:lnblnk(aligned_str))

      WRITE(IUF,'(A,A)',IOSTAT=IOS,ERR=14)'*geom  ',
     &  LGEOM(1:lnblnk(LGEOM))
      WRITE(tokens,'(3I4)',IOSTAT=IOS,ERR=14) NCUB(ICOMP),NZS,ICOMP
      WRITE(comment,'(a)',IOSTAT=IOS,ERR=14)
     &  'number of mrt sensors & zone surfaces, zone index'
      call align_comment(24,tokens,comment,aligned_str)
      write(IUF,'(a)') aligned_str(1:lnblnk(aligned_str))

      if(act.eq.'a')then
        WRITE(IUF,'(A)',IOSTAT=IOS,ERR=14)
     &    '# Area weighted zone viewfactors follow:'
      else
        WRITE(IUF,'(A)',IOSTAT=IOS,ERR=14)'# Zone viewfactors follow:'
      endif

C Write matrix, one line at a time. Begin by copying data to a single
C dimension array and then generating & writing out as much as 496 chars.
C Use arlist2 because 12 characters is plenty for representing view
C factors.
      do I = 1,NZS
        do j = 1,NZS
          rval(j)=VEWF(i,j)
        enddo
        itrunc=1
        ipos=1
        do while (itrunc.ne.0)
          call arlist2(ipos,NZS,rval,MS,'C',louts,loutlen,itrunc)
          write(iuf,'(1x,a)',IOSTAT=ios,ERR=14) louts(1:loutlen)
          ipos=itrunc+1
        end do
      enddo

C Print sum over a row of view factors. Commented
C because it might influence use of view factors in bps.
      do I =  1,NZS
        fr=0.0
        do J =  1,NZS
          fr=fr+VEWF(i,j)
        enddo
        WRITE(IUF,4060)i,fr
4060    FORMAT(' sum over row ',i3,' is : ',F12.8)
      enddo

C If there are any cubes the save this information as well.
      if(NCUB(ICOMP).eq.0)goto 999
      WRITE(IUF,'(A)',IOSTAT=IOS,ERR=14)'# '
C      WRITE(tokens,'(A)',IOSTAT=IOS,ERR=14) '*MRT_SENSOR'
      WRITE(tokens,'(A)',IOSTAT=IOS,ERR=14) '*mrt_sensor'
      WRITE(comment,'(A)',IOSTAT=IOS,ERR=14)
     &'OK, Xorig,  Yorig,  Zorig,   DX,    DY,    DZ, rotation,  name'
      call align_comment(14,tokens,comment,aligned_str)
      write(IUF,'(a)') aligned_str(1:lnblnk(aligned_str))

      DO 1180 I=1,NCUB(ICOMP)

C Write heading for subsequent sensors.
        if(I.gt.1)then
          WRITE(tokens,'(A)',IOSTAT=IOS,ERR=14) '*mrt_sensor'
          WRITE(comment,'(A)',IOSTAT=IOS,ERR=14)
     &'OK, Xorig,  Yorig,  Zorig,   DX,    DY,    DZ, rotation,  name'
          call align_comment(14,tokens,comment,aligned_str)
          write(IUF,'(a)') aligned_str(1:lnblnk(aligned_str))
        endif
        WRITE(IUF,34)IVFOK(I),XOC(I),YOC(I),ZOC(I),DXC(I),DYC(I),
     &    DZC(I),CANG(I),CUBN(I),I
  34    FORMAT(8x,I8,6F8.3,F7.1,2X,A6,'   # sensor ',I2)
        if(IVFOK(I).eq.1)then
          WRITE(IUF,'(A)',IOSTAT=IOS,ERR=14)'*mrt_viewfactors'
        else
          WRITE(IUF,'(A)',IOSTAT=IOS,ERR=14)'*NOMRTVIEW'
        endif
        DO 425 iv = 1,6

C For each face of MRT sensor compose 1D array and generate packed
C string(s) as required.
          do j = 1,NZS
            rval(j)=ffl(i,iv,j)
          enddo
          itrunc=1
          ipos=1
          do while (itrunc.ne.0)
            call arlist(ipos,NZS,rval,MS,'C',louts,loutlen,itrunc)
            write(iuf,'(1x,a)',IOSTAT=ios,ERR=14) louts(1:loutlen)
            ipos=itrunc+1
          end do
  425   CONTINUE

1180  CONTINUE

C Close sensor file.
 999  CALL ERPFREE(IUF,ISTAT)
      RETURN

C Error messages.
  14  if(IOS.eq.2)then
        call usrmsg(' Problem writing to view factor & MRT sensor',
     &            ' file. No permission to write file.','W')
      else
        call usrmsg(' Problem writing to view factor & MRT sensor',
     &            ' file. Check disk space or computed values.','W')
      endif
      ier=1
      goto 999

      END


C ******************** SIFIMPORT ********************
C Imports the shading and insolation factors as held in an
C ASCII zone shading & insolation file to bimary file. Uses SIFWRT to
C update file contents. Uses some of the same code blocks as sifops but is
C written for silent operation. If the format changes in sifops then
C sifexp should also be updated.
C Input parameters:
C  icomp      - the current zone index
C  exportfile - ascii file to import (typically this would be a
C               name derived from the zone shading file).
C  ier        - is 0 if no problems, -3 if empty, -2 not found,
C             -1 wrong file type, -4 wrong zone.

      subroutine sifimport(icomp,exportfile,ier)
#include "building.h"
#include "model.h"
#include "geometry.h"

      integer lnblnk  ! function definition

      common/outin/iuout,iuin,ieout
      common/filep/ifil

      common/tmc/itmc(ms),nwins
      common/data2/pso(ms,24),psof(ms,24)
      common/data3/ishd(12),isadd(12),ntmc(ms),ioffs(ms)
      common/data4/insst(mgt,24,misur),pinsst(mgt,24,misur)
      common/data5/irecx,nsurs,msurs
      character ltrns*72
      integer multic,mons,monf
      common/mtfile/ltrns,multic,mons,monf

      character*3 month(12)
      character outs*124,louts*248,exportfile*96
      character outstr*124,loutstr*248,lkoutstr*1000
      character message*64
      integer nboftmc       ! number of insolation sources returned from findtmc
      logical ok

      DATA month/'Jan','Feb','Mar','Apr','May','Jun','Jul',
     &           'Aug','Sep','Oct','Nov','Dec'/

C Scan header of the zone shading & insolation file.
      ifilsi=ifil+3
      irec=1
      read(ifilsi,rec=irec,iostat=istat,err=1000)(ishd(i),i=1,12),
     &                                           (isadd(i),i=1,12)
C      write(outs,'(2a)')'Content of zone shading & insolation file ',
C     &                   lshad(icomp)(1:lnblnk(lshad(icomp)))
C      call edisp(iuout,' ')
C      call edisp(iuout,outs)
      ims=0
      mnth=1
      ifirst=0
      do 10 i=1,12
         if(ishd(i).ne.0)then
            ims=ims+1
            if(ifirst.eq.0)then
               mnth=i
               ifirst=1
            endif
         endif
   10 continue

C Assume there is nothing in the shading file and the
C import from ascii file is used to fill it.

C An empty shading file so setup some initial information. Find the
C initial month in the import file and then close the file. Note:
C the string for the month e.g. Jan is expected to be found
C between positions 11 and 13 of the line.
      iuj=ifil+10
      mnth=1
      call efopseq(iuj,exportfile,1,ier)
      call stripc(iuj,outstr,0,nd,1,'month',ier)
      if(outstr(1:7).eq.'* month')then
        do 16 im=1,12
          if(outstr(11:13).eq.month(im))mnth=im
 16     continue
        call erpfree(iuj,istat)
      elseif(outstr(1:5).eq.'* end')then
        call erpfree(iuj,istat)
      endif

      if(irecx.eq.0)irecx=5   ! irecx probably unset so do it for initial month
      isadd(mnth)=irecx       ! so code knows where to write data
      nsurs=nzsur(icomp)      ! needed for the header
      msurs=misur
      call findtmc(icomp,'s',nboftmc) ! establish insolation sources and copy to ntmc
      do ij=1,nsurs
        ntmc(ij)=itmc(ij)
      enddo

C Based on the file name being passed to this subroutine.
      call efopseq(iuj,exportfile,1,ier)
      if(ier.ne.0)goto 1002
      call stripc(iuj,outstr,0,nd,1,'header',ier)
      if(ier.ne.0)goto 1002
      if(outstr(1:24).ne.'* Shading and insolation')then
         call usrmsg('Not an ascii zone shading & insolation file!',
     &               exportfile,'W')
         call erpfree(iuj,istat)
         ier=-1
         return
      endif

      call stripc(iuj,outstr,0,nd,1,'zone & surf',ier)
      if(ier.ne.0)goto 1002
      k=0
      call egetwi(outstr,k,iret,0,0,'-','zone index',ier)
      if(ier.ne.0)goto 1002
      if(iret.ne.icomp)then
        call usrmsg('These data are for a different zone!',
     &                                     exportfile,'W')
        call erpfree(iuj,istat)
        ier=-4
        return
      endif

      call egetwi(outstr,k,iret,0,0,'-','surfaces',ier)
      if(ier.ne.0)goto 1002
      if(iret.ne.nzsur(icomp))then
        call usrmsg(
     &    'Number of surfaces in file does not match current model!',
     &     exportfile,'W')
        call erpfree(iuj,istat)
        ier=-4
        return
      endif

C Read data for a month. If we have a month that matches then
C the code looks for either '24 hour external' in which case
C the data is shading data. If '24 hour internal' found following
C the * month tag then we have only insolation.
      multic=2  ! signal data is known
      call stripc(iuj,outstr,0,nd,1,'month',ier)
 172  if(outstr(1:5).eq.'* end')goto 18
      if(ier.ne.0.or.outstr(1:7).ne.'* month')goto 1002

C For MODISH embedded.
C      if(ISIcalc==1)then
        if(outstr(1:7).eq.'* month')then 
          do 973 in=1,12
            if(outstr(11:13).eq.month(in))then
              mnth=in
            endif
 973      continue
        endif
C      endif

      if(outstr(11:13).eq.month(mnth))then
         call stripc(iuj,outstr,0,nd,1,'24 hour external',ier)
         if(outstr(1:16).ne.'24 hour external')then
           if(outstr(1:16).ne.'24 hour internal')then
             ishd(mnth)=2   ! no shading only insolation
             goto 173
           endif
           message='expecting 24 hours external'
           multic=0  ! signal data is not known
           goto 1002
         endif
         ishd(mnth)=1   ! at least shading
         do 150 i=1,nzsur(icomp)
            message='reading direct shading'
            call lstripc(iuj,loutstr,0,nd,1,'dir shading 01-12',ier)
            if(ier.ne.0)goto 1004
            k=0
            do 160 j=1,12
               call egetwr(loutstr,k,ret,0.,1.,'W',
     &                                     'dir shading 01-12',ier)
               if(ier.ne.0)goto 1004
               pso(i,j)=ret
  160       continue
            call lstripc(iuj,loutstr,0,nd,1,'dir shading 12-24',ier)
            if(ier.ne.0)goto 1004
            k=0
            do 170 j=13,24
               call egetwr(loutstr,k,ret,0.,1.,'W',
     &                                     'dir shading 12-24',ier)
               if(ier.ne.0)goto 1004
               pso(i,j)=ret
  170       continue

            message='reading diffuse shading'
            call lstripc(iuj,loutstr,0,nd,1,'dif shading 01-12',ier)
            if(ier.ne.0)goto 1004
            k=0
            do 180 j=1,12
               call egetwr(loutstr,k,ret,0.,1.,'W',
     &                                     'dif shading 01-12',ier)
               if(ier.ne.0)goto 1004
               psof(i,j)=ret
  180       continue
            call lstripc(iuj,loutstr,0,nd,1,'dif shading 12-24',ier)
            if(ier.ne.0)goto 1004
            k=0
            do 190 j=13,24
               call egetwr(loutstr,k,ret,0.,1.,'W',
     &                                     'dif shading 12-24',ier)
               if(ier.ne.0)goto 1004
               psof(i,j)=ret
  190       continue
  150    continue
      else
         if(mnth.gt.12) goto 18  ! have reached past december
         call usrmsg('Data in file is not for the specified month!',
     &                               exportfile,'W')
         call erpfree(iuj,istat)
         ier=-3
         return
      endif

C Read insolation factors. But the next line might also hold
C a Month string or end marker.
      call stripc(iuj,outstr,0,nd,1,'insolation header',ier)
 173  if(ier.ne.0.or.outstr(1:16).ne.'24 hour internal')then
        if(outstr(1:7).eq.'* month')then
          ok=.true.
          if(ok)then
            call sifwrt(icomp,mnth,lastrec)
            if(lastrec.gt.5)then
              if(isadd(mnth+1).eq.0) isadd(mnth+1)=lastrec
            endif
          endif
          mnth=mnth+1   ! increment the month and jump back
          goto 172
        elseif(outstr(1:5).eq.'* end')then
          goto 18   ! end of file reached
        endif
        message='expecting 24 hours internal'
        multic=0  ! signal data is not known
        goto 1002
      endif

      if(outstr(1:5).eq.'* end')goto 18
      call stripc(iuj,outstr,0,nd,1,'offsets header',ier)
      if(ier.ne.0.or.outstr(1:14).ne.'record offsets')then
        message='expecting record offsets'
        goto 1002
      endif
      if(ishd(mnth).eq.1) ishd(mnth)=3   ! set to shading + insul

C Read the offsets line. Items with a zero are not insolation
C sources, non-zero entries are offsets to use within the binary
C file and the position in the list indicates with surface in
C the zone is an insolation source.
      call stripc1k(iuj,lkoutstr,0,nd,1,'offsets data',ier)
      if(ier.ne.0)goto 1004
      k=0
      do 200 i=1,nzsur(icomp)
         call egetwi(lkoutstr,k,iret,0,0,'-','offset',ier)
         if(ier.ne.0)goto 1004
         ioffs(i)=iret
  200 continue

C Reset the counter for insolation sources. Use the nwins
C value for the first index of insst
      nwins=0
      do 210 i=1,nzsur(icomp)
         if(ioffs(i).ne.0)then
            nwins=nwins+1
            call stripc(iuj,outstr,0,nd,1,'insst surf header',ier)
            if(ier.ne.0.or.outstr(1:21).ne.
     &        'surfaces insolated by')then
               message='expecting surfaces insolated by'
              goto 1002
            endif
            do 220 j=1,misur
               call stripc(iuj,outstr,0,nd,1,'insst data',ier)
               if(ier.ne.0)goto 1002
               kk=0
               do 230 k=1,24
                  call egetwi(outstr,kk,iret,-1,ms,'-','insst',ier)
                  if(ier.ne.0)then
                    message='while reading insst data'
                    goto 1002
                  endif
                  insst(nwins,k,j)=iret
  230          continue
  220       continue

            call stripc(iuj,outstr,0,nd,1,'pinsst header',ier)
            if(ier.ne.0)goto 1002

            if(outstr(1:26).ne.'matched surface insolation')then
              message='expecting matched surface insolation'
              goto 1002
            endif
            do 240 j=1,misur
               call lstripc(iuj,loutstr,0,nd,1,'pinsst line',ier)
               if(ier.ne.0)goto 1004
               kk=0
               do 250 k=1,24
                  call egetwr(loutstr,kk,ret,0.,1.,'W','pinsst',ier)
                  if(ier.ne.0)then
                    message='while reading pinsst data'
                    goto 1004
                  endif
                  pinsst(nwins,k,j)=ret
  250          continue
  240       continue
         endif
  210 continue

      call stripc(iuj,outstr,0,nd,1,'* end',ier)
      if(ier.ne.0)goto 1002
      if(outstr(1:5).ne.'* end')then
        if(outstr(1:7).eq.'* month')then
          ok=.true.
          if(ok)then
            call sifwrt(icomp,mnth,lastrec)
            if(lastrec.gt.5)then
              if(isadd(mnth+1).eq.0) isadd(mnth+1)=lastrec
            endif
          endif
          mnth=mnth+1
          goto 172
        endif
        message='Expecting * end'
        goto 1002
      endif

C End marker of the file reached. Close it and update isadd
C if not december.
  18  call erpfree(iuj,istat)
C      call edisp(iuout,' ')
C      call edisp(iuout,'Import file closed.')
      ok=.true.
      if(ok)then
        call sifwrt(icomp,mnth,lastrec)
        if(lastrec.gt.5)then
          if(mnth.le.11)then  ! this line is different from line 656
            if(isadd(mnth+1).eq.0)isadd(mnth+1)=lastrec
          endif
        endif
      endif

      return

C Error handling.
 1000 write(outs,1001)
 1001 format('SIFIMPORT: Zone shading & insolation ascii file error!')
      call edisp(iuout,' ')
      call edisp(iuout,outs)
      call edisp(iuout,outstr)
      return

C Error written out in several lines with message identifying the
C type of data involved.
 1002 write(louts,'(3a)') 'sifimport: zone shading & insolation ',
     &   message(1:lnblnk(message)),' in the line '
      call edisp248(iuout,louts,90)
      call edisp(iuout,outstr)
      return

C Error written out in several lines with message identifying the
C type of data involved.
 1004 write(louts,'(3a)') 'sifimport: zone shading & insolation ',
     &   message(1:lnblnk(message)),' in the line '
      call edisp248(iuout,louts,90)
      call edisp248(iuout,loutstr,90)
      return
      end


C ******************** SIFWRT ********************
C Writes shading/insolation data to a zone shading & insolation file
C for the given month. lastrecwritten is an integer to pass back in
C case the calling code needs up update irecx.
C Originally in sifops.F

      subroutine sifwrt(icomp,mnth,lastrecwritten)
#include "building.h"
#include "geometry.h"

      common/outin/iuout,iuin,ieout
      common/filep/ifil
      common/tmc/itmc(ms),nwins

C isadd()  - start address of shading/insolation data for each
C            month with data.
C ishd()   - data type for month (0 no data, 1 shading only,
C            2 insolation only, 3 shading and insolation).
C pso()    - direct shading factor for each surface and hour.
C psof()   - diffuse shading factor for each surface and hour.
C ntmc()   - if 0 then surface is not an insolation source,
C            if 1 then it is.
C ioffs()  - the record offset to the insolation data for each
C            insolated surface associated with each insolation
C            source.
C insst(i,j,k)  - the index of kth internal surface being insolated
C                 from source i at hour j (0 indicates whole surface
C                 shading, -1 that the sun is not up).
C pinsst(i,j,k) - proportion of insolation associated with source i
C                 at hour j that reaches the kth internal surface.
      common/data2/pso(ms,24),psof(ms,24)
      common/data3/ishd(12),isadd(12),ntmc(ms),ioffs(ms)
      common/data4/insst(mgt,24,misur),pinsst(mgt,24,misur)
      common/data5/irecx,nsurs,msurs

      character outs*124

C S/I file unit number.
      ifilsi=ifil+3
      if(isadd(mnth).eq.0)then
         isadd(mnth)=irecx
         ishd(mnth)=1
      endif
      irec=1
      write(ifilsi,rec=irec,iostat=istat,err=1000)(ishd(i),i=1,12),
     &                                            (isadd(i),i=1,12)
      irec=2

      write(ifilsi,rec=irec,iostat=istat,err=1000)irecx,nsurs,msurs

C Record 3 reserved for future use, skip to 4.
      irec=4
      write(ifilsi,rec=irec,iostat=istat,err=1000)
     & (ntmc(i),i=1,nzsur(icomp))

C Number of insolation sources in zone.
      nwins=0
      irec=isadd(mnth)
      do 10 i=1,nzsur(icomp)
         nwins=nwins+ntmc(i)

C Write shading factors.
         write(ifilsi,rec=irec,iostat=istat,err=1000)(pso(i,j),j=1,24)
         irec=irec+1
         write(ifilsi,rec=irec,iostat=istat,err=1000)(psof(i,j),j=1,24)
         irec=irec+1
   10 continue

C Write insolation factors.
      if(ishd(mnth).eq.0.or.ishd(mnth).eq.1.or.nwins.eq.0) then
         lastrecwritten=irec
         return
      endif
      write(ifilsi,rec=irec,iostat=istat,err=1000)
     &  (ioffs(i),i=1,nzsur(icomp))
      irec=irec+1
      do 20 i=1,nwins
         do 30 j=1,misur
            write(ifilsi,rec=irec,iostat=istat,err=1000)
     &        (insst(i,k,j),k=1,24)
            irec=irec+1
   30    continue
         do 40 j=1,misur
            write(ifilsi,rec=irec,iostat=istat,err=1000)
     &        (pinsst(i,k,j),k=1,24)
            irec=irec+1
   40    continue
   20 continue
      lastrecwritten=irec
      return

C Error handling.
 1000 write(outs,1001)irec
 1001 format('SIFWRT: zone shading & insolation file error, record',I6)
      call edisp(iuout,' ')
      call edisp(iuout,outs)
      return
      end


C ******************** findtmc ********************
C Searches for surfaces that are insolation sources.
C   icomp  - the zone index;
C   act    - 's' for silent mode, '-' for user interaction mode.
c   ntmc   - how many insolation sources were found
C Previously in eish/inscon.F

      subroutine findtmc(icomp,act,ntmc)
#include "building.h"
#include "geometry.h"

C   ntmc & nwins: the number of insolation sources (i.e. external
C                 and transparent surfaces); the latter is held
C                 in common.
C   itmc & isc:   toggles for each surface, if 1 then surface is an
C                 insolation source. The latter is held
C                 in common.
      common/outin/iuout,iuin,ieout

      integer izstocn
      common/c24/izstocn(mcom,ms)
      common/shdfil/ishadf
      integer mon,isc,iyd
      common/contr/mon,isc(ms),iyd
      common/tmc/itmc(ms),nwins
      common/ract/paction

C iaplic(zone,1) toggle for shading;
C iaplic(zone,2) toggle for insolation;
C           where 1 means consider all applicable surfaces and 0
C           means manual selection of surfaces.
C nsurfcalc is number of shaded surfaces.
C lstsfcalc list of applicable surfaces.
C nsurfinso number of insolation sources.
C isurfinso list of insolation sources.
      common/ishdirec/iaplic(mcom,2),nsurfcalc(mcom),
     &       lstsfcalc(mcom,ms),nsurfinso(mcom),isurfinso(mcom,ms)

      dimension iva(ms)
      character paction*16
      character act*1

      logical newgeo  ! Used to test for new/old geometry file.

      newgeo=.false.  ! Assume older format geometry.

      ishadf=0

C Check which version.
      call eclose(gversion(icomp),1.1,0.01,newgeo)

C Establish if any of the surfaces are TMCs or CFCs.
      ntmc=0
      nwins=0

C If new format geometry and iaplic(icomp,2) equals 1 then
C all applicable surfaces were set in the zone geometry file.
      if(newgeo)then
         if(iaplic(icomp,2).eq.1)then
            nwins=nsurfinso(icomp)
            do j=1,nwins
               iva(j)=isurfinso(icomp,j)
            enddo  ! of j

C Set up itmc and isc arrays and total number of sources in zone.
            do i=1,nzsur(icomp)
              itmc(i)=0
              isc(i)=0 
              do j=1,nwins
                if(i.eq.iva(j))then
                  itmc(i)=1
                  isc(i)=1
                  ntmc=ntmc+1  ! update the parameter passed back
                endif
              enddo  ! of j
            enddo   ! of i

C If iaplic(icomp,2) is 0 and nsurfinso is non-zero then user
C has manually selected surfaces so fill arrays. If both 0 then
C the user effectively said no insolation should be calculated
C so just clear itmc() and isc() arrays.
         elseif(iaplic(icomp,2).eq.0)then
            nwins=nsurfinso(icomp)
            if(nwins.eq.0)then
               do i=1,nzsur(icomp)
                 itmc(i)=0
                 isc(i)=0 
               enddo  ! of i
            else
               do j=1,nwins
                  iva(j)=isurfinso(icomp,j)
               enddo  ! of j

C Set up itmc and isc arrays and total number of sources in zone.
               do I=1,nzsur(icomp)
                 itmc(i)=0
                 isc(i)=0 
                 do j=1,nwins
                   if(i.eq.iva(j))then
                      itmc(i)=1
                      isc(i)=1
                      ntmc=ntmc+1  ! update the parameter passed back
                    endif
                 enddo  ! of j
               enddo    ! of i
            endif
         endif

      else

C Older geometry file, user is required to set preferences for
C surfaces to include or, in the case of silent action, just
C do 'all applicable' surfaces.
         if(act.eq.'s'.or.paction(1:11).eq.'recalculate')then

C Clear return array and select all applicable surfaces.
            do i=1,nzsur(icomp)
              iva(i)=0
            enddo  ! of i
            do i=1,nzsur(icomp)
              icn=izstocn(icomp,i)
              if(zboundarytype(icomp,i,1).eq.0.and.
     &           sotf(icomp,i)(1:4).ne.'OPAQ')then
                ntmc=ntmc+1
                iva(ntmc)=i
              endif
            enddo  ! of i
            if(ntmc.eq.0)then
              if(paction(1:13).eq.'update_silent'.or.
     &           paction(1:16).eq.'useupdate_silent')then
               return
              else
                call usrmsg('No insolation source surfaces found!',
     &            ' ','W')
                return
              endif
            endif
            iaplic(icomp,2)=1
         else
            call edisp(iuout,' ')
            call edisp(iuout,'Select external transparent surfaces')
            call edisp(iuout,'(i.e. light sources) to include in the')
            call edisp(iuout,'intra-zone insolation calculation.')
            call pickshsur(icomp,ntmc,'i',iva,ier)
            if(ier.ne.0)return
            if(ntmc.eq.0) return
         endif

C Set up itmc and isc arrays and total number of sources, nwins, 
C in zone.
         do i=1,nzsur(icomp)
           itmc(i)=0
           isc(i)=0 
           do j=1,ntmc
             if(i.eq.iva(j))then
               itmc(i)=1
               isc(i)=1
               nwins=nwins+1
             endif
           enddo  ! of j
         enddo    ! of i

C Fill ishdirec array.
         nsurfinso(icomp)=nwins
         do j=1,nwins
            isurfinso(icomp,j)=iva(j)
         enddo  ! of j
      endif

      return
      end


C ******************** PICKSHSUR ********************
C Selects surfaces for shading & insolation analysis.
C 'izone' is the target zone, 'np' the number of surfaces selected,
C 'act' = 's or S' for shading, 'act' = 'i or I' for insolation,
C 'act' = 'l or L' for view shading surfaces and 'act' = '-' for
C no selection.  'iva' is the array of selections.
C This is a variant of pickssur with fewer passed parameters.

      subroutine pickshsur(izone,np,act,iva,ier)
#include "building.h"
#include "geometry.h"
#include "help.h"
      
      integer ncomp,ncon
      common/c1/ncomp,ncon
      integer izstocn
      common/c24/izstocn(mcom,ms)
      integer mon,isc,iyd
      common/contr/mon,isc(ms),iyd

C iaplic(1) toggle for shading; iaplic(2) toggle for insolation:
C                      1 is 'all_applicable' and
C                      0 is manual selection of surfaces.
C nsurfcalc nb of shaded surfaces, lstsfcalc() list of applicable surfaces.
C nsurfinso nb of insolation sources, isurfinso() list of insolation sources.
      common/ishdirec/iaplic(mcom,2),nsurfcalc(mcom),lstsfcalc(mcom,ms),
     &       nsurfinso(mcom),isurfinso(mcom,ms)

      dimension stmp(ms),iva(ms),ivals(ms)
      character stmp*33,act*1
      character sbound_ty*12,sbound_c2*6,sbound_e2*6

      integer ichoice ! temporary local variable for dialogs.
      integer iexcludediff_flag
      common/excludediff/iexcludediff_flag
      integer i
      logical newgeo  ! Used to test for new/old geometry file.

      helpinsub='miscel'  ! set for subroutine

      ier=0
      if(izone.gt.ncomp.or.izone.eq.0)then
         call usrmsg(' ',' Zone number out of range! ','W')
         ier=1
         return
      endif
      newgeo=.false.  ! Assume older format geometry.
      call eclose(gversion(izone),1.1,0.01,newgeo)
      
      helptopic='diffuse_shading_request'
      call gethelptext(helpinsub,helptopic,nbhelp)
      iexcludediff_flag=0     
      call easkmbox(' ','Diffuse shading options:',
     &  'Exclude diffuse shading',
     &  'Include diffuse shading (default)',
     &  ' ',' ',' ',' ',' ',' ',ichoice,nbhelp)
      if(ichoice.eq.1)then

C Exclude diffuse shading.
         iexcludediff_flag=1
      else
         iexcludediff_flag=0      
      endif

C Generate help text for the sequence of dialogs.
 43   helptopic='surface_selection_notes'
      call gethelptext(helpinsub,helptopic,nbhelp)
      if(act.eq.'s'.or.act.eq.'S')then
         call easkmbox(' ','Shading options:',
     &     'all applicable surfaces','select surface(s)',
     &     'cancel',' ',' ',' ',' ',' ',iic,nbhelp)
         if(iic.eq.1)iaplic(izone,1)=1
         if(iic.eq.2)iaplic(izone,1)=0
      elseif(act.eq.'i'.or.act.eq.'I')then
         if(newgeo)then
           if(iaplic(izone,2).eq.1)then
             iic=1   ! user nominated in the geometry file
           elseif(iaplic(izone,2).eq.0)then
             iic=2   ! user nominated in the geometry file
           endif
         else
           call easkmbox(' ','Insolation options:',
     &       'all applicable sources','select source(s)',
     &       'cancel',' ',' ',' ',' ',' ',iic,nbhelp)
           if(iic.eq.1)iaplic(izone,2)=1
           if(iic.eq.2)iaplic(izone,2)=0
         endif
      elseif(act.eq.'l'.or.act.eq.'L')then
         iic=4
      else
         iic=2
      endif

C Clear return array.
      do i=1,nzsur(izone)
         iva(i)=0
      enddo  ! of i

C Process initial selection.
      if(iic.eq.3)then
         return
      elseif(iic.eq.1)then
         if(act.eq.'s'.or.act.eq.'S')then
            np=0
            do i=1,nzsur(izone)
               icn=izstocn(izone,i)
               if(zboundarytype(izone,i,1).eq.0)then
                  np=np+1
                 iva(np)=i
               endif
            enddo  ! if i
            if(np.eq.0)then
               call usrmsg('No applicable surfaces found!',' ','W')
               goto 43
            endif
            return
         elseif(act.eq.'i'.or.act.eq.'I')then
            np=0
            do i=1,nzsur(izone)
               icn=izstocn(izone,i)
               if(zboundarytype(izone,i,1).eq.0.and.
     &            sotf(izone,i)(1:4).ne.'OPAQ')then
                  np=np+1
                  iva(np)=i
               endif
            enddo  ! of i
            if(np.eq.0)then
               call usrmsg('No applicable surfaces found!',' ','W')
               goto 43
            endif
            return
         endif
      elseif(iic.eq.2)then
         inpic=nzsur(izone)
         do i=1,inpic
            icn=izstocn(izone,i)
            call decode_zsbound(izone,i,sbound_ty,sbound_c2,sbound_e2)
            if(act.eq.'s'.or.act.eq.'S')then
               if(zboundarytype(izone,i,1).eq.0)then
                  write(stmp(I),'(5a)')sname(izone,i),'|',
     &              sotf(izone,i)(1:4),'|',sbound_ty(1:12)
               else
                  write(stmp(I),'(2a)')sname(izone,i),' not applicable'
               endif
            elseif(act.eq.'-')then
               write(stmp(i),'(5a)')sname(izone,i),'|',
     &           sotf(izone,i)(1:4),'|',sbound_ty(1:12)
            elseif(act.eq.'i'.or.act.eq.'I')then
               if(zboundarytype(izone,i,1).eq.0.and.
     &            sotf(izone,i)(1:4).ne.'OPAQ')then
                  write(stmp(i),'(5a)')sname(izone,i),'|',
     &              sotf(izone,i)(1:4),'|',sbound_ty(1:12)
               else
                  write(stmp(i),'(2a)')sname(izone,i),' not applicable'
               endif
            endif
            iva(i)=0
         enddo  ! of i

         call epicks(inpic,ivals,' ','Surface(s) to include',
     &     33,nzsur(izone),stmp,'Surface(s) to include?',ier,nbhelp)
         if(inpic.eq.0)then
            return
         else
            np=inpic
            do i=1,np
               iva(i)=ivals(i)
            enddo  ! of i
         endif

      elseif(iic.eq.4)then
         inpic=nzsur(izone)
         do i=1,inpic
            icn=izstocn(izone,i)
            call decode_zsbound(izone,i,sbound_ty,sbound_c2,sbound_e2)
            if(isc(i).eq.1)then
               write(stmp(i),'(5a)')sname(izone,i),'|',
     &           sotf(izone,i)(1:4),'|',sbound_ty(1:12)
            else
               write(stmp(i),'(2a)')sname(izone,i),' not assessed'
            endif
            iva(i)=0
         enddo  ! of i
         inpic=1
         call epicks(inpic,ivals,' ','Surface to View',
     &     33,nzsur(izone),stmp,'Surface(s) to view?',ier,nbhelp)
         if(inpic.eq.0)then
            return
         else
            np=inpic
            iva(1)=ivals(1)
         endif
      endif
      return
      end

C ******************** stuf4xyz *******************
C Instantiates 4 vertices in x(MV),y(MV),z(MV) from raw data.
C Useful for block shapes prior to call to PLEQN.

      subroutine stuf4xyz(x,y,z,x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4)
#include "building.h"

      dimension x(MV), y(MV), z(MV)
      X(1) = x1
      Y(1) = y1
      Z(1) = z1
      X(2) = x2
      Y(2) = y2
      Z(2) = z2
      X(3) = x3
      Y(3) = y3
      Z(3) = z3
      X(4) = x4
      Y(4) = y4
      Z(4) = z4
      return
      end

C ********************  PLEQN ********************
C Finds the equation EQN to a plane containing a polygon which
C is defined as a set of X() Y() Z() verticies tracing in order the
C edges of the polygon.  The plane is the best fit from points and its
C equation is in the form:
C       A*X + B*Y + C*Z = D
C where the vector (A B C) is the unit normal vector to the plane.
C The normal will point out from the surface if the vertices are
C passed in anti-clockwise.
C If ierpln=-1 then SNORM is very close to zero
C If ierpln=1 then number of points is zero

      SUBROUTINE PLEQN(X,Y,Z,NP,CG,EQN,IERPLN)
#include "building.h"

      DIMENSION X(MV), Y(MV), Z(MV), CG(3), EQN(4)
      DIMENSION VA(3), VB(3), VC(3), VN(3)
      logical close

C Initialise.
      IERPLN=0
      CG(1)=0.00
      CG(2)=0.00
      CG(3)=0.00
      EQN(1)=0.00
      EQN(2)=0.00
      EQN(3)=0.00
      EQN(4)=0.00
      VN(1)=0.00
      VN(2)=0.00
      VN(3)=0.00

C Check that we have some points.
      if (NP.eq.0) then
        IERPLN=1
        RETURN
      endif

C Find the center of gravity.
      do 10 I=1,NP
        CG(1)=CG(1)+X(I)
        CG(2)=CG(2)+Y(I)
        CG(3)=CG(3)+Z(I)
 10   continue
      do 20 I=1,3
        CG(I)=CG(I)/NP
 20   continue

C Loop through vertices calculating cross product.
      do 30 I=1,NP
        if ((I+1).gt.NP) then
          VA(1)=X(1)-X(I)
          VA(2)=Y(1)-Y(I)
          VA(3)=Z(1)-Z(I)
          VB(1)=X(2)-X(1)
          VB(2)=Y(2)-Y(1)
          VB(3)=Z(2)-Z(1)
        elseif ((I+1).eq.NP) then
          VA(1)=X(I+1)-X(I)
          VA(2)=Y(I+1)-Y(I)
          VA(3)=Z(I+1)-Z(I)
          VB(1)=X(1)-X(I+1)
          VB(2)=Y(1)-Y(I+1)
          VB(3)=Z(1)-Z(I+1)
        else
          VA(1)=X(I+1)-X(I)
          VA(2)=Y(I+1)-Y(I)
          VA(3)=Z(I+1)-Z(I)
          VB(1)=X(I+2)-X(I+1)
          VB(2)=Y(I+2)-Y(I+1)
          VB(3)=Z(I+2)-Z(I+1)
        endif

C Do cross product and if VC is not close to zero then
C normalise it (so that a polygon with long and short
C edges is treated correctly.
        call CROSS(VA,VB,VC)
        SNORM=0.00
        SNORM=sqrt(VC(1)**2+VC(2)**2+VC(3)**2)
        close=.false.
        call eclose(SNORM,0.0,0.0001,close)
        if(.not.close)then
          do 50 J=1,3
            VC(J)=VC(J)/SNORM
 50       continue
        endif

C Add to VN the normalised VC.
        VN(1)=VN(1)+VC(1)
        VN(2)=VN(2)+VC(2)
        VN(3)=VN(3)+VC(3)
 30   continue

C Make the surface normal of unit length and build EQN from VN.
      SNORM=0.
      SNORM=sqrt(VN(1)**2+VN(2)**2+VN(3)**2)
      close=.false.
      call eclose(SNORM,0.0,0.0001,close)
      if(close)then
        ierpln=-1
        return
      else
        do 40 I=1,3
          EQN(I)=VN(I)/SNORM
 40     continue
      endif

C Calculate constant term.
      EQN(4)=(EQN(1)*CG(1)) + (EQN(2)*CG(2)) + (EQN(3)*CG(3))

      RETURN
      END


C ******************** EPLNEQN ********************
C Finds the equation EQN to a plane containing a polygon which
C is defined as a set of X Y Z verticies tracing in order the edges of
C the polygon (this information is contained in PNTLST).  The plane is
C the best fit from PNTLST and its equation is in the form:
C       A*X + B*Y + C*Z = D
C where the vector (A<B<C) is the unit normal vecotr to the plane.
C This normal will be in the direction given by the right hand rotation
C rule MORS is the handedness of the axes defining the polygon
C verticies.  For solid bodies whose faces have been described anti-
C clockwise when viewed from the outside the unit normals within this
C routine will point outwards from the body.

C Note: this subroutine is not called.

      SUBROUTINE EPLNEQN(ITRU,MORS,ISTA,PNTLST,CG,EQN,IERR)
#include "building.h"

C Parameters.
      integer itru  ! unit for writing errors
      integer mors  ! indicates handedness of polygon - see below
      integer ISTA  ! start pointer to pntlst
      real PNTLST   ! list of points - see below
      real CG       ! returned centroid of polygon
      real EQN      ! returned equation of the plane
      DIMENSION PNTLST(100),CG(3),EQN(4)
      integer IERR  ! error state - see below

      real VNORM,PNT,E,VN,EV1,EV2,EV3
      dimension VNORM(3),PNT(MV,3),E(MV,3),VN(MV,3)
      dimension EV1(3),EV2(3),EV3(3)
      CHARACTER outs*124
      logical close

C Inputs.
C    PNTLST(ISTA)      NO. OF POINTS IN THE POLYGON.
C    PNTLST(ISTA+1)    FIRST VERTEX X COORD.
C    PNTLST(ISTA+2)    FIRST VERTEX Y COORD.
C    PNTLST(ISTA+3)    FIRST VERTEX Z COORD.
C    PNTLST(ISTA+4)    SECOND VERTEX X COORD. .....ETC.
C    MORS              (MODEL OR SCREEN) IS A FLAG TO INDICATE THE
C                      HANDEDNESS OF THE AXIS SYSTEM DEFINING THE POLYGON.
C                      IF MORS=1 FLAGS A RIGHT HANDED SYSTEM
C                                         E.G. MODEL COORDS.
C                      IF MORS=2 FLAGS A LEFT HANDED SYSTEM
C                                         E.G. SCREEN COORDS.

C    IERR   AN ERROR FLAG. IF .GE. 0 ALL O.K.
C           IF -1 THEN THE MAGNITUDE OF THE UNIT NORMAL IS .LT.10E-4
C           IF -2 THEN LESS THAN 3 POINTS IN THE POLYGON.
C           IF -3 THEN MORS IS OUT OF RANGE.

C Internal variables.
C    PNT(MV,3)   AN ARRAY OF VERTEX POINTS.
C    E(MV,3)     AN ARRAY OF EDGE VECTORS.
C    VN(MV,3)    AN ARRAY OF NORMAL VECTORS.
C    EV*(3)       TEMPORARY STORAGE FOR VECTORS.
C    VNORM(1>3)   X Y Z COORDS OF THE UNIT NORMAL VECTOR TO THE PLANE.

      IERR=0

      NP=INT(PNTLST(ISTA))
      IF(NP.LT.3)THEN
        IERR=-2
        GO TO 999
      ENDIF

      IF(NP.GT.MV) NP=MV
      DO 20 J=1,NP
        J1=J+1
        IF(J1.GT.NP)J1=1
        INJ=ISTA+((J-1)*3)
        INJ1=ISTA+((J1-1)*3)
        DO 10 K=1,3
          KNJ=INJ+K
          KNJ1=INJ1+K
          PNT(J,K)=PNTLST(KNJ)
          E(J,K)=PNTLST(KNJ1)-PNTLST(KNJ)

   10   CONTINUE
   20 CONTINUE

      DO 50 J=1,NP
        J1=J+1
        IF(J1.GT.NP) J1=1
        DO 30 K=1,3
          EV1(K)=E(J,K)
          EV2(K)=E(J1,K)
   30   CONTINUE

        CALL CROSS(EV1,EV2,EV3)

        SNORM = 0.0
        SNORM=SQRT(EV3(1)**2+EV3(2)**2+EV3(3)**2)
        call eclose(SNORM,0.0,0.0001,close)
        IF (.NOT.close)  SNORM = SQRT(SNORM)
        DO 40 K=1,3
          VN(J,K) = 0.0
          IF (.NOT.close)  VN(J,K)=EV3(K)/SNORM
   40   CONTINUE
   50 CONTINUE

      CALL AVER(MV,NP,PNT,CG)

      CALL AVER(MV,NP,VN,VNORM)

      SNORM=SQRT(VNORM(1)**2+VNORM(2)**2+VNORM(3)**2)
      IF(SNORM.LT.10E-4)THEN
        WRITE(outs,'(A,F10.5)')' PLNEQN: SNORM=',SNORM
        CALL EDISP(ITRU,outs)
        IERR=-1
        GO TO 999
      ENDIF

      DO 80 J=1,3
        EQN(J)=VNORM(J)/SNORM
   80 CONTINUE

      EQN(4)=EQN(1)*CG(1)+EQN(2)*CG(2)+EQN(3)*CG(3)

      IF(MORS.EQ.1)THEN
        RETURN
      ELSEIF(MORS.EQ.2)THEN
        DO 100 J=1,4
          EQN(J)=-EQN(J)
  100   CONTINUE
        RETURN
      ELSE

C MORS flag not recognised.
        IERR=-3
        GO TO 999
      ENDIF

 999  WRITE(outs,'(A,I3)') ' PLNEQN: error flag IERR =',IERR
      CALL EDISP(ITRU,outs)

      RETURN
      END

C ******************** ETRANSW ********************
C Used when creating an insert rectangular shape into a surface.
C OFFSET is the offset from the polygon (zero tpically).

C STEP 1 - Find equation of surface (EQN(4)) via PLEQN and get centre
C          Centre of Gravity (VP(3))
C STEP 2 - Set up Eye Point normal to plane at C. of G. (EP(3))
C STEP 3 - Find matrix and reverse matrix via EYEMAT to transform window
C          points to normal view.
C STEP 4 - Find co-ordinates of 'origin' as transformed via ORTTRN to
C          to normal view ('origin' - first vertex of surface)
C STEP 5 - Derive displacement of Window/Door co-ordinates relative to
C          'origin'
C STEP 6 - Apply reverse transformation to Window/Door co-ordinates via
C          ORTTRN to give vertices in global co-ords.
C N is the number of surface vertices, X,Y,Z are the surface vertex arrays,
C DX,DZ are the window offsets, DDX,DDZ are the window width & hieght,
C XXW,YYW,ZZW are the transformed window coords in surface coord system.

      SUBROUTINE ETRANSW(ITRC,ITRU,N,X,Y,Z,OFFSET,DX,DZ,DDX,DDZ,
     &                   XXW,YYW,ZZW)
#include "building.h"

      DIMENSION  X(MV),Y(MV),Z(MV),XXW(4),YYW(4),ZZW(4)
      DIMENSION  TMAT(4,4),RMAT(4,4)
      DIMENSION  VP(3),EP(3),EQN(4)
      CHARACTER OUTSTR*124

C Find transformation matrices that normalise face.
      call PLEQN(X,Y,Z,N,VP,EQN,IERR)

      IF (IERR .LT. 0)  GOTO  100
      DO 250 J = 1,3
        EP(J) = VP(J) + EQN(J)
  250 CONTINUE
      IF(ITRC.GT.1)THEN
        CALL EDISP(ITRU,' Plane equation data: ')
        WRITE(OUTSTR,'(a,3F8.3)')' Center of grav:',(VP(I),I=1,3)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,4F8.3)')' Equation:',(EQN(I),I=1,4)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,3F8.3)')' Eye Point:',(EP(I),I=1,3)
        CALL EDISP(ITRU,OUTSTR)
      ENDIF
      CALL  EYEMAT(EP,VP,1.0,TMAT,RMAT)

C Transform all points in surface and find lower left corner.
      XMIN=0.0
      YMIN=0.0
      DO 300 I=1,N
        CALL ORTTRN(X(I),Y(I),Z(I),TMAT,X1,Y1,ZZZ,IERR)
        IF(X1.LT.XMIN)XMIN=X1
        IF(Y1.LT.YMIN)YMIN=Y1
  300 CONTINUE
      XXW(1)=XMIN+DX
      YYW(1)=YMIN+DZ
      XXW(2)=XXW(1)+DDX
      YYW(2)=YYW(1)
      XXW(3)=XXW(2)
      YYW(3)=YYW(1)+DDZ
      XXW(4)=XXW(1)
      YYW(4)=YYW(3)

C Take each window or door and apply transformation first shifting
C the Z point by OFFSET.
      ZZZ=ZZZ-OFFSET
      DO 350 K = 1,4
        CALL  ORTTRN(XXW(K),YYW(K),ZZZ,RMAT,XX,YY,ZZ,IERR)
        XXW(K) = XX
        YYW(K) = YY
        ZZW(K) = ZZ
  350 CONTINUE
      IF(ITRC.GT.1)THEN
        CALL EDISP(ITRU,' Transforming window coords: ')
        WRITE(OUTSTR,'(a,4F8.3)') ' X coords:',(XXW(I),I=1,4)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,4F8.3)') ' Y coords:',(YYW(I),I=1,4)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,4F8.3)') ' Z coords:',(ZZW(I),I=1,4)
        CALL EDISP(ITRU,OUTSTR)
      ENDIF

  100 CONTINUE

      RETURN
      END

C ******************** ETRANFRAME ********************
C Used when creating an fixed width frame into a surface. It
C is assumed that an initial polygon of N edges will result in a frame
C polygon of N edges, however nwvert is returned with the actual number
C of vertices.

C STEP 1 - Find equation of surface (EQN(4)) via PLEQN and get centre
C          Centre of Gravity (VP(3))
C STEP 2 - Set up Eye Point normal to plane at C. of G. (EP(3))
C STEP 3 - Find matrix and reverse matrix via EYEMAT to transform frame
C          points to normal view.
C STEP 4 - Find offset points away from the polygon edge.
C STEP 5 - Derive displacement of frame co-ordinates relative to
C          'origin'?
C STEP 6 - Apply reverse transformation to Window/Door co-ordinates via
C          ORTTRN to give vertices in global co-ords.

      SUBROUTINE ETRANFRAME(ITRC,N,X,Y,Z,FRW,XXF,YYF,ZZF,nwvert,IER)
#include "building.h"

C Passed parameters.
      integer N     ! number of edges in the parent polygon
      real X,Y,Z    ! array of coordinates of parent polygon
      DIMENSION  X(MV),Y(MV),Z(MV)
      real FRW      ! frame width (m)
      real XXF,YYF,ZZF ! array of returned frame coordinates
      DIMENSION  XXF(MV),YYF(MV),ZZF(MV)
      integer nwvert  ! returned number of conformant new vertices
      integer ier   ! if 1 can not deal with complexity

      common/OUTIN/IUOUT,IUIN,IEOUT

C Local variables.
      DIMENSION  TMAT(4,4),RMAT(4,4)
      DIMENSION  VP(3),EP(3),EQN(4)
      real XN,YN    ! 2D coordinate array (raw)
      real XPN,YPN    ! 2D coordinate array (plus offset)
      DIMENSION  XN(MV),YN(MV),XPN(MV),YPN(MV)
      real XL,YL    ! ??
      DIMENSION  XL(MV),YL(MV)
      real AIL,BIL,CIL  ! defines inner lines
      DIMENSION AIL(MVS),BIL(MVS),CIL(MVS)
      CHARACTER OUTSTR*124,LOUTSTR*700
      integer ITVX   ! number of vertices in polygon
      logical BCLOSE,ICLOSE,MCLOSE ! close to X or Y axis
      logical close  ! to avoid divide by zero
      logical is180,close180  ! to avoid stright edge
      dimension is180(MV)
      real pi,ang3

C Check if we can deal with additional complexity in parent surface.
      ITVX = N
      if((N+2+ITVX).gt.MTV)then
        call edisp(iuout,
     &    'Frame more complex than ESP-r can work with. Returning.')
        ier=1
        return
      endif

      pi=4.0*atan(1.0)

C Find transformation matrices that normalise face.
      call PLEQN(X,Y,Z,N,VP,EQN,IERR)

      IF (IERR .LT. 0)  GOTO  100
      DO 250 J = 1,3
        EP(J) = VP(J) + EQN(J)
  250 CONTINUE
      IF(ITRC.GT.1)THEN
        CALL EDISP(IUOUT,' Plane equation data: ')
        WRITE(OUTSTR,'(a,3F8.3)')' Center of grav:',(VP(I),I=1,3)
        CALL EDISP(IUOUT,OUTSTR)
        WRITE(OUTSTR,'(a,4F8.3)')' Equation:',(EQN(I),I=1,4)
        CALL EDISP(IUOUT,OUTSTR)
        WRITE(OUTSTR,'(a,3F8.3)')' Eye Point:',(EP(I),I=1,3)
        CALL EDISP(IUOUT,OUTSTR)
      ENDIF
      CALL  EYEMAT(EP,VP,1.0,TMAT,RMAT)

C Transform all points in surface into 2D working points XN & YN.
C Also find lower left corner in 2D (the 2D coordinates will be
C relative to the COG of the surface).
      XMIN=0.0
      YMIN=0.0
      DO 300 I=1,N

C Also mark which of the edge angles is not close to 180 degrees.
C Check where we are in the list of edges to ensure that we also
C check from terminus vertex back to 1 & 2nd vertices.
        is180(I)=.false.
        if(I.lt.N-2)then
          call ang3vtx(x(i),y(i),z(i),x(i+1),y(i+1),z(i+1),
     &      x(i+2),y(i+2),z(i+2),ang3)
          call eclose(ang3,180.,1.0,close180)
          if(close180) is180(I)=.true.
        elseif(I.eq.N-1)then
          call ang3vtx(x(i),y(i),z(i),x(i+1),y(i+1),z(i+1),
     &      x(1),y(1),z(1),ang3)
          call eclose(ang3,180.,1.0,close180)
          if(close180) is180(I)=.true.
        elseif(I.eq.N)then
          call ang3vtx(x(i),y(i),z(i),x(1),y(1),z(1),
     &      x(2),y(2),z(2),ang3)
          call eclose(ang3,180.,1.0,close180)
          if(close180) is180(I)=.true.
        endif
        CALL ORTTRN(X(I),Y(I),Z(I),TMAT,X1,Y1,ZZZ,IERR)
        IF(X1.LT.XMIN)XMIN=X1
        IF(Y1.LT.YMIN)YMIN=Y1
        XN(I)=X1
        YN(I)=Y1
  300 CONTINUE

C Offset the 2D coordinates so that lower left is at zero zero.
      if(XMIN.lt.0.0)then
        XOFFSET= ABS(XMIN)
      else
        XOFFSET=XMIN
      endif
      if(YMIN.lt.0.0)then
        YOFFSET= ABS(YMIN)
      else
        YOFFSET= YMIN
      endif

C Add offset to XN YN array.
      do 301 I=1,N
        XPN(I)=XN(I)+XOFFSET
        YPN(I)=YN(I)+YOFFSET
  301 continue

C Logic for determining frame coordinates.
C Solve equation of perpendicular bisector and inner lines.
      I1=0      ! I1, I2 used to create maximum possible traiangles
      I2=0      ! using all vertices of the parent surface
      DTIN=FRW  ! distance moved in inner edge to create child surface
      XMX=0.0; YMY=0.0;
      XAA=0.

C A1,B1,C1,A2,B2,C2,C22 are used in equation of line.
      A1=0.0; B1=0.0; C1=0.0
      A2=0.0; B2=0.0; C2=0.0; C22=0.0
      DM=0.    ! DM=(A1*B2)-(A2*B1)
      AMX=0.   ! AMX = (C1A2-C2A1)/(B1A2-A1B2)
      AMY=0.   ! AMY = (C1B2-C2B1)/(A1B2-A2B1)
      AMXX=0.  ! AMXX = (C1A2-C22A1)/(B1A2-A1B2)
      AMYY=0.  ! AMYY = (C1B2-C22B1)/(A1B2-A2B1)
C      AREA=0.  ! calculated area of inner polygon
C      ITER=0   ! number of iterations to calculate required area

C Loop through all the possivblew 2D vertices.
      NWVERT=0   ! new vertices
      DO 765 IV=1,ITVX

C If the next pair of edges would be a straight line do not bother.
C This ensures that the AIL BIL CIL array is packed with only valid
C corner data.
        if(is180(iv))then
          goto 765
        endif
        I1=IV
        I2=IV+1
        IF(I1.EQ.ITVX)I2=1   ! end point at the start of polygon
        DX = XPN(I2) - XPN(I1) ! difference in X
        DY = YPN(I2) - YPN(I1) ! difference in Y
        CALL ECLOSE(DY,0.,0.0001,CLOSE)
        if(close)then
          XAA= PI/2.0          ! to avoid division by zero
        else
          XAA= ATAN(DX/DY)     ! angle between
        endif
        XMX= (XPN(I1)+XPN(I2))/2.0  ! half way along X
        YMY= (YPN(I1)+YPN(I2))/2.0  ! half way along Y

C Calculate equation of perpendicular bisector a1y+b1x=c1.
        BCLOSE=.FALSE.
        CALL ECLOSE(DY,0.,0.01,BCLOSE)
        IF(BCLOSE) THEN
          A1=0.0   ! Y dist was zero
          B1=1.
          C1=XMX
        ELSE
          CALL ECLOSE(DX,0.,0.01,BCLOSE)
          IF(BCLOSE) THEN
            A1=1.   ! X dist was zero
            B1=0.
            C1=YMY
          ELSE
            A1=1.   ! X dist was non-zero
            B1=(DX/DY)
            C1=YMY+(B1*(XMX))
          ENDIF
        ENDIF

C Calculate equation of inner lines.
        ICLOSE=.FALSE.
        CALL ECLOSE(DY,0.,0.0001,ICLOSE)
        IF(ICLOSE) THEN
          A2=1.   ! Y dist was zero
          B2=0.
          C2 =YMY+DTIN
          C22=YMY-DTIN
        ELSE
          CALL ECLOSE(DX,0.,0.0001,ICLOSE)
          IF(ICLOSE) THEN
            A2=0.   ! X dist was zero
            B2=1.
            C2 =XMX+DTIN
            C22=XMX-DTIN
          ELSE
            A2=1.   ! X dist was non-zero
            B2= -(DY/DX)

C << need to check to see that sin does not return zero >>
            C2 =YMY+(B2*(XMX))+(DTIN / SIN(XAA))
            C22=YMY+(B2*(XMX))-(DTIN / SIN(XAA))
          ENDIF
        ENDIF

C Solve equation of perpendicular bisector and inner lines
C to calculate M'or M''.
C M' = (M'x,M'y)   M''=(M''x,M''y)
        DM=(A1*B2)-(A2*B1)
        CALL ECLOSE(DM,0.,0.01,MCLOSE)
        IF(MCLOSE) THEN
          call edisp(iuout,'A zero length detected. Returning.')
          ier=1
          RETURN
        ENDIF
        AMX= ((C1*A2)-(C2*A1))/((B1*A2)-(A1*B2))  ! at one side of bisector
        AMY= ((C1*B2)-(C2*B1))/((A1*B2)-(A2*B1))
        AMXX=((C1*A2)-(C22*A1))/((B1*A2)-(A1*B2)) ! at other side of bisector
        AMYY=((C1*B2)-(C22*B1))/((A1*B2)-(A2*B1))

C Figure out if M'or M'' is  contained within polygon.
        CALL PNPOLY(AMX,AMY,XPN,YPN,ITVX,IN_OUT)
        IF(IN_OUT.EQ.1) THEN
          NWVERT=NWVERT+1
          AIL(NWVERT)=A2
          BIL(NWVERT)=B2
          CIL(NWVERT)=C2
        ELSE
          CALL PNPOLY(AMXX,AMYY,XPN,YPN,ITVX,IN_OUT)
          IF(IN_OUT.EQ.1) THEN
            C2=C22
            NWVERT=NWVERT+1
            AIL(NWVERT)=A2
            BIL(NWVERT)=B2
            CIL(NWVERT)=C2
          ELSE
            GOTO 765  ! not a valid new corner
          ENDIF
        ENDIF
 765  CONTINUE

C Debug.
      IF(ITRC.GT.1)THEN
        WRITE(LOUTSTR,'(a,82F8.3)') ' AIL:',(AIL(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
        WRITE(LOUTSTR,'(a,82F8.3)') ' BIL:',(BIL(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
        WRITE(LOUTSTR,'(a,82F8.3)') ' CIL:',(CIL(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
      endif

C Solve equation to get intersections of the inner polygon
C XL,YL (2D points).
      DO 766 IV=1,NWVERT
        I1=IV
        I2=IV+1
        IF(I1.EQ.NWVERT)I2=1
        XL(I1)= (((CIL(I1))*(AIL(I2)))-((CIL(I2))*(AIL(I1))))/
     &          (((BIL(I1))*(AIL(I2)))-((AIL(I1))*(BIL(I2))))
        YL(I1)= (((CIL(I1))*(BIL(I2)))-((CIL(I2))*(BIL(I1))))/
     &          (((AIL(I1))*(BIL(I2)))-((AIL(I2))*(BIL(I1))))

C Because we used XPN and YPN need to cast XL and YL back from
C the offsets.
        XL(I1)=XL(I1)-XOFFSET
        YL(I1)=YL(I1)-YOFFSET
        IF(ITRC.GT.1)THEN
          WRITE(outstr,'(a,2f8.3,i2)')'XL,YL,I1',
     &      XL(I1),YL(I1),I1
          CALL EDISP(IUOUT,OUTSTR)
        ENDIF
 766  CONTINUE

C Take frame coords and apply reverse transformation from 2D to 3D.
C Adjust looping to prevent the first edge of the new polygon being
C vertical. Note: working within packed list.
      DO 350 K = 1,NWVERT
        if(K.eq.1)then
          I1=NWVERT
        else
          I1=K-1
        endif
        CALL  ORTTRN(XL(I1),YL(I1),ZZZ,RMAT,XX,YY,ZZ,IERR)
        XXF(K) = XX
        YYF(K) = YY
        ZZF(K) = ZZ
  350 CONTINUE
      IF(ITRC.GT.1)THEN
        CALL EDISP(IUOUT,' Transformed frame coords: ')
        WRITE(LOUTSTR,'(a,82F8.3)') ' X coords:',(XXF(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
        WRITE(LOUTSTR,'(a,82F8.3)') ' Y coords:',(YYF(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
        WRITE(LOUTSTR,'(a,82F8.3)') ' Z coords:',(ZZF(I),I=1,NWVERT)
        CALL EDISP248(IUOUT,LOUTSTR,100)
      ENDIF

  100 CONTINUE

      RETURN
      END


C ******************** PNPOLY ********************
C Determines whether a point is inside a polygon.
C Method:
C   A vertical line is drawn through the point in question. If it
c   crosses the polygon boundary an odd number of times then the
c   point is inside the polygon.
C Parameters:
C   PX   - X-coordinate of point.
C   PY   - Y-coordinate of point.
C   XX   - N long vector containing x-coordinates of vertices of polygon.
C   YY   - N long vector containg y-coordinates of vertices of polygon.
C   N    - Number of vertices in the polygon.
C  INOUT - Signal returned:
C           -1 if the point is outside the polygon;
c            0 if the point is on an edge or at a vertex;
c            1 if the point is inside the polygon.
C Remarks:
C   The vertices may be listed clockwise or anticlockwise.
C   The first may optionally be repeated, if so N may optionally
c   be increased by 1.
C   The input polygon may be a compound polygon consisting
c   of several separate subpolygons. If so, the first vertex
c   of each subpolygon must be repeated, and when calculating
C   N, these first vertices must be counted twice.
C   The size of the arrays must be increased if N > MAXDIM.

      SUBROUTINE PNPOLY(PX,PY,XX,YY,N,INOUT)

      common/OUTIN/IUOUT,IUIN,IEOUT
      REAL X(200),Y(200),XX(N),YY(N)
      LOGICAL MX,MY,NX,NY
      character outs*124

      MAXDIM=200
      IF(N.GT.MAXDIM)then
        WRITE(outs,'(a,i3,a)') 'Warning: ',N,' is beyond edge limits'
        call edisp(iuout,outs)
        RETURN
      endif
      DO 1 I=1,N
        X(I)=XX(I)-PX
        Y(I)=YY(I)-PY
 1    continue
      INOUT=-1
      DO 2 I=1,N
        J=1+MOD(I,N)
        MX= (X(I).GE.0.0)
        NX= (X(J).GE.0.0)
        MY= (Y(I).GE.0.0)
        NY= (Y(J).GE.0.0)
        IF(.NOT.((MY.OR.NY).AND.(MX.OR.NX)).OR.(MX.AND.NX)) GOTO 2
        IF(.NOT.(MY.AND.NY.AND.(MX.OR.NX).AND..NOT.(MX.AND.NX))) GOTO 3
        INOUT=-INOUT
        GO TO 2

 3      IF((Y(I)*X(J)-X(I)*Y(J))/(X(J)-X(I))) 2,4,5
 4      INOUT=0
        RETURN
 5      INOUT=-INOUT
 2    CONTINUE
      RETURN
      END


C ******************** TRANSUR ********************
C Transforms a surface along its normal.
C OFFSET   - the offset from the base polygon (0.02 typically).
C NB       - number of base surface vertices.
C XB,YB,ZB - base surface vertex arrays.
C XT,YT,ZT - transformed surface vertex arrays.

      SUBROUTINE TRANSUR(ITRC,ITRU,NB,XB,YB,ZB,OFFSET,XT,YT,ZT,sname)
#include "building.h"

      DIMENSION  XB(MV),YB(MV),ZB(MV),XT(MV),YT(MV),ZT(MV)
      DIMENSION  VP(3),EQN(4),TRNS(3)
      CHARACTER sname*28,outs*144,out96*124

C Find transformation matrices that normalise face.
      call PLEQN(XB,YB,ZB,NB,VP,EQN,IERR)

C If error, return transformed points same as initial.
      IF (IERR .NE. 0)then
        write(outs,'(a,a)') ' PLEQN problem with ',sname
        call edisp(itru,outs)
        do 354 k=1,NB
          XT(k)=XB(k)
          YT(k)=YB(k)
          ZT(k)=ZB(k)
  354   continue
        return
      endif
      DO 352 K = 1,3
        TRNS(k)=EQN(k)*OFFSET
  352 continue
      do 353 k=1,NB
        XT(k)=XB(k)+TRNS(1)
        YT(k)=YB(k)+TRNS(2)
        ZT(k)=ZB(k)+TRNS(3)
  353 continue

      IF(ITRC.GT.1)THEN
        CALL EDISP(ITRU,' Plane equation data: ')
        WRITE(outs,'(a,3F8.3)')' Center of grav:',(VP(I),I=1,3)
        CALL EDISP(ITRU,outs)
        WRITE(outs,'(a,4F8.3)')' Equation:',(EQN(I),I=1,4)
        CALL EDISP(ITRU,outs)
        CALL EDISP(ITRU,' Transforming coords: ')
        ipos=1
        call arlist3(ipos,NB,XT,MV,'S',out96,loutlen,itrunc)
        WRITE(outs,'(a,a)') ' X coords:',out96(1:loutlen)
        CALL EDISP(ITRU,outs)
        call arlist3(ipos,NB,YT,MV,'S',out96,loutlen,itrunc)
        WRITE(outs,'(a,a)') ' Y coords:',out96(1:loutlen)
        CALL EDISP(ITRU,outs)
        call arlist3(ipos,NB,ZT,MV,'S',out96,loutlen,itrunc)
        WRITE(outs,'(a,a)') ' Z coords:',out96(1:loutlen)
        CALL EDISP(ITRU,outs)
      ENDIF

      RETURN
      END

C ******************** UV2AZ ********************
C Recover azimuth & elevation from unit vector.

      SUBROUTINE UV2AZ(vdx,vdy,vdz,azim,elev)

      logical clx0,cly0,clx1,cly1,clxm1,clym1
      PI = 4.0 * ATAN(1.0)
      RAD = PI/180.
      CROWA = vdx*vdx + vdy*vdy + vdz*vdz
      CROWA=SQRT(CROWA)
      if (abs(crowa).lt.0.001) then
        return
      endif

C Make vector into unit vector.
      vdx=vdx/crowa
      vdy=vdy/crowa
      vdz=vdz/crowa
      elev=90.0-(acos(vdz)/RAD)

C Reduce the azimuth calculation to a 2D problem.
      dist = vdx**2 + vdy**2
      dist = sqrt(dist)

C Check if tolerably close to an axis.
      CALL ECLOSE(vdx,0.0,0.001,clx0)
      CALL ECLOSE(vdy,0.0,0.001,cly0)
      CALL ECLOSE(vdx,1.0,0.001,clx1)
      CALL ECLOSE(vdy,1.0,0.001,cly1)
      CALL ECLOSE(vdx,-1.0,0.001,clxm1)
      CALL ECLOSE(vdy,-1.0,0.001,clym1)
      if(clx0.and.cly1)then
        azim=0.
      elseif(clx1.and.cly0)then
        azim=90.
      elseif(clx0.and.clym1)then
        azim=180.
      elseif(clxm1.and.cly0)then
        azim=270.
      elseif(vdx.gt.0.0.and.vdy.gt.0.0)then
        azim=acos(vdy/dist)/RAD
      elseif(vdx.gt.0.0.and.vdy.lt.0.0)then
        azim=acos(vdy/dist)/RAD
      elseif(vdx.lt.0.0.and.vdy.lt.0.0)then
        azim=360.0-(acos(vdy/dist)/RAD)
      elseif(vdx.lt.0.0.and.vdy.gt.0.0)then
        azim=360.0-(acos(vdy/dist)/RAD)
      endif

      return
      end

C ******************** LN2AZ ********************
C Recover azimuth & elevation vector from two coordinates in space.

      SUBROUTINE LN2AZ(x1,y1,z1,x2,y2,z2,azim,elev)

      logical clx0,cly0,clx1,cly1,clxm1,clym1
      PI = 4.0 * ATAN(1.0)
      RAD = PI/180.
      vdx=x2-x1
      vdy=y2-y1
      vdz=z2-z1
      CROWA = vdx*vdx + vdy*vdy + vdz*vdz
      CROWA=SQRT(CROWA)
      if (abs(crowa).lt.0.001) then
        return
      endif

C Make vector into unit vector.
      vdx=vdx/crowa
      vdy=vdy/crowa
      vdz=vdz/crowa
      elev=90.0-(acos(vdz)/RAD)

C Reduce the azimuth calculation to a 2D problem.
      dist = (vdx*vdx) + (vdy*vdy)
      dist = sqrt(dist)

C Check if tolerably close to an axis.
      CALL ECLOSE(vdx,0.0,0.001,clx0)
      CALL ECLOSE(vdy,0.0,0.001,cly0)
      CALL ECLOSE(vdx,1.0,0.001,clx1)
      CALL ECLOSE(vdy,1.0,0.001,cly1)
      CALL ECLOSE(vdx,-1.0,0.001,clxm1)
      CALL ECLOSE(vdy,-1.0,0.001,clym1)
      if(clx0.and.cly1)then
        azim=0.
      elseif(clx1.and.cly0)then
        azim=90.
      elseif(clx0.and.clym1)then
        azim=180.
      elseif(clxm1.and.cly0)then
        azim=270.
      elseif(vdx.gt.0.0.and.vdy.gt.0.0)then
        azim=acos(vdy/dist)/RAD
      elseif(vdx.gt.0.0.and.vdy.lt.0.0)then
        azim=acos(vdy/dist)/RAD
      elseif(vdx.lt.0.0.and.vdy.lt.0.0)then
        azim=360.0-(acos(vdy/dist)/RAD)
      elseif(vdx.lt.0.0.and.vdy.gt.0.0)then
        azim=360.0-(acos(vdy/dist)/RAD)
      endif
      return
      end

C ******************** AZ2UV ********************
C Recover unit vector from azimuth & elevation.

      SUBROUTINE AZ2UV(azim,elev,vdx,vdy,vdz)
      PI = 4.0 * ATAN(1.0)
      RAD = PI/180.

C Reconstitute the viewing vector.
      RYAZI = azim*RAD
      RSALT = elev*RAD
      vdz = SIN(RSALT)
      XYDIS = COS(RSALT)
      IF (XYDIS .LT. 1E-6)THEN
        vdx = 0.
        vdy = 0.
      ELSE
        vdx = XYDIS*SIN(RYAZI)
        vdy = XYDIS*COS(RYAZI)
      ENDIF

      return
      end

C ******************** CHECKWARP ********************
C Transforms surface into 2D and checks if points are
C in the plane of the surface.

C STEP 1 - Find equation of surface (EQN(4)) via PLEQN and get Centre of Gravity (VP(3))
C STEP 2 - Set up Eye Point normal to plane at C. of G. (EP(3))
C STEP 3 - Find matrix and reverse matrix via EYEMAT to transform > 2D
C isurf  - Current surface index (for reporting)
C N      - Number of surface vertices.
C X,Y,Z  - Surface vertex arrays,
C iwhich - Worst vertex off plane and ofby is amount it deviates.
C ivoff  - Number of vertices which are more than 3mm off.

      SUBROUTINE CHECKWARP(ITRC,itru,isurf,N,X,Y,Z,iwhich,ofby,ivoff)
      implicit none
#include "building.h"

C Passed parameters.
      integer itrc,itru  ! trace level and trace channel
      integer isurf,n    ! focus surface in the room and how many surfaces
      real X,Y,Z         ! arrays of X Y Z coords
      DIMENSION  X(MV),Y(MV),Z(MV)
      integer iwhich     ! which point has largest difference
      real ofby          ! largest difference
      integer ivoff      ! nb of points beyond tolerance

C Local variables.
      integer i,j,ierr   ! types for local variables
      real TMAT,RMAT,VP,EP,EQN
      DIMENSION  TMAT(4,4),RMAT(4,4)
      DIMENSION  VP(3),EP(3),EQN(4)
      real X1,Y1,ZZZ     ! returned 2D x y and z of offset point
      real differ,offset ! difference and offset from plane
      CHARACTER OUTSTR*124
      logical close

C Find transformation matrices that normalise face.
      call PLEQN(X,Y,Z,N,VP,EQN,IERR)

      if (IERR .LT. 0) then
        WRITE(OUTSTR,'(a,i3)')
     &    ' CHECKWARP Plane equation error for surface: ',isurf
        return
      endif
      DO 250 J = 1,3
        EP(J) = VP(J) + EQN(J)
  250 CONTINUE

C Report if user has toggled trace on.
      IF(ITRC.GT.1)THEN
        WRITE(OUTSTR,'(a,i3)')
     &    ' CHECKWARP Plane equation data for surface: ',isurf
        CALL EDISP(ITRU,outstr)
        WRITE(OUTSTR,'(a,3F8.3)')' Center of grav:',(VP(I),I=1,3)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,4F8.3)')' Equation:',(EQN(I),I=1,4)
        CALL EDISP(ITRU,OUTSTR)
        WRITE(OUTSTR,'(a,3F8.3)')' Eye Point:',(EP(I),I=1,3)
        CALL EDISP(ITRU,OUTSTR)
      ENDIF

C Call eyemat with 1m offset.
      offset=1.00
      CALL  EYEMAT(EP,VP,offset,TMAT,RMAT)

C Transform all points in surface and check for ZZZ which differs
C from the 1m offset. The tolerance is currently set to 5mm.
      ivoff=0
      ofby=0.0
      DO 300 I=1,N
        CALL ORTTRN(X(I),Y(I),Z(I),TMAT,X1,Y1,ZZZ,IERR)
        call eclose(ZZZ,offset,0.005,close)
        if(.NOT.close)then
          ivoff=ivoff+1   ! increment number of vertices off by more than 5mm
          differ=offset-ZZZ
          if(abs(differ).gt.abs(ofby))then  ! keep track of largest diff
            iwhich=i
            ofby=differ
          endif
          if(ITRC.GT.1)then
            WRITE(OUTSTR,'(a,i3,a,3F9.4,a,i3,a,F7.5)')' Point ',I,
     &      ' @ ',X(I),Y(I),Z(I),' in surf ',isurf,' is off by ',differ
            CALL EDISP(ITRU,OUTSTR)
          endif
        endif
  300 CONTINUE

      RETURN
      END


C ******************** ESCZONE ********************
C Makes a copy of the current contents of common blocks G1
C G4 G5 into SG1 SG2 SG4 SG5.

      SUBROUTINE ESCZONE(ICOMP)
#include "building.h"
#include "geometry.h"

      real gversion1
      COMMON/SG0/CTYPE1,gversion1
      COMMON/SG1/X1(MTV),Y1(MTV),Z1(MTV),NSUR1,JVN1(MS,MV),NVER1(MS),
     &           NTV1
      COMMON/SG4/NDP1,IDPN1(3)
      COMMON/SG5/SNAME1(MS),SOTF1(MS),SMLCN1(MS),SVFC1(MS),
     &           SUSE1(MS,2),SPARENT1(MS)

      CHARACTER CTYPE1*4,SNAME1*12,SMLCN1*32
      CHARACTER SVFC1*4,SOTF1*24,SUSE1*12,SPARENT1*12

C Loop through all data and copy their contents into a parallel common
C block for later recovery.
      CTYPE1=CTYPE(icomp)
      gversion1=gversion(icomp)
      NSUR1=NZSUR(icomp)
      NDP1=NDP(ICOMP)
      IDPN1(1)=IDPN(ICOMP,1)
      IDPN1(2)=IDPN(ICOMP,2)
      IDPN1(3)=IDPN(ICOMP,3)

      NTV1=NZTV(ICOMP)
      DO 65 IV=1,NTV1
        X1(IV)=X(IV)
        Y1(IV)=Y(IV)
        Z1(IV)=Z(IV)
   65 CONTINUE

      DO 66 IS=1,NZSUR(icomp)
        SNAME1(IS)=SNAME(ICOMP,IS)
        SOTF1(IS)=SOTF(ICOMP,IS)
        SMLCN1(IS)=SMLCN(ICOMP,IS)
        SVFC1(IS)=SVFC(ICOMP,IS)
        SUSE1(IS,1)=SUSE(ICOMP,IS,1)
        SUSE1(IS,2)=SUSE(ICOMP,IS,2)
        SPARENT1(IS)=SPARENT(ICOMP,IS)
        NVER1(IS)=isznver(ICOMP,IS)
        DO 67 IV=1,NVER1(IS)
          JVN1(IS,IV)=iszjvn(icomp,is,iv)
   67   CONTINUE
   66 CONTINUE

      RETURN
      END


C ******************** ERCZONE ********************
C Recovers the saved contents of common blocks G1 G2
C G4 G5 from SG1 SG2 SG4 SG5.

      SUBROUTINE ERCZONE(ICOMP)
#include "building.h"
#include "geometry.h"

      real gversion1
      COMMON/SG0/CTYPE1,gversion1
      COMMON/SG1/X1(MTV),Y1(MTV),Z1(MTV),NSUR1,JVN1(MS,MV),NVER1(MS),
     &           NTV1
      COMMON/SG4/NDP1,IDPN1(3)
      COMMON/SG5/SNAME1(MS),SOTF1(MS),SMLCN1(MS),SVFC1(MS),
     &           SUSE1(MS,2),SPARENT1(MS)

      CHARACTER CTYPE1*4,SNAME1*12,SMLCN1*32
      CHARACTER SVFC1*4,SOTF1*24,SUSE1*12,SPARENT1*12

C Loop through all saved data and copy their contents into icomp
C common blocks.
      CTYPE(icomp)=CTYPE1
      gversion(icomp)=gversion1
      NSUR=NSUR1
      NZSUR(icomp)=NSUR1
      NDP(ICOMP)=NDP1
      IDPN(ICOMP,1)=IDPN1(1)
      IDPN(ICOMP,2)=IDPN1(2)
      IDPN(ICOMP,3)=IDPN1(3)

      NTV=NTV1
      NZTV(icomp)=NTV1
      DO 65 IV=1,NTV
        X(IV)=X1(IV)
        Y(IV)=Y1(IV)
        Z(IV)=Z1(IV)
        szcoords(ICOMP,IV,1)=X(IV); szcoords(ICOMP,IV,2)=Y(IV)
        szcoords(ICOMP,IV,3)=Z(IV)
   65 CONTINUE

      DO 66 IS=1,NSUR
        SNAME(ICOMP,IS)=SNAME1(IS)
        SOTF(ICOMP,IS)=SOTF1(IS)
        SMLCN(ICOMP,IS)=SMLCN1(IS)
        SVFC(ICOMP,IS)=SVFC1(IS)
        SUSE(ICOMP,IS,1)=SUSE1(IS,1)
        SUSE(ICOMP,IS,2)=SUSE1(IS,2)
        SPARENT(ICOMP,IS)=SPARENT1(IS)
        NVER(IS)=NVER1(IS)
        isznver(ICOMP,IS)=NVER1(IS)
        DO 67 IV=1,NVER(IS)
          JVN(IS,IV)=JVN1(IS,IV)
          iszjvn(icomp,is,iv)=JVN1(IS,IV)
   67   CONTINUE
   66 CONTINUE

      RETURN
      END

C ******************** EASKGEOF ********************
C EASKGEOF asks for the zone number and geometry file name. If the
C configuration file has been read present a list of zone names,
C otherwise ask for a specific zone number and file name.
C If MOD = m or M then allowing a new zone to be created or one
C to be deleted (passed back as a negative zone number).
C If MOD = t or T then the focus is thermophysical.
C It is assumed that the user will make one selection only.

      SUBROUTINE EASKGEOF(PROMPT,CFGOK,IZONE,MOD,IMW,IER)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "epara.h"
#include "help.h"

C Parameters.
      character*(*) PROMPT   ! text for menu heading
      logical CFGOK          ! did the model load cleanly
      integer izone          ! which zone was selected
      character MOD*1        ! m M or t T
      integer IMW            ! menu width
      integer IER            ! zero is no problem

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/user/browse
      LOGICAL SEL,delzone,browse,cpyzone,XST

      DIMENSION VERT(35)
      character*(IMW) VERT
      CHARACTER KEY*1,DFILE*72
      CHARACTER*72 LFILG
      integer MVERT,IVERT  ! max items and current menu item

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_for_geometry'
      call gethelptext(helpinsub,helptopic,nbhelp)

C If no configuration file then ask for zone number and name.
      delzone = .false.
      cpyzone = .false.
      IF(.NOT.CFGOK)THEN
        IER=0
        IZONE=1
        CALL EASKI(IZONE,PROMPT,'Zone number?',
     &    1,'F',MCOM,'W',1,'zone number',IERI,nbhelp)
        if(ieri.eq.-3)then

C User requested a cancel set izone to zero to signal that
C nothing has been selected.
          IZONE=0
          RETURN
        endif

        DFILE='new.geo'
   79   CALL EASKS(LFILG,PROMPT,' Geometry file name?',
     &    72,DFILE,'geom name',IER,nbhelp)
        IF(LFILG.NE.' ')THEN
          LGEOM(IZONE)=LFILG
        ELSE
          GOTO 79
        ENDIF
        RETURN
      ENDIF

C Initialise zone menu variables based on window size.
C IVERT is the menu position, MVERT the current number of menu lines.
C Use shorter menu depending on what MOD is.
      SEL=.false.
      MHEAD=0
      if(browse)then
        MCTL=3
      else
        IF(MOD.EQ.'M'.OR.MOD.EQ.'m')THEN
          MCTL=4
        ELSEIF(MOD.EQ.'T'.OR.MOD.EQ.'t')THEN
          MCTL=5
        ELSE
          MCTL=3
        endif
      endif
      ILEN=NCOMP
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Loop through the items until the page to be displayed. M is the
C current menu line index. Build up text strings for the menu.
    3 M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LT.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          if(MOD.EQ.'T'.OR.MOD.EQ.'t')then
            if(LTHRM(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LTHRM(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          else
            WRITE(VERT(M),14)KEY,zname(L)
          endif
   14     FORMAT(A1,1X,A)
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text and info on portion seen.
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)=  '  ____________________  '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM
   15   FORMAT ('0 page: ',I1,' -- of:',I1)
      ENDIF

C If MOD has been passed as a M then add an item at the end allowing
C list to be modified otherwise blank choice.  If user is browsing
C no need to show additional options.
      if(browse)then
        VERT(M+2)  ='? help                   '
        VERT(M+3)  ='- exit menu              '
      else
        IF(MOD.EQ.'M'.OR.MOD.EQ.'m')THEN
          VERT(M+2)='* add/delete/copy        '
          VERT(M+3)='? help                   '
          VERT(M+4)='- exit menu              '
        ELSEIF(MOD.EQ.'T'.OR.MOD.EQ.'t')THEN
          VERT(M+2)='# update all zones       '
          VERT(M+3)='* non-linear properties  '
          VERT(M+4)='? help                   '
          VERT(M+5)='- exit menu              '
        ELSE
          VERT(M+2)='? help                   '
          VERT(M+3)='- exit menu              '
        ENDIF
      endif

C Display the menu.
      call usrmsg(PROMPT,'  ','-')
      if(MOD.EQ.'M'.OR.MOD.EQ.'m')then
        CALL EMENU('Zone Geometry/Attribution',VERT,MVERT,IVERT)
      elseif(MOD.EQ.'T'.OR.MOD.EQ.'t')then
        CALL EMENU('Zone Constructions',VERT,MVERT,IVERT)
      else
        CALL EMENU('Zones',VERT,MVERT,IVERT)
      endif

      IF(IVERT.LE.MHEAD)THEN
        IVERT=-1
        goto 3

C If no selection has been made before exit then return with 0.
      ELSEIF(IVERT.EQ.MVERT)THEN
        IF(.NOT.SEL)IZONE=0
        RETURN

C If nothing from list return with 0.
      ELSEIF(IVERT.EQ.0)THEN
        IZONE=0
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-1))THEN

C Display help text.
        CALL PHELPD('zone geom file section',nbhelp,'-',0,0,IER)

C Decode from the potentially long list to the zone number via KEYIND.
C If delete zone selected previously then turn zone into negative as
C follows -11 = del zone 1, -12 = del zone 2.  In the case of
C copying a zone add 100.
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        SEL=.TRUE.
        if(delzone)then
          IZONE = (IFOC + 10) * (-1)
        else
          IZONE = IFOC
        endif
        if(cpyzone)then
          IZONE = IFOC + 100
        endif
        RETURN
      endif

C Treat the remaining options depending on if the usr is browsing
C or owns the model.
      if(browse)then
        IF(IVERT.EQ.(MVERT-2))THEN

C If there are enough items allow paging control via EKPAGE.
          IF(IPFLG.EQ.1)THEN
            IPACT=EDIT
            CALL EKPAGE(IPACT)
          ENDIF
        else

C Not one of the legal menu choices.
          IVERT=-1
          goto 92
        endif
      else

C User can modify zone list.
        IF(IVERT.EQ.(MVERT-2))THEN

C Allow a zone to be added or deleted.
          IF(MOD.EQ.'M'.OR.MOD.EQ.'m')THEN
            CALL EASKMBOX(' ','Options:','add zone','delete zone',
     &        'copy zone','copy zones or group','cancel',
     &        ' ',' ',' ',IW,nbhelp)
            if(IW.EQ.1)then
              delzone = .false.
              IZONE=NCOMP+1
              RETURN
            elseif(IW.EQ.2)then
              delzone = .true.
              call usrmsg(' ','Select zone to delete.','-')
              IVERT=-2
              goto 3
            elseif(IW.EQ.3)then
              cpyzone = .true.
              call usrmsg(' ','Select zone to copy.','-')
              IVERT=-2
              goto 3
            elseif(IW.EQ.4)then
              cpyzone = .true.  ! Signal calling code to present multi-zones
              IZONE=301
              RETURN
            endif

C Display nonlinear thermophysical menu.
          ELSEIF(MOD.EQ.'T'.OR.MOD.EQ.'t')THEN
            delzone = .false.
            IZONE=-2
            RETURN
          ELSE

C If there are enough items allow paging control via EKPAGE.
            IF(IPFLG.EQ.1)THEN
              IPACT=EDIT
              CALL EKPAGE(IPACT)
            ENDIF
          ENDIF
        ELSEIF(IVERT.EQ.(MVERT-3))THEN

C All zones have been sellected return as 99
          IF(MOD.EQ.'T'.OR.MOD.EQ.'t')THEN
            IZONE=99
            RETURN
          ELSEIF(MOD.EQ.'M'.OR.MOD.EQ.'m')THEN
            IF(IPFLG.EQ.1)THEN
              IPACT=EDIT
              CALL EKPAGE(IPACT)
            ENDIF
          ENDIF
        ELSEIF(IVERT.EQ.(MVERT-4))THEN

C If there are enough items allow paging control via EKPAGE.
          IF(MOD.EQ.'T'.OR.MOD.EQ.'t')THEN
            IF(IPFLG.EQ.1)THEN
              IPACT=EDIT
              CALL EKPAGE(IPACT)
            ENDIF
          endif
        else

C Not one of the legal menu choices.
          IVERT=-1
          goto 92
        endif
      ENDIF
      IVERT=-2
      goto 3

      END

C ******************** ASKZONE ********************
C Presents a list of zones to select from.
C It is passed a prompt, menu title, default
C index and indicates current index (if zero then says no prior
C selection). It is assumed that the user will make one selection only.
C MOD display modifier - `c` note constructions defined, `o` note
C operations defined, `s` note shading defined, `z` note zone attrib
C complete, `v` note view factors, `g` casual gain ctl, `d` domain flow,
C `h` heat transfer (convective) methods, `-` zone names only.

      SUBROUTINE ASKZONE(IZONE,IDZONE,title,mod,errmsg,IMW,IER)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "schedule.h"
#include "epara.h"
#include "help.h"

C Parameters.
      integer izone          ! which zone was selected
      integer idzone         ! default suggestion
      character*(*) TITLE    ! text for menu heading
      character MOD*1        ! m M or t T
      character*(*) ERRMSG   ! text for error
      integer IMW            ! menu width
      integer IER            ! zero is no problem

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/cfdfil/LCFD(MCOM),IFCFD(MCOM)

      LOGICAL SEL,XST

      DIMENSION VERT(35)
      character*(IMW) VERT
      CHARACTER KEY*1
      character outs*124
      CHARACTER*72 LCFD,shdafile
      integer MVERT,IVERT  ! max items and current menu item

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_zone_single'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Initialise zone menu variables based on window size.
C IVERT is the menu position, MVERT the current number of menu lines.
      SEL=.FALSE.
      MHEAD=0
      if(mod.eq.'-')then
        MCTL=4
      elseif(mod.eq.'c')then
        MCTL=4
      elseif(mod.eq.'o')then
        MCTL=5
      elseif(mod.eq.'s')then
        MCTL=5
      elseif(mod.eq.'v')then
        MCTL=5
      elseif(mod.eq.'g')then
        MCTL=4
      elseif(mod.eq.'d')then
        MCTL=4
      elseif(mod.eq.'h')then
        MCTL=4
      endif
      ILEN=NCOMP
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Build up text strings for the menu.
    3 M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          if(mod.eq.'-')then
            WRITE(VERT(M),'(a1,1x,a)')KEY,zname(L)
          elseif(mod.eq.'c')then
            if(LTHRM(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LTHRM(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'o')then

C Check for operations files. For each one that exists, scan to see
C if it has been sorted and notify user.
            if(LPROJ(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LPROJ(L),XST)
              if(XST)then
                IUO=IFIL+1
                CALL ERPFREE(IUO,ISTAT)
                CALL EROPER(0,iuout,IUO,L,IER)
                if(ip3ver(L).eq.0)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (older)'
                  write(outs,'(3a)') 'Operations for ',zname(L),
     &              'needs update (periods unsorted).'
                  call edisp(iuout,outs)
                elseif(ip3ver(L).eq.1)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (defined)'
                elseif(ip3ver(L).ge.2)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (defined)'
                endif
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'s')then

C Check for existing shading files. Also check if an ASCII version
C exists if no binary file exists.
            if(LSHAD(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LSHAD(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                write(shdafile,'(2a)') lshad(L)(1:lnblnk(lshad(L))),'a'
                call FINDFIL(shdafile,XST)
                if(XST)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (ASCII only)'
                else
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (not found)'
                endif
              endif
            endif
          elseif(mod.eq.'v')then

C Check for existing viewfactor files.
            if(LVIEW(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LVIEW(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'g')then

C Check for casual gain control files.
            if(LCGCIN(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LCGCIN(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'d')then

C Check for CFD domain files.
            if(LCFD(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LCFD(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'h')then

C Check for heat transfer regime files.
            if(LHCCO(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LHCCO(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          endif
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text and info on portion seen.
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)=  '  ____________________  '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM
   15   FORMAT ('0 page part: ',I1,' -- of:',I1)
      ENDIF

      if(idzone.ne.0)then
        write(VERT(M+2),'(a,a)') '* default is ',zname(IDZONE)
      else
        VERT(M+2)='                        '
      endif
      if(MCTL.eq.5)then
        VERT(M+3)  ='* global tasks          '
        VERT(M+4)  ='? help                  '
        VERT(M+5)  ='- exit menu             '
      else
        VERT(M+3)  ='? help                  '
        VERT(M+4)  ='- exit menu             '
      endif

C Display the menu.
      CALL EMENU(title,VERT,MVERT,IVERT)
      IF(IVERT.LE.MHEAD)THEN
        IVERT=-1
        goto 3
      ELSEIF(IVERT.EQ.MVERT)THEN

C If no selection has been made before exit then display error message.
        IF(.NOT.SEL.and.mod.eq.'-')then
          call usrmsg(errmsg,'You must select one.','W')
          IVERT=-2
          goto 92
        endif
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-1))THEN

C Display help text.
        CALL PHELPD('zone geom file section',nbhelp,'-',0,0,IER)
      ELSEIF(IVERT.EQ.(MVERT-2).and.IDZONE.ne.0.and.MCTL.eq.4)THEN

C Take default zone.
        IZONE=IDZONE
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-2).and.MCTL.eq.5)THEN

C Signal global task.
        IZONE=99
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-3).and.IDZONE.ne.0.and.MCTL.eq.5)THEN

C Take default zone when there is also a global choice.
        IZONE=IDZONE
        RETURN
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Decode from the potentially long list to the zone number via KEYIND.
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        SEL=.TRUE.
        IZONE = IFOC
        RETURN
      ELSEIF(IVERT.EQ.(MVERT-3).and.MCTL.eq.4)THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      ELSEIF(IVERT.EQ.(MVERT-4).and.MCTL.eq.5)THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      else

C Not one of the legal menu choices.
        IVERT=-1
        goto 92
      endif
      IVERT=-2
      goto 3

      END

C ******************** ASKMULTIZONE ********************
C Presents a list of zones to select one or more from.
C It is passed a prompt, menu title, and number of allowable items inpic
C It returns inpick and array IVALS.
C MOD display modifier - `c` note constructions defined, `o` note
C operations defined, `s` note shading defined, `z` note zone attrib
C complete, `v` note view factors, `g` casual gain ctl, `d` domain flow,
C `h` heat transfer (comvective) methods, 'b' obstruction blocks,
C `-` zone names only.
C If there have been groups-of-zones defined also include these
C in the list (at the bottom).

      SUBROUTINE ASKMULTIZONE(INPIC,IVALS,prompt,title,mod,IER)
#include "building.h"
#include "model.h"
#include "geometry.h"
#include "schedule.h"
#include "epara.h"
#include "help.h"

      integer lnblnk  ! function definition

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      common/cfdfil/LCFD(MCOM),IFCFD(MCOM)

      LOGICAL XST,FOUND
      CHARACTER*(*) prompt,title

      DIMENSION VERT(35),IVALS(MCOM)
      DIMENSION GERT(32),IGVAL(32)  ! For groups.
      CHARACTER VERT*27,gert*20,KEY*1,prompt2*36
      character mod*1,outs*124,msg*96
      CHARACTER*72 LCFD

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_zone_multi'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Clear IVALS and INPICK.
      IER=0
      INPIC=0
      DO 40 I=1,NCOMP
        IVALS(I)=0
   40 CONTINUE

C Makeup list of zone groups.
      if(nzgroup.gt.0)then
        do i=1,nzgroup
          CALL EMKEY(i,KEY,IER)
          write(gert(i),'(a,1x,a)')KEY,zglbl(i)(1:lnblnk(zglbl(i)))
        enddo
      endif

C Initialise zone menu variables based on window size.
C IVERT is the menu position, MVERT the current number of menu lines.
      MHEAD=0
      if(nzgroup.gt.0)then
        MCTL=4
      else
        MCTL=3
      endif
      ILEN=NCOMP
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Build up text strings for the menu.
    3 M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          if(mod.eq.'-')then
            WRITE(VERT(M),'(a1,1x,a)')KEY,zname(L)
          elseif(mod.eq.'c')then
            if(LTHRM(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LTHRM(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'o')then

C Check for operations files. For each one that exists, scan to see
C if it has been sorted and notify user.
            if(LPROJ(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LPROJ(L),XST)
              if(XST)then
                IUO=IFIL+1
                CALL ERPFREE(IUO,ISTAT)
                CALL EROPER(0,iuout,IUO,L,IER)
                if(ip3ver(L).eq.0)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (older)'
                  write(outs,'(3a)') 'Operations for ',zname(L),
     &              'needs update (periods unsorted).'
                  call edisp(iuout,outs)
                elseif(ip3ver(L).eq.1)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (defined v1)'
                elseif(ip3ver(L).eq.2)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (defined v2)'
                elseif(ip3ver(L).gt.2)then
                  WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &              ' (definedv2+)'
                endif
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'s')then

C Check for existing shading files.
            if(LSHAD(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LSHAD(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'b')then

C Check for existing obstruction block files.
            if(ZOBS(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(ZOBS(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'v')then

C Check for existing viewfactor files.
            if(LVIEW(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LVIEW(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'g')then

C Check for casual gain control files.
            if(LCGCIN(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LCGCIN(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'d')then

C Check for CFD domain files.
            if(LCFD(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LCFD(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          elseif(mod.eq.'h')then

C Check for heat transfer regime files.
            if(LHCCO(L)(1:7).eq.'UNKNOWN')then
              WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (undefined)'
            else
              call FINDFIL(LHCCO(L),XST)
              if(XST)then
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),' (defined)'
              else
                WRITE(VERT(M),'(a1,1x,a,a)')KEY,zname(L),
     &            ' (not found)'
              endif
            endif
          endif
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text and info on portion seen.
      IF(IPFLG.EQ.0)THEN
        VERT(M+1)=  '  ____________________  '
      ELSE
        WRITE(VERT(M+1),15)IPM,MPM
   15   FORMAT ('0 page part: ',I1,' -- of:',I1)
      ENDIF

C If groups defined.
      if(nzgroup.gt.0)then
        VERT(M+2)  ='! via group-of-zones    '
        VERT(M+3)  ='? help                  '
        VERT(M+4)  ='- exit menu             '
      else
        VERT(M+2)  ='? help                  '
        VERT(M+3)  ='- exit menu             '
      endif
      write(prompt2,'(a)') 'Select one or more...'

C Instantiate help message for this menu.
      if(mod.eq.'-')then
        helptopic='ask_zone_mod-'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'c')then
        helptopic='ask_zone_modc'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'o')then
        helptopic='ask_zone_modo'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'s')then
        helptopic='ask_zone_mods'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'v')then
        helptopic='ask_zone_modv'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'g')then
        helptopic='ask_zone_modg'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'d')then
        helptopic='ask_zone_modg'
        call gethelptext(helpinsub,helptopic,nbhelp)
      elseif(mod.eq.'h')then
        helptopic='ask_zone_modh'
        call gethelptext(helpinsub,helptopic,nbhelp)
      endif

C Display the menu.
      call usrmsg(PROMPT,PROMPT2,'-')
      CALL EMENU(title,VERT,MVERT,IVERT)
      IF(IVERT.LE.MHEAD)THEN
        IVERT=-1
        goto 3
      ELSEIF(IVERT.EQ.MVERT)THEN

        RETURN
      ELSEIF(IVERT.EQ.(MVERT-1))THEN

C Display help text.
        CALL PHELPD('zone files section',4,'-',0,0,IER)
      ELSEIF(IVERT.EQ.(MVERT-2).AND.nzgroup.gt.0)THEN

C Display a list of groups. Allow uset to select.
        INPIC=1
        CALL EPICKS(INPIC,IGVAL,' ','Available groups:',
     &    16,nzgroup,zglbl,'group list',IER,1)
        write(msg,'(a,i2,a)') 'Includes ',izgnumber(IGVAL(1)),
     &    'zones.'
        call edisp(iuout,msg)
        if(IGVAL(1).gt.0)then
          INPIC=0; limit=izgnumber(IGVAL(1))
          do j=1,limit
            INPIC=INPIC+1
            IVALS(INPIC)=izglist(IGVAL(1),j)
            write(outs,*) 'including ',zname(IVALS(INPIC))
            call edisp(iuout,outs)
          enddo
          return
        endif
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Look through previous selections and see if IFOC is unique, if
C so update IVALS and loop back for another.
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        FOUND=.FALSE.
        IF(INPIC.GT.0)THEN
          DO 44 J=1,INPIC
            IF(IVALS(J).EQ.IFOC.or.FOUND) then
              FOUND=.TRUE.
              if (J+1.gt.NCOMP) then
                IVALS(J)=0
              else
                IVALS(J)=IVALS(J+1)
              endif
            endif
  44      CONTINUE
          IF(.NOT.FOUND)THEN
            if (INPIC.lt.NCOMP) then
              INPIC=INPIC+1
              IVALS(INPIC)=IFOC
              write(outs,*) 'added ',vert(ivert)(2:lnblnk(vert(ivert)))
              call edisp(iuout,outs)
            endif
          ELSE
            INPIC=INPIC-1
            write(outs,*) 'removed ',
     &        vert(ivert)(2:lnblnk(vert(ivert)))
            call edisp(iuout,outs)
          ENDIF
        ELSEIF(INPIC.EQ.0)THEN
          INPIC=1
          IVALS(INPIC)=IFOC
          write(outs,*) 'added ',vert(ivert)(2:lnblnk(vert(ivert)))
          call edisp(iuout,outs)
        ENDIF
      endif

      IF(IVERT.EQ.(MVERT-3))THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      else

C Not one of the legal menu choices.
        IVERT=-1
        goto 92
      endif
      IVERT=-2
      goto 3

      END

C ******************** EASKSUR ********************
C Presents a list of surfaces in a zone IZONE returning the
C index IS. It assumes that a geometry file has been read in.
C If MOD = '-' name list only, MOD = 'M' attribute Many, MOD = 'A'
C show attributes in list, MOD = 'U' as 'A' but also include SUSE,
C MOD = 'V' as 'M' but also include SUSE.

      SUBROUTINE EASKSUR(IZONE,IS,MOD,PROMPT1,PROMPT2,IER)
#include "building.h"
#include "geometry.h"
#include "epara.h"
#include "help.h"

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      integer ifs,itfs,imfs
      COMMON/GFONT/IFS,ITFS,IMFS

      DIMENSION VERT(35),VERTS(35),VERTU(35)

      CHARACTER*(*) PROMPT1,PROMPT2
      CHARACTER KEY*1,MOD*1,title*29
      CHARACTER VERT*32,VERTS*44,VERTU*56
      character sbound_ty*12,sbound_c2*6,sbound_e2*6
      LOGICAL SEL
      integer loopstart,loopend,i,icc   ! for looping
      logical usesbasesimp

      IER=0
      IF(IZONE.GT.NCOMP.OR.IZONE.EQ.0)THEN
        CALL USRMSG(' ',' Zone number out of range!','W')
        IER=1
        RETURN
      ENDIF

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_surface'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Initialise surface menu variables based on window size.
C IVERT is the menu position, MVERT the current number of menu lines.
      SEL=.FALSE.
      if(MOD.eq.'-')then
        write(title,'(2a)')' Surfaces in ',
     &    zname(IZONE)(1:lnzname(IZONE))
        MHEAD=1
        VERT(1)= '  Name         Composition'
      elseif(MOD.eq.'M')then
        write(title,'(2a)')'  Surfaces in ',
     &    zname(IZONE)(1:lnzname(IZONE))
        MHEAD=1
        VERTS(1)='  Name         Composition     Facing'
      elseif(MOD.eq.'A')then
        write(title,'(2a)')'  Surfaces in ',
     &    zname(IZONE)(1:lnzname(IZONE))
        MHEAD=1
        VERTS(1)='  Name         Composition     Facing'
      elseif(MOD.eq.'U')then
        write(title,'(2a)')'  Surfaces in ',
     &    zname(IZONE)(1:lnzname(IZONE))
        MHEAD=1
        VERTU(1)='  Name         Composition     Facing       USE'
      elseif(MOD.eq.'V')then
        write(title,'(2a)')'  Surfaces in ',
     &    zname(IZONE)(1:lnzname(IZONE))
        MHEAD=1
        VERTU(1)='  Name         Composition     Facing       USE'
      endif
      MCTL=4
      ILEN=NZSUR(IZONE)
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Loop through the items until the page to be displayed. M is the
C current menu line index. Build up text strings for the menu.
    3 M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          icc=IZSTOCN(izone,L)
          if(icc.lt.1)then
            continue
          else
            lnn=lnblnk(SNAME(izone,L))
            lnsmlcn=lnblnk(SMLCN(izone,L))
            if((lnn+lnsmlcn+3).lt.32)then
              continue
            elseif((lnn+lnsmlcn).lt.32)then
              lnsmlcn=lnsmlcn-3
            elseif((lnn+16).lt.32)then
              lnsmlcn=16
            endif
            if(MOD.eq.'-')then
              WRITE(VERT(M),14)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn)
   14         FORMAT(A1,1X,A,1X,A)
            endif
          endif

C Display surface name plus some context information.
          if(icc.gt.0)then
            lnn=lnblnk(SNAME(izone,L))
            call decode_zsbound(izone,L,sbound_ty,sbound_c2,sbound_e2)
            if(lnn.lt.8) lnn=8
            lnsmlcn=lnblnk(SMLCN(izone,L))
            if(lnsmlcn.lt.10) lnsmlcn=10
            if(lnsmlcn.gt.20)then
              lnsmlcn20=20
            else
              lnsmlcn20=lnsmlcn
            endif
            lnoth=lnblnk(sbound_ty)
            lnu=lnblnk(SUSE(izone,L,1))
            lnu2=lnblnk(SUSE(izone,L,2))
            lnu3=lnu2
            if(lnu3.gt.6) lnu3=6
            if((lnn+lnsmlcn+lnoth).lt.38)then
              WRITE(VERTS(M),13)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn),sbound_ty(1:lnoth)
            elseif((lnn+lnsmlcn20+lnoth).lt.38)then
              WRITE(VERTS(M),13)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn20),sbound_ty(1:lnoth)
            else
              WRITE(VERTS(M),13)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:17),sbound_ty(1:lnoth)
            endif
   13       FORMAT(A,1X,A,2X,A,2X,A)
   15       FORMAT(A,1X,A,2X,A,2X,A,3X,A)
   17       FORMAT(A,1X,A,2X,A,2X,A,3X,A,1X,A)
            if((lnn+lnsmlcn+lnoth+lnu+lnu2).lt.46)then
              WRITE(VERTU(M),17)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn),sbound_ty(1:lnoth),
     &          SUSE(izone,L,1)(1:lnu),SUSE(izone,L,2)(1:lnu2)
            elseif((lnn+lnsmlcn+lnoth+lnu+lnu3).lt.46)then
              WRITE(VERTU(M),17)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn),sbound_ty(1:lnoth),
     &          SUSE(izone,L,1)(1:lnu),SUSE(izone,L,2)(1:lnu3)
            elseif((lnn+lnsmlcn+lnoth+lnu).lt.48)then
              WRITE(VERTU(M),15)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn),sbound_ty(1:lnoth),
     &          SUSE(izone,L,1)(1:lnu)
            elseif((lnn+lnsmlcn20+lnoth+lnu).lt.48)then
              WRITE(VERTU(M),15)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:lnsmlcn20),sbound_ty(1:lnoth),
     &          SUSE(izone,L,1)(1:lnu)
            else
              WRITE(VERTU(M),15)KEY,SNAME(izone,L)(1:lnn),
     &          SMLCN(izone,L)(1:17),sbound_ty(1:lnoth),
     &          SUSE(izone,L,1)(1:lnu)
            endif
          else
            WRITE(VERTS(M),'(2a)')KEY,' unresolved surface...'
            WRITE(VERTU(M),'(2a)')KEY,' unresolved surface...'
          endif
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.
      IF(IPFLG.EQ.0)THEN
        VERT(M+1) ='  _________________  '
        VERTS(M+1)='  _________________________  '
        VERTU(M+1)='  _____________________________  '
      ELSE
        WRITE(VERT(M+1),16)IPM,MPM
        WRITE(VERTS(M+1),16)IPM,MPM
        WRITE(VERTU(M+1),16)IPM,MPM
   16   FORMAT ('0 page --- part: ',I2,' of ',I2)
      ENDIF

C If MOD has been passed as a M then return -2 to indicate further processing
      IF(MOD.EQ.'M'.OR.MOD.EQ.'m')THEN
        VERTS(M+2)='* attribute many    '
      ELSEIF(MOD.EQ.'V'.OR.MOD.EQ.'v')THEN
        VERTU(M+2)='* attribute many    '
      ELSE
        VERT(M+2) ='                    '
        VERTS(M+2)='                    '
        VERTU(M+2)='                    '
      ENDIF
      VERT(M+3)   ='? help              '
      VERTS(M+3)  ='? help              '
      VERTU(M+3)  ='? help              '
      VERT(M+4)   ='- exit menu         '
      VERTS(M+4)  ='- exit menu         '
      VERTU(M+4)  ='- exit menu         '

C Display the menu.
      call usrmsg(PROMPT1,PROMPT2,'-')
      if(MOD.eq.'-')then
        CALL EMENU(title,VERT,MVERT,IVERT)
      elseif(MOD.EQ.'M'.OR.MOD.EQ.'m')then
        CALL EMENU(title,VERTS,MVERT,IVERT)
      elseif(MOD.EQ.'A'.OR.MOD.EQ.'a')then
        CALL EMENU(title,VERTS,MVERT,IVERT)
      elseif(MOD.EQ.'U'.OR.MOD.EQ.'u')then
        CALL EMENU(title,VERTU,MVERT,IVERT)
      elseif(MOD.EQ.'V'.OR.MOD.EQ.'v')then
        CALL EMENU(title,VERTU,MVERT,IVERT)
      endif
      IF(IVERT.LE.MHEAD)THEN
        IVERT=-1
        goto 3
      ELSEIF(IVERT.EQ.MVERT)THEN

C If no selection has been made before exit then return with 0.
        IF(.NOT.SEL)IS=0

C Checks the surfaces in the current zone to see if any of the surface
C attributes are 'BASESIMP'.  If there are any then present the
C BASESIMP editing facility (once).
        usesbasesimp=.false.   ! assume no basesimp attributed surfaces
        loopstart=1
        loopend=NZSUR(IZONE)
        DO i=loopstart,loopend
          icc=IZSTOCN(izone,i)
          IF(zboundarytype(izone,i,1).EQ.6)THEN
            usesbasesimp=.true.
          END IF
        END DO
        if(usesbasesimp)then
          CALL BASESIMP_INPUTS(IZONE,IER)
        endif
        RETURN  ! return to the parent call

      ELSEIF(IVERT.EQ.(MVERT-1))THEN
        CALL PHELPD('zone geom file section',3,'-',0,0,IER)
      ELSEIF(IVERT.EQ.(MVERT-2))THEN

C Allow user to say several to be attributed.
        IF(MOD.EQ.'M'.OR.MOD.EQ.'m'.or.
     &     MOD.EQ.'V'.OR.MOD.EQ.'v')THEN
          IS= -2
          call usrmsg(' ',' ','-')
          RETURN
        ELSE
          IVERT=-1
          goto 3
        ENDIF
      ELSEIF(IVERT.EQ.(MVERT-3))THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Decode from the potential long list to the zone number via KEYIND.
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        SEL=.TRUE.
        IS=IFOC
        call usrmsg(' ',' ','-')
        RETURN
      ELSE
C Not one of the legal menu choices.
        IVERT=-1
        goto 92
      ENDIF
      IVERT=-2
      goto 3

      END

C ******************** EASKMSUR ********************
C Presents a list of surfaces in a zone IZONE returning array
C of surface indices ISLIST. It assumes that a geometry file has been read in.
C Designed to show attributes in list.

      SUBROUTINE EASKMSUR(IZONE,INPICK,ISLIST,PROMPT1,PROMPT2,IER)
#include "building.h"
#include "geometry.h"
#include "epara.h"
#include "help.h"

      common/OUTIN/IUOUT,IUIN,IEOUT
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      DIMENSION VERTS(35)
      DIMENSION ISLIST(MS)    ! selected surface
      DIMENSION ISCNLIST(MCON)! selected surface connection

      CHARACTER*(*) PROMPT1,PROMPT2
      CHARACTER VERTS*44,KEY*1,title*29,outs*124
      character sbound_ty*12,sbound_c2*6,sbound_e2*6
      LOGICAL SEL
      integer i,j,icc   ! for looping

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_m_surface'
      call gethelptext(helpinsub,helptopic,nbhelp)

      IER=0
      IF(IZONE.GT.NCOMP.OR.IZONE.EQ.0)THEN
        CALL USRMSG(' ',' Zone number out of range!','W')
        IER=1
        RETURN
      ENDIF
      INPICK=0
      DO I=1,MS
        ISLIST(I)=0
      ENDDO
      DO I=1,MCON
        ISCNLIST(I)=0
      ENDDO

C Initialise surface menu variables based on window size.
C IVERT is the menu position, MVERT the current number of menu lines.
      SEL=.FALSE.
      write(title,'(2a)')'  Surfaces in ',
     &  zname(IZONE)(1:lnzname(IZONE))
      MHEAD=1
      VERTS(1)='  Name         Composition   Facing'
      MCTL=3
      ILEN=NZSUR(IZONE)
      IPACT=CREATE
      CALL EKPAGE(IPACT)

C Initial menu entry setup.
   92 IER=0
      IVERT=-3

C Loop through the items until the page to be displayed. M is the
C current menu line index. Build up text strings for the menu.
    3 M=MHEAD
      DO 10 L=1,ILEN
        IF(L.GE.IST.AND.(L.LE.(IST+MIFULL)))THEN
          M=M+1
          CALL EMKEY(L,KEY,IER)
          icc=IZSTOCN(izone,L)
          if(icc.lt.1)then
            continue
          else
            lnsmlcn=lnblnk(SMLCN(izone,L))
            if(lnsmlcn.gt.16) lnsmlcn=16
          endif

          if(icc.gt.0)then
            call decode_zsbound(izone,L,sbound_ty,sbound_c2,sbound_e2)
            lnn=lnblnk(SNAME(izone,L))
            if(lnn.lt.8) lnn=8
            lnsmlcn=lnblnk(SMLCN(izone,L))
            if(lnsmlcn.lt.10) lnsmlcn=10
            lnoth=lnblnk(sbound_ty)
            if((lnn+lnsmlcn+lnoth).lt.36)then
              if(ISCNLIST(icc).eq.0)then
                WRITE(VERTS(M),'(7a)')KEY,'  ',SNAME(izone,L)(1:lnn),
     &            '  ',SMLCN(izone,L)(1:lnsmlcn),'  ',
     &            sbound_ty(1:lnoth)
              else
                WRITE(VERTS(M),'(8a)')KEY,'  ',SNAME(izone,L)(1:lnn),
     &            '  ',SMLCN(izone,L)(1:lnsmlcn),'  ',
     &             sbound_ty(1:lnoth),' *'
              endif
            else
              if(ISCNLIST(icc).eq.0)then
                lnoth=36-(lnn+15+7+1)
                WRITE(VERTS(M),'(7a)')KEY,'  ',SNAME(izone,L)(1:lnn),
     &            '  ',SMLCN(izone,L)(1:15),'  ',
     &            sbound_ty(1:lnoth)
              else
                lnoth=36-(lnn+15+9+1)
                WRITE(VERTS(M),'(8a)')KEY,'  ',SNAME(izone,L)(1:lnn),
     &            '  ',SMLCN(izone,L)(1:15),'  ',
     &            sbound_ty(1:lnoth),' *'
              endif
            endif
          else
            WRITE(VERTS(M),'(2a)')KEY,' unresolved surface...'
          endif
        ENDIF
   10 CONTINUE

C Number of actual items displayed.
      MVERT=M+MCTL

C If a long list include page facility text.
      IF(IPFLG.EQ.0)THEN
        VERTS(M+1)='  _________________________  '
      ELSE
        WRITE(VERTS(M+1),16)IPM,MPM
   16   FORMAT ('0 page --- part: ',I2,' of ',I2)
      ENDIF

      VERTS(M+2)  ='? help              '
      VERTS(M+3)  ='- exit menu         '

C Display the menu.
      call usrmsg(PROMPT1,PROMPT2,'-')
      CALL EMENU(title,VERTS,MVERT,IVERT)
      IF(IVERT.LE.MHEAD)THEN
        IVERT=-1
        goto 3
      ELSEIF(IVERT.EQ.MVERT)THEN

C If no selection has been made before exit then return with 0.
        IF(.NOT.SEL)INPICK=0
        call usrmsg(' ',' ','-')
C       write(6,*)'ivlist',(ISLIST(J),J=1,10)
        RETURN  ! return to the parent call
      ELSEIF(IVERT.EQ.(MVERT-1))THEN
        CALL PHELPD('zone geom mul surf section',3,'-',0,0,IER)
      ELSEIF(IVERT.EQ.(MVERT-2))THEN

C If there are enough items allow paging control via EKPAGE.
        IF(IPFLG.EQ.1)THEN
          IPACT=EDIT
          CALL EKPAGE(IPACT)
        ENDIF
      ELSEIF(IVERT.GT.MHEAD.AND.IVERT.LT.(MVERT-MCTL+1))THEN

C Decode from the potential long list to the zone number via KEYIND.
        if(INPICK.ge.9)then
          call edisp(iuout,
     &      'Only 8 surfaces can be acted upon.')
          IVERT=-2
          goto 3
        endif
        CALL KEYIND(MVERT,IVERT,IFOC,IO)
        iccc=IZSTOCN(izone,IFOC)  ! get which connection
        if(ISCNLIST(iccc).eq.1)then
          ISCNLIST(iccc)=0        ! mark to remove *
          do j=1,inpick
            if(ISLIST(j).eq.ifoc) ISLIST(j)=0
          enddo
          INPICK=INPICK-1         ! decrement
        else
          SEL=.TRUE.
          INPICK=INPICK+1
          ISLIST(INPICK)=IFOC
          iccc=IZSTOCN(izone,IFOC)  ! get which connection
          ISCNLIST(iccc)=1          ! mark for *
          lnn=lnblnk(SNAME(izone,IFOC))
          lnsmlcn=lnblnk(SMLCN(izone,IFOC))
          call decode_zsbound(izone,ifoc,sbound_ty,sbound_c2,sbound_e2)
          lnoth=lnblnk(sbound_ty)
          WRITE(outs,'(7a)')'Selected: ',SNAME(izone,IFOC)(1:lnn),
     &      '  ',SMLCN(izone,IFOC)(1:lnsmlcn),'  ',
     &      sbound_ty(1:lnoth),' to act on.'
          call edisp(iuout,outs)
        endif
      ELSE

C Not one of the legal menu choices.
        IVERT=-1
        goto 92
      ENDIF
      IVERT=-2
      goto 3

      END

C ******************** asksnode ********************
C Provides a selection list for the layers
C and nodes within a construction. Passed zone index (icomp)
C and surface index (IS) and returns layer index (ilay) and
C optionally the node index (inode). It assumes that relevant
C databases have been opened.

      subroutine asksnode(icomp,is,ilay,inode,ier)
#include "building.h"
#include "geometry.h"
#include "esprdbfile.h"
#include "material.h"
#include "help.h"

      common/OUTIN/IUOUT,IUIN,IEOUT
      
C Special materials file flag.
      DIMENSION PNAM(ME),item(ME+10)
      integer header,footer
      character item*32,NAM*72,PNAM*20,outs*124
      logical closemat1,closemat2  ! to check version of materials db.

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='ask_constr_node'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Check name of surface with construction name in MLC common.
      imatch=0
      call matchmlcdesc(SMLCN(icomp,is),imatch)
      if(imatch.eq.0) then
         call edisp(iuout,'Error: probably no construction defined!')
         ier=1
         return
      endif
      call eclose(matver,1.1,0.001,closemat1)  ! check materials version 1.1.
      call eclose(matver,1.2,0.001,closemat2)  ! check materials version 1.2.

C Write menu displaying a list of layer names.
      header=3
      footer=3
      write(item(1),'(a,a)') 'a surface name: ',SNAME(icomp,is)
      write(item(2),'(a,a)') 'c constr name: ',mlcname(imatch)(1:16)
      item(3)='  ----------------------------'
      do 10 j=1,LAYERS(imatch)

C Pick up the material name of each layer. Uses zero matarrayindex to signal gap.
        if(closemat1.or.closemat2)then
          matarrayindex=IPRMAT(imatch,j)
          if(matarrayindex.ne.0)then
            write(NAM,'(a)') matname(matarrayindex)(1:32)
            PNAM(j)=NAM(1:20)
          else
            write(NAM,'(a)') 'air '
            write(PNAM(j),'(a)') 'air '
          endif
        else
          write(PNAM(j),'(a)') 'unknown'
          call usrmsg('Materials are incomplete or not yet scanned.',
     &      'Please check your model materials file.','W')
        endif
        write(item(header+j),'(a,i2,1x,a)')' Layer: ',j,PNAM(j)
        ndisp=header+j
  10  continue
      item(ndisp+footer-2)='  ----------------------------'
      item(ndisp+footer-1)='? help  '
      item(ndisp+footer)  ='- exit menu'
      ino=-1
      nitms=ndisp+footer

  7   call emenu('Surface layers & nodes',item,nitms,ino)
      if(ino.gt.header.and.ino.le.ndisp) then

C Ask for the nodal location, first calculate a location at centre.
        nodloc=2*(ino-header)
        nodloca=nodloc-1
        nodlocb=nodloc+1
        nodlocd=nodloc
        call easki(nodloc,' Position material at ',' which node ? ',
     &    nodloca,'W',nodlocb,'W',nodlocd,'spm node',IERI,nbhelp)
        if(ieri.eq.-3)then
          ier=1
          return
        else
          ilay=ino-header
          inode=nodloc
          return
        endif
      elseif(ino.eq.ndisp+footer-1) then
        call phelpd('Special material',nbhelp,'-',0,0,IER)
        ino=-1
        goto 7
      elseif (ino.eq.ndisp+footer) then
        return
      elseif(ino.lt.0) then
        goto 7
      else
        goto 7
      endif

      return

      end

C ******************** SURADJ ********************
C Returns information about connections between surfaces (a updates version
C of MOFADJ).  Given IZONE & ISFN (the zone and surface under consideration),
C it returns the following information:

C IE: identifies the zone coupling index
C IE=-1: not yet defined
C IE=0 : external and both TMP=0.0/ISC=0
C IE=1 : internal to identical environment, both TMP=0.0/ISC=0
C IE=2 : internal to environment with temperature TMP.
C IE=3 : internal where IZC,ISC defines other zone & surface.
C IE=4 : ground connection, both TMP=0.0/ISC=0
C IE=5 : adiabatic, both TMP=0.0/ISC=0
C IE=6 : BASESIMP foundation
C IE=7 : CEN 13791 partition
C DESCR: descriptive string 25 characters wide
C IC   : connection number.
C TMP  : is IE2 (constant temperature if IE=2)

      SUBROUTINE SURADJ(IZONE,ISFN,IE,TMP,IZC,ISC,IC,DESCR)
#include "building.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/C3/IC1(MCON),IE1(MCON),ICT(MCON),IC2(MCON),IE2(MCON)
      integer IZSTOCN
      COMMON/C24/IZSTOCN(MCOM,MS)
      CHARACTER*25 DESCR
      character msg*72

      IE=0
      TMP=0.0
      IZC=0
      ISC=0
      IC=0

C Get match.
      if(izone.eq.0.or.isfn.eq.0)then
        write(msg,'(a,i3,a,i3)') 
     &    'SURADJ WARNING: zero input for zn',izone,' or surf ',
     &    isfn
        call edisp(iuout,msg)
        return
      endif
      I=IZSTOCN(IZONE,ISFN)
      if(I.eq.0)then
        write(msg,'(a,i3,a,i3)') 
     &    'SuRADJ WARNING: returned connection 0 for zn',izone,
     &    ' surf ',isfn
        call edisp(iuout,msg)
        return
      endif
      IC=I
      IE=ICT(I)

C Knowing IE establish TMP, IZC,ISC.
      IF(IE.EQ.3)THEN
        IZC=IC2(I)
        ISC=IE2(I)
        WRITE(DESCR,142)ISC,IZC
  142   FORMAT(' surface',I3,' in zone',I3)
      ELSEIF(IE.EQ.2)THEN
        TMP=IC2(I)
        WRITE(DESCR,143)TMP
  143   FORMAT(' a constant temp= ',F6.2)
      ELSEIF(IE.EQ.1)THEN
        if(IC2(I).eq.0.and.IE2(I).eq.0)then
          DESCR=' an identical environment'
        else
          DESCR=' a similar +- environment'
        endif
      ELSEIF(IE.EQ.0)THEN
        DESCR=' the outside             '
      ELSEIF(IE.EQ.-1)THEN
        DESCR=' not yet defined         '
      ELSEIF(IE.EQ.4)THEN
        DESCR=' the ground/month profile'
      ELSEIF(IE.EQ.5)THEN
        DESCR=' adiabatic               '
      ELSEIF(IE.EQ.6)THEN
        DESCR=' BASESIMP foundation     '
      ELSEIF(IE.EQ.7)THEN
        if(IC2(I).eq.0.and.IE2(I).eq.0)then
          DESCR=' an similar CEN 17391 env'
        else
          DESCR=' a similar CEN +- env    '
        endif
      ENDIF

      RETURN
      END

C ******************** FLNAME ********************
C Provides a name for a defined file type.

      SUBROUTINE FLNAME(ICOMP,FILENM,FLTYP,EXT,NHLP,IER)
#include "building.h"
#include "geometry.h"

      integer lnblnk  ! function definition

      COMMON/OUTIN/IUOUT,IUIN,IEOUT

      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

      LOGICAL XST
      CHARACTER FILENM*72,FLTYP*25,EXT*4
      CHARACTER*72 MSG1,TEXT,DFILE

      NUMCH=lnblnk(FILENM)
      IF(NUMCH.LE.0.OR.NUMCH.GE.72)THEN
        IF(ICOMP.GT.0.AND.ICOMP.LE.NCOMP)THEN
          WRITE(FILENM,'(A9,A,A4)')'../zones/',
     &      zname(ICOMP)(1:lnzname(ICOMP)),EXT
        ELSEIF(ICOMP.EQ.-1)THEN
          WRITE(FILENM,'(A15,A4)')'../zones/ground',EXT
        ELSE
          FILENM='file_name'
        ENDIF
      ENDIF
      CALL FINDFIL(FILENM,XST)
      IF(ICOMP.GT.0.AND.ICOMP.LE.NCOMP)THEN
        WRITE(DFILE,'(A9,A,A4)')'../zones/',
     &    zname(ICOMP)(1:lnzname(ICOMP)),EXT
      ELSEIF(ICOMP.EQ.-1)THEN
        WRITE(DFILE,'(A15,A4)')'../zones/ground',EXT
      ELSE
        DFILE='file_name'
      ENDIF
      if(FILENM(1:7).eq.'UNKNOWN'.or.FILENM(1:2).eq.'  ')FILENM=DFILE
      WRITE(MSG1,'(3a)')'  Enter the zone ',
     &  FLTYP(1:lnblnk(FLTYP)),' file name'
      CALL EASKS(FILENM,MSG1,' ',72,DFILE,
     &  FLTYP(1:lnblnk(FLTYP)),IER,NHLP)
      RETURN
      END

C ******************** ZSID ********************
C Returns compact descriptions of the zone:surface.
C ZSDES has no truncation, ZSDESC compacts to 20 char with minimum
C of truncation, ZSDESS has maximum risk of truncation.

      SUBROUTINE ZSID(IZ,IS,ZSDES,ZSDESC,ZSDESS)
#include "building.h"
#include "geometry.h"

      integer lnblnk  ! function definition

      CHARACTER ZSDES*28,ZSDESC*20,SST1*12,ZST1*12,ZSDESS*16

      ZSDESC=' '
      ZSDESS='  '
      ZSDES =' '
      if(iz.eq.0)then
        ZSDESC='-'
        ZSDESS='-'
        ZSDES ='-'
        return
      endif
      SST1=SNAME(iz,is)
      lsn0=lnblnk(SST1)
      lsn1=MIN0(lsn0,5)
      lsn2=MIN0(lsn0,9)
      lsn3=MIN0(lsn0,11)
      ZST1=zname(IZ)
      lzn0=lnblnk(ZST1)
      lzn1=MIN0(lsn0,6)
      lzn2=MIN0(lsn0,10)
      lzn3=MIN0(lsn0,12)
      if((lsn0+lzn0).lt.12)then
        WRITE(ZSDESS,'(a,a1,a)') SST1(1:lsn0),':',ZST1(1:lzn0)
      elseif((lsn1+lzn0).lt.12)then
        WRITE(ZSDESS,'(a,a1,a)') SST1(1:lsn1),':',ZST1(1:lzn0)
      elseif((lsn0+lzn1).lt.12)then
        WRITE(ZSDESS,'(a,a1,a)') SST1(1:lsn0),':',ZST1(1:lzn1)
      else
        WRITE(ZSDESS,'(a,a1,a)') SST1(1:lsn1),':',ZST1(1:lzn1)
      endif
      if((lsn0+lzn0).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn0),':',ZST1(1:lzn0)
      elseif((lsn2+lzn0).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn2),':',ZST1(1:lzn0)
      elseif((lsn0+lzn2).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn0),':',ZST1(1:lzn2)
      elseif((lsn2+lzn2).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn2),':',ZST1(1:lzn2)
      elseif((lsn2+lzn3).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn2),':',ZST1(1:lzn3)
      elseif((lsn3+lzn2).lt.20)then
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn3),':',ZST1(1:lzn2)
      else
        WRITE(ZSDESC,'(a,a1,a)') SST1(1:lsn2),':',ZST1(1:lzn2)
      endif
      WRITE(ZSDES,'(a,a1,a)') SST1(1:lnblnk(SST1)),':',
     &      ZST1(1:lnblnk(ZST1))

      RETURN
      END

C ******************** ZNARLIST ********************
C Takes number of items (inlist) in the array (list)
C of size (insize) and builds a descriptive string (zdescr)
C of character length (length) to be used in reports.
C Similar to code ZLIST in esrures/utils.F.

      SUBROUTINE ZNARLIST(inlist,list,insize,zdescr,length,ierr)
#include "building.h"
#include "geometry.h"

      dimension list(insize)
      CHARACTER zdescr*248,outs*248,outsd*248
      character t124*124
      logical unixok

      t124=' '
      length=0
      do 42 i=1,inlist
        lna=lnzname(list(i))
        length=length+lna+1
  42  continue
      if(length.lt.236)then
        WRITE(outs,5,iostat=ios,err=1)(zname(list(I)),I=1,inlist)
    5   FORMAT(' Zones: ',20(a,' '))
        call sdelim(outs,outsd,'S',IW)
        zdescr=outsd
        return
      else
        if(inlist.eq.1)then
         WRITE(ZDESCR,'(A,I3,2A)')' Zone (',list(1),') ',zname(list(1))
        elseif(inlist.gt.1)THEN

C If full names will not fit in zdescr then write out indices only.
C First try to use t124 string (so have room for zones label).
          ipos=1
          call ailist(ipos,inlist,list,MCOM,'C',t124,loutlen,itrunc)
          if(itrunc.eq.0)then
            WRITE(ZDESCR,'(2a)')' Zones: ',t124(1:loutlen)
          else
            call ailist(ipos,inlist,list,MCOM,'C',outs,loutlen,itrunc)
            WRITE(ZDESCR,'(2a)')' Zones: ',outs(1:loutlen)
          endif
        endif
        return
      endif

C Trap for I/O errors.
   1  call isunix(unixok)
      if(unixok)then
        if(IOS.eq.2)then
          write(6,*)'ZARLIST: no permission to write zone names: ',outs
        else
          write(6,*)'ZARLIST: error writing zone names: ',outs
        endif
      endif
      ierr=1
      return
      END

C ******************** discovercfg ********************
C Provides a list of model cfg files within a passed
C folder and returns full path of selected in sfile. If user did
C not select ier is -1, if there were no matching files ier is -2
C and ier = 1 was an error in composition.

      subroutine discovercfg(subpath,sfile,ier)
#include "espriou.h"
#include "building.h"
#include "model.h"
#include "help.h"

      common/SPAD/MMOD,LIMIT,LIMTTY
      character subpath*84 ! folder to scan for cfg
      character sfile*144  ! full path of cfg file name selected

C Local variables.
      character action*3,fs*1
      character outs*124,t144*144
      logical unixok

      common/OUTIN/IUOUT,IUIN,IEOUT

      integer nboflistf  ! how many folders or file names passed
      integer listfoldertype   ! zero if unused one if folder two if file
      integer lenlistfolder    ! width of each string
      character*72 listfolder  ! array of folder or file names
      common/listfold/nboflistf,listfoldertype(MFFOLD),
     &                lenlistfolder(MFFOLD),listfolder(MFFOLD)

      dimension ivlist(MFFOLD)
      character*70 listfc70(MFFOLD)
      character*70 listfc70s(MFFOLD)
      character*72 listfolders(MFFOLD)  ! for sorted
      integer lenlistfolders(MFFOLD)    ! for sorted

#ifdef OSI
      integer nnlistf  ! for use with getfileslist
#else
      integer*8 nnlistf
#endif

      helpinsub='esru_misc'  ! set for subroutine
      helptopic='cfg_discover'
      call gethelptext(helpinsub,helptopic,nbhelp)

C Echo search criteria.
      if(MMOD.EQ.8)then
        continue
      else
        write(outs,*,IOSTAT=ios,ERR=16) 'models in folder ',subpath
        call edisp(iuout,outs)
      endif

C Re-establish action and file separator prior to call to getfileslist.
      action='cfg'
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif
      call getfileslist(subpath,action,nnlistf)
      nlistf=int(nnlistf)
      if(MMOD.EQ.8)then
        continue
      else
        call printfileslist(outs,'p')
      endif

C Try to use information gathered from file scan.
      if(nlistf.gt.0)then
        ix=1
        do 76 ij=1,nlistf
          listfc70(ij)=' '
          lex=lenlistfolder(ij)
          if(lex.gt.70) lex=70
          if(lex.le.1)then
            write(listfc70(ij),'(a)') '  '
          else
            write(listfc70(ij),'(a)') listfolder(ij)(1:lex)
          endif
          if(lex.gt.maxw) maxw=lex  ! ensure widest string can be displayed
  76    continue
        if(maxw.gt.70) maxw=70  ! ensure list fits
        if(maxw.lt.15) maxw=15  ! ensure title can be seen

C Sort both file name lists.
        do ij=1,nlistf
          listfc70s(ij)=listfc70(ij)
          listfolders(ij)=listfolder(ij)
        enddo
        call SORTSTRA(listfc70s,nlistf)
        call SORTSTRA(listfolders,nlistf)
        do ij=1,nlistf
C          write(6,*) ij,' ',listfc70s(ij)
          lenlistfolders(ij)=lnblnk(listfolders(ij))
        enddo

C Select from the list. If prj was started in model cfg folder
C (pwdtocfg = !) write with pwdinitial, otherwise also include
C the pwdtocfg part of the path.
        CALL EPICKS(IX,ivlist,outs,' ',
     &    maxw,nboflistf,listfc70s,'Available models',IER,nbhelp)
        if(ix.eq.1)then
          if(pwdtocfg(1:1).eq.'!')then
            write(sfile,'(3a)',IOSTAT=ios,ERR=17)
     &        pwdinitial(1:lnpwdi),fs,
     &        listfolders(ivlist(ix))(1:lenlistfolders(ivlist(ix)))
          else
            write(sfile,'(5a)',IOSTAT=ios,ERR=17)
     &        pwdinitial(1:lnpwdi),fs,pwdtocfg(1:lnpwdc),fs,
     &        listfolders(ivlist(ix))(1:lenlistfolders(ivlist(ix)))
          endif
        else
          sfile='UNKNOWN'
          ier=-1   ! user did not select
        endif
      else
        sfile='UNKNOWN'
        ier=-2   ! no matching files found
      endif

      return

C Error conditions.
   16 if(IOS.eq.2)then
        CALL USRMSG('No permission to write outs',outs,'W')
      else
        CALL USRMSG('String write error in outs',outs,'W')
      endif
      IER=1
      return
   17 if(IOS.eq.2)then
        CALL LUSRMSG('No permission to write sfile',sfile,'W')
      else
        CALL LUSRMSG('String write error in sfile',sfile,'W')
      endif
      IER=1
      return
      end

C ******************** FDPWDTOCFG ********************
C Given a file name (fstring) and using the current value
C of pwdinitial (if applications have established this via a
C call usrdir(pwdinitial) as they start) then this checks if fstring
C contains a (pwdtocfg) and a file name (filen). Begins with similar
C logic to fdroot from esru_lib.F and filen should be the same as
C the file name returned in fdroot.
C Updates the common block variable pwdtocfg.
C Ppath is returned for information purposes << consider removing >>

      SUBROUTINE fdpwdtocfg(fstring,ppath,filen)
#include "espriou.h"
#include "building.h"
#include "model.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      character*(*) ppath,filen,fstring
      character fs*1
      character testpwdtocfg*72
      logical unixok
      integer ilbfstr   ! last actual char in fstring
      integer ipos      ! the leftward moving character position
      integer ilstr     ! declaired length of fstring
      integer ilenfilen ! declaired length of filen to be returned
      integer ilenpath  ! declaired length of path to be returned

C Set fileseparator depending on OS.
      call isunix(unixok)
      if(unixok)then
        fs = char(47)
      else
        fs = char(92)
      endif

C Clear variables and get string lengths.
      filen = ' '
      ilbfstr = lnblnk(fstring)
      ipos = ilbfstr
      ilstr = LEN(fstring)
      ilenfilen = LEN(filen)
      ilenpath = LEN(ppath)

C Loop backwards from last non-blank character until a separator is found.
 344  continue
      ipos=ipos-1
      if(fstring(ipos:ipos).eq.fs)then
        filen = ' '
        write(filen,'(a)',IOSTAT=IOS,ERR=1) fstring(ipos+1:ilbfstr)
        ppath = ' '
        if(ipos.gt.ilenpath)then
          write(ppath,'(a)',IOSTAT=IOS,ERR=1) fstring(1:ilenpath)
        else
          write(ppath,'(a)',IOSTAT=IOS,ERR=1) fstring(1:ipos)
        endif
        continue
      elseif(fstring(ipos:ipos).eq.'/')then
        filen = ' '
        write(filen,'(a)',IOSTAT=IOS,ERR=1) fstring(ipos+1:ilbfstr)
        ppath = ' '
        if(ipos.gt.ilenpath)then
          write(ppath,'(a)',IOSTAT=IOS,ERR=1) fstring(1:ilenpath)
        else
          write(ppath,'(a)',IOSTAT=IOS,ERR=1) fstring(1:ipos)
        endif
        continue
      else

C Arrived at the first character. There have been no file separators
C so filen is fstring (truncated if necessary) and the path becomes
C the equivalent of where-i-am-now.
        if(ipos.eq.1)then
          if(ilstr.ge.ilenfilen)then
            filen = ' '
            write(filen,'(a)',IOSTAT=IOS,ERR=1)fstring(1:ilenfilen)
            write(ppath,'(a1,a1)',IOSTAT=IOS,ERR=1) '.',fs
            continue
          elseif(ilstr.lt.ilenfilen)then
            write(filen,'(a)')fstring(1:lnblnk(fstring))
            write(ppath,'(a1,a1)',IOSTAT=IOS,ERR=1) '.',fs
            continue
          endif
        elseif(ipos.gt.1)then
          goto 344   ! read some more
        endif
      endif

C Now see about comparing pwdinitial with the initial portion of
C ppath to derive pwdtocfg. Start at left and work to the end of
C pwdinitial looking for the same characters.
      loop=0
  345 continue
      loop=loop+1
      if(ppath(loop:loop).eq.pwdinitial(loop:loop))then
        if(loop.lt.lnpwdi) goto 345
        if(loop.eq.lnpwdi.and.ipos.gt.lnpwdi)then
          write(pwdtocfg,'(a)') ppath(loop+1:ipos)
          lnpwdc=lnblnk(pwdtocfg)

        elseif(loop.eq.lnpwdi.and.ipos.eq.lnpwdi)then
          write(pwdtocfg,'(a)') '!'
        endif
        return
      else
C << not sure >>
      endif

      return

   1  if(IOS.eq.2)then
        call edisp(iuout,
     &  'fdpwdtocfg: permission error composing path or file.')
        call edisp(iuout,fstring)
      else
        call edisp(iuout,
     &    'fdpwdtocfg: error composing path or file from string.')
        call edisp(iuout,fstring)
      endif
      return
      end


C ******************** DeallocateAllArrays ********************
C Deallocates all the memory asociated with allocatable arrays.

      SUBROUTINE DeallocateAllArrays

      USE AIM2, ONLY:AIM2_DEALLOCATE

      IMPLICIT NONE

      CALL AIM2_DEALLOCATE

      END SUBROUTINE DeallocateAllArrays


C ******************** dintervalf ********************
C Fortran implementation of the c surboutine dinterval.

      subroutine dintervalf(v1,v2,dv,ndec,mode)

      real v1,v2,dv
      integer ndec,mode
C When 'mode'=1 the hour interval on the graphical time (x-axis) is
C set as follow:
C v=v2-v1 for v < 12 dv=1, v < 18 dv=2, v < 24 dv=3
C             v < 48 dv=6, v < 96 dv=12 else dv=24.
C Should be the same logic as in esru_x.c.
      real v,dvv,x,w
      integer ix
      logical close10,close5,close3,close2,close1
      if(mode.eq.0)then
        vv = v2 - v1
        v = abs(vv)
        x = log10(v)
        ix = nint(x)
        if (x.lt.0.0) ix=ix-2
        dx = real(ix)

        dz = 10.0**dx
        vr =  v / dz
        w = 10.0
        if (vr.lt.5.0) w = 5.0
        if (vr.lt.3.0) w = 3.0
        if (vr.lt.2.0) w = 2.0
        if (vr.lt.1.0) w = 1.0
C        if (vr.lt.0.5) w = 0.5

        dvv = w * 0.1 * dz
        if (vv.lt.0.0) dvv = -dvv
        call eclose(w,10.0,0.01,close10)
        call eclose(w,5.0,0.01,close5)
        call eclose(w,3.0,0.01,close3)
        call eclose(w,2.0,0.01,close2)
        call eclose(w,1.0,0.01,close1)

        nd = 1 - ix
        if(close10)nd=nd-1
        if(close5)nd=1
        if(close3)nd=1
        if(close2)nd=1
        if(close1)nd=2
C        if (w.eq.10.0)then
C          nd=nd-1
C        elseif (w.eq.5.0)then
C          nd = 1
C        elseif (w.eq.3.0)then
C          nd = 1
C        elseif (w.eq.2.0)then
C          nd = 1
C        elseif (w.eq.1.0)then
C          nd = 2
C        elseif (w.eq.0.5)then
C          nd = 1
C        endif
        if (nd.lt.0) nd = 0
      else
        v = v2 - v1
        dvv = 168.0
        if (v.lt.4320.0) dvv = 48.0
        if (v.lt.1440.0) dvv = 24.0
        if (v.lt.338.0) dvv = 12.0
        if (v.lt.122.0) dvv = 8.0
        if (v.lt.50.0) dvv = 4.0
        if (v.lt.26.0) dvv = 3.0
        if (v.lt.20.0) dvv = 2.0
        if (v.lt.14.0) dvv = 1.0
        nd = 0
      endif
      dv = dvv
      ndec = nd
      return
      end


C ******************** align_comment ********************
C Add comment after a specific column and return formatted line.

      subroutine align_comment(icolumn,string,comment,aligned_str)

      integer lnblnk
      integer icolumn              ! Column to start comment.
      character*(*) string         ! Data or token string.
      character*(*) comment        ! Comment string.
      character*(*) aligned_str    ! Composed string.
      character*56  hash_str       ! Filler string to be created.
      integer lnstring,lncomment   ! Length of strings.
      integer lnprehash            ! Blanks before hash

C If lnstring is less than icolumn create hash_str to fill in the gap.
C Otherwise if lnstring is greater than icolumn the hash_str is '  # '
      lnstring=lnblnk(string)
      lncomment=lnblnk(comment)
      if(lnstring.lt.(icolumn-3))then
        lnprehash=(icolumn-lnstring)+1
        hash_str='                                               '
        write(hash_str(lnprehash:lnprehash),'(a)') '#' 
      else
        lnprehash=3
        write(hash_str,'(a)') '  # '
      endif
      write(aligned_str,'(3a)') string(1:lnstring),
     &  hash_str(1:lnprehash+1),comment(1:lncomment)
      return
      end

C ******************** ZNALIST ********************
C Takes array of zone indices and builds a descriptive
C string (124 char) to be used in headers. 
C Currently only deals with up to 38 zones.
      SUBROUTINE ZNALIST(npick,izl,zdescr,length,ierr)
#include "building.h"

C Get common block precz/lnprecz from geometry.h
#include "geometry.h"

      integer npick ! number of zones in list
      dimension izl(MCOM)
      CHARACTER zdescr*124,outs*244,outsd*124
      integer ncomp,ncon
      common/C1/NCOMP,NCON
      logical unixok

      length=0
      do i=1,npick
        lna=lnzname(izl(i))
        length=length+lna+1
      enddo
      if(length.lt.124)then
        WRITE(outs,5,iostat=ios,err=1)(zname(izl(I)),I=1,npick)
    5   FORMAT('Zones: ',20(a,' '))
        call sdelim(outs,outsd,'S',IW)
        zdescr=outsd
        return
      else
        if(npick.eq.1)then
          WRITE(ZDESCR,'(A,I3,2A)')' Zone (',izl(1),') ',zname(izl(1))
        elseif(npick.gt.1.and.npick.LE.28)THEN
          WRITE(outs,6,iostat=ios,err=1)(izl(I),I=1,npick)
    6     FORMAT('Zones: ',28(I4))
          call sdelim(outs,outsd,'S',IW)
          zdescr=outsd
        ELSEIF(npick.GT.28.AND.npick.LE.npick)THEN
          WRITE(outs,7,iostat=ios,err=1)(izl(I),I=1,npick)
    7     FORMAT(' Zn: ',38(I4))
          call sdelim(outs,outsd,'S',IW)
          zdescr=outsd
        ELSEIF(npick.GT.38)THEN
          if(npick.eq.NCOMP)then
            write(zdescr,'(a)') 'Zones: all'
          else
            iloop=MIN0(40,npick)
            WRITE(outs,8,iostat=ios,err=1)(izl(I),I=1,iloop)
    8       FORMAT(' Zn: ',40(I4),'...')
            call sdelim(outs,outsd,'S',IW)
            zdescr=outsd
          endif
        ENDIF
        return
      endif

C I/O error trap.
   1  call isunix(unixok)
      if(unixok)then
        call lusrmsg('ZNALIST: error writing zone names: ',
     &    outs,'-')
      endif
      ierr=1
      return
      END

C ******************** zones_with_occupants ********************
C Scans zone operation files and reports which have occupants.
      SUBROUTINE zones_with_occupants(icount,ivals,zdescr,ierr)
#include "building.h"
#include "model.h"
#include "net_flow.h"
#include "schedule.h"

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/FILEP/IFIL
      integer ncomp,ncon
      common/c1/ncomp,ncon
      common/dynamico/isdynamicocup(MCOM)
      integer isdynamicocup
      common/caleni/nbdaytype,nbcaldays(MDTY),icalender(365)
      INTEGER nbdaytype,nbcaldays,icalender

      CHARACTER zdescr*124
      logical have_occup
      integer IVALS(MCOM)  ! the array of occupied zones

      IUF=IFIL+2
      call edisp(iuout,' ')
      call edisp(iuout,'The following zones have occupants:')
      icount=0
      do iz = 1,NCOMP
        CALL ERPFREE(IUF,ISTAT)
        CALL EROPER(0,iuout,IUF,iz,IER)
        have_occup=.FALSE.
        if(isdynamicocup(iz).ne.0)then  ! dynamic occupants
          have_occup=.TRUE.
        endif
        do IDTY=1,NBDAYTYPE
          if(NCAS(IDTY).gt.0)then
            do I = 1,NCAS(IDTY)
              icur=ICGT(IDTY,I)
              if(iabs(icur).eq.1.and.CMGS(IDTY,I).gt.1.0)then
                have_occup=.TRUE.
                cycle
              endif
            enddo
          endif
        enddo
        if(have_occup)then
          icount=icount+1
          IVALS(icount)=iz
        endif
      enddo
      if(icount.gt.0)then
        call ZNALIST(icount,ivals,zdescr,length,ierr)
        call edisp(iuout,zdescr)
      endif
      return
      end
