C This file is part of the ESP-r system.
C Copyright Energy Systems Research Unit, University of
C Strathclyde, Glasgow Scotland, 2001.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 orlater).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.

C ****************************   READST    ****************************
C Read ASCII structured mesh data file.
      SUBROUTINE READST(IComp,ITRC,IER)

#include "building.h"

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/PREC9/NCONST(MCOM),NELTS(MCOM,MS),NGAPS(MCOM,MS),
     &             NPGAP(MCOM,MS,MGP)
      
      integer ncomp,ncon
      COMMON/C1/NCOMP,NCON

C INDLCL - indices for each surface in zone.
C RefWidth - reference mesh width.
C NRow,NCol,NLay - numbers of rows, columns and layers in the grid. These
C will be odd numbers. The data on mesh widths linesto expects (NRow-1)/2
C entitie on the mesh widths lines. LRow() - how many RefWidth's along the row,
C LCol() and LLay() - how many RefWidth's along the (NCol-1)/2 columns 
C and along the (NLay-1)/2 layers.
C Example of an un-structured mesh file:
C # The indices for each construction (1: defined)
C  1  1  1  1  1  1  0  0
C   0.0010               # reference mesh width
C    17    27    27      # number of rows, columns, layers
C # Row mesh widths
C   100   250   450   800   800   450   250   100
  
      COMMON/GRSD31/INDLCL(MS)
      COMMON/GRSD41/RefWidth,NRow,NCol,NLay
      COMMON/GRSD42/LRow(MROW),LCol(MCOL),LLay(MLAY)

C NMtr - number of material geometries, and for each the IMtrS() zone surface
C it is associated with and the IMtrE() layer of the MLC it is associated with.
C IMRowS() the starting row, IMColS() the starting column, IMLayS() the starting
C layer. And then IMRowE() IMColE() IMLayE() the end row/column/layer. E example:
C     3                  # Number of material geometries
C # Material geometries details
C     7     1     3     3     3    15    25    25
      COMMON/GRSD51/NMtr,IMtrS(MMTR),IMtrE(MMTR)
      COMMON/GRSD52/IMRowS(MMTR),IMRowE(MMTR)
      COMMON/GRSD53/IMColS(MMTR),IMColE(MMTR)
      COMMON/GRSD54/IMLayS(MMTR),IMLayE(MMTR)

C NBnd - number of boundary surface boxes/geometries.
C IBndZ() - index of associated thermal zone, IBndS() index of the
C associated zone surface (if negative then ambient conditions, if
C positive zone side). IBRowS() IBColS() IBLayS() are the starting
C row/column/layer and IBRowE() IBColE() IBLayE() are the end
C row/column/layer. Example:
C     4                  # Number of boundary surface boxes
C # Boundary surface boxes details
C     1    -7     3     3     3    15    25     3

      COMMON/GRSD61/NBnd,IBndZ(MBND),IBndS(MBND)
      COMMON/GRSD62/IBRowS(MBND),IBRowE(MBND)
      COMMON/GRSD63/IBColS(MBND),IBColE(MBND)
      COMMON/GRSD64/IBLayS(MBND),IBLayE(MBND)
      COMMON/GRSD101/LGrdSt

      CHARACTER LGrdSt*72 ! ASCII structured mesh data file
      CHARACTER OUTSTR*124
      LOGICAL IsEven

      IER=0
      IOUT=IUOUT
      IIN=IFIL+1

C Open existing ASCII structured mesh data file as unit IIN.
      CALL EFOPSEQ(IIN,LGrdSt,1,IER)
      IF(IER.LT.0)RETURN

C The indices for each surface within the zone (1: defined, 0: not)
      NC=NCONST(IComp)
      CALL STRIPC(IIN,OUTSTR,NC,ND,1,'construction index',IER)
      IF(IER.NE.0)GOTO 777
      K=0
      DO 10 IC=1,NC
        CALL EGETWI(OUTSTR,K,Indx,0,1,'F','constr. index',IER)
        IF(IER.NE.0)GOTO 777
        INDLCL(IC)=Indx
   10 CONTINUE

C The reference mesh width.
      CALL STRIPC(IIN,OUTSTR,1,ND,1,'ref. mesh width',IER)
      IF(IER.NE.0)GOTO 777
      K=0
      CALL EGETWR(OUTSTR,K,RefWidth,0.,10.,'F','ref. width',IER)
      IF(IER.NE.0)GOTO 777

C The number of rows, columns, layers.
      CALL STRIPC(IIN,OUTSTR,3,ND,1,'No. of rows, col, lay.',IER)
      IF(IER.NE.0)GOTO 777
      K=0
      MAXR=MROW*2+1
      CALL EGETWI(OUTSTR,K,NRow,7,MAXR,'F','No. of rows',IER)
      IF(IER.NE.0)GOTO 777
      IF(IsEven(NRow))THEN
        CALL USRMSG(' ',' Maximum row number should be odd.','W')
        GOTO 777
      ENDIF
      NumR=(NRow-1)/2
      MAXC=MCOL*2+1
      CALL EGETWI(OUTSTR,K,NCol,7,MAXC,'F','No. of columns',IER)
      IF(IER.NE.0)GOTO 777
      IF(IsEven(NCol))THEN
        CALL USRMSG(' ',' Maximum column should be odd.','W')
        GOTO 777
      ENDIF
      NumC=(NCol-1)/2
      MAXL=MLAY*2+1
      CALL EGETWI(OUTSTR,K,NLay,7,MAXL,'F','No. of layers',IER)
      IF(IER.NE.0)GOTO 777
      IF(IsEven(NLay))THEN
        CALL USRMSG(' ',' Maximum layer should be odd.','W')
        GOTO 777
      ENDIF
      NumL=(NLay-1)/2

C Row mesh widths.Take the NumR=(NRow-1)/2 and assuming that there
C are a maximum of 10 entries on the line convert to the number
C of lines to be scanned.
      Numb=INT((NumR-1)/10)+1
      J2=0
      DO 20 I=1,Numb
        J1=J2+1
        IF(I.EQ.Numb)THEN
          N=NumR-(I-1)*10
          J2=NumR
        ELSE
          N=10
          J2=J2+10
        ENDIF
        CALL STRIPC(IIN,OUTSTR,N,ND,1,'row mesh widths',IER)
        IF(IER.NE.0)GOTO 777
        K=0
      DO 20 J=J1,J2
        CALL EGETWI(OUTSTR,K,LRow(J),1,1000000,'F','row',IER)
        IF(IER.NE.0)GOTO 777
   20 CONTINUE

C Column mesh widths. Compute Numb of lines to scan.
      Numb=INT((NumC-1)/10)+1
      J2=0
      DO 30 I=1,Numb
        J1=J2+1
        IF(I.EQ.Numb)THEN
          N=NumC-(I-1)*10
          J2=NumC
        ELSE
          N=10
          J2=J2+10
        ENDIF
        CALL STRIPC(IIN,OUTSTR,N,ND,1,'column mesh widths',IER)
        IF(IER.NE.0)GOTO 777
        K=0
      DO 30 J=J1,J2
        CALL EGETWI(OUTSTR,K,LCol(J),1,1000000,'F','column',IER)
        IF(IER.NE.0)GOTO 777
   30 CONTINUE

C Layer mesh widths. Compute number of lines to read and then get LLay()
      Numb=INT((NumL-1)/10)+1
      J2=0
      DO 40 I=1,Numb
        J1=J2+1
        IF(I.EQ.Numb)THEN
          N=NumL-(I-1)*10
          J2=NumL
        ELSE
          N=10
          J2=J2+10
        ENDIF
        CALL STRIPC(IIN,OUTSTR,N,ND,1,'layer mesh widths',IER)
        IF(IER.NE.0)GOTO 777
        K=0
      DO 40 J=J1,J2
        CALL EGETWI(OUTSTR,K,LLay(J),1,1000000,'F','layer',IER)
        IF(IER.NE.0)GOTO 777
   40 CONTINUE

C Number of material geometries.
      CALL STRIPC(IIN,OUTSTR,1,ND,1,'No. of material boxes',IER)
      IF(IER.NE.0)GOTO 777
      K=0
      CALL EGETWI(OUTSTR,K,NMtr,1,MMTR,'F','No. of material',IER)
      IF(IER.NE.0)GOTO 777

C Material geometries details.
      DO 50 I=1,NMtr
        CALL STRIPC(IIN,OUTSTR,8,ND,1,'material details',IER)
        IF(IER.NE.0)GOTO 777
        K=0
        CALL EGETWI(OUTSTR,K,IMtrS(I),0,NC,'F','Surface',IER)
        IF(IER.NE.0)GOTO 777
        if(IMtrS(I).gt.0)then
          NL=NELTS(IComp,IMtrS(I))
          CALL EGETWI(OUTSTR,K,IMtrE(I),0,NL,'F','Element',IER)
        else
          CALL EGETWI(OUTSTR,K,IMtrE(I),0,0,'-','Element',IER)
        endif 
        IF(IER.NE.0)GOTO 777
        CALL EGETWI(OUTSTR,K,IMRowS(I),1,MAXR-1,'F','1st row',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMRowS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        CALL EGETWI(OUTSTR,K,IMColS(I),1,MAXC-1,'F','1st clmn',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMColS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        CALL EGETWI(OUTSTR,K,IMLayS(I),1,MAXL-1,'F','1st layr',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMLayS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IMRowS(I)+1
        CALL EGETWI(OUTSTR,K,IMRowE(I),M,MAXR-1,'F','last row',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMRowE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IMColS(I)+1
        CALL EGETWI(OUTSTR,K,IMColE(I),M,MAXC-1,'F','end clmn',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMColE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IMLayS(I)+1
        CALL EGETWI(OUTSTR,K,IMLayE(I),M,MAXL-1,'F','end layr',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IMLayE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
   50 CONTINUE

C Number of boundary surface boxes/geometries.
      CALL STRIPC(IIN,OUTSTR,1,ND,1,'No. of boundary boxes',IER)
      IF(IER.NE.0)GOTO 777
      K=0
      CALL EGETWI(OUTSTR,K,NBnd,1,MBND,'F','No. of boundary',IER)
      IF(IER.NE.0)GOTO 777

C Boundary surface boxes details.
      DO 60 I=1,NBnd
        CALL STRIPC(IIN,OUTSTR,8,ND,1,'boundary details',IER)
        IF(IER.NE.0)GOTO 777
        K=0
        CALL EGETWI(OUTSTR,K,IBndZ(I),1,NComp,'F','Zone',IER)
        IF(IER.NE.0)GOTO 777
        M=NCONST(IBndZ(I))
        CALL EGETWI(OUTSTR,K,IBndS(I),-M,M,'F','Surface',IER)
        IF(IER.NE.0)GOTO 777
        CALL EGETWI(OUTSTR,K,IBRowS(I),0,MAXR,'F','1st row',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBRowS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        CALL EGETWI(OUTSTR,K,IBColS(I),0,MAXC,'F','1st clmn',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBColS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        CALL EGETWI(OUTSTR,K,IBLayS(I),0,MAXL,'F','1st layr',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBLayS(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IBRowS(I)
        CALL EGETWI(OUTSTR,K,IBRowE(I),M,MAXR,'F','last row',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBRowE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IBColS(I)
        CALL EGETWI(OUTSTR,K,IBColE(I),M,MAXC,'F','end clmn',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBColE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
        M=IBLayS(I)
        CALL EGETWI(OUTSTR,K,IBLayE(I),M,MAXL,'F','end layr',IER)
        IF(IER.NE.0)GOTO 777
        IF(IsEven(IBLayE(I)))THEN
          CALL USRMSG(' ',' Box coordinates should be odd.','W')
          GOTO 777
        ENDIF
   60 CONTINUE
      CALL ERPFREE(IIN,ISTAT)
      IF(ITRC.NE.0)CALL EDISP(IOUT,
     &    'Structured mesh configuration file read succesfuly !')
      RETURN
  777 CALL EDISP(IOUT,'Structured mesh configuration file ignored !!!')
      CALL ERPFREE(IIN,ISTAT)
      RETURN
      END

C ****************************   SAVEST    ****************************
C Write structured grid information to file. 

      SUBROUTINE SAVEST(IComp,ITRC,IER)
#include "building.h"
#include "help.h"

      COMMON/FILEP/IFIL
      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/PREC9/NCONST(MCOM),NELTS(MCOM,MS),NGAPS(MCOM,MS),
     &             NPGAP(MCOM,MS,MGP)

      COMMON/GRSD31/INDLCL(MS)
      COMMON/GRSD41/RefWidth,NRow,NCol,NLay
      COMMON/GRSD42/LRow(MROW),LCol(MCOL),LLay(MLAY)
      COMMON/GRSD51/NMtr,IMtrS(MMTR),IMtrE(MMTR)
      COMMON/GRSD52/IMRowS(MMTR),IMRowE(MMTR)
      COMMON/GRSD53/IMColS(MMTR),IMColE(MMTR)
      COMMON/GRSD54/IMLayS(MMTR),IMLayE(MMTR)
      COMMON/GRSD61/NBnd,IBndZ(MBND),IBndS(MBND)
      COMMON/GRSD62/IBRowS(MBND),IBRowE(MBND)
      COMMON/GRSD63/IBColS(MBND),IBColE(MBND)
      COMMON/GRSD64/IBLayS(MBND),IBLayE(MBND)
      COMMON/GRSD101/LGrdSt

      CHARACTER LGrdSt*72,ltmp*72

      helpinsub='esgrid'  ! set for subroutine
      helptopic='struc_mesh_write'
      call gethelptext(helpinsub,helptopic,nbhelp)

      IER=0
      IOUT=IUOUT
      IIN=IFIL+1
      ltmp=LGrdSt
      CALL EASKS(ltmp,'Structured mesh file name?',' ',
     &  72,' ','Structured mesh file',IER,nbhelp)
      if(ltmp(1:2).ne.'  '.and.ltmp(1:4).ne.'UNKN')then
        LGrdSt=ltmp
      endif

C Open existing ASCII construction data file as unit IIN.
      CALL EFOPSEQ(IIN,LGrdSt,4,IER)
      IF(IER.LT.0)RETURN

C The indices for each construction within the zone (1: defined, 0: not).
      NC=NCONST(IComp)
      WRITE(IIN,'(a)')'# Indices for each surface (1: defined 0: not)'
      WRITE(IIN,'(48I3)')(INDLCL(IC),IC=1,NC)

C The reference mesh width.
      WRITE(IIN,'(F9.4,15X,A)')RefWidth,'# reference mesh width'

C The number of rows, columns, layers.
      WRITE(IIN,'(3I6,6X,A)')NRow,NCol,NLay,
     &                            '# number of rows, columns, layers'

C Row mesh widths.
      WRITE(IIN,'(a)')'# Row mesh widths'
      NumRow=(NRow-1)/2
      WRITE(IIN,'(10I6)')(LRow(IR),IR=1,NumRow)

C Column mesh widths.
      WRITE(IIN,'(a)')'# Column mesh widths'
      NumCol=(NCol-1)/2
      WRITE(IIN,'(10I6)')(LCol(IC),IC=1,NumCol)

C Layer mesh widths.
      WRITE(IIN,'(a)')'# Layer mesh widths'
      NumLay=(NLay-1)/2
      WRITE(IIN,'(10I6)')(LLay(IL),IL=1,NumLay)

C Number of material geometries.
      WRITE(IIN,'(I6,18X,A)')NMtr,'# Number of material geometries'

C Material geometries details.
      WRITE(IIN,'(a)')'# Material geometries details'
      DO 20 I=1,NMtr
        WRITE(IIN,'(8I6)')IMtrS(I),IMtrE(I),IMRowS(I),IMColS(I),
     &                  IMLayS(I),IMRowE(I),IMColE(I),IMLayE(I)
   20 CONTINUE

C Number of boundary surface boxes.
      WRITE(IIN,'(I6,18X,A)')NBnd,'# Number of boundary surface boxes'

C Boundary surface boxes details.
      WRITE(IIN,'(a)')'# Boundary surface boxes details'
      DO 30 I=1,NBnd
        WRITE(IIN,'(8I6)')IBndZ(I),IBndS(I),IBRowS(I),IBColS(I),
     &                  IBLayS(I),IBRowE(I),IBColE(I),IBLayE(I)
   30 CONTINUE
      CALL ERPFREE(IIN,ISTAT)
      IF(ITRC.NE.0)CALL EDISP(IOUT,
     &    'Structured mesh configuration file saved succesfuly !')
      RETURN
      END

C ****************************   IsEven    ****************************
C IsEven
C *********************************************************************
      LOGICAL FUNCTION IsEven(Num)

      Num2=MOD(Num,2)
      IF(Num2.EQ.0)THEN
        IsEven=.true.
      ELSE
        IsEven=.false.
      ENDIF
      RETURN
      END

C ****************************    IGridN    ***************************
C IGridN is a function which returns the grid number from the row,
C        column, and layer numbers.
C *********************************************************************
      FUNCTION IGridN(IRow,ICol,ILay)

      COMMON/GRSD41/RefWidth,NRow,NCol,NLay
      COMMON/GRSD111/NColLay

      IGridN=(IRow-1)*NColLay+(ICol-1)*NLay+ILay
      RETURN
      END
