C This file is part of the ESP-r system.
C Copyright CANMET Energy Technology Centre 
C Natural Resources Canada, Government of Canada
C 2004-.

C ESP-r is free software.  You can redistribute it and/or
C modify it under the terms of the GNU General Public
C License as published by the Free Software Foundation 
C (version 2 or later).

C ESP-r is distributed in the hope that it will be useful
C but WITHOUT ANY WARRANTY; without even the implied
C warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C PURPOSE. See the GNU General Public License for more
C details.


C This file contains the following routines related to the BASESIMP
C foundation heat loss model.
C  COEFEXT1 - BASESIMP coefficients for configurations from original set of
C             67 generated by Ian Beausoleil-Morrison, 1996.
C  COEFEXT2 - BASESIMP coefficients for configurations generated by
C             Debra Haltrect, 1998.
C  COEFEXT3 - BASESIMP coefficients for configurations generated by
C             Julia Purdy, summer 1999.
C  COEFEXT4 - BASESIMP coefficients for configurations generated by
C             Kamel Haddad, summer 1999.
C  COEFEXT5 - BASESIMP coefficients for configurations generated by
C             Julia Purdy, October 1999.


C ******************** COEFEXT1 ********************
C Sets BASESIMP correlation coefficients and the `corner-correction column number'
C for the BASESIMP configuration under consideration. It supports the original
C set of 67 configurations except for the `basic' ones that are supported in
C COEFBAS. The correlation coefficients are described in:
C   Beausoleil-Morrison I., `BASESIMP: A Simplified Foundation Energy-Loss
C   Model Derived from BASECALC Simulations', NRCan internal report, 1996.

C The `corner-correction column number' refers to columns of Table 1 and
C Table 2 in:
C   Beausoleil-Morrison, Mitalas, and Chin (1992), `Estimating Three-Dimensional
C   Below-Grade Heat Losses from Houses Using Two-Dimensional Calculations',
C   Proc. Thermal Performance of the Exterior Envelopes of Buildings VI,
C   ASHRAE, pp. 95-99.
C (icol = 1 for column 1 of Table 1.  icol = 5 for column1 of Table 2.)

C Coefficients are set based on the passed 'iconfig' number and are held in
C the Dsumuo, Dsumur, Datten, Dphase and Dcorn common blocks.

      SUBROUTINE COEFEXT1(iconfig)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/Dsumuo/BSa1,BSb1,BSc1,BSd1,BSe1,BSf1,BSg1,BSh1,BSi1,BSj1
      COMMON/Dsumur/BSq2,BSr2,BSu2,BSv2,BSw2,BSx2,BSs2,BSt2,BSy2,BSa2,
     &              BSb2,BSc2,BSd2,BSe2,BSf2,BSg2,BSh2
      COMMON/Datten/BSa3,BSb3,BSc3,BSe3,BSf3,BSg3,BSh3,BSi3
      COMMON/Dphase/BSa4,BSb4,BSc4
      COMMON/Dcorn/icol

C BCCN_1:
C   - concrete walls and floor
C   - exterior surface of wall insulated below grade
C   - interior surface of wall insulated from top of wall producing an overlap
C     with the exterior insulation
C   - first storey brick veneer placed directly on basement's concrete walls
      IF(iconfig.eq.11) THEN
        BSa1 =     1.038000
        BSb1 =     1.412000
        BSc1 =     0.038300
        BSd1 =     0.279000
        BSe1 =     2.690000
        BSf1 =     0.468000
        BSg1 =     1.210000
        BSh1 =    -0.940000
        BSi1 =     1.000000
        BSj1 =     0.163000
        BSq2 =     0.123000
        BSr2 =     0.551000
        BSu2 =     0.204000
        BSv2 =     0.620000
        BSw2 =     0.707000
        BSx2 =     0.500000
        BSs2 =     0.654000
        BSt2 =     0.013500
        BSy2 =     0.025400
        BSa2 =     0.410000
        BSb2 =    -0.077700
        BSc2 =     0.590000
        BSd2 =    -0.318000
        BSe2 =    -0.011800
        BSf2 =    -0.035800
        BSg2 =     0.096100
        BSh2 =     0.255000
        BSa3 =     0.119000
        BSb3 =     0.295000
        BSc3 =    -0.063000
        BSe3 =     0.460000
        BSf3 =     0.086400
        BSg3 =    -0.058300
        BSh3 =     0.237000
        BSi3 =     1.889000
        BSa4 =     2.532000
        BSb4 =     0.352000
        BSc4 =     0.338000
        icol = 99

C BCCN_2:
C   - concrete walls and floor
C   - exterior surface of wall insulated below grade
C   - interior surface of wall insulated from top of wall producing an overlap
C     with the exterior insulation
C   - first storey is non-brick veneer or bricks thermally broken from
C     basement's concrete walls
      ELSEIF(iconfig.eq.12) THEN
        BSa1 =     0.900000
        BSb1 =     1.562000
        BSc1 =     0.038000
        BSd1 =     0.282000
        BSe1 =     2.667000
        BSf1 =     0.409000
        BSg1 =     1.114000
        BSh1 =    -0.873000
        BSi1 =     1.000000
        BSj1 =     0.141000
        BSq2 =     0.121000
        BSr2 =     0.553000
        BSu2 =     0.206000
        BSv2 =     0.620000
        BSw2 =     0.712000
        BSx2 =     0.500000
        BSs2 =     0.667000
        BSt2 =     0.013200
        BSy2 =     0.023400
        BSa2 =     0.418000
        BSb2 =    -0.069000
        BSc2 =     0.590000
        BSd2 =    -0.316000
        BSe2 =    -0.009290
        BSf2 =    -0.035800
        BSg2 =     0.092800
        BSh2 =     0.252000
        BSa3 =     0.116000
        BSb3 =     0.295000
        BSc3 =    -0.059600
        BSe3 =     0.458000
        BSf3 =     0.086400
        BSg3 =    -0.052900
        BSh3 =     0.234000
        BSi3 =     1.848000
        BSa4 =     2.541000
        BSb4 =     0.346000
        BSc4 =     0.339000
        icol = 99

C BWNN_1:
C   - wood walls and wood floor
C   - no insulation
C   - any first storey construction type
      ELSEIF(iconfig.eq.13) THEN
        BSa1 =    -0.018000
        BSb1 =     1.570000
        BSc1 =     0.003180
        BSd1 =     0.000000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.612000
        BSr2 =     0.125000
        BSu2 =     0.741000
        BSv2 =     0.620000
        BSw2 =     0.587000
        BSx2 =     0.500000
        BSs2 =    -0.047600
        BSt2 =     0.016700
        BSy2 =     0.064500
        BSa2 =     0.000000
        BSb2 =     0.000000
        BSc2 =     0.000000
        BSd2 =     0.000000
        BSe2 =     0.000000
        BSf2 =     0.000000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.159000
        BSb3 =     0.392000
        BSc3 =     0.284000
        BSe3 =     0.000000
        BSf3 =     0.000000
        BSg3 =     0.000000
        BSh3 =     0.000000
        BSi3 =     0.000000
        BSa4 =     2.983000
        BSb4 =     0.000000
        BSc4 =     0.000000
        icol =  1

C BWIN_1:
C   - wood walls and wood floor
C   - interior surface of wall insulated over full-height
C   - any first storey construction type
      ELSEIF(iconfig.eq.14) THEN
        BSa1 =    -0.008910
        BSb1 =     0.647000
        BSc1 =     0.003130
        BSd1 =     0.798000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.003850
        BSr2 =     0.102000
        BSu2 =     0.570000
        BSv2 =     0.620000
        BSw2 =     1.068000
        BSx2 =     0.500000
        BSs2 =    -0.042400
        BSt2 =     0.018800
        BSy2 =     0.134000
        BSa2 =     0.494000
        BSb2 =     0.797000
        BSc2 =     0.347000
        BSd2 =     0.064100
        BSe2 =     1.105000
        BSf2 =     0.094900
        BSg2 =    -0.246000
        BSh2 =     0.000000
        BSa3 =     0.104000
        BSb3 =     0.112000
        BSc3 =    -0.087000
        BSe3 =     0.007320
        BSf3 =     0.086600
        BSg3 =     0.244000
        BSh3 =     0.659000
        BSi3 =     0.000000
        BSa4 =    -8.379000
        BSb4 =    11.286000
        BSc4 =     0.010300
        icol =  3

C BWIN_2:
C   - wood walls and wood floor
C   - interior surface of wall insulated from top of wall to 0.2 m from floor
C   - any first storey construction type
      ELSEIF(iconfig.eq.15) THEN
        BSa1 =    -0.008370
        BSb1 =     0.647000
        BSc1 =     0.003180
        BSd1 =     0.797000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.094500
        BSr2 =     0.093700
        BSu2 =     0.656000
        BSv2 =     0.620000
        BSw2 =     1.115000
        BSx2 =     0.500000
        BSs2 =    -0.063400
        BSt2 =     0.018600
        BSy2 =     0.137000
        BSa2 =     0.366000
        BSb2 =     0.947000
        BSc2 =     0.404000
        BSd2 =     0.049700
        BSe2 =     1.356000
        BSf2 =     0.074900
        BSg2 =    -0.330000
        BSh2 =     0.000000
        BSa3 =     0.205000
        BSb3 =     0.141000
        BSc3 =    -0.129000
        BSe3 =    -0.028100
        BSf3 =     0.084500
        BSg3 =     0.245000
        BSh3 =     0.625000
        BSi3 =     0.000000
        BSa4 =    -2.996000
        BSb4 =     5.837000
        BSc4 =     0.023600
        icol =  3

C BWIN_3:
C   - wood walls and wood floor
C   - interior surface of wall insulated from top of wall to 0.6 m below grade
C   - any first storey construction type
      ELSEIF(iconfig.eq.16) THEN
        BSa1 =    -0.004050
        BSb1 =     0.635000
        BSc1 =     0.002900
        BSd1 =     0.782000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.126000
        BSr2 =     0.295000
        BSu2 =     0.783000
        BSv2 =     0.620000
        BSw2 =     0.128000
        BSx2 =     0.500000
        BSs2 =     0.377000
        BSt2 =     0.006610
        BSy2 =     0.163000
        BSa2 =     0.508000
        BSb2 =     0.507000
        BSc2 =     0.619000
        BSd2 =    -0.161000
        BSe2 =     0.166000
        BSf2 =    -0.008010
        BSg2 =    -0.041300
        BSh2 =     0.000000
        BSa3 =    -0.276000
        BSb3 =     0.306000
        BSc3 =     0.279000
        BSe3 =     0.214000
        BSf3 =     0.050600
        BSg3 =    -0.018200
        BSh3 =     0.656000
        BSi3 =     0.000000
        BSa4 =     2.697000
        BSb4 =     0.196000
        BSc4 =     0.402000
        icol =  2

C BWEN_1:
C   - wood walls and wood floor
C   - exterior surface of wall insulated over full-height
C   - any first storey construction type
      ELSEIF(iconfig.eq.17) THEN
        BSa1 =    -0.030900
        BSb1 =     0.651000
        BSc1 =    -0.000065
        BSd1 =     0.809000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075600
        BSq2 =     0.015100
        BSr2 =     0.103000
        BSu2 =     0.561000
        BSv2 =     0.620000
        BSw2 =     1.051000
        BSx2 =     0.500000
        BSs2 =    -0.039000
        BSt2 =     0.018700
        BSy2 =     0.136000
        BSa2 =     0.506000
        BSb2 =     0.791000
        BSc2 =     0.340000
        BSd2 =     0.067000
        BSe2 =     1.134000
        BSf2 =     0.084400
        BSg2 =    -0.258000
        BSh2 =     0.000000
        BSa3 =     0.092500
        BSb3 =     0.111000
        BSc3 =    -0.088900
        BSe3 =     0.014500
        BSf3 =     0.087000
        BSg3 =     0.250000
        BSh3 =     0.633000
        BSi3 =     0.000000
        BSa4 =     2.343000
        BSb4 =     0.645000
        BSc4 =     1.000000
        icol =  5

C BWEN_2:
C   - wood walls and wood floor
C   - exterior surface of wall insulated below grade
C   - any first storey construction type
      ELSEIF(iconfig.eq.18) THEN
        BSa1 =    -0.011000
        BSb1 =     1.569000
        BSc1 =    -0.000076
        BSd1 =    -0.000364
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.046100
        BSr2 =     0.091400
        BSu2 =     0.651000
        BSv2 =     0.620000
        BSw2 =     1.135000
        BSx2 =     0.500000
        BSs2 =    -0.052100
        BSt2 =     0.018900
        BSy2 =     0.130000
        BSa2 =     0.470000
        BSb2 =     0.838000
        BSc2 =     0.345000
        BSd2 =     0.063300
        BSe2 =     1.093000
        BSf2 =     0.098500
        BSg2 =    -0.245000
        BSh2 =     0.000000
        BSa3 =     0.188000
        BSb3 =     0.107000
        BSc3 =    -0.121000
        BSe3 =     0.002400
        BSf3 =     0.086600
        BSg3 =     0.268000
        BSh3 =     0.557000
        BSi3 =     0.000000
        BSa4 =     2.607000
        BSb4 =     0.342000
        BSc4 =     1.000000
        icol =  4

C BCIB_1:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab fully insulated but no insulation under footings
C   - any first storey construction type
      ELSEIF(iconfig.eq.19) THEN
        BSa1 =    -0.003740
        BSb1 =     0.724000
        BSc1 =     0.116000
        BSd1 =     0.757000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.996000
        BSr2 =    -0.057600
        BSu2 =     0.620000
        BSv2 =     0.620000
        BSw2 =    -2.850000
        BSx2 =     0.735000
        BSs2 =     0.746000
        BSt2 =     0.007420
        BSy2 =    -0.201000
        BSa2 =     3.429000
        BSb2 =     0.176000
        BSc2 =     0.522000
        BSd2 =     0.269000
        BSe2 =     0.155000
        BSf2 =     0.047800
        BSg2 =     0.039400
        BSh2 =     0.000000
        BSa3 =     0.235000
        BSb3 =     0.050600
        BSc3 =    -0.082100
        BSe3 =     0.025500
        BSf3 =     0.244000
        BSg3 =     0.176000
        BSh3 =     0.711000
        BSi3 =     0.000000
        BSa4 =     2.813000
        BSb4 =     0.118000
        BSc4 =     0.729000
        icol =  7

C BCIB_2:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 0.6 m strip around perimeter
C   - any first storey construction type
      ELSEIF(iconfig.eq.20) THEN
        BSa1 =     0.016000
        BSb1 =     0.709000
        BSc1 =     0.103000
        BSd1 =     0.715000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    11.396000
        BSr2 =    -0.640000
        BSu2 =     0.095400
        BSv2 =     0.620000
        BSw2 =    -1.869000
        BSx2 =     0.500000
        BSs2 =     1.213000
        BSt2 =    -0.004700
        BSy2 =    -0.278000
        BSa2 =     8.129000
        BSb2 =     0.157000
        BSc2 =     0.775000
        BSd2 =     0.537000
        BSe2 =     0.047700
        BSf2 =    -0.015100
        BSg2 =     0.019700
        BSh2 =     0.000000
        BSa3 =     0.237000
        BSb3 =     0.288000
        BSc3 =    -0.171000
        BSe3 =     0.013900
        BSf3 =     0.113000
        BSg3 =     0.219000
        BSh3 =     0.770000
        BSi3 =     0.000000
        BSa4 =     2.344000
        BSb4 =     0.558000
        BSc4 =     0.233000
        icol =  3

C BCIB_3:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 1.0 m strip around perimeter
C   - any first storey construction type
      ELSEIF(iconfig.eq.21) THEN
        BSa1 =     0.012800
        BSb1 =     0.711000
        BSc1 =     0.105000
        BSd1 =     0.722000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    10.942000
        BSr2 =    -0.637000
        BSu2 =     0.086300
        BSv2 =     0.620000
        BSw2 =    -1.867000
        BSx2 =     0.500000
        BSs2 =     1.206000
        BSt2 =    -0.000041
        BSy2 =    -0.284000
        BSa2 =     7.541000
        BSb2 =     0.168000
        BSc2 =     0.761000
        BSd2 =     0.530000
        BSe2 =     0.058200
        BSf2 =    -0.016300
        BSg2 =     0.020200
        BSh2 =     0.000000
        BSa3 =     0.220000
        BSb3 =     0.251000
        BSc3 =    -0.153000
        BSe3 =     0.027100
        BSf3 =     0.123000
        BSg3 =     0.214000
        BSh3 =     0.768000
        BSi3 =     0.000000
        BSa4 =     2.246000
        BSb4 =     0.658000
        BSc4 =     0.199000
        icol =  3

C BCIB_4:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab fully insulated but no insulation under footings
C   - thermal-break between walls and floor slab
C   - any first storey construction type
      ELSEIF(iconfig.eq.22) THEN
        BSa1 =    -0.002110
        BSb1 =     0.748000
        BSc1 =     0.093800
        BSd1 =     0.845000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -0.140000
        BSr2 =     0.009540
        BSu2 =     0.662000
        BSv2 =     0.620000
        BSw2 =     8.476000
        BSx2 =     0.500000
        BSs2 =     0.453000
        BSt2 =     0.007740
        BSy2 =    -0.007940
        BSa2 =     3.002000
        BSb2 =     0.248000
        BSc2 =     0.506000
        BSd2 =     0.256000
        BSe2 =     0.363000
        BSf2 =     0.058000
        BSg2 =     0.013500
        BSh2 =     0.000000
        BSa3 =    -0.013600
        BSb3 =    -0.026300
        BSc3 =    -0.003810
        BSe3 =     0.166000
        BSf3 =     0.267000
        BSg3 =     0.158000
        BSh3 =     0.679000
        BSi3 =     0.000000
        BSa4 =     2.526000
        BSb4 =     0.388000
        BSc4 =     0.255000
        icol =  7

C BCIB_5:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 0.6 m strip around perimeter
C   - thermal-break between walls and floor slab
C   - any first storey construction type
      ELSEIF(iconfig.eq.23) THEN
        BSa1 =     0.020900
        BSb1 =     0.723000
        BSc1 =     0.081600
        BSd1 =     0.776000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -0.068300
        BSr2 =     0.375000
        BSu2 =     0.136000
        BSv2 =     0.620000
        BSw2 =     0.630000
        BSx2 =     0.500000
        BSs2 =    -0.003790
        BSt2 =     0.021900
        BSy2 =     0.177000
        BSa2 =     0.785000
        BSb2 =     0.567000
        BSc2 =     0.342000
        BSd2 =     0.142000
        BSe2 =     2.234000
        BSf2 =     0.003520
        BSg2 =    -0.686000
        BSh2 =     0.000000
        BSa3 =     0.037400
        BSb3 =     0.254000
        BSc3 =    -0.117000
        BSe3 =     0.103000
        BSf3 =     0.107000
        BSg3 =     0.222000
        BSh3 =     0.778000
        BSi3 =     0.000000
        BSa4 =    16.468000
        BSb4 =   -13.584000
        BSc4 =    -0.012400
        icol =  3

C BCIB_6:
C   - concrete walls and floor
C   - interior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 1.0 m strip around perimeter
C   - thermal-break between walls and floor slab
C   - any first storey construction type
      ELSEIF(iconfig.eq.24) THEN
        BSa1 =     0.017100
        BSb1 =     0.727000
        BSc1 =     0.082500
        BSd1 =     0.789000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -0.325000
        BSr2 =     0.374000
        BSu2 =     0.131000
        BSv2 =     0.620000
        BSw2 =     0.637000
        BSx2 =     0.500000
        BSs2 =    -0.001340
        BSt2 =     0.022800
        BSy2 =     0.170000
        BSa2 =     0.830000
        BSb2 =     0.513000
        BSc2 =     0.346000
        BSd2 =     0.121000
        BSe2 =     1.849000
        BSf2 =     0.043600
        BSg2 =    -0.530000
        BSh2 =     0.000000
        BSa3 =     0.010700
        BSb3 =     0.210000
        BSc3 =    -0.095400
        BSe3 =     0.124000
        BSf3 =     0.117000
        BSg3 =     0.218000
        BSh3 =     0.778000
        BSi3 =     0.000000
        BSa4 =     4.396000
        BSb4 =    -1.511000
        BSc4 =    -0.113000
        icol =  3

C BCEB_1:
C   - concrete walls and floor
C   - exterior surface of wall insulated over full-height
C   - sub-surface of floor slab fully insulated but no insulation under footings
C   - first storey brick veneer placed directly on basement's concrete walls
      ELSEIF(iconfig.eq.25) THEN
        BSa1 =    -0.084100
        BSb1 =     0.748000
        BSc1 =     0.004410
        BSd1 =     0.884000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.356000
        BSq2 =    -0.006140
        BSr2 =     0.015300
        BSu2 =     0.592000
        BSv2 =     0.620000
        BSw2 =     3.497000
        BSx2 =     0.500000
        BSs2 =    -0.228000
        BSt2 =     0.019900
        BSy2 =     0.088500
        BSa2 =     2.157000
        BSb2 =     0.358000
        BSc2 =     0.556000
        BSd2 =     0.312000
        BSe2 =     0.533000
        BSf2 =     0.150000
        BSg2 =    -0.040800
        BSh2 =     0.000000
        BSa3 =     0.140000
        BSb3 =     0.097800
        BSc3 =    -0.095100
        BSe3 =     0.047200
        BSf3 =     0.198000
        BSg3 =     0.213000
        BSh3 =     0.682000
        BSi3 =     0.000000
        BSa4 =     2.188000
        BSb4 =     0.711000
        BSc4 =     0.132000
        icol =  8

C BCEB_2:
C   - concrete walls and floor
C   - exterior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 0.6 m strip around perimeter
C   - first storey brick veneer placed directly on basement's concrete walls
      ELSEIF(iconfig.eq.26) THEN
        BSa1 =    -0.083600
        BSb1 =     0.749000
        BSc1 =     0.003390
        BSd1 =     0.885000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.357000
        BSq2 =     0.188000
        BSr2 =     0.354000
        BSu2 =     0.197000
        BSv2 =     0.620000
        BSw2 =     0.666000
        BSx2 =     0.500000
        BSs2 =    -0.025900
        BSt2 =     0.022300
        BSy2 =     0.183000
        BSa2 =     0.786000
        BSb2 =     0.683000
        BSc2 =     0.353000
        BSd2 =     0.229000
        BSe2 =     2.850000
        BSf2 =    -0.047800
        BSg2 =    -0.939000
        BSh2 =     0.000000
        BSa3 =     0.129000
        BSb3 =     0.304000
        BSc3 =    -0.169000
        BSe3 =     0.044400
        BSf3 =     0.085800
        BSg3 =     0.247000
        BSh3 =     0.730000
        BSi3 =     0.000000
        BSa4 =     1.232000
        BSb4 =     1.644000
        BSc4 =     0.088100
        icol =  5

C BCEB_3:
C   - concrete walls and floor
C   - exterior surface of wall insulated over full-height
C   - sub-surface of floor slab insulated with a 1.0 m strip around perimeter
C   - first storey brick veneer placed directly on basement's concrete walls
      ELSEIF(iconfig.eq.27) THEN
        BSa1 =    -0.083700
        BSb1 =     0.749000
        BSc1 =     0.003520
        BSd1 =     0.885000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.356000
        BSq2 =     0.039000
        BSr2 =     0.345000
        BSu2 =     0.214000
        BSv2 =     0.620000
        BSw2 =     0.668000
        BSx2 =     0.500000
        BSs2 =    -0.033200
        BSt2 =     0.022900
        BSy2 =     0.179000
        BSa2 =     0.794000
        BSb2 =     0.617000
        BSc2 =     0.359000
        BSd2 =     0.199000
        BSe2 =     2.673000
        BSf2 =    -0.024200
        BSg2 =    -0.865000
        BSh2 =     0.000000
        BSa3 =     0.121000
        BSb3 =     0.273000
        BSc3 =    -0.155000
        BSe3 =     0.051300
        BSf3 =     0.093300
        BSg3 =     0.245000
        BSh3 =     0.731000
        BSi3 =     0.000000
        BSa4 =     0.408000
        BSb4 =     2.469000
        BSc4 =     0.059100
        icol =  5

C SCB_3:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - insulation also placed under footing creating a 0.85 m continuous section
C     of insulation
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.36) THEN
        BSa1 =     0.025400
        BSb1 =     0.000000
        BSc1 =     0.004240
        BSd1 =    -0.014400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.269000
        BSr2 =     0.404000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.546000
        BSt2 =     0.011500
        BSy2 =     0.000000
        BSa2 =     2.051000
        BSb2 =     0.000000
        BSc2 =     0.771000
        BSd2 =     0.183000
        BSe2 =     0.014800
        BSf2 =    -0.002720
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.082000
        BSb3 =     0.429000
        BSc3 =     0.000000
        BSe3 =     0.032200
        BSf3 =     0.007170
        BSg3 =     0.000000
        BSh3 =     0.730000
        BSi3 =     0.000000
        BSa4 =     2.818000
        BSb4 =     0.014000
        BSc4 =     0.768000
        icol =  3

C SCB_4:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - insulation also placed under footing creating a 0.85 m continuous section
C     of insulation
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.37) THEN
        BSa1 =     0.057000
        BSb1 =     0.000000
        BSc1 =     0.007130
        BSd1 =    -0.011000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.286000
        BSr2 =     0.402000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.545000
        BSt2 =     0.011300
        BSy2 =     0.000000
        BSa2 =     2.094000
        BSb2 =     0.000000
        BSc2 =     0.743000
        BSd2 =     0.180000
        BSe2 =     0.014000
        BSf2 =    -0.002790
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.125000
        BSb3 =     0.423000
        BSc3 =     0.000000
        BSe3 =     0.030500
        BSf3 =     0.007520
        BSg3 =     0.000000
        BSh3 =     0.741000
        BSi3 =     0.000000
        BSa4 =     2.844000
        BSb4 =     0.010100
        BSc4 =     0.823000
        icol =  3

C SCB_5:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.38) THEN
        BSa1 =     0.026600
        BSb1 =     0.000000
        BSc1 =     0.005120
        BSd1 =    -0.023900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.329000
        BSr2 =     0.419000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.566000
        BSt2 =     0.011600
        BSy2 =     0.000000
        BSa2 =     1.998000
        BSb2 =     0.000000
        BSc2 =     0.796000
        BSd2 =     0.185000
        BSe2 =     0.015200
        BSf2 =    -0.003010
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.004810
        BSb3 =     0.443000
        BSc3 =     0.000000
        BSe3 =     0.060500
        BSf3 =     0.001520
        BSg3 =     0.000000
        BSh3 =     0.619000
        BSi3 =     0.000000
        BSa4 =     2.756000
        BSb4 =     0.044700
        BSc4 =     0.556000
        icol =  3

C SCB_6:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.39) THEN
        BSa1 =     0.067100
        BSb1 =     0.000000
        BSc1 =     0.012900
        BSd1 =    -0.028900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.270000
        BSr2 =     0.418000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.570000
        BSt2 =     0.011300
        BSy2 =     0.000000
        BSa2 =     2.007000
        BSb2 =     0.000000
        BSc2 =     0.781000
        BSd2 =     0.183000
        BSe2 =     0.017400
        BSf2 =    -0.003980
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.006410
        BSb3 =     0.436000
        BSc3 =     0.000000
        BSe3 =     0.076000
        BSf3 =     0.001740
        BSg3 =     0.000000
        BSh3 =     0.584000
        BSi3 =     0.000000
        BSa4 =     2.761000
        BSb4 =     0.051600
        BSc4 =     0.507000
        icol =  3

C SCB_9:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.40) THEN
        BSa1 =     0.038600
        BSb1 =     0.000000
        BSc1 =     0.001500
        BSd1 =    -0.064300
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.298000
        BSr2 =     0.422000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.587000
        BSt2 =     0.010300
        BSy2 =     0.000000
        BSa2 =     1.881000
        BSb2 =     0.000000
        BSc2 =     0.813000
        BSd2 =     0.222000
        BSe2 =     0.061500
        BSf2 =    -0.018800
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.097700
        BSb3 =     0.323000
        BSc3 =     0.000000
        BSe3 =     0.145000
        BSf3 =     0.007050
        BSg3 =     0.000000
        BSh3 =     0.701000
        BSi3 =     0.000000
        BSa4 =     2.346000
        BSb4 =     0.335000
        BSc4 =     0.375000
        icol =  3

C SCB_10:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.41) THEN
        BSa1 =     0.099500
        BSb1 =     0.000000
        BSc1 =     0.000022
        BSd1 =    -0.066600
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.283000
        BSr2 =     0.423000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.594000
        BSt2 =     0.010400
        BSy2 =     0.000000
        BSa2 =     1.931000
        BSb2 =     0.000000
        BSc2 =     0.779000
        BSd2 =     0.215000
        BSe2 =     0.050500
        BSf2 =    -0.014500
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.074900
        BSb3 =     0.319000
        BSc3 =     0.000000
        BSe3 =     0.148000
        BSf3 =     0.009450
        BSg3 =     0.000000
        BSh3 =     0.660000
        BSi3 =     0.000000
        BSa4 =     2.438000
        BSb4 =     0.277000
        BSc4 =     0.370000
        icol =  3

C  SCB_11:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C     horizontal skirt extends from slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.42) THEN

        BSa1 =     0.026600
        BSb1 =     0.000000
        BSc1 =     0.004020
        BSd1 =    -0.003710
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.396000
        BSr2 =     0.420000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.588000
        BSt2 =     0.010100
        BSy2 =     0.000000
        BSa2 =     2.088000
        BSb2 =     0.000000
        BSc2 =     0.765000
        BSd2 =     0.206000
        BSe2 =     0.018500
        BSf2 =    -0.004170
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.072500
        BSb3 =     0.369000
        BSc3 =     0.000000
        BSe3 =     0.053100
        BSf3 =     0.007400
        BSg3 =     0.000000
        BSh3 =     0.755000
        BSi3 =     0.000000
        BSa4 =     2.766000
        BSb4 =     0.031800
        BSc4 =     0.724000
        icol =  3

C SCB_12:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 0.6 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - horizontal skirt extends from slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.43) THEN
        BSa1 =     0.061100
        BSb1 =     0.000000
        BSc1 =     0.008110
        BSd1 =    -0.001550
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.419000
        BSr2 =     0.416000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.583000
        BSt2 =     0.009900
        BSy2 =     0.000000
        BSa2 =     2.148000
        BSb2 =     0.000000
        BSc2 =     0.732000
        BSd2 =     0.204000
        BSe2 =     0.019300
        BSf2 =    -0.004850
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.118000
        BSb3 =     0.362000
        BSc3 =     0.000000
        BSe3 =     0.054800
        BSf3 =     0.007470
        BSg3 =     0.000000
        BSh3 =     0.745000
        BSi3 =     0.000000
        BSa4 =     2.797000
        BSb4 =     0.027900
        BSc4 =     0.715000
        icol =  3

C SCB_13:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.44) THEN
        BSa1 =     0.023100
        BSb1 =     0.000000
        BSc1 =     0.004580
        BSd1 =     0.009590
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.203000
        BSr2 =     0.397000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.521000
        BSt2 =     0.013500
        BSy2 =     0.000000
        BSa2 =     1.998000
        BSb2 =     0.000000
        BSc2 =     0.733000
        BSd2 =     0.180000
        BSe2 =     0.027100
        BSf2 =    -0.003600
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.100000
        BSb3 =     0.364000
        BSc3 =     0.000000
        BSe3 =     0.048600
        BSf3 =     0.026500
        BSg3 =     0.000000
        BSh3 =     0.677000
        BSi3 =     0.000000
        BSa4 =     2.791000
        BSb4 =     0.034700
        BSc4 =     0.631000
        icol =  3

C SCB_14:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.45) THEN
        BSa1 =     0.053200
        BSb1 =     0.000000
        BSc1 =     0.009350
        BSd1 =     0.012500
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.234000
        BSr2 =     0.396000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.518000
        BSt2 =     0.013400
        BSy2 =     0.000000
        BSa2 =     2.042000
        BSb2 =     0.000000
        BSc2 =     0.707000
        BSd2 =     0.178000
        BSe2 =     0.028700
        BSf2 =    -0.004570
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.137000
        BSb3 =     0.359000
        BSc3 =     0.000000
        BSe3 =     0.054000
        BSf3 =     0.025600
        BSg3 =     0.000000
        BSh3 =     0.671000
        BSi3 =     0.000000
        BSa4 =     2.816000
        BSb4 =     0.031700
        BSc4 =     0.627000
        icol =  3

C SCB_17:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.46) THEN
        BSa1 =     0.025200
        BSb1 =     0.000000
        BSc1 =     0.005710
        BSd1 =    -0.016900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.215000
        BSr2 =     0.403000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.526000
        BSt2 =     0.013700
        BSy2 =     0.000000
        BSa2 =     1.925000
        BSb2 =     0.000000
        BSc2 =     0.767000
        BSd2 =     0.184000
        BSe2 =     0.032400
        BSf2 =    -0.005470
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.004970
        BSb3 =     0.377000
        BSc3 =     0.000000
        BSe3 =     0.077200
        BSf3 =     0.019500
        BSg3 =     0.000000
        BSh3 =     0.651000
        BSi3 =     0.000000
        BSa4 =     2.708000
        BSb4 =     0.073500
        BSc4 =     0.546000
        icol =  3

C SCB_18:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.47) THEN
        BSa1 =     0.063300
        BSb1 =     0.000000
        BSc1 =     0.014600
        BSd1 =    -0.021100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.156000
        BSr2 =     0.401000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.527000
        BSt2 =     0.013500
        BSy2 =     0.000000
        BSa2 =     1.931000
        BSb2 =     0.000000
        BSc2 =     0.752000
        BSd2 =     0.182000
        BSe2 =     0.035200
        BSf2 =    -0.006660
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.006420
        BSb3 =     0.370000
        BSc3 =     0.000000
        BSe3 =     0.092500
        BSf3 =     0.019200
        BSg3 =     0.000000
        BSh3 =     0.629000
        BSi3 =     0.000000
        BSa4 =     2.713000
        BSb4 =     0.080500
        BSc4 =     0.508000
        icol =  3

C SCB_21:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.48) THEN
        BSa1 =     0.036600
        BSb1 =     0.000000
        BSc1 =     0.002540
        BSd1 =    -0.056900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.200000
        BSr2 =     0.408000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.552000
        BSt2 =     0.011900
        BSy2 =     0.000000
        BSa2 =     1.815000
        BSb2 =     0.000000
        BSc2 =     0.790000
        BSd2 =     0.221000
        BSe2 =     0.075400
        BSf2 =    -0.021200
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.091600
        BSb3 =     0.285000
        BSc3 =     0.000000
        BSe3 =     0.146000
        BSf3 =     0.014000
        BSg3 =     0.000000
        BSh3 =     0.736000
        BSi3 =     0.000000
        BSa4 =     2.241000
        BSb4 =     0.416000
        BSc4 =     0.361000
        icol =  3

C SCB_22:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.49) THEN
        BSa1 =     0.093900
        BSb1 =     0.000000
        BSc1 =     0.003020
        BSd1 =    -0.058100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.176000
        BSr2 =     0.408000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.555000
        BSt2 =     0.012200
        BSy2 =     0.000000
        BSa2 =     1.857000
        BSb2 =     0.000000
        BSc2 =     0.756000
        BSd2 =     0.213000
        BSe2 =     0.065700
        BSf2 =    -0.017300
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.071900
        BSb3 =     0.280000
        BSc3 =     0.000000
        BSe3 =     0.153000
        BSf3 =     0.015500
        BSg3 =     0.000000
        BSh3 =     0.696000
        BSi3 =     0.000000
        BSa4 =     2.352000
        BSb4 =     0.340000
        BSc4 =     0.362000
        icol =  3

C  SCB_23:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - horizontal skirt extends from slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.50) THEN
        BSa1 =     0.025300
        BSb1 =     0.000000
        BSc1 =     0.004640
        BSd1 =     0.003570
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.283000
        BSr2 =     0.406000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.549000
        BSt2 =     0.012200
        BSy2 =     0.000000
        BSa2 =     2.004000
        BSb2 =     0.000000
        BSc2 =     0.739000
        BSd2 =     0.203000
        BSe2 =     0.033500
        BSf2 =    -0.006230
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.067700
        BSb3 =     0.315000
        BSc3 =     0.000000
        BSe3 =     0.069100
        BSf3 =     0.020400
        BSg3 =     0.000000
        BSh3 =     0.737000
        BSi3 =     0.000000
        BSa4 =     2.736000
        BSb4 =     0.045400
        BSc4 =     0.729000
        icol =  3

C SCB_24:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab insulated 1.0 m around perimeter
C   - no insulation under footing or foundation wall (ie. insulation starts
C     0.25 m from edge)
C   - horizontal skirt extends from slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.51) THEN
        BSa1 =     0.057600
        BSb1 =     0.000000
        BSc1 =     0.009710
        BSd1 =     0.006590
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.306000
        BSr2 =     0.401000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.544000
        BSt2 =     0.012000
        BSy2 =     0.000000
        BSa2 =     2.062000
        BSb2 =     0.000000
        BSc2 =     0.706000
        BSd2 =     0.201000
        BSe2 =     0.034400
        BSf2 =    -0.006960
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.110000
        BSb3 =     0.308000
        BSc3 =     0.000000
        BSe3 =     0.073100
        BSf3 =     0.020100
        BSg3 =     0.000000
        BSh3 =     0.730000
        BSi3 =     0.000000
        BSa4 =     2.770000
        BSb4 =     0.039300
        BSc4 =     0.732000
        icol =  3

C SCB_29:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (ie. insulation starts 0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.54) THEN
        BSa1 =     0.019000
        BSb1 =     0.000000
        BSc1 =     0.010600
        BSd1 =     0.054100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.536000
        BSr2 =     0.114000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.311000
        BSt2 =     0.007740
        BSy2 =     0.000000
        BSa2 =     2.033000
        BSb2 =     0.000000
        BSc2 =     0.452000
        BSd2 =     0.158000
        BSe2 =     0.133000
        BSf2 =     0.093800
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.149000
        BSb3 =     0.030600
        BSc3 =     0.000000
        BSe3 =     0.022700
        BSf3 =     0.216000
        BSg3 =     0.000000
        BSh3 =     0.599000
        BSi3 =     0.000000
        BSa4 =     2.709000
        BSb4 =     0.071500
        BSc4 =    -0.505000
        icol =  7

C SCB_30:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (i.e. insulation starts 0.25 m from edge)
C   - thermal break around edge of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.55) THEN
        BSa1 =     0.048200
        BSb1 =     0.000000
        BSc1 =     0.026700
        BSd1 =     0.051400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.484000
        BSr2 =     0.114000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.311000
        BSt2 =     0.007770
        BSy2 =     0.000000
        BSa2 =     2.026000
        BSb2 =     0.000000
        BSc2 =     0.441000
        BSd2 =     0.156000
        BSe2 =     0.138000
        BSf2 =     0.094600
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.151000
        BSb3 =     0.025500
        BSc3 =     0.000000
        BSe3 =     0.036700
        BSf3 =     0.213000
        BSg3 =     0.000000
        BSh3 =     0.601000
        BSi3 =     0.000000
        BSa4 =     2.720000
        BSb4 =     0.074200
        BSc4 =    -0.500000
        icol =  7

C SCB_33:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (i.e. insulation starts 0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.56) THEN
        BSa1 =     0.028000
        BSb1 =     0.000000
        BSc1 =     0.009720
        BSd1 =     0.018900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.409000
        BSr2 =     0.115000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.324000
        BSt2 =     0.006290
        BSy2 =     0.000000
        BSa2 =     1.837000
        BSb2 =     0.000000
        BSc2 =     0.476000
        BSd2 =     0.177000
        BSe2 =     0.190000
        BSf2 =     0.080200
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.010300
        BSb3 =     0.030500
        BSc3 =     0.000000
        BSe3 =     0.111000
        BSf3 =     0.148000
        BSg3 =     0.000000
        BSh3 =     0.657000
        BSi3 =     0.000000
        BSa4 =     2.549000
        BSb4 =     0.168000
        BSc4 =     2.465000
        icol =  7

C SCB_34:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (i.e. insulation starts 0.25 m from edge)
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.57) THEN
        BSa1 =     0.072300
        BSb1 =     0.000000
        BSc1 =     0.021300
        BSd1 =     0.021400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.385000
        BSr2 =     0.116000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.328000
        BSt2 =     0.006910
        BSy2 =     0.000000
        BSa2 =     1.870000
        BSb2 =     0.000000
        BSc2 =     0.452000
        BSd2 =     0.174000
        BSe2 =     0.180000
        BSf2 =     0.087200
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.037500
        BSb3 =     0.019900
        BSc3 =     0.000000
        BSe3 =     0.110000
        BSf3 =     0.154000
        BSg3 =     0.000000
        BSh3 =     0.654000
        BSi3 =     0.000000
        BSa4 =     2.670000
        BSb4 =    -0.018700
        BSc4 =     1.000000
        icol =  7

C SCB_35:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (i.e. insulation starts 0.25 m from edge)
C   - horizontal skirt extends from slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.58) THEN
        BSa1 =     0.018800
        BSb1 =     0.000000
        BSc1 =     0.009840
        BSd1 =     0.081700
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.620000
        BSr2 =     0.115000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.326000
        BSt2 =     0.006580
        BSy2 =     0.000000
        BSa2 =     2.129000
        BSb2 =     0.000000
        BSc2 =     0.428000
        BSd2 =     0.171000
        BSe2 =     0.121000
        BSf2 =     0.091400
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.201000
        BSb3 =     0.021800
        BSc3 =     0.000000
        BSe3 =     0.009230
        BSf3 =     0.183000
        BSg3 =     0.000000
        BSh3 =     0.679000
        BSi3 =     0.000000
        BSa4 =     2.977000
        BSb4 =    -0.262000
        BSc4 =     1.000000
        icol =  7

C SCB_36:
C   - concrete or soil (for crawl space) floor
C   - bottom of slab fully insulated except under footing/foundation wall
C     (i.e. insulation starts 0.25 m from edge)
C   - horizontal skirt extends from slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.59) THEN
        BSa1 =     0.043500
        BSb1 =     0.000000
        BSc1 =     0.021300
        BSd1 =     0.086800
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.659000
        BSr2 =     0.114000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.323000
        BSt2 =     0.006260
        BSy2 =     0.000000
        BSa2 =     2.188000
        BSb2 =     0.000000
        BSc2 =     0.401000
        BSd2 =     0.169000
        BSe2 =     0.117000
        BSf2 =     0.090700
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.242000
        BSb3 =     0.010700
        BSc3 =     0.000000
        BSe3 =     0.015100
        BSf3 =     0.184000
        BSg3 =     0.000000
        BSh3 =     0.681000
        BSi3 =     0.000000
        BSa4 =     2.562000
        BSb4 =     0.256000
        BSc4 =    -0.246000
        icol =  7

C SCA_17:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.60) THEN
        BSa1 =     0.010800
        BSb1 =     0.000000
        BSc1 =     0.007830
        BSd1 =     0.490000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.620000
        BSr2 =     0.098400
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.230000
        BSt2 =     0.008990
        BSy2 =     0.000000
        BSa2 =     2.185000
        BSb2 =     0.000000
        BSc2 =     0.405000
        BSd2 =     0.177000
        BSe2 =     0.196000
        BSf2 =     0.111000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.000555
        BSb3 =    -0.040600
        BSc3 =     0.000000
        BSe3 =     0.143000
        BSf3 =     0.241000
        BSg3 =     0.000000
        BSh3 =     0.556000
        BSi3 =     0.000000
        BSa4 =     2.472000
        BSb4 =     0.226000
        BSc4 =     0.838000
        icol =  6

C SCA_18:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.61) THEN
        BSa1 =     0.024800
        BSb1 =     0.000000
        BSc1 =     0.017200
        BSd1 =     0.563000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.601000
        BSr2 =     0.098000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.227000
        BSt2 =     0.008790
        BSy2 =     0.000000
        BSa2 =     2.171000
        BSb2 =     0.000000
        BSc2 =     0.400000
        BSd2 =     0.174000
        BSe2 =     0.204000
        BSf2 =     0.109000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.004710
        BSb3 =    -0.039800
        BSc3 =     0.000000
        BSe3 =     0.168000
        BSf3 =     0.236000
        BSg3 =     0.000000
        BSh3 =     0.560000
        BSi3 =     0.000000
        BSa4 =     2.442000
        BSb4 =     0.270000
        BSc4 =     0.623000
        icol =  6

C SCA_19:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - thermal break around edge of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.62) THEN
        BSa1 =     0.011400
        BSb1 =     0.000000
        BSc1 =     0.009890
        BSd1 =     0.467000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.626000
        BSr2 =     0.099500
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.237000
        BSt2 =     0.008750
        BSy2 =     0.000000
        BSa2 =     2.162000
        BSb2 =     0.000000
        BSc2 =     0.418000
        BSd2 =     0.181000
        BSe2 =     0.191000
        BSf2 =     0.113000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.001230
        BSb3 =    -0.037400
        BSc3 =     0.000000
        BSe3 =     0.103000
        BSf3 =     0.246000
        BSg3 =     0.000000
        BSh3 =     0.564000
        BSi3 =     0.000000
        BSa4 =     2.385000
        BSb4 =     0.272000
        BSc4 =     0.720000
        icol =  6

C SCA_20:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - thermal break around edge of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.63) THEN
        BSa1 =     0.028200
        BSb1 =     0.000000
        BSc1 =     0.024900
        BSd1 =     0.524000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.594000
        BSr2 =     0.099400
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.237000
        BSt2 =     0.008870
        BSy2 =     0.000000
        BSa2 =     2.141000
        BSb2 =     0.000000
        BSc2 =     0.417000
        BSd2 =     0.182000
        BSe2 =     0.202000
        BSf2 =     0.112000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.002830
        BSb3 =    -0.034000
        BSc3 =     0.000000
        BSe3 =     0.110000
        BSf3 =     0.240000
        BSg3 =     0.000000
        BSh3 =     0.579000
        BSi3 =     0.000000
        BSa4 =     2.332000
        BSb4 =     0.329000
        BSc4 =     0.546000
        icol =  6

C SCA_21:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.64) THEN
        BSa1 =     0.018700
        BSb1 =     0.000000
        BSc1 =     0.010500
        BSd1 =     0.400000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.658000
        BSr2 =     0.104000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.270000
        BSt2 =     0.007570
        BSy2 =     0.000000
        BSa2 =     2.110000
        BSb2 =     0.000000
        BSc2 =     0.429000
        BSd2 =     0.206000
        BSe2 =     0.187000
        BSf2 =     0.110000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.008890
        BSb3 =    -0.010100
        BSc3 =     0.000000
        BSe3 =     0.075700
        BSf3 =     0.179000
        BSg3 =     0.000000
        BSh3 =     0.673000
        BSi3 =     0.000000
        BSa4 =     1.849000
        BSb4 =     0.674000
        BSc4 =     0.432000
        icol =  6

C SCA_22:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - thermal break around edge of slab
C   - vertical skirt extends from bottom of slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.65) THEN
        BSa1 =     0.049100
        BSb1 =     0.000000
        BSc1 =     0.020900
        BSd1 =     0.457000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.616000
        BSr2 =     0.103000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.265000
        BSt2 =     0.008140
        BSy2 =     0.000000
        BSa2 =     2.099000
        BSb2 =     0.000000
        BSc2 =     0.421000
        BSd2 =     0.203000
        BSe2 =     0.203000
        BSf2 =     0.108000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.009400
        BSb3 =    -0.011100
        BSc3 =     0.000000
        BSe3 =     0.088700
        BSf3 =     0.177000
        BSg3 =     0.000000
        BSh3 =     0.675000
        BSi3 =     0.000000
        BSa4 =     1.919000
        BSb4 =     0.635000
        BSc4 =     0.417000
        icol =  6

C SCA_23:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - horizontal skirt extends from slab
C   - first storey is non-brick veneer or bricks thermally broken from concrete
C     floor
      ELSEIF(iconfig.eq.66) THEN
        BSa1 =     0.012300
        BSb1 =     0.000000
        BSc1 =     0.008490
        BSd1 =     0.477000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.684000
        BSr2 =     0.101000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.251000
        BSt2 =     0.008190
        BSy2 =     0.000000
        BSa2 =     2.220000
        BSb2 =     0.000000
        BSc2 =     0.404000
        BSd2 =     0.193000
        BSe2 =     0.188000
        BSf2 =     0.109000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.001580
        BSb3 =    -0.028100
        BSc3 =     0.000000
        BSe3 =     0.128000
        BSf3 =     0.203000
        BSg3 =     0.000000
        BSh3 =     0.588000
        BSi3 =     0.000000
        BSa4 =     2.395000
        BSb4 =     0.253000
        BSc4 =     0.893000
        icol =  6

C SCA_24:
C   - concrete or soil (for crawl space) floor
C   - top of slab fully insulated
C   - horizontal skirt extends from slab
C   - first storey brick veneer placed directly on concrete slab
      ELSEIF(iconfig.eq.67) THEN
        BSa1 =     0.028200
        BSb1 =     0.000000
        BSc1 =     0.018400
        BSd1 =     0.543000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.663000
        BSr2 =     0.100000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.246000
        BSt2 =     0.007990
        BSy2 =     0.000000
        BSa2 =     2.207000
        BSb2 =     0.000000
        BSc2 =     0.397000
        BSd2 =     0.189000
        BSe2 =     0.196000
        BSf2 =     0.107000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.005900
        BSb3 =    -0.028000
        BSc3 =     0.000000
        BSe3 =     0.155000
        BSf3 =     0.197000
        BSg3 =     0.000000
        BSh3 =     0.589000
        BSi3 =     0.000000
        BSa4 =     2.373000
        BSb4 =     0.292000
        BSc4 =     0.674000
        icol =  6

      ELSE
        call edisp(IUOUT,'Not a valid iconfig.')

      ENDIF
      RETURN
      END


C ******************** COEFEXT2 ********************
C BASESIMP coefficients for configurations generated by
C Debra Haltrecht, 1998.

      SUBROUTINE COEFEXT2(iconfig)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/Dsumuo/BSa1,BSb1,BSc1,BSd1,BSe1,BSf1,BSg1,BSh1,BSi1,BSj1
      COMMON/Dsumur/BSq2,BSr2,BSu2,BSv2,BSw2,BSx2,BSs2,BSt2,BSy2,BSa2,
     &              BSb2,BSc2,BSd2,BSe2,BSf2,BSg2,BSh2
      COMMON/Datten/BSa3,BSb3,BSc3,BSe3,BSf3,BSg3,BSh3,BSi3
      COMMON/Dphase/BSa4,BSb4,BSc4
      COMMON/Dcorn/icol

C This subroutine sets BASESIMP correlation coefficients and the
C `corner-correction column number' for the BASESIMP configuration under
C consideration. It supports the set of configurations generated by Debra
C Haltrecht in 1998.

C It sets the coefficients based on the passed `iconfig' number. The
C coefficients are placed in the Dsumuo, Dsumur, Datten, Dphase, and Dcorn
C common blocks.

C The correlation coefficients are described in:
C    Beausoleil-Morrison I., `BASESIMP: A Simplified Foundation Energy-Loss
C    Model Derived from BASECALC Simulations', NRCan internal report, 1996.

C The `corner-correction column number' refers to columns of Table 1 and
C Table 2 in:
C    Beausoleil-Morrison, Mitalas, and Chin (1992), `Estimating Three-Dimensional
C    Below-Grade Heat Losses from Houses Using Two-Dimensional Calculations',
C    Proceedings of Thermal Performance of the Exterior Envelopes of Buildings VI,
C    ASHRAE, pp. 95-99.
C icol = 1 for column 1 of Table 1.  icol = 5 for column1 of Table 2.


      IF(iconfig.eq.68) THEN
C BCCN_3:
C    - concrete walls and floor
C    - interior surface of wall insulated over full-height
C    - exterior surface of wall insulated over full-height
C    - thermal-break between walls and floor slab
C    - any first storey construction type
        BSa1 =     0.066000
        BSb1 =     0.384000
        BSc1 =     0.021000
        BSd1 =     1.072000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.080000
        BSq2 =     0.134000
        BSr2 =     0.352000
        BSu2 =     0.118000
        BSv2 =     0.620000
        BSw2 =     0.690000
        BSx2 =     0.500000
        BSs2 =    -0.012000
        BSt2 =     0.024000
        BSy2 =     0.176000
        BSa2 =     0.948000
        BSb2 =     0.449000
        BSc2 =     0.262000
        BSd2 =     0.372000
        BSe2 =     3.845000
        BSf2 =    -0.116000
        BSg2 =    -1.323000
        BSh2 =     0.000000
        BSa3 =     0.040000
        BSb3 =     0.275000
        BSc3 =    -0.123000
        BSe3 =     0.060000
        BSf3 =     0.052000
        BSg3 =     0.122000
        BSh3 =     0.948000
        BSi3 =     0.000000
        BSa4 =     1.962000
        BSb4 =     0.775000
        BSc4 =     0.349000
        icol =  3

      ELSEIF(iconfig.eq.69) THEN
C BCCB_4:
C    - concrete walls and floor
C    - interior surface of wall insulated over full-height
C    - exterior surface of wall insulated over full-height
C    - sub-surface of floor slab fully insulated but no insulation under footings
C    - thermal-break between walls and floor slab
C    - any first storey construction type
        BSa1 =     0.095000
        BSb1 =     0.372000
        BSc1 =     0.034000
        BSd1 =     1.030000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.048000
        BSq2 =     0.596000
        BSr2 =    -0.037000
        BSu2 =     0.672000
        BSv2 =     0.620000
        BSw2 =    -3.480000
        BSx2 =     0.735000
        BSs2 =     0.631000
        BSt2 =     0.006000
        BSy2 =    -0.151000
        BSa2 =     3.009000
        BSb2 =     0.159000
        BSc2 =     0.519000
        BSd2 =     0.296000
        BSe2 =     0.285000
        BSf2 =     0.049000
        BSg2 =     0.035000
        BSh2 =     0.000000
        BSa3 =     0.014000
        BSb3 =    -0.002000
        BSc3 =    -0.025000
        BSe3 =     0.099000
        BSf3 =     0.192000
        BSg3 =     0.074000
        BSh3 =     0.779000
        BSi3 =     0.000000
        BSa4 =    -5.952000
        BSb4 =     8.699000
        BSc4 =     0.024000
        icol =  7

      ELSEIF(iconfig.eq.70) THEN
C BCEA_1:
C    - concrete walls and floor
C    - exterior surface of wall insulated over full-height
C    - top of slab fully insulated
C    - first storey brick veneer placed directly on basement's concrete walls
        BSa1 =    -0.084000
        BSb1 =     0.748000
        BSc1 =     0.005000
        BSd1 =     0.883000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.355000
        BSq2 =    -0.024000
        BSr2 =     0.021000
        BSu2 =     0.619000
        BSv2 =     0.620000
        BSw2 =     2.348000
        BSx2 =     0.500000
        BSs2 =    -0.214000
        BSt2 =     0.019000
        BSy2 =     0.095000
        BSa2 =     2.091000
        BSb2 =     0.343000
        BSc2 =     0.571000
        BSd2 =     0.285000
        BSe2 =     0.469000
        BSf2 =     0.174000
        BSg2 =    -0.027000
        BSh2 =     0.000000
        BSa3 =     0.117000
        BSb3 =     0.068000
        BSc3 =    -0.076000
        BSe3 =     0.048000
        BSf3 =     0.214000
        BSg3 =     0.208000
        BSh3 =     0.683000
        BSi3 =     0.000000
        BSa4 =     1.793000
        BSb4 =     1.096000
        BSc4 =     0.092000
        icol =  8

      ELSEIF(iconfig.eq.71) THEN
C BCEA_4:
C    - concrete walls and floor
C    - exterior surface of wall insulated over full-height
C    - top of slab fully insulated
C    - first storey is non-brick veneer or bricks thermally broken from
C      basement's concrete walls
        BSa1 =    -0.037000
        BSb1 =     0.765000
        BSc1 =     0.002900
        BSd1 =     0.888130
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.132000
        BSq2 =     1.189000
        BSr2 =    -0.072000
        BSu2 =     0.584000
        BSv2 =     0.620000
        BSw2 =    -2.634000
        BSx2 =     0.735000
        BSs2 =     0.822000
        BSt2 =     0.006000
        BSy2 =    -0.239000
        BSa2 =     3.472000
        BSb2 =     0.199000
        BSc2 =     0.533000
        BSd2 =     0.283000
        BSe2 =     0.161000
        BSf2 =     0.035000
        BSg2 =     0.035000
        BSh2 =     0.000000
        BSa3 =     0.118000
        BSb3 =     0.068000
        BSc3 =    -0.078000
        BSe3 =     0.044000
        BSf3 =     0.214000
        BSg3 =     0.218000
        BSh3 =     0.683000
        BSi3 =     0.000000
        BSa4 =     1.695000
        BSb4 =     1.197000
        BSc4 =     0.084000
        icol =  8

      ELSEIF(iconfig.eq.72) THEN
C BCIA_1:
C    - concrete walls and floor
C    - interior surface of wall insulated over full-height
C    - top of slab fully insulated
C    - any first storey construction type
        BSa1 =    -0.020400
        BSb1 =     0.760000
        BSc1 =     0.100000
        BSd1 =     0.861000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.008000
        BSq2 =     0.443000
        BSr2 =    -0.029000
        BSu2 =     0.690000
        BSv2 =     0.620000
        BSw2 =    -4.225000
        BSx2 =     0.735000
        BSs2 =     0.556000
        BSt2 =     0.006500
        BSy2 =    -0.117000
        BSa2 =     3.150000
        BSb2 =     0.222000
        BSc2 =     0.507000
        BSd2 =     0.254000
        BSe2 =     0.330000
        BSf2 =     0.054400
        BSg2 =     0.022400
        BSh2 =     0.000000
        BSa3 =    -0.011000
        BSb3 =    -0.031000
        BSc3 =    -0.006000
        BSe3 =     0.193000
        BSf3 =     0.277000
        BSg3 =     0.145000
        BSh3 =     0.664000
        BSi3 =     0.000000
        BSa4 =     2.523000
        BSb4 =     0.385000
        BSc4 =     0.276000
        icol =  6

      ELSE
        call edisp(IUOUT,' Not a valid iconfig.')

      ENDIF
      RETURN
      END


C ******************** COEFEXT3 ********************
C COEFEXT3      BASESIMP coefficients for configurations generated by
C               Julia Purdy in summer of 1999.

      SUBROUTINE COEFEXT3(iconfig)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/Dsumuo/BSa1,BSb1,BSc1,BSd1,BSe1,BSf1,BSg1,BSh1,BSi1,BSj1
      COMMON/Dsumur/BSq2,BSr2,BSu2,BSv2,BSw2,BSx2,BSs2,BSt2,BSy2,BSa2,
     &              BSb2,BSc2,BSd2,BSe2,BSf2,BSg2,BSh2
      COMMON/Datten/BSa3,BSb3,BSc3,BSe3,BSf3,BSg3,BSh3,BSi3
      COMMON/Dphase/BSa4,BSb4,BSc4
      COMMON/Dcorn/icol

C This subroutine sets BASESIMP correlation coefficients and the
C `corner-correction column number' for the BASESIMP configuration under
C consideration. It supports the set of configurations generated by Julia
C Purdy in the summer of 1999.

C It sets the coefficients based on the passed `iconfig' number. The
C coefficients are placed in the Dsumuo, Dsumur, Datten, Dphase, and Dcorn
C common blocks.

C The correlation coefficients are described in:
C    Beausoleil-Morrison I., `BASESIMP: A Simplified Foundation Energy-Loss
C    Model Derived from BASECALC Simulations', NRCan internal report, 1996.

C The `corner-correction column number' refers to columns of Table 1 and
C Table 2 in:
C    Beausoleil-Morrison, Mitalas, and Chin (1992), `Estimating Three-Dimensional
C    Below-Grade Heat Losses from Houses Using Two-Dimensional Calculations',
C    Proceedings of Thermal Performance of the Exterior Envelopes of Buildings VI,
C    ASHRAE, pp. 95-99.
C icol = 1 for column 1 of Table 1.  icol = 5 for column1 of Table 2.


      IF(iconfig.eq.73) THEN
C BCIA_4:
C    - concrete walls and floor
C    - interior surface of wall insulated to 0.2m above floor
C    - full insulation above slab
C    - first-storey brick with no thermal breaks
        BSa1 =    -0.071230
        BSb1 =     0.760347
        BSc1 =     0.131294
        BSd1 =     0.785350
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.036898
        BSq2 =     0.773493
        BSr2 =    -0.027347
        BSu2 =     0.450354
        BSv2 =     0.620000
        BSw2 =    -4.899600
        BSx2 =     0.735000
        BSs2 =     0.590526
        BSt2 =     0.007582
        BSy2 =    -0.086467
        BSa2 =     4.715540
        BSb2 =     0.113200
        BSc2 =     0.551280
        BSd2 =     0.319280
        BSe2 =     0.126000
        BSf2 =     0.027226
        BSg2 =     0.027579
        BSh2 =     0.000000
        BSa3 =     0.294070
        BSb3 =     0.081500
        BSc3 =    -0.106280
        BSe3 =     0.062620
        BSf3 =     0.243660
        BSg3 =     0.144810
        BSh3 =     0.724765
        BSi3 =     0.000000
        BSa4 =     2.876000
        BSb4 =     0.064696
        BSc4 =     0.276000
        icol =  6

      ELSEIF(iconfig.eq.74) THEN
C BCEA_7:
C    - concrete walls and floor
C    - exterior surface of wall insulated below grade only
C    - full insulation above slab
C    - first-storey brick with no thermal breaks
        BSa1 =     0.198990
        BSb1 =     2.918970
        BSc1 =     0.006260
        BSd1 =    -0.002425
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.010190
        BSr2 =     0.020820
        BSu2 =     0.881412
        BSv2 =     0.620000
        BSw2 =     1.954236
        BSx2 =     0.500000
        BSs2 =    -0.275610
        BSt2 =     0.020197
        BSy2 =     0.086238
        BSa2 =     2.211346
        BSb2 =     0.331075
        BSc2 =     0.530859
        BSd2 =     0.316900
        BSe2 =     0.228122
        BSf2 =     0.228748
        BSg2 =     0.045537
        BSh2 =     0.000000
        BSa3 =     0.704441
        BSb3 =     0.061763
        BSc3 =    -0.222700
        BSe3 =    -0.077969
        BSf3 =     0.201850
        BSg3 =     0.246550
        BSh3 =     0.666425
        BSi3 =     0.000000
        BSa4 =     3.032800
        BSb4 =    -0.049830
        BSc4 =     0.411000
        icol =  4

      ELSEIF(iconfig.eq.75) THEN
C BCEA_8:
C    - concrete walls and floor
C    - exterior surface of wall insulated below grade only
C    - full insulation above slab
C    - first-storey non-brick with a thermal break
        BSa1 =     0.124817
        BSb1 =     2.949200
        BSc1 =     0.006070
        BSd1 =    -0.002375
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =     0.010425
        BSr2 =     0.020505
        BSu2 =     0.885840
        BSv2 =     0.620000
        BSw2 =     1.985315
        BSx2 =     0.500000
        BSs2 =    -0.274739
        BSt2 =     0.020236
        BSy2 =     0.083996
        BSa2 =     2.217098
        BSb2 =     0.335890
        BSc2 =     0.528369
        BSd2 =     0.317068
        BSe2 =     0.231890
        BSf2 =     0.228317
        BSg2 =     0.041176
        BSh2 =     0.000000
        BSa3 =     0.701859
        BSb3 =     0.061754
        BSc3 =    -0.215070
        BSe3 =    -0.078714
        BSf3 =     0.201920
        BSg3 =     0.278666
        BSh3 =     0.666900
        BSi3 =     0.000000
        BSa4 =     3.036870
        BSb4 =    -0.052290
        BSc4 =     0.426000
        icol =  4
 
      ELSEIF(iconfig.eq.76) THEN
C BCEB_8:
C    - concrete walls and floor
C    - exterior surface of wall insulated  to 0.6m below grade only
C    - full insulation below slab
C    - thermal break between wall and slab
C    - first-storey brick with no thermal breaks
        BSa1 =    -0.083310
        BSb1 =     0.746580
        BSc1 =     0.006320
        BSd1 =     0.878840
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.353700
        BSq2 =    -0.069721
        BSr2 =     0.046983
        BSu2 =     4.049199
        BSv2 =     0.620000
        BSw2 =    -0.029300
        BSx2 =     0.500000
        BSs2 =    -0.023519
        BSt2 =     0.012950
        BSy2 =     0.328888
        BSa2 =     1.520370
        BSb2 =     0.466830
        BSc2 =     0.724090
        BSd2 =     0.110352
        BSe2 =     0.561002
        BSf2 =    -0.009356
        BSg2 =    -0.165070
        BSh2 =     0.000000
        BSa3 =    -0.418600
        BSb3 =     0.277700
        BSc3 =     0.418100
        BSe3 =     0.307104
        BSf3 =     0.135589
        BSg3 =    -0.089250
        BSh3 =     0.747110
        BSi3 =     0.000000
        BSa4 =     2.854400
        BSb4 =     0.072350
        BSc4 =     1.299000
        icol =  8
 
      ELSEIF(iconfig.eq.77) THEN
C BCEB_9:
C    - concrete walls and floor
C    - exterior surface of wall insulated  to 0.6m below grade only
C    - full insulation below slab
C    - thermal break between wall and slab
C    - first-storey non-brick with a thermal break
        BSa1 =    -0.038213
        BSb1 =     0.763880
        BSc1 =     0.003235
        BSd1 =     0.887379
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.119581
        BSq2 =     0.660969
        BSr2 =     0.168863
        BSu2 =     0.112584
        BSv2 =     0.620000
        BSw2 =    -0.020200
        BSx2 =     0.500000
        BSs2 =    -0.206723
        BSt2 =     0.015950
        BSy2 =     0.095326
        BSa2 =     2.152850
        BSb2 =     0.024900
        BSc2 =     0.455866
        BSd2 =     0.360834
        BSe2 =     0.324333
        BSf2 =     0.359352
        BSg2 =    -0.118260
        BSh2 =     0.000000
        BSa3 =    -0.418948
        BSb3 =     0.278115
        BSc3 =     0.418326
        BSe3 =     0.304350
        BSf3 =     0.135980
        BSg3 =    -0.081449
        BSh3 =     0.746450
        BSi3 =     0.000000
        BSa4 =     2.854540
        BSb4 =     0.074000
        BSc4 =     1.254000
        icol =  8
 
      ELSEIF(iconfig.eq.78) THEN
C BWEN_3:
C    - wood walls and floor
C    - exterior surface of wall insulated to 0.6m below grade only
C    - no slab insulation
C    - first-storey brick with no thermal breaks
        BSa1 =    -0.030788
        BSb1 =     0.650499
        BSc1 =    -0.000330
        BSd1 =     0.810000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075968
        BSq2 =    -0.162143
        BSr2 =     0.215933
        BSu2 =     0.694206
        BSv2 =     0.620000
        BSw2 =     0.293126
        BSx2 =     0.500000
        BSs2 =     0.067465
        BSt2 =     0.014496
        BSy2 =     0.206205
        BSa2 =     0.615051
        BSb2 =     0.713764
        BSc2 =     0.576454
        BSd2 =    -0.010456
        BSe2 =     0.317440
        BSf2 =    -0.019935
        BSg2 =    -0.097595
        BSh2 =     0.000000
        BSa3 =    -0.267450
        BSb3 =     0.224320
        BSc3 =     0.277777
        BSe3 =     0.207546
        BSf3 =     0.046110
        BSg3 =     0.013254
        BSh3 =     0.677812
        BSi3 =     0.000000
        BSa4 =     2.560000
        BSb4 =     0.347400
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.79) THEN
C BBIB_3:
C    - wood walls and concrete floor
C    - interior surface of wall insulated over full height
C    - full insulation below slab
C    - thermal break between wall and slab
        BSa1 =    -0.012492
        BSb1 =     0.649800
        BSc1 =     0.003403
        BSd1 =     0.804034
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.001523
        BSq2 =     0.393200
        BSr2 =    -0.024024
        BSu2 =     0.681964
        BSv2 =     0.620000
        BSw2 =    -4.663550
        BSx2 =     0.735000
        BSs2 =     0.561570
        BSt2 =     0.006560
        BSy2 =    -0.108203
        BSa2 =     3.118051
        BSb2 =     0.213268
        BSc2 =     0.488352
        BSd2 =     0.263121
        BSe2 =     0.315049
        BSf2 =     0.052232
        BSg2 =     0.018485
        BSh2 =     0.000000
        BSa3 =     0.006841
        BSb3 =    -0.040390
        BSc3 =    -0.006733
        BSe3 =     0.134274
        BSf3 =     0.253267
        BSg3 =     0.145490
        BSh3 =     0.587305
        BSi3 =     0.000000
        BSa4 =     2.466150
        BSb4 =     0.485450
        BSc4 =     1.000000
        icol =  7

      ELSEIF(iconfig.eq.80) THEN
C BBIB_4:
C    - wood walls and concrete floor
C    - interior surface of wall insulated to 0.6m below grade only
C    - full insulation below slab
C    - thermal break between wall and slab
        BSa1 =    -0.013814
        BSb1 =     0.650135
        BSc1 =     0.002998
        BSd1 =     0.808695
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.003843
        BSq2 =     0.222760
        BSr2 =     0.149651
        BSu2 =     0.388961
        BSv2 =     0.620000
        BSw2 =    -0.204761
        BSx2 =     0.500000
        BSs2 =    -0.454127
        BSt2 =     0.017890
        BSy2 =     0.205281
        BSa2 =     2.210061
        BSb2 =    -0.005805
        BSc2 =     0.520561
        BSd2 =     0.327860
        BSe2 =     0.770500
        BSf2 =     0.225836
        BSg2 =    -0.285055
        BSh2 =     0.000000
        BSa3 =    -0.470070
        BSb3 =     0.135941
        BSc3 =     0.495440
        BSe3 =     0.397302
        BSf3 =     0.174450
        BSg3 =    -0.176874
        BSh3 =     0.640170
        BSi3 =     0.000000
        BSa4 =     2.671512
        BSb4 =     0.236990
        BSc4 =     1.000000
        icol =  7
 
      ELSEIF(iconfig.eq.81) THEN
C SCB_31:
C    - concrete slab floor
C    - bottom of slab fully insulated 
C    - insulation under footing
C    - thermal break around edge of slab
C    - first-storey is non-brick or brick thermally broken from slab
        BSa1 =     0.037138
        BSb1 =     0.000000
        BSc1 =     0.000693
        BSd1 =    -0.100380
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.735360
        BSr2 =     0.096844
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.243830
        BSt2 =     0.000000
        BSy2 =     0.000000
        BSa2 =     2.378200
        BSb2 =     0.000000
        BSc2 =     0.387290
        BSd2 =     0.176850
        BSe2 =     0.161380
        BSf2 =     0.108647
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.006050
        BSb3 =    -0.060180
        BSc3 =     0.000000
        BSe3 =     0.137650
        BSf3 =     0.276020
        BSg3 =     0.000000
        BSh3 =     0.483710
        BSi3 =     0.000000
        BSa4 =     2.657300
        BSb4 =     0.156290
        BSc4 =     0.000000
        icol =  7
 
      ELSEIF(iconfig.eq.82) THEN
C SCB_32:
C    - concrete slab floor
C    - bottom of slab fully insulated 
C    - insulation under footing
C    - thermal break around edge of slab
C    - first-storey is brick placed directly on concrete slab
        BSa1 =     0.085100
        BSb1 =     0.000000
        BSc1 =     0.001800
        BSd1 =    -0.090300
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -1.556000
        BSr2 =     0.099600
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.254100
        BSt2 =     0.008000
        BSy2 =     0.000000
        BSa2 =     2.227000
        BSb2 =     0.000000
        BSc2 =     0.401800
        BSd2 =     0.170700
        BSe2 =     0.160700
        BSf2 =     0.112400
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.047000
        BSb3 =    -0.055000
        BSc3 =     0.000000
        BSe3 =     0.119000
        BSf3 =     0.269000
        BSg3 =     0.000000
        BSh3 =     0.500700
        BSi3 =     0.000000
        BSa4 =     2.737000
        BSb4 =     0.043200
        BSc4 =     0.000000
        icol =  7

      ELSEIF(iconfig.eq.83) THEN
C SCB_37:
C    - concrete slab floor
C    - bottom of slab insulated 0.35m around perimeter
C    - insulation also placed under footing, creating a 0.6 m continuous
C      section of insulation
C    - thermal break around edge of slab
C    - first-storey is non-brick or brick thermally broken from slab
        BSa1 =     0.039517
        BSb1 =     0.000000
        BSc1 =     0.000185
        BSd1 =    -0.083530
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.292589
        BSr2 =     0.417510
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.521346
        BSt2 =     0.016540
        BSy2 =     0.000000
        BSa2 =     1.980200
        BSb2 =     0.000000
        BSc2 =     0.826860
        BSd2 =     0.190353
        BSe2 =     0.031480
        BSf2 =    -0.008430
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.095980
        BSb3 =     0.454060
        BSc3 =     0.000000
        BSe3 =     0.116340
        BSf3 =     0.006612
        BSg3 =     0.000000
        BSh3 =     0.459470
        BSi3 =     0.000000
        BSa4 =     2.615900
        BSb4 =     0.159950
        BSc4 =     0.296200
        icol =  3

      ELSEIF(iconfig.eq.84) THEN
C SCB_38:
C    - concrete slab floor
C    - bottom of slab insulated 0.35m around perimeter
C    - insulation also placed under footing, creating a 0.6 m continuous
C      section of insulation
C    - thermal break around edge of slab
C    - first-storey is brick placed directly on concrete slab
        BSa1 =     0.088380
        BSb1 =     0.000000
        BSc1 =     0.002409
        BSd1 =    -0.068600
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.266900
        BSr2 =     0.420750
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.535850
        BSt2 =     0.015980
        BSy2 =     0.000000
        BSa2 =     2.018850
        BSb2 =     0.000000
        BSc2 =     0.801370
        BSd2 =     0.184610
        BSe2 =     0.019588
        BSf2 =    -0.005032
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.064300
        BSb3 =     0.453470
        BSc3 =     0.000000
        BSe3 =     0.109440
        BSf3 =     0.004804
        BSg3 =     0.000000
        BSh3 =     0.440260
        BSi3 =     0.000000
        BSa4 =     2.664500
        BSb4 =     0.131514
        BSc4 =     0.285300
        icol =  3

      ELSEIF(iconfig.eq.85) THEN
C SCB_39:
C    - concrete slab floor
C    - bottom of slab insulated 0.75m around perimeter
C    - insulation also placed under footing, creating a 1.0 m continuous
C      section of insulation
C    - thermal break around edge of slab
C    - first-storey is non-brick or brick thermally broken from slab
        BSa1 =     0.040500
        BSb1 =     0.000000
        BSc1 =    -0.000900
        BSd1 =    -0.096100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.127100
        BSr2 =     0.386500
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.522600
        BSt2 =     0.010600
        BSy2 =     0.000000
        BSa2 =     1.925000
        BSb2 =     0.000000
        BSc2 =     0.798000
        BSd2 =     0.198600
        BSe2 =     0.058700
        BSf2 =    -0.014200
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.105000
        BSb3 =     0.376000
        BSc3 =     0.000000
        BSe3 =     0.141500
        BSf3 =     0.027700
        BSg3 =     0.000000
        BSh3 =     0.539800
        BSi3 =     0.000000
        BSa4 =     2.401500
        BSb4 =     0.341100
        BSc4 =     0.246600
        icol =  3
 
      ELSEIF(iconfig.eq.86) THEN
C SCB_40:
C    - concrete slab floor
C    - bottom of slab insulated 0.75m around perimeter
C    - insulation also placed under footing, creating a 1.0 m continuous
C      section of insulation
C    - thermal break around edge of slab
C    - first-storey is brick placed directly on concrete slab
        BSa1 =     0.090763
        BSb1 =     0.000000
        BSc1 =    -0.002720
        BSd1 =    -0.081400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.106820
        BSr2 =     0.390350
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.535410
        BSt2 =     0.010430
        BSy2 =     0.000000
        BSa2 =     1.960170
        BSb2 =     0.000000
        BSc2 =     0.773957
        BSd2 =     0.192200
        BSe2 =     0.042120
        BSf2 =    -0.009680
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.075860
        BSb3 =     0.379150
        BSc3 =     0.000000
        BSe3 =     0.135920
        BSf3 =     0.022610
        BSg3 =     0.000000
        BSh3 =     0.534300
        BSi3 =     0.000000
        BSa4 =     2.512200
        BSb4 =     0.253350
        BSc4 =     0.266500
        icol =  3

      ELSEIF(iconfig.eq.108) THEN
C BBIN_1:
C    - interior surface of wall insulated over full-height
C    - first-storey is non-brick veneer or bricks thermally broken from
C      basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.012900
        BSb1 =     0.649900
        BSc1 =     0.002300
        BSd1 =     0.803769
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002992
        BSq2 =     0.269209
        BSr2 =     0.314870
        BSu2 =     0.214797
        BSv2 =     0.620000
        BSw2 =     0.727638
        BSx2 =     0.500000
        BSs2 =    -0.049231
        BSt2 =     0.023589
        BSy2 =     0.178418
        BSa2 =     0.715430
        BSb2 =     0.796889
        BSc2 =     0.391086
        BSd2 =     0.293721
        BSe2 =     2.930860
        BSf2 =    -0.057227
        BSg2 =    -0.986300
        BSh2 =     0.000000
        BSa3 =     0.195559
        BSb3 =     0.310135
        BSc3 =    -0.180597
        BSe3 =     0.009348
        BSf3 =     0.086330
        BSg3 =     0.213013
        BSh3 =     0.634290
        BSi3 =     0.000000
        BSa4 =     1.781950
        BSb4 =     1.029925
        BSc4 =     0.131120
        icol =  3

      ELSEIF(iconfig.eq.109) THEN
C BCEN_5:
C    - exterior surface of wall insulated to 0.6m below-grade
C    - first-storey brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.082700
        BSb1 =     0.747400
        BSc1 =     0.004940
        BSd1 =     0.880900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.354900
        BSq2 =     0.765400
        BSr2 =     0.457780
        BSu2 =     0.193889
        BSv2 =     0.620000
        BSw2 =     0.376500
        BSx2 =     0.500000
        BSs2 =    -0.002930
        BSt2 =     0.022400
        BSy2 =     0.143538
        BSa2 =     0.347228
        BSb2 =     0.872426
        BSc2 =     0.624580
        BSd2 =     0.123450
        BSe2 =     1.337000
        BSf2 =    -0.098390
        BSg2 =    -0.464230
        BSh2 =     0.000000
        BSa3 =    -0.399600
        BSb3 =     0.515790
        BSc3 =     0.266200
        BSe3 =     0.253600
        BSf3 =     0.031260
        BSg3 =    -0.013035
        BSh3 =     0.797335
        BSi3 =     0.000000
        BSa4 =     2.711700
        BSb4 =     0.191900
        BSc4 =     0.498570
        icol =  5

      ELSEIF(iconfig.eq.110) THEN
C BCEN_6:
C    - exterior surface of wall insulated to 0.6m below-grade
C    - first-storey is non-brick veneer or bricks thermally broken from
C      basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.037530
        BSb1 =     0.764620
        BSc1 =     0.002210
        BSd1 =     0.887900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120195
        BSq2 =     0.770237
        BSr2 =     0.459580
        BSu2 =     0.194470
        BSv2 =     0.620000
        BSw2 =     0.373630
        BSx2 =     0.500000
        BSs2 =    -0.003087
        BSt2 =     0.022389
        BSy2 =     0.144460
        BSa2 =     0.347840
        BSb2 =     0.879500
        BSc2 =     0.615230
        BSd2 =     0.113790
        BSe2 =     1.334200
        BSf2 =    -0.100500
        BSg2 =    -0.458800
        BSh2 =     0.000000
        BSa3 =    -0.340350
        BSb3 =     0.516170
        BSc3 =     0.266680
        BSe3 =     0.251100
        BSf3 =     0.031627
        BSg3 =    -0.005400
        BSh3 =     0.794950
        BSi3 =     0.000000
        BSa4 =     2.710660
        BSb4 =     0.195060
        BSc4 =     0.493950
        icol =  5
 
      ELSEIF(iconfig.eq.111) THEN
C BBIA_1:
C    - interior surface of wall insulated over full-height
C    - top-surface of floor slab fully insulated
C    - slab and wall insulation have same thermal resistance
C    - any first storey construction
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.012480
        BSb1 =     0.649810
        BSc1 =     0.003444
        BSd1 =     0.804040
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.001512
        BSq2 =     0.422447
        BSr2 =    -0.024940
        BSu2 =     0.681265
        BSv2 =     0.620000
        BSw2 =    -4.687400
        BSx2 =     0.735000
        BSs2 =     0.529814
        BSt2 =     0.006118
        BSy2 =    -0.096650
        BSa2 =     3.277222
        BSb2 =     0.192607
        BSc2 =     0.493670
        BSd2 =     0.265127
        BSe2 =     0.293738
        BSf2 =     0.049900
        BSg2 =     0.021455
        BSh2 =     0.000000
        BSa3 =     0.008850
        BSb3 =    -0.044900
        BSc3 =    -0.008220
        BSe3 =     0.151468
        BSf3 =     0.265000
        BSg3 =     0.134320
        BSh3 =     0.575730
        BSi3 =     0.000000
        BSa4 =     2.458470
        BSb4 =     0.483090
        BSc4 =     1.000000
        icol =  6

      ELSEIF(iconfig.eq.112) THEN
C BBIB_1:
C    - interior surface of wall insulated over full height
C    - sub-surface of floor slab insulated with a 0.6m strip around perimeter
C    - slab and wall insulation have same thermal resistance
C    - any first storey construction
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.012880
        BSb1 =     0.649900
        BSc1 =     0.002346
        BSd1 =     0.803777
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002950
        BSq2 =     0.103510
        BSr2 =     0.330900
        BSu2 =     0.214500
        BSv2 =     0.620000
        BSw2 =     0.722600
        BSx2 =     0.500000
        BSs2 =    -0.062340
        BSt2 =     0.025200
        BSy2 =     0.177360
        BSa2 =     0.718550
        BSb2 =     0.761550
        BSc2 =     0.382000
        BSd2 =     0.278350
        BSe2 =     2.910330
        BSf2 =    -0.051470
        BSg2 =    -0.976010
        BSh2 =     0.000000
        BSa3 =     0.185250
        BSb3 =     0.298400
        BSc3 =    -0.173000
        BSe3 =     0.012660
        BSf3 =     0.087635
        BSg3 =     0.212620
        BSh3 =     0.635980
        BSi3 =     0.000000
        BSa4 =     1.671200
        BSb4 =     1.140200
        BSc4 =     0.120000
        icol =  7

      ELSEIF(iconfig.eq.113) THEN
C BBIB_2:
C    - interior surface of wall insulated over full-height
C    - sub-surface of floor slab fully insulated but no insulation below footings
C    - slab and wall insulation have same thermal resistance
C    - any first storey construction
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.013000
        BSb1 =     0.649850
        BSc1 =     0.003350
        BSd1 =     0.803740
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002180
        BSq2 =     0.928299
        BSr2 =    -0.052500
        BSu2 =     0.622920
        BSv2 =     0.620000
        BSw2 =    -2.922000
        BSx2 =     0.735000
        BSs2 =     0.711757
        BSt2 =     0.008103
        BSy2 =    -0.187300
        BSa2 =     3.347700
        BSb2 =     0.165700
        BSc2 =     0.510060
        BSd2 =     0.270720
        BSe2 =     0.175190
        BSf2 =     0.044550
        BSg2 =     0.037400
        BSh2 =     0.000000
        BSa3 =     0.173880
        BSb3 =     0.034540
        BSc3 =    -0.069000
        BSe3 =     0.034100
        BSf3 =     0.226800
        BSg3 =     0.163500
        BSh3 =     0.593769
        BSi3 =     0.000000
        BSa4 =     2.434300
        BSb4 =     0.403470
        BSc4 =     0.201620
        icol =  7

      ELSEIF(iconfig.eq.114) THEN
C BCCB_9:
C    - exterior surface of wall insulated to 0.6m below grade
C    - interior surface of wall insulated over full height
C    - sub-surface of floor slab fully insulated but no insulation under footings
C    - sub slab and wall insulation have same thermal resistance 
C    - any first storey construction
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =     0.092179
        BSb1 =     0.371259
        BSc1 =     0.048327
        BSd1 =     0.962350
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.030159
        BSq2 =     0.524800
        BSr2 =    -0.033659
        BSu2 =     0.659850
        BSv2 =     0.620000
        BSw2 =    -3.919500
        BSx2 =     0.735000
        BSs2 =     0.591498
        BSt2 =     0.006708
        BSy2 =    -0.128440
        BSa2 =     3.057845
        BSb2 =     0.218556
        BSc2 =     0.535304
        BSd2 =     0.282197
        BSe2 =     0.280364
        BSf2 =     0.056400
        BSg2 =     0.033100
        BSh2 =     0.000000
        BSa3 =     0.000966
        BSb3 =    -0.018830
        BSc3 =    -0.011740
        BSe3 =     0.027200
        BSf3 =     0.245900
        BSg3 =     0.138780
        BSh3 =     0.665040
        BSi3 =     0.000000
        BSa4 =     2.420990
        BSb4 =     0.417256
        BSc4 =     1.000000
        icol =  7

      ELSEIF(iconfig.eq.115) THEN
C BCCB_10:
C    - exterior surface of wall insulated to 0.6m below grade 
C    - interior surface of wall insulated over full height
C    - sub-surface of floor slab insulated with a 0.6m strip around perimeter
C      but no insulation under footings
C    - sub slab and wall insulation have same thermal resistance 
C    - any first floor construction
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =     0.062090
        BSb1 =     0.378913
        BSc1 =     0.039857
        BSd1 =     0.978853
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.060326
        BSq2 =     7.487250
        BSr2 =    -0.452186
        BSu2 =     0.066454
        BSv2 =     0.620000
        BSw2 =    -2.818540
        BSx2 =     0.735000
        BSs2 =     1.244550
        BSt2 =    -0.000196
        BSy2 =    -0.281688
        BSa2 =     7.284925
        BSb2 =     0.192060
        BSc2 =     0.810250
        BSd2 =     0.570720
        BSe2 =     0.056399
        BSf2 =    -0.017679
        BSg2 =     0.018369
        BSh2 =     0.000000
        BSa3 =     0.041629
        BSb3 =     0.249299
        BSc3 =    -0.096260
        BSe3 =    -0.019194
        BSf3 =     0.093779
        BSg3 =     0.178270
        BSh3 =     0.794877
        BSi3 =     0.000000
        BSa4 =     2.374770
        BSb4 =     0.454750
        BSc4 =     1.000000
        icol =  7

      ELSEIF(iconfig.eq.120) THEN
C BBEB_2:
C    - exterior surface of wall insulated to 0.6 m below grade
C    - bottom of slab fully insulated but no insulation under footings
C    - first-storey brick veneer placed directly on basement's concrete walls
C    - thermal break between slab and wall
C    - slab, wall, and thermal break insulation have same thermal resistance
C    - 50 mm wood wall and 100 mm and concrete floor
        BSa1 =    -0.030759
        BSb1 =     0.651000
        BSc1 =     0.000081
        BSd1 =     0.809100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075460
        BSq2 =     0.504520
        BSr2 =    -0.032000
        BSu2 =     0.675600
        BSv2 =     0.620000
        BSw2 =    -3.911500
        BSx2 =     0.730000
        BSs2 =     0.617160
        BSt2 =     0.007200
        BSy2 =    -0.134500
        BSa2 =     3.076800
        BSb2 =     0.222400
        BSc2 =     0.490900
        BSd2 =     0.265700
        BSe2 =     0.280100
        BSf2 =     0.056400
        BSg2 =     0.022360
        BSh2 =     0.000000
        BSa3 =     0.034480
        BSb3 =    -0.032400
        BSc3 =    -0.018500
        BSe3 =     0.092230
        BSf3 =     0.244000
        BSg3 =     0.168100
        BSh3 =     0.574200
        BSi3 =     0.000000
        BSa4 =     2.502000
        BSb4 =     0.432500
        BSc4 =     1.000000
        icol =  8

      ELSE
        call edisp(IUOUT,' Not a valid iconfig.')

      ENDIF
      RETURN
      END


C ******************** COEFEXT4 ********************
C COEFEXT4      BASESIMP coefficients for configurations generated by
C               Kamel Haddad in summer of 1999.

      SUBROUTINE COEFEXT4(iconfig)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/Dsumuo/BSa1,BSb1,BSc1,BSd1,BSe1,BSf1,BSg1,BSh1,BSi1,BSj1
      COMMON/Dsumur/BSq2,BSr2,BSu2,BSv2,BSw2,BSx2,BSs2,BSt2,BSy2,BSa2,
     &              BSb2,BSc2,BSd2,BSe2,BSf2,BSg2,BSh2
      COMMON/Datten/BSa3,BSb3,BSc3,BSe3,BSf3,BSg3,BSh3,BSi3
      COMMON/Dphase/BSa4,BSb4,BSc4
      COMMON/Dcorn/icol

C This subroutine sets BASESIMP correlation coefficients and the
C `corner-correction column number' for the BASESIMP configuration under
C consideration. It supports the set of configurations generated by Kamel
C Haddad in the summer of 1999.

C It sets the coefficients based on the passed `iconfig' number. The
C coefficients are placed in the Dsumuo, Dsumur, Datten, Dphase, and Dcorn
C common blocks.

C The correlation coefficients are described in:
C    Beausoleil-Morrison I., `BASESIMP: A Simplified Foundation Energy-Loss
C    Model Derived from BASECALC Simulations', NRCan internal report, 1996.

C The `corner-correction column number' refers to columns of Table 1 and
C Table 2 in:
C    Beausoleil-Morrison, Mitalas, and Chin (1992), `Estimating Three-Dimensional
C    Below-Grade Heat Losses from Houses Using Two-Dimensional Calculations',
C    Proceedings of Thermal Performance of the Exterior Envelopes of Buildings VI,
C    ASHRAE, pp. 95-99.
C icol = 1 for column 1 of Table 1.  icol = 5 for column1 of Table 2.


      IF(iconfig.eq.87) THEN
C BBEB_1:
C    - wood wall and concrete slab
C    - exterior surface of wall fully insulated
C    - bottom of slab fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.030700
        BSb1 =     0.650000
        BSc1 =    -0.000065
        BSd1 =     0.809000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075400
        BSq2 =     0.604000
        BSr2 =    -0.038200
        BSu2 =     0.675000
        BSv2 =     0.620000
        BSw2 =    -3.429000
        BSx2 =     0.730000
        BSs2 =     0.645000
        BSt2 =     0.007040
        BSy2 =    -0.156000
        BSa2 =     3.101000
        BSb2 =     0.211000
        BSc2 =     0.491000
        BSd2 =     0.264000
        BSe2 =     0.274000
        BSf2 =     0.056700
        BSg2 =     0.024500
        BSh2 =     0.000000
        BSa3 =     0.038500
        BSb3 =    -0.032000
        BSc3 =    -0.020300
        BSe3 =     0.106000
        BSf3 =     0.248000
        BSg3 =     0.160000
        BSh3 =     0.572000
        BSi3 =     0.000000
        BSa4 =     3.109000
        BSb4 =    -0.292000
        BSc4 =    -0.313000
        icol =  8
 
      ELSEIF(iconfig.eq.88) THEN
C BBEN_1:
C    - wood wall and concrete slab
C    - exterior surface of wall fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.030500
        BSb1 =     0.650000
        BSc1 =    -0.000394
        BSd1 =     0.809000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075700
        BSq2 =     8.622000
        BSr2 =    -0.503000
        BSu2 =     0.097300
        BSv2 =     0.620000
        BSw2 =    -2.535000
        BSx2 =     0.730000
        BSs2 =     1.361000
        BSt2 =    -0.003860
        BSy2 =    -0.334000
        BSa2 =     7.643000
        BSb2 =     0.188000
        BSc2 =     0.775000
        BSd2 =     0.562000
        BSe2 =     0.071200
        BSf2 =    -0.024400
        BSg2 =     0.018700
        BSh2 =     0.000000
        BSa3 =     0.085000
        BSb3 =     0.269000
        BSc3 =    -0.142000
        BSe3 =     0.056200
        BSf3 =     0.088800
        BSg3 =     0.217000
        BSh3 =     0.632000
        BSi3 =     0.000000
        BSa4 =    13.055000
        BSb4 =   -10.259000
        BSc4 =    -0.015400
        icol =  5

      ELSEIF(iconfig.eq.89) THEN
C BBEN_2:
C    - wood wall and concrete slab
C    - exterior surface of wall insulated to 0.6 m below grade
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.030400
        BSb1 =     0.650000
        BSc1 =    -0.000727
        BSd1 =     0.810000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.076200
        BSq2 =     7.651000
        BSr2 =    -0.505000
        BSu2 =     0.098300
        BSv2 =     0.620000
        BSw2 =    -2.685000
        BSx2 =     0.730000
        BSs2 =     1.407000
        BSt2 =    -0.000380
        BSy2 =    -0.338000
        BSa2 =     6.665000
        BSb2 =     0.285000
        BSc2 =     0.781000
        BSd2 =     0.514000
        BSe2 =     0.072800
        BSf2 =    -0.013600
        BSg2 =    -0.014500
        BSh2 =     0.000000
        BSa3 =    -0.236000
        BSb3 =     0.400000
        BSc3 =     0.194000
        BSe3 =     0.221000
        BSf3 =     0.045400
        BSg3 =     0.002140
        BSh3 =     0.662000
        BSi3 =     0.000000
        BSa4 =     2.488000
        BSb4 =     0.334000
        BSc4 =     0.333000
        icol =  4

      ELSEIF(iconfig.eq.90) THEN
C BBIA_2:
C    - wood wall and concrete slab
C    - interior surface of wall fully insulated
C    - top of slab insulated with a 0.6 m strip around the perimeter
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.012700
        BSb1 =     0.649800
        BSc1 =     0.002400
        BSd1 =     0.803900
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002700
        BSq2 =    -0.033900
        BSr2 =     0.347000
        BSu2 =     0.200000
        BSv2 =     0.620000
        BSw2 =     0.690000
        BSx2 =     0.500000
        BSs2 =    -0.054600
        BSt2 =     0.025400
        BSy2 =     0.179400
        BSa2 =     0.730900
        BSb2 =     0.685000
        BSc2 =     0.372000
        BSd2 =     0.221000
        BSe2 =     2.535000
        BSf2 =    -0.025100
        BSg2 =    -0.826000
        BSh2 =     0.000000
        BSa3 =     0.133000
        BSb3 =     0.256000
        BSc3 =    -0.151000
        BSe3 =     0.035700
        BSf3 =     0.101000
        BSg3 =     0.210000
        BSh3 =     0.647000
        BSi3 =     0.000000
        BSa4 =    -2.296000
        BSb4 =     5.091000
        BSc4 =     0.031400
        icol =  3
 
      ELSEIF(iconfig.eq.91) THEN
C BBIN_2:
C    - wood wall and concrete slab
C    - interior surface of wall insulated to 0.6 m below grade
C    - first-storey construction is non-brick
        BSa1 =    -0.017500
        BSb1 =     0.650000
        BSc1 =     0.001940
        BSd1 =     0.808200
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.003950
        BSq2 =     7.542000
        BSr2 =    -0.481000
        BSu2 =     0.105000
        BSv2 =     0.620000
        BSw2 =    -2.685000
        BSx2 =     0.730000
        BSs2 =     1.359000
        BSt2 =    -0.001270
        BSy2 =    -0.322000
        BSa2 =     6.883000
        BSb2 =     0.259000
        BSc2 =     0.775000
        BSd2 =     0.501000
        BSe2 =     0.057600
        BSf2 =    -0.009680
        BSg2 =    -0.012600
        BSh2 =     0.000000
        BSa3 =    -0.167000
        BSb3 =     0.429000
        BSc3 =     0.192000
        BSe3 =     0.197000
        BSf3 =     0.045300
        BSg3 =    -0.008610
        BSh3 =     0.662000
        BSi3 =     0.000000
        BSa4 =     2.650000
        BSb4 =     0.198000
        BSc4 =     0.426000
        icol =  2

      ELSEIF(iconfig.eq.92) THEN
C BCCB_8:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - interior surface of wall fully insulated
C    - bottom of slab insulated with a 0.6 m strip around the perimeter
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.031600
        BSb1 =     0.393000
        BSc1 =     0.030400
        BSd1 =     1.090500
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.103000
        BSq2 =     0.064300
        BSr2 =     0.354000
        BSu2 =     0.161000
        BSv2 =     0.620000
        BSw2 =     0.709000
        BSx2 =     0.500000
        BSs2 =    -0.024700
        BSt2 =     0.024200
        BSy2 =     0.175000
        BSa2 =     0.952000
        BSb2 =     0.470000
        BSc2 =     0.299000
        BSd2 =     0.421000
        BSe2 =     4.241000
        BSf2 =    -0.110000
        BSg2 =    -1.500000
        BSh2 =     0.000000
        BSa3 =     0.094600
        BSb3 =     0.291000
        BSc3 =    -0.138000
        BSe3 =     0.055600
        BSf3 =     0.046500
        BSg3 =     0.121000
        BSh3 =     0.914000
        BSi3 =     0.000000
        BSa4 =     2.231000
        BSb4 =     0.526000
        BSc4 =     0.422000
        icol =  7

      ELSEIF(iconfig.eq.93) THEN
C BCCA_7:
C    - concrete wall and slab
C    - exterior surface of wall insulated to 0.6 m below grade
C    - interior surface of wall is fully insulated
C    - top of slab is fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.092100
        BSb1 =     0.371000
        BSc1 =     0.048300
        BSd1 =     0.962000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.030100
        BSq2 =     0.528000
        BSr2 =    -0.033800
        BSu2 =     0.660000
        BSv2 =     0.620000
        BSw2 =    -3.895000
        BSx2 =     0.730000
        BSs2 =     0.591000
        BSt2 =     0.006700
        BSy2 =    -0.128000
        BSa2 =     3.058000
        BSb2 =     0.218000
        BSc2 =     0.535000
        BSd2 =     0.282000
        BSe2 =     0.280000
        BSf2 =     0.056400
        BSg2 =     0.033000
        BSh2 =     0.000000
        BSa3 =     0.000966
        BSb3 =    -0.018800
        BSc3 =    -0.011700
        BSe3 =     0.027200
        BSf3 =     0.246000
        BSg3 =     0.138000
        BSh3 =     0.665000
        BSi3 =     0.000000
        BSa4 =     2.069000
        BSb4 =     0.693000
        BSc4 =     0.272000
        icol =  6

      ELSEIF(iconfig.eq.94) THEN
C BCCA_8:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - interior surface of wall insulated to 0.2 m from top of slab
C    - top of slab is fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.024600
        BSb1 =     0.397000
        BSc1 =     0.037800
        BSd1 =     1.099600
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.107000
        BSq2 =     0.846000
        BSr2 =    -0.046800
        BSu2 =     0.568000
        BSv2 =     0.620000
        BSw2 =    -3.490000
        BSx2 =     0.730000
        BSs2 =     0.708000
        BSt2 =     0.007200
        BSy2 =    -0.160000
        BSa2 =     3.464000
        BSb2 =     0.130000
        BSc2 =     0.546000
        BSd2 =     0.315000
        BSe2 =     0.170000
        BSf2 =     0.037100
        BSg2 =     0.026500
        BSh2 =     0.000000
        BSa3 =     0.091800
        BSb3 =     0.053600
        BSc3 =    -0.056200
        BSe3 =     0.097300
        BSf3 =     0.175000
        BSg3 =     0.068700
        BSh3 =     0.775000
        BSi3 =     0.000000
        BSa4 =     2.426000
        BSb4 =     0.363000
        BSc4 =     0.500000
        icol =  8

      ELSEIF(iconfig.eq.95) THEN
C BCCN_4:
C    - concrete wall and slab
C    - exterior surface of wall insulated to 0.6 m below grade
C    - interior surface of wall fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.042300
        BSb1 =     0.383000
        BSc1 =     0.044200
        BSd1 =     0.975000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.076600
        BSq2 =     8.141000
        BSr2 =    -0.456000
        BSu2 =     0.083100
        BSv2 =     0.620000
        BSw2 =    -2.771000
        BSx2 =     0.730000
        BSs2 =     1.303000
        BSt2 =    -0.003200
        BSy2 =    -0.298000
        BSa2 =     8.005000
        BSb2 =     0.192000
        BSc2 =     0.815000
        BSd2 =     0.575000
        BSe2 =     0.035200
        BSf2 =    -0.012200
        BSg2 =     0.015200
        BSh2 =     0.000000
        BSa3 =     0.072600
        BSb3 =     0.320000
        BSc3 =    -0.096700
        BSe3 =    -0.015700
        BSf3 =     0.072800
        BSg3 =     0.156000
        BSh3 =     0.805000
        BSi3 =     0.000000
        BSa4 =     2.441000
        BSb4 =     0.338000
        BSc4 =     0.492000
        icol =  3

      ELSEIF(iconfig.eq.96) THEN
C BCCN_5:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - interior surface of wall insulated to 0.2 m from top of slab
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.009130
        BSb1 =     0.406000
        BSc1 =     0.027100
        BSd1 =     1.115000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.128000
        BSq2 =     0.243000
        BSr2 =     0.341000
        BSu2 =     0.169000
        BSv2 =     0.620000
        BSw2 =     0.723000
        BSx2 =     0.500000
        BSs2 =    -0.024900
        BSt2 =     0.023200
        BSy2 =     0.177000
        BSa2 =     0.993000
        BSb2 =     0.460000
        BSc2 =     0.319000
        BSd2 =     0.451000
        BSe2 =     4.253000
        BSf2 =    -0.120000
        BSg2 =    -1.519000
        BSh2 =     0.000000
        BSa3 =     0.130000
        BSb3 =     0.322000
        BSc3 =    -0.166000
        BSe3 =     0.078600
        BSf3 =     0.045400
        BSg3 =     0.115000
        BSh3 =     0.864000
        BSi3 =     0.000000
        BSa4 =     2.300000
        BSb4 =     0.484000
        BSc4 =     0.383000
        icol =  5

      ELSEIF(iconfig.eq.97) THEN
C BCEA_5:
C    - concrete wall and slab
C    - exterior surface of wall insulated to 0.6 m below grade
C    - top of slab is fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.083500
        BSb1 =     0.745000
        BSc1 =     0.007900
        BSd1 =     0.875000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.352000
        BSq2 =    -0.090000
        BSr2 =     0.065400
        BSu2 =     3.141000
        BSv2 =     0.620000
        BSw2 =    -0.045500
        BSx2 =     0.500000
        BSs2 =    -0.226000
        BSt2 =     0.011900
        BSy2 =     0.350000
        BSa2 =     1.497000
        BSb2 =     0.468000
        BSc2 =     0.741000
        BSd2 =     0.099100
        BSe2 =     0.498000
        BSf2 =     0.000540
        BSg2 =    -0.150000
        BSh2 =     0.000000
        BSa3 =    -0.438000
        BSb3 =     0.312000
        BSc3 =     0.445000
        BSe3 =     0.309000
        BSf3 =     0.135000
        BSg3 =    -0.107000
        BSh3 =     0.746000
        BSi3 =     0.000000
        BSa4 =     2.871000
        BSb4 =     0.060200
        BSc4 =     1.619000
        icol =  8

      ELSEIF(iconfig.eq.98) THEN
C BCEA_6:
C    - concrete wall and slab
C    - exterior surface of wall insulated to 0.6 m below grade
C    - top of slab is fully insulated
C    - first-storey construction is non-brick
        BSa1 =    -0.038600
        BSb1 =     0.763000
        BSc1 =     0.004000
        BSd1 =     0.886000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.118900
        BSq2 =     0.726000
        BSr2 =     0.175000
        BSu2 =     0.125000
        BSv2 =     0.620000
        BSw2 =    -0.015000
        BSx2 =     0.500000
        BSs2 =    -0.218000
        BSt2 =     0.015700
        BSy2 =     0.104000
        BSa2 =     2.171000
        BSb2 =     0.009670
        BSc2 =     0.479000
        BSd2 =     0.383000
        BSe2 =     0.271000
        BSf2 =     0.375000
        BSg2 =    -0.105000
        BSh2 =     0.000000
        BSa3 =    -0.439000
        BSb3 =     0.312000
        BSc3 =     0.446000
        BSe3 =     0.306000
        BSf3 =     0.135000
        BSg3 =    -0.100000
        BSh3 =     0.746000
        BSi3 =     0.000000
        BSa4 =     2.871000
        BSb4 =     0.061400
        BSc4 =     1.553000
        icol =  8

      ELSEIF(iconfig.eq.99) THEN
C BCEB_4:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - bottom of slab fully insulated
C    - first-storey construction is non-brick
        BSa1 =    -0.038100
        BSb1 =     0.764000
        BSc1 =     0.002590
        BSd1 =     0.888000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120000
        BSq2 =    -0.005890
        BSr2 =     0.014900
        BSu2 =     0.592000
        BSv2 =     0.620000
        BSw2 =     3.604000
        BSx2 =     0.500000
        BSs2 =    -0.226000
        BSt2 =     0.019900
        BSy2 =     0.087700
        BSa2 =     2.162000
        BSb2 =     0.363000
        BSc2 =     0.554000
        BSd2 =     0.310000
        BSe2 =     0.534000
        BSf2 =     0.149000
        BSg2 =    -0.040000
        BSh2 =     0.000000
        BSa3 =     0.141000
        BSb3 =     0.097800
        BSc3 =    -0.096100
        BSe3 =     0.043500
        BSf3 =     0.198000
        BSg3 =     0.221000
        BSh3 =     0.681000
        BSi3 =     0.000000
        BSa4 =     2.148000
        BSb4 =     0.753000
        BSc4 =     0.123000
        icol =  8

      ELSEIF(iconfig.eq.100) THEN
C BCEB_5:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - bottom of slab insulated with 0.6 m strip around perimeter
C    - first-storey construction is non-brick
        BSa1 =    -0.037600
        BSb1 =     0.764000
        BSc1 =     0.001800
        BSd1 =     0.888000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120000
        BSq2 =     0.189000
        BSr2 =     0.354000
        BSu2 =     0.197000
        BSv2 =     0.620000
        BSw2 =     0.663000
        BSx2 =     0.500000
        BSs2 =    -0.026300
        BSt2 =     0.022300
        BSy2 =     0.183000
        BSa2 =     0.782000
        BSb2 =     0.693000
        BSc2 =     0.348000
        BSd2 =     0.222000
        BSe2 =     2.819000
        BSf2 =    -0.047200
        BSg2 =    -0.924000
        BSh2 =     0.000000
        BSa3 =     0.129000
        BSb3 =     0.304000
        BSc3 =    -0.170000
        BSe3 =     0.040800
        BSf3 =     0.086300
        BSg3 =     0.256000
        BSh3 =     0.729000
        BSi3 =     0.000000
        BSa4 =     1.127000
        BSb4 =     1.751000
        BSc4 =     0.082300
        icol =  5

      ELSEIF(iconfig.eq.101) THEN
C BCEB_6:
C    - concrete wall and slab
C    - exterior surface of wall fully insulated
C    - bottom of slab insulated with 1. m strip around perimeter
C    - first-storey construction is non-brick
        BSa1 =    -0.037700
        BSb1 =     0.765000
        BSc1 =     0.001920
        BSd1 =     0.888000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120000
        BSq2 =     0.038200
        BSr2 =     0.345000
        BSu2 =     0.213000
        BSv2 =     0.620000
        BSw2 =     0.666000
        BSx2 =     0.500000
        BSs2 =    -0.034300
        BSt2 =     0.022900
        BSy2 =     0.179000
        BSa2 =     0.792000
        BSb2 =     0.632000
        BSc2 =     0.354000
        BSd2 =     0.195000
        BSe2 =     2.635000
        BSf2 =    -0.023400
        BSg2 =    -0.848000
        BSh2 =     0.000000
        BSa3 =     0.121000
        BSb3 =     0.273000
        BSc3 =    -0.156000
        BSe3 =     0.047800
        BSf3 =     0.093800
        BSg3 =     0.253000
        BSh3 =     0.729000
        BSi3 =     0.000000
        BSa4 =     0.158000
        BSb4 =     2.721000
        BSc4 =     0.053400
        icol =  5

      ELSEIF(iconfig.eq.102) THEN
C BWIA_1:
C    - wood wall and slab
C    - interior surface of wall fully insulated
C    - top of slab insulated with 0.6 m strip around perimeter
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.013200
        BSb1 =     0.649000
        BSc1 =     0.003230
        BSd1 =     0.804100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002020
        BSq2 =    -0.070000
        BSr2 =     0.092400
        BSu2 =     0.577000
        BSv2 =     0.620000
        BSw2 =     1.153000
        BSx2 =     0.500000
        BSs2 =    -0.039000
        BSt2 =     0.018800
        BSy2 =     0.127000
        BSa2 =     0.594000
        BSb2 =     0.703000
        BSc2 =     0.344000
        BSd2 =     0.073600
        BSe2 =     0.878000
        BSf2 =     0.109000
        BSg2 =    -0.163000
        BSh2 =     0.000000
        BSa3 =     0.074900
        BSb3 =     0.085600
        BSc3 =    -0.075000
        BSe3 =     0.029500
        BSf3 =     0.100000
        BSg3 =     0.240000
        BSh3 =     0.643000
        BSi3 =     0.000000
        BSa4 =     3.642000
        BSb4 =    -0.819000
        BSc4 =    -0.217000
        icol =  3
 
      ELSEIF(iconfig.eq.103) THEN
C BWIA_2:
C    - wood wall and slab
C    - interior surface of wall fully insulated
C    - top of slab fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =    -0.012700
        BSb1 =     0.649000
        BSc1 =     0.003450
        BSd1 =     0.804000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.001500
        BSq2 =    -0.126000
        BSr2 =     0.007840
        BSu2 =     0.809000
        BSv2 =     0.620000
        BSw2 =     7.878000
        BSx2 =     0.500000
        BSs2 =     0.357000
        BSt2 =     0.006830
        BSy2 =     0.010100
        BSa2 =     2.585000
        BSb2 =     0.243000
        BSc2 =     0.427000
        BSd2 =     0.228000
        BSe2 =     0.292000
        BSf2 =     0.039000
        BSg2 =     0.024600
        BSh2 =     0.000000
        BSa3 =     0.014300
        BSb3 =    -0.035100
        BSc3 =    -0.026400
        BSe3 =     0.092400
        BSf3 =     0.208800
        BSg3 =     0.192000
        BSh3 =     0.537000
        BSi3 =     0.000000
        BSa4 =     3.106000
        BSb4 =    -0.278000
        BSc4 =    -0.380000
        icol =  6

      ELSEIF(iconfig.eq.104) THEN
C SCA_1:
C    - concrete slab
C    - top of slab insulated 0.6 m strip around perimeter
C    - first-storey construction is non-brick
        BSa1 =     0.019400
        BSb1 =     0.000000
        BSc1 =     0.001960
        BSd1 =     0.054000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.178000
        BSr2 =     0.398000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.517000
        BSt2 =     0.013700
        BSy2 =     0.000000
        BSa2 =     1.912000
        BSb2 =     0.000000
        BSc2 =     0.795000
        BSd2 =     0.185000
        BSe2 =     0.026700
        BSf2 =    -0.004200
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.016500
        BSb3 =     0.400000
        BSc3 =     0.000000
        BSe3 =     0.049400
        BSf3 =     0.019600
        BSg3 =     0.000000
        BSh3 =     0.787000
        BSi3 =     0.000000
        BSa4 =     2.706000
        BSb4 =     0.066300
        BSc4 =     0.000000
        icol =  6

      ELSEIF(iconfig.eq.105) THEN
C SCA_2:
C    - concrete slab
C    - top of slab insulated 0.6 m strip around perimeter
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.045300
        BSb1 =     0.000000
        BSc1 =     0.002370
        BSd1 =     0.056400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.198000
        BSr2 =     0.396000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.513000
        BSt2 =     0.013800
        BSy2 =     0.000000
        BSa2 =     1.936000
        BSb2 =     0.000000
        BSc2 =     0.780000
        BSd2 =     0.184000
        BSe2 =     0.029900
        BSf2 =    -0.005670
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =     0.031300
        BSb3 =     0.400000
        BSc3 =     0.000000
        BSe3 =     0.059500
        BSf3 =     0.017600
        BSg3 =     0.000000
        BSh3 =     0.791000
        BSi3 =     0.000000
        BSa4 =     2.721000
        BSb4 =     0.068700
        BSc4 =     0.000000
        icol =  6

      ELSEIF(iconfig.eq.106) THEN
C SCA_9:
C    - concrete slab
C    - top of slab insulated 1. m strip around perimeter
C    - first-storey construction is non-brick
        BSa1 =     0.017800
        BSb1 =     0.000000
        BSc1 =     0.001760
        BSd1 =     0.092500
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.033000
        BSr2 =     0.375000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.461000
        BSt2 =     0.015900
        BSy2 =     0.000000
        BSa2 =     1.831000
        BSb2 =     0.000000
        BSc2 =     0.774000
        BSd2 =     0.190000
        BSe2 =     0.056300
        BSf2 =    -0.010000
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.021000
        BSb3 =     0.331000
        BSc3 =     0.000000
        BSe3 =     0.084900
        BSf3 =     0.038200
        BSg3 =     0.000000
        BSh3 =     0.744000
        BSi3 =     0.000000
        BSa4 =     2.583000
        BSb4 =     0.154000
        BSc4 =     0.000000
        icol =  6

      ELSEIF(iconfig.eq.107) THEN
C SCA_10:
C    - concrete slab
C    - top of slab insulated 1. m strip around perimeter
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     0.041000
        BSb1 =     0.000000
        BSc1 =     0.002200
        BSd1 =     0.101000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.000000
        BSq2 =    -3.047500
        BSr2 =     0.374000
        BSu2 =     1.000000
        BSv2 =     0.000000
        BSw2 =     1.000000
        BSx2 =     0.000000
        BSs2 =     0.458000
        BSt2 =     0.015900
        BSy2 =     0.000000
        BSa2 =     1.852000
        BSb2 =     0.000000
        BSc2 =     0.760000
        BSd2 =     0.190000
        BSe2 =     0.060100
        BSf2 =    -0.011800
        BSg2 =     0.000000
        BSh2 =     0.000000
        BSa3 =    -0.013300
        BSb3 =     0.432000
        BSc3 =     0.000000
        BSe3 =     0.098600
        BSf3 =     0.035200
        BSg3 =     0.000000
        BSh3 =     0.749000
        BSi3 =     0.000000
        BSa4 =     2.597000
        BSb4 =     0.159000
        BSc4 =     0.000000
        icol =  6

      ELSEIF(iconfig.eq.116) THEN
C BCCA_1:
C    - concrete wall and slab
C    - exterior surface of wall insulated below grade
C    - interior surface of wall insulated from top of wall producing an
C      overlap with the exterior insulation
C    - top of slab fully insulated
C    - first-storey construction is brick with no thermal breaks
        BSa1 =     1.248000
        BSb1 =     1.583000
        BSc1 =     0.058500
        BSd1 =     0.271000
        BSe1 =     3.092000
        BSf1 =     0.292000
        BSg1 =     1.523000
        BSh1 =    -0.918000
        BSi1 =     1.000000
        BSj1 =     0.142000
        BSq2 =    -0.093900
        BSr2 =     0.080600
        BSu2 =     1.261000
        BSv2 =     0.620000
        BSw2 =    -0.034700
        BSx2 =     0.500000
        BSs2 =    -0.041300
        BSt2 =     0.014800
        BSy2 =     0.083200
        BSa2 =     1.789000
        BSb2 =     0.196000
        BSc2 =     0.561000
        BSd2 =     0.165000
        BSe2 =     0.030100
        BSf2 =     0.121000
        BSg2 =     0.144000
        BSh2 =     0.676000
        BSa3 =    -0.148000
        BSb3 =     0.057800
        BSc3 =     0.127000
        BSe3 =     0.702000
        BSf3 =     0.136000
        BSg3 =    -0.151000
        BSh3 =     0.183000
        BSi3 =     1.242000
        BSa4 =     2.720000
        BSb4 =     0.178000
        BSc4 =     0.499000
        icol =  8

      ELSEIF(iconfig.eq.117) THEN
C BCCA_4:
C    - concrete wall and slab
C    - exterior surface of wall insulated below grade
C    - interior surface of wall insulated from top of wall producing an
C      overlap with the exterior insulation
C    - top of slab fully insulated
C    - first-storey construction is non-brick or bricks thermally broken from
C      concrete walls
        BSa1 =     1.066200
        BSb1 =     1.743000
        BSc1 =     0.057200
        BSd1 =     0.277000
        BSe1 =     3.036000
        BSf1 =     0.233000
        BSg1 =     1.426000
        BSh1 =    -0.873000
        BSi1 =     1.000000
        BSj1 =     0.124000
        BSq2 =    -0.090300
        BSr2 =     0.079600
        BSu2 =     1.280000
        BSv2 =     0.620000
        BSw2 =    -0.033500
        BSx2 =     0.500000
        BSs2 =    -0.039800
        BSt2 =     0.014900
        BSy2 =     0.081500
        BSa2 =     1.792000
        BSb2 =     0.199000
        BSc2 =     0.560000
        BSd2 =     0.165000
        BSe2 =     0.032800
        BSf2 =     0.121000
        BSg2 =     0.141000
        BSh2 =     0.676000
        BSa3 =    -0.155000
        BSb3 =     0.057100
        BSc3 =     0.132000
        BSe3 =     0.704000
        BSf3 =     0.136000
        BSg3 =    -0.147000
        BSh3 =     0.179000
        BSi3 =     1.219000
        BSa4 =     2.732000
        BSb4 =     0.169000
        BSc4 =     0.520000
        icol =  8

      ELSEIF(iconfig.eq.118) THEN
C BCIB_7:
C    - concrete wall and slab
C    - interior surface of wall insulated to 0.6 m below grade
C    - bottom of slab fully insulated
C    - thermal break between walls and floor slab
C    - first-storey construction is brick with no thermal break
        BSa1 =    -0.094600
        BSb1 =     0.766000
        BSc1 =     0.132000
        BSd1 =     0.992000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.085500
        BSq2 =     1.185000
        BSr2 =     0.199000
        BSu2 =     0.332000
        BSv2 =     0.620000
        BSw2 =    -0.260000
        BSx2 =     0.500000
        BSs2 =    -0.427000
        BSt2 =     0.014200
        BSy2 =     0.226000
        BSa2 =     2.210000
        BSb2 =    -0.211000
        BSc2 =     0.566000
        BSd2 =     0.360000
        BSe2 =     0.653000
        BSf2 =     0.300000
        BSg2 =    -0.248000
        BSh2 =     0.000000
        BSa3 =    -0.727000
        BSb3 =     0.248000
        BSc3 =     0.749000
        BSe3 =     0.483000
        BSf3 =     0.177000
        BSg3 =    -0.252000
        BSh3 =     0.728000
        BSi3 =     0.000000
        BSa4 =     2.827000
        BSb4 =     0.128000
        BSc4 =     0.411000
        icol =  7

      ELSEIF(iconfig.eq.119) THEN
C BCIB_8:
C    - concrete wall and slab
C    - interior surface of wall insulated to 0.6 m below grade
C    - bottom of slab fully insulated
C    - thermal break between walls and floor slab
C    - first-storey is non-brick veneer or bricks thermally broken from
C      concrete walls
        BSa1 =    -0.102000
        BSb1 =     0.776000
        BSc1 =     0.124000
        BSd1 =     0.964000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.074900
        BSq2 =     1.181000
        BSr2 =     0.198000
        BSu2 =     0.337000
        BSv2 =     0.620000
        BSw2 =    -0.260000
        BSx2 =     0.500000
        BSs2 =    -0.427000
        BSt2 =     0.014200
        BSy2 =     0.225000
        BSa2 =     2.215000
        BSb2 =    -0.206000
        BSc2 =     0.565000
        BSd2 =     0.359000
        BSe2 =     0.655000
        BSf2 =     0.297000
        BSg2 =    -0.248000
        BSh2 =     0.000000
        BSa3 =    -0.729000
        BSb3 =     0.247000
        BSc3 =     0.754000
        BSe3 =     0.482000
        BSf3 =     0.177000
        BSg3 =    -0.249000
        BSh3 =     0.728000
        BSi3 =     0.000000
        BSa4 =     2.828000
        BSb4 =     0.128000
        BSc4 =     0.411000
        icol =  7

      ELSE
        call edisp(IUOUT,' Not a valid iconfig.')

      ENDIF
      RETURN
      END


C ******************** COEFEXT5 ********************
C COEFEXT5      BASESIMP coefficients for configurations generated by
C               Julia Purdy in October 1999.

      SUBROUTINE COEFEXT5(iconfig)

      COMMON/OUTIN/IUOUT,IUIN,IEOUT
      COMMON/Dsumuo/BSa1,BSb1,BSc1,BSd1,BSe1,BSf1,BSg1,BSh1,BSi1,BSj1
      COMMON/Dsumur/BSq2,BSr2,BSu2,BSv2,BSw2,BSx2,BSs2,BSt2,BSy2,BSa2,
     &              BSb2,BSc2,BSd2,BSe2,BSf2,BSg2,BSh2
      COMMON/Datten/BSa3,BSb3,BSc3,BSe3,BSf3,BSg3,BSh3,BSi3
      COMMON/Dphase/BSa4,BSb4,BSc4
      COMMON/Dcorn/icol

C This subroutine sets BASESIMP correlation coefficients and the
C `corner-correction column number' for the BASESIMP configuration under
C consideration. It supports the set of configurations generated by Julia
C Purdy in October 1999 to support the MNECH.

C It sets the coefficients based on the passed `iconfig' number. The
C coefficients are placed in the Dsumuo, Dsumur, Datten, Dphase, and Dcorn
C common blocks.

C The correlation coefficients are described in:
C    Beausoleil-Morrison I., `BASESIMP: A Simplified Foundation Energy-Loss
C    Model Derived from BASECALC Simulations', NRCan internal report, 1996.

C The `corner-correction column number' refers to columns of Table 1 and
C Table 2 in:
C    Beausoleil-Morrison, Mitalas, and Chin (1992), `Estimating Three-Dimensional
C    Below-Grade Heat Losses from Houses Using Two-Dimensional Calculations',
C    Proceedings of Thermal Performance of the Exterior Envelopes of Buildings VI,
C    ASHRAE, pp. 95-99.
C icol = 1 for column 1 of Table 1.  icol = 5 for column1 of Table 2.


      IF(iconfig.eq.121) THEN
C BCIA_3:
C    - interior surface of wall insulated over full-height
C    - top surface of floor slab insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.035830
        BSb1 =     0.756150
        BSc1 =     0.094100
        BSd1 =     0.831300
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.025030
        BSq2 =     6.654780
        BSr2 =    -0.423500
        BSu2 =     0.072140
        BSv2 =     0.620000
        BSw2 =    -2.802500
        BSx2 =     0.735000
        BSs2 =     1.174800
        BSt2 =     0.004120
        BSy2 =    -0.278130
        BSa2 =     6.769600
        BSb2 =     0.193100
        BSc2 =     0.758400
        BSd2 =     0.527400
        BSe2 =     0.100900
        BSf2 =    -0.026750
        BSg2 =     0.020180
        BSh2 =     0.000000
        BSa3 =     0.071520
        BSb3 =     0.207100
        BSc3 =    -0.111500
        BSe3 =     0.102980
        BSf3 =     0.131900
        BSg3 =     0.212360
        BSh3 =     0.769790
        BSi3 =     0.000000
        BSa4 =     2.471400
        BSb4 =     0.540800
        BSc4 =     1.000000
        icol =  3

      ELSEIF(iconfig.eq.122) THEN
C BCIA_5:
C    - interior surface of wall insulated to 0.6m below grade
C    - top surface of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.102755
        BSb1 =     0.758400
        BSc1 =     0.127850
        BSd1 =     0.923830
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.095400
        BSq2 =     0.356082
        BSr2 =     1.175170
        BSu2 =     0.193035
        BSv2 =     0.620000
        BSw2 =     0.019890
        BSx2 =     0.500000
        BSs2 =     0.385205
        BSt2 =     0.010492
        BSy2 =     0.231285
        BSa2 =     0.533470
        BSb2 =     0.529600
        BSc2 =     0.678140
        BSd2 =    -0.226610
        BSe2 =     0.194250
        BSf2 =    -0.008800
        BSg2 =    -0.063400
        BSh2 =     0.000000
        BSa3 =    -0.505580
        BSb3 =     0.463320
        BSc3 =     0.516750
        BSe3 =     0.318440
        BSf3 =     0.071850
        BSg3 =    -0.106340
        BSh3 =     0.820841
        BSi3 =     0.000000
        BSa4 =     2.785130
        BSb4 =     0.177090
        BSc4 =     1.000000
        icol =  2

      ELSEIF(iconfig.eq.123) THEN
C BCIA_6:
C    - interior surface of wall insulated to 0.6m below grade
C    - top surface of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is non-brick veneer or bricks thermally broken from concrete
C      walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.110115
        BSb1 =     0.768570
        BSc1 =     0.119650
        BSd1 =     0.896200
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.084336
        BSq2 =     0.322508
        BSr2 =     1.177253
        BSu2 =     0.192520
        BSv2 =     0.620000
        BSw2 =     0.018815
        BSx2 =     0.500000
        BSs2 =     0.383320
        BSt2 =     0.010505
        BSy2 =     0.232525
        BSa2 =     0.546050
        BSb2 =     0.534980
        BSc2 =     0.673230
        BSd2 =    -0.220550
        BSe2 =     0.193790
        BSf2 =    -0.008839
        BSg2 =    -0.062920
        BSh2 =     0.000000
        BSa3 =    -0.507432
        BSb3 =     0.462610
        BSc3 =     0.521787
        BSe3 =     0.317700
        BSf3 =     0.072040
        BSg3 =    -0.103580
        BSh3 =     0.820152
        BSi3 =     0.000000
        BSa4 =     2.785986
        BSb4 =     0.177500
        BSc4 =     1.000000
        icol =  2

      ELSEIF(iconfig.eq.124) THEN
C BCIB_9:
C    - interior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - thermal break between walls and floor slab
C    - sub-slab, wall, and thermal break insulation all have same thermal resist
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.095730
        BSb1 =     0.759500
        BSc1 =     0.120900
        BSd1 =     0.944400
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.094136
        BSq2 =     0.392119
        BSr2 =     1.244337
        BSu2 =     0.176210
        BSv2 =     0.620000
        BSw2 =    -0.017980
        BSx2 =     0.500000
        BSs2 =     0.334740
        BSt2 =     0.010732
        BSy2 =     0.258040
        BSa2 =     0.525216
        BSb2 =     0.588802
        BSc2 =     0.676886
        BSd2 =    -0.218160
        BSe2 =     0.210820
        BSf2 =    -0.012470
        BSg2 =    -0.068500
        BSh2 =     0.000000
        BSa3 =    -0.581040
        BSb3 =     0.467500
        BSc3 =     0.554980
        BSe3 =     0.345205
        BSf3 =     0.063890
        BSg3 =    -0.116690
        BSh3 =     0.834930
        BSi3 =     0.000000
        BSa4 =     2.756980
        BSb4 =     0.214150
        BSc4 =     1.000000
        icol =  2
 
      ELSEIF(iconfig.eq.125) THEN
C BCIB_10:
C    - interior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - thermal break between walls and floor slab
C    - sub-slab, wall, and thermal break insulation all have same thermal resist
C    - first-storey is non-brick veneer or bricks thermally broken from
C      concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.103200
        BSb1 =     0.769500
        BSc1 =     0.112700
        BSd1 =     0.915800
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.083070
        BSq2 =     0.347370
        BSr2 =     1.247860
        BSu2 =     0.175410
        BSv2 =     0.620000
        BSw2 =    -0.019260
        BSx2 =     0.500000
        BSs2 =     0.332680
        BSt2 =     0.010750
        BSy2 =     0.259590
        BSa2 =     0.539770
        BSb2 =     0.593620
        BSc2 =     0.672010
        BSd2 =    -0.211000
        BSe2 =     0.209830
        BSf2 =    -0.012460
        BSg2 =    -0.067828
        BSh2 =     0.000000
        BSa3 =    -0.582970
        BSb3 =     0.466810
        BSc3 =     0.560070
        BSe3 =     0.344520
        BSf3 =     0.064070
        BSg3 =    -0.113950
        BSh3 =     0.834110
        BSi3 =     0.000000
        BSa4 =     2.757860
        BSb4 =     0.214560
        BSc4 =     1.000000
        icol =  2
 
      ELSEIF(iconfig.eq.126) THEN
C BCEB_10:
C    - exterior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - thermal break between walls and floor slab
C    - sub-slab, wall, and thermal break insulation all have same thermal resist
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.082866
        BSb1 =     0.747000
        BSc1 =     0.005117
        BSd1 =     0.880190
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.354580
        BSq2 =     0.473306
        BSr2 =     0.512520
        BSu2 =     0.208830
        BSv2 =     0.620000
        BSw2 =     0.311590
        BSx2 =     0.500000
        BSs2 =     0.016306
        BSt2 =     0.021280
        BSy2 =     0.172150
        BSa2 =     0.346200
        BSb2 =     0.930900
        BSc2 =     0.668600
        BSd2 =    -0.013540
        BSe2 =     0.792270
        BSf2 =    -0.067900
        BSg2 =    -0.262030
        BSh2 =     0.000000
        BSa3 =    -0.347432
        BSb3 =     0.471450
        BSc3 =     0.299225
        BSe3 =     0.252390
        BSf3 =     0.037600
        BSg3 =    -0.006287
        BSh3 =     0.802489
        BSi3 =     0.000000
        BSa4 =     2.669500
        BSb4 =     0.230600
        BSc4 =     0.500000
        icol =  5

      ELSEIF(iconfig.eq.127) THEN
C BCEB_11:
C    - exterior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - thermal break between walls and floor slab
C    - sub-slab, wall, and thermal break insulation all have same thermal resist
C    - first-storey is non-brick veneer or bricks thermally broken from
C      concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.037710
        BSb1 =     0.764220
        BSc1 =     0.002345
        BSd1 =     0.887697
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120000
        BSq2 =     0.471953
        BSr2 =     0.512454
        BSu2 =     0.208830
        BSv2 =     0.620000
        BSw2 =     0.311880
        BSx2 =     0.500000
        BSs2 =     0.016550
        BSt2 =     0.021280
        BSy2 =     0.172080
        BSa2 =     0.346870
        BSb2 =     0.929640
        BSc2 =     0.668740
        BSd2 =    -0.013460
        BSe2 =     0.790300
        BSf2 =    -0.067800
        BSg2 =    -0.261300
        BSh2 =     0.000000
        BSa3 =    -0.374325
        BSb3 =     0.471450
        BSc3 =     0.299225
        BSe3 =     0.252390
        BSf3 =     0.037000
        BSg3 =    -0.006287
        BSh3 =     0.802500
        BSi3 =     0.000000
        BSa4 =     2.669500
        BSb4 =     0.230570
        BSc4 =     0.500000
        icol =  5

      ELSEIF(iconfig.eq.128) THEN
C BCEA_3:
C    - exterior surface of wall insulated over full height
C    - top surface of floor slab insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.083846
        BSb1 =     0.748270
        BSc1 =     0.003780
        BSd1 =     0.884560
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.356000
        BSq2 =    -0.013900
        BSr2 =     0.346370
        BSu2 =     0.224479
        BSv2 =     0.620000
        BSw2 =     0.658920
        BSx2 =     0.500000
        BSs2 =    -0.028296
        BSt2 =     0.022880
        BSy2 =     0.179770
        BSa2 =     0.780258
        BSb2 =     0.620340
        BSc2 =     0.384045
        BSd2 =     0.189720
        BSe2 =     2.519800
        BSf2 =     0.003260
        BSg2 =    -0.815290
        BSh2 =     0.000000
        BSa3 =     0.119523
        BSb3 =     0.253770
        BSc3 =    -0.147840
        BSe3 =     0.035197
        BSf3 =     0.103024
        BSg3 =     0.255490
        BSh3 =     0.737528
        BSi3 =     0.000000
        BSa4 =     2.523800
        BSb4 =     0.449460
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.129) THEN
C BCEA_9:
C    - exterior surface of wall insulated over full height
C    - top surface of floor slab insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is non-brick veneer or bricks thermally broken from
C      concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.037960
        BSb1 =     0.764560
        BSc1 =     0.002095
        BSd1 =     0.882560
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120206
        BSq2 =    -0.012624
        BSr2 =     0.346870
        BSu2 =     0.225017
        BSv2 =     0.620000
        BSw2 =     0.656788
        BSx2 =     0.500000
        BSs2 =    -0.028665
        BSt2 =     0.022879
        BSy2 =     0.179115
        BSa2 =     0.779820
        BSb2 =     0.631300
        BSc2 =     0.380318
        BSd2 =     0.184787
        BSe2 =     2.496030
        BSf2 =     0.003646
        BSg2 =    -0.803790
        BSh2 =     0.000000
        BSa3 =     0.119500
        BSb3 =     0.253770
        BSc3 =    -0.147800
        BSe3 =     0.035200
        BSf3 =     0.103020
        BSg3 =     0.255500
        BSh3 =     0.737530
        BSi3 =     0.000000
        BSa4 =     2.523800
        BSb4 =     0.449500
        BSc4 =     1.000000
        icol =  5
 
      ELSEIF(iconfig.eq.130) THEN
C BCEA_10:
C    - exterior surface of wall insulated to 0.6m below grade
C    - top surface of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.082930
        BSb1 =     0.747060
        BSc1 =     0.005237
        BSd1 =     0.880240
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.354600
        BSq2 =     6.365400
        BSr2 =    -0.440800
        BSu2 =     0.062176
        BSv2 =     0.620000
        BSw2 =    -3.020130
        BSx2 =     0.730000
        BSs2 =     1.285500
        BSt2 =     0.000656
        BSy2 =    -0.275300
        BSa2 =     6.466700
        BSb2 =     0.308730
        BSc2 =     0.795500
        BSd2 =     0.488500
        BSe2 =     0.076124
        BSf2 =    -0.013000
        BSg2 =    -0.017600
        BSh2 =     0.000000
        BSa3 =    -0.358950
        BSb3 =     0.470600
        BSc3 =     0.291980
        BSe3 =     0.251810
        BSf3 =     0.041790
        BSg3 =    -0.014440
        BSh3 =     0.803190
        BSi3 =     0.000000
        BSa4 =     2.735900
        BSb4 =     0.186500
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.131) THEN
C BCEA_11:
C    - exterior surface of wall insulated to 0.6m below grade
C    - top surface of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is non-brick veneer or bricks thermally broken from
C      concrete walls
C    - 200mm concrete walls and 100mm concrete floor
        BSa1 =    -0.037760
        BSb1 =     0.764260
        BSc1 =     0.002430
        BSd1 =     0.887720
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.120050
        BSq2 =     6.338190
        BSr2 =    -0.440300
        BSu2 =     0.062640
        BSv2 =     0.620000
        BSw2 =    -3.029940
        BSx2 =     0.735000
        BSs2 =     1.287370
        BSt2 =     0.000713
        BSy2 =    -0.276570
        BSa2 =     6.454200
        BSb2 =     0.310885
        BSc2 =     0.793500
        BSd2 =     0.487150
        BSe2 =     0.076922
        BSf2 =    -0.013430
        BSg2 =    -0.017130
        BSh2 =     0.000000
        BSa3 =    -0.359600
        BSb3 =     0.470970
        BSc3 =     0.292400
        BSe3 =     0.249220
        BSf3 =     0.042160
        BSg3 =    -0.006776
        BSh3 =     0.800740
        BSi3 =     0.000000
        BSa4 =     2.669680
        BSb4 =     0.228820
        BSc4 =     0.500000
        icol =  5

      ELSEIF(iconfig.eq.132) THEN
C BWIB_1:
C    - interior surface of wall insulated over full-height
C    - sub-surface of floor insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.013317
        BSb1 =     0.649880
        BSc1 =     0.003184
        BSd1 =     0.804315
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002130
        BSq2 =    -0.097633
        BSr2 =     0.099027
        BSu2 =     0.550320
        BSv2 =     0.620000
        BSw2 =     1.116420
        BSx2 =     0.500000
        BSs2 =    -0.048976
        BSt2 =     0.019566
        BSy2 =     0.130299
        BSa2 =     0.599600
        BSb2 =     0.717490
        BSc2 =     0.340250
        BSd2 =     0.081380
        BSe2 =     0.893277
        BSf2 =     0.113290
        BSg2 =    -0.169400
        BSh2 =     0.000000
        BSa3 =     0.072319
        BSb3 =     0.084716
        BSc3 =    -0.070685
        BSe3 =     0.023877
        BSf3 =     0.097430
        BSg3 =     0.241229
        BSh3 =     0.649840
        BSi3 =     0.000000
        BSa4 =     2.312320
        BSb4 =     0.697238
        BSc4 =     1.000000
        icol =  3

      ELSEIF(iconfig.eq.133) THEN
C BWIB_2:
C    - interior surface of wall insulated over full-height
C    - sub-surface of floor fully insulated
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.012950
        BSb1 =     0.649780
        BSc1 =     0.003517
        BSd1 =     0.804050
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.001567
        BSq2 =    -1.186390
        BSr2 =     0.114417
        BSu2 =     0.921700
        BSv2 =     0.620000
        BSw2 =     0.000000
        BSx2 =     0.500000
        BSs2 =    -0.067360
        BSt2 =     0.005783
        BSy2 =     0.355200
        BSa2 =     1.866000
        BSb2 =     0.309700
        BSc2 =     0.398500
        BSd2 =     0.165950
        BSe2 =     0.333000
        BSf2 =     0.062570
        BSg2 =     0.028100
        BSh2 =     0.000000
        BSa3 =     0.041710
        BSb3 =    -0.022650
        BSc3 =    -0.032800
        BSe3 =     0.057337
        BSf3 =     0.184820
        BSg3 =     0.207860
        BSh3 =     0.552620
        BSi3 =     0.000000
        BSa4 =     2.500000
        BSb4 =     0.468100
        BSc4 =     1.000000
        icol =  7

      ELSEIF(iconfig.eq.134) THEN
C BWIB_4:
C    - interior surface of wall insulated over full-height
C    - sub-surface of floor insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.013181
        BSb1 =     0.649820
        BSc1 =     0.003152
        BSd1 =     0.804095
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002091
        BSq2 =    -0.058239
        BSr2 =     0.106230
        BSu2 =     0.544950
        BSv2 =     0.620000
        BSw2 =     1.079680
        BSx2 =     0.500000
        BSs2 =    -0.043880
        BSt2 =     0.019430
        BSy2 =     0.131390
        BSa2 =     0.521400
        BSb2 =     0.769000
        BSc2 =     0.335500
        BSd2 =     0.065850
        BSe2 =     1.007430
        BSf2 =     0.110560
        BSg2 =    -0.213200
        BSh2 =     0.000000
        BSa3 =     0.089900
        BSb3 =     0.103910
        BSc3 =    -0.080670
        BSe3 =     0.011959
        BSf3 =     0.088945
        BSg3 =     0.243870
        BSh3 =     0.658276
        BSi3 =     0.000000
        BSa4 =     2.329980
        BSb4 =     0.659540
        BSc4 =     1.000000
        icol =  3

      ELSEIF(iconfig.eq.135) THEN
C BWIA_3:
C    - interior surface of wall insulated to 0.6m below grade
C    - top surface of floor insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.014170
        BSb1 =     0.650050
        BSc1 =     0.002820
        BSd1 =     0.808200
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.004060
        BSq2 =    -0.892810
        BSr2 =     0.365590
        BSu2 =     0.659620
        BSv2 =     0.620000
        BSw2 =     0.043142
        BSx2 =     0.500000
        BSs2 =     0.074252
        BSt2 =     0.011677
        BSy2 =     0.303140
        BSa2 =     0.870480
        BSb2 =     0.653690
        BSc2 =     0.556110
        BSd2 =     0.019229
        BSe2 =     0.220000
        BSf2 =    -0.008110
        BSg2 =    -0.067740
        BSh2 =     0.000000
        BSa3 =    -0.350977
        BSb3 =     0.226320
        BSc3 =     0.372970
        BSe3 =     0.249970
        BSf3 =     0.055950
        BSg3 =    -0.036000
        BSh3 =     0.678300
        BSi3 =     0.000000
        BSa4 =     1.597820
        BSb4 =     1.252800
        BSc4 =     0.105500
        icol =  2

      ELSEIF(iconfig.eq.136) THEN
C BWEB_1:
C    - exterior surface of wall insulated over full-height
C    - bottom of floor insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.030890
        BSb1 =     0.650530
        BSc1 =    -0.000019
        BSd1 =     0.809187
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075536
        BSq2 =    -0.100000
        BSr2 =     0.100700
        BSu2 =     0.538523
        BSv2 =     0.620000
        BSw2 =     1.126370
        BSx2 =     0.500000
        BSs2 =    -0.039893
        BSt2 =     0.019840
        BSy2 =     0.127870
        BSa2 =     0.615260
        BSb2 =     0.694830
        BSc2 =     0.333130
        BSd2 =     0.079298
        BSe2 =     0.882230
        BSf2 =     0.111220
        BSg2 =    -0.167070
        BSh2 =     0.000000
        BSa3 =     0.063040
        BSb3 =     0.081414
        BSc3 =    -0.072290
        BSe3 =     0.030850
        BSf3 =     0.099640
        BSg3 =     0.246660
        BSh3 =     0.625840
        BSi3 =     0.000000
        BSa4 =     2.307880
        BSb4 =     0.715339
        BSc4 =     1.000000
        icol =  5
 
      ELSEIF(iconfig.eq.137) THEN
C BWEB_2:
C    - exterior surface of wall insulated over full-height
C    - sub-surface of floor fully insulated
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.030900
        BSb1 =     0.650520
        BSc1 =     0.000126
        BSd1 =     0.809110
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075400
        BSq2 =    -0.100666
        BSr2 =     0.006160
        BSu2 =     0.811340
        BSv2 =     0.620000
        BSw2 =     9.354000
        BSx2 =     0.500000
        BSs2 =     0.359300
        BSt2 =     0.006200
        BSy2 =     0.004830
        BSa2 =     2.451100
        BSb2 =     0.257300
        BSc2 =     0.401400
        BSd2 =     0.223140
        BSe2 =     0.276600
        BSf2 =     0.034240
        BSg2 =     0.026860
        BSh2 =     0.000000
        BSa3 =     0.032563
        BSb3 =    -0.023900
        BSc3 =    -0.033700
        BSe3 =     0.068500
        BSf3 =     0.185210
        BSg3 =     0.211670
        BSh3 =     0.541690
        BSi3 =     0.000000
        BSa4 =     2.491800
        BSb4 =     0.493390
        BSc4 =     1.000000
        icol =  8

      ELSEIF(iconfig.eq.138) THEN
C BWEB_3:
C    - exterior surface of wall insulated to 0.6m below grade
C    - bottom of floor insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.030800
        BSb1 =     0.650500
        BSc1 =    -0.000310
        BSd1 =     0.810000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075960
        BSq2 =    -0.564500
        BSr2 =     0.250510
        BSu2 =     0.611998
        BSv2 =     0.620000
        BSw2 =     0.277700
        BSx2 =     0.500000
        BSs2 =     0.102009
        BSt2 =     0.013950
        BSy2 =     0.218030
        BSa2 =     0.838520
        BSb2 =     0.643200
        BSc2 =     0.541440
        BSd2 =     0.041040
        BSe2 =     0.261800
        BSf2 =    -0.015200
        BSg2 =    -0.078700
        BSh2 =     0.000000
        BSa3 =    -0.283600
        BSb3 =     0.215440
        BSc3 =     0.288500
        BSe3 =     0.214720
        BSf3 =     0.049360
        BSg3 =     0.009120
        BSh3 =     0.678600
        BSi3 =     0.000000
        BSa4 =     2.548800
        BSb4 =     0.367100
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.139) THEN
C BWEB_4:
C    - exterior surface of wall insulated over full-height
C    - bottom of floor insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm wood floor
        BSa1 =    -0.030880
        BSb1 =     0.650540
        BSc1 =    -0.000045
        BSd1 =     0.809210
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075558
        BSq2 =    -0.057123
        BSr2 =     0.107770
        BSu2 =     0.540350
        BSv2 =     0.620000
        BSw2 =     1.068860
        BSx2 =     0.500000
        BSs2 =    -0.040303
        BSt2 =     0.019384
        BSy2 =     0.133140
        BSa2 =     0.539700
        BSb2 =     0.756590
        BSc2 =     0.331970
        BSd2 =     0.069257
        BSe2 =     1.018200
        BSf2 =     0.103580
        BSg2 =    -0.220000
        BSh2 =     0.000000
        BSa3 =     0.080160
        BSb3 =     0.100000
        BSc3 =    -0.082570
        BSe3 =     0.018670
        BSf3 =     0.091450
        BSg3 =     0.249800
        BSh3 =     0.631300
        BSi3 =     0.000000
        BSa4 =     2.326200
        BSb4 =     0.676240
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.140) THEN
C BBIB_5:
C    - interior surface of wall insulated over full height
C    - bottom of floor slab insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.012590
        BSb1 =     0.649880
        BSc1 =     0.002510
        BSd1 =     0.804100
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.002360
        BSq2 =    -0.259990
        BSr2 =     0.362950
        BSu2 =     0.153770
        BSv2 =     0.620000
        BSw2 =     0.665620
        BSx2 =     0.500000
        BSs2 =    -0.032500
        BSt2 =     0.025330
        BSy2 =     0.173580
        BSa2 =     0.771200
        BSb2 =     0.567300
        BSc2 =     0.313740
        BSd2 =     0.154600
        BSe2 =     2.042900
        BSf2 =     0.002390
        BSg2 =    -0.615050
        BSh2 =     0.000000
        BSa3 =     0.035480
        BSb3 =     0.213550
        BSc3 =    -0.105500
        BSe3 =     0.085500
        BSf3 =     0.099230
        BSg3 =     0.205840
        BSh3 =     0.674560
        BSi3 =     0.000000
        BSa4 =     2.303130
        BSb4 =     0.647160
        BSc4 =     1.000000
        icol =  3

      ELSEIF(iconfig.eq.141) THEN
C BBIB_6:
C    - interior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.013690
        BSb1 =     0.650050
        BSc1 =     0.002022
        BSd1 =     0.807080
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.004660
        BSq2 =     7.336860
        BSr2 =    -0.471580
        BSu2 =     0.096200
        BSv2 =     0.620000
        BSw2 =    -2.740600
        BSx2 =     0.730000
        BSs2 =     1.311300
        BSt2 =     0.006077
        BSy2 =    -0.309480
        BSa2 =     6.739200
        BSb2 =     0.261210
        BSc2 =     0.774910
        BSd2 =     0.501790
        BSe2 =     0.060400
        BSf2 =    -0.009997
        BSg2 =    -0.013330
        BSh2 =     0.000000
        BSa3 =    -0.179200
        BSb3 =     0.419230
        BSc3 =     0.201200
        BSe3 =     0.201400
        BSf3 =     0.046400
        BSg3 =    -0.010700
        BSh3 =     0.663900
        BSi3 =     0.000000
        BSa4 =     2.712500
        BSb4 =     0.160500
        BSc4 =     1.000000
        icol =  2

      ELSEIF(iconfig.eq.142) THEN
C BBEB_3:
C    - exterior surface of wall insulated over full height
C    - bottom of floor slab insulated with a 1.0m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.030640
        BSb1 =     0.650530
        BSc1 =    -0.000307
        BSd1 =     0.809200
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075730
        BSq2 =     7.627630
        BSr2 =    -0.467320
        BSu2 =     0.078184
        BSv2 =     0.620000
        BSw2 =    -2.630500
        BSx2 =     0.730000
        BSs2 =     1.249332
        BSt2 =     0.007903
        BSy2 =    -0.306510
        BSa2 =     6.940040
        BSb2 =     0.191590
        BSc2 =     0.758668
        BSd2 =     0.553020
        BSe2 =     0.091920
        BSf2 =    -0.028970
        BSg2 =     0.020170
        BSh2 =     0.000000
        BSa3 =     0.051800
        BSb3 =     0.212390
        BSc3 =    -0.111600
        BSe3 =     0.073330
        BSf3 =     0.099610
        BSg3 =     0.214240
        BSh3 =     0.648060
        BSi3 =     0.000000
        BSa4 =     2.347400
        BSb4 =     0.595840
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.143) THEN
C BBEB_4:
C    - exterior surface of wall insulated over full height
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.030585
        BSb1 =     0.650520
        BSc1 =    -0.000376
        BSd1 =     0.809200
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075760
        BSq2 =     8.625330
        BSr2 =    -0.498760
        BSu2 =     0.081750
        BSv2 =     0.620000
        BSw2 =    -2.553000
        BSx2 =     0.730000
        BSs2 =     1.308400
        BSt2 =     0.007158
        BSy2 =    -0.327700
        BSa2 =     7.506358
        BSb2 =     0.188600
        BSc2 =     0.775200
        BSd2 =     0.569300
        BSe2 =     0.077900
        BSf2 =    -0.026120
        BSg2 =     0.019240
        BSh2 =     0.000000
        BSa3 =     0.070580
        BSb3 =     0.253220
        BSc3 =    -0.132400
        BSe3 =     0.062050
        BSf3 =     0.092810
        BSg3 =     0.216200
        BSh3 =     0.636400
        BSi3 =     0.000000
        BSa4 =     2.394550
        BSb4 =     0.526970
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.144) THEN
C BBEB_5:
C    - exterior surface of wall insulated to 0.6m below grade
C    - bottom of floor slab insulated with a 0.6m strip around perimeter
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.030440
        BSb1 =     0.650000
        BSc1 =    -0.000700
        BSd1 =     0.810000
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.076200
        BSq2 =     6.980800
        BSr2 =    -0.462000
        BSu2 =     0.089760
        BSv2 =     0.620000
        BSw2 =    -2.833000
        BSx2 =     0.735000
        BSs2 =     1.316000
        BSt2 =     0.007800
        BSy2 =    -0.306200
        BSa2 =     6.558000
        BSb2 =     0.285200
        BSc2 =     0.780500
        BSd2 =     0.514480
        BSe2 =     0.076770
        BSf2 =    -0.014130
        BSg2 =    -0.015600
        BSh2 =     0.000000
        BSa3 =    -0.253500
        BSb3 =     0.389750
        BSc3 =     0.206770
        BSe3 =     0.228810
        BSf3 =     0.046850
        BSg3 =    -0.001900
        BSh3 =     0.665640
        BSi3 =     0.000000
        BSa4 =     2.622900
        BSb4 =     0.240800
        BSc4 =     1.000000
        icol =  5

      ELSEIF(iconfig.eq.145) THEN
C BBEA_2:
C    - exterior surface of wall insulated over full height
C    - top surface of floor slab fully insulated
C    - floor and wall insulation have same thermal resistance
C    - first-storey is brick veneer placed directly on basement's concrete walls
C    - 50mm wood walls and 100mm concrete floor
        BSa1 =    -0.030756
        BSb1 =     0.650500
        BSc1 =     0.000055
        BSd1 =     0.809140
        BSe1 =     1.000000
        BSf1 =     1.000000
        BSg1 =     1.000000
        BSh1 =     1.000000
        BSi1 =     0.000000
        BSj1 =     0.075449
        BSq2 =     0.588859
        BSr2 =    -0.037886
        BSu2 =     0.644873
        BSv2 =     0.620000
        BSw2 =    -3.702740
        BSx2 =     0.730000
        BSs2 =     0.653646
        BSt2 =     0.007464
        BSy2 =    -0.145560
        BSa2 =     3.113500
        BSb2 =     0.219430
        BSc2 =     0.507580
        BSd2 =     0.272440
        BSe2 =     0.252230
        BSf2 =     0.052930
        BSg2 =     0.020660
        BSh2 =     0.000000
        BSa3 =     0.035720
        BSb3 =    -0.013200
        BSc3 =    -0.018100
        BSe3 =     0.087370
        BSf3 =     0.233800
        BSg3 =     0.165200
        BSh3 =     0.592780
        BSi3 =     0.000000
        BSa4 =     2.454450
        BSb4 =     0.482300
        BSc4 =     1.000000
        icol =  7
 
      ELSE
        call edisp(IUOUT,' Not a valid iconfig.')

      ENDIF
      RETURN
      END
