"""Functions for scanning e2r daylight factor output files"""
import sys, os
import datetime
import re
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.ticker as tck


def ask_YorN(s_desc):
# Part of APUF (Andy's Python Useful Functions).
# Ask yes or no question and return a logical.
# Argument is a string containing the question, the function automatically adds syntax guidance onto the end of this.
    while True:
        s_YorN=input(s_desc+' Enter "y" or "n", or "e" to exit: ')
        if s_YorN=='y' or s_YorN=='Y':
            return True
        elif s_YorN=='n' or s_YorN=='N':
            return False
        elif s_YorN=='e' or s_YorN=='E':
            sys.exit('Exiting.')
        elif s_YorN=='42':
            print ('Nice reference you hoopy frood, but try again.')
        else:
            print ('Unrecognised input, please try again.')

def _read_file(filepath):
    """
    Reads in tab separated daylight factor data generated by e2r-Radiance
    All comments (#) are stripped and each line is an element in the returned
    list. Each line element is stripped of whitespace at either end, and is
    partitioned at the first whitespace character.
    Further splitting of elements will be required based on what file type is
    being read.
    """
    file = []
    with open(filepath, "r") as fp:
        for line in fp:
            # .partition returns a tuple: everything before the hash, the hash
            # and everything after the hash.
            # By indexing with [0] takes just the part before the hash.
            line = line.partition("#")[0]
            line = re.split('[ \t]', line)
            # print(line)

            # if line not empty append to file list
            if line[0]:
                file.append(line)
    return file


# Got this from www.geeksforgeeks.org/adding-value-labels-on-a-matplotlib-bar-chart/
def addlabels(x,y):
    for i in range(len(x)):
        if larger_fonts:
            plt.text(i, y[i], y[i], ha = 'center', fontsize=11)
        else:
            plt.text(i, y[i], y[i], ha = 'center')

# Parse command line.
s_dfFile=sys.argv[1]
# s_dfFile='Day_fa.df'
if not os.path.isfile(s_dfFile): sys.exit('Error: input file "'+s_dfFile+'" does not exist. Exiting.')

# Main program.
# Clear the arrays.
df_data=False
gx= []
gy= []
dft= []

introduction_a = 'This script scans Daylight Factor report and creates a contour plot.'
introduction_b = 'Give it the name of the df file and it should create a *.png file.'
introduction_c = 'Edit this script to adjust the graph size or the number of contours.'
print (introduction_a)
print (introduction_b)
print (introduction_c)
message = 'Proceed scanning ' + s_dfFile + '(Y/N)?'
doit = ask_YorN(message)
if not doit:
    sys.exit('Exiting...')

# Scan the df report into an overall entity holding all lines to work with.
df_rep = _read_file(s_dfFile)

larger_fonts = ask_YorN('Use larger fonts in graphs?')

# Get user opinion on verbosity.
verbose = ask_YorN('Display data as it is scanned?')

# Loop through each line, find the number of tokens in the current line.
for s_line in df_rep:
    n_tokens = len(s_line)
    if verbose:
        print (s_line)

# Parse the X Y and then the DF value from file.
    gx.append(float(s_line[0]))
    gy.append(float(s_line[1]))
    dft.append(float(s_line[3]))
    continue

# Set attributes of what is to be plotted. axs.tricontour is given
# the X Y & daylight factors from the file.  Alter ms below if you
# the DF grid points larger or smaller.
fig, axs = plt.subplots(figsize=(7.0,4.0), layout='constrained')
axs.tricontour(gx, gy, dft, levels=70, linewidths=0.3, colours='k')
cntr2 = axs.tricontour(gx, gy, dft, levels=70, cmap="RdBu_r")
fig.colorbar(cntr2, ax=axs)
axs.plot(gx, gy, 'ko', ms=1)
axs.set_title('Daylight factors in open plan offices')
plt.xlabel('Along facade (m)', fontsize=12)
axs.tick_params(axis='x', labelsize=11)
axs.tick_params(axis='y', labelsize=11)
figname = 'DF_coutours' + '.png'
plt.savefig(figname, format='png')
plt.close()            
print ('created ' + figname)
dft = []

        
