# Synopsis
 
Synopsis of the model Office with clear story window & TrombeM wall & small
dampers 3D flow defined in trombe_wall_office_cr3d_ctl.cfg generated on Tue
Feb  5 15:21:29 2019. Associated notes are in ../doc/trombe_wall_office.log
 
The model is located at latitude   55.90 with a longitude difference of  -4.10
from the local time meridian (east +ve). The year used in simulations is 2007
and weekends occur on Saturday and Sunday.
 
The site exposure is typical city centre and the ground reflectance is 0.20.
 
 
The climate is: ESP test climate and is held in: clm67 with hour centred solar data.
Standard annual weather clm67                                                                                                                       
Calculated ground temperature at depth                                                                                      
  0.5 m: 3.0888 4.3008 6.6610 8.8949 13.123 15.349 15.963 14.834 12.227 8.9770 5.7777 3.6649                                                                                                                                                                                                                                                                                                                                                                                                                    
  1.0 m: 3.6630 4.5020 6.4738 8.4398 12.343 14.560 15.374 14.612 12.434 9.5459 6.5633 4.4524                                                                                                                                                                                                                                                                                                                                                                                                                    
  1.5 m: 4.2245 4.7614 6.3956 8.1158 11.689 13.852 14.802 14.336 12.531 9.9790 7.2247 5.1599                                                                                                                                                                                                                                                                                                                                                                                                                    
  2.0 m: 4.7588 5.0557 6.4004 7.8990 11.149 13.226 14.259 14.027 12.542 10.298 7.7730 5.7855                                                                                                                                                                                                                                                                                                                                                                                                                    
  2.5 m: 5.2563 5.3667 6.4664 7.7682 10.709 12.681 13.756 13.705 12.490 10.522 8.2208 6.3313                                                                                                                                                                                                                                                                                                                                                                                                                    
  3.0 m: 5.7116 5.6803 6.5755 7.7046 10.357 12.211 13.297 13.382 12.393 10.670 8.5810 6.8017                                                                                                                                                                                                                                                                                                                                                                                                                    
  3.5 m: 6.1222 5.9864 6.7127 7.6921 10.080 11.812 12.884 13.069 12.266 10.758 8.8661 7.2026                                                                                                                                                                                                                                                                                                                                                                                                                    
  4.0 m: 6.4880 6.2779 6.8663 7.7174 9.8661 11.475 12.517 12.771 12.121 10.800 9.0880 7.5409                                                                                                                                                                                                                                                                                                                                                                                                                    
  4.5 m: 6.8105 6.5502 7.0275 7.7692 9.7037 11.193 12.194 12.495 11.967 10.806 9.2575 7.8239                                                                                                                                                                                                                                                                                                                                                                                                                    
  5.0 m: 7.0924 6.8008 7.1892 7.8387 9.5835 10.959 11.913 12.241 11.812 10.787 9.3843 8.0587                                                                                                                                                                                                                                                                                                                                                                                                                    
  5.5 m: 7.3371 7.0287 7.3468 7.9188 9.4969 10.767 11.669 12.010 11.659 10.750 9.4768 8.2523                                                                                                                                                                                                                                                                                                                                                                                                                    
  6.0 m: 7.5483 7.2337 7.4969 8.0042 9.4367 10.610 11.459 11.804 11.513 10.702 9.5423 8.4109                                                                                                                                                                                                                                                                                                                                                                                                                    
  6.5 m: 7.7298 7.4168 7.6374 8.0909 9.3969 10.482 11.279 11.619 11.376 10.646 9.5869 8.5404                                                                                                                                                                                                                                                                                                                                                                                                                    
  7.0 m: 7.8854 7.5794 7.7672 8.1760 9.3725 10.377 11.125 11.456 11.249 10.588 9.6156 8.6458                                                                                                                                                                                                                                                                                                                                                                                                                    
  7.5 m: 8.0186 7.7231 7.8858 8.2576 9.3593 10.293 10.993 11.312 11.132 10.530 9.6324 8.7315                                                                                                                                                                                                                                                                                                                                                                                                                    
  8.0 m: 8.1327 7.8497 7.9934 8.3344 9.3543 10.224 10.881 11.185 11.026 10.472 9.6407 8.8013                                                                                                                                                                                                                                                                                                                                                                                                                    
  8.5 m: 8.2306 7.9611 8.0905 8.4057 9.3549 10.168 10.784 11.074 10.931 10.417 9.6430 8.8583                                                                                                                                                                                                                                                                                                                                                                                                                    
  9.0 m: 8.3148 8.0592 8.1776 8.4712 9.3591 10.121 10.701 10.976 10.845 10.366 9.6413 8.9053                                                                                                                                                                                                                                                                                                                                                                                                                    
  9.5 m: 8.3877 8.1457 8.2557 8.5310 9.3656 10.083 10.630 10.889 10.768 10.319 9.6371 8.9442                                                                                                                                                                                                                                                                                                                                                                                                                    
 10.0 m: 8.4510 8.2221 8.3255 8.5853 9.3733 10.051 10.568 10.813 10.699 10.275 9.6314 8.9770                                                                                                                                                                                                                                                                                                                                                                                                                    
 
 
## Integrated Performance View  
An Integrated Performance View is incomplete or missing.  
 
## Databases
: Databases associated with the model
 
-------------------------  --------------------
standard pressure distr    pressc.db1
standard materials         material.db
constructions              ../dbs/trombe_wall_office.constrdb
standard plant comp        plantc.db1
standard event profiles    profiles.db2.a
standard optical prop      optics.db
standard UK NCM data       SBEM.db1
standard predefined obj    predefined.db1
standard mould isopleth    mould.db1
-------------------------  --------------------
 
## Controls
 
The model includes ideal controls -
vents closed unless trombe  upper is warmer than office
        
 
 Flow control includes  4 loops.
uses delta T between trombe_up and office
 
The sensor for function  1 sensors are nodes trombe_up (  4) & office (  6)  
The actuator for function  1 is flow connection:   9 trombe_up - office via GrOPz04:007  
 >  1 periods of validity during the year have been defined.
 
Control is valid Mon-01-Jan to Mon-31-Dec, 2007 with  3 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  delt T > flow          on/off setpoint 4.00 direct action ON fraction 0.000.  
  2   7.00  delt T > flow          on/off setpoint 3.00 direct action ON fraction 1.000.  
  3  18.00  delt T > flow          on/off setpoint 4.00 direct action ON fraction 0.000.  
 
The sensor for function  2 sensors are nodes trombe_up (  4) & office (  6)  
The actuator for function  2 is flow connection:   5 trombe_low - office via GrOPz01:008  
 >  1 periods of validity during the year have been defined.
 
Control is valid Mon-01-Jan to Mon-31-Dec, 2007 with  3 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  delt T > flow          on/off setpoint 4.00 direct action ON fraction 0.000.  
  2   7.00  delt T > flow          on/off setpoint 3.00 direct action ON fraction 1.000.  
  3  18.00  delt T > flow          on/off setpoint 4.00 direct action ON fraction 0.000.  
 
The sensor for function  3 senses node (4) trombe_up  
The actuator for function  3 is flow connection:   4 BW-Op01:007 - trombe_low via GrOPz01:007  
 >  1 periods of validity during the year have been defined.
 
Control is valid Mon-01-Jan to Mon-31-Dec, 2007 with  1 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  dry bulb > flow        on/off setpoint 27.00 direct action ON fraction 1.000.  
 
The sensor for function  4 senses node (4) trombe_up  
The actuator for function  4 is flow connection:  10 BW-Op04:009 - trombe_up via GrOPz04:009  
 >  1 periods of validity during the year have been defined.
 
Control is valid Mon-01-Jan to Mon-31-Dec, 2007 with  1 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  dry bulb > flow        on/off setpoint 27.00 direct action ON fraction 1.000.  
 
 
## Flow network description
The model includes a mass flow network.
The details are shown below.  
 
  11 nodes,  12 components,  12 connections;     wind reduction =  1.000
 
: Network summary
 
   # Node        Fluid   Node Type            X       Y       Z       Temperature Data_1  Data_2
 --- ----------- -----  -------------------   ------  ------  ------  ----------- ------  ------ ---- -------
   1 trombe_low   air   internal & unknown    2.0000  1.1000  0.3750   20.000     (-)     1.000  vol    0.600
   2 trombe_mid   air   internal & unknown    2.0000  1.1000  1.1250   20.000     (-)     1.000  vol    0.600
   3 trombe_mid2  air   internal & unknown    2.0000  1.1000  1.8750   20.000     (-)     1.000  vol    0.600
   4 trombe_up    air   internal & unknown    2.0000  1.1000  2.6250   20.000     (-)     1.000  vol    0.600
   5 bypass       air   internal & unknown   -0.1000  1.1000  1.5000   20.000     (-)     1.000  vol    0.120
   6 office       air   internal & unknown    2.0000  3.4500  1.5000   20.000     (-)     1.000  vol   49.501
   7 BW-Cr01:001  air   boundary & wind ind   2.5000  0.1000  0.1000   0.0000     coef    9.000  azim 180.000
   8 BW-Op01:007  air   boundary & wind ind   2.1000  0.1000  0.1000   0.0000     coef    1.000  azim 180.000
   9 BW-Op04:009  air   boundary & wind ind   2.1000  0.1000  2.9000   0.0000     coef    1.000  azim 180.000
  10 BW-Cr06:014  air   boundary & wind ind   3.4000  6.6000  0.0000   0.0000     coef    1.000  azim   0.000
  11 bypass_out   air   boundary & wind ind  -1.1000  1.1000  1.5000   0.0000     coef    5.000  azim 270.000
 
 Component    Type C+ L+ X Y Z Position Description
 
 WiCrz01:001   120  3  0   2.5   1.0   0.2 Specific air flow crack             m = rho.f(W,L,dP)
 Associated with trombe_low:front
 Fluid  1.0 crack width(m)  0.0020 crack length(m)  4.000
 
 GrOPz01:004    40  3  0   0.0   1.1   0.4 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_low:fict_left
 Fluid  1.0 opening area (m^2)  0.150 discharge factor (-) 0.400
 
 GrOPz01:005    40  3  0   2.0   1.1   0.8 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_low:fict_up
 Fluid  1.0 opening area (m^2)  0.800 discharge factor (-) 0.500
 
 GrOPz01:007    40  3  0   2.1   1.0   0.1 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_low:out_vent
 Fluid  1.0 opening area (m^2)  0.090 discharge factor (-) 0.900
 
 GrOPz01:008    40  3  0   0.9   1.2   0.1 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_low:low_in_vent
 Fluid  1.0 opening area (m^2)  0.100 discharge factor (-) 0.900
 
 GrOPz02:005    40  3  0   2.0   1.1   1.5 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_mid:fict_up
 Fluid  1.0 opening area (m^2)  0.800 discharge factor (-) 0.500
 
 GrOPz03:005    40  3  0   2.0   1.1   2.2 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_low:out_vent
 Fluid  1.0 opening area (m^2)  0.800 discharge factor (-) 0.400
 
 GrOPz04:004    40  3  0   0.0   1.1   2.6 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_up:fict_left
 Fluid  1.0 opening area (m^2)  0.150 discharge factor (-) 0.500
 
 GrOPz04:007    40  3  0   0.9   1.2   2.3 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_up:up_grill
 Fluid  1.0 opening area (m^2)  0.090 discharge factor (-) 0.900
 
 GrOPz04:009    40  3  0   2.1   1.0   2.9 Common orifice flow component m = rho.f(Cd,A,rho,dP)
 Associated with trombe_up:up_out_grill
 Fluid  1.0 opening area (m^2)  0.090 discharge factor (-) 0.900
 
 FrCrz05:003   120  3  0  -0.2   1.1   1.5 Specific air flow crack             m = rho.f(W,L,dP)
 Associated with bypass:left
 Fluid  1.0 crack width(m)  0.0020 crack length(m)  3.200
 
 DoCrz06:014   120  3  0   3.4   5.7   0.0 Specific air flow crack             m = rho.f(W,L,dP)
 Associated with office:bk_door
 Fluid  1.0 crack width(m)  0.0050 crack length(m)  0.800
 
 
: Connection summary
 
   # +Node         dHght   -Node         dHght   Component       Z @+    Z @-
 --- ------------ -------  -----------  -------  ------------   ------  ------
    1 BW-Cr01:001  -0.000   trombe_low   -0.138   WiCrz01:001     0.100   0.237
    2 trombe_low    0.000   bypass       -1.125   GrOPz01:004     0.375   0.375
    3 trombe_low    0.375   trombe_mid   -0.375   GrOPz01:005     0.750   0.750
    4 BW-Op01:007   0.000   trombe_low   -0.275   GrOPz01:007     0.100   0.100
    5 trombe_low   -0.275   office       -1.400   GrOPz01:008     0.100   0.100
    6 trombe_mid    0.375   trombe_mid2  -0.375   GrOPz02:005     1.500   1.500
    7 trombe_mid2   0.375   trombe_up    -0.375   GrOPz03:005     2.250   2.250
    8 trombe_up     0.000   bypass        1.125   GrOPz04:004     2.625   2.625
    9 trombe_up    -0.275   office        0.850   GrOPz04:007     2.350   2.350
   10 BW-Op04:009   0.000   trombe_up     0.275   GrOPz04:009     2.900   2.900
   11 BW-Cr06:014   0.000   office       -1.500   DoCrz06:014     0.000   0.000
   12 bypass_out    0.000   bypass        0.000   FrCrz05:003     1.500   1.500
 
thermal zone -> air flow node  
trombe_low   -> trombe_low  
trombe_mid   -> trombe_mid  
trombe_mid2  -> trombe_mid2  
trombe_up    -> trombe_up  
bypass       -> bypass  
office       -> office  
 
 
## Zones
 
: Zone summary
 
ID  Zone name     Volume (m^3^)  Surfaces   Opaque (m^2^)    Transparent (m^2^)   Floor (m^2^)    Description
--  ------------  -------------  --------   --------------   ------------------   -------------   -------------------------------------------
 1  trombe_low       0.6            8                4.0                  3.9              0.8     trombe_low describes lower section of trombe air gap
 2  trombe_mid       0.6            6                3.2                  4.8              0.8     trombe_mid describes 2nd level of air gap in trombe wall
 3  trombe_mid2      0.6            6                3.2                  4.8              0.8     trombe_mid2 describes upper middle section of trombe wall gap
 4  trombe_up        0.6            9                2.0                  5.9              0.8     trombe_up is the clear glazing section of trombe wall air gap
 5  bypass           0.1            9                1.9                  0.6              0.2     bypass describes a vertical air channel for circulation
 6  office          49.5           14               82.7                  2.0             18.0     office is behind trombe wall with clear story glazing
 -  all             52.            52               96.9                 21.9             21.4             -
 
### Zone 1: trombe_low
 
Zone trombe_low ( 1) is composed of 8 surfaces and 16 vertices.
It encloses a volume of 0.600 m^3^ of space, with a total surface
area of 7.90 m^2^ & approx floor area of 0.800 m^2^.
trombe_low describes lower section of trombe air gap.  
There is 3.0000 m^2^ of exposed surface area, 3.0000 m^2^ of which is vertical.
Facade glazing is 2.9600 m^2^ & 370.0 % of floor &  98.7 % facade with average U of 5.621 & UA of 16.639.  
Opaque partitions:ceiling:floor 3.0000 m^2^ & trasparent partitions:ceiling:floor 0.95000 m^2^.  
Ground contact is 100.00 % of floor area & average U of 0.461 & perimeter 4.0000  
 
: A summary of the surfaces in trombe_low( 1)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  2.96         180.        0.       front         SCF8477_      VERT      C-WINDOW     CRACK       single_glz            external
  2  0.150         90.        0.       right         OPAQUE        VERT      -            -           insul_mtl_p           identical environment
  3  2.96           0.        0.       trombe_face   OPAQUE        VERT      -            -           trombe_mas_a          wall_tlow:office
  4  0.150        270.        0.       fict_left     SC_ficti      VERT      GRILL        OPEN        fictitious            fict_low:bypass
  5  0.800          0.       90.       fict_up       SC_ficti      CEIL      GRILL        OPEN        fictitious            fict_base:trombe_mid
  6  0.800          0.      -90.       base          OPAQUE        FLOR      -            -           insul_mtl_p           ground profile  1
  7  0.040        180.        0.       out_vent      OPAQUE        VERT      GRILL        OPEN        int_doors             external
  8  0.040          0.        0.       low_in_vent   OPAQUE        VERT      GRILL        OPEN        int_doors             low_in_vent:office
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1     0.0000     1.0000     0.0000
    2     4.0000     1.0000     0.0000
    3     4.0000     1.2000     0.0000
    4     0.0000     1.2000     0.0000
    5     0.0000     1.0000     0.7500
    6     4.0000     1.0000     0.7500
    7     4.0000     1.2000     0.7500
    8     0.0000     1.2000     0.7500
    9     2.0000     1.0000     0.0000
   10     2.2000     1.0000     0.0000
   11     2.2000     1.0000     0.2000
   12     2.0000     1.0000     0.2000
   13     1.0000     1.2000     0.0000
   14     0.8000     1.2000     0.0000
   15     0.8000     1.2000     0.2000
   16     1.0000     1.2000     0.2000
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   8 1,9,12,11,10,2,6,5                 front          9.900
   4 2,3,7,6                            right          1.900
   8 3,13,16,15,14,4,8,7                trombe_face    9.900
   4 4,1,5,8                            fict_left      1.900
   4 5,6,7,8                            fict_up        8.400
   8 1,4,14,13,3,2,10,9                 base           8.400
   4 9,10,11,12                         out_vent       0.800
   4 13,14,15,16                        low_in_vent    0.800
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
front out_vent  
Insolation sources (all applicable) 
front  
 
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     0.0    0.0    3.0    4.0    1.0    0.1    0.0    0.0  1.00   overhang extern_wall
 
 Shading patterns have been calculated for this zone.
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: trombe_low
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
weekdays    2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
weekdays    3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
saturday    1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
saturday    2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
saturday    3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
sunday      1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
sunday      2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
sunday      3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
 
### Zone 2: trombe_mid
 
Zone trombe_mid ( 2) is composed of 6 surfaces and 8 vertices.
It encloses a volume of 0.600 m^3^ of space, with a total surface
area of 7.90 m^2^ & approx floor area of 0.800 m^2^.
trombe_mid describes 2nd level of air gap in trombe wall.  
There is 3.0000 m^2^ of exposed surface area, 3.0000 m^2^ of which is vertical.
Facade glazing is 3.0000 m^2^ & 375.0 % of floor & 100.0 % facade with average U of 5.621 & UA of 16.864.  
Opaque partitions:ceiling:floor 3.0000 m^2^ & trasparent partitions:ceiling:floor 1.7500 m^2^.  
 
: A summary of the surfaces in trombe_mid( 2)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  3.00         180.        0.       front         SCF8477_      VERT      -            -           single_glz            external
  2  0.150         90.        0.       right         OPAQUE        VERT      -            -           insul_mtl_p           identical environment
  3  3.00         360.        0.       trombe_face   OPAQUE        VERT      -            -           trombe_mas_a          wall_tmid:office
  4  0.150        270.        0.       fict_left     SC_ficti      VERT      -            -           fictitious            fict_mid:bypass
  5  0.800          0.       90.       fict_up       SC_ficti      CEIL      GRILL        OPEN        fictitious            fict_base:trombe_mid2
  6  0.800          0.      -90.       fict_base     SC_ficti      FLOR      GRILL        OPEN        fictitious            fict_up:trombe_low
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1     0.0000     1.0000     0.7500
    2     4.0000     1.0000     0.7500
    3     4.0000     1.2000     0.7500
    4     0.0000     1.2000     0.7500
    5     0.0000     1.0000     1.5000
    6     4.0000     1.0000     1.5000
    7     4.0000     1.2000     1.5000
    8     0.0000     1.2000     1.5000
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   4 1,2,6,5                            front          9.500
   4 2,3,7,6                            right          1.900
   4 3,4,8,7                            trombe_face    9.500
   4 4,1,5,8                            fict_left      1.900
   4 5,6,7,8                            fict_up        8.400
   4 1,4,3,2                            fict_base      8.400
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
front  
Insolation sources (all applicable) 
front  
 
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     0.0    0.0    3.0    4.0    1.0    0.1    0.0    0.0  1.00   overhang extern_wall
 
 Shading patterns have been calculated for this zone.
 
 Uses same operations as zone trombe_low
 
### Zone 3: trombe_mid2
 
Zone trombe_mid2 ( 3) is composed of 6 surfaces and 8 vertices.
It encloses a volume of 0.600 m^3^ of space, with a total surface
area of 7.90 m^2^ & approx floor area of 0.800 m^2^.
trombe_mid2 describes upper middle section of trombe wall gap.  
There is 3.0000 m^2^ of exposed surface area, 3.0000 m^2^ of which is vertical.
Facade glazing is 3.0000 m^2^ & 375.0 % of floor & 100.0 % facade with average U of 5.621 & UA of 16.864.  
Opaque partitions:ceiling:floor 3.0000 m^2^ & trasparent partitions:ceiling:floor 1.7500 m^2^.  
 
: A summary of the surfaces in trombe_mid2( 3)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  3.00         180.        0.       front         SCF8477_      VERT      -            -           single_glz            external
  2  0.150         90.        0.       right         OPAQUE        VERT      -            -           insul_mtl_p           identical environment
  3  3.00         360.        0.       trombe_face   OPAQUE        VERT      -            -           trombe_mas_a          wall_tup:office
  4  0.150        270.        0.       fict_left     SC_ficti      VERT      -            -           fictitious            fict_mid2:bypass
  5  0.800          0.       90.       fict_up       SC_ficti      CEIL      GRILL        OPEN        fictitious            fict_base:trombe_up
  6  0.800          0.      -90.       fict_base     SC_ficti      FLOR      GRILL        OPEN        fictitious            fict_up:trombe_mid
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1     0.0000     1.0000     1.5000
    2     4.0000     1.0000     1.5000
    3     4.0000     1.2000     1.5000
    4     0.0000     1.2000     1.5000
    5     0.0000     1.0000     2.2500
    6     4.0000     1.0000     2.2500
    7     4.0000     1.2000     2.2500
    8     0.0000     1.2000     2.2500
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   4 1,2,6,5                            front          9.500
   4 2,3,7,6                            right          1.900
   4 3,4,8,7                            trombe_face    9.500
   4 4,1,5,8                            fict_left      1.900
   4 5,6,7,8                            fict_up        8.400
   4 1,4,3,2                            fict_base      8.400
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
front  
Insolation sources (all applicable) 
front  
 
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     0.0    0.0    3.0    4.0    1.0    0.1    0.0    0.0  1.00   overhang extern_wall
 
 Shading patterns have been calculated for this zone.
 
 Uses same operations as zone trombe_low
 
### Zone 4: trombe_up
 
Zone trombe_up ( 4) is composed of 9 surfaces and 24 vertices.
It encloses a volume of 0.600 m^3^ of space, with a total surface
area of 7.90 m^2^ & approx floor area of 0.800 m^2^.
trombe_up is the clear glazing section of trombe wall air gap.  
There is 3.8000 m^2^ of exposed surface area, 3.0000 m^2^ of which is vertical.
Flat roof is 100.00 % of floor area & average U of 0.467 & UA of 0.37383.
Facade glazing is 2.9600 m^2^ & 370.0 % of floor &  98.7 % facade with average U of 5.621 & UA of 16.639.  
Opaque partitions:ceiling:floor 0.99000 m^2^ & trasparent partitions:ceiling:floor 2.9600 m^2^.  
 
: A summary of the surfaces in trombe_up( 4)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  2.96         180.        0.       front         SCF8477_      VERT      -            -           single_glz            external
  2  0.150         90.        0.       right         OPAQUE        VERT      -            -           insul_mtl_p           identical environment
  3  0.950        360.        0.       frame_open    OPAQUE        VERT      -            -           door                  frame_open:office
  4  0.150        270.        0.       fict_left     SC_ficti      VERT      GRILL        OPEN        fictitious            fict_up:bypass
  5  0.800          0.       90.       top           OPAQUE        CEIL      -            -           insul_mtl_p           external
  6  0.800          0.      -90.       fict_base     SC_ficti      FLOR      GRILL        OPEN        fictitious            fict_up:trombe_mid2
  7  0.040          0.        0.       up_grill      OPAQUE        VERT      GRILL        OPEN        int_doors             up_grill:office
  8  2.01         360.        0.       up_in_glz     SCF8477_      VERT      WINDOW       CLOSED      single_glz            up_in_glz:office
  9  0.040        180.        0.       up_out_grill  OPAQUE        VERT      GRILL        OPEN        int_doors             external
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1     0.0000     1.0000     2.2500   13     3.9000     1.2000     2.3500
    2     4.0000     1.0000     2.2500   14     1.1000     1.2000     2.3500
    3     4.0000     1.2000     2.2500   15     1.1000     1.2000     2.5500
    4     0.0000     1.2000     2.2500   16     0.7000     1.2000     2.5500
    5     0.0000     1.0000     3.0000   17     0.7000     1.2000     2.3500
    6     4.0000     1.0000     3.0000   18     0.1000     1.2000     2.3500
    7     4.0000     1.2000     3.0000   19     0.1000     1.2000     2.9000
    8     0.0000     1.2000     3.0000   20     3.9000     1.2000     2.9000
    9     1.0000     1.2000     2.2500   21     2.2000     1.0000     3.0000
   10     0.8000     1.2000     2.2500   22     2.0000     1.0000     3.0000
   11     0.8000     1.2000     2.4500   23     2.2000     1.0000     2.8000
   12     1.0000     1.2000     2.4500   24     2.0000     1.0000     2.8000
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   8 1,2,6,21,23,24,22,5                front          9.900
   4 2,3,7,6                            right          1.900
  18 3,13,20,19,18,17,16,15,14,13,3,9   frame_open    19.283
   4 4,1,5,8                            fict_left      1.900
   6 5,22,21,6,7,8                      top            8.400
   6 1,4,10,9,3,2                       fict_base      8.400
   4 9,10,11,12                         up_grill       0.800
   8 13,14,15,16,17,18,19,20            up_in_glz      9.100
   4 24,23,21,22                        up_out_grill   0.800
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
front top up_out_grill  
Insolation sources (all applicable) 
front  
 
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     0.0    0.0    3.0    4.0    1.0    0.1    0.0    0.0  1.00   overhang extern_wall
 
 Shading patterns have been calculated for this zone.
 
 Uses same operations as zone trombe_low
 
### Zone 5: bypass
 
Zone bypass ( 5) is composed of 9 surfaces and 14 vertices.
It encloses a volume of 0.120 m^3^ of space, with a total surface
area of 2.48 m^2^ & approx floor area of 0.190 m^2^.
bypass describes a vertical air channel for circulation.  
There is 0.60000 m^2^ of exposed surface area, 0.60000 m^2^ of which is vertical.
Facade opaque is 0.60000 m^2^ & 315.8 % of floor area & average U of 0.461 & UA of 0.27649.
Facade opaque is 0.60000 m^2^ & 315.8 % of floor area & average U of 0.461 & UA of 0.27649.  
 
: A summary of the surfaces in bypass( 5)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  0.600        180.        0.       front         OPAQUE        VERT      -            -           insul_mtl_p           external
  2  0.600        360.        0.       back          OPAQUE        VERT      -            -           insul_mtl_p           adiabatic
  3  0.600        270.        0.       left          OPAQUE        VERT      F-FRAME      CRACK       insul_mtl_p           adiabatic
  4  0.040          0.       90.       top           OPAQUE        CEIL      -            -           insul_mtl_p           adiabatic
  5  0.040          0.      -90.       base          OPAQUE        FLOR      -            -           insul_mtl_p           adiabatic
  6  0.150         90.        0.       fict_low      SC_ficti      VERT      GRILL        OPEN        fictitious            fict_left:trombe_low
  7  0.150         90.        0.       fict_mid      SC_ficti      VERT      -            -           fictitious            fict_left:trombe_mid
  8  0.150         90.        0.       fict_mid2     SC_ficti      VERT      -            -           fictitious            fict_left:trombe_mid2
  9  0.150         90.        0.       fict_up       SC_ficti      VERT      GRILL        OPEN        fictitious            fict_left:trombe_up
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1    -0.2000     1.0000     0.0000
    2     0.0000     1.0000     0.0000
    3     0.0000     1.2000     0.0000
    4    -0.2000     1.2000     0.0000
    5    -0.2000     1.0000     3.0000
    6     0.0000     1.0000     3.0000
    7     0.0000     1.2000     3.0000
    8    -0.2000     1.2000     3.0000
    9     0.0000     1.0000     0.7500
   10     0.0000     1.2000     0.7500
   11     0.0000     1.0000     1.5000
   12     0.0000     1.2000     1.5000
   13     0.0000     1.0000     2.2500
   14     0.0000     1.2000     2.2500
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   7 1,2,9,11,13,6,5                    front          6.400
   7 3,4,8,7,14,12,10                   back           6.400
   4 4,1,5,8                            left           6.400
   4 5,6,7,8                            top            0.800
   4 1,4,3,2                            base           0.800
   4 2,3,10,9                           fict_low       1.900
   4 9,10,12,11                         fict_mid       1.900
   4 11,12,14,13                        fict_mid2      1.900
   4 13,14,7,6                          fict_up        1.900
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 
 
 Uses same operations as zone trombe_low
 
### Zone 6: office
 
Zone office ( 6) is composed of 14 surfaces and 38 vertices.
It encloses a volume of 49.5 m^3^ of space, with a total surface
area of 84.7 m^2^ & approx floor area of 18.0 m^2^.
office is behind trombe wall with clear story glazing.  
There is 1.6800 m^2^ of exposed surface area, 1.6800 m^2^ of which is vertical.
Facade opaque is 1.6800 m^2^ &   9.3 % of floor area & average U of 3.316 & UA of 5.5707.
Opaque partitions:ceiling:floor 9.9900 m^2^ & trasparent partitions:ceiling:floor 2.0100 m^2^.  
Ground contact is 88.889 % of floor area & average U of 0.699 & perimeter 0.80000  
 
: A summary of the surfaces in office( 6)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Optics        Location  Use primary  Use detail  Construction name    Environment other side
---  -----------  --------  ---------  ------------  ------------  --------  -----------  ----------  -------------------  ----------------------
  1  2.96         180.        0.       wall_tlow     OPAQUE        VERT      -            -           trombe_mass           trombe_face:trombe_low
  2  12.4          90.        0.       right_ptn     OPAQUE        VERT      -            -           gyp_blk_ptn           identical environment
  3  10.3           0.        0.       back_ptn      OPAQUE        VERT      -            -           gyp_blk_ptn           identical environment
  4  12.4         270.        0.       left_ptn      OPAQUE        VERT      -            -           gyp_blk_ptn           identical environment
  5  18.0           0.       90.       ceiling       OPAQUE        CEIL      -            -           trombe_mass           identical environment
  6  16.0           0.      -90.       floor         OPAQUE        FLOR      -            -           grnd_floor            ground profile  1
  7  3.00         180.        0.       wall_tmid     OPAQUE        VERT      -            -           trombe_mass           trombe_face:trombe_mid
  8  3.00         180.        0.       wall_tup      OPAQUE        VERT      -            -           trombe_mass           trombe_face:trombe_mid2
  9  2.00           0.      -90.       top_of_tw     OPAQUE        FLOR      -            -           trombe_mas_a          identical environment
 10  0.040        180.        0.       low_in_vent   OPAQUE        VERT      GRILL        OPEN        int_doors             low_in_vent:trombe_low
 11  0.950        180.        0.       frame_open    OPAQUE        VERT      -            -           door                  frame_open:trombe_up
 12  0.040        180.        0.       up_grill      OPAQUE        VERT      GRILL        OPEN        int_doors             up_grill:trombe_up
 13  2.01         180.        0.       up_in_glz     SCF8477_      VERT      WINDOW       CLOSED      single_glz            up_in_glz:trombe_up
 14  1.68           0.        0.       bk_door       OPAQUE        VERT      DOOR         UNDERCUT    int_doors             external
 
 
: A summary of the vertices
 
Vertex X          Y          Z         Vertex X         Y          Z
------ ---------  ---------  --------- ------ --------- ---------  ---------
    1     0.0000     1.7000     0.0000   20     0.8000     1.7000     0.0000
    2     4.0000     1.7000     0.0000   21     0.8000     1.7000     0.2000
    3     4.0000     5.7000     0.0000   22     1.0000     1.7000     0.2000
    4     0.0000     5.7000     0.0000   23     3.9000     1.2000     2.3500
    5     0.0000     1.7000     3.0000   24     3.9000     1.2000     2.9000
    6     4.0000     1.7000     3.0000   25     0.1000     1.2000     2.9000
    7     4.0000     5.7000     3.0000   26     0.1000     1.2000     2.3500
    8     0.0000     5.7000     3.0000   27     0.7000     1.2000     2.3500
    9     0.0000     1.2000     2.2500   28     0.7000     1.2000     2.5500
   10     0.0000     1.2000     3.0000   29     1.1000     1.2000     2.5500
   11     4.0000     1.2000     2.2500   30     1.1000     1.2000     2.3500
   12     4.0000     1.2000     3.0000   31     1.0000     1.2000     2.2500
   13     0.0000     1.7000     2.2500   32     1.0000     1.2000     2.4500
   14     4.0000     1.7000     2.2500   33     0.8000     1.2000     2.4500
   15     0.0000     1.7000     0.7500   34     0.8000     1.2000     2.2500
   16     0.0000     1.7000     1.5000   35     3.8000     5.7000     0.0000
   17     4.0000     1.7000     0.7500   36     3.0000     5.7000     0.0000
   18     4.0000     1.7000     1.5000   37     3.0000     5.7000     2.1000
   19     1.0000     1.7000     0.0000   38     3.8000     5.7000     2.1000
 
: A summary of the edges
 
Edge List                              Name          Perimeter
---- --------------------------------  ------------- ---------
   8 1,20,21,22,19,2,17,15              wall_tlow      9.900
   9 2,3,7,6,12,11,14,18,17             right_ptn     15.000
   8 3,35,38,37,36,4,8,7                back_ptn      18.200
   9 4,1,15,16,13,9,10,5,8              left_ptn      15.000
   6 10,12,6,7,8,5                      ceiling       17.000
   8 1,4,36,35,3,2,19,20                floor         16.000
   4 15,17,18,16                        wall_tmid      9.500
   4 16,18,14,13                        wall_tup       9.500
   6 11,31,34,9,13,14                   top_of_tw      9.000
   4 20,19,22,21                        low_in_vent    0.800
  18 23,11,12,10,9,34,33,32,31,11,23,   frame_open    19.283
   4 34,31,32,33                        up_grill       0.800
   8 30,23,24,25,26,27,28,29            up_in_glz      9.100
   4 35,36,37,38                        bk_door        5.800
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 
visual type name    composition
 vis 1rot  low-mass trombe_mas_a
 vis 1rot  mid-mass trombe_mas_a
 vis 1rot  high-mass trombe_mas_a
 
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: office
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
weekdays    2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
weekdays    3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
saturday    1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
saturday    2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
saturday    3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
sunday      1  Occupt     people     W      0-24       0.0      0.0       0.50       0.50
sunday      2  Lights     lighting   W      0-24       0.0      0.0       0.50       0.50
sunday      3  Equipt     equipment  W      0-24       0.0      0.0       0.50       0.50
 
## Areas
 
 
 Project floor area is 21.390m2, wall area is 2.3600m2, window area is 11.920m2.
 Sloped roof area is 0.00m2, flat roof area is 0.80000m2, skylight area is 0.00m2.
 In contact with ground 16.800m2.
 There is 15.080m2 of outside surface area, 14.280m2 of which is vertical.
 
 Outside walls are 11.033 % of floor area & average U of 2.590 & UA of 6.1124 & max MLC thickness 0.088
 Flat roof is 3.7401 % of floor area & average U of 0.467 & UA of 0.37383
 Glazing is 55.727 % of floor & 83.473 % facade with average U of 5.621 & UA of 67.006
 Ground contact is 78.541 % of floor area & average U of 0.687 & perimeter 4.8000 & max MLC thickness 0.975
 CIBSE ground beta! 7.000 dt 2.330 Ufleft 0.123 Ufright 2.346 Uf 0.289 R extra @ virtual layer 2.002
 
## Constructions  
 Multi-layer constructions referenced in the model.  
 
 
### insul_mtl_p
Details of opaque construction: insul_mtl_p with an overall thickness of  0.088m.  
In category general constructions also shown in menus as: insulated metal wall panel  
insulated grey aluminium panel wall with 80mm insulation (legacy construction used in some
training models)
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
Ext      4.0          210.000                  2700.              880.                     0.82        0.72      19200.         0.00          10.8   grey cotd alum : Grey coated aluminium
    2   80.0            0.040                    12.              840.                     0.90        0.65         30.         2.00           1.0   glass fibre quilt : Glass Fibre Quilt (non-hygroscopic)
Int      4.0          210.000                  2700.              880.                     0.82        0.32      19200.         0.00          10.8   wt cotd alum : White coated aluminium
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.461  0.467  0.452 (partition)  0.442  
Weight per m^2 of this construction  22.56  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  0.46
 External surface admittance Y=  0.81  w=  3.41 decrement factor f=  0.94  phi=  0.31 surface factor f=  0.94  phi=  0.31
 Partition admittance Y=  0.70  w=  5.68 surface factor f=  1.00  phi=  0.32  
 
Total area of insul_mtl_p is      4.08  
 
 
### door
Details of opaque construction: door with an overall thickness of  0.025m.  
In category general constructions also shown in menus as: solid wood door 25mm  
solid wood oak door 25mm.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
    1   25.0            0.190                   700.             2390.                     0.90        0.65         12.         0.13          17.5   oak : Oak (radial cut)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  3.316  3.682  2.928 (partition)  2.554  
Weight per m^2 of this construction  17.50  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  3.21
 External surface admittance Y=  3.33  w=  0.61 decrement factor f=  0.61  phi=  0.40 surface factor f=  0.61  phi=  0.40
 Partition admittance Y=  1.21  w=  5.38 surface factor f=  0.99  phi=  0.56  
 
Total area of door is      1.90  
 
 
### int_doors
Details of opaque construction: int_doors with an overall thickness of  0.025m.  
In category general constructions also shown in menus as: internal wood door 25mm  
internal solid oak door 25mm.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
    1   25.0            0.190                   700.             2390.                     0.90        0.65         12.         0.13          17.5   oak : Oak (radial cut)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  3.316  3.682  2.928 (partition)  2.554  
Weight per m^2 of this construction  17.50  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  3.21
 External surface admittance Y=  3.33  w=  0.61 decrement factor f=  0.61  phi=  0.40 surface factor f=  0.61  phi=  0.40
 Partition admittance Y=  1.21  w=  5.38 surface factor f=  0.99  phi=  0.56  
 
Total area of int_doors is      1.92  
 
 
### trombe_mass
Details of opaque construction: trombe_mass linked to trombe_mas_a with an overall thickness of  0.500m.  
In category general constructions also shown in menus as: trombe_mass (white side in)  
trombe_mass  is a ...
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
Ext    250.0            1.400                  2100.              653.                     0.90        0.85         19.         0.18         525.0   solar_absorb concrete : Heavy mix concrete with dark surface for use in
Int    250.0            1.400                  2100.              653.                     0.90        0.21         19.         0.18         525.0   white ptd concrete : White painted heavy mix concrete
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.897  2.011  1.763 (partition)  1.620  
Weight per m^2 of this construction1050.00  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  1.86
 External surface admittance Y=  5.28  w=  1.22 decrement factor f=  0.45  phi=  1.77 surface factor f=  0.45  phi=  1.77
 Partition admittance Y=  5.61  w=  1.19 surface factor f=  0.41  phi=  1.99  
 
Total area of trombe_mass is     26.96  
 
 
### single_glz  
Details of transparent construction single_glz with SCF8477_10nb optics with an overall thickness of  0.006m.  
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
    1    6.0            0.760                  2710.              837.                     0.83        0.05      19200.         0.01          16.3   plate glass : Plate glass with placeholder single layer optics
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.621  6.762  4.589 (partition)  3.733  
Weight per m^2 of this construction  16.26  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  5.32
 External surface admittance Y=  5.33  w=  0.08 decrement factor f=  0.36  phi=  0.15 surface factor f=  0.36  phi=  0.15
 Partition admittance Y=  0.34  w=  5.85 surface factor f=  1.00  phi=  0.15  
 
 Clear float 84/77,    10mm, no blind: with id of: SCF8477_10nb
 with 1 layers [including air gaps] and visible trn: 0.84
 
: Direct transmission @deg
 
   0     40    55    70    80
   ----- ----- ----- ----- -----
   0.699 0.672 0.629 0.503 0.294
 
: Absorption @deg
 
 Layer 0     40    55    70    80
 ----- ----- ----- ----- ----- -----
    1    0.235  0.255  0.269  0.273  0.247
 
Total area of single_glz is     15.94  
 
 
### grnd_floor
Details of opaque construction: grnd_floor with an overall thickness of  0.975m.  
In category general constructions also shown in menus as: carpet conc floor hardcore-earth  
An uninsulated slab on grade foundation over hardcore and 600mm of earth with a built-up of
chipboard and carpet above.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
Ext    200.0            1.280                  1460.              879.                     0.90        0.85          5.         0.16         292.0   earth std : Common_earth
    2  200.0            1.280                  1460.              879.                     0.90        0.85          5.         0.16         292.0   earth std : Common_earth
    3  200.0            1.280                  1460.              879.                     0.90        0.85          5.         0.16         292.0   earth std : Common_earth
    4  150.0            0.520                  2050.              184.                     0.90        0.85          2.         0.29         307.5   gravel based : Gravel based (non-hygroscopic)
    5  150.0            1.400                  2100.              653.                     0.90        0.65         19.         0.11         315.0   heavy mix concrete : Heavy mix concrete
    6   50.0            0.000                     0.                0.                     0.99        0.99          1.         0.17           0.1   air  0.17 0.17 0.17
    7   19.0            0.150                   800.             2093.                     0.91        0.65         96.         0.13          15.2   chipboard : Chipboard
Int      6.0            0.060                   186.             1360.                     0.90        0.60         10.         0.10           1.1   Wilton : Wilton weave wool carpet (organic-hygroscopic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.699  0.714  0.680 (partition)  0.657  
Weight per m^2 of this construction1514.88  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  0.69
 External surface admittance Y=  2.16  w=  1.36 decrement factor f=  0.76  phi=  0.46 surface factor f=  0.76  phi=  0.46
 Partition admittance Y=  2.16  w=  1.36 surface factor f=  0.76  phi=  0.45  
 
Total area of grnd_floor is     16.00  
 
 
### gyp_blk_ptn
Details of opaque construction: gyp_blk_ptn with an overall thickness of  0.226m.  
In category general constructions also shown in menus as: plasterbd dabs 100mm concrete bl  
partition - plasterboard on dabs over 100mm concret block.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
Ext     13.0            0.190                   950.              840.                     0.91        0.22         11.         0.07          12.4   white gypboard : White painted Gypboard (inorganic-porous)
    2   50.0            0.000                     0.                0.                     0.99        0.99          1.         0.17           0.1   air  0.17 0.17 0.17
    3  100.0            0.510                  1400.             1000.                     0.90        0.65         10.         0.20         140.0   block inner : Block inner (3% mc)
    4   50.0            0.000                     0.                0.                     0.99        0.99          1.         0.17           0.1   air  0.17 0.17 0.17
Int     13.0            0.190                   950.              840.                     0.91        0.22         11.         0.07          12.4   white gypboard : White painted Gypboard (inorganic-porous)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.186  1.230  1.133 (partition)  1.072  
Weight per m^2 of this construction 164.82  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  1.17
 External surface admittance Y=  2.38  w=  1.44 decrement factor f=  0.74  phi=  0.54 surface factor f=  0.74  phi=  0.54
 Partition admittance Y=  2.59  w=  2.21 surface factor f=  0.76  phi=  0.86  
 
Total area of gyp_blk_ptn is     35.07  
 
 
### fictitious  
Details of transparent construction fictitious with SC_fictit optics with an overall thickness of  0.004m.  
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
    1    4.0           20.000                    10.               10.                     0.99        0.01      19200.         0.00           0.0   fict : fictitious material (almost not there) with matching single layer
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.875  7.133  4.757 (partition)  3.843  
Weight per m^2 of this construction   0.04  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  5.55
 External surface admittance Y=  5.55  w=  0.00 decrement factor f=  0.33  phi=  0.00 surface factor f=  0.33  phi=  0.00
 Partition admittance Y=  0.00  w=  6.00 surface factor f=  1.00  phi=  0.00  
 
 Fictitious 99/99,      4mm, no blind: with id of: SC_fictit
 with 1 layers [including air gaps] and visible trn: 0.99
 
: Direct transmission @deg
 
   0     40    55    70    80
   ----- ----- ----- ----- -----
   0.998 0.987 0.986 0.985 0.984
 
: Absorption @deg
 
 Layer 0     40    55    70    80
 ----- ----- ----- ----- ----- -----
    1    0.001  0.001  0.001  0.001  0.001
 
Total area of fictitious is      6.00  
 
 
### trombe_mas_a
Details of opaque construction: trombe_mas_a linked to trombe_mass with an overall thickness of  0.500m.  
In category general constructions also shown in menus as: trombe_mass (dark @inside face)  
trombe_mas_a is a ...
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Diffusivity  R (m^2^K/W)  kg/m^2^  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  -----------  -----------  -------  -----------------------------------
Ext    250.0            1.400                  2100.              653.                     0.90        0.21         19.         0.18         525.0   white ptd concrete : White painted heavy mix concrete
Int    250.0            1.400                  2100.              653.                     0.90        0.85         19.         0.18         525.0   solar_absorb concrete : Heavy mix concrete with dark surface for use in
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.897  2.011  1.763 (partition)  1.620  
Weight per m^2 of this construction1050.00  
 
Admittance calculations using Rsi   0.12 Rso   0.06 & Uvalue=  1.86
 External surface admittance Y=  5.28  w=  1.22 decrement factor f=  0.45  phi=  1.77 surface factor f=  0.45  phi=  1.77
 Partition admittance Y=  5.61  w=  1.19 surface factor f=  0.41  phi=  1.99  
 
Total area of trombe_mas_a is     10.96  
