# Synopsis
 
Synopsis of model Matrix of small offices with different P PI PD PID controls.
defined in office_ctl_pid.cfg generated on Sun Dec  4 09:15:03 2022.
Associated notes are in ../doc/office_ctl.log
 
Location latitude   59.65 longitude difference   2.90 (from local time
meridian (east +ve). Simulations year 2016 with Weekends occuring on Saturday
and Sunday.
Site exposure is typical city centre
 
Exterior surface heat transfer method:
MoWiTT  exterior hc method
 
Interior surface heat transfer method:
Alamdari and Hammond (default)
 
The Site exposure is typical city centre and the ground reflectance is 0.20.
 
Weather file: Sweden Stockholm Arlanda 1984 in SWE_Stockholm with hour-centred solar data.
Standard annual weather SWE_Stockholm                                                                                                               
Calculated ground temperature at depth                                                                                      
  0.5 m: -1.9593 -2.7908 -1.3161 0.99155 7.0276 11.686 14.827 15.784 14.154 10.538 5.7050 1.2207                                                                                                                                                                                                                                                                                                                                                                                                                
  1.0 m: -0.82306 -1.9623 -0.96745 0.92127 6.2288 10.560 13.684 14.934 13.835 10.818 6.5257 2.3488                                                                                                                                                                                                                                                                                                                                                                                                              
  1.5 m: 0.19756 -1.1522 -0.54409 0.98537 5.6254 9.6165 12.660 14.108 13.436 10.940 7.1505 3.2961                                                                                                                                                                                                                                                                                                                                                                                                               
  2.0 m: 1.1002 -0.38132 -0.0788431 1.1469 5.1858 8.8370 11.757 13.325 12.991 10.940 7.6103 4.0795                                                                                                                                                                                                                                                                                                                                                                                                              
  2.5 m: 1.8877 0.33652 0.40283 1.3754 4.8808 8.2029 10.972 12.599 12.525 10.852 7.9340 4.7176                                                                                                                                                                                                                                                                                                                                                                                                                  
  3.0 m: 2.5663 0.99338 0.88182 1.6461 4.6841 7.6954 10.298 11.936 12.060 10.700 8.1478 5.2292                                                                                                                                                                                                                                                                                                                                                                                                                  
  3.5 m: 3.1446 1.5857 1.3444 1.9395 4.5727 7.2957 9.7242 11.341 11.607 10.507 8.2746 5.6328                                                                                                                                                                                                                                                                                                                                                                                                                    
  4.0 m: 3.6327 2.1135 1.7812 2.2408 4.5269 6.9867 9.2417 10.811 11.179 10.290 8.3341 5.9455                                                                                                                                                                                                                                                                                                                                                                                                                    
  4.5 m: 4.0410 2.5788 2.1865 2.5389 4.5299 6.7525 8.8394 10.346 10.779 10.061 8.3431 6.1832                                                                                                                                                                                                                                                                                                                                                                                                                    
  5.0 m: 4.3798 2.9855 2.5573 2.8261 4.5680 6.5790 8.5066 9.9399 10.413 9.8300 8.3155 6.3598                                                                                                                                                                                                                                                                                                                                                                                                                    
  5.5 m: 4.6590 3.3385 2.8927 3.0971 4.6303 6.4541 8.2331 9.5883 10.081 9.6050 8.2623 6.4876                                                                                                                                                                                                                                                                                                                                                                                                                    
  6.0 m: 4.8878 3.6432 3.1932 3.3489 4.7078 6.3673 8.0098 9.2854 9.7825 9.3904 8.1925 6.5769                                                                                                                                                                                                                                                                                                                                                                                                                    
  6.5 m: 5.0746 3.9051 3.4605 3.5799 4.7940 6.3099 7.8283 9.0255 9.5167 9.1893 8.1131 6.6366                                                                                                                                                                                                                                                                                                                                                                                                                    
  7.0 m: 5.2266 4.1296 3.6970 3.7897 4.8838 6.2747 7.6810 8.8032 9.2811 9.0033 8.0291 6.6739                                                                                                                                                                                                                                                                                                                                                                                                                    
  7.5 m: 5.3503 4.3218 3.9054 3.9789 4.9734 6.2558 7.5618 8.6132 9.0732 8.8332 7.9444 6.6946                                                                                                                                                                                                                                                                                                                                                                                                                    
  8.0 m: 5.4509 4.4864 4.0886 4.1485 5.0603 6.2485 7.4651 8.4508 8.8902 8.6788 7.8616 6.7034                                                                                                                                                                                                                                                                                                                                                                                                                    
  8.5 m: 5.5333 4.6276 4.2495 4.3000 5.1428 6.2494 7.3864 8.3116 8.7293 8.5395 7.7827 6.7040                                                                                                                                                                                                                                                                                                                                                                                                                    
  9.0 m: 5.6010 4.7491 4.3908 4.4350 5.2200 6.2555 7.3219 8.1920 8.5878 8.4144 7.7086 6.6991                                                                                                                                                                                                                                                                                                                                                                                                                    
  9.5 m: 5.6572 4.8542 4.5151 4.5552 5.2914 6.2649 7.2686 8.0887 8.4633 8.3022 7.6399 6.6908                                                                                                                                                                                                                                                                                                                                                                                                                    
 10.0 m: 5.7044 4.9456 4.6248 4.6622 5.3568 6.2759 7.2240 7.9989 8.3533 8.2018 7.5768 6.6807                                                                                                                                                                                                                                                                                                                                                                                                                    
 
 
## Integrated Performance View  
An Integrated Performance View has been defined  
Title Matrix of small offices with different h  
synopsis
:The heat_transfer
Images    0  
 
Simulations to be undertaken  
 
name    simulations                days  descripion
------  -------------------------  ----  ----------
1st win  Sat-09-Jan to Fri-15-Jan   7     1st winter week run
spring   Sun-06-Mar to Sat-12-Mar   7     spring week run
summer   Mon-11-Jul to Sun-17-Jul   7     summer week run
autumn   Sun-02-Oct to Sat-08-Oct   7     autumn week run
2nd win  Sun-20-Nov to Sat-26-Nov   7     2nd winter week run
 
display day Sun-10-Jan.
display day Mon-07-Mar.
display day Tue-12-Jul.
display day Mon-03-Oct.
display day Mon-21-Nov.
 
Seasons (as found in climatelist)  
 
         winter  spring  summer  autumn  winter
-------  ------- ------  ------  ------  ------
  start  01-Jan  19-Mar  07-May  13-Aug  19-Nov
  finish 18-Mar  06-May  12-Aug  18-Nov  31-Dec
  days     77       49      98      98      43
 
Ratios for:   winter  spring summer autumn winter
------------  ------- ------ ------ ------ -------
 heating         1.00   1.00   1.00   1.00   1.00
 cooling         1.00   1.00   1.00   1.00   1.00
 lighting        1.00   1.00   1.00   1.00   1.00
 small power     1.00   1.00   1.00   1.00   1.00
 fans&pumps      1.00   1.00   1.00   1.00   1.00
 DHW             1.00   1.00   1.00   1.00   1.00
 
ID  Metric                zones  area    scale weight type      name          zones
--  --------------------  -----  ------  ----- ------ --------- ------------  ------------------------
 1  Resultant T (degC)       0     1.00   1.00   1.00  zones     ocup_zones
 
 
ID Name          Zones  Area     Scale   Notes
-- ------------  ------ -------  ------  --------
 1 zones              0    1.00   1.000
 
 
## Databases
: Databases associated with the model
 
-------------------------  --------------------
standard pressure distr    pressc.db1
standard materials         material.db
constructions              ../dbs/office_ctl.constrdb
standard plant comp        plantc.db1
standard event profiles    profiles.db2.a
standard optical prop      optics.db
standard UK NCM data       SBEM.db1
standard predefined obj    predefined.db1
standard mould isopleth    mould.db1
-------------------------  --------------------
 
## Controls
 
The model includes ideal controls -
a mix of ideal controls room_bc is ideal pure covective room_pi uses P+D controller with 2m D. Looser DB for P+D & P.
Master control switched to Prop control and dbT sensing. Prop+D given more capacity. Prop+D with 4deg range. 3pos
longer reaction time
 
Zones control includes 18 functions.  
 
The following day types are defined weekdays    saturday    sunday      holiday  
 
Details of control loops referenced in the model  
 loop: convective  
 
The sensor for function  1 senses a mix of dry bulb 50% and MRT in the current zone.  
The actuator for function  1 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   6.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 20.00C cooling setpoint 24.00C.  
  3  18.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   7.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 20.00C cooling setpoint 24.00C.  
  3  14.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 loop: proportional  
 
The sensor for function  2 senses dry bulb temperature in room_prop+I.  
The actuator for function  2 is the air point in room_prop+I.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 30.0s.  
  2   6.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 24.00C throttling range 4.00C integral action time 30.0s.  
  3  18.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 30.0s.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s.  
  2   7.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 24.00C throttling range 4.00C integral action time 60.0s.  
  3  14.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s.  
 loop: floor_heating  
 
The sensor for function  3 senses the temperature of the current zone.  
The actuator for function  3 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
  2   6.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 20.0 24.0  
  3  18.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
  2   7.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 20.0 24.0  
  3  14.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       Ideal multi-sensor: max heat cp 3000.W min heat cp 0.W max cool cp 3000.W min heat cp 0.W Heat stpt 35.0C cool stpt 100.0C Aux:senses dry bulb T in floor_heat. h/c 15.0 26.0  
 loop: separateONOFF  
 
The sensor for function  4 senses a mix of dry bulb 50% and MRT in the current zone.  
The actuator for function  4 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
  2   6.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 19.00C heating off above 20.00C cooling on above 25.00C cooling off below 24.00C.  
  3  18.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
  2   7.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 19.00C heating off above 20.00C cooling on above 25.00C cooling off below 24.00C.  
  3  14.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       separate ON/OFF flux: heating capacity 1400.00W cooling capacity 1400.00W heating on below 15.00C heating off above 16.00C cooling on above 26.00C cooling off below 25.00C.  
 loop: dummy_floor_heating  
 
The sensor for function  5 senses a mix of dry bulb 50% and MRT in the current zone.  
The actuator for function  5 is the air point in floor_heat.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   6.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 20.00C cooling setpoint 24.00C.  
  3  18.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   7.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 20.00C cooling setpoint 24.00C.  
  3  14.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 20.0W. cooling capacity 20.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 loop: match mid to low void  
 
The sensor for function  6 senses dry bulb temperature in void_low.  
The actuator for function  6 is the air point in void_low.  
 >  1 periods of validity during the year have been defined.
 
Control is valid Fri-01-Jan to Sat-31-Dec, 2016 with  1 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       match temperature (ideal): max heat cp 2000.W min heat cp 0.W max cool cp 2000.W min heat cp 0.W Aux sensors 1. mean value @senses dry bulb T in mid_void. scale 1.00 offset 0.00  
 loop: match mid to high void  
 
The sensor for function  7 senses dry bulb temperature in upper_void.  
The actuator for function  7 is the air point in upper_void.  
 >  1 periods of validity during the year have been defined.
 
Control is valid Fri-01-Jan to Sat-31-Dec, 2016 with  1 periods.
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       match temperature (ideal): max heat cp 2000.W min heat cp 0.W max cool cp 2000.W min heat cp 0.W Aux sensors 1. mean value @senses dry bulb T in mid_void. scale 1.00 offset 0.00  
 loop: VAV_CV  
 
The sensor for function  9 senses the temperature of the current zone.  
The actuator for function  9 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   6.00  db temp   > flux       VAV and CAV air based: reheat cap 1400.00W air supply temp 11.000C room setpoint 20.000C max air flow rate 0.1660m^3/s min air flow rate 0.0560m^3/s  
  3  18.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
  2   7.00  db temp   > flux       VAV and CAV air based: reheat cap 1400.00W air supply temp 11.000C room setpoint 20.000C max air flow rate 0.1660m^3/s min air flow rate 0.0560m^3/s  
  3  14.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       basic control: heating capacity 1400.0W. cooling capacity 1400.0W. heating setpoint 15.00C cooling setpoint 26.00C.  
 loop: master_p  
 
The sensor for function 10 senses dry bulb temperature in room_master.  
The actuator for function 10 is the air point in room_master.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
  2   6.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 20.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 24.00C throttling range 3.00C.  
  3  18.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
  2   7.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 20.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 24.00C throttling range 3.00C.  
  3  14.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 loop: slave_one  
 
The sensor for function 11 senses dry bulb temperature in room_master.  
The actuator for function 11 is the air point in room_slave1.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       master/slave control: index of master control loop10 slave max heating capacity 1000.00 slave max cooling capacity 1000.00.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       master/slave control: index of master control loop10 slave max heating capacity 1000.00 slave max cooling capacity 1000.00.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       master/slave control: index of master control loop10 slave max heating capacity 1000.00 slave max cooling capacity 1000.00.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       master/slave control: index of master control loop10 slave max heating capacity 1000.00 slave max cooling capacity 1000.00.  
 loop: time_prop_ONOFF  
 
The sensor for function 13 senses the temperature of the current zone.  
The actuator for function 13 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
  2   6.00  db temp   > flux       time proportioning ON/OFF: heat cap 1400.00W cool cap 1400.00W heat ON 19.00C heat OFF 20.00C cool ON 25.00C cool OFF 24.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
  3  18.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
  2   7.00  db temp   > flux       time proportioning ON/OFF: heat cap 1400.00W cool cap 1400.00W heat ON 19.00C heat OFF 20.00C cool ON 25.00C cool OFF 24.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
  3  14.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       time proportioning ON/OFF: heat cap 1000.00W cool cap 1000.00W heat ON 15.00C heat OFF 16.00C cool ON 26.00C cool OFF 25.00C tot heat 10.mn min heat ON 5.mn min heat OFF 5.mn tot cool mnts10. min cool ON 5.mn min cool OFF 5.mn.  
 loop: threepos  
 
The sensor for function 15 senses the temperature of the current zone.  
The actuator for function 15 is air point of the current zone  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 1.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1000.0W min ht cap 0.0W ROC ht 5.ts max cl cap 1000.0W min cl cap 0.0W ROC cl 5.ts.  
  2   6.00  db temp   > flux       floating 3-pos: heat sp 20.00C ht dbd 2.00C ht shut df 1.00C ht open df 1.00C cool sp 24.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1400.0W min ht cap 0.0W ROC ht 5.ts max cl cap 1400.0W min cl cap 0.0W ROC cl 5.ts.  
  3  18.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 1.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1000.0W min ht cap 0.0W ROC ht 5.ts max cl cap 1000.0W min cl cap 0.0W ROC cl 5.ts.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 2.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1000.0W min ht cap 0.0W ROC ht10.ts max cl cap 1000.0W min cl cap 0.0W ROC cl10.ts.  
  2   7.00  db temp   > flux       floating 3-pos: heat sp 20.00C ht dbd 2.00C ht shut df 1.00C ht open df 2.00C cool sp 24.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1400.0W min ht cap 0.0W ROC ht10.ts max cl cap 1400.0W min cl cap 0.0W ROC cl10.ts.  
  3  14.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 2.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1000.0W min ht cap 0.0W ROC ht10.ts max cl cap 1000.0W min cl cap 0.0W ROC cl10.ts.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 2.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1400.0W min ht cap 0.0W ROC ht 5.ts max cl cap 1400.0W min cl cap 0.0W ROC cl 5.ts.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       floating 3-pos: heat sp 16.00C ht dbd 2.00C ht shut df 1.00C ht open df 2.00C cool sp 26.00C cl dbd 2.00C cl open df 1.00C cl shut df 1.00C max ht cap 1400.0W min ht cap 0.0W ROC ht 5.ts max cl cap 1400.0W min cl cap 0.0W ROC cl 5.ts.  
 loop: prop_no_I  
 
The sensor for function 16 senses dry bulb temperature in room_p.  
The actuator for function 16 is the air point in room_p.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
  2   6.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 20.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 24.00C throttling range 3.00C.  
  3  18.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
  2   7.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 20.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 24.00C throttling range 3.00C.  
  3  14.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional: max heating 1400.0W min heating 0.0W heating spt 15.00C throttling range 3.00C. Max cooling 1400.0C min cooling 0.0W cooling spt 26.00C throttling range 3.00C.  
 loop: prop+D  
 
The sensor for function 17 senses dry bulb temperature in room_prop+D.  
The actuator for function 17 is the air point in room_prop+D.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
  2   6.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 24.00C throttling range 4.00C derivative action time 60.0s.  
  3  18.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
  2   7.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 24.00C throttling range 4.00C derivative action time 60.0s.  
  3  14.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0 W cool spt 26.00C throttling range 4.00C derivative action time 60.0s.  
 loop: Prop+P+I+D  
 
The sensor for function 18 senses dry bulb temperature in room_pid.  
The actuator for function 18 is the air point in room_pid.  
 
Per  Start  Sensing   Actuating   weekdays control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
  2   6.00  db temp   > flux       proportional+I+D: max heat 1400.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1400.0W min cool 0.0W cool spt 24.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
  3  18.00  db temp   > flux       proportional+I+D: max heat 1900.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   saturday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I+D: max heat 1900.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
  2   7.00  db temp   > flux       proportional+I+D: max heat 1900.0W min heat 0.0W heat spt 20.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 24.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
  3  14.00  db temp   > flux       proportional+I+D: max heat 1900.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   sunday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I+D: max heat 1900.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
 
Per  Start  Sensing   Actuating   holiday control laws
---  -----  -------   ---------   -------------------------------------------
  1   0.00  db temp   > flux       proportional+I+D: max heat 1400.0W min heat 0.0W heat spt 15.00C throttling range 4.00C. Max cool 1900.0W min cool 0.0W cool spt 26.00C throttling range 4.00C integral action time 60.0s derivative action time 60.0s.  
 
Zone to contol loop linkages  
 zone ( 1) room_bc      << control  1 convective  
 zone ( 2) room_prop+I  << control  2 proportional  
 zone ( 3) room_p       << control 16 prop_no_I  
 zone ( 4) room_3pos    << control 15 threepos  
 zone ( 5) room_pid     << control 18 Prop+P+I+D  
 zone ( 6) room_prop+D  << control 17 prop+D  
 zone ( 7) corid_conv   << control  1 convective  
 zone ( 8) void_low     << control  6 match mid to low void  
 zone ( 9) room_master  << control 10 master_p  
 zone (10) room_slave1  << control 11 slave_one  
 zone (11) room_onoffsh << control  4 separateONOFF  
 zone (12) floor_heat   << control  5 dummy_floor_heating  
 zone (13) room_vave    << control  9 VAV_CV  
 zone (14) room_tprop   << control 13 time_prop_ONOFF  
 zone (15) corid_rad    << control  1 convective  
 zone (16) mid_void     << control  0 no control imposed  
 zone (17) thin_floor   << control  3 floor_heating  
 zone (18) upper_void   << control  7 match mid to high void  
 
 
## Flow network description
The model includes a mass flow network.
The details are shown below.  
 
  51 nodes,  44 components,  44 connections;     wind reduction =  0.600
 
: Network summary
 
   # Node        Fluid   Node Type            X       Y       Z       Temperature Data_1  Data_2
 --- ----------- -----  -------------------   ------  ------  ------  ----------- ------  ------ ---- -------
   1 room_bc_conv air   internal & unknown     1.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   2 room_prop    air   internal & unknown     4.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   3 CAV_mixed    air   internal & unknown     7.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   4 VAV_mix_CVh  air   internal & unknown    10.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   5 VAV_mix_VVh  air   internal & unknown    13.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   6 room_prop+D  air   internal & unknown    16.500   2.250   1.500   20.000     (-)     1.000  vol   40.312
   7 corid_conv   air   internal & unknown     9.000   5.250   1.500   20.000     (-)     1.000  vol   81.002
   8 void_low     air   internal & unknown     9.000   3.000  -0.200   20.000     (-)     1.000  vol   43.201
   9 room_bc_rad  air   internal & unknown     1.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  10 rad_at_fac   air   internal & unknown     4.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  11 rad_at_wall  air   internal & unknown     7.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  12 floor_heat   air   internal & unknown    10.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  13 user_hc      air   internal & unknown    13.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  14 warm_wall    air   internal & unknown    16.500   2.250   4.900   20.000     (-)     1.000  vol   40.312
  15 corid_rad    air   internal & unknown     9.000   5.250   4.900   20.000     (-)     1.000  vol   81.002
  16 mid_void     air   internal & unknown     9.000   3.000   3.200   20.000     (-)     1.000  vol   40.501
  17 thin_floor   air   internal & unknown    10.500   2.250   3.300   20.000     (-)     1.000  vol    2.700
  18 upper_void   air   internal & unknown     9.000   3.000   6.600   20.000     (-)     1.000  vol   43.201
  19 ambient      air   boundary & wind ind   -1.000  -1.000   1.000   0.0000     coef    1.000  azim 180.000
  20 BW-Ve01:008  air   boundary & wind ind    1.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  21 BW-Cr01:009  air   boundary & wind ind    1.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  22 BW-Ve02:008  air   boundary & wind ind    4.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  23 BW-Cr02:009  air   boundary & wind ind    4.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  24 BW-Ve03:008  air   boundary & wind ind    7.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  25 BW-Cr03:009  air   boundary & wind ind    7.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  26 BW-Ve04:008  air   boundary & wind ind   10.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  27 BW-Cr04:009  air   boundary & wind ind   10.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  28 BW-Ve05:008  air   boundary & wind ind   13.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  29 BW-Cr05:009  air   boundary & wind ind   13.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  30 BW-Ve06:008  air   boundary & wind ind   16.210  -0.900   3.000   0.0000     coef    1.000  azim 180.000
  31 BW-Cr06:009  air   boundary & wind ind   16.500  -0.900   1.950   0.0000     coef    1.000  azim 180.000
  32 BW-Uc07:037  air   boundary & wind ind   -0.900   5.250   0.000   0.0000     coef    1.000  azim 270.000
  33 BW-Uc07:038  air   boundary & wind ind   18.900   5.250   0.000   0.0000     coef    1.000  azim  90.000
  34 BW-Uc08:014  air   boundary & wind ind   18.900   3.500  -0.400   0.0000     coef    1.000  azim  90.000
  35 BW-Ve09:008  air   boundary & wind ind    1.210  -0.900   6.400   0.0000     coef    1.000  azim 180.000
  36 BW-Cr09:009  air   boundary & wind ind    1.500  -0.900   5.350   0.0000     coef    1.000  azim 180.000
  37 BW-Ve10:008  air   boundary & wind ind    4.210  -0.900   6.400   0.0000     coef    1.000  azim 180.000
  38 BW-Cr10:009  air   boundary & wind ind    4.500  -0.900   5.350   0.0000     coef    1.000  azim 180.000
  39 BW-Ve11:008  air   boundary & wind ind    7.210  -0.900   6.400   0.0000     coef    1.000  azim 180.000
  40 BW-Cr11:009  air   boundary & wind ind    7.500  -0.900   5.350   0.0000     coef    1.000  azim 180.000
  41 BW-Ve12:008  air   boundary & wind ind   10.210  -0.900   6.400   0.0000     coef    1.000  azim 180.000
  42 BW-Cr12:009  air   boundary & wind ind   10.500  -0.900   5.350   0.0000     coef    1.000  azim 180.000
  43 BW-Ve13:008  air   boundary & wind ind   13.210  -0.900   6.400   0.0000     coef    1.000  azim 180.000
  44 BW-Cr13:009  air   boundary & wind ind   13.500  -0.900   5.350   0.0000     coef    1.000  azim 180.000
  45 BW-Uc15:037  air   boundary & wind ind   -0.900   5.250   3.400   0.0000     coef    1.000  azim 270.000
  46 BW-Uc15:038  air   boundary & wind ind   18.900   5.250   3.400   0.0000     coef    1.000  azim  90.000
  47 BW-Uc16:025  air   boundary & wind ind   18.900   3.500   3.000   0.0000     coef    1.000  azim  90.000
  48 BW-Uc18:014  air   boundary & wind ind   18.900   3.300   6.400   0.0000     coef    1.000  azim  90.000
  49 BF-Cr08:013  air   boundary & wind ind   -0.900   3.500  -0.200   0.0000     coef    1.000  azim 270.000
  50 BF-Cr16:024  air   boundary & wind ind   -0.900   3.500   3.200   0.0000     coef    1.000  azim 270.000
  51 BF-Cr18:015  air   boundary & wind ind   -0.900   3.300   6.560   0.0000     coef    1.000  azim 270.000
 
: Components (C+ = atributes L+ connection atributes):
 
Component     Type Fluid C+ L+ Associated with            @X     @Y    @Z  Description
------------- ---- ----- -- -- ------------------------- ----- ----- ----- -------------------------------
 DoUcz01:003    40 air    3  0 room_bc_conv:bc_door        0.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez01:008    40 air    3  0 room_bc_conv:frame          1.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz01:009   120 air    3  0 room_bc_conv:glazing        1.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz02:003    40 air    3  0 room_fan:fc_door            3.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez02:008    40 air    3  0 room_fan:frame              4.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz02:009   120 air    3  0 room_fan:glazing            4.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz03:003    40 air    3  0 CAV_mixed:cav_door          6.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez03:008    40 air    3  0 CAV_mixed:frame             7.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz03:009   120 air    3  0 CAV_mixed:glazing           7.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz04:003    40 air    3  0 VAV_mix_CVh:vavc_door       9.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez04:008    40 air    3  0 VAV_mix_CVh:frame          10.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz04:009   120 air    3  0 VAV_mix_CVh:glazing        10.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz05:003    40 air    3  0 VAV_mix_VVh:vavv_door      12.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez05:008    40 air    3  0 VAV_mix_VVh:frame          13.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz05:009   120 air    3  0 VAV_mix_VVh:glazing        13.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz06:003    40 air    3  0 CEN_hc:cen_door            15.8   4.5   0.0 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez06:008    40 air    3  0 CEN_hc:frame               16.2   0.0   3.0 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz06:009   120 air    3  0 CEN_hc:glazing             16.5   0.0   2.0 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz07:037    40 air    3  0 corid_conv:left             0.0   5.2   0.0 Common orifice flow
 With opening area (m^2)  0.022 discharge factor (-) 0.700
 DoUcz07:038    40 air    3  0 corid_conv:right           18.0   5.2   0.0 Common orifice flow
 With opening area (m^2)  0.022 discharge factor (-) 0.700
 DoUcz08:014    40 air    3  0 void_low:right             18.0   3.5  -0.4 Common orifice flow
 With opening area (m^2)  0.090 discharge factor (-) 0.700
 DoUcz09:003    40 air    3  0 room_bc_rad:bcr_door        0.8   4.5   3.4 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez09:008    40 air    3  0 room_bc_rad:frame           1.2   0.0   6.4 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz09:009   120 air    3  0 room_bc_rad:glazing         1.5   0.0   5.3 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz10:003    40 air    3  0 rad_at_fac:radf_door        3.8   4.5   3.4 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez10:008    40 air    3  0 rad_at_fac:frame            4.2   0.0   6.4 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz10:009   120 air    3  0 rad_at_fac:glazing          4.5   0.0   5.3 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz11:003    40 air    3  0 rad_at_wall:radw_door       6.8   4.5   3.4 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez11:008    40 air    3  0 rad_at_wall:frame           7.2   0.0   6.4 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz11:009   120 air    3  0 rad_at_wall:glazing         7.5   0.0   5.3 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz12:003    40 air    3  0 floor_heat:flrh_door        9.8   4.5   3.4 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez12:008    40 air    3  0 floor_heat:frame           10.2   0.0   6.4 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz12:009   120 air    3  0 floor_heat:glazing         10.5   0.0   5.3 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz13:003    40 air    3  0 user_hc:user_door          12.8   4.5   3.4 Common orifice flow
 With opening area (m^2)  0.012 discharge factor (-) 0.700
 FrVez13:008    40 air    3  0 user_hc:frame              13.2   0.0   6.4 Common orifice flow
 With opening area (m^2)  0.010 discharge factor (-) 0.340
 WiCrz13:009   120 air    3  0 user_hc:glazing            13.5   0.0   5.3 Specific air flow crack
 With crack width(m)  0.0020 crack length(m)  9.400
 DoUcz15:037    40 air    3  0 corid_rad:left              0.0   5.2   3.4 Common orifice flow
 With opening area (m^2)  0.022 discharge factor (-) 0.700
 DoUcz15:038    40 air    3  0 corid_rad:right            18.0   5.2   3.4 Common orifice flow
 With opening area (m^2)  0.022 discharge factor (-) 0.700
 DoUcz16:025    40 air    3  0 mid_void:right             18.0   3.5   3.0 Common orifice flow
 With opening area (m^2)  0.090 discharge factor (-) 0.700
 DoUcz16:029    40 air    3  0 mid_void:thin_back         10.3   4.5   3.2 Common orifice flow
 With opening area (m^2)  0.045 discharge factor (-) 0.700
 DoUcz18:014    40 air    3  0 upper_void:right           18.0   3.3   6.4 Common orifice flow
 With opening area (m^2)  0.090 discharge factor (-) 0.700
 FrCrz08:013   120 air    3  0 void_low:left               0.0   3.5  -0.2 Specific air flow crack
 With crack width(m)  0.0020 crack length(m) 12.800
 FrCrz16:024   120 air    3  0 mid_void:left               0.0   3.5   3.2 Specific air flow crack
 With crack width(m)  0.0020 crack length(m) 12.800
 FrCrz18:015   120 air    3  0 upper_void:left             0.0   3.3   6.6 Specific air flow crack
 With crack width(m)  0.0020 crack length(m) 12.800
 
 
: Connection summary
 
   # +Node         dHght   -Node         dHght   Component       Z @+    Z @-
 --- ------------ -------  -----------  -------  ------------   ------  ------
    1 room_bc_conv -1.500   corid_conv   -1.500   DoUcz01:003     0.000   0.000
    2 BW-Ve01:008   0.000   room_bc_conv  1.500   FrVez01:008     3.000   3.000
    3 BW-Cr01:009   0.000   room_bc_conv  0.450   WiCrz01:009     1.950   1.950
    4 room_prop    -1.500   corid_conv   -1.500   DoUcz02:003     0.000   0.000
    5 BW-Ve02:008   0.000   room_prop     1.500   FrVez02:008     3.000   3.000
    6 BW-Cr02:009   0.000   room_prop     0.450   WiCrz02:009     1.950   1.950
    7 CAV_mixed    -1.500   corid_conv   -1.500   DoUcz03:003     0.000   0.000
    8 BW-Ve03:008   0.000   CAV_mixed     1.500   FrVez03:008     3.000   3.000
    9 BW-Cr03:009   0.000   CAV_mixed     0.450   WiCrz03:009     1.950   1.950
   10 VAV_mix_CVh  -1.500   corid_conv   -1.500   DoUcz04:003     0.000   0.000
   11 BW-Ve04:008   0.000   VAV_mix_CVh   1.500   FrVez04:008     3.000   3.000
   12 BW-Cr04:009   0.000   VAV_mix_CVh   0.450   WiCrz04:009     1.950   1.950
   13 VAV_mix_VVh  -1.500   corid_conv   -1.500   DoUcz05:003     0.000   0.000
   14 BW-Ve05:008   0.000   VAV_mix_VVh   1.500   FrVez05:008     3.000   3.000
   15 BW-Cr05:009   0.000   VAV_mix_VVh   0.450   WiCrz05:009     1.950   1.950
   16 room_prop+D  -1.500   corid_conv   -1.500   DoUcz06:003     0.000   0.000
   17 BW-Ve06:008   0.000   room_prop+D   1.500   FrVez06:008     3.000   3.000
   18 BW-Cr06:009   0.000   room_prop+D   0.450   WiCrz06:009     1.950   1.950
   19 BW-Uc07:037   0.000   corid_conv   -1.500   DoUcz07:037     0.000   0.000
   20 BW-Uc07:038   0.000   corid_conv   -1.500   DoUcz07:038     0.000   0.000
   21 BW-Uc08:014   0.000   void_low     -0.200   DoUcz08:014    -0.400  -0.400
   22 room_bc_rad  -1.500   corid_rad    -1.500   DoUcz09:003     3.400   3.400
   23 BW-Ve09:008   0.000   room_bc_rad   1.500   FrVez09:008     6.400   6.400
   24 BW-Cr09:009   0.000   room_bc_rad   0.450   WiCrz09:009     5.350   5.350
   25 rad_at_fac   -1.500   corid_rad    -1.500   DoUcz10:003     3.400   3.400
   26 BW-Ve10:008   0.000   rad_at_fac    1.500   FrVez10:008     6.400   6.400
   27 BW-Cr10:009   0.000   rad_at_fac    0.450   WiCrz10:009     5.350   5.350
   28 rad_at_wall  -1.500   corid_rad    -1.500   DoUcz11:003     3.400   3.400
   29 BW-Ve11:008   0.000   rad_at_wall   1.500   FrVez11:008     6.400   6.400
   30 BW-Cr11:009   0.000   rad_at_wall   0.450   WiCrz11:009     5.350   5.350
   31 floor_heat   -1.500   corid_rad    -1.500   DoUcz12:003     3.400   3.400
   32 BW-Ve12:008   0.000   floor_heat    1.500   FrVez12:008     6.400   6.400
   33 BW-Cr12:009   0.000   floor_heat    0.450   WiCrz12:009     5.350   5.350
   34 user_hc      -1.500   corid_rad    -1.500   DoUcz13:003     3.400   3.400
   35 BW-Ve13:008   0.000   user_hc       1.500   FrVez13:008     6.400   6.400
   36 BW-Cr13:009   0.000   user_hc       0.450   WiCrz13:009     5.350   5.350
   37 BW-Uc15:037   0.000   corid_rad    -1.500   DoUcz15:037     3.400   3.400
   38 BW-Uc15:038   0.000   corid_rad    -1.500   DoUcz15:038     3.400   3.400
   39 BW-Uc16:025   0.000   mid_void     -0.200   DoUcz16:025     3.000   3.000
   40 mid_void      0.000   thin_floor   -0.100   DoUcz16:029     3.200   3.200
   41 BW-Uc18:014   0.000   upper_void   -0.200   DoUcz18:014     6.400   6.400
   42 BF-Cr08:013   0.000   void_low      0.000   FrCrz08:013    -0.200  -0.200
   43 BF-Cr16:024   0.000   mid_void     -0.000   FrCrz16:024     3.200   3.200
   44 BF-Cr18:015   0.000   upper_void   -0.040   FrCrz18:015     6.560   6.560
 
: Thermal zone -> flow node mapping:
 
zone        to  node
----------- --- -----------------
room_bc      -> room_bc_conv  
room_prop+I  -> room_prop  
room_p       -> CAV_mixed  
room_3pos    -> VAV_mix_CVh  
room_pid     -> VAV_mix_VVh  
room_prop+D  -> room_prop+D  
corid_conv   -> corid_conv  
void_low     -> void_low  
room_master  -> room_bc_rad  
room_slave1  -> rad_at_fac  
room_onoffsh -> rad_at_wall  
floor_heat   -> floor_heat  
room_vave    -> user_hc  
room_tprop   -> warm_wall  
corid_rad    -> corid_rad  
mid_void     -> mid_void  
thin_floor   -> thin_floor  
upper_void   -> upper_void  
 
 
## Zones
 
: Zone summary
 
ID  Zone name     Volume (m^3^)  Floor (m^2^)  Description
--  ------------  -------------  ------------  -------------------------------------------
 1  room_bc         40.3             13.5      manager describes cellular office on left (base case)
 2  room_prop+I     40.3             13.5      room_prop+I is a small office with a P+I Controller
 3  room_p          40.3             13.5      A small office with ideal proportional (No I or D) controller.
 4  room_3pos       40.3             13.5      Small office ideal threed position controler
 5  room_pid        40.3             13.5      Small office with ideal pid controller.
 6  room_prop+D     40.3             13.5      A small office with Prop+D controller for convective regime.
 7  corid_conv      81.0             27.0      corid_conv is passage adjacet to convective heating rooms
 8  void_low        43.2            108.0      void_low describes lower boundary ceiling void
 9  room_master     40.3             13.5      room_master is office with master controler
10  room_slave1     40.3             13.5      small office slaved to room_master
11  room_onoffsh    40.3             13.5      small office with ON OFF controller for short timesteps
12  floor_heat      40.3             13.5      floor_heat office with thin zone floor heating
13  room_vave       40.3             13.5      small office with ideal VAV with terminal reheat.
14  room_tprop      40.3             13.5      small office with a time-proportioning ONOFF control
15  corid_rad       81.0             27.0      corid_rad describes corridor adjacent to radiator rooms
16  mid_void        41.9            108.0      mid_void is the ceiling void between convective and radiant
17  thin_floor       1.4             13.5      thin_floor a thin zone for floor heat injection
18  upper_void      43.2            108.0      upper_void describes ceiling void over radiator rooms
 -  all            775.            553.5             -
 
### Zone 1: room_bc
 
Zone room_bc ( 1) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
manager describes cellular office on left (base case).  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 56.168 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_bc( 1)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_prop+I
  2  0.920        360.        0.       bc_corid_fra  -            sash_fr92mm                 bc_corid_fra:corid_conv
  3  2.32           0.        0.       bc_door       DOOR         door                        bc_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 identical environment
  5  13.5           0.       90.       ceiling_bc    -            ceiling                     ceiling_bc:mid_void
  6  13.5           0.      -90.       floor_bc      -            slate_over_struc room>voi   floor_bc:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       bc_part_glaz  -            dbl_glz                     bc_part_glaz:corid_conv
 11  1.28         360.        0.       bc_ptn_corid  -            gyp_gyp_ptn                 bc_ptn_corid:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_bc
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_bc
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_bc
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_bc
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_bc
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_bc
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_bc
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_bc
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_bc
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_bc
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_bc
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_bc
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_bc
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_bc
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_bc
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_bc
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_bc
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_bc
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_bc
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_bc
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_bc
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_bc
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
bc_door         0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     14.8      0.0       0.0      13.5
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    -0.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    -0.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    -0.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    -0.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    -0.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    -0.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_bc and typcial ceiling ceiling_bc.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: room_bc_conv
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupants  people     W      0- 8       0.0      0.0       0.60       0.40
weekdays    2  Occupants  people     W      8- 9      30.0     15.0       0.60       0.40
weekdays    3  Occupants  people     W      9-12     100.0     50.0       0.60       0.40
weekdays    4  Occupants  people     W     12-13      60.0     30.0       0.60       0.40
weekdays    5  Occupants  people     W     13-16     100.0     50.0       0.60       0.40
weekdays    6  Occupants  people     W     16-18      80.0     40.0       0.60       0.40
weekdays    7  Occupants  people     W     18-24       0.0      0.0       0.60       0.40
weekdays    8  Lights     lighting   Wm2    0- 8       0.0      0.0       0.30       0.70
weekdays    9  Lights     lighting   Wm2    8-12       7.0     11.6       0.30       0.70
weekdays   10  Lights     lighting   Wm2   12-14       5.0      0.0       0.30       0.70
weekdays   11  Lights     lighting   Wm2   14-18       7.0      0.0       0.30       0.70
weekdays   12  Lights     lighting   Wm2   18-24       1.0      0.0       0.30       0.70
weekdays   13  SmallPower equipment  Wm2    0- 7       2.0      0.0       0.40       0.60
weekdays   14  SmallPower equipment  Wm2    7-17      11.7      0.0       0.40       0.60
weekdays   15  SmallPower equipment  Wm2   17-24       3.0      0.0       0.40       0.60
saturday    1  Occupants  people     W      0- 8       0.0      0.0       0.60       0.40
saturday    2  Occupants  people     W      8- 9      30.0     15.0       0.60       0.40
saturday    3  Occupants  people     W      9-12     100.0     50.0       0.60       0.40
saturday    4  Occupants  people     W     12-24       0.0      0.0       0.60       0.40
saturday    5  Lights     lighting   Wm2    0- 8       0.0      0.0       0.30       0.70
saturday    6  Lights     lighting   Wm2    8-12       7.0      0.0       0.30       0.70
saturday    7  Lights     lighting   Wm2   12-24       5.0      0.0       0.30       0.70
saturday    8  SmallPower equipment  Wm2    0- 7       2.0      0.0       0.40       0.60
saturday    9  SmallPower equipment  Wm2    7-14      11.7      0.0       0.40       0.60
saturday   10  SmallPower equipment  Wm2   14-24       2.0      0.0       0.40       0.60
sunday      1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
sunday      2  Lights     lighting   Wm2    0-24       1.0      0.0       0.30       0.70
sunday      3  SmallPower equipment  Wm2    0-24       2.0      0.0       0.40       0.60
holiday     1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
holiday     2  Lights     lighting   Wm2    0-24       1.0      0.0       0.30       0.70
holiday     3  SmallPower equipment  Wm2    0-24       2.0      0.0       0.40       0.60
 
### Zone 2: room_prop+I
 
Zone room_prop+I ( 2) is composed of 39 surfaces and 77 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
room_prop+I is a small office with a P+I Controller.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_prop+I( 2)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_p
  2  0.920        360.        0.       fc_corid_fra  -            sash_fr92mm                 fc_corid_fra:corid_conv
  3  2.32           0.        0.       fc_door       DOOR         door                        fc_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_bc
  5  13.5           0.       90.       ceiling_fan   -            ceiling                     ceiling_fan:mid_void
  6  13.5           0.      -90.       floor_fan     -            slate_over_struc room>voi   floor_fan:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       fc_part_glaz  -            dbl_glz                     fc_part_glaz:corid_conv
 11  1.28         360.        0.       fc_ptn_corid  -            gyp_gyp_ptn                 fc_ptn_corid:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_prop+I
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_prop+I
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_prop+I
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_prop+I
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_prop+I
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_prop+I
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_prop+I
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_prop+I
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_prop+I
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_prop+I
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_prop+I
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_prop+I
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_prop+I
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_prop+I
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_prop+I
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_prop+I
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_prop+I
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_prop+I
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_prop+I
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_prop+I
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_prop+I
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_prop+I
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
fc_door         0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     2.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     2.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     2.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     2.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     2.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     2.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_top  corian_cou     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cseat      upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fkick      furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_b    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot croll_d    sensor_cas     vis  1rot f4th_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdlft_edge IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdrt_edge  IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdscreen   collector_
 vis   1rot dl_arm_res steel_gr_3     vis  1rot fan_heater collector_
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_fan and typcial ceiling ceiling_fan.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone 3: room_p
 
Zone room_p ( 3) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
A small office with ideal proportional (No I or D) controller..  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_p( 3)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_3pos
  2  0.920        360.        0.       cav_corid_fr  -            sash_fr92mm                 cav_corid_fr:corid_conv
  3  2.32           0.        0.       cav_door      DOOR         door                        cav_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_prop+I
  5  13.5           0.       90.       ceiling_cav   -            ceiling                     ceiling_cav:mid_void
  6  13.5           0.      -90.       floor_cav     -            slate_over_struc room>voi   floor_cav:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       cav_part_gla  -            dbl_glz                     cav_part_gla:corid_conv
 11  1.28         360.        0.       cav_ptn_cori  -            gyp_gyp_ptn                 cav_ptn_cori:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_p
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_p
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_p
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_p
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_p
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_p
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_p
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_p
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_p
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_p
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_p
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_p
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_p
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_p
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_p
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_p
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_p
 35  1.55          90.       -0.       fbooks_       FURNI        stuffonshelf                fbooks:room_p
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_p
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_p
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_p
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_p
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
cav_door        0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     5.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     5.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     5.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     5.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     5.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     5.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_cav and typcial ceiling ceiling_cav.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone 4: room_3pos
 
Zone room_3pos ( 4) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
Small office ideal threed position controler.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_3pos( 4)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_pid
  2  0.920        360.        0.       vavc_corid_f  -            sash_fr92mm                 vavc_corid_f:corid_conv
  3  2.32           0.        0.       vavc_door     DOOR         door                        vavc_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_p
  5  13.5           0.       90.       ceiling_vavc  -            ceiling                     ceiling_vavc:mid_void
  6  13.5           0.      -90.       floor_vavc    -            slate_over_struc room>voi   floor_vavc:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       vavc_part_gl  -            dbl_glz                     vavc_part_gl:corid_conv
 11  1.28         360.        0.       vavc_ptn_cor  -            gyp_gyp_ptn                 vavc_ptn_cor:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_3pos
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_3pos
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_3pos
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_3pos
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_3pos
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_3pos
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_3pos
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_3pos
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_3pos
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_3pos
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_3pos
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_3pos
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_3pos
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_3pos
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_3pos
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_3pos
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_3pos
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_3pos
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_3pos
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_3pos
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_3pos
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_3pos
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
vavc_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     8.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     8.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     8.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     8.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     8.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     8.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_vavc and typcial ceiling ceiling_vavc.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone 5: room_pid
 
Zone room_pid ( 5) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
Small office with ideal pid controller..  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_pid( 5)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_prop+D
  2  0.920        360.        0.       vavv_corid_f  -            sash_fr92mm                 vavv_corid_f:corid_conv
  3  2.32           0.        0.       vavv_door     DOOR         door                        vavv_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_3pos
  5  13.5           0.       90.       ceiling_vavv  -            ceiling                     ceiling_vavv:mid_void
  6  13.5           0.      -90.       floor_vavv    -            slate_over_struc room>voi   floor_vavv:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       vavv_part_gl  -            dbl_glz                     vavv_part_gl:corid_conv
 11  1.28         360.        0.       vavv_ptn_cor  -            gyp_gyp_ptn                 vavv_ptn_cor:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_pid
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_pid
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_pid
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_pid
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_pid
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_pid
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_pid
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_pid
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_pid
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_pid
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_pid
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_pid
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.       -0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_pid
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_pid
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_pid
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_pid
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_pid
 35  1.55          90.       -0.       fbooks_       FURNI        stuffonshelf                fbooks:room_pid
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_pid
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_pid
 38  0.123         90.       -0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_pid
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_pid
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
vavv_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    11.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    11.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    11.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    11.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    11.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    11.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_vavv and typcial ceiling ceiling_vavv.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone 6: room_prop+D
 
Zone room_prop+D ( 6) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
A small office with Prop+D controller for convective regime..  
There is 22.500 m^2^ of exposed surface area, 22.500 m^2^ of which is vertical.
Facade opaque is 17.180 m^2^ &  127.3 % of floor area & average U of 0.394 & UA of 6.7622.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  23.6 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 56.168 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_prop+D( 6)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            insul_frc_facade_heater     external
  2  0.920        360.        0.       cen_corid_fr  -            sash_fr92mm                 cen_corid_fr:corid_conv
  3  2.32           0.        0.       cen_door      DOOR         door                        cen_door:corid_conv
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_pid
  5  13.5           0.       90.       ceiling_cen   -            ceiling                     ceiling_cen:mid_void
  6  13.5           0.      -90.       floor_cen     -            slate_over_struc room>voi   floor_cen:void_low
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       cen_part_gla  -            dbl_glz                     cen_part_gla:corid_conv
 11  1.28         360.        0.       cen_ptn_cori  -            gyp_gyp_ptn                 cen_ptn_cori:corid_conv
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_prop+D
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_prop+D
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_prop+D
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_prop+D
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_prop+D
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_prop+D
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_prop+D
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_prop+D
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_prop+D
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_prop+D
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_prop+D
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_prop+D
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484        360.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_prop+D
 31  0.500          0.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_prop+D
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_prop+D
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_prop+D
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_prop+D
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_prop+D
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_prop+D
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_prop+D
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_prop+D
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_prop+D
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
cen_door        0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             14.8       0.0     14.8      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
insul_frc_facade_h      13.5      13.5      0.0      0.0       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    14.5   -0.1    3.1    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    14.5   -0.3    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    14.5   -0.5    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    14.5   -0.7    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    14.5   -0.9    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    14.5   -1.1    3.1    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_cen and typcial ceiling ceiling_cen.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone 7: corid_conv
 
Zone corid_conv ( 7) is composed of 44 surfaces and 88 vertices.
It encloses a volume of 81.0 m^3^ of space, with a total surface
area of 171. m^2^ & approx floor area of 27.0 m^2^.
corid_conv is passage adjacet to convective heating rooms.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 9.0000 m^2^ &   33.3 % of floor area & average U of 0.360 & UA of 3.2388.
Opaque partitions:ceiling:floor 81.120 m^2^ & trasparent partitions:ceiling:floor 26.880 m^2^.  
 
: A summary of the surfaces in corid_conv( 7)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  0.920        180.       -0.       bc_corid_fra  -            sash_fr92mm                 bc_corid_fra:room_bc
  2  2.32         180.        0.       bc_door       DOOR         door                        bc_door:room_bc
  3  4.48         180.        0.       bc_part_glaz  -            dbl_glz                     bc_part_glaz:room_bc
  4  1.28         180.        0.       bc_ptn_corid  -            gyp_gyp_ptn                 bc_ptn_corid:room_bc
  5  0.920        180.        0.       fc_corid_fra  -            sash_fr92mm                 fc_corid_fra:room_prop+I
  6  2.32         180.        0.       fc_door       DOOR         door                        fc_door:room_prop+I
  7  4.48         180.        0.       fc_part_glaz  -            dbl_glz                     fc_part_glaz:room_prop+I
  8  1.28         180.        0.       fc_ptn_corid  -            gyp_gyp_ptn                 fc_ptn_corid:room_prop+I
  9  0.920        180.        0.       cav_corid_fr  -            sash_fr92mm                 cav_corid_fr:room_p
 10  2.32         180.        0.       cav_door      DOOR         door                        cav_door:room_p
 11  4.48         180.        0.       cav_part_gla  -            dbl_glz                     cav_part_gla:room_p
 12  1.28         180.        0.       cav_ptn_cori  -            gyp_gyp_ptn                 cav_ptn_cori:room_p
 13  0.920        180.        0.       vavc_corid_f  -            sash_fr92mm                 vavc_corid_f:room_3pos
 14  2.32         180.        0.       vavc_door     DOOR         door                        vavc_door:room_3pos
 15  4.48         180.        0.       vavc_part_gl  -            dbl_glz                     vavc_part_gl:room_3pos
 16  1.28         180.        0.       vavc_ptn_cor  -            gyp_gyp_ptn                 vavc_ptn_cor:room_3pos
 17  0.920        180.        0.       vavv_corid_f  -            sash_fr92mm                 vavv_corid_f:room_pid
 18  2.32         180.        0.       vavv_door     DOOR         door                        vavv_door:room_pid
 19  4.48         180.        0.       vavv_part_gl  -            dbl_glz                     vavv_part_gl:room_pid
 20  1.28         180.        0.       vavv_ptn_cor  -            gyp_gyp_ptn                 vavv_ptn_cor:room_pid
 21  0.920        180.        0.       cen_corid_fr  -            sash_fr92mm                 cen_corid_fr:room_prop+D
 22  2.32         180.        0.       cen_door      DOOR         door                        cen_door:room_prop+D
 23  4.48         180.        0.       cen_part_gla  -            dbl_glz                     cen_part_gla:room_prop+D
 24  1.28         180.        0.       cen_ptn_cori  -            gyp_gyp_ptn                 cen_ptn_cori:room_prop+D
 25  4.50           0.      -90.       cor_floor_a   -            slate_over_struc room>voi   cor_floor_a:void_low
 26  4.50           0.      -90.       cor_floor_b   -            slate_over_struc room>voi   cor_floor_b:void_low
 27  4.50           0.      -90.       cor_floor_c   -            slate_over_struc room>voi   cor_floor_c:void_low
 28  4.50           0.      -90.       corid_floor_  -            slate_over_struc room>voi   corid_floor_:void_low
 29  4.50           0.      -90.       corid_flr_e   -            slate_over_struc room>voi   corid_flr_e:void_low
 30  4.50           0.      -90.       corid_flr_f   -            slate_over_struc room>voi   corid_flr_f:void_low
 31  4.50           0.       90.       cor_ceil_a    -            ceiling                     cor_ceil_a:mid_void
 32  4.50           0.       90.       cor_ceil_b    -            ceiling                     cor_ceil_b:mid_void
 33  4.50           0.       90.       cor_ceil_c    -            ceiling                     cor_ceil_c:mid_void
 34  4.50           0.       90.       cor_ceil_d    -            ceiling                     cor_ceil_d:mid_void
 35  4.50           0.       90.       cor_ceil_e    -            ceiling                     cor_ceil_e:mid_void
 36  4.50           0.       90.       cor_ceil_f    -            ceiling                     cor_ceil_f:mid_void
 37  4.50         270.        0.       left          DOOR         insul_frc_facade_heater     external
 38  4.50          90.        0.       right         DOOR         insul_frc_facade_heater     external
 39  9.00           0.        0.       corid_a       -            gyp_blk_ptn                 identical environment
 40  9.00           0.        0.       corid_b       -            gyp_blk_ptn                 identical environment
 41  9.00           0.        0.       corid_c       -            gyp_blk_ptn                 identical environment
 42  9.00           0.        0.       corid_d       -            gyp_blk_ptn                 identical environment
 43  9.00           0.        0.       corid_e       -            gyp_blk_ptn                 identical environment
 44  9.00           0.        0.       corid_f       -            gyp_blk_ptn                 identical environment
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
bc_door         0.80       2.90      0.00    DOOR
fc_door         0.80       2.90      0.00    DOOR
cav_door        0.80       2.90      0.00    DOOR
vavc_door       0.80       2.90      0.00    DOOR
vavv_door       0.80       2.90      0.00    DOOR
cen_door        0.80       2.90      0.00    DOOR
left            1.50       3.00      0.00    DOOR
right           1.50       3.00      0.00    DOOR
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_blk_ptn             54.0       0.0      0.0      0.0       0.0      54.0
gyp_gyp_ptn              7.7       0.0      7.7      0.0       0.0       0.0
door                    13.9       0.0     13.9      0.0       0.0       0.0
dbl_glz                 26.9       0.0     26.9      0.0       0.0       0.0
sash_fr92mm              5.5       0.0      5.5      0.0       0.0       0.0
ceiling                 27.0       0.0     27.0      0.0       0.0       0.0
insul_frc_facade_h       9.0       9.0      0.0      0.0       0.0       0.0
slate_over_struc r      27.0       0.0     27.0      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor cor_floor_a and typcial ceiling cor_ceil_a.
Floor upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external   8.000.
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: corid_conv
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupants  people     W      0- 7      32.0     20.0       0.60       0.40
weekdays    2  Occupants  people     W      7- 8      75.0     45.0       0.60       0.40
weekdays    3  Occupants  people     W      8- 9     166.0     91.0       0.60       0.40
weekdays    4  Occupants  people     W      9-12      75.0     45.0       0.60       0.40
weekdays    5  Occupants  people     W     12-14     166.0     91.0       0.60       0.40
weekdays    6  Occupants  people     W     14-17      32.0     20.0       0.60       0.40
weekdays    7  Occupants  people     W     17-18     166.0     91.0       0.60       0.40
weekdays    8  Occupants  people     W     18-21      32.0     20.0       0.60       0.40
weekdays    9  Occupants  people     W     21-24      16.0     11.6       0.60       0.40
weekdays   10  Lights     lighting   Wm2    0- 7       1.0      0.0       0.30       0.70
weekdays   11  Lights     lighting   Wm2    7-21       8.0      0.0       0.30       0.70
weekdays   12  Lights     lighting   Wm2   21-24       1.0      0.0       0.30       0.70
weekdays   13  SmallPower equipment  Wm2    0- 7       0.0      0.0       0.40       0.60
weekdays   14  SmallPower equipment  Wm2    7- 8       3.0      0.0       0.40       0.60
weekdays   15  SmallPower equipment  Wm2    8-24       0.0      0.0       0.40       0.60
saturday    1  Occupants  people     W      0- 7      32.0     20.0       0.60       0.40
saturday    2  Occupants  people     W      7- 8      75.0     45.0       0.60       0.40
saturday    3  Occupants  people     W      8- 9     166.0     91.0       0.60       0.40
saturday    4  Occupants  people     W      9-12      75.0     45.0       0.60       0.40
saturday    5  Occupants  people     W     12-14     100.0     50.0       0.60       0.40
saturday    6  Occupants  people     W     14-24      32.0     11.6       0.60       0.40
saturday    7  Lights     lighting   Wm2    0- 8       1.0      0.0       0.30       0.70
saturday    8  Lights     lighting   Wm2    8-12       7.0      0.0       0.30       0.70
saturday    9  Lights     lighting   Wm2   12-24       5.0      0.0       0.30       0.70
saturday   10  SmallPower equipment  Wm2    0- 7       0.0      0.0       0.40       0.60
saturday   11  SmallPower equipment  Wm2    7-14       1.0      0.0       0.40       0.60
saturday   12  SmallPower equipment  Wm2   14-24       0.0      0.0       0.40       0.60
sunday      1  Occupants  people     W      0-24       8.0      4.0       0.60       0.40
sunday      2  Lights     lighting   Wm2    0-24       1.0      0.0       0.30       0.70
sunday      3  SmallPower equipment  Wm2    0-24       1.0      0.0       0.40       0.60
holiday     1  Occupants  people     W      0-24       8.0      4.0       0.60       0.40
holiday     2  Lights     lighting   Wm2    0-24       1.0      0.0       0.30       0.70
holiday     3  SmallPower equipment  Wm2    0-24       1.0      0.0       0.40       0.60
 
### Zone 8: void_low
 
Zone void_low ( 8) is composed of 18 surfaces and 39 vertices.
It encloses a volume of 43.2 m^3^ of space, with a total surface
area of 235. m^2^ & approx floor area of 108. m^2^.
void_low describes lower boundary ceiling void.  
There is 12.000 m^2^ of exposed surface area, 12.000 m^2^ of which is vertical.
Facade opaque is 12.000 m^2^ &   11.1 % of floor area & average U of 0.319 & UA of 3.8272.
Opaque partitions:ceiling:floor 108.00 m^2^.  
 
: A summary of the surfaces in void_low( 8)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  4.50           0.       90.       cor_floor_a   -            slate_scr_struc_rev         cor_floor_a:corid_conv
  2  4.50           0.       90.       cor_floor_b   -            slate_scr_struc_rev         cor_floor_b:corid_conv
  3  4.50           0.       90.       cor_floor_c   -            slate_scr_struc_rev         cor_floor_c:corid_conv
  4  4.50           0.       90.       corid_floor_  -            slate_scr_struc_rev         corid_floor_:corid_conv
  5  4.50           0.       90.       corid_flr_e   -            slate_scr_struc_rev         corid_flr_e:corid_conv
  6  4.50           0.       90.       corid_flr_f   -            slate_scr_struc_rev         corid_flr_f:corid_conv
  7  13.5           0.       90.       floor_bc      -            slate_scr_struc_rev         floor_bc:room_bc
  8  13.5           0.       90.       floor_fan     -            slate_scr_struc_rev         floor_fan:room_prop+I
  9  13.5           0.       90.       floor_cav     -            slate_scr_struc_rev         floor_cav:room_p
 10  13.5           0.       90.       floor_vavc    -            slate_scr_struc_rev         floor_vavc:room_3pos
 11  13.5           0.       90.       floor_vavv    -            slate_scr_struc_rev         floor_vavv:room_pid
 12  13.5           0.       90.       floor_cen     -            slate_scr_struc_rev         floor_cen:room_prop+D
 13  2.40         270.        0.       left          F-FRAME      insul_frc_facade_heater     external
 14  2.40          90.        0.       right         DOOR         insul_frc_facade_heater     external
 15  7.20           0.        0.       back          -            gyp_blk_ptn                 identical environment
 16  7.20         180.        0.       facade        -            frc_facade                  external
 17  81.0           0.      -90.       base_offices  -            ceiling_rev                 identical environment
 18  27.0           0.      -90.       base_corid    -            ceiling_rev                 identical environment
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
left            6.00       0.40      0.00    F-FRAME
right           6.00       0.40      0.00    DOOR
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_blk_ptn              7.2       0.0      0.0      0.0       0.0       7.2
ceiling_rev            108.0       0.0      0.0      0.0       0.0     108.0
slate_scr_struc_re     108.0       0.0    108.0      0.0       0.0       0.0
insul_frc_facade_h       4.8       4.8      0.0      0.0       0.0       0.0
frc_facade               7.2       7.2      0.0      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: void_low
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupants  people     W      0-24       0.0     10.0       0.60       0.40
weekdays    2  Lights     lighting   Wm2    0- 8       1.0      0.0       0.80       0.20
weekdays    3  Lights     lighting   Wm2    8-21       2.0      0.0       0.80       0.20
weekdays    4  Lights     lighting   Wm2   21-24       1.0      0.0       0.80       0.20
weekdays    5  SmallPower equipment  Wm2    0-24       1.0      0.0       0.40       0.60
saturday    1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
saturday    2  Lights     lighting   Wm2    0- 8       1.0      0.0       0.80       0.20
saturday    3  Lights     lighting   Wm2    8-13       2.5      0.0       0.80       0.20
saturday    4  Lights     lighting   Wm2   13-24       1.0      0.0       0.80       0.20
saturday    5  SmallPower equipment  Wm2    0-24       1.0      0.0       0.40       0.60
sunday      1  Occupants  people     W      0-24       0.5      0.5       0.60       0.40
sunday      2  Lights     lighting   Wm2    0-24       1.0      0.0       0.80       0.20
sunday      3  SmallPower equipment  Wm2    0-24       1.0      1.0       0.40       0.60
holiday     1  Occupants  people     W      0-24       0.5      0.5       0.60       0.40
holiday     2  Lights     lighting   Wm2    0-24       1.0      0.0       0.80       0.20
holiday     3  SmallPower equipment  Wm2    0-24       1.0      1.0       0.40       0.60
 
### Zone 9: room_master
 
Zone room_master ( 9) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
room_master is office with master controler.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 56.168 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_master( 9)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_slave1
  2  0.920          0.        0.       bcr_corid_fr  -            sash_fr92mm                 bc_corid_fra:corid_rad
  3  2.32           0.        0.       bcr_door      DOOR         door                        bc_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 identical environment
  5  13.5           0.       90.       ceiling_bcr   -            ceiling                     ceiling_bcr:upper_void
  6  13.5           0.      -90.       floor_bcr     -            slate_over_struc room>voi   floor_bcr:mid_void
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       bcr_part_gla  -            dbl_glz                     bc_part_glaz:corid_rad
 11  1.28           0.        0.       bcr_ptn_cori  -            gyp_gyp_ptn                 bc_ptn_corid:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_master
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_master
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_master
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_master
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_master
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_master
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_master
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_master
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_master
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_master
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_master
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_master
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_master
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_master
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_master
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_master
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_master
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_master
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_master
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_master
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_master
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_master
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
bcr_door        0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     14.8      0.0       0.0      13.5
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    -0.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    -0.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    -0.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    -0.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    -0.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    -0.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_bcr and typcial ceiling ceiling_bcr.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone10: room_slave1
 
Zone room_slave1 (10) is composed of 39 surfaces and 77 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
small office slaved to room_master.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_slave1(10)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_onoffsh
  2  0.920          0.        0.       radf_corid_f  -            sash_fr92mm                 fc_corid_fra:corid_rad
  3  2.32           0.        0.       radf_door     DOOR         door                        fc_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_master
  5  13.5           0.       90.       ceiling_radf  -            ceiling                     ceiling_radf:upper_void
  6  13.5           0.      -90.       floor_radf    -            slate_over_struc room>voi   floor_radf:mid_void
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       radf_part_gl  -            dbl_glz                     fc_part_glaz:corid_rad
 11  1.28           0.        0.       radf_ptn_cor  -            gyp_gyp_ptn                 fc_ptn_corid:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_slave1
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_slave1
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_slave1
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_slave1
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_slave1
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_slave1
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_slave1
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_slave1
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_slave1
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_slave1
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_slave1
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_slave1
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_slave1
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_slave1
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_slave1
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_slave1
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_slave1
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_slave1
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_slave1
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_slave1
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_slave1
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_slave1
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
radf_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     2.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     2.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     2.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     2.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     2.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     2.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_top  corian_cou     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cseat      upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fkick      furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_b    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot croll_d    sensor_cas     vis  1rot f4th_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdlft_edge IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdrt_edge  IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdscreen   collector_
 vis   1rot dl_arm_res steel_gr_3     vis  1rot radiator   steel_pl_3
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_radf and typcial ceiling ceiling_radf.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone11: room_onoffsh
 
Zone room_onoffsh (11) is composed of 39 surfaces and 77 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
small office with ON OFF controller for short timesteps.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_onoffsh(11)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:floor_heat
  2  0.920          0.        0.       radw_corid_f  -            sash_fr92mm                 cav_corid_fr:corid_rad
  3  2.32           0.        0.       radw_door     DOOR         door                        cav_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_slave1
  5  13.5           0.       90.       ceiling_radw  -            ceiling                     ceiling_radw:upper_void
  6  13.5           0.      -90.       floor_radw    -            susp_flr_re                 floor_radw:mid_void
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       radw_part_gl  -            dbl_glz                     cav_part_gla:corid_rad
 11  1.28           0.        0.       radw_ptn_cor  -            gyp_gyp_ptn                 cav_ptn_cori:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_onoffsh
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_onoffsh
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_onoffsh
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_onoffsh
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_onoffsh
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_onoffsh
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_onoffsh
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_onoffsh
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_onoffsh
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_onoffsh
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_onoffsh
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_onoffsh
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_onoffsh
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_onoffsh
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_onoffsh
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_onoffsh
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_onoffsh
 35  1.55          90.       -0.       fbooks_       FURNI        stuffonshelf                fbooks:room_onoffsh
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_onoffsh
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_onoffsh
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_onoffsh
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_onoffsh
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
radw_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
susp_flr_re             13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     5.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     5.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     5.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     5.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     5.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     5.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_top  corian_cou     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cseat      upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fshelf_a   furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fkick      furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_b    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot croll_d    sensor_cas     vis  1rot f4th_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dl_arm     upholstery     vis  1rot gdstand    steel_pl_3
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdlft_edge IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdrt_edge  IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdscreen   collector_
 vis   1rot dl_arm_res steel_gr_3     vis  1rot radiator   steel_pl_3
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_radw and typcial ceiling ceiling_radw.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone12: floor_heat
 
Zone floor_heat (12) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
floor_heat office with thin zone floor heating.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in floor_heat(12)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_vave
  2  0.920          0.        0.       flrh_corid_f  -            sash_fr92mm                 vavc_corid_f:corid_rad
  3  2.32           0.        0.       flrh_door     DOOR         door                        vavc_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_onoffsh
  5  13.5           0.       90.       ceiling_flrh  -            ceiling                     ceiling_flrh:upper_void
  6  13.5           0.      -90.       floor_flrh    -            slate_screed                floor_flrh:thin_floor
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       flrh_part_gl  -            dbl_glz                     vavc_part_gl:corid_rad
 11  1.28           0.        0.       flrh_ptn_cor  -            gyp_gyp_ptn                 vavc_ptn_cor:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:floor_heat
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:floor_heat
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:floor_heat
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:floor_heat
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:floor_heat
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:floor_heat
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:floor_heat
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:floor_heat
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:floor_heat
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:floor_heat
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:floor_heat
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:floor_heat
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:floor_heat
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:floor_heat
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:floor_heat
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:floor_heat
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:floor_heat
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:floor_heat
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:floor_heat
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:floor_heat
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:floor_heat
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:floor_heat
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
flrh_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_screed            13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1     8.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2     8.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3     8.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4     8.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5     8.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6     8.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 surf-to-air deltaT via in-floor heating
 Surface  Orientation ----- Inside -----     ----- Outside -----
  1 pt_right     (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  2 flrh_corid_f (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  3 flrh_door    (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  4 pt_left      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  5 ceiling_flrh (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
  6 floor_flrh   (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
  7 spandral     (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  8 frame        (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
  9 glazing      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 10 flrh_part_gl (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 11 flrh_ptn_cor (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 12 adesk_t      (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
 13 adesk_t_     (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
 14 bdesk_t      (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
 15 bdesk_t_     (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
 16 cseat        (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
 17 cseat_       (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
 18 cstback      (SLOP)   1.   6.  -1.   0.     99.  99.  99.  99.
 19 cstback_     (SLOP)   1.   6.  -1.   0.     99.  99.  99.  99.
 20 dseat        (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
 21 dseat_       (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
 22 dstback      (SLOP)   1.   6.  -1.   0.     99.  99.  99.  99.
 23 dstback_     (SLOP)   1.   6.  -1.   0.     99.  99.  99.  99.
 24 ecab_lf      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 25 ecab_rt      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 26 ecab_fr      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 27 ecab_bk      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 28 ecab_to      (FLOR)   1.  55.  -1.   0.     99.  99.  99.  99.
 29 ecab_bs      (CEIL)   1.  61.  -1.   0.     99.  99.  99.  99.
 30 fbil_lft     (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 31 fbil_lft_    (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 32 fbil_rt      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 33 fbil_rt_     (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 34 fbooks       (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 35 fbooks_      (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 36 gcase        (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 37 gcase_       (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 38 gcircuit     (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 39 gcircuit_    (VERT)   1.   6.  -1.   0.     99.  99.  99.  99.
 
 Uses same operations as zone room_bc
 
### Zone13: room_vave
 
Zone room_vave (13) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
small office with ideal VAV with terminal reheat..  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 3.6800 m^2^ &   27.3 % of floor area & average U of 0.517 & UA of 1.9040.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  59.1 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 69.668 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_vave(13)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            gyp_gyp_ptn                 pt_left:room_tprop
  2  0.920          0.        0.       user_corid_f  -            sash_fr92mm                 vavv_corid_f:corid_rad
  3  2.32           0.        0.       user_door     DOOR         door                        vavv_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:floor_heat
  5  13.5           0.       90.       ceiling_user  -            ceiling                     ceiling_user:upper_void
  6  13.5           0.      -90.       floor_user    -            slate_over_struc room>voi   floor_vavv:mid_void
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         F-FRAME      sash_fr92mm                 external
  9  5.32         180.        0.       glazing       C-WINDOW     dbl_glz                     external
 10  4.48           0.        0.       user_part_gl  -            dbl_glz                     vavv_part_gl:corid_rad
 11  1.28           0.        0.       user_ptn_cor  -            gyp_gyp_ptn                 vavv_ptn_cor:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_vave
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_vave
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_vave
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_vave
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_vave
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_vave
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_vave
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_vave
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_vave
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_vave
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_vave
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_vave
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.       -0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_vave
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_vave
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_vave
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_vave
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_vave
 35  1.55          90.       -0.       fbooks_       FURNI        stuffonshelf                fbooks:room_vave
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_vave
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_vave
 38  0.123         90.       -0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_vave
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_vave
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
user_door       0.80       2.90      0.00    DOOR
frame           3.00       2.10      0.90    F-FRAME
glazing         2.80       1.90      1.00    C-WINDOW
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             28.3       0.0     28.3      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    11.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    11.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    11.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    11.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    11.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    11.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor floor_user and typcial ceiling ceiling_user.
Floor upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external  -1.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external  -1.000.
 
 Uses same operations as zone room_bc
 
### Zone14: room_tprop
 
Zone room_tprop (14) is composed of 39 surfaces and 76 vertices.
It encloses a volume of 40.3 m^3^ of space, with a total surface
area of 85.4 m^2^ & approx floor area of 13.5 m^2^.
small office with a time-proportioning ONOFF control.  
There is 22.500 m^2^ of exposed surface area, 22.500 m^2^ of which is vertical.
Facade opaque is 17.180 m^2^ &  127.3 % of floor area & average U of 0.394 & UA of 6.7622.
Facade glazing is 5.3200 m^2^ &  39.4 % of floor &  23.6 % facade with average U of 2.811 & UA of 14.953.  
Opaque partitions:ceiling:floor 56.168 m^2^ & trasparent partitions:ceiling:floor 4.4800 m^2^.  
 
: A summary of the surfaces in room_tprop(14)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5          90.        0.       pt_right      -            insul_frc_facade_heater     external
  2  0.920          0.        0.       wrmw_corid_f  -            sash_fr92mm                 cen_corid_fr:corid_rad
  3  2.32           0.        0.       warmw_door    -            door                        cen_door:corid_rad
  4  13.5         270.        0.       pt_left       -            gyp_gyp_ptn                 pt_right:room_vave
  5  13.5           0.       90.       ceiling_warm  -            ceiling                     ceiling_warm:upper_void
  6  13.5           0.      -90.       floor_warmw   -            slate_over_struc room>voi   floor_cen:mid_void
  7  2.70         180.        0.       spandral      -            frc_facade                  external
  8  0.980        180.        0.       frame         -            sash_fr92mm                 external
  9  5.32         180.        0.       glazing       -            dbl_glz                     external
 10  4.48           0.        0.       warmw_part_g  -            dbl_glz                     cen_part_gla:corid_rad
 11  1.28           0.        0.       warmw_ptn_co  -            gyp_gyp_ptn                 cen_ptn_cori:corid_rad
 12  0.938          0.       90.       adesk_t       FURNI        corian_count                adesk_t_:room_tprop
 13  0.938          0.      -90.       adesk_t_      FURNI        corian_count                adesk_t:room_tprop
 14  0.938          0.       90.       bdesk_t       FURNI        corian_count                bdesk_t_:room_tprop
 15  0.938          0.      -90.       bdesk_t_      FURNI        corian_count                bdesk_t:room_tprop
 16  0.207          0.       90.       cseat         FURNI        upholstery                  cseat_:room_tprop
 17  0.207          0.      -90.       cseat_        FURNI        upholstery                  cseat:room_tprop
 18  0.231        225.        6.       cstback       FURNI        upholstery                  cstback_:room_tprop
 19  0.231         45.       -6.       cstback_      FURNI        upholstery                  cstback:room_tprop
 20  0.207          0.       90.       dseat         FURNI        upholstery                  dseat_:room_tprop
 21  0.207          0.      -90.       dseat_        FURNI        upholstery                  dseat:room_tprop
 22  0.231        190.        6.       dstback       FURNI        upholstery                  dstback_:room_tprop
 23  0.231         10.       -6.       dstback_      FURNI        upholstery                  dstback:room_tprop
 24  0.484        180.        0.       ecab_lf       FURNI        steel_pl_3mm                identical environment
 25  0.484          0.        0.       ecab_rt       FURNI        steel_pl_3mm                identical environment
 26  0.484         90.        0.       ecab_fr       FURNI        file_papers                 identical environment
 27  0.484        270.        0.       ecab_bk       FURNI        file_papers                 identical environment
 28  0.152          0.      -90.       ecab_to       FURNI        steel_gr_3mm                identical environment
 29  0.152          0.       90.       ecab_bs       FURNI        steel_gr_3mm                identical environment
 30  0.500        180.        0.       fbil_lft      FURNI        furn_wd10mm                 fbil_lft_:room_tprop
 31  0.500        360.        0.       fbil_lft_     FURNI        furn_wd10mm                 fbil_lft:room_tprop
 32  0.500        180.        0.       fbil_rt       FURNI        furn_wd10mm                 fbil_rt_:room_tprop
 33  0.500        360.        0.       fbil_rt_      FURNI        furn_wd10mm                 fbil_rt:room_tprop
 34  1.55         270.        0.       fbooks        FURNI        stuffonshelf                fbooks_:room_tprop
 35  1.55          90.        0.       fbooks_       FURNI        stuffonshelf                fbooks:room_tprop
 36  0.148         90.        0.       gcase         FURNI        IT_case                     gcase_:room_tprop
 37  0.148        270.        0.       gcase_        FURNI        IT_case                     gcase:room_tprop
 38  0.123         90.        0.       gcircuit      FURNI        circuit_bd                  gcircuit_:room_tprop
 39  0.123        270.        0.       gcircuit_     FURNI        circuit_bd                  gcircuit:room_tprop
 
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_gyp_ptn             14.8       0.0     14.8      0.0       0.0       0.0
door                     2.3       0.0      2.3      0.0       0.0       0.0
dbl_glz                  9.8       5.3      4.5      0.0       0.0       0.0
sash_fr92mm              1.9       1.0      0.9      0.0       0.0       0.0
ceiling                 13.5       0.0     13.5      0.0       0.0       0.0
steel_pl_3mm             1.0       0.0      0.0      0.0       0.0       1.0
circuit_bd               0.1       0.0      0.0      0.1       0.0       0.0
upholstery               0.9       0.0      0.0      0.9       0.0       0.0
corian_count             1.9       0.0      0.0      1.9       0.0       0.0
IT_case                  0.1       0.0      0.0      0.1       0.0       0.0
furn_wd10mm              1.0       0.0      0.0      1.0       0.0       0.0
steel_gr_3mm             0.3       0.0      0.0      0.0       0.0       0.3
file_papers              1.0       0.0      0.0      0.0       0.0       1.0
stuffonshelf             1.5       0.0      0.0      1.5       0.0       0.0
insul_frc_facade_h      13.5      13.5      0.0      0.0       0.0       0.0
slate_over_struc r      13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               2.7       2.7      0.0      0.0       0.0       0.0
 
An hourly solar radiation distribution is used for this zone.  
Surfaces (all applicable) for shading analysis  
spandral frame glazing  
Insolation sources (all applicable) 
glazing  
 Explicit viewfactors have been derived for this zone.
 
: Blocks associated with zone
 
Block X       Y      Z      DX     DY     DZ     Orient        Opacity Name     Constr
----- ------- ------ ------ ------ ------ ------ ------ ------ ------- -------- -----------
    1    14.5   -0.1    6.5    4.0    0.0    0.3    0.0    0.0  1.00   ob1      door
    2    14.5   -0.3    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob2      door
    3    14.5   -0.5    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob3      door
    4    14.5   -0.7    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob4      door
    5    14.5   -0.9    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob5      door
    6    14.5   -1.1    6.5    4.0    0.0    0.2    0.0    0.0  1.00   ob6      door
 
 
: Visual entities:
 
visual type name       composition  visual type name       composition
------ ---- ---------- -----------  ------ ---- ---------- -----------
 vis   1rot adesk_top  corian_cou     vis  1rot dl_arm_res steel_gr_3
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_a    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_b    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_c    sensor_cas
 vis   1rot adesk_leg_ steel_pl_3     vis  1rot droll_d    sensor_cas
 vis   1rot bdesk_top  corian_cou     vis  1rot ef_cabinet steel_pl_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_a     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_b     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_c     steel_gr_3
 vis   1rot bdesk_leg_ steel_pl_3     vis  1rot edrw_d     steel_gr_3
 vis   1rot cseat      upholstery     vis  1rot fleft_ver  furn_wd10m
 vis   1rot cr_arm     upholstery     vis  1rot fright_ver furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot cl_arm     upholstery     vis  1rot fbil_bk    furn_wd10m
 vis   1rot ccross_a   steel_gr_3     vis  1rot fshelf_b   furn_wd10m
 vis   1rot ccross_b   steel_gr_3     vis  1rot fshelf_c   furn_wd10m
 vis   1rot cpost      PH_alu_fra     vis  1rot fshelf_d   furn_wd10m
 vis   1rot cr_arm_res steel_gr_3     vis  1rot fshelf_e   furn_wd10m
 vis   1rot cl_arm_res steel_gr_3     vis  1rot fbil_top   furn_wd10m
 vis   1rot croll_a    sensor_cas     vis  1rot fkick      furn_wd10m
 vis   1rot croll_b    sensor_cas     vis  1rot flow_books stuffonshe
 vis   1rot croll_c    sensor_cas     vis  1rot f2nd_books stuffonshe
 vis   1rot croll_d    sensor_cas     vis  1rot f3rd_books booksonshl
 vis   1rot dseat      upholstery     vis  1rot f4th_books booksonshl
 vis   1rot dr_arm     upholstery     vis  1rot ftop_books booksonshl
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dl_arm     upholstery     vis  1rot gdbase     IT_case
 vis   1rot dcross_a   steel_gr_3     vis  1rot gdlow_edge IT_case
 vis   1rot dcross_b   steel_gr_3     vis  1rot gdup_edge  IT_case
 vis   1rot dpost      PH_alu_fra     vis  1rot gdlft_edge IT_case
 vis   1rot dr_arm_res steel_gr_3     vis  1rot gdrt_edge  IT_case
                                       vis 1rot  gdscreen   collector_pl
 
 Shading patterns have been calculated for this zone.
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 surf-to-air deltaT via wall panel heating
 Surface  Orientation ----- Inside -----     ----- Outside -----
  1 pt_right     (VERT)   1.  14.  -1.   0.     99.  99.  99.  99.
  2 wrmw_corid_f (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
  3 warmw_door   (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
  4 pt_left      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
  5 ceiling_warm (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
  6 floor_warmw  (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
  7 spandral     (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
  8 frame        (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
  9 glazing      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 10 warmw_part_g (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 11 warmw_ptn_co (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 12 adesk_t      (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
 13 adesk_t_     (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
 14 bdesk_t      (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
 15 bdesk_t_     (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
 16 cseat        (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
 17 cseat_       (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
 18 cstback      (SLOP)   1.   5.  -1.   0.     99.  99.  99.  99.
 19 cstback_     (SLOP)   1.   5.  -1.   0.     99.  99.  99.  99.
 20 dseat        (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
 21 dseat_       (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
 22 dstback      (SLOP)   1.   5.  -1.   0.     99.  99.  99.  99.
 23 dstback_     (SLOP)   1.   5.  -1.   0.     99.  99.  99.  99.
 24 ecab_lf      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 25 ecab_rt      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 26 ecab_fr      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 27 ecab_bk      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 28 ecab_to      (FLOR)   1.  70.  -1.   0.     99.  99.  99.  99.
 29 ecab_bs      (CEIL)   1.  60.  -1.   0.     99.  99.  99.  99.
 30 fbil_lft     (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 31 fbil_lft_    (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 32 fbil_rt      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 33 fbil_rt_     (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 34 fbooks       (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 35 fbooks_      (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 36 gcase        (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 37 gcase_       (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 38 gcircuit     (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 39 gcircuit_    (VERT)   1.   5.  -1.   0.     99.  99.  99.  99.
 
 Uses same operations as zone room_bc
 
### Zone15: corid_rad
 
Zone corid_rad (15) is composed of 44 surfaces and 88 vertices.
It encloses a volume of 81.0 m^3^ of space, with a total surface
area of 171. m^2^ & approx floor area of 27.0 m^2^.
corid_rad describes corridor adjacent to radiator rooms.  
There is 9.0000 m^2^ of exposed surface area, 9.0000 m^2^ of which is vertical.
Facade opaque is 9.0000 m^2^ &   33.3 % of floor area & average U of 0.326 & UA of 2.9318.
Opaque partitions:ceiling:floor 81.120 m^2^ & trasparent partitions:ceiling:floor 26.880 m^2^.  
 
: A summary of the surfaces in corid_rad(15)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  0.920        180.       -0.       bc_corid_fra  -            sash_fr92mm                 bcr_corid_fr:room_master
  2  2.32         180.        0.       bc_door       DOOR         door                        bcr_door:room_master
  3  4.48         180.        0.       bc_part_glaz  -            dbl_glz                     bcr_part_gla:room_master
  4  1.28         180.        0.       bc_ptn_corid  -            gyp_gyp_ptn                 bcr_ptn_cori:room_master
  5  0.920        180.        0.       fc_corid_fra  -            sash_fr92mm                 radf_corid_f:room_slave1
  6  2.32         180.        0.       fc_door       DOOR         door                        radf_door:room_slave1
  7  4.48         180.        0.       fc_part_glaz  -            dbl_glz                     radf_part_gl:room_slave1
  8  1.28         180.        0.       fc_ptn_corid  -            gyp_gyp_ptn                 radf_ptn_cor:room_slave1
  9  0.920        180.        0.       cav_corid_fr  -            sash_fr92mm                 radw_corid_f:room_onoffsh
 10  2.32         180.        0.       cav_door      DOOR         door                        radw_door:room_onoffsh
 11  4.48         180.        0.       cav_part_gla  -            dbl_glz                     radw_part_gl:room_onoffsh
 12  1.28         180.        0.       cav_ptn_cori  -            gyp_gyp_ptn                 radw_ptn_cor:room_onoffsh
 13  0.920        180.        0.       vavc_corid_f  -            sash_fr92mm                 flrh_corid_f:floor_heat
 14  2.32         180.        0.       vavc_door     DOOR         door                        flrh_door:floor_heat
 15  4.48         180.        0.       vavc_part_gl  -            dbl_glz                     flrh_part_gl:floor_heat
 16  1.28         180.        0.       vavc_ptn_cor  -            gyp_gyp_ptn                 flrh_ptn_cor:floor_heat
 17  0.920        180.        0.       vavv_corid_f  -            sash_fr92mm                 user_corid_f:room_vave
 18  2.32         180.        0.       vavv_door     DOOR         door                        user_door:room_vave
 19  4.48         180.        0.       vavv_part_gl  -            dbl_glz                     user_part_gl:room_vave
 20  1.28         180.        0.       vavv_ptn_cor  -            gyp_gyp_ptn                 user_ptn_cor:room_vave
 21  0.920        180.        0.       cen_corid_fr  -            sash_fr92mm                 wrmw_corid_f:room_tprop
 22  2.32         180.        0.       cen_door      -            door                        warmw_door:room_tprop
 23  4.48         180.        0.       cen_part_gla  -            dbl_glz                     warmw_part_g:room_tprop
 24  1.28         180.        0.       cen_ptn_cori  -            gyp_gyp_ptn                 warmw_ptn_co:room_tprop
 25  4.50           0.      -90.       cor_floor_a   -            slate_over_struc room>voi   cor_floor_a:mid_void
 26  4.50           0.      -90.       cor_floor_b   -            slate_over_struc room>voi   cor_floor_b:mid_void
 27  4.50           0.      -90.       cor_floor_c   -            slate_over_struc room>voi   cor_floor_c:mid_void
 28  4.50           0.      -90.       corid_floor_  -            slate_over_struc room>voi   corid_floor_:mid_void
 29  4.50           0.      -90.       corid_flr_e   -            slate_over_struc room>voi   corid_flr_e:mid_void
 30  4.50           0.      -90.       corid_flr_f   -            slate_over_struc room>voi   corid_flr_f:mid_void
 31  4.50           0.       90.       cor_ceil_a    -            ceiling                     cor_ceil_a:upper_void
 32  4.50           0.       90.       cor_ceil_b    -            ceiling                     cor_ceil_b:upper_void
 33  4.50           0.       90.       cor_ceil_c    -            ceiling                     cor_ceil_c:upper_void
 34  4.50           0.       90.       cor_ceil_d    -            ceiling                     cor_ceil_d:upper_void
 35  4.50           0.       90.       cor_ceil_e    -            ceiling                     cor_ceil_e:upper_void
 36  4.50           0.       90.       cor_ceil_f    -            ceiling                     cor_ceil_f:upper_void
 37  4.50         270.        0.       left          DOOR         frc_facade                  external
 38  4.50          90.        0.       right         DOOR         insul_frc_facade_heater     external
 39  9.00           0.        0.       corid_a       -            gyp_blk_ptn                 identical environment
 40  9.00           0.        0.       corid_b       -            gyp_blk_ptn                 identical environment
 41  9.00           0.        0.       corid_c       -            gyp_blk_ptn                 identical environment
 42  9.00           0.        0.       corid_d       -            gyp_blk_ptn                 identical environment
 43  9.00           0.        0.       corid_e       -            gyp_blk_ptn                 identical environment
 44  9.00           0.        0.       corid_f       -            gyp_blk_ptn                 identical environment
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
bc_door         0.80       2.90      0.00    DOOR
fc_door         0.80       2.90      0.00    DOOR
cav_door        0.80       2.90      0.00    DOOR
vavc_door       0.80       2.90      0.00    DOOR
vavv_door       0.80       2.90      0.00    DOOR
left            1.50       3.00      0.00    DOOR
right           1.50       3.00      0.00    DOOR
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_blk_ptn             54.0       0.0      0.0      0.0       0.0      54.0
gyp_gyp_ptn              7.7       0.0      7.7      0.0       0.0       0.0
door                    13.9       0.0     13.9      0.0       0.0       0.0
dbl_glz                 26.9       0.0     26.9      0.0       0.0       0.0
sash_fr92mm              5.5       0.0      5.5      0.0       0.0       0.0
ceiling                 27.0       0.0     27.0      0.0       0.0       0.0
insul_frc_facade_h       4.5       4.5      0.0      0.0       0.0       0.0
slate_over_struc r      27.0       0.0     27.0      0.0       0.0       0.0
frc_facade               4.5       4.5      0.0      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 CEN default hc coefficients
 CEN regime based on typical floor cor_floor_a and typcial ceiling cor_ceil_a.
Floor upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Ceiling upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Sloped upwards flow hc is   5.000 and downwards   0.700 and external   8.000.
Walls inside hc is   2.500 and other side of partitions   2.500 and external   8.000.
 
 Uses same operations as zone corid_conv
 
### Zone16: mid_void
 
Zone mid_void (16) is composed of 31 surfaces and 70 vertices.
It encloses a volume of 41.9 m^3^ of space, with a total surface
area of 236. m^2^ & approx floor area of 108. m^2^.
mid_void is the ceiling void between convective and radiant.  
There is 11.700 m^2^ of exposed surface area, 11.700 m^2^ of which is vertical.
Facade opaque is 11.700 m^2^ &   10.8 % of floor area & average U of 0.320 & UA of 3.7397.
Opaque partitions:ceiling:floor 217.20 m^2^.  
 
: A summary of the surfaces in mid_void(16)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  4.50           0.      -90.       cor_ceil_a    -            ceiling_rev                 cor_ceil_a:corid_conv
  2  4.50           0.      -90.       cor_ceil_b    -            ceiling_rev                 cor_ceil_b:corid_conv
  3  4.50           0.      -90.       cor_ceil_c    -            ceiling_rev                 cor_ceil_c:corid_conv
  4  4.50           0.      -90.       cor_ceil_d    -            ceiling_rev                 cor_ceil_d:corid_conv
  5  4.50           0.      -90.       cor_ceil_e    -            ceiling_rev                 cor_ceil_e:corid_conv
  6  4.50           0.      -90.       cor_ceil_f    -            ceiling_rev                 cor_ceil_f:corid_conv
  7  4.50           0.       90.       cor_floor_a   -            slate_scr_struc_rev         cor_floor_a:corid_rad
  8  4.50           0.       90.       cor_floor_b   -            slate_scr_struc_rev         cor_floor_b:corid_rad
  9  4.50           0.       90.       cor_floor_c   -            slate_scr_struc_rev         cor_floor_c:corid_rad
 10  4.50           0.       90.       corid_floor_  -            slate_scr_struc_rev         corid_floor_:corid_rad
 11  4.50           0.       90.       corid_flr_e   -            slate_scr_struc_rev         corid_flr_e:corid_rad
 12  4.50           0.       90.       corid_flr_f   -            slate_scr_struc_rev         corid_flr_f:corid_rad
 13  13.5           0.      -90.       ceiling_bc    -            ceiling_rev                 ceiling_bc:room_bc
 14  13.5           0.      -90.       ceiling_fan   -            ceiling_rev                 ceiling_fan:room_prop+I
 15  13.5           0.      -90.       ceiling_cav   -            ceiling_rev                 ceiling_cav:room_p
 16  13.5           0.      -90.       ceiling_vavc  -            ceiling_rev                 ceiling_vavc:room_3pos
 17  13.5           0.      -90.       ceiling_vavv  -            ceiling_rev                 ceiling_vavv:room_pid
 18  13.5           0.      -90.       ceiling_cen   -            ceiling_rev                 ceiling_cen:room_prop+D
 19  13.5           0.       90.       floor_bcr     -            slate_scr_struc_rev         floor_bcr:room_master
 20  13.5           0.       90.       floor_radf    -            slate_scr_struc_rev         floor_radf:room_slave1
 21  13.5           0.       90.       floor_radw    -            susp_floor                  floor_radw:room_onoffsh
 22  13.5           0.       90.       floor_vavv    -            slate_scr_struc_rev         floor_user:room_vave
 23  13.5           0.       90.       floor_cen     -            slate_scr_struc_rev         floor_warmw:room_tprop
 24  2.40         270.        0.       left          F-FRAME      insul_frc_facade_heater     external
 25  2.40          90.        0.       right         DOOR         insul_frc_facade_heater     external
 26  6.90         180.        0.       facade        -            frc_facade                  external
 27  7.20           0.        0.       back          -            gyp_blk_ptn                 identical environment
 28  0.450        270.        0.       thin_right    -            floor_heating_ceil->pipe    thin_right:thin_floor
 29  0.300        180.        0.       thin_back     DOOR         floor_heating_ceil->pipe    thin_back:thin_floor
 30  0.450         90.        0.       thin_left     -            floor_heating_ceil->pipe    thin_left:thin_floor
 31  13.5           0.       90.       thin_base     -            floor_heating_ceil->pipe    thin_base:thin_floor
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
left            6.00       0.40      0.00    F-FRAME
right           6.00       0.40      0.00    DOOR
thin_back       3.00       0.10      0.30    DOOR
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_blk_ptn              7.2       0.0      0.0      0.0       0.0       7.2
ceiling_rev            108.0       0.0    108.0      0.0       0.0       0.0
susp_floor              13.5       0.0     13.5      0.0       0.0       0.0
slate_scr_struc_re      81.0       0.0     81.0      0.0       0.0       0.0
insul_frc_facade_h       4.8       4.8      0.0      0.0       0.0       0.0
frc_facade               6.9       6.9      0.0      0.0       0.0       0.0
floor_heating_ceil      14.7       0.0     14.7      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 Uses same operations as zone void_low
 
### Zone17: thin_floor
 
Zone thin_floor (17) is composed of 6 surfaces and 10 vertices.
It encloses a volume of 1.35 m^3^ of space, with a total surface
area of 28.5 m^2^ & approx floor area of 13.5 m^2^.
thin_floor a thin zone for floor heat injection.  
There is 0.30000 m^2^ of exposed surface area, 0.30000 m^2^ of which is vertical.
Facade opaque is 0.30000 m^2^ &    2.2 % of floor area & average U of 0.292 & UA of 0.0874928.
Opaque partitions:ceiling:floor 28.200 m^2^.  
 
: A summary of the surfaces in thin_floor(17)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  13.5           0.       90.       floor_flrh    -            slate_screed_rev            floor_flrh:floor_heat
  2  0.300        180.        0.       facade        WALL         frc_facade                  external
  3  0.450         90.        0.       thin_right    -            heating_struc_pipe->ceili   thin_right:mid_void
  4  0.300          0.        0.       thin_back     DOOR         heating_struc_pipe->ceili   thin_back:mid_void
  5  0.450        270.        0.       thin_left     -            heating_struc_pipe->ceili   thin_left:mid_void
  6  13.5           0.      -90.       thin_base     -            heating_struc_pipe->ceili   thin_base:mid_void
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
thin_back       3.00       0.10      0.00    DOOR
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
slate_screed_rev        13.5       0.0     13.5      0.0       0.0       0.0
frc_facade               0.3       0.3      0.0      0.0       0.0       0.0
heating_struc_pipe      14.7       0.0     14.7      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 
 Number of control periods:  1
 Period  1 start   0.00 finish  24.00
 User supplied hc values
   Surface orientation    Inside    Outside
  1 floor_flrh   (CEIL)    40.000   default
  2 facade       (VERT)    40.000   default
  3 thin_right   (VERT)    40.000   default
  4 thin_back    (VERT)    40.000   default
  5 thin_left    (VERT)    40.000   default
  6 thin_base    (FLOR)    40.000   default
 
 Ventilation & infiltration is assessed via network analysis
 and the associated network node is: thin_floor
 
 
Daytype   ID   Label      Type       Unit  Hours  Sens.(W)  Late.(W)   Rad. Frac   Con. Frac
--------  ---  ---------  ---------  ----  -----  --------  --------   ---------   ---------
weekdays    1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
weekdays    2  Lights     lighting   W      0-24       0.0      0.0       0.30       0.70
weekdays    3  SmallPower equipment  W      0-24       0.0      0.0       0.40       0.60
saturday    1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
saturday    2  Lights     lighting   W      0-24       0.0      0.0       0.30       0.70
saturday    3  SmallPower equipment  W      0-24       0.0      0.0       0.40       0.60
sunday      1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
sunday      2  Lights     lighting   W      0-24       0.0      0.0       0.30       0.70
sunday      3  SmallPower equipment  W      0-24       0.0      0.0       0.40       0.60
holiday     1  Occupants  people     W      0-24       0.0      0.0       0.60       0.40
holiday     2  Lights     lighting   W      0-24       0.0      0.0       0.30       0.70
holiday     3  SmallPower equipment  W      0-24       0.0      0.0       0.40       0.60
 
### Zone18: upper_void
 
Zone upper_void (18) is composed of 17 surfaces and 37 vertices.
It encloses a volume of 43.2 m^3^ of space, with a total surface
area of 235. m^2^ & approx floor area of 108. m^2^.
upper_void describes ceiling void over radiator rooms.  
There is 12.000 m^2^ of exposed surface area, 12.000 m^2^ of which is vertical.
Facade opaque is 12.000 m^2^ &   11.1 % of floor area & average U of 0.319 & UA of 3.8272.
Opaque partitions:ceiling:floor 108.00 m^2^.  
 
: A summary of the surfaces in upper_void(18)
 
ID   Area (m^2^)  Azimuth   Elevation  Name          Use          Construction name          Environment other side
---  -----------  --------  ---------  ------------  -----------  -------------------------  ------------------------
  1  4.50           0.      -90.       cor_ceil_a    -            ceiling_rev                 cor_ceil_a:corid_rad
  2  4.50           0.      -90.       cor_ceil_b    -            ceiling_rev                 cor_ceil_b:corid_rad
  3  4.50           0.      -90.       cor_ceil_c    -            ceiling_rev                 cor_ceil_c:corid_rad
  4  4.50           0.      -90.       cor_ceil_d    -            ceiling_rev                 cor_ceil_d:corid_rad
  5  4.50           0.      -90.       cor_ceil_e    -            ceiling_rev                 cor_ceil_e:corid_rad
  6  4.50           0.      -90.       cor_ceil_f    -            ceiling_rev                 cor_ceil_f:corid_rad
  7  13.5           0.      -90.       ceiling_bcr   -            ceiling_rev                 ceiling_bcr:room_master
  8  13.5           0.      -90.       ceiling_radf  -            ceiling_rev                 ceiling_radf:room_slave1
  9  13.5           0.      -90.       ceiling_radw  -            ceiling_rev                 ceiling_radw:room_onoffsh
 10  13.5           0.      -90.       ceiling_flrh  -            ceiling_rev                 ceiling_flrh:floor_heat
 11  13.5           0.      -90.       ceiling_user  -            ceiling_rev                 ceiling_user:room_vave
 12  13.5           0.      -90.       ceiling_warm  -            ceiling_rev                 ceiling_warm:room_tprop
 13  7.20         180.        0.       facade        -            frc_facade                  external
 14  2.40          90.        0.       right         DOOR         insul_frc_facade_heater     external
 15  2.40         270.        0.       left          F-FRAME      insul_frc_facade_heater     external
 16  7.20           0.        0.       back          -            gyp_blk_ptn                 identical environment
 17  108.           0.       90.       upper         -            structure100mm              identical environment
 
The width & height & height above the floor for surfaces
marked as frames or doors or glazing is shown below.
 
: A summary of frames
 
Surface      Width(m)   Height(m)  Above ff  USE
------------ ---------  ---------  --------- -------
right           6.00       0.40      0.00    DOOR
left            6.00       0.40      0.00    F-FRAME
 
: A summary of the MLC areas m^2^
 
MLC name           total     to ambient to other z back-back to ground to similar
------------------ --------- ---------- ---------- --------- --------- ----------
gyp_blk_ptn              7.2       0.0      0.0      0.0       0.0       7.2
ceiling_rev            108.0       0.0    108.0      0.0       0.0       0.0
structure100mm         108.0       0.0      0.0      0.0       0.0     108.0
insul_frc_facade_h       4.8       4.8      0.0      0.0       0.0       0.0
frc_facade               7.2       7.2      0.0      0.0       0.0       0.0
 
All surfaces will receive diffuse insolation (if shading not calculated).  
No shading analysis requested.  
No insolation analysis requested.  
 
 Uses same operations as zone void_low
 
## Areas
 
 
 Project floor area is 553.50m2, wall area is 125.16m2, window area is 63.840m2.
 Sloped roof area is 0.00m2, flat roof area is 0.00m2, skylight area is 0.00m2.
 In contact with ground 0.00m2.
 There is 189.00m2 of outside surface area, 189.00m2 of which is vertical.
 
 Outside walls are 22.612 % of floor area & average U of 0.401 & UA of 50.216 & max MLC thickness 0.190
 Glazing is 11.534 % of floor & 33.778 % facade with average U of 2.811 & UA of 179.43
 
## Constructions  
 Multi-layer constructions referenced in the model.  
 
 
### gyp_blk_ptn
Details of opaque construction: gyp_blk_ptn with an overall thickness of  0.226m.  
In category partitions also shown in menus as: plasterbd dabs 100mm concrete bl  
partition - plasterboard on dabs over 100mm concret block.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     13.0            0.190                   950.              840.                     0.91        0.22       white gypboard : White painted Gypboard (inorganic-porous)
    2   50.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
    3  100.0            0.510                  1400.             1000.                     0.90        0.65       block inner : Block inner (3% mc)
    4   50.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
Int     13.0            0.190                   950.              840.                     0.91        0.22       white gypboard : White painted Gypboard (inorganic-porous)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.186  1.230  1.133 (partition)  1.072  
Kappa (thermal mass value)   132.2  
 
Total area of gyp_blk_ptn is    129.60  
 
 
### gyp_gyp_ptn
Details of opaque construction: gyp_gyp_ptn with an overall thickness of  0.074m.  
In category partitions also shown in menus as: plasterboard on 50mm studs  
partition - plasterboard on 50mm studs with no acoustic treatment.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     12.0            0.190                   950.              840.                     0.91        0.22       white gypboard : White painted Gypboard (inorganic-porous)
    2   50.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
Int     12.0            0.190                   950.              840.                     0.91        0.22       white gypboard : White painted Gypboard (inorganic-porous)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  2.144  2.292  1.975 (partition)  1.798  
Kappa (thermal mass value)    19.2  
 
Total area of gyp_gyp_ptn is    177.36  
 
 
### door
Details of opaque construction: door with an overall thickness of  0.025m.  
In category doors also shown in menus as: solid wood door 25mm  
solid wood oak door 25mm.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1   25.0            0.190                   700.             2390.                     0.90        0.65       oak : Oak (radial cut)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  3.316  3.682  2.928 (partition)  2.554  
Kappa (thermal mass value)    20.9  
 
Total area of door is     27.84  
 
 
### dbl_glz  
Details of transparent construction dbl_glz with DCF7671_06nb optics and thickness of  0.024m.  
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext      6.0            0.760                  2710.              837.                     0.83        0.05       plate glass : Plate glass with placeholder single layer optics
    2   12.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
Int      6.0            0.760                  2710.              837.                     0.83        0.05       plate glass : Plate glass with placeholder single layer optics
 
ISO 6946 U values (horiz/upward/downward heat flow)=  2.811  3.069  2.527 (partition)  2.243  
Kappa (thermal mass value)    27.2  
 
 Clear float 76/71,     6mm, no blind: with id of: DCF7671_06nb
 with 3 layers [including air gaps] and visible trn: 0.76
 
: Direct transmission @deg
 
   0     40    55    70    80
   ----- ----- ----- ----- -----
   0.611 0.583 0.534 0.384 0.170
 
: Absorption @deg
 
 Layer 0     40    55    70    80
 ----- ----- ----- ----- ----- -----
    1    0.157  0.172  0.185  0.201  0.202
    2    0.001  0.002  0.003  0.004  0.005
    3    0.117  0.124  0.127  0.112  0.077
 
Total area of dbl_glz is    117.60  
 
 
### PH_alu_frame
Details of opaque construction: PH_alu_frame with an overall thickness of  0.079m.  
In category frames also shown in menus as: alum Passive House frame U=0.87  
A composite aluminium Passive House grade window frame with air gap resistances set to give U of
0.87
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext      3.0          210.000                  2700.              880.                     0.82        0.72       grey cotd alum : Grey coated aluminium
    2    8.0            -                       -                -                         -           -          air gap resistance  0.06 0.06 0.06
    3    3.0          210.000                  2700.              880.                     0.22        0.20       aluminium : Aluminium
    4    8.0            -                       -                -                         -           -          air gap resistance  0.06 0.06 0.06
    5    3.0          210.000                  2700.              880.                     0.22        0.20       aluminium : Aluminium
    6   40.0            0.050                    15.             1000.                     0.90        0.70       EPS k 0.05 : EPS k=0.05 (non-hygroscopic)
    7    3.0          210.000                  2700.              880.                     0.22        0.20       aluminium : Aluminium
    8    8.0            -                       -                -                         -           -          air gap resistance  0.06 0.06 0.06
Int      3.0          210.000                  2700.              880.                     0.82        0.72       grey cotd alum : Grey coated aluminium
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.870  0.893  0.840 (partition)  0.806  
Kappa (thermal mass value)    35.6  
 
Total area of PH_alu_frame is      0.00  
 
 
### sash_fr92mm
Details of opaque construction: sash_fr92mm with an overall thickness of  0.092m.  
In category frames also shown in menus as: sash window frame 92m thick  
A wood frame for traditional windows 92mm thick made from generic softwood.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1   92.0            0.130                   630.             2760.                     0.90        0.65       softwood : Softwood (generic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.139  1.180  1.090 (partition)  1.033  
Kappa (thermal mass value)    80.0  
 
Total area of sash_fr92mm is     22.80  
 
 
### ceiling
Details of opaque construction: ceiling linked to ceiling_rev with an overall thickness of  0.110m.  
In category ceil_floor also shown in menus as: suspended acoustic ceiling acous  
A mineral time with 100mm acoustic treatment. For use as a suspended ceiling. To be referenced
from room. Reversed version is ceiling_rev
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext    100.0            0.040                   250.              840.                     0.90        0.30       glasswool : Glasswool (generic) (non-hygroscopic)
Int     10.0            0.030                   290.             2000.                     0.90        0.60       ceiling mineral : Ceiling acoustic tile (mineral fibre based)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.333  0.336  0.329 (partition)  0.323  
Kappa (thermal mass value)     0.0  
 
Total area of ceiling is    108.00  
 
 
### ceiling_rev
Details of opaque construction: ceiling_rev linked to ceiling with an overall thickness of  0.110m.  
In category ceil_floor also shown in menus as: rev suspended acoustic ceiling  
A mineral time with 100mm acoustic treatment. For use as a suspended ceiling. To be referenced
from ceiling void. Reversed version is ceiling
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     10.0            0.030                   290.             2000.                     0.90        0.60       ceiling mineral : Ceiling acoustic tile (mineral fibre based)
Int    100.0            0.040                   250.              840.                     0.90        0.30       glasswool : Glasswool (generic) (non-hygroscopic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.333  0.336  0.329 (partition)  0.323  
Kappa (thermal mass value)     0.0  
 
Total area of ceiling_rev is    216.00  
 
 
### susp_floor
Details of opaque construction: susp_floor linked to susp_flr_re with an overall thickness of  0.219m.  
In category ceil_floor also shown in menus as: carpeted intermed void->room  
A commercial concrete floor structure with carpet cast on steel shuttering. For use over a ceiling
void.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext      6.0            0.060                   186.             1360.                     0.90        0.60       Wilton : Wilton weave wool carpet (organic-hygroscopic)
    2   19.0            0.150                   800.             2093.                     0.91        0.65       chipboard : Chipboard
    3   50.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
    4  140.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
Int      4.0           50.000                  7800.              502.                     0.12        0.20       steel : Steel
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.500  1.570  1.415 (partition)  1.321  
Kappa (thermal mass value)   147.3  
 
Total area of susp_floor is      6.75  
 
 
### susp_flr_re
Details of opaque construction: susp_flr_re linked to susp_floor with an overall thickness of  0.219m.  
In category ceil_floor also shown in menus as: carpeted intermed room->void  
A commercial concrete floor structure with carpet cast on steel shuttering. For use in the room
over a ceiling void.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext      4.0           50.000                  7800.              502.                     0.12        0.20       steel : Steel
    2  140.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
    3   50.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
    4   19.0            0.150                   800.             2093.                     0.91        0.65       chipboard : Chipboard
Int      6.0            0.060                   186.             1360.                     0.90        0.60       Wilton : Wilton weave wool carpet (organic-hygroscopic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.500  1.570  1.415 (partition)  1.321  
Kappa (thermal mass value)   142.9  
 
Total area of susp_flr_re is      6.75  
 
 
### steel_pl_3mm
Details of opaque construction: steel_pl_3mm with an overall thickness of  0.003m.  
In category fittings also shown in menus as: white steel panel 3mm  
Used for furniture or in the cases of fittings or equipment.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    3.0           40.000                  7800.              502.                     0.82        0.30       white ptd steel : White painted steel
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.880  7.139  4.760 (partition)  3.845  
Kappa (thermal mass value)     5.9  
 
Total area of steel_pl_3mm is     11.61  
 
 
### collector_pl
Details of opaque construction: collector_pl with an overall thickness of  0.003m.  
In category fittings also shown in menus as: black copper panel 3mm  
black coated copper plate for solar collectors or other equipment such as boiler combustion
chambers.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    3.0          200.000                  8900.              418.                     0.52        0.96       black_coated_copper : black_coated_copper coated for solar absorption eq
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.882  7.142  4.762 (partition)  3.846  
Kappa (thermal mass value)     5.6  
 
Total area of collector_pl is      0.00  
 
 
### sensor_case
Details of opaque construction: sensor_case with an overall thickness of  0.002m.  
In category fittings also shown in menus as: ABS shell for control equipment  
Used for thermostat shell or furniture or other office equipment.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    1.7            0.250                  1020.             1400.                     0.90        0.60       ABS_case : ABS case (Acrylonitrile Butadiene Styrene) (www.matweb.com) (
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.656  6.812  4.613 (partition)  3.748  
Kappa (thermal mass value)     1.2  
 
Total area of sensor_case is      0.00  
 
 
### circuit_bd
Details of opaque construction: circuit_bd with an overall thickness of  0.002m.  
In category fittings also shown in menus as: pcb-board for control equipment  
Used within controls or office equipment to represent internal mass.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    1.7            0.323                  1770.              695.                     0.90        0.75       pcb-board : pcb-board based on FR4 with a thin layer of copper from Soli
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.706  6.884  4.645 (partition)  3.770  
Kappa (thermal mass value)     1.0  
 
Total area of circuit_bd is      1.48  
 
 
### upholstery
Details of opaque construction: upholstery with an overall thickness of  0.035m.  
In category fittings also shown in menus as: upholstery with layers of felt  
Used to represent upholstery made from layers of dense fabric and wool fibre stuffing.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext      5.0            0.040                   160.             1360.                     0.90        0.65       wool felt underlay : Wool felt underlay (organic-hygroscopic)
    2   25.0            0.060                   198.             1360.                     0.90        0.60       sheeps wool : Sheeps wool (simulated)
Int      5.0            0.040                   160.             1360.                     0.90        0.65       wool felt underlay : Wool felt underlay (organic-hygroscopic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  1.195  1.240  1.141 (partition)  1.079  
Kappa (thermal mass value)     0.0  
 
Total area of upholstery is     10.52  
 
 
### corian_count
Details of opaque construction: corian_count with an overall thickness of  0.020m.  
In category fittings also shown in menus as: non-porous countertop surface  
Used to represent the solid homogeneous non-porous surfacing of office furniture or kitchen
cabinets.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1   20.0            1.012                  1750.              771.                     0.80        0.40       corian : corian is a solid homogeneous non-porous surfacing of natural m
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.270  6.259  4.352 (partition)  3.574  
Kappa (thermal mass value)    13.5  
 
Total area of corian_count is     22.51  
 
 
### IT_case
Details of opaque construction: IT_case with an overall thickness of  0.003m.  
In category fittings also shown in menus as: dark ABS shell for equipment  
Used for dark casings (ABS) of office equipment or furniture.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    2.7            0.250                  1020.             1400.                     0.90        0.90       dark_abs_case : dark_abs_case dark grey ABS (Acrylonitrile Butadiene Sty
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.531  6.631  4.529 (partition)  3.693  
Kappa (thermal mass value)     1.9  
 
Total area of IT_case is      1.77  
 
 
### furn_wd10mm
Details of opaque construction: furn_wd10mm with an overall thickness of  0.010m.  
In category fittings also shown in menus as: oak shelves or furniture (10mm)  
Used to represent 10mm wooden shelves and case for book storage, furniture etc.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1   10.0            0.190                   700.             2390.                     0.90        0.65       oak : Oak (radial cut)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  4.492  5.191  3.808 (partition)  3.199  
Kappa (thermal mass value)     8.4  
 
Total area of furn_wd10mm is     12.00  
 
 
### steel_gr_3mm
Details of opaque construction: steel_gr_3mm with an overall thickness of  0.003m.  
In category fittings also shown in menus as: grey steel panel 3mm  
Used for furniture or in the cases of fittings or equipment.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1    3.0           40.000                  7800.              502.                     0.82        0.45       beige ptd steel : Beige painted steel
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.880  7.139  4.760 (partition)  3.845  
Kappa (thermal mass value)     5.9  
 
Total area of steel_gr_3mm is      3.65  
 
 
### file_papers
Details of opaque construction: file_papers with an overall thickness of  0.300m.  
In category fittings also shown in menus as: book paper layers on shelves  
Used to represent large paper books and files 300mm thick on a shelf or in a filing cabinet.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext    100.0            0.100                   720.             1300.                     0.90        0.65       book_paper : book_paper .72 g/cc from paperonweb.com engineering toolbox
    2  100.0            0.060                   620.             1300.                     0.90        0.60       news_paper : news_paper .62g/cc on paperonweb.com engineering toolbox ot
Int    100.0            0.100                   720.             1300.                     0.90        0.65       book_paper : book_paper .72 g/cc from paperonweb.com engineering toolbox
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.261  0.263  0.258 (partition)  0.255  
Kappa (thermal mass value)    93.6  
 
Total area of file_papers is     11.61  
 
 
### booksonshlf
Details of opaque construction: booksonshlf with an overall thickness of  0.210m.  
In category fittings also shown in menus as: paper-back books on shelves  
Used to represent smaller paper books and files 210mm thick on a shelf or in a filing cabinet.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1  210.0            0.100                   720.             1300.                     0.90        0.65       book_paper : book_paper .72 g/cc from paperonweb.com engineering toolbox
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.441  0.446  0.433 (partition)  0.424  
Kappa (thermal mass value)    93.6  
 
Total area of booksonshlf is      0.00  
 
 
### stuffonshelf
Details of opaque construction: stuffonshelf with an overall thickness of  0.210m.  
In category fittings also shown in menus as: mix of books clutter on shelves  
Used to represent a mix of books and boxes 210mm thick on a shelf or in a filing cabinet.
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1  210.0            0.100                   480.             1300.                     0.90        0.60       shelf_clutter : shelf_clutter mix of books magazines papers on typical s
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.441  0.446  0.433 (partition)  0.424  
Kappa (thermal mass value)    62.4  
 
Total area of stuffonshelf is     18.60  
 
 
### slate_screed_rev
Details of opaque construction: slate_screed_rev linked to slate_screed with an overall thickness of  0.040m.  
In category ceil_floor also shown in menus as: tile over screed_rev struc->rm  
screed_rev used from within a thin zone upper layer struc->room
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     20.0            2.000                  2700.              753.                     0.95        0.85       Slate tile : Slate tile (inorganic-porous)
Int     20.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.147  6.087  4.268 (partition)  3.518  
Kappa (thermal mass value)    27.4  
 
Total area of slate_screed_rev is      6.75  
 
 
### slate_screed
Details of opaque construction: slate_screed linked to slate_screed_rev with an overall thickness of  0.040m.  
In category ceil_floor also shown in menus as: tile over screed rm->struc  
screed used in room above a heated screed (thin zone upper layer) room->struc
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     20.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
Int     20.0            2.000                  2700.              753.                     0.95        0.85       Slate tile : Slate tile (inorganic-porous)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  5.147  6.087  4.268 (partition)  3.518  
Kappa (thermal mass value)    40.7  
 
Total area of slate_screed is      6.75  
 
 
### structure100mm
Details of opaque construction: structure100mm with an overall thickness of  0.100m.  
In category ceil_floor also shown in menus as: 100mm concrete structure  
structure is structural floor of 100mm concrete
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
    1  100.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
 
ISO 6946 U values (horiz/upward/downward heat flow)=  4.142  4.730  3.553 (partition)  3.017  
Kappa (thermal mass value)    68.6  
 
Total area of structure100mm is    108.00  
 
 
### slate_scr_struc_rev
Details of opaque construction: slate_scr_struc_rev with an overall thickness of  0.160m.  
In category project specific also shown in menus as: slate_scr_struc void->room  
slate_scr_struc_rev slate over screed over 100mm concrete slab layer struc->room
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     20.0            2.000                  2700.              753.                     0.95        0.85       Slate tile : Slate tile (inorganic-porous)
    2   40.0            1.400                  2100.              650.                     0.91        0.65       cement screed : Cement screed (inorganic-porous)
Int    100.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
 
ISO 6946 U values (horiz/upward/downward heat flow)=  3.571  4.000  3.125 (partition)  2.703  
Kappa (thermal mass value)   137.0  
 
Total area of slate_scr_struc_rev is     94.50  
 
 
### insul_frc_facade_heater
Details of opaque construction: insul_frc_facade_heater with an overall thickness of  0.190m.  
In category project specific also shown in menus as: insul_frc_facade embed heater  
insul_frc_facade_heater concrete panel over insulation with added pipes and fermacell
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     20.0            0.900                  1950.              840.                     0.90        0.65       Glass reinf conc : Glass fibre reinforced concrete
    2  100.0            0.040                    12.              840.                     0.90        0.65       glass fibre quilt : Glass Fibre Quilt (non-hygroscopic)
    3   50.0            0.800                  1800.             1100.                     0.91        0.70       lime cement plaster : lime cement plaster from IBO PassivHaus (inorganic
Int     20.0            0.830                  1400.              920.                     0.91        0.40       White_RK38_baumat_lime_plaster : White_RK38_baumat_lime_plaster same as
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.360  0.364  0.355 (partition)  0.349  
Kappa (thermal mass value)   157.5  
 
Total area of insul_frc_facade_heater is     54.90  
 
 
### slate_over_struc room>void
Details of opaque construction: slate_over_struc room>void linked to slate_scr_struc_rev with an overall thickness of  0.160m.  
In category project specific also shown in menus as: slate_scr_struc room->void  
slate_scr_struc_rev slate over screed over 100mm concrete slab layer room->structure
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext    100.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
    2   40.0            1.400                  2100.              650.                     0.91        0.65       cement screed : Cement screed (inorganic-porous)
Int     20.0            2.000                  2700.              753.                     0.95        0.85       Slate tile : Slate tile (inorganic-porous)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  3.571  4.000  3.125 (partition)  2.703  
Kappa (thermal mass value)   150.1  
 
Total area of slate_over_struc room>void is     94.50  
 
 
### frc_facade
Details of opaque construction: frc_facade with an overall thickness of  0.184m.  
In category project specific also shown in menus as: frc_facade  
frc_facade  GFR concrete over insulation and double fermacell
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     20.0            0.900                  1950.              840.                     0.90        0.65       Glass reinf conc : Glass fibre reinforced concrete
    2   20.0            -                       -                -                         -           -          air gap resistance  0.17 0.17 0.17
    3  120.0            0.040                    12.              840.                     0.90        0.65       glass fibre quilt : Glass Fibre Quilt (non-hygroscopic)
Int     24.0            0.360                  1150.             1000.                     0.91        0.22       gypsum_fibreboard : Fermacell gypsum fibreboard IBR report 3001-100 gyps
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.292  0.294  0.288 (partition)  0.284  
Kappa (thermal mass value)    60.4  
 
Total area of frc_facade is     58.50  
 
 
### floor_heating_ceil->pipe
Details of opaque construction: floor_heating_ceil->pipe linked to heating_struc_pipe->ceiling with an overall thickness of  0.150m.  
In category project specific also shown in menus as: floor_heating_ceil->pipe  
floor_heating_ceil->pipe 50mm insul over 100mm concrete ceiling void to pipes of a floor heating
system
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext    100.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
Int     50.0            0.040                   105.             1800.                     0.90        0.60       mineral fibre : Mineral fibre (non-hygroscopic)
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.670  0.684  0.653 (partition)  0.632  
Kappa (thermal mass value)   102.8  
 
Total area of floor_heating_ceil->pipe is      7.35  
 
 
### heating_struc_pipe->ceiling
Details of opaque construction: heating_struc_pipe->ceiling linked to floor_heating_ceil->pipe with an overall thickness of  0.150m.  
In category project specific also shown in menus as: floor_heating_pipe->ceiling  
floor_heating_ceil->pipe 50mm insul over 100mm concrete ceiling void to pipes of a floor heating
system
 
Layer  Thickness (mm)  Conductivity (W/(mK))  Density (kg/m^3^)  Specific heat (J/(kgK))  Emissivity  Absorption  Description
-----  --------------  ---------------------  -----------------  -----------------------  ----------  ----------  ------------------------
Ext     50.0            0.040                   105.             1800.                     0.90        0.60       mineral fibre : Mineral fibre (non-hygroscopic)
Int    100.0            1.400                  2100.              653.                     0.90        0.65       heavy mix concrete : Heavy mix concrete
 
ISO 6946 U values (horiz/upward/downward heat flow)=  0.670  0.684  0.653 (partition)  0.632  
Kappa (thermal mass value)   102.8  
 
Total area of heating_struc_pipe->ceiling is      7.35  
