# Explicit Plant Empirical Cooling Coil Model

This exemplar contains a single zone with an explicit plant network. All surfaces have constant temperature boundaries (40 oC). The purpose of this exemplar is to demonstrate the use of two explicit plant components:

    - CMP 144, an empirical cooling coil model
    - CMP 145, a moist air flow source

The following provides brief descriptions of the components and their inputs.

## Cooling Coil Model Inputs

The cooling coil model encompasses the evaporator and outdoor unit. The blower is expected to be modelled separately in the plant network.

The cooling coil model requires the following inputs:
    - Rated net cooling capacity (W)
        - This is the cooling capacity rated at evaporator entering wetbulb (EWB) of 67 oF (19.4 oC) and condenser inlet temperature of 95 oF (35 oC), hereafter referred to as the rating conditions. It should be the net capacity with the blower motor heat subtracted.
    - Net rated SHR
        - The sensible heat ratio rated at rating conditions. It should be the ratio of net sensible cooling to net total, where net implies the blower motor heat has been subtracted
    - Net rated COP
        - The COP at rating conditions. It should be the ratio of Total net cooling output to total net system energy input. Again the net cooling indicates blower motor heat has been subtracted. The net system energy input is the energy input of the entire system *minus* the blower motor input.
    - Rated air volume flow rate
        - the flow rate through the evaporator at rating conditions.

The remainder of the inputs are coefficients to performance curve fits, one for the total cooling capacity and the other for energy input ratio (EIR, which is just the inverse of COP). The first set of coefficients are for total cooling capacity and has the form:

    `T_cap_net_ratio = a0 + a1*EWB + a2*EWB^2 + a3*Tout + a4*Tout^2 + a5*FlowRatio + a6*FlowRatio^2 + a7*EWB*Tout*FlowRatio`

where `EWB` is the entering wetbulb temperature, `Tout` is the temperature of the air entering the condenser, and `FlowRatio` is the ratio of the flow rate entering the evaporator to the flow rate at the rating condition. Similarly the fit for the EIR is:

    `EIR_net_ratio = a0 + a1*EWB + a2*EWB^2 + a3*Tout + a4*Tout^2 + a5*FlowRatio + a6*FlowRatio^2 + a7*EWB*Tout*FlowRatio`

An example script written in R is provided in `fitACdata.R`. It is set to load the example data in `AC_Fit_Data_v2.csv`. The data in `AC_Fit_Data_v2.csv` was derived from manufacturer reported data. For each `EWB`, `Tout`, and `FlowRatio` test point provided by the manufacturer corresponding `T_cap_net_ratio` and `EIR_net_ratio` values were calculated. `T_cap_net_ratio` is the ratio of the net cooling capacity at that operating point divided by the net cooling capacity at rating conditions. `EIR_net_ratio` is the `EIR` at the current operating point divided by `EIR` at rating conditions.

The model has one control variable that acts as and ON/OFF toggle. There is currently no functionality of part-load performance; the device is either ON or OFF for the duration of the timestep.

## Moist Air Flow Source

The moist air flow source was created as a way to test the cooling coil. It has three control variables:
    1. Temperature
    2. Dry air mass flow
    3. Moisture flow

In the current exemplar only the dry air flow is being controlled. The temperature can be controlled by changing actuator data item 3 from 2 (what it is currently) to 1. Similarly the moisture flow can be controlled by changing it to 3. The model was implemented such that it can be the start of an `open loop`; i.e., it doesn't need to be connected to a sending component.

In the current exemplar it is set to control the mass flow and toggles ON and OFF with the cooling coil. The temperature is set to 26.7 oC and moisture flow of 0.005087 kg/s. The dry air flow when on is 0.453 kg/s which is roughly 377 L/s or 800 CFM. Taken together this provides outlet conditions of 800 CFM with a wetbulb temperature of 19.4 oF. The component does not permit moisture flow if there is no mass flow.

## Testing

The exemplar model inputs were derived from a commercially-available unit. The moist air source provides rating evaporator inlet conditions. A temporal data file (TDF) is used to set outdoor drybulb temperature which is used as condenser inlet drybulb temperature, and varies the temperature to correspond with different test conditions (75, 85, 95, 105, 115, and 125 oF). DISCLAIMER: The user is cautioned to always check and validate their own implementation of the model and to use at their own risk. This exemplar may be used to isolate and test the cooling coil model. The testing parameters, and where they may be adjusted, are described here:
    - Evaporator inlet temperature (currently 26.7 oC) is set in the `nets/Explicit_Cooling_Coil.pln` file
    - Evaporator inlet moisture flow (currently 0.005087 kg/s) is set in the `nets/Explicit_Cooling_Coil.pln` file
    - Evaporator inlet dry air flow (currently 0.45300 kg/s) is set in the `ctl/Explicit_Cooling_Coil.ctl` file
        - combined this yields an evaporator flow rate of ~800 CFM with an EWB of 19.4 oC.
    - Condenser inlet temperature is specified in the temporal data file `nets/Explicit_Cooling_Coil_temporal.tdfa` in the `DBTEXTT` data field

The boundary temperatures of the surfaces, set in the `cfg/Explicit_Cooling_Coil.cnn` file, may need to be increased of decreased to induce a cooling load on the zone.