*CONTROL
*cdoc Represents an initial optimal start controller (4 AM initial guess) to reach 20C +- 1C at 8h00 via a 300W heating input. Cooling not enabled. Loop 1 is for manager_a and manager_b and loop 2 for the corridor.
*building
*zdoc It has been calibrated to work with a rewind from 4AM to 2AM at 20 time steps per hour. A basic control is used after ideal startup.
*scope HEATCOOL    
   2                        # number of loops
*loop   1 offices optim start
    0    0    0    0        # senses the temperature of the current zone.
    0    0    0             # actuates air point of the current zone
    1                       # all day types have same control
    1  365    3             # valid Sun-01-Jan - Sun-31-Dec, periods in weekdays
    0   15   0.000   7.     # ctl type, law (opt. start logic ctl), start @, data items
  300.000 20.000 1.000 8.000 0.500 1.000 4.000  # optimum user def start : heating capacity 300.00W heating setpoint 20.00C temperature diff 1.00C desired time of arrival 8.00Hr minimum time difference 0.50Hr starting at 4.00Hr.
    0    1   8.000   7.     # ctl type, law (basic control), start @, data items
  1000.000 0.000 1000.000 0.000 20.000 24.000 0.000  # basic control: heating capacity 1000.0W. cooling capacity 1000.0W. heating setpoint 20.00C cooling setpoint 24.00C.
    0    2  19.000   0.     # ctl type, law (free floating), start @, data items
*loop   2 corridor ideal
    0    0    0    0        # senses the temperature of the current zone.
    0    0    0             # actuates air point of the current zone
    1                       # all day types have same control
    1  365    3             # valid Sun-01-Jan - Sun-31-Dec, periods in weekdays
    0    2   0.000   0.     # ctl type, law (free floating), start @, data items
    0    1   7.000   7.     # ctl type, law (basic control), start @, data items
  1500.000 0.000 1500.000 0.000 18.000 26.000 0.000  # basic control: heating capacity 1500.0W. cooling capacity 1500.0W. heating setpoint 18.00C cooling setpoint 26.00C.
    0    2  19.000   0.     # ctl type, law (free floating), start @, data items
# Function:Zone links
 1,1,2
