/* map display with locaton return on xhair pick
 * reads in exrep files and scans a file of city
 * names and locations.  See map.1 for details of
 * how it works.
 */
#include <stdio.h>
#include <fcntl.h>
#include </usr/esru/include/wwinfo.h>

char*	getenv();

main (argc, argv)
int	argc;
char**	argv;
 {
/* xs & ys are scaling factors from pixels to seconds.
 * x_org is the pixels from left edge to 0deg,
 * y_org is (probably) the pixels from equator to bottom edge of map, so that:
 *   seconds long = (pixel_x - x_org) * scale
 *   seconds lat = (bottom_pixel - pixel_y - y_org) * scale 
 */
 	static char *menu[] = { "Quit", NULL };
  	long x, y, xx, yy, x_org = 152, y_org = -493, xs = 250, ys = 250;
 	int n, z, style;
	int oneshot = 0, rtnsecs = 0;
	char	*chp, mapname[20], *mappath, cityname[40];
	int	fd;
	FILE*	fp;
	exrep	ex;
	

	wwstartup();
	strcpy(mapname,"europe.exrep");	/* assumed defult map */
	mappath = getenv("MAP_HOME");	/* use environment variable if set */
	if (mappath)
		chdir(mappath);
	else
		chdir("/usr/esru/ife/lib/maps");

	for ( argv++ ; --argc ; argv++ ) {
		chp = *argv;
		if (*chp++ != '-') {	/* passing file name does not yet work */
			strcpy(mapname, ++argv);
			x_org = atoi(++argv);
			y_org = atoi(++argv);
		} else
			switch (*chp) {
			    case 'e':	strcpy(mapname, "europe.exrep");
					x_org = 152; y_org = -493;
					xs = 250; ys = 250;
					break;
			    case 'u':	strcpy(mapname, "uk_small.exrep");
					x_org = 405; y_org = -2590;
					xs = 68; ys = 68;
					break;
			    case 'o':	oneshot++;
					break;
			    case 's':	rtnsecs++;
					break;
			};
	};
		

	if((fd = open(mapname,O_RDONLY)) == -1) {
		fprintf(stderr, "No such map available\n");
		exit(1);
	};
	exread(fd, &style, &ex);
	if (!ex.ex_bitmap) {
		fprintf(stderr, "Invalid map format\n");
		exit(1);
	};
	close(fd);

/* Size of image known, open matching window */
 	ddwin = wwxget (ex.ex_bitmap->bm_box, 2, "map", WWINTERNALSIZE);
 	ddbm = ddwin->w_bm;
 	dd->d_line = WWOR;
 	wwstack (WWPUSHOFF);
 	bmbox (ddbm->bm_box, BMCLEARALL);
	bmcopy(ex.ex_bitmap, ex.ex_bitmap->bm_box, BMFROM);
 	wwstack (WWPOP);
 	dd->d_line = WWXOR;

/* scan city names & locations (x & y in seconds lat/long) and 
 * display if they fall within map.
 */
	if(fp = fopen("names.map","r")) 
		while (fscanf(fp, "%d%d %d %s", &z, &x, &y, cityname) == 4) {
			x = (x/xs) + x_org;
			y = ddbm->bm_box.b_bottom - ((y/ys) + y_org);
/* debug....
	fprintf(stderr, "after x %d y %d x_org %d y_org %d xs %d ys %d\n",
		x,y,x_org,y_org,xs,ys);
 */
			if (x > 0  && x < ddbm->bm_box.b_right  &&
		 	   y > 0  && y < ddbm->bm_box.b_bottom) {
				bmbox(boxbuild(x-5, y-5, x+5, y+5),BMCLEAR|BMNOT);
				ftprint(boxshift(ftbox(ddfont, cityname,strlen(cityname),
				  FTPROP),x+6, y-5),cityname,FTPROP|FTCONTROL|FTOVER);
			};
		};
			

 	ipset (IPON);
 	for (;;)
 	 {
 	 	ipwait ();
 	 	if (dd->d_buttons == ITEMBUTTON)
 	 	 {
 	 	 	int ox, oy;
 	 	 	
 	 	 	custack ((cursor *) NULL, WWPUSHOFF);
 	 	 	hairs (dd->d_x, dd->d_y);
 	 		while (dd->d_buttons == ITEMBUTTON)
 	 		 {
 	 		 	ox = dd->d_x; oy = dd->d_y;
	 			ipwait ();
	 			hairs (ox, oy);
	 			hairs (dd->d_x, dd->d_y);
	 		 }
	 		hairs (dd->d_x, dd->d_y);
 	 	 	custack ((cursor *) NULL, WWPOP);
	 		if (dd->d_buttons)
	 		 {
	 		 	wwnoise ();
	 		 	while (dd->d_buttons)
	 		 		ipwait ();
	 		 }
	 		else {
				x = (dd->d_x - x_org) * xs;
				y = (ddbm->bm_box.b_bottom - dd->d_y - y_org) * ys;
/* debug...
	fprintf(stderr, "  \n");
	fprintf(stderr, "x %d ddx %d y %d ddy %d bot %d x_org %d y_org %d xs %d ys %d\n",
		x,dd->d_x,y,dd->d_y,ddbm->bm_box.b_bottom,x_org,y_org,xs,ys);
 */
				if (rtnsecs)
 	 	 			printf ("%d %d\n", x, y);
				else {
					xx = x/3600;  x %= 3600;
					yy = y/3600;  y %= 3600;
					printf ("%d.%d.%d %d.%d.%d\n",
						xx,x/60,x%60, yy,y/60,y%60);
				};
				if (oneshot)   exit(0);
			};
 	 	 }
 	 	else if (dd->d_buttons == MENUBUTTON)
 	 		if (xxpopup (menu, -1) == 0)
 	 			exit (0);
 	 }
 }

hairs (x, y) int x, y;
 {
 	line (0, y, LNMOVEABS); line (ddbm->bm_box.b_right, y, LNDRAWABS);
 	line (x, 0, LNMOVEABS); line (x, ddbm->bm_box.b_bottom, LNDRAWABS);
 }
