/*
 * ww contributed software. ellipse equivalent to bmcircle.
 * From Janet Haswell, via Keith Appleby. RAL 1987.
 */
#include "di.h"
static int how,fillflag;
static int lasty;
static int plotpoint,changelasty;
PRIVATE void plot();
PRIVATE void fillellipse(x,y,r1,r2)int x, y;int r1, r2;{
	register int tmpx,tmpy;
	register int pi;
	register int condition;
	int R1 = r1 * r1;
	int R14 = 4 * R1;
	int R2 = r2 * r2;
	int R24 = 4 * R2;
	int i1, i2;

	fillflag = 1;

	changelasty=1;
	lasty=-1;

	tmpx=0;
	tmpy=r2;

	condition = r2 * R1;
	pi = R1 + R24 - 2 * condition;
	i1 = 6 * R2;
	i2 = 4 * condition;

	while ( condition >= 0 )
	{
		/* plot(tmpx,tmpy,o); */
		if ( pi < 0)
		{
			pi += i1;
		}
		else
		{
			plot(tmpx,tmpy,x,y);
			i2 -= R14;
			pi += i1 - i2;
			tmpy--;
			condition -= R1;
		}
		tmpx++;
		i1 += R24;
		condition -= R2;
	}
	tmpx=r1;
	tmpy=0;

	condition =  r1 * R2;
	pi = R2 - R14 - 2 * condition;
	i1 = 6 * R1;
	i2 = 4 * condition;

	while ( condition > 0 )
	{
		plot(tmpx,tmpy,x,y);
		if (pi<0)
		{
			pi += i1;
		}
		else
		{
			i2 -= R24;
			pi += i1 - i2;
			tmpx--;
			condition -= R2;
		}
		tmpy++;
		i1 += R14;
		condition -= R1;
	}
}
PRIVATE void ellipse(x,y,r1,r2)int x,y;int r1,r2;{
	register int tmpx,tmpy;
	register int pi;
	register int condition;
	int R1 = r1 * r1;
	int R14 = 4 * R1;
	int R2 = r2 * r2;
	int R24 = 4 * R2;
	int i1, i2;

	fillflag = 0;

	changelasty=1;
	lasty=-1;

	tmpx=0;
	tmpy=r2;

	condition = r2 * R1;
	pi = R1 + R24 - 2 * condition;
	i1 = 6 * R2;
	i2 = 4 * condition;

	while ( condition >= 0 )
	{
		plot(tmpx,tmpy,x,y);
		if ( pi < 0)
		{
			pi += i1;
		}
		else
		{
			i2 -= R14;
			pi += i1 - i2;
			tmpy--;
			condition -= R1;
		}
		tmpx++;
		i1 += R24;
		condition -= R2;
	}

	tmpx=r1;
	tmpy=0;

	condition =  r1 * R2;
	pi = R2 - R14 - 2 * condition;
	i1 = 6 * R1;
	i2 = 4 * condition;

	while ( condition > 0 )
	{
		plot(tmpx,tmpy,x,y);
		if (pi<0)
		{
			pi += i1;
		}
		else
		{
			i2 -= R24;
			pi += i1 - i2;
			tmpx--;
			condition -= R2;
		}
		tmpy++;
		i1 += R14;
		condition -= R1;
	}
}

/*
 *  This routine has been added so that the call to bmdraw is more
 *  obvious.  Now that the X version has been changed to draw lines
 *  without the last point, calls to bmdraw with x1,y1 the same as
 *  x2,y2 caused nothing to be shown
*/
PRIVATE void plotpt (x, y) int x, y; {

	bmdraw(x, y, x, y+1, ddbm, dd->d_line);
}

PRIVATE void plot(x,y,a,b) int x,y;int a,b;{

	int x1, x2, y1, y2;

	plotpoint=!(lasty==y);
	if (changelasty)
	   if (y==lasty-1|lasty==-1) lasty=y;
	   else changelasty=0;
	x1 = a + x;
	x2 = a - x;
	y1 = b + y;
	y2 = b - y;
	if ( fillflag )
	{
	   if ( plotpoint )
	   {
		 bmbox(boxbuild(x2,y1,x1,y1),how);
		 /* y=0 is the centre line of the ellipse and
		    y1 and y2 are identical		    */
		 if ( y )
		  	bmbox(boxbuild(x2,y2,x1,y2),how);
	   }
	}
	else
	{
	 plotpt(x1,y1);
	 if ( y )
	    {
	  	plotpt(x1,y2);
	    }
	 if ( x )
	    {
	 	plotpt(x2,y1);
		if ( y )
	  	{
	 		plotpt(x2,y2);
	  	}
	    }
	}
}

PUBLIC void bmellipse(bm,x,y,a,b,flags)bitmap *bm;int x,y,a,b,flags;{
	if(flags & ~(BMEDGES|BMCLEAR|BMNOTALL|BMNOT|BMCLEARALL))
		wwfail("Unknown flag to xxellipse",);
	if ((a!=0) & (b!=0)) 
	{
		window *savewin = ddwin;
		bitmap *savebm;
		savebm=ddbm;
		ddbm=bm;
		a=abs(a),b=abs(b);
		if(bm->bm_window!=0)
		{
			ddwin = bm->bm_window;
			wwstack(WWPUSHOFF);
		}
		if(flags&(BMCLEARALL|BMNOTALL))
		{
			how=flags&(BMCLEARALL|BMNOTALL);
			fillellipse(x,y,a,b);
		}
		if(flags&(BMCLEAR|BMNOT))
		{
			how=(flags&BMCLEAR)?BMCLEARALL:0;
			if(flags&BMNOT)how |= BMNOTALL;
			if((--a!=0) & (--b!=0))fillellipse(x,y,a,b);
		}
		if(flags&BMEDGES)
		{
			ellipse(x,y,a,b);
		}	
		if(bm->bm_window!=0)
		{
			wwstack(WWPOP);
			ddwin = savewin;
		}
		ddbm = savebm;
	}
}
