/* 
  This program is a minimal DES interaction handler which is associated
  with the application_dialog area of the bb.  It responds to the following
  commands:
  `abort` shuts down,
  `application_dialog	show_petri` <petri network name> to which it appends `_petri`
  `application_dialog	token_move` <place or transition name>
  `application_dialog	store` <design_function> <source_program> <format> <file>
  `application_dialog	application_said	store` <design_function> <source_program> <format> <file>
  `application_dialog	get_data_for` <design_function> <program> <format>
  `application_dialog	new_application` <program> <design_function>
  or `application_dialog abort` or `data_model disconnect ife_datah`.

 In the case of an associated petri network, this is drawn and updated
 according to messages arriving in the application_dialog area.
*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "wwinfo.h"

#define	NULL	0
#define	TRUE	1
#define	FALSE	0
#define	READ	0
#define	WRITE	1
#define	HEAD	0
#define	TAIL	1
#define	ERR	-1
#define		NFONTS 		4

extern char* getenv();
static int	no_files = 0;

FILE *pnf;
int gfx_current_font;           /* standard font  */
static fontinfo *fonts[NFONTS];
static int pdw = 400;		/* petri display area width */
static int pdh = 250;		/* petri display area height */
static int mpdw = 420;		/* maximum petri display area width */
static int mpdh = 300;		/* maximum petri display area height */
static int pc = 0;		/* number of items in petri */
static int last_place = -1;	/* to remember previous token position */
static int zer = 0;		/* variable for passing minimal range checks */
static int title_font = 2;	/* font for titles */
static int std_fnt = 1;		/* font for petri places and text */
static box pb;			/* box for petri display */
static box ac;			/* box to clear up/down arrows */

static  struct {
	char	type[20];	/* type of petri entity */
	char	text[40];	/* text assoc with entity */
	int	x;		/* x position */
	int	y;		/* x position */
	int	m1;		/* miscel data */
	int	m2;		/* miscel data */
} pn_itm[50];

static  struct {
	char	file_desfunc[20];	/* originating design function */
	char	file_source[10];	/* originating application */
	char	file_type[10];		/* type of data in file */
	char	file_name[72];		/* name of data file */
} data_items[20];


/* draw representation of a DES
 */ 
draw_des(ix,iy)		
 int *ix;
 int *iy;
{
 int x = *ix;
 int y = *iy;
  bmellipse(ddbm,x,y,15,8,BMCLEAR |BMEDGES);	/* upper elipse  */
  bmellipse(ddbm,x,y+30,15,8,BMCLEAR |BMEDGES);	/* lower elipse  */
  bmdraw(x-15,y,x-15,y+30,ddbm,WWOR);  /* solid vert line  */
  bmdraw(x+15,y,x+15,y+30,ddbm,WWOR);  /* solid vert line  */
  ftxprint(x-5,y+20,"DES",3,WWCOPY,ddfont,ddbm,0);   /* text   */
}

/* draw an up arrow, where ix & iy are it`s centroid
 */
draw_up(ix,iy)	
 int *ix;
 int *iy;
{
 int x = *ix;
 int y = *iy;
  bmdraw(x,y-4,x+7,y,ddbm,WWOR);
  bmdraw(x+7,y,x+5,y+3,ddbm,WWOR);
  bmdraw(x+5,y+3,x+2,y+1,ddbm,WWOR);
  bmdraw(x+2,y+1,x+2,y+7,ddbm,WWOR);
  bmdraw(x+2,y+7,x-2,y+7,ddbm,WWOR);
  bmdraw(x-2,y+7,x-2,y+1,ddbm,WWOR);
  bmdraw(x-2,y+1,x-5,y+3,ddbm,WWOR);
  bmdraw(x-5,y+3,x-7,y,ddbm,WWOR);
  bmdraw(x-7,y,x,y-4,ddbm,WWOR);
}

/* draw a down arrow, where ix & iy are centroid
 */
draw_down(ix,iy)	
 int *ix;
 int *iy;
{
 int x = *ix;
 int y = *iy;
  bmdraw(x,y+4,x+7,y,ddbm,WWOR);
  bmdraw(x+7,y,x+5,y-3,ddbm,WWOR);
  bmdraw(x+5,y-3,x+2,y-1,ddbm,WWOR);
  bmdraw(x+2,y-1,x+2,y-7,ddbm,WWOR);
  bmdraw(x+2,y-7,x-2,y-7,ddbm,WWOR);
  bmdraw(x-2,y-7,x-2,y-1,ddbm,WWOR);
  bmdraw(x-2,y-1,x-5,y-3,ddbm,WWOR);
  bmdraw(x-5,y-3,x-7,y,ddbm,WWOR);
  bmdraw(x-7,y,x,y+4,ddbm,WWOR);
}

/* clear an arrow, where ix & iy are it`s centroid
 */
clear_arrow(ix,iy,size)
 int *ix;
 int *iy;
 int size;
{
 int x = *ix;
 int y = *iy;

 ac.b_top = y - size; ac.b_bottom = y + size;
 ac.b_left = x - size; ac.b_right = x + size;
 bmbox(ac,BMCLEARALL);        /* clear this region of space  */
}

/* update display after reciept of a get_data_for message from the bb
 */
inform_get(desfunc,type,fname)
  char *desfunc;
  char *type;
  char *fname;
{
  char text[124];
  int tfl,xarow,yarow;
  int xdes,ydes;

  strcpy(text,"                                                               ");
  tfl = strlen(text);
  ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 10,
	text,tfl,WWCOPY,ddfont,ddbm,0);   /* clear */	
  strcpy(text," ");
  sprintf(text," Get_data: DTF %s formated as %s in %s\0",desfunc,type,fname);
  tfl = strlen(text);
  ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 10,
	text,tfl,WWCOPY,ddfont,ddbm,0);   /* get msg */
	
  xdes = ddbm->bm_box.b_left + 30;	/* re-display des */
  ydes = ddbm->bm_box.b_bottom - 40;
  draw_des(&xdes,&ydes);
  xarow = ddbm->bm_box.b_left + 30;	/* draw get arrow */
  yarow = ddbm->bm_box.b_bottom - 60;
  clear_arrow(&xarow,&yarow,7);
  draw_up(&xarow,&yarow);
}

/* update the display after reciept of a store message from the bb
 */
inform_store(src_desfunc,type,fname)
  char *src_desfunc;
  char *type;
  char *fname;
{
  char text[124];
  int tfl,xarow,yarow;
  int xdes,ydes;

  strcpy(text,"                                                           ");
  tfl = strlen(text);
  ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 10,
	text,tfl,WWCOPY,ddfont,ddbm,0);   /* clear */	
  strcpy(text," ");
  sprintf(text," Storing: DTF %s with format %s in %s\0",src_desfunc,type,fname); 
  tfl = strlen(text);
  ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 10,
	text,tfl,WWCOPY,ddfont,ddbm,0);   /* store msg */	
	
  xdes = ddbm->bm_box.b_left + 30;	/* re-display des */
  ydes = ddbm->bm_box.b_bottom - 40;
  draw_des(&xdes,&ydes);
  xarow = ddbm->bm_box.b_left + 30;	/* draw store arrow */
  yarow = ddbm->bm_box.b_bottom - 60;
  clear_arrow(&xarow,&yarow,7);
  draw_down(&xarow,&yarow);
}

/* update the token position at a place and related messages
 */
inform_place(src_desfunc,dir)
  char *src_desfunc;
  char dir;   /* direction s = start, f = finish */
{
  char text[124];
  int tfl,xarow,yarow, i;
  int xdes,ydes;

  for (i = pc; i >= 0 ; i--) { /* search for match */
    if (!strncmp(pn_itm[i].type,"place",4))
      if (!strcmp(pn_itm[i].text,src_desfunc)) {
	bmcircle(ddbm,pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y+9,
	  5,BMCLEARALL|BMNOTALL);	/* token */
	strcpy(text,"                                                     ");
	tfl = strlen(text);
	ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 25,
	  text,tfl,WWCOPY,ddfont,ddbm,0);   /* clear */	
	if(dir == 's') {
          strcpy(text," ");
	  sprintf(text," Changing to : DTF %s\0",src_desfunc);
          last_place = i;
	} else if (dir == 'f') {
	  xarow = pb.b_left + pn_itm[i].x;
	  yarow = pb.b_bottom - pn_itm[i].y + 9;
	  clear_arrow(&xarow,&yarow,5);	/* clear that token as leaving... */
          last_place = -1;
        }
	tfl = strlen(text);
	ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 25,
	  text,tfl,WWCOPY,ddfont,ddbm,0);   /* place change msg */
	xdes = ddbm->bm_box.b_left + 30;	/* re-display des */
	ydes = ddbm->bm_box.b_bottom - 40;
	draw_des(&xdes,&ydes);
	xarow = ddbm->bm_box.b_left + 30;	/* clear any previous up/down arrow */
	yarow = ddbm->bm_box.b_bottom - 60;
	clear_arrow(&xarow,&yarow,7);
	break;
      }
  }
}

/* update token position and messages.
 */
at_transition(t_name,dir)
  char *t_name;
  char dir;   /* direction s = start, f = finish */
{
  char text[124];
  int tfl,xarow,yarow, i;
  int xdes,ydes;

  for (i = pc; i >= 0 ; i--) { /* search for match */
    if (!strncmp(pn_itm[i].type,"transition",10))
      if (!strcmp(pn_itm[i].text,t_name)) {
	bmcircle(ddbm,pb.b_left+pn_itm[i].x+9,pb.b_bottom-pn_itm[i].y+9,
	  5,BMCLEARALL|BMNOTALL);	/* token */
	strcpy(text,"                                                     ");
	tfl = strlen(text);
	ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 25,
	  text,tfl,WWCOPY,ddfont,ddbm,0);   /* clear */	
	if(dir == 's') {
          strcpy(text," ");
	  sprintf(text," Moving to transition: %s\0",t_name);
          last_place = i;
	} else if (dir == 'f') {
          strcpy(text," ");
	  sprintf(text," Leaving transition: %s\0",t_name);
          last_place = -1;
        }
	tfl = strlen(text);
	ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 25,
	  text,tfl,WWCOPY,ddfont,ddbm,0);   /* place change msg */
	xdes = ddbm->bm_box.b_left + 30;	/* re-display des */
	ydes = ddbm->bm_box.b_bottom - 40;
	draw_des(&xdes,&ydes);
	xarow = ddbm->bm_box.b_left + 30;	/* clear any previous up/down arrow */
	yarow = ddbm->bm_box.b_bottom - 60;
	clear_arrow(&xarow,&yarow,7);
	break;
      }
  }
}  /*  at_transition */

/* 
 * Clear the pn_itm structure
 */
clear_petri(ipc)	
  int *ipc;
{
  int	lpc = *ipc;
  int	i;

  if(lpc == 0) return;
  for (i = lpc; i >= 0 ; i--) {
    pn_itm[i].x = 0;
    pn_itm[i].y = 0;
    strcpy(pn_itm[i].text," ");
    pn_itm[i].m1 = 0;
    pn_itm[i].m2 = 0;
  }
}

/* ************ Select a font **************** */
winfnt_(n)
 int *n;
{
	ddfont = fonts[*n % NFONTS];
	gfx_current_font = *n;
}

/* ************** Confirm string length *************** */
/*
 Since the string length automaticly passed between Fortran and C
 tends to represent the "defined" string length rather than the actual
 string length here is a bit of code to start at the "defined" end
 and work backwards to find the last non-blank character position.
 This variant of f_to_c_length takes into account case where fortran
 string has not been terminated with a null character and an extra
 check needs to be made to ensure the strlen(msg) does not look
 past the string.
*/
f_to_c_l(msg,f_len,len)
  char    *msg;         /* character string */
  int     *f_len,*len;  /* fortran string length,
                           found position of last non blank character */
{
  int lm, sl, n, found;       /* local string lengths found by test  */
  sl = strlen(msg);
  if( sl == *f_len ){
    n = *f_len;
  } else if( sl > *f_len ) {
    n = *f_len;
  } else if( sl < *f_len ) {
    n = sl;
  }
  found = FALSE;
  while(n > 0 && !found) {
    n--;
    if ( msg[n] != ' ') found = TRUE;
  }
  if (found) {
    lm = n+1;
  } else if (! found && n == 0) {
    lm = 0;
  }
  *len = lm;

} /* f_to_c_l */

/* read_pn reads in a terse description of a petri network
 * and plots it.
 */
read_pn(name,len)
 char *name;
 int len;
{
 int iexp, itm;
 int ilen, ier;
 char outstr[124];
 char word[72];
 char a_start[20], a_spos[5], a_end[20], a_epos[5];
 char text[124];
 int k,w,x1,y1,x2,y2,ia,tfl;
 int done;

  f_to_c_l(name,&len,&ilen);	/* open the file */
  if ( ilen < len ) name[ilen] = '\0';
  fprintf(stderr,"file is %s\n",name);
  if ((pnf = fopen(name,"r"))==NULL) {
    strcpy(text," ");
    sprintf(text,"could not open wwc file %s\n",name);
    tfl = strlen(text);
    ftxprint(ddbm->bm_box.b_left+50,ddbm->bm_box.b_bottom - 10,
	text,tfl,WWCOPY,ddfont,ddbm,0);   /* get msg */
    return;
  }
  done = 0;
  pc = 0;
  bmbox(pb,BMCLEARALL);        /* clear the (default) petri drawing area  */
  do {	/* Read a line from file, skipping & stripping comments */
    iexp = 99; itm = 0; ier = 0;
    cstripc(pnf,outstr,&iexp,&itm,"petri line",&ier);
    k = 0;
    strcpy(word," ");
    cgetw(outstr,&k,word,'-',"type field",&ier);
    if (strncmp(word, "end", 3) == 0) {
       done = 1;
       break;
    } else if (strncmp(word, "size", 4) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pdw,&zer,&mpdw,'W',"width",&ier);
      cgetwi(outstr,&k,&pdh,&zer,&mpdh,'W',"height",&ier);
      strcpy(pn_itm[pc].text," ");
      pn_itm[pc].x = pdw;  pn_itm[pc].y = pdh;
      pn_itm[pc].m1 = 0;   pn_itm[pc].m2 = 0;
      pc = pc + 1;			/* finished with size, increment count */
    } else if (strncmp(word, "network", 7) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"network name",&ier);
      pn_itm[pc].x = 0;    pn_itm[pc].y = 0;
      pn_itm[pc].m1 = 0;   pn_itm[pc].m2 = 0;
      pc = pc + 1;			/* finished with title, increment count */
    } else if (strncmp(word, "title", 5) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pn_itm[pc].x,&zer,&pdw,'W',"x position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].y,&zer,&pdh,'W',"y position",&ier);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"title text",&ier);
      pn_itm[pc].m1 = 0;   pn_itm[pc].m2 = 0;
      pc = pc + 1;			/* finished with title, increment count */
    } else if (strncmp(word, "place", 5) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pn_itm[pc].x,&zer,&pdw,'W',"x position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].y,&zer,&pdh,'W',"y position",&ier);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"text field",&ier);
      pn_itm[pc].m1 = 0;
      pn_itm[pc].m2 = 0;
      pc = pc + 1;			/* finished with this place, increment count */
    } else if (strncmp(word, "text", 4) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pn_itm[pc].x,&zer,&pdw,'W',"x position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].y,&zer,&pdh,'W',"y position",&ier);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"title text",&ier);
      pn_itm[pc].m1 = 0;
      pn_itm[pc].m2 = 0;
      pc = pc + 1;			/* finished with text, increment count */
    } else if (strncmp(word, "transition", 10) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pn_itm[pc].x,&zer,&pdw,'W',"x position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].y,&zer,&pdh,'W',"y position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].m1,&zer,&pdh,'W',"height",&ier);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"transition name",&ier);
      pn_itm[pc].m2 = 0;
      pc = pc + 1;			 /* increment count  */
    } else if (strncmp(word, "doubletransition", 16) == 0) {
      strcpy(pn_itm[pc].type,word);
      cgetwi(outstr,&k,&pn_itm[pc].x,&zer,&pdw,'W',"x position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].y,&zer,&pdh,'W',"y position",&ier);
      cgetwi(outstr,&k,&pn_itm[pc].m1,&zer,&pdh,'W',"height",&ier);
      cgetw(outstr,&k,pn_itm[pc].text,'-',"doubletransition name",&ier);
      pn_itm[pc].m2 = 0;
      pc = pc + 1;			 /* increment count  */
    } else if (strncmp(word, "arrow", 7) == 0) {
/*
 * NOTE: arrows must come after all places and transitions.
 */
      strcpy(pn_itm[pc].type,word);
      strcpy(pn_itm[pc].text," ");
      cgetw(outstr,&k,a_start,'-',"arc start name",&ier);
      cgetw(outstr,&k,a_spos,'-',"arc start position",&ier);
      cgetw(outstr,&k,a_end,'-',"arc end name",&ier);
      cgetw(outstr,&k,a_epos,'-',"arc end position",&ier);
      for (ia = pc; ia >= 0 ; ia--) { /* search for start match */
        if (!strcmp(pn_itm[ia].text,a_start)) {
          tfl = strlen(a_start);
          w = tfl * ddfont->f_width;
          if (!strncmp(pn_itm[ia].type,"transition",10)) {
            x1 = pn_itm[ia].x;  y1 = pn_itm[ia].y;  break;
          } else if (!strncmp(pn_itm[ia].type,"doubletransition",16)) {
            x1 = pn_itm[ia].x;  y1 = pn_itm[ia].y;  break;
          } else if (!strncmp(pn_itm[ia].type,"place",5)) {
            y1 = pn_itm[ia].y;
            if (!strncmp(a_spos,"l",1)) x1 = pn_itm[ia].x -4;
            if (!strncmp(a_spos,"r",1)) x1 = pn_itm[ia].x + w + 4;
            break;
          } 
        }
      }
      for (ia = pc; ia >= 0 ; ia--) { /* search for end match */
        if (!strcmp(pn_itm[ia].text,a_end)) {
          tfl = strlen(a_end);
          w = tfl * ddfont->f_width;
          if (!strncmp(pn_itm[ia].type,"transition",10)) {
            x2 = pn_itm[ia].x;  y2 = pn_itm[ia].y;  break;
          } else if (!strncmp(pn_itm[ia].type,"doubletransition",16)) {
            x2 = pn_itm[ia].x;  y2 = pn_itm[ia].y;  break;
          } else if (!strncmp(pn_itm[ia].type,"place",5)) {
            y2 = pn_itm[ia].y;
            if (!strncmp(a_epos,"l",1)) x2 = pn_itm[ia].x -4;
            if (!strncmp(a_epos,"r",1)) x2 = pn_itm[ia].x +w +4;
            break;
          } 
        }
      }
      pn_itm[pc].x = x1;  pn_itm[pc].y = y1;
      pn_itm[pc].m1 = x2; pn_itm[pc].m2 = y2;
      pc = pc + 1;			/* finished with arrow, increment count */
    } else {
      fprintf(stderr,"unknown word is: %s in : %s\n",word,outstr);
      ier = 1;
    }	
  } while ( ier == 0 || done == 0);
  fclose(pnf);
}

/*
 * plots the current petri network.
 */
draw_pn(ipc)
  int	*ipc;
{
  int lpc = *ipc;
  int tfl,i,half,halfw,ehigh;
  int x;
  int y,y1,y2;

  if(lpc == 0) return;
  bmbox(pb,BMCLEARALL);        /* clear the (default) petri drawing area  */
  for (i = 0; i < lpc; i++) {
    if (strncmp(pn_itm[i].type, "size", 4) == 0) {
      pdw = pn_itm[i].x;
      pdh = pn_itm[i].y;
      pb = ddbm->bm_box;
      pb.b_top = ddbm->bm_box.b_top + 10;
      pb.b_bottom = pb.b_top + pdh;
      pb.b_left = ddbm->bm_box.b_left + 10;
      pb.b_right = pb.b_left + pdw + 10;
      bmbox(pb,BMCLEAR |BMEDGES);        /* draw outer box with edges  */
    } else if (strncmp(pn_itm[i].type, "title", 5) == 0) {
      winfnt_(&title_font);		/* reset the default font to larger size */
      tfl = strlen(pn_itm[i].text);
      ftxprint(pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y,pn_itm[i].text,tfl,WWCOPY,ddfont,ddbm,0);   /* title */	
      winfnt_(&std_fnt);  		/* return to the default font */
    } else if (strncmp(pn_itm[i].type, "place", 5) == 0) {
      tfl = strlen(pn_itm[i].text);
      halfw = (tfl / 2) * ddfont->f_width;
      ehigh = ddfont->f_height+1;
      x = pb.b_left+pn_itm[i].x + halfw +2;
      y = pb.b_bottom-pn_itm[i].y - (ddfont->f_height / 2);
      bmellipse(ddbm,x,y,halfw+8,ehigh,BMCLEAR |BMEDGES);	/* elipse around place  */
      ftxprint(pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y,
	pn_itm[i].text,tfl,WWCOPY,ddfont,ddbm,0);		/* print place name */
    } else if (strncmp(pn_itm[i].type, "text", 4) == 0) {
      tfl = strlen(pn_itm[i].text);
      ftxprint(pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y,
	pn_itm[i].text,tfl,WWCOPY,ddfont,ddbm,0);		/* print text */	
    } else if (strncmp(pn_itm[i].type, "transition", 10) == 0) {
      half = pn_itm[i].m1/2;
      tfl = strlen(pn_itm[i].text);
      ftxprint(pb.b_left+pn_itm[i].x+4,pb.b_bottom-pn_itm[i].y-half,
	pn_itm[i].text,tfl,WWCOPY,ddfont,ddbm,0);			/* print transition name */	
      bmdraw(pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y-half,
	pb.b_left+pn_itm[i].x,pb.b_bottom-pn_itm[i].y+half,ddbm,WWOR);	/* vert line */
    } else if (strncmp(pn_itm[i].type, "doubletransition", 16) == 0) {
      half = pn_itm[i].m1/2;
      tfl = strlen(pn_itm[i].text);
      ftxprint(pb.b_left+pn_itm[i].x+2,pb.b_bottom-pn_itm[i].y-half,
	pn_itm[i].text,tfl,WWCOPY,ddfont,ddbm,0);			/* print transition name */	
      bmdraw(pb.b_left+pn_itm[i].x-1,pb.b_bottom-pn_itm[i].y-half,
	pb.b_left+pn_itm[i].x-1,pb.b_bottom-pn_itm[i].y+half,ddbm,WWOR);	/* vert line */
      bmdraw(pb.b_left+pn_itm[i].x+1,pb.b_bottom-pn_itm[i].y-half,
	pb.b_left+pn_itm[i].x+1,pb.b_bottom-pn_itm[i].y+half,ddbm,WWOR);	/* vert line */
    } else if (strncmp(pn_itm[i].type, "arrow", 5) == 0) {
      y1 = pb.b_bottom-pn_itm[i].y - (ddfont->f_height / 2);
      y2 = pb.b_bottom-pn_itm[i].m2 - (ddfont->f_height / 2);
      bmdraw(pb.b_left+pn_itm[i].x,y1,pb.b_left+pn_itm[i].m1,y2,ddbm,WWOR);	/* arrow */
      bmcircle(ddbm,pb.b_left+pn_itm[i].m1,y2,2,BMCLEARALL|BMNOTALL);		/* mock head */
    }
  }	
}


/* recover product model for the requested tool in the form of a file name */
recover(type,fname)
char *type;
char fname[72];
{
	/* change this, as you can't use the same file name repeatedly */
	extern char* getenv();
	char	*new_name	= "new_file";  
	char    cmd[254];
	char    cmdh[73];
        int	i;

	/* search for exact match 1st */
	for (i = no_files; i >= 0 ; i--)
		if (!strncmp(data_items[i].file_type, type,3)) {
	        	strcpy(fname,data_items[i].file_name);
			return;
                }
	/* no match, so filter */

/* If user wishes an esp product model, scan available items, first
 * looking for zip files which are easy to convert.
 */
	if (!strcmp("esp", type)) {
	  for (i = no_files; i >= 0 ; i--)
	    if (!strncmp(data_items[i].file_type,"zip",3)) {
	      strcpy(fname,data_items[i].file_name);
	      if (fname != NULL) {		/* got it, so filter  */
	        strcpy(new_name,fname);
	        strcat(new_name,".cfg");	/* append " config extension" */
		printf("post\tjournal\tconv_product_model\tzip_to_esp\tvia\tecnv\n");
		strcpy(cmdh,getenv("IFE_HOME"));
		sprintf(cmd,"%ssys/bin/ecnv -if zip -in %s -of esp -out %s\0",cmdh,fname,new_name);
		printf("post\tjournal\trunning\t%s\n",cmd);
		system(cmd);
		strcpy(data_items[no_files].file_desfunc,"archcad");	/* store the design function */
		strcpy(data_items[no_files].file_source,"zip");		/* store the application name */
		strcpy(data_items[no_files].file_type,"esp");		/* store the file format */
		strcpy(data_items[no_files].file_name,new_name);	/* store the file name */
        	printf("post\tjournal\tife_datah storing\tarchcad\tzip\tesp\t%s\n",new_name);
        	printf("post\tjournal\tife_datah latest items %d\n",no_files);
		no_files++;
	        strcpy(fname,new_name);
		return;
	    };
          }

/*  If there are no zip files then look and see if there are any autocad
 *  files available.  In this case run a filter ecnv. 
 */
	  for (i = no_files; i >= 0 ; i--)
	    if (!strncmp(data_items[i].file_type,"autocad",7)) {
	      strcpy(fname,data_items[i].file_name);
	      if (fname != NULL) {
	        strcpy(new_name,fname);
	        strcat(new_name,".cfg");	/* append " cfg extension" */
		printf("post\tjournal\tconv_product_model\tdxf_to_esp\tvia\tecnv\n");
		strcpy(cmdh,getenv("IFE_HOME"));
		sprintf(cmd,"%ssys/bin/ecnv -obs -mm -if dxf -in %s -of esp -out %s\0",cmdh,fname,new_name);
		printf("post\tjournal\trunning\t%s\n",cmd);
		system(cmd);
		strcpy(data_items[no_files].file_desfunc,"archcad");	/* store the design function */
		strcpy(data_items[no_files].file_source,"autocad");	/* store the esp description */
		strcpy(data_items[no_files].file_type,"esp");
		strcpy(data_items[no_files].file_name,new_name);
		no_files++;
        	printf("post\tjournal\tife_datah storing\tarchcad\tautocad\tesp\t%s\n",new_name);
        	printf("post\tjournal\tife_datah latest items %d\n",no_files);
	        strcpy(fname,new_name);
		return;
	    };
          }
	  strcpy(fname,"unknown");
	  return;	/* cant find something to filter */
	};

/* If the user requests a radiance (e2r) description, this is gotten from
 * an esp-r configration file.
 */
	if (!strcmp("radiance", type)) {
	  for (i = no_files; i >= 0 ; i--) 
	    if (!strncmp(data_items[i].file_type,"esp",3)) {
			strcpy(new_name,data_items[i].file_name);
	    }
	    if (new_name != NULL) {
	  	strcpy(fname,new_name);
		return;
	  };
	  strcpy(fname,"unknown");
	  return;		/* cant find something to filter */
	};

/* If the user requests a simulator (esp) description, this is gotten from
 * an esp-r configration file.
 */
	if (!strcmp("simulator", type)) {
	  for (i = no_files; i >= 0 ; i--) 
	    if (!strncmp(data_items[i].file_type,"esp",3)) {
			strcpy(new_name,data_items[i].file_name);
	    }
	    if (new_name != NULL) {
	  	strcpy(fname,new_name);
		return;
	  };
	  strcpy(fname,"unknown");
	  return;		/* cant find something to filter */
	};

/* If the user requests a viewer file, the user can convert from either
 * esp, zip or autocad  files.
 */
	if (!strcmp("viewer", type)) {  
	  for (i = no_files; i >= 0 ; i--)	/* esp to viewer */
	    if (!strncmp(data_items[i].file_type,"esp",3)) {
	    strcpy(fname,data_items[i].file_name);
	    if (fname != NULL) {		/* got it, so filter  */
	      strcpy(new_name,fname);
	      strcat(new_name,".vew");		/* append " vew extension" */
	      printf("post\tjournal\tconv_product_model\tesp_to_view\tvia\tecnv\n");
	      strcpy(cmdh,getenv("IFE_HOME"));
	      sprintf(cmd,"%ssys/bin/ecnv -obs -if esp -in %s -of viewer -out %s\0",cmdh,fname,new_name);
	      printf("post\tjournal\trunning\t%s\n",cmd);
	      system(cmd);
	      strcpy(fname,new_name);
	      return;
	    };
          }

	  for (i = no_files; i >= 0 ; i--)	/* zip to viewer */
	    if (!strncmp(data_items[i].file_type,"zip",3)) {
	    strcpy(fname,data_items[i].file_name);
	    if (fname != NULL) {		/* got it, so filter  */
	       strcpy(new_name,fname);
	       strcat(new_name,".vew");		/* append " vew extension" */
	       printf("post\tjournal\tconv_product_model\tzip_to_view\tvia\tecnv\n");
	       strcpy(cmdh,getenv("IFE_HOME"));
	       sprintf(cmd,"%ssys/bin/ecnv -if zip -in %s -of viewer -out %s\0",cmdh,fname,new_name);
	       printf("post\tjournal\trunning\t%s\n",cmd);
	       system(cmd);
	       strcpy(fname,new_name);
	       return;
	    };
          }

	  for (i = no_files; i >= 0 ; i--)	/* autocad to viewer */
	    if (!strncmp(data_items[i].file_type,"autocad",7)) {
	    strcpy(fname,data_items[i].file_name);
	    if (fname != NULL) {
	       strcpy(new_name,fname);
	       strcat(new_name,".vew");  /* append " vew extension" */
	       printf("post\tapplication_dialog\tconv_product_model\tdxf_to_view\tvia\tecnv\n");
	       strcpy(cmdh,getenv("IFE_HOME"));
	       sprintf(cmd,"%ssys/bin/ecnv -if dxf -in %s -of viewer -out %s\0",cmdh,fname,new_name);
	       printf("post\tjournal\trunning\t%s\n",cmd);
	       system(cmd);
	       strcpy(fname,new_name);
	       return;
	    };
          }
	  strcpy(fname,"unknown");
	  return;	/* cant find something to filter */
	};

/* If user wishes an autocad product model, scan for esp configuration
 * and run ecnv.
 */
	if (!strcmp("autocad", type)) {
	  for (i = no_files; i >= 0 ; i--)
	    if (!strncmp(data_items[i].file_type,"esp",3)) {
	      strcpy(fname,data_items[i].file_name);
	      if (fname != NULL) {	/* got it, so filter  */
	        strcpy(new_name,fname);
	        strcat(new_name,".dxf");  /* append " dxf extension" */
		printf("post\tapplication_dialog\tconv_product_model\tesp_to_autocad\tvia\tecnv\n");
		strcpy(cmdh,getenv("IFE_HOME"));
		sprintf(cmd,"%ssys/bin/ecnv -obs -mm -if esp -in %s -of dxf -out %s\0",cmdh,fname,new_name);	/* generate command */
		printf("post\tjournal\trunning\t%s\n",cmd);
		system(cmd);		/* issue command */
		strcpy(data_items[no_files].file_desfunc,"attribute");	/* store design function */
		strcpy(data_items[no_files].file_source,"esp");		/* store the application */
		strcpy(data_items[no_files].file_type,"autocad");	/* store the file format */
		strcpy(data_items[no_files].file_name,new_name);
		no_files++;
        	printf("post\tjournal\tife_datah storing\tarchcad\tautocad\tautocad\t%s\n",new_name);
        	printf("post\tjournal\tife_datah latest items %d\n",no_files);
	        strcpy(fname,new_name);
		return;
	    };
          }
        };
	strcpy(fname,"unknown");
	return;	/* cant filter for this type */
	
};


main() /* ife_datah */
{
  char str[124];
  char str2[124];
  char area[24],cmd[24],src_desfunc[24];
  char	desfunc[24], type[24], prgn[24], fname[72], t_name[24];
  int i,k,ier,ix;
  int xdes,ydes;
  char *p_name  = "UNKNOWN";	/* bb msg petri file string */
  long int ulx = 690;		/* default initial window position */
  long int uly = 240;
  long int uw = 430;		/* default initial window position */
  long int uh = 370;

  setbuf(stdin,(char*) 0);
  setbuf(stdout,(char*) 0);

  printf("mk_area\tapplication_dialog\n");	/* connect to the bb */
  printf("update_me\tapplication_dialog\n");
  printf("mk_area\tjournal\n");
  fprintf (stderr,"dataH - data handler started\n");
  printf("post\tjournal\tgood entry to ife_datah\n");

/* open a petri & des display window << upgrade option to delay showing graph >> */
  if (wwxget(boxbuild(ulx,uly,ulx+uw,uly+uh),2,"Design process manager",0)==0) exit(1);
	
  fonts[0] = ftload(getenv("EFONT_0"));	/* open some fonts  */
  fonts[1] = ftload(getenv("EFONT_1"));
  fonts[2] = ftload(getenv("EFONT_2"));
  fonts[3] = ftload(getenv("EFONT_3"));

  ipset(IPON);				/* allow keyboard and mouse input */
  dd->d_line = WWCOPY;
  bmbox(ddbm->bm_box,BMCLEARALL);

  winfnt_(&std_fnt);

  ac = ddbm->bm_box;			/* set box for clearing arrows */
  pb = ddbm->bm_box;			/* initial definition of petri display box */
  pb.b_top = ddbm->bm_box.b_top + 10;
  pb.b_bottom = pb.b_top + pdh;
  pb.b_left = ddbm->bm_box.b_left + 10;
  pb.b_right = pb.b_left + pdw + 10;
  bmbox(pb,BMCLEAR |BMEDGES);		/* draw outer box with edges  */

  xdes = ddbm->bm_box.b_left + 30;	/* draw representation of des */
  ydes = ddbm->bm_box.b_bottom - 40;
  draw_des(&xdes,&ydes);

  while(1) {
    printf(">\n");
    gets(str);
    strcpy(str2,str);

    k = 0;
    strcpy(area," ");
    cgetw(str2,&k,area,'-',"area",&ier);
    if (strncmp(area, "abort", 5) == 0) {
        printf("post\tjournal\tife_datah exiting\n");
	exit(0);
    } else if (strncmp(area,"application_said",16)==0) {	/* did application ask for a store? */
        cgetw(str2,&k,cmd,'-',"command",&ier);
	if(strncmp(cmd,"store",5)==0) {			/* store the file detail in data_items */
          cgetw(str2,&k,data_items[no_files].file_desfunc,'-',"design function",&ier);
          cgetw(str2,&k,data_items[no_files].file_source,'-',"source application",&ier);
          cgetw(str2,&k,data_items[no_files].file_type,'-',"file format",&ier);
          cgetw(str2,&k,data_items[no_files].file_name,'-',"file name",&ier);
          printf("post\tjournal\tife_datah storing\t%s\n",str2);
	  inform_store(data_items[no_files].file_desfunc,data_items[no_files].file_type,data_items[no_files].file_name);	/* display store action */
	  no_files++;
       	  printf("post\tjournal\tife_datah latest items %d\n",no_files);
        }
    } else if(strncmp(area,"application_dialog",18)==0) {
      cgetw(str2,&k,cmd,'-',"command",&ier);
      treat_command:
      if (!strcmp(cmd, "abort")) {
         printf("post\tjournal\tife_datah exiting\n");
         exit(0);
      } else if(strncmp(cmd,"store",5)==0) {	/* store the file details in data_items */
        cgetw(str2,&k,data_items[no_files].file_desfunc,'-',"design function",&ier);
        cgetw(str2,&k,data_items[no_files].file_source,'-',"source application",&ier);
        cgetw(str2,&k,data_items[no_files].file_type,'-',"file format",&ier);
        cgetw(str2,&k,data_items[no_files].file_name,'-',"file name",&ier);
        printf("post\tjournal\tife_datah storing\t%s\n",str2);
	inform_store(data_items[no_files].file_desfunc,data_items[no_files].file_type,data_items[no_files].file_name);	/* display store action */
	no_files++;
        printf("post\tjournal\tife_datah latest items %d\n",no_files);
      } else if (strncmp(cmd,"get_data_for",12)==0) {
        cgetw(str2,&k,desfunc,'-',"design function",&ier);
        cgetw(str2,&k,prgn,'-',"application",&ier);
        cgetw(str2,&k,type,'-',"file format",&ier);
	printf("post\tjournal\tife_datah asked for data\t%s\t%s\t%s\n",desfunc,prgn,type);
	strcpy(fname,"unknown");
	recover(type,fname);			/* fname is the matching datafile */
	if (fname != NULL) {
	  printf("post\tjournal\tife_datah retrieving\t%s\t%s\n",type, fname);
	  printf("post\tapplication_dialog\tdata_for\t%s\t%s\t%s\t%s\n",desfunc,prgn,type,fname);
	  inform_get(desfunc,type,fname);
	} else {
	  printf("post\tapplication_dialog\tdata_for\t%s\t%s\t%s\tunknown\n",desfunc,prgn,type);
	}
      } else if (strncmp(cmd,"show_petri",10)==0) {
/*
 * Refresh or re-display petri. The name passed will be the
 * transition facts for the kb, the name of the petri file
 * will be the same name with an extension _petri 
 */
        cgetw(str2,&k,p_name,'-',"petri_name",&ier);
	strcat(p_name,"_petri");  	/* append " _petri extension" */
	clear_petri(&pc);
	pc = 0;				/* reset number of petri items */
	read_pn(p_name,strlen(p_name));	/* read in petri description */
	draw_pn(&pc);			/* draw petri */
	inform_place("start",'s');	/* place token at start */
      } else if (strncmp(cmd,"new_application",15)==0) {
        cgetw(str2,&k,prgn,'-',"pogram_name",&ier);
        cgetw(str2,&k,src_desfunc,'-',"design tool name",&ier);
	draw_pn(&pc);			/* re-draw petri */
	inform_place(src_desfunc,'s');	/* place token at matching DTF name */
      } else if (strncmp(cmd,"finished",8)==0) {
        cgetw(str2,&k,desfunc,'-',"design tool name",&ier);
	inform_place(desfunc,'f');	/* re-place token at matching DTF name */
      } else if (strncmp(cmd,"token_move",10)==0) {
        cgetw(str2,&k,t_name,'-',"token_name",&ier);
	draw_pn(&pc);			/* re-draw petri */
	for (ix = pc; ix >= 0 ; ix--) { /* search for match */
	  if (!strncmp(pn_itm[ix].type,"transition",10)) {
	    if (!strcmp(pn_itm[ix].text,t_name)) at_transition(t_name,'s');	/* place token at transition */
	  } else if (!strncmp(pn_itm[ix].type,"place",5)) {
	    if (!strcmp(pn_itm[ix].text,t_name)) inform_place(t_name,'s');	/* place token at place */ 
	  }
	}
     } else if (strncmp(cmd,"query",5)==0) {	/* list contents */
        printf("post\tjournal\tife_datah query known_items %d\n",no_files);
	for (i = no_files-1; i >= 0 ; i--)
          printf("post\tjournal\tife_datah item \t%s\t%s\t%s\t%s\n",
		data_items[i].file_desfunc,data_items[i].file_source,
		data_items[i].file_type,data_items[i].file_name);
      } else if (strncmp(cmd,"application_said",16)==0) {	/* shift this token... */
        cgetw(str2,&k,cmd,'-',"command",&ier);
	goto treat_command;
      }
    }
  };
}
