/*
 * Ask for a schema name and return.  If there is a quoted string in the command
 * line use this as the prompt.
 */
#include "wwinfo.h"
#include 	<stdio.h>

#define		NFONTS 		4
#define 	MAXIMUM<(x,y)	((x > y) ? x : y)

static fontinfo *fonts[NFONTS];
int gfx_current_font;           /* standard font                   */

static 	box	msgbx, askbx, helpbx;
static  box	fbb; /* feedback box background, tutorial, setup */
static  box     querb,defb,okb; /* boxes for querry help, default,confirm  */
static int dialogue_lines = 0;  /* number of lines of text in dialogue box */
static int ask_len;             /* width of the input box */ 
static	char	txterm = '\n';
static int pause_len;           /* pause loop length               */
static int help_argc = 0;	/* number of help lines */
				/* array of help string pointers */
static char *help_argv[] =    { "Currently there is no help available ",
				"for the information which is being   ",
				"requested.                           ", 0 };

/* ************ Select a font **************** */
winfnt_(n)
 int *n;
{
	ddfont = fonts[*n % NFONTS];
	gfx_current_font = *n;
}

/* *************** ESRU help box. *************** */
/* 
 This function takes an array of strings from f77 and attempts to
 display it in a box and waits for the user to press a key
 or click a mouse to get rid of it.  The strings passed will each
 be displayed on a separate line so that the arangement of the
 text passed will not be changed ie. no word warp etc will be
 undertaken, however if the longest string will not fit in the
 width of the box then a smaller font will be used.
*/
  eghelp(hargc,hargv,iw,impx,impy)
  
  int *hargc;		/* number of help lines */
  char	**hargv;	/* array of help string pointers */
  int  *iw;            /* actual max char width in items    */
  int  *impx,*impy;    /* box position (if 0,0 use default) */
{
/* Local variables   */
  char  *malloc();
  int	i, j, iy, iwth, ihsw;
  int	nitms = *hargc;

  int 	saved_font, use_font, changed_font;
  int   h_height, h_width, xb,yb,x,y;
  bitmap *under;                       /* to save image under help box  */
  int	no_valid_event;

  xb = *impx;
  yb = *impy;
  iwth = *iw;

  changed_font = 0;
  saved_font = use_font = gfx_current_font; /* save existing font  */
  h_height = (nitms*(ddfont->f_height+1))+20;  /* include a bit of extra space  */

  h_width = (iwth*ddfont->f_width)+20;	  /* box slightly wider than longest line */

/* 
 If a specific box starting point has been passed then try to honor
 this otherwise place it slightly above the dialogue box.
*/
  if (xb == 0) {
    xb= msgbx.b_left+20;
    yb = msgbx.b_top-10;
  }

/* 
 Check to see if the text will conviently fit within window, if not
 keep down-sizing until it does.  
*/
  while ((ddbm->bm_box.b_right - ddbm->bm_box.b_left + 50) < h_width) {  
    if (use_font == 0) break;
    use_font-- ;
    winfnt_(&use_font);
    h_width = iwth*ddfont->f_width+4;
    changed_font = 1;
  }

/* Create the help box but keep it from going above the display. */
  helpbx=ddbm->bm_box;
  if (yb - h_height < 40) {
    helpbx.b_top   = yb - h_height + 40;
    helpbx.b_bottom= yb + 40;
  } else {
    helpbx.b_top   = yb - h_height;
    helpbx.b_bottom= yb;
  }
  helpbx.b_left  = xb;
  helpbx.b_right = xb + h_width;

  under = bmcopy(NULLPTR(bitmap),helpbx,BMTO|BMGET);  /* save image under */
  bmbox(helpbx,BMCLEAR|BMEDGES);            /* draw outer box with edges  */

/* display lines of text.  */
  for ( i = 0; i < nitms; i++ ) {
    iy = helpbx.b_top + ((i + 1) * (ddfont->f_height+1)) + 10;
    ihsw = strlen(hargv[i]);
    if ( ihsw == 0 ) {
      ftxprint(helpbx.b_left+10,iy,"  ",2,WWXOR,ddfont,ddbm,0);
    } else if ( ihsw > 0 && ihsw > iwth ){
      ftxprint(helpbx.b_left+10,iy,hargv[i],iwth,WWXOR,ddfont,ddbm,0);
    } else if ( ihsw > 0 && ihsw < iwth ){
      ftxprint(helpbx.b_left+10,iy,hargv[i],ihsw,WWXOR,ddfont,ddbm,0);
    }
  }

  no_valid_event = TRUE;
  while ( no_valid_event) {
    ipwait();
    x = dd->d_x;
    y = dd->d_y;
    switch ( dd->d_buttons ) {    /* wait for any button press  */
    case ITEMBUTTON :   
    case MENUBUTTON :    
    case SHOWBUTTON : 		
         if (boxinside(helpbx,x,y)){
	   no_valid_event = FALSE;
           bmbox(helpbx,BMEDGES|BMCLEAR); /* clear help box */ 
           if (changed_font == 1) winfnt_(&saved_font);  /* Restore font.  */
   	   break;
         }

    default: /* if no button is down then check there is input */
 	 if (dd->d_event == IPKEY) {
           no_valid_event = FALSE;
	   break;
         }
    }
  }
  xxneutral();

  bmcopy(under,helpbx,BMFROM);             /* copy original image back */
  bmfree(under);
  if (changed_font == 1) winfnt_(&saved_font);  /* Restore font.  */

}

/* **************  Open feedback background box *************** */
/*
 Passed the character width of the main control menu, the number of
 lines of text to leave at the bottom for a dialogue box.
 dbx1 is the outer box (including axes) and viewbx is the image area.
*/
setup_box() 
{
  static int shade = 13;
  bitmap *greyshade;

  fbb=ddbm->bm_box;
  fbb.b_top   = 2;
  fbb.b_bottom= ddbm->bm_box.b_bottom - 2;
  fbb.b_left  = 2;
  fbb.b_right = ddbm->bm_box.b_right  -2;
  bmbox(fbb,BMCLEAR |BMEDGES);        /* draw outer box with edges  */
  greyshade = xxgrey(shade,FALSE);
  bmxcopy(greyshade,greyshade->bm_box,ddbm,fbb,WWXOR|WWREGISTER);
  bmbox(fbb,BMEDGES);              
  bmfree(greyshade);

/* Set number of dialogue line =2 to signal that the dialogue box exists */
  dialogue_lines = 2;  
  msgbx=ddbm->bm_box;
  msgbx.b_top = ddbm->bm_box.b_bottom - ((ddfont->f_height+4) * 2) -12;
  msgbx.b_bottom= ddbm->bm_box.b_bottom - 10;
  msgbx.b_left  = ddbm->bm_box.b_left + 10;
  msgbx.b_right = ddbm->bm_box.b_right - 10;
  bmbox(msgbx,BMCLEAR |BMEDGES);   /* draw dialogue box with edges  */
} /* setup_box */

/* **************  Open a dialogue input box *************** */
/*
 Passed the prompts which were sent to the dialogue box so that the
 correct position is defined. msgbx contains the prompts while
 askbx is reserved for user input.  If the width of the string
 would cause the input box to over-run the dialogue box then
 truncate the input box. If there is only a " " in the second
 prompt then position askbx against the left side.
*/
openask(msg1,msg2,asklen,len1,len2)
  char      *msg1,*msg2; /* character strings for each line */
  int  len1,len2; /* lengths as supplied */
  int  *asklen;     /* character width of the input box */
{
  int lprompt,tprompt;   /* cursor position, prompt left side */
  int lm1, lm2;          /* local string lengths found by test  */

  ask_len = *asklen;
  askbx = ddbm->bm_box;                /* get general properties of window */
  querb = defb = okb = ddbm->bm_box;   /* get general properties  */

  f_to_c_l(msg1,&len1,&lm1);
  f_to_c_l(msg2,&len2,&lm2);

  askbx.b_top = msgbx.b_bottom - (ddfont->f_height + 6);
  askbx.b_bottom = msgbx.b_bottom -1;
  querb.b_top =  askbx.b_top;
  defb.b_top =  askbx.b_top;
  okb.b_top = askbx.b_top;
  querb.b_bottom = msgbx.b_bottom -1;
  defb.b_bottom = msgbx.b_bottom -1;
  okb.b_bottom = msgbx.b_bottom -1;

/* Set default, querry & ok boxes at right side of msgbx */
  defb.b_right = msgbx.b_right - 5;
  defb.b_left = defb.b_right - (2 * ddfont->f_width);
  querb.b_right = defb.b_left - 5;
  querb.b_left = querb.b_right - (2 * ddfont->f_width);
  okb.b_right = querb.b_left - 5;
  okb.b_left = okb.b_right - (3 * ddfont->f_width);

/* Set askbx against ok box and truncate editing box if necessary */
  askbx.b_right = okb.b_left - 5;
  askbx.b_left = askbx.b_right -((*asklen+2) * ddfont->f_width);
  if (askbx.b_left < (msgbx.b_left + 5)) {
       askbx.b_left = msgbx.b_left + 5;
  }

/* determine left edge of prompt text */
  lprompt = askbx.b_left;
  tprompt = msgbx.b_right - ((lm1+2) * ddfont->f_width);
  if (tprompt < lprompt) lprompt = tprompt;
  tprompt = askbx.b_left - ((lm2+2) * ddfont->f_width);
  if (tprompt < lprompt) lprompt = tprompt;
  if (lprompt < msgbx.b_left) lprompt = msgbx.b_left+5;

  bmbox(msgbx,BMCLEAR |BMEDGES);   /* draw dialogue box with edges  */
  ftxprint(lprompt,msgbx.b_bottom - (ddfont->f_height+8),msg1,lm1,WWXOR,ddfont,ddbm,0);
  ftxprint(lprompt,msgbx.b_bottom - 1,msg2,lm2,WWXOR,ddfont,ddbm,0);

  bmbox(defb,BMCLEAR |BMEDGES);   /* draw defaults box with edges  */
  bmbox(querb,BMCLEAR |BMEDGES);   /* draw querry box with edges  */
  bmbox(okb,BMCLEAR |BMEDGES);   /* draw ok box with edges  */
  bmbox(askbx,BMCLEAR |BMEDGES);   /* draw input box with edges  */

  ftxprint(defb.b_left+2,defb.b_bottom-2,"d",1,WWXOR,ddfont,ddbm,0);
  ftxprint(querb.b_left+2,querb.b_bottom-2,"?",1,WWXOR,ddfont,ddbm,0);
  ftxprint(okb.b_left+2,okb.b_bottom-2,"ok",2,WWXOR,ddfont,ddbm,0);

} /* openaskbox */


/* **************  Get string from dialogue input box *************** */
/*
 Code implements control of a single line input facility.  
 Input begins when cursor is within askbx.
*/
dialog(sstr,s_len,dsstr,d_len,u_len)
  char *sstr, *dsstr;        /* string & default (remember strip end mark) */
  int  s_len,d_len,u_len;   /* character width of the string from fortran */
{
  txinfo *t1;
  int	no_valid_event = TRUE;
  int x,y,n,dn,i,impx,impy,iw;
  float dum1,dum2,dum3,dum4;
  dum1 = dum2 = dum3 = 10.25;
  dum4 = 5.0;

  t1 = txcreate(askbx);
  t1->tx_term = "\n"; 

/*
 Find actual string length and truncate when printing to fit within box.
*/
  f_to_c_l(sstr,&s_len,&n);
  if ( n < s_len ) sstr[n] = '\0';
  if (n > 0) txinsert(t1,0,sstr,n);
  f_to_c_l(dsstr,&d_len,&dn);
  if ( dn < d_len ) dsstr[dn] = '\0';

  while ( no_valid_event) {
    ipwait();
    x = dd->d_x;
    y = dd->d_y;
    if (boxinside(askbx,x,y)){
	txfollow(t1);
        if (dd->d_event==IPKEY && dd->d_char==txterm) no_valid_event = FALSE;
    } else {
      switch ( dd->d_buttons ) {
      case ITEMBUTTON :    /*   no matter what button is pressed  */
      case MENUBUTTON :    /*   treat as the same                 */
      case SHOWBUTTON :
        if (boxinside(okb,x,y)){

/* if clicked the ok box then terminate the programme... */
          bmbox(okb, BMCLEAR | BMNOT |BMEDGES);        /* invert box */
          ftxprint(okb.b_left+2,okb.b_bottom-2,"ok",2,WWXOR,ddfont,ddbm,0);
	  for (i=0; i< pause_len; i++) dum1*dum2*dum3/dum4;  /* pause for effect */
          bmbox(okb, BMCLEAR | BMEDGES);               /* clear box */
          ftxprint(okb.b_left+2,okb.b_bottom-2,"ok",2,WWXOR,ddfont,ddbm,0);
	  no_valid_event = FALSE;
          break;
        } else if (boxinside(defb,x,y)){

/* if clicked the default box then stuff default string into edit
 * box and re-display... */
          bmbox(defb, BMCLEAR | BMNOT |BMEDGES);       /* invert box */
          ftxprint(defb.b_left+2,defb.b_bottom-2,"d",1,WWXOR,ddfont,ddbm,0);
	  for (i=0; i< pause_len; i++) dum1*dum2*dum3/dum4;  /* pause for effect */
          bmbox(defb, BMCLEAR | BMEDGES);              /* clear box */
          ftxprint(defb.b_left+2,defb.b_bottom-2,"d",1,WWXOR,ddfont,ddbm,0);
          if (dn > 0) {
            t1 = txcreate(askbx);
	    t1->tx_term = "\n"; 
 	    txinsert(t1,0,dsstr,dn);
	  }
          
/*	  no_valid_event = FALSE;  */
          break;
        } else if (boxinside(querb,x,y)){

/* if clicked in the query box, read help messages from the def file and display
 * note that the help box must be rather small to fit within limited window...*/
          bmbox(querb, BMCLEAR | BMNOT |BMEDGES);      /* invert box */
          ftxprint(querb.b_left+2,querb.b_bottom-2,"?",1,WWXOR,ddfont,ddbm,0);  
          for (i=0; i< pause_len; i++) dum1*dum2*dum3/dum4;  /* pause for effect */
          bmbox(querb, BMCLEAR | BMEDGES);             /* clear box */
          ftxprint(querb.b_left+2,querb.b_bottom-2,"?",1,WWXOR,ddfont,ddbm,0);
/* display a limited help */ 
	  impx = 0; impy = 0; iw = 50;
	  if( help_argc == 0 ) help_argc = 3;
 	  eghelp(&help_argc,help_argv,&iw,&impx,&impy);         
/*	  no_valid_event = FALSE;  */
          break;
        }
      default:    /* if no button is down then check there is input */
 	if (dd->d_event == IPKEY) {   /* keyboard input */
          if (dd->d_char == txterm) no_valid_event = FALSE;
        }
	break;
      }
    }
  }
  xxneutral();
  strcpy(sstr,t1->tx_start);  /* copy string from txfollow to sstr */

  strip_leading_space (sstr);  /* strip leading blanks */
  sstr[u_len] = '\0';	/* make sure it is no longer than defined length */
} /* dialog */

/* **************  Open a two choice box *************** */
/*
 Passed the prompts which were sent to the dialogue box so that the
 correct position is defined. choicebx contains the prompts while
 a & b is reserved for user input. If there is only a " " in the second
 prompt then position askbx against the left side. If querry box is
 selected then ok returned as 3 which should be trapped by calling code.
*/
ab_dialog(msg1,msg2,opta,optb,ok,len1,len2,len3,len4)
  char    *msg1,*msg2;         /* character strings for each line */
  char    *opta,*optb;         /* character strings for 2 options */
  int len1,len2,len3,len4;     /* lengths as supplied by fortran (ignored) */
  int *ok;                /* returned 1=option a picked, 2=option b picked */
{
  char keypressed;
  int	no_valid_event = TRUE;
  box a,b;                           /* boxes for option a and option b     */
  int x1,y1,lprompt,tprompt;         /* cursor position, prompt left side   */
  int lm1,lm2,lm3,lm4,i,impx,impy,iw;         /* local string lengths found by test      */
  float dum1,dum2,dum3,dum4;
  dum1 = dum2 = dum3 = 10.25;
  dum4 = 5.0;

/*
 Find ends of strings passed and terminate.
 */
   f_to_c_l(msg1,&len1,&lm1);
   f_to_c_l(msg2,&len2,&lm2);
   f_to_c_l(opta,&len3,&lm3);
   f_to_c_l(optb,&len4,&lm4);

  querb = a = b = ddbm->bm_box;        /* get general properties of window */
  querb.b_top =  a.b_top = b.b_top = msgbx.b_bottom - (ddfont->f_height + 6);
  querb.b_bottom = a.b_bottom = b.b_bottom = msgbx.b_bottom -1;

/* Set choice and querry boxes at right side of msgbx */
  querb.b_right = msgbx.b_right - 5;
  querb.b_left = querb.b_right - (2 * ddfont->f_width);
  b.b_right = querb.b_left - 5;
  b.b_left = b.b_right - ((lm4+1) * ddfont->f_width);
  a.b_right = b.b_left - 5;
  a.b_left = a.b_right - ((lm3+1) * ddfont->f_width);

/* determine left edge of prompt text */
  lprompt = a.b_left;
  tprompt = msgbx.b_right - ((lm1+2) * ddfont->f_width);
  if (tprompt < lprompt) lprompt = tprompt;
  tprompt = a.b_left - ((lm2+2) * ddfont->f_width);
  if (tprompt < lprompt) lprompt = tprompt;
  if (lprompt < msgbx.b_left) lprompt = msgbx.b_left+2;

  bmbox(msgbx,BMCLEAR |BMEDGES);   /* draw dialogue box with edges  */
  ftxprint(lprompt,msgbx.b_bottom - (ddfont->f_height+8),msg1,lm1,WWXOR,ddfont,ddbm,0);
  ftxprint(lprompt,msgbx.b_bottom - 1,msg2,lm2,WWXOR,ddfont,ddbm,0);
  bmbox(a,BMCLEAR |BMEDGES);       /* draw yes box with edges  */
  bmbox(b,BMCLEAR |BMEDGES);       /* draw no box with edges  */
  bmbox(querb,BMCLEAR |BMEDGES);   /* draw querry box with edges  */

  ftxprint(a.b_left+3,a.b_bottom-1,opta,lm3,WWXOR,ddfont,ddbm,0);
  ftxprint(b.b_left+3,b.b_bottom-1,optb,lm4,WWXOR,ddfont,ddbm,0);
  ftxprint(querb.b_left+2,querb.b_bottom-1,"?",1,WWXOR,ddfont,ddbm,0);
  *ok = 0;                     /* assume no answer         */
/*
  Now check to see if mouse moves into the option a or option b box and
  don't leave until one has been selected.
*/
  while ( no_valid_event) {
    ipwait();
    x1 = dd->d_x;
    y1 = dd->d_y;
    switch ( dd->d_buttons ) {
    case ITEMBUTTON :    /*   no matter what button is pressed  */
    case MENUBUTTON :    /*   treat as the same                 */
    case SHOWBUTTON :
         if (boxinside(a,x1,y1)){
	   no_valid_event = FALSE;
           bmbox(a,BMEDGES|BMNOT|BMCLEAR);              /* invert box */ 
           ftxprint(a.b_left+3,a.b_bottom-1,opta,lm3,WWXOR,ddfont,ddbm,0);
           *ok = 1;
   	   break;
         } else if (boxinside(b,x1,y1)){
	   no_valid_event = FALSE;
           bmbox(b,BMEDGES|BMNOT|BMCLEAR);              /* invert box */ 
           ftxprint(b.b_left+3,b.b_bottom-1,optb,lm4,WWXOR,ddfont,ddbm,0);
           *ok = 2;
   	   break;
         } else if (boxinside(querb,x1,y1)){
           bmbox(querb, BMCLEAR | BMNOT |BMEDGES);      /* invert box */
           ftxprint(querb.b_left+2,querb.b_bottom-2,"?",1,WWXOR,ddfont,ddbm,0);  
           for (i=0; i< pause_len; i++) dum1*dum2*dum3/dum4;  /* pause for effect */
           bmbox(querb, BMCLEAR | BMEDGES);             /* clear box */
           ftxprint(querb.b_left+2,querb.b_bottom-2,"?",1,WWXOR,ddfont,ddbm,0);
 	   impx = 0; impy = 0; iw = 50;		/* display a limited help */
	   if( help_argc == 0 ) help_argc = 3;
 	   eghelp(&help_argc,help_argv,&iw,&impx,&impy);         
           break;
         }

    default:    /* if no button is down then check there is input */
 	 if (dd->d_event == IPKEY) {   /* keyboard input */
            keypressed = isupper (dd -> d_char) ?
		tolower(dd -> d_char) : dd -> d_char;
            if ( keypressed == 'a' || keypressed == 'y' )*ok = 1;
            if ( keypressed == 'b' || keypressed == 'n' )*ok = 2;
	    no_valid_event = FALSE;
	 }
	 break;
    }
  }
  xxneutral();     /* throw away any buffered key or mouse presses */

/*
  If one of the choices has been made pause and then clear the dialogue box.
*/
  if ( *ok == 1 || *ok == 2 ) {
    for (i=0; i<pause_len; i++) dum1*dum2*dum3/dum4;  /* pause for effect    */
    bmbox(msgbx,BMCLEAR |BMEDGES);                    /* clear dialogue box  */
  }
} /* abbox */

/* ************** function to remove leading blanks *************** */
strip_leading_space (line)
char    *line;
{
int i = 0;
char c; 
  if (line==NULL) return;
  if (*line==NULL) return;
  while ((c = line [i]) != '\n' || c != '\0'  ) {
      if ( !isspace ( c ) ) break;
      i++;
  }
  strcpy ( &line[0], &line[i]);
}

/* ************** Confirm Fortran string length *************** */
/*
 Since the string length automaticly passed between Fortran and C
 tends to represent the "defined" string length rather than the actual
 string length here is a bit of code to start at the "defined" end
 and work backwards to find the last non-blank character position.
 This variant of f_to_c_length takes into account case where fortran
 string has not been terminated with a null character and an extra
 check needs to be made to ensure the strlen(msg) does not look
 past the string.
*/
f_to_c_l(msg,f_len,len)
  char    *msg;         /* character string */
  int     *f_len,*len;  /* fortran string length,
                           found position of last non blank character */
{
  int lm, sl, n, found;       /* local string lengths found by test  */
  sl = strlen(msg);
  if( sl == *f_len ){
    n = *f_len;
  } else if( sl > *f_len ) {
    n = *f_len;
  } else if( sl < *f_len ) {
    n = sl;
  }
  found = FALSE;
  while(n > 0 && !found) {
    n--;
    if ( msg[n] != ' ') found = TRUE;
  }
  if (found) {
    lm = n+1;
  } else if (! found && n == 0) {
    lm = 0;
  }
  *len = lm;

} /* f_to_c_l */

/* ************* */	
main(argc,argv)char **argv;{
  int i;
  int  asklen,deflen,use_len,max_len;        /* character widths */
  int  a_len,b_len,ok;
  char *msg1 = "Please supply the schema file name:";	/* default prompt  */
  char *msg2 = " ";					/* default prompt  */
  char *sstr = "                             ";	        /* initial response  */
  char *dsstr= "                             ";	        /* default response  */
  char *sstr_a = "        ";	        /* ab choice a */
  char *sstr_b = "        ";	        /* ab choice b */
  char dt;				/* dialog type */

  pause_len = 1000;  /* inital pause loop length */

  if(argc == 1 ) {                 /* no commands to put in defaults */
  } else if (argc > 1 )  {
     for (i = 1; i < argc; i++) {
       if (strncmp(argv[i], "-help", 5) == 0) {
         printf(" \n");
         printf(" Design tool schema completion tool. \n");
         printf(" Use: [-p <quoted prompt string>] \n");
         printf("      {-file|-s|-num|-ab|-ok}\n");
         printf("      where -file <quoted string <= 72 char\n");
         printf("            -s <any length quoted string> \n");
         printf("            -num <number> \n");
         printf("            -ab <quoted choice a> <quoted choice b>\n");
         printf("            -ok yes & no selections provided\n");
         printf(" \n");
         printf("      [-d <quoted default response> \n");
         printf("      [-h1 <quoted first line of help> \n");
         printf("      [-h2 <quoted 2nd line of help> \n");
         printf("      [-h3 <quoted 3rd line of help> \n");
         printf("      (if no help the a default message is given) \n");
         printf(" \n");
         printf(" -help :this help message.\n");
         printf(" \n");
         exit(1);
       }
       if (strncmp(argv[i], "-p", 2) == 0) {
         msg1 = argv[++i];
       } else if (strncmp(argv[i], "-file", 6) == 0) {
	 dt = 'f';
	 max_len = 72;
         sstr = argv[++i];
       } else if (strncmp(argv[i], "-num", 4) == 0) {
	 dt = 'n';
	 max_len = 24;
         sstr = argv[++i];
       } else if (strncmp(argv[i], "-s", 2) == 0) {
	 dt = 's';
         sstr = argv[++i];
	 max_len = strlen(sstr)+1;
       } else if (strncmp(argv[i], "-ab", 3) == 0) {
	 dt = 'a';
         sstr_a = argv[++i];
	 a_len = strlen(sstr_a);
         sstr_b = argv[++i];
	 b_len = strlen(sstr_b);
       } else if (strncmp(argv[i], "-ok", 3) == 0) {
	 dt = 'o';
         strcpy(sstr_a,"yes"); a_len = strlen(sstr_a);
         strcpy(sstr_b,"no");  b_len = strlen(sstr_b);
       } else if (strncmp(argv[i], "-d", 2) == 0) {
         dsstr = argv[++i];
       } else if (strncmp(argv[i], "-h1", 3) == 0) {
         help_argv[help_argc] = argv[++i];
	 help_argc++;
       } else if (strncmp(argv[i], "-h2", 3) == 0) {
         help_argv[help_argc] = argv[++i];
	 help_argc++;
       } else if (strncmp(argv[i], "-h3", 3) == 0) {
         help_argv[help_argc] = argv[++i];
	 help_argc++;
       }
     }
  }
  if (wwxget(boxbuild(20,20,500,120),2,"User dialog",0)==0) exit(1);
  fonts[0] = ftload(getenv("EFONT_0"));
  fonts[1] = ftload(getenv("EFONT_1"));
  fonts[2] = ftload(getenv("EFONT_2"));
  fonts[3] = ftload(getenv("EFONT_3"));
  dd->d_line = WWCOPY;		/* to support drawing of lines and boxes. */
  ddbm = ddwin->w_bm;
  setup_box();			/* layout the display  */

  ipset(IPON);
	
  asklen = strlen(sstr);
  deflen = strlen(dsstr);
  if(asklen <= 12) asklen = 12;
  if(deflen <= 12) deflen = 12;
  use_len = (asklen > deflen) ? asklen : deflen;
  if(dt == 'f' || dt == 'n' || dt == 's') {
    openask(msg1,msg2,&use_len,strlen(msg1),strlen(msg2));
    max_len = (use_len > max_len) ? use_len : max_len;
    dialog(sstr,strlen(sstr),dsstr,strlen(dsstr),max_len);
    write(1,sstr,strlen(sstr));
    write(1,"\n",1);
  } else if (dt == 'a') {
    ab_dialog(msg1,msg2,sstr_a,sstr_b,&ok,strlen(msg1),strlen(msg2),a_len,b_len);
    if(ok == 1 )write(1,"dialog_option_a",15);
    if(ok == 2 )write(1,"dialog_option_b",15);
    write(1,"\n",1);
  } else if (dt == 'o') {
    ab_dialog(msg1,msg2,sstr_a,sstr_b,&ok,strlen(msg1),strlen(msg2),a_len,b_len);
    if(ok == 1 )write(1,"dialog_option_yes",17);
    if(ok == 2 )write(1,"dialog_option_no",16);
    write(1,"\n",1);
  }

  ipset(IPOFF);
}
