#include	<stdio.h>
#include	<string.h>
#include	<errno.h>
#include	<sys/time.h>

#define	CSEP	(char)9			/* '\t' */
#define	MAX_NO_DIALOGS		10
#define	NULL	0
#define	TRUE	1
#define	FALSE	0
#define	READ	0
#define	WRITE	1
#define	HEAD	0
#define	TAIL	1
#define	ERR	-1

char		csep = CSEP;
static int	in_channels = 1;

static int	no_dialogs = 0;

typedef struct	_fl {
	struct	_fl	*next;
	struct	_fl	*prev;
	char		*name;
} FormEntry;
static FormEntry	*FormList[2] = {(FormEntry *)0, (FormEntry *)0};
typedef struct	_dl {
	struct	_dl	*next;
	struct	_dl	*prev;
	char		*name;
	int		list_size;
} DupEntry;
static DupEntry	*DupList[2] = {(DupEntry *)0, (DupEntry *)0};

static	struct {
	char		name[64];	/* name of dialog client (for ps)*/
	int		running;	/* program status */
	char		progtype[64];	/* dialog driver type (form, map..)*/
	char		command[256];	/* command to start client */
	int		channel[2];	/* io channels for communication */
} dialogs[MAX_NO_DIALOGS];

char	buf[MAX_NO_DIALOGS][512], * bufptr[MAX_NO_DIALOGS];




Decapitate (buf, head, body)
char	* buf, ** head, **body;
{
	*head = buf;
	*body = *head;
	while (**body!=csep && **body!='\0')
		(*body)++;
	if (**body!='\0')   *(*body)++ = '\0';
	if (**body=='\t')
		(*body)++;
};




CloseDown(by)
int	by;
{	int	a;

	fprintf(stderr,"DH- %s aborted, closing session\n",dialogs[by].name);
					/* notify all other kb's*/
	for (a = 1; a <= no_dialogs; a++) {
		fprintf(stderr,"	aborting %s\n", dialogs[a].name);
		if (a != by)
		    if (!strcmp(dialogs[a].progtype,"formp"))
			write (dialogs[a].channel[WRITE], ".:quit:\n", 5);
		    else
			write (dialogs[a].channel[WRITE], "abort\n", 6);
	};
};

char*	ReplEnv(string) char* string;
{
	extern char* getenv();
	char*	c;
	char*	env_var = string;
	char*	remainder;
	char*	new_var = NULL;
	int	size;

	if((c=strchr(env_var,'$'))!=NULL)
	{
		env_var++;
		if((c=strchr(env_var,'/'))!=NULL)
		{
			remainder = c+1;
			*c='\0';
			env_var = getenv(env_var);
			size = strlen(env_var)+strlen(remainder)+1;
			new_var=(char*)malloc(size);
			strcat(new_var,env_var);
			strcat(new_var,remainder);
			new_var[size] = '\0';
		}
	}
	return(new_var);
}



SpawnDialog(name, progtype, command)
char	* name, * progtype, * command;
{	int	a, pid, pipe_in[2], pipe_out[2], argc;
	char	**argv, prog_file[256];
	char*	c;

	for (a = 1; a <= no_dialogs; a++)
		if (!strcmp(dialogs[a].progtype, progtype)  &&
					dialogs[a].running != TRUE)
			break;
	if (a > no_dialogs) {
		no_dialogs++;			/* 1st invocation */
		bufptr[a] = buf[a];
		strcpy(dialogs[a].name, name);
		strcpy(dialogs[a].progtype, progtype);
		strcpy(dialogs[a].command, command);
	};
	pipe (pipe_in);
	pipe (pipe_out);
	if ((pid=fork()) == ERR)
		fprintf (stderr,"DH - couldn't fork %s\n", dialogs[a].name);
	if (pid == 0) {
		dup2 (pipe_out[READ], 0);
		dup2 (pipe_in[WRITE], 1);
		close (pipe_out[WRITE]);
		close (pipe_in[READ]);
		setbuf(stdout,(char*)NULL);
					/* set up argument list */
		*prog_file = '\0';
		if (*dialogs[a].command != '/') {
			strcpy(prog_file,getenv("IFE_HOME"));
			strcat(prog_file,"bin/");
		};
		strcat(prog_file, strtok(dialogs[a].command," \t\n"));
		argv = (char**)malloc(10*sizeof(char*));
		argv[0] = dialogs[a].name;
		argc = 1;
		while ((argv[argc++] = strtok(NULL," \t\n")) != NULL)
		{
			if ((argc % 10) == 0)
				argv = (char**)realloc(argv,argc+10);
			if((c=strchr(argv[argc-1],'$'))!=NULL)
				 argv[argc-1] = ReplEnv(argv[argc-1]);
		}
		fprintf (stderr,"DH - starting %s (as %s) on %d:%d\n",
				dialogs[a].name,command,
				pipe_in[READ],pipe_out[WRITE]);
		execvp (prog_file, argv);
		fprintf (stderr,"DH - couldn't exec %s\n", prog_file);
fprintf (stderr,"   -  %s, %s, %s\n", argv[0],argv[1],argv[2]);
		exit(0);
	};
	close (pipe_out[READ]);
	close (pipe_in[WRITE]);
	dialogs[a].channel[READ] = pipe_in[READ];
	dialogs[a].channel[WRITE] = pipe_out[WRITE];
	in_channels |= 1 << dialogs[a++].channel[READ];
};

		




known_focus(new_form)
char	*new_form;
{	FormEntry	*f;
					/* search list for new_form */
	for (f = FormList[HEAD]; f != (FormEntry *)0; f = f->next)
		if (!strcmp (f->name, new_form))
			return(TRUE);	/* got it */
					/* not found, add to list */
	if (FormList[TAIL] != (FormEntry *)0) {
	    FormList[TAIL]->next =
			    (FormEntry *)malloc((unsigned)sizeof(FormEntry));
	    if (FormList[TAIL]->next == (FormEntry *)NULL) {
		fprintf (stderr, "DH - can't malloc necessary list space");
		CloseDown(0);		/* 0 = Blackborad */
		abort();
	    };
	    FormList[TAIL]->next->prev = FormList[TAIL];
	    FormList[TAIL] = FormList[TAIL]->next;
	} else {
	    FormList[TAIL] =(FormEntry *)malloc((unsigned)sizeof(FormEntry));
	    FormList[TAIL]->prev = (FormEntry *)0;
	    FormList[HEAD] = FormList[TAIL];
	};
	FormList[TAIL]->next = (FormEntry *)0;
	FormList[TAIL]->name =(char *)malloc((unsigned)(strlen(new_form)+1));
	if (FormList[TAIL]->name == NULL) {
		fprintf (stderr,"DH - can't malloc necessary string space");
		CloseDown(0);		/* 0 = Blackborad */
		abort();
	    };
					/* fill new entry with form name */
	strcpy (FormList[TAIL]->name, new_form);
	return(FALSE);
};



known_list(field_name,element)
char*	field_name;
int	element;
{	DupEntry	*l;
	int		last;
					/* search list for field_name */
	for (l = DupList[HEAD]; l != (DupEntry *)0; l = l->next)
		if (!strcmp (l->name, field_name)) {
					/* got it, check if big enough */
			if ((last = l->list_size) < element)
				l->list_size = element;		/* no */
			return(last);
	};
					/* not found, so add to list */
	if (DupList[TAIL] != (DupEntry *)0) {
	    DupList[TAIL]->next =
			    (DupEntry *)malloc((unsigned)sizeof(DupEntry));
	    if (DupList[TAIL]->next == (DupEntry *)NULL) {
		fprintf (stderr, "DH - can't malloc necessary list space");
		CloseDown(0);		/* 0 = Blackborad */
		abort();
	    };
	    DupList[TAIL]->next->prev = DupList[TAIL];
	    DupList[TAIL] = DupList[TAIL]->next;
	} else {
	    DupList[TAIL] =(DupEntry *)malloc((unsigned)sizeof(DupEntry));
	    DupList[TAIL]->prev = (DupEntry *)0;
	    DupList[HEAD] = DupList[TAIL];
	};
	DupList[TAIL]->next = (DupEntry *)0;
	DupList[TAIL]->name=(char *)malloc((unsigned)(strlen(field_name)+1));
	if (DupList[TAIL]->name == NULL) {
		fprintf (stderr,"DH - can't malloc necessary string space");
		CloseDown(0);		/* 0 = Blackborad */
		abort();
	    };
					/* fill new entry with name & size */
	strcpy (DupList[TAIL]->name, field_name);
	DupList[TAIL]->list_size = element;
	return(0);
};





ExpandFormMsg(head, rest)
char	*head, *rest;
{	char	command[512], cpt_root[64], * concept, * data, *c, *indxp;
	int	a, last;

	Decapitate (rest, &concept, &data);
	/* check for duplicatable concept list */
	if ((c = strchr(concept,'$'))) {
		*c++ = '[';		/* convert "cpt 6" syntax to cpt[5]*/
		while (*data != csep  &&  *data != '\0')
			*c++ = *data++;
		*c++ = ']';
		if (*data == csep)   *data++ = '\0';
	};
	if (!strcmp(head, "chat_user")) {
		sprintf(command,".:contents: /chat_area/chat_user + %s\n",
							concept);
	} else if (!strcmp(head, "tell_user")) {
			sprintf(command,"@%s:set current:%s\n..::\n",
							concept, data);
	} else if (!strcmp(head, "focus_user")) {
		if (!known_focus(concept))
		    sprintf(command,".:load:%s\n./%s:display:10\n",
							concept, concept);
		else
		    sprintf(command, "@%s:display:10\n", concept);
	} else if (!strcmp(head, "ask_user")) {
		*command = '\0';
		/* have to handle lists (field[n] syntax) differently */
		if ( (c = strchr(concept,'[')) != (char *)NULL) {
			strncpy(cpt_root, concept, c-concept);
			a = atoi(++c);		/* element no */
			if ((last = known_list(cpt_root,a)) < a)
				/* need to extend list by a-last*/
				sprintf(command, ".:duplicate:@%s[%d]*%d\n",
						cpt_root, last, a-last);
		}
		/* now display the element, with any default data */
		sprintf(command,"%s@%s:display:\n..::\n", command, concept);
		if (*data)
			sprintf(command,"%s@%s:set current:%s\n..::\n",
						command, concept, data);
	} else if (!strcmp(head, "unfocus_user")) {
		sprintf(command,"@%s:hide:10\n..::\n", concept);
	} else if (!strcmp(head, "defocus_user")) {
		sprintf(command,"@%s::\n..::\n", concept);
	} else if (!strcmp(head, "unask_user")) {
		sprintf(command,"@%s:hide:10\n..::\n", concept);
	} else if (!strcmp(head, "sugest_user")) {
		sprintf(command,"@%s:set default:%s\n..::\n",
							concept, data);
	} else if (!strcmp(head, "offer_user")) {
		sprintf(command,"@%s:menu:%s\n..::\n",
							concept, data);
/*	} else if (!strcmp(head, "new_query")) {
		sprintf(command,".:new field%s\n..::\n", concept);
 */	} else if (!strcmp(head, "remind")) {
		sprintf(command,".:contents:./%s\n", concept);
	} else {
		fprintf(stderr, "DH - unrecognised fp command %s:%s\n",
			head, concept);
		return;
	};
	for (c = command ; *c != '\0' ; c++)
		if (*c == CSEP)   *c = '\n';

					/* send to all forms */
	for (a = 1; a <= no_dialogs; a++)
	    if (!strcmp(dialogs[a].progtype, "formp"))
		 write (dialogs[a].channel[WRITE], command, strlen(command));
#ifdef DEBUG
fprintf(stderr,"DH>FP:  %s", command);
#endif

};

char *
tail(string)
char *string;
{
char *c;
	return(((c=strrchr(string,'/'))!=NULL)?c+1:string);
}





ProcFPMsg (from, buf)
int	from;
char	* buf;
{	char	command[128], concept[1024], data[256], *cpt, *c;

#ifdef DEBUG
fprintf(stderr,"DH<FP:  %s\n",buf);
#endif
	if (sscanf(buf, "%[^:]:%*[^:]:%s", concept, data) == 2)
		sprintf(command, "user_dialog_a%cuser_said%c", csep, csep);
	else if (sscanf(buf, "%[^!]!%*[^!]!%s", concept, data) == 2)
		sprintf(command, "user_error%cuser_said%c", csep, csep);
	else if (sscanf(buf, "%[^@]@%*[^@]@%s", concept, data) == 2)
		sprintf(command, "user_action%cuser_said%c", csep, csep);
	else if (sscanf(buf, "%[^?]?%*[^?]?%s", concept, data) == 2)
		sprintf(command, "user_query%cuser_said%c", csep, csep);
	else
		return;
	cpt = tail(concept);
	if ((c = strchr(cpt,']'))) {	/* convert "cpt[5]" syntax to cpt 6*/
		while (*--c != '[')
			*(c+1) = *c;
		*c++ = '$';
		*c = csep;
	};
	sprintf(command,"%s%s%c%s\n", command, cpt, csep, data);
	write (dialogs[0].channel[WRITE], command, strlen(command));
#ifdef DEBUG
fprintf(stderr,"DH>BB:  %s" ,command);
#endif

				/* check for abort */
	if (!strncmp(concept, "abort", 5)) {
		CloseDown(from);
		exit(0);
	};

};





ProcMAPMsg (from, buf)
int	from;
char	* buf;
{	char	command[128];
	int	lat, lng, latf, lngf;

#ifdef DEBUG
fprintf(stderr,"DH<MAP: %s\n",buf);
#endif
					/* check for abort */
	if (!strncmp(buf, "abort", 5)) {
		CloseDown(from);
		exit(0);
	};
	sscanf(buf,"%d %d", &lng, &lat);
	lat /= 360;				/* convert to degrees */
	lng /= 360;
	latf = (lat < 0 ? -lat % 10 : lat % 10);
	lngf = (lng < 0 ? -lng % 10 : lng % 10);
	lat /= 10;
	lng /= 10;
	sprintf(command, "user_dialog_a%cuser_said%clatitude%c%d.%d\nuser_dialog_a%cuser_said%clongitude%c%d.%d\n", csep, csep, csep, lat, latf, csep, csep, csep, lng, lngf);
	write (dialogs[0].channel[WRITE], command, strlen(command));
#ifdef DEBUG
fprintf(stderr,"DH>BB:  %s", command);
#endif
};





ProcBBMsg(from, buf)			/* message from Blackboard */
int	from;
char	* buf;
{	char	*area, *mesg, *cmd, *rest;
	char	prog[256];

#ifdef DEBUG
fprintf(stderr,"DH<BB:  %s\n",buf);
#endif
	Decapitate(buf, &area, &mesg);	/* strip off bb area holding mesg */
	if (!strcmp(area, "abort")) {
		CloseDown(from);
		exit(0);
	} else if (!strcmp(area, "user_dialog_a")) {		
		Decapitate(mesg, &cmd, &rest);	/* process dialog command */
		if (!strcmp(cmd, "abort")) {
			CloseDown(from);
			exit(0);
		} else if (!strcmp(cmd,"new_dialog")) {
			if (!strncmp(rest, "formp", 4))
				SpawnDialog("IFE_dh_form","formp",rest);
			else if (!strncmp(rest, "map", 3))
				SpawnDialog("IFE_dh_map","map",rest);
			else if (!strncmp(rest, "draw", 4))
				SpawnDialog("IFE_dh_draw","geom",rest);
			else if (!strncmp(rest, "browse", 6))
				SpawnDialog("IFE_dh_browse","geom",rest);
			else
				ExpandFormMsg(cmd,rest);
		} else
			ExpandFormMsg(cmd,rest);
	};
	write (dialogs[0].channel[WRITE], ">", 1);
	
};




ProcMsg (from, buf)
int	from;
char	* buf;
{
	if (*buf == '\0')
		return;			/* pipe closed or spurious select */

	if (!strcmp(dialogs[from].progtype, "bb"))
		ProcBBMsg(from, buf);
	else if(!strcmp(dialogs[from].progtype, "formp"))
		ProcFPMsg(from, buf);
	else if(!strcmp(dialogs[from].progtype, "map"))
		ProcMAPMsg(from, buf);
};
		




main()
{
	char	c;
	char	name[64], progtype[64], prog[256], args[64], text[128];
	char	dialog_name[256];
	int	a = 0;
	int	rd, wrt, ex;
	int	n;
	FILE	* dialog_file;

	setbuf(stdout,(char*)NULL); 
	setbuf(stdin,(char*)NULL); 
	bufptr[a] = buf[a];
	strcpy(dialogs[a].name, "Blackboard");
	strcpy(dialogs[a].progtype, "bb");
	strcpy(dialogs[a].command, "ife_bb");
	dialogs[a].channel[READ] = 0;	/* stdin */
	dialogs[a++].channel[WRITE] = 1;	/* stdout */
					/* spawn off dialog entities */
	strcpy(dialog_name,getenv("IFE_HOME"));
	strcat(dialog_name,"lib/startup/dh_clients");
	if ((dialog_file = fopen(dialog_name,"r")) == (FILE *)NULL) {
		fprintf(stderr,"Can't open file %s",dialog_name);
		exit (0);
	};
	while ((n = fscanf(dialog_file, "%s %s %[^~]\n",
					 progtype, name, args)) !=  EOF) {
		if (n != 3) {
			fprintf(stderr,"Bad entry %d in %s\n",n,dialog_name);
			CloseDown(0);
			exit(0);
		};
		SpawnDialog(name, progtype, args);
	};
	for (a = 1; a <= no_dialogs; a++)
	    if (!strcmp(dialogs[a].progtype, "formp"))
		 write (dialogs[a].channel[WRITE],"\n/:ignore events:\n", 18);
				/* tell bb (stdout) of required messages */
	sprintf(text,"mk_area%cuser_dialog_a\n",csep);
	write (dialogs[0].channel[WRITE], text, strlen(text));
	sprintf(text,"update_me%cuser_dialog_a%cuser_dialog_a\n",
								csep, csep);
	write (dialogs[0].channel[WRITE], text, strlen(text));
	write (dialogs[0].channel[WRITE], ">", 1);
	fprintf (stderr,"DH - dialog handler started\n");
	while (1) {
	    wrt = 0;
	    rd = ex = in_channels ;
	    n = select (32, &rd, &wrt, &ex, (struct timeval *)NULL);
				/* from user/bb */
		for (a=0; a <= no_dialogs; a++) 
		   if (rd & 1<<dialogs[a].channel[READ]) {
			n = read (dialogs[a].channel[READ], &c, 1);
			switch (n) {
			    case 1:
				if (c == '\n') {
					*bufptr[a] = '\0';
					ProcMsg(a, buf[a]);
					bufptr[a] = buf[a];
				} else
					*bufptr[a]++ = c;
				break;
			    case 0:	/* end of file, close pipe */
				*bufptr[a] = '\0';
				ProcMsg(a, buf[a]);
				fprintf (stderr,"DH - %s pipe closed)\n",
							dialogs[a].name);
				write (dialogs[0].channel[WRITE], text,
							strlen(text));
				if (a == 0) {	/* bb (stdin) gone */
					CloseDown(a);
					exit(0);
				};
				sprintf(text, "closed%c%s\n",
						csep,dialogs[a].name);
				dialogs[a].running = FALSE;
				in_channels &= ~(1<<dialogs[a].channel[READ]);
				break;
			    default:
 				fprintf (stderr,"DH - %s pipe error %d\n",
						dialogs[a].name, errno);
				CloseDown(a);
				abort();
			};
		   };
	}
}
