				/****************************/
				/*                          */
				/*   IFE building model:    */
              			/* Version 1.0a, Nov. 1988. */
				/*                          */
				/****************************/
#include <stdio.h>
#include <strings.h>

#define CHARS 100
#define LOOPS 10

int for_count = -1, if_count = -1, marker[LOOPS], number_loops[LOOPS] ;
char line[CHARS], for_called_by ;
FILE *ofp, *ifp, *tfp[LOOPS] ;
char fname[LOOPS][5] = {
   '0', "tf0",
   '1', "tf1",
   '2', "tf2",
   '3', "tf3",
   '4', "tf4",
   '5', "tf5",
   '6', "tf6",
   '7', "tf7",
   '8', "tf8",
   '9', "tf9"
} ;
   

main()
{

int i, get_line() ;
char c, filen[CHARS] ;
char process_line() ;
FILE *fopen() ;
void for_loop(), process_if() ;

				/* Input file. */
   printf("ESP data builder template file ?\n") ;
   scanf("%s", filen) ;
   if((ifp = fopen(filen, "r"))==NULL) {
      printf("Cannot open file.\n") ;
      exit(1) ;
   }
				/* Output file. */
   printf("Output script file ?\n") ;
   scanf("%s", filen) ;
   if((ofp = fopen(filen, "w"))==NULL) {
      printf("Cannot open file.\n") ;
      exit(1) ;
   }

   while (i = get_line()) {		/* Get a line from input */
      c = process_line() ;		/* file and process it.  */
      if (c == 'f') {
         for_called_by = 'm' ;
         for_loop() ;
      }
      else if (c == 'i')
         process_if(ofp) ;
      else if (c != '\0') {
         fprintf(ofp, "%s\n", line) ;
      }
   }
   printf("%s\n\n", "Done.") ;
}

int get_line()
{
int i ;
char c ;
 				/* Read input file character by character */
				/* and discard leading white space.       */
   for (i = 0; (c = getc(ifp)) != EOF; ++i) {
      if (c == '\n') {
         line[i] = '\0' ;	/* Got a line, with leading white */
         return (1) ;		/* space removed, now process it. */
      }
      else if (i > 0 || (c != ' ' && c != '\t'))
         line[i] = c ;
      else
         --i ;			/* Skip leading white space. */
   }
   return (0) ;

}

char process_line()
{

int i ;
char c, word[CHARS] ;
void ask_bb() ;

   c = line[0] ;		/* Look for special cases. */
   switch (c) {
      case '#':			/* Comment line. */
         return ('#') ;
      case '%':			/* IFE: question to Blackboard. */
         ask_bb() ;
         return ('%') ;
      case '\0':		/* Null line. */
         return ('\0') ;
   }

   i = 0 ;			/* Get first word, \0 terminates while. */
   while ((c = line[i]) != '\n') {
      if (c != ' ' && c != '\t' && c != '\0') {
         word[i] = c ;
         ++i ;
      }
      else {			/* Found first word, is it a shell command ? */
         word[i] = '\0' ;
         if (!strcmp(word, "for"))
            return ('f') ;
         else if (!strcmp(word, "do"))
            return ('1') ;
         else if (!strcmp(word, "done"))
            return ('d') ;
         else if (!strcmp(word, "if"))
            return ('i') ;
         else if (!strcmp(word, "then"))
            return ('2') ;
         else if (!strcmp(word, "elif"))
            return ('3') ;
         else if (!strcmp(word, "else"))
            return ('4') ;
         else if (!strcmp(word, "fi"))
            return ('5') ;
         else
            return ('z') ;
      }
   }
   printf("%s\n", "Error in line processing function.") ;

}

void ask_bb()
{
				  /* Identify variable */
   /* printf("%s\n", line) ; */   /* Send only part after = */
   /* scanf("%s", line) ; */      /* Strip of above part on return */
				  /* Assign variable */
}

void for_loop()
{

int get_line(), process_line2() ;
int i ;
char c, process_line(), *p ;
void process_if() ;

   if (for_count == -1) {			/* Flag that loop has commenced and    */
      number_loops[0] = process_line2() ;	/* establish number of loops required. */
      for_count = 1 ;			

      p = &fname[0][0] ;		/* Temp. file for outer "for" loop lines. */
      if((tfp[0] = fopen(p, "w+"))==NULL) {
      printf("Cannot open temporary file. %s\n", p) ;
      exit(1) ;
      }
   }				
   else {
      number_loops[for_count] = process_line2() ;

      p = &fname[for_count][0] ;		/* Open new temp. file. */
      if((tfp[for_count] = fopen(p, "w+"))==NULL) {
         printf("Cannot open temporary file. %s\n", p) ;
         exit(1) ;
      }
      ++for_count ;
   }

   while (i = get_line()) {
      c = process_line() ;

      if (c == 'f') {			/* Found a nested "for". */
         number_loops[for_count] = process_line2() ;

         p = &fname[for_count][0] ;		/* Open new temp. file. */
         if((tfp[for_count] = fopen(p, "w+"))==NULL) {
            printf("Cannot open temporary file. %s\n", p) ;
            exit(1) ;
         }
         ++for_count ;
      }
      else if (c == '\0' || c == '1')	/* Skip NULL and "do". */
         ;
      else if (c == 'd') {
         for (; number_loops[for_count-1] > 0; --number_loops[for_count-1]) {
            rewind(tfp[for_count-1]) ;
            while(fgets(line, 100, tfp[for_count-1]) != NULL) {
               if ( for_count == 1)
                  fprintf(ofp, "%s", line) ;
               else
                  fprintf(tfp[for_count-2], "%s", line) ;
            }
         }
         --for_count ; 
         fclose(tfp[for_count]) ;
         if (for_called_by == 'i')
            if (for_count == marker[if_count]) {
               return ;
            }
         if (for_count == 0) {		/* Finished. */
            for_count = -1 ; 
            return ;
         }
      }
      else if (c == 'i') {		/* Found an "if". */
         ++if_count ;
         marker[if_count] = for_count ;
         process_if(tfp[for_count-1]) ;
      }
      else {
         fprintf(tfp[for_count-1], "%s\n", line) ;
      }
   }

}

int process_line2()
{

   return (2) ;
}

void process_if(p)
FILE *p ;
{
int i, expr, get_line(), print = 0 ;
char c ;
					/* First process "if" line and */
					/* evaluate to true or false.  */
   expr = 1 ;				/* Assume TRUE for now and only */
   if(expr)				/* process first part of "if".  */
      print = 1 ;

   while (i = get_line()) {		/* Continue with next lines until "fi" */
      c = process_line() ;

      switch (c) {
         case 'i':			/* Nested "if". */
            process_if(p) ;
            break ;
         case '5':			/* Shell "fi". */
            return ;
         case '2':			/* Shell "then", do nothing. */
            break ;
         case '\0':			/* Null line, do nothing. */
            break ;
         case '3':			/* Shell "elif", do nothing for now. */
            if (print == 0) {
               expr = 0 ; /* Evaluate expr, 0 for now */
               if (expr) print = 1 ;
            }
            break ;
         case '4':			/* Shell "else", do nothing for now. */
            if (print == 0)
               print = 1 ;
               break ;
         case 'f':			/* Shell "for". */
            for_called_by = 'i' ;
            for_loop() ;
            --if_count ;
            if (if_count < -1)
               if_count = -1 ;
            break ;
         default :
            if (print) {
               fprintf(p, "%s\n", line) ;
            }
            break ;
      }
   }
}
