#include <stdio.h>
#include <pwd.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sgtty.h>
#include <sys/ttychars.h>
#include <sys/ttold.h>
/*#include <sys/suntty.h>*/
#include <sys/ioctl.h>
/*#include <sys/termios.h>*/
#include <sys/time.h>
#include <utmp.h>
#include <signal.h>
#include <sys/wait.h>

static void set_utmp (), unset_utmp ();
char *strcpy (), *malloc (), *ttyname ();
long time (), lseek ();

int pty_allocate (slave_name) char *slave_name;
 {
 	int i, fd;
 	
 	(void) strcpy (slave_name, "/dev/ptyp?");
 	
 	for (i = 0; i < 63; i++)
 	 {
 	 	slave_name[8] = 'p' + (i >> 4);
 	 	slave_name[9] = "0123456789abcdef"[i & 0xf];
 		if ((fd = open (slave_name, 2)) >= 0)
 		 {
 		 	slave_name [5] = 't';
 		 	return fd;
 		 }
 	 }
 	return -1;
 }

void pty_set_state (fd) int fd;
 {
 	static struct sgttyb b = { B9600, B9600, CERASE, CKILL, ECHO | CRMOD | CRTBS };
 	static struct tchars tc = { CINTR, CQUIT, CSTART, CSTOP, CEOF, CBRK };
 	static struct ltchars lc = { CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT };
 	static int lb = LCRTERA | LCRTKIL | LCRTBS | LCTLECH | LPENDIN | LDECCTQ;
 	static int l = NTTYDISC;
 	
	(void) ioctl(fd, TIOCSETD, (char *)&l);
	(void) ioctl(fd, TIOCSETP, (char *)&b);
	(void) ioctl(fd, TIOCLSET, (char *)&lb);
	(void) ioctl(fd, TIOCSLTC, (char *)&lc);
	(void) ioctl(fd, TIOCSETC, (char *)&tc);
 }

static int *tslot = NULL;

void pty_slot (master, slave_name) int master; char *slave_name;
 {
	FILE *fp;
	int slot;
	char buf [BUFSIZ];
	
	if ((fp = fopen ("/etc/ttys", "r")) >= 0) /* actually ttyslot, but that doesn't work later... */
	 {
	 	for (slot = 0; fgets (buf, BUFSIZ, fp); slot++)
	 		if (strncmp (buf + 2, slave_name + 5, 5) == 0)
	 			break;
	 	fclose (fp);
	 }
	++slot;
	if (tslot == NULL)
		tslot = (int *) malloc (sizeof (int) * getdtablesize ());
	tslot [master] = slot;
 }

static void pty_close_all ()
 {
	int i, n = getdtablesize ();
	
	for (i = 0; i < n; i++)
		(void) close (i);
 }

static int *ptypid = 0;

int pty_create (command, width, height, close_fn) char *command; int width, height; void (*close_fn)();
 {
	int master, pid, fd, fd2;
	char slave_name [20], *user_name;
	struct passwd *pw;
	
	master = pty_allocate (slave_name);
	
	if (master < 0)
		return -1;
	
	pty_slot (master, slave_name);
	fd = dup (master);
	fd2 = dup (master);
	close (fd);
	close (fd2);
	user_name = getpwuid (getuid ())->pw_name;
	/* doesn't work if it is much later because of yellow pages opening a file */
	close (fd);
	close (fd2);	
#ifdef BSD
	pid = vfork ();
#else
	pid = fork ();
#endif
	
	if (pid < 0)
		return -1;
	
	if (pid != 0)
	 {
	 	char *malloc ();
	 	
		if (ptypid == 0)
			ptypid = (int *) malloc (sizeof (int) * getdtablesize ());
		ptypid [master] = pid;
		
		return master;
	 }
	if (close_fn)
		(*close_fn)();
	else
		pty_close_all ();
	
	(void) close (master);
	(void) close (0);
	(void) setpgrp (getpid (), 0);
	(void) open ("/dev/tty", 0);
	(void) ioctl (0, TIOCNOTTY, 0);
	(void) close (0);
	(void) close (1);
	(void) close (2);
	(void) open (slave_name, 2);
	(void) dup (0);
	(void) dup (0);
	
	pty_set_state (0);
	pty_set_size (0, width, height);
	set_utmp (user_name, master, 0);
	signal (SIGINT, SIG_DFL);
	signal (SIGQUIT, SIG_DFL);
	execlp ("/bin/sh", "sh", "-c", command, (char *) 0);
	perror ("ptycreate");
	exit (1);
	return 0; /* keeps lint happy */
 }

int pty_close (fd) int fd;
 {
 	int wpid;
 	union wait status;
 	
 	unset_utmp (fd);
 	(void) close (fd);
 	while ((wpid = wait (&status)) != ptypid[fd] && wpid != -1)
 		;
 	return status.w_status;
 }

int pty_set_size (fd, width, height) int fd, width, height;
 {
#ifdef TIOCSWINSZ
	struct winsize s;
	
	s.ws_row = height;
	s.ws_col = width;
	s.ws_xpixel = s.ws_ypixel = 0;
	(void) ioctl (fd, TIOCSWINSZ, &s);
#endif
 }

int pty_set_console (fd, on) int fd, on;
 {
#ifdef sun
	if (on && ioctl (fd, TIOCCONS, &on))
		return 1;
		
	return 0;
#else
	return 1;
#endif
 }

static void set_utmp (user_name, master, slave) char *user_name; int master, slave;
 {
	struct utmp utmp;
	int i;
	
	if ((i = open ("/etc/utmp", O_WRONLY)) >= 0)
	 {
		(void) bzero((char *)&utmp, sizeof (struct utmp));
		(void) strcpy (utmp.ut_line, ttyname (slave) + 5);
		(void) strcpy (utmp.ut_name, user_name);
		(void) time (&utmp.ut_time);
		(void) lseek (i, (long) (tslot[master] * sizeof (struct utmp)), 0);
		(void) write (i, (char *) &utmp, sizeof (struct utmp));
		(void) close (i);
	 }
 }

static void unset_utmp (master) int master;
 {
	struct utmp utmp;
 	int i;
 	
 	if (tslot && tslot[master] > 0 && (i = open("/etc/utmp", O_WRONLY)) >= 0)
 	 {
		(void) bzero ((char *)&utmp, sizeof(struct utmp));
		(void) lseek (i, (long)(tslot[master] * sizeof(struct utmp)), 0);
		(void) write (i, (char *)&utmp, sizeof(struct utmp));
		(void) close (i);
	 }
 }
