#include <stdio.h>
#include <sys/fcntl.h>
#include <sys/termios.h>
#include <stropts.h>
#include <sys/resource.h>
#include <signal.h>
#include <sys/suntty.h>

#include <sys/stream.h>
#include <sys/eucioctl.h>
#include <sys/ldterm.h>

char *strcpy (), *malloc (), *ttyname (), *ptsname();

int pty_allocate (slave_name) char *slave_name;
{
	int	master;

	master = open("/dev/ptmx",O_RDWR);
	if (master < 0)
		return -1;

	grantpt(master);
	unlockpt(master);
	
	(void) strcpy (slave_name, ptsname(master));

	return master;
};

void pty_set_state (fd) int fd;
 {
	static struct termios t = {
		/* iflags */	BRKINT | ICRNL,	/* ~IXON  ~IMAXBEL */
		/* oflags */	OPOST | ONLCR,	/* ~TAB3 */
		/* cflags */	B9600,	/* ~CS8  ~CREAD */
		/* lflags */	ISIG | IEXTEN | ECHO | ECHOE | ECHOCTL  | ECHOKE | PENDIN,	/* ~ICANON  ~ECHOK  ECHOCTL  PENDIN */
		/* cc[] */	CINTR, CQUIT, CERASE, CKILL, 1, 0, CEOL2, CSTART, CSTOP, CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT /* MIN = 1, TIME = 0 */
				  };

	(void) ioctl(fd, I_PUSH, "ptem");
	(void) ioctl(fd, I_PUSH, "ldterm");
	(void) ioctl(fd, TCSETS, t);
 }

void pty_close_all ()
 {
	int i;
	struct rlimit limit;

	getrlimit (RLIMIT_NOFILE, &limit);
	
	for (i = 0; i < limit.rlim_cur; i++)
		(void) close (i);
 }

static int *ptypid = 0;

int pty_create (command, width, height, close_fn) char *command; int width, height; void (*close_fn)();
 {
	int master, slave, pid;
	char slave_name[20], cmd_buf[1024];

	strcpy(cmd_buf, command);

	master = pty_allocate (slave_name);
	
	pid = fork ();
	
	if (pid < 0)
		return -1;
	
	if (pid != 0) {				/* parent (=master) */
	 	char *malloc ();
		struct rlimit	limit;
	 	
		if (ptypid == 0) {
			getrlimit (RLIMIT_NOFILE, &limit);
			ptypid = (int *) malloc (sizeof (int) * limit.rlim_cur);
		};
		ptypid [master] = pid;
		
		return master;
	};
				/* child (=slave) */
	if (close_fn) {
		(*close_fn)();
		(void) close (master);
		(void) close (0);
		(void) close (1);
		(void) close (2);
	} else {
		pty_close_all ();
	};
	
	(void) setpgrp (getpid (), 0);
	(void) open ("/dev/tty", 0);
 	(void) ioctl (0, TIOCNOTTY, 0);
 	(void) close (0);
 
	slave = open (slave_name, O_RDWR);
	(void) dup (0);
	(void) dup (0);
	
	pty_set_state (0);
	pty_set_size (0, width, height);
	signal (SIGINT, SIG_DFL);
	signal (SIGQUIT, SIG_DFL);
	execlp ("/bin/sh", "sh", "-c", cmd_buf, (char *) 0);
	perror ("ptycreate");
	exit (1);
	return 0; /* keeps lint happy */
 }

int pty_close (fd) int fd;
 {
 	int wpid;
 	int status;
 	
 	(void) close (fd);
 	while ((wpid = wait (&status)) != ptypid[fd] && wpid != -1)
 		;
 	return status;
 }

int pty_set_size (fd, width, height) int fd, width, height;
 {
#ifdef TIOCSWINSZ
	struct winsize s;
	
	s.ws_row = height;
	s.ws_col = width;
	s.ws_xpixel = s.ws_ypixel = 0;
	(void) ioctl (fd, TIOCSWINSZ, &s);
#endif
	return fd;
 }

int pty_set_console (fd, on) int fd, on;
 {
#ifdef sun
	if (on && ioctl (fd, TIOCCONS, &on))
		return 1;
		
	return 0;
#else
	return 1;
#endif
 }

