#ifndef	TRACER_H
#define	TRACER_H


#include <stdarg.h>
#ifdef	DEBUG
#include <stream.h>
#include <strings.h>
	enum	trace_level { TRACE_ALL, TRACE_CTOR, NO_TRACE }; ////
class Tracer {
////	enum	trace_level { TRACE_ALL, TRACE_CTOR, NO_TRACE };
	static	trace_level	debug_level;
	static	char	spaces[128];
	static	int	indent;
public:
				Tracer(const char* fn_name ...);
				~Tracer();

	const	Tracer&	operator<<(const char* str) const;
	const	Tracer&	operator<<(const int) const;
	const	Tracer&	operator<<(const long) const;
};

#if DEBUG==0
inline
Tracer::Tracer(const char* format ...)
{}
inline
Tracer::~Tracer()
{}
#else DEBUG==0
inline
Tracer::Tracer(const char* format ...)
{
	if (format == (char*)0) {
		spaces[indent++] = 'X';
		spaces[indent] = '\0';
		return;
	} else {
		spaces[indent++] = ' ';
		spaces[indent++] = ' ';
		spaces[indent++] = ' ';
		spaces[indent] = '\0';
		if (debug_level < NO_TRACE) {
			char	buff[1024];
			char* bufptr = buff;
			if (!strchr(format, '%')) {
				bufptr = (char*) format;
			} else {
				va_list	ap;
				va_start(ap,format);
				vsprintf(bufptr, format, ap);
				va_end(ap);
			};
			cerr << "|" << spaces << "Entering " << bufptr << "\n";
		};
	};
};

inline
Tracer::~Tracer()
{
	if (spaces[indent] == 'X') {
		spaces[indent--] = '\0';
	} else {
		if (debug_level < NO_TRACE)
			cerr << "|" << spaces << "Returning\n";

		spaces[--indent] = '\0';
		spaces[--indent] = '\0';
		spaces[--indent] = '\0';
	};
};
#endif DEBUG==0


#if DEBUG < 2
inline
const	Tracer&	Tracer::operator<<(const char*) const
{	return *this; };
inline
const	Tracer&	Tracer::operator<<(const int) const
{	return *this; };
inline
const	Tracer&	Tracer::operator<<(const long) const
{	return *this; };

#else DEBUG < 2
inline
const Tracer&	Tracer::operator<<( const char* str) const
{
	if (debug_level < TRACE_CTOR)
		cerr << str;
	return *this;
};

inline
const Tracer&	Tracer::operator<<( const long l) const
{
	if (debug_level < TRACE_CTOR)
		cerr << l;
	return *this;
};

inline
const	Tracer&	Tracer::operator<<( const int i) const 
{
	if (debug_level < TRACE_CTOR)
		cerr << i;
	return *this;
};
#endif DEBUG < 2

#else DEBUG
	enum	trace_level { TRACE_ALL, TRACE_CTOR, NO_TRACE }; ////
class Tracer {
////	enum	trace_level { TRACE_ALL, TRACE_CTOR, NO_TRACE };
	static	trace_level	debug_level;
	static	char	spaces[1];
	static	int	indent;
public:
				Tracer(const char* ...);
				~Tracer();

	const	Tracer&	operator<<(const char*) const;
	const	Tracer&	operator<<(const int) const;
	const	Tracer&	operator<<(const long) const;
};
inline
Tracer::Tracer(const char* ...)
{};
inline
Tracer::~Tracer()
{};
inline
const	Tracer&	Tracer::operator<<(const char*) const
{	return *this; };
inline
const	Tracer&	Tracer::operator<<(const int) const
{	return *this; };
inline
const	Tracer&	Tracer::operator<<(const long) const
{	return *this; };

#endif  DEBUG

#endif	TRACER_H
