#ifndef	PTY_H
#define	PTY_H

#include	<osfcn.h>
#include	<string.h>

#define ERR     -1


class Pty {
protected:
	char*	name;
////	int	tty_slot;			/* Sunos4 */
	int	master_fd;
	int	cmd_pid;
	int	console;

	int	allocate(char *slave_name);
	void	set_state();
	void	close_all();
	int	set_console();
	void	slot (char *slave_name);
public:
	Pty(char* command, char* name=(char*)0, void (*close_fn)()=(void (*)())0);
	~Pty();

	int	fd();
	int	send(char* test, int len = -1);
	int	get(char* text, int no_chars);
	void	flush();
	void	set_win_size (int width, int height);
};


inline
int	Pty::fd()
{
	return master_fd;
};

inline
int	Pty::send(char* text, int len)
{
	int	n = write(master_fd, text, (len == -1 ? strlen(text) : len));
	return n;
};

inline
int	Pty::get(char* text, int no_chars)
{
	int	n = read(master_fd, text, no_chars);
	return n;
};

inline
void	Pty::flush()
{
////	tcflush(pty_fd,TIOFLUSH);
};

#endif
