#include	"Poster.h"

#include	"Tracer.h"

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */

Area*	get_area(char* area_name);


					/*** ctors ***/

Poster::Poster()
{
	Tracer trace("Poster::Poster()");

	area_list = new List(Area)();	// create empty list
};

Poster::~Poster()
{
	Tracer trace("Poster::~Poster()");

	delete area_list;
};


					/*** computational members ***/

void	Poster::new_area(Client_handler* from, char* area_name)
{
	Tracer trace("Poster::new_area(%s, %s)", from->name, area_name);

	Area*	a;
	if (!get_area(area_name)) {
		a = new Area(from, area_name);	// area doesn't exist
		area_list->append(a);
	};
};


void	Poster::post(Client_handler* from, char* area_name, char* text)
{
	Tracer trace("Poster::post(%s, %s, %s)", from->name, area_name, text);

	Area*	area;
	if (!(area = get_area(area_name)))
		return;				// area doesnt exist, ignore
	area->post (from, text);
};


void	Poster::query(Client_handler* from, char* area_name, char* text)
{
	Tracer trace("Poster::post(%s, %s, %s)", from->name, area_name, text);

	Area*	a;
	Entry*	e = NULLPTR(Entry);
	char	answer[512];

	if ((a = get_area(area_name)))
		e = a->match(text);
	sprintf(answer,"answer\t%s\t%s",area_name, e ? e->retrieve() : "");
	from->send_reply(answer);
};


void	Poster::dump(Client_handler* from, char* area_name, char* text)
{
	Tracer trace("Poster::dump(%s, %s, %s)", from->name, area_name, text);

	Area*	a;
	Entry*	ent;

	if (!(a = get_area(area_name)))
		return;				// nothing to dump
	while (ent = a->dump(text))
		from->send_reply(ent->retrieve());
};


		
Area*	Poster::get_area(char* area_name)
{
	Tracer trace("Poster::get_area(%s)", area_name);

	if (area_list == NULLPTR(List(Area)))   {
		cerr << "null area list\n";
		return(NULLPTR(Area));
	};

	Area*	a;
	List_iterator(Area)	area_iter(area_list);

	while (a = area_iter(FORWARD))
		if (!strcmp(area_name,a->name))
			return(a);
	return(NULLPTR(Area));
};


template_implement(List,Area);
