#include	"Notifier_entry.h"

#include	"Tracer.h"
#include	"stdlib.h"

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */



					/*** ctors ***/

Notifier_entry::Notifier_entry(Client_handler* from, char* area_name, char* reply_text)
{
	Tracer trace("Notifier_entry::Notifier_entry(%s, %s, %s)",
					from->name, area_name, reply_text);

	client = from;
	area = (char*)malloc(strlen(area_name)+1);
	strcpy(area, area_name);
	if (strlen(reply_text) == 0)
		reply_text = area_name;
	header = (char*)malloc(strlen(reply_text)+1);
	strcpy(header, reply_text);
};

Notifier_entry::~Notifier_entry()
{
	Tracer trace("Notifier_entry::~Notifier_entry()");

	free(area);
			free(header);
};



					/*** computational members ***/

Client_handler*	Notifier_entry::match(char* area_name)
{
	Tracer trace("Notifier_entry::match(%s)", area_name);

	return (!strcmp(area_name, area) ? client : NULLPTR(Client_handler));
};
