#include	"Notifier.h"

#include	"Tracer.h"

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */


					/*** ctors ***/

Notifier::Notifier()
{
	Tracer trace("Notifier::Notifier()");

	notifier_list = new List(Notifier_entry)(); // create empty list
};

Notifier::~Notifier()
{
	Tracer trace("Notifier::~Notifier()");

	delete notifier_list;
};



					/*** computational members ***/

void	Notifier::new_notifier_entry(Client_handler* from, char* area_name, char* reply_text)
{
	Tracer trace("Notifier::new_notifier_entry(%s, %s, %s)",
					from->name, area_name, reply_text);

	Client_handler*	c;
	Notifier_entry*	e;
	List_iterator(Notifier_entry)	entry_iter(notifier_list);

	while (e = entry_iter(FORWARD))
		if ((c = e->match(area_name))  &&
					!strcmp(from->name, c->name)){
			free (e->header);    // already notifying this client
			e->header = (char*)malloc(strlen(reply_text)+1);
			strcpy(e->header, reply_text);
			return;
		};
	e = new Notifier_entry(from, area_name, reply_text);
	notifier_list->append(e);
};


void Notifier::notify(Client_handler* from, char* area_name, char* text)
{
	Tracer trace("Notifier::notify(%s, %s, %s)", from->name, area_name, text);

	char	reply[1024];
	Client_handler*	c;
	Notifier_entry*	e;
	List_iterator(Notifier_entry)	entry_iter(notifier_list);

	while (e = entry_iter(FORWARD))
		if (c = e->match(area_name) )
			if (strcmp(c->name, from->name)) {
				sprintf(reply,"%s\t%s",e->header, text);
				c->write_mesg(reply);
			};
};


template_implement(List,Notifier_entry);
