#include	"Monitor.h"

#include	"Tracer.h"
#include	<osfcn.h>
#include	<string.h>


Monitor::Monitor()
{
	Tracer trace("Monitor::Monitor()");

	monitor_list = new List(char)(); 	// create empty list

	pipe = (Pty*)0;
	
};

Monitor::~Monitor()
{
	Tracer trace("Monitor::~Monitor()");

	delete monitor_list;
	if (pipe)   delete pipe;
};



					/*** computational members ***/

void	Monitor::display(Client_handler* client, char* area, char* header)
{
	Tracer trace("Monitor::display(%s, %s, %s)", client->name, area, header);

	if (strcmp(client->name, "Superuser"))	// only superuser can monitor
		return;
					// create (xi and) xi "buffer"
	char	buff[256];
	if (pipe == (Pty*)0) {
		trace	<< "starting xi\n";
		sprintf(buff, "xi -d /BB_area/%s\n\0", area);
		pipe = new Pty(buff, "IFE_monitor", (void (*)())0);
		sprintf(buff, "insert-line %s\n\0", area);
		trace	<< "xi< " << buff << "\n";
		pipe->send(buff, strlen(buff));
		sprintf(buff, "goto-line 99999\n\0");
	} else {
		sprintf(buff,"edit /BB_area/%s\n\0", area);
	};
	trace	<< "xi< " << buff << "\n";
	pipe->send(buff, strlen(buff));
	monitor_list->append(area);
					// label
	sprintf(buff, "insert-line %s\ninsert-line \n\0", header);
	trace	<< "xi< " << buff;
	pipe->send(buff, strlen(buff));
	sprintf(buff, "goto-line 99999\n\0");
	trace	<< "xi< " << buff;
	pipe->send(buff, strlen(buff));
					// update list of windows, in display order
	char	buf[BUFSIZ];
	sprintf(buff, "list-buffers\n\0");
	trace	<< "xi< " << buff << "\nxi> ";
	pipe->send(buff, strlen(buff));
	int	no_buffers = monitor_list->size();
	trace	<< "   n=" << no_buffers << "\n   ";
	while (pipe->get(buf, BUFSIZ) == BUFSIZ);		// flush xi's output
	List_iterator(char)	lst_iter(monitor_list);
	for (int  i = 0; i < no_buffers; i++)
		free(lst_iter[i]);
	monitor_list->clear();
	for (i = 0; i < no_buffers; i++) {
		int  n = pipe->get(buf, BUFSIZ);
		buf[n] = '\0';
		monitor_list->append(strdup(buf));
		trace	<< "  " << i << "=" << buf;
	};
	trace	<< "\n";
};

void	Monitor::display_cmd(char* cmd, char* data)
{
	Tracer trace("Monitor::display_cmd(%s, %s)", cmd, data);

	char	buff[256];
	int	window;
	if ((window = get_window("~")) == -1)
		return;				// area doesnt exist, ignore
	sprintf(buff,"choose-buffer %d\ngoto-line 99999\ninsert-line %s\t%s\n\0",
					window, cmd, data);
	trace	<< "xi< " << buff << "\nxi> ";
	pipe->send(buff, strlen(buff));
};

void	Monitor::display_req(char* cmd, char* data)
{
	Tracer trace("Monitor::display_req(%s, %s)", cmd, data);

	char	buff[256];
	int	window;
	if ((window = get_window("~")) == -1)
		return;				// area doesnt exist, ignore
	sprintf(buff,"choose-buffer %d\ngoto-line 99999\ninsert-line \t%s\t%s\n\0",
					window, cmd, data);
	trace	<< "xi< " << buff << "\nxi> ";
	pipe->send(buff, strlen(buff));
};

void	Monitor::post(Client_handler* from, char* area, char* data)
{
	Tracer trace("Monitor::post(%s, %s, %s)", from->name, area, data);

	char	buff[256];
	int	window;
	if ((window = get_window(area)) == -1)
		return;				// buffer doesnt exist, ignore
	sprintf(buff,"choose-buffer %d\ngoto-line 99999\ninsert-line %s\n\0",
					window, data);
	trace	<< "xi< " << buff << "\nxi> ";
	pipe->send(buff, strlen(buff));
};




int	Monitor::get_window(char* area_name)
{
	Tracer trace("Monitor::get_window(%s)", area_name);

	int	n = 0;

	List_iterator(char)	buf_iter(monitor_list);
	char* editor;
	while (editor = (char*)buf_iter(FORWARD))
		if (!strncmp(area_name, &editor[9], strlen(area_name))) {
			trace	<< "    editor <" << n << "> = " << editor << "\n";
			return n;
		} else
			n++;
	return -1;
};


template_implement(List,char);
