#ifndef LIST_H
#define	LIST_H

#include	<generic.h>
#include	<stream.h>
#include	<stdlib.h>

			// type itself may be parameterized, so must be 1st part
			// of result or it won't be expanded - unlike generic.h
#define sethandler(generic,type,x) name3(type,generic,_sethandler)(x)
#define template_declare(a,t) name2(a,declare)(t)
#define template_declare2(a,t1,t2) name2(a,declare)(t1,t2)
#define template_define(a,t) name2(a,define)(t)
#define template_define2(a,t1,t2) name2(a,define)(t1,t2)
#define template_implement(a,t) name2(a,implement)(t)
#define template_implement2(a,t1,t2) name2(a,implement)(t1,t2)

#define List(type) name2(type,PList)
#define Listlink(type) name2(type,PList_link)
#define List_iterator(type) name2(type,PList_iterator)

#define	BACKWARD	-1
#define RESET		0
#define FORWARD		1

#define Listdeclare(type)						\
  class	List(type);							\
  class	List_iterator(type)

#define Listdefine(type)						\
  typedef	type*	name2(type,P);					\
  extern GPT errorhandler(List,type);					\
  extern GPT sethandler(List,type,GPT);					\
  class List_iterator(type);                                            \
									\
  class Listlink(type) {						\
  public:								\
	Listlink(type)*	next;						\
	Listlink(type)*	prev;						\
	type*		entry;						\
									\
	Listlink(type)(type* e, Listlink(type)* a, Listlink(type)* b);	\
  };									\
									\
  class	List(type) {							\
  protected:								\
  friend	List_iterator(type);					\
	Listlink(type)*	head;						\
	Listlink(type)*	tail;						\
	int		length;						\
	Listlink(type)*	find(type*);					\
  public:								\
	List(type) ();							\
	List(type) (type* a);						\
	List(type) (const List(type)& lst);			/*shallow copy*/\
	~List(type) ();							\
									\
	List(type)&	operator=(const List(type)& lst);	/*shallow copy*/\
	List(type)&	operator+=(const List(type)& lst);	/*shallow copy*/\
  friend List(type)	operator+(const List(type)& lst);	/*shallow copy*/\
									\
	int	size() const;							\
	void	append(type* a);					\
	void	append(type* a, type* b);				\
	void	insert(type* a);					\
	void	insert(type* a, type* b);				\
	void	remove(type* a);					\
	type*	first() const;							\
	type*	last() const;							\
	void	clear();						\
  };									\
									\
									\
  class	 List_iterator(type) {						\
  protected:								\
	Listlink(type)*	next_item;					\
	List(type)*	list;						\
  public:								\
	List_iterator(type)    (List(type)* lst);			\
	List_iterator(type)    (const List_iterator(type)& lst_iter);		\
									\
	List_iterator(type)&   operator=(const List_iterator(type)& lst_iter);\
									\
	type* operator() (int d);					\
	type* operator[] (int a) const;						\
	int	size() const;							\
  }


#define Listimplement(type)						\
  typedef	type*	name2(type,P);					\
  extern	error(int err_no, char* err_str);			\
  GPT	errorhandler(List,type) = error;				\
  GPT	sethandler(List,type, GPT a)					\
  {									\
	GPT oo = errorhandler(List,type);				\
	errorhandler(List,type) = a;					\
	return oo;							\
  };									\
									\
  Listlink(type)::Listlink(type)(type* e, Listlink(type)* a,		\
					  Listlink(type)* b)		\
  {									\
	entry = e; next = b; prev = a;					\
	if (a)    a->next = this;					\
	if (b)    b->prev = this;					\
  };									\
									\
  Listlink(type)*	List(type)::find(type* where)			\
  {	Listlink(type)* lp;						\
	for (lp = head; lp->entry != where  &&  lp != 0; lp = lp->next);\
	return lp;							\
  };									\
									\
									\
		/****************************************/		\
									\
  List(type)::List(type)()						\
  {									\
	head = tail = 0;						\
	length = 0;							\
  };									\
									\
  List(type)::List(type)(type* a)					\
  {									\
	head = tail = new Listlink(type)(a, 0, 0);			\
	length = 1;							\
  };									\
									\
  List(type)::List(type)(const List(type)& lst)				\
  {									\
	head = tail = 0;						\
	length = 0;							\
	(void) operator+=(lst);						\
  };									\
									\
  List(type)::~List(type)()						\
  {									\
	clear();							\
  };									\
									\
  List(type)&	List(type)::operator=(const List(type)& lst)			\
  {									\
	if (this == &lst)   return (*this);				\
									\
	clear();							\
	return operator+=(lst);						\
  };									\
									\
									\
  List(type)&	List(type)::operator+=(const List(type)& lst)			\
  {									\
	Listlink(type)* nextlink = lst.head;				\
	while (nextlink) {						\
		tail = new Listlink(type)(nextlink->entry, tail, 0);	\
		if (!head)   head = tail;				\
		length++;						\
		nextlink = nextlink->next;				\
	};								\
	return *this;							\
  };									\
									\
									\
  List(type)	operator+(const List(type)& lst1, const List(type)& lst2)		\
  {									\
	List(type) newlst(lst1);					\
	newlst += lst2;							\
									\
	return newlst;							\
  };									\
									\
									\
  void	List(type)::append(type* a)					\
  {									\
	tail = new Listlink(type)(a, tail, 0);				\
	if (!head)   head = tail;					\
	length++;							\
  };									\
									\
  void	List(type)::append(type* a, type* where)			\
  {	Listlink(type)*	lp;						\
	if (!head  ||  !where) {	/* empty list || null where */	\
		append (a);		/*       put at tail */		\
		return;							\
	};								\
					/* locate 'where' on list */	\
	if (!(lp = find(where))) {					\
		callerror(List, type, 1,	/* not found */		\
		  "List(type)::append(type*,type*) - arg2 not on list");\
	    	return;							\
	};								\
	if (!lp->next)							\
		tail = new Listlink(type)(a, lp, lp->next);		\
	else								\
		(void) new Listlink(type)(a, lp, lp->next);		\
	length++;							\
  };									\
									\
  void	List(type)::insert(type* a)		/* insert before head */\
  {									\
	head = new Listlink(type)(a, 0, head);				\
	if (!tail)   tail = head;					\
	length++;							\
  };									\
									\
  void	List(type)::insert(type* a, type* where)   /* insert before b */\
  {	Listlink(type)*	lp;						\
									\
	if (!head  ||  !where) {	/* empty list || null where */	\
		insert (a);		/*       put at head */		\
		return;							\
	};								\
					/* locate 'where' on list */	\
	if (!(lp = find(where))) {					\
		callerror(List, type, 2,	/* not found */		\
		  "List(type)::insert(type*,type*) - arg2 not on list");\
	    	return;							\
	};								\
									\
	if (!lp->prev)							\
		head = new Listlink(type)(a, lp->prev, lp);		\
	else								\
		(void) new Listlink(type)(a, lp->prev, lp);		\
	length++;							\
  };									\
									\
									\
  void	List(type)::remove(type* what)					\
  {	Listlink(type)*	lp;						\
									\
	if (!head  ||  !what  ||  !(lp = find (what))) {		\
		callerror(List, type, 3,  /* empty list || null what */	\
		  "List(type)::remove(type*) - arg1 not on list");	\
		return;							\
	};								\
									\
	if (!lp->prev)				/* link back */		\
		head = lp->next;					\
	else								\
		lp->prev->next = lp->next;				\
	if (!lp->next)				/* link forward */	\
		tail = lp->prev;					\
	else								\
		lp->next->prev = lp->prev;				\
									\
									\
	delete lp;			/* free up link storage */	\
	length--;							\
  };									\
									\
									\
  int	List(type)::size() const						\
  {									\
	return length;							\
  };									\
									\
									\
  type*	List(type)::first() const						\
  {									\
	if (!head) {							\
		callerror(List, type, -4,  /* empty list */		\
		  "List(type)::first() - empty list");			\
		return (type*) 0;					\
	};								\
	return (head->entry);						\
  };									\
									\
									\
  type*	List(type)::last() const						\
  {									\
	if (!head) {							\
		callerror(List, type, -5,  /* empty list */		\
		  "List(type)::last() - empty list");			\
		return (type*) 0;					\
	};								\
	return (tail->entry);						\
  };									\
									\
									\
  void	List(type)::clear()						\
  {									\
	if (!head)			/* empty list */		\
		return;							\
									\
	length = 0;							\
									\
        while ( head != 0) {            /* free all link storage */     \
                tail = head->next;                                      \
                delete head;                                            \
                head = tail;                                            \
        };                                                              \
  };									\
									\
									\
		/****************************************/		\
									\
  List_iterator(type)::List_iterator(type) (List(type)* lst)		\
  {									\
	list = lst;							\
	next_item = 0;							\
  };									\
									\
   List_iterator(type)::List_iterator(type) (const List_iterator(type)& l_itr)\
  {									\
	list = l_itr.list;						\
	next_item = l_itr.next_item;					\
  };									\
									\
									\
  List_iterator(type)&   List_iterator(type)::operator=(		\
					 const List_iterator(type)& lst_iter) \
  {									\
	if (this == &lst_iter)   return (*this);			\
									\
	list = lst_iter.list;						\
	next_item = lst_iter.next_item;					\
									\
	return *this;							\
  };									\
									\
  type*	List_iterator(type)::operator()(int direction)			\
  {									\
	if (!list->head) {						\
		callerror(List, type, -6,  /* empty list */		\
		  "List_iterator::() - empty list");			\
		return (type*) 0;					\
	};								\
									\
	if (!direction || next_item==(direction>0? list->tail: list->head)){\
		next_item = 0;			/* off end of list */	\
		return 0;						\
	};								\
	if (!next_item)				/* null => restart */	\
		next_item = (direction>0 ? list->head:  list->tail);	\
	else								\
		next_item = (direction>0? next_item->next: next_item->prev);\
	return (next_item->entry);					\
  };									\
									\
  type*	List_iterator(type)::operator[](int index) const			\
  {	Listlink(type)*	lp = list->head;				\
	int		count = 0;					\
									\
	if (!list->head) {						\
		callerror(List, type, 7,  /* empty list */			\
		  "List_iterator::[] - empty list");			\
		return (type*) 0;					\
	};								\
									\
	for (; count < index  &&  lp != list->tail; count++, lp = lp->next);\
	if (count != index) {						\
		callerror(List, type, 8,  /* not on list */		\
		  "List_iterator::[] - index out of range");		\
		return (type*) 0;					\
	};								\
									\
	return lp->entry;						\
  };									\
									\
									\
  int	List_iterator(type)::size() const					\
  {									\
	return list->length;						\
  }
#endif
