#include	"Entry.h"

#include	"Tracer.h"
#include	<stream.h>
#include	<ctype.h>

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */



					/*** ctors ***/

Entry::Entry(Client_handler* from, char* entry_text)
{
	Tracer trace("Entry::Entry(%s, %s)", from->name, entry_text);

	poster = from;
	timestamp = transaction_no++;
	text = (char*)malloc(strlen(entry_text)+1);
	strcpy(text, entry_text);
};

Entry::~Entry()
{
	Tracer trace("Entry::~Entry()");

	free(text);
};


					/*** access members ***/

char* Entry::retrieve_all ()
{
	Tracer trace("Entry::retrieve_all()");

	char*	entry_text;
	entry_text = (char*)malloc((unsigned)(strlen(text) + strlen(poster->name) + 8));
	(void) sprintf(entry_text,"%s\t%5d\t%s",poster->name,timestamp,text);
	return (entry_text);
};


char* Entry::retrieve ()
{
	Tracer trace("Entry::retrieve()");

	return (text);
};


Entry* Entry::match (char* entry_text)
{	char	*next_match, *next_text;

	Tracer trace("Entry::match(%s)", entry_text);
					// test each word against entry text
	next_match = entry_text;
	next_text = text;
	while (!strncmp(next_text,next_match,strcspn(next_match," \t\n\r\f"))
		|| !strncmp(next_match, "?",1)){ // wildcard matches anything
		while (!isspace(*next_match++))
			if (!*next_match) // fallen off end of match=> match
				return (this);
		while (!isspace(*next_text++))
			if (!*next_text) // fallen off end of entry=> nomatch
				return (NULLPTR(Entry));
	};
	return (NULLPTR(Entry));	// no match
};
