#ifndef CLIENT_H
#define	CLIENT_H

#include	<sys/time.h>
#include	<sys/types.h>
#include	<stream.h>
#include	<string.h>

#define	ACK	">"
#define	NOLOCK	-1
#define	OFF	0
#define	ON	1
#define	IN	0
#define	OUT	1
#define	ERR	-1


class Client_handler {
	char*	in_buff;
	char*	out_buff;
	int	nchr, in_buf_sz, out_buf_sz;
	int*	channel;		// use as 'int channel[2]' structure
	int	out_lock;		// don't output until prompted

	int*	spawn_client(char* name, char* prog, char* args);
	void	send();
public:
	char*	name;
	int	selector;

	Client_handler(char* client_name);
	Client_handler(char* client_name, char* prog, char* args);
	~Client_handler();

	void	event_handler(fd_set selected);
	int	read_msg(char* buff);
	void	write_mesg(char* buff);
	void	send_reply(char* buff);
};
#endif
