#include	"Client.h"

#include	"Tracer.h"
#include	"stdlib.h"
#include	<osfcn.h>

extern void	CloseDown(Client_handler* from);



				/*** ctors ***/

Client_handler::Client_handler(char* client_name)    // dummy client on stdio
{
	Tracer trace("Client_handler(~)::Client_handler(%s)", client_name);

	name = (char*)malloc(strlen(client_name)+1);
	strcpy(name,client_name);
	in_buff = (char*)malloc(in_buf_sz = 512);
	out_buff = (char*)malloc(out_buf_sz = 512);
	nchr = 0;
	out_lock = ON;				// dont need prompt to start
						// connect to stdio
	channel = (int*)malloc(2*sizeof(int));
	setbuf (stdin,(char*)NULL);
	setbuf (stdout,(char*)NULL);
	channel[IN] = 0;
	channel[OUT] = 1;

	selector = channel[IN];
};

Client_handler::Client_handler(char* client_name, char* prog, char* args)
{
	Tracer trace("Client_handler(~)::Client_handler(%s, %s, %s)", client_name, prog, args);

	name = (char*)malloc(strlen(client_name)+1);
	strcpy(name,client_name);
	in_buff = (char*)malloc(in_buf_sz = 512);
	out_buff = (char*)malloc(out_buf_sz = 512);
	nchr = 0;
	out_lock = ON;				// dont need prompt to start

	channel = spawn_client(name, prog, args);

	selector = channel[IN];
};

Client_handler::~Client_handler()
{
	Tracer trace("Client_handler(%s)::~Client_handler()", name);

	close (channel[OUT]);
	close (channel[IN]);
	free(name);
	free(in_buff);
	free(out_buff);
	free((char*)channel);
};


					/*** computational members ***/

void Client_handler::event_handler(fd_set selected)
{	char	c;
	int	n;

	Tracer trace((char*)0);	// no ctor msgs, see trace msgs below

	if (!(FD_ISSET(channel[IN], &selected)))
		return;				/* event not for us */
//	trace << "Client_handler(" << name << "@" << channel[IN
//	      << ")::event_handler(" <<  selected.fds_bits[1] << ")";
	n = read(channel[IN], &c, 1);
	c = c&0177;
	switch (n) {
	    case -1:				/* pipe error */
		cerr << "BB - pipe to " << name << " broken\n";
		CloseDown(this);
		abort();
	    case 0: 				/* pipe closed */
		trace	<< "BB - pipe to " << name << " closed\n";
		if (nchr != 0  &&  in_buff[nchr-1] == '\n')
			in_buff[nchr++] = '\n';
		if (nchr >= in_buf_sz + 12)
			in_buff = (char*)realloc(in_buff, (in_buf_sz += 512));
		strcat(&in_buff[nchr],"kill_me\n");
		nchr += 13;
		in_buff[nchr] = '\0';
		break;
			
	    default:				/* got a character */
		if (nchr == in_buf_sz)
			in_buff = (char*)realloc(in_buff, (in_buf_sz += 512));
		in_buff[nchr++] = c;
		in_buff[nchr] = '\0';
		trace << "got " << in_buff[nchr-1];

		n = strlen(ACK);
		if (c == '>')
		if (nchr >= n  &&
			!strncmp(ACK, &in_buff[nchr - n], n)  && 
			(nchr == n || in_buff[nchr - n-1] == '\n' )) {
				send();
				nchr -= n;
				in_buff[nchr] = '\0';
			break;
		};
	};
	trace << "\n";
};

int	Client_handler::read_msg(char* buff)
{	
	Tracer trace((char*)0);	// no ctor msg, see trace output msgs below
	char*	p = in_buff;
	char*	q = buff;

	if (!strchr(in_buff,'\n')) {		// \n => complete message
//		trace << "    Client_handler(" << name << ")::read_msg())\n";
		return(0);
	};
	while (*p != '\n')			// copy to argument
		*q++ = *p++;
	*q = '\0';
	q = in_buff;				// copy remaining chrs down
	while (++p - in_buff < nchr)
		*q++ = *p;
	nchr -= strlen(buff)+1;			// remember the '\n'
	in_buff[nchr] = '\0';
		trace << "    Client_handler(" << name << ")::read_msg("
		      << buff << ")\n";
	return(1);
};
		


void	Client_handler::write_mesg(char* buff)
{
	Tracer trace("Client_handler(%s)::write_mesg(%s)", name, buff);

	if ((strlen(out_buff) + strlen(buff) + 2) > out_buf_sz)
		out_buff = (char*)realloc(out_buff, (out_buf_sz += 512));
	strcat(out_buff, buff);
	strcat(out_buff,"\n\0");
					// check if waiting for output
	if ((out_lock == OFF) || (channel[OUT] == 1))
		send();
};

void	Client_handler::send()
{	char*	p, *q = out_buff;

	Tracer trace("Client_handler(%s)::send(...)", name, out_buff);

	out_lock = OFF;				/* enable output */
	if (strlen(out_buff) == 0)
		return;				/* nothing to output */

	p = strchr(out_buff,'\n');		/* output 1st line */
	*p++ = '\0';
	write(channel[OUT],out_buff,strlen(out_buff));
	write(channel[OUT],"\n",1);
	trace	<< "<" << out_buff << ">\n";
	while (*q++ = *p++);			/*copy remaining chrs down*/
	out_lock = ON;
};
		
	
void	Client_handler::send_reply(char* buff)	/* client waiting for ans */
{	int	n;

	Tracer trace("Client_handler(%s)::send(%s)", name, buff);

	if (n = strlen(buff)) {
		write(channel[OUT],buff,strlen(buff));
		write(channel[OUT],"\n",1);
	};
};

char*	ReplEnv(char* string)
{
	char*	c;
	char*	env_var = string;
	char*	remainder;
	char*	new_var = NULL;
	int	size;

	if((c=strchr(env_var,'$'))!=NULL)
	{
		env_var++;
		if((c=strchr(env_var,'/'))!=NULL)
		{
			remainder = c+1;
			*c='\0';
			env_var = getenv(env_var);
			size = strlen(env_var)+strlen(remainder)+1;
			new_var=(char*)malloc(size);
			strcat(new_var,env_var);
			strcat(new_var,remainder);
			new_var[size] = '\0';
		}
	}
	return(new_var);
}

int*	Client_handler::spawn_client (char* name, char* prog, char* args)
{	int*	pipes = (int*)malloc(2*sizeof(int));
	int	pipe_in[2], pipe_out[2];
	int	argc;
	pid_t	pid;
	char*	argv[10];
	char	prog_name[256];
	char*	c;

	Tracer trace("Client_handler(%s)::spawn_client(%s, %s)", name, prog, args);

	pipe (pipe_in);
	pipe (pipe_out);
	if ((pid = fork()) == ERR) {
		cerr <<"BB - couldn't start "<< name <<" \n";
		CloseDown(this);
		abort();
	};
	if (pid == 0) {				// child
		dup2 (pipe_out[IN], 0);
		dup2 (pipe_in[OUT], 1);
		close (pipe_out[OUT]);
		close (pipe_in[IN]);
		setbuf (stdout,(char*)NULL);
		setbuf (stdin,(char*)NULL);
		argv[0] = name;
		argc = 1;
		argv[argc++] = strtok(args,"[ \t]");
		if (strlen(args))
			while (argv[argc++] = strtok(NULL,"[ \t]"))
			     if((c=strchr(argv[argc-1],'$'))!=NULL)
				 argv[argc-1] = ReplEnv(argv[argc-1]);
		strcpy(prog_name,getenv("IFE_HOME"));
		strcat(prog_name,"bin/");
		strcat(prog_name,prog);
		trace << "BB - starting " << name
		      << "     as " << prog_name << "("	<< argv[0] << ","
							<< argv[1] << ","
							<< argv[2] << ","
							<< ")\n";
		execvp(prog_name,argv);
		cerr <<"BB - couldn't start"<< name <<" \n";
		exit(0);
	};
		/* kludge for "nip", cant self start */
		if (!strcmp(prog,"ife_ukh")  ||
		    !strcmp(prog,"ife_umkh")  ||
		    !strcmp(prog,"ife_akh"))
			write(pipe_out[OUT],"startup.\n",9);
	close(pipe_out[IN]);
	close(pipe_in[OUT]);

			// return pointer to 'int pipes[2]' type struct 
	pipes[IN] = pipe_in[IN];
	pipes[OUT] = pipe_out[OUT];
	return(pipes);
};
