#include	<sys/time.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<stream.h>
#include	<stdlib.h>
#include	"Tracer.h"
#include	"List.h"
#include	"Client.h"
#include	"Poster.h"
#ifdef	MONITOR
#include	"Monitor.h" 
#endif	MONITOR
#include	"Notifier.h"

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */

template_define(List,Client_handler);
template_implement(List,Client_handler);

List(Client_handler)*	client_list;
Poster*		poster;
Notifier*	notifier;
int		transaction_no = 0;
char*		BLACKBOARD = "IFE_blackboard";



		
void CloseDown(Client_handler* from)
{
};


char* decap(char** text, char* separators)
{	char	*token;

	token = *text;
	*text = strpbrk(*text, separators);
	if (*text)
		while (strchr(separators,**text))    // relpace sep by nulls
			*(*text)++ = '\0';
	else
		*text = token + strlen(token);	     // no sep => one token
	return(token);
};


main(int /*argc*/, char** argv)
{	Client_handler*	c;
	FILE*	agent_file;
	char	agent_filename[256];
	int	n;
	fd_set	wrt, rd, ex, in_channels;
	char	*cmd, *prog, *name, *args;
	char	*area, *question, *reply, *data, *header;
	char	buff[512], *buffptr = buff;

	Tracer trace("IFe Blackboard: main()");
	argv[0][0] = 'I';
	argv[0][1] = 'F';
	argv[0][2] = 'E';
	notifier = new Notifier();
	poster = new Poster();
#ifdef	MONITOR
	Monitor* monitor = new Monitor();
#endif	MONITOR
	setbuf(stdout,(char*)NULL); 
	setbuf(stdin,(char*)NULL); 
/*
 *	create default clients
 */
	trace << "BB - creating superuser client\n";
	c = new Client_handler("Superuser");
	client_list = new List(Client_handler) (c);
	FD_ZERO(&in_channels);
	FD_SET(0, &in_channels);
	strcpy(agent_filename,getenv("IFE_HOME"));
	strcat(agent_filename,"lib/startup/bb_clients");
	if ((agent_file = fopen(agent_filename,"r")) == (FILE*)NULL) {
		fprintf(stderr,"Can't open file %s", agent_filename);
	} else {
		trace << "BB - creating other clients\n";
		prog = (char*)malloc(512);
		name = (char*)malloc(512);
		args = (char*)malloc(512);
		while ((n = fscanf (agent_file, "%s	%s	%[^\n]\n",
					name, prog, args)) != EOF) {
			if (n < 2) {
				fprintf(stderr,"Bad entry in file AGENTFILE\n");
				CloseDown(NULLPTR(Client_handler));
				break;
			};
			c = new Client_handler(name, prog, args);
			trace << "   - " << name << "@" << c->selector << "\n";
			client_list->append(c);
			FD_SET(c->selector, &in_channels);	// see client.h
		};
		free(prog);
		free(name);
		free(args);
	};
/*
 *	event handling loop
 */
	trace << "BB - blackboard started processing -\n";
	List_iterator(Client_handler) client_iter(client_list);
	while(1) {
/*
 *		get next event, if any
 */
		FD_ZERO(&wrt);
		rd = ex = in_channels ;
		n = select (32, &rd, &wrt, &ex, (struct timeval *)NULL);
		if (n != 0) {
/*
 *			got event, check which client to send it to
 */
			client_iter(RESET);
			while (c = client_iter(FORWARD))
				c->event_handler(rd);
		};
/*
 *	    handle any incoming mesages from clients
 *		NOTE mesg priority scheduler should go here -
 *			currently uses round robin, in client creation order
 *			currently handles all internal mesgs before clients
 */
		client_iter(RESET);
		while (c = client_iter(FORWARD))
			if (c->read_msg(buff)) {
				if (strlen(buff) == 0)   break;
				buffptr = buff;
				cmd = decap(&buffptr, "\t");
				if (!cmd)	continue;
				if (!strcmp(cmd,"abort")) {
					CloseDown(c);
					exit(0);
				} else if (!strcmp(cmd, "new_client" )) {
#ifdef	MONITOR
					monitor->display_cmd(cmd, buffptr); 
#endif	MONITOR
					name = decap(&buffptr, "\t");
					prog = decap(&buffptr, "\t");
					args = buffptr;
					c=new Client_handler(name,prog,args);
					client_list->append(c);
					FD_SET(c->selector, &in_channels);
				} else if (!strcmp(cmd, "kill_me" )) {
#ifdef	MONITOR
					monitor->display_cmd(cmd, buffptr); 
#endif	MONITOR
					client_list->remove(c);
					FD_CLR(c->selector, &in_channels);
					delete c;
					break;	    // nb. iterator clobbered
				} else if (!strcmp(cmd, "monitor" )) {
					area = decap(&buffptr, "\t");
					header = buffptr;
#ifdef	MONITOR
					monitor->display(c, area, header);
#endif	MONITOR
				} else if (!strcmp(cmd, "notify_me" )) {
#ifdef	MONITOR
					monitor->display_req(cmd, buffptr); 
#endif	MONITOR
					area = decap(&buffptr, "\t");
					reply = buffptr;
					notifier->new_notifier_entry(c,
								area, reply);
				} else if (!strcmp(cmd, "update_me")){
#ifdef	MONITOR
					monitor->display_req(cmd, buffptr); 
#endif	MONITOR
					area = decap(&buffptr, "\t");
					reply = buffptr;
					notifier->new_notifier_entry(c,
								area, reply);
					poster->dump(c, area, "");
				} else if (!strcmp(cmd, "mk_area" )) {
#ifdef	MONITOR
					monitor->display_cmd(cmd, buffptr); 
#endif	MONITOR
					area = decap(&buffptr, "\t");
					poster->new_area(c, area);
				} else if (!strcmp(cmd, "query" )) {
#ifdef	MONITOR
					monitor->display_req(cmd, buffptr); 
#endif	MONITOR
					area = decap(&buffptr, "\t");
					question = buffptr;
					poster->query(c, area, question);
				} else if (!strcmp(cmd, "dump" )) {
#ifdef	MONITOR
					monitor->display_req(cmd, buffptr); 
#endif	MONITOR
					area = decap(&buffptr, "\t");
					question = buffptr;
					poster->dump(c, area, question);
				} else  if (!strcmp(cmd, "post" )) {
					area = decap(&buffptr, "\t");
#ifdef	MONITOR
					monitor->post(c, area, buffptr); 
#endif	MONITOR
					data = buffptr;
					poster->post(c, area, data);
					notifier->notify(c, area, data);
				} else {	// assume cmd is "post"
					area = cmd;
#ifdef	MONITOR
					monitor->post(c, area, buffptr); 
#endif	MONITOR
					data = buffptr;
					poster->post(c, area, data);
					notifier->notify(c, area, data);
				};
			};
	};
};

