#include	"Area.h"

#include	"Tracer.h"

#define	NULLPTR(x)	((x *)0)		/* null coerced to type x */


					/*** ctors ***/

Area::Area(Client_handler* from, char* area_name)
{

	Tracer trace("Area(~)::Area(%s, %s);", from->name, area_name);

	name = (char*)malloc(strlen(area_name)+1);
	strcpy(name, area_name);

	Entry*	first_entry = new Entry(from, strcat(area_name,"\tinitialized"));
	entry_list = new List(Entry)(first_entry);
};

Area::~Area()
{
	Tracer trace("Area(%s)::~Area()", name);

	free(name);
	delete entry_list;
};



					/*** computational members ***/

void	Area::post(Client_handler* from, char* text)
{
	Tracer trace("Area(%s)::post(%s, %s)", name, from->name, text);

	Entry*	entry = new Entry(from, text);
	entry_list->append(entry);
};


Entry*	Area::match(char* text)
{
	Tracer trace("Area(%s)::match(%s)", name, text);

	List_iterator(Entry)	entry_iter(entry_list);
	Entry*		p;
	while (p = entry_iter(BACKWARD))
		if (p->match(text))
			return (p);
	return (NULLPTR(Entry));
};


Entry*	Area::dump(char* text)
{
	Tracer trace("Area(%s)::dump(%s)", name, text);

	static	Entry*	dump_ptr;
	static	List_iterator(Entry)*	next_entry;
	if (!dump_ptr) {
		next_entry = new List_iterator(Entry)(entry_list);
						// no dump in progress
		dump_ptr = (*next_entry)(FORWARD);
		if (strlen(text))			// dump from matching entry
			while (!dump_ptr->match(text))	//	-> latest
				dump_ptr = (*next_entry)(FORWARD);
	};

	dump_ptr = (*next_entry)(FORWARD);
	return (dump_ptr);
};



template_implement(List,Entry)
