/* IFE program handler */
#include	<stdio.h>
#include	<string.h>
#include	<errno.h>
#include	<sys/time.h>

#define	CSEP	(char)9			/* '\t' */
#define	MAX_NO_DIALOGS		10
#define	MAX_NO_APPLICATIONS	50
#define	NULL	0
#define	TRUE	1
#define	FALSE	0
#define	READ	0
#define	WRITE	1
#define	HEAD	0
#define	TAIL	1
#define	ERR	-1

char		csep = CSEP;
static int	in_channels = 1;

static int	no_dialogs = 0;

static	struct {
	char		name[64];	/* name (kb alias) of dialog */
	char		args[64];	/* program args */
	int		running;	/* program status */
	char		progtype[64];	/* dialog driver type (bb, nip) */
	char		prog[64];	/* dialog driver location (from $IFE) */
	int		channel[2];	/* io channels for communication */
} dialogs[MAX_NO_DIALOGS];

char	buf[MAX_NO_DIALOGS][512], * bufptr[MAX_NO_DIALOGS];


char*	ReplEnv(string) char* string;
{
	extern char* getenv();
	char*	c;
	char*	env_var = string;
	char*	remainder;
	char*	new_var = NULL;
	int	size;

	if((c=strchr(env_var,'$'))!=NULL)
	{
		env_var++;
		if((c=strchr(env_var,'/'))!=NULL)
		{
			remainder = c+1;
			*c='\0';
			env_var = getenv(env_var);
			size = strlen(env_var)+strlen(remainder)+1;
			new_var=(char*)malloc(size);
			strcat(new_var,env_var);
			strcat(new_var,remainder);
			new_var[size] = '\0';
		}
	}
	return(new_var);
}

Decapitate (buf, head, body)
char	* buf, ** head, **body;
{
	*head = buf;
	*body = *head;
	while (**body!=csep && **body!='\0')
		(*body)++;
	if (**body!='\0')   *(*body)++ = '\0';
	if (**body=='\t')
		(*body)++;
};




CloseDown(by)
int	by;
{	int	a;

	fprintf (stderr,"%s aborted, AH closing session\n",dialogs[by].name);
					/* notify all other kb's*/
	for (a = 1; a <= no_dialogs; a++) {
		fprintf(stderr,"	aborting %s\n", dialogs[a].name);
		if (a != by)
		    if (!strcmp(dialogs[a].progtype,"form"))
			write (dialogs[a].channel[WRITE], "quit\n", 5);
		    else
			write (dialogs[a].channel[WRITE], "abort\n", 6);
	};
};




/* name = design function, progtype & prog are application name, args = rest of parameters */
SpawnDialog(name, progtype, prog, args)
char	* name, * progtype, * prog, * args;
{	int	a, pid, pipe_in[2], pipe_out[2], argc;
	char	*c, prog_file[256], **argv;

	for (a = 1; a <= no_dialogs; a++)
 		if (!strcmp(dialogs[a].prog, prog)  &&
 					dialogs[a].running != TRUE) {
			break;
 		};
 
	if (a > no_dialogs) {
		no_dialogs++;			/* 1st invocation */
		bufptr[a] = buf[a];
		strcpy(dialogs[a].name, name);
		strcpy(dialogs[a].progtype, progtype);
		strcpy(dialogs[a].prog, prog);
		strcpy(dialogs[a].args, args);
	};
	pipe (pipe_in);
	pipe (pipe_out);
	if ((pid=fork()) == ERR)
		fprintf (stderr,"AH - couldn't fork %s<%s>\n", dialogs[a].prog, dialogs[a].name);
	if (pid == 0) {
		dup2 (pipe_out[READ], 0);
		dup2 (pipe_in[WRITE], 1);
		close (pipe_out[WRITE]);
		close (pipe_in[READ]);
		setbuf(stdout,(char*)NULL); 
		*prog_file = '\0';
		if (*dialogs[a].prog != '/') {
			strcpy(prog_file, getenv("IFE_HOME"));
			strcat(prog_file, "sys/bin/IFe_");
		};
		strcat(prog_file, dialogs[a].prog);
		argv = (char**)malloc(10*sizeof(char*));
		argv[0] = dialogs[a].name;
		argc = 1;	/* << previous version had argc = 0 >> */
		if (args != NULL) {
			argv[argc++] = strtok(args," \t\n");
			if((c=strchr(argv[argc-1],'$'))!=NULL)
				argv[argc-1] = ReplEnv(argv[argc-1]);
			while ((argv[argc++] = strtok(NULL," \t\n")) != NULL) {
				if ((argc % 10) == 0)
					argv = (char**)realloc(argv,argc+10);
				if((c=strchr(argv[argc-1],'$'))!=NULL)
				 argv[argc-1] = ReplEnv(argv[argc-1]);
			}; 
		};
#ifdef DEBUG
		fprintf (stderr,"AH - starting %s %s <%s> on %d:%d\n",
			 dialogs[a].name, prog_file, dialogs[a].args,
			 pipe_in[READ], pipe_out[WRITE]);
#endif
		execvp (prog_file, argv);
		fprintf (stderr,"AH - couldn't exec %s<%s>\n", prog_file, dialogs[a].name);
		exit(0);
	};
	close (pipe_out[READ]);
	close (pipe_in[WRITE]);
	dialogs[a].channel[READ] = pipe_in[READ];
	dialogs[a].channel[WRITE] = pipe_out[WRITE];
	dialogs[a].running = TRUE;
	in_channels |= 1 << dialogs[a++].channel[READ];
};



ProcAPPMsg (from, buf)
int	from;
char	* buf;
{	char	command[128];
	char	*cpt, *data;

#ifdef DEBUG
fprintf(stderr,"AH<%s - ProcAPPMsg:  %s\n",dialogs[from].name ,buf);
#endif

	Decapitate(buf, &cpt, &data);	/* split buf into concept and data */

				/* check for abort */
	if (!strncmp(cpt, "abort", 5)) {
		cpt = "aborted";
		dialogs[from].running = FALSE;
/*** close down client ***/
	};

	sprintf(command,"application_dialog%capplication_said%c%s%c%s\n",
	        csep,csep, cpt, csep, data);
	write (dialogs[0].channel[WRITE], command, strlen(command));
};






ProcBBMsg(from, buf)			/* message from Blackboard */
int	from;
char	* buf;
{	char	*area, *mesg, *cmd, *name, *rest,*rest1,*args,*client;

#ifdef DEBUG
fprintf(stderr,"AH<BB - ProcBBMsg:  %s\n",buf);
#endif

	Decapitate(buf, &area, &mesg);	/* strip off bb area holding mesg */

	if (!strcmp(area, "abort")) {
		CloseDown(from);
		exit(0);
	} else if (!strcmp(area, "application_dialog")) {		
		Decapitate(mesg, &cmd, &rest);	/* process dialog command */
		if (!strcmp(cmd, "abort")) {
			CloseDown(from);
			exit(0);
		} else 	if(!strcmp(cmd,"new_application")) {  /* start up client based on match of name */
				Decapitate(rest,&client,&rest1);	/* client is application name */
				Decapitate(rest1,&name,&args);		/* name is design function */
				SpawnDialog(name, client, client, args);
		} else    if(!strcmp(cmd,"inform")) {   /* pass message to client*/
				Decapitate(rest, &client, &rest1);
				Decapitate(rest1,&name,&args);
				Send(name,args);
		};
	};
	write (dialogs[0].channel[WRITE], ">", 1);

};

Send(name,args)
char *name, *args;
{
	int	a = 0;

#ifdef DEBUG
fprintf(stderr,"AH>%s - Send:%s\n",name,args);
#endif

	for (a = 1; a <= no_dialogs; a++)
		if (!strcmp(dialogs[a].name, name)  &&
					dialogs[a].running == TRUE ) {
			if(args!=NULL) {
				write( dialogs[a].channel[WRITE],
				       args, strlen(args));
				write( dialogs[a].channel[WRITE], "\n", 1);
			};
			break;
		};
};


ProcMsg (from, buf)
int	from;
char	* buf;
{
	if (*buf == '\0')
		return;			/* pipe closed or spurious select */

	if (!strcmp(dialogs[from].progtype, "bb"))
		ProcBBMsg(from, buf);
	else
		ProcAPPMsg(from,buf);
};




main()
{
	char	c;
	char	text[128];
	int	a = 0;
	int	rd, wrt, ex;
	int	n;

	setbuf(stdout,(char*)NULL); 
	setbuf(stdin,(char*)NULL); 
	bufptr[a] = buf[a];
	strcpy(dialogs[a].name, "Blackboard");
	strcpy(dialogs[a].progtype, "bb");
	strcpy(dialogs[a].prog, "ife_bb");
	dialogs[a].channel[READ] = 0;	/* stdin */
	dialogs[a++].channel[WRITE] = 1;	/* stdout */

	sleep(5);		/* give nip time to start up */
				/* tell bb (stdout) of required messages */
	sprintf(text,"mk_area%capplication_dialog\n",csep);
	write (dialogs[0].channel[WRITE], text, strlen(text));
	sprintf(text,"update_me%capplication_dialog%capplication_dialog\n",
								csep, csep);
	write (dialogs[0].channel[WRITE], text, strlen(text));
	write (dialogs[0].channel[WRITE], ">", 1);
	sleep(1); /* give new areas a moment to sort themselves out */
	fprintf (stderr,"AH - application handler started\n");

	while (1) {
	    wrt = 0;
	    rd = ex = in_channels ;
	    n = select (32, &rd, &wrt, &ex, (struct timeval *)NULL);
				/* from user/bb */
		for (a=0; a <= no_dialogs; a++) 
		   if (rd & 1<<dialogs[a].channel[READ]) {
			n = read (dialogs[a].channel[READ], &c, 1);
			switch (n) {
			    case 1:
				if (c == '\n') {
					*bufptr[a] = '\0';
					ProcMsg(a, buf[a]);
					bufptr[a] = buf[a];
				} else
					*bufptr[a]++ = c;
				break;
			    case 0:	/* end of file, close pipe */
				*bufptr[a] = '\0';
				ProcMsg(a, buf[a]);
				fprintf (stderr,"AH - %s pipe closed)\n",
							dialogs[a].name);
				if (a == 0) {	/* bb (stdin) gone */
					CloseDown(a);
					exit(0);
				};
/*
 * Tell others that the application/design function has finished the akh (tool_mgr)
 * is looking for "finished	xxx" where xxx is the designfunction name.
 */
				sprintf(text, "application_dialog%cclosed%c%s\n",
						csep,csep,dialogs[a].name);
				write (dialogs[0].channel[WRITE], text,
							strlen(text));
				sprintf(text, "application_dialog%cfinished%c%s\n",
						csep,csep,dialogs[a].name);
				write (dialogs[0].channel[WRITE], text,
							strlen(text));
				dialogs[a].running = FALSE;
				in_channels &= ~(1<<dialogs[a].channel[READ]);
				break;
			    default:
 				fprintf (stderr,"AH - %s pipe error %d\n",
						dialogs[a].name, errno);
				CloseDown(a);
				abort();
			};
		   };
	}
}
