/*
 * copyright (c) Mark M Martin. RAL. 1986
 * to convert bitmap pattern to line-printer image (byte per bit)
 * or octal constant for ww or vice versa. jun 85
 * args: [-width 64] [-strip] {from style} {to style} 
 * bit order. source lp/ww style: left	01234567 89ABCDEF G... right
 * on perq:				89ABCDEF 01234567 G...
 * on whitechapel			76543210 FEDCBA98 G...
 * on sun:				01234567 89ABCDEF G...
 * on X:				76543210 FEDCBA98 G...
 * bits are stored internally here in chbit in strict sequence, one per byte.
 */
#include <stdio.h>

#define CEDRA	0
#define LP	3
#define WW	4
#define OCTALP2	5
#define SUN	6
#define WWBITS	7
#define ICED	8
#define EXREP	9
#define OCTALWC	10
#define OCTALSUN 11
#define SUNRASTER 12
#define POSTSCRIPT 13
#define TROFF	14
#define XSTYLE	15

extern char *malloc();
typedef int bool;
typedef unsigned char unchar;
typedef struct{
	char	*name;		/* option as given in args */
	int	number;		/* internal code equivalent */
	bool	packed;		/* data is 8bits/byte */
	bool	reverse;	/* data reads 76543210 instead of 01234567 */
	bool	swopped;	/* data bytes swopped, baba... */
	int	(*readf)();	/* function to do input */
	int	(*writef)();	/* function to do output */
}desc;
#define FALSE	0
#define TRUE	1
#define CHARINT(x)	((x)&0377)
static char *progname;	/* argv[0] */
desc descs[];
static desc *from;
static desc *to;
/*
 * convert two bytes to an int
 */
int charshort(high,low)unchar high,low;{
	return(CHARINT(high)<<8 | CHARINT(low));
}
/* convert 4 bytes to an int */
int charint(str)unchar str[4];{
	return(CHARINT(str[0])<<24 | CHARINT(str[1])<<16
		| CHARINT(str[2])<<8 | CHARINT(str[3]));
}
/* VARARGS */
pexit(a,b,c,d,e,f,g)char *a;{
	desc *dp;
	fprintf(stderr,"%s: ",progname);
	fprintf(stderr,a,b,c,d,e,f,g);
	fprintf(stderr,"\n");
	fprintf(stderr,"usage: [-not] [-width 64] [-strip [l t r b]] -fromstyle -tostyle\n\
where a style is one of");
	for(dp = descs;dp->name!=0;dp++)
		fprintf(stderr," %s",dp->name);
	fprintf(stderr,"\nand the width is of the stored rectangle\n\
and -strip can have upto 4 amounts given with -1 meaning strip blanks.\n");
	exit(1);
}
desc *whichdesc(cp)char *cp;{
	desc *dp;
	for(dp = descs;dp->name!=0;dp++)
		if(strcmp(dp->name,cp)==0)break;
	if(dp->name==0)pexit("unknown arg %s",cp);
	return(dp);
}
eofmsg(){
	fprintf(stderr,"%s: premature eof\n",progname);
}
static int totbytes;
static int expectedlines;
static int loopcount;
static int width;
static int lines;
static bool moreok;
static unchar *chb,*chbit;
getspace(l,w,packed){
	static int sizegot = 0;
	static int sizegotpacked = 0;
	int bytes;

	if(packed){
		bytes = l*((w+7)/8);
		if(bytes>sizegotpacked && sizegotpacked!=0){
			free((char *)chb);
			chb = 0;
		}
		if(bytes>sizegotpacked){
			chb = (unchar *)malloc((unsigned)bytes+20/*for bugs*/);	/* holds packed version */
			if(chb==0)
				if(sizegotpacked==0)pexit("couldnt get space");
				else pexit("couldnt get space. picture too big");
			sizegotpacked = bytes;
		}
		return;
	}
	bytes = l*w;
	if(bytes>sizegot && sizegot!=0){
		free((char *)chbit);
		chbit = 0;
	}
	if(bytes>sizegot){
		chbit = (unchar *)malloc((unsigned)bytes+200/*for bugs*/);	/* holds unpacked version */
		if(chbit==0)
			if(sizegot==0)pexit("couldnt get space");
			else pexit("couldnt get space. picture too big");
		sizegot = bytes;
	}
}
int bigread(str,len)unchar *str;{
	int n;
	unchar *cp;
	cp = str;
	while(len>0 && (n = read(0,(char *)cp,len))>0)len -= n, cp += n;
		/* need to loop for pipe input! */
	if(len!=0)eofmsg();
	return(cp-str);
}
#define CEDRABYTES	512	/* byte len of cursors */
#define CEDRABITS	(512*8)	/* byte len of cursors */
rced(){
	int j,ch,b1,b2;
	j = 0;
	getspace((CEDRABYTES+4),8,from->packed);
	expectedlines = 64;
	j = bigread(chb,CEDRABYTES);
	if(j==0 && loopcount!=0)exit(0);
	if(j<CEDRABYTES)
		fprintf(stderr,"%s: ced pattern length read was only %d bytes\n",progname,j);
	else{
		if(read(0,(char*)chb+j,4)==4){	/* print hotspot */
			b1 = charshort(chb[j+1],chb[j]);
			b2 = charshort(chb[j+3],chb[j+2]);
			fprintf(stderr,"hotspot at %d %d ignored\n",b1,b2);
		}
	}
	if(j&1){
		fprintf(stderr,"%s: ced pattern length read %d was padded to even\n",progname,j);
		chb[j++] = '\0';
	}
	moreok = FALSE;
	lines = j*8/width;
}
#define MAXLINES	2049	/* max lines in -lp picture */
rlp(){
	int j,end,ch,endspace;
	j = 0;
	end = width;
	expectedlines = lines = 0;
	getspace(MAXLINES,width,from->packed);
	endspace = MAXLINES*width;
	while((ch = getchar())!=EOF && j<endspace){
		if(ch=='\n'){
			if(j>end)fprintf(stderr,"%s: overflow of width into line %d\n",progname,j/width+1);
			while(j<end)chbit[j++] = '\0';
			j = end;
			end += width;
			lines++;
		}else chbit[j++] = (ch!=' ');
	}
	if(j==endspace)fprintf(stderr,"%s: picture truncated, too big\n",progname);
	moreok = FALSE;
	lines = j/width;
}
rww(){
	int j,n,b1,b2,ch;
	j = 0;
	n = scanf("%*[^0123456789]%d%*[^0123456789]%d",&b1,&b2);
	if(n==EOF && loopcount!=0)exit(0);
	if(n!=2)pexit("couldn't read length");
	expectedlines = lines = charshort((unchar)b1,(unchar)b2);
	if(scanf("%*[^0123456789]%d%*[^0123456789]%d",&b1,&b2)!=2)
		pexit("couldn't read width");
	width = charshort((unchar)b1,(unchar)b2);
	fprintf(stderr,"ww style of %d lines and width %d\n",lines,width);
	getspace(lines,width,from->packed);
	n = lines*((width+7)/8);
	while(n-->0 && scanf("%*[^0123456789]%o",&ch)==1){
		chb[j++] = ch;
	}
	if(n!=-1)eofmsg();
	lines = j*8/width;
}
roct(){
	int j,ch,endspace;
	expectedlines = j = 0;
	lines = MAXLINES;
	if(0<scanf("{ /* lines=%d width=%d */ ",&lines,&width)){
		/* note optional header */
		expectedlines = lines;
		fprintf(stderr,"%s style of %d lines and width %d\n",from->name,lines,width);
	}
	getspace(lines,width,from->packed);
	endspace = MAXLINES*width;
	while(scanf("%*[^0123456789]%o",&ch)==1 && j<endspace)chb[j++] = ch;
	if(j==0 && loopcount!=0)exit(0);
	if(j==endspace)fprintf(stderr,"%s: picture truncated, too big\n",progname);
	moreok = FALSE;
	lines = j*8/width;
}
rsun(){
	int j,n,ch;
	j = 0;
	n = scanf("%*[^0123456789]%*d%*[^0123456789]%d",&width);
	if(n==EOF && loopcount!=0)exit(0);
	if(n!=1)pexit("couldn't read width");	
	if(scanf("%*[^0123456789]%d",&lines)!=1)
		pexit("couldn't read lines");
	expectedlines = lines;
	scanf("%*[^\n]%*c");	/* get to next line */	
	fprintf(stderr,"sun icontool style of %d lines and width %d\n",lines,width);
	getspace(lines,width,from->packed);
	n = lines*((width+7)/8)/2;
	while(n-->0 && scanf("%*[^0]0x%x",&ch)==1){
		chb[j++] = ch>>8;
		chb[j++] = ch;
	}
	if(n!=-1)eofmsg();
	lines = j*8/width;
}
rexrep(){
	int n;
	unchar str[9];
	if((n = bigread(str,9))!=9){
		if(n==0 && loopcount!=0)exit(0);
		pexit("");
	}
	if(strncmp((char *)str,"bitm",4)!=0)
		pexit("-exrep for input other than bitmaps not implemented yet");
	n = charint(&str[4])-4;
	/* number of bytes, not used */
	if(str[8]!=2)	/* ENWWSTYLE */
		pexit("-exrep for other than ww style not implemented yet");
	rwwbits();
}
rwwbits(){
	int n;
	unchar str[4];
	if((n = bigread(str,4))!=4){
		if(n==0 && loopcount!=0)exit(0);
		pexit("couldn't read length or width");
	}
	expectedlines = lines = charshort(str[0],str[1]);
	width = charshort(str[2],str[3]);	
	fprintf(stderr,"ww style of %d lines and width %d\n",lines,width);
	getspace(lines,width,from->packed);
	lines = bigread(chb,lines*((width+7)/8))*8/width;
}
riced(){
	int j;
	unchar str[548-32];
	j = 0;
	if((j = bigread(str,32))!=32){
		if(j==0 && loopcount!=0)exit(0);
		pexit("couldn't read header");
	}
	if(str[0]==(unchar)'\323'){	/* cursor */
		expectedlines = lines = charshort(str[7],str[8]);
		width = charshort(str[11],str[12]);
	}else{	/* icon */
		expectedlines = lines = 60;
		width = 60;
		if(bigread(str,548-32)!=548-32)
			pexit("couldn't read header");
	}
	fprintf(stderr,"iced style of %d lines and width %d\n",lines,width);
	if(lines*width==0)pexit("null picture");
	getspace(lines,width,from->packed);
	lines = bigread(chb,lines*((width+7)/8))*8/width;
}
rx(){
	int j,n,ch;
	char dummy;
	j = 0;
	n = scanf("#define %*[^ ] %d ",&width);
	if(n==EOF && loopcount!=0)exit(0);
	if(n!=1)pexit("couldn't read width");	
	if(scanf("#define %*[^ ] %d ",&lines)!=1)
		pexit("couldn't read height");
	expectedlines = lines;
	while(1==scanf("#define %[^\n]")); /* skip opt cursor hotspot */
	scanf("static %*[^\n]");	/* get past declare */	
	getspace(lines,width,from->packed);
	fprintf(stderr,"X bitmap of %d lines and width %d\n",lines,width);
	n = lines*((width+7)/8);
	while(n-->0 && scanf("%*[^0]0x%x",&ch)==1)
		chb[j++] = ch;
	if(n!=-1)eofmsg();
	scanf(" } ; ");	/* get past end */	
	lines = j*8/width;
}
/*
 * sun screendump format: 
 * struct rasterfile {
	int	ras_magic
#define	RAS_MAGIC	0x59a66a95
	int	ras_width
	int	ras_height
	int	ras_depth
	int	ras_length length (bytes) of image
	int	ras_type
#define RT_OLD		0
	int	ras_maptype of colormap
	int	ras_maplength
 *	color map follows for ras_maplength bytes, followed by image
 *	Each line of the image is rounded out to a multiple of 16 bits.
 */
rsunras(){
#define RT_STANDARD	1
#define RT_BYTE_ENCODED	2
#define RMT_NONE	0	/* ras_maplength is expected to be 0 */
	int j,n,bytewidth,len,compressed,datalen;
	unchar str[32];
	j = 0;
	n = bigread(str,32);
	if(n==0 && loopcount!=0)exit(0);
	if(n!=32)pexit("couldnt read whole of header");
	if(strncmp((char *)str,"\131\246\152\225",4)!=0)
		pexit("couldnt read 4 byte magic number");
	width = charint(str+4);
	expectedlines = lines = charint(str+8);
	n  = charint(str+12);	/* depth */
	if(n!=1)pexit("raster depth %d (!=1) not implemented",n);
	n  = charint(str+20);
	compressed = n==RT_BYTE_ENCODED;
	if(n!=RT_STANDARD && !compressed)pexit("unknown encoding style");
	datalen  = charint(str+16);	/* length (bytes) of image */
	if(!compressed && datalen!=(width+15)/16*16*lines/8)
		fprintf(stderr,"conv: warning given length %d != computed length %d\n",datalen,(width+15)/16*16*lines/8);
	n  = charint(str+24);
	if(n!=RMT_NONE)fprintf(stderr,"conv: warning colourmap ignored\n");
	n  = charint(str+28);	/*colourmaplength*/
	if(n!=0){
		getspace(n,8,TRUE);
		if(bigread(chb,n)!=n)
			pexit("couldnt skip past colourmap");
	}
	fprintf(stderr,"%ssun raster style of %d lines and width %d\n",
		compressed?"compressed ":"",lines,width);
	getspace(lines,width+8,from->packed);
	bytewidth = (width+7)/8;
	n = bytewidth*lines;
/*
 * sun compressed form is marker byte 0200 followed
 * by num-1 of repeats of byte following.
 * If num-1==0, it is the data byte 0200.
 * If not 0200, it is a data byte.
 * 0200<rpts-1>databyte | 0200 0000 | not 0200
 */	
#define MARKER	(unsigned char)'\200'
	if(compressed){
		unsigned char *from,*to,*end;
		int i;
		getspace(lines,(width+15)/8,FALSE);
		n = bigread(chbit,datalen);
		from = chbit, to = chb;
		end = from+datalen;
		while(from<end)
		if(*from==MARKER){
			i = *++from;
			from++;
			if(i==0)*to++ = MARKER;
			else{
				while(i-->=0)*to++ = *from;
				from++;
			}
		}else *to++ = *from++;
		j = to-chb;
		if(j!=(width+15)/16*16*lines/8)
		fprintf(stderr,"conv: warning uncompressed length %d != computed length %d\n",j,(width+15)/16*16*lines/8);
	}else
	if(bytewidth&1)	/* not even num of 16 bits */
	for(j=0;j<n;j += bytewidth){
		len = bigread(chb+j,bytewidth+1);	/* pad to 16 */
		if(len!=bytewidth+1)
			break;
	}else{
		j = bigread(chb,n);
	}
	lines = j*8/width;
}
#define BEFORESTRIP	1
#define AFTERSTRIP	2
static int bytewidth;
doit(strip,notit){
	desc *now,nowdesc;
	int bytesread;

	(*from->readf)();
	if(expectedlines!=lines)
		fprintf(stderr,"%d lines read\n",lines);
	bytewidth = (width+7)/8;
	bytesread = lines*bytewidth;
	now = &nowdesc;
	nowdesc = *from;	/* copy struct so can change packed etc */
	if(notit==BEFORESTRIP)donot(now);
	if(strip){
		/* must be unreversed, unswopped, unpacked */
		if(now->reverse)reverse(now,bytesread);
		if(now->swopped)swop(now,bytesread);
		if(now->packed)unpack(now);
		dostrip();
		bytesread = lines*bytewidth;
	}
	if(bytesread==0){
		fprintf(stderr,"null pattern\n");
		exit(0);
	}
	if(now->reverse != to->reverse)
		reverse(now,bytesread);
	if(now->swopped != to->swopped){
		swop(now,bytesread);
		if(bytewidth&1)
			fprintf(stderr,"conv: this probably won't work with an odd number of bytes width\n");
	}
	if(now->packed != to->packed){
		if(!now->packed)pack(now);
		else unpack(now);
	}
	totbytes = lines*bytewidth;
	if(notit==AFTERSTRIP)donot(now);
	(*to->writef)();
}
/*
 * not the data
 */
donot(dp)desc *dp;{
	unchar *end,*cp;
	if(dp->packed){
		end = chb+lines*bytewidth;
		for(cp=chb;cp<end;cp++)*cp = ~*cp;
	}else{
		end = chbit+lines*width;
		for(cp=chbit;cp<end;cp++)*cp = *cp?'\0':'\1';
	}
}
/* strip starting blank bits and trailing blank lines */
#define LEFT	0	/* indexes in tostrip */
#define TOP	1
#define RIGHT	2
#define BOTTOM	3
#define STRIPBLANK	(-1)	/* strip this dimensions if poss */
int tostrip[4] = {STRIPBLANK,STRIPBLANK,STRIPBLANK,STRIPBLANK};
dostrip(){
	int strip,lgap,rgap,j,k,dl,dt,db,dr;
	strip = 0;
	if(tostrip[BOTTOM]!=STRIPBLANK){
		strip = tostrip[BOTTOM];
		if(strip>lines)strip = lines;
	}else
	for(j=lines*width;j>0;j-=width){	/* strip trailing null lines */
		for(k=j-1;k>=j-width && chbit[k]=='\0';k--);
		if(k>=j-width)break;	/* non null line */
		strip++;
	}
	lines -= strip;
	db = strip;
	strip = 0;
	if(tostrip[TOP]!=STRIPBLANK){
		strip = tostrip[TOP];
		if(strip>lines)strip = lines;
	}else
	for(j=0;j<lines*width;j+=width){	/* strip null lines at start */
		for(k=j;k<j+width && chbit[k]=='\0';k++);
		if(k<j+width)break;	/* non null line */
		strip++;
	}
	dt = strip;
	rgap = width;
	lgap = width;
	for(j=strip*width;j<lines*width;j+=width){	/* strip blanks at left and right */
		for(k=j+width-1;k>=j && chbit[k]=='\0';k--);
		if((j+width-1)-k<rgap)rgap = (j+width-1)-k;
		for(k=j;k<j+width && chbit[k]=='\0';k++);
		if(k-j<lgap)lgap = k-j;
	}
	if(tostrip[LEFT]!=STRIPBLANK)
		lgap = tostrip[LEFT];
	if(tostrip[RIGHT]!=STRIPBLANK)
		rgap = tostrip[RIGHT];
	/* there are lgap blanks at the left, and rgap at the right edge of picture */
	if(lgap+rgap+strip!=0){
		int to;
		to = 0;
		for(j=strip*width;j<lines*width;j+=width){
			for(k=j+lgap;k<j+width-rgap;k++)
				chbit[to++] = chbit[k];
		}
		width = width-lgap-rgap;
		if(width<0)width = 0;	/* could happen if tostrip[] */
		bytewidth = (width+7)/8;
		dl = lgap;
		dr = rgap;
		lines = lines-strip;
	}else dl = dr = 0;
	if(dl+dr+dt+db!=0)fprintf(stderr,
		"stripped to the box (%d,%d,%d,%d) (that's %d at right and %d at bottom)\n",
		dl,dt,width-1+dl,lines-1+dt,dr,db);
	else fprintf(stderr,"nothing stripped\n");
	
}
#define CURSORSTRIDE	64
wced(){
	int j,k;
	if(width>CURSORSTRIDE || lines*width>CEDRABITS)
		fprintf(stderr,"pattern too large for cedra style\n");
	if(width<CURSORSTRIDE || lines*width<CEDRABITS)
		fprintf(stderr,"padding pattern to 64 by 64\n");
	for(j=0;j<lines*bytewidth;j+=bytewidth){
		for(k=j;k<j+bytewidth;k++){
			putchar(chb[k]);
		}
		while((k++-j)*8<CURSORSTRIDE)putchar('\0');
	}
	j = lines*CURSORSTRIDE/8;
	while(j++<CEDRABYTES)putchar('\0');
}
wlp(){
	int j,k,n;
	for(j=0;j<lines*width;j+=width){
		for(k=j+width-1;k>=j && chbit[k]=='\0';k--);
		for(n=j;n<=k;n++){
			printf("%c",chbit[n]?'x':' ');
		}
		printf("\n");
	}
}
www(){
	int j;
	poctlist(bytewidth);
	printf(" /* lines= */ %d,%d, /* width= */ %d,%d,\n",
		lines>>8,lines&0377,width>>8,width&0377);
	for(j=0;j<totbytes;j++)poct(chb[j]);
	poctlist(0);
	printf(" /* ww style */\n");
}
woct(){
	int j;
	poctlist(bytewidth);
	printf(" /* lines=%d width=%d */\n",lines,width);
	for(j=0;j<totbytes;j++)poct(chb[j]);
	poctlist(0);
	printf(" /* raw %s order */\n",to->name);
}
wsun(){
	int j;
	printf("/* Format_version=1, Width=%d, Height=%d, Depth=1, Valid_bits_per_item=16\n */\n",
		(width+15)/16*16,lines);
	if(bytewidth%2!=0){
		/* need to pad out last byte to 16 bits */
		phexlist(bytewidth/2+1);
		for(j=0;j<totbytes;)
			if((j+1)%bytewidth==0)
				phex(chb[j++],0);
			else{
				phex(chb[j],chb[j+1]);
				j += 2;
			}
	}else{
		phexlist(bytewidth/2);
		for(j=0;j<totbytes;j += 2)phex(chb[j],chb[j+1]);
	}
	phexlist(0);
	printf("\n");
}
wsunras(){
	int j;
	unchar str[28];
	write(1,"\131\246\152\225",4);
	putint(width,4,str);
	putint(lines,4,str+4);
	putint(1/*depth*/,4,str+8);
	putint((width+15)/16*16*lines/8,4,str+12);
	putint(RT_STANDARD,4,str+16);
	putint(RMT_NONE,4,str+20);
	putint(0/*colourmaplength*/,4,str+24);
	write(1,(char *)str,28);
	if(bytewidth&1)	/* not even num of 16 bits */
	for(j=0;j<totbytes;j += bytewidth){
		write(1,(char *)chb+j,bytewidth);
		write(1,"\0",1);	/* pad to 16 */
	}else write(1,(char *)chb,totbytes);
}
wwwbits(){
	unchar str[4];
	str[0] = lines>>8;
	str[1] = lines;
	str[2] = width>>8;
	str[3] = width;
	write(1,(char *)str,4);
	write(1,(char *)chb,totbytes);
}
wexrep(){
	extern char *strcpy();
	unchar str[13];

	strcpy((char *)str,"bitm");
	putint(totbytes+5,4,str+4);
	str[8] = 2;	/* ENWWSTYLE */
	putint(lines,2,str+9);
	putint(width,2,str+11);
	write(1,(char *)str,13);
	write(1,(char *)chb,totbytes);
}
static char *postsc[] = {
	"%% remove the %%- from ONE of the next 2 lines and replace",
	"%% HEIGHT or WIDTH with the desired height or width in inches.",
	"%%- WIDTH dup xbits div ybits mul scale %% width",
	"%%- HEIGHT dup ybits div xbits mul exch scale %% height",
	"72 72 scale /buf xbits 7 add 8 idiv string def",
	"xbits ybits 1 [xbits 0 0 ybits neg 0 ybits] { currentfile buf readhexstring pop } image",
	0 };

static char *troffheader = ".fl \\\"flush troff output\n\
\\!%\n\\! save /wwsave exch def currentpoint translate resolution 72 div dup neg scale 0 0 moveto\n\\!";

wps(){
	int j,n,troff;
	char *newline;

	troff = to->number==TROFF;
	newline = troff?"\n\\!":"\n";
	printf("%s /xbits %d def /ybits %d def%s",troff?troffheader:"",width,lines,newline);
	for(n=0;postsc[n]!=0;n++)
		printf(" %s%s",postsc[n],newline);
	for(j=0;j<totbytes;j++){
		if(j%bytewidth==0)printf("%s",newline);
		puthexval(chb[j]>>4);
		puthexval(chb[j]);
	}
	printf("%s",troff?"\n\\!wwsave restore\n\\!.\n":"\n");
}
/*
 * following the w&h defines are: #define fred_x_hot 1
 * 	#define fred_y_hot 14
 */
wx(){
	int j;
	printf("#define ww_width %d\n#define ww_height %d\nstatic char ww_bits[] = {\n",
		width,lines);
	phexlist(bytewidth);
	for(j=0;j<totbytes;j++)phexbyte(chb[j]);
	printf("};\n");
}
/*
 * end of particular io routines
 */
isnum(cp)char *cp;{
	if(*cp=='-' || *cp=='+')cp++;
	while(*cp>='0' && *cp<='9')cp++;
	return(*cp=='\0');
}

desc descs[] = {
/* name		number packed reversed swopped */
{"-cedra",	CEDRA,	1,0,1,	rced,	wced},
				/* a perq cursor editor form */
{"-lp",		LP,	0,0,0,	rlp,	wlp},
				/* line printer ie byte per bit */
{"-ww",		WW,	1,0,0,	rww,	www},
				/* ww octal constants with length and width */
{"-octalp2",OCTALP2,	1,0,1,	roct,	woct},
			/* non-portable octal constants for spy. perq 2 */
{"-octalsun",OCTALSUN,	1,0,0,	roct,	woct},
				/* non-portable octal constants for spy */
{"-octalwc",OCTALWC,	1,1,0,	roct,	woct},
				/* non-portable octal constants for spy */
{"-sun",	SUN,	1,0,0,	rsun,	wsun},
				/* sun icontool format */
{"-exrep",	EXREP,	1,0,0,	rexrep, wexrep},
				/* ww external rep */
{"-bits",	WWBITS,	1,0,0,	rwwbits,wwwbits},
		/* "compiled" ww in bytes, not a printing declaration */
{"-iced",	ICED,	1,1,0,	riced,	0},
				/* wc iced form */
{"-X",		XSTYLE,	1,1,0,	rx,	wx},
				/* X c declaration style */
{"-x",		XSTYLE,	1,1,0,	rx,	wx},
				/* X c declaration style */
{"-sunraster",SUNRASTER,1,0,0,	rsunras,wsunras},
				/* sun screendump etc format */
{"-ps",	POSTSCRIPT,	1,0,0,	0,	wps},
				/* postscript */
{"-pstroff",	TROFF,	1,0,0,	0,	wps},
				/* postscript for troff */
{0}};

main(argc,argv)char **argv;{
	int strip,notit;

	from = to = 0;
	width = CURSORSTRIDE;
	notit = strip = FALSE;
	progname = argv[0];
	argv++; argc--;
	while(argc>0){
		if(strcmp(argv[0],"-width")==0 && argc>=2){
			width = atoi(argv[1]);
			argv++; argc--;
		}else if(strcmp(argv[0],"-not")==0){
			notit = strip?AFTERSTRIP:BEFORESTRIP;
		}else if(strcmp(argv[0],"-strip")==0){
		/* look for up to 4 numbers following */
			int i;
			strip++;
			i = 0;
			while(i<4 && argc>1 && isnum(argv[1])){
				tostrip[i] = atoi(argv[1]);
				if(tostrip[i]<-1)tostrip[i] = 0;
				argv++, argc--, i++;
			}
		}else if(from==0){
			from = whichdesc(argv[0]);
		}else if(to==0){
			to = whichdesc(argv[0]);
		}else
			pexit("unknown argument %s",argv[0]);
		argv++; argc--;
	}
	if(from==0 || to==0)pexit("missing from or to style");
	if(from==to && !strip){
		fprintf(stderr,"%s: warning: from and to styles are the same\n",progname);
	}
	if(width<=0 || width!=CURSORSTRIDE && (from->number==CEDRA || to->number==CEDRA)){
		fprintf(stderr,"conv: width given ignored\n");
		width = CURSORSTRIDE;
	}

	if(from->readf==0)pexit("from %s not implemented",from->name);
	if(to->writef==0)pexit("to %s not implemented",to->name);
	while(doit(strip,notit), moreok)loopcount++;
}
static unchar bitreverse[256] = {
0,0200,0100,0300,040,0240,0140,0340,020,0220,0120,0320,060,0260,0160,0360,
010,0210,0110,0310,050,0250,0150,0350,030,0230,0130,0330,070,0270,0170,0370,
04,0204,0104,0304,044,0244,0144,0344,024,0224,0124,0324,064,0264,0164,0364,
014,0214,0114,0314,054,0254,0154,0354,034,0234,0134,0334,074,0274,0174,0374,
02,0202,0102,0302,042,0242,0142,0342,022,0222,0122,0322,062,0262,0162,0362,
012,0212,0112,0312,052,0252,0152,0352,032,0232,0132,0332,072,0272,0172,0372,
06,0206,0106,0306,046,0246,0146,0346,026,0226,0126,0326,066,0266,0166,0366,
016,0216,0116,0316,056,0256,0156,0356,036,0236,0136,0336,076,0276,0176,0376,
01,0201,0101,0301,041,0241,0141,0341,021,0221,0121,0321,061,0261,0161,0361,
011,0211,0111,0311,051,0251,0151,0351,031,0231,0131,0331,071,0271,0171,0371,
05,0205,0105,0305,045,0245,0145,0345,025,0225,0125,0325,065,0265,0165,0365,
015,0215,0115,0315,055,0255,0155,0355,035,0235,0135,0335,075,0275,0175,0375,
03,0203,0103,0303,043,0243,0143,0343,023,0223,0123,0323,063,0263,0163,0363,
013,0213,0113,0313,053,0253,0153,0353,033,0233,0133,0333,073,0273,0173,0373,
07,0207,0107,0307,047,0247,0147,0347,027,0227,0127,0327,067,0267,0167,0367,
017,0217,0117,0317,057,0257,0157,0357,037,0237,0137,0337,077,0277,0177,0377
};
reverse(dp,len)desc *dp;{
	unchar *start,*end;

	if(!dp->packed)pack(dp);	/* pack before reverse */
	dp->reverse = !dp->reverse;
	start = chb;
	end = start+len;
	while(start<end){
		*start = bitreverse[(*start)&0377];
		start++;
	}
}
/*
 * swop adjacent bytes. if len isnt even, more fool you
 */
swop(dp,len)desc *dp;{
	unchar *chp;
	int tmp;

	if(!dp->packed)pack(dp);	/* pack before swop */
	dp->swopped = !dp->swopped;
	chp = chb;
	len >>= 1;
	while(len-->0){
		tmp = *chp;
		*chp = chp[1];
		chp[1] = tmp;
		chp += 2;
	}
}
/*
 * pack 8 bits per byte
 */
pack(dp)desc *dp;{
	int l,w,i;
	unchar *from,*to;

	if(dp->packed)return;
	dp->packed = TRUE;
	getspace(width,lines,TRUE);
	from = chbit, to = chb;
	for(l=lines;l-->0;){
		for(w=width;w>0;){
			*to = '\0';
			for(i=8;i-->0 && w-->0;)
				if(*from++)*to |= (1<<i);
			to++;
		}
	}
}
/*
 * unpack 8 bits per byte to 1
 */
unpack(dp)desc *dp;{
	int l,w,i;
	unchar *from,*to;

	if(!dp->packed)return;
	dp->packed = FALSE;
	getspace(width,lines,FALSE);
	from = chb, to = chbit;
	for(l=lines;l-->0;){
		for(w=width;w>0;){
			for(i=8;i-->0 && w-->0;)
				*to++ = (*from & (1<<i))?'\1':'\0';
			from++;
		}
	}
}
/*
 * print out lists of octal numbers (ie put a leading 0) 
 * and break into lines every "start" numbers
 */
static int poctdone,poctwidth;
poctlist(start){
	if(start){
		poctdone = 0;
		poctwidth = start;
		printf("{");
	}else printf("}");
}
poct(ch)unchar ch;{
	int i = ch & 0377;
	printf("%s%s%o",
		poctdone?(poctdone%poctwidth==0?",\n":","):"",
		i!=0?"0":"",
		i);
	poctdone++;
}
phexlist(start){
	if(start){
		poctdone = 0;
		poctwidth = start;
	}
}
phex(ch1,ch2)unchar ch1,ch2;{
	int i = ((ch1<<8)|(ch2&0377))&0xFFFF;
	printf("%s0x%04x",
		poctdone?(poctdone%poctwidth==0?",\n":","):"",
		i);
	poctdone++;
}
/* print a byte in hex */
phexbyte(ch)unchar ch;{
	printf("%s0x%02x",
		poctdone?(poctdone%poctwidth==0?",\n":","):"",
		ch&0xFF);
	poctdone++;
}
puthexval(ch)unchar ch;{
	/* need to invert pixels for postscript. not "0123456789abcdef" */
	putchar("fedcba9876543210"[ch&017]);
}
/*
 * convert an int i to n bytes in order, most sig first.
 */
putint(i,n,cp)unchar *cp;{
	while(n-->0){
		cp[n] = i;
		i >>= 8;
	}
}
