#include <wwinfo.h>
#include <sys/types.h>
#include <stdio.h>	/* for debugging */
#include <errno.h>

#define IPREADY	100
#define FD_OR(q, p)	do { int i = howmany(FD_SETSIZE, NFDBITS)-1; for (; i >= 0; i--) (p)->fds_bits[i] |= (q)->fds_bits[i]; } while (0)
#define FD_AND(q, p)	do { int i = howmany(FD_SETSIZE, NFDBITS)-1; for (; i >= 0; i--) (p)->fds_bits[i] &= (q)->fds_bits[i]; } while (0)
#define FD_ANY(mask)	((mask)->fds_bits[0] | (mask)->fds_bits[1] | (mask)->fds_bits[2] | (mask)->fds_bits[3] | (mask)->fds_bits[4] | (mask)->fds_bits[5] | (mask)->fds_bits[6] | (mask)->fds_bits[7])


char *malloc (), *realloc (), *index (), *rindex ();

				/*** copied from util/utils.c ***/
char *indexn (s, c, n) char *s; char c; int n;
 {
 	char *end = s + n;
 	
 	while (s != end && *s != c)
 		s++;
 	if (s == end)
 		s = 0;
 	return s;
 }

static fd_set readmask, wwmask;

ipaddfd (fd) int fd;
 {
	FD_SET(fd, &readmask);
 }

ipremovefd (fd) int fd;
 {
	FD_CLR(fd, &readmask);
 }

static int (*ipwaitfd_fn)() = 0;

static int ipwaitfd ()
 {
 	static int nfds = 0;
	fd_set inputfds, resultmask;
	int i;
	
	if (nfds == 0)
	 {
	 	nfds = getdtablesize ();
	 }
	if (dd->d_flags & WWINPUTREADY || dd->d_buttons)
		return (*ipwaitfd_fn)();
	
	{
		int res, ox = dd->d_x, oy = dd->d_y, obuttons = dd->d_buttons;
		ipset (IPSAMPLE);
		res = (*ipwaitfd_fn) ();	/* we have to do this to flush any pending output */
		ipset (IPREQUEST);	/* we assume here that we won't ask for an event in SAMPLE
					   mode with all the buttons up */
		/* now ensure that we didn't get an event as a result of flushing */
		if (dd->d_event != IPOTHER || dd->d_x != ox || dd->d_y != oy || dd->d_buttons != obuttons || (dd->d_flags & WWINPUTREADY))
			return res;
	}
	/* now it is safe to select */
	resultmask = readmask;
 	if (select (nfds, &resultmask, (int *) 0, (int *) 0, (struct timeval *)0) < 0)
	 {
	 	if (errno == EINTR)
	 		;
	 	else
			perror ("ipwaitfd"),
				exit (1);
	 }
	
	/* mask only WW fds and return next event if we have one */
	inputfds = resultmask;
	FD_AND (&wwmask, &inputfds);
 	if (FD_ANY (&inputfds))
 	 	return (*ipwaitfd_fn) ();
 	
 	/* if nothing from WW, we must have an FD */
	for (i = 0; i < nfds; i++)
		if (FD_ISSET(i, &resultmask))
		 {
		 	dd->d_char = i;
		 	dd->d_event = IPREADY;
		 	return 0;
		 }
	dd->d_event = IPOTHER;
	fprintf (stderr, "ipwaitfd: event not found!\n");
	
	return 0;
 }

ipsetwaitfd ()
 {
 	if (ipwaitfd_fn)
 		return;
 	ipwaitfd_fn = dd->d_ipwait;
 	dd->d_ipwait = ipwaitfd;
	bcopy ((char *) dd->d_selectmore, (char *) &wwmask, dd->d_selectlength / 8);
	readmask = wwmask;
 }

static void (*handle_fd_fn)() = 0;
static char *handle_fd_buf = 0;
static int handle_fd_bufsize = 0;

int ipfdready ()
 {
	char *p, buffer [BUFSIZ];
	int n = read (dd->d_char, buffer, BUFSIZ);
	
	if (n <= 0)
	 {
	 	ipremovefd (dd->d_char);	/* channel gone! */
	 	return 1;
	 }
	for (p = buffer; n > 0; )
	 {
 		char *indexn (), *end = indexn (p, '\n', n);
 		int length;
 		
		if (end == 0)
			length = n;
		else
			length = end - p;
		if (handle_fd_buf)
			handle_fd_buf = realloc (handle_fd_buf, handle_fd_bufsize + length + 1);
		else
			handle_fd_buf = malloc (length + 1);
		 		
		bcopy (buffer, handle_fd_buf + handle_fd_bufsize, length);
		handle_fd_bufsize += length;
		handle_fd_buf [handle_fd_bufsize] = '\0';
		p += length;
		n -= length;
		
		if (n && *p == '\n')
		 {
		 	(*handle_fd_fn)(handle_fd_buf, handle_fd_bufsize);
		 	free (handle_fd_buf);
		 	handle_fd_buf = 0;
		 	handle_fd_bufsize = 0;
		 	++p;
		 	--n;
		 }
	 }
	return 1;
 }

void ipcommands (fd, fn) int fd; void (*fn)();
 {
	ipsetwaitfd ();
	ipaddfd (fd);
	iphandle (IPREADY, ipfdready);
	handle_fd_fn = fn;
 }


#define MAX_HANDLERS	100

static struct handler
 {
	int event;
	int (*fn)();
 } handler [MAX_HANDLERS];

static int nhandlers = 0;
static int (*handle_ipwait)();

static int handle_event ()
 {
	int swallow = 1, res;
	
	while (swallow)
	 {
		int i;
		
		res = (*handle_ipwait) ();
		
		swallow = 0;
		for (i = nhandlers - 1; i >= 0 && !swallow; i--)
			if (dd->d_event == handler[i].event)
				swallow = (*handler[i].fn)();
	 }
	return res;
 }

/*
 * installs a function to handle the given kind of event.
 * the function will normally return 0;
 * if it returns non-zero, the event will not be passed onto other handlers or the user
 */
iphandle (event, fn) int event, (*fn)();
 {
 	static int not_init = 1;
 	
 	handler[nhandlers].event = event;
 	handler[nhandlers].fn = fn;
 	nhandlers++;
 	if (not_init)
 	 {
 	 	not_init = 0;
 	 	handle_ipwait = dd->d_ipwait;
 	 	dd->d_ipwait = handle_event;
 	 }
 }

ipdonthandle (event, fn) int event, (*fn)();
 {
 	int i;
 	
 	for (i = nhandlers - 1; i >= 0; i--)
 		if (event == handler[i].event && fn == handler[i].fn)
 			break;
 	if (i >= 0)
 		for (; i < nhandlers; i++)
 			handler[i] = handler[i+1];
 	nhandlers--;
 }

