/* 
  This program first writes on the Blackboard (BB) a simple Tuple:
  Concept<tab>Value     where :
                               Concept = connection_by
                               Value   = 2_bb_2
  then it goes into an continues loop waiting for responses from the BB
  which might be other Tuples posted onto the BB by other clients (in-
  cluding the user typing in Tuples from the Keybord).
  All responses are recorded in the file 'fort.12'
  The continues waiting loop and the connection to the BB are ended on
  reception of an appropriate message from the BB.

  Notes: 1) in each of the I/O list strings there is a <TAB> character
         2) '>' signals to the BB that this client is now ready for input
         3) setbuf(...) flushes the I/O buffer

*/

#include <stdio.h>
#define  REC_FILE  "fort.12"

main() /* 2_bb_2 */
{
  FILE *fp;
  char str[1][80];

  setbuf(stdin,(char*) 0);
  setbuf(stdout,(char*) 0);
  setbuf(stderr,(char*) 0);

  if((fp=fopen(REC_FILE,"w")) == NULL) {
    fprintf(stderr,"Can't open file %s",REC_FILE);
    exit (0);
  }

  printf("mk_area\tuser_dialog\n");
  printf("update_me\tuser_dialog\n");
  printf("post\tuser_dialog\tconnection_by\t2_bb_2\n");

  do {
    printf(">\n");
    gets(str[0]);
    fprintf(fp,"%s\n",str[0]);
  } while(strcmp(str[0],"user_dialog\tdisconnect\t2_bb_2"));

  printf("post\tuser_dialog\tdscn_req\t2_bb_2\n");
  printf("kill_me\n");

  close(fp);

}
