#include	"theory/Shortwave_smear.h"

#include	"transport/Irradiance.h"
#include	"building/Building_es.h"
#include	"building/Room_es.h"
template_define(List,Room_es);
#include	"building/Surface_es.h"
template_define(List,Surface_es);
#include	"theory/Shortwave_beam.h"
template_define(List,Shortwave_beam);

Type*	Shortwave_smear_Type_pointer;


Shortwave_smear::Shortwave_smear(Metaclass* meta, Shortwave_def* def)
				: Shortwave(meta, def)
{
	DEBUG	<< "Shortwave_smear::Shortwave_smear(Metaclass* meta, Shortwave* def)\n";

	directType(TYPE_OF(Shortwave_smear));
};

Shortwave_smear::Shortwave_smear(Shortwave_smear& sw) : Shortwave((Shortwave&) sw)
{
	DEBUG	<< "Shortwave_smear::Shortwave_smear(Shortwave_smear& sw)\n";

	directType(TYPE_OF(Shortwave_smear));
};

Shortwave_smear::Shortwave_smear(APL* theAPL) : Shortwave(theAPL)
{
	DEBUG	<< "Shortwave_smear::Shortwave_smear(APL* theAPL)\n";
};

Shortwave_smear::~Shortwave_smear()
{
	DEBUG	<< "Shortwave_smear::~Shortwave_smear()\n";
};


List(Shortwave_beam)&	Shortwave_smear::building_response(List(Shortwave_beam)& incident,
						     Building& the_building)
{
	DEBUG	<< "List(Shortwave_beam)&	Shortwave_smear::building_response(List(Shortwave_beam)& incident,\n";
	DEBUG	<< "		 Building& the_building)\n";
	List(Shortwave_beam)	reflected;	// to collect reflected beams
	List(Shortwave_beam)	transmitted;	// transmitted into some room
/*
** NOTE THAT THE BLIND/ SHUTER CONTROL ASPECTS ARE
** NOT DEALT WITH AS YET.
*/

/*
** Calculate the shortwave radiation transmitted through
** the external constructions into the rooms.
*/
	List_iterator(Shortwave_beam) insol_iter(&incident);
	Shortwave_beam* beam;
				// for each insolation beam
	while (beam = insol_iter(FORWARD)) {
					// propagate through construction (surface)
		List(Shortwave_beam)&	processed_beam =
			beam->surface()->shortwave_response(*beam);
					// collect all exiting (reflected) beams
		if (processed_beam.first()->surface() == beam->surface()) {
			reflected.append(processed_beam.first());
			processed_beam.remove(processed_beam.first());
		};
					// save all transmitted beams for later
		transmitted += processed_beam;
		incident.remove(beam);
	};
/*
** Going through the transmitted radiation, get appropriate Room
** to handle transmitted beams and return re-transmitted beams
** These are either added to the reflected list (if comming from
** an external surface, or appended to the transmitted list
*/
				// handle transmitted (into a room) beams
	List_iterator(Shortwave_beam) beam_iter(&transmitted);
	do {
					// for each room
		List_iterator(Room_es) rm_iter(&the_building.rooms());
		Room_es*	rm;
		while( rm = rm_iter(FORWARD))
						// delete incomming beams,
						//    process internal reflections
						//    and return (re)transmitted
			transmitted += rm->shortwave_response(transmitted);
					// collect transmissions through ext surfs
		while( beam = beam_iter(FORWARD)) {
			if (beam->irradiance()->direct() +
			    beam->irradiance()->diffuse()  < tolerance_value)
				transmitted.remove(beam);
			if (the_building.leftRoom_for(beam->surface()->constr()) ||
			    the_building.rightRoom_for(beam->surface()->constr()) ) {
				reflected.append(beam);
				transmitted.remove(beam);
			};
		};
	} while (transmitted.size() != 0);
};

List(Shortwave_beam)&	Shortwave_smear::room_response(List(Shortwave_beam)& incident,
						 Room& the_room)
{
	DEBUG	<< "List(Shortwave_beam)&	Shortwave_smear::room_response(List(Shortwave_beam)& incident,\n";
	DEBUG	<< "		 Room& the_room)\n";
/* process those shortwave beams entering this room, and return
** those leaving
*/

/* NB incident means entering room - ie leaving the surface */

	List(Shortwave_beam)	pending;	// beams still to be processed
	List(Shortwave_beam)	retransmitted;	// to collect distributed beams
					// get beams to be processed
	List_iterator(Shortwave_beam) beam_iter(&incident);
	List_iterator(Surface)& surf_iter = the_room.surface_iterator();
	Shortwave_beam*	beam;
	Surface*	surf;
	while (beam = beam_iter(FORWARD)) {
					// check if for this room
		surf_iter(RESET);
		while (surf = surf_iter(FORWARD)) 
			if (beam->surface() == surf) {
				pending.append(beam);
				incident.remove(beam);
			};
	};
/* take first beam from pending list and distribute to appropriate other surfaces.
** add significant reflections to the pending list.  delete processed beam from
** pending list and repeat until list is empty
 */
	List_iterator(Shortwave_beam)	pending_iter(&pending);
	while (beam = pending_iter(FORWARD))
					// ignore weak beams
	    if (beam->irradiance()->direct() + beam->irradiance()->diffuse()
						 > tolerance_value) {
/* for every other surface in the room, calculate the direct & diffuse
 * radiation from this beam falling on it.
 */
					// smear energy evenly over other surfaces
		Shortwave_beam*	d_beam;		// incident beam on other surface
		surf_iter(RESET);
		int	ns = surf_iter.size();
		while (surf = surf_iter(FORWARD))
		    if (surf != beam->surface()) {	// ignore self
			Irradiance*	ird = new Irradiance(
					       beam->irradiance()->direct()/ns,
					       beam->irradiance()->diffuse()/ns,
					       beam->irradiance()->orientation(),
					       beam->irradiance()->sun_position());
			d_beam = new Shortwave_beam(ird, surf);
					// reflect distributed beam off surface,
					//    add reflected beam to pending list
			pending += surf->shortwave_response(d_beam);
		    };
					// remove processed beam from list
		pending.remove(beam);
	    };
					// return re-transmitted beams
	return retransmitted;
};

List(Shortwave_beam)&	Shortwave_smear::surface_response(Shortwave_beam& incident,
						    Surface& the_surface)
{
	DEBUG1	<< "List(Shortwave_beam)&	Shortwave_smear::surface_response(Shortwave_beam& incident,\n";
	DEBUG1	<< "			Surface& the_surface)\n";

	List(Shortwave_beam)	beams;
	cerr << "Shortwave_smear::surface_response() :  not implemented\n";

	return	beams;
};
