#ifndef RADIATION_FD_1_H
#define RADIATION_FD_1_H

#include	"theory/Radiation.h"
#include	"theory/Radiation_fd_1_def.h"
class	Surface;
typedef	float	ViewFactor;
//???class	ViewFactor;

extern Type*	Radiation_fd_1_Type_pointer;

class Radiation_fd_1 : public Radiation {
protected:
float	Radiation_fd_1::heat_transfer_coeff(Surface* surf_1,Surface* surf_2,
                                            ViewFactor view_factor);
public:
	Radiation_fd_1(Metaclass* meta, Radiation_fd_1_def* def);
	Radiation_fd_1(Radiation& c);
	Radiation_fd_1(APL* theAPL);
	~Radiation_fd_1();

	Type*	getDirectType();

	Radiation_fd_1& operator=(Radiation_fd_1& c);

virtual void		add_coupling(Equation_iterator  surf1_eqn_iter,
				     State_variable*  surf1,
				     Equation_iterator	region2_eqn_iter,
				     State_variable*  node_in_region2,
				     EKSObject*  data_supplier);
virtual	void		inject_energy(Equation_iterator  surf_eqn_iter,
				      State_variable*  node_in_surf,
				      Energy  gain);
};


inline
Type*	Radiation_fd_1::getDirectType()
{
	return TYPE_OF(Radiation_fd_1);
};
#endif
