#ifndef CONVECTION_FD_H
#define CONVECTION_FD_H

#include	"theory/Convection.h"
#include	"theory/Convection_fd_1_def.h"
class	AirVolume;
class	Surface;

extern Type*	Convection_fd_1_Type_pointer;

/*
** Lumped parameter air volume state equation.
*/

class Convection_fd_1 : public Convection {
protected:
	virtual float	heat_transfer_coeff(AirVolume* airvol, Surface* surface);
public:
	Convection_fd_1(Metaclass* meta, Convection_fd_1_def* def);
	Convection_fd_1(Convection_fd_1& c);
	Convection_fd_1(APL* theAPL);
	~Convection_fd_1();

	Type*	getDirectType();

	Convection_fd_1& operator=(Convection_fd_1& c);

virtual Equation_set	generate_equations(State_vector* state_vector,
					   EKSObject*  layer,
					   Equation_iterator  layer_eqn_iter);
virtual	Equation_set	combine_equations(Equation_iterator  layer1_eqn_iter,
					  State_variable*  layer1_surface_node,
					  Equation_iterator  layer2_eqn_iter,
					  State_variable*  layer2_surface_node,
					  EKSObject*  data_supplier);
virtual	void		add_coupling(Equation_iterator  layer1_eqn_iter,
				     State_variable*  node_in_layer1,
				     Equation_iterator  region2_eqn_iter,
				     State_variable*  node_in_region2,
				     EKSObject*  data_supplier);
virtual	void		inject_energy(Equation_iterator  layer_eqn_iter,
				      State_variable*  node_in_layer,
				      Energy  gain);
};


inline
Type*	Convection_fd_1::getDirectType()
{
	return TYPE_OF(Convection_fd_1);
};
#endif
