#include	"theory/Convection_fd_1.h"

#include	"dimensions/Area.h"
#include	"dimensions/Volume.h"
#include	"dimensions/SpecificHeatCapacity.h"
#include	"dimensions/ThermalResistance.h"
#include	"transport/Polygon.h"
#include	"transport/Equation.h"
#include	"transport/Equation_set.h"
#include	"transport/State_vector.h"
#include	"building/Building_es.h"
#include	"building/Room_es.h"
#include	"building/Surface.h"
#include	"building/AirVolume.h"

Type*	Convection_fd_1_Type_pointer;
static	char*	class_name = "the_convection(fd_1)";


Convection_fd_1::Convection_fd_1(Metaclass* meta, Convection_fd_1_def* def)
                                : (meta, (Convection_def*) def)
{
	DEBUG << "Convection_fd_1::Convection_fd_1(Metaclass* meta, Convection_fd_1_def* def)\n";

	name(class_name);
	directType(TYPE_OF(Convection_fd_1));
};

Convection_fd_1::Convection_fd_1(Convection_fd_1& c) : ((Convection&)c)
{
	DEBUG << "Convection_fd_1::Convection_fd_1(Convection_fd_1& c)\n";

	name(class_name);
	directType(TYPE_OF(Convection_fd_1));
}

Convection_fd_1::Convection_fd_1(APL* theAPL) : Convection(theAPL)
{};

Convection_fd_1::~Convection_fd_1()
{
	DEBUG << "Convection_fd_1::~Convection_fd_1()\n";
}


float	Convection_fd_1::heat_transfer_coeff(AirVolume* airvol, Surface* surface)
{
	DEBUG1	<< "float Convection_fd_1::heat_transfer_coef(AirVolume* airvol, Surface* surface)"\n;

        // This function returns the convective heat transfer coefficient
        // which is recommented by CIBSE or ASHRAE.
        return 8.0;
};



Convection_fd_1& Convection_fd_1::operator=(Convection_fd_1& c)
{
        DEBUG1 << "Convection_fd_1& Convection_fd_1::operator=(Convection_fd_1& c)\n";

        return *this;
};


/*
** Lumped parameter air volume state equation.
*/
Equation_set   Convection_fd_1::generate_equations( State_vector* state_vector,
                                                EKSObject*  airvol,
						Equation_iterator  airvol_eqn_iter)
{
        DEBUG1 << "Equation_set*   Convection_fd_1::generate_equations(State_vector* state_vector,\n";
        DEBUG1 << "         EKSObject*  airvol, Equation_iterator  airvol_eqn_iter)\n";

/*==============================================================================
Inputs:
        state_vector - State_vector of air-volume.
        airvol - object.
        airvol_eqn_iter - object's old eqns.
What the function does:
        1. calculate the air capacity.
        2. create an air equation with only one sefl-coupling coefficient.
        3. set coefficient, gain, resistance to 0.
        4. store capacity.
        5. encapsulate equation into equation_set and return.
Note:
==============================================================================*/

					// Create equation set for generated eqns
        Equation_set   eqn_set;

					// Get the required data from airvol.
	AirVolume* 	air_vol = (AirVolume*)airvol;
        SpecificHeatCapacity capacity = air_vol->volume() *
					air_vol->substance().density() *
					air_vol->substance().specificHeatCapacity();
        ThermalResistance resist(0);

				// Generate the first (only) air equation.
        float	self_coupling_coeff = 0;
        Energy	gain(0);
        
        Equation*	eqn = new Equation((*state_vector)[0], ENERGY,
					    self_coupling_coeff, gain,
					    resist, capacity);

        eqn_set.append(eqn);

					// delete old equations
	if (airvol_eqn_iter.size() != 0) {
		airvol_eqn_iter(RESET);
		while (eqn = airvol_eqn_iter(FORWARD))
			delete eqn;
	};

        return eqn_set;
};

Equation_set Convection_fd_1::combine_equations(Equation_iterator airvol1_eqn_iter,
					       State_variable* node_in_airvol1,
					       Equation_iterator  airvol2_eqn_iter,
					       State_variable* node_in_airvol2,
					       EKSObject*  data_supplier)
{
	
	DEBUG1 << "Equation_set* Conduction_fd_1::combine_equations(Equation_iterator  airvol1_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  node_in_airvol1, Equation_iterator  airvol2_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  node_in_airvol2, EKSObject*  data_supplier)\n";

					// get 1st equation
	Equation*	eqn1;
	airvol1_eqn_iter(RESET);
	while (eqn1 = airvol1_eqn_iter(FORWARD))
		if (node_in_airvol1 == eqn1->state_variable())
			break;
	if (eqn1 = NULLPTR(Equation)) {
		cerr << "Conduction::combine equations(): eqn for sv1 not found";
		exit(1);
	};
					// get 2nd equation
	Equation*	eqn2;
	airvol2_eqn_iter(RESET);
	while (eqn2 = airvol2_eqn_iter(FORWARD))
		if (node_in_airvol2 == eqn2->state_variable())
			break;
	if (eqn2 = NULLPTR(Equation)) {
		cerr << "Conduction::combine equations(): eqn for sv2 not found";
		exit(1);
	};

	AirVolume* 	airvol1 = (AirVolume*)node_in_airvol1->owner();
	AirVolume* 	airvol2 = (AirVolume*)node_in_airvol2->owner();
	MassFlowRate*	flow_rate = ((Building_es*)data_supplier)->
					massFlowRate_between(airvol1, airvol2);
					// update self coupling coefficients
					// add new coupling coefficients
					// concatenate equation sets and return
	Equation_set	eqn_set;
	eqn_set = airvol1_eqn_iter;
	eqn_set += airvol2_eqn_iter;

	return eqn_set;
};

/*
** Create convective heat transfer couplings between the air
** and the surfaces in the room.
*/
void    Convection_fd_1::add_coupling(Equation_iterator  airvol_eqn_iter,
				      State_variable*  node_in_airvol,
				      Equation_iterator  region2_eqn_iter,
				      State_variable*  node_in_region2,
				      EKSObject*  data_supplier)
{
	DEBUG1 << "void Conduction_fd_1::add_coupling(Equation_iterator  airvol_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  node_in_airvol, Equation_iterator  region2_eqn_iter,\n";
	DEBUG1 << "	  State_variable*  node_in_region2, EKSObject*  data_supplier)\n";

/*==============================================================================
Inputs:
        airvol_eqns		- equation_set of AirVolume.
        region2_eqns		- equation_set of Surface.
	data_supplier		- Surface (gives area & inclination)
What the function does:
        1. collect all the data.
        2. calculate the new coefficient.
        3. find the self coupling coefficient and get the value.
        4. modify the self coupling coefficient. c=c+new_value.
        5. create a cross coupling coefficient and add to the list in Equation.
 
==============================================================================*/

					// Get the equations to be coupled.
	Equation*	air_eqn;
        air_eqn = airvol_eqn_iter[0];
//					NB Assumed only 1 air equation, otherwise
//	airvol_eqn_iter(RESET)
//	while (eqn1 = airvol_eqn_iter(FORWARD))
//		if (node_in_airvol == eqn1->state_variable())
//			break;
//	if (eqn1 = NULLPTR(Equation)) {
//		cerr << "Convection::add_coupling(): eqn for air sv not found";
//		exit(1);
//	};

	Equation*	surface_eqn;
	region2_eqn_iter(RESET);
	while (surface_eqn = region2_eqn_iter(FORWARD))
		if (node_in_region2 == surface_eqn->state_variable())
			break;
	if (surface_eqn == NULLPTR(Equation)) {
		cerr << "Convection::add_coupling(): eqn for surface sv not found";
		exit(1);
	};

	AirVolume* 	airvol = (AirVolume*)node_in_airvol->owner();
        Surface*	surface = ((Room_es*)data_supplier)->
						surface_for(node_in_region2);
        SpecificHeatCapacity	air_capacity = air_eqn->capacity();
        SpecificHeatCapacity	surface_capacity = surface_eqn->capacity();
        ThermalResistance	surface_resistance = surface_eqn->resistance();
	Area			surface_area = surface->polygon()->area();

				// calculate heat transfer coeff
	float	htf = heat_transfer_coeff(airvol, surface);

       				 // Modify air equation.
        float	new_coeff = (surface_area
				  / ( surface_resistance/2 + 1/htf)
				  / air_capacity)
						.value();	// ditch type info
        float	old_coeff = air_eqn->coefficient_value(node_in_airvol);
        float	modified_coeff = old_coeff - new_coeff;
        air_eqn->change_coefficient(node_in_airvol, modified_coeff);
        air_eqn->append_coefficient(node_in_region2, new_coeff, TEMPERATURE);

        // For surface equation.
        new_coeff = (1 / (surface_resistance/2 + 1/htf) / surface_capacity)
						.value();	// ditch type info
	old_coeff = surface_eqn->coefficient_value(node_in_region2);
        modified_coeff = old_coeff - new_coeff;
        surface_eqn->change_coefficient(node_in_region2, modified_coeff);
        surface_eqn->append_coefficient(node_in_airvol, new_coeff, TEMPERATURE);
};

void    Convection_fd_1::inject_energy(Equation_iterator  airvol_eqn_iter,
				       State_variable*  node_in_airvol,
				       Energy  gain)
{
	DEBUG1	<< "void   Convection_fd_1::inject_energy(Equation_iterator  airvol_eqn_iter,"\n;
	DEBUG1	<< "		     State_variable*  node_in_airvol,"\n;
	DEBUG1	<< "		     Energy  gain)"\n;

					// Get the equation to be modified.
	Equation*	air_eqn;
        air_eqn = airvol_eqn_iter[0];
//					NB Assumed only 1 air equation, otherwise
//	airvol1_eqn_iter(RESET)
//	while (eqn1 = airvol1_eqn_iter(FORWARD))
//		if (airvol1_surface_node == eqn1->state_variable())
//			break;
//	if (eqn1 = NULLPTR(Equation)) {
//		cerr << "Convection::ad_coupling(): eqn for air sv not found";
//		exit(1);
//	};

        air_eqn->add_gain(gain);
};
