#ifndef CONDUCTION_FD_H
#define CONDUCTION_FD_H

#include	"theory/Conduction.h"
#include	"theory/Conduction_fd_def.h"

extern Type*	Conduction_fd_Type_pointer;

/*
** A model of one dimensional conduction based on a finite
** difference approximation of the space derivative.
*/

class Conduction_fd : public Conduction {
public:
	Conduction_fd(Metaclass* meta, Conduction_fd_def* def);
	Conduction_fd(Conduction_fd& c);
	Conduction_fd(APL* theAPL);
	~Conduction_fd();

	Type*	getDirectType();

	Conduction_fd& operator=(Conduction_fd& c);

virtual Equation_set	generate_equations(State_vector* state_vector,
					   EKSObject*  layer,
					   Equation_iterator  layer_eqn_iter);
virtual	Equation_set	combine_equations(Equation_iterator  layer1_eqn_iter,
					  State_variable*  layer1_surface_node,
					  Equation_iterator  layer2_eqn_iter,
					  State_variable*  layer2_surface_node,
					  EKSObject*  data_supplier);
//	void		add_coupling(Equation_iterator  layer1_eqn_iter,
//				     State_variable*  node_in_layer1,
//				     Equation_iterator  region2_eqn_iter,
//				     State_variable*  node_in_region2,
//				     EKSObject*  data_supplier);
virtual	void		inject_energy(Equation_iterator  layer_eqn_iter,
				      State_variable*  node_in_layer,
				      Energy  gain);
};


inline
Type*	Conduction_fd::getDirectType()
{
	return TYPE_OF(Conduction_fd);
};
#endif
