#include	"Lu_factorise.h"

#include	<string.h>
#include	"Equation_set.h"
#include	"Matrix.h"
#include	"State_vector.h"


static	char*	class_name = "the_lu_factorise_solver";
/**/static	char*	class_type = "Lu_factorise";


Lu_factorise::Lu_factorise(Metaclass* meta, Solver_def* def)
				: Solver(meta, def)
{
	DEBUG	<< "Lu_factorise::Lu_factorise(Metaclass* meta, Solver_def* def)\n";

	name(class_name);
/**/	my_type = class_type;
};

Lu_factorise::~Lu_factorise()
{
	DEBUG << "Lu_factorise::~Lu_factorise()\n";
};

//** This function solves linear simltaneous equations by L-U decomposition
//** method.
Vector&	Lu_factorise::execute(Equation_iterator eqn_iter)
{
	DEBUG1	<< "State_vector*  Lu_factorise::execute(iterator eqn_iter)\n";

	int n = eqn_iter.size();
	Matrix	a(n,n,0);
	Vector&	b = *new Vector(n,0);
	Vector st = Vector(n,0);

  	register int i=0, j=0, k=0;
	eqn_iter(RESET);
	Equation*	eq;
	while (eq = eqn_iter(FORWARD)) {
					// ?should check eqn type
		i = eq->state_variable()->id();
		b[i] = eq->gain().value();
		st[i] = eq->state_variable()->state_variable();
		List_iterator(Coefficient) coeff_iter = eq->coeff_iterator();
		Coefficient* coeff;
		while(coeff = coeff_iter(FORWARD)) {
					// ?should check coeff type
			j = coeff->state_variable()->id();
			a[i][j] = coeff->value();
		};
	};

// start time discretisation: temporalily force time step = 1 hour.
	time_discretise(a, b, st, n, 3600);

//start solution.
	int 		flag;    
	register int	v1, v2, v3;

	if(a[0][0] == 0) {
    		flag = 1; 
		exit (0);
  	}
  	for(i=1; i<n; a[0][i] /= a[0][0], i++);

  	for(i=1; i<n; i++) {
    		for(j=i; j<n; j++)
      			for(k=1; k<=i; k++)
				a[j][i] -= a[j][k-1] * a[k-1][i];
    		v1 = i + 1;
    		for(j=v1; j<n; j++) {
      			for(k=1; k<=i; k++)
				a[i][j] -= a[i][k-1] * a[k-1][j];
      			a[i][j] /= a[i][i];
    		}
  	}

  	b[0] /= a[0][0];

  	for(j=1; j<n; j++) {
    		for(k=1; k<=j; k++)
			b[j] -= a[j][k-1] * b[k-1];
    		b[j] /= a[j][j];
  	}

  	for(j=1; j<n; j++) {
    		v2 = n - j;
    		for(k=v2; k<n; k++) {
      			v3 = n - j - 1;
			b[v3] -= a[v3][k] * b[k];
		}
  	}
  	flag = 0;
					// return new state_vector.

	DEBUG2	<< "solved matrix\nLu_factorise::result=\n";
	DEBUG2	<< "New right vector: " << b << "\n";
	return b;
};
