#include	"Gauss_seidle.h"

#include	<string.h>
#include	"Equation_set.h"
#include	"Matrix.h"
#include	"State_vector.h"

static	char*	class_name = "the_Gauss_seidle_solver";
/**/static	char*	class_type = "Gauss_seidle";


Gauss_seidle::Gauss_seidle(Metaclass* meta, Solver_def* def)
				: Solver(meta, def)
{
	DEBUG	<< "Gauss_seidle::Lu_factorise(Metaclass* meta, Solver_def* def)\n";

	name(class_name);
/**/	my_type = class_type;
};

Gauss_seidle::~Gauss_seidle()
{
	DEBUG << "Gauss_seidle::~Gauss_seidle()\n";
};

//** This function solves the linear simultaneous matrix equation by  
//** Gauss-Seidle iterative method.
Vector&	Gauss_seidle::execute(Equation_iterator eqn_iter)
{
	DEBUG1	<< "State_vector*  Gauss_seidle::execute(iterator eqn_iter)\n";

	int n = eqn_iter.size();
	Matrix	a(n,n,0);
	Vector&	b = *new Vector(n,0);
	Vector st = Vector(n,0);

  	register int i=0, j=0, k=0;
	eqn_iter(RESET);
	Equation*	eq;
	while (eq = eqn_iter(FORWARD)) {
					// ?should check eqn type
		i = eq->state_variable()->id();
		b[i] = eq->gain().value();
		st[i] = eq->state_variable()->state_variable();
		List_iterator(Coefficient) coeff_iter = eq->coeff_iterator();
		Coefficient* coeff;
		while(coeff = coeff_iter(FORWARD)) {
					// ?should check coeff type
			j = coeff->state_variable()->id();
			a[i][j] = coeff->value();
		};
	};

// start time discretisation: temporalily force time step = 1 hour.
	time_discretise(a, b, st, n, 3600);

  	float	errBound=1e-6, s;
	int	iter_limit=100;
  	int	flag;

	Vector c = Vector(n, 1.0);

  	for(i=0; i<iter_limit; i++) {
    		flag = 0;
    		for(j=0; j<n; j++) {
      			s = b[j] + c[j];
      			for(k=0; k<n; k++)
				s -= a[j][k] * c[k];
			if(fabs(c[j]-s)>(fabs(s)+1)*errBound) flag = 1;
      			c[j] = s;
    		}
    		if(flag==0) break;
  	}

	if(flag==1)	cout << "Solution failed.\n";
	else		cout << "Solution convergent.\n";

	return b=c;
};
