#include	"site/Sky_basic_def.h"

#include	"infrastructure/Metaclass.h"
#include	"site/Sky_temperature_def.h"
#include	"site/Sky_irradiance_def.h"

Type*	Sky_basic_def_Type_pointer;
static	char*	class_name = "the_sky_basic_def";


Sky_basic_def::Sky_basic_def(Metaclass* meta)  : Sky_def(meta)
{
	DEBUG	<< "Sky_basic_def::Sky_basic_def()\n";

	name(class_name);
	directType(TYPE_OF(Sky_basic_def));

	the_sky_irradiance = meta->make_def_for("Sky_irradiance");
	the_sky_temperature = meta->make_def_for("Sky_temperature");
};

Sky_basic_def::Sky_basic_def(Sky_irradiance_def* irrad, Sky_temperature_def* temp)  : Sky_def()
{
	DEBUG	<< "Sky_basic_def::Sky_basic_def(Sky_irradiance_def*, Sky_temperature_def*)\n";

	name(class_name);
	directType(TYPE_OF(Sky_basic_def));

	the_sky_irradiance = irrad;
	the_sky_temperature = temp;
};

Sky_basic_def::Sky_basic_def(APL* theAPL) : Sky_def(theAPL)
{};

Sky_basic_def::~Sky_basic_def()
{
	DEBUG	<< "Sky_basic_def::~Sky_basic_def()\n";
};


Sky_irradiance_def*	Sky_basic_def::sky_irradiance_def()
{
	DEBUG1	<< "Sky_basic_def::sky_irradiance_def()\n";

	return (Sky_irradiance_def*)the_sky_irradiance;
};

Sky_temperature_def*	Sky_basic_def::sky_temperature_def()
{
	DEBUG1	<< "Sky_basic_def::sky_temperature_def()\n";

	return (Sky_temperature_def*)the_sky_temperature;
};


void	Sky_basic_def::description(Metaclass* meta, ostream& s)
{
	s << "Sky_basic\n";
};
