#ifndef SKY_BASIC_H
#define SKY_BASIC_H

#include	"site/Sky.h"
#include	"site/Sky_basic_def.h"
class	Sky_irradiance;
class	Sky_temperature;
class	Irradiance;
class	Temperature;
class	Sun_position;
class	Orientation;
class	Time_of_day;
class	ClimateRecord;

extern	Type*	Sky_basic_Type_pointer;


class Sky_basic : public Sky {
protected:
	Sky_irradiance*		the_sky_irradiance_theory;   // or derivative
	Sky_temperature*	the_sky_temperature_theory;   // or derivative
public:
	Sky_basic(Metaclass* meta, Sky_basic_def* def);
	Sky_basic(Sky_basic& s);				// Shallow copy.
	Sky_basic(APL* theAPL);
	~Sky_basic();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Sky_basic& operator=(Sky_basic& s); 			// Shallow copy.

	Sky_irradiance*		sky_irradiance();
	Sky_temperature*	sky_temperature();

	virtual	Irradiance irradiance(Irradiance& augmented_irradiance,
		Sun_position& a_sun_pos,
		Orientation& a_surface_orientation,
		Time_of_day& a_time_of_day);
	virtual	Temperature temperature(ClimateRecord& a_clm_rec,
		Sun_position& a_sun_pos,
		Time_of_day& a_time_of_day);
};


inline
Type*	Sky_basic::getDirectType()
{
	return TYPE_OF(Sky_basic);
};

inline
Sky_irradiance*	Sky_basic::sky_irradiance()
{					// cast guaranteed by Metaclass
	return (Sky_irradiance*)the_sky_irradiance_theory;
};

inline
Sky_temperature*	Sky_basic::sky_temperature()
{					// cast guaranteed by Metaclass
	return (Sky_temperature*)the_sky_temperature_theory;
};

#endif
